import{s as mN,o as cN,n as k}from"../chunks/scheduler.9bc65507.js";import{S as fN,i as gN,g as i,s as n,r as p,A as pN,h as l,f as d,c as a,j as y,u as h,x as f,k as w,y as r,a as F,v as u,d as _,t as b,w as v}from"../chunks/index.707bf1b6.js";import{T as Sw}from"../chunks/Tip.c2ecdbf4.js";import{D as x}from"../chunks/Docstring.17db21ae.js";import{C as L}from"../chunks/CodeBlock.54a9f38d.js";import{E as $}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as B}from"../chunks/Heading.342b1fa6.js";function hN(C){let t,T=`If your <code>NewModelConfig</code> is a subclass of <a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, make sure its
<code>model_type</code> attribute is set to the same key you use when registering the config (here <code>&quot;new-model&quot;</code>).`,m,s,c=`Likewise, if your <code>NewModel</code> is a subclass of <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, make sure its
<code>config_class</code> attribute is set to the same class you use when registering the model (here
<code>NewModelConfig</code>).`;return{c(){t=i("p"),t.innerHTML=T,m=n(),s=i("p"),s.innerHTML=c},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1nu8gdb"&&(t.innerHTML=T),m=a(e),s=l(e,"P",{"data-svelte-h":!0}),f(s)!=="svelte-dw8ewn"&&(s.innerHTML=c)},m(e,M){F(e,t,M),F(e,m,M),F(e,s,M)},p:k,d(e){e&&(d(t),d(m),d(s))}}}function uN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMCh1c2VyLXVwbG9hZGVkKSUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRibWR6JTJGYmVydC1iYXNlLWdlcm1hbi1jYXNlZCUyMiklMEElMEElMjMlMjBJZiUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlJTIwaXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyQyUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRmJlcnRfc2F2ZWRfbW9kZWwlMkYlMjIpJTBBJTBBJTIzJTIwTG9hZCUyMGElMjBzcGVjaWZpYyUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGYmVydF9zYXZlZF9tb2RlbCUyRm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEElMEElMjMlMjBDaGFuZ2UlMjBzb21lJTIwY29uZmlnJTIwYXR0cmlidXRlcyUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMHByZXRyYWluZWQlMjBjb25maWcuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSUyQyUyMGZvbyUzREZhbHNlKSUwQWNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQWNvbmZpZyUyQyUyMHVudXNlZF9rd2FyZ3MlMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTJDJTIwZm9vJTNERmFsc2UlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBdW51c2VkX2t3YXJncw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If configuration file is in a directory (e.g., was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a specific configuration file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Change some config attributes when loading a pretrained config.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config, unused_kwargs = AutoConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function _N(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBEb3dubG9hZCUyMHZvY2FidWxhcnklMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwdm9jYWJ1bGFyeSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMCh1c2VyLXVwbG9hZGVkKSUyMGFuZCUyMGNhY2hlLiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRibWR6JTJGYmVydC1iYXNlLWdlcm1hbi1jYXNlZCUyMiklMEElMEElMjMlMjBJZiUyMHZvY2FidWxhcnklMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwdG9rZW5pemVyJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSopJTBBJTIzJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZiZXJ0X3NhdmVkX21vZGVsJTJGJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwdm9jYWJ1bGFyeSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGRlZmluZSUyMG1vZGVsLXNwZWNpZmljJTIwYXJndW1lbnRzJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyRmFjZWJvb2tBSSUyRnJvYmVydGEtYmFzZSUyMiUyQyUyMGFkZF9wcmVmaXhfc3BhY2UlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If vocabulary files are in a directory (e.g. tokenizer was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tokenizer = AutoTokenizer.from_pretrained(&quot;./test/bert_saved_model/&quot;)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and define model-specific arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/roberta-base&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function bN(C){let t,T="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){t=i("p"),t.innerHTML=T},l(m){t=l(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-15auxyb"&&(t.innerHTML=T)},m(m,s){F(m,t,s)},p:k,d(m){m&&d(t)}}}function vN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBJTBBJTIzJTIwSWYlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMGZlYXR1cmUlMjBleHRyYWN0b3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download feature extractor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If feature extractor files are in a directory (e.g. feature extractor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feature_extractor = AutoFeatureExtractor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function MN(C){let t,T="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){t=i("p"),t.innerHTML=T},l(m){t=l(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-15auxyb"&&(t.innerHTML=T)},m(m,s){F(m,t,s)},p:k,d(m){m&&d(t)}}}function FN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQSUyMyUyMERvd25sb2FkJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyKSUwQSUwQSUyMyUyMElmJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download image processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If image processor files are in a directory (e.g. image processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># image_processor = AutoImageProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function TN(C){let t,T="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){t=i("p"),t.innerHTML=T},l(m){t=l(m,"P",{"data-svelte-h":!0}),f(t)!=="svelte-15auxyb"&&(t.innerHTML=T)},m(m,s){F(m,t,s)},p:k,d(m){m&&d(t)}}}function CN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEElMjMlMjBEb3dubG9hZCUyMHByb2Nlc3NvciUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUyMyUyMElmJTIwcHJvY2Vzc29yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMHByb2Nlc3NvciUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKSUwQSUyMyUyMHByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If processor files are in a directory (e.g. processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># processor = AutoProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function yN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function wN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function xN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function kN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function LN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function $N(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function BN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function jN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function ZN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function AN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function RN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function WN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function SN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function GN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function VN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function PN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function JN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function EN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function IN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function UN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function NN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function XN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function qN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function DN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function QN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function HN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwVEYlMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBQeVRvcmNoJTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0Zl9tb2RlbCUyRnQ1X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZ0NV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/t5_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/t5_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function YN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function zN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGdDVfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function ON(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function KN(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0NV9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function e5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function o5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function r5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function t5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function n5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function a5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function s5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function i5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function l5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function d5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function m5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function c5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function f5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function g5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function p5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function h5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function u5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function _5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function b5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function v5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function M5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function F5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function T5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function C5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function y5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function w5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function x5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function k5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function L5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function $5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function B5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function j5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function Z5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function A5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function R5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function W5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function S5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function G5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function V5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function P5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function J5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function E5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function I5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function U5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function N5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function X5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function q5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function D5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function Q5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function H5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function Y5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function z5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function O5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW5zdGFuY2VTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function K5(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function eX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function oX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function rX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function tX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function nX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function aX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function sX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function iX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function lX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function dX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function mX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function cX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function fX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function gX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function pX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function hX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function uX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function _X(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function bX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function vX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function MX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function FX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function TX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function CX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function yX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function wX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ0YXBhc190Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnRhcGFzX3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/tapas_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/tapas_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function xX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function kX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRnRhcGFzX3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0YXBhc19weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/tapas_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/tapas_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function LX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyaW1waXJhJTJGbGF5b3V0bG0tZG9jdW1lbnQtcWElMjIlMkMlMjByZXZpc2lvbiUzRCUyMjUyZTAxYjMlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function $X(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI1MmUwMWIzJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGbGF5b3V0bG1fdGZfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZsYXlvdXRsbV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/layoutlm_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/layoutlm_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function BX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function jX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZsYXlvdXRsbV9wdF9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGbGF5b3V0bG1fcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/layoutlm_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/layoutlm_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function ZX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRhbmRlbGluJTJGdmlsdC1iMzItZmluZXR1bmVkLXZxYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc3VhbFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function AX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ2aWx0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzdWFsUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnZpbHRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/vilt_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/vilt_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function RX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function WX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function SX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function GX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function VX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function PX(C){let t,T="Examples:",m,s,c;return s=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){t=i("p"),t.textContent=T,m=n(),p(s.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=T),m=a(e),h(s.$$.fragment,e)},m(e,M){F(e,t,M),F(e,m,M),u(s,e,M),c=!0},p:k,i(e){c||(_(s.$$.fragment,e),c=!0)},o(e){b(s.$$.fragment,e),c=!1},d(e){e&&(d(t),d(m)),v(s,e)}}}function JX(C){let t,T,m,s,c,e,M,ES=`In many cases, the architecture you want to use can be guessed from the name or the path of the pretrained model you
are supplying to the <code>from_pretrained()</code> method. AutoClasses are here to do this job for you so that you
automatically retrieve the relevant model given the name/path to the pretrained weights/config/vocabulary.`,kC,Cd,IS=`Instantiating one of <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>, <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoModel">AutoModel</a>, and
<a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a> will directly create a class of the relevant architecture. For instance`,LC,yd,$C,wd,US='will create a model that is an instance of <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertModel">BertModel</a>.',BC,xd,NS="There is one class of <code>AutoModel</code> for each task, and for each backend (PyTorch, TensorFlow, or Flax).",jC,kd,ZC,Ld,XS=`Each of the auto classes has a method to be extended with your custom classes. For instance, if you have defined a
custom class of model <code>NewModel</code>, make sure you have a <code>NewModelConfig</code> then you can add those to the auto
classes like this:`,AC,$d,RC,Bd,qS="You will then be able to use the auto classes like you would usually do!",WC,Cs,SC,jd,GC,me,Zd,Gw,ph,DS=`This is a generic configuration class that will be instantiated as one of the configuration classes of the library
when created with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoConfig.from_pretrained">from_pretrained()</a> class method.`,Vw,hh,QS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Pw,Io,Ad,Jw,uh,HS="Instantiate one of the configuration classes of the library from a pretrained model configuration.",Ew,_h,YS=`The configuration class to instantiate is selected based on the <code>model_type</code> property of the config object that
is loaded, or when it’s missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Iw,bh,zS='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/align#transformers.AlignConfig">AlignConfig</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bark#transformers.BarkConfig">BarkConfig</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitConfig">BitConfig</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bros#transformers.BrosConfig">BrosConfig</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineConfig">CanineConfig</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> (Chinese-CLIP model)</li> <li><strong>chinese_clip_vision_model</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionConfig">ChineseCLIPVisionConfig</a> (ChineseCLIPVisionModel model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clap#transformers.ClapConfig">ClapConfig</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> (CodeGen model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> (DeiT model)</li> <li><strong>depth_anything</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/depth_anything#transformers.DepthAnythingConfig">DepthAnythingConfig</a> (Depth Anything model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deta#transformers.DetaConfig">DetaConfig</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dinov2#transformers.Dinov2Config">Dinov2Config</a> (DINOv2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a> (DonutSwin model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> (DPR model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTConfig">DPTConfig</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a> (EfficientNet model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> (ELECTRA model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encodec#transformers.EncodecConfig">EncodecConfig</a> (EnCodec model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encoder-decoder#transformers.EncoderDecoderConfig">EncoderDecoderConfig</a> (Encoder decoder model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> (FNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/focalnet#transformers.FocalNetConfig">FocalNetConfig</a> (FocalNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> (Funnel Transformer model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a> (Fuyu model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitConfig">GitConfig</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/graphormer#transformers.GraphormerConfig">GraphormerConfig</a> (Graphormer model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a> (ImageGPT model)</li> <li><strong>informer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/informer#transformers.InformerConfig">InformerConfig</a> (Informer model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/instructblip#transformers.InstructBlipConfig">InstructBlipConfig</a> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2Config">LayoutLMv2Config</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> (LED model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitConfig">LevitConfig</a> (LeViT model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a> (LLaMA model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> (LLaVa model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/m2m_100#transformers.M2M100Config">M2M100Config</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> (Marian model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a> (MarkupLM model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinConfig</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> (mBART model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a> (M-CTC-T model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mgp-str#transformers.MgpstrConfig">MgpstrConfig</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1Config">MobileNetV1Config</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2Config">MobileNetV2Config</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevitv2#transformers.MobileViTV2Config">MobileViTV2Config</a> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraConfig">MraConfig</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> (MT5 model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (MusicGen model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> (MVP model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nat#transformers.NatConfig">NatConfig</a> (NAT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> (NLLB-MOE model)</li> <li><strong>nougat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a> (Nougat model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a> (OneFormer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTConfig">OwlViTConfig</a> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/patchtsmixer#transformers.PatchTSMixerConfig">PatchTSMixerConfig</a> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a> (PatchTST model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> (Phi model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pix2struct#transformers.Pix2StructConfig">Pix2StructConfig</a> (Pix2Struct model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> (PLBart model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerConfig">PoolFormerConfig</a> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pop2piano#transformers.Pop2PianoConfig">Pop2PianoConfig</a> (Pop2Piano model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> (ProphetNet model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pvt#transformers.PvtConfig">PvtConfig</a> (PVT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> (Qwen2 model)</li> <li><strong>rag</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rag#transformers.RagConfig">RagConfig</a> (RAG model)</li> <li><strong>realm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a> (REALM model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> (Reformer model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> (ResNet model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> (RWKV model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamConfig">SamConfig</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TConfig">SeamlessM4TConfig</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew#transformers.SEWConfig">SEWConfig</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a> (SiglipVisionModel model)</li> <li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderConfig">SpeechEncoderDecoderConfig</a> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Config">SpeechT5Config</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a> (StableLm model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swiftformer#transformers.SwiftFormerConfig">SwiftFormerConfig</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swinv2#transformers.Swinv2Config">Swinv2Config</a> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> (T5 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a> (Table Transformer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerConfig">TimeSeriesTransformerConfig</a> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <a href="/docs/transformers/v4.38.1/en/main_classes/backbones#transformers.TimmBackboneConfig">TimmBackboneConfig</a> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerConfig">TrajectoryTransformerConfig</a> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> (Transformer-XL model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a> (TrOCR model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> (TVP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5Config">UMT5Config</a> (UMT5 model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a> (UnivNet model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/upernet#transformers.UperNetConfig">UperNetConfig</a> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/van#transformers.VanConfig">VanConfig</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltConfig">ViltConfig</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vipllava#transformers.VipLlavaConfig">VipLlavaConfig</a> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a> (Vision Encoder decoder model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> (VisualBERT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_hybrid#transformers.ViTHybridConfig">ViTHybridConfig</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_msn#transformers.ViTMSNConfig">ViTMSNConfig</a> (ViTMSN model)</li> <li><strong>vitdet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vitdet#transformers.VitDetConfig">VitDetConfig</a> (VitDet model)</li> <li><strong>vitmatte</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vitmatte#transformers.VitMatteConfig">VitMatteConfig</a> (ViTMatte model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vits#transformers.VitsConfig">VitsConfig</a> (VITS model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a> (ViViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertConfig">Wav2Vec2BertConfig</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMConfig">WavLMConfig</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xclip#transformers.XCLIPConfig">XCLIPConfig</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> (X-MOD model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a> (YOLOS model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> (YOSO model)</li>',Uw,ys,Nw,ws,Rd,Xw,vh,OS="Register a new configuration for this class.",VC,Wd,PC,ce,Sd,qw,Mh,KS=`This is a generic tokenizer class that will be instantiated as one of the tokenizer classes of the library when
created with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer.from_pretrained">AutoTokenizer.from_pretrained()</a> class method.`,Dw,Fh,eG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Qw,Uo,Gd,Hw,Th,oG="Instantiate one of the tokenizer classes of the library from a pretrained model vocabulary.",Yw,Ch,rG=`The tokenizer class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,zw,yh,tG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ALIGN model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartTokenizer">BartTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartTokenizerFast">BartTokenizerFast</a> (BART model)</li> <li><strong>barthez</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/barthez#transformers.BarthezTokenizer">BarthezTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/barthez#transformers.BarthezTokenizerFast">BarthezTokenizerFast</a> (BARThez model)</li> <li><strong>bartpho</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bartpho#transformers.BartphoTokenizer">BartphoTokenizer</a> (BARTpho model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationTokenizer">BertGenerationTokenizer</a> (Bert Generation model)</li> <li><strong>bert-japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert-japanese#transformers.BertJapaneseTokenizer">BertJapaneseTokenizer</a> (BertJapanese model)</li> <li><strong>bertweet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bertweet#transformers.BertweetTokenizer">BertweetTokenizer</a> (BERTweet model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdTokenizer">BigBirdTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdTokenizerFast">BigBirdTokenizerFast</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptTokenizer">BioGptTokenizer</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotTokenizer">BlenderbotTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotTokenizerFast">BlenderbotTokenizerFast</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallTokenizer">BlenderbotSmallTokenizer</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomTokenizerFast">BloomTokenizerFast</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BROS model)</li> <li><strong>byt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/byt5#transformers.ByT5Tokenizer">ByT5Tokenizer</a> (ByT5 model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertTokenizer">CamembertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertTokenizerFast">CamembertTokenizerFast</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineTokenizer">CanineTokenizer</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpTokenizer">ClvpTokenizer</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/code_llama#transformers.CodeLlamaTokenizer">CodeLlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/code_llama#transformers.CodeLlamaTokenizerFast">CodeLlamaTokenizerFast</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (CodeGen model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertTokenizer">ConvBertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertTokenizerFast">ConvBertTokenizerFast</a> (ConvBERT model)</li> <li><strong>cpm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cpm#transformers.CpmTokenizer">CpmTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/cpm#transformers.CpmTokenizerFast">CpmTokenizerFast</a> (CPM model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntTokenizer">CpmAntTokenizer</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLTokenizer">CTRLTokenizer</a> (CTRL model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaTokenizer">DebertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaTokenizerFast">DebertaTokenizerFast</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Tokenizer">DebertaV2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2TokenizerFast">DebertaV2TokenizerFast</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertTokenizer">DistilBertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertTokenizerFast">DistilBertTokenizerFast</a> (DistilBERT model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRQuestionEncoderTokenizer">DPRQuestionEncoderTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRQuestionEncoderTokenizerFast">DPRQuestionEncoderTokenizerFast</a> (DPR model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraTokenizer">ElectraTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraTokenizerFast">ElectraTokenizerFast</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmTokenizer">EsmTokenizer</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> —  (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertTokenizer">FlaubertTokenizer</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetTokenizer">FNetTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetTokenizerFast">FNetTokenizerFast</a> (FNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTTokenizer">FSMTTokenizer</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelTokenizer">FunnelTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelTokenizerFast">FunnelTokenizerFast</a> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaTokenizer">GemmaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaTokenizerFast">GemmaTokenizerFast</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt-sw3#transformers.GPTSw3Tokenizer">GPTSw3Tokenizer</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseTokenizer">GPTNeoXJapaneseTokenizer</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseTokenizer">GPTSanJapaneseTokenizer</a> (GPTSAN-japanese model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (GroupViT model)</li> <li><strong>herbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/herbert#transformers.HerbertTokenizer">HerbertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/herbert#transformers.HerbertTokenizerFast">HerbertTokenizerFast</a> (HerBERT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (IDEFICS model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/jukebox#transformers.JukeboxTokenizer">JukeboxTokenizer</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMTokenizer">LayoutLMTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMTokenizerFast">LayoutLMTokenizerFast</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2Tokenizer">LayoutLMv2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2TokenizerFast">LayoutLMv2TokenizerFast</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Tokenizer">LayoutLMv3Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> (LayoutLMv3 model)</li> <li><strong>layoutxlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizer">LayoutXLMTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizerFast">LayoutXLMTokenizerFast</a> (LayoutXLM model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDTokenizer">LEDTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDTokenizerFast">LEDTokenizerFast</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Tokenizer">LayoutLMv3Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaMA model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (LLaVa model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerTokenizer">LongformerTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerTokenizerFast">LongformerTokenizerFast</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeTokenizer">LukeTokenizer</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertTokenizer">LxmertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertTokenizerFast">LxmertTokenizerFast</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/m2m_100#transformers.M2M100Tokenizer">M2M100Tokenizer</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianTokenizer">MarianTokenizer</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartTokenizer">MBartTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartTokenizerFast">MBartTokenizerFast</a> (mBART model)</li> <li><strong>mbart50</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBart50Tokenizer">MBart50Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBart50TokenizerFast">MBart50TokenizerFast</a> (mBART-50 model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mgp-str#transformers.MgpstrTokenizer">MgpstrTokenizer</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Mixtral model)</li> <li><strong>mluke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mluke#transformers.MLukeTokenizer">MLukeTokenizer</a> (mLUKE model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertTokenizer">MobileBertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertTokenizerFast">MobileBertTokenizerFast</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetTokenizer">MPNetTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetTokenizerFast">MPNetTokenizerFast</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">MT5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">MT5TokenizerFast</a> (MT5 model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (MusicGen model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpTokenizer">MvpTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpTokenizerFast">MvpTokenizerFast</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Nezha model)</li> <li><strong>nllb</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nllb#transformers.NllbTokenizer">NllbTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/nllb#transformers.NllbTokenizerFast">NllbTokenizerFast</a> (NLLB model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nllb#transformers.NllbTokenizer">NllbTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/nllb#transformers.NllbTokenizerFast">NllbTokenizerFast</a> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OneFormer model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizer">OpenAIGPTTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizerFast">OpenAIGPTTokenizerFast</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer">GPT2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWL-ViT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusTokenizer">PegasusTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusTokenizerFast">PegasusTokenizerFast</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverTokenizer">PerceiverTokenizer</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (Phi model)</li> <li><strong>phobert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/phobert#transformers.PhobertTokenizer">PhobertTokenizer</a> (PhoBERT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (Pix2Struct model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartTokenizer">PLBartTokenizer</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetTokenizer">ProphetNetTokenizer</a> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2Tokenizer">Qwen2Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a> (Qwen2 model)</li> <li><strong>rag</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rag#transformers.RagTokenizer">RagTokenizer</a> (RAG model)</li> <li><strong>realm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/realm#transformers.RealmTokenizer">RealmTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/realm#transformers.RealmTokenizerFast">RealmTokenizerFast</a> (REALM model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerTokenizer">ReformerTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerTokenizerFast">ReformerTokenizerFast</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertTokenizer">RemBertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertTokenizerFast">RemBertTokenizerFast</a> (RemBERT model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertTokenizer">RetriBertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertTokenizerFast">RetriBertTokenizerFast</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaTokenizerFast">RobertaTokenizerFast</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertTokenizer">RoCBertTokenizer</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerTokenizer">RoFormerTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerTokenizerFast">RoFormerTokenizerFast</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (RWKV model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizerFast">SeamlessM4TTokenizerFast</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizerFast">SeamlessM4TTokenizerFast</a> (SeamlessM4Tv2 model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipTokenizer">SiglipTokenizer</a> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextTokenizer">Speech2TextTokenizer</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer">Speech2Text2Tokenizer</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Tokenizer">SpeechT5Tokenizer</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterTokenizerFast">SplinterTokenizerFast</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertTokenizer">SqueezeBertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertTokenizerFast">SqueezeBertTokenizerFast</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a> (StableLm model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasTokenizer">TapasTokenizer</a> (TAPAS model)</li> <li><strong>tapex</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapex#transformers.TapexTokenizer">TapexTokenizer</a> (TAPEX model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLTokenizer">TransfoXLTokenizer</a> (Transformer-XL model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (TVP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.T5TokenizerFast">T5TokenizerFast</a> (UMT5 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (VisualBERT model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vits#transformers.VitsTokenizer">VitsTokenizer</a> (VITS model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a> (Wav2Vec2-Conformer model)</li> <li><strong>wav2vec2_phoneme</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2_phoneme#transformers.Wav2Vec2PhonemeCTCTokenizer">Wav2Vec2PhonemeCTCTokenizer</a> (Wav2Vec2Phoneme model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperTokenizer">WhisperTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperTokenizerFast">WhisperTokenizerFast</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMTokenizer">XGLMTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMTokenizerFast">XGLMTokenizerFast</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMTokenizer">XLMTokenizer</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetTokenizer">XLMProphetNetTokenizer</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetTokenizerFast">XLNetTokenizerFast</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizerFast">XLMRobertaTokenizerFast</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (YOSO model)</li>',Ow,xs,Kw,ks,Vd,e4,wh,nG="Register a new tokenizer in this mapping.",JC,Pd,EC,fe,Jd,o4,xh,aG=`This is a generic feature extractor class that will be instantiated as one of the feature extractor classes of the
library when created with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoFeatureExtractor.from_pretrained">AutoFeatureExtractor.from_pretrained()</a> class method.`,r4,kh,sG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",t4,j,Ed,n4,Lh,iG="Instantiate one of the feature extractor classes of the library from a pretrained model vocabulary.",a4,$h,lG=`The feature extractor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,s4,Bh,dG='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/audio-spectrogram-transformer#transformers.ASTFeatureExtractor">ASTFeatureExtractor</a> (Audio Spectrogram Transformer model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (BEiT model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPFeatureExtractor">ChineseCLIPFeatureExtractor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clap#transformers.ClapFeatureExtractor">ClapFeatureExtractor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpFeatureExtractor">ClvpFeatureExtractor</a> (CLVP model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor">ConditionalDetrFeatureExtractor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ConvNeXT model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Data2VecAudio model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrFeatureExtractor">DeformableDetrFeatureExtractor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTFeatureExtractor">DeiTFeatureExtractor</a> (DeiT model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (DiNAT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/donut#transformers.DonutFeatureExtractor">DonutFeatureExtractor</a> (DonutSwin model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTFeatureExtractor">DPTFeatureExtractor</a> (DPT model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> (EnCodec model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaFeatureExtractor">FlavaFeatureExtractor</a> (FLAVA model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNFeatureExtractor">GLPNFeatureExtractor</a> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Hubert model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor">ImageGPTFeatureExtractor</a> (ImageGPT model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2FeatureExtractor">LayoutLMv2FeatureExtractor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3FeatureExtractor">LayoutLMv3FeatureExtractor</a> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitFeatureExtractor">LevitFeatureExtractor</a> (LeViT model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor">MaskFormerFeatureExtractor</a> (MaskFormer model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTFeatureExtractor">MCTCTFeatureExtractor</a> (M-CTC-T model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1FeatureExtractor">MobileNetV1FeatureExtractor</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2FeatureExtractor">MobileNetV2FeatureExtractor</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor">MobileViTFeatureExtractor</a> (MobileViT model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (NAT model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTFeatureExtractor">OwlViTFeatureExtractor</a> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverFeatureExtractor">PerceiverFeatureExtractor</a> (Perceiver model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor">PoolFormerFeatureExtractor</a> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pop2piano#transformers.Pop2PianoFeatureExtractor">Pop2PianoFeatureExtractor</a> (Pop2Piano model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ResNet model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerFeatureExtractor">SegformerFeatureExtractor</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (SEW-D model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextFeatureExtractor">Speech2TextFeatureExtractor</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5FeatureExtractor">SpeechT5FeatureExtractor</a> (SpeechT5 model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor">VideoMAEFeatureExtractor</a> (TimeSformer model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltFeatureExtractor">TvltFeatureExtractor</a> (TVLT model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/univnet#transformers.UnivNetFeatureExtractor">UnivNetFeatureExtractor</a> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEFeatureExtractor">VideoMAEFeatureExtractor</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltFeatureExtractor">ViltFeatureExtractor</a> (ViLT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> (ViTMSN model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperFeatureExtractor">WhisperFeatureExtractor</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosFeatureExtractor">YolosFeatureExtractor</a> (YOLOS model)</li>',i4,Ls,l4,$s,d4,Bs,Id,m4,jh,mG="Register a new feature extractor for this class.",IC,Ud,UC,ge,Nd,c4,Zh,cG=`This is a generic image processor class that will be instantiated as one of the image processor classes of the
library when created with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoImageProcessor.from_pretrained">AutoImageProcessor.from_pretrained()</a> class method.`,f4,Ah,fG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",g4,Z,Xd,p4,Rh,gG="Instantiate one of the image processor classes of the library from a pretrained model vocabulary.",h4,Wh,pG=`The image processor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,u4,Sh,hG='<li><strong>align</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetImageProcessor">EfficientNetImageProcessor</a> (ALIGN model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (BiT model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bridgetower#transformers.BridgeTowerImageProcessor">BridgeTowerImageProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPImageProcessor">ChineseCLIPImageProcessor</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (CLIPSeg model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrImageProcessor">ConditionalDetrImageProcessor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrImageProcessor">DeformableDetrImageProcessor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTImageProcessor">DeiTImageProcessor</a> (DeiT model)</li> <li><strong>depth_anything</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTImageProcessor">DPTImageProcessor</a> (Depth Anything model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deta#transformers.DetaImageProcessor">DetaImageProcessor</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (DINOv2 model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/donut#transformers.DonutImageProcessor">DonutImageProcessor</a> (DonutSwin model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTImageProcessor">DPTImageProcessor</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerImageProcessor">EfficientFormerImageProcessor</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetImageProcessor">EfficientNetImageProcessor</a> (EfficientNet model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaImageProcessor">FlavaImageProcessor</a> (FLAVA model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (FocalNet model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNImageProcessor">GLPNImageProcessor</a> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GroupViT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTImageProcessor">ImageGPTImageProcessor</a> (ImageGPT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2ImageProcessor">LayoutLMv2ImageProcessor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3ImageProcessor">LayoutLMv3ImageProcessor</a> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitImageProcessor">LevitImageProcessor</a> (LeViT model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (LLaVa model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> (MaskFormer model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (MGP-STR model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1ImageProcessor">MobileNetV1ImageProcessor</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2ImageProcessor">MobileNetV2ImageProcessor</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTImageProcessor">MobileViTImageProcessor</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTImageProcessor">MobileViTImageProcessor</a> (MobileViTV2 model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (NAT model)</li> <li><strong>nougat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nougat#transformers.NougatImageProcessor">NougatImageProcessor</a> (Nougat model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> (OneFormer model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTImageProcessor">OwlViTImageProcessor</a> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverImageProcessor">PerceiverImageProcessor</a> (Perceiver model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pix2struct#transformers.Pix2StructImageProcessor">Pix2StructImageProcessor</a> (Pix2Struct model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerImageProcessor">PoolFormerImageProcessor</a> (PoolFormer model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pvt#transformers.PvtImageProcessor">PvtImageProcessor</a> (PVT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ResNet model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamImageProcessor">SamImageProcessor</a> (SAM model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerImageProcessor">SegformerImageProcessor</a> (SegFormer model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> (SigLIP model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin2sr#transformers.Swin2SRImageProcessor">Swin2SRImageProcessor</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> (TimeSformer model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltImageProcessor">TvltImageProcessor</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvp#transformers.TvpImageProcessor">TvpImageProcessor</a> (TVP model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerImageProcessor">SegformerImageProcessor</a> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltImageProcessor">ViltImageProcessor</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (VipLlava model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_hybrid#transformers.ViTHybridImageProcessor">ViTHybridImageProcessor</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> (ViTMSN model)</li> <li><strong>vitmatte</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vitmatte#transformers.VitMatteImageProcessor">VitMatteImageProcessor</a> (ViTMatte model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> (YOLOS model)</li>',_4,js,b4,Zs,v4,As,qd,M4,Gh,uG="Register a new image processor for this class.",NC,Dd,XC,pe,Qd,F4,Vh,_G=`This is a generic processor class that will be instantiated as one of the processor classes of the library when
created with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoProcessor.from_pretrained">AutoProcessor.from_pretrained()</a> class method.`,T4,Ph,bG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",C4,A,Hd,y4,Jh,vG="Instantiate one of the processor classes of the library from a pretrained model vocabulary.",w4,Eh,MG=`The processor class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible):`,x4,Ih,FG='<li><strong>align</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/align#transformers.AlignProcessor">AlignProcessor</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> (AltCLIP model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bark#transformers.BarkProcessor">BarkProcessor</a> (Bark model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipProcessor">BlipProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2Processor">Blip2Processor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bridgetower#transformers.BridgeTowerProcessor">BridgeTowerProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPProcessor">ChineseCLIPProcessor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clap#transformers.ClapProcessor">ClapProcessor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clipseg#transformers.CLIPSegProcessor">CLIPSegProcessor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpProcessor">ClvpProcessor</a> (CLVP model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaProcessor">FlavaProcessor</a> (FLAVA model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fuyu#transformers.FuyuProcessor">FuyuProcessor</a> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitProcessor">GitProcessor</a> (GIT model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Hubert model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> (IDEFICS model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/instructblip#transformers.InstructBlipProcessor">InstructBlipProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/kosmos-2#transformers.Kosmos2Processor">Kosmos2Processor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2Processor">LayoutLMv2Processor</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Processor">LayoutLMv3Processor</a> (LayoutLMv3 model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> (LLaVa model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMProcessor">MarkupLMProcessor</a> (MarkupLM model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTProcessor">MCTCTProcessor</a> (M-CTC-T model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mgp-str#transformers.MgpstrProcessor">MgpstrProcessor</a> (MGP-STR model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> (OneFormer model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTProcessor">OwlViTProcessor</a> (OWL-ViT model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pix2struct#transformers.Pix2StructProcessor">Pix2StructProcessor</a> (Pix2Struct model)</li> <li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pop2piano#transformers.Pop2PianoProcessor">Pop2PianoProcessor</a> (Pop2Piano model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamProcessor">SamProcessor</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> (SeamlessM4T model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipProcessor">SiglipProcessor</a> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextProcessor">Speech2TextProcessor</a> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text_2#transformers.Speech2Text2Processor">Speech2Text2Processor</a> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Processor">SpeechT5Processor</a> (SpeechT5 model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/trocr#transformers.TrOCRProcessor">TrOCRProcessor</a> (TrOCR model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltProcessor">TvltProcessor</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvp#transformers.TvpProcessor">TvpProcessor</a> (TVP model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (UniSpeechSat model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> (VipLlava model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor">VisionTextDualEncoderProcessor</a> (VisionTextDualEncoder model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperProcessor">WhisperProcessor</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xclip#transformers.XCLIPProcessor">XCLIPProcessor</a> (X-CLIP model)</li>',k4,Rs,L4,Ws,$4,Ss,Yd,B4,Uh,TG="Register a new processor for this class.",qC,zd,DC,Od,CG="The following auto classes are available for instantiating a base model class without a specific head.",QC,Kd,HC,he,em,j4,Nh,yG=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Z4,Xh,wG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",A4,St,om,R4,qh,xG="Instantiates one of the base model classes of the library from a configuration.",W4,Dh,kG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,S4,Gs,G4,R,rm,V4,Qh,LG="Instantiate one of the base model classes of the library from a pretrained model.",P4,Hh,$G=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,J4,Yh,BG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>chinese_clip_vision_model</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionModel">ChineseCLIPVisionModel</a> (ChineseCLIPVisionModel model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaModel">LlamaModel</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dinov2#transformers.Dinov2Model">Dinov2Model</a> (DINOv2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertModel">DistilBertModel</a> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> (DonutSwin model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRQuestionEncoder">DPRQuestionEncoder</a> (DPR model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> (DPT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> (EfficientNet model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraModel">ElectraModel</a> (ELECTRA model)</li> <li><strong>encodec</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a> (EnCodec model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmModel">EsmModel</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertModel">FlaubertModel</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaModel">FlavaModel</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetModel">FNetModel</a> (FNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/focalnet#transformers.FocalNetModel">FocalNetModel</a> (FocalNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTModel">FSMTModel</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelModel">FunnelModel</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelBaseModel">FunnelBaseModel</a> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaModel">GemmaModel</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitModel">GitModel</a> (GIT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoModel">GPTNeoModel</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXModel">GPTNeoXModel</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseModel">GPTNeoXJapaneseModel</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJModel">GPTJModel</a> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/graphormer#transformers.GraphormerModel">GraphormerModel</a> (Graphormer model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.GroupViTModel">GroupViTModel</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> (Hubert model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertModel">IBertModel</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> (ImageGPT model)</li> <li><strong>informer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/informer#transformers.InformerModel">InformerModel</a> (Informer model)</li> <li><strong>jukebox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMModel">LayoutLMModel</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2Model">LayoutLMv2Model</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Model">LayoutLMv3Model</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDModel">LEDModel</a> (LED model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitModel">LevitModel</a> (LeViT model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaModel">LlamaModel</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerModel">LongformerModel</a> (Longformer model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5Model">LongT5Model</a> (LongT5 model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeModel">LukeModel</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertModel">LxmertModel</a> (LXMERT model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/m2m_100#transformers.M2M100Model">M2M100Model</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianModel">MarianModel</a> (Marian model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> (MarkupLM model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartModel">MBartModel</a> (mBART model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> (M-CTC-T model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaModel">MegaModel</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertModel">MegatronBertModel</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mgp-str#transformers.MgpstrForSceneTextRecognition">MgpstrForSceneTextRecognition</a> (MGP-STR model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralModel">MistralModel</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertModel">MobileBertModel</a> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1Model">MobileNetV1Model</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2Model">MobileNetV2Model</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTModel">MobileViTModel</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevitv2#transformers.MobileViTV2Model">MobileViTV2Model</a> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetModel">MPNetModel</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptModel">MptModel</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraModel">MraModel</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpModel">MvpModel</a> (MVP model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nat#transformers.NatModel">NatModel</a> (NAT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaModel">NezhaModel</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeModel">NllbMoeModel</a> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerModel">NystromformerModel</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> (OneFormer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaModel">OpenLlamaModel</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTModel">OPTModel</a> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTModel">OwlViTModel</a> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/patchtsmixer#transformers.PatchTSMixerModel">PatchTSMixerModel</a> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a> (PatchTST model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusModel">PegasusModel</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiModel">PhiModel</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartModel">PLBartModel</a> (PLBart model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerModel">PoolFormerModel</a> (PoolFormer model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetModel">ProphetNetModel</a> (ProphetNet model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pvt#transformers.PvtModel">PvtModel</a> (PVT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertModel">QDQBertModel</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2Model">Qwen2Model</a> (Qwen2 model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> (Reformer model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertModel">RemBertModel</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> (ResNet model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaModel">RobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormModel">RobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertModel">RoCBertModel</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerModel">RoFormerModel</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvModel">RwkvModel</a> (RWKV model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamModel">SamModel</a> (SAM model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TModel">SeamlessM4TModel</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerModel">SegformerModel</a> (SegFormer model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew#transformers.SEWModel">SEWModel</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> (SEW-D model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> (SiglipVisionModel model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Model">SpeechT5Model</a> (SpeechT5 model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a> (StableLm model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swiftformer#transformers.SwiftFormerModel">SwiftFormerModel</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinModel">SwinModel</a> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> (Swin2SR model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Model">T5Model</a> (T5 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> (Table Transformer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerModel">TimeSeriesTransformerModel</a> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <a href="/docs/transformers/v4.38.1/en/main_classes/backbones#transformers.TimmBackbone">TimmBackbone</a> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerModel">TrajectoryTransformerModel</a> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLModel">TransfoXLModel</a> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> (TVLT model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> (TVP model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5Model">UMT5Model</a> (UMT5 model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechModel">UniSpeechModel</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/van#transformers.VanModel">VanModel</a> (VAN model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> (VideoMAE model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltModel">ViltModel</a> (ViLT model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertModel">VisualBertModel</a> (VisualBERT model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTModel">ViTModel</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_hybrid#transformers.ViTHybridModel">ViTHybridModel</a> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEModel">ViTMAEModel</a> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_msn#transformers.ViTMSNModel">ViTMSNModel</a> (ViTMSN model)</li> <li><strong>vitdet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vitdet#transformers.VitDetModel">VitDetModel</a> (VitDet model)</li> <li><strong>vits</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vits#transformers.VitsModel">VitsModel</a> (VITS model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> (ViViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertModel">Wav2Vec2BertModel</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerModel">Wav2Vec2ConformerModel</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMModel">WavLMModel</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperModel">WhisperModel</a> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xclip#transformers.XCLIPModel">XCLIPModel</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMModel">XGLMModel</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMModel">XLMModel</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetModel">XLMProphetNetModel</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaModel">XLMRobertaModel</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLModel">XLMRobertaXLModel</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodModel">XmodModel</a> (X-MOD model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> (YOLOS model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoModel">YosoModel</a> (YOSO model)</li>',E4,zh,jG=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,I4,Vs,YC,tm,zC,ue,nm,U4,Oh,ZG=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,N4,Kh,AG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",X4,Gt,am,q4,eu,RG="Instantiates one of the base model classes of the library from a configuration.",D4,ou,WG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Q4,Ps,H4,No,sm,Y4,ru,SG="Instantiate one of the base model classes of the library from a pretrained model.",z4,tu,GG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,O4,nu,VG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertModel">TFDistilBertModel</a> (DistilBERT model)</li> <li><strong>dpr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.TFDPRQuestionEncoder">TFDPRQuestionEncoder</a> (DPR model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> (EfficientFormer model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraModel">TFElectraModel</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.TFEsmModel">TFEsmModel</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertModel">TFFlaubertModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelModel">TFFunnelModel</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelBaseModel">TFFunnelBaseModel</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.TFGPTJModel">TFGPTJModel</a> (GPT-J model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.TFGroupViTModel">TFGroupViTModel</a> (GroupViT model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> (Hubert model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMModel">TFLayoutLMModel</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3Model">TFLayoutLMv3Model</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.TFLEDModel">TFLEDModel</a> (LED model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerModel">TFLongformerModel</a> (Longformer model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.TFLxmertModel">TFLxmertModel</a> (LXMERT model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.TFMBartModel">TFMBartModel</a> (mBART model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertModel">TFMobileBertModel</a> (MobileBERT model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.TFMobileViTModel">TFMobileViTModel</a> (MobileViT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetModel">TFMPNetModel</a> (MPNet model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a> (MT5 model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.TFPegasusModel">TFPegasusModel</a> (Pegasus model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> (RegNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertModel">TFRemBertModel</a> (RemBERT model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> (ResNet model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaModel">TFRobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormModel">TFRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerModel">TFRoFormerModel</a> (RoFormer model)</li> <li><strong>sam</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> (SAM model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.TFSegformerModel">TFSegformerModel</a> (SegFormer model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.TFSpeech2TextModel">TFSpeech2TextModel</a> (Speech2Text model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> (Swin Transformer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLModel">TFTransfoXLModel</a> (Transformer-XL model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.TFViTModel">TFViTModel</a> (ViT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.TFViTMAEModel">TFViTMAEModel</a> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.TFWhisperModel">TFWhisperModel</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.TFXGLMModel">TFXGLMModel</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMModel">TFXLMModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaModel">TFXLMRobertaModel</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetModel">TFXLNetModel</a> (XLNet model)</li>',K4,Js,OC,im,KC,_e,lm,e3,au,PG=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,o3,su,JG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",r3,Vt,dm,t3,iu,EG="Instantiates one of the base model classes of the library from a configuration.",n3,lu,IG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,a3,Es,s3,Xo,mm,i3,du,UG="Instantiate one of the base model classes of the library from a pretrained model.",l3,mu,NG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,d3,cu,XG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertModel">FlaxDistilBertModel</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraModel">FlaxElectraModel</a> (ELECTRA model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.FlaxGemmaModel">FlaxGemmaModel</a> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.FlaxGPTNeoModel">FlaxGPTNeoModel</a> (GPT Neo model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.FlaxGPTJModel">FlaxGPTJModel</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama#transformers.FlaxLlamaModel">FlaxLlamaModel</a> (LLaMA model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.FlaxLongT5Model">FlaxLongT5Model</a> (LongT5 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.FlaxMarianModel">FlaxMarianModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartModel">FlaxMBartModel</a> (mBART model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.FlaxMistralModel">FlaxMistralModel</a> (Mistral model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.FlaxMT5Model">FlaxMT5Model</a> (MT5 model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.FlaxOPTModel">FlaxOPTModel</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.FlaxPegasusModel">FlaxPegasusModel</a> (Pegasus model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.FlaxRegNetModel">FlaxRegNetModel</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.FlaxResNetModel">FlaxResNetModel</a> (ResNet model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaModel">FlaxRobertaModel</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormModel">FlaxRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerModel">FlaxRoFormerModel</a> (RoFormer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a> (T5 model)</li> <li><strong>vision-text-dual-encoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.FlaxViTModel">FlaxViTModel</a> (ViT model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2Model">FlaxWav2Vec2Model</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.FlaxWhisperModel">FlaxWhisperModel</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.FlaxXGLMModel">FlaxXGLMModel</a> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaModel">FlaxXLMRobertaModel</a> (XLM-RoBERTa model)</li>',m3,Is,ey,cm,oy,fm,qG="The following auto classes are available for instantiating a model with a pretraining head.",ry,gm,ty,be,pm,c3,fu,DG=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,f3,gu,QG="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",g3,Pt,hm,p3,pu,HG="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",h3,hu,YG=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,u3,Us,_3,W,um,b3,uu,zG="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",v3,_u,OG=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,M3,bu,KG='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForPreTraining">ElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> (ERNIE model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>flava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaForPreTraining">FlavaForPreTraining</a> (FLAVA model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForPreTraining">FNetForPreTraining</a> (FNet model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForPreTraining">FunnelForPreTraining</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li> <li><strong>idefics</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> (IDEFICS model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertForPreTraining">LxmertForPreTraining</a> (LXMERT model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForPreTraining">MegatronBertForPreTraining</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForPreTraining">MobileBertForPreTraining</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForPreTraining">NezhaForPreTraining</a> (Nezha model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>retribert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForPreTraining">RoCBertForPreTraining</a> (RoCBert model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> (TVLT model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechForPreTraining">UniSpeechForPreTraining</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> (UniSpeechSat model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> (VideoMAE model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertForPreTraining">VisualBertForPreTraining</a> (VisualBERT model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEForPreTraining">ViTMAEForPreTraining</a> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForPreTraining">Wav2Vec2ConformerForPreTraining</a> (Wav2Vec2-Conformer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>',F3,vu,eV=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,T3,Ns,ny,_m,ay,ve,bm,C3,Mu,oV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,y3,Fu,rV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",w3,Jt,vm,x3,Tu,tV="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",k3,Cu,nV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,L3,Xs,$3,qo,Mm,B3,yu,aV="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",j3,wu,sV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Z3,xu,iV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForPreTraining">TFElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForPreTraining">TFFunnelForPreTraining</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.TFLxmertForPreTraining">TFLxmertForPreTraining</a> (LXMERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForPreTraining">TFMobileBertForPreTraining</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>vit_mae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.TFViTMAEForPreTraining">TFViTMAEForPreTraining</a> (ViTMAE model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>',A3,qs,sy,Fm,iy,Me,Tm,R3,ku,lV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,W3,Lu,dV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",S3,Et,Cm,G3,$u,mV="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",V3,Bu,cV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,P3,Ds,J3,Do,ym,E3,ju,fV="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",I3,Zu,gV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,U3,Au,pV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForPreTraining">FlaxElectraForPreTraining</a> (ELECTRA model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',N3,Qs,ly,wm,dy,xm,hV="The following auto classes are available for the following natural language processing tasks.",my,km,cy,Fe,Lm,X3,Ru,uV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,q3,Wu,_V="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",D3,It,$m,Q3,Su,bV="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",H3,Gu,vV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Y3,Hs,z3,S,Bm,O3,Vu,MV="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",K3,Pu,FV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,ex,Ju,TV='<li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForCausalLM">ElectraForCausalLM</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> (ERNIE model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> (Falcon model)</li> <li><strong>fuyu</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> (Fuyu model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaForCausalLM">GemmaForCausalLM</a> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoForCausalLM">GPTNeoForCausalLM</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXForCausalLM">GPTNeoXForCausalLM</a> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseForCausalLM">GPTNeoXJapaneseForCausalLM</a> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJForCausalLM">GPTJForCausalLM</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (LLaMA model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianForCausalLM">MarianForCausalLM</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForCausalLM">MBartForCausalLM</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForCausalLM">MegatronBertForCausalLM</a> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> (Mixtral model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li> <li><strong>musicgen</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> (MusicGen model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForCausalLM">MvpForCausalLM</a> (MVP model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaForCausalLM">OpenLlamaForCausalLM</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> (OPT model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusForCausalLM">PegasusForCausalLM</a> (Pegasus model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartForCausalLM">PLBartForCausalLM</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetForCausalLM">ProphetNetForCausalLM</a> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertLMHeadModel">QDQBertLMHeadModel</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2ForCausalLM">Qwen2ForCausalLM</a> (Qwen2 model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForCausalLM">RemBertForCausalLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForCausalLM">RobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForCausalLM">RobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForCausalLM">RoCBertForCausalLM</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForCausalLM">RoFormerForCausalLM</a> (RoFormer model)</li> <li><strong>rwkv</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li> <li><strong>speech_to_text_2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a> (Speech2Text2 model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmForCausalLM">StableLmForCausalLM</a> (StableLm model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>trocr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a> (TrOCR model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperForCausalLM">WhisperForCausalLM</a> (Whisper model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMForCausalLM">XGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForCausalLM">XLMProphetNetForCausalLM</a> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForCausalLM">XLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForCausalLM">XLMRobertaXLForCausalLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForCausalLM">XmodForCausalLM</a> (X-MOD model)</li>',ox,Eu,CV=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rx,Ys,fy,jm,gy,Te,Zm,tx,Iu,yV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,nx,Uu,wV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ax,Ut,Am,sx,Nu,xV="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",ix,Xu,kV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lx,zs,dx,Qo,Rm,mx,qu,LV="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",cx,Du,$V=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fx,Qu,BV='<li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.TFGPTJForCausalLM">TFGPTJForCausalLM</a> (GPT-J model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> (OPT model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForCausalLM">TFRemBertForCausalLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForCausalLM">TFRobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForCausalLM">TFRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForCausalLM">TFRoFormerForCausalLM</a> (RoFormer model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.TFXGLMForCausalLM">TFXGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForCausalLM">TFXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>',gx,Os,py,Wm,hy,Ce,Sm,px,Hu,jV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,hx,Yu,ZV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ux,Nt,Gm,_x,zu,AV="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",bx,Ou,RV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,vx,Ks,Mx,Ho,Vm,Fx,Ku,WV="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",Tx,e_,SV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Cx,o_,GV='<li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForCausalLM">FlaxElectraForCausalLM</a> (ELECTRA model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.FlaxGemmaForCausalLM">FlaxGemmaForCausalLM</a> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.FlaxGPTNeoForCausalLM">FlaxGPTNeoForCausalLM</a> (GPT Neo model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.FlaxGPTJForCausalLM">FlaxGPTJForCausalLM</a> (GPT-J model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama#transformers.FlaxLlamaForCausalLM">FlaxLlamaForCausalLM</a> (LLaMA model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.FlaxMistralForCausalLM">FlaxMistralForCausalLM</a> (Mistral model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> (OPT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForCausalLM">FlaxRobertaForCausalLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForCausalLM">FlaxRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>xglm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.FlaxXGLMForCausalLM">FlaxXGLMForCausalLM</a> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForCausalLM">FlaxXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>',yx,ei,uy,Pm,_y,ye,Jm,wx,r_,VV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xx,t_,PV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",kx,Xt,Em,Lx,n_,JV="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",$x,a_,EV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Bx,oi,jx,G,Im,Zx,s_,IV="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",Ax,i_,UV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Rx,l_,NV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForMaskedLM">ElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> (ERNIE model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmForMaskedLM">EsmForMaskedLM</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForMaskedLM">FNetForMaskedLM</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForMaskedLM">FunnelForMaskedLM</a> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForMaskedLM">MegatronBertForMaskedLM</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForMaskedLM">MobileBertForMaskedLM</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForMaskedLM">NezhaForMaskedLM</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerForMaskedLM">NystromformerForMaskedLM</a> (Nyströmformer model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> (Perceiver model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForMaskedLM">QDQBertForMaskedLM</a> (QDQBert model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForMaskedLM">RemBertForMaskedLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForMaskedLM">RoCBertForMaskedLM</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForMaskedLM">RoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoForMaskedLM">YosoForMaskedLM</a> (YOSO model)</li>',Wx,d_,XV=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Sx,ri,by,Um,vy,we,Nm,Gx,m_,qV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Vx,c_,DV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Px,qt,Xm,Jx,f_,QV="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",Ex,g_,HV=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Ix,ti,Ux,Yo,qm,Nx,p_,YV="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",Xx,h_,zV=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,qx,u_,OV='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForMaskedLM">TFBertForMaskedLM</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertForMaskedLM">TFConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.TFDebertaForMaskedLM">TFDebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMaskedLM">TFDebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForMaskedLM">TFElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.TFEsmForMaskedLM">TFEsmForMaskedLM</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForMaskedLM">TFFunnelForMaskedLM</a> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerForMaskedLM">TFLongformerForMaskedLM</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForMaskedLM">TFMobileBertForMaskedLM</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForMaskedLM">TFRemBertForMaskedLM</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForMaskedLM">TFRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',Dx,ni,My,Dm,Fy,xe,Qm,Qx,__,KV=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Hx,b_,eP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Yx,Dt,Hm,zx,v_,oP="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",Ox,M_,rP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Kx,ai,e8,zo,Ym,o8,F_,tP="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",r8,T_,nP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,t8,C_,aP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForMaskedLM">FlaxAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForMaskedLM">FlaxBertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForMaskedLM">FlaxBigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertForMaskedLM">FlaxDistilBertForMaskedLM</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForMaskedLM">FlaxElectraForMaskedLM</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>',n8,si,Ty,zm,Cy,Om,Km,yy,ec,wy,oc,rc,xy,tc,ky,ke,nc,a8,y_,sP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,s8,w_,iP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",i8,Qt,ac,l8,x_,lP="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",d8,k_,dP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,m8,ii,c8,V,sc,f8,L_,mP="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",g8,$_,cP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,p8,B_,fP='<li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForConditionalGeneration">BigBirdPegasusForConditionalGeneration</a> (BigBird-Pegasus model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotForConditionalGeneration">BlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForConditionalGeneration">BlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>fsmt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li> <li><strong>gptsan-japanese</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDForConditionalGeneration">LEDForConditionalGeneration</a> (LED model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5ForConditionalGeneration">LongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>m2m_100</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/m2m_100#transformers.M2M100ForConditionalGeneration">M2M100ForConditionalGeneration</a> (M2M100 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianMTModel">MarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5ForConditionalGeneration">MT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li> <li><strong>nllb-moe</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusForConditionalGeneration">PegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus_x#transformers.PegasusXForConditionalGeneration">PegasusXForConditionalGeneration</a> (PEGASUS-X model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartForConditionalGeneration">PLBartForConditionalGeneration</a> (PLBart model)</li> <li><strong>prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetForConditionalGeneration">ProphetNetForConditionalGeneration</a> (ProphetNet model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TForTextToText">SeamlessM4TForTextToText</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToText">SeamlessM4Tv2ForTextToText</a> (SeamlessM4Tv2 model)</li> <li><strong>switch_transformers</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5ForConditionalGeneration">UMT5ForConditionalGeneration</a> (UMT5 model)</li> <li><strong>xlm-prophetnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForConditionalGeneration">XLMProphetNetForConditionalGeneration</a> (XLM-ProphetNet model)</li>',h8,j_,gP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,u8,li,Ly,ic,$y,Le,lc,_8,Z_,pP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,b8,A_,hP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",v8,Ht,dc,M8,R_,uP="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",F8,W_,_P=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,T8,di,C8,Oo,mc,y8,S_,bP="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",w8,G_,vP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,x8,V_,MP='<li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.TFBlenderbotForConditionalGeneration">TFBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallForConditionalGeneration">TFBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encoder-decoder#transformers.TFEncoderDecoderModel">TFEncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.TFLEDForConditionalGeneration">TFLEDForConditionalGeneration</a> (LED model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.TFMarianMTModel">TFMarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.TFMBartForConditionalGeneration">TFMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.TFMT5ForConditionalGeneration">TFMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.TFPegasusForConditionalGeneration">TFPegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li>',k8,mi,By,cc,jy,$e,fc,L8,P_,FP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,$8,J_,TP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",B8,Yt,gc,j8,E_,CP="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",Z8,I_,yP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,A8,ci,R8,Ko,pc,W8,U_,wP="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",S8,N_,xP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,G8,X_,kP='<li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.FlaxBlenderbotForConditionalGeneration">FlaxBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallForConditionalGeneration">FlaxBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/encoder-decoder#transformers.FlaxEncoderDecoderModel">FlaxEncoderDecoderModel</a> (Encoder decoder model)</li> <li><strong>longt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li> <li><strong>marian</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.FlaxMarianMTModel">FlaxMarianMTModel</a> (Marian model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li> <li><strong>pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.FlaxPegasusForConditionalGeneration">FlaxPegasusForConditionalGeneration</a> (Pegasus model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li>',V8,fi,Zy,hc,Ay,Be,uc,P8,q_,LP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,J8,D_,$P="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",E8,zt,_c,I8,Q_,BP="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",U8,H_,jP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,N8,gi,X8,P,bc,q8,Y_,ZP="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",D8,z_,AP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Q8,O_,RP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForSequenceClassification">AlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForSequenceClassification">BartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForSequenceClassification">BigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForSequenceClassification">BigBirdPegasusForSequenceClassification</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForSequenceClassification">BloomForSequenceClassification</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForSequenceClassification">CamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a> (CANINE model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> (CodeLlama model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertForSequenceClassification">ConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForSequenceClassification">Data2VecTextForSequenceClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForSequenceClassification">DebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForSequenceClassification">DebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForSequenceClassification">DistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForSequenceClassification">ElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForSequenceClassification">ErnieForSequenceClassification</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMForSequenceClassification">ErnieMForSequenceClassification</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmForSequenceClassification">EsmForSequenceClassification</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertForSequenceClassification">FlaubertForSequenceClassification</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForSequenceClassification">FNetForSequenceClassification</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForSequenceClassification">FunnelForSequenceClassification</a> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaForSequenceClassification">GemmaForSequenceClassification</a> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForSequenceClassification">GPTBigCodeForSequenceClassification</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoForSequenceClassification">GPTNeoForSequenceClassification</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXForSequenceClassification">GPTNeoXForSequenceClassification</a> (GPT NeoX model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJForSequenceClassification">GPTJForSequenceClassification</a> (GPT-J model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForSequenceClassification">IBertForSequenceClassification</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForSequenceClassification">LayoutLMForSequenceClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForSequenceClassification">LayoutLMv2ForSequenceClassification</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForSequenceClassification">LayoutLMv3ForSequenceClassification</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDForSequenceClassification">LEDForSequenceClassification</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltForSequenceClassification">LiltForSequenceClassification</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForSequenceClassification">LongformerForSequenceClassification</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForSequenceClassification">LukeForSequenceClassification</a> (LUKE model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMForSequenceClassification">MarkupLMForSequenceClassification</a> (MarkupLM model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForSequenceClassification">MBartForSequenceClassification</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForSequenceClassification">MegaForSequenceClassification</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForSequenceClassification">MegatronBertForSequenceClassification</a> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralForSequenceClassification">MistralForSequenceClassification</a> (Mistral model)</li> <li><strong>mixtral</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralForSequenceClassification">MixtralForSequenceClassification</a> (Mixtral model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForSequenceClassification">MobileBertForSequenceClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForSequenceClassification">MPNetForSequenceClassification</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForSequenceClassification">MraForSequenceClassification</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5ForSequenceClassification">MT5ForSequenceClassification</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForSequenceClassification">MvpForSequenceClassification</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForSequenceClassification">NezhaForSequenceClassification</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerForSequenceClassification">NystromformerForSequenceClassification</a> (Nyströmformer model)</li> <li><strong>open-llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaForSequenceClassification">OpenLlamaForSequenceClassification</a> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> (OpenAI GPT model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTForSequenceClassification">OPTForSequenceClassification</a> (OPT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a> (Perceiver model)</li> <li><strong>persimmon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> (Phi model)</li> <li><strong>plbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartForSequenceClassification">PLBartForSequenceClassification</a> (PLBart model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForSequenceClassification">QDQBertForSequenceClassification</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2ForSequenceClassification">Qwen2ForSequenceClassification</a> (Qwen2 model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerForSequenceClassification">ReformerForSequenceClassification</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForSequenceClassification">RemBertForSequenceClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForSequenceClassification">RobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForSequenceClassification">RobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForSequenceClassification">RoCBertForSequenceClassification</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForSequenceClassification">RoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForSequenceClassification">SqueezeBertForSequenceClassification</a> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a> (StableLm model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5ForSequenceClassification">T5ForSequenceClassification</a> (T5 model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForSequenceClassification">TapasForSequenceClassification</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLForSequenceClassification">TransfoXLForSequenceClassification</a> (Transformer-XL model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5ForSequenceClassification">UMT5ForSequenceClassification</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMForSequenceClassification">XLMForSequenceClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForSequenceClassification">XLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForSequenceClassification">XLMRobertaXLForSequenceClassification</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetForSequenceClassification">XLNetForSequenceClassification</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForSequenceClassification">XmodForSequenceClassification</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoForSequenceClassification">YosoForSequenceClassification</a> (YOSO model)</li>',H8,K_,WP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Y8,pi,Ry,vc,Wy,je,Mc,z8,eb,SP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,O8,ob,GP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",K8,Ot,Fc,ek,rb,VP="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",ok,tb,PP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rk,hi,tk,er,Tc,nk,nb,JP="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",ak,ab,EP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sk,sb,IP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForSequenceClassification">TFAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.TFBartForSequenceClassification">TFBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForSequenceClassification">TFBertForSequenceClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForSequenceClassification">TFCamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertForSequenceClassification">TFConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.TFDebertaForSequenceClassification">TFDebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2ForSequenceClassification">TFDebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForSequenceClassification">TFDistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForSequenceClassification">TFElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.TFEsmForSequenceClassification">TFEsmForSequenceClassification</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertForSequenceClassification">TFFlaubertForSequenceClassification</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForSequenceClassification">TFFunnelForSequenceClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2ForSequenceClassification">TFGPT2ForSequenceClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2ForSequenceClassification">TFGPT2ForSequenceClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.TFGPTJForSequenceClassification">TFGPTJForSequenceClassification</a> (GPT-J model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMForSequenceClassification">TFLayoutLMForSequenceClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForSequenceClassification">TFLayoutLMv3ForSequenceClassification</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerForSequenceClassification">TFLongformerForSequenceClassification</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForSequenceClassification">TFMobileBertForSequenceClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForSequenceClassification">TFMPNetForSequenceClassification</a> (MPNet model)</li> <li><strong>openai-gpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> (OpenAI GPT model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForSequenceClassification">TFRemBertForSequenceClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForSequenceClassification">TFRobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForSequenceClassification">TFRobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForSequenceClassification">TFRoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForSequenceClassification">TFTapasForSequenceClassification</a> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLForSequenceClassification">TFTransfoXLForSequenceClassification</a> (Transformer-XL model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMForSequenceClassification">TFXLMForSequenceClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForSequenceClassification">TFXLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetForSequenceClassification">TFXLNetForSequenceClassification</a> (XLNet model)</li>',ik,ui,Sy,Cc,Gy,Ze,yc,lk,ib,UP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,dk,lb,NP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",mk,Kt,wc,ck,db,XP="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",fk,mb,qP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,gk,_i,pk,or,xc,hk,cb,DP="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",uk,fb,QP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,_k,gb,HP='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForSequenceClassification">FlaxAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForSequenceClassification">FlaxBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForSequenceClassification">FlaxBertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForSequenceClassification">FlaxBigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertForSequenceClassification">FlaxDistilBertForSequenceClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForSequenceClassification">FlaxElectraForSequenceClassification</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartForSequenceClassification">FlaxMBartForSequenceClassification</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForSequenceClassification">FlaxRobertaForSequenceClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForSequenceClassification">FlaxRobertaPreLayerNormForSequenceClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForSequenceClassification">FlaxRoFormerForSequenceClassification</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForSequenceClassification">FlaxXLMRobertaForSequenceClassification</a> (XLM-RoBERTa model)</li>',bk,bi,Vy,kc,Py,Ae,Lc,vk,pb,YP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Mk,hb,zP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Fk,en,$c,Tk,ub,OP="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",Ck,_b,KP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,yk,vi,wk,J,Bc,xk,bb,e0="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",kk,vb,o0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Lk,Mb,r0='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForMultipleChoice">AlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForMultipleChoice">BertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForMultipleChoice">BigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForMultipleChoice">CamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertForMultipleChoice">ConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForMultipleChoice">Data2VecTextForMultipleChoice</a> (Data2VecText model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForMultipleChoice">DebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForMultipleChoice">DistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForMultipleChoice">ElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForMultipleChoice">ErnieForMultipleChoice</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMForMultipleChoice">ErnieMForMultipleChoice</a> (ErnieM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertForMultipleChoice">FlaubertForMultipleChoice</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForMultipleChoice">FNetForMultipleChoice</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForMultipleChoice">FunnelForMultipleChoice</a> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForMultipleChoice">IBertForMultipleChoice</a> (I-BERT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForMultipleChoice">LongformerForMultipleChoice</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForMultipleChoice">LukeForMultipleChoice</a> (LUKE model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForMultipleChoice">MegaForMultipleChoice</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForMultipleChoice">MegatronBertForMultipleChoice</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForMultipleChoice">MobileBertForMultipleChoice</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForMultipleChoice">MPNetForMultipleChoice</a> (MPNet model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForMultipleChoice">MraForMultipleChoice</a> (MRA model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForMultipleChoice">NezhaForMultipleChoice</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerForMultipleChoice">NystromformerForMultipleChoice</a> (Nyströmformer model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForMultipleChoice">QDQBertForMultipleChoice</a> (QDQBert model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForMultipleChoice">RemBertForMultipleChoice</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForMultipleChoice">RobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMultipleChoice">RobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForMultipleChoice">RoCBertForMultipleChoice</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForMultipleChoice">RoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForMultipleChoice">SqueezeBertForMultipleChoice</a> (SqueezeBERT model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMForMultipleChoice">XLMForMultipleChoice</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForMultipleChoice">XLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMultipleChoice">XLMRobertaXLForMultipleChoice</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetForMultipleChoice">XLNetForMultipleChoice</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForMultipleChoice">XmodForMultipleChoice</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoForMultipleChoice">YosoForMultipleChoice</a> (YOSO model)</li>',$k,Fb,t0=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Bk,Mi,Jy,jc,Ey,Re,Zc,jk,Tb,n0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Zk,Cb,a0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Ak,on,Ac,Rk,yb,s0="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",Wk,wb,i0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Sk,Fi,Gk,rr,Rc,Vk,xb,l0="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",Pk,kb,d0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Jk,Lb,m0='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForMultipleChoice">TFAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForMultipleChoice">TFBertForMultipleChoice</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForMultipleChoice">TFCamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertForMultipleChoice">TFConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2ForMultipleChoice">TFDebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForMultipleChoice">TFDistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForMultipleChoice">TFElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertForMultipleChoice">TFFlaubertForMultipleChoice</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForMultipleChoice">TFFunnelForMultipleChoice</a> (Funnel Transformer model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerForMultipleChoice">TFLongformerForMultipleChoice</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForMultipleChoice">TFMobileBertForMultipleChoice</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForMultipleChoice">TFMPNetForMultipleChoice</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForMultipleChoice">TFRemBertForMultipleChoice</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForMultipleChoice">TFRobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMultipleChoice">TFRobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForMultipleChoice">TFRoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMForMultipleChoice">TFXLMForMultipleChoice</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMultipleChoice">TFXLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetForMultipleChoice">TFXLNetForMultipleChoice</a> (XLNet model)</li>',Ek,Ti,Iy,Wc,Uy,We,Sc,Ik,$b,c0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Uk,Bb,f0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Nk,rn,Gc,Xk,jb,g0="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",qk,Zb,p0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Dk,Ci,Qk,tr,Vc,Hk,Ab,h0="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",Yk,Rb,u0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,zk,Wb,_0='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForMultipleChoice">FlaxAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForMultipleChoice">FlaxBertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForMultipleChoice">FlaxBigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertForMultipleChoice">FlaxDistilBertForMultipleChoice</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForMultipleChoice">FlaxElectraForMultipleChoice</a> (ELECTRA model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForMultipleChoice">FlaxRobertaForMultipleChoice</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMultipleChoice">FlaxRobertaPreLayerNormForMultipleChoice</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForMultipleChoice">FlaxRoFormerForMultipleChoice</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMultipleChoice">FlaxXLMRobertaForMultipleChoice</a> (XLM-RoBERTa model)</li>',Ok,yi,Ny,Pc,Xy,Se,Jc,Kk,Sb,b0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eL,Gb,v0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oL,tn,Ec,rL,Vb,M0="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",tL,Pb,F0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,nL,wi,aL,E,Ic,sL,Jb,T0="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",iL,Eb,C0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lL,Ib,y0='<li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForNextSentencePrediction">BertForNextSentencePrediction</a> (BERT model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForNextSentencePrediction">ErnieForNextSentencePrediction</a> (ERNIE model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForNextSentencePrediction">FNetForNextSentencePrediction</a> (FNet model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForNextSentencePrediction">MegatronBertForNextSentencePrediction</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForNextSentencePrediction">MobileBertForNextSentencePrediction</a> (MobileBERT model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForNextSentencePrediction">NezhaForNextSentencePrediction</a> (Nezha model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForNextSentencePrediction">QDQBertForNextSentencePrediction</a> (QDQBert model)</li>',dL,Ub,w0=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,mL,xi,qy,Uc,Dy,Ge,Nc,cL,Nb,x0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fL,Xb,k0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gL,nn,Xc,pL,qb,L0="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",hL,Db,$0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,uL,ki,_L,nr,qc,bL,Qb,B0="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",vL,Hb,j0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,ML,Yb,Z0='<li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForNextSentencePrediction">TFBertForNextSentencePrediction</a> (BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForNextSentencePrediction">TFMobileBertForNextSentencePrediction</a> (MobileBERT model)</li>',FL,Li,Qy,Dc,Hy,Ve,Qc,TL,zb,A0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,CL,Ob,R0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",yL,an,Hc,wL,Kb,W0="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",xL,ev,S0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,kL,$i,LL,ar,Yc,$L,ov,G0="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",BL,rv,V0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,jL,tv,P0='<li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForNextSentencePrediction">FlaxBertForNextSentencePrediction</a> (BERT model)</li>',ZL,Bi,Yy,zc,zy,Pe,Oc,AL,nv,J0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,RL,av,E0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",WL,sn,Kc,SL,sv,I0="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",GL,iv,U0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,VL,ji,PL,I,ef,JL,lv,N0="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",EL,dv,X0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,IL,mv,q0='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForTokenClassification">AlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForTokenClassification">BigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptForTokenClassification">BioGptForTokenClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForTokenClassification">BloomForTokenClassification</a> (BLOOM model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bros#transformers.BrosForTokenClassification">BrosForTokenClassification</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForTokenClassification">CamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineForTokenClassification">CanineForTokenClassification</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertForTokenClassification">ConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForTokenClassification">Data2VecTextForTokenClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForTokenClassification">DebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForTokenClassification">DebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForTokenClassification">DistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForTokenClassification">ElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForTokenClassification">ErnieForTokenClassification</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMForTokenClassification">ErnieMForTokenClassification</a> (ErnieM model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmForTokenClassification">EsmForTokenClassification</a> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconForTokenClassification">FalconForTokenClassification</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertForTokenClassification">FlaubertForTokenClassification</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForTokenClassification">FNetForTokenClassification</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForTokenClassification">FunnelForTokenClassification</a> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2ForTokenClassification">GPT2ForTokenClassification</a> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2ForTokenClassification">GPT2ForTokenClassification</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForTokenClassification">GPTBigCodeForTokenClassification</a> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoForTokenClassification">GPTNeoForTokenClassification</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXForTokenClassification">GPTNeoXForTokenClassification</a> (GPT NeoX model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForTokenClassification">IBertForTokenClassification</a> (I-BERT model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForTokenClassification">LayoutLMForTokenClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForTokenClassification">LayoutLMv2ForTokenClassification</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForTokenClassification">LayoutLMv3ForTokenClassification</a> (LayoutLMv3 model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltForTokenClassification">LiltForTokenClassification</a> (LiLT model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForTokenClassification">LongformerForTokenClassification</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForTokenClassification">LukeForTokenClassification</a> (LUKE model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMForTokenClassification">MarkupLMForTokenClassification</a> (MarkupLM model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForTokenClassification">MegaForTokenClassification</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForTokenClassification">MegatronBertForTokenClassification</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForTokenClassification">MobileBertForTokenClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForTokenClassification">MPNetForTokenClassification</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForTokenClassification">MptForTokenClassification</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForTokenClassification">MraForTokenClassification</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5ForTokenClassification">MT5ForTokenClassification</a> (MT5 model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForTokenClassification">NezhaForTokenClassification</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerForTokenClassification">NystromformerForTokenClassification</a> (Nyströmformer model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiForTokenClassification">PhiForTokenClassification</a> (Phi model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForTokenClassification">QDQBertForTokenClassification</a> (QDQBert model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForTokenClassification">RemBertForTokenClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForTokenClassification">RobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForTokenClassification">RobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForTokenClassification">RoCBertForTokenClassification</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForTokenClassification">RoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForTokenClassification">SqueezeBertForTokenClassification</a> (SqueezeBERT model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5ForTokenClassification">T5ForTokenClassification</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5ForTokenClassification">UMT5ForTokenClassification</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMForTokenClassification">XLMForTokenClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForTokenClassification">XLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForTokenClassification">XLMRobertaXLForTokenClassification</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetForTokenClassification">XLNetForTokenClassification</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForTokenClassification">XmodForTokenClassification</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoForTokenClassification">YosoForTokenClassification</a> (YOSO model)</li>',UL,cv,D0=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,NL,Zi,Oy,of,Ky,Je,rf,XL,fv,Q0=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,qL,gv,H0="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",DL,ln,tf,QL,pv,Y0="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",HL,hv,z0=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,YL,Ai,zL,sr,nf,OL,uv,O0="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",KL,_v,K0=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,e$,bv,eJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForTokenClassification">TFAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForTokenClassification">TFBertForTokenClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForTokenClassification">TFCamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertForTokenClassification">TFConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.TFDebertaForTokenClassification">TFDebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2ForTokenClassification">TFDebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForTokenClassification">TFDistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForTokenClassification">TFElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>esm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.TFEsmForTokenClassification">TFEsmForTokenClassification</a> (ESM model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertForTokenClassification">TFFlaubertForTokenClassification</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForTokenClassification">TFFunnelForTokenClassification</a> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMForTokenClassification">TFLayoutLMForTokenClassification</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForTokenClassification">TFLayoutLMv3ForTokenClassification</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerForTokenClassification">TFLongformerForTokenClassification</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForTokenClassification">TFMobileBertForTokenClassification</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForTokenClassification">TFMPNetForTokenClassification</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForTokenClassification">TFRemBertForTokenClassification</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForTokenClassification">TFRobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForTokenClassification">TFRobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForTokenClassification">TFRoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMForTokenClassification">TFXLMForTokenClassification</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForTokenClassification">TFXLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetForTokenClassification">TFXLNetForTokenClassification</a> (XLNet model)</li>',o$,Ri,e2,af,o2,Ee,sf,r$,vv,oJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,t$,Mv,rJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",n$,dn,lf,a$,Fv,tJ="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",s$,Tv,nJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,i$,Wi,l$,ir,df,d$,Cv,aJ="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",m$,yv,sJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,c$,wv,iJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForTokenClassification">FlaxAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForTokenClassification">FlaxBertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForTokenClassification">FlaxBigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertForTokenClassification">FlaxDistilBertForTokenClassification</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForTokenClassification">FlaxElectraForTokenClassification</a> (ELECTRA model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForTokenClassification">FlaxRobertaForTokenClassification</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForTokenClassification">FlaxRobertaPreLayerNormForTokenClassification</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForTokenClassification">FlaxRoFormerForTokenClassification</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForTokenClassification">FlaxXLMRobertaForTokenClassification</a> (XLM-RoBERTa model)</li>',f$,Si,r2,mf,t2,Ie,cf,g$,xv,lJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,p$,kv,dJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",h$,mn,ff,u$,Lv,mJ="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",_$,$v,cJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,b$,Gi,v$,U,gf,M$,Bv,fJ="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",F$,jv,gJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,T$,Zv,pJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForQuestionAnswering">AlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForQuestionAnswering">BartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForQuestionAnswering">BertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForQuestionAnswering">BigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForQuestionAnswering">BigBirdPegasusForQuestionAnswering</a> (BigBird-Pegasus model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForQuestionAnswering">BloomForQuestionAnswering</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForQuestionAnswering">CamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineForQuestionAnswering">CanineForQuestionAnswering</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertForQuestionAnswering">ConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForQuestionAnswering">Data2VecTextForQuestionAnswering</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForQuestionAnswering">DebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForQuestionAnswering">DebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForQuestionAnswering">DistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForQuestionAnswering">ElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForQuestionAnswering">ErnieForQuestionAnswering</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMForQuestionAnswering">ErnieMForQuestionAnswering</a> (ErnieM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconForQuestionAnswering">FalconForQuestionAnswering</a> (Falcon model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertForQuestionAnsweringSimple">FlaubertForQuestionAnsweringSimple</a> (FlauBERT model)</li> <li><strong>fnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForQuestionAnswering">FNetForQuestionAnswering</a> (FNet model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForQuestionAnswering">FunnelForQuestionAnswering</a> (Funnel Transformer model)</li> <li><strong>gpt2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2ForQuestionAnswering">GPT2ForQuestionAnswering</a> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoForQuestionAnswering">GPTNeoForQuestionAnswering</a> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXForQuestionAnswering">GPTNeoXForQuestionAnswering</a> (GPT NeoX model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJForQuestionAnswering">GPTJForQuestionAnswering</a> (GPT-J model)</li> <li><strong>ibert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForQuestionAnswering">IBertForQuestionAnswering</a> (I-BERT model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForQuestionAnswering">LayoutLMv2ForQuestionAnswering</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForQuestionAnswering">LayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li> <li><strong>led</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDForQuestionAnswering">LEDForQuestionAnswering</a> (LED model)</li> <li><strong>lilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltForQuestionAnswering">LiltForQuestionAnswering</a> (LiLT model)</li> <li><strong>llama</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llama#transformers.LlamaForQuestionAnswering">LlamaForQuestionAnswering</a> (LLaMA model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForQuestionAnswering">LongformerForQuestionAnswering</a> (Longformer model)</li> <li><strong>luke</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForQuestionAnswering">LukeForQuestionAnswering</a> (LUKE model)</li> <li><strong>lxmert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertForQuestionAnswering">LxmertForQuestionAnswering</a> (LXMERT model)</li> <li><strong>markuplm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMForQuestionAnswering">MarkupLMForQuestionAnswering</a> (MarkupLM model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForQuestionAnswering">MBartForQuestionAnswering</a> (mBART model)</li> <li><strong>mega</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForQuestionAnswering">MegaForQuestionAnswering</a> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForQuestionAnswering">MegatronBertForQuestionAnswering</a> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForQuestionAnswering">MobileBertForQuestionAnswering</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForQuestionAnswering">MPNetForQuestionAnswering</a> (MPNet model)</li> <li><strong>mpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForQuestionAnswering">MptForQuestionAnswering</a> (MPT model)</li> <li><strong>mra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForQuestionAnswering">MraForQuestionAnswering</a> (MRA model)</li> <li><strong>mt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5ForQuestionAnswering">MT5ForQuestionAnswering</a> (MT5 model)</li> <li><strong>mvp</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForQuestionAnswering">MvpForQuestionAnswering</a> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForQuestionAnswering">NezhaForQuestionAnswering</a> (Nezha model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerForQuestionAnswering">NystromformerForQuestionAnswering</a> (Nyströmformer model)</li> <li><strong>opt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTForQuestionAnswering">OPTForQuestionAnswering</a> (OPT model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForQuestionAnswering">QDQBertForQuestionAnswering</a> (QDQBert model)</li> <li><strong>reformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerForQuestionAnswering">ReformerForQuestionAnswering</a> (Reformer model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForQuestionAnswering">RemBertForQuestionAnswering</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForQuestionAnswering">RobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForQuestionAnswering">RobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForQuestionAnswering">RoCBertForQuestionAnswering</a> (RoCBert model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForQuestionAnswering">RoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>splinter</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> (Splinter model)</li> <li><strong>squeezebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForQuestionAnswering">SqueezeBertForQuestionAnswering</a> (SqueezeBERT model)</li> <li><strong>t5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5ForQuestionAnswering">T5ForQuestionAnswering</a> (T5 model)</li> <li><strong>umt5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5ForQuestionAnswering">UMT5ForQuestionAnswering</a> (UMT5 model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMForQuestionAnsweringSimple">XLMForQuestionAnsweringSimple</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForQuestionAnswering">XLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForQuestionAnswering">XLMRobertaXLForQuestionAnswering</a> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetForQuestionAnsweringSimple">XLNetForQuestionAnsweringSimple</a> (XLNet model)</li> <li><strong>xmod</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForQuestionAnswering">XmodForQuestionAnswering</a> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoForQuestionAnswering">YosoForQuestionAnswering</a> (YOSO model)</li>',C$,Av,hJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,y$,Vi,n2,pf,a2,Ue,hf,w$,Rv,uJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,x$,Wv,_J="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",k$,cn,uf,L$,Sv,bJ="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",$$,Gv,vJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,B$,Pi,j$,lr,_f,Z$,Vv,MJ="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",A$,Pv,FJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,R$,Jv,TJ='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForQuestionAnswering">TFAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForQuestionAnswering">TFBertForQuestionAnswering</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForQuestionAnswering">TFCamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertForQuestionAnswering">TFConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.TFDebertaForQuestionAnswering">TFDebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2ForQuestionAnswering">TFDebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForQuestionAnswering">TFDistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForQuestionAnswering">TFElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>flaubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertForQuestionAnsweringSimple">TFFlaubertForQuestionAnsweringSimple</a> (FlauBERT model)</li> <li><strong>funnel</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForQuestionAnswering">TFFunnelForQuestionAnswering</a> (Funnel Transformer model)</li> <li><strong>gptj</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.TFGPTJForQuestionAnswering">TFGPTJForQuestionAnswering</a> (GPT-J model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForQuestionAnswering">TFLayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerForQuestionAnswering">TFLongformerForQuestionAnswering</a> (Longformer model)</li> <li><strong>mobilebert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForQuestionAnswering">TFMobileBertForQuestionAnswering</a> (MobileBERT model)</li> <li><strong>mpnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForQuestionAnswering">TFMPNetForQuestionAnswering</a> (MPNet model)</li> <li><strong>rembert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForQuestionAnswering">TFRemBertForQuestionAnswering</a> (RemBERT model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForQuestionAnswering">TFRobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForQuestionAnswering">TFRobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForQuestionAnswering">TFRoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>xlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMForQuestionAnsweringSimple">TFXLMForQuestionAnsweringSimple</a> (XLM model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForQuestionAnswering">TFXLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetForQuestionAnsweringSimple">TFXLNetForQuestionAnsweringSimple</a> (XLNet model)</li>',W$,Ji,s2,bf,i2,Ne,vf,S$,Ev,CJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,G$,Iv,yJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",V$,fn,Mf,P$,Uv,wJ="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",J$,Nv,xJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,E$,Ei,I$,dr,Ff,U$,Xv,kJ="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",N$,qv,LJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,X$,Dv,$J='<li><strong>albert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForQuestionAnswering">FlaxAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForQuestionAnswering">FlaxBartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForQuestionAnswering">FlaxBertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForQuestionAnswering">FlaxBigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>distilbert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertForQuestionAnswering">FlaxDistilBertForQuestionAnswering</a> (DistilBERT model)</li> <li><strong>electra</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForQuestionAnswering">FlaxElectraForQuestionAnswering</a> (ELECTRA model)</li> <li><strong>mbart</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartForQuestionAnswering">FlaxMBartForQuestionAnswering</a> (mBART model)</li> <li><strong>roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForQuestionAnswering">FlaxRobertaForQuestionAnswering</a> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForQuestionAnswering">FlaxRobertaPreLayerNormForQuestionAnswering</a> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForQuestionAnswering">FlaxRoFormerForQuestionAnswering</a> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForQuestionAnswering">FlaxXLMRobertaForQuestionAnswering</a> (XLM-RoBERTa model)</li>',q$,Ii,l2,Tf,d2,Cf,yf,m2,wf,c2,xf,kf,f2,Lf,g2,$f,BJ="The following auto classes are available for the following computer vision tasks.",p2,Bf,h2,Xe,jf,D$,Qv,jJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a depth estimation head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Q$,Hv,ZJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",H$,gn,Zf,Y$,Yv,AJ="Instantiates one of the model classes of the library (with a depth estimation head) from a configuration.",z$,zv,RJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,O$,Ui,K$,N,Af,eB,Ov,WJ="Instantiate one of the model classes of the library (with a depth estimation head) from a pretrained model.",oB,Kv,SJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,rB,eM,GJ='<li><strong>depth_anything</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> (Depth Anything model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> (DPT model)</li> <li><strong>glpn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> (GLPN model)</li>',tB,oM,VJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,nB,Ni,u2,Rf,_2,qe,Wf,aB,rM,PJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,sB,tM,JJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",iB,pn,Sf,lB,nM,EJ="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",dB,aM,IJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,mB,Xi,cB,X,Gf,fB,sM,UJ="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",gB,iM,NJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,pB,lM,XJ='<li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitForImageClassification">BitForImageClassification</a> (BiT model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPForImageClassification">CLIPForImageClassification</a> (CLIP model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextForImageClassification">ConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.ConvNextV2ForImageClassification">ConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.CvtForImageClassification">CvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionForImageClassification">Data2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTForImageClassificationWithTeacher">DeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dinat#transformers.DinatForImageClassification">DinatForImageClassification</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dinov2#transformers.Dinov2ForImageClassification">Dinov2ForImageClassification</a> (DINOv2 model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassification">EfficientFormerForImageClassification</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerForImageClassificationWithTeacher">EfficientFormerForImageClassificationWithTeacher</a> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetForImageClassification">EfficientNetForImageClassification</a> (EfficientNet model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/focalnet#transformers.FocalNetForImageClassification">FocalNetForImageClassification</a> (FocalNet model)</li> <li><strong>imagegpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTForImageClassification">ImageGPTForImageClassification</a> (ImageGPT model)</li> <li><strong>levit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitForImageClassification">LevitForImageClassification</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitForImageClassificationWithTeacher">LevitForImageClassificationWithTeacher</a> (LeViT model)</li> <li><strong>mobilenet_v1</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1ForImageClassification">MobileNetV1ForImageClassification</a> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2ForImageClassification">MobileNetV2ForImageClassification</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTForImageClassification">MobileViTForImageClassification</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevitv2#transformers.MobileViTV2ForImageClassification">MobileViTV2ForImageClassification</a> (MobileViTV2 model)</li> <li><strong>nat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/nat#transformers.NatForImageClassification">NatForImageClassification</a> (NAT model)</li> <li><strong>perceiver</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a> (Perceiver model)</li> <li><strong>poolformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerForImageClassification">PoolFormerForImageClassification</a> (PoolFormer model)</li> <li><strong>pvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pvt#transformers.PvtForImageClassification">PvtForImageClassification</a> (PVT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetForImageClassification">ResNetForImageClassification</a> (ResNet model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerForImageClassification">SegformerForImageClassification</a> (SegFormer model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipForImageClassification">SiglipForImageClassification</a> (SigLIP model)</li> <li><strong>swiftformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swiftformer#transformers.SwiftFormerForImageClassification">SwiftFormerForImageClassification</a> (SwiftFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swinv2#transformers.Swinv2ForImageClassification">Swinv2ForImageClassification</a> (Swin Transformer V2 model)</li> <li><strong>van</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/van#transformers.VanForImageClassification">VanForImageClassification</a> (VAN model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> (ViT model)</li> <li><strong>vit_hybrid</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_hybrid#transformers.ViTHybridForImageClassification">ViTHybridForImageClassification</a> (ViT Hybrid model)</li> <li><strong>vit_msn</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit_msn#transformers.ViTMSNForImageClassification">ViTMSNForImageClassification</a> (ViTMSN model)</li>',hB,dM,qJ=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,uB,qi,b2,Vf,v2,De,Pf,_B,mM,DJ=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,bB,cM,QJ="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",vB,hn,Jf,MB,fM,HJ="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",FB,gM,YJ=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,TB,Di,CB,mr,Ef,yB,pM,zJ="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",wB,hM,OJ=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,xB,uM,KJ='<li><strong>convnext</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.TFConvNextForImageClassification">TFConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.TFConvNextV2ForImageClassification">TFConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.TFCvtForImageClassification">TFCvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.TFData2VecVisionForImageClassification">TFData2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.TFDeiTForImageClassification">TFDeiTForImageClassification</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.TFDeiTForImageClassificationWithTeacher">TFDeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>efficientformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassification">TFEfficientFormerForImageClassification</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.TFEfficientFormerForImageClassificationWithTeacher">TFEfficientFormerForImageClassificationWithTeacher</a> (EfficientFormer model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.TFMobileViTForImageClassification">TFMobileViTForImageClassification</a> (MobileViT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.TFRegNetForImageClassification">TFRegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.TFResNetForImageClassification">TFResNetForImageClassification</a> (ResNet model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.TFSegformerForImageClassification">TFSegformerForImageClassification</a> (SegFormer model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.TFSwinForImageClassification">TFSwinForImageClassification</a> (Swin Transformer model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.TFViTForImageClassification">TFViTForImageClassification</a> (ViT model)</li>',kB,Qi,M2,If,F2,Qe,Uf,LB,_M,eE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,$B,bM,oE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",BB,un,Nf,jB,vM,rE="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",ZB,MM,tE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,AB,Hi,RB,cr,Xf,WB,FM,nE="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",SB,TM,aE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,GB,CM,sE='<li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.FlaxBeitForImageClassification">FlaxBeitForImageClassification</a> (BEiT model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.FlaxRegNetForImageClassification">FlaxRegNetForImageClassification</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.FlaxResNetForImageClassification">FlaxResNetForImageClassification</a> (ResNet model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.FlaxViTForImageClassification">FlaxViTForImageClassification</a> (ViT model)</li>',VB,Yi,T2,qf,C2,He,Df,PB,yM,iE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a video classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,JB,wM,lE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",EB,_n,Qf,IB,xM,dE="Instantiates one of the model classes of the library (with a video classification head) from a configuration.",UB,kM,mE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,NB,zi,XB,q,Hf,qB,LM,cE="Instantiate one of the model classes of the library (with a video classification head) from a pretrained model.",DB,$M,fE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,QB,BM,gE='<li><strong>timesformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/timesformer#transformers.TimesformerForVideoClassification">TimesformerForVideoClassification</a> (TimeSformer model)</li> <li><strong>videomae</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a> (VideoMAE model)</li> <li><strong>vivit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a> (ViViT model)</li>',HB,jM,pE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,YB,Oi,y2,Yf,w2,Ye,zf,zB,ZM,hE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,OB,AM,uE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",KB,bn,Of,ej,RM,_E="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",oj,WM,bE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rj,Ki,tj,D,Kf,nj,SM,vE="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",aj,GM,ME=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sj,VM,FE='<li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTForMaskedImageModeling">DeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/focalnet#transformers.FocalNetForMaskedImageModeling">FocalNetForMaskedImageModeling</a> (FocalNet model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swinv2#transformers.Swinv2ForMaskedImageModeling">Swinv2ForMaskedImageModeling</a> (Swin Transformer V2 model)</li> <li><strong>vit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTForMaskedImageModeling">ViTForMaskedImageModeling</a> (ViT model)</li>',ij,PM,TE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,lj,el,x2,eg,k2,ze,og,dj,JM,CE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,mj,EM,yE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",cj,vn,rg,fj,IM,wE="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",gj,UM,xE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,pj,ol,hj,fr,tg,uj,NM,kE="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",_j,XM,LE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,bj,qM,$E='<li><strong>deit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.TFDeiTForMaskedImageModeling">TFDeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>swin</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.TFSwinForMaskedImageModeling">TFSwinForMaskedImageModeling</a> (Swin Transformer model)</li>',vj,rl,L2,ng,$2,Oe,ag,Mj,DM,BE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a object detection head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Fj,QM,jE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Tj,Mn,sg,Cj,HM,ZE="Instantiates one of the model classes of the library (with a object detection head) from a configuration.",yj,YM,AE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,wj,tl,xj,Q,ig,kj,zM,RE="Instantiate one of the model classes of the library (with a object detection head) from a pretrained model.",Lj,OM,WE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,$j,KM,SE='<li><strong>conditional_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> (Conditional DETR model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> (Deformable DETR model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/deta#transformers.DetaForObjectDetection">DetaForObjectDetection</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> (DETR model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/table-transformer#transformers.TableTransformerForObjectDetection">TableTransformerForObjectDetection</a> (Table Transformer model)</li> <li><strong>yolos</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> (YOLOS model)</li>',Bj,eF,GE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,jj,nl,B2,lg,j2,Ke,dg,Zj,oF,VE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image segmentation head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Aj,rF,PE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Rj,Fn,mg,Wj,tF,JE="Instantiates one of the model classes of the library (with a image segmentation head) from a configuration.",Sj,nF,EE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Gj,al,Vj,H,cg,Pj,aF,IE="Instantiate one of the model classes of the library (with a image segmentation head) from a pretrained model.",Jj,sF,UE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Ej,iF,NE='<li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li>',Ij,lF,XE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Uj,sl,Z2,fg,A2,gg,pg,R2,hg,W2,eo,ug,Nj,dF,qE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Xj,mF,DE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",qj,Tn,_g,Dj,cF,QE="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",Qj,fF,HE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Hj,il,Yj,Y,bg,zj,gF,YE="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",Oj,pF,zE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Kj,hF,OE='<li><strong>beit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> (BEiT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionForSemanticSegmentation">Data2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>dpt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> (DPT model)</li> <li><strong>mobilenet_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2ForSemanticSegmentation">MobileNetV2ForSemanticSegmentation</a> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTForSemanticSegmentation">MobileViTForSemanticSegmentation</a> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevitv2#transformers.MobileViTV2ForSemanticSegmentation">MobileViTV2ForSemanticSegmentation</a> (MobileViTV2 model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerForSemanticSegmentation">SegformerForSemanticSegmentation</a> (SegFormer model)</li> <li><strong>upernet</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/upernet#transformers.UperNetForSemanticSegmentation">UperNetForSemanticSegmentation</a> (UPerNet model)</li>',eZ,uF,KE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,oZ,ll,S2,vg,G2,oo,Mg,rZ,_F,eI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,tZ,bF,oI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",nZ,Cn,Fg,aZ,vF,rI="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",sZ,MF,tI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,iZ,dl,lZ,gr,Tg,dZ,FF,nI="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",mZ,TF,aI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,cZ,CF,sI='<li><strong>data2vec-vision</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.TFData2VecVisionForSemanticSegmentation">TFData2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>mobilevit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.TFMobileViTForSemanticSegmentation">TFMobileViTForSemanticSegmentation</a> (MobileViT model)</li> <li><strong>segformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.TFSegformerForSemanticSegmentation">TFSegformerForSemanticSegmentation</a> (SegFormer model)</li>',fZ,ml,V2,Cg,P2,ro,yg,gZ,yF,iI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a instance segmentation head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,pZ,wF,lI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",hZ,yn,wg,uZ,xF,dI="Instantiates one of the model classes of the library (with a instance segmentation head) from a configuration.",_Z,kF,mI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,bZ,cl,vZ,z,xg,MZ,LF,cI="Instantiate one of the model classes of the library (with a instance segmentation head) from a pretrained model.",FZ,$F,fI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,TZ,BF,gI='<li><strong>maskformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> (MaskFormer model)</li>',CZ,jF,pI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,yZ,fl,J2,kg,E2,to,Lg,wZ,ZF,hI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a universal image segmentation head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xZ,AF,uI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",kZ,wn,$g,LZ,RF,_I="Instantiates one of the model classes of the library (with a universal image segmentation head) from a configuration.",$Z,WF,bI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,BZ,gl,jZ,O,Bg,ZZ,SF,vI="Instantiate one of the model classes of the library (with a universal image segmentation head) from a pretrained model.",AZ,GF,MI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,RZ,VF,FI='<li><strong>detr</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li> <li><strong>mask2former</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> (Mask2Former model)</li> <li><strong>maskformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> (MaskFormer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> (OneFormer model)</li>',WZ,PF,TI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,SZ,pl,I2,jg,U2,no,Zg,GZ,JF,CI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,VZ,EF,yI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",PZ,xn,Ag,JZ,IF,wI="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",EZ,UF,xI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,IZ,hl,UZ,K,Rg,NZ,NF,kI="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",XZ,XF,LI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,qZ,qF,$I='<li><strong>align</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>siglip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li>',DZ,DF,BI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,QZ,ul,N2,Wg,X2,ao,Sg,HZ,QF,jI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,YZ,HF,ZI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",zZ,kn,Gg,OZ,YF,AI="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",KZ,zF,RI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,eA,_l,oA,pr,Vg,rA,OF,WI="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",tA,KF,SI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nA,eT,GI='<li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>',aA,bl,q2,Pg,D2,so,Jg,sA,oT,VI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot object detection head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,iA,rT,PI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",lA,Ln,Eg,dA,tT,JI="Instantiates one of the model classes of the library (with a zero-shot object detection head) from a configuration.",mA,nT,EI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,cA,vl,fA,ee,Ig,gA,aT,II="Instantiate one of the model classes of the library (with a zero-shot object detection head) from a pretrained model.",pA,sT,UI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,hA,iT,NI='<li><strong>owlv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTForObjectDetection">OwlViTForObjectDetection</a> (OWL-ViT model)</li>',uA,lT,XI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,_A,Ml,Q2,Ug,H2,Ng,qI="The following auto classes are available for the following audio tasks.",Y2,Xg,z2,io,qg,bA,dT,DI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,vA,mT,QI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",MA,$n,Dg,FA,cT,HI="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",TA,fT,YI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,CA,Fl,yA,oe,Qg,wA,gT,zI="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",xA,pT,OI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,kA,hT,KI='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/audio-spectrogram-transformer#transformers.ASTForAudioClassification">ASTForAudioClassification</a> (Audio Spectrogram Transformer model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioForSequenceClassification">Data2VecAudioForSequenceClassification</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertForSequenceClassification">HubertForSequenceClassification</a> (Hubert model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew#transformers.SEWForSequenceClassification">SEWForSequenceClassification</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew-d#transformers.SEWDForSequenceClassification">SEWDForSequenceClassification</a> (SEW-D model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechForSequenceClassification">UniSpeechForSequenceClassification</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatForSequenceClassification">UniSpeechSatForSequenceClassification</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForSequenceClassification">Wav2Vec2BertForSequenceClassification</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForSequenceClassification">Wav2Vec2ConformerForSequenceClassification</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMForSequenceClassification">WavLMForSequenceClassification</a> (WavLM model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperForAudioClassification">WhisperForAudioClassification</a> (Whisper model)</li>',LA,uT,eU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,$A,Tl,O2,Hg,K2,lo,Yg,BA,_T,oU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jA,bT,rU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ZA,Bn,zg,AA,vT,tU="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",RA,MT,nU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WA,Cl,SA,hr,Og,GA,FT,aU="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",VA,TT,sU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,PA,CT,iU='<li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.TFWav2Vec2ForSequenceClassification">TFWav2Vec2ForSequenceClassification</a> (Wav2Vec2 model)</li>',JA,yl,ew,Kg,ow,mo,ep,EA,yT,lU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio frame (token) classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,IA,wT,dU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",UA,jn,op,NA,xT,mU="Instantiates one of the model classes of the library (with a audio frame (token) classification head) from a configuration.",XA,kT,cU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,qA,wl,DA,re,rp,QA,LT,fU="Instantiate one of the model classes of the library (with a audio frame (token) classification head) from a pretrained model.",HA,$T,gU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,YA,BT,pU='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioForAudioFrameClassification">Data2VecAudioForAudioFrameClassification</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatForAudioFrameClassification">UniSpeechSatForAudioFrameClassification</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForAudioFrameClassification">Wav2Vec2ForAudioFrameClassification</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForAudioFrameClassification">Wav2Vec2BertForAudioFrameClassification</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForAudioFrameClassification">Wav2Vec2ConformerForAudioFrameClassification</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMForAudioFrameClassification">WavLMForAudioFrameClassification</a> (WavLM model)</li>',zA,jT,hU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,OA,xl,rw,tp,tw,co,np,KA,ZT,uU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a connectionist temporal classification head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eR,AT,_U="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oR,Zn,ap,rR,RT,bU="Instantiates one of the model classes of the library (with a connectionist temporal classification head) from a configuration.",tR,WT,vU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,nR,kl,aR,te,sp,sR,ST,MU="Instantiate one of the model classes of the library (with a connectionist temporal classification head) from a pretrained model.",iR,GT,FU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lR,VT,TU='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioForCTC">Data2VecAudioForCTC</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a> (Hubert model)</li> <li><strong>mctct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTForCTC">MCTCTForCTC</a> (M-CTC-T model)</li> <li><strong>sew</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew#transformers.SEWForCTC">SEWForCTC</a> (SEW model)</li> <li><strong>sew-d</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a> (SEW-D model)</li> <li><strong>unispeech</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechForCTC">UniSpeechForCTC</a> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatForCTC">UniSpeechSatForCTC</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForCTC">Wav2Vec2BertForCTC</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForCTC">Wav2Vec2ConformerForCTC</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMForCTC">WavLMForCTC</a> (WavLM model)</li>',dR,PT,CU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,mR,Ll,nw,ip,aw,fo,lp,cR,JT,yU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fR,ET,wU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gR,An,dp,pR,IT,xU="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",hR,UT,kU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,uR,$l,_R,ne,mp,bR,NT,LU="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",vR,XT,$U=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,MR,qT,BU='<li><strong>pop2piano</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a> (Pop2Piano model)</li> <li><strong>seamless_m4t</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TForSpeechToText">SeamlessM4TForSpeechToText</a> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToText">SeamlessM4Tv2ForSpeechToText</a> (SeamlessM4Tv2 model)</li> <li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech-encoder-decoder#transformers.SpeechEncoderDecoderModel">SpeechEncoderDecoderModel</a> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextForConditionalGeneration">Speech2TextForConditionalGeneration</a> (Speech2Text model)</li> <li><strong>speecht5</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5ForSpeechToText">SpeechT5ForSpeechToText</a> (SpeechT5 model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperForConditionalGeneration">WhisperForConditionalGeneration</a> (Whisper model)</li>',FR,DT,jU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,TR,Bl,sw,cp,iw,go,fp,CR,QT,ZU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,yR,HT,AU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",wR,Rn,gp,xR,YT,RU="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",kR,zT,WU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,LR,jl,$R,ur,pp,BR,OT,SU="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",jR,KT,GU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,ZR,e1,VU='<li><strong>speech_to_text</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.TFSpeech2TextForConditionalGeneration">TFSpeech2TextForConditionalGeneration</a> (Speech2Text model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.TFWhisperForConditionalGeneration">TFWhisperForConditionalGeneration</a> (Whisper model)</li>',AR,Zl,lw,hp,dw,po,up,RR,o1,PU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,WR,r1,JU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",SR,Wn,_p,GR,t1,EU="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",VR,n1,IU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,PR,Al,JR,_r,bp,ER,a1,UU="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",IR,s1,NU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,UR,i1,XU='<li><strong>speech-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/speech-encoder-decoder#transformers.FlaxSpeechEncoderDecoderModel">FlaxSpeechEncoderDecoderModel</a> (Speech Encoder decoder model)</li> <li><strong>whisper</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li>',NR,Rl,mw,vp,cw,ho,Mp,XR,l1,qU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio retrieval via x-vector head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,qR,d1,DU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",DR,Sn,Fp,QR,m1,QU="Instantiates one of the model classes of the library (with a audio retrieval via x-vector head) from a configuration.",HR,c1,HU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,YR,Wl,zR,ae,Tp,OR,f1,YU="Instantiate one of the model classes of the library (with a audio retrieval via x-vector head) from a pretrained model.",KR,g1,zU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,eW,p1,OU='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioForXVector">Data2VecAudioForXVector</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatForXVector">UniSpeechSatForXVector</a> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertForXVector">Wav2Vec2BertForXVector</a> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForXVector">Wav2Vec2ConformerForXVector</a> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMForXVector">WavLMForXVector</a> (WavLM model)</li>',oW,h1,KU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rW,Sl,fw,Cp,gw,yp,wp,pw,xp,hw,kp,Lp,uw,$p,_w,Bp,e9="The following auto classes are available for the following multimodal tasks.",bw,jp,vw,uo,Zp,tW,u1,o9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,nW,_1,r9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",aW,Gn,Ap,sW,b1,t9="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",iW,v1,n9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lW,Gl,dW,se,Rp,mW,M1,a9="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",cW,F1,s9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fW,T1,i9='<li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForQuestionAnswering">TapasForQuestionAnswering</a> (TAPAS model)</li>',gW,C1,l9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,pW,Vl,Mw,Wp,Fw,_o,Sp,hW,y1,d9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,uW,w1,m9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",_W,Vn,Gp,bW,x1,c9="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",vW,k1,f9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,MW,Pl,FW,br,Vp,TW,L1,g9="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",CW,$1,p9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,yW,B1,h9='<li><strong>tapas</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForQuestionAnswering">TFTapasForQuestionAnswering</a> (TAPAS model)</li>',wW,Jl,Tw,Pp,Cw,bo,Jp,xW,j1,u9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,kW,Z1,_9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",LW,Pn,Ep,$W,A1,b9="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",BW,R1,v9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,jW,El,ZW,ie,Ip,AW,W1,M9="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",RW,S1,F9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,WW,G1,T9='<li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForQuestionAnswering">LayoutLMForQuestionAnswering</a> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2ForQuestionAnswering">LayoutLMv2ForQuestionAnswering</a> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3ForQuestionAnswering">LayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li>',SW,V1,C9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,GW,Il,yw,Up,ww,vo,Np,VW,P1,y9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,PW,J1,w9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",JW,Jn,Xp,EW,E1,x9="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",IW,I1,k9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,UW,Ul,NW,vr,qp,XW,U1,L9="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",qW,N1,$9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,DW,X1,B9='<li><strong>layoutlm</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMForQuestionAnswering">TFLayoutLMForQuestionAnswering</a> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3ForQuestionAnswering">TFLayoutLMv3ForQuestionAnswering</a> (LayoutLMv3 model)</li>',QW,Nl,xw,Dp,kw,Mo,Qp,HW,q1,j9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a visual question answering head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,YW,D1,Z9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",zW,En,Hp,OW,Q1,A9="Instantiates one of the model classes of the library (with a visual question answering head) from a configuration.",KW,H1,R9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,eS,Xl,oS,le,Yp,rS,Y1,W9="Instantiate one of the model classes of the library (with a visual question answering head) from a pretrained model.",tS,z1,S9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nS,O1,G9='<li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltForQuestionAnswering">ViltForQuestionAnswering</a> (ViLT model)</li>',aS,K1,V9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,sS,ql,Lw,zp,$w,Fo,Op,iS,eC,P9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,lS,oC,J9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",dS,In,Kp,mS,rC,E9="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",cS,tC,I9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,fS,Dl,gS,de,eh,pS,nC,U9="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",hS,aC,N9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,uS,sC,X9='<li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipForConditionalGeneration">BlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>git</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/instructblip#transformers.InstructBlipForConditionalGeneration">InstructBlipForConditionalGeneration</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/kosmos-2#transformers.Kosmos2ForConditionalGeneration">Kosmos2ForConditionalGeneration</a> (KOSMOS-2 model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li> <li><strong>pix2struct</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/pix2struct#transformers.Pix2StructForConditionalGeneration">Pix2StructForConditionalGeneration</a> (Pix2Struct model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderModel">VisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',_S,iC,q9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,bS,Ql,Bw,oh,jw,To,rh,vS,lC,D9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,MS,dC,Q9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",FS,Un,th,TS,mC,H9="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",CS,cC,Y9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,yS,Hl,wS,Mr,nh,xS,fC,z9="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",kS,gC,O9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,LS,pC,K9='<li><strong>blip</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.TFBlipForConditionalGeneration">TFBlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-encoder-decoder#transformers.TFVisionEncoderDecoderModel">TFVisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',$S,Yl,Zw,ah,Aw,Co,sh,BS,hC,eN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jS,uC,oN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ZS,Nn,ih,AS,_C,rN="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",RS,bC,tN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WS,zl,SS,Fr,lh,GS,vC,nN="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",VS,MC,aN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,PS,FC,sN='<li><strong>vision-encoder-decoder</strong> — <a href="/docs/transformers/v4.38.1/en/model_doc/vision-encoder-decoder#transformers.FlaxVisionEncoderDecoderModel">FlaxVisionEncoderDecoderModel</a> (Vision Encoder decoder model)</li>',JS,Ol,Rw,TC,Ww;return c=new B({props:{title:"Auto Classes",local:"auto-classes",headingTag:"h1"}}),yd=new L({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKQ==",highlighted:'model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)',wrap:!1}}),kd=new B({props:{title:"Extending the Auto Classes",local:"extending-the-auto-classes",headingTag:"h2"}}),$d=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEFBdXRvQ29uZmlnLnJlZ2lzdGVyKCUyMm5ldy1tb2RlbCUyMiUyQyUyME5ld01vZGVsQ29uZmlnKSUwQUF1dG9Nb2RlbC5yZWdpc3RlcihOZXdNb2RlbENvbmZpZyUyQyUyME5ld01vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

AutoConfig.register(<span class="hljs-string">&quot;new-model&quot;</span>, NewModelConfig)
AutoModel.register(NewModelConfig, NewModel)`,wrap:!1}}),Cs=new Sw({props:{warning:!0,$$slots:{default:[hN]},$$scope:{ctx:C}}}),jd=new B({props:{title:"AutoConfig",local:"transformers.AutoConfig",headingTag:"h2"}}),Zd=new x({props:{name:"class transformers.AutoConfig",anchor:"transformers.AutoConfig",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/configuration_auto.py#L987"}}),Ad=new x({props:{name:"from_pretrained",anchor:"transformers.AutoConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>A path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, or the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> method,
e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a saved configuration JSON <em>file</em>, e.g.,
<code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoConfig.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoConfig.from_pretrained.kwargs(additional",description:`<strong>kwargs(additional</strong> keyword arguments, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs(additional"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/configuration_auto.py#L1010"}}),ys=new $({props:{anchor:"transformers.AutoConfig.from_pretrained.example",$$slots:{default:[uN]},$$scope:{ctx:C}}}),Rd=new x({props:{name:"register",anchor:"transformers.AutoConfig.register",parameters:[{name:"model_type",val:""},{name:"config",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoConfig.register.model_type",description:"<strong>model_type</strong> (<code>str</code>) &#x2014; The model type like &#x201C;bert&#x201D; or &#x201C;gpt&#x201D;.",name:"model_type"},{anchor:"transformers.AutoConfig.register.config",description:'<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014; The config to register.',name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/configuration_auto.py#L1149"}}),Wd=new B({props:{title:"AutoTokenizer",local:"transformers.AutoTokenizer",headingTag:"h2"}}),Sd=new x({props:{name:"class transformers.AutoTokenizer",anchor:"transformers.AutoTokenizer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/tokenization_auto.py#L627"}}),Gd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoTokenizer.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoTokenizer.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/v4.38.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a single saved vocabulary file if and only if the tokenizer only requires a
single vocabulary file (like Bert or XLNet), e.g.: <code>./my_model_directory/vocab.txt</code>. (Not
applicable to all derived classes)</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoTokenizer.from_pretrained.inputs",description:`<strong>inputs</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the Tokenizer <code>__init__()</code> method.`,name:"inputs"},{anchor:"transformers.AutoTokenizer.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
The configuration object used to determine the tokenizer class to instantiate.`,name:"config"},{anchor:"transformers.AutoTokenizer.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoTokenizer.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoTokenizer.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoTokenizer.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co (e.g. for
facebook/rag-token-base), specify it here.`,name:"subfolder"},{anchor:"transformers.AutoTokenizer.from_pretrained.use_fast",description:`<strong>use_fast</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Use a <a href="https://huggingface.co/docs/tokenizers/index" rel="nofollow">fast Rust-based tokenizer</a> if it is supported for
a given model. If a fast tokenizer is not available for a given model, a normal Python-based tokenizer
is returned instead.`,name:"use_fast"},{anchor:"transformers.AutoTokenizer.from_pretrained.tokenizer_type",description:`<strong>tokenizer_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Tokenizer type to be loaded.`,name:"tokenizer_type"},{anchor:"transformers.AutoTokenizer.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoTokenizer.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the Tokenizer <code>__init__()</code> method. Can be used to set special tokens like
<code>bos_token</code>, <code>eos_token</code>, <code>unk_token</code>, <code>sep_token</code>, <code>pad_token</code>, <code>cls_token</code>, <code>mask_token</code>,
<code>additional_special_tokens</code>. See parameters in the <code>__init__()</code> for more details.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/tokenization_auto.py#L641"}}),xs=new $({props:{anchor:"transformers.AutoTokenizer.from_pretrained.example",$$slots:{default:[_N]},$$scope:{ctx:C}}}),Vd=new x({props:{name:"register",anchor:"transformers.AutoTokenizer.register",parameters:[{name:"config_class",val:""},{name:"slow_tokenizer_class",val:" = None"},{name:"fast_tokenizer_class",val:" = None"},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoTokenizer.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoTokenizer.register.slow_tokenizer_class",description:`<strong>slow_tokenizer_class</strong> (<code>PretrainedTokenizer</code>, <em>optional</em>) &#x2014;
The slow tokenizer to register.`,name:"slow_tokenizer_class"},{anchor:"transformers.AutoTokenizer.register.fast_tokenizer_class",description:`<strong>fast_tokenizer_class</strong> (<code>PretrainedTokenizerFast</code>, <em>optional</em>) &#x2014;
The fast tokenizer to register.`,name:"fast_tokenizer_class"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/tokenization_auto.py#L858"}}),Pd=new B({props:{title:"AutoFeatureExtractor",local:"transformers.AutoFeatureExtractor",headingTag:"h2"}}),Jd=new x({props:{name:"class transformers.AutoFeatureExtractor",anchor:"transformers.AutoFeatureExtractor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/feature_extraction_auto.py#L238"}}),Ed=new x({props:{name:"from_pretrained",anchor:"transformers.AutoFeatureExtractor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.38.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/feature_extraction_auto.py#L252"}}),Ls=new Sw({props:{$$slots:{default:[bN]},$$scope:{ctx:C}}}),$s=new $({props:{anchor:"transformers.AutoFeatureExtractor.from_pretrained.example",$$slots:{default:[vN]},$$scope:{ctx:C}}}),Id=new x({props:{name:"register",anchor:"transformers.AutoFeatureExtractor.register",parameters:[{name:"config_class",val:""},{name:"feature_extractor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoFeatureExtractor.register.feature_extractor_class",description:"<strong>feature_extractor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The feature extractor to register.",name:"feature_extractor_class"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/feature_extraction_auto.py#L386"}}),Ud=new B({props:{title:"AutoImageProcessor",local:"transformers.AutoImageProcessor",headingTag:"h2"}}),Nd=new x({props:{name:"class transformers.AutoImageProcessor",anchor:"transformers.AutoImageProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/image_processing_auto.py#L251"}}),Xd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoImageProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained image_processor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a image processor file saved using the
<a href="/docs/transformers/v4.38.1/en/main_classes/image_processor#transformers.ImageProcessingMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved image processor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoImageProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model image processor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoImageProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the image processor files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoImageProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoImageProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoImageProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final image processor object. If <code>True</code>, then this
functions returns a <code>Tuple(image_processor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not image processor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>image_processor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoImageProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoImageProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are image processor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> image processor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/image_processing_auto.py#L265"}}),js=new Sw({props:{$$slots:{default:[MN]},$$scope:{ctx:C}}}),Zs=new $({props:{anchor:"transformers.AutoImageProcessor.from_pretrained.example",$$slots:{default:[FN]},$$scope:{ctx:C}}}),qd=new x({props:{name:"register",anchor:"transformers.AutoImageProcessor.register",parameters:[{name:"config_class",val:""},{name:"image_processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoImageProcessor.register.image_processor_class",description:'<strong>image_processor_class</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a>) &#x2014; The image processor to register.',name:"image_processor_class"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/image_processing_auto.py#L421"}}),Dd=new B({props:{title:"AutoProcessor",local:"transformers.AutoProcessor",headingTag:"h2"}}),Qd=new x({props:{name:"class transformers.AutoProcessor",anchor:"transformers.AutoProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/processing_auto.py#L129"}}),Hd=new x({props:{name:"from_pretrained",anchor:"transformers.AutoProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a processor files saved using the <code>save_pretrained()</code> method,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/processing_auto.py#L143"}}),Rs=new Sw({props:{$$slots:{default:[TN]},$$scope:{ctx:C}}}),Ws=new $({props:{anchor:"transformers.AutoProcessor.from_pretrained.example",$$slots:{default:[CN]},$$scope:{ctx:C}}}),Yd=new x({props:{name:"register",anchor:"transformers.AutoProcessor.register",parameters:[{name:"config_class",val:""},{name:"processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoProcessor.register.processor_class",description:"<strong>processor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The processor to register.",name:"processor_class"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/processing_auto.py#L346"}}),zd=new B({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Kd=new B({props:{title:"AutoModel",local:"transformers.AutoModel",headingTag:"h3"}}),em=new x({props:{name:"class transformers.AutoModel",anchor:"transformers.AutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_auto.py#L1318"}}),om=new x({props:{name:"from_config",anchor:"transformers.AutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/align#transformers.AlignConfig">AlignConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bark#transformers.BarkConfig">BarkConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitConfig">BitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bros#transformers.BrosConfig">BrosConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineConfig">CanineConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionConfig">ChineseCLIPVisionConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/chinese_clip#transformers.ChineseCLIPVisionModel">ChineseCLIPVisionModel</a> (ChineseCLIPVisionModel model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clap#transformers.ClapConfig">ClapConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRQuestionEncoder">DPRQuestionEncoder</a> (DPR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTConfig">DPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> (DPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deta#transformers.DetaConfig">DetaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrConfig">DetrConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/dinov2#transformers.Dinov2Config">Dinov2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/dinov2#transformers.Dinov2Model">Dinov2Model</a> (DINOv2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertModel">DistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/donut#transformers.DonutSwinConfig">DonutSwinConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/donut#transformers.DonutSwinModel">DonutSwinModel</a> (DonutSwin model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerModel">EfficientFormerModel</a> (EfficientFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetConfig">EfficientNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/efficientnet#transformers.EfficientNetModel">EfficientNetModel</a> (EfficientNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraModel">ElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/encodec#transformers.EncodecConfig">EncodecConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a> (EnCodec model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieModel">ErnieModel</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> (ErnieM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmModel">EsmModel</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetModel">FNetModel</a> (FNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTModel">FSMTModel</a> (FairSeq Machine-Translation model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> (Falcon model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a> (FastSpeech2Conformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertModel">FlaubertModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaModel">FlavaModel</a> (FLAVA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/focalnet#transformers.FocalNetConfig">FocalNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/focalnet#transformers.FocalNetModel">FocalNetModel</a> (FocalNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelModel">FunnelModel</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelBaseModel">FunnelBaseModel</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> (GLPN model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJModel">GPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoModel">GPTNeoModel</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXModel">GPTNeoXModel</a> (GPT NeoX model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseModel">GPTNeoXJapaneseModel</a> (GPT NeoX Japanese model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaModel">GemmaModel</a> (Gemma model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitConfig">GitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitModel">GitModel</a> (GIT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/graphormer#transformers.GraphormerConfig">GraphormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/graphormer#transformers.GraphormerModel">GraphormerModel</a> (Graphormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.GroupViTModel">GroupViTModel</a> (GroupViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> (Hubert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertModel">IBertModel</a> (I-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> (IDEFICS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTConfig">ImageGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/imagegpt#transformers.ImageGPTModel">ImageGPTModel</a> (ImageGPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/informer#transformers.InformerConfig">InformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/informer#transformers.InformerModel">InformerModel</a> (Informer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a> (Jukebox model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/kosmos-2#transformers.Kosmos2Config">Kosmos2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/kosmos-2#transformers.Kosmos2Model">Kosmos2Model</a> (KOSMOS-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDModel">LEDModel</a> (LED model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMModel">LayoutLMModel</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2Config">LayoutLMv2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv2#transformers.LayoutLMv2Model">LayoutLMv2Model</a> (LayoutLMv2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Model">LayoutLMv3Model</a> (LayoutLMv3 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitConfig">LevitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/levit#transformers.LevitModel">LevitModel</a> (LeViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> (LiLT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaModel">LlamaModel</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5Model">LongT5Model</a> (LongT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerModel">LongformerModel</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeModel">LukeModel</a> (LUKE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertModel">LxmertModel</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/m2m_100#transformers.M2M100Config">M2M100Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/m2m_100#transformers.M2M100Model">M2M100Model</a> (M2M100 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartModel">MBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> (M-CTC-T model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetModel">MPNetModel</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianModel">MarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMConfig">MarkupLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/markuplm#transformers.MarkupLMModel">MarkupLMModel</a> (MarkupLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> (Mask2Former model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> (MaskFormer model)</li>
<li><code>MaskFormerSwinConfig</code> configuration class: <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaModel">MegaModel</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertModel">MegatronBertModel</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mgp-str#transformers.MgpstrConfig">MgpstrConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mgp-str#transformers.MgpstrForSceneTextRecognition">MgpstrForSceneTextRecognition</a> (MGP-STR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralModel">MistralModel</a> (Mistral model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralModel">MixtralModel</a> (Mixtral model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertModel">MobileBertModel</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1Config">MobileNetV1Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v1#transformers.MobileNetV1Model">MobileNetV1Model</a> (MobileNetV1 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2Config">MobileNetV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilenet_v2#transformers.MobileNetV2Model">MobileNetV2Model</a> (MobileNetV2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTModel">MobileViTModel</a> (MobileViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilevitv2#transformers.MobileViTV2Config">MobileViTV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevitv2#transformers.MobileViTV2Model">MobileViTV2Model</a> (MobileViTV2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptModel">MptModel</a> (MPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraModel">MraModel</a> (MRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpModel">MvpModel</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nat#transformers.NatConfig">NatConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nat#transformers.NatModel">NatModel</a> (NAT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaModel">NezhaModel</a> (Nezha model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeModel">NllbMoeModel</a> (NLLB-MOE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerModel">NystromformerModel</a> (Nystr&#xF6;mformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTModel">OPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> (OneFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaModel">OpenLlamaModel</a> (OpenLlama model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTConfig">OwlViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/owlvit#transformers.OwlViTModel">OwlViTModel</a> (OWL-ViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> (OWLv2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartModel">PLBartModel</a> (PLBart model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/patchtsmixer#transformers.PatchTSMixerConfig">PatchTSMixerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/patchtsmixer#transformers.PatchTSMixerModel">PatchTSMixerModel</a> (PatchTSMixer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a> (PatchTST model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusModel">PegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> (PEGASUS-X model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> (Perceiver model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> (Persimmon model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiModel">PhiModel</a> (Phi model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerConfig">PoolFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/poolformer#transformers.PoolFormerModel">PoolFormerModel</a> (PoolFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetModel">ProphetNetModel</a> (ProphetNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/pvt#transformers.PvtConfig">PvtConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/pvt#transformers.PvtModel">PvtModel</a> (PVT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertModel">QDQBertModel</a> (QDQBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2Model">Qwen2Model</a> (Qwen2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerModel">ReformerModel</a> (Reformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertModel">RemBertModel</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetModel">ResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertModel">RoCBertModel</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerModel">RoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaModel">RobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormModel">RobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvModel">RwkvModel</a> (RWKV model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/sew#transformers.SEWConfig">SEWConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/sew#transformers.SEWModel">SEWModel</a> (SEW model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> (SEW-D model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamConfig">SamConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamModel">SamModel</a> (SAM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TConfig">SeamlessM4TConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t#transformers.SeamlessM4TModel">SeamlessM4TModel</a> (SeamlessM4T model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> (SeamlessM4Tv2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerModel">SegformerModel</a> (SegFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> (SigLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> (SiglipVisionModel model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextModel">Speech2TextModel</a> (Speech2Text model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Config">SpeechT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Model">SpeechT5Model</a> (SpeechT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> (Splinter model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertModel">SqueezeBertModel</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a> (StableLm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/swiftformer#transformers.SwiftFormerConfig">SwiftFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/swiftformer#transformers.SwiftFormerModel">SwiftFormerModel</a> (SwiftFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/swin2sr#transformers.Swin2SRConfig">Swin2SRConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/swin2sr#transformers.Swin2SRModel">Swin2SRModel</a> (Swin2SR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinModel">SwinModel</a> (Swin Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/swinv2#transformers.Swinv2Config">Swinv2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/swinv2#transformers.Swinv2Model">Swinv2Model</a> (Swin Transformer V2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> (SwitchTransformers model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Model">T5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> (Table Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasModel">TapasModel</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerConfig">TimeSeriesTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/time_series_transformer#transformers.TimeSeriesTransformerModel">TimeSeriesTransformerModel</a> (Time Series Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> (TimeSformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/main_classes/backbones#transformers.TimmBackboneConfig">TimmBackboneConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/main_classes/backbones#transformers.TimmBackbone">TimmBackbone</a> (TimmBackbone model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerConfig">TrajectoryTransformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/trajectory_transformer#transformers.TrajectoryTransformerModel">TrajectoryTransformerModel</a> (Trajectory Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLModel">TransfoXLModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltModel">TvltModel</a> (TVLT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tvp#transformers.TvpConfig">TvpConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tvp#transformers.TvpModel">TvpModel</a> (TVP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5Config">UMT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/umt5#transformers.UMT5Model">UMT5Model</a> (UMT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechModel">UniSpeechModel</a> (UniSpeech model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatModel">UniSpeechSatModel</a> (UniSpeechSat model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/univnet#transformers.UnivNetConfig">UnivNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/univnet#transformers.UnivNetModel">UnivNetModel</a> (UnivNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/van#transformers.VanConfig">VanConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/van#transformers.VanModel">VanModel</a> (VAN model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTModel">ViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit_hybrid#transformers.ViTHybridConfig">ViTHybridConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit_hybrid#transformers.ViTHybridModel">ViTHybridModel</a> (ViT Hybrid model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEModel">ViTMAEModel</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit_msn#transformers.ViTMSNConfig">ViTMSNConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit_msn#transformers.ViTMSNModel">ViTMSNModel</a> (ViTMSN model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> (VideoMAE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltConfig">ViltConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vilt#transformers.ViltModel">ViltModel</a> (ViLT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertModel">VisualBertModel</a> (VisualBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vitdet#transformers.VitDetConfig">VitDetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vitdet#transformers.VitDetModel">VitDetModel</a> (VitDet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vits#transformers.VitsConfig">VitsConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vits#transformers.VitsModel">VitsModel</a> (VITS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> (ViViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertConfig">Wav2Vec2BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-bert#transformers.Wav2Vec2BertModel">Wav2Vec2BertModel</a> (Wav2Vec2-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerModel">Wav2Vec2ConformerModel</a> (Wav2Vec2-Conformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMConfig">WavLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wavlm#transformers.WavLMModel">WavLMModel</a> (WavLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperModel">WhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xclip#transformers.XCLIPConfig">XCLIPConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xclip#transformers.XCLIPModel">XCLIPModel</a> (X-CLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMModel">XGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMModel">XLMModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetModel">XLMProphetNetModel</a> (XLM-ProphetNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaModel">XLMRobertaModel</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLModel">XLMRobertaXLModel</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodModel">XmodModel</a> (X-MOD model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> (YOLOS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoModel">YosoModel</a> (YOSO model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Gs=new $({props:{anchor:"transformers.AutoModel.from_config.example",$$slots:{default:[yN]},$$scope:{ctx:C}}}),rm=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModel.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModel.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Vs=new $({props:{anchor:"transformers.AutoModel.from_pretrained.example",$$slots:{default:[wN]},$$scope:{ctx:C}}}),tm=new B({props:{title:"TFAutoModel",local:"transformers.TFAutoModel",headingTag:"h3"}}),nm=new x({props:{name:"class transformers.TFAutoModel",anchor:"transformers.TFAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_tf_auto.py#L531"}}),am=new x({props:{name:"from_config",anchor:"transformers.TFAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.DPRConfig">DPRConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/dpr#transformers.TFDPRQuestionEncoder">TFDPRQuestionEncoder</a> (DPR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertModel">TFDistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.EfficientFormerConfig">EfficientFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/efficientformer#transformers.TFEfficientFormerModel">TFEfficientFormerModel</a> (EfficientFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraModel">TFElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.TFEsmModel">TFEsmModel</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertModel">TFFlaubertModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelModel">TFFunnelModel</a> or <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelBaseModel">TFFunnelBaseModel</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2Model">TFGPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.TFGPTJModel">TFGPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.GroupViTConfig">GroupViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/groupvit#transformers.TFGroupViTModel">TFGroupViTModel</a> (GroupViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> (Hubert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.LEDConfig">LEDConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/led#transformers.TFLEDModel">TFLEDModel</a> (LED model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMModel">TFLayoutLMModel</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.LayoutLMv3Config">LayoutLMv3Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlmv3#transformers.TFLayoutLMv3Model">TFLayoutLMv3Model</a> (LayoutLMv3 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.TFLongformerModel">TFLongformerModel</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.TFLxmertModel">TFLxmertModel</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.TFMBartModel">TFMBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetModel">TFMPNetModel</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.TFMarianModel">TFMarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertModel">TFMobileBertModel</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.MobileViTConfig">MobileViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilevit#transformers.TFMobileViTModel">TFMobileViTModel</a> (MobileViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.TFPegasusModel">TFPegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertModel">TFRemBertModel</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.TFResNetModel">TFResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerModel">TFRoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaModel">TFRobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormModel">TFRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.SamConfig">SamConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/sam#transformers.TFSamModel">TFSamModel</a> (SAM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.SegformerConfig">SegformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/segformer#transformers.TFSegformerModel">TFSegformerModel</a> (SegFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.Speech2TextConfig">Speech2TextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text#transformers.TFSpeech2TextModel">TFSpeech2TextModel</a> (Speech2Text model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> (Swin Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasModel">TFTapasModel</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLModel">TFTransfoXLModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.TFViTModel">TFViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.TFViTMAEModel">TFViTMAEModel</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.TFWhisperModel">TFWhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.TFXGLMModel">TFXGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMModel">TFXLMModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaModel">TFXLMRobertaModel</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetModel">TFXLNetModel</a> (XLNet model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Ps=new $({props:{anchor:"transformers.TFAutoModel.from_config.example",$$slots:{default:[xN]},$$scope:{ctx:C}}}),sm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Js=new $({props:{anchor:"transformers.TFAutoModel.from_pretrained.example",$$slots:{default:[kN]},$$scope:{ctx:C}}}),im=new B({props:{title:"FlaxAutoModel",local:"transformers.FlaxAutoModel",headingTag:"h3"}}),lm=new x({props:{name:"class transformers.FlaxAutoModel",anchor:"transformers.FlaxAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_flax_auto.py#L280"}}),dm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.FlaxDistilBertModel">FlaxDistilBertModel</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraModel">FlaxElectraModel</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.FlaxGPT2Model">FlaxGPT2Model</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.FlaxGPTJModel">FlaxGPTJModel</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.FlaxGPTNeoModel">FlaxGPTNeoModel</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.FlaxGemmaModel">FlaxGemmaModel</a> (Gemma model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/llama#transformers.FlaxLlamaModel">FlaxLlamaModel</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.FlaxLongT5Model">FlaxLongT5Model</a> (LongT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartModel">FlaxMBartModel</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.FlaxMT5Model">FlaxMT5Model</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.FlaxMarianModel">FlaxMarianModel</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.FlaxMistralModel">FlaxMistralModel</a> (Mistral model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.FlaxOPTModel">FlaxOPTModel</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.FlaxPegasusModel">FlaxPegasusModel</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/regnet#transformers.FlaxRegNetModel">FlaxRegNetModel</a> (RegNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.ResNetConfig">ResNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/resnet#transformers.FlaxResNetModel">FlaxResNetModel</a> (ResNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerModel">FlaxRoFormerModel</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaModel">FlaxRobertaModel</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormModel">FlaxRobertaPreLayerNormModel</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit#transformers.FlaxViTModel">FlaxViTModel</a> (ViT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> (VisionTextDualEncoder model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2Model">FlaxWav2Vec2Model</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.FlaxWhisperModel">FlaxWhisperModel</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.FlaxXGLMModel">FlaxXGLMModel</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaModel">FlaxXLMRobertaModel</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Es=new $({props:{anchor:"transformers.FlaxAutoModel.from_config.example",$$slots:{default:[LN]},$$scope:{ctx:C}}}),mm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Is=new $({props:{anchor:"transformers.FlaxAutoModel.from_pretrained.example",$$slots:{default:[$N]},$$scope:{ctx:C}}}),cm=new B({props:{title:"Generic pretraining classes",local:"generic-pretraining-classes",headingTag:"h2"}}),gm=new B({props:{title:"AutoModelForPreTraining",local:"transformers.AutoModelForPreTraining",headingTag:"h3"}}),pm=new x({props:{name:"class transformers.AutoModelForPreTraining",anchor:"transformers.AutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_auto.py#L1325"}}),hm=new x({props:{name:"from_config",anchor:"transformers.AutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForPreTraining">ElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForPreTraining">ErnieForPreTraining</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForPreTraining">FNetForPreTraining</a> (FNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTConfig">FSMTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fsmt#transformers.FSMTForConditionalGeneration">FSMTForConditionalGeneration</a> (FairSeq Machine-Translation model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaConfig">FlavaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flava#transformers.FlavaForPreTraining">FlavaForPreTraining</a> (FLAVA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForPreTraining">FunnelForPreTraining</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseConfig">GPTSanJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptsan-japanese#transformers.GPTSanJapaneseForConditionalGeneration">GPTSanJapaneseForConditionalGeneration</a> (GPTSAN-japanese model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> (IDEFICS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> (LLaVa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertForPreTraining">LxmertForPreTraining</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForPreTraining">MegatronBertForPreTraining</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForPreTraining">MobileBertForPreTraining</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForPreTraining">NezhaForPreTraining</a> (Nezha model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeConfig">NllbMoeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nllb-moe#transformers.NllbMoeForConditionalGeneration">NllbMoeForConditionalGeneration</a> (NLLB-MOE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertConfig">RetriBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/retribert#transformers.RetriBertModel">RetriBertModel</a> (RetriBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForPreTraining">RoCBertForPreTraining</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> (Splinter model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> (SwitchTransformers model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5ForConditionalGeneration">T5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltConfig">TvltConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tvlt#transformers.TvltForPreTraining">TvltForPreTraining</a> (TVLT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechConfig">UniSpeechConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech#transformers.UniSpeechForPreTraining">UniSpeechForPreTraining</a> (UniSpeech model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatConfig">UniSpeechSatConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/unispeech-sat#transformers.UniSpeechSatForPreTraining">UniSpeechSatForPreTraining</a> (UniSpeechSat model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEForPreTraining">ViTMAEForPreTraining</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> (VideoMAE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vipllava#transformers.VipLlavaConfig">VipLlavaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vipllava#transformers.VipLlavaForConditionalGeneration">VipLlavaForConditionalGeneration</a> (VipLlava model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertConfig">VisualBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/visual_bert#transformers.VisualBertForPreTraining">VisualBertForPreTraining</a> (VisualBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerConfig">Wav2Vec2ConformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2-conformer#transformers.Wav2Vec2ConformerForPreTraining">Wav2Vec2ConformerForPreTraining</a> (Wav2Vec2-Conformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Us=new $({props:{anchor:"transformers.AutoModelForPreTraining.from_config.example",$$slots:{default:[BN]},$$scope:{ctx:C}}}),um=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Ns=new $({props:{anchor:"transformers.AutoModelForPreTraining.from_pretrained.example",$$slots:{default:[jN]},$$scope:{ctx:C}}}),_m=new B({props:{title:"TFAutoModelForPreTraining",local:"transformers.TFAutoModelForPreTraining",headingTag:"h3"}}),bm=new x({props:{name:"class transformers.TFAutoModelForPreTraining",anchor:"transformers.TFAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_tf_auto.py#L547"}}),vm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.TFDistilBertForMaskedLM">TFDistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.TFElectraForPreTraining">TFElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.TFFlaubertWithLMHeadModel">TFFlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.TFFunnelForPreTraining">TFFunnelForPreTraining</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.TFLayoutLMForMaskedLM">TFLayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.LxmertConfig">LxmertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/lxmert#transformers.TFLxmertForPreTraining">TFLxmertForPreTraining</a> (LXMERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.TFMPNetForMaskedLM">TFMPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.TFMobileBertForPreTraining">TFMobileBertForPreTraining</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForMaskedLM">TFRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForMaskedLM">TFRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TFTapasForMaskedLM">TFTapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.ViTMAEConfig">ViTMAEConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/vit_mae#transformers.TFViTMAEForPreTraining">TFViTMAEForPreTraining</a> (ViTMAE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForMaskedLM">TFXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Xs=new $({props:{anchor:"transformers.TFAutoModelForPreTraining.from_config.example",$$slots:{default:[ZN]},$$scope:{ctx:C}}}),Mm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),qs=new $({props:{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[AN]},$$scope:{ctx:C}}}),Fm=new B({props:{title:"FlaxAutoModelForPreTraining",local:"transformers.FlaxAutoModelForPreTraining",headingTag:"h3"}}),Tm=new x({props:{name:"class transformers.FlaxAutoModelForPreTraining",anchor:"transformers.FlaxAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_flax_auto.py#L287"}}),Cm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForPreTraining">FlaxElectraForPreTraining</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.LongT5Config">LongT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longt5#transformers.FlaxLongT5ForConditionalGeneration">FlaxLongT5ForConditionalGeneration</a> (LongT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.FlaxMBartForConditionalGeneration">FlaxMBartForConditionalGeneration</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.MT5Config">MT5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mt5#transformers.FlaxMT5ForConditionalGeneration">FlaxMT5ForConditionalGeneration</a> (MT5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.FlaxRoFormerForMaskedLM">FlaxRoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForMaskedLM">FlaxRobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForMaskedLM">FlaxRobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.T5Config">T5Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a> (T5 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.FlaxWhisperForConditionalGeneration">FlaxWhisperForConditionalGeneration</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForMaskedLM">FlaxXLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Ds=new $({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.example",$$slots:{default:[RN]},$$scope:{ctx:C}}}),ym=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Qs=new $({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[WN]},$$scope:{ctx:C}}}),wm=new B({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),km=new B({props:{title:"AutoModelForCausalLM",local:"transformers.AutoModelForCausalLM",headingTag:"h3"}}),Lm=new x({props:{name:"class transformers.AutoModelForCausalLM",anchor:"transformers.AutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_auto.py#L1340"}}),$m=new x({props:{name:"from_config",anchor:"transformers.AutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForCausalLM">ElectraForCausalLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForCausalLM">ErnieForCausalLM</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> (Falcon model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> (Fuyu model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2LMHeadModel">GPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig">GPTBigCodeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> (GPTBigCode model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJForCausalLM">GPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoForCausalLM">GPTNeoForCausalLM</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXConfig">GPTNeoXConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox#transformers.GPTNeoXForCausalLM">GPTNeoXForCausalLM</a> (GPT NeoX model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseConfig">GPTNeoXJapaneseConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neox_japanese#transformers.GPTNeoXJapaneseForCausalLM">GPTNeoXJapaneseForCausalLM</a> (GPT NeoX Japanese model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaForCausalLM">GemmaForCausalLM</a> (Gemma model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitConfig">GitConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/git#transformers.GitForCausalLM">GitForCausalLM</a> (GIT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaForCausalLM">LlamaForCausalLM</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForCausalLM">MBartForCausalLM</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianConfig">MarianConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/marian#transformers.MarianForCausalLM">MarianForCausalLM</a> (Marian model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForCausalLM">MegatronBertForCausalLM</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralForCausalLM">MistralForCausalLM</a> (Mistral model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralConfig">MixtralConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mixtral#transformers.MixtralForCausalLM">MixtralForCausalLM</a> (Mixtral model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptConfig">MptConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> (MPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> (MusicGen model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForCausalLM">MvpForCausalLM</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaConfig">OpenLlamaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/open-llama#transformers.OpenLlamaForCausalLM">OpenLlamaForCausalLM</a> (OpenLlama model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartConfig">PLBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/plbart#transformers.PLBartForCausalLM">PLBartForCausalLM</a> (PLBart model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusConfig">PegasusConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/pegasus#transformers.PegasusForCausalLM">PegasusForCausalLM</a> (Pegasus model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> (Persimmon model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> (Phi model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetConfig">ProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/prophetnet#transformers.ProphetNetForCausalLM">ProphetNetForCausalLM</a> (ProphetNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertLMHeadModel">QDQBertLMHeadModel</a> (QDQBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2Config">Qwen2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/qwen2#transformers.Qwen2ForCausalLM">Qwen2ForCausalLM</a> (Qwen2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerModelWithLMHead">ReformerModelWithLMHead</a> (Reformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForCausalLM">RemBertForCausalLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForCausalLM">RoCBertForCausalLM</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForCausalLM">RoFormerForCausalLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForCausalLM">RobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForCausalLM">RobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvConfig">RwkvConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rwkv#transformers.RwkvForCausalLM">RwkvForCausalLM</a> (RWKV model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text_2#transformers.Speech2Text2Config">Speech2Text2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/speech_to_text_2#transformers.Speech2Text2ForCausalLM">Speech2Text2ForCausalLM</a> (Speech2Text2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/stablelm#transformers.StableLmForCausalLM">StableLmForCausalLM</a> (StableLm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/trocr#transformers.TrOCRConfig">TrOCRConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/trocr#transformers.TrOCRForCausalLM">TrOCRForCausalLM</a> (TrOCR model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLLMHeadModel">TransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperConfig">WhisperConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/whisper#transformers.WhisperForCausalLM">WhisperForCausalLM</a> (Whisper model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMForCausalLM">XGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetConfig">XLMProphetNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-prophetnet#transformers.XLMProphetNetForCausalLM">XLMProphetNetForCausalLM</a> (XLM-ProphetNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForCausalLM">XLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForCausalLM">XLMRobertaXLForCausalLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetLMHeadModel">XLNetLMHeadModel</a> (XLNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForCausalLM">XmodForCausalLM</a> (X-MOD model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Hs=new $({props:{anchor:"transformers.AutoModelForCausalLM.from_config.example",$$slots:{default:[SN]},$$scope:{ctx:C}}}),Bm=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Ys=new $({props:{anchor:"transformers.AutoModelForCausalLM.from_pretrained.example",$$slots:{default:[GN]},$$scope:{ctx:C}}}),jm=new B({props:{title:"TFAutoModelForCausalLM",local:"transformers.TFAutoModelForCausalLM",headingTag:"h3"}}),Zm=new x({props:{name:"class transformers.TFAutoModelForCausalLM",anchor:"transformers.TFAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_tf_auto.py#L562"}}),Am=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.TFGPT2LMHeadModel">TFGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.TFGPTJForCausalLM">TFGPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> (OpenAI GPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.TFRemBertForCausalLM">TFRemBertForCausalLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.TFRoFormerForCausalLM">TFRoFormerForCausalLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.TFRobertaForCausalLM">TFRobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.TFRobertaPreLayerNormForCausalLM">TFRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TransfoXLConfig">TransfoXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/transfo-xl#transformers.TFTransfoXLLMHeadModel">TFTransfoXLLMHeadModel</a> (Transformer-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.TFXGLMForCausalLM">TFXGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.TFXLMWithLMHeadModel">TFXLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.TFXLMRobertaForCausalLM">TFXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.XLNetConfig">XLNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlnet#transformers.TFXLNetLMHeadModel">TFXLNetLMHeadModel</a> (XLNet model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),zs=new $({props:{anchor:"transformers.TFAutoModelForCausalLM.from_config.example",$$slots:{default:[VN]},$$scope:{ctx:C}}}),Rm=new x({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),Os=new $({props:{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[PN]},$$scope:{ctx:C}}}),Wm=new B({props:{title:"FlaxAutoModelForCausalLM",local:"transformers.FlaxAutoModelForCausalLM",headingTag:"h3"}}),Sm=new x({props:{name:"class transformers.FlaxAutoModelForCausalLM",anchor:"transformers.FlaxAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_flax_auto.py#L294"}}),Gm=new x({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.FlaxElectraForCausalLM">FlaxElectraForCausalLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Config">GPT2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.FlaxGPT2LMHeadModel">FlaxGPT2LMHeadModel</a> (OpenAI GPT-2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.GPTJConfig">GPTJConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gptj#transformers.FlaxGPTJForCausalLM">FlaxGPTJForCausalLM</a> (GPT-J model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.GPTNeoConfig">GPTNeoConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gpt_neo#transformers.FlaxGPTNeoForCausalLM">FlaxGPTNeoForCausalLM</a> (GPT Neo model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.GemmaConfig">GemmaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/gemma#transformers.FlaxGemmaForCausalLM">FlaxGemmaForCausalLM</a> (Gemma model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/llama#transformers.FlaxLlamaForCausalLM">FlaxLlamaForCausalLM</a> (LLaMA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.MistralConfig">MistralConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mistral#transformers.FlaxMistralForCausalLM">FlaxMistralForCausalLM</a> (Mistral model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> (OPT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.FlaxRobertaForCausalLM">FlaxRobertaForCausalLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.FlaxRobertaPreLayerNormForCausalLM">FlaxRobertaPreLayerNormForCausalLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.XGLMConfig">XGLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xglm#transformers.FlaxXGLMForCausalLM">FlaxXGLMForCausalLM</a> (XGLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.FlaxXLMRobertaForCausalLM">FlaxXLMRobertaForCausalLM</a> (XLM-RoBERTa model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),Ks=new $({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.example",$$slots:{default:[JN]},$$scope:{ctx:C}}}),Vm=new x({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),ei=new $({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[EN]},$$scope:{ctx:C}}}),Pm=new B({props:{title:"AutoModelForMaskedLM",local:"transformers.AutoModelForMaskedLM",headingTag:"h3"}}),Jm=new x({props:{name:"class transformers.AutoModelForMaskedLM",anchor:"transformers.AutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_auto.py#L1347"}}),Em=new x({props:{name:"from_config",anchor:"transformers.AutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertConfig">DistilBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/distilbert#transformers.DistilBertForMaskedLM">DistilBertForMaskedLM</a> (DistilBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraConfig">ElectraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/electra#transformers.ElectraForMaskedLM">ElectraForMaskedLM</a> (ELECTRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieConfig">ErnieConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ernie#transformers.ErnieForMaskedLM">ErnieForMaskedLM</a> (ERNIE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmConfig">EsmConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/esm#transformers.EsmForMaskedLM">EsmForMaskedLM</a> (ESM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetConfig">FNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/fnet#transformers.FNetForMaskedLM">FNetForMaskedLM</a> (FNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertConfig">FlaubertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/flaubert#transformers.FlaubertWithLMHeadModel">FlaubertWithLMHeadModel</a> (FlauBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelConfig">FunnelConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/funnel#transformers.FunnelForMaskedLM">FunnelForMaskedLM</a> (Funnel Transformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertConfig">IBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/ibert#transformers.IBertForMaskedLM">IBertForMaskedLM</a> (I-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMConfig">LayoutLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/layoutlm#transformers.LayoutLMForMaskedLM">LayoutLMForMaskedLM</a> (LayoutLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerConfig">LongformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/longformer#transformers.LongformerForMaskedLM">LongformerForMaskedLM</a> (Longformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeConfig">LukeConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/luke#transformers.LukeForMaskedLM">LukeForMaskedLM</a> (LUKE model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartConfig">MBartConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a> (mBART model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetConfig">MPNetConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mpnet#transformers.MPNetForMaskedLM">MPNetForMaskedLM</a> (MPNet model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> (MEGA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertConfig">MegatronBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/megatron-bert#transformers.MegatronBertForMaskedLM">MegatronBertForMaskedLM</a> (Megatron-BERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertConfig">MobileBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mobilebert#transformers.MobileBertForMaskedLM">MobileBertForMaskedLM</a> (MobileBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraConfig">MraConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mra#transformers.MraForMaskedLM">MraForMaskedLM</a> (MRA model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpConfig">MvpConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/mvp#transformers.MvpForConditionalGeneration">MvpForConditionalGeneration</a> (MVP model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaConfig">NezhaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nezha#transformers.NezhaForMaskedLM">NezhaForMaskedLM</a> (Nezha model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerConfig">NystromformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/nystromformer#transformers.NystromformerForMaskedLM">NystromformerForMaskedLM</a> (Nystr&#xF6;mformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> (Perceiver model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertConfig">QDQBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/qdqbert#transformers.QDQBertForMaskedLM">QDQBertForMaskedLM</a> (QDQBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerConfig">ReformerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/reformer#transformers.ReformerForMaskedLM">ReformerForMaskedLM</a> (Reformer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertConfig">RemBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/rembert#transformers.RemBertForMaskedLM">RemBertForMaskedLM</a> (RemBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertConfig">RoCBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roc_bert#transformers.RoCBertForMaskedLM">RoCBertForMaskedLM</a> (RoCBert model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerConfig">RoFormerConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roformer#transformers.RoFormerForMaskedLM">RoFormerForMaskedLM</a> (RoFormer model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaConfig">RobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta#transformers.RobertaForMaskedLM">RobertaForMaskedLM</a> (RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormConfig">RobertaPreLayerNormConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/roberta-prelayernorm#transformers.RobertaPreLayerNormForMaskedLM">RobertaPreLayerNormForMaskedLM</a> (RoBERTa-PreLayerNorm model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertConfig">SqueezeBertConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/squeezebert#transformers.SqueezeBertForMaskedLM">SqueezeBertForMaskedLM</a> (SqueezeBERT model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasConfig">TapasConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/tapas#transformers.TapasForMaskedLM">TapasForMaskedLM</a> (TAPAS model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a> configuration class: <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMConfig">XLMConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm#transformers.XLMWithLMHeadModel">XLMWithLMHeadModel</a> (XLM model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaConfig">XLMRobertaConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta#transformers.XLMRobertaForMaskedLM">XLMRobertaForMaskedLM</a> (XLM-RoBERTa model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLConfig">XLMRobertaXLConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xlm-roberta-xl#transformers.XLMRobertaXLForMaskedLM">XLMRobertaXLForMaskedLM</a> (XLM-RoBERTa-XL model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodConfig">XmodConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/xmod#transformers.XmodForMaskedLM">XmodForMaskedLM</a> (X-MOD model)</li>
<li><a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoConfig">YosoConfig</a> configuration class: <a href="/docs/transformers/v4.38.1/en/model_doc/yoso#transformers.YosoForMaskedLM">YosoForMaskedLM</a> (YOSO model)</li>
</ul>`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L411"}}),oi=new $({props:{anchor:"transformers.AutoModelForMaskedLM.from_config.example",$$slots:{default:[IN]},$$scope:{ctx:C}}}),Im=new x({props:{name:"from_pretrained",anchor:"transformers.AutoModelForMaskedLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/auto_factory.py#L442"}}),ri=new $({props:{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.example",$$slots:{default:[UN]},$$scope:{ctx:C}}}),Um=new B({props:{title:"TFAutoModelForMaskedLM",local:"transformers.TFAutoModelForMaskedLM",headingTag:"h3"}}),Nm=new x({props:{name:"class transformers.TFAutoModelForMaskedLM",anchor:"transformers.TFAutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/auto/modeling_tf_auto.py#L612"}}),Xm=new x({props:{name:"from_config",anchor:"transformers.TFAutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMaskedLM.from_config.config",description:`<strong>config