import{s as Vt,o as Yt,n as ql}from"../chunks/scheduler.bdbef820.js";import{S as Qt,i as Ht,g as M,s as n,r as y,A as Et,h as i,f as t,c as a,j as xt,u as m,x as p,k as Gt,y as zt,a as s,v as r,d as c,t as d,w as J}from"../chunks/index.33f81d56.js";import{T as Sl}from"../chunks/Tip.34194030.js";import{C as w}from"../chunks/CodeBlock.362b34a4.js";import{H as Re,E as Ft}from"../chunks/EditOnGithub.a9246e21.js";function Lt(U){let o,f="라이브러리에 존재하는 모델과 굉장히 유사하다면, 모델을 생성할 때 구성을 참조해 재사용할 수 있습니다.";return{c(){o=M("p"),o.textContent=f},l(T){o=i(T,"P",{"data-svelte-h":!0}),p(o)!=="svelte-hf6zh1"&&(o.textContent=f)},m(T,j){s(T,o,j)},p:ql,d(T){T&&t(o)}}}function St(U){let o,f="이 API는 실험적이며 다음 릴리스에서 약간의 변경 사항이 있을 수 있습니다.";return{c(){o=M("p"),o.textContent=f},l(T){o=i(T,"P",{"data-svelte-h":!0}),p(o)!=="svelte-11fial7"&&(o.textContent=f)},m(T,j){s(T,o,j)},p:ql,d(T){T&&t(o)}}}function qt(U){let o,f=`라이브러리에서 모델링 파일을 복사하는 경우,
모든 파일 상단에 있는 상대 경로 임포트(relative import) 부분을 <code>transformers</code> 패키지에서 임포트 하도록 변경해야 합니다.`;return{c(){o=M("p"),o.innerHTML=f},l(T){o=i(T,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1igyulw"&&(o.innerHTML=f)},m(T,j){s(T,o,j)},p:ql,d(T){T&&t(o)}}}function Pt(U){let o,f,T,j,I,We,_,Pl=`🤗 Transformers 라이브러리는 쉽게 확장할 수 있도록 설계되었습니다.
모든 모델은 추상화 없이 저장소의 지정된 하위 폴더에 완전히 코딩되어 있으므로, 손쉽게 모델링 파일을 복사하고 필요에 따라 조정할 수 있습니다.`,ve,h,Dl=`완전히 새로운 모델을 만드는 경우에는 처음부터 시작하는 것이 더 쉬울 수 있습니다.
이 튜토리얼에서는 Transformers 내에서 사용할 수 있도록 사용자 정의 모델과 구성을 작성하는 방법과
🤗 Transformers 라이브러리에 없는 경우에도 누구나 사용할 수 있도록 (의존성과 함께) 커뮤니티에 공유하는 방법을 배울 수 있습니다.`,Xe,Z,Kl='<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 라이브러리</a>의 ResNet 클래스를 <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>로 래핑한 ResNet 모델을 예로 모든 것을 설명합니다.',xe,g,Ge,A,Ol=`모델에 들어가기 전에 먼저 구성을 작성해보도록 하겠습니다.
모델의 <code>configuration</code>은 모델을 만들기 위해 필요한 모든 중요한 것들을 포함하고 있는 객체입니다.
다음 섹션에서 볼 수 있듯이, 모델은 <code>config</code>를 사용해서만 초기화할 수 있기 때문에 완벽한 구성이 필요합니다.`,Ve,$,et=`아래 예시에서는 ResNet 클래스의 인수(argument)를 조정해보겠습니다.
다른 구성은 가능한 ResNet 중 다른 유형을 제공합니다.
그런 다음 몇 가지 유효성을 확인한 후 해당 인수를 저장합니다.`,Ye,k,Qe,N,lt="사용자 정의 <code>configuration</code>을 작성할 때 기억해야 할 세 가지 중요한 사항은 다음과 같습니다:",He,R,tt="<li><code>PretrainedConfig</code>을 상속해야 합니다.</li> <li><code>PretrainedConfig</code>의 <code>__init__</code>은 모든 kwargs를 허용해야 하고,</li> <li>이러한 <code>kwargs</code>는 상위 클래스 <code>__init__</code>에 전달되어야 합니다.</li>",Ee,B,st=`상속은 🤗 Transformers 라이브러리에서 모든 기능을 가져오는 것입니다.
이러한 점으로부터 비롯되는 두 가지 제약 조건은 <code>PretrainedConfig</code>에 설정하는 것보다 더 많은 필드가 있습니다.
<code>from_pretrained</code> 메서드로 구성을 다시 로드할 때 해당 필드는 구성에서 수락한 후 상위 클래스로 보내야 합니다.`,ze,W,nt="모델을 auto 클래스에 등록하지 않는 한, <code>configuration</code>에서 <code>model_type</code>을 정의(여기서 <code>model_type=&quot;resnet&quot;</code>)하는 것은 필수 사항이 아닙니다 (마지막 섹션 참조).",Fe,v,at=`이렇게 하면 라이브러리의 다른 모델 구성과 마찬가지로 구성을 쉽게 만들고 저장할 수 있습니다.
다음은 resnet50d 구성을 생성하고 저장하는 방법입니다:`,Le,X,Se,x,Mt=`이렇게 하면 <code>custom-resnet</code> 폴더 안에 <code>config.json</code>이라는 파일이 저장됩니다.
그런 다음 <code>from_pretrained</code> 메서드를 사용하여 구성을 다시 로드할 수 있습니다.`,qe,G,Pe,V,it='구성을 Hub에 직접 업로드하기 위해 <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> 클래스의 <a href="/docs/transformers/main/ko/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>와 같은 다른 메서드를 사용할 수 있습니다.',De,Y,Ke,Q,pt=`이제 ResNet 구성이 있으므로 모델을 작성할 수 있습니다.
실제로는 두 개를 작성할 것입니다. 하나는 이미지 배치에서 hidden features를 추출하는 것(<code>BertModel</code>과 같이), 다른 하나는 이미지 분류에 적합한 것입니다(<code>BertForSequenceClassification</code>과 같이).`,Oe,H,ot=`이전에 언급했듯이 이 예제에서는 단순하게 하기 위해 모델의 느슨한 래퍼(loose wrapper)만 작성할 것입니다.
이 클래스를 작성하기 전에 블록 유형과 실제 블록 클래스 간의 매핑 작업만 하면 됩니다.
그런 다음 <code>ResNet</code> 클래스로 전달되어 <code>configuration</code>을 통해 모델이 선언됩니다:`,el,E,ll,z,yt="이미지 분류 모델을 만들기 위해서는 forward 메소드만 변경하면 됩니다:",tl,F,sl,L,mt=`두 경우 모두 <code>PreTrainedModel</code>를 상속받고, <code>config</code>를 통해 상위 클래스 초기화를 호출하다는 점을 기억하세요 (일반적인 <code>torch.nn.Module</code>을 작성할 때와 비슷함).
모델을 auto 클래스에 등록하고 싶은 경우에는 <code>config_class</code>를 설정하는 부분이 필수입니다 (마지막 섹션 참조).`,nl,u,al,S,rt=`원하는 것을 모델이 반환하도록 할 수 있지만, <code>ResnetModelForImageClassification</code>에서 했던 것 처럼
레이블을 통과시켰을 때 손실과 함께 사전 형태로 반환하는 것이 <a href="/docs/transformers/main/ko/main_classes/trainer#transformers.Trainer">Trainer</a> 클래스 내에서 직접 모델을 사용하기에 유용합니다.
자신만의 학습 루프 또는 다른 학습 라이브러리를 사용할 계획이라면 다른 출력 형식을 사용해도 좋습니다.`,Ml,q,ct="이제 모델 클래스가 있으므로 하나 생성해 보겠습니다:",il,P,pl,D,dt=`다시 말하지만, <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>또는 <a href="/docs/transformers/main/ko/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>처럼 <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>에 속하는 모든 메소드를 사용할 수 있습니다.
다음 섹션에서 두 번째 메소드를 사용해 모델 코드와 모델 가중치를 업로드하는 방법을 살펴보겠습니다.
먼저, 모델 내부에 사전 훈련된 가중치를 로드해 보겠습니다.`,ol,K,Jt=`이 예제를 활용할 때는, 사용자 정의 모델을 자신만의 데이터로 학습시킬 것입니다.
이 튜토리얼에서는 빠르게 진행하기 위해 사전 훈련된 resnet50d를 사용하겠습니다.
아래 모델은 resnet50d의 래퍼이기 때문에, 가중치를 쉽게 로드할 수 있습니다.`,yl,O,ml,ee,Tt='이제 <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> 또는 <a href="/docs/transformers/main/ko/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>를 사용할 때 모델 코드가 저장되는지 확인해봅시다.',rl,le,cl,C,dl,te,wt=`먼저 모델이 <code>.py</code> 파일에 완전히 정의되어 있는지 확인하세요.
모든 파일이 동일한 작업 경로에 있기 때문에 상대경로 임포트(relative import)에 의존할 수 있습니다 (transformers에서는 이 기능에 대한 하위 모듈을 지원하지 않습니다).
이 예시에서는 작업 경로 안의 <code>resnet_model</code>에서 <code>modeling_resnet.py</code> 파일과 <code>configuration_resnet.py</code> 파일을 정의합니다.
구성 파일에는 <code>ResnetConfig</code>에 대한 코드가 있고 모델링 파일에는 <code>ResnetModel</code> 및 <code>ResnetModelForImageClassification</code>에 대한 코드가 있습니다.`,Jl,se,Tl,ne,ft="Python이 <code>resnet_model</code>을 모듈로 사용할 수 있도록 감지하는 목적이기 때문에 <code>__init__.py</code>는 비어 있을 수 있습니다.",wl,b,fl,ae,jt="기존 구성이나 모델을 재사용(또는 서브 클래스화)할 수 있습니다.",jl,Me,Ut=`커뮤니티에 모델을 공유하기 위해서는 다음 단계를 따라야 합니다:
먼저, 새로 만든 파일에 ResNet 모델과 구성을 임포트합니다:`,Ul,ie,ul,pe,ut=`다음으로 <code>save_pretrained</code> 메소드를 사용해 해당 객체의 코드 파일을 복사하고,
복사한 파일을 Auto 클래스로 등록하고(모델인 경우) 실행합니다:`,Cl,oe,bl,ye,Ct=`<code>configuration</code>에 대한 auto 클래스를 지정할 필요는 없지만(<code>configuration</code> 관련 auto 클래스는 AutoConfig 클래스 하나만 있음), 모델의 경우에는 지정해야 합니다.
사용자 지정 모델은 다양한 작업에 적합할 수 있으므로, 모델에 맞는 auto 클래스를 지정해야 합니다.`,Il,me,bt="다음으로, 이전에 작업했던 것과 마찬가지로 구성과 모델을 작성합니다:",_l,re,hl,ce,It=`이제 모델을 Hub로 업로드하기 위해 로그인 상태인지 확인하세요.
터미널에서 다음 코드를 실행해 확인할 수 있습니다:`,Zl,de,gl,Je,_t="주피터 노트북의 경우에는 다음과 같습니다:",Al,Te,$l,we,ht="그런 다음 이렇게 자신의 네임스페이스(또는 자신이 속한 조직)에 업로드할 수 있습니다:",kl,fe,Nl,je,Zt=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.
json 형식의 모델링 가중치와 구성 외에도 <code>custom-resnet50d</code> 폴더 안의 모델링과 구성 <code>.py</code> 파일을 복사하해 Hub에 업로드합니다.
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">모델 저장소</a>에서 결과를 확인할 수 있습니다.`,Rl,Ue,gt='<a href="model_sharing">sharing tutorial</a> 문서의 <code>push_to_hub</code> 메소드에서 자세한 내용을 확인할 수 있습니다.',Bl,ue,Wl,Ce,At=`auto 클래스와 <code>from_pretrained</code> 메소드를 사용하여 사용자 지정 코드 파일과 함께 모든 구성, 모델, 토크나이저를 사용할 수 있습니다.
Hub에 업로드된 모든 파일 및 코드는 멜웨어가 있는지 검사되지만 (자세한 내용은 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 보안</a> 설명 참조),
자신의 컴퓨터에서 모델 코드와 작성자가 악성 코드를 실행하지 않는지 확인해야 합니다.
사용자 정의 코드로 모델을 사용하려면 <code>trust_remote_code=True</code>로 설정하세요:`,vl,be,Xl,Ie,$t="모델 작성자가 악의적으로 코드를 업데이트하지 않았다는 점을 확인하기 위해, 커밋 해시(commit hash)를 <code>revision</code>으로 전달하는 것도 강력히 권장됩니다 (모델 작성자를 완전히 신뢰하지 않는 경우).",xl,_e,Gl,he,kt="Hub에서 모델 저장소의 커밋 기록을 찾아볼 때, 모든 커밋의 커밋 해시를 쉽게 복사할 수 있는 버튼이 있습니다.",Vl,Ze,Yl,ge,Nt=`🤗 Transformers를 상속하는 라이브러리를 작성하는 경우 사용자 정의 모델을 auto 클래스에 추가할 수 있습니다.
사용자 정의 모델을 사용하기 위해 해당 라이브러리를 임포트해야 하기 때문에, 이는 Hub로 코드를 업로드하는 것과 다릅니다 (Hub에서 자동적으로 모델 코드를 다운로드 하는 것과 반대).`,Ql,Ae,Rt=`구성에 기존 모델 유형과 다른 <code>model_type</code> 속성이 있고 모델 클래스에 올바른 <code>config_class</code> 속성이 있는 한,
다음과 같이 auto 클래스에 추가할 수 있습니다:`,Hl,$e,El,ke,Bt=`사용자 정의 구성을 <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoConfig">AutoConfig</a>에 등록할 때 사용되는 첫 번째 인수는 사용자 정의 구성의 <code>model_type</code>과 일치해야 합니다.
또한, 사용자 정의 모델을 auto 클래스에 등록할 때 사용되는 첫 번째 인수는 해당 모델의 <code>config_class</code>와 일치해야 합니다.`,zl,Ne,Fl,Be,Ll;return I=new Re({props:{title:"사용자 정의 모델 공유하기",local:"sharing-custom-models",headingTag:"h1"}}),g=new Re({props:{title:"사용자 정의 구성 작성하기",local:"writing-a-custom-configuration",headingTag:"h2"}}),k=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),G=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),Y=new Re({props:{title:"사용자 정의 모델 작성하기",local:"writing-a-custom-model",headingTag:"h2"}}),E=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5jcm9zc19lbnRyb3B5KGxvZ2l0cyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb3NzJTIyJTNBJTIwbG9zcyUyQyUyMCUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RA==",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.functional.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),u=new Sl({props:{$$slots:{default:[Lt]},$$scope:{ctx:U}}}),P=new w({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new w({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),le=new Re({props:{title:"Hub로 코드 업로드하기",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),C=new Sl({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:U}}}),se=new w({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Sl({props:{warning:!0,$$slots:{default:[qt]},$$scope:{ctx:U}}}),ie=new w({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),oe=new w({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),re=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),de=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Te=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),fe=new w({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),ue=new Re({props:{title:"사용자 정의 코드로 모델 사용하기",local:"using-a-model-with-custom-code",headingTag:"h2"}}),be=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_e=new w({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ze=new Re({props:{title:"사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),$e=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),Ne=new Ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/custom_models.md"}}),{c(){o=M("meta"),f=n(),T=M("p"),j=n(),y(I.$$.fragment),We=n(),_=M("p"),_.textContent=Pl,ve=n(),h=M("p"),h.textContent=Dl,Xe=n(),Z=M("p"),Z.innerHTML=Kl,xe=n(),y(g.$$.fragment),Ge=n(),A=M("p"),A.innerHTML=Ol,Ve=n(),$=M("p"),$.textContent=et,Ye=n(),y(k.$$.fragment),Qe=n(),N=M("p"),N.innerHTML=lt,He=n(),R=M("ul"),R.innerHTML=tt,Ee=n(),B=M("p"),B.innerHTML=st,ze=n(),W=M("p"),W.innerHTML=nt,Fe=n(),v=M("p"),v.textContent=at,Le=n(),y(X.$$.fragment),Se=n(),x=M("p"),x.innerHTML=Mt,qe=n(),y(G.$$.fragment),Pe=n(),V=M("p"),V.innerHTML=it,De=n(),y(Y.$$.fragment),Ke=n(),Q=M("p"),Q.innerHTML=pt,Oe=n(),H=M("p"),H.innerHTML=ot,el=n(),y(E.$$.fragment),ll=n(),z=M("p"),z.textContent=yt,tl=n(),y(F.$$.fragment),sl=n(),L=M("p"),L.innerHTML=mt,nl=n(),y(u.$$.fragment),al=n(),S=M("p"),S.innerHTML=rt,Ml=n(),q=M("p"),q.textContent=ct,il=n(),y(P.$$.fragment),pl=n(),D=M("p"),D.innerHTML=dt,ol=n(),K=M("p"),K.textContent=Jt,yl=n(),y(O.$$.fragment),ml=n(),ee=M("p"),ee.innerHTML=Tt,rl=n(),y(le.$$.fragment),cl=n(),y(C.$$.fragment),dl=n(),te=M("p"),te.innerHTML=wt,Jl=n(),y(se.$$.fragment),Tl=n(),ne=M("p"),ne.innerHTML=ft,wl=n(),y(b.$$.fragment),fl=n(),ae=M("p"),ae.textContent=jt,jl=n(),Me=M("p"),Me.textContent=Ut,Ul=n(),y(ie.$$.fragment),ul=n(),pe=M("p"),pe.innerHTML=ut,Cl=n(),y(oe.$$.fragment),bl=n(),ye=M("p"),ye.innerHTML=Ct,Il=n(),me=M("p"),me.textContent=bt,_l=n(),y(re.$$.fragment),hl=n(),ce=M("p"),ce.textContent=It,Zl=n(),y(de.$$.fragment),gl=n(),Je=M("p"),Je.textContent=_t,Al=n(),y(Te.$$.fragment),$l=n(),we=M("p"),we.textContent=ht,kl=n(),y(fe.$$.fragment),Nl=n(),je=M("p"),je.innerHTML=Zt,Rl=n(),Ue=M("p"),Ue.innerHTML=gt,Bl=n(),y(ue.$$.fragment),Wl=n(),Ce=M("p"),Ce.innerHTML=At,vl=n(),y(be.$$.fragment),Xl=n(),Ie=M("p"),Ie.innerHTML=$t,xl=n(),y(_e.$$.fragment),Gl=n(),he=M("p"),he.textContent=kt,Vl=n(),y(Ze.$$.fragment),Yl=n(),ge=M("p"),ge.textContent=Nt,Ql=n(),Ae=M("p"),Ae.innerHTML=Rt,Hl=n(),y($e.$$.fragment),El=n(),ke=M("p"),ke.innerHTML=Bt,zl=n(),y(Ne.$$.fragment),Fl=n(),Be=M("p"),this.h()},l(e){const l=Et("svelte-u9bgzb",document.head);o=i(l,"META",{name:!0,content:!0}),l.forEach(t),f=a(e),T=i(e,"P",{}),xt(T).forEach(t),j=a(e),m(I.$$.fragment,e),We=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-al07n"&&(_.textContent=Pl),ve=a(e),h=i(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1lxcxix"&&(h.textContent=Dl),Xe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1ob22f7"&&(Z.innerHTML=Kl),xe=a(e),m(g.$$.fragment,e),Ge=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-la43mp"&&(A.innerHTML=Ol),Ve=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1qc22zw"&&($.textContent=et),Ye=a(e),m(k.$$.fragment,e),Qe=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-nxq6mo"&&(N.innerHTML=lt),He=a(e),R=i(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-1tfxli8"&&(R.innerHTML=tt),Ee=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-x5ckqo"&&(B.innerHTML=st),ze=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1kaub1g"&&(W.innerHTML=nt),Fe=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-ovl0zx"&&(v.textContent=at),Le=a(e),m(X.$$.fragment,e),Se=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-d1xscf"&&(x.innerHTML=Mt),qe=a(e),m(G.$$.fragment,e),Pe=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-k70j2o"&&(V.innerHTML=it),De=a(e),m(Y.$$.fragment,e),Ke=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-6nuh70"&&(Q.innerHTML=pt),Oe=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1ufn8h6"&&(H.innerHTML=ot),el=a(e),m(E.$$.fragment,e),ll=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-10szka3"&&(z.textContent=yt),tl=a(e),m(F.$$.fragment,e),sl=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1g3ya33"&&(L.innerHTML=mt),nl=a(e),m(u.$$.fragment,e),al=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-8hpjib"&&(S.innerHTML=rt),Ml=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-68rs2x"&&(q.textContent=ct),il=a(e),m(P.$$.fragment,e),pl=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-tjmxn6"&&(D.innerHTML=dt),ol=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1319e67"&&(K.textContent=Jt),yl=a(e),m(O.$$.fragment,e),ml=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-14t9d9v"&&(ee.innerHTML=Tt),rl=a(e),m(le.$$.fragment,e),cl=a(e),m(C.$$.fragment,e),dl=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-q87di4"&&(te.innerHTML=wt),Jl=a(e),m(se.$$.fragment,e),Tl=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-fw3tvd"&&(ne.innerHTML=ft),wl=a(e),m(b.$$.fragment,e),fl=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-19tqquy"&&(ae.textContent=jt),jl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1tgl3y3"&&(Me.textContent=Ut),Ul=a(e),m(ie.$$.fragment,e),ul=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-85qz6h"&&(pe.innerHTML=ut),Cl=a(e),m(oe.$$.fragment,e),bl=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-urqb2q"&&(ye.innerHTML=Ct),Il=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-th8o9z"&&(me.textContent=bt),_l=a(e),m(re.$$.fragment,e),hl=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1xhzef1"&&(ce.textContent=It),Zl=a(e),m(de.$$.fragment,e),gl=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-4bt266"&&(Je.textContent=_t),Al=a(e),m(Te.$$.fragment,e),$l=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-xc5sk0"&&(we.textContent=ht),kl=a(e),m(fe.$$.fragment,e),Nl=a(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-dnw5aw"&&(je.innerHTML=Zt),Rl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-2rsbbb"&&(Ue.innerHTML=gt),Bl=a(e),m(ue.$$.fragment,e),Wl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1m1cooj"&&(Ce.innerHTML=At),vl=a(e),m(be.$$.fragment,e),Xl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-18oh14g"&&(Ie.innerHTML=$t),xl=a(e),m(_e.$$.fragment,e),Gl=a(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-eerkzr"&&(he.textContent=kt),Vl=a(e),m(Ze.$$.fragment,e),Yl=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1w0yfzt"&&(ge.textContent=Nt),Ql=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-xh4cqs"&&(Ae.innerHTML=Rt),Hl=a(e),m($e.$$.fragment,e),El=a(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1s3szhm"&&(ke.innerHTML=Bt),zl=a(e),m(Ne.$$.fragment,e),Fl=a(e),Be=i(e,"P",{}),xt(Be).forEach(t),this.h()},h(){Gt(o,"name","hf:doc:metadata"),Gt(o,"content",Dt)},m(e,l){zt(document.head,o),s(e,f,l),s(e,T,l),s(e,j,l),r(I,e,l),s(e,We,l),s(e,_,l),s(e,ve,l),s(e,h,l),s(e,Xe,l),s(e,Z,l),s(e,xe,l),r(g,e,l),s(e,Ge,l),s(e,A,l),s(e,Ve,l),s(e,$,l),s(e,Ye,l),r(k,e,l),s(e,Qe,l),s(e,N,l),s(e,He,l),s(e,R,l),s(e,Ee,l),s(e,B,l),s(e,ze,l),s(e,W,l),s(e,Fe,l),s(e,v,l),s(e,Le,l),r(X,e,l),s(e,Se,l),s(e,x,l),s(e,qe,l),r(G,e,l),s(e,Pe,l),s(e,V,l),s(e,De,l),r(Y,e,l),s(e,Ke,l),s(e,Q,l),s(e,Oe,l),s(e,H,l),s(e,el,l),r(E,e,l),s(e,ll,l),s(e,z,l),s(e,tl,l),r(F,e,l),s(e,sl,l),s(e,L,l),s(e,nl,l),r(u,e,l),s(e,al,l),s(e,S,l),s(e,Ml,l),s(e,q,l),s(e,il,l),r(P,e,l),s(e,pl,l),s(e,D,l),s(e,ol,l),s(e,K,l),s(e,yl,l),r(O,e,l),s(e,ml,l),s(e,ee,l),s(e,rl,l),r(le,e,l),s(e,cl,l),r(C,e,l),s(e,dl,l),s(e,te,l),s(e,Jl,l),r(se,e,l),s(e,Tl,l),s(e,ne,l),s(e,wl,l),r(b,e,l),s(e,fl,l),s(e,ae,l),s(e,jl,l),s(e,Me,l),s(e,Ul,l),r(ie,e,l),s(e,ul,l),s(e,pe,l),s(e,Cl,l),r(oe,e,l),s(e,bl,l),s(e,ye,l),s(e,Il,l),s(e,me,l),s(e,_l,l),r(re,e,l),s(e,hl,l),s(e,ce,l),s(e,Zl,l),r(de,e,l),s(e,gl,l),s(e,Je,l),s(e,Al,l),r(Te,e,l),s(e,$l,l),s(e,we,l),s(e,kl,l),r(fe,e,l),s(e,Nl,l),s(e,je,l),s(e,Rl,l),s(e,Ue,l),s(e,Bl,l),r(ue,e,l),s(e,Wl,l),s(e,Ce,l),s(e,vl,l),r(be,e,l),s(e,Xl,l),s(e,Ie,l),s(e,xl,l),r(_e,e,l),s(e,Gl,l),s(e,he,l),s(e,Vl,l),r(Ze,e,l),s(e,Yl,l),s(e,ge,l),s(e,Ql,l),s(e,Ae,l),s(e,Hl,l),r($e,e,l),s(e,El,l),s(e,ke,l),s(e,zl,l),r(Ne,e,l),s(e,Fl,l),s(e,Be,l),Ll=!0},p(e,[l]){const Wt={};l&2&&(Wt.$$scope={dirty:l,ctx:e}),u.$set(Wt);const vt={};l&2&&(vt.$$scope={dirty:l,ctx:e}),C.$set(vt);const Xt={};l&2&&(Xt.$$scope={dirty:l,ctx:e}),b.$set(Xt)},i(e){Ll||(c(I.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(G.$$.fragment,e),c(Y.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(u.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(C.$$.fragment,e),c(se.$$.fragment,e),c(b.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(Te.$$.fragment,e),c(fe.$$.fragment,e),c(ue.$$.fragment,e),c(be.$$.fragment,e),c(_e.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),c(Ne.$$.fragment,e),Ll=!0)},o(e){d(I.$$.fragment,e),d(g.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(G.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(u.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(C.$$.fragment,e),d(se.$$.fragment,e),d(b.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(ue.$$.fragment,e),d(be.$$.fragment,e),d(_e.$$.fragment,e),d(Ze.$$.fragment,e),d($e.$$.fragment,e),d(Ne.$$.fragment,e),Ll=!1},d(e){e&&(t(f),t(T),t(j),t(We),t(_),t(ve),t(h),t(Xe),t(Z),t(xe),t(Ge),t(A),t(Ve),t($),t(Ye),t(Qe),t(N),t(He),t(R),t(Ee),t(B),t(ze),t(W),t(Fe),t(v),t(Le),t(Se),t(x),t(qe),t(Pe),t(V),t(De),t(Ke),t(Q),t(Oe),t(H),t(el),t(ll),t(z),t(tl),t(sl),t(L),t(nl),t(al),t(S),t(Ml),t(q),t(il),t(pl),t(D),t(ol),t(K),t(yl),t(ml),t(ee),t(rl),t(cl),t(dl),t(te),t(Jl),t(Tl),t(ne),t(wl),t(fl),t(ae),t(jl),t(Me),t(Ul),t(ul),t(pe),t(Cl),t(bl),t(ye),t(Il),t(me),t(_l),t(hl),t(ce),t(Zl),t(gl),t(Je),t(Al),t($l),t(we),t(kl),t(Nl),t(je),t(Rl),t(Ue),t(Bl),t(Wl),t(Ce),t(vl),t(Xl),t(Ie),t(xl),t(Gl),t(he),t(Vl),t(Yl),t(ge),t(Ql),t(Ae),t(Hl),t(El),t(ke),t(zl),t(Fl),t(Be)),t(o),J(I,e),J(g,e),J(k,e),J(X,e),J(G,e),J(Y,e),J(E,e),J(F,e),J(u,e),J(P,e),J(O,e),J(le,e),J(C,e),J(se,e),J(b,e),J(ie,e),J(oe,e),J(re,e),J(de,e),J(Te,e),J(fe,e),J(ue,e),J(be,e),J(_e,e),J(Ze,e),J($e,e),J(Ne,e)}}}const Dt='{"title":"사용자 정의 모델 공유하기","local":"sharing-custom-models","sections":[{"title":"사용자 정의 구성 작성하기","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"사용자 정의 모델 작성하기","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Hub로 코드 업로드하기","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"사용자 정의 코드로 모델 사용하기","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function Kt(U){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Qt{constructor(o){super(),Ht(this,o,Kt,Pt,Vt,{})}}export{ns as component};
