import{s as vl,f as yl,n as wl,o as Tl}from"../chunks/scheduler.85c25b89.js";import{S as Ml,i as xl,g as r,s as n,r as p,A as Cl,h as i,f as a,c as l,j as y,u as c,x as d,k as b,y as s,a as o,v as m,d as h,t as f,w as g}from"../chunks/index.c142fe32.js";import{D as w}from"../chunks/Docstring.e6639b56.js";import{C as Ht}from"../chunks/CodeBlock.a5e95a57.js";import{H as v,E as Ol}from"../chunks/EditOnGithub.a592e7aa.js";function $l(nn){let U,zt,Qt,At,W,Gt,I,ln='<a href="https://huggingface.co/models?other=dpo,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-DPO-blue"/></a>',Vt,q,Xt,E,rn='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by <a href="https://huggingface.co/rmrafailov" rel="nofollow">Rafael Rafailov</a>, Archit Sharma, Eric Mitchell, <a href="https://huggingface.co/ermonste" rel="nofollow">Stefano Ermon</a>, <a href="https://huggingface.co/manning" rel="nofollow">Christopher D. Manning</a>, <a href="https://huggingface.co/cbfinn" rel="nofollow">Chelsea Finn</a>.',St,H,sn="The abstract from the paper is the following:",Yt,Q,dn="<p>While large-scale unsupervised language models (LMs) learn broad world knowledge and some reasoning skills, achieving precise control of their behavior is difficult due to the completely unsupervised nature of their training. Existing methods for gaining such steerability collect human labels of the relative quality of model generations and fine-tune the unsupervised LM to align with these preferences, often with reinforcement learning from human feedback (RLHF). However, RLHF is a complex and often unstable procedure, first fitting a reward model that reflects the human preferences, and then fine-tuning the large unsupervised LM using reinforcement learning to maximize this estimated reward without drifting too far from the original model. In this paper we introduce a new parameterization of the reward model in RLHF that enables extraction of the corresponding optimal policy in closed form, allowing us to solve the standard RLHF problem with only a simple classification loss. The resulting algorithm, which we call Direct Preference Optimization (DPO), is stable, performant, and computationally lightweight, eliminating the need for sampling from the LM during fine-tuning or performing significant hyperparameter tuning. Our experiments show that DPO can fine-tune LMs to align with human preferences as well as or better than existing methods. Notably, fine-tuning with DPO exceeds PPO-based RLHF in ability to control sentiment of generations, and matches or improves response quality in summarization and single-turn dialogue while being substantially simpler to implement and train.</p>",Kt,B,pn="The first step is to train an SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",ea,z,cn='Then, fine-tuning a language model via DPO consists of two steps and is easier than <a href="ppo_trainer">PPO</a>:',ta,A,mn='<li><strong>Data collection</strong>: Gather a <a href="dataset_formats#preference">preference dataset</a> with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>',aa,G,hn='This process is illustrated in the sketch below (from <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Figure 1 of the DPO paper</a>):',oa,V,fn='<img src="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d"/>',na,X,gn='Read more about DPO algorithm in the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">original paper</a>.',la,S,ra,Y,un='This example demonstrates how to train a model using the DPO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model. We use the preference data from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the data in the dataset here:',ia,x,_n,sa,K,bn="Below is the script to train the model:",da,ee,pa,te,vn="Execute the script using the following command:",ca,ae,ma,oe,yn="Distributed across 8 GPUs, the training takes approximately 3 minutes. You can verify the training progress by checking the reward graph. An increasing trend in the reward margin indicates that the model is improving and generating better responses over time.",ha,ne,wn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/dpo-qwen2-reward-margin.png"/>',fa,le,Tn='To see how the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-DPO" rel="nofollow">trained model</a> performs, you can use the <a href="clis#chat-interface">TRL Chat CLI</a>.',ga,re,Mn=`<code>$ trl chat --model_name_or_path trl-lib/Qwen2-0.5B-DPO
<strong><span style="color: red;">&lt;quentin_gallouedec&gt;:</span></strong>
What is the best programming language?

<strong><span style="color: blue;">&lt;trl-lib/Qwen2-0.5B-DPO&gt;:</span></strong>
The best programming language for specific applications can vary depending on the use case and knowledge level of the programmer. Here are some general factors that can be used as input to choose the best programming language:

 <strong><span style="color: green;">1</span></strong> Ease of use: Some programming languages are more user-friendly than others, such as Python, Java, or Ruby. Python is popular due to its simplicity and great scalability.
 <strong><span style="color: green;">2</span></strong> Versatility: The ability to work with a wide range of data structures and frameworks can define the language as versatile.
 <strong><span style="color: green;">3</span></strong> Ease of learning: Different programming languages have different learning curves, so users must be willing to take some time to master one.
 <strong><span style="color: green;">4</span></strong> Community support: The broader community of developers and enthusiasts in the selected programming language can provide great support and resources.
 <strong><span style="color: green;">5</span></strong> Reusability: Languages that emphasize code reuse and can be easily modifiable can be more suitable for software development.

The best programming language based on these factors is subjective and depends on what the programmer intends to accomplish.
</code>`,ua,ie,_a,se,xn='DPO requires a <a href="dataset_formats#preference">preference dataset</a>. The <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',ba,de,Cn='Although the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> supports both explicit and implicit prompts, we recommend using explicit prompts. If provided with an implicit prompt dataset, the trainer will automatically extract the prompt from the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> columns. For more information, refer to the <a href="dataset_formats#preference">preference style</a> section.',va,pe,ya,ce,On='The <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> supports fine-tuning vision-language models (VLMs). For these models, a vision dataset is required. To learn more about the specific format for vision datasets, refer to the <a href="dataset_formats#vision-datasets">Vision dataset format</a> section.',wa,me,$n="Additionally, unlike standard text-based models where a <code>tokenizer</code> is used, for VLMs, you should replace the <code>tokenizer</code> with a <code>processor</code>.",Ta,he,Ma,fe,Pn='For a complete example of fine-tuning a vision-language model, refer to the script in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo_vlm.py" rel="nofollow"><code>examples/scripts/dpo_vlm.py</code></a>.',xa,ge,Ca,ue,Un='We provide an example script to train a model using the DPO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>',Oa,_e,Dn='To test the DPO script with the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen2 0.5B model</a> on the <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">UltraFeedback dataset</a>, run the following command:',$a,be,Pa,ve,Ua,ye,Jn="While training and evaluating we record the following reward metrics:",Da,we,kn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Ja,Te,ka,Me,Fn='The DPO algorithm supports several loss functions. The loss function can be set using the <code>loss_type</code> parameter in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. The following loss functions are supported:',Fa,xe,Ln='<thead><tr><th><code>loss_type=</code></th> <th>Description</th></tr></thead> <tbody><tr><td><code>&quot;sigmoid&quot;</code> (default)</td> <td>Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.</td></tr> <tr><td><code>&quot;hinge&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. In this case, the <code>beta</code> is the reciprocal of the margin.</td></tr> <tr><td><code>&quot;ipo&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).</td></tr> <tr><td><code>&quot;exo_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. Setting non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.</td></tr> <tr><td><code>&quot;nca_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood.</td></tr> <tr><td><code>&quot;robust&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, it assumes that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0)</td></tr> <tr><td><code>&quot;bco_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. For unpaired data, we recommend the dedicated <a href="/docs/trl/main/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a>.</td></tr> <tr><td><code>&quot;sppo_hard&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser.</td></tr> <tr><td><code>&quot;aot&quot;</code>  or <code>loss_type=&quot;aot_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.</td></tr> <tr><td><code>&quot;apo_zero&quot;</code> or <code>loss_type=&quot;apo_down&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> method introduces an “anchored” version of the alignment objective. There are two variants: <code>apo_zero</code> and <code>apo_down</code>. The <code>apo_zero</code> loss increases the likelihood of winning outputs while decreasing the likelihood of losing outputs, making it suitable when the model is less performant than the winning outputs. On the other hand, <code>apo_down</code> decreases the likelihood of both winning and losing outputs, but with a stronger emphasis on reducing the likelihood of losing outputs. This variant is more effective when the model is better than the winning outputs.</td></tr></tbody>',La,Ce,ja,Oe,jn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0).',Na,$e,Ra,Pe,Nn='The <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model=True</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Za,Ue,Wa,De,Rn='The <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://huggingface.co/papers/2405.16436" rel="nofollow">paper</a> that essentially consists of a weighted SFT loss on the chosen preferences together with the DPO loss. To use this loss, set the <code>rpo_alpha</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> to an appropriate value. The paper suggests setting this weight to <code>1.0</code>.',Ia,Je,qa,ke,Zn='The <a href="https://huggingface.co/papers/2406.11827" rel="nofollow">WPO</a> paper adapts off-policy data to resemble on-policy data more closely by reweighting preference pairs according to their probability under the current policy. To use this method, set the <code>use_weighting</code> flag to <code>True</code> in the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ea,Fe,Ha,Le,Wn=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,Qa,je,In=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. <a href="https://huggingface.co/docs/transformers/main/en/model_doc/mixtral#transformers.MixtralConfig" rel="nofollow">MixtralConfig</a>).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: <code>0.001</code>) in the model config.`,Ba,Ne,za,Re,qn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',Aa,Ze,En="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Ga,We,Hn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Va,Ie,Xa,qe,Qn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Sa,Ee,Ya,He,Bn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",Ka,Qe,zn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>ref_model</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",eo,Be,to,ze,An='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',ao,Ae,Gn="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",oo,Ge,no,Ve,Vn='To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',lo,Xe,Xn="For example:",ro,Se,io,Ye,so,u,Ke,Mo,ut,Sn="Initialize DPOTrainer.",xo,D,et,Co,_t,Yn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Oo,C,tt,$o,bt,Kn="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Po,vt,el="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Uo,J,at,Do,yt,tl="Concatenate the chosen and rejected inputs into a single tensor.",Jo,k,ot,ko,wt,al="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Fo,F,nt,Lo,Tt,ol="Compute the DPO loss for a batch of policy and reference model log probabilities.",jo,O,lt,No,Mt,nl=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ro,xt,ll="Works both with or without labels.",Zo,L,rt,Wo,Ct,rl="Generate samples from the model and reference model for the given batch of inputs.",Io,T,it,qo,Ot,il="Compute the log probabilities of the given labels under the given logits.",Eo,$t,sl=`Returns
A Tuple of three tensors of shape ((batch_size,), (batch_size,), Optional[(batch_size,)]) containing:`,Ho,Pt,dl="<li>The sum of log probabilities of the given labels under the given logits.</li> <li>The number of non-masked tokens.</li> <li>The wpo weighting (if use_weighting is True, otherwise None).</li>",Qo,j,st,Bo,Ut,pl="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",zo,$,dt,Ao,Dt,cl="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Go,Jt,ml="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Vo,P,pt,Xo,kt,hl="Returns the training <code>~torch.utils.data.DataLoader</code>.",So,Ft,fl="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Yo,N,ct,Ko,Lt,gl="Log <code>logs</code> on the various objects watching training, including stored metrics.",en,R,mt,tn,jt,ul="Context manager for handling null reference model (that is, peft adapter manipulation).",po,ht,co,M,ft,an,Nt,_l='Configuration class for the <a href="/docs/trl/main/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',on,Rt,bl=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,mo,gt,ho,Bt,fo;return W=new v({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),q=new v({props:{title:"Overview",local:"overview",headingTag:"h2"}}),S=new v({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),ee=new Ht({props:{code:"JTIzJTIwdHJhaW5fZHBvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBEUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLTAuNUItRFBPJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_dpo.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2-0.5B-DPO&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = DPOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
trainer.train()`,wrap:!1}}),ae=new Ht({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2Rwby5weQ==",highlighted:"accelerate launch train_dpo.py",wrap:!1}}),ie=new v({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),pe=new v({props:{title:"Special considerations for vision-language models",local:"special-considerations-for-vision-language-models",headingTag:"h3"}}),he=new Ht({props:{code:"LSUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBLSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyQiUyMHByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQSUyMCUyMHRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQS0lMjAlMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-deletion">- model = AutoModelForCausalLM.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = AutoModelForVision2Seq.from_pretrained(model_id)</span>

<span class="hljs-deletion">- tokenizer = AutoTokenizer.from_pretrained(model_id)</span>
<span class="hljs-addition">+ processor = AutoProcessor.from_pretrained(model_id)</span>

  trainer = DPOTrainer(
      model,
      args=training_args,
      train_dataset=train_dataset,
<span class="hljs-deletion">-     processing_class=tokenizer,</span>
<span class="hljs-addition">+     processing_class=processor,</span>
)`,wrap:!1}}),ge=new v({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),be=new Ht({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmRwby5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHRybC1saWIlMkZ1bHRyYWZlZWRiYWNrX2JpbmFyaXplZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxvZ2dpbmdfc3RlcHMlMjAyNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMFF3ZW4yLTAuNUItRFBP",highlighted:`accelerate launch examples/scripts/dpo.py \\
    --model_name_or_path Qwen/Qwen2-0.5B-Instruct \\
    --dataset_name trl-lib/ultrafeedback_binarized \\
    --num_train_epochs 1 \\
    --logging_steps 25 \\
    --output_dir Qwen2-0.5B-DPO`,wrap:!1}}),ve=new v({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),Te=new v({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Ce=new v({props:{title:"Label smoothing",local:"label-smoothing",headingTag:"h3"}}),$e=new v({props:{title:"Syncing the reference model",local:"syncing-the-reference-model",headingTag:"h3"}}),Ue=new v({props:{title:"RPO loss",local:"rpo-loss",headingTag:"h3"}}),Je=new v({props:{title:"WPO loss",local:"wpo-loss",headingTag:"h3"}}),Fe=new v({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),Ne=new v({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Ie=new Ht({props:{code:"JTIwJTIwZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTIwJTIwZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEEtJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUyQiUyMGZyb20lMjB1bnNsb3RoJTIwaW1wb3J0JTIwRmFzdExhbmd1YWdlTW9kZWwlMEElMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBLSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUyQiUyMG1vZGVsJTJDJTIwdG9rZW5pemVyJTIwJTNEJTIwRmFzdExhbmd1YWdlTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwRmFzdExhbmd1YWdlTW9kZWwuZ2V0X3BlZnRfbW9kZWwobW9kZWwpJTBBJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQS0lMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJRd2VuMi0wLjVCLURQTyUyMiUyQyUyMGxvZ2dpbmdfc3RlcHMlM0QxMCklMEElMkIlMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJRd2VuMi0wLjVCLURQTyUyMiUyQyUyMGxvZ2dpbmdfc3RlcHMlM0QxMCUyQyUyMGJmMTYlM0RUcnVlKSUwQSUyMCUyMHRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEElMjAlMjB0cmFpbmVyLnRyYWluKCklMEE=",highlighted:`  from datasets import load_dataset
  from trl import DPOConfig, DPOTrainer
<span class="hljs-deletion">- from transformers import AutoModelForCausalLM, AutoTokenizer</span>
<span class="hljs-addition">+ from unsloth import FastLanguageModel</span>

<span class="hljs-deletion">- model = AutoModelForCausalLM.from_pretrained(&quot;Qwen/Qwen2-0.5B-Instruct&quot;)</span>
<span class="hljs-deletion">- tokenizer = AutoTokenizer.from_pretrained(&quot;Qwen/Qwen2-0.5B-Instruct&quot;)</span>
<span class="hljs-addition">+ model, tokenizer = FastLanguageModel.from_pretrained(&quot;Qwen/Qwen2-0.5B-Instruct&quot;)</span>
<span class="hljs-addition">+ model = FastLanguageModel.get_peft_model(model)</span>
  train_dataset = load_dataset(&quot;trl-lib/ultrafeedback_binarized&quot;, split=&quot;train&quot;)

<span class="hljs-deletion">- training_args = DPOConfig(output_dir=&quot;Qwen2-0.5B-DPO&quot;, logging_steps=10)</span>
<span class="hljs-addition">+ training_args = DPOConfig(output_dir=&quot;Qwen2-0.5B-DPO&quot;, logging_steps=10, bf16=True)</span>
  trainer = DPOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
  trainer.train()
`,wrap:!1}}),Ee=new v({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Be=new v({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),Ge=new v({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Se=new Ht({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbC4lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9oYXNfZnAxNl93ZWlnaHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaXN0cmFsYWklMkZtaXh0cmFsLTh4N2ItdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSklMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWRhcHRlci4lMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5hYmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUyMyUyMExvYWQlMjB0aGUlMjBhZGFwdGVyJTIwYSUyMHNlY29uZCUyMHRpbWUlMkMlMjB3aXRoJTIwYSUyMGRpZmZlcmVudCUyMG5hbWUlMkMlMjB3aGljaCUyMHdpbGwlMjBiZSUyMG91ciUyMHJlZmVyZW5jZSUyMG1vZGVsLiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycmVmZXJlbmNlJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjB0cmFpbmVyJTJDJTIwd2l0aG91dCUyMGElMjByZWZfbW9kZWwlMjBwYXJhbS4lMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2FkYXB0ZXJfbmFtZSUzRCUyMnRyYWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVmX2FkYXB0ZXJfbmFtZSUzRCUyMnJlZmVyZW5jZSUyMiUyQyUwQSklMEFkcG9fdHJhaW5lciUyMCUzRCUyMERQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMC4uLiUwQSk=",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Ye=new v({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Ke=new w({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"processing_class",val:": Union = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.
This supercedes the <code>tokenizer</code> argument, which is now deprecated.`,name:"processing_class"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L341"}}),et=new w({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1055"}}),tt=new w({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1375"}}),at=new w({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"is_vision_model",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1073",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),ot=new w({props:{name:"create_model_card",anchor:"trl.DPOTrainer.create_model_card",parameters:[{name:"model_name",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"tags",val:": Union = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.DPOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.DPOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>List[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1716"}}),nt=new w({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),lt=new w({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1650"}}),rt=new w({props:{name:"generate_from_model_and_ref",anchor:"trl.DPOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1565"}}),it=new w({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"},{name:"use_weighting",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1325"}}),st=new w({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1472"}}),dt=new w({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L991"}}),pt=new w({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L944"}}),ct=new w({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1700"}}),mt=new w({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1043"}}),ht=new v({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),ft=new w({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"use_weighting",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": FDivergenceType = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": float = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-6</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and
<a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between <code>0.0</code> and <code>0.5</code>.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;exo_pair&quot;</code>: pairwise EXO loss from the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> paper.</li>
<li><code>&quot;nca_pair&quot;</code>: pairwise NCA loss from the <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> paper.</li>
<li><code>&quot;robust&quot;</code>: unbiased estimate of the DPO loss that is robust to preference noise from the <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper.</li>
<li><code>&quot;bco_pair&quot;</code>: pairwise BCO loss from the <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.</li>
<li><code>&quot;sppo_hard&quot;</code>: SPPO loss with hard label from the <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> paper.</li>
<li><code>&quot;aot&quot;</code>: AOT loss for paired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;aot_pair&quot;</code>: AOT loss for unpaired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;apo_zero&quot;</code>: APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
<li><code>&quot;apo_down&quot;</code>: APO-down loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.DPOConfig.use_weighting",description:`<strong>use_weighting</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to weight the loss as done in the <a href="https://huggingface.co/papers/2406.11827" rel="nofollow">WPO</a> paper.`,name:"use_weighting"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the
default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the target. This argument is required if you want to use the default data collator and
your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.DPOConfig.is_encoder_decoder(Optional[int],",description:`<strong>is_encoder_decoder(<code>Optional[int]</code>,</strong> <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder(Optional[int],"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model and reference model.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal
probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the
ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
Type of f-divergence regularization function to compute divergence between policy and reference model.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
&#x3B1; coefficient in the &#x3B1;-divergence u^-&#x3B1; regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When set to <code>True</code>, the reference model is synchronized with the active model every <code>ref_model_sync_steps</code>
steps, using the <code>ref_model_mixup_alpha</code> parameter. This synchronization originites from the
<a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.9</code>) &#x2014;
&#x3B1; parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper, which controls the mix
between the current policy and the previous reference policy during updates. The reference policy is
updated according to the equation: <code>&#x3C0;_ref = &#x3B1; * &#x3C0;_&#x3B8; + (1 - &#x3B1;) * &#x3C0;_ref_prev</code>
To use this parameter, you must set <code>sync_ref_model=True</code>.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>64</code>) &#x2014;
&#x3C4; parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper, which determines how
frequently the current policy is synchronized with the reference policy. To use this parameter, you must
set <code>sync_ref_model=True</code>.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
&#x3B1; parameter from the <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper (v3), which controls the
weighting of the NLL term in the loss. If <code>None</code>, no weighting is applied and the loss is the same as the
DPO loss. The paper recommends <code>rpo_alpha=1.0</code>.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_config.py#L33"}}),gt=new Ol({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){U=r("meta"),zt=n(),Qt=r("p"),At=n(),p(W.$$.fragment),Gt=n(),I=r("p"),I.innerHTML=ln,Vt=n(),p(q.$$.fragment),Xt=n(),E=r("p"),E.innerHTML=rn,St=n(),H=r("p"),H.textContent=sn,Yt=n(),Q=r("blockquote"),Q.innerHTML=dn,Kt=n(),B=r("p"),B.textContent=pn,ea=n(),z=r("p"),z.innerHTML=cn,ta=n(),A=r("ol"),A.innerHTML=mn,aa=n(),G=r("p"),G.innerHTML=hn,oa=n(),V=r("p"),V.innerHTML=fn,na=n(),X=r("p"),X.innerHTML=gn,la=n(),p(S.$$.fragment),ra=n(),Y=r("p"),Y.innerHTML=un,ia=n(),x=r("iframe"),sa=n(),K=r("p"),K.textContent=bn,da=n(),p(ee.$$.fragment),pa=n(),te=r("p"),te.textContent=vn,ca=n(),p(ae.$$.fragment),ma=n(),oe=r("p"),oe.textContent=yn,ha=n(),ne=r("p"),ne.innerHTML=wn,fa=n(),le=r("p"),le.innerHTML=Tn,ga=n(),re=r("pre"),re.innerHTML=Mn,ua=n(),p(ie.$$.fragment),_a=n(),se=r("p"),se.innerHTML=xn,ba=n(),de=r("p"),de.innerHTML=Cn,va=n(),p(pe.$$.fragment),ya=n(),ce=r("p"),ce.innerHTML=On,wa=n(),me=r("p"),me.innerHTML=$n,Ta=n(),p(he.$$.fragment),Ma=n(),fe=r("p"),fe.innerHTML=Pn,xa=n(),p(ge.$$.fragment),Ca=n(),ue=r("p"),ue.innerHTML=Un,Oa=n(),_e=r("p"),_e.innerHTML=Dn,$a=n(),p(be.$$.fragment),Pa=n(),p(ve.$$.fragment),Ua=n(),ye=r("p"),ye.textContent=Jn,Da=n(),we=r("ul"),we.innerHTML=kn,Ja=n(),p(Te.$$.fragment),ka=n(),Me=r("p"),Me.innerHTML=Fn,Fa=n(),xe=r("table"),xe.innerHTML=Ln,La=n(),p(Ce.$$.fragment),ja=n(),Oe=r("p"),Oe.innerHTML=jn,Na=n(),p($e.$$.fragment),Ra=n(),Pe=r("p"),Pe.innerHTML=Nn,Za=n(),p(Ue.$$.fragment),Wa=n(),De=r("p"),De.innerHTML=Rn,Ia=n(),p(Je.$$.fragment),qa=n(),ke=r("p"),ke.innerHTML=Zn,Ea=n(),p(Fe.$$.fragment),Ha=n(),Le=r("p"),Le.innerHTML=Wn,Qa=n(),je=r("p"),je.innerHTML=In,Ba=n(),p(Ne.$$.fragment),za=n(),Re=r("p"),Re.innerHTML=qn,Aa=n(),Ze=r("table"),Ze.innerHTML=En,Ga=n(),We=r("p"),We.innerHTML=Hn,Va=n(),p(Ie.$$.fragment),Xa=n(),qe=r("p"),qe.innerHTML=Qn,Sa=n(),p(Ee.$$.fragment),Ya=n(),He=r("p"),He.textContent=Bn,Ka=n(),Qe=r("ol"),Qe.innerHTML=zn,eo=n(),p(Be.$$.fragment),to=n(),ze=r("p"),ze.innerHTML=An,ao=n(),Ae=r("p"),Ae.textContent=Gn,oo=n(),p(Ge.$$.fragment),no=n(),Ve=r("p"),Ve.innerHTML=Vn,lo=n(),Xe=r("p"),Xe.textContent=Xn,ro=n(),p(Se.$$.fragment),io=n(),p(Ye.$$.fragment),so=n(),u=r("div"),p(Ke.$$.fragment),Mo=n(),ut=r("p"),ut.textContent=Sn,xo=n(),D=r("div"),p(et.$$.fragment),Co=n(),_t=r("p"),_t.textContent=Yn,Oo=n(),C=r("div"),p(tt.$$.fragment),$o=n(),bt=r("p"),bt.textContent=Kn,Po=n(),vt=r("p"),vt.textContent=el,Uo=n(),J=r("div"),p(at.$$.fragment),Do=n(),yt=r("p"),yt.textContent=tl,Jo=n(),k=r("div"),p(ot.$$.fragment),ko=n(),wt=r("p"),wt.innerHTML=al,Fo=n(),F=r("div"),p(nt.$$.fragment),Lo=n(),Tt=r("p"),Tt.textContent=ol,jo=n(),O=r("div"),p(lt.$$.fragment),No=n(),Mt=r("p"),Mt.innerHTML=nl,Ro=n(),xt=r("p"),xt.textContent=ll,Zo=n(),L=r("div"),p(rt.$$.fragment),Wo=n(),Ct=r("p"),Ct.textContent=rl,Io=n(),T=r("div"),p(it.$$.fragment),qo=n(),Ot=r("p"),Ot.textContent=il,Eo=n(),$t=r("p"),$t.textContent=sl,Ho=n(),Pt=r("ul"),Pt.innerHTML=dl,Qo=n(),j=r("div"),p(st.$$.fragment),Bo=n(),Ut=r("p"),Ut.textContent=pl,zo=n(),$=r("div"),p(dt.$$.fragment),Ao=n(),Dt=r("p"),Dt.innerHTML=cl,Go=n(),Jt=r("p"),Jt.innerHTML=ml,Vo=n(),P=r("div"),p(pt.$$.fragment),Xo=n(),kt=r("p"),kt.innerHTML=hl,So=n(),Ft=r("p"),Ft.innerHTML=fl,Yo=n(),N=r("div"),p(ct.$$.fragment),Ko=n(),Lt=r("p"),Lt.innerHTML=gl,en=n(),R=r("div"),p(mt.$$.fragment),tn=n(),jt=r("p"),jt.textContent=ul,po=n(),p(ht.$$.fragment),co=n(),M=r("div"),p(ft.$$.fragment),an=n(),Nt=r("p"),Nt.innerHTML=_l,on=n(),Rt=r("p"),Rt.innerHTML=bl,mo=n(),p(gt.$$.fragment),ho=n(),Bt=r("p"),this.h()},l(e){const t=Cl("svelte-u9bgzb",document.head);U=i(t,"META",{name:!0,content:!0}),t.forEach(a),zt=l(e),Qt=i(e,"P",{}),y(Qt).forEach(a),At=l(e),c(W.$$.fragment,e),Gt=l(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1phtljg"&&(I.innerHTML=ln),Vt=l(e),c(q.$$.fragment,e),Xt=l(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-z3e1vo"&&(E.innerHTML=rn),St=l(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-vfdo9a"&&(H.textContent=sn),Yt=l(e),Q=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(Q)!=="svelte-79s4co"&&(Q.innerHTML=dn),Kt=l(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-nj0mw8"&&(B.textContent=pn),ea=l(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1shy0cc"&&(z.innerHTML=cn),ta=l(e),A=i(e,"OL",{"data-svelte-h":!0}),d(A)!=="svelte-191izpi"&&(A.innerHTML=mn),aa=l(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-12mg2q5"&&(G.innerHTML=hn),oa=l(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1281kkc"&&(V.innerHTML=fn),na=l(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-16acsjo"&&(X.innerHTML=gn),la=l(e),c(S.$$.fragment,e),ra=l(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-hit9c8"&&(Y.innerHTML=un),ia=l(e),x=i(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),y(x).forEach(a),sa=l(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-uqytq6"&&(K.textContent=bn),da=l(e),c(ee.$$.fragment,e),pa=l(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-15hino8"&&(te.textContent=vn),ca=l(e),c(ae.$$.fragment,e),ma=l(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-yajp6a"&&(oe.textContent=yn),ha=l(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-4zuv47"&&(ne.innerHTML=wn),fa=l(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-kj7i7s"&&(le.innerHTML=Tn),ga=l(e),re=i(e,"PRE",{"data-svelte-h":!0}),d(re)!=="svelte-1d8earv"&&(re.innerHTML=Mn),ua=l(e),c(ie.$$.fragment,e),_a=l(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1014eh0"&&(se.innerHTML=xn),ba=l(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1v5f57c"&&(de.innerHTML=Cn),va=l(e),c(pe.$$.fragment,e),ya=l(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-124rokg"&&(ce.innerHTML=On),wa=l(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1641qgj"&&(me.innerHTML=$n),Ta=l(e),c(he.$$.fragment,e),Ma=l(e),fe=i(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-112nfxj"&&(fe.innerHTML=Pn),xa=l(e),c(ge.$$.fragment,e),Ca=l(e),ue=i(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1k7pp2t"&&(ue.innerHTML=Un),Oa=l(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-ob6zvc"&&(_e.innerHTML=Dn),$a=l(e),c(be.$$.fragment,e),Pa=l(e),c(ve.$$.fragment,e),Ua=l(e),ye=i(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-132s7j9"&&(ye.textContent=Jn),Da=l(e),we=i(e,"UL",{"data-svelte-h":!0}),d(we)!=="svelte-1oji3mm"&&(we.innerHTML=kn),Ja=l(e),c(Te.$$.fragment,e),ka=l(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-tmttss"&&(Me.innerHTML=Fn),Fa=l(e),xe=i(e,"TABLE",{"data-svelte-h":!0}),d(xe)!=="svelte-15d7j98"&&(xe.innerHTML=Ln),La=l(e),c(Ce.$$.fragment,e),ja=l(e),Oe=i(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1t8obhw"&&(Oe.innerHTML=jn),Na=l(e),c($e.$$.fragment,e),Ra=l(e),Pe=i(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1sifkns"&&(Pe.innerHTML=Nn),Za=l(e),c(Ue.$$.fragment,e),Wa=l(e),De=i(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1wb7wca"&&(De.innerHTML=Rn),Ia=l(e),c(Je.$$.fragment,e),qa=l(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-15e9h0w"&&(ke.innerHTML=Zn),Ea=l(e),c(Fe.$$.fragment,e),Ha=l(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-14px1ga"&&(Le.innerHTML=Wn),Qa=l(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-11it1aj"&&(je.innerHTML=In),Ba=l(e),c(Ne.$$.fragment,e),za=l(e),Re=i(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-2145zu"&&(Re.innerHTML=qn),Aa=l(e),Ze=i(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-435mua"&&(Ze.innerHTML=En),Ga=l(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1p74c9x"&&(We.innerHTML=Hn),Va=l(e),c(Ie.$$.fragment,e),Xa=l(e),qe=i(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1o18rwj"&&(qe.innerHTML=Qn),Sa=l(e),c(Ee.$$.fragment,e),Ya=l(e),He=i(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-4infz6"&&(He.textContent=Bn),Ka=l(e),Qe=i(e,"OL",{"data-svelte-h":!0}),d(Qe)!=="svelte-4ytutj"&&(Qe.innerHTML=zn),eo=l(e),c(Be.$$.fragment,e),to=l(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-rqj7uy"&&(ze.innerHTML=An),ao=l(e),Ae=i(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1xhv3st"&&(Ae.textContent=Gn),oo=l(e),c(Ge.$$.fragment,e),no=l(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-v40bvb"&&(Ve.innerHTML=Vn),lo=l(e),Xe=i(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1gkqha7"&&(Xe.textContent=Xn),ro=l(e),c(Se.$$.fragment,e),io=l(e),c(Ye.$$.fragment,e),so=l(e),u=i(e,"DIV",{class:!0});var _=y(u);c(Ke.$$.fragment,_),Mo=l(_),ut=i(_,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-n6cc8y"&&(ut.textContent=Sn),xo=l(_),D=i(_,"DIV",{class:!0});var go=y(D);c(et.$$.fragment,go),Co=l(go),_t=i(go,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-10t1062"&&(_t.textContent=Yn),go.forEach(a),Oo=l(_),C=i(_,"DIV",{class:!0});var Zt=y(C);c(tt.$$.fragment,Zt),$o=l(Zt),bt=i(Zt,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-16i1nac"&&(bt.textContent=Kn),Po=l(Zt),vt=i(Zt,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-tgti68"&&(vt.textContent=el),Zt.forEach(a),Uo=l(_),J=i(_,"DIV",{class:!0});var uo=y(J);c(at.$$.fragment,uo),Do=l(uo),yt=i(uo,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1cvsgkk"&&(yt.textContent=tl),uo.forEach(a),Jo=l(_),k=i(_,"DIV",{class:!0});var _o=y(k);c(ot.$$.fragment,_o),ko=l(_o),wt=i(_o,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1mh859w"&&(wt.innerHTML=al),_o.forEach(a),Fo=l(_),F=i(_,"DIV",{class:!0});var bo=y(F);c(nt.$$.fragment,bo),Lo=l(bo),Tt=i(bo,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-ymgxq7"&&(Tt.textContent=ol),bo.forEach(a),jo=l(_),O=i(_,"DIV",{class:!0});var Wt=y(O);c(lt.$$.fragment,Wt),No=l(Wt),Mt=i(Wt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-8qlty5"&&(Mt.innerHTML=nl),Ro=l(Wt),xt=i(Wt,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1tyo99t"&&(xt.textContent=ll),Wt.forEach(a),Zo=l(_),L=i(_,"DIV",{class:!0});var vo=y(L);c(rt.$$.fragment,vo),Wo=l(vo),Ct=i(vo,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-18uwvbi"&&(Ct.textContent=rl),vo.forEach(a),Io=l(_),T=i(_,"DIV",{class:!0});var Z=y(T);c(it.$$.fragment,Z),qo=l(Z),Ot=i(Z,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-4nmimv"&&(Ot.textContent=il),Eo=l(Z),$t=i(Z,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1bets9r"&&($t.textContent=sl),Ho=l(Z),Pt=i(Z,"UL",{"data-svelte-h":!0}),d(Pt)!=="svelte-1qxj4bm"&&(Pt.innerHTML=dl),Z.forEach(a),Qo=l(_),j=i(_,"DIV",{class:!0});var yo=y(j);c(st.$$.fragment,yo),Bo=l(yo),Ut=i(yo,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-11q8u7l"&&(Ut.textContent=pl),yo.forEach(a),zo=l(_),$=i(_,"DIV",{class:!0});var It=y($);c(dt.$$.fragment,It),Ao=l(It),Dt=i(It,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-xesobz"&&(Dt.innerHTML=cl),Go=l(It),Jt=i(It,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-qg43tm"&&(Jt.innerHTML=ml),It.forEach(a),Vo=l(_),P=i(_,"DIV",{class:!0});var qt=y(P);c(pt.$$.fragment,qt),Xo=l(qt),kt=i(qt,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-dkae9b"&&(kt.innerHTML=hl),So=l(qt),Ft=i(qt,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-hmd5cw"&&(Ft.innerHTML=fl),qt.forEach(a),Yo=l(_),N=i(_,"DIV",{class:!0});var wo=y(N);c(ct.$$.fragment,wo),Ko=l(wo),Lt=i(wo,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-nqksfz"&&(Lt.innerHTML=gl),wo.forEach(a),en=l(_),R=i(_,"DIV",{class:!0});var To=y(R);c(mt.$$.fragment,To),tn=l(To),jt=i(To,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-17kjsy4"&&(jt.textContent=ul),To.forEach(a),_.forEach(a),po=l(e),c(ht.$$.fragment,e),co=l(e),M=i(e,"DIV",{class:!0});var Et=y(M);c(ft.$$.fragment,Et),an=l(Et),Nt=i(Et,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-u2mn4r"&&(Nt.innerHTML=_l),on=l(Et),Rt=i(Et,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-ekuf1t"&&(Rt.innerHTML=bl),Et.forEach(a),mo=l(e),c(gt.$$.fragment,e),ho=l(e),Bt=i(e,"P",{}),y(Bt).forEach(a),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",Pl),yl(x.src,_n="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized/embed/viewer/default/train?row=0")||b(x,"src",_n),b(x,"frameborder","0"),b(x,"width","100%"),b(x,"height","560px"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,U),o(e,zt,t),o(e,Qt,t),o(e,At,t),m(W,e,t),o(e,Gt,t),o(e,I,t),o(e,Vt,t),m(q,e,t),o(e,Xt,t),o(e,E,t),o(e,St,t),o(e,H,t),o(e,Yt,t),o(e,Q,t),o(e,Kt,t),o(e,B,t),o(e,ea,t),o(e,z,t),o(e,ta,t),o(e,A,t),o(e,aa,t),o(e,G,t),o(e,oa,t),o(e,V,t),o(e,na,t),o(e,X,t),o(e,la,t),m(S,e,t),o(e,ra,t),o(e,Y,t),o(e,ia,t),o(e,x,t),o(e,sa,t),o(e,K,t),o(e,da,t),m(ee,e,t),o(e,pa,t),o(e,te,t),o(e,ca,t),m(ae,e,t),o(e,ma,t),o(e,oe,t),o(e,ha,t),o(e,ne,t),o(e,fa,t),o(e,le,t),o(e,ga,t),o(e,re,t),o(e,ua,t),m(ie,e,t),o(e,_a,t),o(e,se,t),o(e,ba,t),o(e,de,t),o(e,va,t),m(pe,e,t),o(e,ya,t),o(e,ce,t),o(e,wa,t),o(e,me,t),o(e,Ta,t),m(he,e,t),o(e,Ma,t),o(e,fe,t),o(e,xa,t),m(ge,e,t),o(e,Ca,t),o(e,ue,t),o(e,Oa,t),o(e,_e,t),o(e,$a,t),m(be,e,t),o(e,Pa,t),m(ve,e,t),o(e,Ua,t),o(e,ye,t),o(e,Da,t),o(e,we,t),o(e,Ja,t),m(Te,e,t),o(e,ka,t),o(e,Me,t),o(e,Fa,t),o(e,xe,t),o(e,La,t),m(Ce,e,t),o(e,ja,t),o(e,Oe,t),o(e,Na,t),m($e,e,t),o(e,Ra,t),o(e,Pe,t),o(e,Za,t),m(Ue,e,t),o(e,Wa,t),o(e,De,t),o(e,Ia,t),m(Je,e,t),o(e,qa,t),o(e,ke,t),o(e,Ea,t),m(Fe,e,t),o(e,Ha,t),o(e,Le,t),o(e,Qa,t),o(e,je,t),o(e,Ba,t),m(Ne,e,t),o(e,za,t),o(e,Re,t),o(e,Aa,t),o(e,Ze,t),o(e,Ga,t),o(e,We,t),o(e,Va,t),m(Ie,e,t),o(e,Xa,t),o(e,qe,t),o(e,Sa,t),m(Ee,e,t),o(e,Ya,t),o(e,He,t),o(e,Ka,t),o(e,Qe,t),o(e,eo,t),m(Be,e,t),o(e,to,t),o(e,ze,t),o(e,ao,t),o(e,Ae,t),o(e,oo,t),m(Ge,e,t),o(e,no,t),o(e,Ve,t),o(e,lo,t),o(e,Xe,t),o(e,ro,t),m(Se,e,t),o(e,io,t),m(Ye,e,t),o(e,so,t),o(e,u,t),m(Ke,u,null),s(u,Mo),s(u,ut),s(u,xo),s(u,D),m(et,D,null),s(D,Co),s(D,_t),s(u,Oo),s(u,C),m(tt,C,null),s(C,$o),s(C,bt),s(C,Po),s(C,vt),s(u,Uo),s(u,J),m(at,J,null),s(J,Do),s(J,yt),s(u,Jo),s(u,k),m(ot,k,null),s(k,ko),s(k,wt),s(u,Fo),s(u,F),m(nt,F,null),s(F,Lo),s(F,Tt),s(u,jo),s(u,O),m(lt,O,null),s(O,No),s(O,Mt),s(O,Ro),s(O,xt),s(u,Zo),s(u,L),m(rt,L,null),s(L,Wo),s(L,Ct),s(u,Io),s(u,T),m(it,T,null),s(T,qo),s(T,Ot),s(T,Eo),s(T,$t),s(T,Ho),s(T,Pt),s(u,Qo),s(u,j),m(st,j,null),s(j,Bo),s(j,Ut),s(u,zo),s(u,$),m(dt,$,null),s($,Ao),s($,Dt),s($,Go),s($,Jt),s(u,Vo),s(u,P),m(pt,P,null),s(P,Xo),s(P,kt),s(P,So),s(P,Ft),s(u,Yo),s(u,N),m(ct,N,null),s(N,Ko),s(N,Lt),s(u,en),s(u,R),m(mt,R,null),s(R,tn),s(R,jt),o(e,po,t),m(ht,e,t),o(e,co,t),o(e,M,t),m(ft,M,null),s(M,an),s(M,Nt),s(M,on),s(M,Rt),o(e,mo,t),m(gt,e,t),o(e,ho,t),o(e,Bt,t),fo=!0},p:wl,i(e){fo||(h(W.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(Ue.$$.fragment,e),h(Je.$$.fragment,e),h(Fe.$$.fragment,e),h(Ne.$$.fragment,e),h(Ie.$$.fragment,e),h(Ee.$$.fragment,e),h(Be.$$.fragment,e),h(Ge.$$.fragment,e),h(Se.$$.fragment,e),h(Ye.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(lt.$$.fragment,e),h(rt.$$.fragment,e),h(it.$$.fragment,e),h(st.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(ft.$$.fragment,e),h(gt.$$.fragment,e),fo=!0)},o(e){f(W.$$.fragment,e),f(q.$$.fragment,e),f(S.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(Ue.$$.fragment,e),f(Je.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Ee.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Ye.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(lt.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(st.$$.fragment,e),f(dt.$$.fragment,e),f(pt.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),f(gt.$$.fragment,e),fo=!1},d(e){e&&(a(zt),a(Qt),a(At),a(Gt),a(I),a(Vt),a(Xt),a(E),a(St),a(H),a(Yt),a(Q),a(Kt),a(B),a(ea),a(z),a(ta),a(A),a(aa),a(G),a(oa),a(V),a(na),a(X),a(la),a(ra),a(Y),a(ia),a(x),a(sa),a(K),a(da),a(pa),a(te),a(ca),a(ma),a(oe),a(ha),a(ne),a(fa),a(le),a(ga),a(re),a(ua),a(_a),a(se),a(ba),a(de),a(va),a(ya),a(ce),a(wa),a(me),a(Ta),a(Ma),a(fe),a(xa),a(Ca),a(ue),a(Oa),a(_e),a($a),a(Pa),a(Ua),a(ye),a(Da),a(we),a(Ja),a(ka),a(Me),a(Fa),a(xe),a(La),a(ja),a(Oe),a(Na),a(Ra),a(Pe),a(Za),a(Wa),a(De),a(Ia),a(qa),a(ke),a(Ea),a(Ha),a(Le),a(Qa),a(je),a(Ba),a(za),a(Re),a(Aa),a(Ze),a(Ga),a(We),a(Va),a(Xa),a(qe),a(Sa),a(Ya),a(He),a(Ka),a(Qe),a(eo),a(to),a(ze),a(ao),a(Ae),a(oo),a(no),a(Ve),a(lo),a(Xe),a(ro),a(io),a(so),a(u),a(po),a(co),a(M),a(mo),a(ho),a(Bt)),a(U),g(W,e),g(q,e),g(S,e),g(ee,e),g(ae,e),g(ie,e),g(pe,e),g(he,e),g(ge,e),g(be,e),g(ve,e),g(Te,e),g(Ce,e),g($e,e),g(Ue,e),g(Je,e),g(Fe,e),g(Ne,e),g(Ie,e),g(Ee,e),g(Be,e),g(Ge,e),g(Se,e),g(Ye,e),g(Ke),g(et),g(tt),g(at),g(ot),g(nt),g(lt),g(rt),g(it),g(st),g(dt),g(pt),g(ct),g(mt),g(ht,e),g(ft),g(gt,e)}}}const Pl='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset type","local":"expected-dataset-type","sections":[{"title":"Special considerations for vision-language models","local":"special-considerations-for-vision-language-models","sections":[],"depth":3}],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"Label smoothing","local":"label-smoothing","sections":[],"depth":3},{"title":"Syncing the reference model","local":"syncing-the-reference-model","sections":[],"depth":3},{"title":"RPO loss","local":"rpo-loss","sections":[],"depth":3},{"title":"WPO loss","local":"wpo-loss","sections":[],"depth":3},{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function Ul(nn){return Tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends Ml{constructor(U){super(),xl(this,U,Ul,$l,vl,{})}}export{jl as component};
