import{s as ss,n as as,o as ns}from"../chunks/scheduler.defa9a21.js";import{S as is,i as os,g as i,s as a,r as p,A as rs,h as o,f as t,c as n,j as ts,u as M,x as r,k as u,y as ps,a as s,v as c,d,t as m,w as y}from"../chunks/index.fe795e71.js";import{C as h}from"../chunks/CodeBlock.204b6c34.js";import{H as T,E as Ms}from"../chunks/index.2bede162.js";function cs(dt){let U,He,Fe,Ee,G,Le,X,mt=`<a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> enables training large transformer language models at scale.
It provides efficient tensor, pipeline and sequence based model parallelism for pre-training transformer based
Language Models such as <a href="https://arxiv.org/abs/2005.14165" rel="nofollow">GPT</a> (Decoder Only), <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT</a> (Encoder Only) and <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">T5</a> (Encoder-Decoder).
For detailed information and how things work behind the scene please refer the github <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">repo</a>.`,Qe,k,xe,W,yt=`Accelerate integrates following feature of Megatron-LM to enable large scale pre-training/finetuning
of BERT (Encoder), GPT (Decoder) or T5 models (Encoder and Decoder):`,Se,v,ht=`a. <strong>Tensor Parallelism (TP)</strong>: Reduces memory footprint without much additional communication on intra-node ranks.
Each tensor is split into multiple chunks with each shard residing on separate GPU. At each step, the same mini-batch of data is processed
independently and in parallel by each shard followed by syncing across all GPUs (<code>all-reduce</code> operation).
In a simple transformer layer, this leads to 2 <code>all-reduces</code> in the forward path and 2 in the backward path.
For more details, please refer research paper <a href="https://arxiv.org/pdf/1909.08053.pdf" rel="nofollow">Megatron-LM: Training Multi-Billion Parameter Language Models Using
Model Parallelism</a> and
this section of blogpost <a href="https://huggingface.co/blog/bloom-megatron-deepspeed#tensor-parallelism" rel="nofollow">The Technology Behind BLOOM Training</a>.`,$e,R,ut=`b. <strong>Pipeline Parallelism (PP)</strong>: Reduces memory footprint and enables large scale training via inter-node parallelization.
Reduces the bubble of naive PP via PipeDream-Flush schedule/1F1B schedule and Interleaved 1F1B schedule.
Layers are distributed uniformly across PP stages. For example, if a model has <code>24</code> layers and we have <code>4</code> GPUs for
pipeline parallelism, each GPU will have <code>6</code> layers (24/4). For more details on schedules to reduce the idle time of PP,
please refer to the research paper <a href="https://arxiv.org/pdf/2104.04473.pdf" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters
Using Megatron-LM</a> and
this section of blogpost <a href="https://huggingface.co/blog/bloom-megatron-deepspeed#pipeline-parallelism" rel="nofollow">The Technology Behind BLOOM Training</a>.`,qe,V,Ut=`c. <strong>Sequence Parallelism (SP)</strong>: Reduces memory footprint without any additional communication. Only applicable when using TP.
It reduces activation memory required as it prevents the same copies to be on the tensor parallel ranks
post <code>all-reduce</code> by replacing then with <code>reduce-scatter</code> and <code>no-op</code> operation would be replaced by <code>all-gather</code>.
As <code>all-reduce = reduce-scatter + all-gather</code>, this saves a ton of activation memory at no added communication cost.
To put it simply, it shards the outputs of each transformer layer along sequence dimension, e.g.,
if the sequence length is <code>1024</code> and the TP size is <code>4</code>, each GPU will have <code>256</code> tokens (1024/4) for each sample.
This increases the batch size that can be supported for training. For more details, please refer to the research paper
<a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Reducing Activation Recomputation in Large Transformer Models</a>.`,Pe,N,Tt=`d. <strong>Data Parallelism (DP)</strong> via Distributed Optimizer: Reduces the memory footprint by sharding optimizer states and gradients across DP ranks
(versus the traditional method of replicating the optimizer state across data parallel ranks).
For example, when using Adam optimizer with mixed-precision training, each parameter accounts for 12 bytes of memory.
This gets distributed equally across the GPUs, i.e., each parameter would account for 3 bytes (12/4) if we have 4 GPUs.
For more details, please refer the research paper <a href="https://arxiv.org/pdf/1910.02054.pdf" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion
Parameter Models</a> and following section of blog
<a href="https://huggingface.co/blog/bloom-megatron-deepspeed#zero-data-parallelism" rel="nofollow">The Technology Behind BLOOM Training</a>.`,De,z,Jt=`e. <strong>Selective Activation Recomputation</strong>: Reduces the memory footprint of activations significantly via smart activation checkpointing.
It doesn’t store activations occupying large memory while being fast to recompute thereby achieving great tradeoff between memory and recomputation.
For example, for GPT-3, this leads to 70% reduction in required memory for activations at the expense of
only 2.7% FLOPs overhead for recomputation of activations. For more details, please refer to the research paper
<a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Reducing Activation Recomputation in Large Transformer Models</a>.`,Oe,Y,wt=`f. <strong>Fused Kernels</strong>: Fused Softmax, Mixed Precision Fused Layer Norm and  Fused gradient accumulation to weight gradient computation of linear layer.
PyTorch JIT compiled Fused GeLU and Fused Bias+Dropout+Residual addition.`,Ke,F,bt="g. <strong>Support for Indexed datasets</strong>: Efficient binary format of datasets for large scale training. Support for the <code>mmap</code>, <code>cached</code> index file and the <code>lazy</code> loader format.",el,A,jt=`h. <strong>Checkpoint reshaping and interoperability</strong>: Utility for reshaping Megatron-LM checkpoints of variable
tensor and pipeline parallel sizes to the beloved Transformers sharded checkpoints as it has great support with plethora of tools
such as Accelerate Big Model Inference, Megatron-DeepSpeed Inference etc.
Support is also available for converting Transformers sharded checkpoints to Megatron-LM checkpoint of variable tensor and pipeline parallel sizes
for large scale training.`,ll,H,tl,E,gt=`You will need to install the latest pytorch, cuda, nccl, and NVIDIA <a href="https://github.com/NVIDIA/apex#quick-start" rel="nofollow">APEX</a> releases and the nltk library.
See <a href="https://github.com/NVIDIA/Megatron-LM#setup" rel="nofollow">documentation</a> for more details.
Another way to setup the environment is to pull an NVIDIA PyTorch Container that comes with all the required installations from NGC.`,sl,L,ft="Below is a step-by-step method to set up the conda environment:",al,Q,_t="<li>Create a virtual environment</li>",nl,x,il,J,It="<li>Assuming that the machine has CUDA 11.3 installed, installing the corresponding PyTorch GPU Version</li>",ol,S,rl,w,Ct="<li>Install Nvidia APEX</li>",pl,$,Ml,b,Zt="<li>Installing Megatron-LM</li>",cl,q,dl,P,ml,D,Bt=`Important features are directly supported via the <code>accelerate config</code> command.
An example of the corresponding questions for using Megatron-LM features is shown below:`,yl,O,hl,K,Gt="The resulting config is shown below:",ul,ee,Ul,le,Xt=`We will take the example of GPT pre-training. The minimal changes required to the official <code>run_clm_no_trainer.py</code>
to use Megatron-LM are as follows:`,Tl,te,kt=`<li>As Megatron-LM uses its own implementation of Optimizer, the corresponding scheduler compatible with it needs to be used.
As such, support for only the Megatron-LM’s scheduler is present. User will need to create <code>accelerate.utils.MegatronLMDummyScheduler</code>.
Example is given below:</li>`,Jl,se,wl,j,Wt=`<li>Getting the details of the total batch size now needs to be cognization of tensor and pipeline parallel sizes.
Example of getting the effective total batch size is shown below:</li>`,bl,ae,jl,g,vt="<li>When using Megatron-LM, the losses are already averaged across the data parallel group</li>",gl,ne,fl,f,Rt="<li>For Megatron-LM, we need to save the model using <code>accelerator.save_state</code></li>",_l,ie,Il,oe,Vt=`That’s it! We are good to go 🚀. Please find the example script in the examples folder at the path <code>accelerate/examples/by_feature/megatron_lm_gpt_pretraining.py</code>.
Let’s run it for <code>gpt-large</code> model architecture using 4 A100-80GB GPUs.`,Cl,re,Zl,pe,Nt="Below are some important excerpts from the output logs:",Bl,Me,Gl,ce,zt="There are a large number of other options/features that one can set using <code>accelerate.utils.MegatronLMPlugin</code>.",Xl,de,kl,me,Yt="For leveraging more features, please go through below details.",Wl,ye,Ft=`<li>Below is an example of changes required to customize the Train Step while using Megatron-LM.
You will implement the <code>accelerate.utils.AbstractTrainStep</code> or inherit from their corresponding children
<code>accelerate.utils.GPTTrainStep</code>, <code>accelerate.utils.BertTrainStep</code> or <code>accelerate.utils.T5TrainStep</code>.</li>`,vl,he,Rl,_,At=`<li>For using the Megatron-LM datasets, a few more changes are required. Dataloaders for these datasets
are available only on rank 0 of each tensor parallel group. As such, there are rank where dataloader won’t be
available and this requires tweaks to the training loop. Being able to do all this shows how
flexible and extensible Accelerate is. The changes required are as follows.</li>`,Vl,ue,Ht=`a. For Megatron-LM indexed datasets, we need to use <code>MegatronLMDummyDataLoader</code>
and pass the required dataset args to it such as <code>data_path</code>, <code>seq_length</code> etc.
See <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/arguments.py#L804" rel="nofollow">here</a> for the list of available args.`,Nl,Ue,zl,Te,Et=`b. <code>megatron_dataloader</code> is repeated 3 times to get training, validation and test dataloaders
as per the <code>args.splits_string</code> proportions`,Yl,Je,Fl,we,Lt=`c. Changes to training and evaluation loops as dataloader is only available on tensor parallel ranks 0
So, we need to iterate only if the dataloader isn’t <code>None</code> else provide empty dict
As such, we loop using <code>while</code> loop and break when <code>completed_steps</code> is equal to <code>args.max_train_steps</code>
This is similar to the Megatron-LM setup wherein user has to provide <code>max_train_steps</code> when using Megaton-LM indexed datasets.
This displays how flexible and extensible Accelerate is.`,Al,be,Hl,je,El,ge,Qt=`<li><p>The scripts for these are present in Transformers library under respective models.
Currently, it is available for GPT model <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/megatron_gpt2/checkpoint_reshaping_and_interoperability.py" rel="nofollow">checkpoint_reshaping_and_interoperability.py</a></p></li> <li><p>Below is an example of conversion of checkpoint from Megatron-LM to universal Transformers sharded checkpoint.</p></li>`,Ll,fe,Ql,I,xt="<li>Conversion of checkpoint from transformers to megatron with <code>tp_size=2</code>, <code>pp_size=2</code> and <code>dp_size=2</code>.</li>",xl,_e,Sl,Ie,$l,Ce,St=`<li>Returning logits require setting <code>require_logits=True</code> in MegatronLMPlugin as shown below.
These would be available on the in the last stage of pipeline.</li>`,ql,Ze,Pl,C,$t=`<li><code>megatron_generate</code> method for Megatron-LM GPT model: This will use Tensor and Pipeline Parallelism to complete
generations for a batch of inputs when using greedy with/without top_k/top_p sampling and for individual prompt inputs when using beam search decoding.
Only a subset of features of transformers generate is supported. This will help in using large models via tensor and pipeline parallelism
for generation (already does key-value caching and uses fused kernels by default).
This requires data parallel size to be 1, sequence parallelism and activation checkpointing to be disabled.
It also requires specifying path to tokenizer’s vocab file and merges file.
Below example shows how to configure and use <code>megatron_generate</code> method for Megatron-LM GPT model.</li>`,Dl,Be,Ol,Z,qt=`<li>An end-to-end example of using <code>megatron_generate</code> method for Megatron-LM GPT model is available at
<a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/src/inference/megatron_gpt2_generation.py" rel="nofollow">megatron_gpt2_generation.py</a> with
config file <a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/src/Configs/megatron_lm_gpt_generate_config.yaml" rel="nofollow">megatron_lm_gpt_generate_config.yaml</a>.
The bash script with accelerate launch command is available at <a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/megatron_lm_gpt_generate.sh" rel="nofollow">megatron_lm_gpt_generate.sh</a>.
The output logs of the script are available at <a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/output_logs/megatron_lm_gpt_generate.log" rel="nofollow">megatron_lm_gpt_generate.log</a>.</li>`,Kl,Ge,et,Xe,Pt="<li>For ROPE/ALiBi attention, pass <code>position_embedding_type</code> with <code>(&quot;absolute&quot; | &quot;rotary&quot; | &quot;alibi&quot;)</code> to <code>MegatronLMPlugin</code> as shown below.</li>",lt,ke,tt,B,Dt="<li>For Multi-Query Attention, pass <code>attention_head_type</code> with <code>(&quot;multihead&quot; | &quot;multiquery&quot;)</code> to <code>MegatronLMPlugin</code> as shown below.</li>",st,We,at,ve,nt,Re,Ot=`<li><p>Supports Transformers GPT2, Megatron-BERT and T5 models.
This covers Decoder only, Encode only and Encoder-Decoder model classes.</p></li> <li><p>Only loss is returned from model forward pass as
there is quite complex interplay of pipeline, tensor and data parallelism behind the scenes.
The <code>model(**batch_data)</code> call return loss(es) averaged across the data parallel ranks.
This is fine for most cases wherein pre-training jobs are run using Megatron-LM features and
you can easily compute the <code>perplexity</code> using the loss.
For GPT model, returning logits in addition to loss(es) is supported.
These logits aren’t gathered across data parallel ranks. Use <code>accelerator.utils.gather_across_data_parallel_groups</code>
to gather logits across data parallel ranks. These logits along with labels can be used for computing various
performance metrics.</p></li> <li><p>The main process is the last rank as the losses/logits are available in the last stage of pipeline.
<code>accelerator.is_main_process</code> and <code>accelerator.is_local_main_process</code> return <code>True</code> for last rank when using
Megatron-LM integration.</p></li> <li><p>In <code>accelerator.prepare</code> call, a Megatron-LM model corresponding to a given Transformers model is created
with random weights. Please use <code>accelerator.load_state</code> to load the Megatron-LM checkpoint with matching TP, PP and DP partitions.</p></li> <li><p>Currently, checkpoint reshaping and interoperability support is only available for GPT.
Soon it will be extended to BERT and T5.</p></li> <li><p><code>gradient_accumulation_steps</code> needs to be 1. When using Megatron-LM, micro batches in pipeline parallelism
setting is synonymous with gradient accumulation.</p></li> <li><p>When using Megatron-LM, use <code>accelerator.save_state</code> and <code>accelerator.load_state</code> for saving and loading checkpoints.</p></li> <li><p>Below are the mapping from Megatron-LM model architectures to the the equivalent transformers model architectures.
Only these transformers model architectures are supported.</p></li>`,it,Ve,Kt=`a. Megatron-LM <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/model/bert_model.py" rel="nofollow">BertModel</a> :
transformers models with <code>megatron-bert</code> in config’s model type, e.g.,
<a href="https://huggingface.co/docs/transformers/model_doc/megatron-bert" rel="nofollow">MegatronBERT</a>`,ot,Ne,es=`b. Megatron-LM <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/model/gpt_model.py" rel="nofollow">GPTModel</a> :
transformers models with <code>gpt2</code> in config’s model type, e.g.,
<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">OpenAI GPT2</a>`,rt,ze,ls=`c. Megatron-LM <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/model/t5_model.py" rel="nofollow">T5Model</a> :
transformers models with <code>t5</code> in  config’s model type, e.g.,
<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a> and
<a href="https://huggingface.co/docs/transformers/model_doc/mt5" rel="nofollow">MT5</a>`,pt,Ye,Mt,Ae,ct;return G=new T({props:{title:"Megatron-LM",local:"megatron-lm",headingTag:"h1"}}),k=new T({props:{title:"What is integrated?",local:"what-is-integrated",headingTag:"h2"}}),H=new T({props:{title:"Pre-Requisites",local:"pre-requisites",headingTag:"h2"}}),x=new h({props:{code:"Y29uZGElMjBjcmVhdGUlMjAtLW5hbWUlMjBtbA==",highlighted:'conda <span class="hljs-built_in">create</span> <span class="hljs-comment">--name ml</span>',wrap:!1}}),S=new h({props:{code:"Y29uZGElMjBpbnN0YWxsJTIwcHl0b3JjaCUyMHRvcmNodmlzaW9uJTIwdG9yY2hhdWRpbyUyMGN1ZGF0b29sa2l0JTNEMTEuMyUyMC1jJTIwcHl0b3JjaA==",highlighted:'<span class="hljs-attribute">conda</span> install pytorch torchvision torchaudio cudatoolkit=<span class="hljs-number">11</span>.<span class="hljs-number">3</span> -c pytorch',wrap:!1}}),$=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZOVklESUElMkZhcGV4JTBBY2QlMjBhcGV4JTBBcGlwJTIwaW5zdGFsbCUyMC12JTIwLS1kaXNhYmxlLXBpcC12ZXJzaW9uLWNoZWNrJTIwLS1uby1jYWNoZS1kaXIlMjAtLWdsb2JhbC1vcHRpb24lM0QlMjItLWNwcF9leHQlMjIlMjAtLWdsb2JhbC1vcHRpb24lM0QlMjItLWN1ZGFfZXh0JTIyJTIwLiUyRiUwQWNkJTIwLi4=",highlighted:`git clone https:<span class="hljs-string">//github.com/NVIDIA/apex</span>
<span class="hljs-keyword">cd</span> apex
pip install -v <span class="hljs-params">--disable-pip-version-check</span> <span class="hljs-params">--no-cache-dir</span> <span class="hljs-params">--global-option=</span><span class="hljs-string">&quot;--cpp_ext&quot;</span> <span class="hljs-params">--global-option=</span><span class="hljs-string">&quot;--cuda_ext&quot;</span> <span class="hljs-string">./</span>
<span class="hljs-keyword">cd</span> <span class="hljs-string">..</span>`,wrap:!1}}),q=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZOVklESUElMkZNZWdhdHJvbi1MTS5naXQlMEFjZCUyME1lZ2F0cm9uLUxNJTBBZ2l0JTIwY2hlY2tvdXQlMjBjb3JlX3IwLjUuMCUwQXBpcCUyMGluc3RhbGwlMjAtLW5vLXVzZS1wZXA1MTclMjAtZSUyMC4=",highlighted:`git clone https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/NVIDIA/</span>Megatron-LM.git
cd Megatron-LM
git checkout core_r0.<span class="hljs-number">5.0</span>
pip install --no-use-pep517 -e .`,wrap:!1}}),P=new T({props:{title:"Accelerate Megatron-LM Plugin",local:"accelerate-megatron-lm-plugin",headingTag:"h2"}}),O=new h({props:{code:"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",highlighted:`:~$ accelerate config --config_file <span class="hljs-string">&quot;megatron_gpt_config.yaml&quot;</span>
In <span class="hljs-built_in">which</span> compute environment are you running? ([0] This machine, [1] AWS (Amazon SageMaker)): 0
Which <span class="hljs-built_in">type</span> of machine are you using? ([0] No distributed training, [1] multi-CPU, [2] multi-GPU, [3] TPU): 2
How many different machines will you use (use more than 1 <span class="hljs-keyword">for</span> multi-node training)? [1]: 
Do you want to use DeepSpeed? [<span class="hljs-built_in">yes</span>/NO]: 
Do you want to use FullyShardedDataParallel? [<span class="hljs-built_in">yes</span>/NO]: 
Do you want to use Megatron-LM ? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
What is the Tensor Parallelism degree/size? [1]:2
Do you want to <span class="hljs-built_in">enable</span> Sequence Parallelism? [YES/no]: 
What is the Pipeline Parallelism degree/size? [1]:2
What is the number of micro-batches? [1]:2
Do you want to <span class="hljs-built_in">enable</span> selective activation recomputation? [YES/no]: 
Do you want to use distributed optimizer <span class="hljs-built_in">which</span> shards optimizer state and gradients across data parallel ranks? [YES/no]: 
What is the gradient clipping value based on global L2 Norm (0 to <span class="hljs-built_in">disable</span>)? [1.0]: 
How many GPU(s) should be used <span class="hljs-keyword">for</span> distributed training? [1]:4
Do you wish to use FP16 or BF16 (mixed precision)? [NO/fp16/bf16]: bf16`,wrap:!1}}),ee=new h({props:{code:"fiUyNCUyMGNhdCUyMG1lZ2F0cm9uX2dwdF9jb25maWcueWFtbCUyMCUwQWNvbXB1dGVfZW52aXJvbm1lbnQlM0ElMjBMT0NBTF9NQUNISU5FJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUyMCU3QiU3RCUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBNRUdBVFJPTl9MTSUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBZnNkcF9jb25maWclM0ElMjAlN0IlN0QlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl9wcm9jZXNzX2lwJTNBJTIwbnVsbCUwQW1haW5fcHJvY2Vzc19wb3J0JTNBJTIwbnVsbCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWVnYXRyb25fbG1fY29uZmlnJTNBJTBBJTIwJTIwbWVnYXRyb25fbG1fZ3JhZGllbnRfY2xpcHBpbmclM0ElMjAxLjAlMEElMjAlMjBtZWdhdHJvbl9sbV9udW1fbWljcm9fYmF0Y2hlcyUzQSUyMDIlMEElMjAlMjBtZWdhdHJvbl9sbV9wcF9kZWdyZWUlM0ElMjAyJTBBJTIwJTIwbWVnYXRyb25fbG1fcmVjb21wdXRlX2FjdGl2YXRpb25zJTNBJTIwdHJ1ZSUwQSUyMCUyMG1lZ2F0cm9uX2xtX3NlcXVlbmNlX3BhcmFsbGVsaXNtJTNBJTIwdHJ1ZSUwQSUyMCUyMG1lZ2F0cm9uX2xtX3RwX2RlZ3JlZSUzQSUyMDIlMEElMjAlMjBtZWdhdHJvbl9sbV91c2VfZGlzdHJpYnV0ZWRfb3B0aW1pemVyJTNBJTIwdHJ1ZSUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-string">~$</span> <span class="hljs-string">cat</span> <span class="hljs-string">megatron_gpt_config.yaml</span> 
<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span> {}
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">MEGATRON_LM</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span>
  <span class="hljs-attr">megatron_lm_gradient_clipping:</span> <span class="hljs-number">1.0</span>
  <span class="hljs-attr">megatron_lm_num_micro_batches:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">megatron_lm_pp_degree:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">megatron_lm_recompute_activations:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">megatron_lm_sequence_parallelism:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">megatron_lm_tp_degree:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">megatron_lm_use_distributed_optimizer:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),se=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBNZWdhdHJvbkxNRHVtbXlTY2hlZHVsZXIlMEElMEFpZiUyMGFjY2VsZXJhdG9yLmRpc3RyaWJ1dGVkX3R5cGUlMjAlM0QlM0QlMjBEaXN0cmlidXRlZFR5cGUuTUVHQVRST05fTE0lM0ElMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBNZWdhdHJvbkxNRHVtbXlTY2hlZHVsZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG90YWxfbnVtX3N0ZXBzJTNEYXJncy5tYXhfdHJhaW5fc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3YXJtdXBfbnVtX3N0ZXBzJTNEYXJncy5udW1fd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0RhcmdzLmxyX3NjaGVkdWxlcl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRGFyZ3MubnVtX3dhcm11cF9zdGVwcyUyMColMjBhcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRGFyZ3MubWF4X3RyYWluX3N0ZXBzJTIwKiUyMGFyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> MegatronLMDummyScheduler

<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    lr_scheduler = MegatronLMDummyScheduler(
        optimizer=optimizer,
        total_num_steps=args.max_train_steps,
        warmup_num_steps=args.num_warmup_steps,
    )
<span class="hljs-keyword">else</span>:
    lr_scheduler = get_scheduler(
        name=args.lr_scheduler_type,
        optimizer=optimizer,
        num_warmup_steps=args.num_warmup_steps * args.gradient_accumulation_steps,
        num_training_steps=args.max_train_steps * args.gradient_accumulation_steps,
    )`,wrap:!1}}),ae=new h({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwdG90YWxfYmF0Y2hfc2l6ZSUyMCUzRCUyMGFjY2VsZXJhdG9yLnN0YXRlLm1lZ2F0cm9uX2xtX3BsdWdpbi5nbG9iYWxfYmF0Y2hfc2l6ZSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjB0b3RhbF9iYXRjaF9zaXplJTIwJTNEJTIwYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAqJTIwYWNjZWxlcmF0b3IubnVtX3Byb2Nlc3NlcyUyMColMjBhcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcw==",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    total_batch_size = accelerator.state.megatron_lm_plugin.global_batch_size
<span class="hljs-keyword">else</span>:
    total_batch_size = args.per_device_train_batch_size * accelerator.num_processes * args.gradient_accumulation_steps`,wrap:!1}}),ne=new h({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwbG9zc2VzLmFwcGVuZChsb3NzKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBsb3NzZXMuYXBwZW5kKGFjY2VsZXJhdG9yLmdhdGhlcl9mb3JfbWV0cmljcyhsb3NzLnJlcGVhdChhcmdzLnBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplKSkpJTBBJTBBaWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwbG9zc2VzJTIwJTNEJTIwdG9yY2gudGVuc29yKGxvc3NlcyklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwbG9zc2VzJTIwJTNEJTIwdG9yY2guY2F0KGxvc3Nlcyk=",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    losses.append(loss)
<span class="hljs-keyword">else</span>:
    losses.append(accelerator.gather_for_metrics(loss.repeat(args.per_device_eval_batch_size)))

<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    losses = torch.tensor(losses)
<span class="hljs-keyword">else</span>:
    losses = torch.cat(losses)`,wrap:!1}}),ie=new h({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc2F2ZV9zdGF0ZShhcmdzLm91dHB1dF9kaXIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEElMjAlMjAlMjAlMjB1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3Mub3V0cHV0X2RpciUyQyUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    accelerator.save_state(args.output_dir)
<span class="hljs-keyword">else</span>:
    unwrapped_model = accelerator.unwrap_model(model)
    unwrapped_model.save_pretrained(
        args.output_dir, is_main_process=accelerator.is_main_process, save_function=accelerator.save
    )`,wrap:!1}}),re=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjBtZWdhdHJvbl9ncHRfY29uZmlnLnlhbWwlMjAlNUMlMEFleGFtcGxlcyUyRmJ5X2ZlYXR1cmUlMkZtZWdhdHJvbl9sbV9ncHRfcHJldHJhaW5pbmcucHklMjAlNUMlMEEtLWNvbmZpZ19uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tdG9rZW5pemVyX25hbWUlMjAlMjJncHQyLWxhcmdlJTIyJTIwJTVDJTBBLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMCU1QyUwQS0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQS0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEEtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDI0JTIwJTVDJTBBLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUyMDI0JTIwJTVDJTBBLS1udW1fdHJhaW5fZXBvY2hzJTIwNSUyMCU1QyUwQS0td2l0aF90cmFja2luZyUyMCU1QyUwQS0tcmVwb3J0X3RvJTIwJTIyd2FuZGIlMjIlMjAlNUMlMEEtLW91dHB1dF9kaXIlMjAlMjJhd2Vzb21lX21vZGVsJTIy",highlighted:`accelerate launch --config_file megatron_gpt_config.yaml \\
examples/by_feature/megatron_lm_gpt_pretraining.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name wikitext \\
--dataset_config_name wikitext-2-raw-v1 \\
--block_size 1024 \\
--learning_rate 5e-5 \\
--per_device_train_batch_size 24 \\
--per_device_eval_batch_size 24 \\
--num_train_epochs 5 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span> \\
--output_dir <span class="hljs-string">&quot;awesome_model&quot;</span>`,wrap:!1}}),Me=new h({props:{code:"ZG9uZSUyMHdpdGglMjBjb21waWxpbmclMjBhbmQlMjBsb2FkaW5nJTIwZnVzZWQlMjBrZXJuZWxzLiUyMENvbXBpbGF0aW9uJTIwdGltZSUzQSUyMDMuNTY5JTIwc2Vjb25kcw==",highlighted:`Loading extension module fused_dense_cuda...
&gt;&gt;&gt; <span class="hljs-keyword">done</span> with compiling and loading fused kernels. Compilation time: 3.569 seconds
 &gt; padded vocab (size: 50257) with 175 dummy tokens (new size: 50432)
Building gpt model <span class="hljs-keyword">in</span> the pre-training mode.
The Megatron LM model weights are initialized at random <span class="hljs-keyword">in</span> \`accelerator.prepare\`. Please use \`accelerator.load_checkpoint\` to load a pre-trained checkpoint matching the distributed setup.
Preparing dataloader
Preparing dataloader
Preparing model
 &gt; number of parameters on (tensor, pipeline) model parallel rank (1, 0): 210753280
 &gt; number of parameters on (tensor, pipeline) model parallel rank (1, 1): 209445120
 &gt; number of parameters on (tensor, pipeline) model parallel rank (0, 0): 210753280
 &gt; number of parameters on (tensor, pipeline) model parallel rank (0, 1): 209445120
Preparing optimizer
Preparing scheduler
&gt; learning rate decay style: linear
10/10/2022 22:57:22 - INFO - __main__ - ***** Running training *****
10/10/2022 22:57:22 - INFO - __main__ -   Num examples = 2318
10/10/2022 22:57:22 - INFO - __main__ -   Num Epochs = 5
10/10/2022 22:57:22 - INFO - __main__ -   Instantaneous batch size per device = 24
10/10/2022 22:57:22 - INFO - __main__ -   Total train batch size (w. parallel, distributed &amp; accumulation) = 48
10/10/2022 22:57:22 - INFO - __main__ -   Gradient Accumulation steps = 1
10/10/2022 22:57:22 - INFO - __main__ -   Total optimization steps = 245
 20%|████████████▍                                                 | 49/245 [01:04&lt;04:09,  1.27s/it]
 10/10/2022 22:58:29 - INFO - __main__ - epoch 0: perplexity: 1222.1594275215962 eval_loss: 7.10837459564209
 40%|████████████████████████▊                                     | 98/245 [02:10&lt;03:07,  1.28s/it]
 10/10/2022 22:59:35 - INFO - __main__ - epoch 1: perplexity: 894.5236583794557 eval_loss: 6.796291351318359
 60%|████████████████████████████████████▌                        | 147/245 [03:16&lt;02:05,  1.28s/it]
 10/10/2022 23:00:40 - INFO - __main__ - epoch 2: perplexity: 702.8458788508042 eval_loss: 6.555137634277344
 80%|████████████████████████████████████████████████▊            | 196/245 [04:22&lt;01:02,  1.28s/it]
 10/10/2022 23:01:46 - INFO - __main__ - epoch 3: perplexity: 600.3220028695281 eval_loss: 6.39746618270874
100%|█████████████████████████████████████████████████████████████| 245/245 [05:27&lt;00:00,  1.28s/it]`,wrap:!1}}),de=new T({props:{title:"Advanced features to leverage writing custom train step and Megatron-LM Indexed Datasets",local:"advanced-features-to-leverage-writing-custom-train-step-and-megatron-lm-indexed-datasets",headingTag:"h2"}}),he=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBNZWdhdHJvbkxNRHVtbXlTY2hlZHVsZXIlMkMlMjBHUFRUcmFpblN0ZXAlMkMlMjBhdmdfbG9zc2VzX2Fjcm9zc19kYXRhX3BhcmFsbGVsX2dyb3VwJTBBJTBBJTBBJTIzJTIwQ3VzdG9tJTIwbG9zcyUyMGZ1bmN0aW9uJTIwZm9yJTIwdGhlJTIwTWVnYXRyb24lMjBtb2RlbCUwQWNsYXNzJTIwR1BUVHJhaW5TdGVwV2l0aEN1c3RvbUxvc3MoR1BUVHJhaW5TdGVwKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtZWdhdHJvbl9hcmdzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXyhtZWdhdHJvbl9hcmdzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYua3dhcmdzJTIwJTNEJTIwa3dhcmdzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2xvc3NfZnVuYyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMGxvc3NfZnVuYyhpbnB1dHMlMkMlMjBsb3NzX21hc2slMkMlMjBvdXRwdXRfdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoX3NpemUlMkMlMjBzZXFfbGVuZ3RoJTIwJTNEJTIwb3V0cHV0X3RlbnNvci5zaGFwZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NlcyUyMCUzRCUyMG91dHB1dF90ZW5zb3IuZmxvYXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfbWFzayUyMCUzRCUyMGxvc3NfbWFzay52aWV3KC0xKS5mbG9hdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3Nlcy52aWV3KC0xKSUyMColMjBsb3NzX21hc2slMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZXNpemUlMjBhbmQlMjBhdmVyYWdlJTIwbG9zcyUyMHBlciUyMHNhbXBsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfcGVyX3NhbXBsZSUyMCUzRCUyMGxvc3MudmlldyhiYXRjaF9zaXplJTJDJTIwc2VxX2xlbmd0aCkuc3VtKGF4aXMlM0QxKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfbWFza19wZXJfc2FtcGxlJTIwJTNEJTIwbG9zc19tYXNrLnZpZXcoYmF0Y2hfc2l6ZSUyQyUyMHNlcV9sZW5ndGgpLnN1bShheGlzJTNEMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzX3Blcl9zYW1wbGUlMjAlM0QlMjBsb3NzX3Blcl9zYW1wbGUlMjAlMkYlMjBsb3NzX21hc2tfcGVyX3NhbXBsZSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENhbGN1bGF0ZSUyMGFuZCUyMHNjYWxlJTIwd2VpZ2h0aW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2VpZ2h0cyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QihpbnB1dHMlMjAlM0QlM0QlMjBrdCkuZmxvYXQoKSUyMGZvciUyMGt0JTIwaW4lMjBzZWxmLmt3YXJncyU1QiUyMmtleXRva2VuX2lkcyUyMiU1RCU1RCkuc3VtKGF4aXMlM0QlNUIwJTJDJTIwMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3ZWlnaHRzJTIwJTNEJTIwMS4wJTIwJTJCJTIwc2VsZi5rd2FyZ3MlNUIlMjJhbHBoYSUyMiU1RCUyMColMjB3ZWlnaHRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ2FsY3VsYXRlJTIwd2VpZ2h0ZWQlMjBhdmVyYWdlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2VpZ2h0ZWRfbG9zcyUyMCUzRCUyMChsb3NzX3Blcl9zYW1wbGUlMjAqJTIwd2VpZ2h0cykubWVhbigpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVkdWNlJTIwbG9zcyUyMGFjcm9zcyUyMGRhdGElMjBwYXJhbGxlbCUyMGdyb3VwcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2ZXJhZ2VkX2xvc3MlMjAlM0QlMjBhdmdfbG9zc2VzX2Fjcm9zc19kYXRhX3BhcmFsbGVsX2dyb3VwKCU1QndlaWdodGVkX2xvc3MlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwd2VpZ2h0ZWRfbG9zcyUyQyUyMCU3QiUyMmxtJTIwbG9zcyUyMiUzQSUyMGF2ZXJhZ2VkX2xvc3MlNUIwJTVEJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zc19mdW5jJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2ZvcndhcmRfc3RlcF9mdW5jKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZF9zdGVwKGRhdGFfaXRlcmF0b3IlMkMlMjBtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJGb3J3YXJkJTIwc3RlcC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjBiYXRjaC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbnMlMkMlMjBsYWJlbHMlMkMlMjBsb3NzX21hc2slMkMlMjBhdHRlbnRpb25fbWFzayUyQyUyMHBvc2l0aW9uX2lkcyUyMCUzRCUyMHNlbGYuZ2V0X2JhdGNoKGRhdGFfaXRlcmF0b3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RlbnNvciUyMCUzRCUyMG1vZGVsKHRva2VucyUyQyUyMHBvc2l0aW9uX2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZW5zb3IlMkMlMjBwYXJ0aWFsKHNlbGYubG9zc19mdW5jJTJDJTIwdG9rZW5zJTJDJTIwbG9zc19tYXNrKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZvcndhcmRfc3RlcCUwQSUwQSUwQWRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEN1c3RvbSUyMGxvc3MlMjBmdW5jdGlvbiUyMGZvciUyMHRoZSUyME1lZ2F0cm9uJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBrZXl0b2tlbl9pZHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBrZXl3b3JkcyUyMCUzRCUyMCU1QiUyMnBsdCUyMiUyQyUyMCUyMnBkJTIyJTJDJTIwJTIyc2slMjIlMkMlMjAlMjJmaXQlMjIlMkMlMjAlMjJwcmVkaWN0JTIyJTJDJTIwJTIyJTIwcGx0JTIyJTJDJTIwJTIyJTIwcGQlMjIlMkMlMjAlMjIlMjBzayUyMiUyQyUyMCUyMiUyMGZpdCUyMiUyQyUyMCUyMiUyMHByZWRpY3QlMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBrZXl3b3JkJTIwaW4lMjBrZXl3b3JkcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkcyUyMCUzRCUyMHRva2VuaXplciglNUJrZXl3b3JkJTVEKS5pbnB1dF9pZHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oaWRzKSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXl0b2tlbl9pZHMuYXBwZW5kKGlkcyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IucHJpbnQoZiUyMktleXRva2VuJTIwaWRzJTNBJTIwJTdCa2V5dG9rZW5faWRzJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnN0YXRlLm1lZ2F0cm9uX2xtX3BsdWdpbi5jdXN0b21fdHJhaW5fc3RlcF9jbGFzcyUyMCUzRCUyMEdQVFRyYWluU3RlcFdpdGhDdXN0b21Mb3NzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc3RhdGUubWVnYXRyb25fbG1fcGx1Z2luLmN1c3RvbV90cmFpbl9zdGVwX2t3YXJncyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmtleXRva2VuX2lkcyUyMiUzQSUyMGtleXRva2VuX2lkcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFscGhhJTIyJTNBJTIwMC4yNSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> MegatronLMDummyScheduler, GPTTrainStep, avg_losses_across_data_parallel_group


<span class="hljs-comment"># Custom loss function for the Megatron model</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">GPTTrainStepWithCustomLoss</span>(<span class="hljs-title class_ inherited__">GPTTrainStep</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, megatron_args, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(megatron_args)
        self.kwargs = kwargs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_loss_func</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">loss_func</span>(<span class="hljs-params">inputs, loss_mask, output_tensor</span>):
            batch_size, seq_length = output_tensor.shape
            losses = output_tensor.<span class="hljs-built_in">float</span>()
            loss_mask = loss_mask.view(-<span class="hljs-number">1</span>).<span class="hljs-built_in">float</span>()
            loss = losses.view(-<span class="hljs-number">1</span>) * loss_mask

            <span class="hljs-comment"># Resize and average loss per sample</span>
            loss_per_sample = loss.view(batch_size, seq_length).<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>)
            loss_mask_per_sample = loss_mask.view(batch_size, seq_length).<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>)
            loss_per_sample = loss_per_sample / loss_mask_per_sample

            <span class="hljs-comment"># Calculate and scale weighting</span>
            weights = torch.stack([(inputs == kt).<span class="hljs-built_in">float</span>() <span class="hljs-keyword">for</span> kt <span class="hljs-keyword">in</span> self.kwargs[<span class="hljs-string">&quot;keytoken_ids&quot;</span>]]).<span class="hljs-built_in">sum</span>(axis=[<span class="hljs-number">0</span>, <span class="hljs-number">2</span>])
            weights = <span class="hljs-number">1.0</span> + self.kwargs[<span class="hljs-string">&quot;alpha&quot;</span>] * weights
            <span class="hljs-comment"># Calculate weighted average</span>
            weighted_loss = (loss_per_sample * weights).mean()

            <span class="hljs-comment"># Reduce loss across data parallel groups</span>
            averaged_loss = avg_losses_across_data_parallel_group([weighted_loss])

            <span class="hljs-keyword">return</span> weighted_loss, {<span class="hljs-string">&quot;lm loss&quot;</span>: averaged_loss[<span class="hljs-number">0</span>]}

        <span class="hljs-keyword">return</span> loss_func

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_forward_step_func</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward_step</span>(<span class="hljs-params">data_iterator, model</span>):
            <span class="hljs-string">&quot;&quot;&quot;Forward step.&quot;&quot;&quot;</span>
            <span class="hljs-comment"># Get the batch.</span>
            tokens, labels, loss_mask, attention_mask, position_ids = self.get_batch(data_iterator)
            output_tensor = model(tokens, position_ids, attention_mask, labels=labels)

            <span class="hljs-keyword">return</span> output_tensor, partial(self.loss_func, tokens, loss_mask)

        <span class="hljs-keyword">return</span> forward_step


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Custom loss function for the Megatron model</span>
    keytoken_ids = []
    keywords = [<span class="hljs-string">&quot;plt&quot;</span>, <span class="hljs-string">&quot;pd&quot;</span>, <span class="hljs-string">&quot;sk&quot;</span>, <span class="hljs-string">&quot;fit&quot;</span>, <span class="hljs-string">&quot;predict&quot;</span>, <span class="hljs-string">&quot; plt&quot;</span>, <span class="hljs-string">&quot; pd&quot;</span>, <span class="hljs-string">&quot; sk&quot;</span>, <span class="hljs-string">&quot; fit&quot;</span>, <span class="hljs-string">&quot; predict&quot;</span>]
    <span class="hljs-keyword">for</span> keyword <span class="hljs-keyword">in</span> keywords:
        ids = tokenizer([keyword]).input_ids[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(ids) == <span class="hljs-number">1</span>:
            keytoken_ids.append(ids[<span class="hljs-number">0</span>])
    accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Keytoken ids: <span class="hljs-subst">{keytoken_ids}</span>&quot;</span>)
    accelerator.state.megatron_lm_plugin.custom_train_step_class = GPTTrainStepWithCustomLoss
    accelerator.state.megatron_lm_plugin.custom_train_step_kwargs = {
        <span class="hljs-string">&quot;keytoken_ids&quot;</span>: keytoken_ids,
        <span class="hljs-string">&quot;alpha&quot;</span>: <span class="hljs-number">0.25</span>,
    }`,wrap:!1}}),Ue=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBNZWdhdHJvbkxNRHVtbXlEYXRhTG9hZGVyJTBBJTBBbWVnYXRyb25fZGF0YWxvYWRlcl9jb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJkYXRhX3BhdGglMjIlM0ElMjBhcmdzLmRhdGFfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNwbGl0c19zdHJpbmclMjIlM0ElMjBhcmdzLnNwbGl0c19zdHJpbmclMkMlMEElMjAlMjAlMjAlMjAlMjJzZXFfbGVuZ3RoJTIyJTNBJTIwYXJncy5ibG9ja19zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIybWljcm9fYmF0Y2hfc2l6ZSUyMiUzQSUyMGFyZ3MucGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTJDJTBBJTdEJTBBbWVnYXRyb25fZGF0YWxvYWRlciUyMCUzRCUyME1lZ2F0cm9uTE1EdW1teURhdGFMb2FkZXIoKiptZWdhdHJvbl9kYXRhbG9hZGVyX2NvbmZpZyklMEFhY2NlbGVyYXRvci5zdGF0ZS5tZWdhdHJvbl9sbV9wbHVnaW4ubWVnYXRyb25fZGF0YXNldF9mbGFnJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> MegatronLMDummyDataLoader

megatron_dataloader_config = {
    <span class="hljs-string">&quot;data_path&quot;</span>: args.data_path,
    <span class="hljs-string">&quot;splits_string&quot;</span>: args.splits_string,
    <span class="hljs-string">&quot;seq_length&quot;</span>: args.block_size,
    <span class="hljs-string">&quot;micro_batch_size&quot;</span>: args.per_device_train_batch_size,
}
megatron_dataloader = MegatronLMDummyDataLoader(**megatron_dataloader_config)
accelerator.state.megatron_lm_plugin.megatron_dataset_flag = <span class="hljs-literal">True</span>`,wrap:!1}}),Je=new h({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwXyUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlMkMlMjBtZWdhdHJvbl9kYXRhbG9hZGVyJTJDJTIwbWVnYXRyb25fZGF0YWxvYWRlciUyQyUyMG1lZ2F0cm9uX2RhdGFsb2FkZXIlMEEp",highlighted:`model, optimizer, lr_scheduler, train_dataloader, eval_dataloader, _ = accelerator.prepare(
    model, optimizer, lr_scheduler, megatron_dataloader, megatron_dataloader, megatron_dataloader
)`,wrap:!1}}),be=new h({props:{code:"d2hpbGUlMjBjb21wbGV0ZWRfc3RlcHMlMjAlM0MlMjBhcmdzLm1heF90cmFpbl9zdGVwcyUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnRyYWluKCklMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMG5leHQodHJhaW5fZGF0YWxvYWRlciklMjBpZiUyMHRyYWluX2RhdGFsb2FkZXIlMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwY29tcGxldGVkX3N0ZXBzJTIwJTI1JTIwZXZhbF9pbnRlcnZhbCUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBldmFsX2NvbXBsZXRlZF9zdGVwcyUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzZXMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGV2YWxfY29tcGxldGVkX3N0ZXBzJTIwJTNDJTIwZXZhbF9pdGVycyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMG5leHQoZXZhbF9kYXRhbG9hZGVyKSUyMGlmJTIwZXZhbF9kYXRhbG9hZGVyJTIwaXMlMjBub3QlMjBOb25lJTIwZWxzZSUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">while</span> completed_steps &lt; args.max_train_steps:
    model.train()
    batch = <span class="hljs-built_in">next</span>(train_dataloader) <span class="hljs-keyword">if</span> train_dataloader <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> {}
    outputs = model(**batch)
    loss = outputs.loss
    ...

    <span class="hljs-keyword">if</span> completed_steps % eval_interval == <span class="hljs-number">0</span>:
        eval_completed_steps = <span class="hljs-number">0</span>
        losses = []
        <span class="hljs-keyword">while</span> eval_completed_steps &lt; eval_iters:
            model.<span class="hljs-built_in">eval</span>()
            <span class="hljs-keyword">with</span> torch.no_grad():
                batch = <span class="hljs-built_in">next</span>(eval_dataloader) <span class="hljs-keyword">if</span> eval_dataloader <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> {}
                outputs = model(**batch)`,wrap:!1}}),je=new T({props:{title:"Utility for Checkpoint reshaping and interoperability",local:"utility-for-checkpoint-reshaping-and-interoperability",headingTag:"h2"}}),fe=new h({props:{code:"cHl0aG9uJTIwY2hlY2twb2ludF9yZXNoYXBpbmdfYW5kX2ludGVyb3BlcmFiaWxpdHkucHklMjAlNUMlMEEtLWNvbnZlcnRfY2hlY2twb2ludF9mcm9tX21lZ2F0cm9uX3RvX3RyYW5zZm9ybWVycyUyMCU1QyUwQS0tbG9hZF9wYXRoJTIwJTIyZ3B0JTJGaXRlcl8wMDA1MDAwJTIyJTIwJTVDJTBBLS1zYXZlX3BhdGglMjAlMjJncHQlMkZ0cmZzX2NoZWNrcG9pbnQlMjIlMjAlNUMlMEEtLW1heF9zaGFyZF9zaXplJTIwJTIyMjAwTUIlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0MiUyMiUyMCU1QyUwQS0tcHJpbnQtY2hlY2twb2ludC1zdHJ1Y3R1cmU=",highlighted:`python checkpoint_reshaping_and_interoperability.py \\
--convert_checkpoint_from_megatron_to_transformers \\
--load_path <span class="hljs-string">&quot;gpt/iter_0005000&quot;</span> \\
--save_path <span class="hljs-string">&quot;gpt/trfs_checkpoint&quot;</span> \\
--max_shard_size <span class="hljs-string">&quot;200MB&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2&quot;</span> \\
--print-checkpoint-structure`,wrap:!1}}),_e=new h({props:{code:"cHl0aG9uJTIwY2hlY2twb2ludF91dGlscyUyRm1lZ2F0Z3Jvbl9ncHQyJTJGY2hlY2twb2ludF9yZXNoYXBpbmdfYW5kX2ludGVyb3BlcmFiaWxpdHkucHklMjAlNUMlMEEtLWxvYWRfcGF0aCUyMCUyMmdwdCUyRnRyZnNfY2hlY2twb2ludCUyMiUyMCU1QyUwQS0tc2F2ZV9wYXRoJTIwJTIyZ3B0JTJGbWVnYXRyb25fbG1fY2hlY2twb2ludCUyMiUyMCU1QyUwQS0tdGFyZ2V0X3RlbnNvcl9tb2RlbF9wYXJhbGxlbF9zaXplJTIwMiUyMCU1QyUwQS0tdGFyZ2V0X3BpcGVsaW5lX21vZGVsX3BhcmFsbGVsX3NpemUlMjAyJTIwJTVDJTBBLS10YXJnZXRfZGF0YV9wYXJhbGxlbF9zaXplJTIwMiUyMCU1QyUwQS0tdGFyZ2V0X3BhcmFtc19kdHlwZSUyMCUyMmJmMTYlMjIlMjAlNUMlMEEtLW1ha2Vfdm9jYWJfc2l6ZV9kaXZpc2libGVfYnklMjAxMjglMjAlNUMlMEEtLXVzZV9kaXN0cmlidXRlZF9vcHRpbWl6ZXIlMjAlNUMlMEEtLXByaW50LWNoZWNrcG9pbnQtc3RydWN0dXJl",highlighted:`python checkpoint_utils/megatgron_gpt2/checkpoint_reshaping_and_interoperability.py \\
--load_path <span class="hljs-string">&quot;gpt/trfs_checkpoint&quot;</span> \\
--save_path <span class="hljs-string">&quot;gpt/megatron_lm_checkpoint&quot;</span> \\
--target_tensor_model_parallel_size 2 \\
--target_pipeline_model_parallel_size 2 \\
--target_data_parallel_size 2 \\
--target_params_dtype <span class="hljs-string">&quot;bf16&quot;</span> \\
--make_vocab_size_divisible_by 128 \\
--use_distributed_optimizer \\
--print-checkpoint-structure`,wrap:!1}}),Ie=new T({props:{title:"Megatron-LM GPT models support returning logits and megatron_generate function for text generation",local:"megatron-lm-gpt-models-support-returning-logits-and-megatrongenerate-function-for-text-generation",headingTag:"h2"}}),Ze=new h({props:{code:"bWVnYXRyb25fbG1fcGx1Z2luJTIwJTNEJTIwTWVnYXRyb25MTVBsdWdpbihyZXR1cm5fbG9naXRzJTNEVHJ1ZSk=",highlighted:'megatron_lm_plugin = MegatronLMPlugin(return_logits=<span class="hljs-literal">True</span>)',wrap:!1}}),Be=new h({props:{code:"JTIzJTIwc3BlY2lmeWluZyUyMHRva2VuaXplcidzJTIwdm9jYWIlMjBhbmQlMjBtZXJnZXMlMjBmaWxlJTBBdm9jYWJfZmlsZSUyMCUzRCUyMG9zLnBhdGguam9pbihhcmdzLnJlc3VtZV9mcm9tX2NoZWNrcG9pbnQlMkMlMjAlMjJ2b2NhYi5qc29uJTIyKSUwQW1lcmdlX2ZpbGUlMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5yZXN1bWVfZnJvbV9jaGVja3BvaW50JTJDJTIwJTIybWVyZ2VzLnR4dCUyMiklMEFvdGhlcl9tZWdhdHJvbl9hcmdzJTIwJTNEJTIwJTdCJTIydm9jYWJfZmlsZSUyMiUzQSUyMHZvY2FiX2ZpbGUlMkMlMjAlMjJtZXJnZV9maWxlJTIyJTNBJTIwbWVyZ2VfZmlsZSU3RCUwQW1lZ2F0cm9uX2xtX3BsdWdpbiUyMCUzRCUyME1lZ2F0cm9uTE1QbHVnaW4ob3RoZXJfbWVnYXRyb25fYXJncyUzRG90aGVyX21lZ2F0cm9uX2FyZ3MpJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTIwdXNpbmclMjAlNjBtZWdhdHJvbl9nZW5lcmF0ZSU2MCUyMGZ1bmN0aW9uYWxpdHklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUwQW1heF9uZXdfdG9rZW5zJTIwJTNEJTIwNjQlMEFiYXRjaF90ZXh0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkFyZSUyMHlvdSUyMGh1bWFuJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcHVycG9zZSUyMG9mJTIwbGlmZSUyMGlzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwYXJzZW5hbCUyMHdhcyUyMGNvbnN0cnVjdGVkJTIwYXQlMjB0aGUlMjByZXF1ZXN0JTIwb2YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3clMjBhcmUlMjB5b3UlMjBkb2luZyUyMHRoZXNlJTIwZGF5cyUzRiUyMiUyQyUwQSU1RCUwQWJhdGNoX2VuY29kaW5ncyUyMCUzRCUyMHRva2VuaXplcihiYXRjaF90ZXh0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEElMjMlMjB0b3AtcCUyMHNhbXBsaW5nJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLm1lZ2F0cm9uX2dlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMGJhdGNoX2VuY29kaW5ncyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX2VuY29kaW5ncyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0RtYXhfbmV3X3Rva2VucyUyQyUwQSUyMCUyMCUyMCUyMHRvcF9wJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwdG9wX3BfZGVjYXklM0QwLjUlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSklMEFkZWNvZGVkX3ByZWRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zLmNwdSgpLm51bXB5KCkpJTBBYWNjZWxlcmF0b3IucHJpbnQoZGVjb2RlZF9wcmVkcyklMEElMEElMjMlMjB0b3AtayUyMHNhbXBsaW5nJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLm1lZ2F0cm9uX2dlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMGJhdGNoX2VuY29kaW5ncyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX2VuY29kaW5ncyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0RtYXhfbmV3X3Rva2VucyUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSklMEFkZWNvZGVkX3ByZWRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zLmNwdSgpLm51bXB5KCkpJTBBYWNjZWxlcmF0b3IucHJpbnQoZGVjb2RlZF9wcmVkcyklMEElMEElMjMlMjBhZGRpbmclMjAlNjBib3MlNjAlMjB0b2tlbiUyMGF0JTIwdGhlJTIwc3RhcnQlMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIwbW9kZWwubWVnYXRyb25fZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwYmF0Y2hfZW5jb2RpbmdzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwYmF0Y2hfZW5jb2RpbmdzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRG1heF9uZXdfdG9rZW5zJTJDJTIwYWRkX0JPUyUzRFRydWUlMEEpJTBBZGVjb2RlZF9wcmVkcyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2Vucy5jcHUoKS5udW1weSgpKSUwQWFjY2VsZXJhdG9yLnByaW50KGRlY29kZWRfcHJlZHMpJTBBJTBBJTIzJTIwYmVhbSUyMHNlYXJjaCUyMCUzRCUzRSUyMG9ubHklMjB0YWtlcyUyMHNpbmdsZSUyMHByb21wdCUwQWJhdGNoX3RleHRzJTIwJTNEJTIwJTVCJTIyVGhlJTIwcHVycG9zZSUyMG9mJTIwbGlmZSUyMGlzJTIyJTVEJTBBYmF0Y2hfZW5jb2RpbmdzJTIwJTNEJTIwdG9rZW5pemVyKGJhdGNoX3RleHRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQWdlbmVyYXRlZF90b2tlbnMlMjAlM0QlMjBtb2RlbC5tZWdhdHJvbl9nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBiYXRjaF9lbmNvZGluZ3MlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9lbmNvZGluZ3MlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEbWF4X25ld190b2tlbnMlMkMlMEElMjAlMjAlMjAlMjBudW1fYmVhbXMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMGxlbmd0aF9wZW5hbHR5JTNEMS41JTJDJTBBKSUwQWRlY29kZWRfcHJlZHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMuY3B1KCkubnVtcHkoKSklMEFhY2NlbGVyYXRvci5wcmludChkZWNvZGVkX3ByZWRzKQ==",highlighted:`<span class="hljs-comment"># specifying tokenizer&#x27;s vocab and merges file</span>
vocab_file = os.path.join(args.resume_from_checkpoint, <span class="hljs-string">&quot;vocab.json&quot;</span>)
merge_file = os.path.join(args.resume_from_checkpoint, <span class="hljs-string">&quot;merges.txt&quot;</span>)
other_megatron_args = {<span class="hljs-string">&quot;vocab_file&quot;</span>: vocab_file, <span class="hljs-string">&quot;merge_file&quot;</span>: merge_file}
megatron_lm_plugin = MegatronLMPlugin(other_megatron_args=other_megatron_args)

<span class="hljs-comment"># inference using \`megatron_generate\` functionality</span>
tokenizer.pad_token = tokenizer.eos_token
max_new_tokens = <span class="hljs-number">64</span>
batch_texts = [
    <span class="hljs-string">&quot;Are you human?&quot;</span>,
    <span class="hljs-string">&quot;The purpose of life is&quot;</span>,
    <span class="hljs-string">&quot;The arsenal was constructed at the request of&quot;</span>,
    <span class="hljs-string">&quot;How are you doing these days?&quot;</span>,
]
batch_encodings = tokenizer(batch_texts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># top-p sampling</span>
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>],
    batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>],
    max_new_tokens=max_new_tokens,
    top_p=<span class="hljs-number">0.8</span>,
    top_p_decay=<span class="hljs-number">0.5</span>,
    temperature=<span class="hljs-number">0.9</span>,
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)

<span class="hljs-comment"># top-k sampling</span>
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>],
    batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>],
    max_new_tokens=max_new_tokens,
    top_k=<span class="hljs-number">50</span>,
    temperature=<span class="hljs-number">0.9</span>,
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)

<span class="hljs-comment"># adding \`bos\` token at the start</span>
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>], batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>], max_new_tokens=max_new_tokens, add_BOS=<span class="hljs-literal">True</span>
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)

<span class="hljs-comment"># beam search =&gt; only takes single prompt</span>
batch_texts = [<span class="hljs-string">&quot;The purpose of life is&quot;</span>]
batch_encodings = tokenizer(batch_texts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>],
    batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>],
    max_new_tokens=max_new_tokens,
    num_beams=<span class="hljs-number">20</span>,
    length_penalty=<span class="hljs-number">1.5</span>,
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)`,wrap:!1}}),Ge=new T({props:{title:"Support for ROPE and ALiBi Positional embeddings and Multi-Query Attention",local:"support-for-rope-and-alibi-positional-embeddings-and-multi-query-attention",headingTag:"h2"}}),ke=new h({props:{code:"b3RoZXJfbWVnYXRyb25fYXJncyUyMCUzRCUyMCU3QiUyMnBvc2l0aW9uX2VtYmVkZGluZ190eXBlJTIyJTNBJTIwJTIyYWxpYmklMjIlN0QlMEFtZWdhdHJvbl9sbV9wbHVnaW4lMjAlM0QlMjBNZWdhdHJvbkxNUGx1Z2luKG90aGVyX21lZ2F0cm9uX2FyZ3MlM0RvdGhlcl9tZWdhdHJvbl9hcmdzKQ==",highlighted:`other_megatron_args = {<span class="hljs-string">&quot;position_embedding_type&quot;</span>: <span class="hljs-string">&quot;alibi&quot;</span>}
megatron_lm_plugin = MegatronLMPlugin(other_megatron_args=other_megatron_args)`,wrap:!1}}),We=new h({props:{code:"b3RoZXJfbWVnYXRyb25fYXJncyUyMCUzRCUyMCU3QiUyMmF0dGVudGlvbl9oZWFkX3R5cGUlMjIlM0ElMjAlMjJtdWx0aXF1ZXJ5JTIyJTdEJTBBbWVnYXRyb25fbG1fcGx1Z2luJTIwJTNEJTIwTWVnYXRyb25MTVBsdWdpbihvdGhlcl9tZWdhdHJvbl9hcmdzJTNEb3RoZXJfbWVnYXRyb25fYXJncyk=",highlighted:`other_megatron_args = {<span class="hljs-string">&quot;attention_head_type&quot;</span>: <span class="hljs-string">&quot;multiquery&quot;</span>}
megatron_lm_plugin = MegatronLMPlugin(other_megatron_args=other_megatron_args)`,wrap:!1}}),ve=new T({props:{title:"Caveats",local:"caveats",headingTag:"h2"}}),Ye=new Ms({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/megatron_lm.md"}}),{c(){U=i("meta"),He=a(),Fe=i("p"),Ee=a(),p(G.$$.fragment),Le=a(),X=i("p"),X.innerHTML=mt,Qe=a(),p(k.$$.fragment),xe=a(),W=i("p"),W.textContent=yt,Se=a(),v=i("p"),v.innerHTML=ht,$e=a(),R=i("p"),R.innerHTML=ut,qe=a(),V=i("p"),V.innerHTML=Ut,Pe=a(),N=i("p"),N.innerHTML=Tt,De=a(),z=i("p"),z.innerHTML=Jt,Oe=a(),Y=i("p"),Y.innerHTML=wt,Ke=a(),F=i("p"),F.innerHTML=bt,el=a(),A=i("p"),A.innerHTML=jt,ll=a(),p(H.$$.fragment),tl=a(),E=i("p"),E.innerHTML=gt,sl=a(),L=i("p"),L.textContent=ft,al=a(),Q=i("ol"),Q.innerHTML=_t,nl=a(),p(x.$$.fragment),il=a(),J=i("ol"),J.innerHTML=It,ol=a(),p(S.$$.fragment),rl=a(),w=i("ol"),w.innerHTML=Ct,pl=a(),p($.$$.fragment),Ml=a(),b=i("ol"),b.innerHTML=Zt,cl=a(),p(q.$$.fragment),dl=a(),p(P.$$.fragment),ml=a(),D=i("p"),D.innerHTML=Bt,yl=a(),p(O.$$.fragment),hl=a(),K=i("p"),K.textContent=Gt,ul=a(),p(ee.$$.fragment),Ul=a(),le=i("p"),le.innerHTML=Xt,Tl=a(),te=i("ol"),te.innerHTML=kt,Jl=a(),p(se.$$.fragment),wl=a(),j=i("ol"),j.innerHTML=Wt,bl=a(),p(ae.$$.fragment),jl=a(),g=i("ol"),g.innerHTML=vt,gl=a(),p(ne.$$.fragment),fl=a(),f=i("ol"),f.innerHTML=Rt,_l=a(),p(ie.$$.fragment),Il=a(),oe=i("p"),oe.innerHTML=Vt,Cl=a(),p(re.$$.fragment),Zl=a(),pe=i("p"),pe.textContent=Nt,Bl=a(),p(Me.$$.fragment),Gl=a(),ce=i("p"),ce.innerHTML=zt,Xl=a(),p(de.$$.fragment),kl=a(),me=i("p"),me.textContent=Yt,Wl=a(),ye=i("ol"),ye.innerHTML=Ft,vl=a(),p(he.$$.fragment),Rl=a(),_=i("ol"),_.innerHTML=At,Vl=a(),ue=i("p"),ue.innerHTML=Ht,Nl=a(),p(Ue.$$.fragment),zl=a(),Te=i("p"),Te.innerHTML=Et,Yl=a(),p(Je.$$.fragment),Fl=a(),we=i("p"),we.innerHTML=Lt,Al=a(),p(be.$$.fragment),Hl=a(),p(je.$$.fragment),El=a(),ge=i("ol"),ge.innerHTML=Qt,Ll=a(),p(fe.$$.fragment),Ql=a(),I=i("ol"),I.innerHTML=xt,xl=a(),p(_e.$$.fragment),Sl=a(),p(Ie.$$.fragment),$l=a(),Ce=i("ol"),Ce.innerHTML=St,ql=a(),p(Ze.$$.fragment),Pl=a(),C=i("ol"),C.innerHTML=$t,Dl=a(),p(Be.$$.fragment),Ol=a(),Z=i("ol"),Z.innerHTML=qt,Kl=a(),p(Ge.$$.fragment),et=a(),Xe=i("ol"),Xe.innerHTML=Pt,lt=a(),p(ke.$$.fragment),tt=a(),B=i("ol"),B.innerHTML=Dt,st=a(),p(We.$$.fragment),at=a(),p(ve.$$.fragment),nt=a(),Re=i("ol"),Re.innerHTML=Ot,it=a(),Ve=i("p"),Ve.innerHTML=Kt,ot=a(),Ne=i("p"),Ne.innerHTML=es,rt=a(),ze=i("p"),ze.innerHTML=ls,pt=a(),p(Ye.$$.fragment),Mt=a(),Ae=i("p"),this.h()},l(e){const l=rs("svelte-u9bgzb",document.head);U=o(l,"META",{name:!0,content:!0}),l.forEach(t),He=n(e),Fe=o(e,"P",{}),ts(Fe).forEach(t),Ee=n(e),M(G.$$.fragment,e),Le=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1tldvfq"&&(X.innerHTML=mt),Qe=n(e),M(k.$$.fragment,e),xe=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-s7paho"&&(W.textContent=yt),Se=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1spkna0"&&(v.innerHTML=ht),$e=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1dmwjl8"&&(R.innerHTML=ut),qe=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14ypnfq"&&(V.innerHTML=Ut),Pe=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-pmrbdn"&&(N.innerHTML=Tt),De=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1kfsym1"&&(z.innerHTML=Jt),Oe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-11yks9s"&&(Y.innerHTML=wt),Ke=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fhtnhq"&&(F.innerHTML=bt),el=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1fvguoj"&&(A.innerHTML=jt),ll=n(e),M(H.$$.fragment,e),tl=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-fa7yz2"&&(E.innerHTML=gt),sl=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1z0rs1p"&&(L.textContent=ft),al=n(e),Q=o(e,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-t1a84w"&&(Q.innerHTML=_t),nl=n(e),M(x.$$.fragment,e),il=n(e),J=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(J)!=="svelte-sqdvae"&&(J.innerHTML=It),ol=n(e),M(S.$$.fragment,e),rl=n(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-1gjf9fx"&&(w.innerHTML=Ct),pl=n(e),M($.$$.fragment,e),Ml=n(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-1lzju7i"&&(b.innerHTML=Zt),cl=n(e),M(q.$$.fragment,e),dl=n(e),M(P.$$.fragment,e),ml=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1uli7cp"&&(D.innerHTML=Bt),yl=n(e),M(O.$$.fragment,e),hl=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-veib80"&&(K.textContent=Gt),ul=n(e),M(ee.$$.fragment,e),Ul=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1o5yv4m"&&(le.innerHTML=Xt),Tl=n(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-17k5y1l"&&(te.innerHTML=kt),Jl=n(e),M(se.$$.fragment,e),wl=n(e),j=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-149vks6"&&(j.innerHTML=Wt),bl=n(e),M(ae.$$.fragment,e),jl=n(e),g=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-1eoa7yj"&&(g.innerHTML=vt),gl=n(e),M(ne.$$.fragment,e),fl=n(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-zyrcln"&&(f.innerHTML=Rt),_l=n(e),M(ie.$$.fragment,e),Il=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1q0cekw"&&(oe.innerHTML=Vt),Cl=n(e),M(re.$$.fragment,e),Zl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-c0uxew"&&(pe.textContent=Nt),Bl=n(e),M(Me.$$.fragment,e),Gl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-7qf7v1"&&(ce.innerHTML=zt),Xl=n(e),M(de.$$.fragment,e),kl=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-y1muxn"&&(me.textContent=Yt),Wl=n(e),ye=o(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-roprbo"&&(ye.innerHTML=Ft),vl=n(e),M(he.$$.fragment,e),Rl=n(e),_=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(_)!=="svelte-gl5ztl"&&(_.innerHTML=At),Vl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-qz1g9y"&&(ue.innerHTML=Ht),Nl=n(e),M(Ue.$$.fragment,e),zl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1w56eiu"&&(Te.innerHTML=Et),Yl=n(e),M(Je.$$.fragment,e),Fl=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1h21rxf"&&(we.innerHTML=Lt),Al=n(e),M(be.$$.fragment,e),Hl=n(e),M(je.$$.fragment,e),El=n(e),ge=o(e,"OL",{"data-svelte-h":!0}),r(ge)!=="svelte-1nw7kxn"&&(ge.innerHTML=Qt),Ll=n(e),M(fe.$$.fragment,e),Ql=n(e),I=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(I)!=="svelte-4ldwdf"&&(I.innerHTML=xt),xl=n(e),M(_e.$$.fragment,e),Sl=n(e),M(Ie.$$.fragment,e),$l=n(e),Ce=o(e,"OL",{"data-svelte-h":!0}),r(Ce)!=="svelte-vjbue1"&&(Ce.innerHTML=St),ql=n(e),M(Ze.$$.fragment,e),Pl=n(e),C=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-14kb7w1"&&(C.innerHTML=$t),Dl=n(e),M(Be.$$.fragment,e),Ol=n(e),Z=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(Z)!=="svelte-6worco"&&(Z.innerHTML=qt),Kl=n(e),M(Ge.$$.fragment,e),et=n(e),Xe=o(e,"OL",{"data-svelte-h":!0}),r(Xe)!=="svelte-1vfw4du"&&(Xe.innerHTML=Pt),lt=n(e),M(ke.$$.fragment,e),tt=n(e),B=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(B)!=="svelte-1t8cxp8"&&(B.innerHTML=Dt),st=n(e),M(We.$$.fragment,e),at=n(e),M(ve.$$.fragment,e),nt=n(e),Re=o(e,"OL",{"data-svelte-h":!0}),r(Re)!=="svelte-103yt70"&&(Re.innerHTML=Ot),it=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-9pt69j"&&(Ve.innerHTML=Kt),ot=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-ii0ldp"&&(Ne.innerHTML=es),rt=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1ccuece"&&(ze.innerHTML=ls),pt=n(e),M(Ye.$$.fragment,e),Mt=n(e),Ae=o(e,"P",{}),ts(Ae).forEach(t),this.h()},h(){u(U,"name","hf:doc:metadata"),u(U,"content",ds),u(J,"start","2"),u(w,"start","3"),u(b,"start","4"),u(j,"start","2"),u(g,"start","3"),u(f,"start","4"),u(_,"start","2"),u(I,"start","3"),u(C,"start","2"),u(Z,"start","3"),u(B,"start","2")},m(e,l){ps(document.head,U),s(e,He,l),s(e,Fe,l),s(e,Ee,l),c(G,e,l),s(e,Le,l),s(e,X,l),s(e,Qe,l),c(k,e,l),s(e,xe,l),s(e,W,l),s(e,Se,l),s(e,v,l),s(e,$e,l),s(e,R,l),s(e,qe,l),s(e,V,l),s(e,Pe,l),s(e,N,l),s(e,De,l),s(e,z,l),s(e,Oe,l),s(e,Y,l),s(e,Ke,l),s(e,F,l),s(e,el,l),s(e,A,l),s(e,ll,l),c(H,e,l),s(e,tl,l),s(e,E,l),s(e,sl,l),s(e,L,l),s(e,al,l),s(e,Q,l),s(e,nl,l),c(x,e,l),s(e,il,l),s(e,J,l),s(e,ol,l),c(S,e,l),s(e,rl,l),s(e,w,l),s(e,pl,l),c($,e,l),s(e,Ml,l),s(e,b,l),s(e,cl,l),c(q,e,l),s(e,dl,l),c(P,e,l),s(e,ml,l),s(e,D,l),s(e,yl,l),c(O,e,l),s(e,hl,l),s(e,K,l),s(e,ul,l),c(ee,e,l),s(e,Ul,l),s(e,le,l),s(e,Tl,l),s(e,te,l),s(e,Jl,l),c(se,e,l),s(e,wl,l),s(e,j,l),s(e,bl,l),c(ae,e,l),s(e,jl,l),s(e,g,l),s(e,gl,l),c(ne,e,l),s(e,fl,l),s(e,f,l),s(e,_l,l),c(ie,e,l),s(e,Il,l),s(e,oe,l),s(e,Cl,l),c(re,e,l),s(e,Zl,l),s(e,pe,l),s(e,Bl,l),c(Me,e,l),s(e,Gl,l),s(e,ce,l),s(e,Xl,l),c(de,e,l),s(e,kl,l),s(e,me,l),s(e,Wl,l),s(e,ye,l),s(e,vl,l),c(he,e,l),s(e,Rl,l),s(e,_,l),s(e,Vl,l),s(e,ue,l),s(e,Nl,l),c(Ue,e,l),s(e,zl,l),s(e,Te,l),s(e,Yl,l),c(Je,e,l),s(e,Fl,l),s(e,we,l),s(e,Al,l),c(be,e,l),s(e,Hl,l),c(je,e,l),s(e,El,l),s(e,ge,l),s(e,Ll,l),c(fe,e,l),s(e,Ql,l),s(e,I,l),s(e,xl,l),c(_e,e,l),s(e,Sl,l),c(Ie,e,l),s(e,$l,l),s(e,Ce,l),s(e,ql,l),c(Ze,e,l),s(e,Pl,l),s(e,C,l),s(e,Dl,l),c(Be,e,l),s(e,Ol,l),s(e,Z,l),s(e,Kl,l),c(Ge,e,l),s(e,et,l),s(e,Xe,l),s(e,lt,l),c(ke,e,l),s(e,tt,l),s(e,B,l),s(e,st,l),c(We,e,l),s(e,at,l),c(ve,e,l),s(e,nt,l),s(e,Re,l),s(e,it,l),s(e,Ve,l),s(e,ot,l),s(e,Ne,l),s(e,rt,l),s(e,ze,l),s(e,pt,l),c(Ye,e,l),s(e,Mt,l),s(e,Ae,l),ct=!0},p:as,i(e){ct||(d(G.$$.fragment,e),d(k.$$.fragment,e),d(H.$$.fragment,e),d(x.$$.fragment,e),d(S.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(Ue.$$.fragment,e),d(Je.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(_e.$$.fragment,e),d(Ie.$$.fragment,e),d(Ze.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(ve.$$.fragment,e),d(Ye.$$.fragment,e),ct=!0)},o(e){m(G.$$.fragment,e),m(k.$$.fragment,e),m(H.$$.fragment,e),m(x.$$.fragment,e),m(S.$$.fragment,e),m($.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(Ue.$$.fragment,e),m(Je.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(ke.$$.fragment,e),m(We.$$.fragment,e),m(ve.$$.fragment,e),m(Ye.$$.fragment,e),ct=!1},d(e){e&&(t(He),t(Fe),t(Ee),t(Le),t(X),t(Qe),t(xe),t(W),t(Se),t(v),t($e),t(R),t(qe),t(V),t(Pe),t(N),t(De),t(z),t(Oe),t(Y),t(Ke),t(F),t(el),t(A),t(ll),t(tl),t(E),t(sl),t(L),t(al),t(Q),t(nl),t(il),t(J),t(ol),t(rl),t(w),t(pl),t(Ml),t(b),t(cl),t(dl),t(ml),t(D),t(yl),t(hl),t(K),t(ul),t(Ul),t(le),t(Tl),t(te),t(Jl),t(wl),t(j),t(bl),t(jl),t(g),t(gl),t(fl),t(f),t(_l),t(Il),t(oe),t(Cl),t(Zl),t(pe),t(Bl),t(Gl),t(ce),t(Xl),t(kl),t(me),t(Wl),t(ye),t(vl),t(Rl),t(_),t(Vl),t(ue),t(Nl),t(zl),t(Te),t(Yl),t(Fl),t(we),t(Al),t(Hl),t(El),t(ge),t(Ll),t(Ql),t(I),t(xl),t(Sl),t($l),t(Ce),t(ql),t(Pl),t(C),t(Dl),t(Ol),t(Z),t(Kl),t(et),t(Xe),t(lt),t(tt),t(B),t(st),t(at),t(nt),t(Re),t(it),t(Ve),t(ot),t(Ne),t(rt),t(ze),t(pt),t(Mt),t(Ae)),t(U),y(G,e),y(k,e),y(H,e),y(x,e),y(S,e),y($,e),y(q,e),y(P,e),y(O,e),y(ee,e),y(se,e),y(ae,e),y(ne,e),y(ie,e),y(re,e),y(Me,e),y(de,e),y(he,e),y(Ue,e),y(Je,e),y(be,e),y(je,e),y(fe,e),y(_e,e),y(Ie,e),y(Ze,e),y(Be,e),y(Ge,e),y(ke,e),y(We,e),y(ve,e),y(Ye,e)}}}const ds='{"title":"Megatron-LM","local":"megatron-lm","sections":[{"title":"What is integrated?","local":"what-is-integrated","sections":[],"depth":2},{"title":"Pre-Requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Accelerate Megatron-LM Plugin","local":"accelerate-megatron-lm-plugin","sections":[],"depth":2},{"title":"Advanced features to leverage writing custom train step and Megatron-LM Indexed Datasets","local":"advanced-features-to-leverage-writing-custom-train-step-and-megatron-lm-indexed-datasets","sections":[],"depth":2},{"title":"Utility for Checkpoint reshaping and interoperability","local":"utility-for-checkpoint-reshaping-and-interoperability","sections":[],"depth":2},{"title":"Megatron-LM GPT models support returning logits and megatron_generate function for text generation","local":"megatron-lm-gpt-models-support-returning-logits-and-megatrongenerate-function-for-text-generation","sections":[],"depth":2},{"title":"Support for ROPE and ALiBi Positional embeddings and Multi-Query Attention","local":"support-for-rope-and-alibi-positional-embeddings-and-multi-query-attention","sections":[],"depth":2},{"title":"Caveats","local":"caveats","sections":[],"depth":2}],"depth":1}';function ms(dt){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends is{constructor(U){super(),os(this,U,ms,cs,ss,{})}}export{Ts as component};
