import{s as os,o as ss,n as G}from"../chunks/scheduler.182ea377.js";import{S as is,i as as,g as l,s,r as g,A as ls,h as r,f as d,c as i,j as J,u as h,x as m,k as S,y as n,a as $,v as _,d as b,t as y,w}from"../chunks/index.abf12888.js";import{T as bo}from"../chunks/Tip.230e2334.js";import{D}from"../chunks/Docstring.93f6f462.js";import{C as q}from"../chunks/CodeBlock.57fe6e13.js";import{E as H}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Nt}from"../chunks/Heading.16916d63.js";function rs(M){let o,T='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,a,f='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){o=l("p"),o.innerHTML=T,c=s(),a=l("p"),a.innerHTML=f},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1j961ct"&&(o.innerHTML=T),c=i(t),a=r(t,"P",{"data-svelte-h":!0}),m(a)!=="svelte-z4pn9c"&&(a.innerHTML=f)},m(t,x){$(t,o,x),$(t,c,x),$(t,a,x)},p:G,d(t){t&&(d(o),d(c),d(a))}}}function ds(M){let o,T="Examples:",c,a,f;return a=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function cs(M){let o,T=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=l("p"),o.innerHTML=T},l(c){o=r(c,"P",{"data-svelte-h":!0}),m(o)!=="svelte-ackzsn"&&(o.innerHTML=T)},m(c,a){$(c,o,a)},p:G,d(c){c&&d(o)}}}function ps(M){let o,T="Examples:",c,a,f;return a=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function fs(M){let o,T=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=l("p"),o.textContent=T},l(c){o=r(c,"P",{"data-svelte-h":!0}),m(o)!=="svelte-17p1lpg"&&(o.textContent=T)},m(c,a){$(c,o,a)},p:G,d(c){c&&d(o)}}}function ms(M){let o,T="Examples:",c,a,f;return a=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function us(M){let o,T="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,a,f;return a=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1gc783q"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function gs(M){let o,T="locally:",c,a,f;return a=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-4c75kq"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function hs(M){let o,T="Examples:",c,a,f;return a=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function _s(M){let o,T="Example:",c,a,f;return a=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMEElMjAlMjAlMjAlMjAlMjJZbnRlYyUyRnBpbmVhcHBsZUFuaW1lTWl4JTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJwaW5lYXBwbGVBbmltZU1peF9waW5lYXBwbGUxMC4xLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYW5pbWUlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;Yntec/pineappleAnimeMix&quot;</span>, weight_name=<span class="hljs-string">&quot;pineappleAnimeMix_pineapple10.1.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;anime&quot;</span>
)`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function bs(M){let o,T="Example:",c,a,f;return a=new q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFmcm9tJTIwcGVmdC51dGlscyUyMGltcG9ydCUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMm5lcmlqcyUyRnBpeGVsLWFydC14bCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycGl4ZWwtYXJ0LXhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycGl4ZWwlMjIpJTBBcGlwZWxpbmUuZnVzZV9sb3JhKCklMEElMEElMjMlMjBnZXQlMjBhbmQlMjBzYXZlJTIwdW5ldCUyMHN0YXRlJTIwZGljdCUwQXVuZXRfc3RhdGVfZGljdCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QocGlwZWxpbmUudW5ldCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBpeGVsJTIyKSUwQXBpcGVsaW5lLnNhdmVfbG9yYV93ZWlnaHRzKCUyMmZ1c2VkLW1vZGVsJTIyJTJDJTIwdW5ldF9sb3JhX2xheWVycyUzRHVuZXRfc3RhdGVfZGljdCklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJmdXNlZC1tb2RlbCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> peft.utils <span class="hljs-keyword">import</span> get_peft_model_state_dict
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;nerijs/pixel-art-xl&quot;</span>, weight_name=<span class="hljs-string">&quot;pixel-art-xl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.fuse_lora()

<span class="hljs-comment"># get and save unet state dict</span>
unet_state_dict = get_peft_model_state_dict(pipeline.unet, adapter_name=<span class="hljs-string">&quot;pixel&quot;</span>)
pipeline.save_lora_weights(<span class="hljs-string">&quot;fused-model&quot;</span>, unet_lora_layers=unet_state_dict)
pipeline.load_lora_weights(<span class="hljs-string">&quot;fused-model&quot;</span>, weight_name=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function ys(M){let o,T="Examples:",c,a,f;return a=new q({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uUFJOR0tleSgwKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQW51bV9zYW1wbGVzJTIwJTNEJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0JTIwJTNEJTIwbnVtX3NhbXBsZXMlMjAqJTIwJTVCcHJvbXB0JTVEJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEElMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jax.numpy.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipeline.prepare_inputs(prompt)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){o=l("p"),o.textContent=T,c=s(),g(a.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=i(t),h(a.$$.fragment,t)},m(t,x){$(t,o,x),$(t,c,x),_(a,t,x),f=!0},p:G,i(t){f||(b(a.$$.fragment,t),f=!0)},o(t){y(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),w(a,t)}}}function ws(M){let o,T,c,a,f,t,x,yo='The Stable Diffusion model was created by researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://github.com/runwayml" rel="nofollow">Runway</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> is capable of generating photorealistic images given any text input. It’s trained on 512x512 images from a subset of the LAION-5B dataset. This model uses a frozen CLIP ViT-L/14 text encoder to condition the model on text prompts. With its 860M UNet and 123M text encoder, the model is relatively lightweight and can run on consumer GPUs. Latent diffusion is the research on top of which Stable Diffusion was built. It was proposed in <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image Synthesis with Latent Diffusion Models</a> by Robin Rombach, Andreas Blattmann, Dominik Lorenz, Patrick Esser, Björn Ommer.',Bt,we,wo="The abstract from the paper is:",Vt,xe,xo='<em>By decomposing the image formation process into a sequential application of denoising autoencoders, diffusion models (DMs) achieve state-of-the-art synthesis results on image data and beyond. Additionally, their formulation allows for a guiding mechanism to control the image generation process without retraining. However, since these models typically operate directly in pixel space, optimization of powerful DMs often consumes hundreds of GPU days and inference is expensive due to sequential evaluations. To enable DM training on limited computational resources while retaining their quality and flexibility, we apply them in the latent space of powerful pretrained autoencoders. In contrast to previous work, training diffusion models on such a representation allows for the first time to reach a near-optimal point between complexity reduction and detail preservation, greatly boosting visual fidelity. By introducing cross-attention layers into the model architecture, we turn diffusion models into powerful and flexible generators for general conditioning inputs such as text or bounding boxes and high-resolution synthesis becomes possible in a convolutional manner. Our latent diffusion models (LDMs) achieve a new state of the art for image inpainting and highly competitive performance on various tasks, including unconditional image generation, semantic scene synthesis, and super-resolution, while significantly reducing computational requirements compared to pixel-based DMs. Code is available at <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">https://github.com/CompVis/latent-diffusion</a>.</em>',Rt,A,Et,ve,zt,u,$e,an,tt,vo="Pipeline for text-to-image generation using Stable Diffusion.",ln,nt,$o=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,rn,ot,To="The pipeline also inherits the following loading methods:",dn,st,Mo='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><code>load_ip_adapter()</code> for loading IP Adapters</li>',cn,B,Te,pn,it,Jo="The call function to the pipeline for generation.",fn,Q,mn,j,Me,un,at,So=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,gn,O,hn,K,_n,ee,Je,bn,lt,Do=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,yn,te,Se,wn,rt,Po=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,xn,ne,De,vn,dt,ko=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,$n,Z,Pe,Tn,ct,Uo=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Mn,oe,Jn,se,Sn,ie,ke,Dn,pt,Io='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Pn,ae,Ue,kn,ft,Co=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Un,le,Ie,In,mt,jo=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Cn,k,Ce,jn,ut,Zo=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Zn,gt,Wo="Example:",Wn,re,Gn,ht,Go=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Ln,de,Fn,V,je,Nn,_t,Lo=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Bn,ce,Vn,P,Ze,Rn,bt,Fo=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,En,yt,No="All kwargs are forwarded to <code>self.lora_state_dict</code>.",zn,wt,Bo='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Xn,xt,Vo=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Yn,vt,Ro=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Hn,pe,qn,R,We,An,$t,Eo="Save the UNet and text encoder LoRA parameters.",Qn,fe,On,me,Ge,Kn,Tt,zo="Disables the FreeU mechanism if enabled.",eo,W,Le,to,Mt,Xo='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',no,Jt,Yo="The suffixes after the scaling factors represent the stages where they are being applied.",oo,St,Ho=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,so,ue,Fe,io,Dt,qo="Encodes the prompt into text encoder hidden states.",ao,ge,Ne,lo,Pt,Ao='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Xt,Be,Yt,z,Ve,ro,kt,Qo="Output class for Stable Diffusion pipelines.",Ht,Re,qt,C,Ee,co,Ut,Oo="Flax-based pipeline for text-to-image generation using Stable Diffusion.",po,It,Ko=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,fo,E,ze,mo,Ct,es="The call function to the pipeline for generation.",uo,he,At,Xe,Qt,L,Ye,go,jt,ts="Output class for Flax-based Stable Diffusion pipelines.",ho,_e,He,_o,Zt,ns="“Returns a new object replacing the specified fields with new values.",Ot,Ft,Kt;return f=new Nt({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),A=new bo({props:{$$slots:{default:[rs]},$$scope:{ctx:M}}}),ve=new Nt({props:{title:"StableDiffusionPipeline",local:"diffusers.StableDiffusionPipeline",headingTag:"h2"}}),$e=new D({props:{name:"class diffusers.StableDiffusionPipeline",anchor:"diffusers.StableDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L73"}}),Te=new D({props:{name:"__call__",anchor:"diffusers.StableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L654",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Q=new H({props:{anchor:"diffusers.StableDiffusionPipeline.__call__.example",$$slots:{default:[ds]},$$scope:{ctx:M}}}),Me=new D({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2046"}}),O=new bo({props:{warning:!0,$$slots:{default:[cs]},$$scope:{ctx:M}}}),K=new H({props:{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[ps]},$$scope:{ctx:M}}}),Je=new D({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2086"}}),Se=new D({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L206"}}),De=new D({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L213"}}),Pe=new D({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1985"}}),oe=new bo({props:{warning:!0,$$slots:{default:[fs]},$$scope:{ctx:M}}}),se=new H({props:{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ms]},$$scope:{ctx:M}}}),ke=new D({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2020"}}),Ue=new D({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L220"}}),Ie=new D({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L228"}}),Ce=new D({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L270"}}),re=new H({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example",$$slots:{default:[us]},$$scope:{ctx:M}}}),de=new H({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example-2",$$slots:{default:[gs]},$$scope:{ctx:M}}}),je=new D({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L54"}}),ce=new H({props:{anchor:"diffusers.StableDiffusionPipeline.from_single_file.example",$$slots:{default:[hs]},$$scope:{ctx:M}}}),Ze=new D({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
A string (model id of a pretrained model hosted on the Hub), a path to a directory containing the model
weights, or a <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name for referencing the loaded adapter model. If not specified, it will use <code>default_{i}</code> where <code>i</code> is
the total number of adapters being loaded. Must have PEFT installed to use.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L107"}}),pe=new H({props:{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.example",$$slots:{default:[_s]},$$scope:{ctx:M}}}),We=new D({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to (will be created if it doesn&#x2019;t exist).`,name:"save_directory"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dict. Useful during distributed training when you need to replace
<code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L912"}}),fe=new H({props:{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.example",$$slots:{default:[bs]},$$scope:{ctx:M}}}),Ge=new D({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L594"}}),Le=new D({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L572"}}),Fe=new D({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L267"}}),Ne=new D({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L599",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Be=new Nt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Ve=new D({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),Re=new Nt({props:{title:"FlaxStableDiffusionPipeline",local:"diffusers.FlaxStableDiffusionPipeline",headingTag:"h2"}}),Ee=new D({props:{name:"class diffusers.FlaxStableDiffusionPipeline",anchor:"diffusers.FlaxStableDiffusionPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_flax.FlaxDDIMScheduler, diffusers.schedulers.scheduling_pndm_flax.FlaxPNDMScheduler, diffusers.schedulers.scheduling_lms_discrete_flax.FlaxLMSDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep_flax.FlaxDPMSolverMultistepScheduler]"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L81"}}),ze=new D({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionPipeline.__call__",parameters:[{name:"prompt_ids",val:": array"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Union[float, jax.Array] = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L310",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),he=new H({props:{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.example",$$slots:{default:[ys]},$$scope:{ctx:M}}}),Xe=new Nt({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Ye=new D({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": typing.List[bool]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L32"}}),He=new D({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){o=l("meta"),T=s(),c=l("p"),a=s(),g(f.$$.fragment),t=s(),x=l("p"),x.innerHTML=yo,Bt=s(),we=l("p"),we.textContent=wo,Vt=s(),xe=l("p"),xe.innerHTML=xo,Rt=s(),g(A.$$.fragment),Et=s(),g(ve.$$.fragment),zt=s(),u=l("div"),g($e.$$.fragment),an=s(),tt=l("p"),tt.textContent=vo,ln=s(),nt=l("p"),nt.innerHTML=$o,rn=s(),ot=l("p"),ot.textContent=To,dn=s(),st=l("ul"),st.innerHTML=Mo,cn=s(),B=l("div"),g(Te.$$.fragment),pn=s(),it=l("p"),it.textContent=Jo,fn=s(),g(Q.$$.fragment),mn=s(),j=l("div"),g(Me.$$.fragment),un=s(),at=l("p"),at.textContent=So,gn=s(),g(O.$$.fragment),hn=s(),g(K.$$.fragment),_n=s(),ee=l("div"),g(Je.$$.fragment),bn=s(),lt=l("p"),lt.innerHTML=Do,yn=s(),te=l("div"),g(Se.$$.fragment),wn=s(),rt=l("p"),rt.textContent=Po,xn=s(),ne=l("div"),g(De.$$.fragment),vn=s(),dt=l("p"),dt.innerHTML=ko,$n=s(),Z=l("div"),g(Pe.$$.fragment),Tn=s(),ct=l("p"),ct.innerHTML=Uo,Mn=s(),g(oe.$$.fragment),Jn=s(),g(se.$$.fragment),Sn=s(),ie=l("div"),g(ke.$$.fragment),Dn=s(),pt=l("p"),pt.innerHTML=Io,Pn=s(),ae=l("div"),g(Ue.$$.fragment),kn=s(),ft=l("p"),ft.textContent=Co,Un=s(),le=l("div"),g(Ie.$$.fragment),In=s(),mt=l("p"),mt.innerHTML=jo,Cn=s(),k=l("div"),g(Ce.$$.fragment),jn=s(),ut=l("p"),ut.innerHTML=Zo,Zn=s(),gt=l("p"),gt.textContent=Wo,Wn=s(),g(re.$$.fragment),Gn=s(),ht=l("p"),ht.innerHTML=Go,Ln=s(),g(de.$$.fragment),Fn=s(),V=l("div"),g(je.$$.fragment),Nn=s(),_t=l("p"),_t.innerHTML=Lo,Bn=s(),g(ce.$$.fragment),Vn=s(),P=l("div"),g(Ze.$$.fragment),Rn=s(),bt=l("p"),bt.innerHTML=Fo,En=s(),yt=l("p"),yt.innerHTML=No,zn=s(),wt=l("p"),wt.innerHTML=Bo,Xn=s(),xt=l("p"),xt.innerHTML=Vo,Yn=s(),vt=l("p"),vt.innerHTML=Ro,Hn=s(),g(pe.$$.fragment),qn=s(),R=l("div"),g(We.$$.fragment),An=s(),$t=l("p"),$t.textContent=Eo,Qn=s(),g(fe.$$.fragment),On=s(),me=l("div"),g(Ge.$$.fragment),Kn=s(),Tt=l("p"),Tt.textContent=zo,eo=s(),W=l("div"),g(Le.$$.fragment),to=s(),Mt=l("p"),Mt.innerHTML=Xo,no=s(),Jt=l("p"),Jt.textContent=Yo,oo=s(),St=l("p"),St.innerHTML=Ho,so=s(),ue=l("div"),g(Fe.$$.fragment),io=s(),Dt=l("p"),Dt.textContent=qo,ao=s(),ge=l("div"),g(Ne.$$.fragment),lo=s(),Pt=l("p"),Pt.innerHTML=Ao,Xt=s(),g(Be.$$.fragment),Yt=s(),z=l("div"),g(Ve.$$.fragment),ro=s(),kt=l("p"),kt.textContent=Qo,Ht=s(),g(Re.$$.fragment),qt=s(),C=l("div"),g(Ee.$$.fragment),co=s(),Ut=l("p"),Ut.textContent=Oo,po=s(),It=l("p"),It.innerHTML=Ko,fo=s(),E=l("div"),g(ze.$$.fragment),mo=s(),Ct=l("p"),Ct.textContent=es,uo=s(),g(he.$$.fragment),At=s(),g(Xe.$$.fragment),Qt=s(),L=l("div"),g(Ye.$$.fragment),go=s(),jt=l("p"),jt.textContent=ts,ho=s(),_e=l("div"),g(He.$$.fragment),_o=s(),Zt=l("p"),Zt.textContent=ns,Ot=s(),Ft=l("p"),this.h()},l(e){const p=ls("svelte-u9bgzb",document.head);o=r(p,"META",{name:!0,content:!0}),p.forEach(d),T=i(e),c=r(e,"P",{}),J(c).forEach(d),a=i(e),h(f.$$.fragment,e),t=i(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1p4bu1q"&&(x.innerHTML=yo),Bt=i(e),we=r(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1cwsb16"&&(we.textContent=wo),Vt=i(e),xe=r(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1xoozhu"&&(xe.innerHTML=xo),Rt=i(e),h(A.$$.fragment,e),Et=i(e),h(ve.$$.fragment,e),zt=i(e),u=r(e,"DIV",{class:!0});var v=J(u);h($e.$$.fragment,v),an=i(v),tt=r(v,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-35p306"&&(tt.textContent=vo),ln=i(v),nt=r(v,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-496sm0"&&(nt.innerHTML=$o),rn=i(v),ot=r(v,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-14s6m4u"&&(ot.textContent=To),dn=i(v),st=r(v,"UL",{"data-svelte-h":!0}),m(st)!=="svelte-14dmjhe"&&(st.innerHTML=Mo),cn=i(v),B=r(v,"DIV",{class:!0});var X=J(B);h(Te.$$.fragment,X),pn=i(X),it=r(X,"P",{"data-svelte-h":!0}),m(it)!=="svelte-50j04k"&&(it.textContent=Jo),fn=i(X),h(Q.$$.fragment,X),X.forEach(d),mn=i(v),j=r(v,"DIV",{class:!0});var F=J(j);h(Me.$$.fragment,F),un=i(F),at=r(F,"P",{"data-svelte-h":!0}),m(at)!=="svelte-10jaql7"&&(at.textContent=So),gn=i(F),h(O.$$.fragment,F),hn=i(F),h(K.$$.fragment,F),F.forEach(d),_n=i(v),ee=r(v,"DIV",{class:!0});var qe=J(ee);h(Je.$$.fragment,qe),bn=i(qe),lt=r(qe,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1lh0nh5"&&(lt.innerHTML=Do),qe.forEach(d),yn=i(v),te=r(v,"DIV",{class:!0});var Ae=J(te);h(Se.$$.fragment,Ae),wn=i(Ae),rt=r(Ae,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-14bnrb6"&&(rt.textContent=Po),Ae.forEach(d),xn=i(v),ne=r(v,"DIV",{class:!0});var Qe=J(ne);h(De.$$.fragment,Qe),vn=i(Qe),dt=r(Qe,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-1s3c06i"&&(dt.innerHTML=ko),Qe.forEach(d),$n=i(v),Z=r(v,"DIV",{class:!0});var N=J(Z);h(Pe.$$.fragment,N),Tn=i(N),ct=r(N,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-e03q3e"&&(ct.innerHTML=Uo),Mn=i(N),h(oe.$$.fragment,N),Jn=i(N),h(se.$$.fragment,N),N.forEach(d),Sn=i(v),ie=r(v,"DIV",{class:!0});var Oe=J(ie);h(ke.$$.fragment,Oe),Dn=i(Oe),pt=r(Oe,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1vfte1e"&&(pt.innerHTML=Io),Oe.forEach(d),Pn=i(v),ae=r(v,"DIV",{class:!0});var Ke=J(ae);h(Ue.$$.fragment,Ke),kn=i(Ke),ft=r(Ke,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1xwrf7t"&&(ft.textContent=Co),Ke.forEach(d),Un=i(v),le=r(v,"DIV",{class:!0});var et=J(le);h(Ie.$$.fragment,et),In=i(et),mt=r(et,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-pkn4ui"&&(mt.innerHTML=jo),et.forEach(d),Cn=i(v),k=r(v,"DIV",{class:!0});var U=J(k);h(Ce.$$.fragment,U),jn=i(U),ut=r(U,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1lv88wo"&&(ut.innerHTML=Zo),Zn=i(U),gt=r(U,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-11lpom8"&&(gt.textContent=Wo),Wn=i(U),h(re.$$.fragment,U),Gn=i(U),ht=r(U,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-15d7mv5"&&(ht.innerHTML=Go),Ln=i(U),h(de.$$.fragment,U),U.forEach(d),Fn=i(v),V=r(v,"DIV",{class:!0});var Y=J(V);h(je.$$.fragment,Y),Nn=i(Y),_t=r(Y,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-pmqrln"&&(_t.innerHTML=Lo),Bn=i(Y),h(ce.$$.fragment,Y),Y.forEach(d),Vn=i(v),P=r(v,"DIV",{class:!0});var I=J(P);h(Ze.$$.fragment,I),Rn=i(I),bt=r(I,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-vs7s0z"&&(bt.innerHTML=Fo),En=i(I),yt=r(I,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-15b960v"&&(yt.innerHTML=No),zn=i(I),wt=r(I,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-12uyc98"&&(wt.innerHTML=Bo),Xn=i(I),xt=r(I,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-1q3yzk7"&&(xt.innerHTML=Vo),Yn=i(I),vt=r(I,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-10xxjud"&&(vt.innerHTML=Ro),Hn=i(I),h(pe.$$.fragment,I),I.forEach(d),qn=i(v),R=r(v,"DIV",{class:!0});var Wt=J(R);h(We.$$.fragment,Wt),An=i(Wt),$t=r(Wt,"P",{"data-svelte-h":!0}),m($t)!=="svelte-1ac6d9e"&&($t.textContent=Eo),Qn=i(Wt),h(fe.$$.fragment,Wt),Wt.forEach(d),On=i(v),me=r(v,"DIV",{class:!0});var en=J(me);h(Ge.$$.fragment,en),Kn=i(en),Tt=r(en,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-psupw6"&&(Tt.textContent=zo),en.forEach(d),eo=i(v),W=r(v,"DIV",{class:!0});var be=J(W);h(Le.$$.fragment,be),to=i(be),Mt=r(be,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1f3tmq1"&&(Mt.innerHTML=Xo),no=i(be),Jt=r(be,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-xjijlp"&&(Jt.textContent=Yo),oo=i(be),St=r(be,"P",{"data-svelte-h":!0}),m(St)!=="svelte-hy0nzs"&&(St.innerHTML=Ho),be.forEach(d),so=i(v),ue=r(v,"DIV",{class:!0});var tn=J(ue);h(Fe.$$.fragment,tn),io=i(tn),Dt=r(tn,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-16q0ax1"&&(Dt.textContent=qo),tn.forEach(d),ao=i(v),ge=r(v,"DIV",{class:!0});var nn=J(ge);h(Ne.$$.fragment,nn),lo=i(nn),Pt=r(nn,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-vo59ec"&&(Pt.innerHTML=Ao),nn.forEach(d),v.forEach(d),Xt=i(e),h(Be.$$.fragment,e),Yt=i(e),z=r(e,"DIV",{class:!0});var on=J(z);h(Ve.$$.fragment,on),ro=i(on),kt=r(on,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1qpjiuf"&&(kt.textContent=Qo),on.forEach(d),Ht=i(e),h(Re.$$.fragment,e),qt=i(e),C=r(e,"DIV",{class:!0});var ye=J(C);h(Ee.$$.fragment,ye),co=i(ye),Ut=r(ye,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-d05p75"&&(Ut.textContent=Oo),po=i(ye),It=r(ye,"P",{"data-svelte-h":!0}),m(It)!=="svelte-knddhk"&&(It.innerHTML=Ko),fo=i(ye),E=r(ye,"DIV",{class:!0});var Gt=J(E);h(ze.$$.fragment,Gt),mo=i(Gt),Ct=r(Gt,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-50j04k"&&(Ct.textContent=es),uo=i(Gt),h(he.$$.fragment,Gt),Gt.forEach(d),ye.forEach(d),At=i(e),h(Xe.$$.fragment,e),Qt=i(e),L=r(e,"DIV",{class:!0});var Lt=J(L);h(Ye.$$.fragment,Lt),go=i(Lt),jt=r(Lt,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-wzv2jc"&&(jt.textContent=ts),ho=i(Lt),_e=r(Lt,"DIV",{class:!0});var sn=J(_e);h(He.$$.fragment,sn),_o=i(sn),Zt=r(sn,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-5ihtpa"&&(Zt.textContent=ns),sn.forEach(d),Lt.forEach(d),Ot=i(e),Ft=r(e,"P",{}),J(Ft).forEach(d),this.h()},h(){S(o,"name","hf:doc:metadata"),S(o,"content",xs),S(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){n(document.head,o),$(e,T,p),$(e,c,p),$(e,a,p),_(f,e,p),$(e,t,p),$(e,x,p),$(e,Bt,p),$(e,we,p),$(e,Vt,p),$(e,xe,p),$(e,Rt,p),_(A,e,p),$(e,Et,p),_(ve,e,p),$(e,zt,p),$(e,u,p),_($e,u,null),n(u,an),n(u,tt),n(u,ln),n(u,nt),n(u,rn),n(u,ot),n(u,dn),n(u,st),n(u,cn),n(u,B),_(Te,B,null),n(B,pn),n(B,it),n(B,fn),_(Q,B,null),n(u,mn),n(u,j),_(Me,j,null),n(j,un),n(j,at),n(j,gn),_(O,j,null),n(j,hn),_(K,j,null),n(u,_n),n(u,ee),_(Je,ee,null),n(ee,bn),n(ee,lt),n(u,yn),n(u,te),_(Se,te,null),n(te,wn),n(te,rt),n(u,xn),n(u,ne),_(De,ne,null),n(ne,vn),n(ne,dt),n(u,$n),n(u,Z),_(Pe,Z,null),n(Z,Tn),n(Z,ct),n(Z,Mn),_(oe,Z,null),n(Z,Jn),_(se,Z,null),n(u,Sn),n(u,ie),_(ke,ie,null),n(ie,Dn),n(ie,pt),n(u,Pn),n(u,ae),_(Ue,ae,null),n(ae,kn),n(ae,ft),n(u,Un),n(u,le),_(Ie,le,null),n(le,In),n(le,mt),n(u,Cn),n(u,k),_(Ce,k,null),n(k,jn),n(k,ut),n(k,Zn),n(k,gt),n(k,Wn),_(re,k,null),n(k,Gn),n(k,ht),n(k,Ln),_(de,k,null),n(u,Fn),n(u,V),_(je,V,null),n(V,Nn),n(V,_t),n(V,Bn),_(ce,V,null),n(u,Vn),n(u,P),_(Ze,P,null),n(P,Rn),n(P,bt),n(P,En),n(P,yt),n(P,zn),n(P,wt),n(P,Xn),n(P,xt),n(P,Yn),n(P,vt),n(P,Hn),_(pe,P,null),n(u,qn),n(u,R),_(We,R,null),n(R,An),n(R,$t),n(R,Qn),_(fe,R,null),n(u,On),n(u,me),_(Ge,me,null),n(me,Kn),n(me,Tt),n(u,eo),n(u,W),_(Le,W,null),n(W,to),n(W,Mt),n(W,no),n(W,Jt),n(W,oo),n(W,St),n(u,so),n(u,ue),_(Fe,ue,null),n(ue,io),n(ue,Dt),n(u,ao),n(u,ge),_(Ne,ge,null),n(ge,lo),n(ge,Pt),$(e,Xt,p),_(Be,e,p),$(e,Yt,p),$(e,z,p),_(Ve,z,null),n(z,ro),n(z,kt),$(e,Ht,p),_(Re,e,p),$(e,qt,p),$(e,C,p),_(Ee,C,null),n(C,co),n(C,Ut),n(C,po),n(C,It),n(C,fo),n(C,E),_(ze,E,null),n(E,mo),n(E,Ct),n(E,uo),_(he,E,null),$(e,At,p),_(Xe,e,p),$(e,Qt,p),$(e,L,p),_(Ye,L,null),n(L,go),n(L,jt),n(L,ho),n(L,_e),_(He,_e,null),n(_e,_o),n(_e,Zt),$(e,Ot,p),$(e,Ft,p),Kt=!0},p(e,[p]){const v={};p&2&&(v.$$scope={dirty:p,ctx:e}),A.$set(v);const X={};p&2&&(X.$$scope={dirty:p,ctx:e}),Q.$set(X);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),O.$set(F);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),K.$set(qe);const Ae={};p&2&&(Ae.$$scope={dirty:p,ctx:e}),oe.$set(Ae);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),se.$set(Qe);const N={};p&2&&(N.$$scope={dirty:p,ctx:e}),re.$set(N);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),de.$set(Oe);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:e}),ce.$set(Ke);const et={};p&2&&(et.$$scope={dirty:p,ctx:e}),pe.$set(et);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),fe.$set(U);const Y={};p&2&&(Y.$$scope={dirty:p,ctx:e}),he.$set(Y)},i(e){Kt||(b(f.$$.fragment,e),b(A.$$.fragment,e),b(ve.$$.fragment,e),b($e.$$.fragment,e),b(Te.$$.fragment,e),b(Q.$$.fragment,e),b(Me.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(Je.$$.fragment,e),b(Se.$$.fragment,e),b(De.$$.fragment,e),b(Pe.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(ke.$$.fragment,e),b(Ue.$$.fragment,e),b(Ie.$$.fragment,e),b(Ce.$$.fragment,e),b(re.$$.fragment,e),b(de.$$.fragment,e),b(je.$$.fragment,e),b(ce.$$.fragment,e),b(Ze.$$.fragment,e),b(pe.$$.fragment,e),b(We.$$.fragment,e),b(fe.$$.fragment,e),b(Ge.$$.fragment,e),b(Le.$$.fragment,e),b(Fe.$$.fragment,e),b(Ne.$$.fragment,e),b(Be.$$.fragment,e),b(Ve.$$.fragment,e),b(Re.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(he.$$.fragment,e),b(Xe.$$.fragment,e),b(Ye.$$.fragment,e),b(He.$$.fragment,e),Kt=!0)},o(e){y(f.$$.fragment,e),y(A.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),y(Te.$$.fragment,e),y(Q.$$.fragment,e),y(Me.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(Je.$$.fragment,e),y(Se.$$.fragment,e),y(De.$$.fragment,e),y(Pe.$$.fragment,e),y(oe.$$.fragment,e),y(se.$$.fragment,e),y(ke.$$.fragment,e),y(Ue.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(re.$$.fragment,e),y(de.$$.fragment,e),y(je.$$.fragment,e),y(ce.$$.fragment,e),y(Ze.$$.fragment,e),y(pe.$$.fragment,e),y(We.$$.fragment,e),y(fe.$$.fragment,e),y(Ge.$$.fragment,e),y(Le.$$.fragment,e),y(Fe.$$.fragment,e),y(Ne.$$.fragment,e),y(Be.$$.fragment,e),y(Ve.$$.fragment,e),y(Re.$$.fragment,e),y(Ee.$$.fragment,e),y(ze.$$.fragment,e),y(he.$$.fragment,e),y(Xe.$$.fragment,e),y(Ye.$$.fragment,e),y(He.$$.fragment,e),Kt=!1},d(e){e&&(d(T),d(c),d(a),d(t),d(x),d(Bt),d(we),d(Vt),d(xe),d(Rt),d(Et),d(zt),d(u),d(Xt),d(Yt),d(z),d(Ht),d(qt),d(C),d(At),d(Qt),d(L),d(Ot),d(Ft)),d(o),w(f,e),w(A,e),w(ve,e),w($e),w(Te),w(Q),w(Me),w(O),w(K),w(Je),w(Se),w(De),w(Pe),w(oe),w(se),w(ke),w(Ue),w(Ie),w(Ce),w(re),w(de),w(je),w(ce),w(Ze),w(pe),w(We),w(fe),w(Ge),w(Le),w(Fe),w(Ne),w(Be,e),w(Ve),w(Re,e),w(Ee),w(ze),w(he),w(Xe,e),w(Ye),w(He)}}}const xs='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"StableDiffusionPipeline","local":"diffusers.StableDiffusionPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipeline","local":"diffusers.FlaxStableDiffusionPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function vs(M){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ks extends is{constructor(o){super(),as(this,o,vs,ws,os,{})}}export{ks as component};
