import{s as ss,f as ul,o as ns,n as ls}from"../chunks/scheduler.9039eef2.js";import{S as as,i as is,g as i,s as n,r as o,A as ps,h as p,f as l,c as a,j as es,u as r,x as m,k as w,y as ms,a as s,v as u,d as c,t as d,w as M}from"../chunks/index.cdcc3d35.js";import{T as ts}from"../chunks/Tip.6f74db41.js";import{C as f}from"../chunks/CodeBlock.e3ac94d9.js";import{H as h}from"../chunks/Heading.96ce3702.js";function os(Fe){let y,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",g,b,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){y=i("p"),y.innerHTML=T,g=n(),b=i("p"),b.innerHTML=j},l(J){y=p(J,"P",{"data-svelte-h":!0}),m(y)!=="svelte-6bhicj"&&(y.innerHTML=T),g=a(J),b=p(J,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1dh7n4s"&&(b.innerHTML=j)},m(J,U){s(J,y,U),s(J,g,U),s(J,b,U)},p:ls,d(J){J&&(l(y),l(g),l(b))}}}function rs(Fe){let y,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){y=i("p"),y.textContent=T},l(g){y=p(g,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1323ut2"&&(y.textContent=T)},m(g,b){s(g,y,b)},p:ls,d(g){g&&l(y)}}}function us(Fe){let y,T,g,b,j,J,U,Ee,C,cl="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",ze,B,dl='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',Le,V,qe,_,Ae,v,Ml="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",De,N,yl="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",Pe,$,hl="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",Ke,k,gl="<strong><em>Export via CLI</em></strong>",Oe,R,fl="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",et,x,tt,S,bl="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",lt,Y,Jl="<strong><em>Export via Python API</em></strong>",st,Q,wl="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",nt,G,at,F,it,H,pt,E,Ul="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",mt,z,Tl="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",ot,L,rt,Z,jl,ut,q,ct,A,Zl="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",dt,D,Mt,P,Wl='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',yt,K,ht,O,Il="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",gt,ee,ft,te,Gl='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',bt,le,Jt,se,Xl="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",wt,ne,Ut,ae,Cl="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",Tt,ie,Bl="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",jt,pe,Vl="<strong><em>Export via CLI</em></strong>",Zt,me,_l="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",Wt,oe,It,re,vl="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Gt,ue,Nl="<strong><em>Export via Python API</em></strong>",Xt,ce,$l="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",Ct,de,Bt,Me,Vt,ye,kl="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",_t,he,vt,W,Rl,Nt,ge,$t,fe,xl="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",kt,be,Rt,Je,Sl='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',xt,we,St,Ue,Yl="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",Yt,Te,Qt,je,Ql='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Ft,Ze,Ht,We,Fl='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',Et,Ie,Hl="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",zt,Ge,Lt,Xe,qt,I,El,At,Ce,Dt,Be,Pt,Ve,zl='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',Kt,X,Ot,_e,el,ve,Ll='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',tl,Ne,ql='Here is an example to compile a LCM of Stable Diffusion XL: <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> and run inference on AWS Inferentia 2 :',ll,$e,sl,ke,Al="<strong><em>Export via Python API</em></strong>",nl,Re,al,xe,il,Se,Dl="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",pl,Ye,ml,Qe,Pl='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',ol,He,rl;return j=new h({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),V=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),_=new h({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),x=new f({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDUxMiUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0td2lkdGglMjA1MTIlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --task stable-diffusion \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),G=new ts({props:{$$slots:{default:[os]},$$scope:{ctx:Fe}}}),F=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzJTJDJTIwZGV2aWNlX2lkcyUzRCU1QjAlMkMlMjAxJTVEKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),L=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),D=new f({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),K=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),ee=new f({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),le=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ne=new h({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),oe=new f({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDEwMjQlMjAlNjAlMjMlMjBoZWlnaHQlMjBpbiUyMHBpeGVscyUyMG9mJTIwZ2VuZXJhdGVkJTIwaW1hZ2UlMkMlMjBlZy4lMjA3NjglMkMlMjAxMDI0JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDEwMjQlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDQlMjAlNjAlMjMlMjBudW1iZXIlMjBvZiUyMGltYWdlcyUyMHRvJTIwZ2VuZXJhdGUlMjBwZXIlMjBwcm9tcHQlMkMlMjBkZWZhdWx0cyUyMHRvJTIwMSU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTYwJTIzJTIwY2FzdCUyMG9ubHklMjBtYXRyaXglMjBtdWx0aXBsaWNhdGlvbiUyMG9wZXJhdGlvbnMlNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdF90eXBlJTIwYmYxNiUyMCU2MCUyMyUyMGNhc3QlMjBvcGVyYXRpb25zJTIwZnJvbSUyMEZQMzIlMjB0byUyMEJGMTYlNjAlMjAlNUMlMEElMjAlMjBzZF9uZXVyb25feGwlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --task stable-diffusion-xl \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),de=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Me=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),he=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ge=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),be=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),we=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),Te=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ze=new h({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),Ge=new h({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Xe=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiUyQyUyMGRldmljZV9pZHMlM0QlNUIwJTJDJTIwMSU1RCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTIwJTNEJTIwcmVmaW5lciglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfc3RhcnQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ce=new h({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),Be=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIlMkMlMjBkZXZpY2VfaWRzJTNEJTVCMCUyQyUyMDElNUQpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyJTJDJTIwZGV2aWNlX2lkcyUzRCU1QjAlMkMlMjAxJTVEKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>, device_ids=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),X=new ts({props:{$$slots:{default:[rs]},$$scope:{ctx:Fe}}}),_e=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),$e=new h({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),Re=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),xe=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Ye=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJsY21fc2R4bF9uZXVyb24lMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNsb3NlLXVwJTIwcGljdHVyZSUyMG9mJTIwYW4lMjBvbGQlMjBtYW4lMjBzdGFuZGluZyUyMGluJTIwdGhlJTIwcmFpbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>)
prompt = <span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>

images = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),{c(){y=i("meta"),T=n(),g=i("p"),b=n(),o(j.$$.fragment),J=n(),o(U.$$.fragment),Ee=n(),C=i("p"),C.innerHTML=cl,ze=n(),B=i("p"),B.innerHTML=dl,Le=n(),o(V.$$.fragment),qe=n(),o(_.$$.fragment),Ae=n(),v=i("p"),v.innerHTML=Ml,De=n(),N=i("ul"),N.innerHTML=yl,Pe=n(),$=i("p"),$.innerHTML=hl,Ke=n(),k=i("p"),k.innerHTML=gl,Oe=n(),R=i("p"),R.innerHTML=fl,et=n(),o(x.$$.fragment),tt=n(),S=i("p"),S.innerHTML=bl,lt=n(),Y=i("p"),Y.innerHTML=Jl,st=n(),Q=i("p"),Q.innerHTML=wl,nt=n(),o(G.$$.fragment),at=n(),o(F.$$.fragment),it=n(),o(H.$$.fragment),pt=n(),E=i("p"),E.innerHTML=Ul,mt=n(),z=i("p"),z.textContent=Tl,ot=n(),o(L.$$.fragment),rt=n(),Z=i("img"),ut=n(),o(q.$$.fragment),ct=n(),A=i("p"),A.innerHTML=Zl,dt=n(),o(D.$$.fragment),Mt=n(),P=i("table"),P.innerHTML=Wl,yt=n(),o(K.$$.fragment),ht=n(),O=i("p"),O.innerHTML=Il,gt=n(),o(ee.$$.fragment),ft=n(),te=i("table"),te.innerHTML=Gl,bt=n(),o(le.$$.fragment),Jt=n(),se=i("p"),se.textContent=Xl,wt=n(),o(ne.$$.fragment),Ut=n(),ae=i("p"),ae.textContent=Cl,Tt=n(),ie=i("ul"),ie.innerHTML=Bl,jt=n(),pe=i("p"),pe.innerHTML=Vl,Zt=n(),me=i("p"),me.innerHTML=_l,Wt=n(),o(oe.$$.fragment),It=n(),re=i("p"),re.innerHTML=vl,Gt=n(),ue=i("p"),ue.innerHTML=Nl,Xt=n(),ce=i("p"),ce.innerHTML=$l,Ct=n(),o(de.$$.fragment),Bt=n(),o(Me.$$.fragment),Vt=n(),ye=i("p"),ye.textContent=kl,_t=n(),o(he.$$.fragment),vt=n(),W=i("img"),Nt=n(),o(ge.$$.fragment),$t=n(),fe=i("p"),fe.innerHTML=xl,kt=n(),o(be.$$.fragment),Rt=n(),Je=i("table"),Je.innerHTML=Sl,xt=n(),o(we.$$.fragment),St=n(),Ue=i("p"),Ue.innerHTML=Yl,Yt=n(),o(Te.$$.fragment),Qt=n(),je=i("table"),je.innerHTML=Ql,Ft=n(),o(Ze.$$.fragment),Ht=n(),We=i("p"),We.innerHTML=Fl,Et=n(),Ie=i("ol"),Ie.innerHTML=Hl,zt=n(),o(Ge.$$.fragment),Lt=n(),o(Xe.$$.fragment),qt=n(),I=i("img"),At=n(),o(Ce.$$.fragment),Dt=n(),o(Be.$$.fragment),Pt=n(),Ve=i("table"),Ve.innerHTML=zl,Kt=n(),o(X.$$.fragment),Ot=n(),o(_e.$$.fragment),el=n(),ve=i("p"),ve.innerHTML=Ll,tl=n(),Ne=i("p"),Ne.innerHTML=ql,ll=n(),o($e.$$.fragment),sl=n(),ke=i("p"),ke.innerHTML=Al,nl=n(),o(Re.$$.fragment),al=n(),o(xe.$$.fragment),il=n(),Se=i("p"),Se.textContent=Dl,pl=n(),o(Ye.$$.fragment),ml=n(),Qe=i("p"),Qe.innerHTML=Pl,ol=n(),He=i("p"),this.h()},l(e){const t=ps("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(l),T=a(e),g=p(e,"P",{}),es(g).forEach(l),b=a(e),r(j.$$.fragment,e),J=a(e),r(U.$$.fragment,e),Ee=a(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1g87d8z"&&(C.innerHTML=cl),ze=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1u4t7n7"&&(B.innerHTML=dl),Le=a(e),r(V.$$.fragment,e),qe=a(e),r(_.$$.fragment,e),Ae=a(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-3qllio"&&(v.innerHTML=Ml),De=a(e),N=p(e,"UL",{"data-svelte-h":!0}),m(N)!=="svelte-1c1t3y0"&&(N.innerHTML=yl),Pe=a(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-15y00oa"&&($.innerHTML=hl),Ke=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1a2m8iq"&&(k.innerHTML=gl),Oe=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-ktaj8q"&&(R.innerHTML=fl),et=a(e),r(x.$$.fragment,e),tt=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-jz092x"&&(S.innerHTML=bl),lt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-kxhd34"&&(Y.innerHTML=Jl),st=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1bahy14"&&(Q.innerHTML=wl),nt=a(e),r(G.$$.fragment,e),at=a(e),r(F.$$.fragment,e),it=a(e),r(H.$$.fragment,e),pt=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1r61oa5"&&(E.innerHTML=Ul),mt=a(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1q8fgqb"&&(z.textContent=Tl),ot=a(e),r(L.$$.fragment,e),rt=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ut=a(e),r(q.$$.fragment,e),ct=a(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-kqnotf"&&(A.innerHTML=Zl),dt=a(e),r(D.$$.fragment,e),Mt=a(e),P=p(e,"TABLE",{"data-svelte-h":!0}),m(P)!=="svelte-i6e2ex"&&(P.innerHTML=Wl),yt=a(e),r(K.$$.fragment,e),ht=a(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-vhijyl"&&(O.innerHTML=Il),gt=a(e),r(ee.$$.fragment,e),ft=a(e),te=p(e,"TABLE",{"data-svelte-h":!0}),m(te)!=="svelte-v8z5s8"&&(te.innerHTML=Gl),bt=a(e),r(le.$$.fragment,e),Jt=a(e),se=p(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-7xctqf"&&(se.textContent=Xl),wt=a(e),r(ne.$$.fragment,e),Ut=a(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-u4wwem"&&(ae.textContent=Cl),Tt=a(e),ie=p(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-17e9k9s"&&(ie.innerHTML=Bl),jt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1a2m8iq"&&(pe.innerHTML=Vl),Zt=a(e),me=p(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-9niqj3"&&(me.innerHTML=_l),Wt=a(e),r(oe.$$.fragment,e),It=a(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-eias7g"&&(re.innerHTML=vl),Gt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-kxhd34"&&(ue.innerHTML=Nl),Xt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-17tzr0c"&&(ce.innerHTML=$l),Ct=a(e),r(de.$$.fragment,e),Bt=a(e),r(Me.$$.fragment,e),Vt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-8q3qyn"&&(ye.textContent=kl),_t=a(e),r(he.$$.fragment,e),vt=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Nt=a(e),r(ge.$$.fragment,e),$t=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-luub4o"&&(fe.innerHTML=xl),kt=a(e),r(be.$$.fragment,e),Rt=a(e),Je=p(e,"TABLE",{"data-svelte-h":!0}),m(Je)!=="svelte-1s0d0pv"&&(Je.innerHTML=Sl),xt=a(e),r(we.$$.fragment,e),St=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-11fbw00"&&(Ue.innerHTML=Yl),Yt=a(e),r(Te.$$.fragment,e),Qt=a(e),je=p(e,"TABLE",{"data-svelte-h":!0}),m(je)!=="svelte-18741xe"&&(je.innerHTML=Ql),Ft=a(e),r(Ze.$$.fragment,e),Ht=a(e),We=p(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1usq821"&&(We.innerHTML=Fl),Et=a(e),Ie=p(e,"OL",{"data-svelte-h":!0}),m(Ie)!=="svelte-6p4eqi"&&(Ie.innerHTML=Hl),zt=a(e),r(Ge.$$.fragment,e),Lt=a(e),r(Xe.$$.fragment,e),qt=a(e),I=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),At=a(e),r(Ce.$$.fragment,e),Dt=a(e),r(Be.$$.fragment,e),Pt=a(e),Ve=p(e,"TABLE",{"data-svelte-h":!0}),m(Ve)!=="svelte-1s7g03c"&&(Ve.innerHTML=zl),Kt=a(e),r(X.$$.fragment,e),Ot=a(e),r(_e.$$.fragment,e),el=a(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1ud6a8q"&&(ve.innerHTML=Ll),tl=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-2o4ofu"&&(Ne.innerHTML=ql),ll=a(e),r($e.$$.fragment,e),sl=a(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-kxhd34"&&(ke.innerHTML=Al),nl=a(e),r(Re.$$.fragment,e),al=a(e),r(xe.$$.fragment,e),il=a(e),Se=p(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-1ebkvay"&&(Se.textContent=Dl),pl=a(e),r(Ye.$$.fragment,e),ml=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-xbi604"&&(Qe.innerHTML=Pl),ol=a(e),He=p(e,"P",{}),es(He).forEach(l),this.h()},h(){w(y,"name","hf:doc:metadata"),w(y,"content",cs),ul(Z.src,jl="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||w(Z,"src",jl),w(Z,"width","256"),w(Z,"height","256"),w(Z,"alt","stable diffusion generated image"),ul(W.src,Rl="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||w(W,"src",Rl),w(W,"width","256"),w(W,"height","256"),w(W,"alt","sdxl generated image"),ul(I.src,El="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||w(I,"src",El),w(I,"width","256"),w(I,"height","256"),w(I,"alt","sdxl base + refiner")},m(e,t){ms(document.head,y),s(e,T,t),s(e,g,t),s(e,b,t),u(j,e,t),s(e,J,t),u(U,e,t),s(e,Ee,t),s(e,C,t),s(e,ze,t),s(e,B,t),s(e,Le,t),u(V,e,t),s(e,qe,t),u(_,e,t),s(e,Ae,t),s(e,v,t),s(e,De,t),s(e,N,t),s(e,Pe,t),s(e,$,t),s(e,Ke,t),s(e,k,t),s(e,Oe,t),s(e,R,t),s(e,et,t),u(x,e,t),s(e,tt,t),s(e,S,t),s(e,lt,t),s(e,Y,t),s(e,st,t),s(e,Q,t),s(e,nt,t),u(G,e,t),s(e,at,t),u(F,e,t),s(e,it,t),u(H,e,t),s(e,pt,t),s(e,E,t),s(e,mt,t),s(e,z,t),s(e,ot,t),u(L,e,t),s(e,rt,t),s(e,Z,t),s(e,ut,t),u(q,e,t),s(e,ct,t),s(e,A,t),s(e,dt,t),u(D,e,t),s(e,Mt,t),s(e,P,t),s(e,yt,t),u(K,e,t),s(e,ht,t),s(e,O,t),s(e,gt,t),u(ee,e,t),s(e,ft,t),s(e,te,t),s(e,bt,t),u(le,e,t),s(e,Jt,t),s(e,se,t),s(e,wt,t),u(ne,e,t),s(e,Ut,t),s(e,ae,t),s(e,Tt,t),s(e,ie,t),s(e,jt,t),s(e,pe,t),s(e,Zt,t),s(e,me,t),s(e,Wt,t),u(oe,e,t),s(e,It,t),s(e,re,t),s(e,Gt,t),s(e,ue,t),s(e,Xt,t),s(e,ce,t),s(e,Ct,t),u(de,e,t),s(e,Bt,t),u(Me,e,t),s(e,Vt,t),s(e,ye,t),s(e,_t,t),u(he,e,t),s(e,vt,t),s(e,W,t),s(e,Nt,t),u(ge,e,t),s(e,$t,t),s(e,fe,t),s(e,kt,t),u(be,e,t),s(e,Rt,t),s(e,Je,t),s(e,xt,t),u(we,e,t),s(e,St,t),s(e,Ue,t),s(e,Yt,t),u(Te,e,t),s(e,Qt,t),s(e,je,t),s(e,Ft,t),u(Ze,e,t),s(e,Ht,t),s(e,We,t),s(e,Et,t),s(e,Ie,t),s(e,zt,t),u(Ge,e,t),s(e,Lt,t),u(Xe,e,t),s(e,qt,t),s(e,I,t),s(e,At,t),u(Ce,e,t),s(e,Dt,t),u(Be,e,t),s(e,Pt,t),s(e,Ve,t),s(e,Kt,t),u(X,e,t),s(e,Ot,t),u(_e,e,t),s(e,el,t),s(e,ve,t),s(e,tl,t),s(e,Ne,t),s(e,ll,t),u($e,e,t),s(e,sl,t),s(e,ke,t),s(e,nl,t),u(Re,e,t),s(e,al,t),u(xe,e,t),s(e,il,t),s(e,Se,t),s(e,pl,t),u(Ye,e,t),s(e,ml,t),s(e,Qe,t),s(e,ol,t),s(e,He,t),rl=!0},p(e,[t]){const Kl={};t&2&&(Kl.$$scope={dirty:t,ctx:e}),G.$set(Kl);const Ol={};t&2&&(Ol.$$scope={dirty:t,ctx:e}),X.$set(Ol)},i(e){rl||(c(j.$$.fragment,e),c(U.$$.fragment,e),c(V.$$.fragment,e),c(_.$$.fragment,e),c(x.$$.fragment,e),c(G.$$.fragment,e),c(F.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(Me.$$.fragment,e),c(he.$$.fragment,e),c(ge.$$.fragment,e),c(be.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(Ze.$$.fragment,e),c(Ge.$$.fragment,e),c(Xe.$$.fragment,e),c(Ce.$$.fragment,e),c(Be.$$.fragment,e),c(X.$$.fragment,e),c(_e.$$.fragment,e),c($e.$$.fragment,e),c(Re.$$.fragment,e),c(xe.$$.fragment,e),c(Ye.$$.fragment,e),rl=!0)},o(e){d(j.$$.fragment,e),d(U.$$.fragment,e),d(V.$$.fragment,e),d(_.$$.fragment,e),d(x.$$.fragment,e),d(G.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(he.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(Xe.$$.fragment,e),d(Ce.$$.fragment,e),d(Be.$$.fragment,e),d(X.$$.fragment,e),d(_e.$$.fragment,e),d($e.$$.fragment,e),d(Re.$$.fragment,e),d(xe.$$.fragment,e),d(Ye.$$.fragment,e),rl=!1},d(e){e&&(l(T),l(g),l(b),l(J),l(Ee),l(C),l(ze),l(B),l(Le),l(qe),l(Ae),l(v),l(De),l(N),l(Pe),l($),l(Ke),l(k),l(Oe),l(R),l(et),l(tt),l(S),l(lt),l(Y),l(st),l(Q),l(nt),l(at),l(it),l(pt),l(E),l(mt),l(z),l(ot),l(rt),l(Z),l(ut),l(ct),l(A),l(dt),l(Mt),l(P),l(yt),l(ht),l(O),l(gt),l(ft),l(te),l(bt),l(Jt),l(se),l(wt),l(Ut),l(ae),l(Tt),l(ie),l(jt),l(pe),l(Zt),l(me),l(Wt),l(It),l(re),l(Gt),l(ue),l(Xt),l(ce),l(Ct),l(Bt),l(Vt),l(ye),l(_t),l(vt),l(W),l(Nt),l($t),l(fe),l(kt),l(Rt),l(Je),l(xt),l(St),l(Ue),l(Yt),l(Qt),l(je),l(Ft),l(Ht),l(We),l(Et),l(Ie),l(zt),l(Lt),l(qt),l(I),l(At),l(Dt),l(Pt),l(Ve),l(Kt),l(Ot),l(el),l(ve),l(tl),l(Ne),l(ll),l(sl),l(ke),l(nl),l(al),l(il),l(Se),l(pl),l(ml),l(Qe),l(ol),l(He)),l(y),M(j,e),M(U,e),M(V,e),M(_,e),M(x,e),M(G,e),M(F,e),M(H,e),M(L,e),M(q,e),M(D,e),M(K,e),M(ee,e),M(le,e),M(ne,e),M(oe,e),M(de,e),M(Me,e),M(he,e),M(ge,e),M(be,e),M(we,e),M(Te,e),M(Ze,e),M(Ge,e),M(Xe,e),M(Ce,e),M(Be,e),M(X,e),M(_e,e),M($e,e),M(Re,e),M(xe,e),M(Ye,e)}}}const cs='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function ds(Fe){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends as{constructor(y){super(),is(this,y,ds,us,ss,{})}}export{bs as component};
