import{s as ae,n as se,o as ne}from"../chunks/scheduler.c57aa7ef.js";import{S as oe,i as Me,g as o,s,r as x,A as de,h as M,f as l,c as n,j as te,u as v,x as i,k as le,y as ie,a,v as F,d as Y,t as H,w as N}from"../chunks/index.c50cb18e.js";import{C as S}from"../chunks/CodeBlock.34f0a53d.js";import{H as pe}from"../chunks/Heading.c7d7e0e7.js";function re($){let d,_,j,C,p,I,r,D='With PEFT, you can inject trainable adapters into any <code>torch</code> module which allows you to use adapter methods without relying on the modeling classes in PEFT. Currently, PEFT supports injecting <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a>, <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a>, and <a href="../conceptual_guides/ia3">IA3</a> into models because for these adapters, inplace modification of the model is sufficient for finetuning it.',E,m,z="Check the table below to see when you should inject adapters.",Z,c,L="<thead><tr><th>Pros</th> <th>Cons</th></tr></thead> <tbody><tr><td>the model is modified inplace, keeping all the original attributes and methods</td> <td>manually write the <code>from_pretrained</code> and <code>save_pretrained</code> utility functions from Hugging Face to save and load adapters</td></tr> <tr><td>works for any <code>torch</code> module and modality</td> <td>doesn’t work with any of the utility methods provided by <code>PeftModel</code> such as disabling and merging adapters</td></tr></tbody>",k,y,K='To perform the adapter injection, use the <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> method. This method takes 3 arguments, the PEFT config, the model, and an optional adapter name. You can also attach multiple adapters to the model if you call <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> multiple times with different adapter names.',B,u,P="For example, to inject LoRA adapters into the <code>linear</code> submodule of the <code>DummyModel</code> module:",A,T,W,J,q="Print the model to see that the adapters have been correctly injected.",G,w,V,h,O='To only save the adapter, use the <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a> function:',R,f,g,U,ee="Otherwise, <code>model.state_dict()</code> returns the full state dict of the model.",Q,b,X;return p=new pe({props:{title:"Adapter injection",local:"adapter-injection",headingTag:"h1"}}),T=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),w=new S({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),f=new S({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),{c(){d=o("meta"),_=s(),j=o("p"),C=s(),x(p.$$.fragment),I=s(),r=o("p"),r.innerHTML=D,E=s(),m=o("p"),m.textContent=z,Z=s(),c=o("table"),c.innerHTML=L,k=s(),y=o("p"),y.innerHTML=K,B=s(),u=o("p"),u.innerHTML=P,A=s(),x(T.$$.fragment),W=s(),J=o("p"),J.textContent=q,G=s(),x(w.$$.fragment),V=s(),h=o("p"),h.innerHTML=O,R=s(),x(f.$$.fragment),g=s(),U=o("p"),U.innerHTML=ee,Q=s(),b=o("p"),this.h()},l(e){const t=de("svelte-u9bgzb",document.head);d=M(t,"META",{name:!0,content:!0}),t.forEach(l),_=n(e),j=M(e,"P",{}),te(j).forEach(l),C=n(e),v(p.$$.fragment,e),I=n(e),r=M(e,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1sptwg7"&&(r.innerHTML=D),E=n(e),m=M(e,"P",{"data-svelte-h":!0}),i(m)!=="svelte-mj4045"&&(m.textContent=z),Z=n(e),c=M(e,"TABLE",{"data-svelte-h":!0}),i(c)!=="svelte-j2tc6m"&&(c.innerHTML=L),k=n(e),y=M(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1gtuu5w"&&(y.innerHTML=K),B=n(e),u=M(e,"P",{"data-svelte-h":!0}),i(u)!=="svelte-tifeyo"&&(u.innerHTML=P),A=n(e),v(T.$$.fragment,e),W=n(e),J=M(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-3xa704"&&(J.textContent=q),G=n(e),v(w.$$.fragment,e),V=n(e),h=M(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-knsou4"&&(h.innerHTML=O),R=n(e),v(f.$$.fragment,e),g=n(e),U=M(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1hk759o"&&(U.innerHTML=ee),Q=n(e),b=M(e,"P",{}),te(b).forEach(l),this.h()},h(){le(d,"name","hf:doc:metadata"),le(d,"content",me)},m(e,t){ie(document.head,d),a(e,_,t),a(e,j,t),a(e,C,t),F(p,e,t),a(e,I,t),a(e,r,t),a(e,E,t),a(e,m,t),a(e,Z,t),a(e,c,t),a(e,k,t),a(e,y,t),a(e,B,t),a(e,u,t),a(e,A,t),F(T,e,t),a(e,W,t),a(e,J,t),a(e,G,t),F(w,e,t),a(e,V,t),a(e,h,t),a(e,R,t),F(f,e,t),a(e,g,t),a(e,U,t),a(e,Q,t),a(e,b,t),X=!0},p:se,i(e){X||(Y(p.$$.fragment,e),Y(T.$$.fragment,e),Y(w.$$.fragment,e),Y(f.$$.fragment,e),X=!0)},o(e){H(p.$$.fragment,e),H(T.$$.fragment,e),H(w.$$.fragment,e),H(f.$$.fragment,e),X=!1},d(e){e&&(l(_),l(j),l(C),l(I),l(r),l(E),l(m),l(Z),l(c),l(k),l(y),l(B),l(u),l(A),l(W),l(J),l(G),l(V),l(h),l(R),l(g),l(U),l(Q),l(b)),l(d),N(p,e),N(T,e),N(w,e),N(f,e)}}}const me='{"title":"Adapter injection","local":"adapter-injection","sections":[],"depth":1}';function ce($){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class we extends oe{constructor(d){super(),Me(this,d,ce,re,ae,{})}}export{we as component};
