import{s as Nt,n as xt,o as It}from"../chunks/scheduler.85c25b89.js";import{S as Bt,i as Wt,g as p,s as a,r as m,A as Gt,h as i,f as l,c as n,j as kt,u as o,x as g,k as Zt,y as Et,a as e,v as r,d as h,t as c,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as Qt}from"../chunks/index.b36f1b99.js";function vt(yt){let y,A,_,H,d,S,j,dt='A <strong>Dual Path Network (DPN)</strong> is a convolutional neural network which presents a new topology of connection paths internally. The intuition is that <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> enables feature re-usage while DenseNet enables new feature exploration, and both are important for learning good representations. To enjoy the benefits from both path topologies, Dual Path Networks share common features while maintaining the flexibility to explore new features through dual path architectures.',F,w,jt='The principal building block is an <a href="https://paperswithcode.com/method/dpn-block" rel="nofollow">DPN Block</a>.',z,u,D,J,wt="To load a pretrained model:",P,f,L,b,ut="To load and preprocess the image:",q,T,K,U,Jt="To get the model predictions:",O,$,tt,C,ft="To get the top-5 predictions class names:",st,k,lt,Z,bt="Replace the model name with the variant you want to use, e.g. <code>dpn107</code>. You can find the IDs in the model summaries at the top of this page.",et,N,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,x,nt,I,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,B,it,W,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,G,ot,E,Ct='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,Q,ht,v,ct,R,Mt,V,gt;return d=new Y({props:{title:"Dual Path Network (DPN)",local:"dual-path-network-dpn",headingTag:"h1"}}),u=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RwbjEwNyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),T=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZHBuMTA3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new X({props:{code:"JTQwbWlzYyU3QmNoZW4yMDE3ZHVhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRHVhbCUyMFBhdGglMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qll1bnBlbmclMjBDaGVuJTIwYW5kJTIwSmlhbmFuJTIwTGklMjBhbmQlMjBIdWF4aW4lMjBYaWFvJTIwYW5kJTIwWGlhb2ppZSUyMEppbiUyMGFuZCUyMFNodWljaGVuZyUyMFlhbiUyMGFuZCUyMEppYXNoaSUyMEZlbmclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDE2MjklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{chen2017dual,
      title={Dual Path Networks}, 
      author={Yunpeng Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jianan </span>Li <span class="hljs-keyword">and </span>Huaxin Xiao <span class="hljs-keyword">and </span>Xiaojie <span class="hljs-keyword">Jin </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Shuicheng </span>Yan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiashi </span>Feng},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">01629</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),R=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/dpn.mdx"}}),{c(){y=p("meta"),A=a(),_=p("p"),H=a(),m(d.$$.fragment),S=a(),j=p("p"),j.innerHTML=dt,F=a(),w=p("p"),w.innerHTML=jt,z=a(),m(u.$$.fragment),D=a(),J=p("p"),J.textContent=wt,P=a(),m(f.$$.fragment),L=a(),b=p("p"),b.textContent=ut,q=a(),m(T.$$.fragment),K=a(),U=p("p"),U.textContent=Jt,O=a(),m($.$$.fragment),tt=a(),C=p("p"),C.textContent=ft,st=a(),m(k.$$.fragment),lt=a(),Z=p("p"),Z.innerHTML=bt,et=a(),N=p("p"),N.innerHTML=Tt,at=a(),m(x.$$.fragment),nt=a(),I=p("p"),I.textContent=Ut,pt=a(),m(B.$$.fragment),it=a(),W=p("p"),W.innerHTML=$t,mt=a(),m(G.$$.fragment),ot=a(),E=p("p"),E.innerHTML=Ct,rt=a(),m(Q.$$.fragment),ht=a(),m(v.$$.fragment),ct=a(),m(R.$$.fragment),Mt=a(),V=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(l),A=n(t),_=i(t,"P",{}),kt(_).forEach(l),H=n(t),o(d.$$.fragment,t),S=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-1vp7kec"&&(j.innerHTML=dt),F=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-34uoom"&&(w.innerHTML=jt),z=n(t),o(u.$$.fragment,t),D=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-18ywhxh"&&(J.textContent=wt),P=n(t),o(f.$$.fragment,t),L=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=ut),q=n(t),o(T.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=Jt),O=n(t),o($.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-19cnvx1"&&(C.textContent=ft),st=n(t),o(k.$$.fragment,t),lt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1lx1824"&&(Z.innerHTML=bt),et=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1wmi3ea"&&(N.innerHTML=Tt),at=n(t),o(x.$$.fragment,t),nt=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-9sr7nh"&&(I.textContent=Ut),pt=n(t),o(B.$$.fragment,t),it=n(t),W=i(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1kguc51"&&(W.innerHTML=$t),mt=n(t),o(G.$$.fragment,t),ot=n(t),E=i(t,"P",{"data-svelte-h":!0}),g(E)!=="svelte-xtxxu6"&&(E.innerHTML=Ct),rt=n(t),o(Q.$$.fragment,t),ht=n(t),o(v.$$.fragment,t),ct=n(t),o(R.$$.fragment,t),Mt=n(t),V=i(t,"P",{}),kt(V).forEach(l),this.h()},h(){Zt(y,"name","hf:doc:metadata"),Zt(y,"content",Rt)},m(t,s){Et(document.head,y),e(t,A,s),e(t,_,s),e(t,H,s),r(d,t,s),e(t,S,s),e(t,j,s),e(t,F,s),e(t,w,s),e(t,z,s),r(u,t,s),e(t,D,s),e(t,J,s),e(t,P,s),r(f,t,s),e(t,L,s),e(t,b,s),e(t,q,s),r(T,t,s),e(t,K,s),e(t,U,s),e(t,O,s),r($,t,s),e(t,tt,s),e(t,C,s),e(t,st,s),r(k,t,s),e(t,lt,s),e(t,Z,s),e(t,et,s),e(t,N,s),e(t,at,s),r(x,t,s),e(t,nt,s),e(t,I,s),e(t,pt,s),r(B,t,s),e(t,it,s),e(t,W,s),e(t,mt,s),r(G,t,s),e(t,ot,s),e(t,E,s),e(t,rt,s),r(Q,t,s),e(t,ht,s),r(v,t,s),e(t,ct,s),r(R,t,s),e(t,Mt,s),e(t,V,s),gt=!0},p:xt,i(t){gt||(h(d.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(T.$$.fragment,t),h($.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(B.$$.fragment,t),h(G.$$.fragment,t),h(Q.$$.fragment,t),h(v.$$.fragment,t),h(R.$$.fragment,t),gt=!0)},o(t){c(d.$$.fragment,t),c(u.$$.fragment,t),c(f.$$.fragment,t),c(T.$$.fragment,t),c($.$$.fragment,t),c(k.$$.fragment,t),c(x.$$.fragment,t),c(B.$$.fragment,t),c(G.$$.fragment,t),c(Q.$$.fragment,t),c(v.$$.fragment,t),c(R.$$.fragment,t),gt=!1},d(t){t&&(l(A),l(_),l(H),l(S),l(j),l(F),l(w),l(z),l(D),l(J),l(P),l(L),l(b),l(q),l(K),l(U),l(O),l(tt),l(C),l(st),l(lt),l(Z),l(et),l(N),l(at),l(nt),l(I),l(pt),l(it),l(W),l(mt),l(ot),l(E),l(rt),l(ht),l(ct),l(Mt),l(V)),l(y),M(d,t),M(u,t),M(f,t),M(T,t),M($,t),M(k,t),M(x,t),M(B,t),M(G,t),M(Q,t),M(v,t),M(R,t)}}}const Rt='{"title":"Dual Path Network (DPN)","local":"dual-path-network-dpn","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(yt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Bt{constructor(y){super(),Wt(this,y,Xt,vt,Nt,{})}}export{Ht as component};
