import{s as Us,n as Is,o as Zs}from"../chunks/scheduler.85c25b89.js";import{S as Cs,i as $s,g as p,s as l,r as m,A as Ws,h as i,f as e,c as n,j as fs,u as o,x as g,k as bs,y as Bs,a,v as r,d as c,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.94efc595.js";import{H as Y}from"../chunks/Heading.3c6e5b17.js";function ks(cs){let d,_,R,X,J,H,w,hs='<strong>ResNet-D</strong> is a modification on the <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> architecture that utilises an <a href="https://paperswithcode.com/method/average-pooling" rel="nofollow">average pooling</a> tweak for downsampling. The motivation is that in the unmodified ResNet, the <a href="https://paperswithcode.com/method/1x1-convolution" rel="nofollow">1×1 convolution</a> for the downsampling block ignores 3/4 of input feature maps, so this is modified so no information will be ignored',z,j,F,y,Ms="To load a pretrained model:",S,T,A,u,gs="To load and preprocess the image:",L,f,D,b,ds="To get the model predictions:",q,U,P,I,Js="To get the top-5 predictions class names:",K,Z,O,C,ws="Replace the model name with the variant you want to use, e.g. <code>resnet101d</code>. You can find the IDs in the model summaries at the top of this page.",ss,$,js='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,W,es,B,ys="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,k,ls,N,Ts=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,G,ps,x,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',is,v,ms,E,os,V,rs;return J=new Y({props:{title:"ResNet-D",local:"resnet-d",headingTag:"h1"}}),j=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwbWlzYyU3QmhlMjAxOGJhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQmFnJTIwb2YlMjBUcmlja3MlMjBmb3IlMjBJbWFnZSUyMENsYXNzaWZpY2F0aW9uJTIwd2l0aCUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRvbmclMjBIZSUyMGFuZCUyMFpoaSUyMFpoYW5nJTIwYW5kJTIwSGFuZyUyMFpoYW5nJTIwYW5kJTIwWmhvbmd5dWUlMjBaaGFuZyUyMGFuZCUyMEp1bnl1YW4lMjBYaWUlMjBhbmQlMjBNdSUyMExpJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODEyLjAxMTg3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{he<span class="hljs-symbol">2018b</span>ag,
      title={<span class="hljs-keyword">Bag </span>of Tricks for Image Classification with Convolutional Neural Networks}, 
      author={Tong He <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Hang Zhang <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span><span class="hljs-keyword">Junyuan </span>Xie <span class="hljs-keyword">and </span>Mu Li},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">01187</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){d=p("meta"),_=l(),R=p("p"),X=l(),m(J.$$.fragment),H=l(),w=p("p"),w.innerHTML=hs,z=l(),m(j.$$.fragment),F=l(),y=p("p"),y.textContent=Ms,S=l(),m(T.$$.fragment),A=l(),u=p("p"),u.textContent=gs,L=l(),m(f.$$.fragment),D=l(),b=p("p"),b.textContent=ds,q=l(),m(U.$$.fragment),P=l(),I=p("p"),I.textContent=Js,K=l(),m(Z.$$.fragment),O=l(),C=p("p"),C.innerHTML=ws,ss=l(),$=p("p"),$.innerHTML=js,ts=l(),m(W.$$.fragment),es=l(),B=p("p"),B.textContent=ys,as=l(),m(k.$$.fragment),ls=l(),N=p("p"),N.innerHTML=Ts,ns=l(),m(G.$$.fragment),ps=l(),x=p("p"),x.innerHTML=us,is=l(),m(v.$$.fragment),ms=l(),m(E.$$.fragment),os=l(),V=p("p"),this.h()},l(s){const t=Ws("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(e),_=n(s),R=i(s,"P",{}),fs(R).forEach(e),X=n(s),o(J.$$.fragment,s),H=n(s),w=i(s,"P",{"data-svelte-h":!0}),g(w)!=="svelte-8lziuy"&&(w.innerHTML=hs),z=n(s),o(j.$$.fragment,s),F=n(s),y=i(s,"P",{"data-svelte-h":!0}),g(y)!=="svelte-18ywhxh"&&(y.textContent=Ms),S=n(s),o(T.$$.fragment,s),A=n(s),u=i(s,"P",{"data-svelte-h":!0}),g(u)!=="svelte-1c2ipa8"&&(u.textContent=gs),L=n(s),o(f.$$.fragment,s),D=n(s),b=i(s,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=ds),q=n(s),o(U.$$.fragment,s),P=n(s),I=i(s,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=Js),K=n(s),o(Z.$$.fragment,s),O=n(s),C=i(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1iogwu7"&&(C.innerHTML=ws),ss=n(s),$=i(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-1wmi3ea"&&($.innerHTML=js),ts=n(s),o(W.$$.fragment,s),es=n(s),B=i(s,"P",{"data-svelte-h":!0}),g(B)!=="svelte-9sr7nh"&&(B.textContent=ys),as=n(s),o(k.$$.fragment,s),ls=n(s),N=i(s,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=Ts),ns=n(s),o(G.$$.fragment,s),ps=n(s),x=i(s,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1n0coha"&&(x.innerHTML=us),is=n(s),o(v.$$.fragment,s),ms=n(s),o(E.$$.fragment,s),os=n(s),V=i(s,"P",{}),fs(V).forEach(e),this.h()},h(){bs(d,"name","hf:doc:metadata"),bs(d,"content",Ns)},m(s,t){Bs(document.head,d),a(s,_,t),a(s,R,t),a(s,X,t),r(J,s,t),a(s,H,t),a(s,w,t),a(s,z,t),r(j,s,t),a(s,F,t),a(s,y,t),a(s,S,t),r(T,s,t),a(s,A,t),a(s,u,t),a(s,L,t),r(f,s,t),a(s,D,t),a(s,b,t),a(s,q,t),r(U,s,t),a(s,P,t),a(s,I,t),a(s,K,t),r(Z,s,t),a(s,O,t),a(s,C,t),a(s,ss,t),a(s,$,t),a(s,ts,t),r(W,s,t),a(s,es,t),a(s,B,t),a(s,as,t),r(k,s,t),a(s,ls,t),a(s,N,t),a(s,ns,t),r(G,s,t),a(s,ps,t),a(s,x,t),a(s,is,t),r(v,s,t),a(s,ms,t),r(E,s,t),a(s,os,t),a(s,V,t),rs=!0},p:Is,i(s){rs||(c(J.$$.fragment,s),c(j.$$.fragment,s),c(T.$$.fragment,s),c(f.$$.fragment,s),c(U.$$.fragment,s),c(Z.$$.fragment,s),c(W.$$.fragment,s),c(k.$$.fragment,s),c(G.$$.fragment,s),c(v.$$.fragment,s),c(E.$$.fragment,s),rs=!0)},o(s){h(J.$$.fragment,s),h(j.$$.fragment,s),h(T.$$.fragment,s),h(f.$$.fragment,s),h(U.$$.fragment,s),h(Z.$$.fragment,s),h(W.$$.fragment,s),h(k.$$.fragment,s),h(G.$$.fragment,s),h(v.$$.fragment,s),h(E.$$.fragment,s),rs=!1},d(s){s&&(e(_),e(R),e(X),e(H),e(w),e(z),e(F),e(y),e(S),e(A),e(u),e(L),e(D),e(b),e(q),e(P),e(I),e(K),e(O),e(C),e(ss),e($),e(ts),e(es),e(B),e(as),e(ls),e(N),e(ns),e(ps),e(x),e(is),e(ms),e(os),e(V)),e(d),M(J,s),M(j,s),M(T,s),M(f,s),M(U,s),M(Z,s),M(W,s),M(k,s),M(G,s),M(v,s),M(E,s)}}}const Ns='{"title":"ResNet-D","local":"resnet-d","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Gs(cs){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Cs{constructor(d){super(),$s(this,d,Gs,ks,Us,{})}}export{Rs as component};
