import{s as Zt,n as Wt,o as vt}from"../chunks/scheduler.85c25b89.js";import{S as xt,i as Nt,g as p,s as l,r as i,A as Bt,h as m,f as a,c as n,j as Ct,u as o,x as M,k as kt,y as Gt,a as e,v as r,d as c,t as h,w as g}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as X,E as Et}from"../chunks/getInferenceSnippets.e17aa01c.js";function Qt(Jt){let J,z,_,H,d,S,y,dt='<strong>CSPDarknet53</strong> is a convolutional neural network and backbone for object detection that uses <a href="https://paperswithcode.com/method/darknet-53" rel="nofollow">DarkNet-53</a>. It employs a CSPNet strategy to partition the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',A,w,yt='This CNN is used as the backbone for <a href="https://paperswithcode.com/method/yolov4" rel="nofollow">YOLOv4</a>.',F,j,L,T,wt="To load a pretrained model:",D,u,P,f,jt="To load and preprocess the image:",q,b,O,U,Tt="To get the model predictions:",K,$,tt,I,ut="To get the top-5 predictions class names:",st,C,at,k,ft="Replace the model name with the variant you want to use, e.g. <code>cspdarknet53</code>. You can find the IDs in the model summaries at the top of this page.",et,Z,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,W,nt,v,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,x,mt,N,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,B,ot,G,It='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,E,ct,Q,ht,Y,gt,R,Mt;return d=new X({props:{title:"CSP-DarkNet",local:"csp-darknet",headingTag:"h1"}}),j=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcGRhcmtuZXQ1MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspdarknet53&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwZGFya25ldDUzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspdarknet53&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwbWlzYyU3QmJvY2hrb3Zza2l5MjAyMHlvbG92NCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWU9MT3Y0JTNBJTIwT3B0aW1hbCUyMFNwZWVkJTIwYW5kJTIwQWNjdXJhY3klMjBvZiUyME9iamVjdCUyMERldGVjdGlvbiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkFsZXhleSUyMEJvY2hrb3Zza2l5JTIwYW5kJTIwQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDA0LjEwOTM0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{bochkovskiy2020yolov4,
      title={YOLOv4: Optimal Speed and Accuracy of Object Detection}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2004.10934}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),Y=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/csp-darknet.mdx"}}),{c(){J=p("meta"),z=l(),_=p("p"),H=l(),i(d.$$.fragment),S=l(),y=p("p"),y.innerHTML=dt,A=l(),w=p("p"),w.innerHTML=yt,F=l(),i(j.$$.fragment),L=l(),T=p("p"),T.textContent=wt,D=l(),i(u.$$.fragment),P=l(),f=p("p"),f.textContent=jt,q=l(),i(b.$$.fragment),O=l(),U=p("p"),U.textContent=Tt,K=l(),i($.$$.fragment),tt=l(),I=p("p"),I.textContent=ut,st=l(),i(C.$$.fragment),at=l(),k=p("p"),k.innerHTML=ft,et=l(),Z=p("p"),Z.innerHTML=bt,lt=l(),i(W.$$.fragment),nt=l(),v=p("p"),v.textContent=Ut,pt=l(),i(x.$$.fragment),mt=l(),N=p("p"),N.innerHTML=$t,it=l(),i(B.$$.fragment),ot=l(),G=p("p"),G.innerHTML=It,rt=l(),i(E.$$.fragment),ct=l(),i(Q.$$.fragment),ht=l(),i(Y.$$.fragment),gt=l(),R=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(a),z=n(t),_=m(t,"P",{}),Ct(_).forEach(a),H=n(t),o(d.$$.fragment,t),S=n(t),y=m(t,"P",{"data-svelte-h":!0}),M(y)!=="svelte-1qc4wgd"&&(y.innerHTML=dt),A=n(t),w=m(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1czs39f"&&(w.innerHTML=yt),F=n(t),o(j.$$.fragment,t),L=n(t),T=m(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=wt),D=n(t),o(u.$$.fragment,t),P=n(t),f=m(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1c2ipa8"&&(f.textContent=jt),q=n(t),o(b.$$.fragment,t),O=n(t),U=m(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1n9qsq1"&&(U.textContent=Tt),K=n(t),o($.$$.fragment,t),tt=n(t),I=m(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=ut),st=n(t),o(C.$$.fragment,t),at=n(t),k=m(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1xzvjrb"&&(k.innerHTML=ft),et=n(t),Z=m(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=bt),lt=n(t),o(W.$$.fragment,t),nt=n(t),v=m(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-9sr7nh"&&(v.textContent=Ut),pt=n(t),o(x.$$.fragment,t),mt=n(t),N=m(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1kguc51"&&(N.innerHTML=$t),it=n(t),o(B.$$.fragment,t),ot=n(t),G=m(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-xtxxu6"&&(G.innerHTML=It),rt=n(t),o(E.$$.fragment,t),ct=n(t),o(Q.$$.fragment,t),ht=n(t),o(Y.$$.fragment,t),gt=n(t),R=m(t,"P",{}),Ct(R).forEach(a),this.h()},h(){kt(J,"name","hf:doc:metadata"),kt(J,"content",Yt)},m(t,s){Gt(document.head,J),e(t,z,s),e(t,_,s),e(t,H,s),r(d,t,s),e(t,S,s),e(t,y,s),e(t,A,s),e(t,w,s),e(t,F,s),r(j,t,s),e(t,L,s),e(t,T,s),e(t,D,s),r(u,t,s),e(t,P,s),e(t,f,s),e(t,q,s),r(b,t,s),e(t,O,s),e(t,U,s),e(t,K,s),r($,t,s),e(t,tt,s),e(t,I,s),e(t,st,s),r(C,t,s),e(t,at,s),e(t,k,s),e(t,et,s),e(t,Z,s),e(t,lt,s),r(W,t,s),e(t,nt,s),e(t,v,s),e(t,pt,s),r(x,t,s),e(t,mt,s),e(t,N,s),e(t,it,s),r(B,t,s),e(t,ot,s),e(t,G,s),e(t,rt,s),r(E,t,s),e(t,ct,s),r(Q,t,s),e(t,ht,s),r(Y,t,s),e(t,gt,s),e(t,R,s),Mt=!0},p:Wt,i(t){Mt||(c(d.$$.fragment,t),c(j.$$.fragment,t),c(u.$$.fragment,t),c(b.$$.fragment,t),c($.$$.fragment,t),c(C.$$.fragment,t),c(W.$$.fragment,t),c(x.$$.fragment,t),c(B.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(Y.$$.fragment,t),Mt=!0)},o(t){h(d.$$.fragment,t),h(j.$$.fragment,t),h(u.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(W.$$.fragment,t),h(x.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(Y.$$.fragment,t),Mt=!1},d(t){t&&(a(z),a(_),a(H),a(S),a(y),a(A),a(w),a(F),a(L),a(T),a(D),a(P),a(f),a(q),a(O),a(U),a(K),a(tt),a(I),a(st),a(at),a(k),a(et),a(Z),a(lt),a(nt),a(v),a(pt),a(mt),a(N),a(it),a(ot),a(G),a(rt),a(ct),a(ht),a(gt),a(R)),a(J),g(d,t),g(j,t),g(u,t),g(b,t),g($,t),g(C,t),g(W,t),g(x,t),g(B,t),g(E,t),g(Q,t),g(Y,t)}}}const Yt='{"title":"CSP-DarkNet","local":"csp-darknet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(Jt){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends xt{constructor(J){super(),Nt(this,J,Vt,Qt,Zt,{})}}export{Ht as component};
