import{s as Ps,f as Ys,o as Ls,n as j}from"../chunks/scheduler.9bc65507.js";import{S as qs,i as Qs,g as a,s as i,u as w,A as As,h as r,f as t,c as d,j as g,v as _,y as u,k as h,o as s,a as c,w as b,d as M,t as v,x as y}from"../chunks/index.78c82d43.js";import{T as _t}from"../chunks/Tip.87d55b76.js";import{D as I}from"../chunks/Docstring.f3d04bd2.js";import{C as Mt}from"../chunks/CodeBlock.48618ec2.js";import{I as H}from"../chunks/IconCopyLink.bedaa44d.js";import{E as bt}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as Ds}from"../chunks/PipelineTag.75b0f707.js";function Os(F){let o,f="Example:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW5Db25maWclMkMlMjBTd2luTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3dpbiUyMG1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3dpbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2luTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SwinConfig, SwinModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swin microsoft/swin-tiny-patch4-window7-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SwinConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the microsoft/swin-tiny-patch4-window7-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-11lpom8"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function Ks(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function ea(F){let o,f="Example:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFN3aW5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinModel.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">768</span>]`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-11lpom8"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function ta(F){let o,f=`Note that we provide a script to pre-train this model on custom data in our <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">examples
directory</a>.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-7i3y9o"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function oa(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function na(F){let o,f="Examples:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tYmFzZS1zaW1taW0td2luZG93Ni0xOTIlMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2luRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi1iYXNlLXNpbW1pbS13aW5kb3c2LTE5MiUyMiklMEElMEFudW1fcGF0Y2hlcyUyMCUzRCUyMChtb2RlbC5jb25maWcuaW1hZ2Vfc2l6ZSUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy5wYXRjaF9zaXplKSUyMCoqJTIwMiUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUyMyUyMGNyZWF0ZSUyMHJhbmRvbSUyMGJvb2xlYW4lMjBtYXNrJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3BhdGNoZXMpJTBBYm9vbF9tYXNrZWRfcG9zJTIwJTNEJTIwdG9yY2gucmFuZGludChsb3clM0QwJTJDJTIwaGlnaCUzRDIlMkMlMjBzaXplJTNEKDElMkMlMjBudW1fcGF0Y2hlcykpLmJvb2woKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBib29sX21hc2tlZF9wb3MlM0Rib29sX21hc2tlZF9wb3MpJTBBbG9zcyUyQyUyMHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5yZWNvbnN0cnVjdGlvbiUwQWxpc3QocmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-base-simmim-window6-192&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-base-simmim-window6-192&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">192</span>, <span class="hljs-number">192</span>]`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function sa(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function aa(F){let o,f="Example:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbkZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-11lpom8"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function ra(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function la(F){let o,f="Example:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbk1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGU3dpbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinModel.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">768</span>]`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-11lpom8"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function ia(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function da(F){let o,f="Examples:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbkZvck1hc2tlZEltYWdlTW9kZWxpbmclMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGU3dpbkZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRmLnJhbmRvbS51bmlmb3JtKCgxJTJDJTIwbnVtX3BhdGNoZXMpKSUyMCUzRSUzRCUyMDAuNSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBib29sX21hc2tlZF9wb3MlM0Rib29sX21hc2tlZF9wb3MpJTBBbG9zcyUyQyUyMHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5yZWNvbnN0cnVjdGlvbiUwQWxpc3QocmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = tf.random.uniform((<span class="hljs-number">1</span>, num_patches)) &gt;= <span class="hljs-number">0.5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>]`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function ca(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(p){o=r(p,"P",{"data-svelte-h":!0}),u(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(p,m){c(p,o,m)},p:j,d(p){p&&t(o)}}}function pa(F){let o,f="Example:",p,m,T;return m=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbkZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`}}),{c(){o=a("p"),o.textContent=f,p=i(),w(m.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),u(o)!=="svelte-11lpom8"&&(o.textContent=f),p=d(n),_(m.$$.fragment,n)},m(n,$){c(n,o,$),c(n,p,$),b(m,n,$),T=!0},p:j,i(n){T||(M(m.$$.fragment,n),T=!0)},o(n){v(m.$$.fragment,n),T=!1},d(n){n&&(t(o),t(p)),y(m,n)}}}function ma(F){let o,f,p,m,T,n,$,Ie,Ko,vt,Ln="Swin Transformer",go,V,K,Dt,We,en,yt,qn="Overview",wo,Ue,Qn=`The Swin Transformer was proposed in <a href="https://arxiv.org/abs/2103.14030" rel="nofollow">Swin Transformer: Hierarchical Vision Transformer using Shifted Windows</a>
by Ze Liu, Yutong Lin, Yue Cao, Han Hu, Yixuan Wei, Zheng Zhang, Stephen Lin, Baining Guo.`,_o,Je,An="The abstract from the paper is the following:",bo,Ze,Dn=`<em>This paper presents a new vision Transformer, called Swin Transformer, that capably serves as a general-purpose backbone
for computer vision. Challenges in adapting Transformer from language to vision arise from differences between the two domains,
such as large variations in the scale of visual entities and the high resolution of pixels in images compared to words in text.
To address these differences, we propose a hierarchical Transformer whose representation is computed with \\bold{S}hifted
\\bold{win}dows. The shifted windowing scheme brings greater efficiency by limiting self-attention computation to non-overlapping
local windows while also allowing for cross-window connection. This hierarchical architecture has the flexibility to model at
various scales and has linear computational complexity with respect to image size. These qualities of Swin Transformer make it
compatible with a broad range of vision tasks, including image classification (87.3 top-1 accuracy on ImageNet-1K) and dense
prediction tasks such as object detection (58.7 box AP and 51.1 mask AP on COCO test-dev) and semantic segmentation
(53.5 mIoU on ADE20K val). Its performance surpasses the previous state-of-the-art by a large margin of +2.7 box AP and
+2.6 mask AP on COCO, and +3.2 mIoU on ADE20K, demonstrating the potential of Transformer-based models as vision backbones.
The hierarchical design and the shifted window approach also prove beneficial for all-MLP architectures.</em>`,Mo,Ne,On="Tips:",vo,ze,Kn='<li>One can use the <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> API to prepare images for the model.</li> <li>Swin pads the inputs supporting any input height and width (if divisible by <code>32</code>).</li> <li>Swin can be used as a <em>backbone</em>. When <code>output_hidden_states = True</code>, it will output both <code>hidden_states</code> and <code>reshaped_hidden_states</code>. The <code>reshaped_hidden_states</code> have a shape of <code>(batch, num_channels, height, width)</code> rather than <code>(batch_size, sequence_length, num_channels)</code>.</li>',yo,ee,es,To,Ge,ts='Swin Transformer architecture. Taken from the <a href="https://arxiv.org/abs/2102.03334">original paper</a>.',$o,Be,os='This model was contributed by <a href="https://huggingface.co/novice03" rel="nofollow">novice03</a>. The Tensorflow version of this model was contributed by <a href="https://huggingface.co/amyeroberts" rel="nofollow">amyeroberts</a>. The original code can be found <a href="https://github.com/microsoft/Swin-Transformer" rel="nofollow">here</a>.',Fo,P,te,Ot,Re,tn,Tt,ns="Resources",ko,Ee,ss="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Swin Transformer.",jo,Xe,Co,He,as='<li><a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',So,Ve,rs="Besides that:",xo,Pe,ls='<li><a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">example script</a>.</li>',Io,Ye,is="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Wo,Y,oe,Kt,Le,on,$t,ds="SwinConfig",Uo,C,qe,nn,Ft,cs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinModel">SwinModel</a>. It is used to instantiate a Swin
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Swin
<a href="https://huggingface.co/microsoft/swin-tiny-patch4-window7-224" rel="nofollow">microsoft/swin-tiny-patch4-window7-224</a>
architecture.`,sn,kt,ps=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,an,ne,Jo,L,se,eo,Qe,rn,jt,ms="SwinModel",Zo,G,Ae,ln,Ct,hs=`The bare Swin Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,dn,W,De,cn,St,us='The <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinModel">SwinModel</a> forward method, overrides the <code>__call__</code> special method.',pn,ae,mn,re,No,q,le,to,Oe,hn,xt,fs="SwinForMaskedImageModeling",zo,k,Ke,un,It,gs='Swin Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.',fn,ie,gn,Wt,ws=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,wn,U,et,_n,Ut,_s='The <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',bn,de,Mn,ce,Go,Q,pe,oo,tt,vn,Jt,bs="SwinForImageClassification",Bo,S,ot,yn,Zt,Ms=`Swin Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,Tn,Nt,vs=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,$n,J,nt,Fn,zt,ys='The <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',kn,me,jn,he,Ro,A,ue,no,st,Cn,Gt,Ts="TFSwinModel",Eo,B,at,Sn,Bt,$s=`The bare Swin Model transformer outputting raw hidden-states without any specific head on top.
This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,xn,Z,rt,In,Rt,Fs='The <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> forward method, overrides the <code>__call__</code> special method.',Wn,fe,Un,ge,Xo,D,we,so,lt,Jn,Et,ks="TFSwinForMaskedImageModeling",Ho,R,it,Zn,Xt,js=`Swin Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.
This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,Nn,N,dt,zn,Ht,Cs='The <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.TFSwinForMaskedImageModeling">TFSwinForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',Gn,_e,Bn,be,Vo,O,Me,ao,ct,Rn,Vt,Ss="TFSwinForImageClassification",Po,x,pt,En,Pt,xs=`Swin Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,Xn,Yt,Is=`This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,Hn,z,mt,Vn,Lt,Ws='The <a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.TFSwinForImageClassification">TFSwinForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Pn,ve,Yn,ye,Yo,ro,Lo;return Ie=new H({}),We=new H({}),Re=new H({}),Xe=new Ds({props:{pipeline:"image-classification"}}),Le=new H({}),qe=new I({props:{name:"class transformers.SwinConfig",anchor:"transformers.SwinConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 4"},{name:"num_channels",val:" = 3"},{name:"embed_dim",val:" = 96"},{name:"depths",val:" = [2, 2, 6, 2]"},{name:"num_heads",val:" = [3, 6, 12, 24]"},{name:"window_size",val:" = 7"},{name:"mlp_ratio",val:" = 4.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"encoder_stride",val:" = 32"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SwinConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.SwinConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.SwinConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.SwinConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.SwinConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to [2, 2, 6, 2]) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.SwinConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to [3, 6, 12, 24]) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.SwinConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.SwinConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.SwinConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to True) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.SwinConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.SwinConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SwinConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.SwinConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SwinConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to False) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.SwinConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SwinConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SwinConfig.encoder_stride",description:`<strong>encoder_stride</strong> (<code>int</code>, <code>optional</code>, defaults to 32) &#x2014;
Factor to increase the spatial resolution by in the decoder head for masked image modeling.`,name:"encoder_stride"},{anchor:"transformers.SwinConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage.`,name:"out_features"},{anchor:"transformers.SwinConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/configuration_swin.py#L38"}}),ne=new bt({props:{anchor:"transformers.SwinConfig.example",$$slots:{default:[Os]},$$scope:{ctx:F}}}),Qe=new H({}),Ae=new I({props:{name:"class transformers.SwinModel",anchor:"transformers.SwinModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"},{name:"use_mask_token",val:" = False"}],parametersDescription:[{anchor:"transformers.SwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_swin.py#L946"}}),De=new I({props:{name:"forward",anchor:"transformers.SwinModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.SwinModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwinModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_swin.py#L973",returnDescription:`
<p>A <code>transformers.models.swin.modeling_swin.SwinModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.swin.modeling_swin.SwinModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new _t({props:{$$slots:{default:[Ks]},$$scope:{ctx:F}}}),re=new bt({props:{anchor:"transformers.SwinModel.forward.example",$$slots:{default:[ea]},$$scope:{ctx:F}}}),Oe=new H({}),Ke=new I({props:{name:"class transformers.SwinForMaskedImageModeling",anchor:"transformers.SwinForMaskedImageModeling",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SwinForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_swin.py#L1055"}}),ie=new _t({props:{$$slots:{default:[ta]},$$scope:{ctx:F}}}),et=new I({props:{name:"forward",anchor:"transformers.SwinForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.SwinForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwinForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_swin.py#L1072",returnDescription:`
<p>A <code>transformers.models.swin.modeling_swin.SwinMaskedImageModelingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.swin.modeling_swin.SwinMaskedImageModelingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new _t({props:{$$slots:{default:[oa]},$$scope:{ctx:F}}}),ce=new bt({props:{anchor:"transformers.SwinForMaskedImageModeling.forward.example",$$slots:{default:[na]},$$scope:{ctx:F}}}),tt=new H({}),ot=new I({props:{name:"class transformers.SwinForImageClassification",anchor:"transformers.SwinForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SwinForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_swin.py#L1166"}}),nt=new I({props:{name:"forward",anchor:"transformers.SwinForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.SwinForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwinForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_swin.py#L1181",returnDescription:`
<p>A <code>transformers.models.swin.modeling_swin.SwinImageClassifierOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.swin.modeling_swin.SwinImageClassifierOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new _t({props:{$$slots:{default:[sa]},$$scope:{ctx:F}}}),he=new bt({props:{anchor:"transformers.SwinForImageClassification.forward.example",$$slots:{default:[aa]},$$scope:{ctx:F}}}),st=new H({}),at=new I({props:{name:"class transformers.TFSwinModel",anchor:"transformers.TFSwinModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_tf_swin.py#L1173"}}),rt=new I({props:{name:"call",anchor:"transformers.TFSwinModel.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinModel.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_tf_swin.py#L1181",returnDescription:`
<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinModelOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.swin.modeling_tf_swin.TFSwinModelOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),fe=new _t({props:{$$slots:{default:[ra]},$$scope:{ctx:F}}}),ge=new bt({props:{anchor:"transformers.TFSwinModel.call.example",$$slots:{default:[la]},$$scope:{ctx:F}}}),lt=new H({}),it=new I({props:{name:"class transformers.TFSwinForMaskedImageModeling",anchor:"transformers.TFSwinForMaskedImageModeling",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_tf_swin.py#L1276"}}),dt=new I({props:{name:"call",anchor:"transformers.TFSwinForMaskedImageModeling.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinForMaskedImageModeling.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_tf_swin.py#L1284",returnDescription:`
<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinMaskedImageModelingOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.swin.modeling_tf_swin.TFSwinMaskedImageModelingOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),_e=new _t({props:{$$slots:{default:[ia]},$$scope:{ctx:F}}}),be=new bt({props:{anchor:"transformers.TFSwinForMaskedImageModeling.call.example",$$slots:{default:[da]},$$scope:{ctx:F}}}),ct=new H({}),pt=new I({props:{name:"class transformers.TFSwinForImageClassification",anchor:"transformers.TFSwinForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_tf_swin.py#L1388"}}),mt=new I({props:{name:"call",anchor:"transformers.TFSwinForImageClassification.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinForImageClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinForImageClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/swin/modeling_tf_swin.py#L1402",returnDescription:`
<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinImageClassifierOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.swin.modeling_tf_swin.TFSwinImageClassifierOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),ve=new _t({props:{$$slots:{default:[ca]},$$scope:{ctx:F}}}),ye=new bt({props:{anchor:"transformers.TFSwinForImageClassification.call.example",$$slots:{default:[pa]},$$scope:{ctx:F}}}),{c(){o=a("meta"),f=i(),p=a("p"),m=i(),T=a("h1"),n=a("a"),$=a("span"),w(Ie.$$.fragment),Ko=i(),vt=a("span"),vt.textContent=Ln,go=i(),V=a("h2"),K=a("a"),Dt=a("span"),w(We.$$.fragment),en=i(),yt=a("span"),yt.textContent=qn,wo=i(),Ue=a("p"),Ue.innerHTML=Qn,_o=i(),Je=a("p"),Je.textContent=An,bo=i(),Ze=a("p"),Ze.innerHTML=Dn,Mo=i(),Ne=a("p"),Ne.textContent=On,vo=i(),ze=a("ul"),ze.innerHTML=Kn,yo=i(),ee=a("img"),To=i(),Ge=a("small"),Ge.innerHTML=ts,$o=i(),Be=a("p"),Be.innerHTML=os,Fo=i(),P=a("h2"),te=a("a"),Ot=a("span"),w(Re.$$.fragment),tn=i(),Tt=a("span"),Tt.textContent=ns,ko=i(),Ee=a("p"),Ee.textContent=ss,jo=i(),w(Xe.$$.fragment),Co=i(),He=a("ul"),He.innerHTML=as,So=i(),Ve=a("p"),Ve.textContent=rs,xo=i(),Pe=a("ul"),Pe.innerHTML=ls,Io=i(),Ye=a("p"),Ye.textContent=is,Wo=i(),Y=a("h2"),oe=a("a"),Kt=a("span"),w(Le.$$.fragment),on=i(),$t=a("span"),$t.textContent=ds,Uo=i(),C=a("div"),w(qe.$$.fragment),nn=i(),Ft=a("p"),Ft.innerHTML=cs,sn=i(),kt=a("p"),kt.innerHTML=ps,an=i(),w(ne.$$.fragment),Jo=i(),L=a("h2"),se=a("a"),eo=a("span"),w(Qe.$$.fragment),rn=i(),jt=a("span"),jt.textContent=ms,Zo=i(),G=a("div"),w(Ae.$$.fragment),ln=i(),Ct=a("p"),Ct.innerHTML=hs,dn=i(),W=a("div"),w(De.$$.fragment),cn=i(),St=a("p"),St.innerHTML=us,pn=i(),w(ae.$$.fragment),mn=i(),w(re.$$.fragment),No=i(),q=a("h2"),le=a("a"),to=a("span"),w(Oe.$$.fragment),hn=i(),xt=a("span"),xt.textContent=fs,zo=i(),k=a("div"),w(Ke.$$.fragment),un=i(),It=a("p"),It.innerHTML=gs,fn=i(),w(ie.$$.fragment),gn=i(),Wt=a("p"),Wt.innerHTML=ws,wn=i(),U=a("div"),w(et.$$.fragment),_n=i(),Ut=a("p"),Ut.innerHTML=_s,bn=i(),w(de.$$.fragment),Mn=i(),w(ce.$$.fragment),Go=i(),Q=a("h2"),pe=a("a"),oo=a("span"),w(tt.$$.fragment),vn=i(),Jt=a("span"),Jt.textContent=bs,Bo=i(),S=a("div"),w(ot.$$.fragment),yn=i(),Zt=a("p"),Zt.textContent=Ms,Tn=i(),Nt=a("p"),Nt.innerHTML=vs,$n=i(),J=a("div"),w(nt.$$.fragment),Fn=i(),zt=a("p"),zt.innerHTML=ys,kn=i(),w(me.$$.fragment),jn=i(),w(he.$$.fragment),Ro=i(),A=a("h2"),ue=a("a"),no=a("span"),w(st.$$.fragment),Cn=i(),Gt=a("span"),Gt.textContent=Ts,Eo=i(),B=a("div"),w(at.$$.fragment),Sn=i(),Bt=a("p"),Bt.innerHTML=$s,xn=i(),Z=a("div"),w(rt.$$.fragment),In=i(),Rt=a("p"),Rt.innerHTML=Fs,Wn=i(),w(fe.$$.fragment),Un=i(),w(ge.$$.fragment),Xo=i(),D=a("h2"),we=a("a"),so=a("span"),w(lt.$$.fragment),Jn=i(),Et=a("span"),Et.textContent=ks,Ho=i(),R=a("div"),w(it.$$.fragment),Zn=i(),Xt=a("p"),Xt.innerHTML=js,Nn=i(),N=a("div"),w(dt.$$.fragment),zn=i(),Ht=a("p"),Ht.innerHTML=Cs,Gn=i(),w(_e.$$.fragment),Bn=i(),w(be.$$.fragment),Vo=i(),O=a("h2"),Me=a("a"),ao=a("span"),w(ct.$$.fragment),Rn=i(),Vt=a("span"),Vt.textContent=Ss,Po=i(),x=a("div"),w(pt.$$.fragment),En=i(),Pt=a("p"),Pt.textContent=xs,Xn=i(),Yt=a("p"),Yt.innerHTML=Is,Hn=i(),z=a("div"),w(mt.$$.fragment),Vn=i(),Lt=a("p"),Lt.innerHTML=Ws,Pn=i(),w(ve.$$.fragment),Yn=i(),w(ye.$$.fragment),Yo=i(),ro=a("p"),this.h()},l(e){const l=As("svelte-1phssyn",document.head);o=r(l,"META",{name:!0,content:!0}),l.forEach(t),f=d(e),p=r(e,"P",{}),g(p).forEach(t),m=d(e),T=r(e,"H1",{class:!0});var ht=g(T);n=r(ht,"A",{id:!0,class:!0,href:!0});var lo=g(n);$=r(lo,"SPAN",{});var io=g($);_(Ie.$$.fragment,io),io.forEach(t),lo.forEach(t),Ko=d(ht),vt=r(ht,"SPAN",{"data-svelte-h":!0}),u(vt)!=="svelte-103gsj3"&&(vt.textContent=Ln),ht.forEach(t),go=d(e),V=r(e,"H2",{class:!0});var ut=g(V);K=r(ut,"A",{id:!0,class:!0,href:!0});var co=g(K);Dt=r(co,"SPAN",{});var po=g(Dt);_(We.$$.fragment,po),po.forEach(t),co.forEach(t),en=d(ut),yt=r(ut,"SPAN",{"data-svelte-h":!0}),u(yt)!=="svelte-1jsw1pg"&&(yt.textContent=qn),ut.forEach(t),wo=d(e),Ue=r(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-fc0dli"&&(Ue.innerHTML=Qn),_o=d(e),Je=r(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-vfdo9a"&&(Je.textContent=An),bo=d(e),Ze=r(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1111d6o"&&(Ze.innerHTML=Dn),Mo=d(e),Ne=r(e,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-axv494"&&(Ne.textContent=On),vo=d(e),ze=r(e,"UL",{"data-svelte-h":!0}),u(ze)!=="svelte-orqzi3"&&(ze.innerHTML=Kn),yo=d(e),ee=r(e,"IMG",{src:!0,alt:!0,width:!0}),To=d(e),Ge=r(e,"SMALL",{"data-svelte-h":!0}),u(Ge)!=="svelte-56pw3c"&&(Ge.innerHTML=ts),$o=d(e),Be=r(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-72q0kq"&&(Be.innerHTML=os),Fo=d(e),P=r(e,"H2",{class:!0});var ft=g(P);te=r(ft,"A",{id:!0,class:!0,href:!0});var mo=g(te);Ot=r(mo,"SPAN",{});var ho=g(Ot);_(Re.$$.fragment,ho),ho.forEach(t),mo.forEach(t),tn=d(ft),Tt=r(ft,"SPAN",{"data-svelte-h":!0}),u(Tt)!=="svelte-w4zzv6"&&(Tt.textContent=ns),ft.forEach(t),ko=d(e),Ee=r(e,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-1pydsgt"&&(Ee.textContent=ss),jo=d(e),_(Xe.$$.fragment,e),Co=d(e),He=r(e,"UL",{"data-svelte-h":!0}),u(He)!=="svelte-6qh4fy"&&(He.innerHTML=as),So=d(e),Ve=r(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1k821ua"&&(Ve.textContent=rs),xo=d(e),Pe=r(e,"UL",{"data-svelte-h":!0}),u(Pe)!=="svelte-igx9v4"&&(Pe.innerHTML=ls),Io=d(e),Ye=r(e,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-1xesile"&&(Ye.textContent=is),Wo=d(e),Y=r(e,"H2",{class:!0});var gt=g(Y);oe=r(gt,"A",{id:!0,class:!0,href:!0});var uo=g(oe);Kt=r(uo,"SPAN",{});var fo=g(Kt);_(Le.$$.fragment,fo),fo.forEach(t),uo.forEach(t),on=d(gt),$t=r(gt,"SPAN",{"data-svelte-h":!0}),u($t)!=="svelte-18cbadc"&&($t.textContent=ds),gt.forEach(t),Uo=d(e),C=r(e,"DIV",{class:!0});var E=g(C);_(qe.$$.fragment,E),nn=d(E),Ft=r(E,"P",{"data-svelte-h":!0}),u(Ft)!=="svelte-1k9yuam"&&(Ft.innerHTML=cs),sn=d(E),kt=r(E,"P",{"data-svelte-h":!0}),u(kt)!=="svelte-cfh5wl"&&(kt.innerHTML=ps),an=d(E),_(ne.$$.fragment,E),E.forEach(t),Jo=d(e),L=r(e,"H2",{class:!0});var wt=g(L);se=r(wt,"A",{id:!0,class:!0,href:!0});var Us=g(se);eo=r(Us,"SPAN",{});var Js=g(eo);_(Qe.$$.fragment,Js),Js.forEach(t),Us.forEach(t),rn=d(wt),jt=r(wt,"SPAN",{"data-svelte-h":!0}),u(jt)!=="svelte-1lv3ra5"&&(jt.textContent=ms),wt.forEach(t),Zo=d(e),G=r(e,"DIV",{class:!0});var qt=g(G);_(Ae.$$.fragment,qt),ln=d(qt),Ct=r(qt,"P",{"data-svelte-h":!0}),u(Ct)!=="svelte-1s5nfel"&&(Ct.innerHTML=hs),dn=d(qt),W=r(qt,"DIV",{class:!0});var Te=g(W);_(De.$$.fragment,Te),cn=d(Te),St=r(Te,"P",{"data-svelte-h":!0}),u(St)!=="svelte-1sgo9ho"&&(St.innerHTML=us),pn=d(Te),_(ae.$$.fragment,Te),mn=d(Te),_(re.$$.fragment,Te),Te.forEach(t),qt.forEach(t),No=d(e),q=r(e,"H2",{class:!0});var qo=g(q);le=r(qo,"A",{id:!0,class:!0,href:!0});var Zs=g(le);to=r(Zs,"SPAN",{});var Ns=g(to);_(Oe.$$.fragment,Ns),Ns.forEach(t),Zs.forEach(t),hn=d(qo),xt=r(qo,"SPAN",{"data-svelte-h":!0}),u(xt)!=="svelte-9i33yi"&&(xt.textContent=fs),qo.forEach(t),zo=d(e),k=r(e,"DIV",{class:!0});var X=g(k);_(Ke.$$.fragment,X),un=d(X),It=r(X,"P",{"data-svelte-h":!0}),u(It)!=="svelte-12jqo2k"&&(It.innerHTML=gs),fn=d(X),_(ie.$$.fragment,X),gn=d(X),Wt=r(X,"P",{"data-svelte-h":!0}),u(Wt)!=="svelte-68lg8f"&&(Wt.innerHTML=ws),wn=d(X),U=r(X,"DIV",{class:!0});var $e=g(U);_(et.$$.fragment,$e),_n=d($e),Ut=r($e,"P",{"data-svelte-h":!0}),u(Ut)!=="svelte-xosm6"&&(Ut.innerHTML=_s),bn=d($e),_(de.$$.fragment,$e),Mn=d($e),_(ce.$$.fragment,$e),$e.forEach(t),X.forEach(t),Go=d(e),Q=r(e,"H2",{class:!0});var Qo=g(Q);pe=r(Qo,"A",{id:!0,class:!0,href:!0});var zs=g(pe);oo=r(zs,"SPAN",{});var Gs=g(oo);_(tt.$$.fragment,Gs),Gs.forEach(t),zs.forEach(t),vn=d(Qo),Jt=r(Qo,"SPAN",{"data-svelte-h":!0}),u(Jt)!=="svelte-f8lfvi"&&(Jt.textContent=bs),Qo.forEach(t),Bo=d(e),S=r(e,"DIV",{class:!0});var Fe=g(S);_(ot.$$.fragment,Fe),yn=d(Fe),Zt=r(Fe,"P",{"data-svelte-h":!0}),u(Zt)!=="svelte-k64ai4"&&(Zt.textContent=Ms),Tn=d(Fe),Nt=r(Fe,"P",{"data-svelte-h":!0}),u(Nt)!=="svelte-68lg8f"&&(Nt.innerHTML=vs),$n=d(Fe),J=r(Fe,"DIV",{class:!0});var ke=g(J);_(nt.$$.fragment,ke),Fn=d(ke),zt=r(ke,"P",{"data-svelte-h":!0}),u(zt)!=="svelte-zl8zvu"&&(zt.innerHTML=ys),kn=d(ke),_(me.$$.fragment,ke),jn=d(ke),_(he.$$.fragment,ke),ke.forEach(t),Fe.forEach(t),Ro=d(e),A=r(e,"H2",{class:!0});var Ao=g(A);ue=r(Ao,"A",{id:!0,class:!0,href:!0});var Bs=g(ue);no=r(Bs,"SPAN",{});var Rs=g(no);_(st.$$.fragment,Rs),Rs.forEach(t),Bs.forEach(t),Cn=d(Ao),Gt=r(Ao,"SPAN",{"data-svelte-h":!0}),u(Gt)!=="svelte-1n32dmb"&&(Gt.textContent=Ts),Ao.forEach(t),Eo=d(e),B=r(e,"DIV",{class:!0});var Qt=g(B);_(at.$$.fragment,Qt),Sn=d(Qt),Bt=r(Qt,"P",{"data-svelte-h":!0}),u(Bt)!=="svelte-13r0xu7"&&(Bt.innerHTML=$s),xn=d(Qt),Z=r(Qt,"DIV",{class:!0});var je=g(Z);_(rt.$$.fragment,je),In=d(je),Rt=r(je,"P",{"data-svelte-h":!0}),u(Rt)!=="svelte-1pj1wqg"&&(Rt.innerHTML=Fs),Wn=d(je),_(fe.$$.fragment,je),Un=d(je),_(ge.$$.fragment,je),je.forEach(t),Qt.forEach(t),Xo=d(e),D=r(e,"H2",{class:!0});var Do=g(D);we=r(Do,"A",{id:!0,class:!0,href:!0});var Es=g(we);so=r(Es,"SPAN",{});var Xs=g(so);_(lt.$$.fragment,Xs),Xs.forEach(t),Es.forEach(t),Jn=d(Do),Et=r(Do,"SPAN",{"data-svelte-h":!0}),u(Et)!=="svelte-zv5pks"&&(Et.textContent=ks),Do.forEach(t),Ho=d(e),R=r(e,"DIV",{class:!0});var At=g(R);_(it.$$.fragment,At),Zn=d(At),Xt=r(At,"P",{"data-svelte-h":!0}),u(Xt)!=="svelte-16awvh3"&&(Xt.innerHTML=js),Nn=d(At),N=r(At,"DIV",{class:!0});var Ce=g(N);_(dt.$$.fragment,Ce),zn=d(Ce),Ht=r(Ce,"P",{"data-svelte-h":!0}),u(Ht)!=="svelte-lbwcmm"&&(Ht.innerHTML=Cs),Gn=d(Ce),_(_e.$$.fragment,Ce),Bn=d(Ce),_(be.$$.fragment,Ce),Ce.forEach(t),At.forEach(t),Vo=d(e),O=r(e,"H2",{class:!0});var Oo=g(O);Me=r(Oo,"A",{id:!0,class:!0,href:!0});var Hs=g(Me);ao=r(Hs,"SPAN",{});var Vs=g(ao);_(ct.$$.fragment,Vs),Vs.forEach(t),Hs.forEach(t),Rn=d(Oo),Vt=r(Oo,"SPAN",{"data-svelte-h":!0}),u(Vt)!=="svelte-2ykcn4"&&(Vt.textContent=Ss),Oo.forEach(t),Po=d(e),x=r(e,"DIV",{class:!0});var Se=g(x);_(pt.$$.fragment,Se),En=d(Se),Pt=r(Se,"P",{"data-svelte-h":!0}),u(Pt)!=="svelte-k64ai4"&&(Pt.textContent=xs),Xn=d(Se),Yt=r(Se,"P",{"data-svelte-h":!0}),u(Yt)!=="svelte-2m586h"&&(Yt.innerHTML=Is),Hn=d(Se),z=r(Se,"DIV",{class:!0});var xe=g(z);_(mt.$$.fragment,xe),Vn=d(xe),Lt=r(xe,"P",{"data-svelte-h":!0}),u(Lt)!=="svelte-153myca"&&(Lt.innerHTML=Ws),Pn=d(xe),_(ve.$$.fragment,xe),Yn=d(xe),_(ye.$$.fragment,xe),xe.forEach(t),Se.forEach(t),Yo=d(e),ro=r(e,"P",{}),g(ro).forEach(t),this.h()},h(){h(o,"name","hf:doc:metadata"),h(o,"content",JSON.stringify(ha)),h(n,"id","swin-transformer"),h(n,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(n,"href","#swin-transformer"),h(T,"class","relative group"),h(K,"id","overview"),h(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(K,"href","#overview"),h(V,"class","relative group"),Ys(ee.src,es="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/swin_transformer_architecture.png")||h(ee,"src",es),h(ee,"alt","drawing"),h(ee,"width","600"),h(te,"id","resources"),h(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(te,"href","#resources"),h(P,"class","relative group"),h(oe,"id","transformers.SwinConfig"),h(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(oe,"href","#transformers.SwinConfig"),h(Y,"class","relative group"),h(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(se,"id","transformers.SwinModel"),h(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(se,"href","#transformers.SwinModel"),h(L,"class","relative group"),h(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(le,"id","transformers.SwinForMaskedImageModeling"),h(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(le,"href","#transformers.SwinForMaskedImageModeling"),h(q,"class","relative group"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(pe,"id","transformers.SwinForImageClassification"),h(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(pe,"href","#transformers.SwinForImageClassification"),h(Q,"class","relative group"),h(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ue,"id","transformers.TFSwinModel"),h(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ue,"href","#transformers.TFSwinModel"),h(A,"class","relative group"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(we,"id","transformers.TFSwinForMaskedImageModeling"),h(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(we,"href","#transformers.TFSwinForMaskedImageModeling"),h(D,"class","relative group"),h(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Me,"id","transformers.TFSwinForImageClassification"),h(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Me,"href","#transformers.TFSwinForImageClassification"),h(O,"class","relative group"),h(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){s(document.head,o),c(e,f,l),c(e,p,l),c(e,m,l),c(e,T,l),s(T,n),s(n,$),b(Ie,$,null),s(T,Ko),s(T,vt),c(e,go,l),c(e,V,l),s(V,K),s(K,Dt),b(We,Dt,null),s(V,en),s(V,yt),c(e,wo,l),c(e,Ue,l),c(e,_o,l),c(e,Je,l),c(e,bo,l),c(e,Ze,l),c(e,Mo,l),c(e,Ne,l),c(e,vo,l),c(e,ze,l),c(e,yo,l),c(e,ee,l),c(e,To,l),c(e,Ge,l),c(e,$o,l),c(e,Be,l),c(e,Fo,l),c(e,P,l),s(P,te),s(te,Ot),b(Re,Ot,null),s(P,tn),s(P,Tt),c(e,ko,l),c(e,Ee,l),c(e,jo,l),b(Xe,e,l),c(e,Co,l),c(e,He,l),c(e,So,l),c(e,Ve,l),c(e,xo,l),c(e,Pe,l),c(e,Io,l),c(e,Ye,l),c(e,Wo,l),c(e,Y,l),s(Y,oe),s(oe,Kt),b(Le,Kt,null),s(Y,on),s(Y,$t),c(e,Uo,l),c(e,C,l),b(qe,C,null),s(C,nn),s(C,Ft),s(C,sn),s(C,kt),s(C,an),b(ne,C,null),c(e,Jo,l),c(e,L,l),s(L,se),s(se,eo),b(Qe,eo,null),s(L,rn),s(L,jt),c(e,Zo,l),c(e,G,l),b(Ae,G,null),s(G,ln),s(G,Ct),s(G,dn),s(G,W),b(De,W,null),s(W,cn),s(W,St),s(W,pn),b(ae,W,null),s(W,mn),b(re,W,null),c(e,No,l),c(e,q,l),s(q,le),s(le,to),b(Oe,to,null),s(q,hn),s(q,xt),c(e,zo,l),c(e,k,l),b(Ke,k,null),s(k,un),s(k,It),s(k,fn),b(ie,k,null),s(k,gn),s(k,Wt),s(k,wn),s(k,U),b(et,U,null),s(U,_n),s(U,Ut),s(U,bn),b(de,U,null),s(U,Mn),b(ce,U,null),c(e,Go,l),c(e,Q,l),s(Q,pe),s(pe,oo),b(tt,oo,null),s(Q,vn),s(Q,Jt),c(e,Bo,l),c(e,S,l),b(ot,S,null),s(S,yn),s(S,Zt),s(S,Tn),s(S,Nt),s(S,$n),s(S,J),b(nt,J,null),s(J,Fn),s(J,zt),s(J,kn),b(me,J,null),s(J,jn),b(he,J,null),c(e,Ro,l),c(e,A,l),s(A,ue),s(ue,no),b(st,no,null),s(A,Cn),s(A,Gt),c(e,Eo,l),c(e,B,l),b(at,B,null),s(B,Sn),s(B,Bt),s(B,xn),s(B,Z),b(rt,Z,null),s(Z,In),s(Z,Rt),s(Z,Wn),b(fe,Z,null),s(Z,Un),b(ge,Z,null),c(e,Xo,l),c(e,D,l),s(D,we),s(we,so),b(lt,so,null),s(D,Jn),s(D,Et),c(e,Ho,l),c(e,R,l),b(it,R,null),s(R,Zn),s(R,Xt),s(R,Nn),s(R,N),b(dt,N,null),s(N,zn),s(N,Ht),s(N,Gn),b(_e,N,null),s(N,Bn),b(be,N,null),c(e,Vo,l),c(e,O,l),s(O,Me),s(Me,ao),b(ct,ao,null),s(O,Rn),s(O,Vt),c(e,Po,l),c(e,x,l),b(pt,x,null),s(x,En),s(x,Pt),s(x,Xn),s(x,Yt),s(x,Hn),s(x,z),b(mt,z,null),s(z,Vn),s(z,Lt),s(z,Pn),b(ve,z,null),s(z,Yn),b(ye,z,null),c(e,Yo,l),c(e,ro,l),Lo=!0},p(e,[l]){const ht={};l&2&&(ht.$$scope={dirty:l,ctx:e}),ne.$set(ht);const lo={};l&2&&(lo.$$scope={dirty:l,ctx:e}),ae.$set(lo);const io={};l&2&&(io.$$scope={dirty:l,ctx:e}),re.$set(io);const ut={};l&2&&(ut.$$scope={dirty:l,ctx:e}),ie.$set(ut);const co={};l&2&&(co.$$scope={dirty:l,ctx:e}),de.$set(co);const po={};l&2&&(po.$$scope={dirty:l,ctx:e}),ce.$set(po);const ft={};l&2&&(ft.$$scope={dirty:l,ctx:e}),me.$set(ft);const mo={};l&2&&(mo.$$scope={dirty:l,ctx:e}),he.$set(mo);const ho={};l&2&&(ho.$$scope={dirty:l,ctx:e}),fe.$set(ho);const gt={};l&2&&(gt.$$scope={dirty:l,ctx:e}),ge.$set(gt);const uo={};l&2&&(uo.$$scope={dirty:l,ctx:e}),_e.$set(uo);const fo={};l&2&&(fo.$$scope={dirty:l,ctx:e}),be.$set(fo);const E={};l&2&&(E.$$scope={dirty:l,ctx:e}),ve.$set(E);const wt={};l&2&&(wt.$$scope={dirty:l,ctx:e}),ye.$set(wt)},i(e){Lo||(M(Ie.$$.fragment,e),M(We.$$.fragment,e),M(Re.$$.fragment,e),M(Xe.$$.fragment,e),M(Le.$$.fragment,e),M(qe.$$.fragment,e),M(ne.$$.fragment,e),M(Qe.$$.fragment,e),M(Ae.$$.fragment,e),M(De.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(Oe.$$.fragment,e),M(Ke.$$.fragment,e),M(ie.$$.fragment,e),M(et.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(tt.$$.fragment,e),M(ot.$$.fragment,e),M(nt.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(st.$$.fragment,e),M(at.$$.fragment,e),M(rt.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(lt.$$.fragment,e),M(it.$$.fragment,e),M(dt.$$.fragment,e),M(_e.$$.fragment,e),M(be.$$.fragment,e),M(ct.$$.fragment,e),M(pt.$$.fragment,e),M(mt.$$.fragment,e),M(ve.$$.fragment,e),M(ye.$$.fragment,e),Lo=!0)},o(e){v(Ie.$$.fragment,e),v(We.$$.fragment,e),v(Re.$$.fragment,e),v(Xe.$$.fragment,e),v(Le.$$.fragment,e),v(qe.$$.fragment,e),v(ne.$$.fragment,e),v(Qe.$$.fragment,e),v(Ae.$$.fragment,e),v(De.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(ie.$$.fragment,e),v(et.$$.fragment,e),v(de.$$.fragment,e),v(ce.$$.fragment,e),v(tt.$$.fragment,e),v(ot.$$.fragment,e),v(nt.$$.fragment,e),v(me.$$.fragment,e),v(he.$$.fragment,e),v(st.$$.fragment,e),v(at.$$.fragment,e),v(rt.$$.fragment,e),v(fe.$$.fragment,e),v(ge.$$.fragment,e),v(lt.$$.fragment,e),v(it.$$.fragment,e),v(dt.$$.fragment,e),v(_e.$$.fragment,e),v(be.$$.fragment,e),v(ct.$$.fragment,e),v(pt.$$.fragment,e),v(mt.$$.fragment,e),v(ve.$$.fragment,e),v(ye.$$.fragment,e),Lo=!1},d(e){e&&(t(f),t(p),t(m),t(T),t(go),t(V),t(wo),t(Ue),t(_o),t(Je),t(bo),t(Ze),t(Mo),t(Ne),t(vo),t(ze),t(yo),t(ee),t(To),t(Ge),t($o),t(Be),t(Fo),t(P),t(ko),t(Ee),t(jo),t(Co),t(He),t(So),t(Ve),t(xo),t(Pe),t(Io),t(Ye),t(Wo),t(Y),t(Uo),t(C),t(Jo),t(L),t(Zo),t(G),t(No),t(q),t(zo),t(k),t(Go),t(Q),t(Bo),t(S),t(Ro),t(A),t(Eo),t(B),t(Xo),t(D),t(Ho),t(R),t(Vo),t(O),t(Po),t(x),t(Yo),t(ro)),t(o),y(Ie),y(We),y(Re),y(Xe,e),y(Le),y(qe),y(ne),y(Qe),y(Ae),y(De),y(ae),y(re),y(Oe),y(Ke),y(ie),y(et),y(de),y(ce),y(tt),y(ot),y(nt),y(me),y(he),y(st),y(at),y(rt),y(fe),y(ge),y(lt),y(it),y(dt),y(_e),y(be),y(ct),y(pt),y(mt),y(ve),y(ye)}}}const ha={local:"swin-transformer",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.SwinConfig",title:"SwinConfig"},{local:"transformers.SwinModel",title:"SwinModel"},{local:"transformers.SwinForMaskedImageModeling",title:"SwinForMaskedImageModeling"},{local:"transformers.SwinForImageClassification",title:"SwinForImageClassification"},{local:"transformers.TFSwinModel",title:"TFSwinModel"},{local:"transformers.TFSwinForMaskedImageModeling",title:"TFSwinForMaskedImageModeling"},{local:"transformers.TFSwinForImageClassification",title:"TFSwinForImageClassification"}],title:"Swin Transformer"};function ua(F){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends qs{constructor(o){super(),Qs(this,o,ua,ma,Ps,{})}}export{Ta as component};
