import{s as Hk,o as qk,n as x}from"../chunks/scheduler.9bc65507.js";import{S as Dk,i as Pk,g as a,s as n,r as p,A as Qk,h as l,f as s,c as o,j as T,u as m,x as y,k as M,y as t,a as d,v as g,d as u,t as h,w as f}from"../chunks/index.707bf1b6.js";import{T as vn}from"../chunks/Tip.c2ecdbf4.js";import{D as v}from"../chunks/Docstring.17db21ae.js";import{C as J}from"../chunks/CodeBlock.54a9f38d.js";import{E as B}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as O}from"../chunks/Heading.342b1fa6.js";function Yk(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-nbt45a"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Ak(j){let i,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1uojnuk"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Ok(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function Kk(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function e2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function t2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function s2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function n2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function o2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function r2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function a2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This Whisper model forces the generation to start with \`50362\` at the first position by default, i.e.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`&quot;forced_decoder_ids&quot;: [[1, 50362]]\`. This means all other tokens are masked out.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">0.</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`forced_decoder_ids\`, we stop seeing that effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, forced_decoder_ids=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">19.3140</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function l2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function c2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">816.3250</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">1.0000</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function i2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function d2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function p2(j){let i,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-15bvr1j"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function m2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function g2(j){let i,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-5zfsi9"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function u2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function h2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity =  tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function f2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function _2(j){let i,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-16cusgy"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function b2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function y2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function T2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">5.7738</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function M2(j){let i,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=a("p"),i.innerHTML=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1byeoum"&&(i.innerHTML=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function v2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function w2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, G, H, I. A, M

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function k2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function $2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function j2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function x2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function J2(j){let i,$;return i=new J({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){p(i.$$.fragment)},l(b){m(i.$$.fragment,b)},m(b,_){g(i,b,_),$=!0},p:x,i(b){$||(u(i.$$.fragment,b),$=!0)},o(b){h(i.$$.fragment,b),$=!1},d(b){f(i,b)}}}function U2(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function B2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function I2(j){let i,$="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=$},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=$)},m(b,_){d(b,i,_)},p:x,d(b){b&&s(i)}}}function Z2(j){let i,$="Examples:",b,_,w;return _=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=$,b=n(),p(_.$$.fragment)},l(r){i=l(r,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=$),b=o(r),m(_.$$.fragment,r)},m(r,k){d(r,i,k),d(r,b,k),g(_,r,k),w=!0},p:x,i(r){w||(u(_.$$.fragment,r),w=!0)},o(r){h(_.$$.fragment,r),w=!1},d(r){r&&(s(i),s(b)),f(_,r)}}}function z2(j){let i,$,b,_,w,r,k,RT='This page lists all the utility functions used by <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM.generate">generate()</a>.',Cm,wn,Lm,kn,ST=`The output of <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Fm,$n,NT="Here’s an example:",Vm,jn,Gm,xn,ET=`The <code>generation_output</code> object is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Xm,Jn,HT="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Rm,Un,qT=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Sm,Bn,DT=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Nm,In,PT=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Em,Zn,Hm,zn,QT="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",qm,Wn,YT=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Dm,Cn,AT="We document here all output types.",Pm,Ln,Qm,Jt,Fn,Jh,Hl,OT="Outputs of decoder-only generation models, when using non-beam methods.",Ym,Ut,Vn,Uh,ql,KT="Outputs of encoder-decoder generation models, when using non-beam methods.",Am,Bt,Gn,Bh,Dl,eM="Outputs of decoder-only generation models, when using beam methods.",Om,It,Xn,Ih,Pl,tM="Outputs of encoder-decoder generation models, when using beam methods.",Km,Rn,eg,Zt,Sn,Zh,Ql,sM=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,tg,zt,Nn,zh,Yl,nM="Base class for outputs of decoder-only generation models using greedy search.",sg,Wt,En,Wh,Al,oM=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ng,Ct,Hn,Ch,Ol,rM="Base class for outputs of decoder-only generation models using sampling.",og,Lt,qn,Lh,Kl,aM=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,rg,Ft,Dn,Fh,ec,lM="Base class for outputs of decoder-only generation models using beam search.",ag,Vt,Pn,Vh,tc,cM=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,lg,Gt,Qn,Gh,sc,iM="Base class for outputs of decoder-only generation models using beam sample.",cg,Xt,Yn,Xh,nc,dM=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ig,Rt,An,Rh,oc,pM="Base class for outputs of decoder-only generation models using contrastive search.",dg,On,pg,xe,Kn,Sh,rc,mM="Flax Base class for outputs of decoder-only generation models using sampling.",Nh,Pt,eo,Eh,ac,gM="“Returns a new object replacing the specified fields with new values.",mg,Je,to,Hh,lc,uM="Flax Base class for outputs of decoder-only generation models using greedy search.",qh,Qt,so,Dh,cc,hM="“Returns a new object replacing the specified fields with new values.",gg,Ue,no,Ph,ic,fM="Flax Base class for outputs of decoder-only generation models using greedy search.",Qh,Yt,oo,Yh,dc,_M="“Returns a new object replacing the specified fields with new values.",ug,ro,hg,ao,bM=`A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,fg,lo,_g,ee,co,Ah,pc,yM='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',Oh,At,Kh,mc,io,bg,W,po,ef,gc,TM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,tf,uc,MM='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',sf,Ot,nf,Kt,of,hc,mo,yg,X,go,rf,fc,vM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,af,_c,wM=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,lf,es,cf,bc,uo,Tg,R,ho,df,yc,kM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,pf,Tc,$M=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,mf,ts,gf,Mc,fo,Mg,te,_o,uf,vc,jM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,hf,ss,ff,wc,bo,vg,se,yo,_f,kc,xM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,bf,ns,yf,$c,To,wg,ne,Mo,Tf,jc,JM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,Mf,os,vf,xc,vo,kg,oe,wo,wf,Jc,UM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,kf,rs,$f,Uc,ko,$g,re,$o,jf,Bc,BM='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',xf,as,Jf,Ic,jo,jg,ae,xo,Uf,Zc,IM=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before generation. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,Bf,ls,If,zc,Jo,xg,C,Uo,Zf,Wc,ZM='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',zf,Cc,zM=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search()</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,Wf,Lc,WM=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,Cf,cs,Lf,Fc,Bo,Jg,le,Io,Ff,Vc,CM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,Vf,Gc,LM=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,Gf,Xc,Zo,Ug,ce,zo,Xf,Rc,FM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,Rf,is,Sf,Sc,Wo,Bg,Be,Co,Nf,Nc,VM="Abstract base class for all logit processors that can be applied during generation.",Ef,Ec,Lo,Ig,Ie,Fo,Hf,Hc,GM=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,qf,qc,Vo,Zg,Ze,Go,Df,Dc,XM="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Pf,Pc,Xo,zg,ie,Ro,Qf,Qc,RM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,Yf,ds,Af,Yc,So,Wg,de,No,Of,Ac,SM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,Kf,ps,e_,Oc,Eo,Cg,S,Ho,t_,Kc,NM='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',s_,ms,n_,gs,o_,ei,qo,Lg,N,Do,r_,ti,EM=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,a_,us,l_,hs,c_,si,Po,Fg,pe,Qo,i_,ni,HM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,d_,fs,p_,oi,Yo,Vg,E,Ao,m_,ri,qM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,g_,ai,DM=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,u_,_s,h_,li,Oo,Gg,H,Ko,f_,ci,PM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,__,bs,b_,ys,y_,ii,er,Xg,me,tr,T_,di,QM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,M_,Ts,v_,pi,sr,Rg,ge,nr,w_,mi,YM=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,k_,Ms,$_,gi,or,Sg,q,rr,j_,ui,AM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,x_,vs,J_,ws,U_,hi,ar,Ng,ue,lr,B_,fi,OM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used together
with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,I_,ks,Z_,_i,cr,Eg,he,ir,z_,bi,KM=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off. Often
used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,W_,$s,C_,yi,dr,Hg,D,pr,L_,Ti,ev=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens whose
log probability is close to the entropy of the token probability distribution. This means that the most likely
tokens may be discarded in the process.`,F_,Mi,tv='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',V_,js,G_,vi,mr,qg,P,gr,X_,wi,sv=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,R_,ki,nv='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',S_,xs,N_,$i,ur,Dg,Q,hr,E_,ji,ov=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,H_,xi,rv='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',q_,Js,D_,Ji,fr,Pg,_r,Qg,ze,br,P_,Ui,av='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Q_,Bi,yr,Yg,We,Tr,Y_,Ii,lv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',A_,Zi,Mr,Ag,Ce,vr,O_,zi,cv=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,K_,Wi,wr,Og,Le,kr,eb,Ci,iv="Abstract base class for all logit processors that can be applied during generation.",tb,Us,$r,sb,Li,dv="TF method for processing logits.",Kg,Fe,jr,nb,Fi,pv=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,ob,Vi,xr,eu,Ve,Jr,rb,Gi,mv="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",ab,Bs,Ur,lb,Xi,gv="TF method for warping logits.",tu,Ge,Br,cb,Ri,uv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',ib,Si,Ir,su,Xe,Zr,db,Ni,hv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',pb,Ei,zr,nu,Re,Wr,mb,Hi,fv=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,gb,qi,Cr,ou,Se,Lr,ub,Di,_v='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',hb,Pi,Fr,ru,Ne,Vr,fb,Qi,bv=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,_b,Yi,Gr,au,Ee,Xr,bb,Ai,yv=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,yb,Oi,Rr,lu,He,Sr,Tb,Ki,Tv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Mb,ed,Nr,cu,qe,Er,vb,td,Mv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',wb,sd,Hr,iu,De,qr,kb,nd,vv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',$b,od,Dr,du,Pr,pu,Pe,Qr,jb,rd,wv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',xb,ad,Yr,mu,Qe,Ar,Jb,ld,kv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Ub,cd,Or,gu,Ye,Kr,Bb,id,$v=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Ib,dd,ea,uu,Ae,ta,Zb,pd,jv="Abstract base class for all logit processors that can be applied during generation.",zb,Is,sa,Wb,md,xv="Flax method for processing logits.",hu,Oe,na,Cb,gd,Jv=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,Lb,ud,oa,fu,Ke,ra,Fb,hd,Uv="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Vb,Zs,aa,Gb,fd,Bv="Flax method for warping logits.",_u,et,la,Xb,_d,Iv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Rb,bd,ca,bu,tt,ia,Sb,yd,Zv=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,Nb,Td,da,yu,st,pa,Eb,Md,zv=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,Hb,vd,ma,Tu,nt,ga,qb,wd,Wv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Db,kd,ua,Mu,ot,ha,Pb,$d,Cv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Qb,jd,fa,vu,rt,_a,Yb,xd,Lv='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',Ab,Jd,ba,wu,at,ya,Ob,Ud,Fv=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,Kb,Bd,Ta,ku,Ma,$u,va,Vv='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',ju,fe,wa,ey,Id,Gv="Abstract base class for all stopping criteria that can be applied during generation.",ty,Zd,Xv="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",sy,zd,ka,xu,St,$a,ny,Wd,ja,Ju,lt,xa,oy,Cd,Rv=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,ry,Ld,Ja,Uu,ct,Ua,ay,Fd,Sv=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,ly,Vd,Ba,Bu,Ia,Iu,Za,Nv='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',Zu,U,za,cy,Gd,Ev=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,iy,Xd,Hv="All classes that inherit Constraint must follow the requirement that",dy,zs,py,Rd,qv="will always terminate (halt).",my,Ws,Wa,gy,Sd,Dv="When called, returns the token that would take this constraint one step closer to being fulfilled.",uy,Cs,Ca,hy,Nd,Pv="Creates a new instance of this constraint.",fy,Ls,La,_y,Ed,Qv="Reads in a token and returns whether it creates progress.",by,Fs,Fa,yy,Hd,Yv="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",Ty,Vs,Va,My,qd,Av=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,vy,Gs,Ga,wy,Dd,Ov="Tests whether this constraint has been properly defined.",ky,bt,Xa,$y,Pd,Kv=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,jy,Qd,ew=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,zu,Nt,Ra,xy,Yd,tw='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Wu,Et,Sa,Jy,Ad,sw='A special <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Cu,_e,Na,Uy,Od,nw="A class for beam scorers to track its progress through a list of constraints.",By,V,Ea,Iy,Kd,ow=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,Zy,ep,rw=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,zy,tp,aw="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",Wy,sp,lw=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,Cy,np,cw=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,Ly,Xs,Ha,Fy,op,iw="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Lu,qa,Fu,be,Da,Vy,rp,dw=`Abstract base class for all beam scorers that are used for <code>beam_search()</code> and
<code>beam_sample()</code>.`,Gy,ap,Pa,Xy,lp,Qa,Vu,L,Ya,Ry,cp,pw='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Sy,ip,mw=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Ny,dp,gw=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,Ey,pp,Aa,Hy,mp,Oa,Gu,ye,Ka,qy,gp,uw='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Dy,up,el,Py,hp,tl,Xu,sl,Ru,it,nl,Qy,fp,hw="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Yy,_p,fw='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Su,dt,ol,Ay,bp,_w="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Oy,yp,bw='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Nu,rl,Eu,z,al,Ky,Tp,yw="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",eT,Rs,tT,Ss,sT,Ns,ll,nT,Mp,Tw="Flushes any remaining cache and prints a newline to stdout.",oT,Es,cl,rT,vp,Mw="Prints the new text to stdout. If the stream is ending, also prints a newline.",aT,Hs,il,lT,wp,vw="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Hu,Y,dl,cT,kp,ww=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,iT,qs,dT,Ds,pT,Ps,pl,mT,$p,kw="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",qu,ml,Du,pt,gl,gT,jp,$w="Base, abstract class for all caches. The actual data structure is specific to each subclass.",uT,Qs,ul,hT,xp,jw="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Pu,Z,hl,fT,Jp,xw="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",_T,Up,Jw=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,bT,Ys,fl,yT,Bp,Uw="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",TT,As,_l,MT,Ip,Bw="Returns the sequence length of the cached states. A layer index can be optionally passed.",vT,Os,bl,wT,Zp,Iw="Reorders the cache for beam search, given the selected beam indices.",kT,Ks,yl,$T,zp,Zw="Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format.",jT,en,Tl,xT,Wp,zw="Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>.",Qu,F,Ml,JT,Cp,Ww=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,UT,Lp,Cw=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,BT,tn,vl,IT,Fp,Lw="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",ZT,sn,wl,zT,Vp,Fw="Returns the sequence length of the cached states. A layer index can be optionally passed.",WT,nn,kl,CT,Gp,Vw="Reorders the cache for beam search, given the selected beam indices.",Yu,Te,$l,LT,Xp,Gw="Static Cache class to be used with <code>torch.compile(model)</code>.",FT,on,jl,VT,Rp,Xw=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,GT,rn,xl,XT,Sp,Rw="Returns the sequence length of the cached states that were seen by the model. <code>layer_idx</code> kept for BC",Au,jm,Ou;return w=new O({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),wn=new O({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),jn=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Zn=new J({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),Ln=new O({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),Fn=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L100"}}),Vn=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L140"}}),Gn=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L192"}}),Xn=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L240"}}),Rn=new O({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),Sn=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L85"}}),Nn=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L57"}}),En=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L155"}}),Hn=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L127"}}),qn=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L232"}}),Dn=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L197"}}),Pn=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L317"}}),Qn=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L282"}}),Yn=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L393"}}),An=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L366"}}),On=new O({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Kn=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L68"}}),eo=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),to=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L54"}}),so=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),no=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L82"}}),oo=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),ro=new O({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),lo=new O({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),co=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2011"}}),At=new vn({props:{warning:!0,$$slots:{default:[Yk]},$$scope:{ctx:j}}}),io=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2040"}}),po=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1947"}}),Ot=new vn({props:{warning:!0,$$slots:{default:[Ak]},$$scope:{ctx:j}}}),Kt=new B({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Ok]},$$scope:{ctx:j}}}),mo=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1995",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L874"}}),es=new B({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[Kk]},$$scope:{ctx:j}}}),uo=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ho=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L342"}}),ts=new B({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[e2]},$$scope:{ctx:j}}}),fo=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L386",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_o=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L603"}}),ss=new B({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[t2]},$$scope:{ctx:j}}}),bo=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L656",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L670"}}),ns=new B({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[s2]},$$scope:{ctx:j}}}),To=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L733",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1494"}}),os=new B({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[n2]},$$scope:{ctx:j}}}),vo=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wo=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1378"}}),rs=new B({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[o2]},$$scope:{ctx:j}}}),ko=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1423"}}),as=new B({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[r2]},$$scope:{ctx:j}}}),jo=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1710"}}),ls=new B({props:{anchor:"transformers.ForceTokensLogitsProcessor.example",$$slots:{default:[a2]},$$scope:{ctx:j}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Uo=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1245"}}),cs=new B({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[l2]},$$scope:{ctx:j}}}),Bo=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Io=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1473"}}),Zo=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1585"}}),is=new B({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[c2]},$$scope:{ctx:j}}}),Wo=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1616",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Co=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L44"}}),Lo=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L47",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Fo=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L64"}}),Vo=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L71",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Go=new v({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L54"}}),Xo=new v({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L57",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ro=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L102"}}),ds=new B({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[i2]},$$scope:{ctx:j}}}),So=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L151",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L160"}}),ps=new B({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[d2]},$$scope:{ctx:j}}}),Eo=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ho=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1090"}}),ms=new vn({props:{$$slots:{default:[p2]},$$scope:{ctx:j}}}),gs=new B({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[m2]},$$scope:{ctx:j}}}),qo=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Do=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L816"}}),us=new vn({props:{$$slots:{default:[g2]},$$scope:{ctx:j}}}),hs=new B({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[u2]},$$scope:{ctx:j}}}),Po=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1177"}}),fs=new B({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[h2]},$$scope:{ctx:j}}}),Yo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ao=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L288"}}),_s=new B({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[f2]},$$scope:{ctx:j}}}),Oo=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L331",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ko=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": Dict"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L942"}}),bs=new vn({props:{$$slots:{default:[_2]},$$scope:{ctx:j}}}),ys=new B({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[b2]},$$scope:{ctx:j}}}),er=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),tr=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1622"}}),Ts=new B({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[y2]},$$scope:{ctx:j}}}),sr=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1664",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),nr=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1672"}}),Ms=new B({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[T2]},$$scope:{ctx:j}}}),or=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1704",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),rr=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L222"}}),vs=new vn({props:{$$slots:{default:[M2]},$$scope:{ctx:j}}}),ws=new B({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[v2]},$$scope:{ctx:j}}}),ar=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L282",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lr=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L462"}}),ks=new B({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[w2]},$$scope:{ctx:j}}}),cr=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ir=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L397"}}),$s=new B({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[k2]},$$scope:{ctx:j}}}),dr=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),pr=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L515"}}),js=new B({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[$2]},$$scope:{ctx:j}}}),mr=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),gr=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2055"}}),xs=new B({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[j2]},$$scope:{ctx:j}}}),ur=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2161"}}),hr=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1761"}}),Js=new B({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[x2]},$$scope:{ctx:j}}}),fr=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1843",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_r=new O({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),br=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),yr=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),Tr=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),Mr=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),vr=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L551"}}),wr=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L567"}}),kr=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),$r=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),jr=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),xr=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jr=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),Ur=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Br=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),Ir=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),Zr=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),zr=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),Wr=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),Cr=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),Lr=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),Fr=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),Vr=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),Gr=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),Xr=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L535"}}),Rr=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L542"}}),Sr=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),Nr=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),Er=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),Hr=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),qr=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),Dr=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),Pr=new O({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Qr=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L194"}}),Yr=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L206"}}),Ar=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L216"}}),Or=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L231"}}),Kr=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L315"}}),ea=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L337"}}),ta=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L50"}}),sa=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),na=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L72"}}),oa=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ra=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L61"}}),aa=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),la=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L241"}}),ca=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L262"}}),ia=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L271"}}),da=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L288"}}),pa=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L296"}}),ma=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L309"}}),ga=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L95"}}),ua=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L110"}}),ha=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L159"}}),fa=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L179"}}),_a=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L115"}}),ba=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L139"}}),ya=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L363"}}),Ta=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L397"}}),Ma=new O({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),wa=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L38"}}),ka=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L45",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),$a=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L132"}}),ja=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),xa=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L50"}}),Ja=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L66",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ua=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L109"}}),Ba=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ia=new O({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),za=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),zs=new B({props:{anchor:"transformers.Constraint.example",$$slots:{default:[J2]},$$scope:{ctx:j}}}),Wa=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),Ca=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),La=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L60"}}),Fa=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L104"}}),Va=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L94"}}),Ga=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),Xa=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),Ra=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L129"}}),Sa=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L261"}}),Na=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L351"}}),Ea=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L383"}}),Ha=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L418"}}),qa=new O({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),Da=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),Pa=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>group_beam_search()</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Qa=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Ya=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),Aa=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),Oa=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L318"}}),Ka=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L415"}}),el=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L509",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),tl=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L807"}}),sl=new O({props:{title:"Utilities",local:"transformers.top_k_top_p_filtering",headingTag:"h2"}}),nl=new v({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L4786"}}),ol=new v({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L3091"}}),rl=new O({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),al=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L38"}}),Rs=new vn({props:{warning:!0,$$slots:{default:[U2]},$$scope:{ctx:j}}}),Ss=new B({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[B2]},$$scope:{ctx:j}}}),ll=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L116"}}),cl=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L130"}}),il=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L82"}}),dl=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L159"}}),qs=new vn({props:{warning:!0,$$slots:{default:[I2]},$$scope:{ctx:j}}}),Ds=new B({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[Z2]},$$scope:{ctx:j}}}),pl=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L213"}}),ml=new O({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),gl=new v({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L9"}}),ul=new v({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L15",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),hl=new v({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L61"}}),fl=new v({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),_l=new v({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L136"}}),bl=new v({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L146"}}),yl=new v({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L154"}}),Tl=new v({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L161"}}),Ml=new v({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L172"}}),vl=new v({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),wl=new v({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L230"}}),kl=new v({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L320"}}),$l=new v({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": int"},{name:"device",val:""},{name:"dtype",val:" = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:"<strong>config</strong> (<code>PretrainedConfig) -- The configuration file defining the </code>max_position_embeddings<code>, </code>hidden_size<code>and</code>num_attention_heads`\nrequired to initialize the static cache.",name:"config"},{anchor:"transformers.StaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L329"}}),jl=new v({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for. Kept for backward compatibility`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> just needs the <code>q_len</code>
to know how much of the cache it should overwrite.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),xl=new v({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L399"}}),{c(){i=a("meta"),$=n(),b=a("p"),_=n(),p(w.$$.fragment),r=n(),k=a("p"),k.innerHTML=RT,Cm=n(),p(wn.$$.fragment),Lm=n(),kn=a("p"),kn.innerHTML=ST,Fm=n(),$n=a("p"),$n.textContent=NT,Vm=n(),p(jn.$$.fragment),Gm=n(),xn=a("p"),xn.innerHTML=ET,Xm=n(),Jn=a("ul"),Jn.innerHTML=HT,Rm=n(),Un=a("p"),Un.innerHTML=qT,Sm=n(),Bn=a("p"),Bn.innerHTML=DT,Nm=n(),In=a("p"),In.innerHTML=PT,Em=n(),p(Zn.$$.fragment),Hm=n(),zn=a("p"),zn.innerHTML=QT,qm=n(),Wn=a("p"),Wn.innerHTML=YT,Dm=n(),Cn=a("p"),Cn.textContent=AT,Pm=n(),p(Ln.$$.fragment),Qm=n(),Jt=a("div"),p(Fn.$$.fragment),Jh=n(),Hl=a("p"),Hl.textContent=OT,Ym=n(),Ut=a("div"),p(Vn.$$.fragment),Uh=n(),ql=a("p"),ql.textContent=KT,Am=n(),Bt=a("div"),p(Gn.$$.fragment),Bh=n(),Dl=a("p"),Dl.textContent=eM,Om=n(),It=a("div"),p(Xn.$$.fragment),Ih=n(),Pl=a("p"),Pl.textContent=tM,Km=n(),p(Rn.$$.fragment),eg=n(),Zt=a("div"),p(Sn.$$.fragment),Zh=n(),Ql=a("p"),Ql.textContent=sM,tg=n(),zt=a("div"),p(Nn.$$.fragment),zh=n(),Yl=a("p"),Yl.textContent=nM,sg=n(),Wt=a("div"),p(En.$$.fragment),Wh=n(),Al=a("p"),Al.textContent=oM,ng=n(),Ct=a("div"),p(Hn.$$.fragment),Ch=n(),Ol=a("p"),Ol.textContent=rM,og=n(),Lt=a("div"),p(qn.$$.fragment),Lh=n(),Kl=a("p"),Kl.textContent=aM,rg=n(),Ft=a("div"),p(Dn.$$.fragment),Fh=n(),ec=a("p"),ec.textContent=lM,ag=n(),Vt=a("div"),p(Pn.$$.fragment),Vh=n(),tc=a("p"),tc.textContent=cM,lg=n(),Gt=a("div"),p(Qn.$$.fragment),Gh=n(),sc=a("p"),sc.textContent=iM,cg=n(),Xt=a("div"),p(Yn.$$.fragment),Xh=n(),nc=a("p"),nc.textContent=dM,ig=n(),Rt=a("div"),p(An.$$.fragment),Rh=n(),oc=a("p"),oc.textContent=pM,dg=n(),p(On.$$.fragment),pg=n(),xe=a("div"),p(Kn.$$.fragment),Sh=n(),rc=a("p"),rc.textContent=mM,Nh=n(),Pt=a("div"),p(eo.$$.fragment),Eh=n(),ac=a("p"),ac.textContent=gM,mg=n(),Je=a("div"),p(to.$$.fragment),Hh=n(),lc=a("p"),lc.textContent=uM,qh=n(),Qt=a("div"),p(so.$$.fragment),Dh=n(),cc=a("p"),cc.textContent=hM,gg=n(),Ue=a("div"),p(no.$$.fragment),Ph=n(),ic=a("p"),ic.textContent=fM,Qh=n(),Yt=a("div"),p(oo.$$.fragment),Yh=n(),dc=a("p"),dc.textContent=_M,ug=n(),p(ro.$$.fragment),hg=n(),ao=a("p"),ao.innerHTML=bM,fg=n(),p(lo.$$.fragment),_g=n(),ee=a("div"),p(co.$$.fragment),Ah=n(),pc=a("p"),pc.innerHTML=yM,Oh=n(),p(At.$$.fragment),Kh=n(),mc=a("div"),p(io.$$.fragment),bg=n(),W=a("div"),p(po.$$.fragment),ef=n(),gc=a("p"),gc.innerHTML=TM,tf=n(),uc=a("p"),uc.innerHTML=MM,sf=n(),p(Ot.$$.fragment),nf=n(),p(Kt.$$.fragment),of=n(),hc=a("div"),p(mo.$$.fragment),yg=n(),X=a("div"),p(go.$$.fragment),rf=n(),fc=a("p"),fc.innerHTML=vM,af=n(),_c=a("p"),_c.textContent=wM,lf=n(),p(es.$$.fragment),cf=n(),bc=a("div"),p(uo.$$.fragment),Tg=n(),R=a("div"),p(ho.$$.fragment),df=n(),yc=a("p"),yc.innerHTML=kM,pf=n(),Tc=a("p"),Tc.textContent=$M,mf=n(),p(ts.$$.fragment),gf=n(),Mc=a("div"),p(fo.$$.fragment),Mg=n(),te=a("div"),p(_o.$$.fragment),uf=n(),vc=a("p"),vc.innerHTML=jM,hf=n(),p(ss.$$.fragment),ff=n(),wc=a("div"),p(bo.$$.fragment),vg=n(),se=a("div"),p(yo.$$.fragment),_f=n(),kc=a("p"),kc.innerHTML=xM,bf=n(),p(ns.$$.fragment),yf=n(),$c=a("div"),p(To.$$.fragment),wg=n(),ne=a("div"),p(Mo.$$.fragment),Tf=n(),jc=a("p"),jc.innerHTML=JM,Mf=n(),p(os.$$.fragment),vf=n(),xc=a("div"),p(vo.$$.fragment),kg=n(),oe=a("div"),p(wo.$$.fragment),wf=n(),Jc=a("p"),Jc.innerHTML=UM,kf=n(),p(rs.$$.fragment),$f=n(),Uc=a("div"),p(ko.$$.fragment),$g=n(),re=a("div"),p($o.$$.fragment),jf=n(),Bc=a("p"),Bc.innerHTML=BM,xf=n(),p(as.$$.fragment),Jf=n(),Ic=a("div"),p(jo.$$.fragment),jg=n(),ae=a("div"),p(xo.$$.fragment),Uf=n(),Zc=a("p"),Zc.innerHTML=IM,Bf=n(),p(ls.$$.fragment),If=n(),zc=a("div"),p(Jo.$$.fragment),xg=n(),C=a("div"),p(Uo.$$.fragment),Zf=n(),Wc=a("p"),Wc.innerHTML=ZM,zf=n(),Cc=a("p"),Cc.innerHTML=zM,Wf=n(),Lc=a("p"),Lc.innerHTML=WM,Cf=n(),p(cs.$$.fragment),Lf=n(),Fc=a("div"),p(Bo.$$.fragment),Jg=n(),le=a("div"),p(Io.$$.fragment),Ff=n(),Vc=a("p"),Vc.innerHTML=CM,Vf=n(),Gc=a("p"),Gc.innerHTML=LM,Gf=n(),Xc=a("div"),p(Zo.$$.fragment),Ug=n(),ce=a("div"),p(zo.$$.fragment),Xf=n(),Rc=a("p"),Rc.innerHTML=FM,Rf=n(),p(is.$$.fragment),Sf=n(),Sc=a("div"),p(Wo.$$.fragment),Bg=n(),Be=a("div"),p(Co.$$.fragment),Nf=n(),Nc=a("p"),Nc.textContent=VM,Ef=n(),Ec=a("div"),p(Lo.$$.fragment),Ig=n(),Ie=a("div"),p(Fo.$$.fragment),Hf=n(),Hc=a("p"),Hc.innerHTML=GM,qf=n(),qc=a("div"),p(Vo.$$.fragment),Zg=n(),Ze=a("div"),p(Go.$$.fragment),Df=n(),Dc=a("p"),Dc.textContent=XM,Pf=n(),Pc=a("div"),p(Xo.$$.fragment),zg=n(),ie=a("div"),p(Ro.$$.fragment),Qf=n(),Qc=a("p"),Qc.innerHTML=RM,Yf=n(),p(ds.$$.fragment),Af=n(),Yc=a("div"),p(So.$$.fragment),Wg=n(),de=a("div"),p(No.$$.fragment),Of=n(),Ac=a("p"),Ac.innerHTML=SM,Kf=n(),p(ps.$$.fragment),e_=n(),Oc=a("div"),p(Eo.$$.fragment),Cg=n(),S=a("div"),p(Ho.$$.fragment),t_=n(),Kc=a("p"),Kc.innerHTML=NM,s_=n(),p(ms.$$.fragment),n_=n(),p(gs.$$.fragment),o_=n(),ei=a("div"),p(qo.$$.fragment),Lg=n(),N=a("div"),p(Do.$$.fragment),r_=n(),ti=a("p"),ti.innerHTML=EM,a_=n(),p(us.$$.fragment),l_=n(),p(hs.$$.fragment),c_=n(),si=a("div"),p(Po.$$.fragment),Fg=n(),pe=a("div"),p(Qo.$$.fragment),i_=n(),ni=a("p"),ni.innerHTML=HM,d_=n(),p(fs.$$.fragment),p_=n(),oi=a("div"),p(Yo.$$.fragment),Vg=n(),E=a("div"),p(Ao.$$.fragment),m_=n(),ri=a("p"),ri.innerHTML=qM,g_=n(),ai=a("p"),ai.innerHTML=DM,u_=n(),p(_s.$$.fragment),h_=n(),li=a("div"),p(Oo.$$.fragment),Gg=n(),H=a("div"),p(Ko.$$.fragment),f_=n(),ci=a("p"),ci.innerHTML=PM,__=n(),p(bs.$$.fragment),b_=n(),p(ys.$$.fragment),y_=n(),ii=a("div"),p(er.$$.fragment),Xg=n(),me=a("div"),p(tr.$$.fragment),T_=n(),di=a("p"),di.innerHTML=QM,M_=n(),p(Ts.$$.fragment),v_=n(),pi=a("div"),p(sr.$$.fragment),Rg=n(),ge=a("div"),p(nr.$$.fragment),w_=n(),mi=a("p"),mi.innerHTML=YM,k_=n(),p(Ms.$$.fragment),$_=n(),gi=a("div"),p(or.$$.fragment),Sg=n(),q=a("div"),p(rr.$$.fragment),j_=n(),ui=a("p"),ui.innerHTML=AM,x_=n(),p(vs.$$.fragment),J_=n(),p(ws.$$.fragment),U_=n(),hi=a("div"),p(ar.$$.fragment),Ng=n(),ue=a("div"),p(lr.$$.fragment),B_=n(),fi=a("p"),fi.innerHTML=OM,I_=n(),p(ks.$$.fragment),Z_=n(),_i=a("div"),p(cr.$$.fragment),Eg=n(),he=a("div"),p(ir.$$.fragment),z_=n(),bi=a("p"),bi.innerHTML=KM,W_=n(),p($s.$$.fragment),C_=n(),yi=a("div"),p(dr.$$.fragment),Hg=n(),D=a("div"),p(pr.$$.fragment),L_=n(),Ti=a("p"),Ti.innerHTML=ev,F_=n(),Mi=a("p"),Mi.innerHTML=tv,V_=n(),p(js.$$.fragment),G_=n(),vi=a("div"),p(mr.$$.fragment),qg=n(),P=a("div"),p(gr.$$.fragment),X_=n(),wi=a("p"),wi.innerHTML=sv,R_=n(),ki=a("p"),ki.innerHTML=nv,S_=n(),p(xs.$$.fragment),N_=n(),$i=a("div"),p(ur.$$.fragment),Dg=n(),Q=a("div"),p(hr.$$.fragment),E_=n(),ji=a("p"),ji.innerHTML=ov,H_=n(),xi=a("p"),xi.innerHTML=rv,q_=n(),p(Js.$$.fragment),D_=n(),Ji=a("div"),p(fr.$$.fragment),Pg=n(),p(_r.$$.fragment),Qg=n(),ze=a("div"),p(br.$$.fragment),P_=n(),Ui=a("p"),Ui.innerHTML=av,Q_=n(),Bi=a("div"),p(yr.$$.fragment),Yg=n(),We=a("div"),p(Tr.$$.fragment),Y_=n(),Ii=a("p"),Ii.innerHTML=lv,A_=n(),Zi=a("div"),p(Mr.$$.fragment),Ag=n(),Ce=a("div"),p(vr.$$.fragment),O_=n(),zi=a("p"),zi.innerHTML=cv,K_=n(),Wi=a("div"),p(wr.$$.fragment),Og=n(),Le=a("div"),p(kr.$$.fragment),eb=n(),Ci=a("p"),Ci.textContent=iv,tb=n(),Us=a("div"),p($r.$$.fragment),sb=n(),Li=a("p"),Li.textContent=dv,Kg=n(),Fe=a("div"),p(jr.$$.fragment),nb=n(),Fi=a("p"),Fi.innerHTML=pv,ob=n(),Vi=a("div"),p(xr.$$.fragment),eu=n(),Ve=a("div"),p(Jr.$$.fragment),rb=n(),Gi=a("p"),Gi.textContent=mv,ab=n(),Bs=a("div"),p(Ur.$$.fragment),lb=n(),Xi=a("p"),Xi.textContent=gv,tu=n(),Ge=a("div"),p(Br.$$.fragment),cb=n(),Ri=a("p"),Ri.innerHTML=uv,ib=n(),Si=a("div"),p(Ir.$$.fragment),su=n(),Xe=a("div"),p(Zr.$$.fragment),db=n(),Ni=a("p"),Ni.innerHTML=hv,pb=n(),Ei=a("div"),p(zr.$$.fragment),nu=n(),Re=a("div"),p(Wr.$$.fragment),mb=n(),Hi=a("p"),Hi.innerHTML=fv,gb=n(),qi=a("div"),p(Cr.$$.fragment),ou=n(),Se=a("div"),p(Lr.$$.fragment),ub=n(),Di=a("p"),Di.innerHTML=_v,hb=n(),Pi=a("div"),p(Fr.$$.fragment),ru=n(),Ne=a("div"),p(Vr.$$.fragment),fb=n(),Qi=a("p"),Qi.innerHTML=bv,_b=n(),Yi=a("div"),p(Gr.$$.fragment),au=n(),Ee=a("div"),p(Xr.$$.fragment),bb=n(),Ai=a("p"),Ai.innerHTML=yv,yb=n(),Oi=a("div"),p(Rr.$$.fragment),lu=n(),He=a("div"),p(Sr.$$.fragment),Tb=n(),Ki=a("p"),Ki.innerHTML=Tv,Mb=n(),ed=a("div"),p(Nr.$$.fragment),cu=n(),qe=a("div"),p(Er.$$.fragment),vb=n(),td=a("p"),td.innerHTML=Mv,wb=n(),sd=a("div"),p(Hr.$$.fragment),iu=n(),De=a("div"),p(qr.$$.fragment),kb=n(),nd=a("p"),nd.innerHTML=vv,$b=n(),od=a("div"),p(Dr.$$.fragment),du=n(),p(Pr.$$.fragment),pu=n(),Pe=a("div"),p(Qr.$$.fragment),jb=n(),rd=a("p"),rd.innerHTML=wv,xb=n(),ad=a("div"),p(Yr.$$.fragment),mu=n(),Qe=a("div"),p(Ar.$$.fragment),Jb=n(),ld=a("p"),ld.innerHTML=kv,Ub=n(),cd=a("div"),p(Or.$$.fragment),gu=n(),Ye=a("div"),p(Kr.$$.fragment),Bb=n(),id=a("p"),id.innerHTML=$v,Ib=n(),dd=a("div"),p(ea.$$.fragment),uu=n(),Ae=a("div"),p(ta.$$.fragment),Zb=n(),pd=a("p"),pd.textContent=jv,zb=n(),Is=a("div"),p(sa.$$.fragment),Wb=n(),md=a("p"),md.textContent=xv,hu=n(),Oe=a("div"),p(na.$$.fragment),Cb=n(),gd=a("p"),gd.innerHTML=Jv,Lb=n(),ud=a("div"),p(oa.$$.fragment),fu=n(),Ke=a("div"),p(ra.$$.fragment),Fb=n(),hd=a("p"),hd.textContent=Uv,Vb=n(),Zs=a("div"),p(aa.$$.fragment),Gb=n(),fd=a("p"),fd.textContent=Bv,_u=n(),et=a("div"),p(la.$$.fragment),Xb=n(),_d=a("p"),_d.innerHTML=Iv,Rb=n(),bd=a("div"),p(ca.$$.fragment),bu=n(),tt=a("div"),p(ia.$$.fragment),Sb=n(),yd=a("p"),yd.innerHTML=Zv,Nb=n(),Td=a("div"),p(da.$$.fragment),yu=n(),st=a("div"),p(pa.$$.fragment),Eb=n(),Md=a("p"),Md.innerHTML=zv,Hb=n(),vd=a("div"),p(ma.$$.fragment),Tu=n(),nt=a("div"),p(ga.$$.fragment),qb=n(),wd=a("p"),wd.innerHTML=Wv,Db=n(),kd=a("div"),p(ua.$$.fragment),Mu=n(),ot=a("div"),p(ha.$$.fragment),Pb=n(),$d=a("p"),$d.innerHTML=Cv,Qb=n(),jd=a("div"),p(fa.$$.fragment),vu=n(),rt=a("div"),p(_a.$$.fragment),Yb=n(),xd=a("p"),xd.innerHTML=Lv,Ab=n(),Jd=a("div"),p(ba.$$.fragment),wu=n(),at=a("div"),p(ya.$$.fragment),Ob=n(),Ud=a("p"),Ud.innerHTML=Fv,Kb=n(),Bd=a("div"),p(Ta.$$.fragment),ku=n(),p(Ma.$$.fragment),$u=n(),va=a("p"),va.innerHTML=Vv,ju=n(),fe=a("div"),p(wa.$$.fragment),ey=n(),Id=a("p"),Id.textContent=Gv,ty=n(),Zd=a("p"),Zd.innerHTML=Xv,sy=n(),zd=a("div"),p(ka.$$.fragment),xu=n(),St=a("div"),p($a.$$.fragment),ny=n(),Wd=a("div"),p(ja.$$.fragment),Ju=n(),lt=a("div"),p(xa.$$.fragment),oy=n(),Cd=a("p"),Cd.innerHTML=Rv,ry=n(),Ld=a("div"),p(Ja.$$.fragment),Uu=n(),ct=a("div"),p(Ua.$$.fragment),ay=n(),Fd=a("p"),Fd.innerHTML=Sv,ly=n(),Vd=a("div"),p(Ba.$$.fragment),Bu=n(),p(Ia.$$.fragment),Iu=n(),Za=a("p"),Za.innerHTML=Nv,Zu=n(),U=a("div"),p(za.$$.fragment),cy=n(),Gd=a("p"),Gd.textContent=Ev,iy=n(),Xd=a("p"),Xd.textContent=Hv,dy=n(),p(zs.$$.fragment),py=n(),Rd=a("p"),Rd.textContent=qv,my=n(),Ws=a("div"),p(Wa.$$.fragment),gy=n(),Sd=a("p"),Sd.textContent=Dv,uy=n(),Cs=a("div"),p(Ca.$$.fragment),hy=n(),Nd=a("p"),Nd.textContent=Pv,fy=n(),Ls=a("div"),p(La.$$.fragment),_y=n(),Ed=a("p"),Ed.textContent=Qv,by=n(),Fs=a("div"),p(Fa.$$.fragment),yy=n(),Hd=a("p"),Hd.innerHTML=Yv,Ty=n(),Vs=a("div"),p(Va.$$.fragment),My=n(),qd=a("p"),qd.textContent=Av,vy=n(),Gs=a("div"),p(Ga.$$.fragment),wy=n(),Dd=a("p"),Dd.textContent=Ov,ky=n(),bt=a("div"),p(Xa.$$.fragment),$y=n(),Pd=a("p"),Pd.innerHTML=Kv,jy=n(),Qd=a("p"),Qd.textContent=ew,zu=n(),Nt=a("div"),p(Ra.$$.fragment),xy=n(),Yd=a("p"),Yd.innerHTML=tw,Wu=n(),Et=a("div"),p(Sa.$$.fragment),Jy=n(),Ad=a("p"),Ad.innerHTML=sw,Cu=n(),_e=a("div"),p(Na.$$.fragment),Uy=n(),Od=a("p"),Od.textContent=nw,By=n(),V=a("div"),p(Ea.$$.fragment),Iy=n(),Kd=a("p"),Kd.textContent=ow,Zy=n(),ep=a("p"),ep.innerHTML=rw,zy=n(),tp=a("p"),tp.innerHTML=aw,Wy=n(),sp=a("p"),sp.innerHTML=lw,Cy=n(),np=a("p"),np.textContent=cw,Ly=n(),Xs=a("div"),p(Ha.$$.fragment),Fy=n(),op=a("p"),op.textContent=iw,Lu=n(),p(qa.$$.fragment),Fu=n(),be=a("div"),p(Da.$$.fragment),Vy=n(),rp=a("p"),rp.innerHTML=dw,Gy=n(),ap=a("div"),p(Pa.$$.fragment),Xy=n(),lp=a("div"),p(Qa.$$.fragment),Vu=n(),L=a("div"),p(Ya.$$.fragment),Ry=n(),cp=a("p"),cp.innerHTML=pw,Sy=n(),ip=a("p"),ip.innerHTML=mw,Ny=n(),dp=a("p"),dp.innerHTML=gw,Ey=n(),pp=a("div"),p(Aa.$$.fragment),Hy=n(),mp=a("div"),p(Oa.$$.fragment),Gu=n(),ye=a("div"),p(Ka.$$.fragment),qy=n(),gp=a("p"),gp.innerHTML=uw,Dy=n(),up=a("div"),p(el.$$.fragment),Py=n(),hp=a("div"),p(tl.$$.fragment),Xu=n(),p(sl.$$.fragment),Ru=n(),it=a("div"),p(nl.$$.fragment),Qy=n(),fp=a("p"),fp.textContent=hw,Yy=n(),_p=a("p"),_p.innerHTML=fw,Su=n(),dt=a("div"),p(ol.$$.fragment),Ay=n(),bp=a("p"),bp.textContent=_w,Oy=n(),yp=a("p"),yp.innerHTML=bw,Nu=n(),p(rl.$$.fragment),Eu=n(),z=a("div"),p(al.$$.fragment),Ky=n(),Tp=a("p"),Tp.textContent=yw,eT=n(),p(Rs.$$.fragment),tT=n(),p(Ss.$$.fragment),sT=n(),Ns=a("div"),p(ll.$$.fragment),nT=n(),Mp=a("p"),Mp.textContent=Tw,oT=n(),Es=a("div"),p(cl.$$.fragment),rT=n(),vp=a("p"),vp.textContent=Mw,aT=n(),Hs=a("div"),p(il.$$.fragment),lT=n(),wp=a("p"),wp.textContent=vw,Hu=n(),Y=a("div"),p(dl.$$.fragment),cT=n(),kp=a("p"),kp.textContent=ww,iT=n(),p(qs.$$.fragment),dT=n(),p(Ds.$$.fragment),pT=n(),Ps=a("div"),p(pl.$$.fragment),mT=n(),$p=a("p"),$p.textContent=kw,qu=n(),p(ml.$$.fragment),Du=n(),pt=a("div"),p(gl.$$.fragment),gT=n(),jp=a("p"),jp.textContent=$w,uT=n(),Qs=a("div"),p(ul.$$.fragment),hT=n(),xp=a("p"),xp.innerHTML=jw,Pu=n(),Z=a("div"),p(hl.$$.fragment),fT=n(),Jp=a("p"),Jp.textContent=xw,_T=n(),Up=a("p"),Up.innerHTML=Jw,bT=n(),Ys=a("div"),p(fl.$$.fragment),yT=n(),Bp=a("p"),Bp.innerHTML=Uw,TT=n(),As=a("div"),p(_l.$$.fragment),MT=n(),Ip=a("p"),Ip.textContent=Bw,vT=n(),Os=a("div"),p(bl.$$.fragment),wT=n(),Zp=a("p"),Zp.textContent=Iw,kT=n(),Ks=a("div"),p(yl.$$.fragment),$T=n(),zp=a("p"),zp.innerHTML=Zw,jT=n(),en=a("div"),p(Tl.$$.fragment),xT=n(),Wp=a("p"),Wp.innerHTML=zw,Qu=n(),F=a("div"),p(Ml.$$.fragment),JT=n(),Cp=a("p"),Cp.innerHTML=Ww,UT=n(),Lp=a("p"),Lp.innerHTML=Cw,BT=n(),tn=a("div"),p(vl.$$.fragment),IT=n(),Fp=a("p"),Fp.innerHTML=Lw,ZT=n(),sn=a("div"),p(wl.$$.fragment),zT=n(),Vp=a("p"),Vp.textContent=Fw,WT=n(),nn=a("div"),p(kl.$$.fragment),CT=n(),Gp=a("p"),Gp.textContent=Vw,Yu=n(),Te=a("div"),p($l.$$.fragment),LT=n(),Xp=a("p"),Xp.innerHTML=Gw,FT=n(),on=a("div"),p(jl.$$.fragment),VT=n(),Rp=a("p"),Rp.innerHTML=Xw,GT=n(),rn=a("div"),p(xl.$$.fragment),XT=n(),Sp=a("p"),Sp.innerHTML=Rw,Au=n(),jm=a("p"),this.h()},l(e){const c=Qk("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(s),$=o(e),b=l(e,"P",{}),T(b).forEach(s),_=o(e),m(w.$$.fragment,e),r=o(e),k=l(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-35f4mu"&&(k.innerHTML=RT),Cm=o(e),m(wn.$$.fragment,e),Lm=o(e),kn=l(e,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-1lre4o6"&&(kn.innerHTML=ST),Fm=o(e),$n=l(e,"P",{"data-svelte-h":!0}),y($n)!=="svelte-wwwyth"&&($n.textContent=NT),Vm=o(e),m(jn.$$.fragment,e),Gm=o(e),xn=l(e,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-1xs4157"&&(xn.innerHTML=ET),Xm=o(e),Jn=l(e,"UL",{"data-svelte-h":!0}),y(Jn)!=="svelte-1arpy9m"&&(Jn.innerHTML=HT),Rm=o(e),Un=l(e,"P",{"data-svelte-h":!0}),y(Un)!=="svelte-xh59rv"&&(Un.innerHTML=qT),Sm=o(e),Bn=l(e,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-rqavqw"&&(Bn.innerHTML=DT),Nm=o(e),In=l(e,"P",{"data-svelte-h":!0}),y(In)!=="svelte-qr02he"&&(In.innerHTML=PT),Em=o(e),m(Zn.$$.fragment,e),Hm=o(e),zn=l(e,"P",{"data-svelte-h":!0}),y(zn)!=="svelte-114v74y"&&(zn.innerHTML=QT),qm=o(e),Wn=l(e,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-13knclg"&&(Wn.innerHTML=YT),Dm=o(e),Cn=l(e,"P",{"data-svelte-h":!0}),y(Cn)!=="svelte-gz8gow"&&(Cn.textContent=AT),Pm=o(e),m(Ln.$$.fragment,e),Qm=o(e),Jt=l(e,"DIV",{class:!0});var Jl=T(Jt);m(Fn.$$.fragment,Jl),Jh=o(Jl),Hl=l(Jl,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-k7oes3"&&(Hl.textContent=OT),Jl.forEach(s),Ym=o(e),Ut=l(e,"DIV",{class:!0});var Ul=T(Ut);m(Vn.$$.fragment,Ul),Uh=o(Ul),ql=l(Ul,"P",{"data-svelte-h":!0}),y(ql)!=="svelte-111f3sj"&&(ql.textContent=KT),Ul.forEach(s),Am=o(e),Bt=l(e,"DIV",{class:!0});var Bl=T(Bt);m(Gn.$$.fragment,Bl),Bh=o(Bl),Dl=l(Bl,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-1j3b9cp"&&(Dl.textContent=eM),Bl.forEach(s),Om=o(e),It=l(e,"DIV",{class:!0});var Il=T(It);m(Xn.$$.fragment,Il),Ih=o(Il),Pl=l(Il,"P",{"data-svelte-h":!0}),y(Pl)!=="svelte-16r5px1"&&(Pl.textContent=tM),Il.forEach(s),Km=o(e),m(Rn.$$.fragment,e),eg=o(e),Zt=l(e,"DIV",{class:!0});var Zl=T(Zt);m(Sn.$$.fragment,Zl),Zh=o(Zl),Ql=l(Zl,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-1bnrp61"&&(Ql.textContent=sM),Zl.forEach(s),tg=o(e),zt=l(e,"DIV",{class:!0});var zl=T(zt);m(Nn.$$.fragment,zl),zh=o(zl),Yl=l(zl,"P",{"data-svelte-h":!0}),y(Yl)!=="svelte-fenhkk"&&(Yl.textContent=nM),zl.forEach(s),sg=o(e),Wt=l(e,"DIV",{class:!0});var Wl=T(Wt);m(En.$$.fragment,Wl),Wh=o(Wl),Al=l(Wl,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-1dqtgq4"&&(Al.textContent=oM),Wl.forEach(s),ng=o(e),Ct=l(e,"DIV",{class:!0});var Cl=T(Ct);m(Hn.$$.fragment,Cl),Ch=o(Cl),Ol=l(Cl,"P",{"data-svelte-h":!0}),y(Ol)!=="svelte-10orfv5"&&(Ol.textContent=rM),Cl.forEach(s),og=o(e),Lt=l(e,"DIV",{class:!0});var Ll=T(Lt);m(qn.$$.fragment,Ll),Lh=o(Ll),Kl=l(Ll,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-jg8udg"&&(Kl.textContent=aM),Ll.forEach(s),rg=o(e),Ft=l(e,"DIV",{class:!0});var Fl=T(Ft);m(Dn.$$.fragment,Fl),Fh=o(Fl),ec=l(Fl,"P",{"data-svelte-h":!0}),y(ec)!=="svelte-1i40667"&&(ec.textContent=lM),Fl.forEach(s),ag=o(e),Vt=l(e,"DIV",{class:!0});var Vl=T(Vt);m(Pn.$$.fragment,Vl),Vh=o(Vl),tc=l(Vl,"P",{"data-svelte-h":!0}),y(tc)!=="svelte-n5fi8x"&&(tc.textContent=cM),Vl.forEach(s),lg=o(e),Gt=l(e,"DIV",{class:!0});var Gl=T(Gt);m(Qn.$$.fragment,Gl),Gh=o(Gl),sc=l(Gl,"P",{"data-svelte-h":!0}),y(sc)!=="svelte-h5pj3l"&&(sc.textContent=iM),Gl.forEach(s),cg=o(e),Xt=l(e,"DIV",{class:!0});var Xl=T(Xt);m(Yn.$$.fragment,Xl),Xh=o(Xl),nc=l(Xl,"P",{"data-svelte-h":!0}),y(nc)!=="svelte-b9zq6n"&&(nc.textContent=dM),Xl.forEach(s),ig=o(e),Rt=l(e,"DIV",{class:!0});var Rl=T(Rt);m(An.$$.fragment,Rl),Rh=o(Rl),oc=l(Rl,"P",{"data-svelte-h":!0}),y(oc)!=="svelte-pru3ks"&&(oc.textContent=pM),Rl.forEach(s),dg=o(e),m(On.$$.fragment,e),pg=o(e),xe=l(e,"DIV",{class:!0});var Ht=T(xe);m(Kn.$$.fragment,Ht),Sh=o(Ht),rc=l(Ht,"P",{"data-svelte-h":!0}),y(rc)!=="svelte-qoov36"&&(rc.textContent=mM),Nh=o(Ht),Pt=l(Ht,"DIV",{class:!0});var Sl=T(Pt);m(eo.$$.fragment,Sl),Eh=o(Sl),ac=l(Sl,"P",{"data-svelte-h":!0}),y(ac)!=="svelte-5ihtpa"&&(ac.textContent=gM),Sl.forEach(s),Ht.forEach(s),mg=o(e),Je=l(e,"DIV",{class:!0});var qt=T(Je);m(to.$$.fragment,qt),Hh=o(qt),lc=l(qt,"P",{"data-svelte-h":!0}),y(lc)!=="svelte-1tz7qrd"&&(lc.textContent=uM),qh=o(qt),Qt=l(qt,"DIV",{class:!0});var Nl=T(Qt);m(so.$$.fragment,Nl),Dh=o(Nl),cc=l(Nl,"P",{"data-svelte-h":!0}),y(cc)!=="svelte-5ihtpa"&&(cc.textContent=hM),Nl.forEach(s),qt.forEach(s),gg=o(e),Ue=l(e,"DIV",{class:!0});var Dt=T(Ue);m(no.$$.fragment,Dt),Ph=o(Dt),ic=l(Dt,"P",{"data-svelte-h":!0}),y(ic)!=="svelte-1tz7qrd"&&(ic.textContent=fM),Qh=o(Dt),Yt=l(Dt,"DIV",{class:!0});var El=T(Yt);m(oo.$$.fragment,El),Yh=o(El),dc=l(El,"P",{"data-svelte-h":!0}),y(dc)!=="svelte-5ihtpa"&&(dc.textContent=_M),El.forEach(s),Dt.forEach(s),ug=o(e),m(ro.$$.fragment,e),hg=o(e),ao=l(e,"P",{"data-svelte-h":!0}),y(ao)!=="svelte-1mhr04t"&&(ao.innerHTML=bM),fg=o(e),m(lo.$$.fragment,e),_g=o(e),ee=l(e,"DIV",{class:!0});var mt=T(ee);m(co.$$.fragment,mt),Ah=o(mt),pc=l(mt,"P",{"data-svelte-h":!0}),y(pc)!=="svelte-r0ppk6"&&(pc.innerHTML=yM),Oh=o(mt),m(At.$$.fragment,mt),Kh=o(mt),mc=l(mt,"DIV",{class:!0});var xm=T(mc);m(io.$$.fragment,xm),xm.forEach(s),mt.forEach(s),bg=o(e),W=l(e,"DIV",{class:!0});var A=T(W);m(po.$$.fragment,A),ef=o(A),gc=l(A,"P",{"data-svelte-h":!0}),y(gc)!=="svelte-3t2r7l"&&(gc.innerHTML=TM),tf=o(A),uc=l(A,"P",{"data-svelte-h":!0}),y(uc)!=="svelte-lu7kru"&&(uc.innerHTML=MM),sf=o(A),m(Ot.$$.fragment,A),nf=o(A),m(Kt.$$.fragment,A),of=o(A),hc=l(A,"DIV",{class:!0});var Jm=T(hc);m(mo.$$.fragment,Jm),Jm.forEach(s),A.forEach(s),yg=o(e),X=l(e,"DIV",{class:!0});var Me=T(X);m(go.$$.fragment,Me),rf=o(Me),fc=l(Me,"P",{"data-svelte-h":!0}),y(fc)!=="svelte-jnv1x5"&&(fc.innerHTML=vM),af=o(Me),_c=l(Me,"P",{"data-svelte-h":!0}),y(_c)!=="svelte-mpy00q"&&(_c.textContent=wM),lf=o(Me),m(es.$$.fragment,Me),cf=o(Me),bc=l(Me,"DIV",{class:!0});var Um=T(bc);m(uo.$$.fragment,Um),Um.forEach(s),Me.forEach(s),Tg=o(e),R=l(e,"DIV",{class:!0});var ve=T(R);m(ho.$$.fragment,ve),df=o(ve),yc=l(ve,"P",{"data-svelte-h":!0}),y(yc)!=="svelte-hixi53"&&(yc.innerHTML=kM),pf=o(ve),Tc=l(ve,"P",{"data-svelte-h":!0}),y(Tc)!=="svelte-3qpgm7"&&(Tc.textContent=$M),mf=o(ve),m(ts.$$.fragment,ve),gf=o(ve),Mc=l(ve,"DIV",{class:!0});var Bm=T(Mc);m(fo.$$.fragment,Bm),Bm.forEach(s),ve.forEach(s),Mg=o(e),te=l(e,"DIV",{class:!0});var gt=T(te);m(_o.$$.fragment,gt),uf=o(gt),vc=l(gt,"P",{"data-svelte-h":!0}),y(vc)!=="svelte-axmqko"&&(vc.innerHTML=jM),hf=o(gt),m(ss.$$.fragment,gt),ff=o(gt),wc=l(gt,"DIV",{class:!0});var Im=T(wc);m(bo.$$.fragment,Im),Im.forEach(s),gt.forEach(s),vg=o(e),se=l(e,"DIV",{class:!0});var ut=T(se);m(yo.$$.fragment,ut),_f=o(ut),kc=l(ut,"P",{"data-svelte-h":!0}),y(kc)!=="svelte-nvfh7w"&&(kc.innerHTML=xM),bf=o(ut),m(ns.$$.fragment,ut),yf=o(ut),$c=l(ut,"DIV",{class:!0});var Zm=T($c);m(To.$$.fragment,Zm),Zm.forEach(s),ut.forEach(s),wg=o(e),ne=l(e,"DIV",{class:!0});var ht=T(ne);m(Mo.$$.fragment,ht),Tf=o(ht),jc=l(ht,"P",{"data-svelte-h":!0}),y(jc)!=="svelte-zac23"&&(jc.innerHTML=JM),Mf=o(ht),m(os.$$.fragment,ht),vf=o(ht),xc=l(ht,"DIV",{class:!0});var zm=T(xc);m(vo.$$.fragment,zm),zm.forEach(s),ht.forEach(s),kg=o(e),oe=l(e,"DIV",{class:!0});var ft=T(oe);m(wo.$$.fragment,ft),wf=o(ft),Jc=l(ft,"P",{"data-svelte-h":!0}),y(Jc)!=="svelte-1xemmef"&&(Jc.innerHTML=UM),kf=o(ft),m(rs.$$.fragment,ft),$f=o(ft),Uc=l(ft,"DIV",{class:!0});var Wm=T(Uc);m(ko.$$.fragment,Wm),Wm.forEach(s),ft.forEach(s),$g=o(e),re=l(e,"DIV",{class:!0});var _t=T(re);m($o.$$.fragment,_t),jf=o(_t),Bc=l(_t,"P",{"data-svelte-h":!0}),y(Bc)!=="svelte-1ideb0b"&&(Bc.innerHTML=BM),xf=o(_t),m(as.$$.fragment,_t),Jf=o(_t),Ic=l(_t,"DIV",{class:!0});var Sw=T(Ic);m(jo.$$.fragment,Sw),Sw.forEach(s),_t.forEach(s),jg=o(e),ae=l(e,"DIV",{class:!0});var an=T(ae);m(xo.$$.fragment,an),Uf=o(an),Zc=l(an,"P",{"data-svelte-h":!0}),y(Zc)!=="svelte-lpfxi8"&&(Zc.innerHTML=IM),Bf=o(an),m(ls.$$.fragment,an),If=o(an),zc=l(an,"DIV",{class:!0});var Nw=T(zc);m(Jo.$$.fragment,Nw),Nw.forEach(s),an.forEach(s),xg=o(e),C=l(e,"DIV",{class:!0});var we=T(C);m(Uo.$$.fragment,we),Zf=o(we),Wc=l(we,"P",{"data-svelte-h":!0}),y(Wc)!=="svelte-gr8gnh"&&(Wc.innerHTML=ZM),zf=o(we),Cc=l(we,"P",{"data-svelte-h":!0}),y(Cc)!=="svelte-wp24j3"&&(Cc.innerHTML=zM),Wf=o(we),Lc=l(we,"P",{"data-svelte-h":!0}),y(Lc)!=="svelte-2fpu88"&&(Lc.innerHTML=WM),Cf=o(we),m(cs.$$.fragment,we),Lf=o(we),Fc=l(we,"DIV",{class:!0});var Ew=T(Fc);m(Bo.$$.fragment,Ew),Ew.forEach(s),we.forEach(s),Jg=o(e),le=l(e,"DIV",{class:!0});var ln=T(le);m(Io.$$.fragment,ln),Ff=o(ln),Vc=l(ln,"P",{"data-svelte-h":!0}),y(Vc)!=="svelte-19509do"&&(Vc.innerHTML=CM),Vf=o(ln),Gc=l(ln,"P",{"data-svelte-h":!0}),y(Gc)!=="svelte-1v3r596"&&(Gc.innerHTML=LM),Gf=o(ln),Xc=l(ln,"DIV",{class:!0});var Hw=T(Xc);m(Zo.$$.fragment,Hw),Hw.forEach(s),ln.forEach(s),Ug=o(e),ce=l(e,"DIV",{class:!0});var cn=T(ce);m(zo.$$.fragment,cn),Xf=o(cn),Rc=l(cn,"P",{"data-svelte-h":!0}),y(Rc)!=="svelte-3ldoeh"&&(Rc.innerHTML=FM),Rf=o(cn),m(is.$$.fragment,cn),Sf=o(cn),Sc=l(cn,"DIV",{class:!0});var qw=T(Sc);m(Wo.$$.fragment,qw),qw.forEach(s),cn.forEach(s),Bg=o(e),Be=l(e,"DIV",{class:!0});var Np=T(Be);m(Co.$$.fragment,Np),Nf=o(Np),Nc=l(Np,"P",{"data-svelte-h":!0}),y(Nc)!=="svelte-y1kta5"&&(Nc.textContent=VM),Ef=o(Np),Ec=l(Np,"DIV",{class:!0});var Dw=T(Ec);m(Lo.$$.fragment,Dw),Dw.forEach(s),Np.forEach(s),Ig=o(e),Ie=l(e,"DIV",{class:!0});var Ep=T(Ie);m(Fo.$$.fragment,Ep),Hf=o(Ep),Hc=l(Ep,"P",{"data-svelte-h":!0}),y(Hc)!=="svelte-hiao6z"&&(Hc.innerHTML=GM),qf=o(Ep),qc=l(Ep,"DIV",{class:!0});var Pw=T(qc);m(Vo.$$.fragment,Pw),Pw.forEach(s),Ep.forEach(s),Zg=o(e),Ze=l(e,"DIV",{class:!0});var Hp=T(Ze);m(Go.$$.fragment,Hp),Df=o(Hp),Dc=l(Hp,"P",{"data-svelte-h":!0}),y(Dc)!=="svelte-th82mu"&&(Dc.textContent=XM),Pf=o(Hp),Pc=l(Hp,"DIV",{class:!0});var Qw=T(Pc);m(Xo.$$.fragment,Qw),Qw.forEach(s),Hp.forEach(s),zg=o(e),ie=l(e,"DIV",{class:!0});var dn=T(ie);m(Ro.$$.fragment,dn),Qf=o(dn),Qc=l(dn,"P",{"data-svelte-h":!0}),y(Qc)!=="svelte-1qtsa3r"&&(Qc.innerHTML=RM),Yf=o(dn),m(ds.$$.fragment,dn),Af=o(dn),Yc=l(dn,"DIV",{class:!0});var Yw=T(Yc);m(So.$$.fragment,Yw),Yw.forEach(s),dn.forEach(s),Wg=o(e),de=l(e,"DIV",{class:!0});var pn=T(de);m(No.$$.fragment,pn),Of=o(pn),Ac=l(pn,"P",{"data-svelte-h":!0}),y(Ac)!=="svelte-1xxt5g1"&&(Ac.innerHTML=SM),Kf=o(pn),m(ps.$$.fragment,pn),e_=o(pn),Oc=l(pn,"DIV",{class:!0});var Aw=T(Oc);m(Eo.$$.fragment,Aw),Aw.forEach(s),pn.forEach(s),Cg=o(e),S=l(e,"DIV",{class:!0});var yt=T(S);m(Ho.$$.fragment,yt),t_=o(yt),Kc=l(yt,"P",{"data-svelte-h":!0}),y(Kc)!=="svelte-1j8exuv"&&(Kc.innerHTML=NM),s_=o(yt),m(ms.$$.fragment,yt),n_=o(yt),m(gs.$$.fragment,yt),o_=o(yt),ei=l(yt,"DIV",{class:!0});var Ow=T(ei);m(qo.$$.fragment,Ow),Ow.forEach(s),yt.forEach(s),Lg=o(e),N=l(e,"DIV",{class:!0});var Tt=T(N);m(Do.$$.fragment,Tt),r_=o(Tt),ti=l(Tt,"P",{"data-svelte-h":!0}),y(ti)!=="svelte-1oiukny"&&(ti.innerHTML=EM),a_=o(Tt),m(us.$$.fragment,Tt),l_=o(Tt),m(hs.$$.fragment,Tt),c_=o(Tt),si=l(Tt,"DIV",{class:!0});var Kw=T(si);m(Po.$$.fragment,Kw),Kw.forEach(s),Tt.forEach(s),Fg=o(e),pe=l(e,"DIV",{class:!0});var mn=T(pe);m(Qo.$$.fragment,mn),i_=o(mn),ni=l(mn,"P",{"data-svelte-h":!0}),y(ni)!=="svelte-8lc5bj"&&(ni.innerHTML=HM),d_=o(mn),m(fs.$$.fragment,mn),p_=o(mn),oi=l(mn,"DIV",{class:!0});var ek=T(oi);m(Yo.$$.fragment,ek),ek.forEach(s),mn.forEach(s),Vg=o(e),E=l(e,"DIV",{class:!0});var Mt=T(E);m(Ao.$$.fragment,Mt),m_=o(Mt),ri=l(Mt,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-1dx7orz"&&(ri.innerHTML=qM),g_=o(Mt),ai=l(Mt,"P",{"data-svelte-h":!0}),y(ai)!=="svelte-qhda5i"&&(ai.innerHTML=DM),u_=o(Mt),m(_s.$$.fragment,Mt),h_=o(Mt),li=l(Mt,"DIV",{class:!0});var tk=T(li);m(Oo.$$.fragment,tk),tk.forEach(s),Mt.forEach(s),Gg=o(e),H=l(e,"DIV",{class:!0});var vt=T(H);m(Ko.$$.fragment,vt),f_=o(vt),ci=l(vt,"P",{"data-svelte-h":!0}),y(ci)!=="svelte-wdblk4"&&(ci.innerHTML=PM),__=o(vt),m(bs.$$.fragment,vt),b_=o(vt),m(ys.$$.fragment,vt),y_=o(vt),ii=l(vt,"DIV",{class:!0});var sk=T(ii);m(er.$$.fragment,sk),sk.forEach(s),vt.forEach(s),Xg=o(e),me=l(e,"DIV",{class:!0});var gn=T(me);m(tr.$$.fragment,gn),T_=o(gn),di=l(gn,"P",{"data-svelte-h":!0}),y(di)!=="svelte-sekyuo"&&(di.innerHTML=QM),M_=o(gn),m(Ts.$$.fragment,gn),v_=o(gn),pi=l(gn,"DIV",{class:!0});var nk=T(pi);m(sr.$$.fragment,nk),nk.forEach(s),gn.forEach(s),Rg=o(e),ge=l(e,"DIV",{class:!0});var un=T(ge);m(nr.$$.fragment,un),w_=o(un),mi=l(un,"P",{"data-svelte-h":!0}),y(mi)!=="svelte-kp6ubc"&&(mi.innerHTML=YM),k_=o(un),m(Ms.$$.fragment,un),$_=o(un),gi=l(un,"DIV",{class:!0});var ok=T(gi);m(or.$$.fragment,ok),ok.forEach(s),un.forEach(s),Sg=o(e),q=l(e,"DIV",{class:!0});var wt=T(q);m(rr.$$.fragment,wt),j_=o(wt),ui=l(wt,"P",{"data-svelte-h":!0}),y(ui)!=="svelte-7ahm2v"&&(ui.innerHTML=AM),x_=o(wt),m(vs.$$.fragment,wt),J_=o(wt),m(ws.$$.fragment,wt),U_=o(wt),hi=l(wt,"DIV",{class:!0});var rk=T(hi);m(ar.$$.fragment,rk),rk.forEach(s),wt.forEach(s),Ng=o(e),ue=l(e,"DIV",{class:!0});var hn=T(ue);m(lr.$$.fragment,hn),B_=o(hn),fi=l(hn,"P",{"data-svelte-h":!0}),y(fi)!=="svelte-117uvp5"&&(fi.innerHTML=OM),I_=o(hn),m(ks.$$.fragment,hn),Z_=o(hn),_i=l(hn,"DIV",{class:!0});var ak=T(_i);m(cr.$$.fragment,ak),ak.forEach(s),hn.forEach(s),Eg=o(e),he=l(e,"DIV",{class:!0});var fn=T(he);m(ir.$$.fragment,fn),z_=o(fn),bi=l(fn,"P",{"data-svelte-h":!0}),y(bi)!=="svelte-msk345"&&(bi.innerHTML=KM),W_=o(fn),m($s.$$.fragment,fn),C_=o(fn),yi=l(fn,"DIV",{class:!0});var lk=T(yi);m(dr.$$.fragment,lk),lk.forEach(s),fn.forEach(s),Hg=o(e),D=l(e,"DIV",{class:!0});var kt=T(D);m(pr.$$.fragment,kt),L_=o(kt),Ti=l(kt,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-179g7r6"&&(Ti.innerHTML=ev),F_=o(kt),Mi=l(kt,"P",{"data-svelte-h":!0}),y(Mi)!=="svelte-1qmimno"&&(Mi.innerHTML=tv),V_=o(kt),m(js.$$.fragment,kt),G_=o(kt),vi=l(kt,"DIV",{class:!0});var ck=T(vi);m(mr.$$.fragment,ck),ck.forEach(s),kt.forEach(s),qg=o(e),P=l(e,"DIV",{class:!0});var $t=T(P);m(gr.$$.fragment,$t),X_=o($t),wi=l($t,"P",{"data-svelte-h":!0}),y(wi)!=="svelte-1dewsn6"&&(wi.innerHTML=sv),R_=o($t),ki=l($t,"P",{"data-svelte-h":!0}),y(ki)!=="svelte-5qs7tv"&&(ki.innerHTML=nv),S_=o($t),m(xs.$$.fragment,$t),N_=o($t),$i=l($t,"DIV",{class:!0});var ik=T($i);m(ur.$$.fragment,ik),ik.forEach(s),$t.forEach(s),Dg=o(e),Q=l(e,"DIV",{class:!0});var jt=T(Q);m(hr.$$.fragment,jt),E_=o(jt),ji=l(jt,"P",{"data-svelte-h":!0}),y(ji)!=="svelte-laa6zp"&&(ji.innerHTML=ov),H_=o(jt),xi=l(jt,"P",{"data-svelte-h":!0}),y(xi)!=="svelte-qmmn5t"&&(xi.innerHTML=rv),q_=o(jt),m(Js.$$.fragment,jt),D_=o(jt),Ji=l(jt,"DIV",{class:!0});var dk=T(Ji);m(fr.$$.fragment,dk),dk.forEach(s),jt.forEach(s),Pg=o(e),m(_r.$$.fragment,e),Qg=o(e),ze=l(e,"DIV",{class:!0});var qp=T(ze);m(br.$$.fragment,qp),P_=o(qp),Ui=l(qp,"P",{"data-svelte-h":!0}),y(Ui)!=="svelte-1r9g8lr"&&(Ui.innerHTML=av),Q_=o(qp),Bi=l(qp,"DIV",{class:!0});var pk=T(Bi);m(yr.$$.fragment,pk),pk.forEach(s),qp.forEach(s),Yg=o(e),We=l(e,"DIV",{class:!0});var Dp=T(We);m(Tr.$$.fragment,Dp),Y_=o(Dp),Ii=l(Dp,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-1o8otjv"&&(Ii.innerHTML=lv),A_=o(Dp),Zi=l(Dp,"DIV",{class:!0});var mk=T(Zi);m(Mr.$$.fragment,mk),mk.forEach(s),Dp.forEach(s),Ag=o(e),Ce=l(e,"DIV",{class:!0});var Pp=T(Ce);m(vr.$$.fragment,Pp),O_=o(Pp),zi=l(Pp,"P",{"data-svelte-h":!0}),y(zi)!=="svelte-1557waw"&&(zi.innerHTML=cv),K_=o(Pp),Wi=l(Pp,"DIV",{class:!0});var gk=T(Wi);m(wr.$$.fragment,gk),gk.forEach(s),Pp.forEach(s),Og=o(e),Le=l(e,"DIV",{class:!0});var Qp=T(Le);m(kr.$$.fragment,Qp),eb=o(Qp),Ci=l(Qp,"P",{"data-svelte-h":!0}),y(Ci)!=="svelte-y1kta5"&&(Ci.textContent=iv),tb=o(Qp),Us=l(Qp,"DIV",{class:!0});var Ku=T(Us);m($r.$$.fragment,Ku),sb=o(Ku),Li=l(Ku,"P",{"data-svelte-h":!0}),y(Li)!=="svelte-5aspnb"&&(Li.textContent=dv),Ku.forEach(s),Qp.forEach(s),Kg=o(e),Fe=l(e,"DIV",{class:!0});var Yp=T(Fe);m(jr.$$.fragment,Yp),nb=o(Yp),Fi=l(Yp,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-wv649x"&&(Fi.innerHTML=pv),ob=o(Yp),Vi=l(Yp,"DIV",{class:!0});var uk=T(Vi);m(xr.$$.fragment,uk),uk.forEach(s),Yp.forEach(s),eu=o(e),Ve=l(e,"DIV",{class:!0});var Ap=T(Ve);m(Jr.$$.fragment,Ap),rb=o(Ap),Gi=l(Ap,"P",{"data-svelte-h":!0}),y(Gi)!=="svelte-th82mu"&&(Gi.textContent=mv),ab=o(Ap),Bs=l(Ap,"DIV",{class:!0});var eh=T(Bs);m(Ur.$$.fragment,eh),lb=o(eh),Xi=l(eh,"P",{"data-svelte-h":!0}),y(Xi)!=="svelte-hcoglc"&&(Xi.textContent=gv),eh.forEach(s),Ap.forEach(s),tu=o(e),Ge=l(e,"DIV",{class:!0});var Op=T(Ge);m(Br.$$.fragment,Op),cb=o(Op),Ri=l(Op,"P",{"data-svelte-h":!0}),y(Ri)!=="svelte-d6heh3"&&(Ri.innerHTML=uv),ib=o(Op),Si=l(Op,"DIV",{class:!0});var hk=T(Si);m(Ir.$$.fragment,hk),hk.forEach(s),Op.forEach(s),su=o(e),Xe=l(e,"DIV",{class:!0});var Kp=T(Xe);m(Zr.$$.fragment,Kp),db=o(Kp),Ni=l(Kp,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-gt0dvy"&&(Ni.innerHTML=hv),pb=o(Kp),Ei=l(Kp,"DIV",{class:!0});var fk=T(Ei);m(zr.$$.fragment,fk),fk.forEach(s),Kp.forEach(s),nu=o(e),Re=l(e,"DIV",{class:!0});var em=T(Re);m(Wr.$$.fragment,em),mb=o(em),Hi=l(em,"P",{"data-svelte-h":!0}),y(Hi)!=="svelte-e8ez2m"&&(Hi.innerHTML=fv),gb=o(em),qi=l(em,"DIV",{class:!0});var _k=T(qi);m(Cr.$$.fragment,_k),_k.forEach(s),em.forEach(s),ou=o(e),Se=l(e,"DIV",{class:!0});var tm=T(Se);m(Lr.$$.fragment,tm),ub=o(tm),Di=l(tm,"P",{"data-svelte-h":!0}),y(Di)!=="svelte-1sr1lwj"&&(Di.innerHTML=_v),hb=o(tm),Pi=l(tm,"DIV",{class:!0});var bk=T(Pi);m(Fr.$$.fragment,bk),bk.forEach(s),tm.forEach(s),ru=o(e),Ne=l(e,"DIV",{class:!0});var sm=T(Ne);m(Vr.$$.fragment,sm),fb=o(sm),Qi=l(sm,"P",{"data-svelte-h":!0}),y(Qi)!=="svelte-16ddbx0"&&(Qi.innerHTML=bv),_b=o(sm),Yi=l(sm,"DIV",{class:!0});var yk=T(Yi);m(Gr.$$.fragment,yk),yk.forEach(s),sm.forEach(s),au=o(e),Ee=l(e,"DIV",{class:!0});var nm=T(Ee);m(Xr.$$.fragment,nm),bb=o(nm),Ai=l(nm,"P",{"data-svelte-h":!0}),y(Ai)!=="svelte-a554sd"&&(Ai.innerHTML=yv),yb=o(nm),Oi=l(nm,"DIV",{class:!0});var Tk=T(Oi);m(Rr.$$.fragment,Tk),Tk.forEach(s),nm.forEach(s),lu=o(e),He=l(e,"DIV",{class:!0});var om=T(He);m(Sr.$$.fragment,om),Tb=o(om),Ki=l(om,"P",{"data-svelte-h":!0}),y(Ki)!=="svelte-m0ovbw"&&(Ki.innerHTML=Tv),Mb=o(om),ed=l(om,"DIV",{class:!0});var Mk=T(ed);m(Nr.$$.fragment,Mk),Mk.forEach(s),om.forEach(s),cu=o(e),qe=l(e,"DIV",{class:!0});var rm=T(qe);m(Er.$$.fragment,rm),vb=o(rm),td=l(rm,"P",{"data-svelte-h":!0}),y(td)!=="svelte-v0j3k9"&&(td.innerHTML=Mv),wb=o(rm),sd=l(rm,"DIV",{class:!0});var vk=T(sd);m(Hr.$$.fragment,vk),vk.forEach(s),rm.forEach(s),iu=o(e),De=l(e,"DIV",{class:!0});var am=T(De);m(qr.$$.fragment,am),kb=o(am),nd=l(am,"P",{"data-svelte-h":!0}),y(nd)!=="svelte-1kdstb"&&(nd.innerHTML=vv),$b=o(am),od=l(am,"DIV",{class:!0});var wk=T(od);m(Dr.$$.fragment,wk),wk.forEach(s),am.forEach(s),du=o(e),m(Pr.$$.fragment,e),pu=o(e),Pe=l(e,"DIV",{class:!0});var lm=T(Pe);m(Qr.$$.fragment,lm),jb=o(lm),rd=l(lm,"P",{"data-svelte-h":!0}),y(rd)!=="svelte-115xumf"&&(rd.innerHTML=wv),xb=o(lm),ad=l(lm,"DIV",{class:!0});var kk=T(ad);m(Yr.$$.fragment,kk),kk.forEach(s),lm.forEach(s),mu=o(e),Qe=l(e,"DIV",{class:!0});var cm=T(Qe);m(Ar.$$.fragment,cm),Jb=o(cm),ld=l(cm,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-nirf9f"&&(ld.innerHTML=kv),Ub=o(cm),cd=l(cm,"DIV",{class:!0});var $k=T(cd);m(Or.$$.fragment,$k),$k.forEach(s),cm.forEach(s),gu=o(e),Ye=l(e,"DIV",{class:!0});var im=T(Ye);m(Kr.$$.fragment,im),Bb=o(im),id=l(im,"P",{"data-svelte-h":!0}),y(id)!=="svelte-klyckq"&&(id.innerHTML=$v),Ib=o(im),dd=l(im,"DIV",{class:!0});var jk=T(dd);m(ea.$$.fragment,jk),jk.forEach(s),im.forEach(s),uu=o(e),Ae=l(e,"DIV",{class:!0});var dm=T(Ae);m(ta.$$.fragment,dm),Zb=o(dm),pd=l(dm,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-y1kta5"&&(pd.textContent=jv),zb=o(dm),Is=l(dm,"DIV",{class:!0});var th=T(Is);m(sa.$$.fragment,th),Wb=o(th),md=l(th,"P",{"data-svelte-h":!0}),y(md)!=="svelte-1l17mwc"&&(md.textContent=xv),th.forEach(s),dm.forEach(s),hu=o(e),Oe=l(e,"DIV",{class:!0});var pm=T(Oe);m(na.$$.fragment,pm),Cb=o(pm),gd=l(pm,"P",{"data-svelte-h":!0}),y(gd)!=="svelte-8dgktv"&&(gd.innerHTML=Jv),Lb=o(pm),ud=l(pm,"DIV",{class:!0});var xk=T(ud);m(oa.$$.fragment,xk),xk.forEach(s),pm.forEach(s),fu=o(e),Ke=l(e,"DIV",{class:!0});var mm=T(Ke);m(ra.$$.fragment,mm),Fb=o(mm),hd=l(mm,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-th82mu"&&(hd.textContent=Uv),Vb=o(mm),Zs=l(mm,"DIV",{class:!0});var sh=T(Zs);m(aa.$$.fragment,sh),Gb=o(sh),fd=l(sh,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-1tcb5cf"&&(fd.textContent=Bv),sh.forEach(s),mm.forEach(s),_u=o(e),et=l(e,"DIV",{class:!0});var gm=T(et);m(la.$$.fragment,gm),Xb=o(gm),_d=l(gm,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-18yq2lb"&&(_d.innerHTML=Iv),Rb=o(gm),bd=l(gm,"DIV",{class:!0});var Jk=T(bd);m(ca.$$.fragment,Jk),Jk.forEach(s),gm.forEach(s),bu=o(e),tt=l(e,"DIV",{class:!0});var um=T(tt);m(ia.$$.fragment,um),Sb=o(um),yd=l(um,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-rwiser"&&(yd.innerHTML=Zv),Nb=o(um),Td=l(um,"DIV",{class:!0});var Uk=T(Td);m(da.$$.fragment,Uk),Uk.forEach(s),um.forEach(s),yu=o(e),st=l(e,"DIV",{class:!0});var hm=T(st);m(pa.$$.fragment,hm),Eb=o(hm),Md=l(hm,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-vt3rxp"&&(Md.innerHTML=zv),Hb=o(hm),vd=l(hm,"DIV",{class:!0});var Bk=T(vd);m(ma.$$.fragment,Bk),Bk.forEach(s),hm.forEach(s),Tu=o(e),nt=l(e,"DIV",{class:!0});var fm=T(nt);m(ga.$$.fragment,fm),qb=o(fm),wd=l(fm,"P",{"data-svelte-h":!0}),y(wd)!=="svelte-15abw8y"&&(wd.innerHTML=Wv),Db=o(fm),kd=l(fm,"DIV",{class:!0});var Ik=T(kd);m(ua.$$.fragment,Ik),Ik.forEach(s),fm.forEach(s),Mu=o(e),ot=l(e,"DIV",{class:!0});var _m=T(ot);m(ha.$$.fragment,_m),Pb=o(_m),$d=l(_m,"P",{"data-svelte-h":!0}),y($d)!=="svelte-1oo0biz"&&($d.innerHTML=Cv),Qb=o(_m),jd=l(_m,"DIV",{class:!0});var Zk=T(jd);m(fa.$$.fragment,Zk),Zk.forEach(s),_m.forEach(s),vu=o(e),rt=l(e,"DIV",{class:!0});var bm=T(rt);m(_a.$$.fragment,bm),Yb=o(bm),xd=l(bm,"P",{"data-svelte-h":!0}),y(xd)!=="svelte-1j5ogr1"&&(xd.innerHTML=Lv),Ab=o(bm),Jd=l(bm,"DIV",{class:!0});var zk=T(Jd);m(ba.$$.fragment,zk),zk.forEach(s),bm.forEach(s),wu=o(e),at=l(e,"DIV",{class:!0});var ym=T(at);m(ya.$$.fragment,ym),Ob=o(ym),Ud=l(ym,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-1sygpwz"&&(Ud.innerHTML=Fv),Kb=o(ym),Bd=l(ym,"DIV",{class:!0});var Wk=T(Bd);m(Ta.$$.fragment,Wk),Wk.forEach(s),ym.forEach(s),ku=o(e),m(Ma.$$.fragment,e),$u=o(e),va=l(e,"P",{"data-svelte-h":!0}),y(va)!=="svelte-vfaqvb"&&(va.innerHTML=Vv),ju=o(e),fe=l(e,"DIV",{class:!0});var _n=T(fe);m(wa.$$.fragment,_n),ey=o(_n),Id=l(_n,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-rfvu1k"&&(Id.textContent=Gv),ty=o(_n),Zd=l(_n,"P",{"data-svelte-h":!0}),y(Zd)!=="svelte-e1lytz"&&(Zd.innerHTML=Xv),sy=o(_n),zd=l(_n,"DIV",{class:!0});var Ck=T(zd);m(ka.$$.fragment,Ck),Ck.forEach(s),_n.forEach(s),xu=o(e),St=l(e,"DIV",{class:!0});var nh=T(St);m($a.$$.fragment,nh),ny=o(nh),Wd=l(nh,"DIV",{class:!0});var Lk=T(Wd);m(ja.$$.fragment,Lk),Lk.forEach(s),nh.forEach(s),Ju=o(e),lt=l(e,"DIV",{class:!0});var Tm=T(lt);m(xa.$$.fragment,Tm),oy=o(Tm),Cd=l(Tm,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-4hfu96"&&(Cd.innerHTML=Rv),ry=o(Tm),Ld=l(Tm,"DIV",{class:!0});var Fk=T(Ld);m(Ja.$$.fragment,Fk),Fk.forEach(s),Tm.forEach(s),Uu=o(e),ct=l(e,"DIV",{class:!0});var Mm=T(ct);m(Ua.$$.fragment,Mm),ay=o(Mm),Fd=l(Mm,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-q5v59n"&&(Fd.innerHTML=Sv),ly=o(Mm),Vd=l(Mm,"DIV",{class:!0});var Vk=T(Vd);m(Ba.$$.fragment,Vk),Vk.forEach(s),Mm.forEach(s),Bu=o(e),m(Ia.$$.fragment,e),Iu=o(e),Za=l(e,"P",{"data-svelte-h":!0}),y(Za)!=="svelte-1fq8mcp"&&(Za.innerHTML=Nv),Zu=o(e),U=l(e,"DIV",{class:!0});var I=T(U);m(za.$$.fragment,I),cy=o(I),Gd=l(I,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-1kh5y5v"&&(Gd.textContent=Ev),iy=o(I),Xd=l(I,"P",{"data-svelte-h":!0}),y(Xd)!=="svelte-1ygkifj"&&(Xd.textContent=Hv),dy=o(I),m(zs.$$.fragment,I),py=o(I),Rd=l(I,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-7kbd1a"&&(Rd.textContent=qv),my=o(I),Ws=l(I,"DIV",{class:!0});var oh=T(Ws);m(Wa.$$.fragment,oh),gy=o(oh),Sd=l(oh,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-691079"&&(Sd.textContent=Dv),oh.forEach(s),uy=o(I),Cs=l(I,"DIV",{class:!0});var rh=T(Cs);m(Ca.$$.fragment,rh),hy=o(rh),Nd=l(rh,"P",{"data-svelte-h":!0}),y(Nd)!=="svelte-dtkk01"&&(Nd.textContent=Pv),rh.forEach(s),fy=o(I),Ls=l(I,"DIV",{class:!0});var ah=T(Ls);m(La.$$.fragment,ah),_y=o(ah),Ed=l(ah,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-11pa7k0"&&(Ed.textContent=Qv),ah.forEach(s),by=o(I),Fs=l(I,"DIV",{class:!0});var lh=T(Fs);m(Fa.$$.fragment,lh),yy=o(lh),Hd=l(lh,"P",{"data-svelte-h":!0}),y(Hd)!=="svelte-57vcuk"&&(Hd.innerHTML=Yv),lh.forEach(s),Ty=o(I),Vs=l(I,"DIV",{class:!0});var ch=T(Vs);m(Va.$$.fragment,ch),My=o(ch),qd=l(ch,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-e342dt"&&(qd.textContent=Av),ch.forEach(s),vy=o(I),Gs=l(I,"DIV",{class:!0});var ih=T(Gs);m(Ga.$$.fragment,ih),wy=o(ih),Dd=l(ih,"P",{"data-svelte-h":!0}),y(Dd)!=="svelte-vbd5xj"&&(Dd.textContent=Ov),ih.forEach(s),ky=o(I),bt=l(I,"DIV",{class:!0});var vm=T(bt);m(Xa.$$.fragment,vm),$y=o(vm),Pd=l(vm,"P",{"data-svelte-h":!0}),y(Pd)!=="svelte-1c2dshy"&&(Pd.innerHTML=Kv),jy=o(vm),Qd=l(vm,"P",{"data-svelte-h":!0}),y(Qd)!=="svelte-1qvu1un"&&(Qd.textContent=ew),vm.forEach(s),I.forEach(s),zu=o(e),Nt=l(e,"DIV",{class:!0});var dh=T(Nt);m(Ra.$$.fragment,dh),xy=o(dh),Yd=l(dh,"P",{"data-svelte-h":!0}),y(Yd)!=="svelte-1rymat9"&&(Yd.innerHTML=tw),dh.forEach(s),Wu=o(e),Et=l(e,"DIV",{class:!0});var ph=T(Et);m(Sa.$$.fragment,ph),Jy=o(ph),Ad=l(ph,"P",{"data-svelte-h":!0}),y(Ad)!=="svelte-1obuarm"&&(Ad.innerHTML=sw),ph.forEach(s),Cu=o(e),_e=l(e,"DIV",{class:!0});var bn=T(_e);m(Na.$$.fragment,bn),Uy=o(bn),Od=l(bn,"P",{"data-svelte-h":!0}),y(Od)!=="svelte-rxlesw"&&(Od.textContent=nw),By=o(bn),V=l(bn,"DIV",{class:!0});var ke=T(V);m(Ea.$$.fragment,ke),Iy=o(ke),Kd=l(ke,"P",{"data-svelte-h":!0}),y(Kd)!=="svelte-15hhlou"&&(Kd.textContent=ow),Zy=o(ke),ep=l(ke,"P",{"data-svelte-h":!0}),y(ep)!=="svelte-x0d0uq"&&(ep.innerHTML=rw),zy=o(ke),tp=l(ke,"P",{"data-svelte-h":!0}),y(tp)!=="svelte-1w36vm3"&&(tp.innerHTML=aw),Wy=o(ke),sp=l(ke,"P",{"data-svelte-h":!0}),y(sp)!=="svelte-1niq0qw"&&(sp.innerHTML=lw),Cy=o(ke),np=l(ke,"P",{"data-svelte-h":!0}),y(np)!=="svelte-af4g6f"&&(np.textContent=cw),ke.forEach(s),Ly=o(bn),Xs=l(bn,"DIV",{class:!0});var mh=T(Xs);m(Ha.$$.fragment,mh),Fy=o(mh),op=l(mh,"P",{"data-svelte-h":!0}),y(op)!=="svelte-eab6jp"&&(op.textContent=iw),mh.forEach(s),bn.forEach(s),Lu=o(e),m(qa.$$.fragment,e),Fu=o(e),be=l(e,"DIV",{class:!0});var yn=T(be);m(Da.$$.fragment,yn),Vy=o(yn),rp=l(yn,"P",{"data-svelte-h":!0}),y(rp)!=="svelte-1ey02pr"&&(rp.innerHTML=dw),Gy=o(yn),ap=l(yn,"DIV",{class:!0});var Gk=T(ap);m(Pa.$$.fragment,Gk),Gk.forEach(s),Xy=o(yn),lp=l(yn,"DIV",{class:!0});var Xk=T(lp);m(Qa.$$.fragment,Xk),Xk.forEach(s),yn.forEach(s),Vu=o(e),L=l(e,"DIV",{class:!0});var $e=T(L);m(Ya.$$.fragment,$e),Ry=o($e),cp=l($e,"P",{"data-svelte-h":!0}),y(cp)!=="svelte-1lvowm"&&(cp.innerHTML=pw),Sy=o($e),ip=l($e,"P",{"data-svelte-h":!0}),y(ip)!=="svelte-19qrwo1"&&(ip.innerHTML=mw),Ny=o($e),dp=l($e,"P",{"data-svelte-h":!0}),y(dp)!=="svelte-l79sbt"&&(dp.innerHTML=gw),Ey=o($e),pp=l($e,"DIV",{class:!0});var Rk=T(pp);m(Aa.$$.fragment,Rk),Rk.forEach(s),Hy=o($e),mp=l($e,"DIV",{class:!0});var Sk=T(mp);m(Oa.$$.fragment,Sk),Sk.forEach(s),$e.forEach(s),Gu=o(e),ye=l(e,"DIV",{class:!0});var Tn=T(ye);m(Ka.$$.fragment,Tn),qy=o(Tn),gp=l(Tn,"P",{"data-svelte-h":!0}),y(gp)!=="svelte-cvew4t"&&(gp.innerHTML=uw),Dy=o(Tn),up=l(Tn,"DIV",{class:!0});var Nk=T(up);m(el.$$.fragment,Nk),Nk.forEach(s),Py=o(Tn),hp=l(Tn,"DIV",{class:!0});var Ek=T(hp);m(tl.$$.fragment,Ek),Ek.forEach(s),Tn.forEach(s),Xu=o(e),m(sl.$$.fragment,e),Ru=o(e),it=l(e,"DIV",{class:!0});var wm=T(it);m(nl.$$.fragment,wm),Qy=o(wm),fp=l(wm,"P",{"data-svelte-h":!0}),y(fp)!=="svelte-1aiwpx2"&&(fp.textContent=hw),Yy=o(wm),_p=l(wm,"P",{"data-svelte-h":!0}),y(_p)!=="svelte-ts4ue3"&&(_p.innerHTML=fw),wm.forEach(s),Su=o(e),dt=l(e,"DIV",{class:!0});var km=T(dt);m(ol.$$.fragment,km),Ay=o(km),bp=l(km,"P",{"data-svelte-h":!0}),y(bp)!=="svelte-1aiwpx2"&&(bp.textContent=_w),Oy=o(km),yp=l(km,"P",{"data-svelte-h":!0}),y(yp)!=="svelte-ts4ue3"&&(yp.innerHTML=bw),km.forEach(s),Nu=o(e),m(rl.$$.fragment,e),Eu=o(e),z=l(e,"DIV",{class:!0});var K=T(z);m(al.$$.fragment,K),Ky=o(K),Tp=l(K,"P",{"data-svelte-h":!0}),y(Tp)!=="svelte-5jvlz5"&&(Tp.textContent=yw),eT=o(K),m(Rs.$$.fragment,K),tT=o(K),m(Ss.$$.fragment,K),sT=o(K),Ns=l(K,"DIV",{class:!0});var gh=T(Ns);m(ll.$$.fragment,gh),nT=o(gh),Mp=l(gh,"P",{"data-svelte-h":!0}),y(Mp)!=="svelte-10d94rs"&&(Mp.textContent=Tw),gh.forEach(s),oT=o(K),Es=l(K,"DIV",{class:!0});var uh=T(Es);m(cl.$$.fragment,uh),rT=o(uh),vp=l(uh,"P",{"data-svelte-h":!0}),y(vp)!=="svelte-tm945r"&&(vp.textContent=Mw),uh.forEach(s),aT=o(K),Hs=l(K,"DIV",{class:!0});var hh=T(Hs);m(il.$$.fragment,hh),lT=o(hh),wp=l(hh,"P",{"data-svelte-h":!0}),y(wp)!=="svelte-1i1356p"&&(wp.textContent=vw),hh.forEach(s),K.forEach(s),Hu=o(e),Y=l(e,"DIV",{class:!0});var xt=T(Y);m(dl.$$.fragment,xt),cT=o(xt),kp=l(xt,"P",{"data-svelte-h":!0}),y(kp)!=="svelte-190fodr"&&(kp.textContent=ww),iT=o(xt),m(qs.$$.fragment,xt),dT=o(xt),m(Ds.$$.fragment,xt),pT=o(xt),Ps=l(xt,"DIV",{class:!0});var fh=T(Ps);m(pl.$$.fragment,fh),mT=o(fh),$p=l(fh,"P",{"data-svelte-h":!0}),y($p)!=="svelte-16i5iz"&&($p.textContent=kw),fh.forEach(s),xt.forEach(s),qu=o(e),m(ml.$$.fragment,e),Du=o(e),pt=l(e,"DIV",{class:!0});var $m=T(pt);m(gl.$$.fragment,$m),gT=o($m),jp=l($m,"P",{"data-svelte-h":!0}),y(jp)!=="svelte-15qehu2"&&(jp.textContent=$w),uT=o($m),Qs=l($m,"DIV",{class:!0});var _h=T(Qs);m(ul.$$.fragment,_h),hT=o(_h),xp=l(_h,"P",{"data-svelte-h":!0}),y(xp)!=="svelte-dfcv5s"&&(xp.innerHTML=jw),_h.forEach(s),$m.forEach(s),Pu=o(e),Z=l(e,"DIV",{class:!0});var G=T(Z);m(hl.$$.fragment,G),fT=o(G),Jp=l(G,"P",{"data-svelte-h":!0}),y(Jp)!=="svelte-11w7j52"&&(Jp.textContent=xw),_T=o(G),Up=l(G,"P",{"data-svelte-h":!0}),y(Up)!=="svelte-1f9j82e"&&(Up.innerHTML=Jw),bT=o(G),Ys=l(G,"DIV",{class:!0});var bh=T(Ys);m(fl.$$.fragment,bh),yT=o(bh),Bp=l(bh,"P",{"data-svelte-h":!0}),y(Bp)!=="svelte-dfcv5s"&&(Bp.innerHTML=Uw),bh.forEach(s),TT=o(G),As=l(G,"DIV",{class:!0});var yh=T(As);m(_l.$$.fragment,yh),MT=o(yh),Ip=l(yh,"P",{"data-svelte-h":!0}),y(Ip)!=="svelte-1nftdf9"&&(Ip.textContent=Bw),yh.forEach(s),vT=o(G),Os=l(G,"DIV",{class:!0});var Th=T(Os);m(bl.$$.fragment,Th),wT=o(Th),Zp=l(Th,"P",{"data-svelte-h":!0}),y(Zp)!=="svelte-114iuj0"&&(Zp.textContent=Iw),Th.forEach(s),kT=o(G),Ks=l(G,"DIV",{class:!0});var Mh=T(Ks);m(yl.$$.fragment,Mh),$T=o(Mh),zp=l(Mh,"P",{"data-svelte-h":!0}),y(zp)!=="svelte-4hau7v"&&(zp.innerHTML=Zw),Mh.forEach(s),jT=o(G),en=l(G,"DIV",{class:!0});var vh=T(en);m(Tl.$$.fragment,vh),xT=o(vh),Wp=l(vh,"P",{"data-svelte-h":!0}),y(Wp)!=="svelte-sp3ts6"&&(Wp.innerHTML=zw),vh.forEach(s),G.forEach(s),Qu=o(e),F=l(e,"DIV",{class:!0});var je=T(F);m(Ml.$$.fragment,je),JT=o(je),Cp=l(je,"P",{"data-svelte-h":!0}),y(Cp)!=="svelte-ldcea6"&&(Cp.innerHTML=Ww),UT=o(je),Lp=l(je,"P",{"data-svelte-h":!0}),y(Lp)!=="svelte-1f9j82e"&&(Lp.innerHTML=Cw),BT=o(je),tn=l(je,"DIV",{class:!0});var wh=T(tn);m(vl.$$.fragment,wh),IT=o(wh),Fp=l(wh,"P",{"data-svelte-h":!0}),y(Fp)!=="svelte-dfcv5s"&&(Fp.innerHTML=Lw),wh.forEach(s),ZT=o(je),sn=l(je,"DIV",{class:!0});var kh=T(sn);m(wl.$$.fragment,kh),zT=o(kh),Vp=l(kh,"P",{"data-svelte-h":!0}),y(Vp)!=="svelte-1nftdf9"&&(Vp.textContent=Fw),kh.forEach(s),WT=o(je),nn=l(je,"DIV",{class:!0});var $h=T(nn);m(kl.$$.fragment,$h),CT=o($h),Gp=l($h,"P",{"data-svelte-h":!0}),y(Gp)!=="svelte-114iuj0"&&(Gp.textContent=Vw),$h.forEach(s),je.forEach(s),Yu=o(e),Te=l(e,"DIV",{class:!0});var Mn=T(Te);m($l.$$.fragment,Mn),LT=o(Mn),Xp=l(Mn,"P",{"data-svelte-h":!0}),y(Xp)!=="svelte-109wkq1"&&(Xp.innerHTML=Gw),FT=o(Mn),on=l(Mn,"DIV",{class:!0});var jh=T(on);m(jl.$$.fragment,jh),VT=o(jh),Rp=l(jh,"P",{"data-svelte-h":!0}),y(Rp)!=="svelte-vi6d54"&&(Rp.innerHTML=Xw),jh.forEach(s),GT=o(Mn),rn=l(Mn,"DIV",{class:!0});var xh=T(rn);m(xl.$$.fragment,xh),XT=o(xh),Sp=l(xh,"P",{"data-svelte-h":!0}),y(Sp)!=="svelte-18x5t5d"&&(Sp.innerHTML=Rw),xh.forEach(s),Mn.forEach(s),Au=o(e),jm=l(e,"P",{}),T(jm).forEach(s),this.h()},h(){M(i,"name","hf:doc:metadata"),M(i,"content",W2),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ii,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ad,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ud,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ls,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(up,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Es,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ps,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(As,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Os,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),d(e,$,c),d(e,b,c),d(e,_,c),g(w,e,c),d(e,r,c),d(e,k,c),d(e,Cm,c),g(wn,e,c),d(e,Lm,c),d(e,kn,c),d(e,Fm,c),d(e,$n,c),d(e,Vm,c),g(jn,e,c),d(e,Gm,c),d(e,xn,c),d(e,Xm,c),d(e,Jn,c),d(e,Rm,c),d(e,Un,c),d(e,Sm,c),d(e,Bn,c),d(e,Nm,c),d(e,In,c),d(e,Em,c),g(Zn,e,c),d(e,Hm,c),d(e,zn,c),d(e,qm,c),d(e,Wn,c),d(e,Dm,c),d(e,Cn,c),d(e,Pm,c),g(Ln,e,c),d(e,Qm,c),d(e,Jt,c),g(Fn,Jt,null),t(Jt,Jh),t(Jt,Hl),d(e,Ym,c),d(e,Ut,c),g(Vn,Ut,null),t(Ut,Uh),t(Ut,ql),d(e,Am,c),d(e,Bt,c),g(Gn,Bt,null),t(Bt,Bh),t(Bt,Dl),d(e,Om,c),d(e,It,c),g(Xn,It,null),t(It,Ih),t(It,Pl),d(e,Km,c),g(Rn,e,c),d(e,eg,c),d(e,Zt,c),g(Sn,Zt,null),t(Zt,Zh),t(Zt,Ql),d(e,tg,c),d(e,zt,c),g(Nn,zt,null),t(zt,zh),t(zt,Yl),d(e,sg,c),d(e,Wt,c),g(En,Wt,null),t(Wt,Wh),t(Wt,Al),d(e,ng,c),d(e,Ct,c),g(Hn,Ct,null),t(Ct,Ch),t(Ct,Ol),d(e,og,c),d(e,Lt,c),g(qn,Lt,null),t(Lt,Lh),t(Lt,Kl),d(e,rg,c),d(e,Ft,c),g(Dn,Ft,null),t(Ft,Fh),t(Ft,ec),d(e,ag,c),d(e,Vt,c),g(Pn,Vt,null),t(Vt,Vh),t(Vt,tc),d(e,lg,c),d(e,Gt,c),g(Qn,Gt,null),t(Gt,Gh),t(Gt,sc),d(e,cg,c),d(e,Xt,c),g(Yn,Xt,null),t(Xt,Xh),t(Xt,nc),d(e,ig,c),d(e,Rt,c),g(An,Rt,null),t(Rt,Rh),t(Rt,oc),d(e,dg,c),g(On,e,c),d(e,pg,c),d(e,xe,c),g(Kn,xe,null),t(xe,Sh),t(xe,rc),t(xe,Nh),t(xe,Pt),g(eo,Pt,null),t(Pt,Eh),t(Pt,ac),d(e,mg,c),d(e,Je,c),g(to,Je,null),t(Je,Hh),t(Je,lc),t(Je,qh),t(Je,Qt),g(so,Qt,null),t(Qt,Dh),t(Qt,cc),d(e,gg,c),d(e,Ue,c),g(no,Ue,null),t(Ue,Ph),t(Ue,ic),t(Ue,Qh),t(Ue,Yt),g(oo,Yt,null),t(Yt,Yh),t(Yt,dc),d(e,ug,c),g(ro,e,c),d(e,hg,c),d(e,ao,c),d(e,fg,c),g(lo,e,c),d(e,_g,c),d(e,ee,c),g(co,ee,null),t(ee,Ah),t(ee,pc),t(ee,Oh),g(At,ee,null),t(ee,Kh),t(ee,mc),g(io,mc,null),d(e,bg,c),d(e,W,c),g(po,W,null),t(W,ef),t(W,gc),t(W,tf),t(W,uc),t(W,sf),g(Ot,W,null),t(W,nf),g(Kt,W,null),t(W,of),t(W,hc),g(mo,hc,null),d(e,yg,c),d(e,X,c),g(go,X,null),t(X,rf),t(X,fc),t(X,af),t(X,_c),t(X,lf),g(es,X,null),t(X,cf),t(X,bc),g(uo,bc,null),d(e,Tg,c),d(e,R,c),g(ho,R,null),t(R,df),t(R,yc),t(R,pf),t(R,Tc),t(R,mf),g(ts,R,null),t(R,gf),t(R,Mc),g(fo,Mc,null),d(e,Mg,c),d(e,te,c),g(_o,te,null),t(te,uf),t(te,vc),t(te,hf),g(ss,te,null),t(te,ff),t(te,wc),g(bo,wc,null),d(e,vg,c),d(e,se,c),g(yo,se,null),t(se,_f),t(se,kc),t(se,bf),g(ns,se,null),t(se,yf),t(se,$c),g(To,$c,null),d(e,wg,c),d(e,ne,c),g(Mo,ne,null),t(ne,Tf),t(ne,jc),t(ne,Mf),g(os,ne,null),t(ne,vf),t(ne,xc),g(vo,xc,null),d(e,kg,c),d(e,oe,c),g(wo,oe,null),t(oe,wf),t(oe,Jc),t(oe,kf),g(rs,oe,null),t(oe,$f),t(oe,Uc),g(ko,Uc,null),d(e,$g,c),d(e,re,c),g($o,re,null),t(re,jf),t(re,Bc),t(re,xf),g(as,re,null),t(re,Jf),t(re,Ic),g(jo,Ic,null),d(e,jg,c),d(e,ae,c),g(xo,ae,null),t(ae,Uf),t(ae,Zc),t(ae,Bf),g(ls,ae,null),t(ae,If),t(ae,zc),g(Jo,zc,null),d(e,xg,c),d(e,C,c),g(Uo,C,null),t(C,Zf),t(C,Wc),t(C,zf),t(C,Cc),t(C,Wf),t(C,Lc),t(C,Cf),g(cs,C,null),t(C,Lf),t(C,Fc),g(Bo,Fc,null),d(e,Jg,c),d(e,le,c),g(Io,le,null),t(le,Ff),t(le,Vc),t(le,Vf),t(le,Gc),t(le,Gf),t(le,Xc),g(Zo,Xc,null),d(e,Ug,c),d(e,ce,c),g(zo,ce,null),t(ce,Xf),t(ce,Rc),t(ce,Rf),g(is,ce,null),t(ce,Sf),t(ce,Sc),g(Wo,Sc,null),d(e,Bg,c),d(e,Be,c),g(Co,Be,null),t(Be,Nf),t(Be,Nc),t(Be,Ef),t(Be,Ec),g(Lo,Ec,null),d(e,Ig,c),d(e,Ie,c),g(Fo,Ie,null),t(Ie,Hf),t(Ie,Hc),t(Ie,qf),t(Ie,qc),g(Vo,qc,null),d(e,Zg,c),d(e,Ze,c),g(Go,Ze,null),t(Ze,Df),t(Ze,Dc),t(Ze,Pf),t(Ze,Pc),g(Xo,Pc,null),d(e,zg,c),d(e,ie,c),g(Ro,ie,null),t(ie,Qf),t(ie,Qc),t(ie,Yf),g(ds,ie,null),t(ie,Af),t(ie,Yc),g(So,Yc,null),d(e,Wg,c),d(e,de,c),g(No,de,null),t(de,Of),t(de,Ac),t(de,Kf),g(ps,de,null),t(de,e_),t(de,Oc),g(Eo,Oc,null),d(e,Cg,c),d(e,S,c),g(Ho,S,null),t(S,t_),t(S,Kc),t(S,s_),g(ms,S,null),t(S,n_),g(gs,S,null),t(S,o_),t(S,ei),g(qo,ei,null),d(e,Lg,c),d(e,N,c),g(Do,N,null),t(N,r_),t(N,ti),t(N,a_),g(us,N,null),t(N,l_),g(hs,N,null),t(N,c_),t(N,si),g(Po,si,null),d(e,Fg,c),d(e,pe,c),g(Qo,pe,null),t(pe,i_),t(pe,ni),t(pe,d_),g(fs,pe,null),t(pe,p_),t(pe,oi),g(Yo,oi,null),d(e,Vg,c),d(e,E,c),g(Ao,E,null),t(E,m_),t(E,ri),t(E,g_),t(E,ai),t(E,u_),g(_s,E,null),t(E,h_),t(E,li),g(Oo,li,null),d(e,Gg,c),d(e,H,c),g(Ko,H,null),t(H,f_),t(H,ci),t(H,__),g(bs,H,null),t(H,b_),g(ys,H,null),t(H,y_),t(H,ii),g(er,ii,null),d(e,Xg,c),d(e,me,c),g(tr,me,null),t(me,T_),t(me,di),t(me,M_),g(Ts,me,null),t(me,v_),t(me,pi),g(sr,pi,null),d(e,Rg,c),d(e,ge,c),g(nr,ge,null),t(ge,w_),t(ge,mi),t(ge,k_),g(Ms,ge,null),t(ge,$_),t(ge,gi),g(or,gi,null),d(e,Sg,c),d(e,q,c),g(rr,q,null),t(q,j_),t(q,ui),t(q,x_),g(vs,q,null),t(q,J_),g(ws,q,null),t(q,U_),t(q,hi),g(ar,hi,null),d(e,Ng,c),d(e,ue,c),g(lr,ue,null),t(ue,B_),t(ue,fi),t(ue,I_),g(ks,ue,null),t(ue,Z_),t(ue,_i),g(cr,_i,null),d(e,Eg,c),d(e,he,c),g(ir,he,null),t(he,z_),t(he,bi),t(he,W_),g($s,he,null),t(he,C_),t(he,yi),g(dr,yi,null),d(e,Hg,c),d(e,D,c),g(pr,D,null),t(D,L_),t(D,Ti),t(D,F_),t(D,Mi),t(D,V_),g(js,D,null),t(D,G_),t(D,vi),g(mr,vi,null),d(e,qg,c),d(e,P,c),g(gr,P,null),t(P,X_),t(P,wi),t(P,R_),t(P,ki),t(P,S_),g(xs,P,null),t(P,N_),t(P,$i),g(ur,$i,null),d(e,Dg,c),d(e,Q,c),g(hr,Q,null),t(Q,E_),t(Q,ji),t(Q,H_),t(Q,xi),t(Q,q_),g(Js,Q,null),t(Q,D_),t(Q,Ji),g(fr,Ji,null),d(e,Pg,c),g(_r,e,c),d(e,Qg,c),d(e,ze,c),g(br,ze,null),t(ze,P_),t(ze,Ui),t(ze,Q_),t(ze,Bi),g(yr,Bi,null),d(e,Yg,c),d(e,We,c),g(Tr,We,null),t(We,Y_),t(We,Ii),t(We,A_),t(We,Zi),g(Mr,Zi,null),d(e,Ag,c),d(e,Ce,c),g(vr,Ce,null),t(Ce,O_),t(Ce,zi),t(Ce,K_),t(Ce,Wi),g(wr,Wi,null),d(e,Og,c),d(e,Le,c),g(kr,Le,null),t(Le,eb),t(Le,Ci),t(Le,tb),t(Le,Us),g($r,Us,null),t(Us,sb),t(Us,Li),d(e,Kg,c),d(e,Fe,c),g(jr,Fe,null),t(Fe,nb),t(Fe,Fi),t(Fe,ob),t(Fe,Vi),g(xr,Vi,null),d(e,eu,c),d(e,Ve,c),g(Jr,Ve,null),t(Ve,rb),t(Ve,Gi),t(Ve,ab),t(Ve,Bs),g(Ur,Bs,null),t(Bs,lb),t(Bs,Xi),d(e,tu,c),d(e,Ge,c),g(Br,Ge,null),t(Ge,cb),t(Ge,Ri),t(Ge,ib),t(Ge,Si),g(Ir,Si,null),d(e,su,c),d(e,Xe,c),g(Zr,Xe,null),t(Xe,db),t(Xe,Ni),t(Xe,pb),t(Xe,Ei),g(zr,Ei,null),d(e,nu,c),d(e,Re,c),g(Wr,Re,null),t(Re,mb),t(Re,Hi),t(Re,gb),t(Re,qi),g(Cr,qi,null),d(e,ou,c),d(e,Se,c),g(Lr,Se,null),t(Se,ub),t(Se,Di),t(Se,hb),t(Se,Pi),g(Fr,Pi,null),d(e,ru,c),d(e,Ne,c),g(Vr,Ne,null),t(Ne,fb),t(Ne,Qi),t(Ne,_b),t(Ne,Yi),g(Gr,Yi,null),d(e,au,c),d(e,Ee,c),g(Xr,Ee,null),t(Ee,bb),t(Ee,Ai),t(Ee,yb),t(Ee,Oi),g(Rr,Oi,null),d(e,lu,c),d(e,He,c),g(Sr,He,null),t(He,Tb),t(He,Ki),t(He,Mb),t(He,ed),g(Nr,ed,null),d(e,cu,c),d(e,qe,c),g(Er,qe,null),t(qe,vb),t(qe,td),t(qe,wb),t(qe,sd),g(Hr,sd,null),d(e,iu,c),d(e,De,c),g(qr,De,null),t(De,kb),t(De,nd),t(De,$b),t(De,od),g(Dr,od,null),d(e,du,c),g(Pr,e,c),d(e,pu,c),d(e,Pe,c),g(Qr,Pe,null),t(Pe,jb),t(Pe,rd),t(Pe,xb),t(Pe,ad),g(Yr,ad,null),d(e,mu,c),d(e,Qe,c),g(Ar,Qe,null),t(Qe,Jb),t(Qe,ld),t(Qe,Ub),t(Qe,cd),g(Or,cd,null),d(e,gu,c),d(e,Ye,c),g(Kr,Ye,null),t(Ye,Bb),t(Ye,id),t(Ye,Ib),t(Ye,dd),g(ea,dd,null),d(e,uu,c),d(e,Ae,c),g(ta,Ae,null),t(Ae,Zb),t(Ae,pd),t(Ae,zb),t(Ae,Is),g(sa,Is,null),t(Is,Wb),t(Is,md),d(e,hu,c),d(e,Oe,c),g(na,Oe,null),t(Oe,Cb),t(Oe,gd),t(Oe,Lb),t(Oe,ud),g(oa,ud,null),d(e,fu,c),d(e,Ke,c),g(ra,Ke,null),t(Ke,Fb),t(Ke,hd),t(Ke,Vb),t(Ke,Zs),g(aa,Zs,null),t(Zs,Gb),t(Zs,fd),d(e,_u,c),d(e,et,c),g(la,et,null),t(et,Xb),t(et,_d),t(et,Rb),t(et,bd),g(ca,bd,null),d(e,bu,c),d(e,tt,c),g(ia,tt,null),t(tt,Sb),t(tt,yd),t(tt,Nb),t(tt,Td),g(da,Td,null),d(e,yu,c),d(e,st,c),g(pa,st,null),t(st,Eb),t(st,Md),t(st,Hb),t(st,vd),g(ma,vd,null),d(e,Tu,c),d(e,nt,c),g(ga,nt,null),t(nt,qb),t(nt,wd),t(nt,Db),t(nt,kd),g(ua,kd,null),d(e,Mu,c),d(e,ot,c),g(ha,ot,null),t(ot,Pb),t(ot,$d),t(ot,Qb),t(ot,jd),g(fa,jd,null),d(e,vu,c),d(e,rt,c),g(_a,rt,null),t(rt,Yb),t(rt,xd),t(rt,Ab),t(rt,Jd),g(ba,Jd,null),d(e,wu,c),d(e,at,c),g(ya,at,null),t(at,Ob),t(at,Ud),t(at,Kb),t(at,Bd),g(Ta,Bd,null),d(e,ku,c),g(Ma,e,c),d(e,$u,c),d(e,va,c),d(e,ju,c),d(e,fe,c),g(wa,fe,null),t(fe,ey),t(fe,Id),t(fe,ty),t(fe,Zd),t(fe,sy),t(fe,zd),g(ka,zd,null),d(e,xu,c),d(e,St,c),g($a,St,null),t(St,ny),t(St,Wd),g(ja,Wd,null),d(e,Ju,c),d(e,lt,c),g(xa,lt,null),t(lt,oy),t(lt,Cd),t(lt,ry),t(lt,Ld),g(Ja,Ld,null),d(e,Uu,c),d(e,ct,c),g(Ua,ct,null),t(ct,ay),t(ct,Fd),t(ct,ly),t(ct,Vd),g(Ba,Vd,null),d(e,Bu,c),g(Ia,e,c),d(e,Iu,c),d(e,Za,c),d(e,Zu,c),d(e,U,c),g(za,U,null),t(U,cy),t(U,Gd),t(U,iy),t(U,Xd),t(U,dy),g(zs,U,null),t(U,py),t(U,Rd),t(U,my),t(U,Ws),g(Wa,Ws,null),t(Ws,gy),t(Ws,Sd),t(U,uy),t(U,Cs),g(Ca,Cs,null),t(Cs,hy),t(Cs,Nd),t(U,fy),t(U,Ls),g(La,Ls,null),t(Ls,_y),t(Ls,Ed),t(U,by),t(U,Fs),g(Fa,Fs,null),t(Fs,yy),t(Fs,Hd),t(U,Ty),t(U,Vs),g(Va,Vs,null),t(Vs,My),t(Vs,qd),t(U,vy),t(U,Gs),g(Ga,Gs,null),t(Gs,wy),t(Gs,Dd),t(U,ky),t(U,bt),g(Xa,bt,null),t(bt,$y),t(bt,Pd),t(bt,jy),t(bt,Qd),d(e,zu,c),d(e,Nt,c),g(Ra,Nt,null),t(Nt,xy),t(Nt,Yd),d(e,Wu,c),d(e,Et,c),g(Sa,Et,null),t(Et,Jy),t(Et,Ad),d(e,Cu,c),d(e,_e,c),g(Na,_e,null),t(_e,Uy),t(_e,Od),t(_e,By),t(_e,V),g(Ea,V,null),t(V,Iy),t(V,Kd),t(V,Zy),t(V,ep),t(V,zy),t(V,tp),t(V,Wy),t(V,sp),t(V,Cy),t(V,np),t(_e,Ly),t(_e,Xs),g(Ha,Xs,null),t(Xs,Fy),t(Xs,op),d(e,Lu,c),g(qa,e,c),d(e,Fu,c),d(e,be,c),g(Da,be,null),t(be,Vy),t(be,rp),t(be,Gy),t(be,ap),g(Pa,ap,null),t(be,Xy),t(be,lp),g(Qa,lp,null),d(e,Vu,c),d(e,L,c),g(Ya,L,null),t(L,Ry),t(L,cp),t(L,Sy),t(L,ip),t(L,Ny),t(L,dp),t(L,Ey),t(L,pp),g(Aa,pp,null),t(L,Hy),t(L,mp),g(Oa,mp,null),d(e,Gu,c),d(e,ye,c),g(Ka,ye,null),t(ye,qy),t(ye,gp),t(ye,Dy),t(ye,up),g(el,up,null),t(ye,Py),t(ye,hp),g(tl,hp,null),d(e,Xu,c),g(sl,e,c),d(e,Ru,c),d(e,it,c),g(nl,it,null),t(it,Qy),t(it,fp),t(it,Yy),t(it,_p),d(e,Su,c),d(e,dt,c),g(ol,dt,null),t(dt,Ay),t(dt,bp),t(dt,Oy),t(dt,yp),d(e,Nu,c),g(rl,e,c),d(e,Eu,c),d(e,z,c),g(al,z,null),t(z,Ky),t(z,Tp),t(z,eT),g(Rs,z,null),t(z,tT),g(Ss,z,null),t(z,sT),t(z,Ns),g(ll,Ns,null),t(Ns,nT),t(Ns,Mp),t(z,oT),t(z,Es),g(cl,Es,null),t(Es,rT),t(Es,vp),t(z,aT),t(z,Hs),g(il,Hs,null),t(Hs,lT),t(Hs,wp),d(e,Hu,c),d(e,Y,c),g(dl,Y,null),t(Y,cT),t(Y,kp),t(Y,iT),g(qs,Y,null),t(Y,dT),g(Ds,Y,null),t(Y,pT),t(Y,Ps),g(pl,Ps,null),t(Ps,mT),t(Ps,$p),d(e,qu,c),g(ml,e,c),d(e,Du,c),d(e,pt,c),g(gl,pt,null),t(pt,gT),t(pt,jp),t(pt,uT),t(pt,Qs),g(ul,Qs,null),t(Qs,hT),t(Qs,xp),d(e,Pu,c),d(e,Z,c),g(hl,Z,null),t(Z,fT),t(Z,Jp),t(Z,_T),t(Z,Up),t(Z,bT),t(Z,Ys),g(fl,Ys,null),t(Ys,yT),t(Ys,Bp),t(Z,TT),t(Z,As),g(_l,As,null),t(As,MT),t(As,Ip),t(Z,vT),t(Z,Os),g(bl,Os,null),t(Os,wT),t(Os,Zp),t(Z,kT),t(Z,Ks),g(yl,Ks,null),t(Ks,$T),t(Ks,zp),t(Z,jT),t(Z,en),g(Tl,en,null),t(en,xT),t(en,Wp),d(e,Qu,c),d(e,F,c),g(Ml,F,null),t(F,JT),t(F,Cp),t(F,UT),t(F,Lp),t(F,BT),t(F,tn),g(vl,tn,null),t(tn,IT),t(tn,Fp),t(F,ZT),t(F,sn),g(wl,sn,null),t(sn,zT),t(sn,Vp),t(F,WT),t(F,nn),g(kl,nn,null),t(nn,CT),t(nn,Gp),d(e,Yu,c),d(e,Te,c),g($l,Te,null),t(Te,LT),t(Te,Xp),t(Te,FT),t(Te,on),g(jl,on,null),t(on,VT),t(on,Rp),t(Te,GT),t(Te,rn),g(xl,rn,null),t(rn,XT),t(rn,Sp),d(e,Au,c),d(e,jm,c),Ou=!0},p(e,[c]){const Jl={};c&2&&(Jl.$$scope={dirty:c,ctx:e}),At.$set(Jl);const Ul={};c&2&&(Ul.$$scope={dirty:c,ctx:e}),Ot.$set(Ul);const Bl={};c&2&&(Bl.$$scope={dirty:c,ctx:e}),Kt.$set(Bl);const Il={};c&2&&(Il.$$scope={dirty:c,ctx:e}),es.$set(Il);const Zl={};c&2&&(Zl.$$scope={dirty:c,ctx:e}),ts.$set(Zl);const zl={};c&2&&(zl.$$scope={dirty:c,ctx:e}),ss.$set(zl);const Wl={};c&2&&(Wl.$$scope={dirty:c,ctx:e}),ns.$set(Wl);const Cl={};c&2&&(Cl.$$scope={dirty:c,ctx:e}),os.$set(Cl);const Ll={};c&2&&(Ll.$$scope={dirty:c,ctx:e}),rs.$set(Ll);const Fl={};c&2&&(Fl.$$scope={dirty:c,ctx:e}),as.$set(Fl);const Vl={};c&2&&(Vl.$$scope={dirty:c,ctx:e}),ls.$set(Vl);const Gl={};c&2&&(Gl.$$scope={dirty:c,ctx:e}),cs.$set(Gl);const Xl={};c&2&&(Xl.$$scope={dirty:c,ctx:e}),is.$set(Xl);const Rl={};c&2&&(Rl.$$scope={dirty:c,ctx:e}),ds.$set(Rl);const Ht={};c&2&&(Ht.$$scope={dirty:c,ctx:e}),ps.$set(Ht);const Sl={};c&2&&(Sl.$$scope={dirty:c,ctx:e}),ms.$set(Sl);const qt={};c&2&&(qt.$$scope={dirty:c,ctx:e}),gs.$set(qt);const Nl={};c&2&&(Nl.$$scope={dirty:c,ctx:e}),us.$set(Nl);const Dt={};c&2&&(Dt.$$scope={dirty:c,ctx:e}),hs.$set(Dt);const El={};c&2&&(El.$$scope={dirty:c,ctx:e}),fs.$set(El);const mt={};c&2&&(mt.$$scope={dirty:c,ctx:e}),_s.$set(mt);const xm={};c&2&&(xm.$$scope={dirty:c,ctx:e}),bs.$set(xm);const A={};c&2&&(A.$$scope={dirty:c,ctx:e}),ys.$set(A);const Jm={};c&2&&(Jm.$$scope={dirty:c,ctx:e}),Ts.$set(Jm);const Me={};c&2&&(Me.$$scope={dirty:c,ctx:e}),Ms.$set(Me);const Um={};c&2&&(Um.$$scope={dirty:c,ctx:e}),vs.$set(Um);const ve={};c&2&&(ve.$$scope={dirty:c,ctx:e}),ws.$set(ve);const Bm={};c&2&&(Bm.$$scope={dirty:c,ctx:e}),ks.$set(Bm);const gt={};c&2&&(gt.$$scope={dirty:c,ctx:e}),$s.$set(gt);const Im={};c&2&&(Im.$$scope={dirty:c,ctx:e}),js.$set(Im);const ut={};c&2&&(ut.$$scope={dirty:c,ctx:e}),xs.$set(ut);const Zm={};c&2&&(Zm.$$scope={dirty:c,ctx:e}),Js.$set(Zm);const ht={};c&2&&(ht.$$scope={dirty:c,ctx:e}),zs.$set(ht);const zm={};c&2&&(zm.$$scope={dirty:c,ctx:e}),Rs.$set(zm);const ft={};c&2&&(ft.$$scope={dirty:c,ctx:e}),Ss.$set(ft);const Wm={};c&2&&(Wm.$$scope={dirty:c,ctx:e}),qs.$set(Wm);const _t={};c&2&&(_t.$$scope={dirty:c,ctx:e}),Ds.$set(_t)},i(e){Ou||(u(w.$$.fragment,e),u(wn.$$.fragment,e),u(jn.$$.fragment,e),u(Zn.$$.fragment,e),u(Ln.$$.fragment,e),u(Fn.$$.fragment,e),u(Vn.$$.fragment,e),u(Gn.$$.fragment,e),u(Xn.$$.fragment,e),u(Rn.$$.fragment,e),u(Sn.$$.fragment,e),u(Nn.$$.fragment,e),u(En.$$.fragment,e),u(Hn.$$.fragment,e),u(qn.$$.fragment,e),u(Dn.$$.fragment,e),u(Pn.$$.fragment,e),u(Qn.$$.fragment,e),u(Yn.$$.fragment,e),u(An.$$.fragment,e),u(On.$$.fragment,e),u(Kn.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(no.$$.fragment,e),u(oo.$$.fragment,e),u(ro.$$.fragment,e),u(lo.$$.fragment,e),u(co.$$.fragment,e),u(At.$$.fragment,e),u(io.$$.fragment,e),u(po.$$.fragment,e),u(Ot.$$.fragment,e),u(Kt.$$.fragment,e),u(mo.$$.fragment,e),u(go.$$.fragment,e),u(es.$$.fragment,e),u(uo.$$.fragment,e),u(ho.$$.fragment,e),u(ts.$$.fragment,e),u(fo.$$.fragment,e),u(_o.$$.fragment,e),u(ss.$$.fragment,e),u(bo.$$.fragment,e),u(yo.$$.fragment,e),u(ns.$$.fragment,e),u(To.$$.fragment,e),u(Mo.$$.fragment,e),u(os.$$.fragment,e),u(vo.$$.fragment,e),u(wo.$$.fragment,e),u(rs.$$.fragment,e),u(ko.$$.fragment,e),u($o.$$.fragment,e),u(as.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(ls.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(cs.$$.fragment,e),u(Bo.$$.fragment,e),u(Io.$$.fragment,e),u(Zo.$$.fragment,e),u(zo.$$.fragment,e),u(is.$$.fragment,e),u(Wo.$$.fragment,e),u(Co.$$.fragment,e),u(Lo.$$.fragment,e),u(Fo.$$.fragment,e),u(Vo.$$.fragment,e),u(Go.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(ds.$$.fragment,e),u(So.$$.fragment,e),u(No.$$.fragment,e),u(ps.$$.fragment,e),u(Eo.$$.fragment,e),u(Ho.$$.fragment,e),u(ms.$$.fragment,e),u(gs.$$.fragment,e),u(qo.$$.fragment,e),u(Do.$$.fragment,e),u(us.$$.fragment,e),u(hs.$$.fragment,e),u(Po.$$.fragment,e),u(Qo.$$.fragment,e),u(fs.$$.fragment,e),u(Yo.$$.fragment,e),u(Ao.$$.fragment,e),u(_s.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(bs.$$.fragment,e),u(ys.$$.fragment,e),u(er.$$.fragment,e),u(tr.$$.fragment,e),u(Ts.$$.fragment,e),u(sr.$$.fragment,e),u(nr.$$.fragment,e),u(Ms.$$.fragment,e),u(or.$$.fragment,e),u(rr.$$.fragment,e),u(vs.$$.fragment,e),u(ws.$$.fragment,e),u(ar.$$.fragment,e),u(lr.$$.fragment,e),u(ks.$$.fragment,e),u(cr.$$.fragment,e),u(ir.$$.fragment,e),u($s.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(js.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(xs.$$.fragment,e),u(ur.$$.fragment,e),u(hr.$$.fragment,e),u(Js.$$.fragment,e),u(fr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u(Mr.$$.fragment,e),u(vr.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u($r.$$.fragment,e),u(jr.$$.fragment,e),u(xr.$$.fragment,e),u(Jr.$$.fragment,e),u(Ur.$$.fragment,e),u(Br.$$.fragment,e),u(Ir.$$.fragment,e),u(Zr.$$.fragment,e),u(zr.$$.fragment,e),u(Wr.$$.fragment,e),u(Cr.$$.fragment,e),u(Lr.$$.fragment,e),u(Fr.$$.fragment,e),u(Vr.$$.fragment,e),u(Gr.$$.fragment,e),u(Xr.$$.fragment,e),u(Rr.$$.fragment,e),u(Sr.$$.fragment,e),u(Nr.$$.fragment,e),u(Er.$$.fragment,e),u(Hr.$$.fragment,e),u(qr.$$.fragment,e),u(Dr.$$.fragment,e),u(Pr.$$.fragment,e),u(Qr.$$.fragment,e),u(Yr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(sa.$$.fragment,e),u(na.$$.fragment,e),u(oa.$$.fragment,e),u(ra.$$.fragment,e),u(aa.$$.fragment,e),u(la.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ga.$$.fragment,e),u(ua.$$.fragment,e),u(ha.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(ya.$$.fragment,e),u(Ta.$$.fragment,e),u(Ma.$$.fragment,e),u(wa.$$.fragment,e),u(ka.$$.fragment,e),u($a.$$.fragment,e),u(ja.$$.fragment,e),u(xa.$$.fragment,e),u(Ja.$$.fragment,e),u(Ua.$$.fragment,e),u(Ba.$$.fragment,e),u(Ia.$$.fragment,e),u(za.$$.fragment,e),u(zs.$$.fragment,e),u(Wa.$$.fragment,e),u(Ca.$$.fragment,e),u(La.$$.fragment,e),u(Fa.$$.fragment,e),u(Va.$$.fragment,e),u(Ga.$$.fragment,e),u(Xa.$$.fragment,e),u(Ra.$$.fragment,e),u(Sa.$$.fragment,e),u(Na.$$.fragment,e),u(Ea.$$.fragment,e),u(Ha.$$.fragment,e),u(qa.$$.fragment,e),u(Da.$$.fragment,e),u(Pa.$$.fragment,e),u(Qa.$$.fragment,e),u(Ya.$$.fragment,e),u(Aa.$$.fragment,e),u(Oa.$$.fragment,e),u(Ka.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(ol.$$.fragment,e),u(rl.$$.fragment,e),u(al.$$.fragment,e),u(Rs.$$.fragment,e),u(Ss.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(qs.$$.fragment,e),u(Ds.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(ul.$$.fragment,e),u(hl.$$.fragment,e),u(fl.$$.fragment,e),u(_l.$$.fragment,e),u(bl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(vl.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u($l.$$.fragment,e),u(jl.$$.fragment,e),u(xl.$$.fragment,e),Ou=!0)},o(e){h(w.$$.fragment,e),h(wn.$$.fragment,e),h(jn.$$.fragment,e),h(Zn.$$.fragment,e),h(Ln.$$.fragment,e),h(Fn.$$.fragment,e),h(Vn.$$.fragment,e),h(Gn.$$.fragment,e),h(Xn.$$.fragment,e),h(Rn.$$.fragment,e),h(Sn.$$.fragment,e),h(Nn.$$.fragment,e),h(En.$$.fragment,e),h(Hn.$$.fragment,e),h(qn.$$.fragment,e),h(Dn.$$.fragment,e),h(Pn.$$.fragment,e),h(Qn.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(so.$$.fragment,e),h(no.$$.fragment,e),h(oo.$$.fragment,e),h(ro.$$.fragment,e),h(lo.$$.fragment,e),h(co.$$.fragment,e),h(At.$$.fragment,e),h(io.$$.fragment,e),h(po.$$.fragment,e),h(Ot.$$.fragment,e),h(Kt.$$.fragment,e),h(mo.$$.fragment,e),h(go.$$.fragment,e),h(es.$$.fragment,e),h(uo.$$.fragment,e),h(ho.$$.fragment,e),h(ts.$$.fragment,e),h(fo.$$.fragment,e),h(_o.$$.fragment,e),h(ss.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(ns.$$.fragment,e),h(To.$$.fragment,e),h(Mo.$$.fragment,e),h(os.$$.fragment,e),h(vo.$$.fragment,e),h(wo.$$.fragment,e),h(rs.$$.fragment,e),h(ko.$$.fragment,e),h($o.$$.fragment,e),h(as.$$.fragment,e),h(jo.$$.fragment,e),h(xo.$$.fragment,e),h(ls.$$.fragment,e),h(Jo.$$.fragment,e),h(Uo.$$.fragment,e),h(cs.$$.fragment,e),h(Bo.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(zo.$$.fragment,e),h(is.$$.fragment,e),h(Wo.$$.fragment,e),h(Co.$$.fragment,e),h(Lo.$$.fragment,e),h(Fo.$$.fragment,e),h(Vo.$$.fragment,e),h(Go.$$.fragment,e),h(Xo.$$.fragment,e),h(Ro.$$.fragment,e),h(ds.$$.fragment,e),h(So.$$.fragment,e),h(No.$$.fragment,e),h(ps.$$.fragment,e),h(Eo.$$.fragment,e),h(Ho.$$.fragment,e),h(ms.$$.fragment,e),h(gs.$$.fragment,e),h(qo.$$.fragment,e),h(Do.$$.fragment,e),h(us.$$.fragment,e),h(hs.$$.fragment,e),h(Po.$$.fragment,e),h(Qo.$$.fragment,e),h(fs.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(_s.$$.fragment,e),h(Oo.$$.fragment,e),h(Ko.$$.fragment,e),h(bs.$$.fragment,e),h(ys.$$.fragment,e),h(er.$$.fragment,e),h(tr.$$.fragment,e),h(Ts.$$.fragment,e),h(sr.$$.fragment,e),h(nr.$$.fragment,e),h(Ms.$$.fragment,e),h(or.$$.fragment,e),h(rr.$$.fragment,e),h(vs.$$.fragment,e),h(ws.$$.fragment,e),h(ar.$$.fragment,e),h(lr.$$.fragment,e),h(ks.$$.fragment,e),h(cr.$$.fragment,e),h(ir.$$.fragment,e),h($s.$$.fragment,e),h(dr.$$.fragment,e),h(pr.$$.fragment,e),h(js.$$.fragment,e),h(mr.$$.fragment,e),h(gr.$$.fragment,e),h(xs.$$.fragment,e),h(ur.$$.fragment,e),h(hr.$$.fragment,e),h(Js.$$.fragment,e),h(fr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(yr.$$.fragment,e),h(Tr.$$.fragment,e),h(Mr.$$.fragment,e),h(vr.$$.fragment,e),h(wr.$$.fragment,e),h(kr.$$.fragment,e),h($r.$$.fragment,e),h(jr.$$.fragment,e),h(xr.$$.fragment,e),h(Jr.$$.fragment,e),h(Ur.$$.fragment,e),h(Br.$$.fragment,e),h(Ir.$$.fragment,e),h(Zr.$$.fragment,e),h(zr.$$.fragment,e),h(Wr.$$.fragment,e),h(Cr.$$.fragment,e),h(Lr.$$.fragment,e),h(Fr.$$.fragment,e),h(Vr.$$.fragment,e),h(Gr.$$.fragment,e),h(Xr.$$.fragment,e),h(Rr.$$.fragment,e),h(Sr.$$.fragment,e),h(Nr.$$.fragment,e),h(Er.$$.fragment,e),h(Hr.$$.fragment,e),h(qr.$$.fragment,e),h(Dr.$$.fragment,e),h(Pr.$$.fragment,e),h(Qr.$$.fragment,e),h(Yr.$$.fragment,e),h(Ar.$$.fragment,e),h(Or.$$.fragment,e),h(Kr.$$.fragment,e),h(ea.$$.fragment,e),h(ta.$$.fragment,e),h(sa.$$.fragment,e),h(na.$$.fragment,e),h(oa.$$.fragment,e),h(ra.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(ca.$$.fragment,e),h(ia.$$.fragment,e),h(da.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ga.$$.fragment,e),h(ua.$$.fragment,e),h(ha.$$.fragment,e),h(fa.$$.fragment,e),h(_a.$$.fragment,e),h(ba.$$.fragment,e),h(ya.$$.fragment,e),h(Ta.$$.fragment,e),h(Ma.$$.fragment,e),h(wa.$$.fragment,e),h(ka.$$.fragment,e),h($a.$$.fragment,e),h(ja.$$.fragment,e),h(xa.$$.fragment,e),h(Ja.$$.fragment,e),h(Ua.$$.fragment,e),h(Ba.$$.fragment,e),h(Ia.$$.fragment,e),h(za.$$.fragment,e),h(zs.$$.fragment,e),h(Wa.$$.fragment,e),h(Ca.$$.fragment,e),h(La.$$.fragment,e),h(Fa.$$.fragment,e),h(Va.$$.fragment,e),h(Ga.$$.fragment,e),h(Xa.$$.fragment,e),h(Ra.$$.fragment,e),h(Sa.$$.fragment,e),h(Na.$$.fragment,e),h(Ea.$$.fragment,e),h(Ha.$$.fragment,e),h(qa.$$.fragment,e),h(Da.$$.fragment,e),h(Pa.$$.fragment,e),h(Qa.$$.fragment,e),h(Ya.$$.fragment,e),h(Aa.$$.fragment,e),h(Oa.$$.fragment,e),h(Ka.$$.fragment,e),h(el.$$.fragment,e),h(tl.$$.fragment,e),h(sl.$$.fragment,e),h(nl.$$.fragment,e),h(ol.$$.fragment,e),h(rl.$$.fragment,e),h(al.$$.fragment,e),h(Rs.$$.fragment,e),h(Ss.$$.fragment,e),h(ll.$$.fragment,e),h(cl.$$.fragment,e),h(il.$$.fragment,e),h(dl.$$.fragment,e),h(qs.$$.fragment,e),h(Ds.$$.fragment,e),h(pl.$$.fragment,e),h(ml.$$.fragment,e),h(gl.$$.fragment,e),h(ul.$$.fragment,e),h(hl.$$.fragment,e),h(fl.$$.fragment,e),h(_l.$$.fragment,e),h(bl.$$.fragment,e),h(yl.$$.fragment,e),h(Tl.$$.fragment,e),h(Ml.$$.fragment,e),h(vl.$$.fragment,e),h(wl.$$.fragment,e),h(kl.$$.fragment,e),h($l.$$.fragment,e),h(jl.$$.fragment,e),h(xl.$$.fragment,e),Ou=!1},d(e){e&&(s($),s(b),s(_),s(r),s(k),s(Cm),s(Lm),s(kn),s(Fm),s($n),s(Vm),s(Gm),s(xn),s(Xm),s(Jn),s(Rm),s(Un),s(Sm),s(Bn),s(Nm),s(In),s(Em),s(Hm),s(zn),s(qm),s(Wn),s(Dm),s(Cn),s(Pm),s(Qm),s(Jt),s(Ym),s(Ut),s(Am),s(Bt),s(Om),s(It),s(Km),s(eg),s(Zt),s(tg),s(zt),s(sg),s(Wt),s(ng),s(Ct),s(og),s(Lt),s(rg),s(Ft),s(ag),s(Vt),s(lg),s(Gt),s(cg),s(Xt),s(ig),s(Rt),s(dg),s(pg),s(xe),s(mg),s(Je),s(gg),s(Ue),s(ug),s(hg),s(ao),s(fg),s(_g),s(ee),s(bg),s(W),s(yg),s(X),s(Tg),s(R),s(Mg),s(te),s(vg),s(se),s(wg),s(ne),s(kg),s(oe),s($g),s(re),s(jg),s(ae),s(xg),s(C),s(Jg),s(le),s(Ug),s(ce),s(Bg),s(Be),s(Ig),s(Ie),s(Zg),s(Ze),s(zg),s(ie),s(Wg),s(de),s(Cg),s(S),s(Lg),s(N),s(Fg),s(pe),s(Vg),s(E),s(Gg),s(H),s(Xg),s(me),s(Rg),s(ge),s(Sg),s(q),s(Ng),s(ue),s(Eg),s(he),s(Hg),s(D),s(qg),s(P),s(Dg),s(Q),s(Pg),s(Qg),s(ze),s(Yg),s(We),s(Ag),s(Ce),s(Og),s(Le),s(Kg),s(Fe),s(eu),s(Ve),s(tu),s(Ge),s(su),s(Xe),s(nu),s(Re),s(ou),s(Se),s(ru),s(Ne),s(au),s(Ee),s(lu),s(He),s(cu),s(qe),s(iu),s(De),s(du),s(pu),s(Pe),s(mu),s(Qe),s(gu),s(Ye),s(uu),s(Ae),s(hu),s(Oe),s(fu),s(Ke),s(_u),s(et),s(bu),s(tt),s(yu),s(st),s(Tu),s(nt),s(Mu),s(ot),s(vu),s(rt),s(wu),s(at),s(ku),s($u),s(va),s(ju),s(fe),s(xu),s(St),s(Ju),s(lt),s(Uu),s(ct),s(Bu),s(Iu),s(Za),s(Zu),s(U),s(zu),s(Nt),s(Wu),s(Et),s(Cu),s(_e),s(Lu),s(Fu),s(be),s(Vu),s(L),s(Gu),s(ye),s(Xu),s(Ru),s(it),s(Su),s(dt),s(Nu),s(Eu),s(z),s(Hu),s(Y),s(qu),s(Du),s(pt),s(Pu),s(Z),s(Qu),s(F),s(Yu),s(Te),s(Au),s(jm)),s(i),f(w,e),f(wn,e),f(jn,e),f(Zn,e),f(Ln,e),f(Fn),f(Vn),f(Gn),f(Xn),f(Rn,e),f(Sn),f(Nn),f(En),f(Hn),f(qn),f(Dn),f(Pn),f(Qn),f(Yn),f(An),f(On,e),f(Kn),f(eo),f(to),f(so),f(no),f(oo),f(ro,e),f(lo,e),f(co),f(At),f(io),f(po),f(Ot),f(Kt),f(mo),f(go),f(es),f(uo),f(ho),f(ts),f(fo),f(_o),f(ss),f(bo),f(yo),f(ns),f(To),f(Mo),f(os),f(vo),f(wo),f(rs),f(ko),f($o),f(as),f(jo),f(xo),f(ls),f(Jo),f(Uo),f(cs),f(Bo),f(Io),f(Zo),f(zo),f(is),f(Wo),f(Co),f(Lo),f(Fo),f(Vo),f(Go),f(Xo),f(Ro),f(ds),f(So),f(No),f(ps),f(Eo),f(Ho),f(ms),f(gs),f(qo),f(Do),f(us),f(hs),f(Po),f(Qo),f(fs),f(Yo),f(Ao),f(_s),f(Oo),f(Ko),f(bs),f(ys),f(er),f(tr),f(Ts),f(sr),f(nr),f(Ms),f(or),f(rr),f(vs),f(ws),f(ar),f(lr),f(ks),f(cr),f(ir),f($s),f(dr),f(pr),f(js),f(mr),f(gr),f(xs),f(ur),f(hr),f(Js),f(fr),f(_r,e),f(br),f(yr),f(Tr),f(Mr),f(vr),f(wr),f(kr),f($r),f(jr),f(xr),f(Jr),f(Ur),f(Br),f(Ir),f(Zr),f(zr),f(Wr),f(Cr),f(Lr),f(Fr),f(Vr),f(Gr),f(Xr),f(Rr),f(Sr),f(Nr),f(Er),f(Hr),f(qr),f(Dr),f(Pr,e),f(Qr),f(Yr),f(Ar),f(Or),f(Kr),f(ea),f(ta),f(sa),f(na),f(oa),f(ra),f(aa),f(la),f(ca),f(ia),f(da),f(pa),f(ma),f(ga),f(ua),f(ha),f(fa),f(_a),f(ba),f(ya),f(Ta),f(Ma,e),f(wa),f(ka),f($a),f(ja),f(xa),f(Ja),f(Ua),f(Ba),f(Ia,e),f(za),f(zs),f(Wa),f(Ca),f(La),f(Fa),f(Va),f(Ga),f(Xa),f(Ra),f(Sa),f(Na),f(Ea),f(Ha),f(qa,e),f(Da),f(Pa),f(Qa),f(Ya),f(Aa),f(Oa),f(Ka),f(el),f(tl),f(sl,e),f(nl),f(ol),f(rl,e),f(al),f(Rs),f(Ss),f(ll),f(cl),f(il),f(dl),f(qs),f(Ds),f(pl),f(ml,e),f(gl),f(ul),f(hl),f(fl),f(_l),f(bl),f(yl),f(Tl),f(Ml),f(vl),f(wl),f(kl),f($l),f(jl),f(xl)}}}const W2='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Utilities","local":"transformers.top_k_top_p_filtering","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2}],"depth":1}';function C2(j){return qk(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class N2 extends Dk{constructor(i){super(),Pk(this,i,C2,z2,Hk,{})}}export{N2 as component};
