import{s as Lv,o as Gv,n as J}from"../chunks/scheduler.9991993c.js";import{S as Cv,i as Xv,g as a,s as o,r as p,A as Rv,h as l,f as s,c as r,j as T,u as m,x as y,k as M,y as t,a as d,v as g,d as u,t as h,w as f}from"../chunks/index.7fc9a5e7.js";import{T as nn}from"../chunks/Tip.9de92fc6.js";import{D as v}from"../chunks/Docstring.8180f571.js";import{C as x}from"../chunks/CodeBlock.e11cba92.js";import{E as z}from"../chunks/ExampleCodeBlock.a03fccd6.js";import{H as Y}from"../chunks/Heading.e3de321f.js";function Nv($){let i,j=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=a("p"),i.innerHTML=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-nbt45a"&&(i.innerHTML=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function Sv($){let i,j=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=a("p"),i.innerHTML=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1uojnuk"&&(i.innerHTML=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function Ev($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Hv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function qv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Pv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Dv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Qv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkp1c3QlMjB3YW50ZWQlMjB0byUyMGxldCUyMHlvdSUyMGtub3clMkMlMjBJJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMExldCdzJTIwY29uc2lkZXIlMjB0aGF0JTIwd2UlMjB3YW50JTIwc2hvcnQlMjBzZW50ZW5jZXMlMkMlMjBzbyUyMHdlJTIwbGltaXQlMjAlNjBtYXhfbGVuZ3RoJTNEMzAlNjAuJTIwSG93ZXZlciUyQyUyMHdlJTIwb2JzZXJ2ZSUyMHRoYXQlMjB0aGUlMjBhbnN3ZXIlMEElMjMlMjB0ZW5kcyUyMHRvJTIwZW5kJTIwYWJydXB0bHkuJTBBc2V0X3NlZWQoMSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjklMkMlMjBtYXhfbGVuZ3RoJTNEMzAlMkMlMjBwYWRfdG9rZW5faWQlM0Q1MDI1NiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBUbyUyMHByb21vdGUlMjB0aGUlMjBhcHBlYXJhbmNlJTIwb2YlMjB0aGUlMjBFT1MlMjB0b2tlbiUyMGF0JTIwdGhlJTIwcmlnaHQlMjB0aW1lJTJDJTIwd2UlMjBhZGQlMjB0aGUlMjAlNjBleHBvbmVudGlhbF9kZWNheV9sZW5ndGhfcGVuYWx0eSUyMCUzRCUwQSUyMyUyMChzdGFydF9pbmRleCUyQyUyMGRlY2F5X2ZhY3RvciklNjAuJTIwSW5zdGVhZCUyMG9mJTIwY3V0dGluZyUyMGF0JTIwbWF4X3Rva2VucyUyQyUyMHRoZSUyMG91dHB1dCUyMGNvbWVzJTIwdG8lMjBhbiUyMGVuZCUyMGJlZm9yZSUyMGFuZCUyMHVzdWFsbHklMEElMjMlMjB3aXRoJTIwbW9yZSUyMG1lYW5pbmcuJTIwV2hhdCUyMGhhcHBlbnMlMjBpcyUyMHRoYXQlMjBzdGFydGluZyUyMGZyb20lMjAlNjBzdGFydF9pbmRleCU2MCUyMHRoZSUyMEVPUyUyMHRva2VuJTIwc2NvcmUlMjB3aWxsJTIwYmUlMjBpbmNyZWFzZWQlMEElMjMlMjBieSUyMCU2MGRlY2F5X2ZhY3RvciU2MCUyMGV4cG9uZW50aWFsbHkuJTIwSG93ZXZlciUyQyUyMGlmJTIweW91JTIwc2V0JTIwYSUyMGhpZ2glMjBkZWNheSUyMGZhY3RvciUyQyUyMHlvdSUyMG1heSUyMGFsc28lMjBlbmQlMjB1cCUyMHdpdGglMjBhYnJ1cHRseSUwQSUyMyUyMGVuZGluZyUyMHNlcXVlbmNlcy4lMEFzZXRfc2VlZCgxKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0QzMCUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbl9pZCUzRDUwMjU2JTJDJTBBJTIwJTIwJTIwJTIwZXhwb25lbnRpYWxfZGVjYXlfbGVuZ3RoX3BlbmFsdHklM0QoMTUlMkMlMjAxLjYpJTJDJTBBKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBhJTIwc21hbGwlMjBkZWNheSUyMGZhY3RvciUyQyUyMHlvdSUyMHdpbGwlMjBoYXZlJTIwYSUyMGhpZ2hlciUyMGNoYW5jZSUyMG9mJTIwZ2V0dGluZyUyMGElMjBtZWFuaW5nZnVsJTIwc2VxdWVuY2UuJTBBc2V0X3NlZWQoMSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjklMkMlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW5faWQlM0Q1MDI1NiUyQyUwQSUyMCUyMCUyMCUyMGV4cG9uZW50aWFsX2RlY2F5X2xlbmd0aF9wZW5hbHR5JTNEKDE1JTJDJTIwMS4wMSklMkMlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Yv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Av($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Ov($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This Whisper model forces the generation to start with \`50362\` at the first position by default, i.e.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`&quot;forced_decoder_ids&quot;: [[1, 50362]]\`. This means all other tokens are masked out.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">0.</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`forced_decoder_ids\`, we stop seeing that effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, forced_decoder_ids=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">19.3140</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Kv($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function ew($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">816.3250</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">1.0000</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function tw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function sw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function nw($){let i,j=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-15bvr1j"&&(i.innerHTML=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function ow($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJbiUyMGElMjB3b3JkJTJDJTIwdGhlJTIwY2FrZSUyMGlzJTIwYSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENSUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMHRha2UlMjB0aGUlMjBiYWQlMjB3b3JkcyUyMG91dC4lMjBQbGVhc2UlMjBub3RlJTIwdGhhdCUyMHRoZSUyMHRva2VuaXplciUyMGlzJTIwaW5pdGlhbGl6ZWQlMjBkaWZmZXJlbnRseSUwQXRva2VuaXplcl93aXRoX3ByZWZpeF9zcGFjZSUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTBBJTBBJTBBZGVmJTIwZ2V0X3Rva2Vuc19hc19saXN0KHdvcmRfbGlzdCklM0ElMEElMjAlMjAlMjAlMjAlMjJDb252ZXJ0cyUyMGElMjBzZXF1ZW5jZSUyMG9mJTIwd29yZHMlMjBpbnRvJTIwYSUyMGxpc3QlMjBvZiUyMHRva2VucyUyMiUwQSUyMCUyMCUyMCUyMHRva2Vuc19saXN0JTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9saXN0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVkX3dvcmQlMjAlM0QlMjB0b2tlbml6ZXJfd2l0aF9wcmVmaXhfc3BhY2UoJTVCd29yZCU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5zX2xpc3QuYXBwZW5kKHRva2VuaXplZF93b3JkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vuc19saXN0JTBBJTBBJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMGdldF90b2tlbnNfYXNfbGlzdCh3b3JkX2xpc3QlM0QlNUIlMjJtZXNzJTIyJTVEKSUwQW91dHB1dF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBiYWRfd29yZHNfaWRzJTNEYmFkX3dvcmRzX2lkcyUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function rw($){let i,j=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=a("p"),i.innerHTML=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-5zfsi9"&&(i.innerHTML=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function aw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function lw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjBpdCUyMGNvbnRpbnVlcyUyMGdlbmVyYXRpbmclMjBhY2NvcmRpbmclMjB0byUyMHRoZSUyMG1vZGVsJ3MlMjBsb2dpdHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMGNvbnRyYWluJTIwaXQlMjB3aXRoJTIwJTYwcHJlZml4X2FsbG93ZWRfdG9rZW5zX2ZuJTYwJTIwdG8lMjBmb3JjZSUyMGElMjBjZXJ0YWluJTIwYmVoYXZpb3IlMjBiYXNlZCUyMG9uJTIwYSUyMHByZWZpeC4lMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMHdlJTIwY2FuJTIwZm9yY2UlMjBhbiUyMGVudGlyZSUyMGVudGl0eSUyMHRvJTIwYmUlMjBnZW5lcmF0ZWQlMjB3aGVuJTIwaXRzJTIwYmVnaW5uaW5nJTIwaXMlMjBkZXRlY3RlZC4lMEFlbnRpdHklMjAlM0QlMjAlMjB0b2tlbml6ZXIoJTIyJTIwQm9iJTIwTWFybGV5JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTVCMCU1RCUyMCUyMCUyMyUyMDMlMjB0b2tlbnMlMEFkZWYlMjBwcmVmaXhfYWxsb3dlZF90b2tlbnNfZm4oYmF0Y2hfaWQlMkMlMjBpbnB1dF9pZHMpJTNBJTBBJTIwJTIwJTIwJTIwJycnJTBBJTIwJTIwJTIwJTIwQXR0ZW1wdHMlMjB0byUyMGdlbmVyYXRlJTIwJ0JvYiUyME1hcmxleSclMjB3aGVuJTIwJ0JvYiclMjBpcyUyMGRldGVjdGVkLiUwQSUyMCUyMCUyMCUyMEluJTIwdGhpcyUyMGNhc2UlMkMlMjAlNjBiYXRjaF9pZCU2MCUyMGlzJTIwbm90JTIwdXNlZCUyQyUyMGJ1dCUyMHlvdSUyMGNhbiUyMHNldCUyMHJ1bGVzJTIwZm9yJTIwZWFjaCUyMGJhdGNoJTIwbWVtYmVyLiUwQSUyMCUyMCUyMCUyMCcnJyUwQSUyMCUyMCUyMCUyMGlmJTIwaW5wdXRfaWRzJTVCLTElNUQlMjAlM0QlM0QlMjBlbnRpdHklNUIwJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW50aXR5JTVCMSU1RCUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpbnB1dF9pZHMlNUItMiU1RCUyMCUzRCUzRCUyMGVudGl0eSU1QjAlNUQlMjBhbmQlMjBpbnB1dF9pZHMlNUItMSU1RCUyMCUzRCUzRCUyMGVudGl0eSU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBlbnRpdHklNUIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbGlzdChyYW5nZSh0b2tlbml6ZXIudm9jYWJfc2l6ZSkpJTIwJTIwJTIzJTIwSWYlMjBubyUyMG1hdGNoJTJDJTIwYWxsb3clMjBhbGwlMjB0b2tlbnMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBwcmVmaXhfYWxsb3dlZF90b2tlbnNfZm4lM0RwcmVmaXhfYWxsb3dlZF90b2tlbnNfZm4pJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity =  tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function cw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function iw($){let i,j=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=a("p"),i.innerHTML=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-16cusgy"&&(i.innerHTML=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function dw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function pw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function mw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">5.7738</span>)`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function gw($){let i,j=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=a("p"),i.innerHTML=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1byeoum"&&(i.innerHTML=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function uw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function hw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, G, H, I. A, M

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function fw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function _w($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function bw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function yw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function Tw($){let i,j;return i=new x({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){p(i.$$.fragment)},l(b){m(i.$$.fragment,b)},m(b,_){g(i,b,_),j=!0},p:J,i(b){j||(u(i.$$.fragment,b),j=!0)},o(b){h(i.$$.fragment,b),j=!1},d(b){f(i,b)}}}function Mw($){let i,j="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function vw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function ww($){let i,j="The API for the streamer classes is still under development and may change in the future.";return{c(){i=a("p"),i.textContent=j},l(b){i=l(b,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=j)},m(b,_){d(b,i,_)},p:J,d(b){b&&s(i)}}}function kw($){let i,j="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=a("p"),i.textContent=j,b=o(),p(_.$$.fragment)},l(n){i=l(n,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),b=r(n),m(_.$$.fragment,n)},m(n,k){d(n,i,k),d(n,b,k),g(_,n,k),w=!0},p:J,i(n){w||(u(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(s(i),s(b)),f(_,n)}}}function jw($){let i,j,b,_,w,n,k,Ab='此页面列出了所有由 <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>。',Vp,on,Lp,rn,Ob=`<a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 的输出是 <a href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> 的一个子类的实例。这个输出是一种包含 <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 返回的所有信息数据结构，但也可以作为元组或字典使用。
这里是一个例子：`,Gp,an,Cp,ln,Kb='<code>generation_output</code> 的对象是 <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a> 的一个实例，从该类的文档中我们可以看到，这意味着它具有以下属性：',Xp,cn,ey="<li><code>sequences</code>: 生成的tokens序列</li> <li><code>scores</code>（可选）: 每个生成步骤的语言建模头的预测分数</li> <li><code>hidden_states</code>（可选）: 每个生成步骤模型的hidden states</li> <li><code>attentions</code>（可选）: 每个生成步骤模型的注意力权重</li>",Rp,dn,ty="在这里，由于我们传递了 <code>output_scores=True</code>，我们具有 <code>scores</code> 属性。但我们没有 <code>hidden_states</code> 和 <code>attentions</code>，因为没有传递 <code>output_hidden_states=True</code> 或 <code>output_attentions=True</code>。",Np,pn,sy="您可以像通常一样访问每个属性，如果该属性未被模型返回，则将获得 <code>None</code>。例如，在这里 <code>generation_output.scores</code> 是语言建模头的所有生成预测分数，而 <code>generation_output.attentions</code> 为 <code>None</code>。",Sp,mn,ny="当我们将 <code>generation_output</code> 对象用作元组时，它只保留非 <code>None</code> 值的属性。例如，在这里它有两个元素，<code>loss</code> 然后是 <code>logits</code>，所以",Ep,gn,Hp,un,oy="将返回元组<code>(generation_output.sequences, generation_output.scores)</code>。",qp,hn,ry="当我们将<code>generation_output</code>对象用作字典时，它只保留非<code>None</code>的属性。例如，它有两个键，分别是<code>sequences</code>和<code>scores</code>。",Pp,fn,ay="我们在此记录所有输出类型。",Dp,_n,Qp,vt,bn,mu,dl,ly="Outputs of decoder-only generation models, when using non-beam methods.",Yp,wt,yn,gu,pl,cy="Outputs of encoder-decoder generation models, when using non-beam methods.",Ap,kt,Tn,uu,ml,iy="Outputs of decoder-only generation models, when using beam methods.",Op,jt,Mn,hu,gl,dy="Outputs of encoder-decoder generation models, when using beam methods.",Kp,vn,em,$t,wn,fu,ul,py=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,tm,Jt,kn,_u,hl,my="Base class for outputs of decoder-only generation models using greedy search.",sm,xt,jn,bu,fl,gy=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,nm,Ut,$n,yu,_l,uy="Base class for outputs of decoder-only generation models using sampling.",om,zt,Jn,Tu,bl,hy=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,rm,Bt,xn,Mu,yl,fy="Base class for outputs of decoder-only generation models using beam search.",am,It,Un,vu,Tl,_y=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,lm,Zt,zn,wu,Ml,by="Base class for outputs of decoder-only generation models using beam sample.",cm,Wt,Bn,ku,vl,yy=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,im,Ft,In,ju,wl,Ty="Base class for outputs of decoder-only generation models using contrastive search.",dm,Zn,pm,ve,Wn,$u,kl,My="Flax Base class for outputs of decoder-only generation models using sampling.",Ju,Nt,Fn,xu,jl,vy="“Returns a new object replacing the specified fields with new values.",mm,we,Vn,Uu,$l,wy="Flax Base class for outputs of decoder-only generation models using greedy search.",zu,St,Ln,Bu,Jl,ky="“Returns a new object replacing the specified fields with new values.",gm,ke,Gn,Iu,xl,jy="Flax Base class for outputs of decoder-only generation models using greedy search.",Zu,Et,Cn,Wu,Ul,$y="“Returns a new object replacing the specified fields with new values.",um,Xn,hm,Rn,Jy='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> 可以用于修改语言模型头的预测分数以进行生成',fm,Nn,_m,A,Sn,Fu,zl,xy='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',Vu,Ht,Lu,Bl,En,bm,Z,Hn,Gu,Il,Uy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Cu,Zl,zy='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',Xu,qt,Ru,Pt,Nu,Wl,qn,ym,L,Pn,Su,Fl,By=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,Eu,Vl,Iy=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,Hu,Dt,qu,Ll,Dn,Tm,G,Qn,Pu,Gl,Zy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,Du,Cl,Wy=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,Qu,Qt,Yu,Xl,Yn,Mm,O,An,Au,Rl,Fy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,Ou,Yt,Ku,Nl,On,vm,K,Kn,eh,Sl,Vy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,th,At,sh,El,eo,wm,ee,to,nh,Hl,Ly=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,oh,Ot,rh,ql,so,km,te,no,ah,Pl,Gy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,lh,Kt,ch,Dl,oo,jm,se,ro,ih,Ql,Cy='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',dh,es,ph,Yl,ao,$m,ne,lo,mh,Al,Xy=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before generation. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,gh,ts,uh,Ol,co,Jm,W,io,hh,Kl,Ry='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',fh,ec,Ny=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search()</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,_h,tc,Sy=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,bh,ss,yh,sc,po,xm,oe,mo,Th,nc,Ey=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,Mh,oc,Hy=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,vh,rc,go,Um,re,uo,wh,ac,qy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,kh,ns,jh,lc,ho,zm,je,fo,$h,cc,Py="Abstract base class for all logit processors that can be applied during generation.",Jh,ic,_o,Bm,$e,bo,xh,dc,Dy=`This class can be used to create a list of <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,Uh,pc,yo,Im,Je,To,zh,mc,Qy="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Bh,gc,Mo,Zm,ae,vo,Ih,uc,Yy=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,Zh,os,Wh,hc,wo,Wm,le,ko,Fh,fc,Ay=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,Vh,rs,Lh,_c,jo,Fm,C,$o,Gh,bc,Oy='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',Ch,as,Xh,ls,Rh,yc,Jo,Vm,X,xo,Nh,Tc,Ky=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Sh,cs,Eh,is,Hh,Mc,Uo,Lm,ce,zo,qh,vc,eT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,Ph,ds,Dh,wc,Bo,Gm,R,Io,Qh,kc,tT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,Yh,jc,sT=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,Ah,ps,Oh,$c,Zo,Cm,N,Wo,Kh,Jc,nT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,ef,ms,tf,gs,sf,xc,Fo,Xm,ie,Vo,nf,Uc,oT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,of,us,rf,zc,Lo,Rm,de,Go,af,Bc,rT=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,lf,hs,cf,Ic,Co,Nm,S,Xo,df,Zc,aT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,pf,fs,mf,_s,gf,Wc,Ro,Sm,pe,No,uf,Fc,lT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used together
with <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,hf,bs,ff,Vc,So,Em,me,Eo,_f,Lc,cT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off. Often
used together with <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,bf,ys,yf,Gc,Ho,Hm,E,qo,Tf,Cc,iT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens whose
log probability is close to the entropy of the token probability distribution. This means that the most likely
tokens may be discarded in the process.`,Mf,Xc,dT='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',vf,Ts,wf,Rc,Po,qm,H,Do,kf,Nc,pT=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,jf,Sc,mT='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',$f,Ms,Jf,Ec,Qo,Pm,q,Yo,xf,Hc,gT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,Uf,qc,uT='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',zf,vs,Bf,Pc,Ao,Dm,Oo,Qm,xe,Ko,If,Dc,hT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Zf,Qc,er,Ym,Ue,tr,Wf,Yc,fT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Ff,Ac,sr,Am,ze,nr,Vf,Oc,_T=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,Lf,Kc,or,Om,Be,rr,Gf,ei,bT="Abstract base class for all logit processors that can be applied during generation.",Cf,ws,ar,Xf,ti,yT="TF method for processing logits.",Km,Ie,lr,Rf,si,TT=`This class can be used to create a list of <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Nf,ni,cr,eg,Ze,ir,Sf,oi,MT="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Ef,ks,dr,Hf,ri,vT="TF method for warping logits.",tg,We,pr,qf,ai,wT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Pf,li,mr,sg,Fe,gr,Df,ci,kT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Qf,ii,ur,ng,Ve,hr,Yf,di,jT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Af,pi,fr,og,Le,_r,Of,mi,$T='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',Kf,gi,br,rg,Ge,yr,e_,ui,JT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,t_,hi,Tr,ag,Ce,Mr,s_,fi,xT=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,n_,_i,vr,lg,Xe,wr,o_,bi,UT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',r_,yi,kr,cg,Re,jr,a_,Ti,zT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',l_,Mi,$r,ig,Ne,Jr,c_,vi,BT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',i_,wi,xr,dg,Ur,pg,Se,zr,d_,ki,IT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',p_,ji,Br,mg,Ee,Ir,m_,$i,ZT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',g_,Ji,Zr,gg,He,Wr,u_,xi,WT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,h_,Ui,Fr,ug,qe,Vr,f_,zi,FT="Abstract base class for all logit processors that can be applied during generation.",__,js,Lr,b_,Bi,VT="Flax method for processing logits.",hg,Pe,Gr,y_,Ii,LT=`This class can be used to create a list of <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,T_,Zi,Cr,fg,De,Xr,M_,Wi,GT="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",v_,$s,Rr,w_,Fi,CT="Flax method for warping logits.",_g,Qe,Nr,k_,Vi,XT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',j_,Li,Sr,bg,Ye,Er,$_,Gi,RT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,J_,Ci,Hr,yg,Ae,qr,x_,Xi,NT=`<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,U_,Ri,Pr,Tg,Oe,Dr,z_,Ni,ST='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',B_,Si,Qr,Mg,Ke,Yr,I_,Ei,ET='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Z_,Hi,Ar,vg,et,Or,W_,qi,HT='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',F_,Pi,Kr,wg,tt,ea,V_,Di,qT=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,L_,Qi,ta,kg,sa,jg,na,PT='可以使用<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>来更改停止生成的时间（除了EOS token以外的方法）。请注意，这仅适用于我们的PyTorch实现。',$g,ge,oa,G_,Yi,DT="Abstract base class for all stopping criteria that can be applied during generation.",C_,Ai,QT="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",X_,Oi,ra,Jg,Vt,aa,R_,Ki,la,xg,st,ca,N_,ed,YT=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,S_,td,ia,Ug,nt,da,E_,sd,AT=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,H_,nd,pa,zg,ma,Bg,ga,OT='可以使用<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.Constraint">Constraint</a>来强制生成结果包含输出中的特定tokens或序列。请注意，这仅适用于我们的PyTorch实现。',Ig,U,ua,q_,od,KT=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,P_,rd,eM="All classes that inherit Constraint must follow the requirement that",D_,Js,Q_,ad,tM="will always terminate (halt).",Y_,xs,ha,A_,ld,sM="When called, returns the token that would take this constraint one step closer to being fulfilled.",O_,Us,fa,K_,cd,nM="Creates a new instance of this constraint.",eb,zs,_a,tb,id,oM="Reads in a token and returns whether it creates progress.",sb,Bs,ba,nb,dd,rM="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",ob,Is,ya,rb,pd,aM=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,ab,Zs,Ta,lb,md,lM="Tests whether this constraint has been properly defined.",cb,mt,Ma,ib,gd,cM=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,db,ud,iM=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Zg,Lt,va,pb,hd,dM='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Wg,Gt,wa,mb,fd,pM='A special <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Fg,ue,ka,gb,_d,mM="A class for beam scorers to track its progress through a list of constraints.",ub,V,ja,hb,bd,gM=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,fb,yd,uM=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,_b,Td,hM="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",bb,Md,fM=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,yb,vd,_M=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,Tb,Ws,$a,Mb,wd,bM="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Vg,Ja,Lg,he,xa,vb,kd,yM=`Abstract base class for all beam scorers that are used for <code>beam_search()</code> and
<code>beam_sample()</code>.`,wb,jd,Ua,kb,$d,za,Gg,F,Ba,jb,Jd,TM='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',$b,xd,MM=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Jb,Ud,vM=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,xb,zd,Ia,Ub,Bd,Za,Cg,fe,Wa,zb,Id,wM='<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Bb,Zd,Fa,Ib,Wd,Va,Xg,La,Rg,ot,Ga,Zb,Fd,kM="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Wb,Vd,jM='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Ng,rt,Ca,Fb,Ld,$M="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Vb,Gd,JM='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Sg,Xa,Eg,I,Ra,Lb,Cd,xM="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Gb,Fs,Cb,Vs,Xb,Ls,Na,Rb,Xd,UM="Flushes any remaining cache and prints a newline to stdout.",Nb,Gs,Sa,Sb,Rd,zM="Prints the new text to stdout. If the stream is ending, also prints a newline.",Eb,Cs,Ea,Hb,Nd,BM="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Hg,P,Ha,qb,Sd,IM=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Pb,Xs,Db,Rs,Qb,Ns,qa,Yb,Ed,ZM="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",qg,Jp,Pg;return w=new Y({props:{title:"用于生成的工具",local:"用于生成的工具",headingTag:"h1"}}),on=new Y({props:{title:"生成输出",local:"生成输出",headingTag:"h2"}}),an=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),gn=new x({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),_n=new Y({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),bn=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L100"}}),yn=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L140"}}),Tn=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L192"}}),Mn=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"logits",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code> is passed or when <code>config.output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L240"}}),vn=new Y({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),wn=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L85"}}),kn=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L57"}}),jn=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L155"}}),$n=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L127"}}),Jn=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L232"}}),xn=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L197"}}),Un=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L317"}}),zn=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L282"}}),Bn=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L393"}}),In=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L366"}}),Zn=new Y({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Wn=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L68"}}),Fn=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Vn=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L54"}}),Ln=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Gn=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L82"}}),Cn=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Xn=new Y({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Nn=new Y({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),Sn=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2011"}}),Ht=new nn({props:{warning:!0,$$slots:{default:[Nv]},$$scope:{ctx:$}}}),En=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2040"}}),Hn=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1947"}}),qt=new nn({props:{warning:!0,$$slots:{default:[Sv]},$$scope:{ctx:$}}}),Pt=new z({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Ev]},$$scope:{ctx:$}}}),qn=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1995",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Pn=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L874"}}),Dt=new z({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[Hv]},$$scope:{ctx:$}}}),Dn=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qn=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L342"}}),Qt=new z({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[qv]},$$scope:{ctx:$}}}),Yn=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L386",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),An=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L603"}}),Yt=new z({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[Pv]},$$scope:{ctx:$}}}),On=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L656",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kn=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L670"}}),At=new z({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[Dv]},$$scope:{ctx:$}}}),eo=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L733",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1494"}}),Ot=new z({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[Qv]},$$scope:{ctx:$}}}),so=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1378"}}),Kt=new z({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[Yv]},$$scope:{ctx:$}}}),oo=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1423"}}),es=new z({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[Av]},$$scope:{ctx:$}}}),ao=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new v({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1710"}}),ts=new z({props:{anchor:"transformers.ForceTokensLogitsProcessor.example",$$slots:{default:[Ov]},$$scope:{ctx:$}}}),co=new v({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1245"}}),ss=new z({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[Kv]},$$scope:{ctx:$}}}),po=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mo=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1473"}}),go=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1585"}}),ns=new z({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[ew]},$$scope:{ctx:$}}}),ho=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1616",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L44"}}),_o=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L47",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L64"}}),yo=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L71",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),To=new v({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L54"}}),Mo=new v({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L57",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vo=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L102"}}),os=new z({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[tw]},$$scope:{ctx:$}}}),wo=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L151",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ko=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L160"}}),rs=new z({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[sw]},$$scope:{ctx:$}}}),jo=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1090"}}),as=new nn({props:{$$slots:{default:[nw]},$$scope:{ctx:$}}}),ls=new z({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[ow]},$$scope:{ctx:$}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L816"}}),cs=new nn({props:{$$slots:{default:[rw]},$$scope:{ctx:$}}}),is=new z({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[aw]},$$scope:{ctx:$}}}),Uo=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1177"}}),ds=new z({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[lw]},$$scope:{ctx:$}}}),Bo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Io=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L288"}}),ps=new z({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[cw]},$$scope:{ctx:$}}}),Zo=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L331",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wo=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": Dict"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L942"}}),ms=new nn({props:{$$slots:{default:[iw]},$$scope:{ctx:$}}}),gs=new z({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[dw]},$$scope:{ctx:$}}}),Fo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vo=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1622"}}),us=new z({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[pw]},$$scope:{ctx:$}}}),Lo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1664",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Go=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1672"}}),hs=new z({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[mw]},$$scope:{ctx:$}}}),Co=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1704",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xo=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L222"}}),fs=new nn({props:{$$slots:{default:[gw]},$$scope:{ctx:$}}}),_s=new z({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[uw]},$$scope:{ctx:$}}}),Ro=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L282",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L462"}}),bs=new z({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[hw]},$$scope:{ctx:$}}}),So=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Eo=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L397"}}),ys=new z({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[fw]},$$scope:{ctx:$}}}),Ho=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qo=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L515"}}),Ts=new z({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[_w]},$$scope:{ctx:$}}}),Po=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Do=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2055"}}),Ms=new z({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[bw]},$$scope:{ctx:$}}}),Qo=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2161"}}),Yo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1761"}}),vs=new z({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[yw]},$$scope:{ctx:$}}}),Ao=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1843",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Oo=new Y({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Ko=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),er=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),tr=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),sr=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),nr=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L551"}}),or=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L567"}}),rr=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),ar=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lr=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),cr=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ir=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),dr=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),pr=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),mr=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),gr=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),ur=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),hr=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),fr=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),_r=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),br=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),yr=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),Tr=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),Mr=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L535"}}),vr=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L542"}}),wr=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),kr=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),jr=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),$r=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),Jr=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),xr=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),Ur=new Y({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),zr=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L194"}}),Br=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L206"}}),Ir=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L216"}}),Zr=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L231"}}),Wr=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L315"}}),Fr=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L337"}}),Vr=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L50"}}),Lr=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gr=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L72"}}),Cr=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xr=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L61"}}),Rr=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Nr=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L241"}}),Sr=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L262"}}),Er=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L271"}}),Hr=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L288"}}),qr=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L296"}}),Pr=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L309"}}),Dr=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L95"}}),Qr=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L110"}}),Yr=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L159"}}),Ar=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L179"}}),Or=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L115"}}),Kr=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L139"}}),ea=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L363"}}),ta=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L397"}}),sa=new Y({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),oa=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L38"}}),ra=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <code>AutoTokenizer</code>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L45",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),aa=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L132"}}),la=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <code>AutoTokenizer</code>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ca=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L50"}}),ia=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <code>AutoTokenizer</code>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L66",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),da=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L109"}}),pa=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <code>AutoTokenizer</code>. See <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ma=new Y({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),ua=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),Js=new z({props:{anchor:"transformers.Constraint.example",$$slots:{default:[Tw]},$$scope:{ctx:$}}}),ha=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),fa=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),_a=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L60"}}),ba=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L104"}}),ya=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L94"}}),Ta=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),Ma=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),va=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L129"}}),wa=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L261"}}),ka=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L351"}}),ja=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L383"}}),$a=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L418"}}),Ja=new Y({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),xa=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),Ua=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>group_beam_search()</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),za=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Ba=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),Ia=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),Za=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L318"}}),Wa=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/zh/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/zh/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L415"}}),Fa=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L509",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Va=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L807"}}),La=new Y({props:{title:"Utilities",local:"transformers.top_k_top_p_filtering",headingTag:"h2"}}),Ga=new v({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L4786"}}),Ca=new v({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L3091"}}),Xa=new Y({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),Ra=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L38"}}),Fs=new nn({props:{warning:!0,$$slots:{default:[Mw]},$$scope:{ctx:$}}}),Vs=new z({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[vw]},$$scope:{ctx:$}}}),Na=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L116"}}),Sa=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L130"}}),Ea=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L82"}}),Ha=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L159"}}),Xs=new nn({props:{warning:!0,$$slots:{default:[ww]},$$scope:{ctx:$}}}),Rs=new z({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[kw]},$$scope:{ctx:$}}}),qa=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L213"}}),{c(){i=a("meta"),j=o(),b=a("p"),_=o(),p(w.$$.fragment),n=o(),k=a("p"),k.innerHTML=Ab,Vp=o(),p(on.$$.fragment),Lp=o(),rn=a("p"),rn.innerHTML=Ob,Gp=o(),p(an.$$.fragment),Cp=o(),ln=a("p"),ln.innerHTML=Kb,Xp=o(),cn=a("ul"),cn.innerHTML=ey,Rp=o(),dn=a("p"),dn.innerHTML=ty,Np=o(),pn=a("p"),pn.innerHTML=sy,Sp=o(),mn=a("p"),mn.innerHTML=ny,Ep=o(),p(gn.$$.fragment),Hp=o(),un=a("p"),un.innerHTML=oy,qp=o(),hn=a("p"),hn.innerHTML=ry,Pp=o(),fn=a("p"),fn.textContent=ay,Dp=o(),p(_n.$$.fragment),Qp=o(),vt=a("div"),p(bn.$$.fragment),mu=o(),dl=a("p"),dl.textContent=ly,Yp=o(),wt=a("div"),p(yn.$$.fragment),gu=o(),pl=a("p"),pl.textContent=cy,Ap=o(),kt=a("div"),p(Tn.$$.fragment),uu=o(),ml=a("p"),ml.textContent=iy,Op=o(),jt=a("div"),p(Mn.$$.fragment),hu=o(),gl=a("p"),gl.textContent=dy,Kp=o(),p(vn.$$.fragment),em=o(),$t=a("div"),p(wn.$$.fragment),fu=o(),ul=a("p"),ul.textContent=py,tm=o(),Jt=a("div"),p(kn.$$.fragment),_u=o(),hl=a("p"),hl.textContent=my,sm=o(),xt=a("div"),p(jn.$$.fragment),bu=o(),fl=a("p"),fl.textContent=gy,nm=o(),Ut=a("div"),p($n.$$.fragment),yu=o(),_l=a("p"),_l.textContent=uy,om=o(),zt=a("div"),p(Jn.$$.fragment),Tu=o(),bl=a("p"),bl.textContent=hy,rm=o(),Bt=a("div"),p(xn.$$.fragment),Mu=o(),yl=a("p"),yl.textContent=fy,am=o(),It=a("div"),p(Un.$$.fragment),vu=o(),Tl=a("p"),Tl.textContent=_y,lm=o(),Zt=a("div"),p(zn.$$.fragment),wu=o(),Ml=a("p"),Ml.textContent=by,cm=o(),Wt=a("div"),p(Bn.$$.fragment),ku=o(),vl=a("p"),vl.textContent=yy,im=o(),Ft=a("div"),p(In.$$.fragment),ju=o(),wl=a("p"),wl.textContent=Ty,dm=o(),p(Zn.$$.fragment),pm=o(),ve=a("div"),p(Wn.$$.fragment),$u=o(),kl=a("p"),kl.textContent=My,Ju=o(),Nt=a("div"),p(Fn.$$.fragment),xu=o(),jl=a("p"),jl.textContent=vy,mm=o(),we=a("div"),p(Vn.$$.fragment),Uu=o(),$l=a("p"),$l.textContent=wy,zu=o(),St=a("div"),p(Ln.$$.fragment),Bu=o(),Jl=a("p"),Jl.textContent=ky,gm=o(),ke=a("div"),p(Gn.$$.fragment),Iu=o(),xl=a("p"),xl.textContent=jy,Zu=o(),Et=a("div"),p(Cn.$$.fragment),Wu=o(),Ul=a("p"),Ul.textContent=$y,um=o(),p(Xn.$$.fragment),hm=o(),Rn=a("p"),Rn.innerHTML=Jy,fm=o(),p(Nn.$$.fragment),_m=o(),A=a("div"),p(Sn.$$.fragment),Fu=o(),zl=a("p"),zl.innerHTML=xy,Vu=o(),p(Ht.$$.fragment),Lu=o(),Bl=a("div"),p(En.$$.fragment),bm=o(),Z=a("div"),p(Hn.$$.fragment),Gu=o(),Il=a("p"),Il.innerHTML=Uy,Cu=o(),Zl=a("p"),Zl.innerHTML=zy,Xu=o(),p(qt.$$.fragment),Ru=o(),p(Pt.$$.fragment),Nu=o(),Wl=a("div"),p(qn.$$.fragment),ym=o(),L=a("div"),p(Pn.$$.fragment),Su=o(),Fl=a("p"),Fl.innerHTML=By,Eu=o(),Vl=a("p"),Vl.textContent=Iy,Hu=o(),p(Dt.$$.fragment),qu=o(),Ll=a("div"),p(Dn.$$.fragment),Tm=o(),G=a("div"),p(Qn.$$.fragment),Pu=o(),Gl=a("p"),Gl.innerHTML=Zy,Du=o(),Cl=a("p"),Cl.textContent=Wy,Qu=o(),p(Qt.$$.fragment),Yu=o(),Xl=a("div"),p(Yn.$$.fragment),Mm=o(),O=a("div"),p(An.$$.fragment),Au=o(),Rl=a("p"),Rl.innerHTML=Fy,Ou=o(),p(Yt.$$.fragment),Ku=o(),Nl=a("div"),p(On.$$.fragment),vm=o(),K=a("div"),p(Kn.$$.fragment),eh=o(),Sl=a("p"),Sl.innerHTML=Vy,th=o(),p(At.$$.fragment),sh=o(),El=a("div"),p(eo.$$.fragment),wm=o(),ee=a("div"),p(to.$$.fragment),nh=o(),Hl=a("p"),Hl.innerHTML=Ly,oh=o(),p(Ot.$$.fragment),rh=o(),ql=a("div"),p(so.$$.fragment),km=o(),te=a("div"),p(no.$$.fragment),ah=o(),Pl=a("p"),Pl.innerHTML=Gy,lh=o(),p(Kt.$$.fragment),ch=o(),Dl=a("div"),p(oo.$$.fragment),jm=o(),se=a("div"),p(ro.$$.fragment),ih=o(),Ql=a("p"),Ql.innerHTML=Cy,dh=o(),p(es.$$.fragment),ph=o(),Yl=a("div"),p(ao.$$.fragment),$m=o(),ne=a("div"),p(lo.$$.fragment),mh=o(),Al=a("p"),Al.innerHTML=Xy,gh=o(),p(ts.$$.fragment),uh=o(),Ol=a("div"),p(co.$$.fragment),Jm=o(),W=a("div"),p(io.$$.fragment),hh=o(),Kl=a("p"),Kl.innerHTML=Ry,fh=o(),ec=a("p"),ec.innerHTML=Ny,_h=o(),tc=a("p"),tc.innerHTML=Sy,bh=o(),p(ss.$$.fragment),yh=o(),sc=a("div"),p(po.$$.fragment),xm=o(),oe=a("div"),p(mo.$$.fragment),Th=o(),nc=a("p"),nc.innerHTML=Ey,Mh=o(),oc=a("p"),oc.innerHTML=Hy,vh=o(),rc=a("div"),p(go.$$.fragment),Um=o(),re=a("div"),p(uo.$$.fragment),wh=o(),ac=a("p"),ac.innerHTML=qy,kh=o(),p(ns.$$.fragment),jh=o(),lc=a("div"),p(ho.$$.fragment),zm=o(),je=a("div"),p(fo.$$.fragment),$h=o(),cc=a("p"),cc.textContent=Py,Jh=o(),ic=a("div"),p(_o.$$.fragment),Bm=o(),$e=a("div"),p(bo.$$.fragment),xh=o(),dc=a("p"),dc.innerHTML=Dy,Uh=o(),pc=a("div"),p(yo.$$.fragment),Im=o(),Je=a("div"),p(To.$$.fragment),zh=o(),mc=a("p"),mc.textContent=Qy,Bh=o(),gc=a("div"),p(Mo.$$.fragment),Zm=o(),ae=a("div"),p(vo.$$.fragment),Ih=o(),uc=a("p"),uc.innerHTML=Yy,Zh=o(),p(os.$$.fragment),Wh=o(),hc=a("div"),p(wo.$$.fragment),Wm=o(),le=a("div"),p(ko.$$.fragment),Fh=o(),fc=a("p"),fc.innerHTML=Ay,Vh=o(),p(rs.$$.fragment),Lh=o(),_c=a("div"),p(jo.$$.fragment),Fm=o(),C=a("div"),p($o.$$.fragment),Gh=o(),bc=a("p"),bc.innerHTML=Oy,Ch=o(),p(as.$$.fragment),Xh=o(),p(ls.$$.fragment),Rh=o(),yc=a("div"),p(Jo.$$.fragment),Vm=o(),X=a("div"),p(xo.$$.fragment),Nh=o(),Tc=a("p"),Tc.innerHTML=Ky,Sh=o(),p(cs.$$.fragment),Eh=o(),p(is.$$.fragment),Hh=o(),Mc=a("div"),p(Uo.$$.fragment),Lm=o(),ce=a("div"),p(zo.$$.fragment),qh=o(),vc=a("p"),vc.innerHTML=eT,Ph=o(),p(ds.$$.fragment),Dh=o(),wc=a("div"),p(Bo.$$.fragment),Gm=o(),R=a("div"),p(Io.$$.fragment),Qh=o(),kc=a("p"),kc.innerHTML=tT,Yh=o(),jc=a("p"),jc.innerHTML=sT,Ah=o(),p(ps.$$.fragment),Oh=o(),$c=a("div"),p(Zo.$$.fragment),Cm=o(),N=a("div"),p(Wo.$$.fragment),Kh=o(),Jc=a("p"),Jc.innerHTML=nT,ef=o(),p(ms.$$.fragment),tf=o(),p(gs.$$.fragment),sf=o(),xc=a("div"),p(Fo.$$.fragment),Xm=o(),ie=a("div"),p(Vo.$$.fragment),nf=o(),Uc=a("p"),Uc.innerHTML=oT,of=o(),p(us.$$.fragment),rf=o(),zc=a("div"),p(Lo.$$.fragment),Rm=o(),de=a("div"),p(Go.$$.fragment),af=o(),Bc=a("p"),Bc.innerHTML=rT,lf=o(),p(hs.$$.fragment),cf=o(),Ic=a("div"),p(Co.$$.fragment),Nm=o(),S=a("div"),p(Xo.$$.fragment),df=o(),Zc=a("p"),Zc.innerHTML=aT,pf=o(),p(fs.$$.fragment),mf=o(),p(_s.$$.fragment),gf=o(),Wc=a("div"),p(Ro.$$.fragment),Sm=o(),pe=a("div"),p(No.$$.fragment),uf=o(),Fc=a("p"),Fc.innerHTML=lT,hf=o(),p(bs.$$.fragment),ff=o(),Vc=a("div"),p(So.$$.fragment),Em=o(),me=a("div"),p(Eo.$$.fragment),_f=o(),Lc=a("p"),Lc.innerHTML=cT,bf=o(),p(ys.$$.fragment),yf=o(),Gc=a("div"),p(Ho.$$.fragment),Hm=o(),E=a("div"),p(qo.$$.fragment),Tf=o(),Cc=a("p"),Cc.innerHTML=iT,Mf=o(),Xc=a("p"),Xc.innerHTML=dT,vf=o(),p(Ts.$$.fragment),wf=o(),Rc=a("div"),p(Po.$$.fragment),qm=o(),H=a("div"),p(Do.$$.fragment),kf=o(),Nc=a("p"),Nc.innerHTML=pT,jf=o(),Sc=a("p"),Sc.innerHTML=mT,$f=o(),p(Ms.$$.fragment),Jf=o(),Ec=a("div"),p(Qo.$$.fragment),Pm=o(),q=a("div"),p(Yo.$$.fragment),xf=o(),Hc=a("p"),Hc.innerHTML=gT,Uf=o(),qc=a("p"),qc.innerHTML=uT,zf=o(),p(vs.$$.fragment),Bf=o(),Pc=a("div"),p(Ao.$$.fragment),Dm=o(),p(Oo.$$.fragment),Qm=o(),xe=a("div"),p(Ko.$$.fragment),If=o(),Dc=a("p"),Dc.innerHTML=hT,Zf=o(),Qc=a("div"),p(er.$$.fragment),Ym=o(),Ue=a("div"),p(tr.$$.fragment),Wf=o(),Yc=a("p"),Yc.innerHTML=fT,Ff=o(),Ac=a("div"),p(sr.$$.fragment),Am=o(),ze=a("div"),p(nr.$$.fragment),Vf=o(),Oc=a("p"),Oc.innerHTML=_T,Lf=o(),Kc=a("div"),p(or.$$.fragment),Om=o(),Be=a("div"),p(rr.$$.fragment),Gf=o(),ei=a("p"),ei.textContent=bT,Cf=o(),ws=a("div"),p(ar.$$.fragment),Xf=o(),ti=a("p"),ti.textContent=yT,Km=o(),Ie=a("div"),p(lr.$$.fragment),Rf=o(),si=a("p"),si.innerHTML=TT,Nf=o(),ni=a("div"),p(cr.$$.fragment),eg=o(),Ze=a("div"),p(ir.$$.fragment),Sf=o(),oi=a("p"),oi.textContent=MT,Ef=o(),ks=a("div"),p(dr.$$.fragment),Hf=o(),ri=a("p"),ri.textContent=vT,tg=o(),We=a("div"),p(pr.$$.fragment),qf=o(),ai=a("p"),ai.innerHTML=wT,Pf=o(),li=a("div"),p(mr.$$.fragment),sg=o(),Fe=a("div"),p(gr.$$.fragment),Df=o(),ci=a("p"),ci.innerHTML=kT,Qf=o(),ii=a("div"),p(ur.$$.fragment),ng=o(),Ve=a("div"),p(hr.$$.fragment),Yf=o(),di=a("p"),di.innerHTML=jT,Af=o(),pi=a("div"),p(fr.$$.fragment),og=o(),Le=a("div"),p(_r.$$.fragment),Of=o(),mi=a("p"),mi.innerHTML=$T,Kf=o(),gi=a("div"),p(br.$$.fragment),rg=o(),Ge=a("div"),p(yr.$$.fragment),e_=o(),ui=a("p"),ui.innerHTML=JT,t_=o(),hi=a("div"),p(Tr.$$.fragment),ag=o(),Ce=a("div"),p(Mr.$$.fragment),s_=o(),fi=a("p"),fi.innerHTML=xT,n_=o(),_i=a("div"),p(vr.$$.fragment),lg=o(),Xe=a("div"),p(wr.$$.fragment),o_=o(),bi=a("p"),bi.innerHTML=UT,r_=o(),yi=a("div"),p(kr.$$.fragment),cg=o(),Re=a("div"),p(jr.$$.fragment),a_=o(),Ti=a("p"),Ti.innerHTML=zT,l_=o(),Mi=a("div"),p($r.$$.fragment),ig=o(),Ne=a("div"),p(Jr.$$.fragment),c_=o(),vi=a("p"),vi.innerHTML=BT,i_=o(),wi=a("div"),p(xr.$$.fragment),dg=o(),p(Ur.$$.fragment),pg=o(),Se=a("div"),p(zr.$$.fragment),d_=o(),ki=a("p"),ki.innerHTML=IT,p_=o(),ji=a("div"),p(Br.$$.fragment),mg=o(),Ee=a("div"),p(Ir.$$.fragment),m_=o(),$i=a("p"),$i.innerHTML=ZT,g_=o(),Ji=a("div"),p(Zr.$$.fragment),gg=o(),He=a("div"),p(Wr.$$.fragment),u_=o(),xi=a("p"),xi.innerHTML=WT,h_=o(),Ui=a("div"),p(Fr.$$.fragment),ug=o(),qe=a("div"),p(Vr.$$.fragment),f_=o(),zi=a("p"),zi.textContent=FT,__=o(),js=a("div"),p(Lr.$$.fragment),b_=o(),Bi=a("p"),Bi.textContent=VT,hg=o(),Pe=a("div"),p(Gr.$$.fragment),y_=o(),Ii=a("p"),Ii.innerHTML=LT,T_=o(),Zi=a("div"),p(Cr.$$.fragment),fg=o(),De=a("div"),p(Xr.$$.fragment),M_=o(),Wi=a("p"),Wi.textContent=GT,v_=o(),$s=a("div"),p(Rr.$$.fragment),w_=o(),Fi=a("p"),Fi.textContent=CT,_g=o(),Qe=a("div"),p(Nr.$$.fragment),k_=o(),Vi=a("p"),Vi.innerHTML=XT,j_=o(),Li=a("div"),p(Sr.$$.fragment),bg=o(),Ye=a("div"),p(Er.$$.fragment),$_=o(),Gi=a("p"),Gi.innerHTML=RT,J_=o(),Ci=a("div"),p(Hr.$$.fragment),yg=o(),Ae=a("div"),p(qr.$$.fragment),x_=o(),Xi=a("p"),Xi.innerHTML=NT,U_=o(),Ri=a("div"),p(Pr.$$.fragment),Tg=o(),Oe=a("div"),p(Dr.$$.fragment),z_=o(),Ni=a("p"),Ni.innerHTML=ST,B_=o(),Si=a("div"),p(Qr.$$.fragment),Mg=o(),Ke=a("div"),p(Yr.$$.fragment),I_=o(),Ei=a("p"),Ei.innerHTML=ET,Z_=o(),Hi=a("div"),p(Ar.$$.fragment),vg=o(),et=a("div"),p(Or.$$.fragment),W_=o(),qi=a("p"),qi.innerHTML=HT,F_=o(),Pi=a("div"),p(Kr.$$.fragment),wg=o(),tt=a("div"),p(ea.$$.fragment),V_=o(),Di=a("p"),Di.innerHTML=qT,L_=o(),Qi=a("div"),p(ta.$$.fragment),kg=o(),p(sa.$$.fragment),jg=o(),na=a("p"),na.innerHTML=PT,$g=o(),ge=a("div"),p(oa.$$.fragment),G_=o(),Yi=a("p"),Yi.textContent=DT,C_=o(),Ai=a("p"),Ai.innerHTML=QT,X_=o(),Oi=a("div"),p(ra.$$.fragment),Jg=o(),Vt=a("div"),p(aa.$$.fragment),R_=o(),Ki=a("div"),p(la.$$.fragment),xg=o(),st=a("div"),p(ca.$$.fragment),N_=o(),ed=a("p"),ed.innerHTML=YT,S_=o(),td=a("div"),p(ia.$$.fragment),Ug=o(),nt=a("div"),p(da.$$.fragment),E_=o(),sd=a("p"),sd.innerHTML=AT,H_=o(),nd=a("div"),p(pa.$$.fragment),zg=o(),p(ma.$$.fragment),Bg=o(),ga=a("p"),ga.innerHTML=OT,Ig=o(),U=a("div"),p(ua.$$.fragment),q_=o(),od=a("p"),od.textContent=KT,P_=o(),rd=a("p"),rd.textContent=eM,D_=o(),p(Js.$$.fragment),Q_=o(),ad=a("p"),ad.textContent=tM,Y_=o(),xs=a("div"),p(ha.$$.fragment),A_=o(),ld=a("p"),ld.textContent=sM,O_=o(),Us=a("div"),p(fa.$$.fragment),K_=o(),cd=a("p"),cd.textContent=nM,eb=o(),zs=a("div"),p(_a.$$.fragment),tb=o(),id=a("p"),id.textContent=oM,sb=o(),Bs=a("div"),p(ba.$$.fragment),nb=o(),dd=a("p"),dd.innerHTML=rM,ob=o(),Is=a("div"),p(ya.$$.fragment),rb=o(),pd=a("p"),pd.textContent=aM,ab=o(),Zs=a("div"),p(Ta.$$.fragment),lb=o(),md=a("p"),md.textContent=lM,cb=o(),mt=a("div"),p(Ma.$$.fragment),ib=o(),gd=a("p"),gd.innerHTML=cM,db=o(),ud=a("p"),ud.textContent=iM,Zg=o(),Lt=a("div"),p(va.$$.fragment),pb=o(),hd=a("p"),hd.innerHTML=dM,Wg=o(),Gt=a("div"),p(wa.$$.fragment),mb=o(),fd=a("p"),fd.innerHTML=pM,Fg=o(),ue=a("div"),p(ka.$$.fragment),gb=o(),_d=a("p"),_d.textContent=mM,ub=o(),V=a("div"),p(ja.$$.fragment),hb=o(),bd=a("p"),bd.textContent=gM,fb=o(),yd=a("p"),yd.innerHTML=uM,_b=o(),Td=a("p"),Td.innerHTML=hM,bb=o(),Md=a("p"),Md.innerHTML=fM,yb=o(),vd=a("p"),vd.textContent=_M,Tb=o(),Ws=a("div"),p($a.$$.fragment),Mb=o(),wd=a("p"),wd.textContent=bM,Vg=o(),p(Ja.$$.fragment),Lg=o(),he=a("div"),p(xa.$$.fragment),vb=o(),kd=a("p"),kd.innerHTML=yM,wb=o(),jd=a("div"),p(Ua.$$.fragment),kb=o(),$d=a("div"),p(za.$$.fragment),Gg=o(),F=a("div"),p(Ba.$$.fragment),jb=o(),Jd=a("p"),Jd.innerHTML=TM,$b=o(),xd=a("p"),xd.innerHTML=MM,Jb=o(),Ud=a("p"),Ud.innerHTML=vM,xb=o(),zd=a("div"),p(Ia.$$.fragment),Ub=o(),Bd=a("div"),p(Za.$$.fragment),Cg=o(),fe=a("div"),p(Wa.$$.fragment),zb=o(),Id=a("p"),Id.innerHTML=wM,Bb=o(),Zd=a("div"),p(Fa.$$.fragment),Ib=o(),Wd=a("div"),p(Va.$$.fragment),Xg=o(),p(La.$$.fragment),Rg=o(),ot=a("div"),p(Ga.$$.fragment),Zb=o(),Fd=a("p"),Fd.textContent=kM,Wb=o(),Vd=a("p"),Vd.innerHTML=jM,Ng=o(),rt=a("div"),p(Ca.$$.fragment),Fb=o(),Ld=a("p"),Ld.textContent=$M,Vb=o(),Gd=a("p"),Gd.innerHTML=JM,Sg=o(),p(Xa.$$.fragment),Eg=o(),I=a("div"),p(Ra.$$.fragment),Lb=o(),Cd=a("p"),Cd.textContent=xM,Gb=o(),p(Fs.$$.fragment),Cb=o(),p(Vs.$$.fragment),Xb=o(),Ls=a("div"),p(Na.$$.fragment),Rb=o(),Xd=a("p"),Xd.textContent=UM,Nb=o(),Gs=a("div"),p(Sa.$$.fragment),Sb=o(),Rd=a("p"),Rd.textContent=zM,Eb=o(),Cs=a("div"),p(Ea.$$.fragment),Hb=o(),Nd=a("p"),Nd.textContent=BM,Hg=o(),P=a("div"),p(Ha.$$.fragment),qb=o(),Sd=a("p"),Sd.textContent=IM,Pb=o(),p(Xs.$$.fragment),Db=o(),p(Rs.$$.fragment),Qb=o(),Ns=a("div"),p(qa.$$.fragment),Yb=o(),Ed=a("p"),Ed.textContent=ZM,qg=o(),Jp=a("p"),this.h()},l(e){const c=Rv("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(s),j=r(e),b=l(e,"P",{}),T(b).forEach(s),_=r(e),m(w.$$.fragment,e),n=r(e),k=l(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1vp301g"&&(k.innerHTML=Ab),Vp=r(e),m(on.$$.fragment,e),Lp=r(e),rn=l(e,"P",{"data-svelte-h":!0}),y(rn)!=="svelte-14cu9br"&&(rn.innerHTML=Ob),Gp=r(e),m(an.$$.fragment,e),Cp=r(e),ln=l(e,"P",{"data-svelte-h":!0}),y(ln)!=="svelte-n0t05o"&&(ln.innerHTML=Kb),Xp=r(e),cn=l(e,"UL",{"data-svelte-h":!0}),y(cn)!=="svelte-1g0grg9"&&(cn.innerHTML=ey),Rp=r(e),dn=l(e,"P",{"data-svelte-h":!0}),y(dn)!=="svelte-1lwrzmb"&&(dn.innerHTML=ty),Np=r(e),pn=l(e,"P",{"data-svelte-h":!0}),y(pn)!=="svelte-1c8gkrx"&&(pn.innerHTML=sy),Sp=r(e),mn=l(e,"P",{"data-svelte-h":!0}),y(mn)!=="svelte-14yu8xd"&&(mn.innerHTML=ny),Ep=r(e),m(gn.$$.fragment,e),Hp=r(e),un=l(e,"P",{"data-svelte-h":!0}),y(un)!=="svelte-1xpf9sq"&&(un.innerHTML=oy),qp=r(e),hn=l(e,"P",{"data-svelte-h":!0}),y(hn)!=="svelte-1mmranx"&&(hn.innerHTML=ry),Pp=r(e),fn=l(e,"P",{"data-svelte-h":!0}),y(fn)!=="svelte-16hdzyk"&&(fn.textContent=ay),Dp=r(e),m(_n.$$.fragment,e),Qp=r(e),vt=l(e,"DIV",{class:!0});var Pa=T(vt);m(bn.$$.fragment,Pa),mu=r(Pa),dl=l(Pa,"P",{"data-svelte-h":!0}),y(dl)!=="svelte-k7oes3"&&(dl.textContent=ly),Pa.forEach(s),Yp=r(e),wt=l(e,"DIV",{class:!0});var Da=T(wt);m(yn.$$.fragment,Da),gu=r(Da),pl=l(Da,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-111f3sj"&&(pl.textContent=cy),Da.forEach(s),Ap=r(e),kt=l(e,"DIV",{class:!0});var Qa=T(kt);m(Tn.$$.fragment,Qa),uu=r(Qa),ml=l(Qa,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-1j3b9cp"&&(ml.textContent=iy),Qa.forEach(s),Op=r(e),jt=l(e,"DIV",{class:!0});var Ya=T(jt);m(Mn.$$.fragment,Ya),hu=r(Ya),gl=l(Ya,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-16r5px1"&&(gl.textContent=dy),Ya.forEach(s),Kp=r(e),m(vn.$$.fragment,e),em=r(e),$t=l(e,"DIV",{class:!0});var Aa=T($t);m(wn.$$.fragment,Aa),fu=r(Aa),ul=l(Aa,"P",{"data-svelte-h":!0}),y(ul)!=="svelte-1bnrp61"&&(ul.textContent=py),Aa.forEach(s),tm=r(e),Jt=l(e,"DIV",{class:!0});var Oa=T(Jt);m(kn.$$.fragment,Oa),_u=r(Oa),hl=l(Oa,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-fenhkk"&&(hl.textContent=my),Oa.forEach(s),sm=r(e),xt=l(e,"DIV",{class:!0});var Ka=T(xt);m(jn.$$.fragment,Ka),bu=r(Ka),fl=l(Ka,"P",{"data-svelte-h":!0}),y(fl)!=="svelte-1dqtgq4"&&(fl.textContent=gy),Ka.forEach(s),nm=r(e),Ut=l(e,"DIV",{class:!0});var el=T(Ut);m($n.$$.fragment,el),yu=r(el),_l=l(el,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-10orfv5"&&(_l.textContent=uy),el.forEach(s),om=r(e),zt=l(e,"DIV",{class:!0});var tl=T(zt);m(Jn.$$.fragment,tl),Tu=r(tl),bl=l(tl,"P",{"data-svelte-h":!0}),y(bl)!=="svelte-jg8udg"&&(bl.textContent=hy),tl.forEach(s),rm=r(e),Bt=l(e,"DIV",{class:!0});var sl=T(Bt);m(xn.$$.fragment,sl),Mu=r(sl),yl=l(sl,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-1i40667"&&(yl.textContent=fy),sl.forEach(s),am=r(e),It=l(e,"DIV",{class:!0});var nl=T(It);m(Un.$$.fragment,nl),vu=r(nl),Tl=l(nl,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-n5fi8x"&&(Tl.textContent=_y),nl.forEach(s),lm=r(e),Zt=l(e,"DIV",{class:!0});var ol=T(Zt);m(zn.$$.fragment,ol),wu=r(ol),Ml=l(ol,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-h5pj3l"&&(Ml.textContent=by),ol.forEach(s),cm=r(e),Wt=l(e,"DIV",{class:!0});var rl=T(Wt);m(Bn.$$.fragment,rl),ku=r(rl),vl=l(rl,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-b9zq6n"&&(vl.textContent=yy),rl.forEach(s),im=r(e),Ft=l(e,"DIV",{class:!0});var al=T(Ft);m(In.$$.fragment,al),ju=r(al),wl=l(al,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-pru3ks"&&(wl.textContent=Ty),al.forEach(s),dm=r(e),m(Zn.$$.fragment,e),pm=r(e),ve=l(e,"DIV",{class:!0});var Ct=T(ve);m(Wn.$$.fragment,Ct),$u=r(Ct),kl=l(Ct,"P",{"data-svelte-h":!0}),y(kl)!=="svelte-qoov36"&&(kl.textContent=My),Ju=r(Ct),Nt=l(Ct,"DIV",{class:!0});var ll=T(Nt);m(Fn.$$.fragment,ll),xu=r(ll),jl=l(ll,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-5ihtpa"&&(jl.textContent=vy),ll.forEach(s),Ct.forEach(s),mm=r(e),we=l(e,"DIV",{class:!0});var Xt=T(we);m(Vn.$$.fragment,Xt),Uu=r(Xt),$l=l(Xt,"P",{"data-svelte-h":!0}),y($l)!=="svelte-1tz7qrd"&&($l.textContent=wy),zu=r(Xt),St=l(Xt,"DIV",{class:!0});var cl=T(St);m(Ln.$$.fragment,cl),Bu=r(cl),Jl=l(cl,"P",{"data-svelte-h":!0}),y(Jl)!=="svelte-5ihtpa"&&(Jl.textContent=ky),cl.forEach(s),Xt.forEach(s),gm=r(e),ke=l(e,"DIV",{class:!0});var Rt=T(ke);m(Gn.$$.fragment,Rt),Iu=r(Rt),xl=l(Rt,"P",{"data-svelte-h":!0}),y(xl)!=="svelte-1tz7qrd"&&(xl.textContent=jy),Zu=r(Rt),Et=l(Rt,"DIV",{class:!0});var il=T(Et);m(Cn.$$.fragment,il),Wu=r(il),Ul=l(il,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-5ihtpa"&&(Ul.textContent=$y),il.forEach(s),Rt.forEach(s),um=r(e),m(Xn.$$.fragment,e),hm=r(e),Rn=l(e,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-1wwh02t"&&(Rn.innerHTML=Jy),fm=r(e),m(Nn.$$.fragment,e),_m=r(e),A=l(e,"DIV",{class:!0});var at=T(A);m(Sn.$$.fragment,at),Fu=r(at),zl=l(at,"P",{"data-svelte-h":!0}),y(zl)!=="svelte-gfr47j"&&(zl.innerHTML=xy),Vu=r(at),m(Ht.$$.fragment,at),Lu=r(at),Bl=l(at,"DIV",{class:!0});var xp=T(Bl);m(En.$$.fragment,xp),xp.forEach(s),at.forEach(s),bm=r(e),Z=l(e,"DIV",{class:!0});var D=T(Z);m(Hn.$$.fragment,D),Gu=r(D),Il=l(D,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-1xllf7o"&&(Il.innerHTML=Uy),Cu=r(D),Zl=l(D,"P",{"data-svelte-h":!0}),y(Zl)!=="svelte-lu7kru"&&(Zl.innerHTML=zy),Xu=r(D),m(qt.$$.fragment,D),Ru=r(D),m(Pt.$$.fragment,D),Nu=r(D),Wl=l(D,"DIV",{class:!0});var Up=T(Wl);m(qn.$$.fragment,Up),Up.forEach(s),D.forEach(s),ym=r(e),L=l(e,"DIV",{class:!0});var _e=T(L);m(Pn.$$.fragment,_e),Su=r(_e),Fl=l(_e,"P",{"data-svelte-h":!0}),y(Fl)!=="svelte-78kpvj"&&(Fl.innerHTML=By),Eu=r(_e),Vl=l(_e,"P",{"data-svelte-h":!0}),y(Vl)!=="svelte-mpy00q"&&(Vl.textContent=Iy),Hu=r(_e),m(Dt.$$.fragment,_e),qu=r(_e),Ll=l(_e,"DIV",{class:!0});var zp=T(Ll);m(Dn.$$.fragment,zp),zp.forEach(s),_e.forEach(s),Tm=r(e),G=l(e,"DIV",{class:!0});var be=T(G);m(Qn.$$.fragment,be),Pu=r(be),Gl=l(be,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-pt3j9p"&&(Gl.innerHTML=Zy),Du=r(be),Cl=l(be,"P",{"data-svelte-h":!0}),y(Cl)!=="svelte-3qpgm7"&&(Cl.textContent=Wy),Qu=r(be),m(Qt.$$.fragment,be),Yu=r(be),Xl=l(be,"DIV",{class:!0});var Bp=T(Xl);m(Yn.$$.fragment,Bp),Bp.forEach(s),be.forEach(s),Mm=r(e),O=l(e,"DIV",{class:!0});var lt=T(O);m(An.$$.fragment,lt),Au=r(lt),Rl=l(lt,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-1j1uxzd"&&(Rl.innerHTML=Fy),Ou=r(lt),m(Yt.$$.fragment,lt),Ku=r(lt),Nl=l(lt,"DIV",{class:!0});var Ip=T(Nl);m(On.$$.fragment,Ip),Ip.forEach(s),lt.forEach(s),vm=r(e),K=l(e,"DIV",{class:!0});var ct=T(K);m(Kn.$$.fragment,ct),eh=r(ct),Sl=l(ct,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-18kacel"&&(Sl.innerHTML=Vy),th=r(ct),m(At.$$.fragment,ct),sh=r(ct),El=l(ct,"DIV",{class:!0});var Zp=T(El);m(eo.$$.fragment,Zp),Zp.forEach(s),ct.forEach(s),wm=r(e),ee=l(e,"DIV",{class:!0});var it=T(ee);m(to.$$.fragment,it),nh=r(it),Hl=l(it,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-1gzat8m"&&(Hl.innerHTML=Ly),oh=r(it),m(Ot.$$.fragment,it),rh=r(it),ql=l(it,"DIV",{class:!0});var Wp=T(ql);m(so.$$.fragment,Wp),Wp.forEach(s),it.forEach(s),km=r(e),te=l(e,"DIV",{class:!0});var dt=T(te);m(no.$$.fragment,dt),ah=r(dt),Pl=l(dt,"P",{"data-svelte-h":!0}),y(Pl)!=="svelte-t5mov6"&&(Pl.innerHTML=Gy),lh=r(dt),m(Kt.$$.fragment,dt),ch=r(dt),Dl=l(dt,"DIV",{class:!0});var Fp=T(Dl);m(oo.$$.fragment,Fp),Fp.forEach(s),dt.forEach(s),jm=r(e),se=l(e,"DIV",{class:!0});var pt=T(se);m(ro.$$.fragment,pt),ih=r(pt),Ql=l(pt,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-51qc7q"&&(Ql.innerHTML=Cy),dh=r(pt),m(es.$$.fragment,pt),ph=r(pt),Yl=l(pt,"DIV",{class:!0});var WM=T(Yl);m(ao.$$.fragment,WM),WM.forEach(s),pt.forEach(s),$m=r(e),ne=l(e,"DIV",{class:!0});var Ss=T(ne);m(lo.$$.fragment,Ss),mh=r(Ss),Al=l(Ss,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-lpfxi8"&&(Al.innerHTML=Xy),gh=r(Ss),m(ts.$$.fragment,Ss),uh=r(Ss),Ol=l(Ss,"DIV",{class:!0});var FM=T(Ol);m(co.$$.fragment,FM),FM.forEach(s),Ss.forEach(s),Jm=r(e),W=l(e,"DIV",{class:!0});var ye=T(W);m(io.$$.fragment,ye),hh=r(ye),Kl=l(ye,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-o59l34"&&(Kl.innerHTML=Ry),fh=r(ye),ec=l(ye,"P",{"data-svelte-h":!0}),y(ec)!=="svelte-wp24j3"&&(ec.innerHTML=Ny),_h=r(ye),tc=l(ye,"P",{"data-svelte-h":!0}),y(tc)!=="svelte-2fpu88"&&(tc.innerHTML=Sy),bh=r(ye),m(ss.$$.fragment,ye),yh=r(ye),sc=l(ye,"DIV",{class:!0});var VM=T(sc);m(po.$$.fragment,VM),VM.forEach(s),ye.forEach(s),xm=r(e),oe=l(e,"DIV",{class:!0});var Es=T(oe);m(mo.$$.fragment,Es),Th=r(Es),nc=l(Es,"P",{"data-svelte-h":!0}),y(nc)!=="svelte-qeig8t"&&(nc.innerHTML=Ey),Mh=r(Es),oc=l(Es,"P",{"data-svelte-h":!0}),y(oc)!=="svelte-1v3r596"&&(oc.innerHTML=Hy),vh=r(Es),rc=l(Es,"DIV",{class:!0});var LM=T(rc);m(go.$$.fragment,LM),LM.forEach(s),Es.forEach(s),Um=r(e),re=l(e,"DIV",{class:!0});var Hs=T(re);m(uo.$$.fragment,Hs),wh=r(Hs),ac=l(Hs,"P",{"data-svelte-h":!0}),y(ac)!=="svelte-1r2uzcf"&&(ac.innerHTML=qy),kh=r(Hs),m(ns.$$.fragment,Hs),jh=r(Hs),lc=l(Hs,"DIV",{class:!0});var GM=T(lc);m(ho.$$.fragment,GM),GM.forEach(s),Hs.forEach(s),zm=r(e),je=l(e,"DIV",{class:!0});var Hd=T(je);m(fo.$$.fragment,Hd),$h=r(Hd),cc=l(Hd,"P",{"data-svelte-h":!0}),y(cc)!=="svelte-y1kta5"&&(cc.textContent=Py),Jh=r(Hd),ic=l(Hd,"DIV",{class:!0});var CM=T(ic);m(_o.$$.fragment,CM),CM.forEach(s),Hd.forEach(s),Bm=r(e),$e=l(e,"DIV",{class:!0});var qd=T($e);m(bo.$$.fragment,qd),xh=r(qd),dc=l(qd,"P",{"data-svelte-h":!0}),y(dc)!=="svelte-1l8u4wr"&&(dc.innerHTML=Dy),Uh=r(qd),pc=l(qd,"DIV",{class:!0});var XM=T(pc);m(yo.$$.fragment,XM),XM.forEach(s),qd.forEach(s),Im=r(e),Je=l(e,"DIV",{class:!0});var Pd=T(Je);m(To.$$.fragment,Pd),zh=r(Pd),mc=l(Pd,"P",{"data-svelte-h":!0}),y(mc)!=="svelte-th82mu"&&(mc.textContent=Qy),Bh=r(Pd),gc=l(Pd,"DIV",{class:!0});var RM=T(gc);m(Mo.$$.fragment,RM),RM.forEach(s),Pd.forEach(s),Zm=r(e),ae=l(e,"DIV",{class:!0});var qs=T(ae);m(vo.$$.fragment,qs),Ih=r(qs),uc=l(qs,"P",{"data-svelte-h":!0}),y(uc)!=="svelte-ef7zxe"&&(uc.innerHTML=Yy),Zh=r(qs),m(os.$$.fragment,qs),Wh=r(qs),hc=l(qs,"DIV",{class:!0});var NM=T(hc);m(wo.$$.fragment,NM),NM.forEach(s),qs.forEach(s),Wm=r(e),le=l(e,"DIV",{class:!0});var Ps=T(le);m(ko.$$.fragment,Ps),Fh=r(Ps),fc=l(Ps,"P",{"data-svelte-h":!0}),y(fc)!=="svelte-r5sqxj"&&(fc.innerHTML=Ay),Vh=r(Ps),m(rs.$$.fragment,Ps),Lh=r(Ps),_c=l(Ps,"DIV",{class:!0});var SM=T(_c);m(jo.$$.fragment,SM),SM.forEach(s),Ps.forEach(s),Fm=r(e),C=l(e,"DIV",{class:!0});var gt=T(C);m($o.$$.fragment,gt),Gh=r(gt),bc=l(gt,"P",{"data-svelte-h":!0}),y(bc)!=="svelte-ezf0bm"&&(bc.innerHTML=Oy),Ch=r(gt),m(as.$$.fragment,gt),Xh=r(gt),m(ls.$$.fragment,gt),Rh=r(gt),yc=l(gt,"DIV",{class:!0});var EM=T(yc);m(Jo.$$.fragment,EM),EM.forEach(s),gt.forEach(s),Vm=r(e),X=l(e,"DIV",{class:!0});var ut=T(X);m(xo.$$.fragment,ut),Nh=r(ut),Tc=l(ut,"P",{"data-svelte-h":!0}),y(Tc)!=="svelte-1wx0t8l"&&(Tc.innerHTML=Ky),Sh=r(ut),m(cs.$$.fragment,ut),Eh=r(ut),m(is.$$.fragment,ut),Hh=r(ut),Mc=l(ut,"DIV",{class:!0});var HM=T(Mc);m(Uo.$$.fragment,HM),HM.forEach(s),ut.forEach(s),Lm=r(e),ce=l(e,"DIV",{class:!0});var Ds=T(ce);m(zo.$$.fragment,Ds),qh=r(Ds),vc=l(Ds,"P",{"data-svelte-h":!0}),y(vc)!=="svelte-co93ve"&&(vc.innerHTML=eT),Ph=r(Ds),m(ds.$$.fragment,Ds),Dh=r(Ds),wc=l(Ds,"DIV",{class:!0});var qM=T(wc);m(Bo.$$.fragment,qM),qM.forEach(s),Ds.forEach(s),Gm=r(e),R=l(e,"DIV",{class:!0});var ht=T(R);m(Io.$$.fragment,ht),Qh=r(ht),kc=l(ht,"P",{"data-svelte-h":!0}),y(kc)!=="svelte-2jq87u"&&(kc.innerHTML=tT),Yh=r(ht),jc=l(ht,"P",{"data-svelte-h":!0}),y(jc)!=="svelte-qhda5i"&&(jc.innerHTML=sT),Ah=r(ht),m(ps.$$.fragment,ht),Oh=r(ht),$c=l(ht,"DIV",{class:!0});var PM=T($c);m(Zo.$$.fragment,PM),PM.forEach(s),ht.forEach(s),Cm=r(e),N=l(e,"DIV",{class:!0});var ft=T(N);m(Wo.$$.fragment,ft),Kh=r(ft),Jc=l(ft,"P",{"data-svelte-h":!0}),y(Jc)!=="svelte-fuk7jp"&&(Jc.innerHTML=nT),ef=r(ft),m(ms.$$.fragment,ft),tf=r(ft),m(gs.$$.fragment,ft),sf=r(ft),xc=l(ft,"DIV",{class:!0});var DM=T(xc);m(Fo.$$.fragment,DM),DM.forEach(s),ft.forEach(s),Xm=r(e),ie=l(e,"DIV",{class:!0});var Qs=T(ie);m(Vo.$$.fragment,Qs),nf=r(Qs),Uc=l(Qs,"P",{"data-svelte-h":!0}),y(Uc)!=="svelte-i7rnup"&&(Uc.innerHTML=oT),of=r(Qs),m(us.$$.fragment,Qs),rf=r(Qs),zc=l(Qs,"DIV",{class:!0});var QM=T(zc);m(Lo.$$.fragment,QM),QM.forEach(s),Qs.forEach(s),Rm=r(e),de=l(e,"DIV",{class:!0});var Ys=T(de);m(Go.$$.fragment,Ys),af=r(Ys),Bc=l(Ys,"P",{"data-svelte-h":!0}),y(Bc)!=="svelte-kp6ubc"&&(Bc.innerHTML=rT),lf=r(Ys),m(hs.$$.fragment,Ys),cf=r(Ys),Ic=l(Ys,"DIV",{class:!0});var YM=T(Ic);m(Co.$$.fragment,YM),YM.forEach(s),Ys.forEach(s),Nm=r(e),S=l(e,"DIV",{class:!0});var _t=T(S);m(Xo.$$.fragment,_t),df=r(_t),Zc=l(_t,"P",{"data-svelte-h":!0}),y(Zc)!=="svelte-1tmlgao"&&(Zc.innerHTML=aT),pf=r(_t),m(fs.$$.fragment,_t),mf=r(_t),m(_s.$$.fragment,_t),gf=r(_t),Wc=l(_t,"DIV",{class:!0});var AM=T(Wc);m(Ro.$$.fragment,AM),AM.forEach(s),_t.forEach(s),Sm=r(e),pe=l(e,"DIV",{class:!0});var As=T(pe);m(No.$$.fragment,As),uf=r(As),Fc=l(As,"P",{"data-svelte-h":!0}),y(Fc)!=="svelte-1b7t8ua"&&(Fc.innerHTML=lT),hf=r(As),m(bs.$$.fragment,As),ff=r(As),Vc=l(As,"DIV",{class:!0});var OM=T(Vc);m(So.$$.fragment,OM),OM.forEach(s),As.forEach(s),Em=r(e),me=l(e,"DIV",{class:!0});var Os=T(me);m(Eo.$$.fragment,Os),_f=r(Os),Lc=l(Os,"P",{"data-svelte-h":!0}),y(Lc)!=="svelte-19u8htu"&&(Lc.innerHTML=cT),bf=r(Os),m(ys.$$.fragment,Os),yf=r(Os),Gc=l(Os,"DIV",{class:!0});var KM=T(Gc);m(Ho.$$.fragment,KM),KM.forEach(s),Os.forEach(s),Hm=r(e),E=l(e,"DIV",{class:!0});var bt=T(E);m(qo.$$.fragment,bt),Tf=r(bt),Cc=l(bt,"P",{"data-svelte-h":!0}),y(Cc)!=="svelte-78uv63"&&(Cc.innerHTML=iT),Mf=r(bt),Xc=l(bt,"P",{"data-svelte-h":!0}),y(Xc)!=="svelte-1qmimno"&&(Xc.innerHTML=dT),vf=r(bt),m(Ts.$$.fragment,bt),wf=r(bt),Rc=l(bt,"DIV",{class:!0});var ev=T(Rc);m(Po.$$.fragment,ev),ev.forEach(s),bt.forEach(s),qm=r(e),H=l(e,"DIV",{class:!0});var yt=T(H);m(Do.$$.fragment,yt),kf=r(yt),Nc=l(yt,"P",{"data-svelte-h":!0}),y(Nc)!=="svelte-1dewsn6"&&(Nc.innerHTML=pT),jf=r(yt),Sc=l(yt,"P",{"data-svelte-h":!0}),y(Sc)!=="svelte-5qs7tv"&&(Sc.innerHTML=mT),$f=r(yt),m(Ms.$$.fragment,yt),Jf=r(yt),Ec=l(yt,"DIV",{class:!0});var tv=T(Ec);m(Qo.$$.fragment,tv),tv.forEach(s),yt.forEach(s),Pm=r(e),q=l(e,"DIV",{class:!0});var Tt=T(q);m(Yo.$$.fragment,Tt),xf=r(Tt),Hc=l(Tt,"P",{"data-svelte-h":!0}),y(Hc)!=="svelte-109qx6w"&&(Hc.innerHTML=gT),Uf=r(Tt),qc=l(Tt,"P",{"data-svelte-h":!0}),y(qc)!=="svelte-qmmn5t"&&(qc.innerHTML=uT),zf=r(Tt),m(vs.$$.fragment,Tt),Bf=r(Tt),Pc=l(Tt,"DIV",{class:!0});var sv=T(Pc);m(Ao.$$.fragment,sv),sv.forEach(s),Tt.forEach(s),Dm=r(e),m(Oo.$$.fragment,e),Qm=r(e),xe=l(e,"DIV",{class:!0});var Dd=T(xe);m(Ko.$$.fragment,Dd),If=r(Dd),Dc=l(Dd,"P",{"data-svelte-h":!0}),y(Dc)!=="svelte-1i5oca"&&(Dc.innerHTML=hT),Zf=r(Dd),Qc=l(Dd,"DIV",{class:!0});var nv=T(Qc);m(er.$$.fragment,nv),nv.forEach(s),Dd.forEach(s),Ym=r(e),Ue=l(e,"DIV",{class:!0});var Qd=T(Ue);m(tr.$$.fragment,Qd),Wf=r(Qd),Yc=l(Qd,"P",{"data-svelte-h":!0}),y(Yc)!=="svelte-5q9fhy"&&(Yc.innerHTML=fT),Ff=r(Qd),Ac=l(Qd,"DIV",{class:!0});var ov=T(Ac);m(sr.$$.fragment,ov),ov.forEach(s),Qd.forEach(s),Am=r(e),ze=l(e,"DIV",{class:!0});var Yd=T(ze);m(nr.$$.fragment,Yd),Vf=r(Yd),Oc=l(Yd,"P",{"data-svelte-h":!0}),y(Oc)!=="svelte-1557waw"&&(Oc.innerHTML=_T),Lf=r(Yd),Kc=l(Yd,"DIV",{class:!0});var rv=T(Kc);m(or.$$.fragment,rv),rv.forEach(s),Yd.forEach(s),Om=r(e),Be=l(e,"DIV",{class:!0});var Ad=T(Be);m(rr.$$.fragment,Ad),Gf=r(Ad),ei=l(Ad,"P",{"data-svelte-h":!0}),y(ei)!=="svelte-y1kta5"&&(ei.textContent=bT),Cf=r(Ad),ws=l(Ad,"DIV",{class:!0});var Dg=T(ws);m(ar.$$.fragment,Dg),Xf=r(Dg),ti=l(Dg,"P",{"data-svelte-h":!0}),y(ti)!=="svelte-5aspnb"&&(ti.textContent=yT),Dg.forEach(s),Ad.forEach(s),Km=r(e),Ie=l(e,"DIV",{class:!0});var Od=T(Ie);m(lr.$$.fragment,Od),Rf=r(Od),si=l(Od,"P",{"data-svelte-h":!0}),y(si)!=="svelte-16g917r"&&(si.innerHTML=TT),Nf=r(Od),ni=l(Od,"DIV",{class:!0});var av=T(ni);m(cr.$$.fragment,av),av.forEach(s),Od.forEach(s),eg=r(e),Ze=l(e,"DIV",{class:!0});var Kd=T(Ze);m(ir.$$.fragment,Kd),Sf=r(Kd),oi=l(Kd,"P",{"data-svelte-h":!0}),y(oi)!=="svelte-th82mu"&&(oi.textContent=MT),Ef=r(Kd),ks=l(Kd,"DIV",{class:!0});var Qg=T(ks);m(dr.$$.fragment,Qg),Hf=r(Qg),ri=l(Qg,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-hcoglc"&&(ri.textContent=vT),Qg.forEach(s),Kd.forEach(s),tg=r(e),We=l(e,"DIV",{class:!0});var ep=T(We);m(pr.$$.fragment,ep),qf=r(ep),ai=l(ep,"P",{"data-svelte-h":!0}),y(ai)!=="svelte-1pc85tu"&&(ai.innerHTML=wT),Pf=r(ep),li=l(ep,"DIV",{class:!0});var lv=T(li);m(mr.$$.fragment,lv),lv.forEach(s),ep.forEach(s),sg=r(e),Fe=l(e,"DIV",{class:!0});var tp=T(Fe);m(gr.$$.fragment,tp),Df=r(tp),ci=l(tp,"P",{"data-svelte-h":!0}),y(ci)!=="svelte-vwkkbr"&&(ci.innerHTML=kT),Qf=r(tp),ii=l(tp,"DIV",{class:!0});var cv=T(ii);m(ur.$$.fragment,cv),cv.forEach(s),tp.forEach(s),ng=r(e),Ve=l(e,"DIV",{class:!0});var sp=T(Ve);m(hr.$$.fragment,sp),Yf=r(sp),di=l(sp,"P",{"data-svelte-h":!0}),y(di)!=="svelte-onru7b"&&(di.innerHTML=jT),Af=r(sp),pi=l(sp,"DIV",{class:!0});var iv=T(pi);m(fr.$$.fragment,iv),iv.forEach(s),sp.forEach(s),og=r(e),Le=l(e,"DIV",{class:!0});var np=T(Le);m(_r.$$.fragment,np),Of=r(np),mi=l(np,"P",{"data-svelte-h":!0}),y(mi)!=="svelte-1cqgh5a"&&(mi.innerHTML=$T),Kf=r(np),gi=l(np,"DIV",{class:!0});var dv=T(gi);m(br.$$.fragment,dv),dv.forEach(s),np.forEach(s),rg=r(e),Ge=l(e,"DIV",{class:!0});var op=T(Ge);m(yr.$$.fragment,op),e_=r(op),ui=l(op,"P",{"data-svelte-h":!0}),y(ui)!=="svelte-mrqmmd"&&(ui.innerHTML=JT),t_=r(op),hi=l(op,"DIV",{class:!0});var pv=T(hi);m(Tr.$$.fragment,pv),pv.forEach(s),op.forEach(s),ag=r(e),Ce=l(e,"DIV",{class:!0});var rp=T(Ce);m(Mr.$$.fragment,rp),s_=r(rp),fi=l(rp,"P",{"data-svelte-h":!0}),y(fi)!=="svelte-a554sd"&&(fi.innerHTML=xT),n_=r(rp),_i=l(rp,"DIV",{class:!0});var mv=T(_i);m(vr.$$.fragment,mv),mv.forEach(s),rp.forEach(s),lg=r(e),Xe=l(e,"DIV",{class:!0});var ap=T(Xe);m(wr.$$.fragment,ap),o_=r(ap),bi=l(ap,"P",{"data-svelte-h":!0}),y(bi)!=="svelte-16h289p"&&(bi.innerHTML=UT),r_=r(ap),yi=l(ap,"DIV",{class:!0});var gv=T(yi);m(kr.$$.fragment,gv),gv.forEach(s),ap.forEach(s),cg=r(e),Re=l(e,"DIV",{class:!0});var lp=T(Re);m(jr.$$.fragment,lp),a_=r(lp),Ti=l(lp,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-1bghrvg"&&(Ti.innerHTML=zT),l_=r(lp),Mi=l(lp,"DIV",{class:!0});var uv=T(Mi);m($r.$$.fragment,uv),uv.forEach(s),lp.forEach(s),ig=r(e),Ne=l(e,"DIV",{class:!0});var cp=T(Ne);m(Jr.$$.fragment,cp),c_=r(cp),vi=l(cp,"P",{"data-svelte-h":!0}),y(vi)!=="svelte-1b66dpm"&&(vi.innerHTML=BT),i_=r(cp),wi=l(cp,"DIV",{class:!0});var hv=T(wi);m(xr.$$.fragment,hv),hv.forEach(s),cp.forEach(s),dg=r(e),m(Ur.$$.fragment,e),pg=r(e),Se=l(e,"DIV",{class:!0});var ip=T(Se);m(zr.$$.fragment,ip),d_=r(ip),ki=l(ip,"P",{"data-svelte-h":!0}),y(ki)!=="svelte-1krxxs2"&&(ki.innerHTML=IT),p_=r(ip),ji=l(ip,"DIV",{class:!0});var fv=T(ji);m(Br.$$.fragment,fv),fv.forEach(s),ip.forEach(s),mg=r(e),Ee=l(e,"DIV",{class:!0});var dp=T(Ee);m(Ir.$$.fragment,dp),m_=r(dp),$i=l(dp,"P",{"data-svelte-h":!0}),y($i)!=="svelte-68319q"&&($i.innerHTML=ZT),g_=r(dp),Ji=l(dp,"DIV",{class:!0});var _v=T(Ji);m(Zr.$$.fragment,_v),_v.forEach(s),dp.forEach(s),gg=r(e),He=l(e,"DIV",{class:!0});var pp=T(He);m(Wr.$$.fragment,pp),u_=r(pp),xi=l(pp,"P",{"data-svelte-h":!0}),y(xi)!=="svelte-m4wngj"&&(xi.innerHTML=WT),h_=r(pp),Ui=l(pp,"DIV",{class:!0});var bv=T(Ui);m(Fr.$$.fragment,bv),bv.forEach(s),pp.forEach(s),ug=r(e),qe=l(e,"DIV",{class:!0});var mp=T(qe);m(Vr.$$.fragment,mp),f_=r(mp),zi=l(mp,"P",{"data-svelte-h":!0}),y(zi)!=="svelte-y1kta5"&&(zi.textContent=FT),__=r(mp),js=l(mp,"DIV",{class:!0});var Yg=T(js);m(Lr.$$.fragment,Yg),b_=r(Yg),Bi=l(Yg,"P",{"data-svelte-h":!0}),y(Bi)!=="svelte-1l17mwc"&&(Bi.textContent=VT),Yg.forEach(s),mp.forEach(s),hg=r(e),Pe=l(e,"DIV",{class:!0});var gp=T(Pe);m(Gr.$$.fragment,gp),y_=r(gp),Ii=l(gp,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-4w2l2r"&&(Ii.innerHTML=LT),T_=r(gp),Zi=l(gp,"DIV",{class:!0});var yv=T(Zi);m(Cr.$$.fragment,yv),yv.forEach(s),gp.forEach(s),fg=r(e),De=l(e,"DIV",{class:!0});var up=T(De);m(Xr.$$.fragment,up),M_=r(up),Wi=l(up,"P",{"data-svelte-h":!0}),y(Wi)!=="svelte-th82mu"&&(Wi.textContent=GT),v_=r(up),$s=l(up,"DIV",{class:!0});var Ag=T($s);m(Rr.$$.fragment,Ag),w_=r(Ag),Fi=l(Ag,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-1tcb5cf"&&(Fi.textContent=CT),Ag.forEach(s),up.forEach(s),_g=r(e),Qe=l(e,"DIV",{class:!0});var hp=T(Qe);m(Nr.$$.fragment,hp),k_=r(hp),Vi=l(hp,"P",{"data-svelte-h":!0}),y(Vi)!=="svelte-jjelii"&&(Vi.innerHTML=XT),j_=r(hp),Li=l(hp,"DIV",{class:!0});var Tv=T(Li);m(Sr.$$.fragment,Tv),Tv.forEach(s),hp.forEach(s),bg=r(e),Ye=l(e,"DIV",{class:!0});var fp=T(Ye);m(Er.$$.fragment,fp),$_=r(fp),Gi=l(fp,"P",{"data-svelte-h":!0}),y(Gi)!=="svelte-edula"&&(Gi.innerHTML=RT),J_=r(fp),Ci=l(fp,"DIV",{class:!0});var Mv=T(Ci);m(Hr.$$.fragment,Mv),Mv.forEach(s),fp.forEach(s),yg=r(e),Ae=l(e,"DIV",{class:!0});var _p=T(Ae);m(qr.$$.fragment,_p),x_=r(_p),Xi=l(_p,"P",{"data-svelte-h":!0}),y(Xi)!=="svelte-19af6xs"&&(Xi.innerHTML=NT),U_=r(_p),Ri=l(_p,"DIV",{class:!0});var vv=T(Ri);m(Pr.$$.fragment,vv),vv.forEach(s),_p.forEach(s),Tg=r(e),Oe=l(e,"DIV",{class:!0});var bp=T(Oe);m(Dr.$$.fragment,bp),z_=r(bp),Ni=l(bp,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-1br3xfv"&&(Ni.innerHTML=ST),B_=r(bp),Si=l(bp,"DIV",{class:!0});var wv=T(Si);m(Qr.$$.fragment,wv),wv.forEach(s),bp.forEach(s),Mg=r(e),Ke=l(e,"DIV",{class:!0});var yp=T(Ke);m(Yr.$$.fragment,yp),I_=r(yp),Ei=l(yp,"P",{"data-svelte-h":!0}),y(Ei)!=="svelte-tn22d2"&&(Ei.innerHTML=ET),Z_=r(yp),Hi=l(yp,"DIV",{class:!0});var kv=T(Hi);m(Ar.$$.fragment,kv),kv.forEach(s),yp.forEach(s),vg=r(e),et=l(e,"DIV",{class:!0});var Tp=T(et);m(Or.$$.fragment,Tp),W_=r(Tp),qi=l(Tp,"P",{"data-svelte-h":!0}),y(qi)!=="svelte-1qjpl6o"&&(qi.innerHTML=HT),F_=r(Tp),Pi=l(Tp,"DIV",{class:!0});var jv=T(Pi);m(Kr.$$.fragment,jv),jv.forEach(s),Tp.forEach(s),wg=r(e),tt=l(e,"DIV",{class:!0});var Mp=T(tt);m(ea.$$.fragment,Mp),V_=r(Mp),Di=l(Mp,"P",{"data-svelte-h":!0}),y(Di)!=="svelte-1sygpwz"&&(Di.innerHTML=qT),L_=r(Mp),Qi=l(Mp,"DIV",{class:!0});var $v=T(Qi);m(ta.$$.fragment,$v),$v.forEach(s),Mp.forEach(s),kg=r(e),m(sa.$$.fragment,e),jg=r(e),na=l(e,"P",{"data-svelte-h":!0}),y(na)!=="svelte-17mrepr"&&(na.innerHTML=PT),$g=r(e),ge=l(e,"DIV",{class:!0});var Ks=T(ge);m(oa.$$.fragment,Ks),G_=r(Ks),Yi=l(Ks,"P",{"data-svelte-h":!0}),y(Yi)!=="svelte-rfvu1k"&&(Yi.textContent=DT),C_=r(Ks),Ai=l(Ks,"P",{"data-svelte-h":!0}),y(Ai)!=="svelte-e1lytz"&&(Ai.innerHTML=QT),X_=r(Ks),Oi=l(Ks,"DIV",{class:!0});var Jv=T(Oi);m(ra.$$.fragment,Jv),Jv.forEach(s),Ks.forEach(s),Jg=r(e),Vt=l(e,"DIV",{class:!0});var Og=T(Vt);m(aa.$$.fragment,Og),R_=r(Og),Ki=l(Og,"DIV",{class:!0});var xv=T(Ki);m(la.$$.fragment,xv),xv.forEach(s),Og.forEach(s),xg=r(e),st=l(e,"DIV",{class:!0});var vp=T(st);m(ca.$$.fragment,vp),N_=r(vp),ed=l(vp,"P",{"data-svelte-h":!0}),y(ed)!=="svelte-4hfu96"&&(ed.innerHTML=YT),S_=r(vp),td=l(vp,"DIV",{class:!0});var Uv=T(td);m(ia.$$.fragment,Uv),Uv.forEach(s),vp.forEach(s),Ug=r(e),nt=l(e,"DIV",{class:!0});var wp=T(nt);m(da.$$.fragment,wp),E_=r(wp),sd=l(wp,"P",{"data-svelte-h":!0}),y(sd)!=="svelte-q5v59n"&&(sd.innerHTML=AT),H_=r(wp),nd=l(wp,"DIV",{class:!0});var zv=T(nd);m(pa.$$.fragment,zv),zv.forEach(s),wp.forEach(s),zg=r(e),m(ma.$$.fragment,e),Bg=r(e),ga=l(e,"P",{"data-svelte-h":!0}),y(ga)!=="svelte-1ap1d5a"&&(ga.innerHTML=OT),Ig=r(e),U=l(e,"DIV",{class:!0});var B=T(U);m(ua.$$.fragment,B),q_=r(B),od=l(B,"P",{"data-svelte-h":!0}),y(od)!=="svelte-1kh5y5v"&&(od.textContent=KT),P_=r(B),rd=l(B,"P",{"data-svelte-h":!0}),y(rd)!=="svelte-1ygkifj"&&(rd.textContent=eM),D_=r(B),m(Js.$$.fragment,B),Q_=r(B),ad=l(B,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-7kbd1a"&&(ad.textContent=tM),Y_=r(B),xs=l(B,"DIV",{class:!0});var Kg=T(xs);m(ha.$$.fragment,Kg),A_=r(Kg),ld=l(Kg,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-691079"&&(ld.textContent=sM),Kg.forEach(s),O_=r(B),Us=l(B,"DIV",{class:!0});var eu=T(Us);m(fa.$$.fragment,eu),K_=r(eu),cd=l(eu,"P",{"data-svelte-h":!0}),y(cd)!=="svelte-dtkk01"&&(cd.textContent=nM),eu.forEach(s),eb=r(B),zs=l(B,"DIV",{class:!0});var tu=T(zs);m(_a.$$.fragment,tu),tb=r(tu),id=l(tu,"P",{"data-svelte-h":!0}),y(id)!=="svelte-11pa7k0"&&(id.textContent=oM),tu.forEach(s),sb=r(B),Bs=l(B,"DIV",{class:!0});var su=T(Bs);m(ba.$$.fragment,su),nb=r(su),dd=l(su,"P",{"data-svelte-h":!0}),y(dd)!=="svelte-57vcuk"&&(dd.innerHTML=rM),su.forEach(s),ob=r(B),Is=l(B,"DIV",{class:!0});var nu=T(Is);m(ya.$$.fragment,nu),rb=r(nu),pd=l(nu,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-e342dt"&&(pd.textContent=aM),nu.forEach(s),ab=r(B),Zs=l(B,"DIV",{class:!0});var ou=T(Zs);m(Ta.$$.fragment,ou),lb=r(ou),md=l(ou,"P",{"data-svelte-h":!0}),y(md)!=="svelte-vbd5xj"&&(md.textContent=lM),ou.forEach(s),cb=r(B),mt=l(B,"DIV",{class:!0});var kp=T(mt);m(Ma.$$.fragment,kp),ib=r(kp),gd=l(kp,"P",{"data-svelte-h":!0}),y(gd)!=="svelte-1c2dshy"&&(gd.innerHTML=cM),db=r(kp),ud=l(kp,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-1qvu1un"&&(ud.textContent=iM),kp.forEach(s),B.forEach(s),Zg=r(e),Lt=l(e,"DIV",{class:!0});var ru=T(Lt);m(va.$$.fragment,ru),pb=r(ru),hd=l(ru,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-1myi79s"&&(hd.innerHTML=dM),ru.forEach(s),Wg=r(e),Gt=l(e,"DIV",{class:!0});var au=T(Gt);m(wa.$$.fragment,au),mb=r(au),fd=l(au,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-1ho89xz"&&(fd.innerHTML=pM),au.forEach(s),Fg=r(e),ue=l(e,"DIV",{class:!0});var en=T(ue);m(ka.$$.fragment,en),gb=r(en),_d=l(en,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-rxlesw"&&(_d.textContent=mM),ub=r(en),V=l(en,"DIV",{class:!0});var Te=T(V);m(ja.$$.fragment,Te),hb=r(Te),bd=l(Te,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-15hhlou"&&(bd.textContent=gM),fb=r(Te),yd=l(Te,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-x0d0uq"&&(yd.innerHTML=uM),_b=r(Te),Td=l(Te,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-1w36vm3"&&(Td.innerHTML=hM),bb=r(Te),Md=l(Te,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-1niq0qw"&&(Md.innerHTML=fM),yb=r(Te),vd=l(Te,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-af4g6f"&&(vd.textContent=_M),Te.forEach(s),Tb=r(en),Ws=l(en,"DIV",{class:!0});var lu=T(Ws);m($a.$$.fragment,lu),Mb=r(lu),wd=l(lu,"P",{"data-svelte-h":!0}),y(wd)!=="svelte-eab6jp"&&(wd.textContent=bM),lu.forEach(s),en.forEach(s),Vg=r(e),m(Ja.$$.fragment,e),Lg=r(e),he=l(e,"DIV",{class:!0});var tn=T(he);m(xa.$$.fragment,tn),vb=r(tn),kd=l(tn,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-1ey02pr"&&(kd.innerHTML=yM),wb=r(tn),jd=l(tn,"DIV",{class:!0});var Bv=T(jd);m(Ua.$$.fragment,Bv),Bv.forEach(s),kb=r(tn),$d=l(tn,"DIV",{class:!0});var Iv=T($d);m(za.$$.fragment,Iv),Iv.forEach(s),tn.forEach(s),Gg=r(e),F=l(e,"DIV",{class:!0});var Me=T(F);m(Ba.$$.fragment,Me),jb=r(Me),Jd=l(Me,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-re9t0f"&&(Jd.innerHTML=TM),$b=r(Me),xd=l(Me,"P",{"data-svelte-h":!0}),y(xd)!=="svelte-19qrwo1"&&(xd.innerHTML=MM),Jb=r(Me),Ud=l(Me,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-l79sbt"&&(Ud.innerHTML=vM),xb=r(Me),zd=l(Me,"DIV",{class:!0});var Zv=T(zd);m(Ia.$$.fragment,Zv),Zv.forEach(s),Ub=r(Me),Bd=l(Me,"DIV",{class:!0});var Wv=T(Bd);m(Za.$$.fragment,Wv),Wv.forEach(s),Me.forEach(s),Cg=r(e),fe=l(e,"DIV",{class:!0});var sn=T(fe);m(Wa.$$.fragment,sn),zb=r(sn),Id=l(sn,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-qcqb4w"&&(Id.innerHTML=wM),Bb=r(sn),Zd=l(sn,"DIV",{class:!0});var Fv=T(Zd);m(Fa.$$.fragment,Fv),Fv.forEach(s),Ib=r(sn),Wd=l(sn,"DIV",{class:!0});var Vv=T(Wd);m(Va.$$.fragment,Vv),Vv.forEach(s),sn.forEach(s),Xg=r(e),m(La.$$.fragment,e),Rg=r(e),ot=l(e,"DIV",{class:!0});var jp=T(ot);m(Ga.$$.fragment,jp),Zb=r(jp),Fd=l(jp,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-1aiwpx2"&&(Fd.textContent=kM),Wb=r(jp),Vd=l(jp,"P",{"data-svelte-h":!0}),y(Vd)!=="svelte-ts4ue3"&&(Vd.innerHTML=jM),jp.forEach(s),Ng=r(e),rt=l(e,"DIV",{class:!0});var $p=T(rt);m(Ca.$$.fragment,$p),Fb=r($p),Ld=l($p,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-1aiwpx2"&&(Ld.textContent=$M),Vb=r($p),Gd=l($p,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-ts4ue3"&&(Gd.innerHTML=JM),$p.forEach(s),Sg=r(e),m(Xa.$$.fragment,e),Eg=r(e),I=l(e,"DIV",{class:!0});var Q=T(I);m(Ra.$$.fragment,Q),Lb=r(Q),Cd=l(Q,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-5jvlz5"&&(Cd.textContent=xM),Gb=r(Q),m(Fs.$$.fragment,Q),Cb=r(Q),m(Vs.$$.fragment,Q),Xb=r(Q),Ls=l(Q,"DIV",{class:!0});var cu=T(Ls);m(Na.$$.fragment,cu),Rb=r(cu),Xd=l(cu,"P",{"data-svelte-h":!0}),y(Xd)!=="svelte-10d94rs"&&(Xd.textContent=UM),cu.forEach(s),Nb=r(Q),Gs=l(Q,"DIV",{class:!0});var iu=T(Gs);m(Sa.$$.fragment,iu),Sb=r(iu),Rd=l(iu,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-tm945r"&&(Rd.textContent=zM),iu.forEach(s),Eb=r(Q),Cs=l(Q,"DIV",{class:!0});var du=T(Cs);m(Ea.$$.fragment,du),Hb=r(du),Nd=l(du,"P",{"data-svelte-h":!0}),y(Nd)!=="svelte-1i1356p"&&(Nd.textContent=BM),du.forEach(s),Q.forEach(s),Hg=r(e),P=l(e,"DIV",{class:!0});var Mt=T(P);m(Ha.$$.fragment,Mt),qb=r(Mt),Sd=l(Mt,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-190fodr"&&(Sd.textContent=IM),Pb=r(Mt),m(Xs.$$.fragment,Mt),Db=r(Mt),m(Rs.$$.fragment,Mt),Qb=r(Mt),Ns=l(Mt,"DIV",{class:!0});var pu=T(Ns);m(qa.$$.fragment,pu),Yb=r(pu),Ed=l(pu,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-16i5iz"&&(Ed.textContent=ZM),pu.forEach(s),Mt.forEach(s),qg=r(e),Jp=l(e,"P",{}),T(Jp).forEach(s),this.h()},h(){M(i,"name","hf:doc:metadata"),M(i,"content",$w),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ll,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(El,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ni,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ii,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ui,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ci,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ri,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Si,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ls,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),d(e,j,c),d(e,b,c),d(e,_,c),g(w,e,c),d(e,n,c),d(e,k,c),d(e,Vp,c),g(on,e,c),d(e,Lp,c),d(e,rn,c),d(e,Gp,c),g(an,e,c),d(e,Cp,c),d(e,ln,c),d(e,Xp,c),d(e,cn,c),d(e,Rp,c),d(e,dn,c),d(e,Np,c),d(e,pn,c),d(e,Sp,c),d(e,mn,c),d(e,Ep,c),g(gn,e,c),d(e,Hp,c),d(e,un,c),d(e,qp,c),d(e,hn,c),d(e,Pp,c),d(e,fn,c),d(e,Dp,c),g(_n,e,c),d(e,Qp,c),d(e,vt,c),g(bn,vt,null),t(vt,mu),t(vt,dl),d(e,Yp,c),d(e,wt,c),g(yn,wt,null),t(wt,gu),t(wt,pl),d(e,Ap,c),d(e,kt,c),g(Tn,kt,null),t(kt,uu),t(kt,ml),d(e,Op,c),d(e,jt,c),g(Mn,jt,null),t(jt,hu),t(jt,gl),d(e,Kp,c),g(vn,e,c),d(e,em,c),d(e,$t,c),g(wn,$t,null),t($t,fu),t($t,ul),d(e,tm,c),d(e,Jt,c),g(kn,Jt,null),t(Jt,_u),t(Jt,hl),d(e,sm,c),d(e,xt,c),g(jn,xt,null),t(xt,bu),t(xt,fl),d(e,nm,c),d(e,Ut,c),g($n,Ut,null),t(Ut,yu),t(Ut,_l),d(e,om,c),d(e,zt,c),g(Jn,zt,null),t(zt,Tu),t(zt,bl),d(e,rm,c),d(e,Bt,c),g(xn,Bt,null),t(Bt,Mu),t(Bt,yl),d(e,am,c),d(e,It,c),g(Un,It,null),t(It,vu),t(It,Tl),d(e,lm,c),d(e,Zt,c),g(zn,Zt,null),t(Zt,wu),t(Zt,Ml),d(e,cm,c),d(e,Wt,c),g(Bn,Wt,null),t(Wt,ku),t(Wt,vl),d(e,im,c),d(e,Ft,c),g(In,Ft,null),t(Ft,ju),t(Ft,wl),d(e,dm,c),g(Zn,e,c),d(e,pm,c),d(e,ve,c),g(Wn,ve,null),t(ve,$u),t(ve,kl),t(ve,Ju),t(ve,Nt),g(Fn,Nt,null),t(Nt,xu),t(Nt,jl),d(e,mm,c),d(e,we,c),g(Vn,we,null),t(we,Uu),t(we,$l),t(we,zu),t(we,St),g(Ln,St,null),t(St,Bu),t(St,Jl),d(e,gm,c),d(e,ke,c),g(Gn,ke,null),t(ke,Iu),t(ke,xl),t(ke,Zu),t(ke,Et),g(Cn,Et,null),t(Et,Wu),t(Et,Ul),d(e,um,c),g(Xn,e,c),d(e,hm,c),d(e,Rn,c),d(e,fm,c),g(Nn,e,c),d(e,_m,c),d(e,A,c),g(Sn,A,null),t(A,Fu),t(A,zl),t(A,Vu),g(Ht,A,null),t(A,Lu),t(A,Bl),g(En,Bl,null),d(e,bm,c),d(e,Z,c),g(Hn,Z,null),t(Z,Gu),t(Z,Il),t(Z,Cu),t(Z,Zl),t(Z,Xu),g(qt,Z,null),t(Z,Ru),g(Pt,Z,null),t(Z,Nu),t(Z,Wl),g(qn,Wl,null),d(e,ym,c),d(e,L,c),g(Pn,L,null),t(L,Su),t(L,Fl),t(L,Eu),t(L,Vl),t(L,Hu),g(Dt,L,null),t(L,qu),t(L,Ll),g(Dn,Ll,null),d(e,Tm,c),d(e,G,c),g(Qn,G,null),t(G,Pu),t(G,Gl),t(G,Du),t(G,Cl),t(G,Qu),g(Qt,G,null),t(G,Yu),t(G,Xl),g(Yn,Xl,null),d(e,Mm,c),d(e,O,c),g(An,O,null),t(O,Au),t(O,Rl),t(O,Ou),g(Yt,O,null),t(O,Ku),t(O,Nl),g(On,Nl,null),d(e,vm,c),d(e,K,c),g(Kn,K,null),t(K,eh),t(K,Sl),t(K,th),g(At,K,null),t(K,sh),t(K,El),g(eo,El,null),d(e,wm,c),d(e,ee,c),g(to,ee,null),t(ee,nh),t(ee,Hl),t(ee,oh),g(Ot,ee,null),t(ee,rh),t(ee,ql),g(so,ql,null),d(e,km,c),d(e,te,c),g(no,te,null),t(te,ah),t(te,Pl),t(te,lh),g(Kt,te,null),t(te,ch),t(te,Dl),g(oo,Dl,null),d(e,jm,c),d(e,se,c),g(ro,se,null),t(se,ih),t(se,Ql),t(se,dh),g(es,se,null),t(se,ph),t(se,Yl),g(ao,Yl,null),d(e,$m,c),d(e,ne,c),g(lo,ne,null),t(ne,mh),t(ne,Al),t(ne,gh),g(ts,ne,null),t(ne,uh),t(ne,Ol),g(co,Ol,null),d(e,Jm,c),d(e,W,c),g(io,W,null),t(W,hh),t(W,Kl),t(W,fh),t(W,ec),t(W,_h),t(W,tc),t(W,bh),g(ss,W,null),t(W,yh),t(W,sc),g(po,sc,null),d(e,xm,c),d(e,oe,c),g(mo,oe,null),t(oe,Th),t(oe,nc),t(oe,Mh),t(oe,oc),t(oe,vh),t(oe,rc),g(go,rc,null),d(e,Um,c),d(e,re,c),g(uo,re,null),t(re,wh),t(re,ac),t(re,kh),g(ns,re,null),t(re,jh),t(re,lc),g(ho,lc,null),d(e,zm,c),d(e,je,c),g(fo,je,null),t(je,$h),t(je,cc),t(je,Jh),t(je,ic),g(_o,ic,null),d(e,Bm,c),d(e,$e,c),g(bo,$e,null),t($e,xh),t($e,dc),t($e,Uh),t($e,pc),g(yo,pc,null),d(e,Im,c),d(e,Je,c),g(To,Je,null),t(Je,zh),t(Je,mc),t(Je,Bh),t(Je,gc),g(Mo,gc,null),d(e,Zm,c),d(e,ae,c),g(vo,ae,null),t(ae,Ih),t(ae,uc),t(ae,Zh),g(os,ae,null),t(ae,Wh),t(ae,hc),g(wo,hc,null),d(e,Wm,c),d(e,le,c),g(ko,le,null),t(le,Fh),t(le,fc),t(le,Vh),g(rs,le,null),t(le,Lh),t(le,_c),g(jo,_c,null),d(e,Fm,c),d(e,C,c),g($o,C,null),t(C,Gh),t(C,bc),t(C,Ch),g(as,C,null),t(C,Xh),g(ls,C,null),t(C,Rh),t(C,yc),g(Jo,yc,null),d(e,Vm,c),d(e,X,c),g(xo,X,null),t(X,Nh),t(X,Tc),t(X,Sh),g(cs,X,null),t(X,Eh),g(is,X,null),t(X,Hh),t(X,Mc),g(Uo,Mc,null),d(e,Lm,c),d(e,ce,c),g(zo,ce,null),t(ce,qh),t(ce,vc),t(ce,Ph),g(ds,ce,null),t(ce,Dh),t(ce,wc),g(Bo,wc,null),d(e,Gm,c),d(e,R,c),g(Io,R,null),t(R,Qh),t(R,kc),t(R,Yh),t(R,jc),t(R,Ah),g(ps,R,null),t(R,Oh),t(R,$c),g(Zo,$c,null),d(e,Cm,c),d(e,N,c),g(Wo,N,null),t(N,Kh),t(N,Jc),t(N,ef),g(ms,N,null),t(N,tf),g(gs,N,null),t(N,sf),t(N,xc),g(Fo,xc,null),d(e,Xm,c),d(e,ie,c),g(Vo,ie,null),t(ie,nf),t(ie,Uc),t(ie,of),g(us,ie,null),t(ie,rf),t(ie,zc),g(Lo,zc,null),d(e,Rm,c),d(e,de,c),g(Go,de,null),t(de,af),t(de,Bc),t(de,lf),g(hs,de,null),t(de,cf),t(de,Ic),g(Co,Ic,null),d(e,Nm,c),d(e,S,c),g(Xo,S,null),t(S,df),t(S,Zc),t(S,pf),g(fs,S,null),t(S,mf),g(_s,S,null),t(S,gf),t(S,Wc),g(Ro,Wc,null),d(e,Sm,c),d(e,pe,c),g(No,pe,null),t(pe,uf),t(pe,Fc),t(pe,hf),g(bs,pe,null),t(pe,ff),t(pe,Vc),g(So,Vc,null),d(e,Em,c),d(e,me,c),g(Eo,me,null),t(me,_f),t(me,Lc),t(me,bf),g(ys,me,null),t(me,yf),t(me,Gc),g(Ho,Gc,null),d(e,Hm,c),d(e,E,c),g(qo,E,null),t(E,Tf),t(E,Cc),t(E,Mf),t(E,Xc),t(E,vf),g(Ts,E,null),t(E,wf),t(E,Rc),g(Po,Rc,null),d(e,qm,c),d(e,H,c),g(Do,H,null),t(H,kf),t(H,Nc),t(H,jf),t(H,Sc),t(H,$f),g(Ms,H,null),t(H,Jf),t(H,Ec),g(Qo,Ec,null),d(e,Pm,c),d(e,q,c),g(Yo,q,null),t(q,xf),t(q,Hc),t(q,Uf),t(q,qc),t(q,zf),g(vs,q,null),t(q,Bf),t(q,Pc),g(Ao,Pc,null),d(e,Dm,c),g(Oo,e,c),d(e,Qm,c),d(e,xe,c),g(Ko,xe,null),t(xe,If),t(xe,Dc),t(xe,Zf),t(xe,Qc),g(er,Qc,null),d(e,Ym,c),d(e,Ue,c),g(tr,Ue,null),t(Ue,Wf),t(Ue,Yc),t(Ue,Ff),t(Ue,Ac),g(sr,Ac,null),d(e,Am,c),d(e,ze,c),g(nr,ze,null),t(ze,Vf),t(ze,Oc),t(ze,Lf),t(ze,Kc),g(or,Kc,null),d(e,Om,c),d(e,Be,c),g(rr,Be,null),t(Be,Gf),t(Be,ei),t(Be,Cf),t(Be,ws),g(ar,ws,null),t(ws,Xf),t(ws,ti),d(e,Km,c),d(e,Ie,c),g(lr,Ie,null),t(Ie,Rf),t(Ie,si),t(Ie,Nf),t(Ie,ni),g(cr,ni,null),d(e,eg,c),d(e,Ze,c),g(ir,Ze,null),t(Ze,Sf),t(Ze,oi),t(Ze,Ef),t(Ze,ks),g(dr,ks,null),t(ks,Hf),t(ks,ri),d(e,tg,c),d(e,We,c),g(pr,We,null),t(We,qf),t(We,ai),t(We,Pf),t(We,li),g(mr,li,null),d(e,sg,c),d(e,Fe,c),g(gr,Fe,null),t(Fe,Df),t(Fe,ci),t(Fe,Qf),t(Fe,ii),g(ur,ii,null),d(e,ng,c),d(e,Ve,c),g(hr,Ve,null),t(Ve,Yf),t(Ve,di),t(Ve,Af),t(Ve,pi),g(fr,pi,null),d(e,og,c),d(e,Le,c),g(_r,Le,null),t(Le,Of),t(Le,mi),t(Le,Kf),t(Le,gi),g(br,gi,null),d(e,rg,c),d(e,Ge,c),g(yr,Ge,null),t(Ge,e_),t(Ge,ui),t(Ge,t_),t(Ge,hi),g(Tr,hi,null),d(e,ag,c),d(e,Ce,c),g(Mr,Ce,null),t(Ce,s_),t(Ce,fi),t(Ce,n_),t(Ce,_i),g(vr,_i,null),d(e,lg,c),d(e,Xe,c),g(wr,Xe,null),t(Xe,o_),t(Xe,bi),t(Xe,r_),t(Xe,yi),g(kr,yi,null),d(e,cg,c),d(e,Re,c),g(jr,Re,null),t(Re,a_),t(Re,Ti),t(Re,l_),t(Re,Mi),g($r,Mi,null),d(e,ig,c),d(e,Ne,c),g(Jr,Ne,null),t(Ne,c_),t(Ne,vi),t(Ne,i_),t(Ne,wi),g(xr,wi,null),d(e,dg,c),g(Ur,e,c),d(e,pg,c),d(e,Se,c),g(zr,Se,null),t(Se,d_),t(Se,ki),t(Se,p_),t(Se,ji),g(Br,ji,null),d(e,mg,c),d(e,Ee,c),g(Ir,Ee,null),t(Ee,m_),t(Ee,$i),t(Ee,g_),t(Ee,Ji),g(Zr,Ji,null),d(e,gg,c),d(e,He,c),g(Wr,He,null),t(He,u_),t(He,xi),t(He,h_),t(He,Ui),g(Fr,Ui,null),d(e,ug,c),d(e,qe,c),g(Vr,qe,null),t(qe,f_),t(qe,zi),t(qe,__),t(qe,js),g(Lr,js,null),t(js,b_),t(js,Bi),d(e,hg,c),d(e,Pe,c),g(Gr,Pe,null),t(Pe,y_),t(Pe,Ii),t(Pe,T_),t(Pe,Zi),g(Cr,Zi,null),d(e,fg,c),d(e,De,c),g(Xr,De,null),t(De,M_),t(De,Wi),t(De,v_),t(De,$s),g(Rr,$s,null),t($s,w_),t($s,Fi),d(e,_g,c),d(e,Qe,c),g(Nr,Qe,null),t(Qe,k_),t(Qe,Vi),t(Qe,j_),t(Qe,Li),g(Sr,Li,null),d(e,bg,c),d(e,Ye,c),g(Er,Ye,null),t(Ye,$_),t(Ye,Gi),t(Ye,J_),t(Ye,Ci),g(Hr,Ci,null),d(e,yg,c),d(e,Ae,c),g(qr,Ae,null),t(Ae,x_),t(Ae,Xi),t(Ae,U_),t(Ae,Ri),g(Pr,Ri,null),d(e,Tg,c),d(e,Oe,c),g(Dr,Oe,null),t(Oe,z_),t(Oe,Ni),t(Oe,B_),t(Oe,Si),g(Qr,Si,null),d(e,Mg,c),d(e,Ke,c),g(Yr,Ke,null),t(Ke,I_),t(Ke,Ei),t(Ke,Z_),t(Ke,Hi),g(Ar,Hi,null),d(e,vg,c),d(e,et,c),g(Or,et,null),t(et,W_),t(et,qi),t(et,F_),t(et,Pi),g(Kr,Pi,null),d(e,wg,c),d(e,tt,c),g(ea,tt,null),t(tt,V_),t(tt,Di),t(tt,L_),t(tt,Qi),g(ta,Qi,null),d(e,kg,c),g(sa,e,c),d(e,jg,c),d(e,na,c),d(e,$g,c),d(e,ge,c),g(oa,ge,null),t(ge,G_),t(ge,Yi),t(ge,C_),t(ge,Ai),t(ge,X_),t(ge,Oi),g(ra,Oi,null),d(e,Jg,c),d(e,Vt,c),g(aa,Vt,null),t(Vt,R_),t(Vt,Ki),g(la,Ki,null),d(e,xg,c),d(e,st,c),g(ca,st,null),t(st,N_),t(st,ed),t(st,S_),t(st,td),g(ia,td,null),d(e,Ug,c),d(e,nt,c),g(da,nt,null),t(nt,E_),t(nt,sd),t(nt,H_),t(nt,nd),g(pa,nd,null),d(e,zg,c),g(ma,e,c),d(e,Bg,c),d(e,ga,c),d(e,Ig,c),d(e,U,c),g(ua,U,null),t(U,q_),t(U,od),t(U,P_),t(U,rd),t(U,D_),g(Js,U,null),t(U,Q_),t(U,ad),t(U,Y_),t(U,xs),g(ha,xs,null),t(xs,A_),t(xs,ld),t(U,O_),t(U,Us),g(fa,Us,null),t(Us,K_),t(Us,cd),t(U,eb),t(U,zs),g(_a,zs,null),t(zs,tb),t(zs,id),t(U,sb),t(U,Bs),g(ba,Bs,null),t(Bs,nb),t(Bs,dd),t(U,ob),t(U,Is),g(ya,Is,null),t(Is,rb),t(Is,pd),t(U,ab),t(U,Zs),g(Ta,Zs,null),t(Zs,lb),t(Zs,md),t(U,cb),t(U,mt),g(Ma,mt,null),t(mt,ib),t(mt,gd),t(mt,db),t(mt,ud),d(e,Zg,c),d(e,Lt,c),g(va,Lt,null),t(Lt,pb),t(Lt,hd),d(e,Wg,c),d(e,Gt,c),g(wa,Gt,null),t(Gt,mb),t(Gt,fd),d(e,Fg,c),d(e,ue,c),g(ka,ue,null),t(ue,gb),t(ue,_d),t(ue,ub),t(ue,V),g(ja,V,null),t(V,hb),t(V,bd),t(V,fb),t(V,yd),t(V,_b),t(V,Td),t(V,bb),t(V,Md),t(V,yb),t(V,vd),t(ue,Tb),t(ue,Ws),g($a,Ws,null),t(Ws,Mb),t(Ws,wd),d(e,Vg,c),g(Ja,e,c),d(e,Lg,c),d(e,he,c),g(xa,he,null),t(he,vb),t(he,kd),t(he,wb),t(he,jd),g(Ua,jd,null),t(he,kb),t(he,$d),g(za,$d,null),d(e,Gg,c),d(e,F,c),g(Ba,F,null),t(F,jb),t(F,Jd),t(F,$b),t(F,xd),t(F,Jb),t(F,Ud),t(F,xb),t(F,zd),g(Ia,zd,null),t(F,Ub),t(F,Bd),g(Za,Bd,null),d(e,Cg,c),d(e,fe,c),g(Wa,fe,null),t(fe,zb),t(fe,Id),t(fe,Bb),t(fe,Zd),g(Fa,Zd,null),t(fe,Ib),t(fe,Wd),g(Va,Wd,null),d(e,Xg,c),g(La,e,c),d(e,Rg,c),d(e,ot,c),g(Ga,ot,null),t(ot,Zb),t(ot,Fd),t(ot,Wb),t(ot,Vd),d(e,Ng,c),d(e,rt,c),g(Ca,rt,null),t(rt,Fb),t(rt,Ld),t(rt,Vb),t(rt,Gd),d(e,Sg,c),g(Xa,e,c),d(e,Eg,c),d(e,I,c),g(Ra,I,null),t(I,Lb),t(I,Cd),t(I,Gb),g(Fs,I,null),t(I,Cb),g(Vs,I,null),t(I,Xb),t(I,Ls),g(Na,Ls,null),t(Ls,Rb),t(Ls,Xd),t(I,Nb),t(I,Gs),g(Sa,Gs,null),t(Gs,Sb),t(Gs,Rd),t(I,Eb),t(I,Cs),g(Ea,Cs,null),t(Cs,Hb),t(Cs,Nd),d(e,Hg,c),d(e,P,c),g(Ha,P,null),t(P,qb),t(P,Sd),t(P,Pb),g(Xs,P,null),t(P,Db),g(Rs,P,null),t(P,Qb),t(P,Ns),g(qa,Ns,null),t(Ns,Yb),t(Ns,Ed),d(e,qg,c),d(e,Jp,c),Pg=!0},p(e,[c]){const Pa={};c&2&&(Pa.$$scope={dirty:c,ctx:e}),Ht.$set(Pa);const Da={};c&2&&(Da.$$scope={dirty:c,ctx:e}),qt.$set(Da);const Qa={};c&2&&(Qa.$$scope={dirty:c,ctx:e}),Pt.$set(Qa);const Ya={};c&2&&(Ya.$$scope={dirty:c,ctx:e}),Dt.$set(Ya);const Aa={};c&2&&(Aa.$$scope={dirty:c,ctx:e}),Qt.$set(Aa);const Oa={};c&2&&(Oa.$$scope={dirty:c,ctx:e}),Yt.$set(Oa);const Ka={};c&2&&(Ka.$$scope={dirty:c,ctx:e}),At.$set(Ka);const el={};c&2&&(el.$$scope={dirty:c,ctx:e}),Ot.$set(el);const tl={};c&2&&(tl.$$scope={dirty:c,ctx:e}),Kt.$set(tl);const sl={};c&2&&(sl.$$scope={dirty:c,ctx:e}),es.$set(sl);const nl={};c&2&&(nl.$$scope={dirty:c,ctx:e}),ts.$set(nl);const ol={};c&2&&(ol.$$scope={dirty:c,ctx:e}),ss.$set(ol);const rl={};c&2&&(rl.$$scope={dirty:c,ctx:e}),ns.$set(rl);const al={};c&2&&(al.$$scope={dirty:c,ctx:e}),os.$set(al);const Ct={};c&2&&(Ct.$$scope={dirty:c,ctx:e}),rs.$set(Ct);const ll={};c&2&&(ll.$$scope={dirty:c,ctx:e}),as.$set(ll);const Xt={};c&2&&(Xt.$$scope={dirty:c,ctx:e}),ls.$set(Xt);const cl={};c&2&&(cl.$$scope={dirty:c,ctx:e}),cs.$set(cl);const Rt={};c&2&&(Rt.$$scope={dirty:c,ctx:e}),is.$set(Rt);const il={};c&2&&(il.$$scope={dirty:c,ctx:e}),ds.$set(il);const at={};c&2&&(at.$$scope={dirty:c,ctx:e}),ps.$set(at);const xp={};c&2&&(xp.$$scope={dirty:c,ctx:e}),ms.$set(xp);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),gs.$set(D);const Up={};c&2&&(Up.$$scope={dirty:c,ctx:e}),us.$set(Up);const _e={};c&2&&(_e.$$scope={dirty:c,ctx:e}),hs.$set(_e);const zp={};c&2&&(zp.$$scope={dirty:c,ctx:e}),fs.$set(zp);const be={};c&2&&(be.$$scope={dirty:c,ctx:e}),_s.$set(be);const Bp={};c&2&&(Bp.$$scope={dirty:c,ctx:e}),bs.$set(Bp);const lt={};c&2&&(lt.$$scope={dirty:c,ctx:e}),ys.$set(lt);const Ip={};c&2&&(Ip.$$scope={dirty:c,ctx:e}),Ts.$set(Ip);const ct={};c&2&&(ct.$$scope={dirty:c,ctx:e}),Ms.$set(ct);const Zp={};c&2&&(Zp.$$scope={dirty:c,ctx:e}),vs.$set(Zp);const it={};c&2&&(it.$$scope={dirty:c,ctx:e}),Js.$set(it);const Wp={};c&2&&(Wp.$$scope={dirty:c,ctx:e}),Fs.$set(Wp);const dt={};c&2&&(dt.$$scope={dirty:c,ctx:e}),Vs.$set(dt);const Fp={};c&2&&(Fp.$$scope={dirty:c,ctx:e}),Xs.$set(Fp);const pt={};c&2&&(pt.$$scope={dirty:c,ctx:e}),Rs.$set(pt)},i(e){Pg||(u(w.$$.fragment,e),u(on.$$.fragment,e),u(an.$$.fragment,e),u(gn.$$.fragment,e),u(_n.$$.fragment,e),u(bn.$$.fragment,e),u(yn.$$.fragment,e),u(Tn.$$.fragment,e),u(Mn.$$.fragment,e),u(vn.$$.fragment,e),u(wn.$$.fragment,e),u(kn.$$.fragment,e),u(jn.$$.fragment,e),u($n.$$.fragment,e),u(Jn.$$.fragment,e),u(xn.$$.fragment,e),u(Un.$$.fragment,e),u(zn.$$.fragment,e),u(Bn.$$.fragment,e),u(In.$$.fragment,e),u(Zn.$$.fragment,e),u(Wn.$$.fragment,e),u(Fn.$$.fragment,e),u(Vn.$$.fragment,e),u(Ln.$$.fragment,e),u(Gn.$$.fragment,e),u(Cn.$$.fragment,e),u(Xn.$$.fragment,e),u(Nn.$$.fragment,e),u(Sn.$$.fragment,e),u(Ht.$$.fragment,e),u(En.$$.fragment,e),u(Hn.$$.fragment,e),u(qt.$$.fragment,e),u(Pt.$$.fragment,e),u(qn.$$.fragment,e),u(Pn.$$.fragment,e),u(Dt.$$.fragment,e),u(Dn.$$.fragment,e),u(Qn.$$.fragment,e),u(Qt.$$.fragment,e),u(Yn.$$.fragment,e),u(An.$$.fragment,e),u(Yt.$$.fragment,e),u(On.$$.fragment,e),u(Kn.$$.fragment,e),u(At.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(Ot.$$.fragment,e),u(so.$$.fragment,e),u(no.$$.fragment,e),u(Kt.$$.fragment,e),u(oo.$$.fragment,e),u(ro.$$.fragment,e),u(es.$$.fragment,e),u(ao.$$.fragment,e),u(lo.$$.fragment,e),u(ts.$$.fragment,e),u(co.$$.fragment,e),u(io.$$.fragment,e),u(ss.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(go.$$.fragment,e),u(uo.$$.fragment,e),u(ns.$$.fragment,e),u(ho.$$.fragment,e),u(fo.$$.fragment,e),u(_o.$$.fragment,e),u(bo.$$.fragment,e),u(yo.$$.fragment,e),u(To.$$.fragment,e),u(Mo.$$.fragment,e),u(vo.$$.fragment,e),u(os.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u(rs.$$.fragment,e),u(jo.$$.fragment,e),u($o.$$.fragment,e),u(as.$$.fragment,e),u(ls.$$.fragment,e),u(Jo.$$.fragment,e),u(xo.$$.fragment,e),u(cs.$$.fragment,e),u(is.$$.fragment,e),u(Uo.$$.fragment,e),u(zo.$$.fragment,e),u(ds.$$.fragment,e),u(Bo.$$.fragment,e),u(Io.$$.fragment,e),u(ps.$$.fragment,e),u(Zo.$$.fragment,e),u(Wo.$$.fragment,e),u(ms.$$.fragment,e),u(gs.$$.fragment,e),u(Fo.$$.fragment,e),u(Vo.$$.fragment,e),u(us.$$.fragment,e),u(Lo.$$.fragment,e),u(Go.$$.fragment,e),u(hs.$$.fragment,e),u(Co.$$.fragment,e),u(Xo.$$.fragment,e),u(fs.$$.fragment,e),u(_s.$$.fragment,e),u(Ro.$$.fragment,e),u(No.$$.fragment,e),u(bs.$$.fragment,e),u(So.$$.fragment,e),u(Eo.$$.fragment,e),u(ys.$$.fragment,e),u(Ho.$$.fragment,e),u(qo.$$.fragment,e),u(Ts.$$.fragment,e),u(Po.$$.fragment,e),u(Do.$$.fragment,e),u(Ms.$$.fragment,e),u(Qo.$$.fragment,e),u(Yo.$$.fragment,e),u(vs.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(er.$$.fragment,e),u(tr.$$.fragment,e),u(sr.$$.fragment,e),u(nr.$$.fragment,e),u(or.$$.fragment,e),u(rr.$$.fragment,e),u(ar.$$.fragment,e),u(lr.$$.fragment,e),u(cr.$$.fragment,e),u(ir.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(ur.$$.fragment,e),u(hr.$$.fragment,e),u(fr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u(Mr.$$.fragment,e),u(vr.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u(jr.$$.fragment,e),u($r.$$.fragment,e),u(Jr.$$.fragment,e),u(xr.$$.fragment,e),u(Ur.$$.fragment,e),u(zr.$$.fragment,e),u(Br.$$.fragment,e),u(Ir.$$.fragment,e),u(Zr.$$.fragment,e),u(Wr.$$.fragment,e),u(Fr.$$.fragment,e),u(Vr.$$.fragment,e),u(Lr.$$.fragment,e),u(Gr.$$.fragment,e),u(Cr.$$.fragment,e),u(Xr.$$.fragment,e),u(Rr.$$.fragment,e),u(Nr.$$.fragment,e),u(Sr.$$.fragment,e),u(Er.$$.fragment,e),u(Hr.$$.fragment,e),u(qr.$$.fragment,e),u(Pr.$$.fragment,e),u(Dr.$$.fragment,e),u(Qr.$$.fragment,e),u(Yr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(sa.$$.fragment,e),u(oa.$$.fragment,e),u(ra.$$.fragment,e),u(aa.$$.fragment,e),u(la.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ua.$$.fragment,e),u(Js.$$.fragment,e),u(ha.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(ya.$$.fragment,e),u(Ta.$$.fragment,e),u(Ma.$$.fragment,e),u(va.$$.fragment,e),u(wa.$$.fragment,e),u(ka.$$.fragment,e),u(ja.$$.fragment,e),u($a.$$.fragment,e),u(Ja.$$.fragment,e),u(xa.$$.fragment,e),u(Ua.$$.fragment,e),u(za.$$.fragment,e),u(Ba.$$.fragment,e),u(Ia.$$.fragment,e),u(Za.$$.fragment,e),u(Wa.$$.fragment,e),u(Fa.$$.fragment,e),u(Va.$$.fragment,e),u(La.$$.fragment,e),u(Ga.$$.fragment,e),u(Ca.$$.fragment,e),u(Xa.$$.fragment,e),u(Ra.$$.fragment,e),u(Fs.$$.fragment,e),u(Vs.$$.fragment,e),u(Na.$$.fragment,e),u(Sa.$$.fragment,e),u(Ea.$$.fragment,e),u(Ha.$$.fragment,e),u(Xs.$$.fragment,e),u(Rs.$$.fragment,e),u(qa.$$.fragment,e),Pg=!0)},o(e){h(w.$$.fragment,e),h(on.$$.fragment,e),h(an.$$.fragment,e),h(gn.$$.fragment,e),h(_n.$$.fragment,e),h(bn.$$.fragment,e),h(yn.$$.fragment,e),h(Tn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(wn.$$.fragment,e),h(kn.$$.fragment,e),h(jn.$$.fragment,e),h($n.$$.fragment,e),h(Jn.$$.fragment,e),h(xn.$$.fragment,e),h(Un.$$.fragment,e),h(zn.$$.fragment,e),h(Bn.$$.fragment,e),h(In.$$.fragment,e),h(Zn.$$.fragment,e),h(Wn.$$.fragment,e),h(Fn.$$.fragment,e),h(Vn.$$.fragment,e),h(Ln.$$.fragment,e),h(Gn.$$.fragment,e),h(Cn.$$.fragment,e),h(Xn.$$.fragment,e),h(Nn.$$.fragment,e),h(Sn.$$.fragment,e),h(Ht.$$.fragment,e),h(En.$$.fragment,e),h(Hn.$$.fragment,e),h(qt.$$.fragment,e),h(Pt.$$.fragment,e),h(qn.$$.fragment,e),h(Pn.$$.fragment,e),h(Dt.$$.fragment,e),h(Dn.$$.fragment,e),h(Qn.$$.fragment,e),h(Qt.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(Yt.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(At.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(Ot.$$.fragment,e),h(so.$$.fragment,e),h(no.$$.fragment,e),h(Kt.$$.fragment,e),h(oo.$$.fragment,e),h(ro.$$.fragment,e),h(es.$$.fragment,e),h(ao.$$.fragment,e),h(lo.$$.fragment,e),h(ts.$$.fragment,e),h(co.$$.fragment,e),h(io.$$.fragment,e),h(ss.$$.fragment,e),h(po.$$.fragment,e),h(mo.$$.fragment,e),h(go.$$.fragment,e),h(uo.$$.fragment,e),h(ns.$$.fragment,e),h(ho.$$.fragment,e),h(fo.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(To.$$.fragment,e),h(Mo.$$.fragment,e),h(vo.$$.fragment,e),h(os.$$.fragment,e),h(wo.$$.fragment,e),h(ko.$$.fragment,e),h(rs.$$.fragment,e),h(jo.$$.fragment,e),h($o.$$.fragment,e),h(as.$$.fragment,e),h(ls.$$.fragment,e),h(Jo.$$.fragment,e),h(xo.$$.fragment,e),h(cs.$$.fragment,e),h(is.$$.fragment,e),h(Uo.$$.fragment,e),h(zo.$$.fragment,e),h(ds.$$.fragment,e),h(Bo.$$.fragment,e),h(Io.$$.fragment,e),h(ps.$$.fragment,e),h(Zo.$$.fragment,e),h(Wo.$$.fragment,e),h(ms.$$.fragment,e),h(gs.$$.fragment,e),h(Fo.$$.fragment,e),h(Vo.$$.fragment,e),h(us.$$.fragment,e),h(Lo.$$.fragment,e),h(Go.$$.fragment,e),h(hs.$$.fragment,e),h(Co.$$.fragment,e),h(Xo.$$.fragment,e),h(fs.$$.fragment,e),h(_s.$$.fragment,e),h(Ro.$$.fragment,e),h(No.$$.fragment,e),h(bs.$$.fragment,e),h(So.$$.fragment,e),h(Eo.$$.fragment,e),h(ys.$$.fragment,e),h(Ho.$$.fragment,e),h(qo.$$.fragment,e),h(Ts.$$.fragment,e),h(Po.$$.fragment,e),h(Do.$$.fragment,e),h(Ms.$$.fragment,e),h(Qo.$$.fragment,e),h(Yo.$$.fragment,e),h(vs.$$.fragment,e),h(Ao.$$.fragment,e),h(Oo.$$.fragment,e),h(Ko.$$.fragment,e),h(er.$$.fragment,e),h(tr.$$.fragment,e),h(sr.$$.fragment,e),h(nr.$$.fragment,e),h(or.$$.fragment,e),h(rr.$$.fragment,e),h(ar.$$.fragment,e),h(lr.$$.fragment,e),h(cr.$$.fragment,e),h(ir.$$.fragment,e),h(dr.$$.fragment,e),h(pr.$$.fragment,e),h(mr.$$.fragment,e),h(gr.$$.fragment,e),h(ur.$$.fragment,e),h(hr.$$.fragment,e),h(fr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(yr.$$.fragment,e),h(Tr.$$.fragment,e),h(Mr.$$.fragment,e),h(vr.$$.fragment,e),h(wr.$$.fragment,e),h(kr.$$.fragment,e),h(jr.$$.fragment,e),h($r.$$.fragment,e),h(Jr.$$.fragment,e),h(xr.$$.fragment,e),h(Ur.$$.fragment,e),h(zr.$$.fragment,e),h(Br.$$.fragment,e),h(Ir.$$.fragment,e),h(Zr.$$.fragment,e),h(Wr.$$.fragment,e),h(Fr.$$.fragment,e),h(Vr.$$.fragment,e),h(Lr.$$.fragment,e),h(Gr.$$.fragment,e),h(Cr.$$.fragment,e),h(Xr.$$.fragment,e),h(Rr.$$.fragment,e),h(Nr.$$.fragment,e),h(Sr.$$.fragment,e),h(Er.$$.fragment,e),h(Hr.$$.fragment,e),h(qr.$$.fragment,e),h(Pr.$$.fragment,e),h(Dr.$$.fragment,e),h(Qr.$$.fragment,e),h(Yr.$$.fragment,e),h(Ar.$$.fragment,e),h(Or.$$.fragment,e),h(Kr.$$.fragment,e),h(ea.$$.fragment,e),h(ta.$$.fragment,e),h(sa.$$.fragment,e),h(oa.$$.fragment,e),h(ra.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(ca.$$.fragment,e),h(ia.$$.fragment,e),h(da.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ua.$$.fragment,e),h(Js.$$.fragment,e),h(ha.$$.fragment,e),h(fa.$$.fragment,e),h(_a.$$.fragment,e),h(ba.$$.fragment,e),h(ya.$$.fragment,e),h(Ta.$$.fragment,e),h(Ma.$$.fragment,e),h(va.$$.fragment,e),h(wa.$$.fragment,e),h(ka.$$.fragment,e),h(ja.$$.fragment,e),h($a.$$.fragment,e),h(Ja.$$.fragment,e),h(xa.$$.fragment,e),h(Ua.$$.fragment,e),h(za.$$.fragment,e),h(Ba.$$.fragment,e),h(Ia.$$.fragment,e),h(Za.$$.fragment,e),h(Wa.$$.fragment,e),h(Fa.$$.fragment,e),h(Va.$$.fragment,e),h(La.$$.fragment,e),h(Ga.$$.fragment,e),h(Ca.$$.fragment,e),h(Xa.$$.fragment,e),h(Ra.$$.fragment,e),h(Fs.$$.fragment,e),h(Vs.$$.fragment,e),h(Na.$$.fragment,e),h(Sa.$$.fragment,e),h(Ea.$$.fragment,e),h(Ha.$$.fragment,e),h(Xs.$$.fragment,e),h(Rs.$$.fragment,e),h(qa.$$.fragment,e),Pg=!1},d(e){e&&(s(j),s(b),s(_),s(n),s(k),s(Vp),s(Lp),s(rn),s(Gp),s(Cp),s(ln),s(Xp),s(cn),s(Rp),s(dn),s(Np),s(pn),s(Sp),s(mn),s(Ep),s(Hp),s(un),s(qp),s(hn),s(Pp),s(fn),s(Dp),s(Qp),s(vt),s(Yp),s(wt),s(Ap),s(kt),s(Op),s(jt),s(Kp),s(em),s($t),s(tm),s(Jt),s(sm),s(xt),s(nm),s(Ut),s(om),s(zt),s(rm),s(Bt),s(am),s(It),s(lm),s(Zt),s(cm),s(Wt),s(im),s(Ft),s(dm),s(pm),s(ve),s(mm),s(we),s(gm),s(ke),s(um),s(hm),s(Rn),s(fm),s(_m),s(A),s(bm),s(Z),s(ym),s(L),s(Tm),s(G),s(Mm),s(O),s(vm),s(K),s(wm),s(ee),s(km),s(te),s(jm),s(se),s($m),s(ne),s(Jm),s(W),s(xm),s(oe),s(Um),s(re),s(zm),s(je),s(Bm),s($e),s(Im),s(Je),s(Zm),s(ae),s(Wm),s(le),s(Fm),s(C),s(Vm),s(X),s(Lm),s(ce),s(Gm),s(R),s(Cm),s(N),s(Xm),s(ie),s(Rm),s(de),s(Nm),s(S),s(Sm),s(pe),s(Em),s(me),s(Hm),s(E),s(qm),s(H),s(Pm),s(q),s(Dm),s(Qm),s(xe),s(Ym),s(Ue),s(Am),s(ze),s(Om),s(Be),s(Km),s(Ie),s(eg),s(Ze),s(tg),s(We),s(sg),s(Fe),s(ng),s(Ve),s(og),s(Le),s(rg),s(Ge),s(ag),s(Ce),s(lg),s(Xe),s(cg),s(Re),s(ig),s(Ne),s(dg),s(pg),s(Se),s(mg),s(Ee),s(gg),s(He),s(ug),s(qe),s(hg),s(Pe),s(fg),s(De),s(_g),s(Qe),s(bg),s(Ye),s(yg),s(Ae),s(Tg),s(Oe),s(Mg),s(Ke),s(vg),s(et),s(wg),s(tt),s(kg),s(jg),s(na),s($g),s(ge),s(Jg),s(Vt),s(xg),s(st),s(Ug),s(nt),s(zg),s(Bg),s(ga),s(Ig),s(U),s(Zg),s(Lt),s(Wg),s(Gt),s(Fg),s(ue),s(Vg),s(Lg),s(he),s(Gg),s(F),s(Cg),s(fe),s(Xg),s(Rg),s(ot),s(Ng),s(rt),s(Sg),s(Eg),s(I),s(Hg),s(P),s(qg),s(Jp)),s(i),f(w,e),f(on,e),f(an,e),f(gn,e),f(_n,e),f(bn),f(yn),f(Tn),f(Mn),f(vn,e),f(wn),f(kn),f(jn),f($n),f(Jn),f(xn),f(Un),f(zn),f(Bn),f(In),f(Zn,e),f(Wn),f(Fn),f(Vn),f(Ln),f(Gn),f(Cn),f(Xn,e),f(Nn,e),f(Sn),f(Ht),f(En),f(Hn),f(qt),f(Pt),f(qn),f(Pn),f(Dt),f(Dn),f(Qn),f(Qt),f(Yn),f(An),f(Yt),f(On),f(Kn),f(At),f(eo),f(to),f(Ot),f(so),f(no),f(Kt),f(oo),f(ro),f(es),f(ao),f(lo),f(ts),f(co),f(io),f(ss),f(po),f(mo),f(go),f(uo),f(ns),f(ho),f(fo),f(_o),f(bo),f(yo),f(To),f(Mo),f(vo),f(os),f(wo),f(ko),f(rs),f(jo),f($o),f(as),f(ls),f(Jo),f(xo),f(cs),f(is),f(Uo),f(zo),f(ds),f(Bo),f(Io),f(ps),f(Zo),f(Wo),f(ms),f(gs),f(Fo),f(Vo),f(us),f(Lo),f(Go),f(hs),f(Co),f(Xo),f(fs),f(_s),f(Ro),f(No),f(bs),f(So),f(Eo),f(ys),f(Ho),f(qo),f(Ts),f(Po),f(Do),f(Ms),f(Qo),f(Yo),f(vs),f(Ao),f(Oo,e),f(Ko),f(er),f(tr),f(sr),f(nr),f(or),f(rr),f(ar),f(lr),f(cr),f(ir),f(dr),f(pr),f(mr),f(gr),f(ur),f(hr),f(fr),f(_r),f(br),f(yr),f(Tr),f(Mr),f(vr),f(wr),f(kr),f(jr),f($r),f(Jr),f(xr),f(Ur,e),f(zr),f(Br),f(Ir),f(Zr),f(Wr),f(Fr),f(Vr),f(Lr),f(Gr),f(Cr),f(Xr),f(Rr),f(Nr),f(Sr),f(Er),f(Hr),f(qr),f(Pr),f(Dr),f(Qr),f(Yr),f(Ar),f(Or),f(Kr),f(ea),f(ta),f(sa,e),f(oa),f(ra),f(aa),f(la),f(ca),f(ia),f(da),f(pa),f(ma,e),f(ua),f(Js),f(ha),f(fa),f(_a),f(ba),f(ya),f(Ta),f(Ma),f(va),f(wa),f(ka),f(ja),f($a),f(Ja,e),f(xa),f(Ua),f(za),f(Ba),f(Ia),f(Za),f(Wa),f(Fa),f(Va),f(La,e),f(Ga),f(Ca),f(Xa,e),f(Ra),f(Fs),f(Vs),f(Na),f(Sa),f(Ea),f(Ha),f(Xs),f(Rs),f(qa)}}}const $w='{"title":"用于生成的工具","local":"用于生成的工具","sections":[{"title":"生成输出","local":"生成输出","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Utilities","local":"transformers.top_k_top_p_filtering","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2}],"depth":1}';function Jw($){return Gv(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fw extends Cv{constructor(i){super(),Xv(this,i,Jw,jw,Lv,{})}}export{Fw as component};
