import{s as ve,n as We,o as _e}from"../chunks/scheduler.9bc65507.js";import{S as Re,i as Je,g as o,s as n,r as c,A as Ne,h as i,f as s,c as l,j as $e,u as r,x as m,k as Ue,l as Ze,y as Ye,a,v as u,d as b,t as f,w as g}from"../chunks/index.707bf1b6.js";import{C as z}from"../chunks/CodeBlock.54a9f38d.js";import{H as ce}from"../chunks/Heading.342b1fa6.js";function Be(re){let p,x,V,H,M,S,y,ue="Backbones are models used for feature extraction for computer vision tasks. One can use a model as backbone in two ways:",G,k,be="<li>initializing <code>AutoBackbone</code> class with a pretrained model,</li> <li>initializing a supported backbone configuration and passing it to the model architecture.</li>",E,j,Q,w,fe=`You can use <code>AutoBackbone</code> class to initialize a model as a backbone and get the feature maps for any stage. You can define <code>out_indices</code> to indicate the index of the layers which you would like to get the feature maps from. You can also use <code>out_features</code> if you know the name of the layers. You can use them interchangeably. If you are using both <code>out_indices</code> and <code>out_features</code>, ensure they are consistent. Not passing any of the feature map arguments will make the backbone yield the feature maps of the last layer.
To visualize how stages look like, let’s take the Swin model. Each stage is responsible from feature extraction, outputting feature maps.`,I,d,ge='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Swin%20Stages.png"/>',L,C,de="Illustrating feature maps of the first stage looks like below.",A,h,he='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Swin%20Stage%201.png"/>',q,$,Me="Let’s see with an example. Note that <code>out_indices=(0,)</code> results in yielding the stem of the model. Stem refers to the stage before the first feature extraction stage. In above diagram, it refers to patch partition. We would like to have the feature maps from stem, first, and second stage of the model.",P,U,K,Z,ye="<code>feature_maps</code> object now has three feature maps, each can be accessed like below. Say we would like to get the feature map of the stem.",D,v,O,W,ke="We can get the feature maps of first and second stages like below.",ee,_,te,R,se,J,je='In computer vision, models consist of backbone, neck, and a head. Backbone extracts the features, neck transforms the output of the backbone and head is used for the main task (e.g. object detection). You can initialize neck and head with model backbones by passing a model configuration to <code>backbone_config</code>. For example, below you can see how to initialize the <a href="../model_doc/maskformer">MaskFormer</a> model with instance segmentation head with <a href="../model_doc/resnet">ResNet</a> backbone.',ae,N,ne,Y,we="You can also initialize a backbone with random weights to initialize the model neck with it.",le,B,oe,F,Ce="<code>timm</code> models are also supported in transformers through <code>TimmBackbone</code> and <code>TimmBackboneConfig</code>.",ie,T,me,X,pe;return M=new ce({props:{title:"Backbones",local:"backbones",headingTag:"h1"}}),j=new ce({props:{title:"Using AutoBackbone",local:"using-autobackbone",headingTag:"h2"}}),U=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9CYWNrYm9uZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvQmFja2JvbmUuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIlMkMlMjBvdXRfaW5kaWNlcyUzRCgwJTJDMSUyQzIpKSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFmZWF0dXJlX21hcHMlMjAlM0QlMjBvdXRwdXRzLmZlYXR1cmVfbWFwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoBackbone
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoBackbone.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>, out_indices=(<span class="hljs-number">0</span>,<span class="hljs-number">1</span>,<span class="hljs-number">2</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_maps = outputs.feature_maps`,wrap:!1}}),v=new z({props:{code:"bGlzdChmZWF0dXJlX21hcHMlNUIwJTVELnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[<span class="hljs-number">0</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">96</span>, <span class="hljs-number">56</span>, <span class="hljs-number">56</span>]`,wrap:!1}}),_=new z({props:{code:"bGlzdChmZWF0dXJlX21hcHMlNUIxJTVELnNoYXBlKSUwQWxpc3QoZmVhdHVyZV9tYXBzJTVCMiU1RC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[<span class="hljs-number">1</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">96</span>, <span class="hljs-number">56</span>, <span class="hljs-number">56</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[<span class="hljs-number">2</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">192</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>]`,wrap:!1}}),R=new ce({props:{title:"Initializing Backbone Configuration",local:"initializing-backbone-configuration",headingTag:"h2"}}),N=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2tGb3JtZXJDb25maWclMkMlMjBNYXNrRm9ybWVyRm9ySW5zdGFuY2VTZWdtZW50YXRpb24lMkMlMjBSZXNOZXRDb25maWclMEElMEFiYWNrYm9uZV9jb25maWclMjAlM0QlMjBSZXNOZXRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEFjb25maWclMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKGJhY2tib25lX2NvbmZpZyUzRGJhY2tib25lX2NvbmZpZyklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbihjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MaskFormerConfig, MaskFormerForInstanceSegmentation, ResNetConfig

backbone_config = ResNetConfig.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
config = MaskFormerConfig(backbone_config=backbone_config)
model = MaskFormerForInstanceSegmentation(config)`,wrap:!1}}),B=new z({props:{code:"YmFja2JvbmVfY29uZmlnJTIwJTNEJTIwUmVzTmV0Q29uZmlnKCklMEFjb25maWclMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKGJhY2tib25lX2NvbmZpZyUzRGJhY2tib25lX2NvbmZpZyklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbihjb25maWcp",highlighted:`backbone_config = ResNetConfig()
config = MaskFormerConfig(backbone_config=backbone_config)
model = MaskFormerForInstanceSegmentation(config)`,wrap:!1}}),T=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRpbW1CYWNrYm9uZUNvbmZpZyUyQyUyMFRpbW1CYWNrYm9uZSUwQSUwQWJhY2tib25lX2NvbmZpZyUyMCUzRCUyMFRpbW1CYWNrYm9uZUNvbmZpZyglMjJyZXNuZXQ1MCUyMiklMEFtb2RlbCUyMCUzRCUyMFRpbW1CYWNrYm9uZShjb25maWclM0RiYWNrYm9uZV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TimmBackboneConfig, TimmBackbone

backbone_config = TimmBackboneConfig(<span class="hljs-string">&quot;resnet50&quot;</span>)
model = TimmBackbone(config=backbone_config)`,wrap:!1}}),{c(){p=o("meta"),x=n(),V=o("p"),H=n(),c(M.$$.fragment),S=n(),y=o("p"),y.textContent=ue,G=n(),k=o("ul"),k.innerHTML=be,E=n(),c(j.$$.fragment),Q=n(),w=o("p"),w.innerHTML=fe,I=n(),d=o("div"),d.innerHTML=ge,L=n(),C=o("p"),C.textContent=de,A=n(),h=o("div"),h.innerHTML=he,q=n(),$=o("p"),$.innerHTML=Me,P=n(),c(U.$$.fragment),K=n(),Z=o("p"),Z.innerHTML=ye,D=n(),c(v.$$.fragment),O=n(),W=o("p"),W.textContent=ke,ee=n(),c(_.$$.fragment),te=n(),c(R.$$.fragment),se=n(),J=o("p"),J.innerHTML=je,ae=n(),c(N.$$.fragment),ne=n(),Y=o("p"),Y.textContent=we,le=n(),c(B.$$.fragment),oe=n(),F=o("p"),F.innerHTML=Ce,ie=n(),c(T.$$.fragment),me=n(),X=o("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(s),x=l(e),V=i(e,"P",{}),$e(V).forEach(s),H=l(e),r(M.$$.fragment,e),S=l(e),y=i(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1832fle"&&(y.textContent=ue),G=l(e),k=i(e,"UL",{"data-svelte-h":!0}),m(k)!=="svelte-19aqc1k"&&(k.innerHTML=be),E=l(e),r(j.$$.fragment,e),Q=l(e),w=i(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-4yx6a9"&&(w.innerHTML=fe),I=l(e),d=i(e,"DIV",{style:!0,"data-svelte-h":!0}),m(d)!=="svelte-1r87dp3"&&(d.innerHTML=ge),L=l(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1s6jmuf"&&(C.textContent=de),A=l(e),h=i(e,"DIV",{style:!0,"data-svelte-h":!0}),m(h)!=="svelte-1fx8pms"&&(h.innerHTML=he),q=l(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-19u2lr1"&&($.innerHTML=Me),P=l(e),r(U.$$.fragment,e),K=l(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-8vtz8w"&&(Z.innerHTML=ye),D=l(e),r(v.$$.fragment,e),O=l(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1ifuecp"&&(W.textContent=ke),ee=l(e),r(_.$$.fragment,e),te=l(e),r(R.$$.fragment,e),se=l(e),J=i(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1ge3jwq"&&(J.innerHTML=je),ae=l(e),r(N.$$.fragment,e),ne=l(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-noz6gh"&&(Y.textContent=we),le=l(e),r(B.$$.fragment,e),oe=l(e),F=i(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-tvty3m"&&(F.innerHTML=Ce),ie=l(e),r(T.$$.fragment,e),me=l(e),X=i(e,"P",{}),$e(X).forEach(s),this.h()},h(){Ue(p,"name","hf:doc:metadata"),Ue(p,"content",Fe),Ze(d,"text-align","center"),Ze(h,"text-align","center")},m(e,t){Ye(document.head,p),a(e,x,t),a(e,V,t),a(e,H,t),u(M,e,t),a(e,S,t),a(e,y,t),a(e,G,t),a(e,k,t),a(e,E,t),u(j,e,t),a(e,Q,t),a(e,w,t),a(e,I,t),a(e,d,t),a(e,L,t),a(e,C,t),a(e,A,t),a(e,h,t),a(e,q,t),a(e,$,t),a(e,P,t),u(U,e,t),a(e,K,t),a(e,Z,t),a(e,D,t),u(v,e,t),a(e,O,t),a(e,W,t),a(e,ee,t),u(_,e,t),a(e,te,t),u(R,e,t),a(e,se,t),a(e,J,t),a(e,ae,t),u(N,e,t),a(e,ne,t),a(e,Y,t),a(e,le,t),u(B,e,t),a(e,oe,t),a(e,F,t),a(e,ie,t),u(T,e,t),a(e,me,t),a(e,X,t),pe=!0},p:We,i(e){pe||(b(M.$$.fragment,e),b(j.$$.fragment,e),b(U.$$.fragment,e),b(v.$$.fragment,e),b(_.$$.fragment,e),b(R.$$.fragment,e),b(N.$$.fragment,e),b(B.$$.fragment,e),b(T.$$.fragment,e),pe=!0)},o(e){f(M.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(v.$$.fragment,e),f(_.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(B.$$.fragment,e),f(T.$$.fragment,e),pe=!1},d(e){e&&(s(x),s(V),s(H),s(S),s(y),s(G),s(k),s(E),s(Q),s(w),s(I),s(d),s(L),s(C),s(A),s(h),s(q),s($),s(P),s(K),s(Z),s(D),s(O),s(W),s(ee),s(te),s(se),s(J),s(ae),s(ne),s(Y),s(le),s(oe),s(F),s(ie),s(me),s(X)),s(p),g(M,e),g(j,e),g(U,e),g(v,e),g(_,e),g(R,e),g(N,e),g(B,e),g(T,e)}}}const Fe='{"title":"Backbones","local":"backbones","sections":[{"title":"Using AutoBackbone","local":"using-autobackbone","sections":[],"depth":2},{"title":"Initializing Backbone Configuration","local":"initializing-backbone-configuration","sections":[],"depth":2}],"depth":1}';function Te(re){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends Re{constructor(p){super(),Je(this,p,Te,Be,ve,{})}}export{He as component};
