import{s as Vl,o as Ql,n as qt}from"../chunks/scheduler.9bc65507.js";import{S as zl,i as El,g as o,s as n,r as m,A as Hl,h as i,f as l,c as a,j as Yl,u as c,x as r,k as Gl,y as Fl,a as s,v as d,d as y,t as u,w as f}from"../chunks/index.707bf1b6.js";import{T as Lt}from"../chunks/Tip.c2ecdbf4.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{H as We}from"../chunks/Heading.342b1fa6.js";function Sl(b){let M,J="If your model is very similar to a model inside the library, you can re-use the same configuration as this model.";return{c(){M=o("p"),M.textContent=J},l(p){M=i(p,"P",{"data-svelte-h":!0}),r(M)!=="svelte-alg4p1"&&(M.textContent=J)},m(p,h){s(p,M,h)},p:qt,d(p){p&&l(M)}}}function Ll(b){let M,J="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){M=o("p"),M.textContent=J},l(p){M=i(p,"P",{"data-svelte-h":!0}),r(M)!=="svelte-15rpg4"&&(M.textContent=J)},m(p,h){s(p,M,h)},p:qt,d(p){p&&l(M)}}}function ql(b){let M,J=`If copying a modeling files from the library, you will need to replace all the relative imports at the top of the file
to import from the <code>transformers</code> package.`;return{c(){M=o("p"),M.innerHTML=J},l(p){M=i(p,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1816fmc"&&(M.innerHTML=J)},m(p,h){s(p,M,h)},p:qt,d(p){p&&l(M)}}}function Pl(b){let M,J=`Use <code>register_for_auto_class()</code> if you want the code files to be copied. If you instead prefer to use code on the Hub from another repo,
you don’t need to call it. In cases where there’s more than one auto class, you can modify the <code>config.json</code> directly using the
following structure:`,p,h,j;return h=new T({props:{code:"JTIyYXV0b19tYXAlMjIlM0ElMjAlN0IlMjAlMjAlMjAlMjAlMjAlMEElMDklMjJBdXRvQ29uZmlnJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTBBJTA5JTIyQXV0b01vZGVsJTIyJTNBJTIwJTIyJTNDeW91ci1yZXBvLW5hbWUlM0UtLSUzQ2NvbmZpZy1uYW1lJTNFJTIyJTJDJTBBJTA5JTIyQXV0b01vZGVsRm9yJTNDVGFzayUzRSUyMiUzQSUyMCUyMiUzQ3lvdXItcmVwby1uYW1lJTNFLS0lM0Njb25maWctbmFtZSUzRSUyMiUyQyUyMCUyMCUyMCUyMCUwQSU3RCUyQw==",highlighted:`<span class="hljs-attr">&quot;auto_map&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>     
	<span class="hljs-attr">&quot;AutoConfig&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>     
	<span class="hljs-attr">&quot;AutoModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;AutoModelFor&lt;Task&gt;&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;your-repo-name&gt;--&lt;config-name&gt;&quot;</span><span class="hljs-punctuation">,</span>    
<span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>`,wrap:!1}}),{c(){M=o("p"),M.innerHTML=J,p=n(),m(h.$$.fragment)},l(w){M=i(w,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1rexmhi"&&(M.innerHTML=J),p=a(w),c(h.$$.fragment,w)},m(w,U){s(w,M,U),s(w,p,U),d(h,w,U),j=!0},p:qt,i(w){j||(y(h.$$.fragment,w),j=!0)},o(w){u(h.$$.fragment,w),j=!1},d(w){w&&(l(M),l(p)),f(h,w)}}}function Dl(b){let M,J,p,h,j,w,U,Pt=`The 🤗 Transformers library is designed to be easily extensible. Every model is fully coded in a given subfolder
of the repository with no abstraction, so you can easily copy a modeling file and tweak it to your needs.`,Re,Z,Dt=`If you are writing a brand new model, it might be easier to start from scratch. In this tutorial, we will show you
how to write a custom model and its configuration so it can be used inside Transformers, and how you can share it
with the community (with the code it relies on) so that anyone can use it, even if it’s not present in the 🤗
Transformers library.`,Xe,$,Kt=`We will illustrate all of this on a ResNet model, by wrapping the ResNet class of the
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm library</a> into a <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.`,xe,A,Ye,k,Ot=`Before we dive into the model, let’s first write its configuration. The configuration of a model is an object that
will contain all the necessary information to build the model. As we will see in the next section, the model can only
take a <code>config</code> to be initialized, so we really need that object to be as complete as possible.`,Ge,v,el=`In our example, we will take a couple of arguments of the ResNet class that we might want to tweak. Different
configurations will then give us the different types of ResNets that are possible. We then just store those arguments,
after checking the validity of a few of them.`,Ve,N,Qe,W,tl="The three important things to remember when writing you own configuration are the following:",ze,B,ll="<li>you have to inherit from <code>PretrainedConfig</code>,</li> <li>the <code>__init__</code> of your <code>PretrainedConfig</code> must accept any kwargs,</li> <li>those <code>kwargs</code> need to be passed to the superclass <code>__init__</code>.</li>",Ee,R,sl=`The inheritance is to make sure you get all the functionality from the 🤗 Transformers library, while the two other
constraints come from the fact a <code>PretrainedConfig</code> has more fields than the ones you are setting. When reloading a
config with the <code>from_pretrained</code> method, those fields need to be accepted by your config and then sent to the
superclass.`,He,X,nl=`Defining a <code>model_type</code> for your configuration (here <code>model_type=&quot;resnet&quot;</code>) is not mandatory, unless you want to
register your model with the auto classes (see last section).`,Fe,x,al=`With this done, you can easily create and save your configuration like you would do with any other model config of the
library. Here is how we can create a resnet50d config and save it:`,Se,Y,Le,G,ol=`This will save a file named <code>config.json</code> inside the folder <code>custom-resnet</code>. You can then reload your config with the
<code>from_pretrained</code> method:`,qe,V,Pe,Q,il=`You can also use any other method of the <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> class, like <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a> to
directly upload your config to the Hub.`,De,z,Ke,E,rl=`Now that we have our ResNet configuration, we can go on writing the model. We will actually write two: one that
extracts the hidden features from a batch of images (like <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertModel">BertModel</a>) and one that is suitable for image
classification (like <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>).`,Oe,H,Ml=`As we mentioned before, we’ll only write a loose wrapper of the model to keep it simple for this example. The only
thing we need to do before writing this class is a map between the block types and actual block classes. Then the
model is defined from the configuration by passing everything to the <code>ResNet</code> class:`,et,F,tt,S,pl="For the model that will classify images, we just change the forward method:",lt,L,st,q,ml=`In both cases, notice how we inherit from <code>PreTrainedModel</code> and call the superclass initialization with the <code>config</code>
(a bit like when you write a regular <code>torch.nn.Module</code>). The line that sets the <code>config_class</code> is not mandatory, unless
you want to register your model with the auto classes (see last section).`,nt,C,at,P,cl=`You can have your model return anything you want, but returning a dictionary like we did for
<code>ResnetModelForImageClassification</code>, with the loss included when labels are passed, will make your model directly
usable inside the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> class. Using another output format is fine as long as you are planning on using your own
training loop or another library for training.`,ot,D,dl="Now that we have our model class, let’s create one:",it,K,rt,O,yl=`Again, you can use any of the methods of <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, like <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or
<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a>. We will use the second in the next section, and see how to push the model weights
with the code of our model. But first, let’s load some pretrained weights inside our model.`,Mt,ee,ul=`In your own use case, you will probably be training your custom model on your own data. To go fast for this tutorial,
we will use the pretrained version of the resnet50d. Since our model is just a wrapper around it, it’s going to be
easy to transfer those weights:`,pt,te,mt,le,fl=`Now let’s see how to make sure that when we do <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> or <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a>, the
code of the model is saved.`,ct,se,dt,g,yt,ne,wl=`First, make sure your model is fully defined in a <code>.py</code> file. It can rely on relative imports to some other files as
long as all the files are in the same directory (we don’t support submodules for this feature yet). For our example,
we’ll define a <code>modeling_resnet.py</code> file and a <code>configuration_resnet.py</code> file in a folder of the current working
directory named <code>resnet_model</code>. The configuration file contains the code for <code>ResnetConfig</code> and the modeling file
contains the code of <code>ResnetModel</code> and <code>ResnetModelForImageClassification</code>.`,ut,ae,ft,oe,hl="The <code>__init__.py</code> can be empty, it’s just there so that Python detects <code>resnet_model</code> can be use as a module.",wt,I,ht,ie,Tl="Note that you can re-use (or subclass) an existing configuration/model.",Tt,re,Jl=`To share your model with the community, follow those steps: first import the ResNet model and config from the newly
created files:`,Jt,Me,jt,pe,jl=`Then you have to tell the library you want to copy the code files of those objects when using the <code>save_pretrained</code>
method and properly register them with a given Auto class (especially for models), just run:`,Ut,me,bt,ce,Ul=`Note that there is no need to specify an auto class for the configuration (there is only one auto class for them,
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>) but it’s different for models. Your custom model could be suitable for many different tasks, so you
have to specify which one of the auto classes is the correct one for your model.`,Ct,_,gt,de,bl="Next, let’s create the config and models as we did before:",It,ye,_t,ue,Cl="Now to send the model to the Hub, make sure you are logged in. Either run in your terminal:",Zt,fe,$t,we,gl="or from a notebook:",At,he,kt,Te,Il="You can then push to your own namespace (or an organization you are a member of) like this:",vt,Je,Nt,je,_l=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.`,Wt,Ue,Zl='See the <a href="model_sharing">sharing tutorial</a> for more information on the push to Hub method.',Bt,be,Rt,Ce,$l=`You can use any configuration, model or tokenizer with custom code files in its repository with the auto-classes and
the <code>from_pretrained</code> method. All files and code uploaded to the Hub are scanned for malware (refer to the <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub security</a> documentation for more information), but you should still
review the model code and author to avoid executing malicious code on your machine. Set <code>trust_remote_code=True</code> to use
a model with custom code:`,Xt,ge,xt,Ie,Al=`It is also strongly encouraged to pass a commit hash as a <code>revision</code> to make sure the author of the models did not
update the code with some malicious new lines (unless you fully trust the authors of the models).`,Yt,_e,Gt,Ze,kl=`Note that when browsing the commit history of the model repo on the Hub, there is a button to easily copy the commit
hash of any commit.`,Vt,$e,Qt,Ae,vl=`If you are writing a library that extends 🤗 Transformers, you may want to extend the auto classes to include your own
model. This is different from pushing the code to the Hub in the sense that users will need to import your library to
get the custom models (contrarily to automatically downloading the model code from the Hub).`,zt,ke,Nl=`As long as your config has a <code>model_type</code> attribute that is different from existing model types, and that your model
classes have the right <code>config_class</code> attributes, you can just add them to the auto classes like this:`,Et,ve,Ht,Ne,Wl=`Note that the first argument used when registering your custom config to <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a> needs to match the <code>model_type</code>
of your custom config, and the first argument used when registering your custom models to any auto model class needs
to match the <code>config_class</code> of those models.`,Ft,Be,St;return j=new We({props:{title:"Sharing custom models",local:"sharing-custom-models",headingTag:"h1"}}),A=new We({props:{title:"Writing a custom configuration",local:"writing-a-custom-configuration",headingTag:"h2"}}),N=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),Y=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),V=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),z=new We({props:{title:"Writing a custom model",local:"writing-a-custom-model",headingTag:"h2"}}),F=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),L=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),C=new Lt({props:{$$slots:{default:[Sl]},$$scope:{ctx:b}}}),K=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),te=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),se=new We({props:{title:"Sending the code to the Hub",local:"sending-the-code-to-the-hub",headingTag:"h2"}}),g=new Lt({props:{warning:!0,$$slots:{default:[Ll]},$$scope:{ctx:b}}}),ae=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),I=new Lt({props:{warning:!0,$$slots:{default:[ql]},$$scope:{ctx:b}}}),Me=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),me=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),_=new Lt({props:{$$slots:{default:[Pl]},$$scope:{ctx:b}}}),ye=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),fe=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),he=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Je=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),be=new We({props:{title:"Using a model with custom code",local:"using-a-model-with-custom-code",headingTag:"h2"}}),ge=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_e=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),$e=new We({props:{title:"Registering a model with custom code to the auto classes",local:"registering-a-model-with-custom-code-to-the-auto-classes",headingTag:"h2"}}),ve=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){M=o("meta"),J=n(),p=o("p"),h=n(),m(j.$$.fragment),w=n(),U=o("p"),U.textContent=Pt,Re=n(),Z=o("p"),Z.textContent=Dt,Xe=n(),$=o("p"),$.innerHTML=Kt,xe=n(),m(A.$$.fragment),Ye=n(),k=o("p"),k.innerHTML=Ot,Ge=n(),v=o("p"),v.textContent=el,Ve=n(),m(N.$$.fragment),Qe=n(),W=o("p"),W.textContent=tl,ze=n(),B=o("ul"),B.innerHTML=ll,Ee=n(),R=o("p"),R.innerHTML=sl,He=n(),X=o("p"),X.innerHTML=nl,Fe=n(),x=o("p"),x.textContent=al,Se=n(),m(Y.$$.fragment),Le=n(),G=o("p"),G.innerHTML=ol,qe=n(),m(V.$$.fragment),Pe=n(),Q=o("p"),Q.innerHTML=il,De=n(),m(z.$$.fragment),Ke=n(),E=o("p"),E.innerHTML=rl,Oe=n(),H=o("p"),H.innerHTML=Ml,et=n(),m(F.$$.fragment),tt=n(),S=o("p"),S.textContent=pl,lt=n(),m(L.$$.fragment),st=n(),q=o("p"),q.innerHTML=ml,nt=n(),m(C.$$.fragment),at=n(),P=o("p"),P.innerHTML=cl,ot=n(),D=o("p"),D.textContent=dl,it=n(),m(K.$$.fragment),rt=n(),O=o("p"),O.innerHTML=yl,Mt=n(),ee=o("p"),ee.textContent=ul,pt=n(),m(te.$$.fragment),mt=n(),le=o("p"),le.innerHTML=fl,ct=n(),m(se.$$.fragment),dt=n(),m(g.$$.fragment),yt=n(),ne=o("p"),ne.innerHTML=wl,ut=n(),m(ae.$$.fragment),ft=n(),oe=o("p"),oe.innerHTML=hl,wt=n(),m(I.$$.fragment),ht=n(),ie=o("p"),ie.textContent=Tl,Tt=n(),re=o("p"),re.textContent=Jl,Jt=n(),m(Me.$$.fragment),jt=n(),pe=o("p"),pe.innerHTML=jl,Ut=n(),m(me.$$.fragment),bt=n(),ce=o("p"),ce.innerHTML=Ul,Ct=n(),m(_.$$.fragment),gt=n(),de=o("p"),de.textContent=bl,It=n(),m(ye.$$.fragment),_t=n(),ue=o("p"),ue.textContent=Cl,Zt=n(),m(fe.$$.fragment),$t=n(),we=o("p"),we.textContent=gl,At=n(),m(he.$$.fragment),kt=n(),Te=o("p"),Te.textContent=Il,vt=n(),m(Je.$$.fragment),Nt=n(),je=o("p"),je.innerHTML=_l,Wt=n(),Ue=o("p"),Ue.innerHTML=Zl,Bt=n(),m(be.$$.fragment),Rt=n(),Ce=o("p"),Ce.innerHTML=$l,Xt=n(),m(ge.$$.fragment),xt=n(),Ie=o("p"),Ie.innerHTML=Al,Yt=n(),m(_e.$$.fragment),Gt=n(),Ze=o("p"),Ze.textContent=kl,Vt=n(),m($e.$$.fragment),Qt=n(),Ae=o("p"),Ae.textContent=vl,zt=n(),ke=o("p"),ke.innerHTML=Nl,Et=n(),m(ve.$$.fragment),Ht=n(),Ne=o("p"),Ne.innerHTML=Wl,Ft=n(),Be=o("p"),this.h()},l(e){const t=Hl("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),p=i(e,"P",{}),Yl(p).forEach(l),h=a(e),c(j.$$.fragment,e),w=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1bvx2nz"&&(U.textContent=Pt),Re=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-t7mxg8"&&(Z.textContent=Dt),Xe=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wz3qo4"&&($.innerHTML=Kt),xe=a(e),c(A.$$.fragment,e),Ye=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-15o85x"&&(k.innerHTML=Ot),Ge=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1u8fbq1"&&(v.textContent=el),Ve=a(e),c(N.$$.fragment,e),Qe=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9tm0xv"&&(W.textContent=tl),ze=a(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1l985bz"&&(B.innerHTML=ll),Ee=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ttxucl"&&(R.innerHTML=sl),He=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-9uxjnq"&&(X.innerHTML=nl),Fe=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1229zpx"&&(x.textContent=al),Se=a(e),c(Y.$$.fragment,e),Le=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1hshoid"&&(G.innerHTML=ol),qe=a(e),c(V.$$.fragment,e),Pe=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1o1xgyg"&&(Q.innerHTML=il),De=a(e),c(z.$$.fragment,e),Ke=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1mzp5zp"&&(E.innerHTML=rl),Oe=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13oyc7x"&&(H.innerHTML=Ml),et=a(e),c(F.$$.fragment,e),tt=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-85b6xb"&&(S.textContent=pl),lt=a(e),c(L.$$.fragment,e),st=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1vktyut"&&(q.innerHTML=ml),nt=a(e),c(C.$$.fragment,e),at=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-hidw7f"&&(P.innerHTML=cl),ot=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-zsjn9b"&&(D.textContent=dl),it=a(e),c(K.$$.fragment,e),rt=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1s8ow2p"&&(O.innerHTML=yl),Mt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-kn8bw1"&&(ee.textContent=ul),pt=a(e),c(te.$$.fragment,e),mt=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-ato8p9"&&(le.innerHTML=fl),ct=a(e),c(se.$$.fragment,e),dt=a(e),c(g.$$.fragment,e),yt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-w79o0g"&&(ne.innerHTML=wl),ut=a(e),c(ae.$$.fragment,e),ft=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1orsl60"&&(oe.innerHTML=hl),wt=a(e),c(I.$$.fragment,e),ht=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-miae0j"&&(ie.textContent=Tl),Tt=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1kyhtnz"&&(re.textContent=Jl),Jt=a(e),c(Me.$$.fragment,e),jt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1ce24vd"&&(pe.innerHTML=jl),Ut=a(e),c(me.$$.fragment,e),bt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-xxqbm1"&&(ce.innerHTML=Ul),Ct=a(e),c(_.$$.fragment,e),gt=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-19txhag"&&(de.textContent=bl),It=a(e),c(ye.$$.fragment,e),_t=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1w2dqml"&&(ue.textContent=Cl),Zt=a(e),c(fe.$$.fragment,e),$t=a(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-11lw65d"&&(we.textContent=gl),At=a(e),c(he.$$.fragment,e),kt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1c2397x"&&(Te.textContent=Il),vt=a(e),c(Je.$$.fragment,e),Nt=a(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-djed3h"&&(je.innerHTML=_l),Wt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1sdq6eg"&&(Ue.innerHTML=Zl),Bt=a(e),c(be.$$.fragment,e),Rt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-nao5c0"&&(Ce.innerHTML=$l),Xt=a(e),c(ge.$$.fragment,e),xt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1i8vto1"&&(Ie.innerHTML=Al),Yt=a(e),c(_e.$$.fragment,e),Gt=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1y2zx54"&&(Ze.textContent=kl),Vt=a(e),c($e.$$.fragment,e),Qt=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-bccbz6"&&(Ae.textContent=vl),zt=a(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-uijzdg"&&(ke.innerHTML=Nl),Et=a(e),c(ve.$$.fragment,e),Ht=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-scwjfy"&&(Ne.innerHTML=Wl),Ft=a(e),Be=i(e,"P",{}),Yl(Be).forEach(l),this.h()},h(){Gl(M,"name","hf:doc:metadata"),Gl(M,"content",Kl)},m(e,t){Fl(document.head,M),s(e,J,t),s(e,p,t),s(e,h,t),d(j,e,t),s(e,w,t),s(e,U,t),s(e,Re,t),s(e,Z,t),s(e,Xe,t),s(e,$,t),s(e,xe,t),d(A,e,t),s(e,Ye,t),s(e,k,t),s(e,Ge,t),s(e,v,t),s(e,Ve,t),d(N,e,t),s(e,Qe,t),s(e,W,t),s(e,ze,t),s(e,B,t),s(e,Ee,t),s(e,R,t),s(e,He,t),s(e,X,t),s(e,Fe,t),s(e,x,t),s(e,Se,t),d(Y,e,t),s(e,Le,t),s(e,G,t),s(e,qe,t),d(V,e,t),s(e,Pe,t),s(e,Q,t),s(e,De,t),d(z,e,t),s(e,Ke,t),s(e,E,t),s(e,Oe,t),s(e,H,t),s(e,et,t),d(F,e,t),s(e,tt,t),s(e,S,t),s(e,lt,t),d(L,e,t),s(e,st,t),s(e,q,t),s(e,nt,t),d(C,e,t),s(e,at,t),s(e,P,t),s(e,ot,t),s(e,D,t),s(e,it,t),d(K,e,t),s(e,rt,t),s(e,O,t),s(e,Mt,t),s(e,ee,t),s(e,pt,t),d(te,e,t),s(e,mt,t),s(e,le,t),s(e,ct,t),d(se,e,t),s(e,dt,t),d(g,e,t),s(e,yt,t),s(e,ne,t),s(e,ut,t),d(ae,e,t),s(e,ft,t),s(e,oe,t),s(e,wt,t),d(I,e,t),s(e,ht,t),s(e,ie,t),s(e,Tt,t),s(e,re,t),s(e,Jt,t),d(Me,e,t),s(e,jt,t),s(e,pe,t),s(e,Ut,t),d(me,e,t),s(e,bt,t),s(e,ce,t),s(e,Ct,t),d(_,e,t),s(e,gt,t),s(e,de,t),s(e,It,t),d(ye,e,t),s(e,_t,t),s(e,ue,t),s(e,Zt,t),d(fe,e,t),s(e,$t,t),s(e,we,t),s(e,At,t),d(he,e,t),s(e,kt,t),s(e,Te,t),s(e,vt,t),d(Je,e,t),s(e,Nt,t),s(e,je,t),s(e,Wt,t),s(e,Ue,t),s(e,Bt,t),d(be,e,t),s(e,Rt,t),s(e,Ce,t),s(e,Xt,t),d(ge,e,t),s(e,xt,t),s(e,Ie,t),s(e,Yt,t),d(_e,e,t),s(e,Gt,t),s(e,Ze,t),s(e,Vt,t),d($e,e,t),s(e,Qt,t),s(e,Ae,t),s(e,zt,t),s(e,ke,t),s(e,Et,t),d(ve,e,t),s(e,Ht,t),s(e,Ne,t),s(e,Ft,t),s(e,Be,t),St=!0},p(e,[t]){const Bl={};t&2&&(Bl.$$scope={dirty:t,ctx:e}),C.$set(Bl);const Rl={};t&2&&(Rl.$$scope={dirty:t,ctx:e}),g.$set(Rl);const Xl={};t&2&&(Xl.$$scope={dirty:t,ctx:e}),I.$set(Xl);const xl={};t&2&&(xl.$$scope={dirty:t,ctx:e}),_.$set(xl)},i(e){St||(y(j.$$.fragment,e),y(A.$$.fragment,e),y(N.$$.fragment,e),y(Y.$$.fragment,e),y(V.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(L.$$.fragment,e),y(C.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(g.$$.fragment,e),y(ae.$$.fragment,e),y(I.$$.fragment,e),y(Me.$$.fragment,e),y(me.$$.fragment,e),y(_.$$.fragment,e),y(ye.$$.fragment,e),y(fe.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(be.$$.fragment,e),y(ge.$$.fragment,e),y(_e.$$.fragment,e),y($e.$$.fragment,e),y(ve.$$.fragment,e),St=!0)},o(e){u(j.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(V.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(C.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(g.$$.fragment,e),u(ae.$$.fragment,e),u(I.$$.fragment,e),u(Me.$$.fragment,e),u(me.$$.fragment,e),u(_.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(Je.$$.fragment,e),u(be.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u($e.$$.fragment,e),u(ve.$$.fragment,e),St=!1},d(e){e&&(l(J),l(p),l(h),l(w),l(U),l(Re),l(Z),l(Xe),l($),l(xe),l(Ye),l(k),l(Ge),l(v),l(Ve),l(Qe),l(W),l(ze),l(B),l(Ee),l(R),l(He),l(X),l(Fe),l(x),l(Se),l(Le),l(G),l(qe),l(Pe),l(Q),l(De),l(Ke),l(E),l(Oe),l(H),l(et),l(tt),l(S),l(lt),l(st),l(q),l(nt),l(at),l(P),l(ot),l(D),l(it),l(rt),l(O),l(Mt),l(ee),l(pt),l(mt),l(le),l(ct),l(dt),l(yt),l(ne),l(ut),l(ft),l(oe),l(wt),l(ht),l(ie),l(Tt),l(re),l(Jt),l(jt),l(pe),l(Ut),l(bt),l(ce),l(Ct),l(gt),l(de),l(It),l(_t),l(ue),l(Zt),l($t),l(we),l(At),l(kt),l(Te),l(vt),l(Nt),l(je),l(Wt),l(Ue),l(Bt),l(Rt),l(Ce),l(Xt),l(xt),l(Ie),l(Yt),l(Gt),l(Ze),l(Vt),l(Qt),l(Ae),l(zt),l(ke),l(Et),l(Ht),l(Ne),l(Ft),l(Be)),l(M),f(j,e),f(A,e),f(N,e),f(Y,e),f(V,e),f(z,e),f(F,e),f(L,e),f(C,e),f(K,e),f(te,e),f(se,e),f(g,e),f(ae,e),f(I,e),f(Me,e),f(me,e),f(_,e),f(ye,e),f(fe,e),f(he,e),f(Je,e),f(be,e),f(ge,e),f(_e,e),f($e,e),f(ve,e)}}}const Kl='{"title":"Sharing custom models","local":"sharing-custom-models","sections":[{"title":"Writing a custom configuration","local":"writing-a-custom-configuration","sections":[],"depth":2},{"title":"Writing a custom model","local":"writing-a-custom-model","sections":[],"depth":2},{"title":"Sending the code to the Hub","local":"sending-the-code-to-the-hub","sections":[],"depth":2},{"title":"Using a model with custom code","local":"using-a-model-with-custom-code","sections":[],"depth":2},{"title":"Registering a model with custom code to the auto classes","local":"registering-a-model-with-custom-code-to-the-auto-classes","sections":[],"depth":2}],"depth":1}';function Ol(b){return Ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends zl{constructor(M){super(),El(this,M,Ol,Dl,Vl,{})}}export{as as component};
