import{s as Xe,n as Ye,o as _e}from"../chunks/scheduler.987d3921.js";import{S as Se,i as ze,g as o,s as a,r as s,A as Ne,h as d,f as l,c as i,j as We,u as r,x as w,k as Ge,y as Ve,a as n,v as p,d as M,t as m,w as c}from"../chunks/index.c8b1fed4.js";import{H as x,g as Re}from"../chunks/Heading.18b35e42.js";import{C as T}from"../chunks/CodeBlock.18094d58.js";function xe(fe){let y,F,E,H,h,K,J,ge='Da die Modelle immer größer werden, hat sich die Parallelität als Strategie zum Trainieren größerer Modelle auf begrenzter Hardware und zur Beschleunigung der Trainingsgeschwindigkeit um mehrere Größenordnungen erwiesen. Bei Hugging Face haben wir die Bibliothek <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a> entwickelt, um Nutzern zu helfen, ein 🤗 Transformers-Modell auf jeder Art von verteiltem Setup zu trainieren, egal ob es sich um mehrere GPUs auf einer Maschine oder mehrere GPUs auf mehreren Maschinen handelt. In diesem Tutorial lernen Sie, wie Sie Ihre native PyTorch-Trainingsschleife anpassen, um das Training in einer verteilten Umgebung zu ermöglichen.',L,u,P,j,be="Beginnen Sie mit der Installation von 🤗 Accelerate:",D,f,q,g,Ue="Dann importieren und erstellen Sie ein <code>Accelerator</code>-Objekt. Der <code>Accelerator</code> wird automatisch Ihre Art der verteilten Einrichtung erkennen und alle notwendigen Komponenten für das Training initialisieren. Sie müssen Ihr Modell nicht explizit auf einem Gerät platzieren.",O,b,ee,U,te,I,Ie="Der nächste Schritt ist die Übergabe aller relevanten Trainingsobjekte an die Methode <code>prepare</code>. Dazu gehören Ihre Trainings- und Evaluierungs-DataLoader, ein Modell und ein Optimierer:",le,$,ne,C,ae,B,$e="Die letzte Ergänzung besteht darin, das typische <code>loss.backward()</code> in der Trainingsschleife durch die 🤗 Accelerate-Methode <code>backward</code> zu ersetzen:",ie,Z,se,k,Ce="Wie Sie im folgenden Code sehen können, müssen Sie nur vier zusätzliche Codezeilen zu Ihrer Trainingsschleife hinzufügen, um verteiltes Training zu ermöglichen!",re,v,pe,A,Me,W,Be="Sobald Sie die entsprechenden Codezeilen hinzugefügt haben, starten Sie Ihr Training in einem Skript oder einem Notebook wie Colaboratory.",me,G,ce,X,Ze="Wenn Sie Ihr Training mit einem Skript durchführen, führen Sie den folgenden Befehl aus, um eine Konfigurationsdatei zu erstellen und zu speichern:",oe,Y,de,_,ke="Dann starten Sie Ihr Training mit:",we,S,ye,z,Te,N,ve="🤗 Accelerate kann auch in einem Notebook laufen, wenn Sie planen, die TPUs von Colaboratory zu verwenden. Verpacken Sie den gesamten Code, der für das Training verantwortlich ist, in eine Funktion und übergeben Sie diese an <code>notebook_launcher</code>:",he,V,Je,R,Ae='Weitere Informationen über 🤗 Accelerate und seine umfangreichen Funktionen finden Sie in der <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Dokumentation</a>.',ue,Q,je;return h=new x({props:{title:"Verteiltes Training mit 🤗 Accelerate",local:"verteiltes-training-mit--accelerate",headingTag:"h1"}}),u=new x({props:{title:"Einrichtung",local:"einrichtung",headingTag:"h2"}}),f=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),b=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`,wrap:!1}}),U=new x({props:{title:"Vorbereiten auf die Beschleunigung",local:"vorbereiten-auf-die-beschleunigung",headingTag:"h2"}}),$=new T({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new x({props:{title:"Rückwärts",local:"rückwärts",headingTag:"h2"}}),Z=new T({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),v=new T({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBZGFtVyUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBJTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQS0lMjBkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEEtJTIwbW9kZWwudG8oZGV2aWNlKSUwQSUwQSUyQiUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMG51bV9lcG9jaHMlMjAlM0QlMjAzJTBBJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEElMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTBBJTIwJTIwKSUwQSUwQSUyMCUyMHByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEElMjAlMjBtb2RlbC50cmFpbigpJTBBJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEEtJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),A=new x({props:{title:"Trainieren",local:"trainieren",headingTag:"h2"}}),G=new x({props:{title:"Trainieren mit einem Skript",local:"trainieren-mit-einem-skript",headingTag:"h3"}}),Y=new T({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),S=new T({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py",wrap:!1}}),z=new x({props:{title:"Trainieren mit einem Notebook",local:"trainieren-mit-einem-notebook",headingTag:"h3"}}),V=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`,wrap:!1}}),{c(){y=o("meta"),F=a(),E=o("p"),H=a(),s(h.$$.fragment),K=a(),J=o("p"),J.innerHTML=ge,L=a(),s(u.$$.fragment),P=a(),j=o("p"),j.textContent=be,D=a(),s(f.$$.fragment),q=a(),g=o("p"),g.innerHTML=Ue,O=a(),s(b.$$.fragment),ee=a(),s(U.$$.fragment),te=a(),I=o("p"),I.innerHTML=Ie,le=a(),s($.$$.fragment),ne=a(),s(C.$$.fragment),ae=a(),B=o("p"),B.innerHTML=$e,ie=a(),s(Z.$$.fragment),se=a(),k=o("p"),k.textContent=Ce,re=a(),s(v.$$.fragment),pe=a(),s(A.$$.fragment),Me=a(),W=o("p"),W.textContent=Be,me=a(),s(G.$$.fragment),ce=a(),X=o("p"),X.textContent=Ze,oe=a(),s(Y.$$.fragment),de=a(),_=o("p"),_.textContent=ke,we=a(),s(S.$$.fragment),ye=a(),s(z.$$.fragment),Te=a(),N=o("p"),N.innerHTML=ve,he=a(),s(V.$$.fragment),Je=a(),R=o("p"),R.innerHTML=Ae,ue=a(),Q=o("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);y=d(t,"META",{name:!0,content:!0}),t.forEach(l),F=i(e),E=d(e,"P",{}),We(E).forEach(l),H=i(e),r(h.$$.fragment,e),K=i(e),J=d(e,"P",{"data-svelte-h":!0}),w(J)!=="svelte-1hjc0yq"&&(J.innerHTML=ge),L=i(e),r(u.$$.fragment,e),P=i(e),j=d(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-15yrwop"&&(j.textContent=be),D=i(e),r(f.$$.fragment,e),q=i(e),g=d(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-pi5ngu"&&(g.innerHTML=Ue),O=i(e),r(b.$$.fragment,e),ee=i(e),r(U.$$.fragment,e),te=i(e),I=d(e,"P",{"data-svelte-h":!0}),w(I)!=="svelte-1u11dxv"&&(I.innerHTML=Ie),le=i(e),r($.$$.fragment,e),ne=i(e),r(C.$$.fragment,e),ae=i(e),B=d(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-18g7sy8"&&(B.innerHTML=$e),ie=i(e),r(Z.$$.fragment,e),se=i(e),k=d(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-1ghqa33"&&(k.textContent=Ce),re=i(e),r(v.$$.fragment,e),pe=i(e),r(A.$$.fragment,e),Me=i(e),W=d(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1jr6frh"&&(W.textContent=Be),me=i(e),r(G.$$.fragment,e),ce=i(e),X=d(e,"P",{"data-svelte-h":!0}),w(X)!=="svelte-ve4x71"&&(X.textContent=Ze),oe=i(e),r(Y.$$.fragment,e),de=i(e),_=d(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-17ookzs"&&(_.textContent=ke),we=i(e),r(S.$$.fragment,e),ye=i(e),r(z.$$.fragment,e),Te=i(e),N=d(e,"P",{"data-svelte-h":!0}),w(N)!=="svelte-1dq64sh"&&(N.innerHTML=ve),he=i(e),r(V.$$.fragment,e),Je=i(e),R=d(e,"P",{"data-svelte-h":!0}),w(R)!=="svelte-1t5vokc"&&(R.innerHTML=Ae),ue=i(e),Q=d(e,"P",{}),We(Q).forEach(l),this.h()},h(){Ge(y,"name","hf:doc:metadata"),Ge(y,"content",Ee)},m(e,t){Ve(document.head,y),n(e,F,t),n(e,E,t),n(e,H,t),p(h,e,t),n(e,K,t),n(e,J,t),n(e,L,t),p(u,e,t),n(e,P,t),n(e,j,t),n(e,D,t),p(f,e,t),n(e,q,t),n(e,g,t),n(e,O,t),p(b,e,t),n(e,ee,t),p(U,e,t),n(e,te,t),n(e,I,t),n(e,le,t),p($,e,t),n(e,ne,t),p(C,e,t),n(e,ae,t),n(e,B,t),n(e,ie,t),p(Z,e,t),n(e,se,t),n(e,k,t),n(e,re,t),p(v,e,t),n(e,pe,t),p(A,e,t),n(e,Me,t),n(e,W,t),n(e,me,t),p(G,e,t),n(e,ce,t),n(e,X,t),n(e,oe,t),p(Y,e,t),n(e,de,t),n(e,_,t),n(e,we,t),p(S,e,t),n(e,ye,t),p(z,e,t),n(e,Te,t),n(e,N,t),n(e,he,t),p(V,e,t),n(e,Je,t),n(e,R,t),n(e,ue,t),n(e,Q,t),je=!0},p:Ye,i(e){je||(M(h.$$.fragment,e),M(u.$$.fragment,e),M(f.$$.fragment,e),M(b.$$.fragment,e),M(U.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(v.$$.fragment,e),M(A.$$.fragment,e),M(G.$$.fragment,e),M(Y.$$.fragment,e),M(S.$$.fragment,e),M(z.$$.fragment,e),M(V.$$.fragment,e),je=!0)},o(e){m(h.$$.fragment,e),m(u.$$.fragment,e),m(f.$$.fragment,e),m(b.$$.fragment,e),m(U.$$.fragment,e),m($.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(v.$$.fragment,e),m(A.$$.fragment,e),m(G.$$.fragment,e),m(Y.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(V.$$.fragment,e),je=!1},d(e){e&&(l(F),l(E),l(H),l(K),l(J),l(L),l(P),l(j),l(D),l(q),l(g),l(O),l(ee),l(te),l(I),l(le),l(ne),l(ae),l(B),l(ie),l(se),l(k),l(re),l(pe),l(Me),l(W),l(me),l(ce),l(X),l(oe),l(de),l(_),l(we),l(ye),l(Te),l(N),l(he),l(Je),l(R),l(ue),l(Q)),l(y),c(h,e),c(u,e),c(f,e),c(b,e),c(U,e),c($,e),c(C,e),c(Z,e),c(v,e),c(A,e),c(G,e),c(Y,e),c(S,e),c(z,e),c(V,e)}}}const Ee='{"title":"Verteiltes Training mit 🤗 Accelerate","local":"verteiltes-training-mit--accelerate","sections":[{"title":"Einrichtung","local":"einrichtung","sections":[],"depth":2},{"title":"Vorbereiten auf die Beschleunigung","local":"vorbereiten-auf-die-beschleunigung","sections":[],"depth":2},{"title":"Rückwärts","local":"rückwärts","sections":[],"depth":2},{"title":"Trainieren","local":"trainieren","sections":[{"title":"Trainieren mit einem Skript","local":"trainieren-mit-einem-skript","sections":[],"depth":3},{"title":"Trainieren mit einem Notebook","local":"trainieren-mit-einem-notebook","sections":[],"depth":3}],"depth":2}],"depth":1}';function Qe(fe){return _e(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Re}),[]}class Pe extends Se{constructor(y){super(),ze(this,y,Qe,xe,Xe,{})}}export{Pe as component};
