import{s as qt,o as Yt,n as Dt}from"../chunks/scheduler.987d3921.js";import{S as Pt,i as Kt,g as i,s as l,r as p,A as Ot,h as r,f as n,c as a,j as Nt,u,x as o,k as ft,y as en,a as s,v as g,d as m,t as d,w as c}from"../chunks/index.c8b1fed4.js";import{H as M,g as tn}from"../chunks/Heading.18b35e42.js";import{T as nn}from"../chunks/Tip.6bc1e794.js";import{C as T}from"../chunks/CodeBlock.18094d58.js";import{D as sn}from"../chunks/DocNotebookDropdown.aed1009b.js";function ln(be){let h,j='Wenn Sie an der grundlegenden Verwendung von LLMs interessiert sind, ist unsere High-Level-Schnittstelle <a href="pipeline_tutorial"><code>Pipeline</code></a> ein guter Ausgangspunkt. LLMs erfordern jedoch oft fortgeschrittene Funktionen wie Quantisierung und Feinsteuerung des Token-Auswahlschritts, was am besten über <code>generate()</code> erfolgt. Die autoregressive Generierung mit LLMs ist ebenfalls ressourcenintensiv und sollte für einen angemessenen Durchsatz auf einer GPU ausgeführt werden.';return{c(){h=i("p"),h.innerHTML=j},l(f){h=r(f,"P",{"data-svelte-h":!0}),o(h)!=="svelte-ea0vwr"&&(h.innerHTML=j)},m(f,fe){s(f,h,fe)},p:Dt,d(f){f&&n(h)}}}function an(be){let h,j,f,fe,k,we,J,ye,v,Mt="LLMs (Large Language Models) sind die Schlüsselkomponente bei der Texterstellung. Kurz gesagt, bestehen sie aus großen, vortrainierten Transformationsmodellen, die darauf trainiert sind, das nächste Wort (oder genauer gesagt Token) aus einem Eingabetext vorherzusagen. Da sie jeweils ein Token vorhersagen, müssen Sie etwas Aufwändigeres tun, um neue Sätze zu generieren, als nur das Modell aufzurufen - Sie müssen eine autoregressive Generierung durchführen.",Te,U,bt="Die autoregressive Generierung ist ein Verfahren zur Inferenzzeit, bei dem ein Modell mit seinen eigenen generierten Ausgaben iterativ aufgerufen wird, wenn einige anfängliche Eingaben vorliegen. In 🤗 Transformers wird dies von der Methode <code>generate()</code> übernommen, die allen Modellen mit generativen Fähigkeiten zur Verfügung steht.",je,z,wt="Dieses Tutorial zeigt Ihnen, wie Sie:",ke,Z,yt="<li>Text mit einem LLM generieren</li> <li>Vermeiden Sie häufige Fallstricke</li> <li>Nächste Schritte, damit Sie das Beste aus Ihrem LLM herausholen können</li>",Je,$,Tt="Bevor Sie beginnen, stellen Sie sicher, dass Sie alle erforderlichen Bibliotheken installiert haben:",ve,_,Ue,G,ze,I,jt='Ein Sprachmodell, das für <a href="tasks/language_modeling">causal language modeling</a> trainiert wurde, nimmt eine Folge von Text-Token als Eingabe und gibt die Wahrscheinlichkeitsverteilung für das nächste Token zurück.',Ze,b,kt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',$e,W,Jt="Ein wichtiger Aspekt der autoregressiven Generierung mit LLMs ist die Auswahl des nächsten Tokens aus dieser Wahrscheinlichkeitsverteilung. In diesem Schritt ist alles möglich, solange Sie am Ende ein Token für die nächste Iteration haben. Das heißt, es kann so einfach sein wie die Auswahl des wahrscheinlichsten Tokens aus der Wahrscheinlichkeitsverteilung oder so komplex wie die Anwendung von einem Dutzend Transformationen vor der Stichprobenziehung aus der resultierenden Verteilung.",_e,w,vt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Die autoregressive Generierung wählt iterativ das nächste Token aus einer Wahrscheinlichkeitsverteilung aus, um Text zu erzeugen&quot;</figcaption>',Ge,C,Ut="Der oben dargestellte Prozess wird iterativ wiederholt, bis eine bestimmte Abbruchbedingung erreicht ist. Im Idealfall wird die Abbruchbedingung vom Modell vorgegeben, das lernen sollte, wann es ein Ende-der-Sequenz-Token (EOS) ausgeben muss. Ist dies nicht der Fall, stoppt die Generierung, wenn eine vordefinierte Maximallänge erreicht ist.",Ie,V,zt="Damit sich Ihr Modell so verhält, wie Sie es für Ihre Aufgabe erwarten, müssen Sie den Schritt der Token-Auswahl und die Abbruchbedingung richtig einstellen. Aus diesem Grund haben wir zu jedem Modell eine <code>GenerationConfig</code>-Datei, die eine gute generative Standardparametrisierung enthält und zusammen mit Ihrem Modell geladen wird.",We,x,Zt="Lassen Sie uns über Code sprechen!",Ce,y,Ve,L,$t="Zunächst müssen Sie das Modell laden.",xe,R,Le,X,_t="Sie werden zwei Flags in dem Aufruf <code>from_pretrained</code> bemerken:",Re,B,Gt='<li><code>device_map</code> stellt sicher, dass das Modell auf Ihre GPU(s) übertragen wird</li> <li><code>load_in_4bit</code> wendet <a href="main_classes/quantization">dynamische 4-Bit-Quantisierung</a> an, um die Ressourcenanforderungen massiv zu reduzieren</li>',Xe,S,It="Es gibt noch andere Möglichkeiten, ein Modell zu initialisieren, aber dies ist eine gute Grundlage, um mit einem LLM zu beginnen.",Be,F,Wt='Als nächstes müssen Sie Ihre Texteingabe mit einem <a href="tokenizer_summary">tokenizer</a> vorverarbeiten.',Se,H,Fe,E,Ct="Die Variable <code>model_inputs</code> enthält die tokenisierte Texteingabe sowie die Aufmerksamkeitsmaske. Obwohl <code>generate()</code> sein Bestes tut, um die Aufmerksamkeitsmaske abzuleiten, wenn sie nicht übergeben wird, empfehlen wir, sie für optimale Ergebnisse wann immer möglich zu übergeben.",He,A,Vt="Rufen Sie schließlich die Methode [~generation.GenerationMixin.generate] auf, um die generierten Token zurückzugeben, die vor dem Drucken in Text umgewandelt werden sollten.",Ee,Q,Ae,N,xt="Und das war’s! Mit ein paar Zeilen Code können Sie sich die Macht eines LLM zunutze machen.",Qe,q,Ne,Y,Lt='Es gibt viele <a href="generation_strategies">Generierungsstrategien</a>, und manchmal sind die Standardwerte für Ihren Anwendungsfall vielleicht nicht geeignet. Wenn Ihre Ausgaben nicht mit dem übereinstimmen, was Sie erwarten, haben wir eine Liste der häufigsten Fallstricke erstellt und wie Sie diese vermeiden können.',qe,D,Ye,P,De,K,Rt='Wenn in der Datei [~generation.GenerationConfig`] nichts angegeben ist, gibt <code>generate</code> standardmäßig bis zu 20 Token zurück. Wir empfehlen dringend, <code>max_new_tokens</code> in Ihrem <code>generate</code>-Aufruf manuell zu setzen, um die maximale Anzahl neuer Token zu kontrollieren, die zurückgegeben werden können. Beachten Sie, dass LLMs (genauer gesagt, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) auch die Eingabeaufforderung als Teil der Ausgabe zurückgeben.',Pe,O,Ke,ee,Oe,te,Xt='Standardmäßig und sofern nicht in der Datei [~generation.GenerationConfig`] angegeben, wählt <code>generate</code> bei jeder Iteration das wahrscheinlichste Token aus (gierige Dekodierung). Je nach Aufgabe kann dies unerwünscht sein; kreative Aufgaben wie Chatbots oder das Schreiben eines Aufsatzes profitieren vom Sampling. Andererseits profitieren Aufgaben, bei denen es auf die Eingabe ankommt, wie z.B. Audiotranskription oder Übersetzung, von der gierigen Dekodierung. Aktivieren Sie das Sampling mit <code>do_sample=True</code>. Mehr zu diesem Thema erfahren Sie in diesem [Blogbeitrag] (<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">https://huggingface.co/blog/how-to-generate</a>).',et,ne,tt,se,nt,le,Bt='LLMs sind <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a>-Architekturen, d.h. sie iterieren weiter über Ihre Eingabeaufforderung. Wenn Ihre Eingaben nicht die gleiche Länge haben, müssen sie aufgefüllt werden. Da LLMs nicht darauf trainiert sind, mit aufgefüllten Token fortzufahren, muss Ihre Eingabe links aufgefüllt werden. Vergessen Sie auch nicht, die Aufmerksamkeitsmaske an generate zu übergeben!',st,ae,lt,ie,at,re,St="Während der Prozess der autoregressiven Generierung relativ einfach ist, kann die optimale Nutzung Ihres LLM ein schwieriges Unterfangen sein, da es viele bewegliche Teile gibt. Für Ihre nächsten Schritte, die Ihnen helfen, tiefer in die LLM-Nutzung und das Verständnis einzutauchen:",it,oe,rt,pe,Ft='<li><a href="generation_strategies">Leitfaden</a> zur Steuerung verschiedener Generierungsmethoden, zur Einrichtung der Generierungskonfigurationsdatei und zum Streaming der Ausgabe;</li> <li>API-Referenz zu <code>GenerationConfig</code>, <code>generate()</code> und <a href="internal/generation_utils">generate-bezogene Klassen</a>.</li>',ot,ue,pt,ge,Ht='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, das sich auf die Qualität der Open-Source-Modelle konzentriert;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, das sich auf den LLM-Durchsatz konzentriert.</li>',ut,me,gt,de,Et='<li><a href="main_classes/quantization">Leitfaden</a> zur dynamischen Quantisierung, der Ihnen zeigt, wie Sie Ihren Speicherbedarf drastisch reduzieren können.</li>',mt,ce,dt,he,At='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a>, ein produktionsreifer Server für LLMs;</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, eine Erweiterung von 🤗 Transformers, die für bestimmte Hardware-Geräte optimiert.</li>',ct,Me,ht;return k=new M({props:{title:"Generation with LLMs",local:"generation-with-llms",headingTag:"h1"}}),J=new sn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/de/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/de/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/de/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/de/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/de/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/de/tensorflow/llm_tutorial.ipynb"}]}}),_=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),G=new M({props:{title:"Text generieren",local:"text-generieren",headingTag:"h2"}}),y=new nn({props:{$$slots:{default:[ln]},$$scope:{ctx:be}}}),R=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmxtLXJlc2VhcmNoJTJGb3Blbl9sbGFtYV83YiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Q=new T({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, black, white, and brown&#x27;</span>`,wrap:!1}}),q=new M({props:{title:"Häufige Fallstricke",local:"häufige-fallstricke",headingTag:"h2"}}),D=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBMbGFtYSUyMGhhcyUyMG5vJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new M({props:{title:"Generierte Ausgabe ist zu kurz/lang",local:"generierte-ausgabe-ist-zu-kurzlang",headingTag:"h3"}}),O=new T({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),ee=new M({props:{title:"Falscher Generierungsmodus",local:"falscher-generierungsmodus",headingTag:"h3"}}),ne=new T({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCgwKSUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJJTIwYW0lMjBhJTIwY2F0LiUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwTExNJTIwJTJCJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjAlM0QlMjByZXBldGl0aXZlJTJDJTIwYm9yaW5nJTIwb3V0cHV0JTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBiZWNvbWVzJTIwbW9yZSUyMGNyZWF0aXZlISUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.\\nI just need to be. I am always.\\nEvery time&#x27;</span>`,wrap:!1}}),se=new M({props:{title:"Falsche Auffüllseite",local:"falsche-auffüllseite",headingTag:"h3"}}),ae=new T({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscy4lMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMGxlZnQtcGFkZGluZyUyQyUyMGl0JTIwd29ya3MlMjBhcyUyMGV4cGVjdGVkISUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTGxhbWElMjBoYXMlMjBubyUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUyMjElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMCUyMkElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMkMlMjBFJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),ie=new M({props:{title:"Weitere Ressourcen",local:"weitere-ressourcen",headingTag:"h2"}}),oe=new M({props:{title:"Fortgeschrittene Nutzung generieren",local:"fortgeschrittene-nutzung-generieren",headingTag:"h3"}}),ue=new M({props:{title:"LLM-Ranglisten",local:"llm-ranglisten",headingTag:"h3"}}),me=new M({props:{title:"Latenz und Durchsatz",local:"latenz-und-durchsatz",headingTag:"h3"}}),ce=new M({props:{title:"Verwandte Bibliotheken",local:"verwandte-bibliotheken",headingTag:"h3"}}),{c(){h=i("meta"),j=l(),f=i("p"),fe=l(),p(k.$$.fragment),we=l(),p(J.$$.fragment),ye=l(),v=i("p"),v.textContent=Mt,Te=l(),U=i("p"),U.innerHTML=bt,je=l(),z=i("p"),z.textContent=wt,ke=l(),Z=i("ul"),Z.innerHTML=yt,Je=l(),$=i("p"),$.textContent=Tt,ve=l(),p(_.$$.fragment),Ue=l(),p(G.$$.fragment),ze=l(),I=i("p"),I.innerHTML=jt,Ze=l(),b=i("figure"),b.innerHTML=kt,$e=l(),W=i("p"),W.textContent=Jt,_e=l(),w=i("figure"),w.innerHTML=vt,Ge=l(),C=i("p"),C.textContent=Ut,Ie=l(),V=i("p"),V.innerHTML=zt,We=l(),x=i("p"),x.textContent=Zt,Ce=l(),p(y.$$.fragment),Ve=l(),L=i("p"),L.textContent=$t,xe=l(),p(R.$$.fragment),Le=l(),X=i("p"),X.innerHTML=_t,Re=l(),B=i("ul"),B.innerHTML=Gt,Xe=l(),S=i("p"),S.textContent=It,Be=l(),F=i("p"),F.innerHTML=Wt,Se=l(),p(H.$$.fragment),Fe=l(),E=i("p"),E.innerHTML=Ct,He=l(),A=i("p"),A.textContent=Vt,Ee=l(),p(Q.$$.fragment),Ae=l(),N=i("p"),N.textContent=xt,Qe=l(),p(q.$$.fragment),Ne=l(),Y=i("p"),Y.innerHTML=Lt,qe=l(),p(D.$$.fragment),Ye=l(),p(P.$$.fragment),De=l(),K=i("p"),K.innerHTML=Rt,Pe=l(),p(O.$$.fragment),Ke=l(),p(ee.$$.fragment),Oe=l(),te=i("p"),te.innerHTML=Xt,et=l(),p(ne.$$.fragment),tt=l(),p(se.$$.fragment),nt=l(),le=i("p"),le.innerHTML=Bt,st=l(),p(ae.$$.fragment),lt=l(),p(ie.$$.fragment),at=l(),re=i("p"),re.textContent=St,it=l(),p(oe.$$.fragment),rt=l(),pe=i("ol"),pe.innerHTML=Ft,ot=l(),p(ue.$$.fragment),pt=l(),ge=i("ol"),ge.innerHTML=Ht,ut=l(),p(me.$$.fragment),gt=l(),de=i("ol"),de.innerHTML=Et,mt=l(),p(ce.$$.fragment),dt=l(),he=i("ol"),he.innerHTML=At,ct=l(),Me=i("p"),this.h()},l(e){const t=Ot("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(n),j=a(e),f=r(e,"P",{}),Nt(f).forEach(n),fe=a(e),u(k.$$.fragment,e),we=a(e),u(J.$$.fragment,e),ye=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-140yavd"&&(v.textContent=Mt),Te=a(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1nh5cju"&&(U.innerHTML=bt),je=a(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-ipf9gg"&&(z.textContent=wt),ke=a(e),Z=r(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-imc6q0"&&(Z.innerHTML=yt),Je=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-28fang"&&($.textContent=Tt),ve=a(e),u(_.$$.fragment,e),Ue=a(e),u(G.$$.fragment,e),ze=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-zi1jgg"&&(I.innerHTML=jt),Ze=a(e),b=r(e,"FIGURE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-hjgddv"&&(b.innerHTML=kt),$e=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ilwa1m"&&(W.textContent=Jt),_e=a(e),w=r(e,"FIGURE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-4pjbi0"&&(w.innerHTML=vt),Ge=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1j4vblf"&&(C.textContent=Ut),Ie=a(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-5vhx9n"&&(V.innerHTML=zt),We=a(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-wo8rtu"&&(x.textContent=Zt),Ce=a(e),u(y.$$.fragment,e),Ve=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-16f5yf"&&(L.textContent=$t),xe=a(e),u(R.$$.fragment,e),Le=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1qd47t5"&&(X.innerHTML=_t),Re=a(e),B=r(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-dbmx59"&&(B.innerHTML=Gt),Xe=a(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-7wdmxs"&&(S.textContent=It),Be=a(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1wuri71"&&(F.innerHTML=Wt),Se=a(e),u(H.$$.fragment,e),Fe=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-9ebqu0"&&(E.innerHTML=Ct),He=a(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-12ref7m"&&(A.textContent=Vt),Ee=a(e),u(Q.$$.fragment,e),Ae=a(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-5a0hj7"&&(N.textContent=xt),Qe=a(e),u(q.$$.fragment,e),Ne=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-e1t2cj"&&(Y.innerHTML=Lt),qe=a(e),u(D.$$.fragment,e),Ye=a(e),u(P.$$.fragment,e),De=a(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-13sfmgc"&&(K.innerHTML=Rt),Pe=a(e),u(O.$$.fragment,e),Ke=a(e),u(ee.$$.fragment,e),Oe=a(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-14fe6r1"&&(te.innerHTML=Xt),et=a(e),u(ne.$$.fragment,e),tt=a(e),u(se.$$.fragment,e),nt=a(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1epu98s"&&(le.innerHTML=Bt),st=a(e),u(ae.$$.fragment,e),lt=a(e),u(ie.$$.fragment,e),at=a(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-g7p5pv"&&(re.textContent=St),it=a(e),u(oe.$$.fragment,e),rt=a(e),pe=r(e,"OL",{"data-svelte-h":!0}),o(pe)!=="svelte-rbjkud"&&(pe.innerHTML=Ft),ot=a(e),u(ue.$$.fragment,e),pt=a(e),ge=r(e,"OL",{"data-svelte-h":!0}),o(ge)!=="svelte-aeb0ps"&&(ge.innerHTML=Ht),ut=a(e),u(me.$$.fragment,e),gt=a(e),de=r(e,"OL",{"data-svelte-h":!0}),o(de)!=="svelte-1txeeui"&&(de.innerHTML=Et),mt=a(e),u(ce.$$.fragment,e),dt=a(e),he=r(e,"OL",{"data-svelte-h":!0}),o(he)!=="svelte-1ex27cn"&&(he.innerHTML=At),ct=a(e),Me=r(e,"P",{}),Nt(Me).forEach(n),this.h()},h(){ft(h,"name","hf:doc:metadata"),ft(h,"content",rn),ft(b,"class","image table text-center m-0 w-full"),ft(w,"class","image table text-center m-0 w-full")},m(e,t){en(document.head,h),s(e,j,t),s(e,f,t),s(e,fe,t),g(k,e,t),s(e,we,t),g(J,e,t),s(e,ye,t),s(e,v,t),s(e,Te,t),s(e,U,t),s(e,je,t),s(e,z,t),s(e,ke,t),s(e,Z,t),s(e,Je,t),s(e,$,t),s(e,ve,t),g(_,e,t),s(e,Ue,t),g(G,e,t),s(e,ze,t),s(e,I,t),s(e,Ze,t),s(e,b,t),s(e,$e,t),s(e,W,t),s(e,_e,t),s(e,w,t),s(e,Ge,t),s(e,C,t),s(e,Ie,t),s(e,V,t),s(e,We,t),s(e,x,t),s(e,Ce,t),g(y,e,t),s(e,Ve,t),s(e,L,t),s(e,xe,t),g(R,e,t),s(e,Le,t),s(e,X,t),s(e,Re,t),s(e,B,t),s(e,Xe,t),s(e,S,t),s(e,Be,t),s(e,F,t),s(e,Se,t),g(H,e,t),s(e,Fe,t),s(e,E,t),s(e,He,t),s(e,A,t),s(e,Ee,t),g(Q,e,t),s(e,Ae,t),s(e,N,t),s(e,Qe,t),g(q,e,t),s(e,Ne,t),s(e,Y,t),s(e,qe,t),g(D,e,t),s(e,Ye,t),g(P,e,t),s(e,De,t),s(e,K,t),s(e,Pe,t),g(O,e,t),s(e,Ke,t),g(ee,e,t),s(e,Oe,t),s(e,te,t),s(e,et,t),g(ne,e,t),s(e,tt,t),g(se,e,t),s(e,nt,t),s(e,le,t),s(e,st,t),g(ae,e,t),s(e,lt,t),g(ie,e,t),s(e,at,t),s(e,re,t),s(e,it,t),g(oe,e,t),s(e,rt,t),s(e,pe,t),s(e,ot,t),g(ue,e,t),s(e,pt,t),s(e,ge,t),s(e,ut,t),g(me,e,t),s(e,gt,t),s(e,de,t),s(e,mt,t),g(ce,e,t),s(e,dt,t),s(e,he,t),s(e,ct,t),s(e,Me,t),ht=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),y.$set(Qt)},i(e){ht||(m(k.$$.fragment,e),m(J.$$.fragment,e),m(_.$$.fragment,e),m(G.$$.fragment,e),m(y.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ue.$$.fragment,e),m(me.$$.fragment,e),m(ce.$$.fragment,e),ht=!0)},o(e){d(k.$$.fragment,e),d(J.$$.fragment,e),d(_.$$.fragment,e),d(G.$$.fragment,e),d(y.$$.fragment,e),d(R.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ne.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),ht=!1},d(e){e&&(n(j),n(f),n(fe),n(we),n(ye),n(v),n(Te),n(U),n(je),n(z),n(ke),n(Z),n(Je),n($),n(ve),n(Ue),n(ze),n(I),n(Ze),n(b),n($e),n(W),n(_e),n(w),n(Ge),n(C),n(Ie),n(V),n(We),n(x),n(Ce),n(Ve),n(L),n(xe),n(Le),n(X),n(Re),n(B),n(Xe),n(S),n(Be),n(F),n(Se),n(Fe),n(E),n(He),n(A),n(Ee),n(Ae),n(N),n(Qe),n(Ne),n(Y),n(qe),n(Ye),n(De),n(K),n(Pe),n(Ke),n(Oe),n(te),n(et),n(tt),n(nt),n(le),n(st),n(lt),n(at),n(re),n(it),n(rt),n(pe),n(ot),n(pt),n(ge),n(ut),n(gt),n(de),n(mt),n(dt),n(he),n(ct),n(Me)),n(h),c(k,e),c(J,e),c(_,e),c(G,e),c(y,e),c(R,e),c(H,e),c(Q,e),c(q,e),c(D,e),c(P,e),c(O,e),c(ee,e),c(ne,e),c(se,e),c(ae,e),c(ie,e),c(oe,e),c(ue,e),c(me,e),c(ce,e)}}}const rn='{"title":"Generation with LLMs","local":"generation-with-llms","sections":[{"title":"Text generieren","local":"text-generieren","sections":[],"depth":2},{"title":"Häufige Fallstricke","local":"häufige-fallstricke","sections":[{"title":"Generierte Ausgabe ist zu kurz/lang","local":"generierte-ausgabe-ist-zu-kurzlang","sections":[],"depth":3},{"title":"Falscher Generierungsmodus","local":"falscher-generierungsmodus","sections":[],"depth":3},{"title":"Falsche Auffüllseite","local":"falsche-auffüllseite","sections":[],"depth":3}],"depth":2},{"title":"Weitere Ressourcen","local":"weitere-ressourcen","sections":[{"title":"Fortgeschrittene Nutzung generieren","local":"fortgeschrittene-nutzung-generieren","sections":[],"depth":3},{"title":"LLM-Ranglisten","local":"llm-ranglisten","sections":[],"depth":3},{"title":"Latenz und Durchsatz","local":"latenz-und-durchsatz","sections":[],"depth":3},{"title":"Verwandte Bibliotheken","local":"verwandte-bibliotheken","sections":[],"depth":3}],"depth":2}],"depth":1}';function on(be){return Yt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=tn}),[]}class hn extends Pt{constructor(h){super(),Kt(this,h,on,an,qt,{})}}export{hn as component};
