import{s as yl,o as fl,n as ge}from"../chunks/scheduler.9bc65507.js";import{S as Il,i as Ul,g as p,s as n,r as M,A as Cl,h as r,f as l,c as t,j as Tl,u as w,x as u,k as Jl,y as Zl,a,v as o,d as j,t as m,w as h}from"../chunks/index.707bf1b6.js";import{H as Be,g as Al}from"../chunks/Heading.9a412c8a.js";import{T as ke}from"../chunks/Tip.c2ecdbf4.js";import{C as b}from"../chunks/CodeBlock.54a9f38d.js";function Gl(J){let c,d="This feature is currently available for PyTorch-only.";return{c(){c=p("p"),c.textContent=d},l(i){c=r(i,"P",{"data-svelte-h":!0}),u(c)!=="svelte-1659hm6"&&(c.textContent=d)},m(i,T){a(i,c,T)},p:ge,d(i){i&&l(c)}}}function Vl(J){let c,d="For multi-GPU training it requires DDP (<code>torch.distributed.launch</code>).";return{c(){c=p("p"),c.innerHTML=d},l(i){c=r(i,"P",{"data-svelte-h":!0}),u(c)!=="svelte-b2srlm"&&(c.innerHTML=d)},m(i,T){a(i,c,T)},p:ge,d(i){i&&l(c)}}}function vl(J){let c,d="This feature can be used with any <code>nn.Module</code>-based model.";return{c(){c=p("p"),c.innerHTML=d},l(i){c=r(i,"P",{"data-svelte-h":!0}),u(c)!=="svelte-tkb0f4"&&(c.innerHTML=d)},m(i,T){a(i,c,T)},p:ge,d(i){i&&l(c)}}}function Bl(J){let c,d,i,T,U,Zs,C,As,Z,Re="When training or inferencing with <code>DistributedDataParallel</code> and multiple GPU, if you run into issue of inter-communication between processes and/or nodes, you can use the following script to diagnose network issues.",Gs,A,Vs,G,$e="For example to test how 2 GPUs interact do:",vs,V,Bs,v,_e="If both processes can talk to each and allocate GPU memory each will print an OK status.",ks,B,xe="For more GPUs or nodes adjust the arguments in the script.",gs,k,Le="You will find a lot more details inside the diagnostics script and even a recipe to how you could run it in a SLURM environment.",Rs,g,Ne="An additional level of debug is to add <code>NCCL_DEBUG=INFO</code> environment variable as follows:",$s,R,_s,$,We="This will dump a lot of NCCL-related debug information, which you can then search online if you find that some problems are reported. Or if you’re not sure how to interpret the output you can share the log file in an Issue.",xs,_,Ls,y,Ns,f,Ws,I,Es,x,Ee=`If you start getting <code>loss=NaN</code> or the model inhibits some other abnormal behavior due to <code>inf</code> or <code>nan</code> in
activations or weights one needs to discover where the first underflow or overflow happens and what led to it. Luckily
you can accomplish that easily by activating a special module that will do the detection automatically.`,Xs,L,Xe='If you’re using <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, you just need to add:',Qs,N,Ds,W,Qe=`to the normal command line arguments, or pass <code>debug=&quot;underflow_overflow&quot;</code> when creating the
<a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> object.`,Hs,E,De="If you’re using your own training loop or another Trainer you can accomplish the same with:",Ss,X,Ys,Q,He=`<a href="/docs/transformers/v4.35.2/en/internal/trainer_utils#transformers.debug_utils.DebugUnderflowOverflow">DebugUnderflowOverflow</a> inserts hooks into the model that immediately after each
forward call will test input and output variables and also the corresponding module’s weights. As soon as <code>inf</code> or
<code>nan</code> is detected in at least one element of the activations or weights, the program will assert and print a report
like this (this was caught with <code>google/mt5-small</code> under fp16 mixed precision):`,zs,D,Fs,H,Se="The example output has been trimmed in the middle for brevity.",Ps,S,Ye=`The second column shows the value of the absolute largest element, so if you have a closer look at the last few frames,
the inputs and outputs were in the range of <code>1e4</code>. So when this training was done under fp16 mixed precision the very
last step overflowed (since under <code>fp16</code> the largest number before <code>inf</code> is <code>64e3</code>). To avoid overflows under
<code>fp16</code> the activations must remain way below <code>1e4</code>, because <code>1e4 * 1e4 = 1e8</code> so any matrix multiplication with
large activations is going to lead to a numerical overflow condition.`,Ks,Y,ze="At the very start of the trace you can discover at which batch number the problem occurred (here <code>Detected inf/nan during batch_number=0</code> means the problem occurred on the first batch).",qs,z,Fe=`Each reported frame starts by declaring the fully qualified entry for the corresponding module this frame is reporting
for. If we look just at this frame:`,Os,F,se,P,Pe=`Here, <code>encoder.block.2.layer.1.layer_norm</code> indicates that it was a layer norm for the first layer, of the second
block of the encoder. And the specific calls of the <code>forward</code> is <code>T5LayerNorm</code>.`,ee,K,Ke="Let’s look at the last few frames of that report:",le,q,ae,O,qe=`The last frame reports for <code>Dropout.forward</code> function with the first entry for the only input and the second for the
only output. You can see that it was called from an attribute <code>dropout</code> inside <code>DenseReluDense</code> class. We can see
that it happened during the first layer, of the 2nd block, during the very first batch. Finally, the absolute largest
input elements was <code>6.27e+04</code> and same for the output was <code>inf</code>.`,ne,ss,Oe=`You can see here, that <code>T5DenseGatedGeluDense.forward</code> resulted in output activations, whose absolute max value was
around 62.7K, which is very close to fp16’s top limit of 64K. In the next frame we have <code>Dropout</code> which renormalizes
the weights, after it zeroed some of the elements, which pushes the absolute max value to more than 64K, and we get an
overflow (<code>inf</code>).`,te,es,sl=`As you can see it’s the previous frames that we need to look into when the numbers start going into very large for fp16
numbers.`,pe,ls,el="Let’s match the report to the code from <code>models/t5/modeling_t5.py</code>:",re,as,ue,ns,ll="Now it’s easy to see the <code>dropout</code> call, and all the previous calls as well.",ce,ts,al=`Since the detection is happening in a forward hook, these reports are printed immediately after each <code>forward</code>
returns.`,ie,ps,nl=`Going back to the full report, to act on it and to fix the problem, we need to go a few frames up where the numbers
started to go up and most likely switch to the <code>fp32</code> mode here, so that the numbers don’t overflow when multiplied
or summed up. Of course, there might be other solutions. For example, we could turn off <code>amp</code> temporarily if it’s
enabled, after moving the original <code>forward</code> into a helper wrapper, like so:`,Me,rs,we,us,tl=`Since the automatic detector only reports on inputs and outputs of full frames, once you know where to look, you may
want to analyse the intermediary stages of any specific <code>forward</code> function as well. In such a case you can use the
<code>detect_overflow</code> helper function to inject the detector where you want it, for example:`,oe,cs,je,is,pl=`You can see that we added 2 of these and now we track if <code>inf</code> or <code>nan</code> for <code>forwarded_states</code> was detected
somewhere in between.`,me,Ms,rl=`Actually, the detector already reports these because each of the calls in the example above is a <code>nn.Module</code>, but
let’s say if you had some local direct calculations this is how you’d do that.`,he,ws,ul=`Additionally, if you’re instantiating the debugger in your own code, you can adjust the number of frames printed from
its default, e.g.:`,be,os,de,js,Te,ms,cl="The same debugging class can be used for per-batch tracing with the underflow/overflow detection feature turned off.",Je,hs,il=`Let’s say you want to watch the absolute min and max values for all the ingredients of each <code>forward</code> call of a given
batch, and only do that for batches 1 and 3. Then you instantiate this class as:`,ye,bs,fe,ds,Ml="And now full batches 1 and 3 will be traced using the same format as the underflow/overflow detector does.",Ie,Ts,wl="Batches are 0-indexed.",Ue,Js,ol=`This is helpful if you know that the program starts misbehaving after a certain batch number, so you can fast-forward
right to that area. Here is a sample truncated output for such configuration:`,Ce,ys,Ze,fs,jl=`Here you will get a huge number of frames dumped - as many as there were forward calls in your model, so it may or may
not what you want, but sometimes it can be easier to use for debugging purposes than a normal debugger. For example, if
a problem starts happening at batch number 150. So you can dump traces for batches 149 and 150 and compare where
numbers started to diverge.`,Ae,Is,ml="You can also specify the batch number after which to stop the training, with:",Ge,Us,Ve,Cs,ve;return U=new Be({props:{title:"Debugging",local:"debugging",headingTag:"h1"}}),C=new Be({props:{title:"Multi-GPU Network Issues Debug",local:"multi-gpu-network-issues-debug",headingTag:"h2"}}),A=new b({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTJGbWFpbiUyRnNjcmlwdHMlMkZkaXN0cmlidXRlZCUyRnRvcmNoLWRpc3RyaWJ1dGVkLWdwdS10ZXN0LnB5",highlighted:"wget https://raw.githubusercontent.com/huggingface/transformers/main/scripts/distributed/torch-distributed-gpu-test.py",wrap:!1}}),V=new b({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5ydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMC0tbm5vZGVzJTIwMSUyMHRvcmNoLWRpc3RyaWJ1dGVkLWdwdS10ZXN0LnB5",highlighted:"python -m torch.distributed.run --nproc_per_node 2 --nnodes 1 torch-distributed-gpu-test.py",wrap:!1}}),R=new b({props:{code:"TkNDTF9ERUJVRyUzRElORk8lMjBweXRob24lMjAtbSUyMHRvcmNoLmRpc3RyaWJ1dGVkLnJ1biUyMC0tbnByb2NfcGVyX25vZGUlMjAyJTIwLS1ubm9kZXMlMjAxJTIwdG9yY2gtZGlzdHJpYnV0ZWQtZ3B1LXRlc3QucHk=",highlighted:"NCCL_DEBUG=INFO python -m torch.distributed.run --nproc_per_node 2 --nnodes 1 torch-distributed-gpu-test.py",wrap:!1}}),_=new Be({props:{title:"Underflow and Overflow Detection",local:"underflow-and-overflow-detection",headingTag:"h2"}}),y=new ke({props:{$$slots:{default:[Gl]},$$scope:{ctx:J}}}),f=new ke({props:{$$slots:{default:[Vl]},$$scope:{ctx:J}}}),I=new ke({props:{$$slots:{default:[vl]},$$scope:{ctx:J}}}),N=new b({props:{code:"LS1kZWJ1ZyUyMHVuZGVyZmxvd19vdmVyZmxvdw==",highlighted:"--debug underflow_overflow",wrap:!1}}),X=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5kZWJ1Z191dGlscyUyMGltcG9ydCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3clMEElMEFkZWJ1Z19vdmVyZmxvdyUyMCUzRCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3cobW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> transformers.debug_utils <span class="hljs-keyword">import</span> DebugUnderflowOverflow

debug_overflow = DebugUnderflowOverflow(model)`,wrap:!1}}),D=new b({props:{code:"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",highlighted:`<span class="hljs-attribute">Detected</span> inf/nan during batch_number=<span class="hljs-number">0</span>
<span class="hljs-attribute">Last</span> <span class="hljs-number">21</span> forward frames:
<span class="hljs-attribute">abs</span> min  abs max  metadata
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">1</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.dropout Dropout
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">2</span>.<span class="hljs-number">57</span>e+<span class="hljs-number">02</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">2</span>.<span class="hljs-number">85</span>e+<span class="hljs-number">02</span> output<span class="hljs-meta">
[...]</span>
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">0</span> T5LayerSelfAttention
<span class="hljs-attribute">6</span>.<span class="hljs-number">78</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">15</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> output[<span class="hljs-number">0</span>]
             <span class="hljs-attribute">None</span> output[<span class="hljs-number">1</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">25</span>e-<span class="hljs-number">01</span> <span class="hljs-number">1</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">04</span> output[<span class="hljs-number">2</span>]
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.layer_norm T5LayerNorm
<span class="hljs-attribute">8</span>.<span class="hljs-number">69</span>e-<span class="hljs-number">02</span> <span class="hljs-number">4</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">01</span> weight
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_0 Linear
<span class="hljs-attribute">2</span>.<span class="hljs-number">17</span>e-<span class="hljs-number">07</span> <span class="hljs-number">4</span>.<span class="hljs-number">50</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">68</span>e-<span class="hljs-number">06</span> <span class="hljs-number">3</span>.<span class="hljs-number">70</span>e+<span class="hljs-number">01</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_1 Linear
<span class="hljs-attribute">8</span>.<span class="hljs-number">08</span>e-<span class="hljs-number">07</span> <span class="hljs-number">2</span>.<span class="hljs-number">66</span>e+<span class="hljs-number">01</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">27</span>e-<span class="hljs-number">04</span> <span class="hljs-number">2</span>.<span class="hljs-number">37</span>e+<span class="hljs-number">02</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.dropout Dropout
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">8</span>.<span class="hljs-number">76</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wo Linear
<span class="hljs-attribute">1</span>.<span class="hljs-number">01</span>e-<span class="hljs-number">06</span> <span class="hljs-number">6</span>.<span class="hljs-number">44</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense T5DenseGatedGeluDense
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.dropout Dropout
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span>      inf output`,wrap:!1}}),F=new b({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEubGF5ZXJfbm9ybSUyMFQ1TGF5ZXJOb3JtJTBBOC42OWUtMDIlMjA0LjE4ZS0wMSUyMHdlaWdodCUwQTIuNjVlLTA0JTIwMy40MmUlMkIwMyUyMGlucHV0JTVCMCU1RCUwQTEuNzllLTA2JTIwNC42NWUlMkIwMCUyMG91dHB1dA==",highlighted:`                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.layer_norm T5LayerNorm
<span class="hljs-attribute">8</span>.<span class="hljs-number">69</span>e-<span class="hljs-number">02</span> <span class="hljs-number">4</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">01</span> weight
<span class="hljs-attribute">2</span>.<span class="hljs-number">65</span>e-<span class="hljs-number">04</span> <span class="hljs-number">3</span>.<span class="hljs-number">42</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> output`,wrap:!1}}),q=new b({props:{code:"RGV0ZWN0ZWQlMjBpbmYlMkZuYW4lMjBkdXJpbmclMjBiYXRjaF9udW1iZXIlM0QwJTBBTGFzdCUyMDIxJTIwZm9yd2FyZCUyMGZyYW1lcyUzQSUwQWFicyUyMG1pbiUyMCUyMGFicyUyMG1heCUyMCUyMG1ldGFkYXRhJTBBJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEuRGVuc2VSZWx1RGVuc2Uud2lfMCUyMExpbmVhciUwQTIuMTdlLTA3JTIwNC41MGUlMkIwMCUyMHdlaWdodCUwQTEuNzllLTA2JTIwNC42NWUlMkIwMCUyMGlucHV0JTVCMCU1RCUwQTIuNjhlLTA2JTIwMy43MGUlMkIwMSUyMG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVuY29kZXIuYmxvY2suMi5sYXllci4xLkRlbnNlUmVsdURlbnNlLndpXzElMjBMaW5lYXIlMEE4LjA4ZS0wNyUyMDIuNjZlJTJCMDElMjB3ZWlnaHQlMEExLjc5ZS0wNiUyMDQuNjVlJTJCMDAlMjBpbnB1dCU1QjAlNUQlMEExLjI3ZS0wNCUyMDIuMzdlJTJCMDIlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGVyLmJsb2NrLjIubGF5ZXIuMS5EZW5zZVJlbHVEZW5zZS53byUyMExpbmVhciUwQTEuMDFlLTA2JTIwNi40NGUlMkIwMCUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjA5Ljc0ZSUyQjAzJTIwaW5wdXQlNUIwJTVEJTBBMy4xOGUtMDQlMjA2LjI3ZSUyQjA0JTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5jb2Rlci5ibG9jay4yLmxheWVyLjEuRGVuc2VSZWx1RGVuc2UlMjBUNURlbnNlR2F0ZWRHZWx1RGVuc2UlMEExLjc5ZS0wNiUyMDQuNjVlJTJCMDAlMjBpbnB1dCU1QjAlNUQlMEEzLjE4ZS0wNCUyMDYuMjdlJTJCMDQlMjBvdXRwdXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGVyLmJsb2NrLjIubGF5ZXIuMS5kcm9wb3V0JTIwRHJvcG91dCUwQTMuMThlLTA0JTIwNi4yN2UlMkIwNCUyMGlucHV0JTVCMCU1RCUwQTAuMDBlJTJCMDAlMjAlMjAlMjAlMjAlMjAlMjBpbmYlMjBvdXRwdXQ=",highlighted:`<span class="hljs-attribute">Detected</span> inf/nan during batch_number=<span class="hljs-number">0</span>
<span class="hljs-attribute">Last</span> <span class="hljs-number">21</span> forward frames:
<span class="hljs-attribute">abs</span> min  abs max  metadata<span class="hljs-meta">
[...]</span>
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_0 Linear
<span class="hljs-attribute">2</span>.<span class="hljs-number">17</span>e-<span class="hljs-number">07</span> <span class="hljs-number">4</span>.<span class="hljs-number">50</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">2</span>.<span class="hljs-number">68</span>e-<span class="hljs-number">06</span> <span class="hljs-number">3</span>.<span class="hljs-number">70</span>e+<span class="hljs-number">01</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wi_1 Linear
<span class="hljs-attribute">8</span>.<span class="hljs-number">08</span>e-<span class="hljs-number">07</span> <span class="hljs-number">2</span>.<span class="hljs-number">66</span>e+<span class="hljs-number">01</span> weight
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">1</span>.<span class="hljs-number">27</span>e-<span class="hljs-number">04</span> <span class="hljs-number">2</span>.<span class="hljs-number">37</span>e+<span class="hljs-number">02</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense.wo Linear
<span class="hljs-attribute">1</span>.<span class="hljs-number">01</span>e-<span class="hljs-number">06</span> <span class="hljs-number">6</span>.<span class="hljs-number">44</span>e+<span class="hljs-number">00</span> weight
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span> <span class="hljs-number">9</span>.<span class="hljs-number">74</span>e+<span class="hljs-number">03</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.DenseReluDense T5DenseGatedGeluDense
<span class="hljs-attribute">1</span>.<span class="hljs-number">79</span>e-<span class="hljs-number">06</span> <span class="hljs-number">4</span>.<span class="hljs-number">65</span>e+<span class="hljs-number">00</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> output
                  <span class="hljs-attribute">encoder</span>.block.<span class="hljs-number">2</span>.layer.<span class="hljs-number">1</span>.dropout Dropout
<span class="hljs-attribute">3</span>.<span class="hljs-number">18</span>e-<span class="hljs-number">04</span> <span class="hljs-number">6</span>.<span class="hljs-number">27</span>e+<span class="hljs-number">04</span> input[<span class="hljs-number">0</span>]
<span class="hljs-attribute">0</span>.<span class="hljs-number">00</span>e+<span class="hljs-number">00</span>      inf output`,wrap:!1}}),as=new b({props:{code:"Y2xhc3MlMjBUNURlbnNlR2F0ZWRHZWx1RGVuc2Uobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53aV8wJTIwJTNEJTIwbm4uTGluZWFyKGNvbmZpZy5kX21vZGVsJTJDJTIwY29uZmlnLmRfZmYlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53aV8xJTIwJTNEJTIwbm4uTGluZWFyKGNvbmZpZy5kX21vZGVsJTJDJTIwY29uZmlnLmRfZmYlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53byUyMCUzRCUyMG5uLkxpbmVhcihjb25maWcuZF9mZiUyQyUyMGNvbmZpZy5kX21vZGVsJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZHJvcG91dCUyMCUzRCUyMG5uLkRyb3BvdXQoY29uZmlnLmRyb3BvdXRfcmF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmdlbHVfYWN0JTIwJTNEJTIwQUNUMkZOJTVCJTIyZ2VsdV9uZXclMjIlNUQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBoaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9nZWx1JTIwJTNEJTIwc2VsZi5nZWx1X2FjdChzZWxmLndpXzAoaGlkZGVuX3N0YXRlcykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX2xpbmVhciUyMCUzRCUyMHNlbGYud2lfMShoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBoaWRkZW5fZ2VsdSUyMColMjBoaWRkZW5fbGluZWFyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHNlbGYuZHJvcG91dChoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBzZWxmLndvKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaGlkZGVuX3N0YXRlcw==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">T5DenseGatedGeluDense</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.wi_0 = nn.Linear(config.d_model, config.d_ff, bias=<span class="hljs-literal">False</span>)
        self.wi_1 = nn.Linear(config.d_model, config.d_ff, bias=<span class="hljs-literal">False</span>)
        self.wo = nn.Linear(config.d_ff, config.d_model, bias=<span class="hljs-literal">False</span>)
        self.dropout = nn.Dropout(config.dropout_rate)
        self.gelu_act = ACT2FN[<span class="hljs-string">&quot;gelu_new&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
        hidden_gelu = self.gelu_act(self.wi_0(hidden_states))
        hidden_linear = self.wi_1(hidden_states)
        hidden_states = hidden_gelu * hidden_linear
        hidden_states = self.dropout(hidden_states)
        hidden_states = self.wo(hidden_states)
        <span class="hljs-keyword">return</span> hidden_states`,wrap:!1}}),rs=new b({props:{code:"ZGVmJTIwX2ZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwaGlkZGVuX2dlbHUlMjAlM0QlMjBzZWxmLmdlbHVfYWN0KHNlbGYud2lfMChoaWRkZW5fc3RhdGVzKSklMEElMjAlMjAlMjAlMjBoaWRkZW5fbGluZWFyJTIwJTNEJTIwc2VsZi53aV8xKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMGhpZGRlbl9nZWx1JTIwKiUyMGhpZGRlbl9saW5lYXIlMEElMjAlMjAlMjAlMjBoaWRkZW5fc3RhdGVzJTIwJTNEJTIwc2VsZi5kcm9wb3V0KGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHNlbGYud28oaGlkZGVuX3N0YXRlcyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaWRkZW5fc3RhdGVzJTBBJTBBJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBoaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guaXNfYXV0b2Nhc3RfZW5hYmxlZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmN1ZGEuYW1wLmF1dG9jYXN0KGVuYWJsZWQlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9mb3J3YXJkKGhpZGRlbl9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuX2ZvcndhcmQoaGlkZGVuX3N0YXRlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, hidden_states</span>):
    hidden_gelu = self.gelu_act(self.wi_0(hidden_states))
    hidden_linear = self.wi_1(hidden_states)
    hidden_states = hidden_gelu * hidden_linear
    hidden_states = self.dropout(hidden_states)
    hidden_states = self.wo(hidden_states)
    <span class="hljs-keyword">return</span> hidden_states


<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
    <span class="hljs-keyword">if</span> torch.is_autocast_enabled():
        <span class="hljs-keyword">with</span> torch.cuda.amp.autocast(enabled=<span class="hljs-literal">False</span>):
            <span class="hljs-keyword">return</span> self._forward(hidden_states)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> self._forward(hidden_states)`,wrap:!1}}),cs=new b({props:{code:"ZnJvbSUyMGRlYnVnX3V0aWxzJTIwaW1wb3J0JTIwZGV0ZWN0X292ZXJmbG93JTBBJTBBJTBBY2xhc3MlMjBUNUxheWVyRkYobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCU1Qi4uLiU1RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yd2FyZGVkX3N0YXRlcyUyMCUzRCUyMHNlbGYubGF5ZXJfbm9ybShoaWRkZW5fc3RhdGVzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldGVjdF9vdmVyZmxvdyhmb3J3YXJkZWRfc3RhdGVzJTJDJTIwJTIyYWZ0ZXIlMjBsYXllcl9ub3JtJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcndhcmRlZF9zdGF0ZXMlMjAlM0QlMjBzZWxmLkRlbnNlUmVsdURlbnNlKGZvcndhcmRlZF9zdGF0ZXMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV0ZWN0X292ZXJmbG93KGZvcndhcmRlZF9zdGF0ZXMlMkMlMjAlMjJhZnRlciUyMERlbnNlUmVsdURlbnNlJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGhpZGRlbl9zdGF0ZXMlMjAlMkIlMjBzZWxmLmRyb3BvdXQoZm9yd2FyZGVkX3N0YXRlcyk=",highlighted:`<span class="hljs-keyword">from</span> debug_utils <span class="hljs-keyword">import</span> detect_overflow


<span class="hljs-keyword">class</span> <span class="hljs-title class_">T5LayerFF</span>(nn.Module):
    [...]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states</span>):
        forwarded_states = self.layer_norm(hidden_states)
        detect_overflow(forwarded_states, <span class="hljs-string">&quot;after layer_norm&quot;</span>)
        forwarded_states = self.DenseReluDense(forwarded_states)
        detect_overflow(forwarded_states, <span class="hljs-string">&quot;after DenseReluDense&quot;</span>)
        <span class="hljs-keyword">return</span> hidden_states + self.dropout(forwarded_states)`,wrap:!1}}),os=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5kZWJ1Z191dGlscyUyMGltcG9ydCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3clMEElMEFkZWJ1Z19vdmVyZmxvdyUyMCUzRCUyMERlYnVnVW5kZXJmbG93T3ZlcmZsb3cobW9kZWwlMkMlMjBtYXhfZnJhbWVzX3RvX3NhdmUlM0QxMDAp",highlighted:`<span class="hljs-keyword">from</span> transformers.debug_utils <span class="hljs-keyword">import</span> DebugUnderflowOverflow

debug_overflow = DebugUnderflowOverflow(model, max_frames_to_save=<span class="hljs-number">100</span>)`,wrap:!1}}),js=new Be({props:{title:"Specific batch absolute min and max value tracing",local:"specific-batch-absolute-min-and-max-value-tracing",headingTag:"h3"}}),bs=new b({props:{code:"ZGVidWdfb3ZlcmZsb3clMjAlM0QlMjBEZWJ1Z1VuZGVyZmxvd092ZXJmbG93KG1vZGVsJTJDJTIwdHJhY2VfYmF0Y2hfbnVtcyUzRCU1QjElMkMlMjAzJTVEKQ==",highlighted:'debug_overflow = DebugUnderflowOverflow(model, trace_batch_nums=[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>])',wrap:!1}}),ys=new b({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKioqJTIwU3RhcnRpbmclMjBiYXRjaCUyMG51bWJlciUzRDElMjAqKiolMEFhYnMlMjBtaW4lMjAlMjBhYnMlMjBtYXglMjAlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXJlZCUyMEVtYmVkZGluZyUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAyLjQ3ZSUyQjA0JTIwaW5wdXQlNUIwJTVEJTBBNS4zNmUtMDUlMjA3LjkyZSUyQjAyJTIwb3V0cHV0JTBBJTVCLi4uJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2Rlci5kcm9wb3V0JTIwRHJvcG91dCUwQTEuNjBlLTA3JTIwMi4yN2UlMkIwMSUyMGlucHV0JTVCMCU1RCUwQTAuMDBlJTJCMDAlMjAyLjUyZSUyQjAxJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2RlciUyMFQ1U3RhY2slMEElMjAlMjAlMjAlMjAlMjBub3QlMjBhJTIwdGVuc29yJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG1faGVhZCUyMExpbmVhciUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAxLjExZSUyQjAwJTIwaW5wdXQlNUIwJTVEJTBBNi4wNmUtMDIlMjA4LjM5ZSUyQjAxJTIwb3V0cHV0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMjAlMjAlMjAlMjAlMjBub3QlMjBhJTIwdGVuc29yJTIwb3V0cHV0JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKioqJTIwU3RhcnRpbmclMjBiYXRjaCUyMG51bWJlciUzRDMlMjAqKiolMEFhYnMlMjBtaW4lMjAlMjBhYnMlMjBtYXglMjAlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXJlZCUyMEVtYmVkZGluZyUwQTEuMDFlLTA2JTIwNy45MmUlMkIwMiUyMHdlaWdodCUwQTAuMDBlJTJCMDAlMjAyLjc4ZSUyQjA0JTIwaW5wdXQlNUIwJTVEJTBBNS4zNmUtMDUlMjA3LjkyZSUyQjAyJTIwb3V0cHV0JTBBJTVCLi4uJTVE",highlighted:`                  *** Starting batch number=1 ***
abs min  abs max  metadata
                  shared Embedding
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 2.47e<span class="hljs-string">+04</span> input[0]
5.36e<span class="hljs-string">-05</span> 7.92e<span class="hljs-string">+02</span> output
[...]
                  decoder.dropout Dropout
1.60e<span class="hljs-string">-07</span> 2.27e<span class="hljs-string">+01</span> input[0]
0.00e<span class="hljs-string">+00</span> 2.52e<span class="hljs-string">+01</span> output
                  decoder T5Stack
     not a tensor output
                  lm_head Linear
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 1.11e<span class="hljs-string">+00</span> input[0]
6.06e<span class="hljs-string">-02</span> 8.39e<span class="hljs-string">+01</span> output
                   T5ForConditionalGeneration
     not a tensor output

                  *** Starting batch number=3 ***
abs min  abs max  metadata
                  shared Embedding
1.01e<span class="hljs-string">-06</span> 7.92e<span class="hljs-string">+02</span> weight
0.00e<span class="hljs-string">+00</span> 2.78e<span class="hljs-string">+04</span> input[0]
5.36e<span class="hljs-string">-05</span> 7.92e<span class="hljs-string">+02</span> output
[...]`,wrap:!1}}),Us=new b({props:{code:"ZGVidWdfb3ZlcmZsb3clMjAlM0QlMjBEZWJ1Z1VuZGVyZmxvd092ZXJmbG93KG1vZGVsJTJDJTIwdHJhY2VfYmF0Y2hfbnVtcyUzRCU1QjElMkMlMjAzJTVEJTJDJTIwYWJvcnRfYWZ0ZXJfYmF0Y2hfbnVtJTNEMyk=",highlighted:'debug_overflow = DebugUnderflowOverflow(model, trace_batch_nums=[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>], abort_after_batch_num=<span class="hljs-number">3</span>)',wrap:!1}}),{c(){c=p("meta"),d=n(),i=p("p"),T=n(),M(U.$$.fragment),Zs=n(),M(C.$$.fragment),As=n(),Z=p("p"),Z.innerHTML=Re,Gs=n(),M(A.$$.fragment),Vs=n(),G=p("p"),G.textContent=$e,vs=n(),M(V.$$.fragment),Bs=n(),v=p("p"),v.textContent=_e,ks=n(),B=p("p"),B.textContent=xe,gs=n(),k=p("p"),k.textContent=Le,Rs=n(),g=p("p"),g.innerHTML=Ne,$s=n(),M(R.$$.fragment),_s=n(),$=p("p"),$.textContent=We,xs=n(),M(_.$$.fragment),Ls=n(),M(y.$$.fragment),Ns=n(),M(f.$$.fragment),Ws=n(),M(I.$$.fragment),Es=n(),x=p("p"),x.innerHTML=Ee,Xs=n(),L=p("p"),L.innerHTML=Xe,Qs=n(),M(N.$$.fragment),Ds=n(),W=p("p"),W.innerHTML=Qe,Hs=n(),E=p("p"),E.textContent=De,Ss=n(),M(X.$$.fragment),Ys=n(),Q=p("p"),Q.innerHTML=He,zs=n(),M(D.$$.fragment),Fs=n(),H=p("p"),H.textContent=Se,Ps=n(),S=p("p"),S.innerHTML=Ye,Ks=n(),Y=p("p"),Y.innerHTML=ze,qs=n(),z=p("p"),z.textContent=Fe,Os=n(),M(F.$$.fragment),se=n(),P=p("p"),P.innerHTML=Pe,ee=n(),K=p("p"),K.textContent=Ke,le=n(),M(q.$$.fragment),ae=n(),O=p("p"),O.innerHTML=qe,ne=n(),ss=p("p"),ss.innerHTML=Oe,te=n(),es=p("p"),es.textContent=sl,pe=n(),ls=p("p"),ls.innerHTML=el,re=n(),M(as.$$.fragment),ue=n(),ns=p("p"),ns.innerHTML=ll,ce=n(),ts=p("p"),ts.innerHTML=al,ie=n(),ps=p("p"),ps.innerHTML=nl,Me=n(),M(rs.$$.fragment),we=n(),us=p("p"),us.innerHTML=tl,oe=n(),M(cs.$$.fragment),je=n(),is=p("p"),is.innerHTML=pl,me=n(),Ms=p("p"),Ms.innerHTML=rl,he=n(),ws=p("p"),ws.textContent=ul,be=n(),M(os.$$.fragment),de=n(),M(js.$$.fragment),Te=n(),ms=p("p"),ms.textContent=cl,Je=n(),hs=p("p"),hs.innerHTML=il,ye=n(),M(bs.$$.fragment),fe=n(),ds=p("p"),ds.textContent=Ml,Ie=n(),Ts=p("p"),Ts.textContent=wl,Ue=n(),Js=p("p"),Js.textContent=ol,Ce=n(),M(ys.$$.fragment),Ze=n(),fs=p("p"),fs.textContent=jl,Ae=n(),Is=p("p"),Is.textContent=ml,Ge=n(),M(Us.$$.fragment),Ve=n(),Cs=p("p"),this.h()},l(s){const e=Cl("svelte-u9bgzb",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(l),d=t(s),i=r(s,"P",{}),Tl(i).forEach(l),T=t(s),w(U.$$.fragment,s),Zs=t(s),w(C.$$.fragment,s),As=t(s),Z=r(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-9omdti"&&(Z.innerHTML=Re),Gs=t(s),w(A.$$.fragment,s),Vs=t(s),G=r(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1l3iq1o"&&(G.textContent=$e),vs=t(s),w(V.$$.fragment,s),Bs=t(s),v=r(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1mfzxxn"&&(v.textContent=_e),ks=t(s),B=r(s,"P",{"data-svelte-h":!0}),u(B)!=="svelte-p47u8u"&&(B.textContent=xe),gs=t(s),k=r(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-r57lzq"&&(k.textContent=Le),Rs=t(s),g=r(s,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1px963d"&&(g.innerHTML=Ne),$s=t(s),w(R.$$.fragment,s),_s=t(s),$=r(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-179ydg6"&&($.textContent=We),xs=t(s),w(_.$$.fragment,s),Ls=t(s),w(y.$$.fragment,s),Ns=t(s),w(f.$$.fragment,s),Ws=t(s),w(I.$$.fragment,s),Es=t(s),x=r(s,"P",{"data-svelte-h":!0}),u(x)!=="svelte-rc8gwf"&&(x.innerHTML=Ee),Xs=t(s),L=r(s,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1e8q0ts"&&(L.innerHTML=Xe),Qs=t(s),w(N.$$.fragment,s),Ds=t(s),W=r(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-5n9c2e"&&(W.innerHTML=Qe),Hs=t(s),E=r(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1l3b7y5"&&(E.textContent=De),Ss=t(s),w(X.$$.fragment,s),Ys=t(s),Q=r(s,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-gxqosu"&&(Q.innerHTML=He),zs=t(s),w(D.$$.fragment,s),Fs=t(s),H=r(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-2ii9wn"&&(H.textContent=Se),Ps=t(s),S=r(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1si0hkb"&&(S.innerHTML=Ye),Ks=t(s),Y=r(s,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-yj4cwf"&&(Y.innerHTML=ze),qs=t(s),z=r(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1w41g2g"&&(z.textContent=Fe),Os=t(s),w(F.$$.fragment,s),se=t(s),P=r(s,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1tqbqml"&&(P.innerHTML=Pe),ee=t(s),K=r(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-wdyrpk"&&(K.textContent=Ke),le=t(s),w(q.$$.fragment,s),ae=t(s),O=r(s,"P",{"data-svelte-h":!0}),u(O)!=="svelte-unqbdv"&&(O.innerHTML=qe),ne=t(s),ss=r(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-yxhf7s"&&(ss.innerHTML=Oe),te=t(s),es=r(s,"P",{"data-svelte-h":!0}),u(es)!=="svelte-qa5qyo"&&(es.textContent=sl),pe=t(s),ls=r(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-lw0sg0"&&(ls.innerHTML=el),re=t(s),w(as.$$.fragment,s),ue=t(s),ns=r(s,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-19gpk8b"&&(ns.innerHTML=ll),ce=t(s),ts=r(s,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-ipsm9a"&&(ts.innerHTML=al),ie=t(s),ps=r(s,"P",{"data-svelte-h":!0}),u(ps)!=="svelte-1rpvta4"&&(ps.innerHTML=nl),Me=t(s),w(rs.$$.fragment,s),we=t(s),us=r(s,"P",{"data-svelte-h":!0}),u(us)!=="svelte-up3p3a"&&(us.innerHTML=tl),oe=t(s),w(cs.$$.fragment,s),je=t(s),is=r(s,"P",{"data-svelte-h":!0}),u(is)!=="svelte-152lw1d"&&(is.innerHTML=pl),me=t(s),Ms=r(s,"P",{"data-svelte-h":!0}),u(Ms)!=="svelte-iv1rb"&&(Ms.innerHTML=rl),he=t(s),ws=r(s,"P",{"data-svelte-h":!0}),u(ws)!=="svelte-1kb9fq"&&(ws.textContent=ul),be=t(s),w(os.$$.fragment,s),de=t(s),w(js.$$.fragment,s),Te=t(s),ms=r(s,"P",{"data-svelte-h":!0}),u(ms)!=="svelte-mwprcu"&&(ms.textContent=cl),Je=t(s),hs=r(s,"P",{"data-svelte-h":!0}),u(hs)!=="svelte-medkr5"&&(hs.innerHTML=il),ye=t(s),w(bs.$$.fragment,s),fe=t(s),ds=r(s,"P",{"data-svelte-h":!0}),u(ds)!=="svelte-zj2sw0"&&(ds.textContent=Ml),Ie=t(s),Ts=r(s,"P",{"data-svelte-h":!0}),u(Ts)!=="svelte-ux7vsk"&&(Ts.textContent=wl),Ue=t(s),Js=r(s,"P",{"data-svelte-h":!0}),u(Js)!=="svelte-v84jpj"&&(Js.textContent=ol),Ce=t(s),w(ys.$$.fragment,s),Ze=t(s),fs=r(s,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-124ox4j"&&(fs.textContent=jl),Ae=t(s),Is=r(s,"P",{"data-svelte-h":!0}),u(Is)!=="svelte-vocb5m"&&(Is.textContent=ml),Ge=t(s),w(Us.$$.fragment,s),Ve=t(s),Cs=r(s,"P",{}),Tl(Cs).forEach(l),this.h()},h(){Jl(c,"name","hf:doc:metadata"),Jl(c,"content",kl)},m(s,e){Zl(document.head,c),a(s,d,e),a(s,i,e),a(s,T,e),o(U,s,e),a(s,Zs,e),o(C,s,e),a(s,As,e),a(s,Z,e),a(s,Gs,e),o(A,s,e),a(s,Vs,e),a(s,G,e),a(s,vs,e),o(V,s,e),a(s,Bs,e),a(s,v,e),a(s,ks,e),a(s,B,e),a(s,gs,e),a(s,k,e),a(s,Rs,e),a(s,g,e),a(s,$s,e),o(R,s,e),a(s,_s,e),a(s,$,e),a(s,xs,e),o(_,s,e),a(s,Ls,e),o(y,s,e),a(s,Ns,e),o(f,s,e),a(s,Ws,e),o(I,s,e),a(s,Es,e),a(s,x,e),a(s,Xs,e),a(s,L,e),a(s,Qs,e),o(N,s,e),a(s,Ds,e),a(s,W,e),a(s,Hs,e),a(s,E,e),a(s,Ss,e),o(X,s,e),a(s,Ys,e),a(s,Q,e),a(s,zs,e),o(D,s,e),a(s,Fs,e),a(s,H,e),a(s,Ps,e),a(s,S,e),a(s,Ks,e),a(s,Y,e),a(s,qs,e),a(s,z,e),a(s,Os,e),o(F,s,e),a(s,se,e),a(s,P,e),a(s,ee,e),a(s,K,e),a(s,le,e),o(q,s,e),a(s,ae,e),a(s,O,e),a(s,ne,e),a(s,ss,e),a(s,te,e),a(s,es,e),a(s,pe,e),a(s,ls,e),a(s,re,e),o(as,s,e),a(s,ue,e),a(s,ns,e),a(s,ce,e),a(s,ts,e),a(s,ie,e),a(s,ps,e),a(s,Me,e),o(rs,s,e),a(s,we,e),a(s,us,e),a(s,oe,e),o(cs,s,e),a(s,je,e),a(s,is,e),a(s,me,e),a(s,Ms,e),a(s,he,e),a(s,ws,e),a(s,be,e),o(os,s,e),a(s,de,e),o(js,s,e),a(s,Te,e),a(s,ms,e),a(s,Je,e),a(s,hs,e),a(s,ye,e),o(bs,s,e),a(s,fe,e),a(s,ds,e),a(s,Ie,e),a(s,Ts,e),a(s,Ue,e),a(s,Js,e),a(s,Ce,e),o(ys,s,e),a(s,Ze,e),a(s,fs,e),a(s,Ae,e),a(s,Is,e),a(s,Ge,e),o(Us,s,e),a(s,Ve,e),a(s,Cs,e),ve=!0},p(s,[e]){const hl={};e&2&&(hl.$$scope={dirty:e,ctx:s}),y.$set(hl);const bl={};e&2&&(bl.$$scope={dirty:e,ctx:s}),f.$set(bl);const dl={};e&2&&(dl.$$scope={dirty:e,ctx:s}),I.$set(dl)},i(s){ve||(j(U.$$.fragment,s),j(C.$$.fragment,s),j(A.$$.fragment,s),j(V.$$.fragment,s),j(R.$$.fragment,s),j(_.$$.fragment,s),j(y.$$.fragment,s),j(f.$$.fragment,s),j(I.$$.fragment,s),j(N.$$.fragment,s),j(X.$$.fragment,s),j(D.$$.fragment,s),j(F.$$.fragment,s),j(q.$$.fragment,s),j(as.$$.fragment,s),j(rs.$$.fragment,s),j(cs.$$.fragment,s),j(os.$$.fragment,s),j(js.$$.fragment,s),j(bs.$$.fragment,s),j(ys.$$.fragment,s),j(Us.$$.fragment,s),ve=!0)},o(s){m(U.$$.fragment,s),m(C.$$.fragment,s),m(A.$$.fragment,s),m(V.$$.fragment,s),m(R.$$.fragment,s),m(_.$$.fragment,s),m(y.$$.fragment,s),m(f.$$.fragment,s),m(I.$$.fragment,s),m(N.$$.fragment,s),m(X.$$.fragment,s),m(D.$$.fragment,s),m(F.$$.fragment,s),m(q.$$.fragment,s),m(as.$$.fragment,s),m(rs.$$.fragment,s),m(cs.$$.fragment,s),m(os.$$.fragment,s),m(js.$$.fragment,s),m(bs.$$.fragment,s),m(ys.$$.fragment,s),m(Us.$$.fragment,s),ve=!1},d(s){s&&(l(d),l(i),l(T),l(Zs),l(As),l(Z),l(Gs),l(Vs),l(G),l(vs),l(Bs),l(v),l(ks),l(B),l(gs),l(k),l(Rs),l(g),l($s),l(_s),l($),l(xs),l(Ls),l(Ns),l(Ws),l(Es),l(x),l(Xs),l(L),l(Qs),l(Ds),l(W),l(Hs),l(E),l(Ss),l(Ys),l(Q),l(zs),l(Fs),l(H),l(Ps),l(S),l(Ks),l(Y),l(qs),l(z),l(Os),l(se),l(P),l(ee),l(K),l(le),l(ae),l(O),l(ne),l(ss),l(te),l(es),l(pe),l(ls),l(re),l(ue),l(ns),l(ce),l(ts),l(ie),l(ps),l(Me),l(we),l(us),l(oe),l(je),l(is),l(me),l(Ms),l(he),l(ws),l(be),l(de),l(Te),l(ms),l(Je),l(hs),l(ye),l(fe),l(ds),l(Ie),l(Ts),l(Ue),l(Js),l(Ce),l(Ze),l(fs),l(Ae),l(Is),l(Ge),l(Ve),l(Cs)),l(c),h(U,s),h(C,s),h(A,s),h(V,s),h(R,s),h(_,s),h(y,s),h(f,s),h(I,s),h(N,s),h(X,s),h(D,s),h(F,s),h(q,s),h(as,s),h(rs,s),h(cs,s),h(os,s),h(js,s),h(bs,s),h(ys,s),h(Us,s)}}}const kl='{"title":"Debugging","local":"debugging","sections":[{"title":"Multi-GPU Network Issues Debug","local":"multi-gpu-network-issues-debug","sections":[],"depth":2},{"title":"Underflow and Overflow Detection","local":"underflow-and-overflow-detection","sections":[{"title":"Specific batch absolute min and max value tracing","local":"specific-batch-absolute-min-and-max-value-tracing","sections":[],"depth":3}],"depth":2}],"depth":1}';function gl(J){return fl(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Al}),[]}class Nl extends Il{constructor(c){super(),Ul(this,c,gl,Bl,yl,{})}}export{Nl as component};
