import{s as mt,f as pt,o as ht,n as Ee}from"../chunks/scheduler.9bc65507.js";import{S as ft,i as ut,g as d,s as r,r as h,A as gt,h as c,f as t,c as l,j as U,u as f,x as y,k as J,y as p,a,v as u,d as g,t as M,w as _}from"../chunks/index.707bf1b6.js";import{H as z,g as Mt}from"../chunks/Heading.9a412c8a.js";import{T as Rs}from"../chunks/Tip.c2ecdbf4.js";import{D as B}from"../chunks/Docstring.e01cd453.js";import{C as _s}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ms}from"../chunks/ExampleCodeBlock.20f42a66.js";function _t(j){let o,T="Example:",i,m,b;return m=new _s({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFQ29uZmlnJTJDJTIwVmlkZW9NQUVNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb01BRSUyMHZpZGVvbWFlLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVmlkZW9NQUVDb25maWcoKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTUFFTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEConfig, VideoMAEModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoMAE videomae-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoMAEConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=d("p"),o.textContent=T,i=r(),h(m.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=T),i=l(n),f(m.$$.fragment,n)},m(n,w){a(n,o,w),a(n,i,w),u(m,n,w),b=!0},p:Ee,i(n){b||(g(m.$$.fragment,n),b=!0)},o(n){M(m.$$.fragment,n),b=!1},d(n){n&&(t(o),t(i)),_(m,n)}}}function yt(j){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,m){a(i,o,m)},p:Ee,d(i){i&&t(o)}}}function bt(j){let o,T="Examples:",i,m,b;return m=new _s({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 16 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">16</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEModel.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1568</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){o=d("p"),o.textContent=T,i=r(),h(m.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),i=l(n),f(m.$$.fragment,n)},m(n,w){a(n,o,w),a(n,i,w),u(m,n,w),b=!0},p:Ee,i(n){b||(g(m.$$.fragment,n),b=!0)},o(n){M(m.$$.fragment,n),b=!1},d(n){n&&(t(o),t(i)),_(m,n)}}}function Tt(j){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,m){a(i,o,m)},p:Ee,d(i){i&&t(o)}}}function wt(j){let o,T="Examples:",i,m,b;return m=new _s({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFZpZGVvTUFFRm9yUHJlVHJhaW5pbmclMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW51bV9mcmFtZXMlMjAlM0QlMjAxNiUwQXZpZGVvJTIwJTNEJTIwbGlzdChucC5yYW5kb20ucmFuZGludCgwJTJDJTIwMjU2JTJDJTIwKG51bV9mcmFtZXMlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSkpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJNQ0ctTkpVJTJGdmlkZW9tYWUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMFZpZGVvTUFFRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMk1DRy1OSlUlMkZ2aWRlb21hZS1iYXNlJTIyKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvcih2aWRlbyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUwQW51bV9wYXRjaGVzX3Blcl9mcmFtZSUyMCUzRCUyMChtb2RlbC5jb25maWcuaW1hZ2Vfc2l6ZSUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy5wYXRjaF9zaXplKSUyMCoqJTIwMiUwQXNlcV9sZW5ndGglMjAlM0QlMjAobnVtX2ZyYW1lcyUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy50dWJlbGV0X3NpemUpJTIwKiUyMG51bV9wYXRjaGVzX3Blcl9mcmFtZSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQoMCUyQyUyMDIlMkMlMjAoMSUyQyUyMHNlcV9sZW5ndGgpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames = <span class="hljs-number">16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = <span class="hljs-built_in">list</span>(np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">256</span>, (num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForPreTraining.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches_per_frame = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>seq_length = (num_frames // model.config.tubelet_size) * num_patches_per_frame
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, (<span class="hljs-number">1</span>, seq_length)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){o=d("p"),o.textContent=T,i=r(),h(m.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),i=l(n),f(m.$$.fragment,n)},m(n,w){a(n,o,w),a(n,i,w),u(m,n,w),b=!0},p:Ee,i(n){b||(g(m.$$.fragment,n),b=!0)},o(n){M(m.$$.fragment,n),b=!1},d(n){n&&(t(o),t(i)),_(m,n)}}}function jt(j){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=d("p"),o.innerHTML=T},l(i){o=c(i,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(i,m){a(i,o,m)},p:Ee,d(i){i&&t(o)}}}function Jt(j){let o,T="Examples:",i,m,b;return m=new _s({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 16 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">16</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
eating spaghetti`,wrap:!1}}),{c(){o=d("p"),o.textContent=T,i=r(),h(m.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),i=l(n),f(m.$$.fragment,n)},m(n,w){a(n,o,w),a(n,i,w),u(m,n,w),b=!0},p:Ee,i(n){b||(g(m.$$.fragment,n),b=!0)},o(n){M(m.$$.fragment,n),b=!1},d(n){n&&(t(o),t(i)),_(m,n)}}}function vt(j){let o,T,i,m,b,n,w,Ye,O,Ss=`The VideoMAE model was proposed in <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE: Masked Autoencoders are Data-Efficient Learners for Self-Supervised Video Pre-Training</a> by Zhan Tong, Yibing Song, Jue Wang, Limin Wang.
VideoMAE extends masked auto encoders (<a href="vit_mae">MAE</a>) to video, claiming state-of-the-art performance on several video classification benchmarks.`,Qe,ee,Xs="The abstract from the paper is the following:",Pe,se,Ys="<em>Pre-training video transformers on extra large-scale datasets is generally required to achieve premier performance on relatively small datasets. In this paper, we show that video masked autoencoders (VideoMAE) are data-efficient learners for self-supervised video pre-training (SSVP). We are inspired by the recent ImageMAE and propose customized video tube masking and reconstruction. These simple designs turn out to be effective for overcoming information leakage caused by the temporal correlation during video reconstruction. We obtain three important findings on SSVP: (1) An extremely high proportion of masking ratio (i.e., 90% to 95%) still yields favorable performance of VideoMAE. The temporally redundant video content enables higher masking ratio than that of images. (2) VideoMAE achieves impressive results on very small datasets (i.e., around 3k-4k videos) without using any extra data. This is partially ascribed to the challenging task of video reconstruction to enforce high-level structure learning. (3) VideoMAE shows that data quality is more important than data quantity for SSVP. Domain shift between pre-training and target datasets are important issues in SSVP. Notably, our VideoMAE with the vanilla ViT backbone can achieve 83.9% on Kinects-400, 75.3% on Something-Something V2, 90.8% on UCF101, and 61.1% on HMDB51 without using any extra data.</em>",He,te,Qs="Tips:",Le,oe,Ps='<li>One can use <a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> to prepare videos for the model. It will resize + normalize all frames of a video for you.</li> <li><a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> includes the decoder on top for self-supervised pre-training.</li>',De,N,Hs,qe,ne,Ls='VideoMAE pre-training. Taken from the <a href="https://arxiv.org/abs/2203.12602">original paper</a>.',Ke,ae,Ds=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/MCG-NJU/VideoMAE" rel="nofollow">here</a>.`,Oe,re,es,le,qs=`A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with VideoMAE. If
you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll
review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.`,ss,ie,Ks="<strong>Video classification</strong>",ts,de,Os=`<li><a href="https://github.com/huggingface/notebooks/blob/main/examples/video_classification.ipynb" rel="nofollow">A notebook</a> that shows how
to fine-tune a VideoMAE model on a custom dataset.</li> <li><a href="../tasks/video_classification">Video classification task guide</a></li> <li><a href="https://huggingface.co/spaces/sayakpaul/video-classification-ucf101-subset" rel="nofollow">A 🤗 Space</a> showing how to perform inference with a video classification model.</li>`,os,ce,ns,v,me,ys,Ze,et=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a>. It is used to instantiate a
VideoMAE model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VideoMAE
<a href="https://huggingface.co/MCG-NJU/videomae-base" rel="nofollow">MCG-NJU/videomae-base</a> architecture.`,bs,Ae,st=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ts,R,as,pe,rs,k,he,ws,S,fe,js,xe,tt="Preprocess an image or a batch of images.",ls,ue,is,E,ge,Js,We,ot="Constructs a VideoMAE image processor.",vs,X,Me,Us,$e,nt="Preprocess an image or batch of images.",ds,_e,cs,Z,ye,Vs,Be,at=`The bare VideoMAE Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Is,V,be,Cs,ke,rt='The <a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> forward method, overrides the <code>__call__</code> special method.',Es,Y,Zs,Q,ms,Te,ps,A,we,As,Ge,lt=`The VideoMAE Model transformer with the decoder on top for self-supervised pre-training.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,xs,I,je,Ws,Fe,it='The <a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',$s,P,Bs,H,hs,Je,fs,x,ve,ks,ze,dt=`VideoMAE Model transformer with a video classification head on top (a linear layer on top of the average pooled hidden
states of all tokens) e.g. for ImageNet.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Gs,C,Ue,Fs,Ne,ct='The <a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',zs,L,Ns,D,us,Xe,gs;return b=new z({props:{title:"VideoMAE",local:"videomae",headingTag:"h1"}}),w=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),re=new z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ce=new z({props:{title:"VideoMAEConfig",local:"transformers.VideoMAEConfig",headingTag:"h2"}}),me=new B({props:{name:"class transformers.VideoMAEConfig",anchor:"transformers.VideoMAEConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"num_frames",val:" = 16"},{name:"tubelet_size",val:" = 2"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"qkv_bias",val:" = True"},{name:"use_mean_pooling",val:" = True"},{name:"decoder_num_attention_heads",val:" = 6"},{name:"decoder_hidden_size",val:" = 384"},{name:"decoder_num_hidden_layers",val:" = 4"},{name:"decoder_intermediate_size",val:" = 1536"},{name:"norm_pix_loss",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.VideoMAEConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.VideoMAEConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.VideoMAEConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.VideoMAEConfig.tubelet_size",description:`<strong>tubelet_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of tubelets.`,name:"tubelet_size"},{anchor:"transformers.VideoMAEConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.VideoMAEConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.VideoMAEConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.VideoMAEConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.VideoMAEConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.VideoMAEConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.VideoMAEConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.VideoMAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VideoMAEConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.VideoMAEConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.VideoMAEConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states instead of using the final hidden state of the [CLS] token.`,name:"use_mean_pooling"},{anchor:"transformers.VideoMAEConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of attention heads for each attention layer in the decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.VideoMAEConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
Dimensionality of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.VideoMAEConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of hidden layers in the decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.VideoMAEConfig.decoder_intermediate_size",description:`<strong>decoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1536) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the decoder.`,name:"decoder_intermediate_size"},{anchor:"transformers.VideoMAEConfig.norm_pix_loss",description:`<strong>norm_pix_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the target patch pixels.`,name:"norm_pix_loss"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/configuration_videomae.py#L28"}}),R=new Ms({props:{anchor:"transformers.VideoMAEConfig.example",$$slots:{default:[_t]},$$scope:{ctx:j}}}),pe=new z({props:{title:"VideoMAEFeatureExtractor",local:"transformers.VideoMAEFeatureExtractor",headingTag:"h2"}}),he=new B({props:{name:"class transformers.VideoMAEFeatureExtractor",anchor:"transformers.VideoMAEFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/feature_extraction_videomae.py#L26"}}),fe=new B({props:{name:"__call__",anchor:"transformers.VideoMAEFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/image_processing_utils.py#L547"}}),ue=new z({props:{title:"VideoMAEImageProcessor",local:"transformers.VideoMAEImageProcessor",headingTag:"h2"}}),ge=new B({props:{name:"class transformers.VideoMAEImageProcessor",anchor:"transformers.VideoMAEImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoMAEImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overriden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VideoMAEImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoMAEImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoMAEImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.VideoMAEImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoMAEImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VideoMAEImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VideoMAEImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoMAEImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/image_processing_videomae.py#L62"}}),Me=new B({props:{name:"preprocess",anchor:"transformers.VideoMAEImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/image_processing_videomae.py#L233"}}),_e=new z({props:{title:"VideoMAEModel",local:"transformers.VideoMAEModel",headingTag:"h2"}}),ye=new B({props:{name:"class transformers.VideoMAEModel",anchor:"transformers.VideoMAEModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/modeling_videomae.py#L525"}}),be=new B({props:{name:"forward",anchor:"transformers.VideoMAEModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.2/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor.__call__">VideoMAEImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VideoMAEModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoMAEModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0). Each video in the
batch must have the same number of masked patches. If <code>None</code>, then all patches are considered. Sequence
length is <code>(num_frames // tubelet_size) * (image_size // patch_size) ** 2</code>.`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/modeling_videomae.py#L552",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new Rs({props:{$$slots:{default:[yt]},$$scope:{ctx:j}}}),Q=new Ms({props:{anchor:"transformers.VideoMAEModel.forward.example",$$slots:{default:[bt]},$$scope:{ctx:j}}}),Te=new z({props:{title:"VideoMAEForPreTraining",local:"transformers.VideoMAEForPreTraining",headingTag:"h2"}}),we=new B({props:{name:"class transformers.VideoMAEForPreTraining",anchor:"transformers.VideoMAEForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/modeling_videomae.py#L752"}}),je=new B({props:{name:"forward",anchor:"transformers.VideoMAEForPreTraining.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"bool_masked_pos",val:": BoolTensor"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEForPreTraining.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.2/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor.__call__">VideoMAEImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VideoMAEForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoMAEForPreTraining.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0). Each video in the
batch must have the same number of masked patches. Sequence length is <code>(num_frames // tubelet_size) * (image_size // patch_size) ** 2</code>.`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/modeling_videomae.py#L770",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.videomae.modeling_videomae.VideoMAEForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Pixel reconstruction loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size ** 2 * num_channels)</code>) — Pixel reconstruction logits.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.videomae.modeling_videomae.VideoMAEForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new Rs({props:{$$slots:{default:[Tt]},$$scope:{ctx:j}}}),H=new Ms({props:{anchor:"transformers.VideoMAEForPreTraining.forward.example",$$slots:{default:[wt]},$$scope:{ctx:j}}}),Je=new z({props:{title:"VideoMAEForVideoClassification",local:"transformers.VideoMAEForVideoClassification",headingTag:"h2"}}),ve=new B({props:{name:"class transformers.VideoMAEForVideoClassification",anchor:"transformers.VideoMAEForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/modeling_videomae.py#L936"}}),Ue=new B({props:{name:"forward",anchor:"transformers.VideoMAEForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.35.2/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor.__call__">VideoMAEImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VideoMAEForVideoClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoMAEForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/videomae/modeling_videomae.py#L950",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new Rs({props:{$$slots:{default:[jt]},$$scope:{ctx:j}}}),D=new Ms({props:{anchor:"transformers.VideoMAEForVideoClassification.forward.example",$$slots:{default:[Jt]},$$scope:{ctx:j}}}),{c(){o=d("meta"),T=r(),i=d("p"),m=r(),h(b.$$.fragment),n=r(),h(w.$$.fragment),Ye=r(),O=d("p"),O.innerHTML=Ss,Qe=r(),ee=d("p"),ee.textContent=Xs,Pe=r(),se=d("p"),se.innerHTML=Ys,He=r(),te=d("p"),te.textContent=Qs,Le=r(),oe=d("ul"),oe.innerHTML=Ps,De=r(),N=d("img"),qe=r(),ne=d("small"),ne.innerHTML=Ls,Ke=r(),ae=d("p"),ae.innerHTML=Ds,Oe=r(),h(re.$$.fragment),es=r(),le=d("p"),le.textContent=qs,ss=r(),ie=d("p"),ie.innerHTML=Ks,ts=r(),de=d("ul"),de.innerHTML=Os,os=r(),h(ce.$$.fragment),ns=r(),v=d("div"),h(me.$$.fragment),ys=r(),Ze=d("p"),Ze.innerHTML=et,bs=r(),Ae=d("p"),Ae.innerHTML=st,Ts=r(),h(R.$$.fragment),as=r(),h(pe.$$.fragment),rs=r(),k=d("div"),h(he.$$.fragment),ws=r(),S=d("div"),h(fe.$$.fragment),js=r(),xe=d("p"),xe.textContent=tt,ls=r(),h(ue.$$.fragment),is=r(),E=d("div"),h(ge.$$.fragment),Js=r(),We=d("p"),We.textContent=ot,vs=r(),X=d("div"),h(Me.$$.fragment),Us=r(),$e=d("p"),$e.textContent=nt,ds=r(),h(_e.$$.fragment),cs=r(),Z=d("div"),h(ye.$$.fragment),Vs=r(),Be=d("p"),Be.innerHTML=at,Is=r(),V=d("div"),h(be.$$.fragment),Cs=r(),ke=d("p"),ke.innerHTML=rt,Es=r(),h(Y.$$.fragment),Zs=r(),h(Q.$$.fragment),ms=r(),h(Te.$$.fragment),ps=r(),A=d("div"),h(we.$$.fragment),As=r(),Ge=d("p"),Ge.innerHTML=lt,xs=r(),I=d("div"),h(je.$$.fragment),Ws=r(),Fe=d("p"),Fe.innerHTML=it,$s=r(),h(P.$$.fragment),Bs=r(),h(H.$$.fragment),hs=r(),h(Je.$$.fragment),fs=r(),x=d("div"),h(ve.$$.fragment),ks=r(),ze=d("p"),ze.innerHTML=dt,Gs=r(),C=d("div"),h(Ue.$$.fragment),Fs=r(),Ne=d("p"),Ne.innerHTML=ct,zs=r(),h(L.$$.fragment),Ns=r(),h(D.$$.fragment),us=r(),Xe=d("p"),this.h()},l(e){const s=gt("svelte-u9bgzb",document.head);o=c(s,"META",{name:!0,content:!0}),s.forEach(t),T=l(e),i=c(e,"P",{}),U(i).forEach(t),m=l(e),f(b.$$.fragment,e),n=l(e),f(w.$$.fragment,e),Ye=l(e),O=c(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-hyjvdr"&&(O.innerHTML=Ss),Qe=l(e),ee=c(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-vfdo9a"&&(ee.textContent=Xs),Pe=l(e),se=c(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-1rhhtl3"&&(se.innerHTML=Ys),He=l(e),te=c(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-axv494"&&(te.textContent=Qs),Le=l(e),oe=c(e,"UL",{"data-svelte-h":!0}),y(oe)!=="svelte-hxe25b"&&(oe.innerHTML=Ps),De=l(e),N=c(e,"IMG",{src:!0,alt:!0,width:!0}),qe=l(e),ne=c(e,"SMALL",{"data-svelte-h":!0}),y(ne)!=="svelte-19gew7l"&&(ne.innerHTML=Ls),Ke=l(e),ae=c(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-xbyn5w"&&(ae.innerHTML=Ds),Oe=l(e),f(re.$$.fragment,e),es=l(e),le=c(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-1k7bn0h"&&(le.textContent=qs),ss=l(e),ie=c(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-yaiu72"&&(ie.innerHTML=Ks),ts=l(e),de=c(e,"UL",{"data-svelte-h":!0}),y(de)!=="svelte-19n7fq5"&&(de.innerHTML=Os),os=l(e),f(ce.$$.fragment,e),ns=l(e),v=c(e,"DIV",{class:!0});var W=U(v);f(me.$$.fragment,W),ys=l(W),Ze=c(W,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-bl1fl4"&&(Ze.innerHTML=et),bs=l(W),Ae=c(W,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-1g275hz"&&(Ae.innerHTML=st),Ts=l(W),f(R.$$.fragment,W),W.forEach(t),as=l(e),f(pe.$$.fragment,e),rs=l(e),k=c(e,"DIV",{class:!0});var Ve=U(k);f(he.$$.fragment,Ve),ws=l(Ve),S=c(Ve,"DIV",{class:!0});var Ie=U(S);f(fe.$$.fragment,Ie),js=l(Ie),xe=c(Ie,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-khengj"&&(xe.textContent=tt),Ie.forEach(t),Ve.forEach(t),ls=l(e),f(ue.$$.fragment,e),is=l(e),E=c(e,"DIV",{class:!0});var G=U(E);f(ge.$$.fragment,G),Js=l(G),We=c(G,"P",{"data-svelte-h":!0}),y(We)!=="svelte-uyvre4"&&(We.textContent=ot),vs=l(G),X=c(G,"DIV",{class:!0});var Ce=U(X);f(Me.$$.fragment,Ce),Us=l(Ce),$e=c(Ce,"P",{"data-svelte-h":!0}),y($e)!=="svelte-1x3yxsa"&&($e.textContent=nt),Ce.forEach(t),G.forEach(t),ds=l(e),f(_e.$$.fragment,e),cs=l(e),Z=c(e,"DIV",{class:!0});var F=U(Z);f(ye.$$.fragment,F),Vs=l(F),Be=c(F,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-1xmhq1d"&&(Be.innerHTML=at),Is=l(F),V=c(F,"DIV",{class:!0});var $=U(V);f(be.$$.fragment,$),Cs=l($),ke=c($,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-blhn6k"&&(ke.innerHTML=rt),Es=l($),f(Y.$$.fragment,$),Zs=l($),f(Q.$$.fragment,$),$.forEach(t),F.forEach(t),ms=l(e),f(Te.$$.fragment,e),ps=l(e),A=c(e,"DIV",{class:!0});var Re=U(A);f(we.$$.fragment,Re),As=l(Re),Ge=c(Re,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-1m9c5iu"&&(Ge.innerHTML=lt),xs=l(Re),I=c(Re,"DIV",{class:!0});var q=U(I);f(je.$$.fragment,q),Ws=l(q),Fe=c(q,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-a0mfm4"&&(Fe.innerHTML=it),$s=l(q),f(P.$$.fragment,q),Bs=l(q),f(H.$$.fragment,q),q.forEach(t),Re.forEach(t),hs=l(e),f(Je.$$.fragment,e),fs=l(e),x=c(e,"DIV",{class:!0});var Se=U(x);f(ve.$$.fragment,Se),ks=l(Se),ze=c(Se,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-9dfld7"&&(ze.innerHTML=dt),Gs=l(Se),C=c(Se,"DIV",{class:!0});var K=U(C);f(Ue.$$.fragment,K),Fs=l(K),Ne=c(K,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-xa3vh8"&&(Ne.innerHTML=ct),zs=l(K),f(L.$$.fragment,K),Ns=l(K),f(D.$$.fragment,K),K.forEach(t),Se.forEach(t),us=l(e),Xe=c(e,"P",{}),U(Xe).forEach(t),this.h()},h(){J(o,"name","hf:doc:metadata"),J(o,"content",Ut),pt(N.src,Hs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/videomae_architecture.jpeg")||J(N,"src",Hs),J(N,"alt","drawing"),J(N,"width","600"),J(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){p(document.head,o),a(e,T,s),a(e,i,s),a(e,m,s),u(b,e,s),a(e,n,s),u(w,e,s),a(e,Ye,s),a(e,O,s),a(e,Qe,s),a(e,ee,s),a(e,Pe,s),a(e,se,s),a(e,He,s),a(e,te,s),a(e,Le,s),a(e,oe,s),a(e,De,s),a(e,N,s),a(e,qe,s),a(e,ne,s),a(e,Ke,s),a(e,ae,s),a(e,Oe,s),u(re,e,s),a(e,es,s),a(e,le,s),a(e,ss,s),a(e,ie,s),a(e,ts,s),a(e,de,s),a(e,os,s),u(ce,e,s),a(e,ns,s),a(e,v,s),u(me,v,null),p(v,ys),p(v,Ze),p(v,bs),p(v,Ae),p(v,Ts),u(R,v,null),a(e,as,s),u(pe,e,s),a(e,rs,s),a(e,k,s),u(he,k,null),p(k,ws),p(k,S),u(fe,S,null),p(S,js),p(S,xe),a(e,ls,s),u(ue,e,s),a(e,is,s),a(e,E,s),u(ge,E,null),p(E,Js),p(E,We),p(E,vs),p(E,X),u(Me,X,null),p(X,Us),p(X,$e),a(e,ds,s),u(_e,e,s),a(e,cs,s),a(e,Z,s),u(ye,Z,null),p(Z,Vs),p(Z,Be),p(Z,Is),p(Z,V),u(be,V,null),p(V,Cs),p(V,ke),p(V,Es),u(Y,V,null),p(V,Zs),u(Q,V,null),a(e,ms,s),u(Te,e,s),a(e,ps,s),a(e,A,s),u(we,A,null),p(A,As),p(A,Ge),p(A,xs),p(A,I),u(je,I,null),p(I,Ws),p(I,Fe),p(I,$s),u(P,I,null),p(I,Bs),u(H,I,null),a(e,hs,s),u(Je,e,s),a(e,fs,s),a(e,x,s),u(ve,x,null),p(x,ks),p(x,ze),p(x,Gs),p(x,C),u(Ue,C,null),p(C,Fs),p(C,Ne),p(C,zs),u(L,C,null),p(C,Ns),u(D,C,null),a(e,us,s),a(e,Xe,s),gs=!0},p(e,[s]){const W={};s&2&&(W.$$scope={dirty:s,ctx:e}),R.$set(W);const Ve={};s&2&&(Ve.$$scope={dirty:s,ctx:e}),Y.$set(Ve);const Ie={};s&2&&(Ie.$$scope={dirty:s,ctx:e}),Q.$set(Ie);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),P.$set(G);const Ce={};s&2&&(Ce.$$scope={dirty:s,ctx:e}),H.$set(Ce);const F={};s&2&&(F.$$scope={dirty:s,ctx:e}),L.$set(F);const $={};s&2&&($.$$scope={dirty:s,ctx:e}),D.$set($)},i(e){gs||(g(b.$$.fragment,e),g(w.$$.fragment,e),g(re.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(R.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(Me.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(Y.$$.fragment,e),g(Q.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(P.$$.fragment,e),g(H.$$.fragment,e),g(Je.$$.fragment,e),g(ve.$$.fragment,e),g(Ue.$$.fragment,e),g(L.$$.fragment,e),g(D.$$.fragment,e),gs=!0)},o(e){M(b.$$.fragment,e),M(w.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(R.$$.fragment,e),M(pe.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(ue.$$.fragment,e),M(ge.$$.fragment,e),M(Me.$$.fragment,e),M(_e.$$.fragment,e),M(ye.$$.fragment,e),M(be.$$.fragment,e),M(Y.$$.fragment,e),M(Q.$$.fragment,e),M(Te.$$.fragment,e),M(we.$$.fragment,e),M(je.$$.fragment,e),M(P.$$.fragment,e),M(H.$$.fragment,e),M(Je.$$.fragment,e),M(ve.$$.fragment,e),M(Ue.$$.fragment,e),M(L.$$.fragment,e),M(D.$$.fragment,e),gs=!1},d(e){e&&(t(T),t(i),t(m),t(n),t(Ye),t(O),t(Qe),t(ee),t(Pe),t(se),t(He),t(te),t(Le),t(oe),t(De),t(N),t(qe),t(ne),t(Ke),t(ae),t(Oe),t(es),t(le),t(ss),t(ie),t(ts),t(de),t(os),t(ns),t(v),t(as),t(rs),t(k),t(ls),t(is),t(E),t(ds),t(cs),t(Z),t(ms),t(ps),t(A),t(hs),t(fs),t(x),t(us),t(Xe)),t(o),_(b,e),_(w,e),_(re,e),_(ce,e),_(me),_(R),_(pe,e),_(he),_(fe),_(ue,e),_(ge),_(Me),_(_e,e),_(ye),_(be),_(Y),_(Q),_(Te,e),_(we),_(je),_(P),_(H),_(Je,e),_(ve),_(Ue),_(L),_(D)}}}const Ut='{"title":"VideoMAE","local":"videomae","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"VideoMAEConfig","local":"transformers.VideoMAEConfig","sections":[],"depth":2},{"title":"VideoMAEFeatureExtractor","local":"transformers.VideoMAEFeatureExtractor","sections":[],"depth":2},{"title":"VideoMAEImageProcessor","local":"transformers.VideoMAEImageProcessor","sections":[],"depth":2},{"title":"VideoMAEModel","local":"transformers.VideoMAEModel","sections":[],"depth":2},{"title":"VideoMAEForPreTraining","local":"transformers.VideoMAEForPreTraining","sections":[],"depth":2},{"title":"VideoMAEForVideoClassification","local":"transformers.VideoMAEForVideoClassification","sections":[],"depth":2}],"depth":1}';function Vt(j){return ht(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Mt}),[]}class $t extends ft{constructor(o){super(),ut(this,o,Vt,vt,mt,{})}}export{$t as component};
