import{s as Lt,o as Qt,n as Xt}from"../chunks/scheduler.9bc65507.js";import{S as It,i as Nt,g as o,s,r as p,A as Pt,h as r,f as a,c as n,j as Ht,u as d,x as c,k as he,y as zt,a as l,v as m,d as f,t as u,w as b}from"../chunks/index.707bf1b6.js";import{H as _,g as Yt}from"../chunks/Heading.9a412c8a.js";import{T as Et}from"../chunks/Tip.c2ecdbf4.js";import{C as h}from"../chunks/CodeBlock.54a9f38d.js";import{D as At}from"../chunks/DocNotebookDropdown.3e6b3817.js";function qt(ce){let i,y="You can load a PEFT adapter with either an <code>AutoModelFor</code> class or the base model class like <code>OPTForCausalLM</code> or <code>LlamaForCausalLM</code>.";return{c(){i=o("p"),i.innerHTML=y},l(M){i=r(M,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1cdoj9o"&&(i.innerHTML=y)},m(M,w){l(M,i,w)},p:Xt,d(M){M&&a(i)}}}function St(ce){let i,y='If you aren’t familiar with fine-tuning a model with <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the <a href="training">Fine-tune a pretrained model</a> tutorial.';return{c(){i=o("p"),i.innerHTML=y},l(M){i=r(M,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1eyafky"&&(i.innerHTML=y)},m(M,w){l(M,i,w)},p:Xt,d(M){M&&a(i)}}}function Kt(ce){let i,y,M,w,k,ye,Z,we,v,ut='<a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter-Efficient Fine Tuning (PEFT)</a> methods freeze the pretrained model parameters during fine-tuning and add a small number of trainable parameters (the adapters) on top of it. The adapters are trained to learn task-specific information. This approach has been shown to be very memory-efficient with lower compute usage while producing results comparable to a fully fine-tuned model.',Te,U,bt="Adapters trained with PEFT are also usually an order of magnitude smaller than the full model, making it convenient to share, store, and load them.",$e,T,ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">The adapter weights for a OPTForCausalLM model stored on the Hub are only ~6MB compared to the full size of the model weights, which can be ~700MB.</figcaption>',ge,F,Mt='If you’re interested in learning more about the 🤗 PEFT library, check out the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',Je,W,Ce,j,ht="Get started by installing 🤗 PEFT:",_e,B,ke,R,yt="If you want to try out the brand new features, you might be interested in installing the library from source:",Ze,V,ve,x,Ue,G,wt="🤗 Transformers natively supports some PEFT methods, meaning you can load adapter weights stored locally or on the Hub and easily run or train them with a few lines of code. The following methods are supported:",Fe,H,Tt='<li><a href="https://huggingface.co/docs/peft/conceptual_guides/lora" rel="nofollow">Low Rank Adapters</a></li> <li><a href="https://huggingface.co/docs/peft/conceptual_guides/ia3" rel="nofollow">IA3</a></li> <li><a href="https://arxiv.org/abs/2303.10512" rel="nofollow">AdaLoRA</a></li>',We,E,$t='If you want to use other PEFT methods, such as prompt learning or prompt tuning, or about the 🤗 PEFT library in general, please refer to the <a href="https://huggingface.co/docs/peft/index" rel="nofollow">documentation</a>.',je,X,Be,L,gt="To load and use a PEFT adapter model from 🤗 Transformers, make sure the Hub repository or local directory contains an <code>adapter_config.json</code> file and the adapter weights, as shown in the example image above. Then you can load the PEFT adapter model using the <code>AutoModelFor</code> class. For example, to load a PEFT adapter model for causal language modeling:",Re,Q,Jt='<li>specify the PEFT model id</li> <li>pass it to the <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoModelForCausalLM">AutoModelForCausalLM</a> class</li>',Ve,I,xe,$,Ge,N,Ct="You can also load a PEFT adapter by calling the <code>load_adapter</code> method:",He,P,Ee,z,Xe,Y,_t='The <code>bitsandbytes</code> integration supports 8bit and 4bit precision data types, which are useful for loading large models because it saves memory (see the <code>bitsandbytes</code> integration <a href="./quantization#bitsandbytes-integration">guide</a> to learn more). Add the <code>load_in_8bit</code> or <code>load_in_4bit</code> parameters to <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and set <code>device_map=&quot;auto&quot;</code> to effectively distribute the model to your hardware:',Le,A,Qe,q,Ie,S,kt="You can use <code>~peft.PeftModel.add_adapter</code> to add a new adapter to a model with an existing adapter as long as the new adapter is the same type as the current one. For example, if you have an existing LoRA adapter attached to a model:",Ne,K,Pe,D,Zt="To add a new adapter:",ze,O,Ye,ee,vt="Now you can use <code>~peft.PeftModel.set_adapter</code> to set which adapter to use:",Ae,te,qe,ae,Se,le,Ut="Once you’ve added an adapter to a model, you can enable or disable the adapter module. To enable the adapter module:",Ke,se,De,ne,Ft="To disable the adapter module:",Oe,oe,et,re,tt,ie,Wt='PEFT adapters are supported by the <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> class so that you can train an adapter for your specific use case. It only requires adding a few more lines of code. For example, to train a LoRA adapter:',at,g,lt,pe,jt="<li>Define your adapter configuration with the task type and hyperparameters (see <code>~peft.LoraConfig</code> for more details about what the hyperparameters do).</li>",st,de,nt,J,Bt="<li>Add adapter to the model.</li>",ot,me,rt,C,Rt='<li>Now you can pass the model to <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer">Trainer</a>!</li>',it,fe,pt,ue,Vt="To save your trained adapter and load it back:",dt,be,mt,Me,ft;return k=new _({props:{title:"Load adapters with 🤗 PEFT",local:"load-adapters-with--peft",headingTag:"h1"}}),Z=new At({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/peft.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/peft.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/peft.ipynb"}]}}),W=new _({props:{title:"Setup",local:"setup",headingTag:"h2"}}),B=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),V=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGcGVmdC5naXQ=",highlighted:"pip install git+https://github.com/huggingface/peft.git",wrap:!1}}),x=new _({props:{title:"Supported PEFT models",local:"supported-peft-models",headingTag:"h2"}}),X=new _({props:{title:"Load a PEFT adapter",local:"load-a-peft-adapter",headingTag:"h2"}}),I=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id)`,wrap:!1}}),$=new Et({props:{$$slots:{default:[qt]},$$scope:{ctx:ce}}}),P=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbC5sb2FkX2FkYXB0ZXIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>

model = AutoModelForCausalLM.from_pretrained(model_id)
model.load_adapter(peft_model_id)`,wrap:!1}}),z=new _({props:{title:"Load in 8bit or 4bit",local:"load-in-8bit-or-4bit",headingTag:"h2"}}),A=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjAlMjJ5YmVsa2FkYSUyRm9wdC0zNTBtLWxvcmElMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChwZWZ0X21vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

peft_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
model = AutoModelForCausalLM.from_pretrained(peft_model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),q=new _({props:{title:"Add a new adapter",local:"add-a-new-adapter",headingTag:"h2"}}),K=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9sb3JhX3dlaWdodHMlM0RGYWxzZSUwQSklMEElMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZyUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)

lora_config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>],
    init_lora_weights=<span class="hljs-literal">False</span>
)

model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),O=new h({props:{code:"JTIzJTIwYXR0YWNoJTIwbmV3JTIwYWRhcHRlciUyMHdpdGglMjBzYW1lJTIwY29uZmlnJTBBbW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWclMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyXzIlMjIp",highlighted:`<span class="hljs-comment"># attach new adapter with same config</span>
model.add_adapter(lora_config, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)`,wrap:!1}}),te=new h({props:{code:"JTIzJTIwdXNlJTIwYWRhcHRlcl8xJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1c2UlMjBhZGFwdGVyXzIlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJhZGFwdGVyXzIlMjIpJTBBb3V0cHV0X2VuYWJsZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dF9lbmFibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-comment"># use adapter_1</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># use adapter_2</span>
model.set_adapter(<span class="hljs-string">&quot;adapter_2&quot;</span>)
output_enabled = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_enabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ae=new _({props:{title:"Enable and disable adapters",local:"enable-and-disable-adapters",headingTag:"h2"}}),se=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBYWRhcHRlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRleHQlMjAlM0QlMjAlMjJIZWxsbyUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFBlZnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKGFkYXB0ZXJfbW9kZWxfaWQpJTBBJTBBJTIzJTIwdG8lMjBpbml0aWF0ZSUyMHdpdGglMjByYW5kb20lMjB3ZWlnaHRzJTBBcGVmdF9jb25maWcuaW5pdF9sb3JhX3dlaWdodHMlMjAlM0QlMjBGYWxzZSUwQSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKSUwQW1vZGVsLmVuYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, OPTForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

model_id = <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
adapter_model_id = <span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
text = <span class="hljs-string">&quot;Hello&quot;</span>
inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(model_id)
peft_config = PeftConfig.from_pretrained(adapter_model_id)

<span class="hljs-comment"># to initiate with random weights</span>
peft_config.init_lora_weights = <span class="hljs-literal">False</span>

model.add_adapter(peft_config)
model.enable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),oe=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`model.disable_adapters()
output = model.generate(**inputs)`,wrap:!1}}),re=new _({props:{title:"Train a PEFT adapter",local:"train-a-peft-adapter",headingTag:"h2"}}),g=new Et({props:{$$slots:{default:[St]},$$scope:{ctx:ce}}}),de=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),me=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIocGVmdF9jb25maWcp",highlighted:"model.add_adapter(peft_config)",wrap:!1}}),fe=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(model=model, ...)
trainer.train()`,wrap:!1}}),be=new h({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`model.save_pretrained(save_dir)
model = AutoModelForCausalLM.from_pretrained(save_dir)`,wrap:!1}}),{c(){i=o("meta"),y=s(),M=o("p"),w=s(),p(k.$$.fragment),ye=s(),p(Z.$$.fragment),we=s(),v=o("p"),v.innerHTML=ut,Te=s(),U=o("p"),U.textContent=bt,$e=s(),T=o("div"),T.innerHTML=ct,ge=s(),F=o("p"),F.innerHTML=Mt,Je=s(),p(W.$$.fragment),Ce=s(),j=o("p"),j.textContent=ht,_e=s(),p(B.$$.fragment),ke=s(),R=o("p"),R.textContent=yt,Ze=s(),p(V.$$.fragment),ve=s(),p(x.$$.fragment),Ue=s(),G=o("p"),G.textContent=wt,Fe=s(),H=o("ul"),H.innerHTML=Tt,We=s(),E=o("p"),E.innerHTML=$t,je=s(),p(X.$$.fragment),Be=s(),L=o("p"),L.innerHTML=gt,Re=s(),Q=o("ol"),Q.innerHTML=Jt,Ve=s(),p(I.$$.fragment),xe=s(),p($.$$.fragment),Ge=s(),N=o("p"),N.innerHTML=Ct,He=s(),p(P.$$.fragment),Ee=s(),p(z.$$.fragment),Xe=s(),Y=o("p"),Y.innerHTML=_t,Le=s(),p(A.$$.fragment),Qe=s(),p(q.$$.fragment),Ie=s(),S=o("p"),S.innerHTML=kt,Ne=s(),p(K.$$.fragment),Pe=s(),D=o("p"),D.textContent=Zt,ze=s(),p(O.$$.fragment),Ye=s(),ee=o("p"),ee.innerHTML=vt,Ae=s(),p(te.$$.fragment),qe=s(),p(ae.$$.fragment),Se=s(),le=o("p"),le.textContent=Ut,Ke=s(),p(se.$$.fragment),De=s(),ne=o("p"),ne.textContent=Ft,Oe=s(),p(oe.$$.fragment),et=s(),p(re.$$.fragment),tt=s(),ie=o("p"),ie.innerHTML=Wt,at=s(),p(g.$$.fragment),lt=s(),pe=o("ol"),pe.innerHTML=jt,st=s(),p(de.$$.fragment),nt=s(),J=o("ol"),J.innerHTML=Bt,ot=s(),p(me.$$.fragment),rt=s(),C=o("ol"),C.innerHTML=Rt,it=s(),p(fe.$$.fragment),pt=s(),ue=o("p"),ue.textContent=Vt,dt=s(),p(be.$$.fragment),mt=s(),Me=o("p"),this.h()},l(e){const t=Pt("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(a),y=n(e),M=r(e,"P",{}),Ht(M).forEach(a),w=n(e),d(k.$$.fragment,e),ye=n(e),d(Z.$$.fragment,e),we=n(e),v=r(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-378l9l"&&(v.innerHTML=ut),Te=n(e),U=r(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-nc5pgb"&&(U.textContent=bt),$e=n(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-1gn6iv2"&&(T.innerHTML=ct),ge=n(e),F=r(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1ldq9i6"&&(F.innerHTML=Mt),Je=n(e),d(W.$$.fragment,e),Ce=n(e),j=r(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1rn19ih"&&(j.textContent=ht),_e=n(e),d(B.$$.fragment,e),ke=n(e),R=r(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-cgwmeo"&&(R.textContent=yt),Ze=n(e),d(V.$$.fragment,e),ve=n(e),d(x.$$.fragment,e),Ue=n(e),G=r(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-5xdqaf"&&(G.textContent=wt),Fe=n(e),H=r(e,"UL",{"data-svelte-h":!0}),c(H)!=="svelte-1ulyaf4"&&(H.innerHTML=Tt),We=n(e),E=r(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-8y8234"&&(E.innerHTML=$t),je=n(e),d(X.$$.fragment,e),Be=n(e),L=r(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-c3wuk0"&&(L.innerHTML=gt),Re=n(e),Q=r(e,"OL",{"data-svelte-h":!0}),c(Q)!=="svelte-oq8quw"&&(Q.innerHTML=Jt),Ve=n(e),d(I.$$.fragment,e),xe=n(e),d($.$$.fragment,e),Ge=n(e),N=r(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1l4y13r"&&(N.innerHTML=Ct),He=n(e),d(P.$$.fragment,e),Ee=n(e),d(z.$$.fragment,e),Xe=n(e),Y=r(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-v8xov2"&&(Y.innerHTML=_t),Le=n(e),d(A.$$.fragment,e),Qe=n(e),d(q.$$.fragment,e),Ie=n(e),S=r(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1xpot6r"&&(S.innerHTML=kt),Ne=n(e),d(K.$$.fragment,e),Pe=n(e),D=r(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1t2m746"&&(D.textContent=Zt),ze=n(e),d(O.$$.fragment,e),Ye=n(e),ee=r(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-adr915"&&(ee.innerHTML=vt),Ae=n(e),d(te.$$.fragment,e),qe=n(e),d(ae.$$.fragment,e),Se=n(e),le=r(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-gwuro2"&&(le.textContent=Ut),Ke=n(e),d(se.$$.fragment,e),De=n(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-tzq689"&&(ne.textContent=Ft),Oe=n(e),d(oe.$$.fragment,e),et=n(e),d(re.$$.fragment,e),tt=n(e),ie=r(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-57nql6"&&(ie.innerHTML=Wt),at=n(e),d(g.$$.fragment,e),lt=n(e),pe=r(e,"OL",{"data-svelte-h":!0}),c(pe)!=="svelte-28sdvg"&&(pe.innerHTML=jt),st=n(e),d(de.$$.fragment,e),nt=n(e),J=r(e,"OL",{start:!0,"data-svelte-h":!0}),c(J)!=="svelte-1qk52ef"&&(J.innerHTML=Bt),ot=n(e),d(me.$$.fragment,e),rt=n(e),C=r(e,"OL",{start:!0,"data-svelte-h":!0}),c(C)!=="svelte-jgiep6"&&(C.innerHTML=Rt),it=n(e),d(fe.$$.fragment,e),pt=n(e),ue=r(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1nalv2a"&&(ue.textContent=Vt),dt=n(e),d(be.$$.fragment,e),mt=n(e),Me=r(e,"P",{}),Ht(Me).forEach(a),this.h()},h(){he(i,"name","hf:doc:metadata"),he(i,"content",Dt),he(T,"class","flex flex-col justify-center"),he(J,"start","2"),he(C,"start","3")},m(e,t){zt(document.head,i),l(e,y,t),l(e,M,t),l(e,w,t),m(k,e,t),l(e,ye,t),m(Z,e,t),l(e,we,t),l(e,v,t),l(e,Te,t),l(e,U,t),l(e,$e,t),l(e,T,t),l(e,ge,t),l(e,F,t),l(e,Je,t),m(W,e,t),l(e,Ce,t),l(e,j,t),l(e,_e,t),m(B,e,t),l(e,ke,t),l(e,R,t),l(e,Ze,t),m(V,e,t),l(e,ve,t),m(x,e,t),l(e,Ue,t),l(e,G,t),l(e,Fe,t),l(e,H,t),l(e,We,t),l(e,E,t),l(e,je,t),m(X,e,t),l(e,Be,t),l(e,L,t),l(e,Re,t),l(e,Q,t),l(e,Ve,t),m(I,e,t),l(e,xe,t),m($,e,t),l(e,Ge,t),l(e,N,t),l(e,He,t),m(P,e,t),l(e,Ee,t),m(z,e,t),l(e,Xe,t),l(e,Y,t),l(e,Le,t),m(A,e,t),l(e,Qe,t),m(q,e,t),l(e,Ie,t),l(e,S,t),l(e,Ne,t),m(K,e,t),l(e,Pe,t),l(e,D,t),l(e,ze,t),m(O,e,t),l(e,Ye,t),l(e,ee,t),l(e,Ae,t),m(te,e,t),l(e,qe,t),m(ae,e,t),l(e,Se,t),l(e,le,t),l(e,Ke,t),m(se,e,t),l(e,De,t),l(e,ne,t),l(e,Oe,t),m(oe,e,t),l(e,et,t),m(re,e,t),l(e,tt,t),l(e,ie,t),l(e,at,t),m(g,e,t),l(e,lt,t),l(e,pe,t),l(e,st,t),m(de,e,t),l(e,nt,t),l(e,J,t),l(e,ot,t),m(me,e,t),l(e,rt,t),l(e,C,t),l(e,it,t),m(fe,e,t),l(e,pt,t),l(e,ue,t),l(e,dt,t),m(be,e,t),l(e,mt,t),l(e,Me,t),ft=!0},p(e,[t]){const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),$.$set(xt);const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),g.$set(Gt)},i(e){ft||(f(k.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(X.$$.fragment,e),f(I.$$.fragment,e),f($.$$.fragment,e),f(P.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(g.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(be.$$.fragment,e),ft=!0)},o(e){u(k.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(X.$$.fragment,e),u(I.$$.fragment,e),u($.$$.fragment,e),u(P.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(g.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),ft=!1},d(e){e&&(a(y),a(M),a(w),a(ye),a(we),a(v),a(Te),a(U),a($e),a(T),a(ge),a(F),a(Je),a(Ce),a(j),a(_e),a(ke),a(R),a(Ze),a(ve),a(Ue),a(G),a(Fe),a(H),a(We),a(E),a(je),a(Be),a(L),a(Re),a(Q),a(Ve),a(xe),a(Ge),a(N),a(He),a(Ee),a(Xe),a(Y),a(Le),a(Qe),a(Ie),a(S),a(Ne),a(Pe),a(D),a(ze),a(Ye),a(ee),a(Ae),a(qe),a(Se),a(le),a(Ke),a(De),a(ne),a(Oe),a(et),a(tt),a(ie),a(at),a(lt),a(pe),a(st),a(nt),a(J),a(ot),a(rt),a(C),a(it),a(pt),a(ue),a(dt),a(mt),a(Me)),a(i),b(k,e),b(Z,e),b(W,e),b(B,e),b(V,e),b(x,e),b(X,e),b(I,e),b($,e),b(P,e),b(z,e),b(A,e),b(q,e),b(K,e),b(O,e),b(te,e),b(ae,e),b(se,e),b(oe,e),b(re,e),b(g,e),b(de,e),b(me,e),b(fe,e),b(be,e)}}}const Dt='{"title":"Load adapters with 🤗 PEFT","local":"load-adapters-with--peft","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Supported PEFT models","local":"supported-peft-models","sections":[],"depth":2},{"title":"Load a PEFT adapter","local":"load-a-peft-adapter","sections":[],"depth":2},{"title":"Load in 8bit or 4bit","local":"load-in-8bit-or-4bit","sections":[],"depth":2},{"title":"Add a new adapter","local":"add-a-new-adapter","sections":[],"depth":2},{"title":"Enable and disable adapters","local":"enable-and-disable-adapters","sections":[],"depth":2},{"title":"Train a PEFT adapter","local":"train-a-peft-adapter","sections":[],"depth":2}],"depth":1}';function Ot(ce){return Qt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Yt}),[]}class oa extends It{constructor(i){super(),Nt(this,i,Ot,Kt,Lt,{})}}export{oa as component};
