import{s as Cn,n as wn,o as In}from"../chunks/scheduler.9bc65507.js";import{S as jn,i as kn,g as l,s as a,r as g,A as Rn,h as d,f as n,c as r,j as $n,u as o,x as c,k as Le,y as Jn,a as i,v as s,d as m,t as h,w as f}from"../chunks/index.707bf1b6.js";import{H as p,g as En}from"../chunks/Heading.9a412c8a.js";import{C as ze}from"../chunks/CodeBlock.54a9f38d.js";function _n(De){let b,jt,wt,kt,u,Rt,y,Ne='This guide aims to provide a benchmark on the inference speed-ups introduced with <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile()</code></a> for <a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers&amp;sort=trending" rel="nofollow">computer vision models in 🤗 Transformers</a>.',Jt,v,Et,$,He="Depending on the model and the GPU, <code>torch.compile()</code> yields up to 30% speed-up during inference. To use <code>torch.compile()</code>, simply install any version of <code>torch</code> above 2.0.",_t,C,We=`Compiling a model takes time, so it’s useful if you are compiling the model only once instead of every time you infer.
To compile any computer vision model of your choice, call <code>torch.compile()</code> on the model as shown below:`,Bt,w,Ut,I,Oe='<code>compile()</code> comes with multiple modes for compiling, which essentially differ in compilation time and inference overhead. <code>max-autotune</code> takes longer than <code>reduce-overhead</code> but results in faster inference. Default mode is fastest for compilation but is not as efficient compared to <code>reduce-overhead</code> for inference time. In this guide, we used the default mode. You can learn more about it <a href="https://pytorch.org/get-started/pytorch-2.0/#user-experience" rel="nofollow">here</a>.',Zt,j,xe="We benchmarked <code>torch.compile</code> with different computer vision models, tasks, types of hardware, and batch sizes on <code>torch</code> version 2.0.1.",St,k,Lt,R,Ve="Below you can find the benchmarking code for each task. We warm up the GPU before inference and take the mean time of 300 inferences, using the same image each time.",zt,J,Dt,E,Nt,_,Ht,B,Wt,U,Ot,Z,xt,S,Xe="Below you can find the list of the models we benchmarked.",Vt,L,Ge="<strong>Image Classification</strong>",Xt,z,Ae='<li><a href="https://huggingface.co/google/vit-base-patch16-224" rel="nofollow">google/vit-base-patch16-224</a></li> <li><a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k-ft22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k-ft22k</a></li> <li><a href="https://huggingface.co/facebook/convnext-large-224" rel="nofollow">facebook/convnext-large-224</a></li> <li><a href="https://huggingface.co/" rel="nofollow">microsoft/resnet-50</a></li>',Gt,D,Fe="<strong>Image Segmentation</strong>",At,N,Ye='<li><a href="https://huggingface.co/nvidia/segformer-b0-finetuned-ade-512-512" rel="nofollow">nvidia/segformer-b0-finetuned-ade-512-512</a></li> <li><a href="https://huggingface.co/facebook/mask2former-swin-tiny-coco-panoptic" rel="nofollow">facebook/mask2former-swin-tiny-coco-panoptic</a></li> <li><a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a></li> <li><a href="https://huggingface.co/google/deeplabv3_mobilenet_v2_1.0_513" rel="nofollow">google/deeplabv3_mobilenet_v2_1.0_513</a></li>',Ft,H,qe="<strong>Object Detection</strong>",Yt,W,Pe='<li><a href="https://huggingface.co/google/owlvit-base-patch32" rel="nofollow">google/owlvit-base-patch32</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-101" rel="nofollow">facebook/detr-resnet-101</a></li> <li><a href="https://huggingface.co/microsoft/conditional-detr-resnet-50" rel="nofollow">microsoft/conditional-detr-resnet-50</a></li>',qt,O,Qe="Below you can find visualization of inference durations with and without <code>torch.compile()</code> and percentage improvements for each model in different hardware and batch sizes.",Pt,T,Ke='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/a100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/t4_batch_comp.png"/></div>',Qt,M,tn='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_duration.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_percentage.png"/></div>',Kt,x,en='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_1_duration.png" alt="Duration Comparison on V100 with Batch Size of 1"/>',te,V,nn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/T4_4_percentage.png" alt="Percentage Improvement on T4 with Batch Size of 4"/>',ee,X,an="Below you can find inference durations in milliseconds for each model with and without <code>compile()</code>. Note that OwlViT results in OOM in larger batch sizes.",ne,G,ie,A,rn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">9.325</td> <td align="center">7.584</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">11.759</td> <td align="center">10.500</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">24.978</td> <td align="center">18.420</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.282</td> <td align="center">8.448</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">34.619</td> <td align="center">19.040</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">10.410</td> <td align="center">10.208</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.531</td> <td align="center">4.124</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">60.188</td> <td align="center">49.117</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">75.764</td> <td align="center">59.487</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">8.583</td> <td align="center">3.974</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">36.276</td> <td align="center">18.197</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">31.219</td> <td align="center">17.993</td></tr></tbody>',ae,F,re,Y,ln='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">14.832</td> <td align="center">14.499</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">18.838</td> <td align="center">16.476</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">13.205</td> <td align="center">13.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">48.657</td> <td align="center">32.418</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">22.940</td> <td align="center">21.631</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.657</td> <td align="center">4.268</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">74.277</td> <td align="center">61.781</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">180.700</td> <td align="center">159.116</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">14.174</td> <td align="center">8.515</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">68.101</td> <td align="center">44.998</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">56.470</td> <td align="center">35.552</td></tr></tbody>',le,q,de,P,dn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">40.944</td> <td align="center">40.010</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">37.005</td> <td align="center">31.144</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">41.854</td> <td align="center">41.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">164.382</td> <td align="center">161.902</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">82.258</td> <td align="center">75.561</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">7.018</td> <td align="center">5.024</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">178.945</td> <td align="center">154.814</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">638.570</td> <td align="center">579.826</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">51.693</td> <td align="center">30.310</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">232.887</td> <td align="center">155.021</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">180.491</td> <td align="center">124.032</td></tr></tbody>',ce,Q,ge,K,cn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">10.495</td> <td align="center">6.00</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">13.321</td> <td align="center">5.862</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">25.769</td> <td align="center">22.395</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.347</td> <td align="center">7.234</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">33.951</td> <td align="center">19.388</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">11.623</td> <td align="center">10.412</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.484</td> <td align="center">3.820</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">64.640</td> <td align="center">49.873</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">95.532</td> <td align="center">72.207</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">9.217</td> <td align="center">4.753</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">52.818</td> <td align="center">28.367</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">39.512</td> <td align="center">20.816</td></tr></tbody>',oe,tt,se,et,gn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">15.181</td> <td align="center">14.501</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.787</td> <td align="center">16.188</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">15.171</td> <td align="center">14.753</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">88.529</td> <td align="center">64.195</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">29.574</td> <td align="center">27.085</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.109</td> <td align="center">4.731</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">90.402</td> <td align="center">76.926</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">234.261</td> <td align="center">205.456</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">24.623</td> <td align="center">14.816</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">134.672</td> <td align="center">101.304</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">97.464</td> <td align="center">69.739</td></tr></tbody>',me,nt,he,it,on='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">52.209</td> <td align="center">51.633</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">61.013</td> <td align="center">55.499</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">53.938</td> <td align="center">53.581</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">109.682</td> <td align="center">100.771</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">14.857</td> <td align="center">12.089</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">249.605</td> <td align="center">222.801</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">831.142</td> <td align="center">743.645</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">93.129</td> <td align="center">55.365</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">482.425</td> <td align="center">361.843</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">344.661</td> <td align="center">255.298</td></tr></tbody>',fe,at,pe,rt,sn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">16.520</td> <td align="center">15.786</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.116</td> <td align="center">14.205</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">53.634</td> <td align="center">51.105</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16.464</td> <td align="center">15.710</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">73.100</td> <td align="center">53.99</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">32.932</td> <td align="center">30.845</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.031</td> <td align="center">4.321</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">79.192</td> <td align="center">66.815</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">200.026</td> <td align="center">188.268</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">18.908</td> <td align="center">11.997</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">106.622</td> <td align="center">82.566</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">77.594</td> <td align="center">56.984</td></tr></tbody>',be,lt,Te,dt,mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">43.653</td> <td align="center">43.626</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">45.327</td> <td align="center">42.445</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">52.007</td> <td align="center">51.354</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">277.850</td> <td align="center">268.003</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">119.259</td> <td align="center">105.580</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">13.039</td> <td align="center">11.388</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">201.540</td> <td align="center">184.670</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">764.052</td> <td align="center">711.280</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">74.289</td> <td align="center">48.677</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">421.859</td> <td align="center">357.614</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">289.002</td> <td align="center">226.945</td></tr></tbody>',Me,ct,ue,gt,hn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">163.914</td> <td align="center">160.907</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">192.412</td> <td align="center">163.620</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">188.978</td> <td align="center">187.976</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">422.886</td> <td align="center">388.078</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">44.114</td> <td align="center">37.604</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">756.337</td> <td align="center">695.291</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">2842.940</td> <td align="center">2656.88</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">299.003</td> <td align="center">201.942</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">1619.505</td> <td align="center">1262.758</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">1137.513</td> <td align="center">897.390</td></tr></tbody>',ye,ot,ve,st,fn='We also benchmarked on PyTorch nightly (2.1.0dev, find the wheel <a href="https://download.pytorch.org/whl/nightly/cu118" rel="nofollow">here</a>) and observed improvement in latency both for uncompiled and compiled models.',$e,mt,Ce,ht,pn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - no compile</strong></th> <th align="center"><strong>torch 2.0 -<br/> compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">12.462</td> <td align="center">6.954</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">14.109</td> <td align="center">12.851</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">30.484</td> <td align="center">15.221</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">46.816</td> <td align="center">30.942</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">163.749</td> <td align="center">163.706</td></tr></tbody>',we,ft,Ie,pt,bn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">14.408</td> <td align="center">14.052</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">47.381</td> <td align="center">46.604</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">68.382</td> <td align="center">53.481</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">269.615</td> <td align="center">204.785</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',je,bt,Tn="### V100",ke,Tt,Mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">13.477</td> <td align="center">7.926</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">15.103</td> <td align="center">14.378</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">52.517</td> <td align="center">51.691</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">28.706</td> <td align="center">19.077</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">88.402</td> <td align="center">62.949</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',Re,Mt,Je,ut,un="We benchmarked <code>reduce-overhead</code> compilation mode for A100 and T4 in Nightly.",Ee,yt,_e,vt,yn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">11.758</td> <td align="center">7.335</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">23.171</td> <td align="center">21.490</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">7.435</td> <td align="center">3.801</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">7.261</td> <td align="center">2.187</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">32.823</td> <td align="center">11.627</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">50.622</td> <td align="center">33.831</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">9.869</td> <td align="center">4.244</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">14.385</td> <td align="center">7.946</td></tr></tbody>',Be,$t,Ue,Ct,vn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">32.137</td> <td align="center">31.84</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">120.944</td> <td align="center">110.209</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">9.761</td> <td align="center">7.698</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">15.215</td> <td align="center">13.871</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">72.150</td> <td align="center">57.660</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">301.494</td> <td align="center">247.543</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">22.266</td> <td align="center">19.339</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">78.311</td> <td align="center">50.983</td></tr></tbody>',Ze,It,Se;return u=new p({props:{title:"Optimize inference using torch.compile()",local:"optimize-inference-using-torchcompile",headingTag:"h1"}}),v=new p({props:{title:"Benefits of torch.compile",local:"benefits-of-torchcompile",headingTag:"h2"}}),w=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKE1PREVMX0lEKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCk=",highlighted:`from transformers import AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(MODEL_ID).to(&quot;cuda&quot;)
<span class="hljs-addition">+ model = torch.compile(model)</span>`,wrap:!1}}),k=new p({props:{title:"Benchmarking code",local:"benchmarking-code",headingTag:"h2"}}),J=new p({props:{title:"Image Classification with ViT",local:"image-classification-with-vit",headingTag:"h3"}}),E=new ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEElMEFwcm9jZXNzZWRfaW5wdXQlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbCgqKnByb2Nlc3NlZF9pbnB1dCklMEE=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

processed_input = processor(image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**processed_input)
`,wrap:!1}}),_=new p({props:{title:"Object Detection with DETR",local:"object-detection-with-detr",headingTag:"h4"}}),B=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMikudG8oJTIyY3VkYSUyMiklMEFtb2RlbCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUobW9kZWwpJTBBJTBBdGV4dHMlMjAlM0QlMjAlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

texts = [<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**inputs)`,wrap:!1}}),U=new p({props:{title:"Image Segmentation with Segformer",local:"image-segmentation-with-segformer",headingTag:"h4"}}),Z=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlZ2Zvcm1lckltYWdlUHJvY2Vzc29yJTJDJTIwU2VnZm9ybWVyRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTZWdmb3JtZXJJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybnZpZGlhJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyMFNlZ2Zvcm1lckZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJudmlkaWElMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEFzZWdfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwXyUyMCUzRCUyMG1vZGVsKCoqc2VnX2lucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SegformerImageProcessor, SegformerForSemanticSegmentation

processor = SegformerImageProcessor.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>)
model = SegformerForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)
seg_inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**seg_inputs)`,wrap:!1}}),G=new p({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),F=new p({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),q=new p({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),Q=new p({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),tt=new p({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),nt=new p({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),at=new p({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),lt=new p({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),ct=new p({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),ot=new p({props:{title:"PyTorch Nightly",local:"pytorch-nightly",headingTag:"h2"}}),mt=new p({props:{title:"A100",local:"a100",headingTag:"h3"}}),ft=new p({props:{title:"T4",local:"t4",headingTag:"h3"}}),Mt=new p({props:{title:"Reduce Overhead",local:"reduce-overhead",headingTag:"h2"}}),yt=new p({props:{title:"A100",local:"a100",headingTag:"h3"}}),$t=new p({props:{title:"T4",local:"t4",headingTag:"h3"}}),{c(){b=l("meta"),jt=a(),wt=l("p"),kt=a(),g(u.$$.fragment),Rt=a(),y=l("p"),y.innerHTML=Ne,Jt=a(),g(v.$$.fragment),Et=a(),$=l("p"),$.innerHTML=He,_t=a(),C=l("p"),C.innerHTML=We,Bt=a(),g(w.$$.fragment),Ut=a(),I=l("p"),I.innerHTML=Oe,Zt=a(),j=l("p"),j.innerHTML=xe,St=a(),g(k.$$.fragment),Lt=a(),R=l("p"),R.textContent=Ve,zt=a(),g(J.$$.fragment),Dt=a(),g(E.$$.fragment),Nt=a(),g(_.$$.fragment),Ht=a(),g(B.$$.fragment),Wt=a(),g(U.$$.fragment),Ot=a(),g(Z.$$.fragment),xt=a(),S=l("p"),S.textContent=Xe,Vt=a(),L=l("p"),L.innerHTML=Ge,Xt=a(),z=l("ul"),z.innerHTML=Ae,Gt=a(),D=l("p"),D.innerHTML=Fe,At=a(),N=l("ul"),N.innerHTML=Ye,Ft=a(),H=l("p"),H.innerHTML=qe,Yt=a(),W=l("ul"),W.innerHTML=Pe,qt=a(),O=l("p"),O.innerHTML=Qe,Pt=a(),T=l("div"),T.innerHTML=Ke,Qt=a(),M=l("div"),M.innerHTML=tn,Kt=a(),x=l("p"),x.innerHTML=en,te=a(),V=l("p"),V.innerHTML=nn,ee=a(),X=l("p"),X.innerHTML=an,ne=a(),g(G.$$.fragment),ie=a(),A=l("table"),A.innerHTML=rn,ae=a(),g(F.$$.fragment),re=a(),Y=l("table"),Y.innerHTML=ln,le=a(),g(q.$$.fragment),de=a(),P=l("table"),P.innerHTML=dn,ce=a(),g(Q.$$.fragment),ge=a(),K=l("table"),K.innerHTML=cn,oe=a(),g(tt.$$.fragment),se=a(),et=l("table"),et.innerHTML=gn,me=a(),g(nt.$$.fragment),he=a(),it=l("table"),it.innerHTML=on,fe=a(),g(at.$$.fragment),pe=a(),rt=l("table"),rt.innerHTML=sn,be=a(),g(lt.$$.fragment),Te=a(),dt=l("table"),dt.innerHTML=mn,Me=a(),g(ct.$$.fragment),ue=a(),gt=l("table"),gt.innerHTML=hn,ye=a(),g(ot.$$.fragment),ve=a(),st=l("p"),st.innerHTML=fn,$e=a(),g(mt.$$.fragment),Ce=a(),ht=l("table"),ht.innerHTML=pn,we=a(),g(ft.$$.fragment),Ie=a(),pt=l("table"),pt.innerHTML=bn,je=a(),bt=l("p"),bt.textContent=Tn,ke=a(),Tt=l("table"),Tt.innerHTML=Mn,Re=a(),g(Mt.$$.fragment),Je=a(),ut=l("p"),ut.innerHTML=un,Ee=a(),g(yt.$$.fragment),_e=a(),vt=l("table"),vt.innerHTML=yn,Be=a(),g($t.$$.fragment),Ue=a(),Ct=l("table"),Ct.innerHTML=vn,Ze=a(),It=l("p"),this.h()},l(t){const e=Rn("svelte-u9bgzb",document.head);b=d(e,"META",{name:!0,content:!0}),e.forEach(n),jt=r(t),wt=d(t,"P",{}),$n(wt).forEach(n),kt=r(t),o(u.$$.fragment,t),Rt=r(t),y=d(t,"P",{"data-svelte-h":!0}),c(y)!=="svelte-a1xmpp"&&(y.innerHTML=Ne),Jt=r(t),o(v.$$.fragment,t),Et=r(t),$=d(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-108lixw"&&($.innerHTML=He),_t=r(t),C=d(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1b66kne"&&(C.innerHTML=We),Bt=r(t),o(w.$$.fragment,t),Ut=r(t),I=d(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-13c27qn"&&(I.innerHTML=Oe),Zt=r(t),j=d(t,"P",{"data-svelte-h":!0}),c(j)!=="svelte-116qe4s"&&(j.innerHTML=xe),St=r(t),o(k.$$.fragment,t),Lt=r(t),R=d(t,"P",{"data-svelte-h":!0}),c(R)!=="svelte-2dld2n"&&(R.textContent=Ve),zt=r(t),o(J.$$.fragment,t),Dt=r(t),o(E.$$.fragment,t),Nt=r(t),o(_.$$.fragment,t),Ht=r(t),o(B.$$.fragment,t),Wt=r(t),o(U.$$.fragment,t),Ot=r(t),o(Z.$$.fragment,t),xt=r(t),S=d(t,"P",{"data-svelte-h":!0}),c(S)!=="svelte-fbvml8"&&(S.textContent=Xe),Vt=r(t),L=d(t,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1pzh5ag"&&(L.innerHTML=Ge),Xt=r(t),z=d(t,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-i1xpay"&&(z.innerHTML=Ae),Gt=r(t),D=d(t,"P",{"data-svelte-h":!0}),c(D)!=="svelte-vq25eq"&&(D.innerHTML=Fe),At=r(t),N=d(t,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-1vcuz7e"&&(N.innerHTML=Ye),Ft=r(t),H=d(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1e8jpwt"&&(H.innerHTML=qe),Yt=r(t),W=d(t,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-yhf9tm"&&(W.innerHTML=Pe),qt=r(t),O=d(t,"P",{"data-svelte-h":!0}),c(O)!=="svelte-7yg5eu"&&(O.innerHTML=Qe),Pt=r(t),T=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-1jw9wmi"&&(T.innerHTML=Ke),Qt=r(t),M=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-nlzsqo"&&(M.innerHTML=tn),Kt=r(t),x=d(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-gdeipd"&&(x.innerHTML=en),te=r(t),V=d(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1cusdpa"&&(V.innerHTML=nn),ee=r(t),X=d(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-16crmf3"&&(X.innerHTML=an),ne=r(t),o(G.$$.fragment,t),ie=r(t),A=d(t,"TABLE",{"data-svelte-h":!0}),c(A)!=="svelte-6uvhqg"&&(A.innerHTML=rn),ae=r(t),o(F.$$.fragment,t),re=r(t),Y=d(t,"TABLE",{"data-svelte-h":!0}),c(Y)!=="svelte-f4zjoc"&&(Y.innerHTML=ln),le=r(t),o(q.$$.fragment,t),de=r(t),P=d(t,"TABLE",{"data-svelte-h":!0}),c(P)!=="svelte-9ju0ii"&&(P.innerHTML=dn),ce=r(t),o(Q.$$.fragment,t),ge=r(t),K=d(t,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-18ncoxq"&&(K.innerHTML=cn),oe=r(t),o(tt.$$.fragment,t),se=r(t),et=d(t,"TABLE",{"data-svelte-h":!0}),c(et)!=="svelte-15udyd3"&&(et.innerHTML=gn),me=r(t),o(nt.$$.fragment,t),he=r(t),it=d(t,"TABLE",{"data-svelte-h":!0}),c(it)!=="svelte-rw07j7"&&(it.innerHTML=on),fe=r(t),o(at.$$.fragment,t),pe=r(t),rt=d(t,"TABLE",{"data-svelte-h":!0}),c(rt)!=="svelte-37x5jw"&&(rt.innerHTML=sn),be=r(t),o(lt.$$.fragment,t),Te=r(t),dt=d(t,"TABLE",{"data-svelte-h":!0}),c(dt)!=="svelte-1mc5027"&&(dt.innerHTML=mn),Me=r(t),o(ct.$$.fragment,t),ue=r(t),gt=d(t,"TABLE",{"data-svelte-h":!0}),c(gt)!=="svelte-10eiin7"&&(gt.innerHTML=hn),ye=r(t),o(ot.$$.fragment,t),ve=r(t),st=d(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-ov5yx8"&&(st.innerHTML=fn),$e=r(t),o(mt.$$.fragment,t),Ce=r(t),ht=d(t,"TABLE",{"data-svelte-h":!0}),c(ht)!=="svelte-1cg5nyy"&&(ht.innerHTML=pn),we=r(t),o(ft.$$.fragment,t),Ie=r(t),pt=d(t,"TABLE",{"data-svelte-h":!0}),c(pt)!=="svelte-1nlzppe"&&(pt.innerHTML=bn),je=r(t),bt=d(t,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-l1xtas"&&(bt.textContent=Tn),ke=r(t),Tt=d(t,"TABLE",{"data-svelte-h":!0}),c(Tt)!=="svelte-ok1p6e"&&(Tt.innerHTML=Mn),Re=r(t),o(Mt.$$.fragment,t),Je=r(t),ut=d(t,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1axz5ve"&&(ut.innerHTML=un),Ee=r(t),o(yt.$$.fragment,t),_e=r(t),vt=d(t,"TABLE",{"data-svelte-h":!0}),c(vt)!=="svelte-13rnx0"&&(vt.innerHTML=yn),Be=r(t),o($t.$$.fragment,t),Ue=r(t),Ct=d(t,"TABLE",{"data-svelte-h":!0}),c(Ct)!=="svelte-oh2zql"&&(Ct.innerHTML=vn),Ze=r(t),It=d(t,"P",{}),$n(It).forEach(n),this.h()},h(){Le(b,"name","hf:doc:metadata"),Le(b,"content",Bn),Le(T,"class","flex"),Le(M,"class","flex")},m(t,e){Jn(document.head,b),i(t,jt,e),i(t,wt,e),i(t,kt,e),s(u,t,e),i(t,Rt,e),i(t,y,e),i(t,Jt,e),s(v,t,e),i(t,Et,e),i(t,$,e),i(t,_t,e),i(t,C,e),i(t,Bt,e),s(w,t,e),i(t,Ut,e),i(t,I,e),i(t,Zt,e),i(t,j,e),i(t,St,e),s(k,t,e),i(t,Lt,e),i(t,R,e),i(t,zt,e),s(J,t,e),i(t,Dt,e),s(E,t,e),i(t,Nt,e),s(_,t,e),i(t,Ht,e),s(B,t,e),i(t,Wt,e),s(U,t,e),i(t,Ot,e),s(Z,t,e),i(t,xt,e),i(t,S,e),i(t,Vt,e),i(t,L,e),i(t,Xt,e),i(t,z,e),i(t,Gt,e),i(t,D,e),i(t,At,e),i(t,N,e),i(t,Ft,e),i(t,H,e),i(t,Yt,e),i(t,W,e),i(t,qt,e),i(t,O,e),i(t,Pt,e),i(t,T,e),i(t,Qt,e),i(t,M,e),i(t,Kt,e),i(t,x,e),i(t,te,e),i(t,V,e),i(t,ee,e),i(t,X,e),i(t,ne,e),s(G,t,e),i(t,ie,e),i(t,A,e),i(t,ae,e),s(F,t,e),i(t,re,e),i(t,Y,e),i(t,le,e),s(q,t,e),i(t,de,e),i(t,P,e),i(t,ce,e),s(Q,t,e),i(t,ge,e),i(t,K,e),i(t,oe,e),s(tt,t,e),i(t,se,e),i(t,et,e),i(t,me,e),s(nt,t,e),i(t,he,e),i(t,it,e),i(t,fe,e),s(at,t,e),i(t,pe,e),i(t,rt,e),i(t,be,e),s(lt,t,e),i(t,Te,e),i(t,dt,e),i(t,Me,e),s(ct,t,e),i(t,ue,e),i(t,gt,e),i(t,ye,e),s(ot,t,e),i(t,ve,e),i(t,st,e),i(t,$e,e),s(mt,t,e),i(t,Ce,e),i(t,ht,e),i(t,we,e),s(ft,t,e),i(t,Ie,e),i(t,pt,e),i(t,je,e),i(t,bt,e),i(t,ke,e),i(t,Tt,e),i(t,Re,e),s(Mt,t,e),i(t,Je,e),i(t,ut,e),i(t,Ee,e),s(yt,t,e),i(t,_e,e),i(t,vt,e),i(t,Be,e),s($t,t,e),i(t,Ue,e),i(t,Ct,e),i(t,Ze,e),i(t,It,e),Se=!0},p:wn,i(t){Se||(m(u.$$.fragment,t),m(v.$$.fragment,t),m(w.$$.fragment,t),m(k.$$.fragment,t),m(J.$$.fragment,t),m(E.$$.fragment,t),m(_.$$.fragment,t),m(B.$$.fragment,t),m(U.$$.fragment,t),m(Z.$$.fragment,t),m(G.$$.fragment,t),m(F.$$.fragment,t),m(q.$$.fragment,t),m(Q.$$.fragment,t),m(tt.$$.fragment,t),m(nt.$$.fragment,t),m(at.$$.fragment,t),m(lt.$$.fragment,t),m(ct.$$.fragment,t),m(ot.$$.fragment,t),m(mt.$$.fragment,t),m(ft.$$.fragment,t),m(Mt.$$.fragment,t),m(yt.$$.fragment,t),m($t.$$.fragment,t),Se=!0)},o(t){h(u.$$.fragment,t),h(v.$$.fragment,t),h(w.$$.fragment,t),h(k.$$.fragment,t),h(J.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),h(B.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(F.$$.fragment,t),h(q.$$.fragment,t),h(Q.$$.fragment,t),h(tt.$$.fragment,t),h(nt.$$.fragment,t),h(at.$$.fragment,t),h(lt.$$.fragment,t),h(ct.$$.fragment,t),h(ot.$$.fragment,t),h(mt.$$.fragment,t),h(ft.$$.fragment,t),h(Mt.$$.fragment,t),h(yt.$$.fragment,t),h($t.$$.fragment,t),Se=!1},d(t){t&&(n(jt),n(wt),n(kt),n(Rt),n(y),n(Jt),n(Et),n($),n(_t),n(C),n(Bt),n(Ut),n(I),n(Zt),n(j),n(St),n(Lt),n(R),n(zt),n(Dt),n(Nt),n(Ht),n(Wt),n(Ot),n(xt),n(S),n(Vt),n(L),n(Xt),n(z),n(Gt),n(D),n(At),n(N),n(Ft),n(H),n(Yt),n(W),n(qt),n(O),n(Pt),n(T),n(Qt),n(M),n(Kt),n(x),n(te),n(V),n(ee),n(X),n(ne),n(ie),n(A),n(ae),n(re),n(Y),n(le),n(de),n(P),n(ce),n(ge),n(K),n(oe),n(se),n(et),n(me),n(he),n(it),n(fe),n(pe),n(rt),n(be),n(Te),n(dt),n(Me),n(ue),n(gt),n(ye),n(ve),n(st),n($e),n(Ce),n(ht),n(we),n(Ie),n(pt),n(je),n(bt),n(ke),n(Tt),n(Re),n(Je),n(ut),n(Ee),n(_e),n(vt),n(Be),n(Ue),n(Ct),n(Ze),n(It)),n(b),f(u,t),f(v,t),f(w,t),f(k,t),f(J,t),f(E,t),f(_,t),f(B,t),f(U,t),f(Z,t),f(G,t),f(F,t),f(q,t),f(Q,t),f(tt,t),f(nt,t),f(at,t),f(lt,t),f(ct,t),f(ot,t),f(mt,t),f(ft,t),f(Mt,t),f(yt,t),f($t,t)}}}const Bn='{"title":"Optimize inference using torch.compile()","local":"optimize-inference-using-torchcompile","sections":[{"title":"Benefits of torch.compile","local":"benefits-of-torchcompile","sections":[],"depth":2},{"title":"Benchmarking code","local":"benchmarking-code","sections":[{"title":"Image Classification with ViT","local":"image-classification-with-vit","sections":[{"title":"Object Detection with DETR","local":"object-detection-with-detr","sections":[],"depth":4},{"title":"Image Segmentation with Segformer","local":"image-segmentation-with-segformer","sections":[],"depth":4}],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Nightly","local":"pytorch-nightly","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2},{"title":"Reduce Overhead","local":"reduce-overhead","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2}],"depth":1}';function Un(De){return In(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=En}),[]}class Dn extends jn{constructor(b){super(),kn(this,b,Un,_n,Cn,{})}}export{Dn as component};
