import{s as ca,n as ma,o as ha}from"../chunks/scheduler.9bc65507.js";import{S as ua,i as ga,g as i,s as n,r,A as da,h as p,f as e,c as l,j as Ss,u as c,x as o,k as ra,y as f,a,v as m,d as h,t as u,w as g}from"../chunks/index.707bf1b6.js";import{H as d,g as ya}from"../chunks/Heading.9a412c8a.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";function ja(fe){let j,Fs,Xs,_s,J,Ls,b,Je="🤗 Transformers is a library of pretrained state-of-the-art models for natural language processing (NLP), computer vision, and audio and speech processing tasks. Not only does the library contain Transformer models, but it also has non-Transformer models like modern convolutional networks for computer vision tasks. If you look at some of the most popular consumer products today, like smartphones, apps, and televisions, odds are that some kind of deep learning technology is behind it. Want to remove a background object from a picture taken by your smartphone? This is an example of a panoptic segmentation task (don’t worry if you don’t know what this means yet, we’ll describe it in the following sections!).",As,x,be="This page provides an overview of the different speech and audio, computer vision, and NLP tasks that can be solved with the 🤗 Transformers library in just three lines of code!",Ps,w,Ks,T,xe="Audio and speech processing tasks are a little different from the other modalities mainly because audio as an input is a continuous signal. Unlike text, a raw audio waveform can’t be neatly split into discrete chunks the way a sentence can be divided into words. To get around this, the raw audio signal is typically sampled at regular intervals. If you take more samples within an interval, the sampling rate is higher, and the audio more closely resembles the original audio source.",Ds,U,we="Previous approaches preprocessed the audio to extract useful features from it. It is now more common to start audio and speech processing tasks by directly feeding the raw audio waveform to a feature encoder to extract an audio representation. This simplifies the preprocessing step and allows the model to learn the most essential features.",Os,k,st,C,Te="Audio classification is a task that labels audio data from a predefined set of classes. It is a broad category with many specific applications, some of which include:",tt,I,Ue="<li>acoustic scene classification: label audio with a scene label (“office”, “beach”, “stadium”)</li> <li>acoustic event detection: label audio with a sound event label (“car horn”, “whale calling”, “glass breaking”)</li> <li>tagging: label audio containing multiple sounds (birdsongs, speaker identification in a meeting)</li> <li>music classification: label music with a genre label (“metal”, “hip-hop”, “country”)</li>",et,Z,at,v,nt,B,ke="Automatic speech recognition (ASR) transcribes speech into text. It is one of the most common audio tasks due partly to speech being such a natural form of human communication. Today, ASR systems are embedded in “smart” technology products like speakers, phones, and cars. We can ask our virtual assistants to play music, set reminders, and tell us the weather.",lt,W,Ce="But one of the key challenges Transformer architectures have helped with is in low-resource languages. By pretraining on large amounts of speech data, finetuning the model on only one hour of labeled speech data in a low-resource language can still produce high-quality results compared to previous ASR systems trained on 100x more labeled data.",it,$,pt,q,ot,G,Ie='One of the first and earliest successful computer vision tasks was recognizing images of zip code numbers using a <a href="glossary#convolution">convolutional neural network (CNN)</a>. An image is composed of pixels, and each pixel has a numerical value. This makes it easy to represent an image as a matrix of pixel values. Each particular combination of pixel values describes the colors of an image.',rt,H,Ze="Two general ways computer vision tasks can be solved are:",ct,V,ve="<li>Use convolutions to learn the hierarchical features of an image from low-level features to high-level abstract things.</li> <li>Split an image into patches and use a Transformer to gradually learn how each image patch is related to each other to form an image. Unlike the bottom-up approach favored by a CNN, this is kind of like starting out with a blurry image and then gradually bringing it into focus.</li>",mt,N,ht,R,Be="Image classification labels an entire image from a predefined set of classes. Like most classification tasks, there are many practical use cases for image classification, some of which include:",ut,z,We="<li>healthcare: label medical images to detect disease or monitor patient health</li> <li>environment: label satellite images to monitor deforestation, inform wildland management or detect wildfires</li> <li>agriculture: label images of crops to monitor plant health or satellite images for land use monitoring</li> <li>ecology: label images of animal or plant species to monitor wildlife populations or track endangered species</li>",gt,Q,dt,Y,yt,X,$e="Unlike image classification, object detection identifies multiple objects within an image and the objects’ positions in an image (defined by the bounding box). Some example applications of object detection include:",jt,E,qe="<li>self-driving vehicles: detect everyday traffic objects such as other vehicles, pedestrians, and traffic lights</li> <li>remote sensing: disaster monitoring, urban planning, and weather forecasting</li> <li>defect detection: detect cracks or structural damage in buildings, and manufacturing defects</li>",Mt,S,ft,F,Jt,_,Ge="Image segmentation is a pixel-level task that assigns every pixel in an image to a class. It differs from object detection, which uses bounding boxes to label and predict objects in an image because segmentation is more granular. Segmentation can detect objects at a pixel-level. There are several types of image segmentation:",bt,L,He="<li>instance segmentation: in addition to labeling the class of an object, it also labels each distinct instance of an object (“dog-1”, “dog-2”)</li> <li>panoptic segmentation: a combination of semantic and instance segmentation; it labels each pixel with a semantic class <strong>and</strong> each distinct instance of an object</li>",xt,A,Ve="Segmentation tasks are helpful in self-driving vehicles to create a pixel-level map of the world around them so they can navigate safely around pedestrians and other vehicles. It is also useful for medical imaging, where the task’s finer granularity can help identify abnormal cells or organ features. Image segmentation can also be used in ecommerce to virtually try on clothes or create augmented reality experiences by overlaying objects in the real world through your camera.",wt,P,Tt,K,Ut,D,Ne="Depth estimation predicts the distance of each pixel in an image from the camera. This computer vision task is especially important for scene understanding and reconstruction. For example, in self-driving cars, vehicles need to understand how far objects like pedestrians, traffic signs, and other vehicles are to avoid obstacles and collisions. Depth information is also helpful for constructing 3D representations from 2D images and can be used to create high-quality 3D representations of biological structures or buildings.",kt,O,Re="There are two approaches to depth estimation:",Ct,ss,ze="<li>stereo: depths are estimated by comparing two images of the same image from slightly different angles</li> <li>monocular: depths are estimated from a single image</li>",It,ts,Zt,es,vt,as,Qe="NLP tasks are among the most common types of tasks because text is such a natural way for us to communicate. To get text into a format recognized by a model, it needs to be tokenized. This means dividing a sequence of text into separate words or subwords (tokens) and then converting these tokens into numbers. As a result, you can represent a sequence of text as a sequence of numbers, and once you have a sequence of numbers, it can be input into a model to solve all sorts of NLP tasks!",Bt,ns,Wt,ls,Ye="Like classification tasks in any modality, text classification labels a sequence of text (it can be sentence-level, a paragraph, or a document) from a predefined set of classes. There are many practical applications for text classification, some of which include:",$t,is,Xe="<li>sentiment analysis: label text according to some polarity like <code>positive</code> or <code>negative</code> which can inform and support decision-making in fields like politics, finance, and marketing</li> <li>content classification: label text according to some topic to help organize and filter information in news and social media feeds (<code>weather</code>, <code>sports</code>, <code>finance</code>, etc.)</li>",qt,ps,Gt,os,Ht,rs,Ee='In any NLP task, text is preprocessed by separating the sequence of text into individual words or subwords. These are known as <a href="/glossary#token">tokens</a>. Token classification assigns each token a label from a predefined set of classes.',Vt,cs,Se="Two common types of token classification are:",Nt,ms,Fe="<li>named entity recognition (NER): label a token according to an entity category like organization, person, location or date. NER is especially popular in biomedical settings, where it can label genes, proteins, and drug names.</li> <li>part-of-speech tagging (POS): label a token according to its part-of-speech like noun, verb, or adjective. POS is useful for helping translation systems understand how two identical words are grammatically different (bank as a noun versus bank as a verb).</li>",Rt,hs,zt,us,Qt,gs,_e="Question answering is another token-level task that returns an answer to a question, sometimes with context (open-domain) and other times without context (closed-domain). This task happens whenever we ask a virtual assistant something like whether a restaurant is open. It can also provide customer or technical support and help search engines retrieve the relevant information you’re asking for.",Yt,ds,Le="There are two common types of question answering:",Xt,ys,Ae='<li>extractive: given a question and some context, the answer is a span of text from the context the model must extract</li> <li>abstractive: given a question and some context, the answer is generated from the context; this approach is handled by the <a href="/docs/transformers/v4.35.2/en/main_classes/pipelines#transformers.Text2TextGenerationPipeline">Text2TextGenerationPipeline</a> instead of the <a href="/docs/transformers/v4.35.2/en/main_classes/pipelines#transformers.QuestionAnsweringPipeline">QuestionAnsweringPipeline</a> shown below</li>',Et,js,St,Ms,Ft,fs,Pe="Summarization creates a shorter version of a text from a longer one while trying to preserve most of the meaning of the original document. Summarization is a sequence-to-sequence task; it outputs a shorter text sequence than the input. There are a lot of long-form documents that can be summarized to help readers quickly understand the main points. Legislative bills, legal and financial documents, patents, and scientific papers are a few examples of documents that could be summarized to save readers time and serve as a reading aid.",_t,Js,Ke="Like question answering, there are two types of summarization:",Lt,bs,De='<li>extractive: identify and extract the most important sentences from the original text</li> <li>abstractive: generate the target summary (which may include new words not in the input document) from the original text; the <a href="/docs/transformers/v4.35.2/en/main_classes/pipelines#transformers.SummarizationPipeline">SummarizationPipeline</a> uses the abstractive approach</li>',At,xs,Pt,ws,Kt,Ts,Oe="Translation converts a sequence of text in one language to another. It is important in helping people from different backgrounds communicate with each other, help translate content to reach wider audiences, and even be a learning tool to help people learn a new language. Along with summarization, translation is a sequence-to-sequence task, meaning the model receives an input sequence and returns a target output sequence.",Dt,Us,sa="In the early days, translation models were mostly monolingual, but recently, there has been increasing interest in multilingual models that can translate between many pairs of languages.",Ot,ks,se,Cs,te,Is,ta="Language modeling is a task that predicts a word in a sequence of text. It has become a very popular NLP task because a pretrained language model can be finetuned for many other downstream tasks. Lately, there has been a lot of interest in large language models (LLMs) which demonstrate zero- or few-shot learning. This means the model can solve tasks it wasn’t explicitly trained to do! Language models can be used to generate fluent and convincing text, though you need to be careful since the text may not always be accurate.",ee,Zs,ea="There are two types of language modeling:",ae,M,vs,Qs,aa="causal: the model’s objective is to predict the next token in a sequence, and future tokens are masked",ye,Bs,je,Ws,Ys,na="masked: the model’s objective is to predict a masked token in a sequence with full access to the tokens in the sequence",Me,$s,ne,qs,le,Gs,la="Multimodal tasks require a model to process multiple data modalities (text, image, audio, video) to solve a particular problem. Image captioning is an example of a multimodal task where the model takes an image as input and outputs a sequence of text describing the image or some properties of the image.",ie,Hs,ia="Although multimodal models work with different data types or modalities, internally, the preprocessing steps help the model convert all the data types into embeddings (vectors or list of numbers that holds meaningful information about the data). For a task like image captioning, the model learns relationships between image embeddings and text embeddings.",pe,Vs,oe,Ns,pa="Document question answering is a task that answers natural language questions from a document. Unlike a token-level question answering task which takes text as input, document question answering takes an image of a document as input along with a question about the document and returns an answer. Document question answering can be used to parse structured documents and extract key information from it. In the example below, the total amount and change due can be extracted from a receipt.",re,Rs,ce,zs,oa='Hopefully, this page has given you some more background information about all the types of tasks in each modality and the practical importance of each one. In the next <a href="tasks_explained">section</a>, you’ll learn <strong>how</strong> 🤗 Transformers work to solve these tasks.',me,Es,he;return J=new d({props:{title:"What 🤗 Transformers can do",local:"what--transformers-can-do",headingTag:"h1"}}),w=new d({props:{title:"Audio",local:"audio",headingTag:"h2"}}),k=new d({props:{title:"Audio classification",local:"audio-classification",headingTag:"h3"}}),Z=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),v=new d({props:{title:"Automatic speech recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),$=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),q=new d({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),N=new d({props:{title:"Image classification",local:"image-classification",headingTag:"h3"}}),Q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),Y=new d({props:{title:"Object detection",local:"object-detection",headingTag:"h3"}}),S=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),F=new d({props:{title:"Image segmentation",local:"image-segmentation",headingTag:"h3"}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),K=new d({props:{title:"Depth estimation",local:"depth-estimation",headingTag:"h3"}}),ts=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),es=new d({props:{title:"Natural language processing",local:"natural-language-processing",headingTag:"h2"}}),ns=new d({props:{title:"Text classification",local:"text-classification",headingTag:"h3"}}),ps=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),os=new d({props:{title:"Token classification",local:"token-classification",headingTag:"h3"}}),hs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),us=new d({props:{title:"Question answering",local:"question-answering",headingTag:"h3"}}),js=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),Ms=new d({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),xs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),ws=new d({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ks=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),Cs=new d({props:{title:"Language modeling",local:"language-modeling",headingTag:"h3"}}),Bs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),$s=new y({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),qs=new d({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),Vs=new d({props:{title:"Document question answering",local:"document-question-answering",headingTag:"h3"}}),Rs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmRhdGFzZXRzLXNlcnZlci5odWdnaW5nZmFjZS5jbyUyRmFzc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZleGFtcGxlLWRvY3VtZW50cyUyRi0tJTJGaGYtaW50ZXJuYWwtdGVzdGluZy0tZXhhbXBsZS1kb2N1bWVudHMlMkZ0ZXN0JTJGMiUyRmltYWdlJTJGaW1hZ2UuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBZG9jX3F1ZXN0aW9uX2Fuc3dlcmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyZG9jdW1lbnQtcXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0QlMjJtYWdvcnNodW5vdiUyRmxheW91dGxtLWludm9pY2VzJTIyKSUwQXByZWRzJTIwJTNEJTIwZG9jX3F1ZXN0aW9uX2Fuc3dlcmVyKCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNEJTIyV2hhdCUyMGlzJTIwdGhlJTIwdG90YWwlMjBhbW91bnQlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKSUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://datasets-server.huggingface.co/assets/hf-internal-testing/example-documents/--/hf-internal-testing--example-documents/test/2/image/image.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>doc_question_answerer = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;magorshunov/layoutlm-invoices&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = doc_question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the total amount?&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8531</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">4</span>}]`,wrap:!1}}),{c(){j=i("meta"),Fs=n(),Xs=i("p"),_s=n(),r(J.$$.fragment),Ls=n(),b=i("p"),b.textContent=Je,As=n(),x=i("p"),x.textContent=be,Ps=n(),r(w.$$.fragment),Ks=n(),T=i("p"),T.textContent=xe,Ds=n(),U=i("p"),U.textContent=we,Os=n(),r(k.$$.fragment),st=n(),C=i("p"),C.textContent=Te,tt=n(),I=i("ul"),I.innerHTML=Ue,et=n(),r(Z.$$.fragment),at=n(),r(v.$$.fragment),nt=n(),B=i("p"),B.textContent=ke,lt=n(),W=i("p"),W.textContent=Ce,it=n(),r($.$$.fragment),pt=n(),r(q.$$.fragment),ot=n(),G=i("p"),G.innerHTML=Ie,rt=n(),H=i("p"),H.textContent=Ze,ct=n(),V=i("ol"),V.innerHTML=ve,mt=n(),r(N.$$.fragment),ht=n(),R=i("p"),R.textContent=Be,ut=n(),z=i("ul"),z.innerHTML=We,gt=n(),r(Q.$$.fragment),dt=n(),r(Y.$$.fragment),yt=n(),X=i("p"),X.textContent=$e,jt=n(),E=i("ul"),E.innerHTML=qe,Mt=n(),r(S.$$.fragment),ft=n(),r(F.$$.fragment),Jt=n(),_=i("p"),_.textContent=Ge,bt=n(),L=i("ul"),L.innerHTML=He,xt=n(),A=i("p"),A.textContent=Ve,wt=n(),r(P.$$.fragment),Tt=n(),r(K.$$.fragment),Ut=n(),D=i("p"),D.textContent=Ne,kt=n(),O=i("p"),O.textContent=Re,Ct=n(),ss=i("ul"),ss.innerHTML=ze,It=n(),r(ts.$$.fragment),Zt=n(),r(es.$$.fragment),vt=n(),as=i("p"),as.textContent=Qe,Bt=n(),r(ns.$$.fragment),Wt=n(),ls=i("p"),ls.textContent=Ye,$t=n(),is=i("ul"),is.innerHTML=Xe,qt=n(),r(ps.$$.fragment),Gt=n(),r(os.$$.fragment),Ht=n(),rs=i("p"),rs.innerHTML=Ee,Vt=n(),cs=i("p"),cs.textContent=Se,Nt=n(),ms=i("ul"),ms.innerHTML=Fe,Rt=n(),r(hs.$$.fragment),zt=n(),r(us.$$.fragment),Qt=n(),gs=i("p"),gs.textContent=_e,Yt=n(),ds=i("p"),ds.textContent=Le,Xt=n(),ys=i("ul"),ys.innerHTML=Ae,Et=n(),r(js.$$.fragment),St=n(),r(Ms.$$.fragment),Ft=n(),fs=i("p"),fs.textContent=Pe,_t=n(),Js=i("p"),Js.textContent=Ke,Lt=n(),bs=i("ul"),bs.innerHTML=De,At=n(),r(xs.$$.fragment),Pt=n(),r(ws.$$.fragment),Kt=n(),Ts=i("p"),Ts.textContent=Oe,Dt=n(),Us=i("p"),Us.textContent=sa,Ot=n(),r(ks.$$.fragment),se=n(),r(Cs.$$.fragment),te=n(),Is=i("p"),Is.textContent=ta,ee=n(),Zs=i("p"),Zs.textContent=ea,ae=n(),M=i("ul"),vs=i("li"),Qs=i("p"),Qs.textContent=aa,ye=n(),r(Bs.$$.fragment),je=n(),Ws=i("li"),Ys=i("p"),Ys.textContent=na,Me=n(),r($s.$$.fragment),ne=n(),r(qs.$$.fragment),le=n(),Gs=i("p"),Gs.textContent=la,ie=n(),Hs=i("p"),Hs.textContent=ia,pe=n(),r(Vs.$$.fragment),oe=n(),Ns=i("p"),Ns.textContent=pa,re=n(),r(Rs.$$.fragment),ce=n(),zs=i("p"),zs.innerHTML=oa,me=n(),Es=i("p"),this.h()},l(s){const t=da("svelte-u9bgzb",document.head);j=p(t,"META",{name:!0,content:!0}),t.forEach(e),Fs=l(s),Xs=p(s,"P",{}),Ss(Xs).forEach(e),_s=l(s),c(J.$$.fragment,s),Ls=l(s),b=p(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-16honzi"&&(b.textContent=Je),As=l(s),x=p(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-co1bd8"&&(x.textContent=be),Ps=l(s),c(w.$$.fragment,s),Ks=l(s),T=p(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-y5bzkk"&&(T.textContent=xe),Ds=l(s),U=p(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1buqhp9"&&(U.textContent=we),Os=l(s),c(k.$$.fragment,s),st=l(s),C=p(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-wenpsc"&&(C.textContent=Te),tt=l(s),I=p(s,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-ii0fya"&&(I.innerHTML=Ue),et=l(s),c(Z.$$.fragment,s),at=l(s),c(v.$$.fragment,s),nt=l(s),B=p(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1uioxjn"&&(B.textContent=ke),lt=l(s),W=p(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-13nabhb"&&(W.textContent=Ce),it=l(s),c($.$$.fragment,s),pt=l(s),c(q.$$.fragment,s),ot=l(s),G=p(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1iprewp"&&(G.innerHTML=Ie),rt=l(s),H=p(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-9en3oh"&&(H.textContent=Ze),ct=l(s),V=p(s,"OL",{"data-svelte-h":!0}),o(V)!=="svelte-1n2rw1y"&&(V.innerHTML=ve),mt=l(s),c(N.$$.fragment,s),ht=l(s),R=p(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1xnawqn"&&(R.textContent=Be),ut=l(s),z=p(s,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-hzwblv"&&(z.innerHTML=We),gt=l(s),c(Q.$$.fragment,s),dt=l(s),c(Y.$$.fragment,s),yt=l(s),X=p(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-rzixgf"&&(X.textContent=$e),jt=l(s),E=p(s,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-11ca9ev"&&(E.innerHTML=qe),Mt=l(s),c(S.$$.fragment,s),ft=l(s),c(F.$$.fragment,s),Jt=l(s),_=p(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-z5ffax"&&(_.textContent=Ge),bt=l(s),L=p(s,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-1uq2lxo"&&(L.innerHTML=He),xt=l(s),A=p(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-fhukdm"&&(A.textContent=Ve),wt=l(s),c(P.$$.fragment,s),Tt=l(s),c(K.$$.fragment,s),Ut=l(s),D=p(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ee4yo2"&&(D.textContent=Ne),kt=l(s),O=p(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1tcdxbt"&&(O.textContent=Re),Ct=l(s),ss=p(s,"UL",{"data-svelte-h":!0}),o(ss)!=="svelte-1h9rsal"&&(ss.innerHTML=ze),It=l(s),c(ts.$$.fragment,s),Zt=l(s),c(es.$$.fragment,s),vt=l(s),as=p(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-p86gd4"&&(as.textContent=Qe),Bt=l(s),c(ns.$$.fragment,s),Wt=l(s),ls=p(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-xkrisb"&&(ls.textContent=Ye),$t=l(s),is=p(s,"UL",{"data-svelte-h":!0}),o(is)!=="svelte-1785q2k"&&(is.innerHTML=Xe),qt=l(s),c(ps.$$.fragment,s),Gt=l(s),c(os.$$.fragment,s),Ht=l(s),rs=p(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1k598k5"&&(rs.innerHTML=Ee),Vt=l(s),cs=p(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1tgdzja"&&(cs.textContent=Se),Nt=l(s),ms=p(s,"UL",{"data-svelte-h":!0}),o(ms)!=="svelte-3b1070"&&(ms.innerHTML=Fe),Rt=l(s),c(hs.$$.fragment,s),zt=l(s),c(us.$$.fragment,s),Qt=l(s),gs=p(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-jggqzr"&&(gs.textContent=_e),Yt=l(s),ds=p(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-16zyksn"&&(ds.textContent=Le),Xt=l(s),ys=p(s,"UL",{"data-svelte-h":!0}),o(ys)!=="svelte-10iqgto"&&(ys.innerHTML=Ae),Et=l(s),c(js.$$.fragment,s),St=l(s),c(Ms.$$.fragment,s),Ft=l(s),fs=p(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-4carp"&&(fs.textContent=Pe),_t=l(s),Js=p(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1s0vpsm"&&(Js.textContent=Ke),Lt=l(s),bs=p(s,"UL",{"data-svelte-h":!0}),o(bs)!=="svelte-17yzcv8"&&(bs.innerHTML=De),At=l(s),c(xs.$$.fragment,s),Pt=l(s),c(ws.$$.fragment,s),Kt=l(s),Ts=p(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1oa82bc"&&(Ts.textContent=Oe),Dt=l(s),Us=p(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-l2a5jq"&&(Us.textContent=sa),Ot=l(s),c(ks.$$.fragment,s),se=l(s),c(Cs.$$.fragment,s),te=l(s),Is=p(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-1hrjdjs"&&(Is.textContent=ta),ee=l(s),Zs=p(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-128qp3h"&&(Zs.textContent=ea),ae=l(s),M=p(s,"UL",{});var ue=Ss(M);vs=p(ue,"LI",{});var ge=Ss(vs);Qs=p(ge,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-cojn0n"&&(Qs.textContent=aa),ye=l(ge),c(Bs.$$.fragment,ge),ge.forEach(e),je=l(ue),Ws=p(ue,"LI",{});var de=Ss(Ws);Ys=p(de,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-b2em4k"&&(Ys.textContent=na),Me=l(de),c($s.$$.fragment,de),de.forEach(e),ue.forEach(e),ne=l(s),c(qs.$$.fragment,s),le=l(s),Gs=p(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1wn2c65"&&(Gs.textContent=la),ie=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1ax7w6c"&&(Hs.textContent=ia),pe=l(s),c(Vs.$$.fragment,s),oe=l(s),Ns=p(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1sl6ve4"&&(Ns.textContent=pa),re=l(s),c(Rs.$$.fragment,s),ce=l(s),zs=p(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-14177uf"&&(zs.innerHTML=oa),me=l(s),Es=p(s,"P",{}),Ss(Es).forEach(e),this.h()},h(){ra(j,"name","hf:doc:metadata"),ra(j,"content",Ma)},m(s,t){f(document.head,j),a(s,Fs,t),a(s,Xs,t),a(s,_s,t),m(J,s,t),a(s,Ls,t),a(s,b,t),a(s,As,t),a(s,x,t),a(s,Ps,t),m(w,s,t),a(s,Ks,t),a(s,T,t),a(s,Ds,t),a(s,U,t),a(s,Os,t),m(k,s,t),a(s,st,t),a(s,C,t),a(s,tt,t),a(s,I,t),a(s,et,t),m(Z,s,t),a(s,at,t),m(v,s,t),a(s,nt,t),a(s,B,t),a(s,lt,t),a(s,W,t),a(s,it,t),m($,s,t),a(s,pt,t),m(q,s,t),a(s,ot,t),a(s,G,t),a(s,rt,t),a(s,H,t),a(s,ct,t),a(s,V,t),a(s,mt,t),m(N,s,t),a(s,ht,t),a(s,R,t),a(s,ut,t),a(s,z,t),a(s,gt,t),m(Q,s,t),a(s,dt,t),m(Y,s,t),a(s,yt,t),a(s,X,t),a(s,jt,t),a(s,E,t),a(s,Mt,t),m(S,s,t),a(s,ft,t),m(F,s,t),a(s,Jt,t),a(s,_,t),a(s,bt,t),a(s,L,t),a(s,xt,t),a(s,A,t),a(s,wt,t),m(P,s,t),a(s,Tt,t),m(K,s,t),a(s,Ut,t),a(s,D,t),a(s,kt,t),a(s,O,t),a(s,Ct,t),a(s,ss,t),a(s,It,t),m(ts,s,t),a(s,Zt,t),m(es,s,t),a(s,vt,t),a(s,as,t),a(s,Bt,t),m(ns,s,t),a(s,Wt,t),a(s,ls,t),a(s,$t,t),a(s,is,t),a(s,qt,t),m(ps,s,t),a(s,Gt,t),m(os,s,t),a(s,Ht,t),a(s,rs,t),a(s,Vt,t),a(s,cs,t),a(s,Nt,t),a(s,ms,t),a(s,Rt,t),m(hs,s,t),a(s,zt,t),m(us,s,t),a(s,Qt,t),a(s,gs,t),a(s,Yt,t),a(s,ds,t),a(s,Xt,t),a(s,ys,t),a(s,Et,t),m(js,s,t),a(s,St,t),m(Ms,s,t),a(s,Ft,t),a(s,fs,t),a(s,_t,t),a(s,Js,t),a(s,Lt,t),a(s,bs,t),a(s,At,t),m(xs,s,t),a(s,Pt,t),m(ws,s,t),a(s,Kt,t),a(s,Ts,t),a(s,Dt,t),a(s,Us,t),a(s,Ot,t),m(ks,s,t),a(s,se,t),m(Cs,s,t),a(s,te,t),a(s,Is,t),a(s,ee,t),a(s,Zs,t),a(s,ae,t),a(s,M,t),f(M,vs),f(vs,Qs),f(vs,ye),m(Bs,vs,null),f(M,je),f(M,Ws),f(Ws,Ys),f(Ws,Me),m($s,Ws,null),a(s,ne,t),m(qs,s,t),a(s,le,t),a(s,Gs,t),a(s,ie,t),a(s,Hs,t),a(s,pe,t),m(Vs,s,t),a(s,oe,t),a(s,Ns,t),a(s,re,t),m(Rs,s,t),a(s,ce,t),a(s,zs,t),a(s,me,t),a(s,Es,t),he=!0},p:ma,i(s){he||(h(J.$$.fragment,s),h(w.$$.fragment,s),h(k.$$.fragment,s),h(Z.$$.fragment,s),h(v.$$.fragment,s),h($.$$.fragment,s),h(q.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),h(Y.$$.fragment,s),h(S.$$.fragment,s),h(F.$$.fragment,s),h(P.$$.fragment,s),h(K.$$.fragment,s),h(ts.$$.fragment,s),h(es.$$.fragment,s),h(ns.$$.fragment,s),h(ps.$$.fragment,s),h(os.$$.fragment,s),h(hs.$$.fragment,s),h(us.$$.fragment,s),h(js.$$.fragment,s),h(Ms.$$.fragment,s),h(xs.$$.fragment,s),h(ws.$$.fragment,s),h(ks.$$.fragment,s),h(Cs.$$.fragment,s),h(Bs.$$.fragment,s),h($s.$$.fragment,s),h(qs.$$.fragment,s),h(Vs.$$.fragment,s),h(Rs.$$.fragment,s),he=!0)},o(s){u(J.$$.fragment,s),u(w.$$.fragment,s),u(k.$$.fragment,s),u(Z.$$.fragment,s),u(v.$$.fragment,s),u($.$$.fragment,s),u(q.$$.fragment,s),u(N.$$.fragment,s),u(Q.$$.fragment,s),u(Y.$$.fragment,s),u(S.$$.fragment,s),u(F.$$.fragment,s),u(P.$$.fragment,s),u(K.$$.fragment,s),u(ts.$$.fragment,s),u(es.$$.fragment,s),u(ns.$$.fragment,s),u(ps.$$.fragment,s),u(os.$$.fragment,s),u(hs.$$.fragment,s),u(us.$$.fragment,s),u(js.$$.fragment,s),u(Ms.$$.fragment,s),u(xs.$$.fragment,s),u(ws.$$.fragment,s),u(ks.$$.fragment,s),u(Cs.$$.fragment,s),u(Bs.$$.fragment,s),u($s.$$.fragment,s),u(qs.$$.fragment,s),u(Vs.$$.fragment,s),u(Rs.$$.fragment,s),he=!1},d(s){s&&(e(Fs),e(Xs),e(_s),e(Ls),e(b),e(As),e(x),e(Ps),e(Ks),e(T),e(Ds),e(U),e(Os),e(st),e(C),e(tt),e(I),e(et),e(at),e(nt),e(B),e(lt),e(W),e(it),e(pt),e(ot),e(G),e(rt),e(H),e(ct),e(V),e(mt),e(ht),e(R),e(ut),e(z),e(gt),e(dt),e(yt),e(X),e(jt),e(E),e(Mt),e(ft),e(Jt),e(_),e(bt),e(L),e(xt),e(A),e(wt),e(Tt),e(Ut),e(D),e(kt),e(O),e(Ct),e(ss),e(It),e(Zt),e(vt),e(as),e(Bt),e(Wt),e(ls),e($t),e(is),e(qt),e(Gt),e(Ht),e(rs),e(Vt),e(cs),e(Nt),e(ms),e(Rt),e(zt),e(Qt),e(gs),e(Yt),e(ds),e(Xt),e(ys),e(Et),e(St),e(Ft),e(fs),e(_t),e(Js),e(Lt),e(bs),e(At),e(Pt),e(Kt),e(Ts),e(Dt),e(Us),e(Ot),e(se),e(te),e(Is),e(ee),e(Zs),e(ae),e(M),e(ne),e(le),e(Gs),e(ie),e(Hs),e(pe),e(oe),e(Ns),e(re),e(ce),e(zs),e(me),e(Es)),e(j),g(J,s),g(w,s),g(k,s),g(Z,s),g(v,s),g($,s),g(q,s),g(N,s),g(Q,s),g(Y,s),g(S,s),g(F,s),g(P,s),g(K,s),g(ts,s),g(es,s),g(ns,s),g(ps,s),g(os,s),g(hs,s),g(us,s),g(js,s),g(Ms,s),g(xs,s),g(ws,s),g(ks,s),g(Cs,s),g(Bs),g($s),g(qs,s),g(Vs,s),g(Rs,s)}}}const Ma='{"title":"What 🤗 Transformers can do","local":"what--transformers-can-do","sections":[{"title":"Audio","local":"audio","sections":[{"title":"Audio classification","local":"audio-classification","sections":[],"depth":3},{"title":"Automatic speech recognition","local":"automatic-speech-recognition","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"Image classification","local":"image-classification","sections":[],"depth":3},{"title":"Object detection","local":"object-detection","sections":[],"depth":3},{"title":"Image segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Depth estimation","local":"depth-estimation","sections":[],"depth":3}],"depth":2},{"title":"Natural language processing","local":"natural-language-processing","sections":[{"title":"Text classification","local":"text-classification","sections":[],"depth":3},{"title":"Token classification","local":"token-classification","sections":[],"depth":3},{"title":"Question answering","local":"question-answering","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Language modeling","local":"language-modeling","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Document question answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2}],"depth":1}';function fa(fe){return ha(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ya}),[]}class Ta extends ua{constructor(j){super(),ga(this,j,fa,ja,ca,{})}}export{Ta as component};
