import{s as Ml,o as ul,n as ws}from"../chunks/scheduler.9bc65507.js";import{S as dl,i as yl,g as i,s as a,r as m,A as wl,h as o,f as s,c as n,j as hl,u as h,x as p,k as cl,y as gl,a as l,v as c,d as M,t as u,w as d}from"../chunks/index.707bf1b6.js";import{H as g,g as jl}from"../chunks/Heading.9a412c8a.js";import{T as ys}from"../chunks/Tip.c2ecdbf4.js";import{C as b}from"../chunks/CodeBlock.54a9f38d.js";import{D as fl}from"../chunks/DocNotebookDropdown.3e6b3817.js";function bl(U){let r,f=`Prompt engineering is only a part of the LLM output optimization process. Another essential component is choosing the
optimal text generation strategy. You can customize how your LLM selects each of the subsequent tokens when generating
the text without modifying any of the trainable parameters. By tweaking the text generation parameters, you can reduce
repetition in the generated text and make it more coherent and human-sounding.
Text generation strategies and parameters are out of scope for this guide, but you can learn more about these topics in
the following guides:`,y,w,J='<li><a href="../llm_tutorial">Generation with LLMs</a></li> <li><a href="../generation_strategies">Text generation strategies</a></li>';return{c(){r=i("p"),r.textContent=f,y=a(),w=i("ul"),w.innerHTML=J},l(j){r=o(j,"P",{"data-svelte-h":!0}),p(r)!=="svelte-194cy3"&&(r.textContent=f),y=n(j),w=o(j,"UL",{"data-svelte-h":!0}),p(w)!=="svelte-1gdi148"&&(w.innerHTML=J)},m(j,T){l(j,r,T),l(j,y,T),l(j,w,T)},p:ws,d(j){j&&(s(r),s(y),s(w))}}}function Tl(U){let r,f=`Note that Falcon models were trained using the <code>bfloat16</code> datatype, so we recommend you use the same. This requires a recent
version of CUDA and works best on modern cards.`;return{c(){r=i("p"),r.innerHTML=f},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-19pliy4"&&(r.innerHTML=f)},m(y,w){l(y,r,w)},p:ws,d(y){y&&s(r)}}}function Jl(U){let r,f=`You may notice that in addition to the prompt, we pass a <code>max_new_tokens</code> parameter. It controls the number of tokens the
model shall generate, and it is one of the many text generation parameters that you can learn about
in <a href="../generation_strategies">Text generation strategies</a> guide.`;return{c(){r=i("p"),r.innerHTML=f},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-7bwgnj"&&(r.innerHTML=f)},m(y,w){l(y,r,w)},p:ws,d(y){y&&s(r)}}}function Ul(U){let r,f,y,w,J,j,T,Se,B,gs=`Large Language Models such as Falcon, LLaMA, etc. are pretrained transformer models initially trained to predict the
next token given some input text. They typically have billions of parameters and have been trained on trillions of
tokens for an extended period of time. As a result, these models become quite powerful and versatile, and you can use
them to solve multiple NLP tasks out of the box by instructing the models with natural language prompts.`,Le,$,js=`Designing such prompts to ensure the optimal output is often called “prompt engineering”. Prompt engineering is an
iterative process that requires a fair amount of experimentation. Natural languages are much more flexible and expressive
than programming languages, however, they can also introduce some ambiguity. At the same time, prompts in natural language
are quite sensitive to changes. Even minor modifications in prompts can lead to wildly different outputs.`,Ae,G,fs=`While there is no exact recipe for creating prompts to match all cases, researchers have worked out a number of best
practices that help to achieve optimal results more consistently.`,Pe,Z,bs=`This guide covers the prompt engineering best practices to help you craft better LLM prompts and solve various NLP tasks.
You’ll learn:`,De,k,Ts='<li><a href="#basic-prompts">Basics of prompting</a></li> <li><a href="#best-practices-of-llm-prompting">Best practices of LLM prompting</a></li> <li><a href="#advanced-prompting-techniques">Advanced prompting techniques: few-shot prompting and chain-of-thought</a></li> <li><a href="#prompting-vs-fine-tuning">When to fine-tune instead of prompting</a></li>',Ke,v,Oe,C,et,W,tt,X,Js=`The majority of modern LLMs are decoder-only transformers. Some examples include: <a href="../model_doc/llama">LLaMA</a>,
<a href="../model_doc/llama2">Llama2</a>, <a href="../model_doc/falcon">Falcon</a>, <a href="../model_doc/gpt2">GPT2</a>. However, you may encounter
encoder-decoder transformer LLMs as well, for instance, <a href="../model_doc/flan-t5">Flan-T5</a> and <a href="../model_doc/bart">BART</a>.`,st,H,Us=`Encoder-decoder-style models are typically used in generative tasks where the output <strong>heavily</strong> relies on the input, for
example, in translation and summarization. The decoder-only models are used for all other types of generative tasks.`,lt,V,vs=`When using a pipeline to generate text with an LLM, it’s important to know what type of LLM you are using, because
they use different pipelines.`,at,Q,xs="Run inference with decoder-only models with the <code>text-generation</code> pipeline:",nt,_,it,R,Is="To run inference with an encoder-decoder, use the <code>text2text-generation</code> pipeline:",ot,F,pt,q,rt,N,Bs=`Most of the recent LLM checkpoints available on 🤗 Hub come in two versions: base and instruct (or chat). For example,
<a href="https://huggingface.co/tiiuae/falcon-7b" rel="nofollow"><code>tiiuae/falcon-7b</code></a> and <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow"><code>tiiuae/falcon-7b-instruct</code></a>.`,mt,Y,$s=`Base models are excellent at completing the text when given an initial prompt, however, they are not ideal for NLP tasks
where they need to follow instructions, or for conversational use. This is where the instruct (chat) versions come in.
These checkpoints are the result of further fine-tuning of the pre-trained base versions on instructions and conversational data.
This additional fine-tuning makes them a better choice for many NLP tasks.`,ht,E,Gs=`Let’s illustrate some simple prompts that you can use with <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow"><code>tiiuae/falcon-7b-instruct</code></a>
to solve some common NLP tasks.`,ct,z,Mt,S,Zs="First, let’s set up the environment:",ut,L,dt,A,ks="Next, let’s load the model with the appropriate pipeline (<code>&quot;text-generation&quot;</code>):",yt,P,wt,x,gt,D,Cs="Now that we have the model loaded via the pipeline, let’s explore how you can use prompts to solve NLP tasks.",jt,K,ft,O,Ws=`One of the most common forms of text classification is sentiment analysis, which assigns a label like “positive”, “negative”,
or “neutral” to a sequence of text. Let’s write a prompt that instructs the model to classify a given text (a movie review).
We’ll start by giving the instruction, and then specifying the text to classify. Note that instead of leaving it at that, we’re
also adding the beginning of the response - <code>&quot;Sentiment: &quot;</code>:`,bt,ee,Tt,te,Xs="As a result, the output contains a classification label from the list we have provided in the instructions, and it is a correct one!",Jt,I,Ut,se,vt,le,Hs=`Named Entity Recognition (NER) is a task of finding named entities in a piece of text, such as a person, location, or organization.
Let’s modify the instructions in the prompt to make the LLM perform this task. Here, let’s also set <code>return_full_text = False</code>
so that output doesn’t contain the prompt:`,xt,ae,It,ne,Vs="As you can see, the model correctly identified two named entities from the given text.",Bt,ie,$t,oe,Qs=`Another task LLMs can perform is translation. You can choose to use encoder-decoder models for this task, however, here,
for the simplicity of the examples, we’ll keep using Falcon-7b-instruct, which does a decent job. Once again, here’s how
you can write a basic prompt to instruct a model to translate a piece of text from English to Italian:`,Gt,pe,Zt,re,_s="Here we’ve added a <code>do_sample=True</code> and <code>top_k=10</code> to allow the model to be a bit more flexible when generating output.",kt,me,Ct,he,Rs=`Similar to the translation, text summarization is another generative task where the output <strong>heavily</strong> relies on the input,
and encoder-decoder models can be a better choice. However, decoder-style models can be used for this task as well.
Previously, we have placed the instructions at the very beginning of the prompt. However, the very end of the prompt can
also be a suitable location for instructions. Typically, it’s better to place the instruction on one of the extreme ends.`,Wt,ce,Xt,Me,Ht,ue,Fs=`For question answering task we can structure the prompt into the following logical components: instructions, context, question, and
the leading word or phrase (<code>&quot;Answer:&quot;</code>) to nudge the model to start generating the answer:`,Vt,de,Qt,ye,_t,we,qs=`Reasoning is one of the most difficult tasks for LLMs, and achieving good results often requires applying advanced prompting techniques, like
<a href="#chain-of-thought">Chain-of-though</a>.`,Rt,ge,Ns="Let’s try if we can make a model reason about a simple arithmetics task with a basic prompt:",Ft,je,qt,fe,Ys="Correct! Let’s increase the complexity a little and see if we can still get away with a basic prompt:",Nt,be,Yt,Te,Es=`This is a wrong answer, it should be 12. In this case, this can be due to the prompt being too basic, or due to the choice
of model, after all we’ve picked the smallest version of Falcon. Reasoning is difficult for models of all sizes, but larger
models are likely to perform better.`,Et,Je,zt,Ue,zs="In this section of the guide we have compiled a list of best practices that tend to improve the prompt results:",St,ve,Ss='<li>When choosing the model to work with, the latest and most capable models are likely to perform better.</li> <li>Start with a simple and short prompt, and iterate from there.</li> <li>Put the instructions at the beginning of the prompt, or at the very end. When working with large context, models apply various optimizations to prevent Attention complexity from scaling quadratically. This may make a model more attentive to the beginning or end of a prompt than the middle.</li> <li>Clearly separate instructions from the text they apply to - more on this in the next section.</li> <li>Be specific and descriptive about the task and the desired outcome - its format, length, style, language, etc.</li> <li>Avoid ambiguous descriptions and instructions.</li> <li>Favor instructions that say “what to do” instead of those that say “what not to do”.</li> <li>“Lead” the output in the right direction by writing the first word (or even begin the first sentence for the model).</li> <li>Use advanced techniques like <a href="#few-shot-prompting">Few-shot prompting</a> and <a href="#chain-of-thought">Chain-of-thought</a></li> <li>Test your prompts with different models to assess their robustness.</li> <li>Version and track the performance of your prompts.</li>',Lt,xe,At,Ie,Pt,Be,Ls=`The basic prompts in the sections above are the examples of “zero-shot” prompts, meaning, the model has been given
instructions and context, but no examples with solutions. LLMs that have been fine-tuned on instruction datasets, generally
perform well on such “zero-shot” tasks. However, you may find that your task has more complexity or nuance, and, perhaps,
you have some requirements for the output that the model doesn’t catch on just from the instructions. In this case, you can
try the technique called few-shot prompting.`,Dt,$e,As=`In few-shot prompting, we provide examples in the prompt giving the model more context to improve the performance.
The examples condition the model to generate the output following the patterns in the examples.`,Kt,Ge,Ps="Here’s an example:",Ot,Ze,es,ke,Ds=`In the above code snippet we used a single example to demonstrate the desired output to the model, so this can be called a
“one-shot” prompting. However, depending on the task complexity you may need to use more than one example.`,ts,Ce,Ks="Limitations of the few-shot prompting technique:",ss,We,Os="<li>While LLMs can pick up on the patterns in the examples, these technique doesn’t work well on complex reasoning tasks</li> <li>Few-shot prompting requires creating lengthy prompts. Prompts with large number of tokens can increase computation and latency. There’s also a limit to the length of the prompts.</li> <li>Sometimes when given a number of examples, models can learn patterns that you didn’t intend them to learn, e.g. that the third movie review is always negative.</li>",ls,Xe,as,He,el=`Chain-of-thought (CoT) prompting is a technique that nudges a model to produce intermediate reasoning steps thus improving
the results on complex reasoning tasks.`,ns,Ve,tl="There are two ways of steering a model to producing the reasoning steps:",is,Qe,sl="<li>few-shot prompting by illustrating examples with detailed answers to questions, showing the model how to work through a problem.</li> <li>by instructing the model to reason by adding phrases like “Let’s think step by step” or “Take a deep breath and work through the problem step by step.”</li>",os,_e,ll=`If we apply the CoT technique to the muffins example from the <a href="#reasoning">reasoning section</a> and use a larger model,
such as (<code>tiiuae/falcon-180B-chat</code>) which you can play with in the <a href="https://huggingface.co/chat/" rel="nofollow">HuggingChat</a>,
we’ll get a significant improvement on the reasoning result:`,ps,Re,rs,Fe,ms,qe,al=`You can achieve great results by optimizing your prompts, however, you may still ponder whether fine-tuning a model
would work better for your case. Here are some scenarios when fine-tuning a smaller model may be a preferred option:`,hs,Ne,nl="<li>Your domain is wildly different from what LLMs were pre-trained on and extensive prompt optimization did not yield sufficient results.</li> <li>You need your model to work well in a low-resource language.</li> <li>You need the model to be trained on sensitive data that is under strict regulations.</li> <li>You have to use a small model due to cost, privacy, infrastructure or other limitations.</li>",cs,Ye,il=`In all of the above examples, you will need to make sure that you either already have or can easily obtain a large enough
domain-specific dataset at a reasonable cost to fine-tune a model. You will also need to have enough time and resources
to fine-tune a model.`,Ms,Ee,ol="If the above examples are not the case for you, optimizing prompts can prove to be more beneficial.",us,ze,ds;return J=new g({props:{title:"LLM prompting guide",local:"llm-prompting-guide",headingTag:"h1"}}),T=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/prompting.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/prompting.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/prompting.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/prompting.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/prompting.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/prompting.ipynb"}]}}),v=new ys({props:{$$slots:{default:[bl]},$$scope:{ctx:U}}}),C=new g({props:{title:"Basics of prompting",local:"basics-of-prompting",headingTag:"h2"}}),W=new g({props:{title:"Types of models",local:"types-of-models",headingTag:"h3"}}),_=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwbW9kZWwlMjAlM0QlMjAnZ3B0MicpJTBBcHJvbXB0JTIwJTNEJTIwJTIySGVsbG8lMkMlMjBJJ20lMjBhJTIwbGFuZ3VhZ2UlMjBtb2RlbCUyMiUwQSUwQWdlbmVyYXRvcihwcm9tcHQlMkMlMjBtYXhfbGVuZ3RoJTIwJTNEJTIwMzAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&#x27;text-generation&#x27;</span>, model = <span class="hljs-string">&#x27;gpt2&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hello, I&#x27;m a language model&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt, max_length = <span class="hljs-number">30</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&quot;Hello, I&#x27;m a language model expert, so I&#x27;m a big believer in the concept that I know very well and then I try to look into&quot;</span>}]`,wrap:!1}}),F=new b({props:{code:"dGV4dDJ0ZXh0X2dlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlMjAlM0QlMjAnZ29vZ2xlJTJGZmxhbi10NS1iYXNlJyklMEFwcm9tcHQlMjAlM0QlMjAlMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwRnJlbmNoJTNBJTIwSSdtJTIwdmVyeSUyMGhhcHB5JTIwdG8lMjBzZWUlMjB5b3UlMjIlMEElMEF0ZXh0MnRleHRfZ2VuZXJhdG9yKHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text2text_generator = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model = <span class="hljs-string">&#x27;google/flan-t5-base&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Translate from English to French: I&#x27;m very happy to see you&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>text2text_generator(prompt)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Je suis très heureuse de vous rencontrer.&#x27;</span>}]`,wrap:!1}}),q=new g({props:{title:"Base vs instruct/chat models",local:"base-vs-instructchat-models",headingTag:"h3"}}),z=new g({props:{title:"NLP tasks",local:"nlp-tasks",headingTag:"h3"}}),L=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZQ==",highlighted:"pip install -q transformers accelerate",wrap:!1}}),P=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9yY2gubWFudWFsX3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMCUyMnRpaXVhZSUyRmZhbGNvbi03Yi1pbnN0cnVjdCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = <span class="hljs-string">&quot;tiiuae/falcon-7b-instruct&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),x=new ys({props:{$$slots:{default:[Tl]},$$scope:{ctx:U}}}),K=new g({props:{title:"Text classification",local:"text-classification",headingTag:"h4"}}),ee=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMCklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJDbGFzc2lmeSUyMHRoZSUyMHRleHQlMjBpbnRvJTIwbmV1dHJhbCUyQyUyMG5lZ2F0aXZlJTIwb3IlMjBwb3NpdGl2ZS4lMjAlMEFUZXh0JTNBJTIwVGhpcyUyMG1vdmllJTIwaXMlMjBkZWZpbml0ZWx5JTIwb25lJTIwb2YlMjBteSUyMGZhdm9yaXRlJTIwbW92aWVzJTIwb2YlMjBpdHMlMjBraW5kLiUyMFRoZSUyMGludGVyYWN0aW9uJTIwYmV0d2VlbiUyMHJlc3BlY3RhYmxlJTIwYW5kJTIwbW9yYWxseSUyMHN0cm9uZyUyMGNoYXJhY3RlcnMlMjBpcyUyMGFuJTIwb2RlJTIwdG8lMjBjaGl2YWxyeSUyMGFuZCUyMHRoZSUyMGhvbm9yJTIwY29kZSUyMGFtb25nc3QlMjB0aGlldmVzJTIwYW5kJTIwcG9saWNlbWVuLiUwQVNlbnRpbWVudCUzQSUwQSUyMiUyMiUyMiUwQSUwQXNlcXVlbmNlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJSZXN1bHQlM0ElMjAlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Classify the text into neutral, negative or positive. 
<span class="hljs-meta">... </span>Text: This movie is definitely one of my favorite movies of its kind. The interaction between respectable and morally strong characters is an ode to chivalry and the honor code amongst thieves and policemen.
<span class="hljs-meta">... </span>Sentiment:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: Classify the text into neutral, negative <span class="hljs-keyword">or</span> positive. 
Text: This movie <span class="hljs-keyword">is</span> definitely one of my favorite movies of its kind. The interaction between respectable <span class="hljs-keyword">and</span> morally strong characters <span class="hljs-keyword">is</span> an ode to chivalry <span class="hljs-keyword">and</span> the honor code amongst thieves <span class="hljs-keyword">and</span> policemen.
Sentiment:
Positive`,wrap:!1}}),I=new ys({props:{$$slots:{default:[Jl]},$$scope:{ctx:U}}}),se=new g({props:{title:"Named Entity Recognition",local:"named-entity-recognition",headingTag:"h4"}}),ae=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJSZXR1cm4lMjBhJTIwbGlzdCUyMG9mJTIwbmFtZWQlMjBlbnRpdGllcyUyMGluJTIwdGhlJTIwdGV4dC4lMEFUZXh0JTNBJTIwVGhlJTIwR29sZGVuJTIwU3RhdGUlMjBXYXJyaW9ycyUyMGFyZSUyMGFuJTIwQW1lcmljYW4lMjBwcm9mZXNzaW9uYWwlMjBiYXNrZXRiYWxsJTIwdGVhbSUyMGJhc2VkJTIwaW4lMjBTYW4lMjBGcmFuY2lzY28uJTBBTmFtZWQlMjBlbnRpdGllcyUzQSUwQSUyMiUyMiUyMiUwQSUwQXNlcXVlbmNlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxNSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9mdWxsX3RleHQlMjAlM0QlMjBGYWxzZSUyQyUyMCUyMCUyMCUyMCUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Return a list of named entities in the text.
<span class="hljs-meta">... </span>Text: The Golden State Warriors are an American professional basketball team based in San Francisco.
<span class="hljs-meta">... </span>Named entities:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,    
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
- Golden State Warriors
- San Francisco`,wrap:!1}}),ie=new g({props:{title:"Translation",local:"translation",headingTag:"h4"}}),pe=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMiklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJUcmFuc2xhdGUlMjB0aGUlMjBFbmdsaXNoJTIwdGV4dCUyMHRvJTIwSXRhbGlhbi4lMEFUZXh0JTNBJTIwU29tZXRpbWVzJTJDJTIwSSd2ZSUyMGJlbGlldmVkJTIwYXMlMjBtYW55JTIwYXMlMjBzaXglMjBpbXBvc3NpYmxlJTIwdGhpbmdzJTIwYmVmb3JlJTIwYnJlYWtmYXN0LiUwQVRyYW5zbGF0aW9uJTNBJTBBJTIyJTIyJTIyJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNEMTAlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTIwJTNEJTIwRmFsc2UlMkMlMEEpJTBBJTBBZm9yJTIwc2VxJTIwaW4lMjBzZXF1ZW5jZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCc2VxJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Translate the English text to Italian.
<span class="hljs-meta">... </span>Text: Sometimes, I&#x27;ve believed as many as six impossible things before breakfast.
<span class="hljs-meta">... </span>Translation:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
A volte, ho creduto a sei impossibili cose prima di colazione.`,wrap:!1}}),me=new g({props:{title:"Text summarization",local:"text-summarization",headingTag:"h4"}}),ce=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMyklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJQZXJtYWN1bHR1cmUlMjBpcyUyMGElMjBkZXNpZ24lMjBwcm9jZXNzJTIwbWltaWNraW5nJTIwdGhlJTIwZGl2ZXJzaXR5JTJDJTIwZnVuY3Rpb25hbGl0eSUyMGFuZCUyMHJlc2lsaWVuY2UlMjBvZiUyMG5hdHVyYWwlMjBlY29zeXN0ZW1zLiUyMFRoZSUyMHByaW5jaXBsZXMlMjBhbmQlMjBwcmFjdGljZXMlMjBhcmUlMjBkcmF3biUyMGZyb20lMjB0cmFkaXRpb25hbCUyMGVjb2xvZ2ljYWwlMjBrbm93bGVkZ2UlMjBvZiUyMGluZGlnZW5vdXMlMjBjdWx0dXJlcyUyMGNvbWJpbmVkJTIwd2l0aCUyMG1vZGVybiUyMHNjaWVudGlmaWMlMjB1bmRlcnN0YW5kaW5nJTIwYW5kJTIwdGVjaG5vbG9naWNhbCUyMGlubm92YXRpb25zLiUyMFBlcm1hY3VsdHVyZSUyMGRlc2lnbiUyMHByb3ZpZGVzJTIwYSUyMGZyYW1ld29yayUyMGhlbHBpbmclMjBpbmRpdmlkdWFscyUyMGFuZCUyMGNvbW11bml0aWVzJTIwZGV2ZWxvcCUyMGlubm92YXRpdmUlMkMlMjBjcmVhdGl2ZSUyMGFuZCUyMGVmZmVjdGl2ZSUyMHN0cmF0ZWdpZXMlMjBmb3IlMjBtZWV0aW5nJTIwYmFzaWMlMjBuZWVkcyUyMHdoaWxlJTIwcHJlcGFyaW5nJTIwZm9yJTIwYW5kJTIwbWl0aWdhdGluZyUyMHRoZSUyMHByb2plY3RlZCUyMGltcGFjdHMlMjBvZiUyMGNsaW1hdGUlMjBjaGFuZ2UuJTBBV3JpdGUlMjBhJTIwc3VtbWFyeSUyMG9mJTIwdGhlJTIwYWJvdmUlMjB0ZXh0LiUwQVN1bW1hcnklM0ElMEElMjIlMjIlMjIlMEElMEFzZXF1ZW5jZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9mdWxsX3RleHQlMjAlM0QlMjBGYWxzZSUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Permaculture is a design process mimicking the diversity, functionality and resilience of natural ecosystems. The principles and practices are drawn from traditional ecological knowledge of indigenous cultures combined with modern scientific understanding and technological innovations. Permaculture design provides a framework helping individuals and communities develop innovative, creative and effective strategies for meeting basic needs while preparing for and mitigating the projected impacts of climate change.
<span class="hljs-meta">... </span>Write a summary of the above text.
<span class="hljs-meta">... </span>Summary:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Permaculture <span class="hljs-keyword">is</span> an ecological design mimicking natural ecosystems to meet basic needs <span class="hljs-keyword">and</span> prepare <span class="hljs-keyword">for</span> climate change. It <span class="hljs-keyword">is</span> based on traditional knowledge <span class="hljs-keyword">and</span> scientific understanding.`,wrap:!1}}),Me=new g({props:{title:"Question answering",local:"question-answering",headingTag:"h4"}}),de=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoNCklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJBbnN3ZXIlMjB0aGUlMjBxdWVzdGlvbiUyMHVzaW5nJTIwdGhlJTIwY29udGV4dCUyMGJlbG93LiUwQUNvbnRleHQlM0ElMjBHYXpwYWNobyUyMGlzJTIwYSUyMGNvbGQlMjBzb3VwJTIwYW5kJTIwZHJpbmslMjBtYWRlJTIwb2YlMjByYXclMkMlMjBibGVuZGVkJTIwdmVnZXRhYmxlcy4lMjBNb3N0JTIwZ2F6cGFjaG8lMjBpbmNsdWRlcyUyMHN0YWxlJTIwYnJlYWQlMkMlMjB0b21hdG8lMkMlMjBjdWN1bWJlcnMlMkMlMjBvbmlvbiUyQyUyMGJlbGwlMjBwZXBwZXJzJTJDJTIwZ2FybGljJTJDJTIwb2xpdmUlMjBvaWwlMkMlMjB3aW5lJTIwdmluZWdhciUyQyUyMHdhdGVyJTJDJTIwYW5kJTIwc2FsdC4lMjBOb3J0aGVybiUyMHJlY2lwZXMlMjBvZnRlbiUyMGluY2x1ZGUlMjBjdW1pbiUyMGFuZCUyRm9yJTIwcGltZW50JUMzJUIzbiUyMChzbW9rZWQlMjBzd2VldCUyMHBhcHJpa2EpLiUyMFRyYWRpdGlvbmFsbHklMkMlMjBnYXpwYWNobyUyMHdhcyUyMG1hZGUlMjBieSUyMHBvdW5kaW5nJTIwdGhlJTIwdmVnZXRhYmxlcyUyMGluJTIwYSUyMG1vcnRhciUyMHdpdGglMjBhJTIwcGVzdGxlJTNCJTIwdGhpcyUyMG1vcmUlMjBsYWJvcmlvdXMlMjBtZXRob2QlMjBpcyUyMHN0aWxsJTIwc29tZXRpbWVzJTIwdXNlZCUyMGFzJTIwaXQlMjBoZWxwcyUyMGtlZXAlMjB0aGUlMjBnYXpwYWNobyUyMGNvb2wlMjBhbmQlMjBhdm9pZHMlMjB0aGUlMjBmb2FtJTIwYW5kJTIwc2lsa3klMjBjb25zaXN0ZW5jeSUyMG9mJTIwc21vb3RoaWUlMjB2ZXJzaW9ucyUyMG1hZGUlMjBpbiUyMGJsZW5kZXJzJTIwb3IlMjBmb29kJTIwcHJvY2Vzc29ycy4lMEFRdWVzdGlvbiUzQSUyMFdoYXQlMjBtb2Rlcm4lMjB0b29sJTIwaXMlMjB1c2VkJTIwdG8lMjBtYWtlJTIwZ2F6cGFjaG8lM0YlMEFBbnN3ZXIlM0ElMEElMjIlMjIlMjIlMEElMEFzZXF1ZW5jZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9mdWxsX3RleHQlMjAlM0QlMjBGYWxzZSUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJSZXN1bHQlM0ElMjAlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Answer the question using the context below.
<span class="hljs-meta">... </span>Context: Gazpacho is a cold soup and drink made of raw, blended vegetables. Most gazpacho includes stale bread, tomato, cucumbers, onion, bell peppers, garlic, olive oil, wine vinegar, water, and salt. Northern recipes often include cumin and/or pimentón (smoked sweet paprika). Traditionally, gazpacho was made by pounding the vegetables in a mortar with a pestle; this more laborious method is still sometimes used as it helps keep the gazpacho cool and avoids the foam and silky consistency of smoothie versions made in blenders or food processors.
<span class="hljs-meta">... </span>Question: What modern tool is used to make gazpacho?
<span class="hljs-meta">... </span>Answer:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: Modern tools are used, such <span class="hljs-keyword">as</span> immersion blenders`,wrap:!1}}),ye=new g({props:{title:"Reasoning",local:"reasoning",headingTag:"h4"}}),je=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoNSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJUaGVyZSUyMGFyZSUyMDUlMjBncm91cHMlMjBvZiUyMHN0dWRlbnRzJTIwaW4lMjB0aGUlMjBjbGFzcy4lMjBFYWNoJTIwZ3JvdXAlMjBoYXMlMjA0JTIwc3R1ZGVudHMuJTIwSG93JTIwbWFueSUyMHN0dWRlbnRzJTIwYXJlJTIwdGhlcmUlMjBpbiUyMHRoZSUyMGNsYXNzJTNGJTIyJTIyJTIyJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNEMTAlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTIwJTNEJTIwRmFsc2UlMkMlMEEpJTBBJTBBZm9yJTIwc2VxJTIwaW4lMjBzZXF1ZW5jZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUmVzdWx0JTNBJTIwJTdCc2VxJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;There are 5 groups of students in the class. Each group has 4 students. How many students are there in the class?&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: 
There are a total of <span class="hljs-number">5</span> groups, so there are <span class="hljs-number">5</span> x <span class="hljs-number">4</span>=<span class="hljs-number">20</span> students <span class="hljs-keyword">in</span> the <span class="hljs-keyword">class</span>.`,wrap:!1}}),be=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoNiklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJJJTIwYmFrZWQlMjAxNSUyMG11ZmZpbnMuJTIwSSUyMGF0ZSUyMDIlMjBtdWZmaW5zJTIwYW5kJTIwZ2F2ZSUyMDUlMjBtdWZmaW5zJTIwdG8lMjBhJTIwbmVpZ2hib3IuJTIwTXklMjBwYXJ0bmVyJTIwdGhlbiUyMGJvdWdodCUyMDYlMjBtb3JlJTIwbXVmZmlucyUyMGFuZCUyMGF0ZSUyMDIuJTIwSG93JTIwbWFueSUyMG11ZmZpbnMlMjBkbyUyMHdlJTIwbm93JTIwaGF2ZSUzRiUyMiUyMiUyMiUwQSUwQXNlcXVlbmNlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0b3BfayUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2Z1bGxfdGV4dCUyMCUzRCUyMEZhbHNlJTJDJTBBKSUwQSUwQWZvciUyMHNlcSUyMGluJTIwc2VxdWVuY2VzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlJlc3VsdCUzQSUyMCU3QnNlcSU1QidnZW5lcmF0ZWRfdGV4dCclNUQlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;I baked 15 muffins. I ate 2 muffins and gave 5 muffins to a neighbor. My partner then bought 6 more muffins and ate 2. How many muffins do we now have?&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: 
The total number of muffins now <span class="hljs-keyword">is</span> <span class="hljs-number">21</span>`,wrap:!1}}),Je=new g({props:{title:"Best practices of LLM prompting",local:"best-practices-of-llm-prompting",headingTag:"h2"}}),xe=new g({props:{title:"Advanced prompting techniques",local:"advanced-prompting-techniques",headingTag:"h2"}}),Ie=new g({props:{title:"Few-shot prompting",local:"few-shot-prompting",headingTag:"h3"}}),Ze=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMCklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJUZXh0JTNBJTIwVGhlJTIwZmlyc3QlMjBodW1hbiUyMHdlbnQlMjBpbnRvJTIwc3BhY2UlMjBhbmQlMjBvcmJpdGVkJTIwdGhlJTIwRWFydGglMjBvbiUyMEFwcmlsJTIwMTIlMkMlMjAxOTYxLiUwQURhdGUlM0ElMjAwNCUyRjEyJTJGMTk2MSUwQVRleHQlM0ElMjBUaGUlMjBmaXJzdC1ldmVyJTIwdGVsZXZpc2VkJTIwcHJlc2lkZW50aWFsJTIwZGViYXRlJTIwaW4lMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMlMjB0b29rJTIwcGxhY2UlMjBvbiUyMFNlcHRlbWJlciUyMDI4JTJDJTIwMTk2MCUyQyUyMGJldHdlZW4lMjBwcmVzaWRlbnRpYWwlMjBjYW5kaWRhdGVzJTIwSm9obiUyMEYuJTIwS2VubmVkeSUyMGFuZCUyMFJpY2hhcmQlMjBOaXhvbi4lMjAlMEFEYXRlJTNBJTIyJTIyJTIyJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDglMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QxMCUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJSZXN1bHQlM0ElMjAlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Text: The first human went into space and orbited the Earth on April 12, 1961.
<span class="hljs-meta">... </span>Date: 04/12/1961
<span class="hljs-meta">... </span>Text: The first-ever televised presidential debate in the United States took place on September 28, 1960, between presidential candidates John F. Kennedy and Richard Nixon. 
<span class="hljs-meta">... </span>Date:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: Text: The first human went into space <span class="hljs-keyword">and</span> orbited the Earth on April <span class="hljs-number">12</span>, <span class="hljs-number">1961.</span>
Date: 04/<span class="hljs-number">12</span>/<span class="hljs-number">1961</span>
Text: The first-ever televised presidential debate <span class="hljs-keyword">in</span> the United States took place on September <span class="hljs-number">28</span>, <span class="hljs-number">1960</span>, between presidential candidates John F. Kennedy <span class="hljs-keyword">and</span> Richard Nixon. 
Date: 09/<span class="hljs-number">28</span>/<span class="hljs-number">1960</span>`,wrap:!1}}),Xe=new g({props:{title:"Chain-of-thought",local:"chain-of-thought",headingTag:"h3"}}),Re=new b({props:{code:"TGV0J3MlMjBnbyUyMHRocm91Z2glMjB0aGlzJTIwc3RlcC1ieS1zdGVwJTNBJTBBMS4lMjBZb3UlMjBzdGFydCUyMHdpdGglMjAxNSUyMG11ZmZpbnMuJTBBMi4lMjBZb3UlMjBlYXQlMjAyJTIwbXVmZmlucyUyQyUyMGxlYXZpbmclMjB5b3UlMjB3aXRoJTIwMTMlMjBtdWZmaW5zLiUwQTMuJTIwWW91JTIwZ2l2ZSUyMDUlMjBtdWZmaW5zJTIwdG8lMjB5b3VyJTIwbmVpZ2hib3IlMkMlMjBsZWF2aW5nJTIweW91JTIwd2l0aCUyMDglMjBtdWZmaW5zLiUwQTQuJTIwWW91ciUyMHBhcnRuZXIlMjBidXlzJTIwNiUyMG1vcmUlMjBtdWZmaW5zJTJDJTIwYnJpbmdpbmclMjB0aGUlMjB0b3RhbCUyMG51bWJlciUyMG9mJTIwbXVmZmlucyUyMHRvJTIwMTQuJTBBNS4lMjBZb3VyJTIwcGFydG5lciUyMGVhdHMlMjAyJTIwbXVmZmlucyUyQyUyMGxlYXZpbmclMjB5b3UlMjB3aXRoJTIwMTIlMjBtdWZmaW5zLiUwQVRoZXJlZm9yZSUyQyUyMHlvdSUyMG5vdyUyMGhhdmUlMjAxMiUyMG11ZmZpbnMu",highlighted:`Let&#x27;s go through this step-by-step:
1. You start with 15 muffins.
2. You eat 2 muffins, leaving you with 13 muffins.
3. You give 5 muffins to your neighbor, leaving you with 8 muffins.
4. Your partner buys 6 more muffins, bringing the total number of muffins to 14.
5. Your partner eats 2 muffins, leaving you with 12 muffins.
Therefore, you now have 12 muffins.`,wrap:!1}}),Fe=new g({props:{title:"Prompting vs fine-tuning",local:"prompting-vs-fine-tuning",headingTag:"h2"}}),{c(){r=i("meta"),f=a(),y=i("p"),w=a(),m(J.$$.fragment),j=a(),m(T.$$.fragment),Se=a(),B=i("p"),B.textContent=gs,Le=a(),$=i("p"),$.textContent=js,Ae=a(),G=i("p"),G.textContent=fs,Pe=a(),Z=i("p"),Z.textContent=bs,De=a(),k=i("ul"),k.innerHTML=Ts,Ke=a(),m(v.$$.fragment),Oe=a(),m(C.$$.fragment),et=a(),m(W.$$.fragment),tt=a(),X=i("p"),X.innerHTML=Js,st=a(),H=i("p"),H.innerHTML=Us,lt=a(),V=i("p"),V.textContent=vs,at=a(),Q=i("p"),Q.innerHTML=xs,nt=a(),m(_.$$.fragment),it=a(),R=i("p"),R.innerHTML=Is,ot=a(),m(F.$$.fragment),pt=a(),m(q.$$.fragment),rt=a(),N=i("p"),N.innerHTML=Bs,mt=a(),Y=i("p"),Y.textContent=$s,ht=a(),E=i("p"),E.innerHTML=Gs,ct=a(),m(z.$$.fragment),Mt=a(),S=i("p"),S.textContent=Zs,ut=a(),m(L.$$.fragment),dt=a(),A=i("p"),A.innerHTML=ks,yt=a(),m(P.$$.fragment),wt=a(),m(x.$$.fragment),gt=a(),D=i("p"),D.textContent=Cs,jt=a(),m(K.$$.fragment),ft=a(),O=i("p"),O.innerHTML=Ws,bt=a(),m(ee.$$.fragment),Tt=a(),te=i("p"),te.textContent=Xs,Jt=a(),m(I.$$.fragment),Ut=a(),m(se.$$.fragment),vt=a(),le=i("p"),le.innerHTML=Hs,xt=a(),m(ae.$$.fragment),It=a(),ne=i("p"),ne.textContent=Vs,Bt=a(),m(ie.$$.fragment),$t=a(),oe=i("p"),oe.textContent=Qs,Gt=a(),m(pe.$$.fragment),Zt=a(),re=i("p"),re.innerHTML=_s,kt=a(),m(me.$$.fragment),Ct=a(),he=i("p"),he.innerHTML=Rs,Wt=a(),m(ce.$$.fragment),Xt=a(),m(Me.$$.fragment),Ht=a(),ue=i("p"),ue.innerHTML=Fs,Vt=a(),m(de.$$.fragment),Qt=a(),m(ye.$$.fragment),_t=a(),we=i("p"),we.innerHTML=qs,Rt=a(),ge=i("p"),ge.textContent=Ns,Ft=a(),m(je.$$.fragment),qt=a(),fe=i("p"),fe.textContent=Ys,Nt=a(),m(be.$$.fragment),Yt=a(),Te=i("p"),Te.textContent=Es,Et=a(),m(Je.$$.fragment),zt=a(),Ue=i("p"),Ue.textContent=zs,St=a(),ve=i("ul"),ve.innerHTML=Ss,Lt=a(),m(xe.$$.fragment),At=a(),m(Ie.$$.fragment),Pt=a(),Be=i("p"),Be.textContent=Ls,Dt=a(),$e=i("p"),$e.textContent=As,Kt=a(),Ge=i("p"),Ge.textContent=Ps,Ot=a(),m(Ze.$$.fragment),es=a(),ke=i("p"),ke.textContent=Ds,ts=a(),Ce=i("p"),Ce.textContent=Ks,ss=a(),We=i("ul"),We.innerHTML=Os,ls=a(),m(Xe.$$.fragment),as=a(),He=i("p"),He.textContent=el,ns=a(),Ve=i("p"),Ve.textContent=tl,is=a(),Qe=i("ul"),Qe.innerHTML=sl,os=a(),_e=i("p"),_e.innerHTML=ll,ps=a(),m(Re.$$.fragment),rs=a(),m(Fe.$$.fragment),ms=a(),qe=i("p"),qe.textContent=al,hs=a(),Ne=i("ul"),Ne.innerHTML=nl,cs=a(),Ye=i("p"),Ye.textContent=il,Ms=a(),Ee=i("p"),Ee.textContent=ol,us=a(),ze=i("p"),this.h()},l(e){const t=wl("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),f=n(e),y=o(e,"P",{}),hl(y).forEach(s),w=n(e),h(J.$$.fragment,e),j=n(e),h(T.$$.fragment,e),Se=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1ljgn3w"&&(B.textContent=gs),Le=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-18wgi3w"&&($.textContent=js),Ae=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-qy50g8"&&(G.textContent=fs),Pe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-9pzuyc"&&(Z.textContent=bs),De=n(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-3j1bb9"&&(k.innerHTML=Ts),Ke=n(e),h(v.$$.fragment,e),Oe=n(e),h(C.$$.fragment,e),et=n(e),h(W.$$.fragment,e),tt=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-nnu9ls"&&(X.innerHTML=Js),st=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-x23cxg"&&(H.innerHTML=Us),lt=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1yu9xal"&&(V.textContent=vs),at=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1ytddav"&&(Q.innerHTML=xs),nt=n(e),h(_.$$.fragment,e),it=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-7uki49"&&(R.innerHTML=Is),ot=n(e),h(F.$$.fragment,e),pt=n(e),h(q.$$.fragment,e),rt=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-i0l3du"&&(N.innerHTML=Bs),mt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-7kf9x0"&&(Y.textContent=$s),ht=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1afwrwd"&&(E.innerHTML=Gs),ct=n(e),h(z.$$.fragment,e),Mt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-uktc9k"&&(S.textContent=Zs),ut=n(e),h(L.$$.fragment,e),dt=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1rcm11q"&&(A.innerHTML=ks),yt=n(e),h(P.$$.fragment,e),wt=n(e),h(x.$$.fragment,e),gt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1qpoueu"&&(D.textContent=Cs),jt=n(e),h(K.$$.fragment,e),ft=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-5h15oc"&&(O.innerHTML=Ws),bt=n(e),h(ee.$$.fragment,e),Tt=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1vj09uj"&&(te.textContent=Xs),Jt=n(e),h(I.$$.fragment,e),Ut=n(e),h(se.$$.fragment,e),vt=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-17al9zp"&&(le.innerHTML=Hs),xt=n(e),h(ae.$$.fragment,e),It=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1lee3n3"&&(ne.textContent=Vs),Bt=n(e),h(ie.$$.fragment,e),$t=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-73k5zw"&&(oe.textContent=Qs),Gt=n(e),h(pe.$$.fragment,e),Zt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-hofrk3"&&(re.innerHTML=_s),kt=n(e),h(me.$$.fragment,e),Ct=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-14bqgsm"&&(he.innerHTML=Rs),Wt=n(e),h(ce.$$.fragment,e),Xt=n(e),h(Me.$$.fragment,e),Ht=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-7xjq21"&&(ue.innerHTML=Fs),Vt=n(e),h(de.$$.fragment,e),Qt=n(e),h(ye.$$.fragment,e),_t=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-qpdy2m"&&(we.innerHTML=qs),Rt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1enryru"&&(ge.textContent=Ns),Ft=n(e),h(je.$$.fragment,e),qt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-bfn0wi"&&(fe.textContent=Ys),Nt=n(e),h(be.$$.fragment,e),Yt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-n2catr"&&(Te.textContent=Es),Et=n(e),h(Je.$$.fragment,e),zt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-70cj29"&&(Ue.textContent=zs),St=n(e),ve=o(e,"UL",{"data-svelte-h":!0}),p(ve)!=="svelte-1m3ht2b"&&(ve.innerHTML=Ss),Lt=n(e),h(xe.$$.fragment,e),At=n(e),h(Ie.$$.fragment,e),Pt=n(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-113emw4"&&(Be.textContent=Ls),Dt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-f5haxx"&&($e.textContent=As),Kt=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-9gwuyp"&&(Ge.textContent=Ps),Ot=n(e),h(Ze.$$.fragment,e),es=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-12eqgvl"&&(ke.textContent=Ds),ts=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1oqsq7s"&&(Ce.textContent=Ks),ss=n(e),We=o(e,"UL",{"data-svelte-h":!0}),p(We)!=="svelte-1tv7al1"&&(We.innerHTML=Os),ls=n(e),h(Xe.$$.fragment,e),as=n(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-u5x5ge"&&(He.textContent=el),ns=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1s6z2yc"&&(Ve.textContent=tl),is=n(e),Qe=o(e,"UL",{"data-svelte-h":!0}),p(Qe)!=="svelte-9m9nfu"&&(Qe.innerHTML=sl),os=n(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-mc5q7v"&&(_e.innerHTML=ll),ps=n(e),h(Re.$$.fragment,e),rs=n(e),h(Fe.$$.fragment,e),ms=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-ezfyph"&&(qe.textContent=al),hs=n(e),Ne=o(e,"UL",{"data-svelte-h":!0}),p(Ne)!=="svelte-14be605"&&(Ne.innerHTML=nl),cs=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1cyrgd1"&&(Ye.textContent=il),Ms=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-oil4mc"&&(Ee.textContent=ol),us=n(e),ze=o(e,"P",{}),hl(ze).forEach(s),this.h()},h(){cl(r,"name","hf:doc:metadata"),cl(r,"content",vl)},m(e,t){gl(document.head,r),l(e,f,t),l(e,y,t),l(e,w,t),c(J,e,t),l(e,j,t),c(T,e,t),l(e,Se,t),l(e,B,t),l(e,Le,t),l(e,$,t),l(e,Ae,t),l(e,G,t),l(e,Pe,t),l(e,Z,t),l(e,De,t),l(e,k,t),l(e,Ke,t),c(v,e,t),l(e,Oe,t),c(C,e,t),l(e,et,t),c(W,e,t),l(e,tt,t),l(e,X,t),l(e,st,t),l(e,H,t),l(e,lt,t),l(e,V,t),l(e,at,t),l(e,Q,t),l(e,nt,t),c(_,e,t),l(e,it,t),l(e,R,t),l(e,ot,t),c(F,e,t),l(e,pt,t),c(q,e,t),l(e,rt,t),l(e,N,t),l(e,mt,t),l(e,Y,t),l(e,ht,t),l(e,E,t),l(e,ct,t),c(z,e,t),l(e,Mt,t),l(e,S,t),l(e,ut,t),c(L,e,t),l(e,dt,t),l(e,A,t),l(e,yt,t),c(P,e,t),l(e,wt,t),c(x,e,t),l(e,gt,t),l(e,D,t),l(e,jt,t),c(K,e,t),l(e,ft,t),l(e,O,t),l(e,bt,t),c(ee,e,t),l(e,Tt,t),l(e,te,t),l(e,Jt,t),c(I,e,t),l(e,Ut,t),c(se,e,t),l(e,vt,t),l(e,le,t),l(e,xt,t),c(ae,e,t),l(e,It,t),l(e,ne,t),l(e,Bt,t),c(ie,e,t),l(e,$t,t),l(e,oe,t),l(e,Gt,t),c(pe,e,t),l(e,Zt,t),l(e,re,t),l(e,kt,t),c(me,e,t),l(e,Ct,t),l(e,he,t),l(e,Wt,t),c(ce,e,t),l(e,Xt,t),c(Me,e,t),l(e,Ht,t),l(e,ue,t),l(e,Vt,t),c(de,e,t),l(e,Qt,t),c(ye,e,t),l(e,_t,t),l(e,we,t),l(e,Rt,t),l(e,ge,t),l(e,Ft,t),c(je,e,t),l(e,qt,t),l(e,fe,t),l(e,Nt,t),c(be,e,t),l(e,Yt,t),l(e,Te,t),l(e,Et,t),c(Je,e,t),l(e,zt,t),l(e,Ue,t),l(e,St,t),l(e,ve,t),l(e,Lt,t),c(xe,e,t),l(e,At,t),c(Ie,e,t),l(e,Pt,t),l(e,Be,t),l(e,Dt,t),l(e,$e,t),l(e,Kt,t),l(e,Ge,t),l(e,Ot,t),c(Ze,e,t),l(e,es,t),l(e,ke,t),l(e,ts,t),l(e,Ce,t),l(e,ss,t),l(e,We,t),l(e,ls,t),c(Xe,e,t),l(e,as,t),l(e,He,t),l(e,ns,t),l(e,Ve,t),l(e,is,t),l(e,Qe,t),l(e,os,t),l(e,_e,t),l(e,ps,t),c(Re,e,t),l(e,rs,t),c(Fe,e,t),l(e,ms,t),l(e,qe,t),l(e,hs,t),l(e,Ne,t),l(e,cs,t),l(e,Ye,t),l(e,Ms,t),l(e,Ee,t),l(e,us,t),l(e,ze,t),ds=!0},p(e,[t]){const pl={};t&2&&(pl.$$scope={dirty:t,ctx:e}),v.$set(pl);const rl={};t&2&&(rl.$$scope={dirty:t,ctx:e}),x.$set(rl);const ml={};t&2&&(ml.$$scope={dirty:t,ctx:e}),I.$set(ml)},i(e){ds||(M(J.$$.fragment,e),M(T.$$.fragment,e),M(v.$$.fragment,e),M(C.$$.fragment,e),M(W.$$.fragment,e),M(_.$$.fragment,e),M(F.$$.fragment,e),M(q.$$.fragment,e),M(z.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(x.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(I.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(de.$$.fragment,e),M(ye.$$.fragment,e),M(je.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),M(xe.$$.fragment,e),M(Ie.$$.fragment,e),M(Ze.$$.fragment,e),M(Xe.$$.fragment,e),M(Re.$$.fragment,e),M(Fe.$$.fragment,e),ds=!0)},o(e){u(J.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(_.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(x.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(I.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(de.$$.fragment,e),u(ye.$$.fragment,e),u(je.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(xe.$$.fragment,e),u(Ie.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),ds=!1},d(e){e&&(s(f),s(y),s(w),s(j),s(Se),s(B),s(Le),s($),s(Ae),s(G),s(Pe),s(Z),s(De),s(k),s(Ke),s(Oe),s(et),s(tt),s(X),s(st),s(H),s(lt),s(V),s(at),s(Q),s(nt),s(it),s(R),s(ot),s(pt),s(rt),s(N),s(mt),s(Y),s(ht),s(E),s(ct),s(Mt),s(S),s(ut),s(dt),s(A),s(yt),s(wt),s(gt),s(D),s(jt),s(ft),s(O),s(bt),s(Tt),s(te),s(Jt),s(Ut),s(vt),s(le),s(xt),s(It),s(ne),s(Bt),s($t),s(oe),s(Gt),s(Zt),s(re),s(kt),s(Ct),s(he),s(Wt),s(Xt),s(Ht),s(ue),s(Vt),s(Qt),s(_t),s(we),s(Rt),s(ge),s(Ft),s(qt),s(fe),s(Nt),s(Yt),s(Te),s(Et),s(zt),s(Ue),s(St),s(ve),s(Lt),s(At),s(Pt),s(Be),s(Dt),s($e),s(Kt),s(Ge),s(Ot),s(es),s(ke),s(ts),s(Ce),s(ss),s(We),s(ls),s(as),s(He),s(ns),s(Ve),s(is),s(Qe),s(os),s(_e),s(ps),s(rs),s(ms),s(qe),s(hs),s(Ne),s(cs),s(Ye),s(Ms),s(Ee),s(us),s(ze)),s(r),d(J,e),d(T,e),d(v,e),d(C,e),d(W,e),d(_,e),d(F,e),d(q,e),d(z,e),d(L,e),d(P,e),d(x,e),d(K,e),d(ee,e),d(I,e),d(se,e),d(ae,e),d(ie,e),d(pe,e),d(me,e),d(ce,e),d(Me,e),d(de,e),d(ye,e),d(je,e),d(be,e),d(Je,e),d(xe,e),d(Ie,e),d(Ze,e),d(Xe,e),d(Re,e),d(Fe,e)}}}const vl='{"title":"LLM prompting guide","local":"llm-prompting-guide","sections":[{"title":"Basics of prompting","local":"basics-of-prompting","sections":[{"title":"Types of models","local":"types-of-models","sections":[],"depth":3},{"title":"Base vs instruct/chat models","local":"base-vs-instructchat-models","sections":[],"depth":3},{"title":"NLP tasks","local":"nlp-tasks","sections":[{"title":"Text classification","local":"text-classification","sections":[],"depth":4},{"title":"Named Entity Recognition","local":"named-entity-recognition","sections":[],"depth":4},{"title":"Translation","local":"translation","sections":[],"depth":4},{"title":"Text summarization","local":"text-summarization","sections":[],"depth":4},{"title":"Question answering","local":"question-answering","sections":[],"depth":4},{"title":"Reasoning","local":"reasoning","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Best practices of LLM prompting","local":"best-practices-of-llm-prompting","sections":[],"depth":2},{"title":"Advanced prompting techniques","local":"advanced-prompting-techniques","sections":[{"title":"Few-shot prompting","local":"few-shot-prompting","sections":[],"depth":3},{"title":"Chain-of-thought","local":"chain-of-thought","sections":[],"depth":3}],"depth":2},{"title":"Prompting vs fine-tuning","local":"prompting-vs-fine-tuning","sections":[],"depth":2}],"depth":1}';function xl(U){return ul(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=jl}),[]}class Cl extends dl{constructor(r){super(),yl(this,r,xl,Ul,Ml,{})}}export{Cl as component};
