import{s as $n,o as kn,n as In}from"../chunks/scheduler.9bc65507.js";import{S as xn,i as Zn,g as p,s as l,r as c,A as vn,h as i,f as s,c as n,j as Cn,u as r,x as o,k as Nt,y as Vn,a,v as h,d as m,t as u,w as M}from"../chunks/index.707bf1b6.js";import{H as w,g as Gn}from"../chunks/Heading.9a412c8a.js";import{T as _n}from"../chunks/Tip.c2ecdbf4.js";import{C as d}from"../chunks/CodeBlock.54a9f38d.js";import{D as Bn}from"../chunks/DocNotebookDropdown.3e6b3817.js";function Wn(Ft){let j,k="To follow this guide you will need a GPU. If you’re working in a notebook, run the following line to check if a GPU is available:",T,g,f;return g=new d({props:{code:"IW52aWRpYS1zbWk=",highlighted:"!nvidia-smi",wrap:!1}}),{c(){j=p("p"),j.textContent=k,T=l(),c(g.$$.fragment)},l(y){j=i(y,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1qyctb1"&&(j.textContent=k),T=n(y),r(g.$$.fragment,y)},m(y,J){a(y,j,J),a(y,T,J),h(g,y,J),f=!0},p:In,i(y){f||(m(g.$$.fragment,y),f=!0)},o(y){u(g.$$.fragment,y),f=!1},d(y){y&&(s(j),s(T)),M(g,y)}}}function Rn(Ft){let j,k,T,g,f,y,J,qt,I,cl=`Text-to-speech (TTS) is the task of creating natural-sounding speech from text, where the speech can be generated in multiple
languages and for multiple speakers. Several text-to-speech models are currently available in 🤗 Transformers, such as
<a href="../model_doc/bark">Bark</a>, <a href="../model_doc/mms">MMS</a>, <a href="../model_doc/vits">VITS</a> and <a href="../model_doc/speecht5">SpeechT5</a>.`,Ht,x,rl=`You can easily generate audio using the <code>&quot;text-to-audio&quot;</code> pipeline (or its alias - <code>&quot;text-to-speech&quot;</code>). Some models, like Bark,
can also be conditioned to generate non-verbal communications such as laughing, sighing and crying, or even add music.
Here’s an example of how you would use the <code>&quot;text-to-speech&quot;</code> pipeline with Bark:`,At,Z,Et,v,hl="Here’s a code snippet you can use to listen to the resulting audio in a notebook:",St,V,Pt,G,ml=`For more examples on what Bark and other pretrained TTS models can do, refer to our
<a href="https://huggingface.co/learn/audio-course/chapter6/pre-trained_models" rel="nofollow">Audio course</a>.`,Lt,_,ul=`If you are looking to fine-tune a TTS model, you can currently fine-tune SpeechT5 only. SpeechT5 is pre-trained on a combination of
speech-to-text and text-to-speech data, allowing it to learn a unified space of hidden representations shared by both text
and speech. This means that the same pre-trained model can be fine-tuned for different tasks. Furthermore, SpeechT5
supports multiple speakers through x-vector speaker embeddings.`,Dt,B,Ml="The remainder of this guide illustrates how to:",Kt,W,dl='<li>Fine-tune <a href="../model_doc/speecht5">SpeechT5</a> that was originally trained on English speech on the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.</li> <li>Use your refined model for inference in one of two ways: using a pipeline or directly.</li>',Ot,R,yl="Before you begin, make sure you have all the necessary libraries installed:",es,X,ts,Y,jl="Install 🤗Transformers from source as not all the SpeechT5 features have been merged into an official release yet:",ss,z,as,b,ls,Q,gl="We encourage you to log in to your Hugging Face account to upload and share your model with the community. When prompted, enter your token to log in:",ns,N,ps,F,is,q,fl=`<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. In this guide, we are using the Dutch language subset, feel free to pick another subset.`,os,H,wl=`Note that VoxPopuli or any other automated speech recognition (ASR) dataset may not be the most suitable
option for training TTS models. The features that make it beneficial for ASR, such as excessive background noise, are
typically undesirable in TTS. However, finding top-quality, multilingual, and multi-speaker TTS datasets can be quite
challenging.`,cs,A,Jl="Let’s load the data:",rs,E,hs,S,Tl=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,ms,P,us,L,Ms,D,bl="Let’s begin by defining the model checkpoint to use and loading the appropriate processor:",ds,K,ys,O,js,ee,Ul="Start by cleaning up the text data. You’ll need the tokenizer part of the processor to process the text:",gs,te,fs,se,Cl=`The dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which feature to use as the text input,
consider that the SpeechT5 tokenizer doesn’t have any tokens for numbers. In <code>normalized_text</code> the numbers are written
out as text. Thus, it is a better fit, and we recommend using    <code>normalized_text</code> as input text.`,ws,ae,$l=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,Js,le,kl=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,Ts,ne,bs,pe,Il=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,Us,ie,Cs,oe,xl=`To handle the unsupported characters identified in the previous step, define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,$s,ce,ks,re,Zl="Now that you have dealt with special characters in the text, it’s time to shift focus to the audio data.",Is,he,xs,me,vl=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,Zs,ue,vs,Me,Vl="By plotting a histogram you can get a sense of how much data there is for each speaker.",Vs,de,Gs,U,Gl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',_s,ye,_l=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,Bs,je,Ws,ge,Bl="Let’s check how many speakers remain:",Rs,fe,Xs,we,Wl="Let’s see how many examples are left:",Ys,Je,zs,Te,Rl="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Qs,be,Xl=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Ns,Ue,Fs,Ce,Yl=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,qs,$e,zl=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,Hs,ke,As,Ie,Ql=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,Es,xe,Nl=`For optimal results, we recommend training an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language.`,Ss,Ze,Ps,ve,Fl=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,Ls,Ve,Ds,Ge,ql="Verify the processing is correct by looking at a single example:",Ks,_e,Os,Be,Hl="Speaker embeddings should be a 512-element vector:",ea,We,ta,Re,Al="The labels should be a log-mel spectrogram with 80 mel bins.",sa,Xe,aa,C,El='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',la,Ye,Sl=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,na,ze,Pl="Now apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",pa,Qe,ia,Ne,Ll=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,oa,Fe,ca,qe,Dl="Next, create a basic train/test split:",ra,He,ha,Ae,ma,Ee,Kl=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with the special value <code>-100</code>. This special value
instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,ua,Se,Ma,Pe,Ol=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,da,Le,ya,De,ja,Ke,en="Load the pre-trained model from the same checkpoint as you used for loading the processor:",ga,Oe,fa,et,tn="The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training.",wa,tt,Ja,st,sn=`Define the training arguments. Here we are not computing any evaluation metrics during the training process. Instead, we’ll
only look at the loss:`,Ta,at,ba,lt,an="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",Ua,nt,Ca,pt,ln=`And with that, you’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,$a,it,ka,ot,nn="To be able to use your checkpoint with a pipeline, make sure to save the processor with the checkpoint:",Ia,ct,xa,rt,pn="Push the final model to the 🤗 Hub:",Za,ht,va,mt,Va,ut,Ga,Mt,on=`Great, now that you’ve fine-tuned a model, you can use it for inference!
First, let’s see how you can use it with a corresponding pipeline. Let’s create a <code>&quot;text-to-speech&quot;</code> pipeline with your
checkpoint:`,_a,dt,Ba,yt,cn="Pick a piece of text in Dutch you’d like narrated, e.g.:",Wa,jt,Ra,gt,rn="To use SpeechT5 with the pipeline, you’ll need a speaker embedding. Let’s get it from an example in the test dataset:",Xa,ft,Ya,wt,hn="Now you can pass the text and speaker embeddings to the pipeline, and it will take care of the rest:",za,Jt,Qa,Tt,mn="You can then listen to the result:",Na,bt,Fa,Ut,qa,Ct,un="You can achieve the same inference results without using the pipeline, however, more steps will be required.",Ha,$t,Mn="Load the model from the 🤗 Hub:",Aa,kt,Ea,It,dn="Pick an example from the test dataset obtain a speaker embedding.",Sa,xt,Pa,Zt,yn="Define the input text and tokenize it.",La,vt,Da,Vt,jn="Create a spectrogram with your model:",Ka,Gt,Oa,_t,gn="Visualize the spectrogram, if you’d like to:",el,Bt,tl,$,fn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_2.png" alt="Generated log-mel spectrogram"/>',sl,Wt,wn="Finally, use the vocoder to turn the spectrogram into sound.",al,Rt,ll,Xt,Jn=`In our experience, obtaining satisfactory results from this model can be challenging. The quality of the speaker
embeddings appears to be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,nl,Yt,Tn=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,pl,zt,bn=`Finally, it is essential to consider ethical considerations. Although TTS technology has numerous useful applications, it
may also be used for malicious purposes, such as impersonating someone’s voice without their knowledge or consent. Please
use TTS judiciously and responsibly.`,il,Qt,ol;return f=new w({props:{title:"Text to speech",local:"text-to-speech",headingTag:"h1"}}),J=new Bn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"}]}}),Z=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJzdW5vJTJGYmFyay1zbWFsbCUyMiklMEF0ZXh0JTIwJTNEJTIwJTIyJTVCY2xlYXJzJTIwdGhyb2F0JTVEJTIwVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjAuLi4lMjBhbmQlMjBJJTIwanVzdCUyMHRvb2slMjBhJTIwbG9uZyUyMHBhdXNlLiUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGUodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;[clears throat] This is a test ... and I just took a long pause.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text)`,wrap:!1}}),V=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlMkMlMjByYXRlJTNEb3V0cHV0JTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),X=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install datasets soundfile speechbrain accelerate",wrap:!1}}),z=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdA==",highlighted:"pip install git+https://github.com/huggingface/transformers.git",wrap:!1}}),b=new _n({props:{$$slots:{default:[Wn]},$$scope:{ctx:Ft}}}),N=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),F=new w({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),E=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">20968</span>`,wrap:!1}}),P=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),L=new w({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),K=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),O=new w({props:{title:"Text cleanup for SpeechT5 tokenization",local:"text-cleanup-for-speecht5-tokenization",headingTag:"h3"}}),te=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer',wrap:!1}}),ne=new d({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
<span class="hljs-meta">... </span>    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


<span class="hljs-meta">&gt;&gt;&gt; </span>vocabs = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    extract_all_chars,
<span class="hljs-meta">... </span>    batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    keep_in_memory=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    remove_columns=dataset.column_names,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),ie=new d({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab - tokenizer_vocab
{<span class="hljs-string">&#x27; &#x27;</span>, <span class="hljs-string">&#x27;à&#x27;</span>, <span class="hljs-string">&#x27;ç&#x27;</span>, <span class="hljs-string">&#x27;è&#x27;</span>, <span class="hljs-string">&#x27;ë&#x27;</span>, <span class="hljs-string">&#x27;í&#x27;</span>, <span class="hljs-string">&#x27;ï&#x27;</span>, <span class="hljs-string">&#x27;ö&#x27;</span>, <span class="hljs-string">&#x27;ü&#x27;</span>}`,wrap:!1}}),ce=new d({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>replacements = [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
<span class="hljs-meta">... </span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
<span class="hljs-meta">... </span>        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),he=new w({props:{title:"Speakers",local:"speakers",headingTag:"h3"}}),ue=new d({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
<span class="hljs-meta">... </span>    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),de=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),je=new d({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),fe=new d({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))
<span class="hljs-number">42</span>`,wrap:!1}}),Je=new d({props:{code:"bGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">9973</span>`,wrap:!1}}),Ue=new w({props:{title:"Speaker embeddings",local:"speaker-embeddings",headingTag:"h3"}}),ke=new d({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

<span class="hljs-meta">&gt;&gt;&gt; </span>spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_model = EncoderClassifier.from_hparams(
<span class="hljs-meta">... </span>    source=spk_model_name,
<span class="hljs-meta">... </span>    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
<span class="hljs-meta">... </span>    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
<span class="hljs-meta">... </span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
<span class="hljs-meta">... </span>        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Ze=new w({props:{title:"Processing the dataset",local:"processing-the-dataset",headingTag:"h3"}}),Ve=new d({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">... </span>    example = processor(
<span class="hljs-meta">... </span>        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
<span class="hljs-meta">... </span>        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>        return_attention_mask=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-comment"># strip off the batch dimension</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),_e=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(processed_example.keys())
[<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;stop_labels&#x27;</span>, <span class="hljs-string">&#x27;speaker_embeddings&#x27;</span>]`,wrap:!1}}),We=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape
(<span class="hljs-number">512</span>,)`,wrap:!1}}),Xe=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),Qe=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Fe=new d({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
<span class="hljs-meta">... </span>    input_length = <span class="hljs-built_in">len</span>(input_ids)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">8259</span>`,wrap:!1}}),He=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Ae=new w({props:{title:"Data collator",local:"data-collator",headingTag:"h3"}}),Se=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
<span class="hljs-meta">... </span>    processor: <span class="hljs-type">Any</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
<span class="hljs-meta">... </span>        batch = processor.pad(input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># not used during fine-tuning</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>            target_lengths = torch.tensor([<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features])
<span class="hljs-meta">... </span>            target_lengths = target_lengths.new(
<span class="hljs-meta">... </span>                [length - length % model.config.reduction_factor <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths]
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            max_length = <span class="hljs-built_in">max</span>(target_lengths)
<span class="hljs-meta">... </span>            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># also add in the speaker embeddings</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Le=new d({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = TTSDataCollatorWithPadding(processor=processor)',wrap:!1}}),De=new w({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),Oe=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),tt=new d({props:{code:"bW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNl",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.use_cache = <span class="hljs-literal">False</span>',wrap:!1}}),at=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = Seq2SeqTrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">4000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),nt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Seq2SeqTrainer(
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),it=new d({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),ct=new d({props:{code:"cHJvY2Vzc29yLnNhdmVfcHJldHJhaW5lZCglMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>processor.save_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),ht=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),mt=new w({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ut=new w({props:{title:"Inference with a pipeline",local:"inference-with-a-pipeline",headingTag:"h3"}}),dt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)`,wrap:!1}}),jt=new d({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),ft=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Jt=new d({props:{code:"Zm9yd2FyZF9wYXJhbXMlMjAlM0QlMjAlN0IlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlM0ElMjBzcGVha2VyX2VtYmVkZGluZ3MlN0QlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHRleHQlMkMlMjBmb3J3YXJkX3BhcmFtcyUzRGZvcndhcmRfcGFyYW1zKSUwQW91dHB1dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>forward_params = {<span class="hljs-string">&quot;speaker_embeddings&quot;</span>: speaker_embeddings}
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text, forward_params=forward_params)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;audio&#x27;</span>: array([-<span class="hljs-number">6.82714235e-05</span>, -<span class="hljs-number">4.26525949e-04</span>,  <span class="hljs-number">1.06134125e-04</span>, ...,
        -<span class="hljs-number">1.22392643e-03</span>, -<span class="hljs-number">7.76011671e-04</span>,  <span class="hljs-number">3.29112721e-04</span>], dtype=float32),
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),bt=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJ2F1ZGlvJyU1RCUyQyUyMHJhdGUlM0RvdXRwdXQlNUInc2FtcGxpbmdfcmF0ZSclNUQpJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&#x27;audio&#x27;</span>], rate=output[<span class="hljs-string">&#x27;sampling_rate&#x27;</span>]) `,wrap:!1}}),Ut=new w({props:{title:"Run inference manually",local:"run-inference-manually",headingTag:"h3"}}),kt=new d({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),xt=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),vt=new d({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Gt=new d({props:{code:"c3BlY3Ryb2dyYW0lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZV9zcGVlY2goaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings)',wrap:!1}}),Bt=new d({props:{code:"cGx0LmZpZ3VyZSgpJTBBcGx0Lmltc2hvdyhzcGVjdHJvZ3JhbS5UKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(spectrogram.T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),Rt=new d({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyMCUzRCUyMHZvY29kZXIoc3BlY3Ryb2dyYW0pJTBBJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    speech = vocoder(spectrogram)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),{c(){j=p("meta"),k=l(),T=p("p"),g=l(),c(f.$$.fragment),y=l(),c(J.$$.fragment),qt=l(),I=p("p"),I.innerHTML=cl,Ht=l(),x=p("p"),x.innerHTML=rl,At=l(),c(Z.$$.fragment),Et=l(),v=p("p"),v.textContent=hl,St=l(),c(V.$$.fragment),Pt=l(),G=p("p"),G.innerHTML=ml,Lt=l(),_=p("p"),_.textContent=ul,Dt=l(),B=p("p"),B.textContent=Ml,Kt=l(),W=p("ol"),W.innerHTML=dl,Ot=l(),R=p("p"),R.textContent=yl,es=l(),c(X.$$.fragment),ts=l(),Y=p("p"),Y.textContent=jl,ss=l(),c(z.$$.fragment),as=l(),c(b.$$.fragment),ls=l(),Q=p("p"),Q.textContent=gl,ns=l(),c(N.$$.fragment),ps=l(),c(F.$$.fragment),is=l(),q=p("p"),q.innerHTML=fl,os=l(),H=p("p"),H.textContent=wl,cs=l(),A=p("p"),A.textContent=Jl,rs=l(),c(E.$$.fragment),hs=l(),S=p("p"),S.textContent=Tl,ms=l(),c(P.$$.fragment),us=l(),c(L.$$.fragment),Ms=l(),D=p("p"),D.textContent=bl,ds=l(),c(K.$$.fragment),ys=l(),c(O.$$.fragment),js=l(),ee=p("p"),ee.textContent=Ul,gs=l(),c(te.$$.fragment),fs=l(),se=p("p"),se.innerHTML=Cl,ws=l(),ae=p("p"),ae.innerHTML=$l,Js=l(),le=p("p"),le.innerHTML=kl,Ts=l(),c(ne.$$.fragment),bs=l(),pe=p("p"),pe.textContent=Il,Us=l(),c(ie.$$.fragment),Cs=l(),oe=p("p"),oe.innerHTML=xl,$s=l(),c(ce.$$.fragment),ks=l(),re=p("p"),re.textContent=Zl,Is=l(),c(he.$$.fragment),xs=l(),me=p("p"),me.textContent=vl,Zs=l(),c(ue.$$.fragment),vs=l(),Me=p("p"),Me.textContent=Vl,Vs=l(),c(de.$$.fragment),Gs=l(),U=p("div"),U.innerHTML=Gl,_s=l(),ye=p("p"),ye.textContent=_l,Bs=l(),c(je.$$.fragment),Ws=l(),ge=p("p"),ge.textContent=Bl,Rs=l(),c(fe.$$.fragment),Xs=l(),we=p("p"),we.textContent=Wl,Ys=l(),c(Je.$$.fragment),zs=l(),Te=p("p"),Te.textContent=Rl,Qs=l(),be=p("p"),be.textContent=Xl,Ns=l(),c(Ue.$$.fragment),Fs=l(),Ce=p("p"),Ce.innerHTML=Yl,qs=l(),$e=p("p"),$e.innerHTML=zl,Hs=l(),c(ke.$$.fragment),As=l(),Ie=p("p"),Ie.innerHTML=Ql,Es=l(),xe=p("p"),xe.textContent=Nl,Ss=l(),c(Ze.$$.fragment),Ps=l(),ve=p("p"),ve.innerHTML=Fl,Ls=l(),c(Ve.$$.fragment),Ds=l(),Ge=p("p"),Ge.textContent=ql,Ks=l(),c(_e.$$.fragment),Os=l(),Be=p("p"),Be.textContent=Hl,ea=l(),c(We.$$.fragment),ta=l(),Re=p("p"),Re.textContent=Al,sa=l(),c(Xe.$$.fragment),aa=l(),C=p("div"),C.innerHTML=El,la=l(),Ye=p("p"),Ye.textContent=Sl,na=l(),ze=p("p"),ze.textContent=Pl,pa=l(),c(Qe.$$.fragment),ia=l(),Ne=p("p"),Ne.textContent=Ll,oa=l(),c(Fe.$$.fragment),ca=l(),qe=p("p"),qe.textContent=Dl,ra=l(),c(He.$$.fragment),ha=l(),c(Ae.$$.fragment),ma=l(),Ee=p("p"),Ee.innerHTML=Kl,ua=l(),c(Se.$$.fragment),Ma=l(),Pe=p("p"),Pe.textContent=Ol,da=l(),c(Le.$$.fragment),ya=l(),c(De.$$.fragment),ja=l(),Ke=p("p"),Ke.textContent=en,ga=l(),c(Oe.$$.fragment),fa=l(),et=p("p"),et.innerHTML=tn,wa=l(),c(tt.$$.fragment),Ja=l(),st=p("p"),st.textContent=sn,Ta=l(),c(at.$$.fragment),ba=l(),lt=p("p"),lt.innerHTML=an,Ua=l(),c(nt.$$.fragment),Ca=l(),pt=p("p"),pt.innerHTML=ln,$a=l(),c(it.$$.fragment),ka=l(),ot=p("p"),ot.textContent=nn,Ia=l(),c(ct.$$.fragment),xa=l(),rt=p("p"),rt.textContent=pn,Za=l(),c(ht.$$.fragment),va=l(),c(mt.$$.fragment),Va=l(),c(ut.$$.fragment),Ga=l(),Mt=p("p"),Mt.innerHTML=on,_a=l(),c(dt.$$.fragment),Ba=l(),yt=p("p"),yt.textContent=cn,Wa=l(),c(jt.$$.fragment),Ra=l(),gt=p("p"),gt.textContent=rn,Xa=l(),c(ft.$$.fragment),Ya=l(),wt=p("p"),wt.textContent=hn,za=l(),c(Jt.$$.fragment),Qa=l(),Tt=p("p"),Tt.textContent=mn,Na=l(),c(bt.$$.fragment),Fa=l(),c(Ut.$$.fragment),qa=l(),Ct=p("p"),Ct.textContent=un,Ha=l(),$t=p("p"),$t.textContent=Mn,Aa=l(),c(kt.$$.fragment),Ea=l(),It=p("p"),It.textContent=dn,Sa=l(),c(xt.$$.fragment),Pa=l(),Zt=p("p"),Zt.textContent=yn,La=l(),c(vt.$$.fragment),Da=l(),Vt=p("p"),Vt.textContent=jn,Ka=l(),c(Gt.$$.fragment),Oa=l(),_t=p("p"),_t.textContent=gn,el=l(),c(Bt.$$.fragment),tl=l(),$=p("div"),$.innerHTML=fn,sl=l(),Wt=p("p"),Wt.textContent=wn,al=l(),c(Rt.$$.fragment),ll=l(),Xt=p("p"),Xt.textContent=Jn,nl=l(),Yt=p("p"),Yt.innerHTML=Tn,pl=l(),zt=p("p"),zt.textContent=bn,il=l(),Qt=p("p"),this.h()},l(e){const t=vn("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(s),k=n(e),T=i(e,"P",{}),Cn(T).forEach(s),g=n(e),r(f.$$.fragment,e),y=n(e),r(J.$$.fragment,e),qt=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-l8vv5f"&&(I.innerHTML=cl),Ht=n(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-onhyd5"&&(x.innerHTML=rl),At=n(e),r(Z.$$.fragment,e),Et=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-8r9uzp"&&(v.textContent=hl),St=n(e),r(V.$$.fragment,e),Pt=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-jff0e4"&&(G.innerHTML=ml),Lt=n(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-c5wqzo"&&(_.textContent=ul),Dt=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-13pgbx8"&&(B.textContent=Ml),Kt=n(e),W=i(e,"OL",{"data-svelte-h":!0}),o(W)!=="svelte-16nfhgc"&&(W.innerHTML=dl),Ot=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1c9nexd"&&(R.textContent=yl),es=n(e),r(X.$$.fragment,e),ts=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1pk9b4n"&&(Y.textContent=jl),ss=n(e),r(z.$$.fragment,e),as=n(e),r(b.$$.fragment,e),ls=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-yib87s"&&(Q.textContent=gl),ns=n(e),r(N.$$.fragment,e),ps=n(e),r(F.$$.fragment,e),is=n(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1lfskuv"&&(q.innerHTML=fl),os=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1smm6mj"&&(H.textContent=wl),cs=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1soaqfm"&&(A.textContent=Jl),rs=n(e),r(E.$$.fragment,e),hs=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1xdebij"&&(S.textContent=Tl),ms=n(e),r(P.$$.fragment,e),us=n(e),r(L.$$.fragment,e),Ms=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1cfkf3a"&&(D.textContent=bl),ds=n(e),r(K.$$.fragment,e),ys=n(e),r(O.$$.fragment,e),js=n(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1bseo5y"&&(ee.textContent=Ul),gs=n(e),r(te.$$.fragment,e),fs=n(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-alux34"&&(se.innerHTML=Cl),ws=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1qiuc1m"&&(ae.innerHTML=$l),Js=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-l4aof2"&&(le.innerHTML=kl),Ts=n(e),r(ne.$$.fragment,e),bs=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-fefaym"&&(pe.textContent=Il),Us=n(e),r(ie.$$.fragment,e),Cs=n(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1m7sgt2"&&(oe.innerHTML=xl),$s=n(e),r(ce.$$.fragment,e),ks=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-k1jzc5"&&(re.textContent=Zl),Is=n(e),r(he.$$.fragment,e),xs=n(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1edo483"&&(me.textContent=vl),Zs=n(e),r(ue.$$.fragment,e),vs=n(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1hah56a"&&(Me.textContent=Vl),Vs=n(e),r(de.$$.fragment,e),Gs=n(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1uufiik"&&(U.innerHTML=Gl),_s=n(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1ujf40"&&(ye.textContent=_l),Bs=n(e),r(je.$$.fragment,e),Ws=n(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-g2dd32"&&(ge.textContent=Bl),Rs=n(e),r(fe.$$.fragment,e),Xs=n(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-hbes5t"&&(we.textContent=Wl),Ys=n(e),r(Je.$$.fragment,e),zs=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-oizlk1"&&(Te.textContent=Rl),Qs=n(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1n0u7fp"&&(be.textContent=Xl),Ns=n(e),r(Ue.$$.fragment,e),Fs=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1xdfpy2"&&(Ce.innerHTML=Yl),qs=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-7nncma"&&($e.innerHTML=zl),Hs=n(e),r(ke.$$.fragment,e),As=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1mtxkxr"&&(Ie.innerHTML=Ql),Es=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1az2ed"&&(xe.textContent=Nl),Ss=n(e),r(Ze.$$.fragment,e),Ps=n(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1tlidee"&&(ve.innerHTML=Fl),Ls=n(e),r(Ve.$$.fragment,e),Ds=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-17mzfft"&&(Ge.textContent=ql),Ks=n(e),r(_e.$$.fragment,e),Os=n(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1mqg4ck"&&(Be.textContent=Hl),ea=n(e),r(We.$$.fragment,e),ta=n(e),Re=i(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-f7g58h"&&(Re.textContent=Al),sa=n(e),r(Xe.$$.fragment,e),aa=n(e),C=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-j4o1b8"&&(C.innerHTML=El),la=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1t9vz0y"&&(Ye.textContent=Sl),na=n(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1r5jy40"&&(ze.textContent=Pl),pa=n(e),r(Qe.$$.fragment,e),ia=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-wvyh3r"&&(Ne.textContent=Ll),oa=n(e),r(Fe.$$.fragment,e),ca=n(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-12gx63x"&&(qe.textContent=Dl),ra=n(e),r(He.$$.fragment,e),ha=n(e),r(Ae.$$.fragment,e),ma=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1qadcxm"&&(Ee.innerHTML=Kl),ua=n(e),r(Se.$$.fragment,e),Ma=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-u623yc"&&(Pe.textContent=Ol),da=n(e),r(Le.$$.fragment,e),ya=n(e),r(De.$$.fragment,e),ja=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1kkriue"&&(Ke.textContent=en),ga=n(e),r(Oe.$$.fragment,e),fa=n(e),et=i(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-15xsopr"&&(et.innerHTML=tn),wa=n(e),r(tt.$$.fragment,e),Ja=n(e),st=i(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-11l73nm"&&(st.textContent=sn),Ta=n(e),r(at.$$.fragment,e),ba=n(e),lt=i(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1yq1u47"&&(lt.innerHTML=an),Ua=n(e),r(nt.$$.fragment,e),Ca=n(e),pt=i(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1qh8b8v"&&(pt.innerHTML=ln),$a=n(e),r(it.$$.fragment,e),ka=n(e),ot=i(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-pldkg9"&&(ot.textContent=nn),Ia=n(e),r(ct.$$.fragment,e),xa=n(e),rt=i(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-hefgo2"&&(rt.textContent=pn),Za=n(e),r(ht.$$.fragment,e),va=n(e),r(mt.$$.fragment,e),Va=n(e),r(ut.$$.fragment,e),Ga=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1jgqgi3"&&(Mt.innerHTML=on),_a=n(e),r(dt.$$.fragment,e),Ba=n(e),yt=i(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1jnrzsv"&&(yt.textContent=cn),Wa=n(e),r(jt.$$.fragment,e),Ra=n(e),gt=i(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1kvctpa"&&(gt.textContent=rn),Xa=n(e),r(ft.$$.fragment,e),Ya=n(e),wt=i(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-n7ysoq"&&(wt.textContent=hn),za=n(e),r(Jt.$$.fragment,e),Qa=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-1rln9cy"&&(Tt.textContent=mn),Na=n(e),r(bt.$$.fragment,e),Fa=n(e),r(Ut.$$.fragment,e),qa=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1r1hsi3"&&(Ct.textContent=un),Ha=n(e),$t=i(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1ydpy0n"&&($t.textContent=Mn),Aa=n(e),r(kt.$$.fragment,e),Ea=n(e),It=i(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-fmd5zf"&&(It.textContent=dn),Sa=n(e),r(xt.$$.fragment,e),Pa=n(e),Zt=i(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1611eam"&&(Zt.textContent=yn),La=n(e),r(vt.$$.fragment,e),Da=n(e),Vt=i(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-eurn6"&&(Vt.textContent=jn),Ka=n(e),r(Gt.$$.fragment,e),Oa=n(e),_t=i(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-iofzmb"&&(_t.textContent=gn),el=n(e),r(Bt.$$.fragment,e),tl=n(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-16b2dt6"&&($.innerHTML=fn),sl=n(e),Wt=i(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-chmo02"&&(Wt.textContent=wn),al=n(e),r(Rt.$$.fragment,e),ll=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-1fdujzv"&&(Xt.textContent=Jn),nl=n(e),Yt=i(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-6lmfh0"&&(Yt.innerHTML=Tn),pl=n(e),zt=i(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1mo0fd"&&(zt.textContent=bn),il=n(e),Qt=i(e,"P",{}),Cn(Qt).forEach(s),this.h()},h(){Nt(j,"name","hf:doc:metadata"),Nt(j,"content",Xn),Nt(U,"class","flex justify-center"),Nt(C,"class","flex justify-center"),Nt($,"class","flex justify-center")},m(e,t){Vn(document.head,j),a(e,k,t),a(e,T,t),a(e,g,t),h(f,e,t),a(e,y,t),h(J,e,t),a(e,qt,t),a(e,I,t),a(e,Ht,t),a(e,x,t),a(e,At,t),h(Z,e,t),a(e,Et,t),a(e,v,t),a(e,St,t),h(V,e,t),a(e,Pt,t),a(e,G,t),a(e,Lt,t),a(e,_,t),a(e,Dt,t),a(e,B,t),a(e,Kt,t),a(e,W,t),a(e,Ot,t),a(e,R,t),a(e,es,t),h(X,e,t),a(e,ts,t),a(e,Y,t),a(e,ss,t),h(z,e,t),a(e,as,t),h(b,e,t),a(e,ls,t),a(e,Q,t),a(e,ns,t),h(N,e,t),a(e,ps,t),h(F,e,t),a(e,is,t),a(e,q,t),a(e,os,t),a(e,H,t),a(e,cs,t),a(e,A,t),a(e,rs,t),h(E,e,t),a(e,hs,t),a(e,S,t),a(e,ms,t),h(P,e,t),a(e,us,t),h(L,e,t),a(e,Ms,t),a(e,D,t),a(e,ds,t),h(K,e,t),a(e,ys,t),h(O,e,t),a(e,js,t),a(e,ee,t),a(e,gs,t),h(te,e,t),a(e,fs,t),a(e,se,t),a(e,ws,t),a(e,ae,t),a(e,Js,t),a(e,le,t),a(e,Ts,t),h(ne,e,t),a(e,bs,t),a(e,pe,t),a(e,Us,t),h(ie,e,t),a(e,Cs,t),a(e,oe,t),a(e,$s,t),h(ce,e,t),a(e,ks,t),a(e,re,t),a(e,Is,t),h(he,e,t),a(e,xs,t),a(e,me,t),a(e,Zs,t),h(ue,e,t),a(e,vs,t),a(e,Me,t),a(e,Vs,t),h(de,e,t),a(e,Gs,t),a(e,U,t),a(e,_s,t),a(e,ye,t),a(e,Bs,t),h(je,e,t),a(e,Ws,t),a(e,ge,t),a(e,Rs,t),h(fe,e,t),a(e,Xs,t),a(e,we,t),a(e,Ys,t),h(Je,e,t),a(e,zs,t),a(e,Te,t),a(e,Qs,t),a(e,be,t),a(e,Ns,t),h(Ue,e,t),a(e,Fs,t),a(e,Ce,t),a(e,qs,t),a(e,$e,t),a(e,Hs,t),h(ke,e,t),a(e,As,t),a(e,Ie,t),a(e,Es,t),a(e,xe,t),a(e,Ss,t),h(Ze,e,t),a(e,Ps,t),a(e,ve,t),a(e,Ls,t),h(Ve,e,t),a(e,Ds,t),a(e,Ge,t),a(e,Ks,t),h(_e,e,t),a(e,Os,t),a(e,Be,t),a(e,ea,t),h(We,e,t),a(e,ta,t),a(e,Re,t),a(e,sa,t),h(Xe,e,t),a(e,aa,t),a(e,C,t),a(e,la,t),a(e,Ye,t),a(e,na,t),a(e,ze,t),a(e,pa,t),h(Qe,e,t),a(e,ia,t),a(e,Ne,t),a(e,oa,t),h(Fe,e,t),a(e,ca,t),a(e,qe,t),a(e,ra,t),h(He,e,t),a(e,ha,t),h(Ae,e,t),a(e,ma,t),a(e,Ee,t),a(e,ua,t),h(Se,e,t),a(e,Ma,t),a(e,Pe,t),a(e,da,t),h(Le,e,t),a(e,ya,t),h(De,e,t),a(e,ja,t),a(e,Ke,t),a(e,ga,t),h(Oe,e,t),a(e,fa,t),a(e,et,t),a(e,wa,t),h(tt,e,t),a(e,Ja,t),a(e,st,t),a(e,Ta,t),h(at,e,t),a(e,ba,t),a(e,lt,t),a(e,Ua,t),h(nt,e,t),a(e,Ca,t),a(e,pt,t),a(e,$a,t),h(it,e,t),a(e,ka,t),a(e,ot,t),a(e,Ia,t),h(ct,e,t),a(e,xa,t),a(e,rt,t),a(e,Za,t),h(ht,e,t),a(e,va,t),h(mt,e,t),a(e,Va,t),h(ut,e,t),a(e,Ga,t),a(e,Mt,t),a(e,_a,t),h(dt,e,t),a(e,Ba,t),a(e,yt,t),a(e,Wa,t),h(jt,e,t),a(e,Ra,t),a(e,gt,t),a(e,Xa,t),h(ft,e,t),a(e,Ya,t),a(e,wt,t),a(e,za,t),h(Jt,e,t),a(e,Qa,t),a(e,Tt,t),a(e,Na,t),h(bt,e,t),a(e,Fa,t),h(Ut,e,t),a(e,qa,t),a(e,Ct,t),a(e,Ha,t),a(e,$t,t),a(e,Aa,t),h(kt,e,t),a(e,Ea,t),a(e,It,t),a(e,Sa,t),h(xt,e,t),a(e,Pa,t),a(e,Zt,t),a(e,La,t),h(vt,e,t),a(e,Da,t),a(e,Vt,t),a(e,Ka,t),h(Gt,e,t),a(e,Oa,t),a(e,_t,t),a(e,el,t),h(Bt,e,t),a(e,tl,t),a(e,$,t),a(e,sl,t),a(e,Wt,t),a(e,al,t),h(Rt,e,t),a(e,ll,t),a(e,Xt,t),a(e,nl,t),a(e,Yt,t),a(e,pl,t),a(e,zt,t),a(e,il,t),a(e,Qt,t),ol=!0},p(e,[t]){const Un={};t&2&&(Un.$$scope={dirty:t,ctx:e}),b.$set(Un)},i(e){ol||(m(f.$$.fragment,e),m(J.$$.fragment,e),m(Z.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(b.$$.fragment,e),m(N.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(P.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(je.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(ke.$$.fragment,e),m(Ze.$$.fragment,e),m(Ve.$$.fragment,e),m(_e.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(Qe.$$.fragment,e),m(Fe.$$.fragment,e),m(He.$$.fragment,e),m(Ae.$$.fragment,e),m(Se.$$.fragment,e),m(Le.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(it.$$.fragment,e),m(ct.$$.fragment,e),m(ht.$$.fragment,e),m(mt.$$.fragment,e),m(ut.$$.fragment,e),m(dt.$$.fragment,e),m(jt.$$.fragment,e),m(ft.$$.fragment,e),m(Jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ut.$$.fragment,e),m(kt.$$.fragment,e),m(xt.$$.fragment,e),m(vt.$$.fragment,e),m(Gt.$$.fragment,e),m(Bt.$$.fragment,e),m(Rt.$$.fragment,e),ol=!0)},o(e){u(f.$$.fragment,e),u(J.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(b.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),u(fe.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(_e.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Qe.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(Le.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(ct.$$.fragment,e),u(ht.$$.fragment,e),u(mt.$$.fragment,e),u(ut.$$.fragment,e),u(dt.$$.fragment,e),u(jt.$$.fragment,e),u(ft.$$.fragment,e),u(Jt.$$.fragment,e),u(bt.$$.fragment,e),u(Ut.$$.fragment,e),u(kt.$$.fragment,e),u(xt.$$.fragment,e),u(vt.$$.fragment,e),u(Gt.$$.fragment,e),u(Bt.$$.fragment,e),u(Rt.$$.fragment,e),ol=!1},d(e){e&&(s(k),s(T),s(g),s(y),s(qt),s(I),s(Ht),s(x),s(At),s(Et),s(v),s(St),s(Pt),s(G),s(Lt),s(_),s(Dt),s(B),s(Kt),s(W),s(Ot),s(R),s(es),s(ts),s(Y),s(ss),s(as),s(ls),s(Q),s(ns),s(ps),s(is),s(q),s(os),s(H),s(cs),s(A),s(rs),s(hs),s(S),s(ms),s(us),s(Ms),s(D),s(ds),s(ys),s(js),s(ee),s(gs),s(fs),s(se),s(ws),s(ae),s(Js),s(le),s(Ts),s(bs),s(pe),s(Us),s(Cs),s(oe),s($s),s(ks),s(re),s(Is),s(xs),s(me),s(Zs),s(vs),s(Me),s(Vs),s(Gs),s(U),s(_s),s(ye),s(Bs),s(Ws),s(ge),s(Rs),s(Xs),s(we),s(Ys),s(zs),s(Te),s(Qs),s(be),s(Ns),s(Fs),s(Ce),s(qs),s($e),s(Hs),s(As),s(Ie),s(Es),s(xe),s(Ss),s(Ps),s(ve),s(Ls),s(Ds),s(Ge),s(Ks),s(Os),s(Be),s(ea),s(ta),s(Re),s(sa),s(aa),s(C),s(la),s(Ye),s(na),s(ze),s(pa),s(ia),s(Ne),s(oa),s(ca),s(qe),s(ra),s(ha),s(ma),s(Ee),s(ua),s(Ma),s(Pe),s(da),s(ya),s(ja),s(Ke),s(ga),s(fa),s(et),s(wa),s(Ja),s(st),s(Ta),s(ba),s(lt),s(Ua),s(Ca),s(pt),s($a),s(ka),s(ot),s(Ia),s(xa),s(rt),s(Za),s(va),s(Va),s(Ga),s(Mt),s(_a),s(Ba),s(yt),s(Wa),s(Ra),s(gt),s(Xa),s(Ya),s(wt),s(za),s(Qa),s(Tt),s(Na),s(Fa),s(qa),s(Ct),s(Ha),s($t),s(Aa),s(Ea),s(It),s(Sa),s(Pa),s(Zt),s(La),s(Da),s(Vt),s(Ka),s(Oa),s(_t),s(el),s(tl),s($),s(sl),s(Wt),s(al),s(ll),s(Xt),s(nl),s(Yt),s(pl),s(zt),s(il),s(Qt)),s(j),M(f,e),M(J,e),M(Z,e),M(V,e),M(X,e),M(z,e),M(b,e),M(N,e),M(F,e),M(E,e),M(P,e),M(L,e),M(K,e),M(O,e),M(te,e),M(ne,e),M(ie,e),M(ce,e),M(he,e),M(ue,e),M(de,e),M(je,e),M(fe,e),M(Je,e),M(Ue,e),M(ke,e),M(Ze,e),M(Ve,e),M(_e,e),M(We,e),M(Xe,e),M(Qe,e),M(Fe,e),M(He,e),M(Ae,e),M(Se,e),M(Le,e),M(De,e),M(Oe,e),M(tt,e),M(at,e),M(nt,e),M(it,e),M(ct,e),M(ht,e),M(mt,e),M(ut,e),M(dt,e),M(jt,e),M(ft,e),M(Jt,e),M(bt,e),M(Ut,e),M(kt,e),M(xt,e),M(vt,e),M(Gt,e),M(Bt,e),M(Rt,e)}}}const Xn='{"title":"Text to speech","local":"text-to-speech","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[{"title":"Text cleanup for SpeechT5 tokenization","local":"text-cleanup-for-speecht5-tokenization","sections":[],"depth":3},{"title":"Speakers","local":"speakers","sections":[],"depth":3},{"title":"Speaker embeddings","local":"speaker-embeddings","sections":[],"depth":3},{"title":"Processing the dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Data collator","local":"data-collator","sections":[],"depth":3}],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Inference with a pipeline","local":"inference-with-a-pipeline","sections":[],"depth":3},{"title":"Run inference manually","local":"run-inference-manually","sections":[],"depth":3}],"depth":2}],"depth":1}';function Yn(Ft){return kn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Gn}),[]}class An extends xn{constructor(j){super(),Zn(this,j,Yn,Rn,$n,{})}}export{An as component};
