import{s as Oe,o as es,n as ss}from"../chunks/scheduler.36a0863c.js";import{S as as,i as ls,g as i,s as t,r as c,A as ts,h as p,f as a,c as n,j as Ke,u as m,x as r,k as Ce,y as ns,a as l,v as d,d as u,t as h,w as g}from"../chunks/index.9c13489a.js";import{H as O,g as is}from"../chunks/Heading.1b76b2ee.js";import{T as ps}from"../chunks/Tip.3b06990e.js";import{C as M}from"../chunks/CodeBlock.05d8ec32.js";function os(ee){let o,$="Echa un vistazo a la documentación de <code>pipeline()</code> para obtener una lista completa de tareas admitidas.";return{c(){o=i("p"),o.innerHTML=$},l(f){o=p(f,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1daerre"&&(o.innerHTML=$)},m(f,D){l(f,o,D)},p:ss,d(f){f&&a(o)}}}function rs(ee){let o,$,f,D,U,se,x,He='Un <code>pipeline()</code> simplifica el uso de cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> para la inferencia en una variedad de tareas como la generación de texto, la segmentación de imágenes y la clasificación de audio. Incluso si no tienes experiencia con una modalidad específica o no comprendes el código que alimenta los modelos, ¡aún puedes usarlos con el <code>pipeline()</code>! Este tutorial te enseñará a:',ae,T,_e="<li>Utilizar un <code>pipeline()</code> para inferencia.</li> <li>Utilizar un tokenizador o modelo específico.</li> <li>Utilizar un <code>pipeline()</code> para tareas de audio y visión.</li>",le,y,te,w,ne,b,Ve="Si bien cada tarea tiene un <code>pipeline()</code> asociado, es más sencillo usar la abstracción general <code>pipeline()</code> que contiene todos los pipelines de tareas específicas. El <code>pipeline()</code> carga automáticamente un modelo predeterminado y un tokenizador con capacidad de inferencia para tu tarea.",ie,J,qe="<li>Comienza creando un <code>pipeline()</code> y específica una tarea de inferencia:</li>",pe,v,oe,j,ze="<li>Pasa tu texto de entrada al <code>pipeline()</code>:</li>",re,Z,ce,k,Le="Si tienes más de una entrada, pásala como una lista:",me,G,de,I,Re="Cualquier parámetro adicional para tu tarea también se puede incluir en el <code>pipeline()</code>. La tarea <code>text-generation</code> tiene un método <code>generate()</code> con varios parámetros para controlar la salida. Por ejemplo, si deseas generar más de una salida, defínelo en el parámetro <code>num_return_sequences</code>:",ue,W,he,B,ge,C,Xe='El <code>pipeline()</code> acepta cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Hay etiquetas en el Model Hub que te permiten filtrar por el modelo que te gustaría utilizar para tu tarea. Una vez que hayas elegido un modelo apropiado, cárgalo con la clase <code>AutoModelFor</code> y <code>AutoTokenizer</code> correspondientes. Por ejemplo, carga la clase <code>AutoModelForCausalLM</code> para una tarea de modelado de lenguaje causal:',fe,H,Me,_,Ee="Crea un <code>pipeline()</code> para tu tarea y específica el modelo y el tokenizador que cargaste:",ye,V,je,q,Pe="Pasa tu texto de entrada a <code>pipeline()</code> para generar algo de texto:",$e,z,Ue,L,xe,R,Se="La flexibilidad de <code>pipeline()</code> significa que también se puede extender a tareas de audio.",Te,X,Ye='Por ejemplo, clasifiquemos la emoción de un breve fragmento del famoso discurso de John F. Kennedy <a href="https://en.wikipedia.org/wiki/We_choose_to_go_to_the_Moon" rel="nofollow">“We choose to go to the Moon”</a>. Encuentra un modelo de <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">audio classification</a> para reconocimiento de emociones en el Model Hub y cárgalo en el <code>pipeline()</code>:',we,E,be,P,Fe="Pasa el archivo de audio al <code>pipeline()</code>:",Je,S,ve,Y,Ze,F,Ae="Finalmente, utilizar un <code>pipeline()</code> para tareas de visión es prácticamente igual.",ke,A,Ne="Específica tu tarea de visión y pasa tu imagen al clasificador. La imagen puede ser un enlace o una ruta local a la imagen. Por ejemplo, ¿qué especie de gato se muestra a continuación?",Ge,N,Qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Ie,Q,We,K,Be;return U=new O({props:{title:"Pipelines para inferencia",local:"pipelines-para-inferencia",headingTag:"h1"}}),y=new ps({props:{$$slots:{default:[os]},$$scope:{ctx:ee}}}),w=new O({props:{title:"Uso del pipeline",local:"uso-del-pipeline",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),G=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new O({props:{title:"Selecciona un modelo y un tokenizador",local:"selecciona-un-modelo-y-un-tokenizador",headingTag:"h3"}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)`,wrap:!1}}),V=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),z=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),L=new O({props:{title:"Pipeline de audio",local:"pipeline-de-audio",headingTag:"h2"}}),E=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),S=new M({props:{code:"YXVkaW9fY2xhc3NpZmllciglMjJqZmtfbW9vbl9zcGVlY2gud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier(<span class="hljs-string">&quot;jfk_moon_speech.wav&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13856211304664612</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;disgust&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13148026168346405</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12635163962841034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;angry&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12439591437578201</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12404385954141617</span>}]`,wrap:!1}}),Y=new O({props:{title:"Pipeline de visión",local:"pipeline-de-visión",headingTag:"h2"}}),Q=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4403027892112732</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03433405980467796</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.032148055732250214</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.02353910356760025</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.023034192621707916</span>}]`,wrap:!1}}),{c(){o=i("meta"),$=t(),f=i("p"),D=t(),c(U.$$.fragment),se=t(),x=i("p"),x.innerHTML=He,ae=t(),T=i("ul"),T.innerHTML=_e,le=t(),c(y.$$.fragment),te=t(),c(w.$$.fragment),ne=t(),b=i("p"),b.innerHTML=Ve,ie=t(),J=i("ol"),J.innerHTML=qe,pe=t(),c(v.$$.fragment),oe=t(),j=i("ol"),j.innerHTML=ze,re=t(),c(Z.$$.fragment),ce=t(),k=i("p"),k.textContent=Le,me=t(),c(G.$$.fragment),de=t(),I=i("p"),I.innerHTML=Re,ue=t(),c(W.$$.fragment),he=t(),c(B.$$.fragment),ge=t(),C=i("p"),C.innerHTML=Xe,fe=t(),c(H.$$.fragment),Me=t(),_=i("p"),_.innerHTML=Ee,ye=t(),c(V.$$.fragment),je=t(),q=i("p"),q.innerHTML=Pe,$e=t(),c(z.$$.fragment),Ue=t(),c(L.$$.fragment),xe=t(),R=i("p"),R.innerHTML=Se,Te=t(),X=i("p"),X.innerHTML=Ye,we=t(),c(E.$$.fragment),be=t(),P=i("p"),P.innerHTML=Fe,Je=t(),c(S.$$.fragment),ve=t(),c(Y.$$.fragment),Ze=t(),F=i("p"),F.innerHTML=Ae,ke=t(),A=i("p"),A.textContent=Ne,Ge=t(),N=i("p"),N.innerHTML=Qe,Ie=t(),c(Q.$$.fragment),We=t(),K=i("p"),this.h()},l(e){const s=ts("svelte-u9bgzb",document.head);o=p(s,"META",{name:!0,content:!0}),s.forEach(a),$=n(e),f=p(e,"P",{}),Ke(f).forEach(a),D=n(e),m(U.$$.fragment,e),se=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1k5gyag"&&(x.innerHTML=He),ae=n(e),T=p(e,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-7f1ymp"&&(T.innerHTML=_e),le=n(e),m(y.$$.fragment,e),te=n(e),m(w.$$.fragment,e),ne=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-gjt1nl"&&(b.innerHTML=Ve),ie=n(e),J=p(e,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-yki1ef"&&(J.innerHTML=qe),pe=n(e),m(v.$$.fragment,e),oe=n(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1e6diuh"&&(j.innerHTML=ze),re=n(e),m(Z.$$.fragment,e),ce=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-wgq0wk"&&(k.textContent=Le),me=n(e),m(G.$$.fragment,e),de=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-183jawq"&&(I.innerHTML=Re),ue=n(e),m(W.$$.fragment,e),he=n(e),m(B.$$.fragment,e),ge=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1sfnia5"&&(C.innerHTML=Xe),fe=n(e),m(H.$$.fragment,e),Me=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-15my78f"&&(_.innerHTML=Ee),ye=n(e),m(V.$$.fragment,e),je=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1qfapyh"&&(q.innerHTML=Pe),$e=n(e),m(z.$$.fragment,e),Ue=n(e),m(L.$$.fragment,e),xe=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-q0unz9"&&(R.innerHTML=Se),Te=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-5ycnhq"&&(X.innerHTML=Ye),we=n(e),m(E.$$.fragment,e),be=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1nrtv5e"&&(P.innerHTML=Fe),Je=n(e),m(S.$$.fragment,e),ve=n(e),m(Y.$$.fragment,e),Ze=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1na9ujt"&&(F.innerHTML=Ae),ke=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-j2gvop"&&(A.textContent=Ne),Ge=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1bks2jw"&&(N.innerHTML=Qe),Ie=n(e),m(Q.$$.fragment,e),We=n(e),K=p(e,"P",{}),Ke(K).forEach(a),this.h()},h(){Ce(o,"name","hf:doc:metadata"),Ce(o,"content",cs),Ce(j,"start","2")},m(e,s){ns(document.head,o),l(e,$,s),l(e,f,s),l(e,D,s),d(U,e,s),l(e,se,s),l(e,x,s),l(e,ae,s),l(e,T,s),l(e,le,s),d(y,e,s),l(e,te,s),d(w,e,s),l(e,ne,s),l(e,b,s),l(e,ie,s),l(e,J,s),l(e,pe,s),d(v,e,s),l(e,oe,s),l(e,j,s),l(e,re,s),d(Z,e,s),l(e,ce,s),l(e,k,s),l(e,me,s),d(G,e,s),l(e,de,s),l(e,I,s),l(e,ue,s),d(W,e,s),l(e,he,s),d(B,e,s),l(e,ge,s),l(e,C,s),l(e,fe,s),d(H,e,s),l(e,Me,s),l(e,_,s),l(e,ye,s),d(V,e,s),l(e,je,s),l(e,q,s),l(e,$e,s),d(z,e,s),l(e,Ue,s),d(L,e,s),l(e,xe,s),l(e,R,s),l(e,Te,s),l(e,X,s),l(e,we,s),d(E,e,s),l(e,be,s),l(e,P,s),l(e,Je,s),d(S,e,s),l(e,ve,s),d(Y,e,s),l(e,Ze,s),l(e,F,s),l(e,ke,s),l(e,A,s),l(e,Ge,s),l(e,N,s),l(e,Ie,s),d(Q,e,s),l(e,We,s),l(e,K,s),Be=!0},p(e,[s]){const De={};s&2&&(De.$$scope={dirty:s,ctx:e}),y.$set(De)},i(e){Be||(u(U.$$.fragment,e),u(y.$$.fragment,e),u(w.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),Be=!0)},o(e){h(U.$$.fragment,e),h(y.$$.fragment,e),h(w.$$.fragment,e),h(v.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(z.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),Be=!1},d(e){e&&(a($),a(f),a(D),a(se),a(x),a(ae),a(T),a(le),a(te),a(ne),a(b),a(ie),a(J),a(pe),a(oe),a(j),a(re),a(ce),a(k),a(me),a(de),a(I),a(ue),a(he),a(ge),a(C),a(fe),a(Me),a(_),a(ye),a(je),a(q),a($e),a(Ue),a(xe),a(R),a(Te),a(X),a(we),a(be),a(P),a(Je),a(ve),a(Ze),a(F),a(ke),a(A),a(Ge),a(N),a(Ie),a(We),a(K)),a(o),g(U,e),g(y,e),g(w,e),g(v,e),g(Z,e),g(G,e),g(W,e),g(B,e),g(H,e),g(V,e),g(z,e),g(L,e),g(E,e),g(S,e),g(Y,e),g(Q,e)}}}const cs='{"title":"Pipelines para inferencia","local":"pipelines-para-inferencia","sections":[{"title":"Uso del pipeline","local":"uso-del-pipeline","sections":[{"title":"Selecciona un modelo y un tokenizador","local":"selecciona-un-modelo-y-un-tokenizador","sections":[],"depth":3}],"depth":2},{"title":"Pipeline de audio","local":"pipeline-de-audio","sections":[],"depth":2},{"title":"Pipeline de visión","local":"pipeline-de-visión","sections":[],"depth":2}],"depth":1}';function ms(ee){return es(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=is}),[]}class Ms extends as{constructor(o){super(),ls(this,o,ms,rs,Oe,{})}}export{Ms as component};
