import{s as zs,o as Gs,n as Fl}from"../chunks/scheduler.36a0863c.js";import{S as Es,i as Vs,g as o,s as a,r as d,A as Ys,h as i,f as s,c as n,j as Ws,u as p,x as r,k as Xs,y as Qs,a as t,v as M,d as m,t as u,w as y}from"../chunks/index.9c13489a.js";import{H as ke,g as Hs}from"../chunks/Heading.1b76b2ee.js";import{T as xl}from"../chunks/Tip.3b06990e.js";import{C as T}from"../chunks/CodeBlock.05d8ec32.js";function qs(j){let c,w="Si tu modelo es muy similar a un modelo dentro de la biblioteca, puedes reutilizar la misma configuración de ese modelo.";return{c(){c=o("p"),c.textContent=w},l(J){c=i(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-143ofzf"&&(c.textContent=w)},m(J,f){t(J,c,f)},p:Fl,d(J){J&&s(c)}}}function xs(j){let c,w="Esta <em>API</em> es experimental y puede tener algunos cambios leves en las próximas versiones.";return{c(){c=o("p"),c.innerHTML=w},l(J){c=i(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1qtj9q"&&(c.innerHTML=w)},m(J,f){t(J,c,f)},p:Fl,d(J){J&&s(c)}}}function Fs(j){let c,w=`Si copias archivos del modelo desde la biblioteca, deberás reemplazar todas las importaciones relativas en la parte superior
del archivo para importarlos desde el paquete <code>transformers</code>.`;return{c(){c=o("p"),c.innerHTML=w},l(J){c=i(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-n79je1"&&(c.innerHTML=w)},m(J,f){t(J,c,f)},p:Fl,d(J){J&&s(c)}}}function Ls(j){let c,w,J,f,I,Be,g,Ll=`La biblioteca 🤗 Transformers está diseñada para ser fácilmente ampliable. Cada modelo está completamente codificado
sin abstracción en una subcarpeta determinada del repositorio, por lo que puedes copiar fácilmente un archivo del modelo
y ajustarlo según tus necesidades.`,Re,Z,Sl=`Si estás escribiendo un modelo completamente nuevo, podría ser más fácil comenzar desde cero. En este tutorial, te mostraremos
cómo escribir un modelo personalizado y su configuración para que pueda usarse dentro de Transformers, y cómo puedes compartirlo
con la comunidad (con el código en el que se basa) para que cualquiera pueda usarlo, incluso si no está presente en la biblioteca
🤗 Transformers.`,We,_,Pl='Ilustraremos todo esto con un modelo ResNet, envolviendo la clase ResNet de la <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">biblioteca timm</a> en un <code>PreTrainedModel</code>.',Xe,h,ze,v,Dl=`Antes de adentrarnos en el modelo, primero escribamos su configuración. La configuración de un modelo es un objeto que
contendrá toda la información necesaria para construir el modelo. Como veremos en la siguiente sección, el modelo solo puede
tomar un <code>config</code> para ser inicializado, por lo que realmente necesitamos que ese objeto esté lo más completo posible.`,Ge,A,Kl=`En nuestro ejemplo, tomaremos un par de argumentos de la clase ResNet que tal vez queramos modificar. Las diferentes
configuraciones nos darán los diferentes tipos de ResNet que son posibles. Luego simplemente almacenamos esos argumentos
después de verificar la validez de algunos de ellos.`,Ee,$,Ve,k,Ol="Las tres cosas importantes que debes recordar al escribir tu propia configuración son las siguientes:",Ye,N,es="<li>tienes que heredar de <code>PretrainedConfig</code>,</li> <li>el <code>__init__</code> de tu <code>PretrainedConfig</code> debe aceptar cualquier <code>kwargs</code>,</li> <li>esos <code>kwargs</code> deben pasarse a la superclase <code>__init__</code>.</li>",Qe,B,ls=`La herencia es para asegurarte de obtener toda la funcionalidad de la biblioteca 🤗 Transformers, mientras que las otras dos
restricciones provienen del hecho de que una <code>PretrainedConfig</code> tiene más campos que los que estás configurando. Al recargar una
<code>config</code> con el método <code>from_pretrained</code>, esos campos deben ser aceptados por tu <code>config</code> y luego enviados a la superclase.`,He,R,ss=`Definir un <code>model_type</code> para tu configuración (en este caso <code>model_type=&quot;resnet&quot;</code>) no es obligatorio, a menos que quieras
registrar tu modelo con las clases automáticas (ver la última sección).`,qe,W,ts=`Una vez hecho esto, puedes crear y guardar fácilmente tu configuración como lo harías con cualquier otra configuración de un
modelo de la biblioteca. Así es como podemos crear una configuración resnet50d y guardarla:`,xe,X,Fe,z,as=`Esto guardará un archivo llamado <code>config.json</code> dentro de la carpeta <code>custom-resnet</code>. Luego puedes volver a cargar tu configuración
con el método <code>from_pretrained</code>:`,Le,G,Se,E,ns=`También puedes usar cualquier otro método de la clase <code>PretrainedConfig</code>, como <code>push_to_hub()</code>, para cargar
directamente tu configuración en el Hub.`,Pe,V,De,Y,os=`Ahora que tenemos nuestra configuración de ResNet, podemos seguir escribiendo el modelo. En realidad escribiremos dos: una que
extrae las características ocultas de un grupo de imágenes (como <code>BertModel</code>) y una que es adecuada para clasificación de
imagenes (como <code>BertForSequenceClassification</code>).`,Ke,Q,is=`Como mencionamos antes, solo escribiremos un envoltura (<em>wrapper</em>) libre del modelo para simplificar este ejemplo. Lo único que debemos
hacer antes de escribir esta clase es un mapeo entre los tipos de bloques y las clases de bloques reales. Luego se define el
modelo desde la configuración pasando todo a la clase <code>ResNet</code>:`,Oe,H,el,q,rs="Para el modelo que clasificará las imágenes, solo cambiamos el método de avance (es decir, el método <code>forward</code>):",ll,x,sl,F,cs=`En ambos casos, observa cómo heredamos de <code>PreTrainedModel</code> y llamamos a la inicialización de la superclase con <code>config</code>
(un poco como cuando escribes <code>torch.nn.Module</code>). La línea que establece <code>config_class</code> no es obligatoria, a menos
que quieras registrar tu modelo con las clases automáticas (consulta la última sección).`,tl,b,al,L,ds=`Puedes hacer que tu modelo devuelva lo que quieras, pero devolver un diccionario como lo hicimos para
<code>ResnetModelForImageClassification</code>, con el <code>loss</code> incluido cuando se pasan las etiquetas, hará que tu modelo se pueda
usar directamente dentro de la clase <code>Trainer</code>. Usar otro formato de salida está bien, siempre y cuando estés planeando usar
tu propio bucle de entrenamiento u otra biblioteca para el entrenamiento.`,nl,S,ps="Ahora que tenemos nuestra clase, vamos a crear un modelo:",ol,P,il,D,Ms=`Nuevamente, puedes usar cualquiera de los métodos de <code>PreTrainedModel</code>, como <code>save_pretrained()</code> o
<code>push_to_hub()</code>. Usaremos el segundo en la siguiente sección y veremos cómo pasar los pesos del modelo
con el código de nuestro modelo. Pero primero, carguemos algunos pesos previamente entrenados dentro de nuestro modelo.`,rl,K,ms=`En tu caso de uso, probablemente estarás entrenando tu modelo personalizado con tus propios datos. Para ir rápido en este
tutorial, usaremos la versión preentrenada de resnet50d. Dado que nuestro modelo es solo un envoltorio alrededor del resnet50d
original, será fácil transferir esos pesos:`,cl,O,dl,ee,us=`Ahora veamos cómo asegurarnos de que cuando hacemos <code>save_pretrained()</code> o <code>push_to_hub()</code>,
se guarda el código del modelo.`,pl,le,Ml,U,ml,se,ys=`Primero, asegúrate de que tu modelo esté completamente definido en un archivo <code>.py</code>. Puedes basarte en importaciones
relativas a otros archivos, siempre que todos los archivos estén en el mismo directorio (aún no admitimos submódulos
para esta característica). Para nuestro ejemplo, definiremos un archivo <code>modeling_resnet.py</code> y un archivo
<code>configuration_resnet.py</code> en una carpeta del directorio de trabajo actual llamado <code>resnet_model</code>. El archivo de configuración
contiene el código de <code>ResnetConfig</code> y el archivo del modelo contiene el código de <code>ResnetModel</code> y
<code>ResnetModelForImageClassification</code>.`,ul,te,yl,ae,Js="El <code>__init__.py</code>  puede estar vacío, solo está ahí para que Python detecte que <code>resnet_model</code> se puede usar como un módulo.",Jl,C,Tl,ne,Ts="Ten en cuenta que puedes reutilizar (o subclasificar) una configuración o modelo existente.",wl,oe,ws=`Para compartir tu modelo con la comunidad, sigue estos pasos: primero importa el modelo y la configuración de ResNet desde
los archivos recién creados:`,fl,ie,jl,re,fs=`Luego, debes decirle a la biblioteca que deseas copiar el código de esos objetos cuando usas el método <code>save_pretrained</code>
y registrarlos correctamente con una determinada clase automática (especialmente para modelos), simplemente ejecuta:`,bl,ce,Ul,de,js=`Ten en cuenta que no es necesario especificar una clase automática para la configuración (solo hay una clase automática
para ellos, <code>AutoConfig</code>), pero es diferente para los modelos. Tu modelo personalizado podría ser adecuado para muchas
tareas diferentes, por lo que debes especificar cuál de las clases automáticas es la correcta para tu modelo.`,Cl,pe,bs="A continuación, vamos a crear la configuración y los modelos como lo hicimos antes:",Il,Me,gl,me,Us="Ahora, para enviar el modelo al Hub, asegúrate de haber iniciado sesión. Ejecuta en tu terminal:",Zl,ue,_l,ye,Cs="o desde un <em>notebook</em>:",hl,Je,vl,Te,Is="Luego puedes ingresar a tu propio espacio (o una organización de la que seas miembro) de esta manera:",Al,we,$l,fe,gs=`Además de los pesos del modelo y la configuración en formato json, esto también copió los archivos <code>.py</code> del modelo y la
configuración en la carpeta <code>custom-resnet50d</code> y subió el resultado al Hub. Puedes verificar el resultado en este
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">repositorio de modelos</a>.`,kl,je,Zs='Consulta el tutorial sobre cómo <a href="model_sharing">compartir modelos</a> para obtener más información sobre el método para subir modelos al Hub.',Nl,be,Bl,Ue,_s=`Puedes usar cualquier configuración, modelo o <em>tokenizador</em> con archivos de código personalizado en tu repositorio con las
clases automáticas y el método <code>from_pretrained</code>. Todos los archivos y códigos cargados en el Hub se analizan en busca de
malware (consulta la documentación de <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">seguridad del Hub</a> para
obtener más información), pero aún debes revisar el código del modelo y el autor para evitar la ejecución de código malicioso
en tu computadora. Configura <code>trust_remote_code=True</code> para usar un modelo con código personalizado:`,Rl,Ce,Wl,Ie,hs=`También se recomienda encarecidamente pasar un <em>hash</em> de confirmación como una “revisión” para asegurarte de que el autor
de los modelos no actualizó el código con algunas líneas nuevas maliciosas (a menos que confíes plenamente en los autores
de los modelos).`,Xl,ge,zl,Ze,vs=`Ten en cuenta que al navegar por el historial de confirmaciones del repositorio del modelo en Hub, hay un botón para copiar
fácilmente el hash de confirmación de cualquier <em>commit</em>.`,Gl,_e,El,he,As=`Si estás escribiendo una biblioteca que amplía 🤗 Transformers, es posible que quieras ampliar las clases automáticas para
incluir tu propio modelo. Esto es diferente de enviar el código al Hub en el sentido de que los usuarios necesitarán importar
tu biblioteca para obtener los modelos personalizados (al contrario de descargar automáticamente el código del modelo desde Hub).`,Vl,ve,$s=`Siempre que tu configuración tenga un atributo <code>model_type</code> que sea diferente de los tipos de modelos existentes, y que tus
clases modelo tengan los atributos <code>config_class</code> correctos, puedes agregarlos a las clases automáticas de la siguiente manera:`,Yl,Ae,Ql,$e,ks=`Ten en cuenta que el primer argumento utilizado al registrar tu configuración personalizada en <code>AutoConfig</code> debe coincidir
con el <code>model_type</code> de tu configuración personalizada, y el primer argumento utilizado al registrar tus modelos personalizados
en cualquier clase del modelo automático debe coincidir con el <code>config_class</code> de esos modelos.`,Hl,Ne,ql;return I=new ke({props:{title:"Compartir modelos personalizados",local:"compartir-modelos-personalizados",headingTag:"h1"}}),h=new ke({props:{title:"Escribir una configuración personalizada",local:"escribir-una-configuración-personalizada",headingTag:"h2"}}),$=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),G=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),V=new ke({props:{title:"Escribir un modelo personalizado",local:"escribir-un-modelo-personalizado",headingTag:"h2"}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),x=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),b=new xl({props:{$$slots:{default:[qs]},$$scope:{ctx:j}}}),P=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),le=new ke({props:{title:"Enviar el código al Hub",local:"enviar-el-código-al-hub",headingTag:"h2"}}),U=new xl({props:{warning:!0,$$slots:{default:[xs]},$$scope:{ctx:j}}}),te=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),C=new xl({props:{warning:!0,$$slots:{default:[Fs]},$$scope:{ctx:j}}}),ie=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),ce=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),Me=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ue=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Je=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),we=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),be=new ke({props:{title:"Usar un modelo con código personalizado",local:"usar-un-modelo-con-código-personalizado",headingTag:"h2"}}),Ce=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),ge=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),_e=new ke({props:{title:"Registrar un model con código personalizado a las clases automáticas",local:"registrar-un-model-con-código-personalizado-a-las-clases-automáticas",headingTag:"h2"}}),Ae=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){c=o("meta"),w=a(),J=o("p"),f=a(),d(I.$$.fragment),Be=a(),g=o("p"),g.textContent=Ll,Re=a(),Z=o("p"),Z.textContent=Sl,We=a(),_=o("p"),_.innerHTML=Pl,Xe=a(),d(h.$$.fragment),ze=a(),v=o("p"),v.innerHTML=Dl,Ge=a(),A=o("p"),A.textContent=Kl,Ee=a(),d($.$$.fragment),Ve=a(),k=o("p"),k.textContent=Ol,Ye=a(),N=o("ul"),N.innerHTML=es,Qe=a(),B=o("p"),B.innerHTML=ls,He=a(),R=o("p"),R.innerHTML=ss,qe=a(),W=o("p"),W.textContent=ts,xe=a(),d(X.$$.fragment),Fe=a(),z=o("p"),z.innerHTML=as,Le=a(),d(G.$$.fragment),Se=a(),E=o("p"),E.innerHTML=ns,Pe=a(),d(V.$$.fragment),De=a(),Y=o("p"),Y.innerHTML=os,Ke=a(),Q=o("p"),Q.innerHTML=is,Oe=a(),d(H.$$.fragment),el=a(),q=o("p"),q.innerHTML=rs,ll=a(),d(x.$$.fragment),sl=a(),F=o("p"),F.innerHTML=cs,tl=a(),d(b.$$.fragment),al=a(),L=o("p"),L.innerHTML=ds,nl=a(),S=o("p"),S.textContent=ps,ol=a(),d(P.$$.fragment),il=a(),D=o("p"),D.innerHTML=Ms,rl=a(),K=o("p"),K.textContent=ms,cl=a(),d(O.$$.fragment),dl=a(),ee=o("p"),ee.innerHTML=us,pl=a(),d(le.$$.fragment),Ml=a(),d(U.$$.fragment),ml=a(),se=o("p"),se.innerHTML=ys,ul=a(),d(te.$$.fragment),yl=a(),ae=o("p"),ae.innerHTML=Js,Jl=a(),d(C.$$.fragment),Tl=a(),ne=o("p"),ne.textContent=Ts,wl=a(),oe=o("p"),oe.textContent=ws,fl=a(),d(ie.$$.fragment),jl=a(),re=o("p"),re.innerHTML=fs,bl=a(),d(ce.$$.fragment),Ul=a(),de=o("p"),de.innerHTML=js,Cl=a(),pe=o("p"),pe.textContent=bs,Il=a(),d(Me.$$.fragment),gl=a(),me=o("p"),me.textContent=Us,Zl=a(),d(ue.$$.fragment),_l=a(),ye=o("p"),ye.innerHTML=Cs,hl=a(),d(Je.$$.fragment),vl=a(),Te=o("p"),Te.textContent=Is,Al=a(),d(we.$$.fragment),$l=a(),fe=o("p"),fe.innerHTML=gs,kl=a(),je=o("p"),je.innerHTML=Zs,Nl=a(),d(be.$$.fragment),Bl=a(),Ue=o("p"),Ue.innerHTML=_s,Rl=a(),d(Ce.$$.fragment),Wl=a(),Ie=o("p"),Ie.innerHTML=hs,Xl=a(),d(ge.$$.fragment),zl=a(),Ze=o("p"),Ze.innerHTML=vs,Gl=a(),d(_e.$$.fragment),El=a(),he=o("p"),he.textContent=As,Vl=a(),ve=o("p"),ve.innerHTML=$s,Yl=a(),d(Ae.$$.fragment),Ql=a(),$e=o("p"),$e.innerHTML=ks,Hl=a(),Ne=o("p"),this.h()},l(e){const l=Ys("svelte-u9bgzb",document.head);c=i(l,"META",{name:!0,content:!0}),l.forEach(s),w=n(e),J=i(e,"P",{}),Ws(J).forEach(s),f=n(e),p(I.$$.fragment,e),Be=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-tr5y5v"&&(g.textContent=Ll),Re=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-109xt20"&&(Z.textContent=Sl),We=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-btynk6"&&(_.innerHTML=Pl),Xe=n(e),p(h.$$.fragment,e),ze=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ogx8ma"&&(v.innerHTML=Dl),Ge=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-150l7rd"&&(A.textContent=Kl),Ee=n(e),p($.$$.fragment,e),Ve=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-136d91e"&&(k.textContent=Ol),Ye=n(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-9z90ps"&&(N.innerHTML=es),Qe=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ydah10"&&(B.innerHTML=ls),He=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-9ngg6t"&&(R.innerHTML=ss),qe=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-aydane"&&(W.textContent=ts),xe=n(e),p(X.$$.fragment,e),Fe=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1m9vi80"&&(z.innerHTML=as),Le=n(e),p(G.$$.fragment,e),Se=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-13fhymr"&&(E.innerHTML=ns),Pe=n(e),p(V.$$.fragment,e),De=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-paws7g"&&(Y.innerHTML=os),Ke=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ibwyqf"&&(Q.innerHTML=is),Oe=n(e),p(H.$$.fragment,e),el=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-836jlz"&&(q.innerHTML=rs),ll=n(e),p(x.$$.fragment,e),sl=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-14m6odt"&&(F.innerHTML=cs),tl=n(e),p(b.$$.fragment,e),al=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1azo3fe"&&(L.innerHTML=ds),nl=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1shfqlo"&&(S.textContent=ps),ol=n(e),p(P.$$.fragment,e),il=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-2zdpdr"&&(D.innerHTML=Ms),rl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-yesi1m"&&(K.textContent=ms),cl=n(e),p(O.$$.fragment,e),dl=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-5f7hiy"&&(ee.innerHTML=us),pl=n(e),p(le.$$.fragment,e),Ml=n(e),p(U.$$.fragment,e),ml=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-5u1ku0"&&(se.innerHTML=ys),ul=n(e),p(te.$$.fragment,e),yl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-6pddse"&&(ae.innerHTML=Js),Jl=n(e),p(C.$$.fragment,e),Tl=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-16nat6k"&&(ne.textContent=Ts),wl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1wbstm1"&&(oe.textContent=ws),fl=n(e),p(ie.$$.fragment,e),jl=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1w1g05r"&&(re.innerHTML=fs),bl=n(e),p(ce.$$.fragment,e),Ul=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1gdhq4n"&&(de.innerHTML=js),Cl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1vs3f15"&&(pe.textContent=bs),Il=n(e),p(Me.$$.fragment,e),gl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1alfdyw"&&(me.textContent=Us),Zl=n(e),p(ue.$$.fragment,e),_l=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-vkjqtt"&&(ye.innerHTML=Cs),hl=n(e),p(Je.$$.fragment,e),vl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1n95bu8"&&(Te.textContent=Is),Al=n(e),p(we.$$.fragment,e),$l=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-5clmj9"&&(fe.innerHTML=gs),kl=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1cn7w99"&&(je.innerHTML=Zs),Nl=n(e),p(be.$$.fragment,e),Bl=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-z7pzfv"&&(Ue.innerHTML=_s),Rl=n(e),p(Ce.$$.fragment,e),Wl=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-k6h5j4"&&(Ie.innerHTML=hs),Xl=n(e),p(ge.$$.fragment,e),zl=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-triido"&&(Ze.innerHTML=vs),Gl=n(e),p(_e.$$.fragment,e),El=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1brns02"&&(he.textContent=As),Vl=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-qfsmdh"&&(ve.innerHTML=$s),Yl=n(e),p(Ae.$$.fragment,e),Ql=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-srgb3"&&($e.innerHTML=ks),Hl=n(e),Ne=i(e,"P",{}),Ws(Ne).forEach(s),this.h()},h(){Xs(c,"name","hf:doc:metadata"),Xs(c,"content",Ss)},m(e,l){Qs(document.head,c),t(e,w,l),t(e,J,l),t(e,f,l),M(I,e,l),t(e,Be,l),t(e,g,l),t(e,Re,l),t(e,Z,l),t(e,We,l),t(e,_,l),t(e,Xe,l),M(h,e,l),t(e,ze,l),t(e,v,l),t(e,Ge,l),t(e,A,l),t(e,Ee,l),M($,e,l),t(e,Ve,l),t(e,k,l),t(e,Ye,l),t(e,N,l),t(e,Qe,l),t(e,B,l),t(e,He,l),t(e,R,l),t(e,qe,l),t(e,W,l),t(e,xe,l),M(X,e,l),t(e,Fe,l),t(e,z,l),t(e,Le,l),M(G,e,l),t(e,Se,l),t(e,E,l),t(e,Pe,l),M(V,e,l),t(e,De,l),t(e,Y,l),t(e,Ke,l),t(e,Q,l),t(e,Oe,l),M(H,e,l),t(e,el,l),t(e,q,l),t(e,ll,l),M(x,e,l),t(e,sl,l),t(e,F,l),t(e,tl,l),M(b,e,l),t(e,al,l),t(e,L,l),t(e,nl,l),t(e,S,l),t(e,ol,l),M(P,e,l),t(e,il,l),t(e,D,l),t(e,rl,l),t(e,K,l),t(e,cl,l),M(O,e,l),t(e,dl,l),t(e,ee,l),t(e,pl,l),M(le,e,l),t(e,Ml,l),M(U,e,l),t(e,ml,l),t(e,se,l),t(e,ul,l),M(te,e,l),t(e,yl,l),t(e,ae,l),t(e,Jl,l),M(C,e,l),t(e,Tl,l),t(e,ne,l),t(e,wl,l),t(e,oe,l),t(e,fl,l),M(ie,e,l),t(e,jl,l),t(e,re,l),t(e,bl,l),M(ce,e,l),t(e,Ul,l),t(e,de,l),t(e,Cl,l),t(e,pe,l),t(e,Il,l),M(Me,e,l),t(e,gl,l),t(e,me,l),t(e,Zl,l),M(ue,e,l),t(e,_l,l),t(e,ye,l),t(e,hl,l),M(Je,e,l),t(e,vl,l),t(e,Te,l),t(e,Al,l),M(we,e,l),t(e,$l,l),t(e,fe,l),t(e,kl,l),t(e,je,l),t(e,Nl,l),M(be,e,l),t(e,Bl,l),t(e,Ue,l),t(e,Rl,l),M(Ce,e,l),t(e,Wl,l),t(e,Ie,l),t(e,Xl,l),M(ge,e,l),t(e,zl,l),t(e,Ze,l),t(e,Gl,l),M(_e,e,l),t(e,El,l),t(e,he,l),t(e,Vl,l),t(e,ve,l),t(e,Yl,l),M(Ae,e,l),t(e,Ql,l),t(e,$e,l),t(e,Hl,l),t(e,Ne,l),ql=!0},p(e,[l]){const Ns={};l&2&&(Ns.$$scope={dirty:l,ctx:e}),b.$set(Ns);const Bs={};l&2&&(Bs.$$scope={dirty:l,ctx:e}),U.$set(Bs);const Rs={};l&2&&(Rs.$$scope={dirty:l,ctx:e}),C.$set(Rs)},i(e){ql||(m(I.$$.fragment,e),m(h.$$.fragment,e),m($.$$.fragment,e),m(X.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(H.$$.fragment,e),m(x.$$.fragment,e),m(b.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(U.$$.fragment,e),m(te.$$.fragment,e),m(C.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(ue.$$.fragment,e),m(Je.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(ge.$$.fragment,e),m(_e.$$.fragment,e),m(Ae.$$.fragment,e),ql=!0)},o(e){u(I.$$.fragment,e),u(h.$$.fragment,e),u($.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(x.$$.fragment,e),u(b.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(U.$$.fragment,e),u(te.$$.fragment,e),u(C.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(Ce.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(Ae.$$.fragment,e),ql=!1},d(e){e&&(s(w),s(J),s(f),s(Be),s(g),s(Re),s(Z),s(We),s(_),s(Xe),s(ze),s(v),s(Ge),s(A),s(Ee),s(Ve),s(k),s(Ye),s(N),s(Qe),s(B),s(He),s(R),s(qe),s(W),s(xe),s(Fe),s(z),s(Le),s(Se),s(E),s(Pe),s(De),s(Y),s(Ke),s(Q),s(Oe),s(el),s(q),s(ll),s(sl),s(F),s(tl),s(al),s(L),s(nl),s(S),s(ol),s(il),s(D),s(rl),s(K),s(cl),s(dl),s(ee),s(pl),s(Ml),s(ml),s(se),s(ul),s(yl),s(ae),s(Jl),s(Tl),s(ne),s(wl),s(oe),s(fl),s(jl),s(re),s(bl),s(Ul),s(de),s(Cl),s(pe),s(Il),s(gl),s(me),s(Zl),s(_l),s(ye),s(hl),s(vl),s(Te),s(Al),s($l),s(fe),s(kl),s(je),s(Nl),s(Bl),s(Ue),s(Rl),s(Wl),s(Ie),s(Xl),s(zl),s(Ze),s(Gl),s(El),s(he),s(Vl),s(ve),s(Yl),s(Ql),s($e),s(Hl),s(Ne)),s(c),y(I,e),y(h,e),y($,e),y(X,e),y(G,e),y(V,e),y(H,e),y(x,e),y(b,e),y(P,e),y(O,e),y(le,e),y(U,e),y(te,e),y(C,e),y(ie,e),y(ce,e),y(Me,e),y(ue,e),y(Je,e),y(we,e),y(be,e),y(Ce,e),y(ge,e),y(_e,e),y(Ae,e)}}}const Ss='{"title":"Compartir modelos personalizados","local":"compartir-modelos-personalizados","sections":[{"title":"Escribir una configuración personalizada","local":"escribir-una-configuración-personalizada","sections":[],"depth":2},{"title":"Escribir un modelo personalizado","local":"escribir-un-modelo-personalizado","sections":[],"depth":2},{"title":"Enviar el código al Hub","local":"enviar-el-código-al-hub","sections":[],"depth":2},{"title":"Usar un modelo con código personalizado","local":"usar-un-modelo-con-código-personalizado","sections":[],"depth":2},{"title":"Registrar un model con código personalizado a las clases automáticas","local":"registrar-un-model-con-código-personalizado-a-las-clases-automáticas","sections":[],"depth":2}],"depth":1}';function Ps(j){return Gs(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Hs}),[]}class st extends Es{constructor(c){super(),Vs(this,c,Ps,Ls,zs,{})}}export{st as component};
