import{s as Xt,o as Gt,n as ql}from"../chunks/scheduler.36a0863c.js";import{S as Vt,i as Qt,g as n,s as i,r as p,A as Yt,h as o,f as t,c as a,j as Rt,u as M,x as r,k as Wt,y as xt,a as s,v as d,d as m,t as u,w as y}from"../chunks/index.9c13489a.js";import{H as $e,g as Et}from"../chunks/Heading.88a24aaa.js";import{T as Fl}from"../chunks/Tip.3b06990e.js";import{C as f}from"../chunks/CodeBlock.05d8ec32.js";function Ht(j){let c,T="Se il tuo modello è molto simile a un modello all’interno della libreria, puoi ri-usare la stessa configurazione di quel modello.";return{c(){c=n("p"),c.textContent=T},l(J){c=o(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1j1jq3y"&&(c.textContent=T)},m(J,w){s(J,c,w)},p:ql,d(J){J&&t(c)}}}function Ft(j){let c,T="Questa API è sperimentale e potrebbe avere alcuni cambiamenti nei prossimi rilasci.";return{c(){c=n("p"),c.textContent=T},l(J){c=o(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1dfgrpm"&&(c.textContent=T)},m(J,w){s(J,c,w)},p:ql,d(J){J&&t(c)}}}function qt(j){let c,T=`Se stai copiando i file relativi alla modellazione della libreria, dovrai sostituire tutti gli import relativi in cima al file con import del
pacchetto <code>transformers</code>.`;return{c(){c=n("p"),c.innerHTML=T},l(J){c=o(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-ek1fx"&&(c.innerHTML=T)},m(J,w){s(J,c,w)},p:ql,d(J){J&&t(c)}}}function St(j){let c,T,J,w,I,Ne,h,Sl=`La libreria 🤗 Transformers è studiata per essere facilmente estendibile. Il codice di ogni modello è interamente
situato in una sottocartella del repository senza alcuna astrazione, perciò puoi facilmente copiare il file di un
modello e modificarlo in base ai tuoi bisogni.`,Be,g,Ll=`Se stai scrivendo un nuovo modello, potrebbe essere più semplice iniziare da zero. In questo tutorial, ti mostreremo
come scrivere un modello personalizzato e la sua configurazione in modo che possa essere utilizzato all’interno di
Transformers, e come condividerlo con la community (assieme al relativo codice) così che tutte le persone possano usarlo, anche
se non presente nella libreria 🤗 Transformers.`,Re,Z,Pl=`Illustriamo tutto questo su un modello ResNet, avvolgendo la classe ResNet della
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">libreria timm</a> in un <code>PreTrainedModel</code>.`,We,_,Xe,v,Dl=`Prima di iniziare a lavorare al modello, scriviamone la configurazione. La configurazione di un modello è un oggetto
che contiene tutte le informazioni necessarie per la build del modello. Come vedremo nella prossima sezione, il
modello può soltanto essere inizializzato tramite <code>config</code>, per cui dovremo rendere tale oggetto più completo possibile.`,Ge,z,Kl=`Nel nostro esempio, prenderemo un paio di argomenti della classe ResNet che potremmo voler modificare.
Configurazioni differenti ci daranno quindi i differenti possibili tipi di ResNet. Salveremo poi questi argomenti,
dopo averne controllato la validità.`,Ve,A,Qe,$,Ol="Le tre cose più importanti da ricordare quando scrivi le tue configurazioni sono le seguenti:",Ye,k,et="<li>Devi ereditare da <code>Pretrainedconfig</code>,</li> <li>Il metodo <code>__init__</code> del tuo <code>Pretrainedconfig</code> deve accettare i kwargs,</li> <li>I <code>kwargs</code> devono essere passati alla superclass <code>__init__</code></li>",xe,N,lt=`L’eredità è importante per assicurarsi di ottenere tutte le funzionalità della libreria 🤗 transformers,
mentre gli altri due vincoli derivano dal fatto che un <code>Pretrainedconfig</code> ha più campi di quelli che stai settando.
Quando ricarichi una config da un metodo <code>from_pretrained</code>, questi campi devono essere accettati dalla tua config e
poi inviati alla superclasse.`,Ee,B,tt=`Definire un <code>model_type</code> per la tua configurazione (qua <code>model_type = “resnet”</code>) non è obbligatorio, a meno che tu
non voglia registrare il modello con le classi Auto (vedi l’ultima sezione).`,He,R,st=`Una volta completato, puoi facilmente creare e salvare la tua configurazione come faresti con ogni altra configurazione
di modelli della libreria. Ecco come possiamo creare la config di un resnet50d e salvarlo:`,Fe,W,qe,X,it=`Questo salverà un file chiamato <code>config.json</code> all’interno della cartella <code>custom-resnet</code>. Potrai poi ricaricare la tua
config con il metodo <code>from_pretrained</code>.`,Se,G,Le,V,at=`Puoi anche usare qualunque altro metodo della classe <code>PretrainedConfig</code>, come <code>push_to_hub()</code>
per caricare direttamente la tua configurazione nell’hub.`,Pe,Q,De,Y,nt=`Ora che abbiamo la nostra configurazione ResNet, possiamo continuare a scrivere il modello. In realtà, ne scriveremo
due: uno che estrae le features nascoste da una batch di immagini (come <code>BertModel</code>) e uno che è utilizzabile per
la classificazione di immagini (come <code>BertModelForSequenceClassification</code>).`,Ke,x,ot=`Come abbiamo menzionato in precedenza, scriveremo soltanto un wrapper del modello, per mantenerlo semplice ai fini di
questo esempio. L’unica cosa che dobbiamo fare prima di scrivere questa classe è una mappatura fra i tipi di blocco e
le vere classi dei blocchi. Successivamente il modello è definito tramite la configurazione, passando tutto quanto alla
classe <code>ResNet</code>.`,Oe,E,el,H,rt="Per il modello che classificherà le immagini, cambiamo soltanto il metodo forward:",ll,F,tl,q,ct=`Nota come, in entrambi i casi, ereditiamo da <code>PreTrainedModel</code> e chiamiamo l’inizializzazione della superclasse
con il metodo <code>config</code> (un po’ come quando scrivi un normale <code>torch.nn.Module</code>). La riga che imposta la  <code>config_class</code>
non è obbligatoria, a meno che tu non voglia registrare il modello con le classi Auto (vedi l’ultima sezione).`,sl,U,il,S,pt=`Puoi fare in modo che il tuo modello restituisca in output qualunque cosa tu voglia, ma far restituire un dizionario
come abbiamo fatto per <code>ResnetModelForImageClassification</code>, con la funzione di perdita inclusa quando vengono passate le labels,
renderà il tuo modello direttamente utilizzabile all’interno della classe <code>Trainer</code>. Utilizzare altri formati di output va bene
se hai in progetto di utilizzare un tuo loop di allenamento, o se utilizzerai un’altra libreria per l’addestramento.`,al,L,Mt="Ora che abbiamo la classe del nostro modello, creiamone uno:",nl,P,ol,D,dt=`Ribadiamo, puoi usare qualunque metodo dei <code>PreTrainedModel</code>, come <code>save_pretrained()</code> o
<code>push_to_hub()</code>. Utilizzeremo quest’ultimo nella prossima sezione, e vedremo come caricare i pesi del
modello assieme al codice del modello stesso. Ma prima, carichiamo alcuni pesi pre-allenati all’interno del nostro modello.`,rl,K,mt=`Nel tuo caso specifico, probabilmente allenerai il tuo modello sui tuoi dati. Per velocizzare in questo tutorial,
utilizzeremo la versione pre-allenata del resnet50d. Dato che il nostro modello è soltanto un wrapper attorno a quel modello,
sarà facile trasferirne i pesi:`,cl,O,pl,ee,ut=`Vediamo adesso come assicurarci che quando facciamo <code>save_pretrained()</code> o <code>push_to_hub()</code>,
il codice del modello venga salvato.`,Ml,le,dl,b,ml,te,yt=`Innanzitutto, assicurati che il tuo modello sia completamente definito in un file <code>.py</code>. Può sfruttare import relativi
ad altri file, purchè questi siano nella stessa directory (non supportiamo ancora sotto-moduli per questa funzionalità).
Per questo esempio, definiremo un file <code>modeling_resnet.py</code> e un file <code>configuration_resnet.py</code> in una cartella dell’attuale
working directory chiamata <code>resnet_model</code>. Il file configuration contiene il codice per <code>ResnetConfig</code> e il file modeling
contiene il codice di <code>ResnetModel</code> e <code>ResnetModelForImageClassification</code>.`,ul,se,yl,ie,Jt="Il file <code>__init__.py</code> può essere vuoto, serve solo perchè Python capisca che <code>resnet_model</code> può essere utilizzato come un modulo.",Jl,C,fl,ae,ft="Nota che puoi ri-utilizzare (o usare come sottoclassi) un modello/configurazione esistente.",Tl,ne,Tt=`Per condividere il tuo modello con la community, segui questi passi: prima importa il modello ResNet e la sua configurazione
dai nuovi file creati:`,wl,oe,jl,re,wt=`Dopodichè dovrai dire alla libreria che vuoi copiare i file con il codice di quegli oggetti quando utilizzi il metodo
<code>save_pretrained</code> e registrarli in modo corretto con una Auto classe (specialmente per i modelli). Utilizza semplicemente:`,Ul,ce,bl,pe,jt=`Nota che non c’è bisogno di specificare una Auto classe per la configurazione (c’è solo una Auto classe per le configurazioni,
<code>AutoConfig</code>, ma è diversa per i modelli). Il tuo modello personalizato potrebbe essere utilizzato per diverse tasks,
per cui devi specificare quale delle classi Auto è quella corretta per il tuo modello.`,Cl,Me,Ut="Successivamente, creiamo i modelli e la config come abbiamo fatto in precedenza:",Il,de,hl,me,bt="Adesso, per inviare il modello all’Hub, assicurati di aver effettuato l’accesso. Lancia dal tuo terminale:",gl,ue,Zl,ye,Ct="O da un notebook:",_l,Je,vl,fe,It="Potrai poi inviare il tutto sul tuo profilo (o di un’organizzazione di cui fai parte) in questo modo:",zl,Te,Al,we,ht=`Oltre ai pesi del modello e alla configurazione in formato json, questo ha anche copiato i file <code>.py</code> modeling e
configuration all’interno della cartella <code>custom-resnet50d</code> e ha caricato i risultati sull’Hub. Puoi controllare
i risultati in questa <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.`,$l,je,gt=`Puoi controllare il tutorial di condivisione <a href="model_sharing">tutorial di condivisione</a> per più informazioni sul
metodo con cui inviare all’Hub.`,kl,Ue,Nl,be,Zt=`Puoi usare ogni configurazione, modello o tokenizer con file di codice personalizzati nella sua repository
con le classi Auto e il metodo <code>from_pretrained</code>. Tutti i files e il codice caricati sull’Hub sono scansionati da malware
(fai riferimento alla documentazione <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub security</a> per più informazioni),
ma dovresti comunque assicurarti dell’affidabilità del codice e dell’autore per evitare di eseguire codice dannoso sulla tua macchina.
Imposta <code>trust_remote_code=True</code> per usare un modello con codice personalizzato:`,Bl,Ce,Rl,Ie,_t=`Inoltre, raccomandiamo fortemente di passare un hash del commit come <code>revision</code> per assicurarti che le autrici o gli autori del modello
non abbiano modificato il codice con alcune nuove righe dannose (a meno che non ti fidi completamente della fonte):`,Wl,he,Xl,ge,vt=`Nota che quando cerchi la storia dei commit della repo del modello sull’Hub, c’è un bottone con cui facilmente copiare il
commit hash di ciascun commit.`,Gl,Ze,Vl,_e,zt=`Se stai scrivendo una libreria che estende 🤗 Transformers, potresti voler estendere le classi Auto per includere il tuo modello.
Questo è diverso dall’inviare codice nell’Hub: gli utenti dovranno importare la tua libreria per ottenere il modello personalizzato
(anzichè scaricare automaticamente il modello dall’Hub).`,Ql,ve,At=`Finchè il tuo file di configurazione ha un attributo <code>model_type</code> diverso dai model types esistenti, e finchè le tue
classi modello hanno i corretti attributi <code>config_class</code>, potrai semplicemente aggiungerli alle classi Auto come segue:`,Yl,ze,xl,Ae,$t=`Nota che il primo argomento utilizzato quando registri la configurazione di un modello personalizzato con <code>AutoConfig</code>
deve corrispondere al <code>model_type</code> della tua configurazione personalizzata, ed il primo argomento utilizzato quando
registri i tuoi modelli personalizzati in una qualunque classe Auto del modello deve corrispondere alla <code>config_class</code>
di quei modelli.`,El,ke,Hl;return I=new $e({props:{title:"Condividere modelli personalizzati",local:"condividere-modelli-personalizzati",headingTag:"h1"}}),_=new $e({props:{title:"Scrivere una configurazione personalizzata",local:"scrivere-una-configurazione-personalizzata",headingTag:"h2"}}),A=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),W=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),G=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),Q=new $e({props:{title:"Scrivere un modello personalizzato",local:"scrivere-un-modello-personalizzato",headingTag:"h2"}}),E=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),U=new Fl({props:{$$slots:{default:[Ht]},$$scope:{ctx:j}}}),P=new f({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new f({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),le=new $e({props:{title:"Inviare il codice all’Hub",local:"inviare-il-codice-allhub",headingTag:"h2"}}),b=new Fl({props:{warning:!0,$$slots:{default:[Ft]},$$scope:{ctx:j}}}),se=new f({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),C=new Fl({props:{warning:!0,$$slots:{default:[qt]},$$scope:{ctx:j}}}),oe=new f({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),ce=new f({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),de=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ue=new f({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Je=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Te=new f({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Ue=new $e({props:{title:"Usare un modello con codice personalizzato",local:"usare-un-modello-con-codice-personalizzato",headingTag:"h2"}}),Ce=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),he=new f({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ze=new $e({props:{title:"Registrare un modello con codice personalizzato nelle classi Auto",local:"registrare-un-modello-con-codice-personalizzato-nelle-classi-auto",headingTag:"h2"}}),ze=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){c=n("meta"),T=i(),J=n("p"),w=i(),p(I.$$.fragment),Ne=i(),h=n("p"),h.textContent=Sl,Be=i(),g=n("p"),g.textContent=Ll,Re=i(),Z=n("p"),Z.innerHTML=Pl,We=i(),p(_.$$.fragment),Xe=i(),v=n("p"),v.innerHTML=Dl,Ge=i(),z=n("p"),z.textContent=Kl,Ve=i(),p(A.$$.fragment),Qe=i(),$=n("p"),$.textContent=Ol,Ye=i(),k=n("ul"),k.innerHTML=et,xe=i(),N=n("p"),N.innerHTML=lt,Ee=i(),B=n("p"),B.innerHTML=tt,He=i(),R=n("p"),R.textContent=st,Fe=i(),p(W.$$.fragment),qe=i(),X=n("p"),X.innerHTML=it,Se=i(),p(G.$$.fragment),Le=i(),V=n("p"),V.innerHTML=at,Pe=i(),p(Q.$$.fragment),De=i(),Y=n("p"),Y.innerHTML=nt,Ke=i(),x=n("p"),x.innerHTML=ot,Oe=i(),p(E.$$.fragment),el=i(),H=n("p"),H.textContent=rt,ll=i(),p(F.$$.fragment),tl=i(),q=n("p"),q.innerHTML=ct,sl=i(),p(U.$$.fragment),il=i(),S=n("p"),S.innerHTML=pt,al=i(),L=n("p"),L.textContent=Mt,nl=i(),p(P.$$.fragment),ol=i(),D=n("p"),D.innerHTML=dt,rl=i(),K=n("p"),K.textContent=mt,cl=i(),p(O.$$.fragment),pl=i(),ee=n("p"),ee.innerHTML=ut,Ml=i(),p(le.$$.fragment),dl=i(),p(b.$$.fragment),ml=i(),te=n("p"),te.innerHTML=yt,ul=i(),p(se.$$.fragment),yl=i(),ie=n("p"),ie.innerHTML=Jt,Jl=i(),p(C.$$.fragment),fl=i(),ae=n("p"),ae.textContent=ft,Tl=i(),ne=n("p"),ne.textContent=Tt,wl=i(),p(oe.$$.fragment),jl=i(),re=n("p"),re.innerHTML=wt,Ul=i(),p(ce.$$.fragment),bl=i(),pe=n("p"),pe.innerHTML=jt,Cl=i(),Me=n("p"),Me.textContent=Ut,Il=i(),p(de.$$.fragment),hl=i(),me=n("p"),me.textContent=bt,gl=i(),p(ue.$$.fragment),Zl=i(),ye=n("p"),ye.textContent=Ct,_l=i(),p(Je.$$.fragment),vl=i(),fe=n("p"),fe.textContent=It,zl=i(),p(Te.$$.fragment),Al=i(),we=n("p"),we.innerHTML=ht,$l=i(),je=n("p"),je.innerHTML=gt,kl=i(),p(Ue.$$.fragment),Nl=i(),be=n("p"),be.innerHTML=Zt,Bl=i(),p(Ce.$$.fragment),Rl=i(),Ie=n("p"),Ie.innerHTML=_t,Wl=i(),p(he.$$.fragment),Xl=i(),ge=n("p"),ge.textContent=vt,Gl=i(),p(Ze.$$.fragment),Vl=i(),_e=n("p"),_e.textContent=zt,Ql=i(),ve=n("p"),ve.innerHTML=At,Yl=i(),p(ze.$$.fragment),xl=i(),Ae=n("p"),Ae.innerHTML=$t,El=i(),ke=n("p"),this.h()},l(e){const l=Yt("svelte-u9bgzb",document.head);c=o(l,"META",{name:!0,content:!0}),l.forEach(t),T=a(e),J=o(e,"P",{}),Rt(J).forEach(t),w=a(e),M(I.$$.fragment,e),Ne=a(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-xqfdfm"&&(h.textContent=Sl),Be=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-9vqb6y"&&(g.textContent=Ll),Re=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-gtiyni"&&(Z.innerHTML=Pl),We=a(e),M(_.$$.fragment,e),Xe=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1fbquu0"&&(v.innerHTML=Dl),Ge=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-vu54em"&&(z.textContent=Kl),Ve=a(e),M(A.$$.fragment,e),Qe=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-pmvkz7"&&($.textContent=Ol),Ye=a(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-b1zbf8"&&(k.innerHTML=et),xe=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-z50i7c"&&(N.innerHTML=lt),Ee=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ya7kyo"&&(B.innerHTML=tt),He=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-s5azty"&&(R.textContent=st),Fe=a(e),M(W.$$.fragment,e),qe=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-i6yebl"&&(X.innerHTML=it),Se=a(e),M(G.$$.fragment,e),Le=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-qiupgh"&&(V.innerHTML=at),Pe=a(e),M(Q.$$.fragment,e),De=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-k6id05"&&(Y.innerHTML=nt),Ke=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-7jzmhs"&&(x.innerHTML=ot),Oe=a(e),M(E.$$.fragment,e),el=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1n9eqy1"&&(H.textContent=rt),ll=a(e),M(F.$$.fragment,e),tl=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1rhha2m"&&(q.innerHTML=ct),sl=a(e),M(U.$$.fragment,e),il=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1xd6e24"&&(S.innerHTML=pt),al=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1eigcf8"&&(L.textContent=Mt),nl=a(e),M(P.$$.fragment,e),ol=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-11w45e"&&(D.innerHTML=dt),rl=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-aatwzz"&&(K.textContent=mt),cl=a(e),M(O.$$.fragment,e),pl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-31zx9x"&&(ee.innerHTML=ut),Ml=a(e),M(le.$$.fragment,e),dl=a(e),M(b.$$.fragment,e),ml=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1h1v7pd"&&(te.innerHTML=yt),ul=a(e),M(se.$$.fragment,e),yl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1jiyxvm"&&(ie.innerHTML=Jt),Jl=a(e),M(C.$$.fragment,e),fl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-lts8a1"&&(ae.textContent=ft),Tl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-7j1ida"&&(ne.textContent=Tt),wl=a(e),M(oe.$$.fragment,e),jl=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-10v4ms0"&&(re.innerHTML=wt),Ul=a(e),M(ce.$$.fragment,e),bl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-16h756x"&&(pe.innerHTML=jt),Cl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1p0sixi"&&(Me.textContent=Ut),Il=a(e),M(de.$$.fragment,e),hl=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-4z8yqk"&&(me.textContent=bt),gl=a(e),M(ue.$$.fragment,e),Zl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1t3y58i"&&(ye.textContent=Ct),_l=a(e),M(Je.$$.fragment,e),vl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1scrh7h"&&(fe.textContent=It),zl=a(e),M(Te.$$.fragment,e),Al=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-amfesh"&&(we.innerHTML=ht),$l=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-51ocuc"&&(je.innerHTML=gt),kl=a(e),M(Ue.$$.fragment,e),Nl=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1xalseo"&&(be.innerHTML=Zt),Bl=a(e),M(Ce.$$.fragment,e),Rl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-lcodn"&&(Ie.innerHTML=_t),Wl=a(e),M(he.$$.fragment,e),Xl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-2poiu5"&&(ge.textContent=vt),Gl=a(e),M(Ze.$$.fragment,e),Vl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1ucsuh2"&&(_e.textContent=zt),Ql=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-14j7ntv"&&(ve.innerHTML=At),Yl=a(e),M(ze.$$.fragment,e),xl=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1a07nu7"&&(Ae.innerHTML=$t),El=a(e),ke=o(e,"P",{}),Rt(ke).forEach(t),this.h()},h(){Wt(c,"name","hf:doc:metadata"),Wt(c,"content",Lt)},m(e,l){xt(document.head,c),s(e,T,l),s(e,J,l),s(e,w,l),d(I,e,l),s(e,Ne,l),s(e,h,l),s(e,Be,l),s(e,g,l),s(e,Re,l),s(e,Z,l),s(e,We,l),d(_,e,l),s(e,Xe,l),s(e,v,l),s(e,Ge,l),s(e,z,l),s(e,Ve,l),d(A,e,l),s(e,Qe,l),s(e,$,l),s(e,Ye,l),s(e,k,l),s(e,xe,l),s(e,N,l),s(e,Ee,l),s(e,B,l),s(e,He,l),s(e,R,l),s(e,Fe,l),d(W,e,l),s(e,qe,l),s(e,X,l),s(e,Se,l),d(G,e,l),s(e,Le,l),s(e,V,l),s(e,Pe,l),d(Q,e,l),s(e,De,l),s(e,Y,l),s(e,Ke,l),s(e,x,l),s(e,Oe,l),d(E,e,l),s(e,el,l),s(e,H,l),s(e,ll,l),d(F,e,l),s(e,tl,l),s(e,q,l),s(e,sl,l),d(U,e,l),s(e,il,l),s(e,S,l),s(e,al,l),s(e,L,l),s(e,nl,l),d(P,e,l),s(e,ol,l),s(e,D,l),s(e,rl,l),s(e,K,l),s(e,cl,l),d(O,e,l),s(e,pl,l),s(e,ee,l),s(e,Ml,l),d(le,e,l),s(e,dl,l),d(b,e,l),s(e,ml,l),s(e,te,l),s(e,ul,l),d(se,e,l),s(e,yl,l),s(e,ie,l),s(e,Jl,l),d(C,e,l),s(e,fl,l),s(e,ae,l),s(e,Tl,l),s(e,ne,l),s(e,wl,l),d(oe,e,l),s(e,jl,l),s(e,re,l),s(e,Ul,l),d(ce,e,l),s(e,bl,l),s(e,pe,l),s(e,Cl,l),s(e,Me,l),s(e,Il,l),d(de,e,l),s(e,hl,l),s(e,me,l),s(e,gl,l),d(ue,e,l),s(e,Zl,l),s(e,ye,l),s(e,_l,l),d(Je,e,l),s(e,vl,l),s(e,fe,l),s(e,zl,l),d(Te,e,l),s(e,Al,l),s(e,we,l),s(e,$l,l),s(e,je,l),s(e,kl,l),d(Ue,e,l),s(e,Nl,l),s(e,be,l),s(e,Bl,l),d(Ce,e,l),s(e,Rl,l),s(e,Ie,l),s(e,Wl,l),d(he,e,l),s(e,Xl,l),s(e,ge,l),s(e,Gl,l),d(Ze,e,l),s(e,Vl,l),s(e,_e,l),s(e,Ql,l),s(e,ve,l),s(e,Yl,l),d(ze,e,l),s(e,xl,l),s(e,Ae,l),s(e,El,l),s(e,ke,l),Hl=!0},p(e,[l]){const kt={};l&2&&(kt.$$scope={dirty:l,ctx:e}),U.$set(kt);const Nt={};l&2&&(Nt.$$scope={dirty:l,ctx:e}),b.$set(Nt);const Bt={};l&2&&(Bt.$$scope={dirty:l,ctx:e}),C.$set(Bt)},i(e){Hl||(m(I.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(W.$$.fragment,e),m(G.$$.fragment,e),m(Q.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(U.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(b.$$.fragment,e),m(se.$$.fragment,e),m(C.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(Je.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(Ce.$$.fragment,e),m(he.$$.fragment,e),m(Ze.$$.fragment,e),m(ze.$$.fragment,e),Hl=!0)},o(e){u(I.$$.fragment,e),u(_.$$.fragment,e),u(A.$$.fragment,e),u(W.$$.fragment,e),u(G.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(U.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(b.$$.fragment,e),u(se.$$.fragment,e),u(C.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(he.$$.fragment,e),u(Ze.$$.fragment,e),u(ze.$$.fragment,e),Hl=!1},d(e){e&&(t(T),t(J),t(w),t(Ne),t(h),t(Be),t(g),t(Re),t(Z),t(We),t(Xe),t(v),t(Ge),t(z),t(Ve),t(Qe),t($),t(Ye),t(k),t(xe),t(N),t(Ee),t(B),t(He),t(R),t(Fe),t(qe),t(X),t(Se),t(Le),t(V),t(Pe),t(De),t(Y),t(Ke),t(x),t(Oe),t(el),t(H),t(ll),t(tl),t(q),t(sl),t(il),t(S),t(al),t(L),t(nl),t(ol),t(D),t(rl),t(K),t(cl),t(pl),t(ee),t(Ml),t(dl),t(ml),t(te),t(ul),t(yl),t(ie),t(Jl),t(fl),t(ae),t(Tl),t(ne),t(wl),t(jl),t(re),t(Ul),t(bl),t(pe),t(Cl),t(Me),t(Il),t(hl),t(me),t(gl),t(Zl),t(ye),t(_l),t(vl),t(fe),t(zl),t(Al),t(we),t($l),t(je),t(kl),t(Nl),t(be),t(Bl),t(Rl),t(Ie),t(Wl),t(Xl),t(ge),t(Gl),t(Vl),t(_e),t(Ql),t(ve),t(Yl),t(xl),t(Ae),t(El),t(ke)),t(c),y(I,e),y(_,e),y(A,e),y(W,e),y(G,e),y(Q,e),y(E,e),y(F,e),y(U,e),y(P,e),y(O,e),y(le,e),y(b,e),y(se,e),y(C,e),y(oe,e),y(ce,e),y(de,e),y(ue,e),y(Je,e),y(Te,e),y(Ue,e),y(Ce,e),y(he,e),y(Ze,e),y(ze,e)}}}const Lt='{"title":"Condividere modelli personalizzati","local":"condividere-modelli-personalizzati","sections":[{"title":"Scrivere una configurazione personalizzata","local":"scrivere-una-configurazione-personalizzata","sections":[],"depth":2},{"title":"Scrivere un modello personalizzato","local":"scrivere-un-modello-personalizzato","sections":[],"depth":2},{"title":"Inviare il codice all’Hub","local":"inviare-il-codice-allhub","sections":[],"depth":2},{"title":"Usare un modello con codice personalizzato","local":"usare-un-modello-con-codice-personalizzato","sections":[],"depth":2},{"title":"Registrare un modello con codice personalizzato nelle classi Auto","local":"registrare-un-modello-con-codice-personalizzato-nelle-classi-auto","sections":[],"depth":2}],"depth":1}';function Pt(j){return Gt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Et}),[]}class ts extends Vt{constructor(c){super(),Qt(this,c,Pt,St,Xt,{})}}export{ts as component};
