import{s as it,o as rt,n as Oe}from"../chunks/scheduler.36a0863c.js";import{S as ot,i as pt,g as w,s as i,r as u,A as mt,h as b,f as a,c as r,j as ve,u as f,x as j,k as He,y as Je,a as l,v as h,d as g,t as M,w as $}from"../chunks/index.9c13489a.js";import{H as $e,g as ct}from"../chunks/Heading.88a24aaa.js";import{T as et}from"../chunks/Tip.3b06990e.js";import{Y as Ke}from"../chunks/Youtube.347c76e5.js";import{C as z}from"../chunks/CodeBlock.05d8ec32.js";import{D as dt}from"../chunks/DocNotebookDropdown.1b1fcfa3.js";import{F as nt,M as tt}from"../chunks/Markdown.4200f8dd.js";function ut(te){let o,T="Potresti vedere un warning dato che alcuni dei pesi pre-addestrati non sono stati utilizzati e altri pesi sono stati inizializzati casualmente. Non preoccuparti, è completamente normale! L’head pre-addestrata del modello BERT viene scartata e rimpiazzata da una classification head inizializzata casualmente. Farai il fine-tuning di questa nuova head del modello sul tuo compito di classificazione, trasferendogli la conoscenza del modello pre-addestrato.";return{c(){o=w("p"),o.textContent=T},l(p){o=b(p,"P",{"data-svelte-h":!0}),j(o)!=="svelte-1gl2557"&&(o.textContent=T)},m(p,J){l(p,o,J)},p:Oe,d(p){p&&a(o)}}}function ft(te){let o,T,p,J="🤗 Transformers mette a disposizione la classe <code>Trainer</code> ottimizzata per addestrare modelli 🤗 Transformers, rendendo semplice iniziare l’addestramento senza scrivere manualmente il tuo ciclo di addestramento. L’API <code>Trainer</code> supporta un’ampia gamma di opzioni e funzionalità di addestramento come logging, gradient accumulation e mixed precision.",v,F,ne='Inizia caricando il tuo modello e specificando il numero di etichette (labels) attese. Nel dataset Yelp Review <a href="https://huggingface.co/datasets/yelp_review_full#data-fields" rel="nofollow">dataset card</a>, sai che ci sono cinque etichette:',Y,_,q,G,L,x,C,k,ae='Successivamente, crea una classe <code>TrainingArguments</code> contenente tutti gli iperparametri che si possono regore nonché le variabili per attivare le differenti opzioni di addestramento. Per questa esercitazione puoi iniziare con gli <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">iperparametri</a> di ddestramento predefiniti, ma sentiti libero di sperimentare per trovare la configurazione ottimale per te.',B,se,V="Specifica dove salvare i checkpoints del tuo addestramento:",A,Z,E,S,W,Q,ce='<code>Trainer</code> non valuta automaticamente le performance del modello durante l’addestramento. Dovrai passare a <code>Trainer</code> una funzione che calcola e restituisce le metriche. La libreria 🤗 Datasets mette a disposizione una semplice funzione <a href="https://huggingface.co/metrics/accuracy" rel="nofollow"><code>accuracy</code></a> che puoi caricare con la funzione <code>load_metric</code> (guarda questa <a href="https://huggingface.co/docs/datasets/metrics.html" rel="nofollow">esercitazione</a> per maggiori informazioni):',U,X,H,oe,P="Richiama <code>compute</code> su <code>metric</code> per calcolare l’accuratezza delle tue previsioni. Prima di passare le tue previsioni a <code>compute</code>, hai bisogno di convertirle in logits (ricorda che tutti i modelli 🤗 Transformers restituiscono logits):",I,R,n,y,ie="Se preferisci monitorare le tue metriche di valutazione durante il fine-tuning, specifica il parametro <code>evaluation_strategy</code> nei tuoi training arguments per restituire le metriche di valutazione ad ogni epoca di addestramento:",pe,D,de,K,fe,me,le="Crea un oggetto <code>Trainer</code> col tuo modello, training arguments, dataset di training e test, e funzione di valutazione:",Me,N,we,O,he="Poi metti a punto il modello richiamando <code>train()</code>:",re,ee,ue;return o=new Ke({props:{id:"nvBXf7s7vTI"}}),_=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),G=new et({props:{$$slots:{default:[ut]},$$scope:{ctx:te}}}),x=new $e({props:{title:"Iperparametri per il training",local:"iperparametri-per-il-training",headingTag:"h3"}}),Z=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>)`,wrap:!1}}),S=new $e({props:{title:"Metriche",local:"metriche",headingTag:"h3"}}),X=new z({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJhY2N1cmFjeSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),R=new z({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),D=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyhvdXRwdXRfZGlyJTNEJTIydGVzdF90cmFpbmVyJTIyJTJDJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)`,wrap:!1}}),K=new $e({props:{title:"Trainer",local:"trainer",headingTag:"h3"}}),N=new z({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHNtYWxsX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ee=new z({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),{c(){u(o.$$.fragment),T=i(),p=w("p"),p.innerHTML=J,v=i(),F=w("p"),F.innerHTML=ne,Y=i(),u(_.$$.fragment),q=i(),u(G.$$.fragment),L=i(),u(x.$$.fragment),C=i(),k=w("p"),k.innerHTML=ae,B=i(),se=w("p"),se.textContent=V,A=i(),u(Z.$$.fragment),E=i(),u(S.$$.fragment),W=i(),Q=w("p"),Q.innerHTML=ce,U=i(),u(X.$$.fragment),H=i(),oe=w("p"),oe.innerHTML=P,I=i(),u(R.$$.fragment),n=i(),y=w("p"),y.innerHTML=ie,pe=i(),u(D.$$.fragment),de=i(),u(K.$$.fragment),fe=i(),me=w("p"),me.innerHTML=le,Me=i(),u(N.$$.fragment),we=i(),O=w("p"),O.innerHTML=he,re=i(),u(ee.$$.fragment)},l(s){f(o.$$.fragment,s),T=r(s),p=b(s,"P",{"data-svelte-h":!0}),j(p)!=="svelte-w7p6ip"&&(p.innerHTML=J),v=r(s),F=b(s,"P",{"data-svelte-h":!0}),j(F)!=="svelte-tdx1mf"&&(F.innerHTML=ne),Y=r(s),f(_.$$.fragment,s),q=r(s),f(G.$$.fragment,s),L=r(s),f(x.$$.fragment,s),C=r(s),k=b(s,"P",{"data-svelte-h":!0}),j(k)!=="svelte-ae6lm"&&(k.innerHTML=ae),B=r(s),se=b(s,"P",{"data-svelte-h":!0}),j(se)!=="svelte-1b2tmkh"&&(se.textContent=V),A=r(s),f(Z.$$.fragment,s),E=r(s),f(S.$$.fragment,s),W=r(s),Q=b(s,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-xr4ry3"&&(Q.innerHTML=ce),U=r(s),f(X.$$.fragment,s),H=r(s),oe=b(s,"P",{"data-svelte-h":!0}),j(oe)!=="svelte-1i3t4rh"&&(oe.innerHTML=P),I=r(s),f(R.$$.fragment,s),n=r(s),y=b(s,"P",{"data-svelte-h":!0}),j(y)!=="svelte-ijtp5w"&&(y.innerHTML=ie),pe=r(s),f(D.$$.fragment,s),de=r(s),f(K.$$.fragment,s),fe=r(s),me=b(s,"P",{"data-svelte-h":!0}),j(me)!=="svelte-5ioy4b"&&(me.innerHTML=le),Me=r(s),f(N.$$.fragment,s),we=r(s),O=b(s,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1y3qbve"&&(O.innerHTML=he),re=r(s),f(ee.$$.fragment,s)},m(s,d){h(o,s,d),l(s,T,d),l(s,p,d),l(s,v,d),l(s,F,d),l(s,Y,d),h(_,s,d),l(s,q,d),h(G,s,d),l(s,L,d),h(x,s,d),l(s,C,d),l(s,k,d),l(s,B,d),l(s,se,d),l(s,A,d),h(Z,s,d),l(s,E,d),h(S,s,d),l(s,W,d),l(s,Q,d),l(s,U,d),h(X,s,d),l(s,H,d),l(s,oe,d),l(s,I,d),h(R,s,d),l(s,n,d),l(s,y,d),l(s,pe,d),h(D,s,d),l(s,de,d),h(K,s,d),l(s,fe,d),l(s,me,d),l(s,Me,d),h(N,s,d),l(s,we,d),l(s,O,d),l(s,re,d),h(ee,s,d),ue=!0},p(s,d){const be={};d&2&&(be.$$scope={dirty:d,ctx:s}),G.$set(be)},i(s){ue||(g(o.$$.fragment,s),g(_.$$.fragment,s),g(G.$$.fragment,s),g(x.$$.fragment,s),g(Z.$$.fragment,s),g(S.$$.fragment,s),g(X.$$.fragment,s),g(R.$$.fragment,s),g(D.$$.fragment,s),g(K.$$.fragment,s),g(N.$$.fragment,s),g(ee.$$.fragment,s),ue=!0)},o(s){M(o.$$.fragment,s),M(_.$$.fragment,s),M(G.$$.fragment,s),M(x.$$.fragment,s),M(Z.$$.fragment,s),M(S.$$.fragment,s),M(X.$$.fragment,s),M(R.$$.fragment,s),M(D.$$.fragment,s),M(K.$$.fragment,s),M(N.$$.fragment,s),M(ee.$$.fragment,s),ue=!1},d(s){s&&(a(T),a(p),a(v),a(F),a(Y),a(q),a(L),a(C),a(k),a(B),a(se),a(A),a(E),a(W),a(Q),a(U),a(H),a(oe),a(I),a(n),a(y),a(pe),a(de),a(fe),a(me),a(Me),a(we),a(O),a(re)),$(o,s),$(_,s),$(G,s),$(x,s),$(Z,s),$(S,s),$(X,s),$(R,s),$(D,s),$(K,s),$(N,s),$(ee,s)}}}function ht(te){let o,T;return o=new tt({props:{$$slots:{default:[ft]},$$scope:{ctx:te}}}),{c(){u(o.$$.fragment)},l(p){f(o.$$.fragment,p)},m(p,J){h(o,p,J),T=!0},p(p,J){const v={};J&2&&(v.$$scope={dirty:J,ctx:p}),o.$set(v)},i(p){T||(g(o.$$.fragment,p),T=!0)},o(p){M(o.$$.fragment,p),T=!1},d(p){$(o,p)}}}function gt(te){let o,T="<code>Trainer</code> usa <code>DataCollatorWithPadding</code> in maniera predefinita in modo da non dover specificare esplicitamente un collettore di dati.";return{c(){o=w("p"),o.innerHTML=T},l(p){o=b(p,"P",{"data-svelte-h":!0}),j(o)!=="svelte-1qdpgxe"&&(o.innerHTML=T)},m(p,J){l(p,o,J)},p:Oe,d(p){p&&a(o)}}}function Mt(te){let o,T,p,J,v,F="I modelli 🤗 Transformers supportano anche l’addestramento in TensorFlow usando l’API di Keras.",ne,Y,_,q,G="Il <code>DefaultDataCollator</code> assembla tensori in lotti su cui il modello si addestrerà. Assicurati di specificare di restituire tensori per TensorFlow in <code>return_tensors</code>:",L,x,C,k,ae,B,se='Successivamente, converti i datasets tokenizzati in TensorFlow datasets con il metodo <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html#datasets.Dataset.to_tf_dataset" rel="nofollow"><code>to_tf_dataset</code></a>. Specifica il tuo input in <code>columns</code> e le tue etichette in <code>label_cols</code>:',V,A,Z,E,S,W,Q="Carica un modello TensorFlow col numero atteso di etichette:",ce,U,X,H,oe='Poi compila e fai il fine-tuning del tuo modello usando <a href="https://keras.io/api/models/model_training_apis/" rel="nofollow"><code>fit</code></a> come faresti con qualsiasi altro modello di Keras:',P,I,R;return p=new Ke({props:{id:"rnTGBy2ax1c"}}),Y=new $e({props:{title:"Convertire dataset nel formato per TensorFlow",local:"convertire-dataset-nel-formato-per-tensorflow",headingTag:"h3"}}),x=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),k=new et({props:{$$slots:{default:[gt]},$$scope:{ctx:te}}}),A=new z({props:{code:"dGZfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNtYWxsX3RyYWluX2RhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEEpJTBBJTBBdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZXZhbF9kYXRhc2V0LnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = small_train_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_dataset = small_eval_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new $e({props:{title:"Compilazione e addestramento",local:"compilazione-e-addestramento",headingTag:"h3"}}),U=new z({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),I=new z({props:{code:"bW9kZWwuY29tcGlsZSglMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0R0Zi5rZXJhcy5vcHRpbWl6ZXJzLkFkYW0obGVhcm5pbmdfcmF0ZSUzRDVlLTUpJTJDJTBBJTIwJTIwJTIwJTIwbG9zcyUzRHRmLmtlcmFzLmxvc3Nlcy5TcGFyc2VDYXRlZ29yaWNhbENyb3NzZW50cm9weShmcm9tX2xvZ2l0cyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUzRHRmLm1ldHJpY3MuU3BhcnNlQ2F0ZWdvcmljYWxBY2N1cmFjeSgpJTJDJTBBKSUwQSUwQW1vZGVsLmZpdCh0Zl90cmFpbl9kYXRhc2V0JTJDJTIwdmFsaWRhdGlvbl9kYXRhJTNEdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTJDJTIwZXBvY2hzJTNEMyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(
<span class="hljs-meta">... </span>    optimizer=tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>),
<span class="hljs-meta">... </span>    loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    metrics=tf.metrics.SparseCategoricalAccuracy(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)`,wrap:!1}}),{c(){o=w("a"),T=i(),u(p.$$.fragment),J=i(),v=w("p"),v.textContent=F,ne=i(),u(Y.$$.fragment),_=i(),q=w("p"),q.innerHTML=G,L=i(),u(x.$$.fragment),C=i(),u(k.$$.fragment),ae=i(),B=w("p"),B.innerHTML=se,V=i(),u(A.$$.fragment),Z=i(),u(E.$$.fragment),S=i(),W=w("p"),W.textContent=Q,ce=i(),u(U.$$.fragment),X=i(),H=w("p"),H.innerHTML=oe,P=i(),u(I.$$.fragment),this.h()},l(n){o=b(n,"A",{id:!0}),ve(o).forEach(a),T=r(n),f(p.$$.fragment,n),J=r(n),v=b(n,"P",{"data-svelte-h":!0}),j(v)!=="svelte-1czjgf4"&&(v.textContent=F),ne=r(n),f(Y.$$.fragment,n),_=r(n),q=b(n,"P",{"data-svelte-h":!0}),j(q)!=="svelte-18ilv9j"&&(q.innerHTML=G),L=r(n),f(x.$$.fragment,n),C=r(n),f(k.$$.fragment,n),ae=r(n),B=b(n,"P",{"data-svelte-h":!0}),j(B)!=="svelte-10qeq0e"&&(B.innerHTML=se),V=r(n),f(A.$$.fragment,n),Z=r(n),f(E.$$.fragment,n),S=r(n),W=b(n,"P",{"data-svelte-h":!0}),j(W)!=="svelte-7tvbf1"&&(W.textContent=Q),ce=r(n),f(U.$$.fragment,n),X=r(n),H=b(n,"P",{"data-svelte-h":!0}),j(H)!=="svelte-q3nlbx"&&(H.innerHTML=oe),P=r(n),f(I.$$.fragment,n),this.h()},h(){He(o,"id","keras")},m(n,y){l(n,o,y),l(n,T,y),h(p,n,y),l(n,J,y),l(n,v,y),l(n,ne,y),h(Y,n,y),l(n,_,y),l(n,q,y),l(n,L,y),h(x,n,y),l(n,C,y),h(k,n,y),l(n,ae,y),l(n,B,y),l(n,V,y),h(A,n,y),l(n,Z,y),h(E,n,y),l(n,S,y),l(n,W,y),l(n,ce,y),h(U,n,y),l(n,X,y),l(n,H,y),l(n,P,y),h(I,n,y),R=!0},p(n,y){const ie={};y&2&&(ie.$$scope={dirty:y,ctx:n}),k.$set(ie)},i(n){R||(g(p.$$.fragment,n),g(Y.$$.fragment,n),g(x.$$.fragment,n),g(k.$$.fragment,n),g(A.$$.fragment,n),g(E.$$.fragment,n),g(U.$$.fragment,n),g(I.$$.fragment,n),R=!0)},o(n){M(p.$$.fragment,n),M(Y.$$.fragment,n),M(x.$$.fragment,n),M(k.$$.fragment,n),M(A.$$.fragment,n),M(E.$$.fragment,n),M(U.$$.fragment,n),M(I.$$.fragment,n),R=!1},d(n){n&&(a(o),a(T),a(J),a(v),a(ne),a(_),a(q),a(L),a(C),a(ae),a(B),a(V),a(Z),a(S),a(W),a(ce),a(X),a(H),a(P)),$(p,n),$(Y,n),$(x,n),$(k,n),$(A,n),$(E,n),$(U,n),$(I,n)}}}function $t(te){let o,T;return o=new tt({props:{$$slots:{default:[Mt]},$$scope:{ctx:te}}}),{c(){u(o.$$.fragment)},l(p){f(o.$$.fragment,p)},m(p,J){h(o,p,J),T=!0},p(p,J){const v={};J&2&&(v.$$scope={dirty:J,ctx:p}),o.$set(v)},i(p){T||(g(o.$$.fragment,p),T=!0)},o(p){M(o.$$.fragment,p),T=!1},d(p){$(o,p)}}}function wt(te){let o,T='Ottieni l’accesso gratuito a una GPU sul cloud se non ne possiedi una usando un notebook sul web come <a href="https://colab.research.google.com/" rel="nofollow">Colaboratory</a> o <a href="https://studiolab.sagemaker.aws/" rel="nofollow">SageMaker StudioLab</a>.';return{c(){o=w("p"),o.innerHTML=T},l(p){o=b(p,"P",{"data-svelte-h":!0}),j(o)!=="svelte-1uxpyqe"&&(o.innerHTML=T)},m(p,J){l(p,o,J)},p:Oe,d(p){p&&a(o)}}}function bt(te){let o,T,p,J="<code>Trainer</code> si occupa del ciclo di addestramento e ti consente di mettere a punto un modello con una sola riga di codice. Per chi preferisse scrivere un proprio ciclo di addestramento personale, puoi anche fare il fine-tuning di un modello 🤗 Transformers in PyTorch nativo.",v,F,ne="A questo punto, potresti avere bisogno di riavviare il tuo notebook o eseguire il seguente codice per liberare un po’ di memoria:",Y,_,q,G,L="Successivamente, postprocessa manualmente il <code>tokenized_dataset</code> per prepararlo ad essere allenato.",x,C,k,ae,B="Rimuovi la colonna <code>text</code> perché il modello non accetta testo grezzo come input:",se,V,A,Z,E,S="Rinomina la colonna <code>label</code> in <code>labels</code> perché il modello si aspetta che questo argomento si chiami <code>labels</code>:",W,Q,ce,U,X,H="Imposta il formato del dataset per farti restituire tensori di PyTorch all’interno delle liste:",oe,P,I,R,n="Poi crea un piccolo sottocampione del dataset come visto precedentemente per velocizzare il fine-tuning:",y,ie,pe,D,de,K,fe="Crea un <code>DataLoader</code> per i tuoi datasets di train e test così puoi iterare sui lotti di dati:",me,le,Me,N,we="Carica il tuo modello con il numero atteso di etichette:",O,he,re,ee,ue,s,d='Crea un ottimizzatore e il learning rate scheduler per fare il fine-tuning del modello. Usa l’ottimizzatore <a href="https://pytorch.org/docs/stable/generated/torch.optim.AdamW.html" rel="nofollow"><code>AdamW</code></a> di PyTorch:',be,ge,ze,ye,ke="Crea il learning rate scheduler predefinito da <code>Trainer</code>:",Ce,Te,_e,je,t="Infine specifica come <code>device</code> da usare una GPU se ne hai una. Altrimenti, l’addestramento su una CPU può richiedere diverse ore invece di un paio di minuti.",m,Ze,Ie,Ue,Ye,Re,at="Ottimo, adesso possiamo addestrare! 🥳",Ee,Ge,Ne,We,st='Per tenere traccia dei tuoi progressi durante l’addestramento, usa la libreria <a href="https://tqdm.github.io/" rel="nofollow">tqdm</a> per aggiungere una progress bar sopra il numero dei passi di addestramento:',Ae,Xe,Qe,Fe,qe,xe,lt='Proprio come è necessario aggiungere una funzione di valutazione del <code>Trainer</code>, è necessario fare lo stesso quando si scrive il proprio ciclo di addestramento. Ma invece di calcolare e riportare la metrica alla fine di ogni epoca, questa volta accumulerai tutti i batch con <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html?highlight=add_batch#datasets.Metric.add_batch" rel="nofollow"><code>add_batch</code></a> e calcolerai la metrica alla fine.',Le,Be,Se;return o=new Ke({props:{id:"Dh9CL8fyG80"}}),_=new z({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBweXRvcmNoX21vZGVsJTBBZGVsJTIwdHJhaW5lciUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pytorch_model
<span class="hljs-keyword">del</span> trainer
torch.cuda.empty_cache()`,wrap:!1}}),V=new z({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnRleHQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])',wrap:!1}}),Q=new z({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)',wrap:!1}}),P=new z({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzLnNldF9mb3JtYXQoJTIydG9yY2glMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)',wrap:!1}}),ie=new z({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),D=new $e({props:{title:"DataLoader",local:"dataloader",headingTag:"h3"}}),le=new z({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoc21hbGxfdHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDgpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(small_train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataloader = DataLoader(small_eval_dataset, batch_size=<span class="hljs-number">8</span>)`,wrap:!1}}),he=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),ee=new $e({props:{title:"Ottimizzatore e learning rate scheduler",local:"ottimizzatore-e-learning-rate-scheduler",headingTag:"h3"}}),ge=new z({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Te=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybGluZWFyJTIyJTJDJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RudW1fdHJhaW5pbmdfc3RlcHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_scheduler(
<span class="hljs-meta">... </span>    name=<span class="hljs-string">&quot;linear&quot;</span>, optimizer=optimizer, num_warmup_steps=<span class="hljs-number">0</span>, num_training_steps=num_training_steps
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ze=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),Ue=new et({props:{$$slots:{default:[wt]},$$scope:{ctx:te}}}),Ge=new $e({props:{title:"Training loop",local:"training-loop",headingTag:"h3"}}),Xe=new z({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Fe=new $e({props:{title:"Metriche",local:"metriche",headingTag:"h3"}}),Be=new z({props:{code:"bWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyYWNjdXJhY3klMjIpJTBBbW9kZWwuZXZhbCgpJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljLmFkZF9iYXRjaChwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEKSUwQSUwQW1ldHJpYy5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
<span class="hljs-meta">... </span>    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**batch)

<span class="hljs-meta">... </span>    logits = outputs.logits
<span class="hljs-meta">... </span>    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`,wrap:!1}}),{c(){u(o.$$.fragment),T=i(),p=w("p"),p.innerHTML=J,v=i(),F=w("p"),F.textContent=ne,Y=i(),u(_.$$.fragment),q=i(),G=w("p"),G.innerHTML=L,x=i(),C=w("ol"),k=w("li"),ae=w("p"),ae.innerHTML=B,se=i(),u(V.$$.fragment),A=i(),Z=w("li"),E=w("p"),E.innerHTML=S,W=i(),u(Q.$$.fragment),ce=i(),U=w("li"),X=w("p"),X.textContent=H,oe=i(),u(P.$$.fragment),I=i(),R=w("p"),R.textContent=n,y=i(),u(ie.$$.fragment),pe=i(),u(D.$$.fragment),de=i(),K=w("p"),K.innerHTML=fe,me=i(),u(le.$$.fragment),Me=i(),N=w("p"),N.textContent=we,O=i(),u(he.$$.fragment),re=i(),u(ee.$$.fragment),ue=i(),s=w("p"),s.innerHTML=d,be=i(),u(ge.$$.fragment),ze=i(),ye=w("p"),ye.innerHTML=ke,Ce=i(),u(Te.$$.fragment),_e=i(),je=w("p"),je.innerHTML=t,m=i(),u(Ze.$$.fragment),Ie=i(),u(Ue.$$.fragment),Ye=i(),Re=w("p"),Re.textContent=at,Ee=i(),u(Ge.$$.fragment),Ne=i(),We=w("p"),We.innerHTML=st,Ae=i(),u(Xe.$$.fragment),Qe=i(),u(Fe.$$.fragment),qe=i(),xe=w("p"),xe.innerHTML=lt,Le=i(),u(Be.$$.fragment)},l(e){f(o.$$.fragment,e),T=r(e),p=b(e,"P",{"data-svelte-h":!0}),j(p)!=="svelte-1czap62"&&(p.innerHTML=J),v=r(e),F=b(e,"P",{"data-svelte-h":!0}),j(F)!=="svelte-1jv7qcp"&&(F.textContent=ne),Y=r(e),f(_.$$.fragment,e),q=r(e),G=b(e,"P",{"data-svelte-h":!0}),j(G)!=="svelte-p1uyrm"&&(G.innerHTML=L),x=r(e),C=b(e,"OL",{});var c=ve(C);k=b(c,"LI",{});var Ve=ve(k);ae=b(Ve,"P",{"data-svelte-h":!0}),j(ae)!=="svelte-unbmvy"&&(ae.innerHTML=B),se=r(Ve),f(V.$$.fragment,Ve),Ve.forEach(a),A=r(c),Z=b(c,"LI",{});var Pe=ve(Z);E=b(Pe,"P",{"data-svelte-h":!0}),j(E)!=="svelte-zdvzgi"&&(E.innerHTML=S),W=r(Pe),f(Q.$$.fragment,Pe),Pe.forEach(a),ce=r(c),U=b(c,"LI",{});var De=ve(U);X=b(De,"P",{"data-svelte-h":!0}),j(X)!=="svelte-ufikes"&&(X.textContent=H),oe=r(De),f(P.$$.fragment,De),De.forEach(a),c.forEach(a),I=r(e),R=b(e,"P",{"data-svelte-h":!0}),j(R)!=="svelte-6j1d26"&&(R.textContent=n),y=r(e),f(ie.$$.fragment,e),pe=r(e),f(D.$$.fragment,e),de=r(e),K=b(e,"P",{"data-svelte-h":!0}),j(K)!=="svelte-1wjjxmk"&&(K.innerHTML=fe),me=r(e),f(le.$$.fragment,e),Me=r(e),N=b(e,"P",{"data-svelte-h":!0}),j(N)!=="svelte-k6va0p"&&(N.textContent=we),O=r(e),f(he.$$.fragment,e),re=r(e),f(ee.$$.fragment,e),ue=r(e),s=b(e,"P",{"data-svelte-h":!0}),j(s)!=="svelte-q4abxx"&&(s.innerHTML=d),be=r(e),f(ge.$$.fragment,e),ze=r(e),ye=b(e,"P",{"data-svelte-h":!0}),j(ye)!=="svelte-1o911h5"&&(ye.innerHTML=ke),Ce=r(e),f(Te.$$.fragment,e),_e=r(e),je=b(e,"P",{"data-svelte-h":!0}),j(je)!=="svelte-jmyeit"&&(je.innerHTML=t),m=r(e),f(Ze.$$.fragment,e),Ie=r(e),f(Ue.$$.fragment,e),Ye=r(e),Re=b(e,"P",{"data-svelte-h":!0}),j(Re)!=="svelte-1x4skh5"&&(Re.textContent=at),Ee=r(e),f(Ge.$$.fragment,e),Ne=r(e),We=b(e,"P",{"data-svelte-h":!0}),j(We)!=="svelte-yb503k"&&(We.innerHTML=st),Ae=r(e),f(Xe.$$.fragment,e),Qe=r(e),f(Fe.$$.fragment,e),qe=r(e),xe=b(e,"P",{"data-svelte-h":!0}),j(xe)!=="svelte-1eki98u"&&(xe.innerHTML=lt),Le=r(e),f(Be.$$.fragment,e)},m(e,c){h(o,e,c),l(e,T,c),l(e,p,c),l(e,v,c),l(e,F,c),l(e,Y,c),h(_,e,c),l(e,q,c),l(e,G,c),l(e,x,c),l(e,C,c),Je(C,k),Je(k,ae),Je(k,se),h(V,k,null),Je(C,A),Je(C,Z),Je(Z,E),Je(Z,W),h(Q,Z,null),Je(C,ce),Je(C,U),Je(U,X),Je(U,oe),h(P,U,null),l(e,I,c),l(e,R,c),l(e,y,c),h(ie,e,c),l(e,pe,c),h(D,e,c),l(e,de,c),l(e,K,c),l(e,me,c),h(le,e,c),l(e,Me,c),l(e,N,c),l(e,O,c),h(he,e,c),l(e,re,c),h(ee,e,c),l(e,ue,c),l(e,s,c),l(e,be,c),h(ge,e,c),l(e,ze,c),l(e,ye,c),l(e,Ce,c),h(Te,e,c),l(e,_e,c),l(e,je,c),l(e,m,c),h(Ze,e,c),l(e,Ie,c),h(Ue,e,c),l(e,Ye,c),l(e,Re,c),l(e,Ee,c),h(Ge,e,c),l(e,Ne,c),l(e,We,c),l(e,Ae,c),h(Xe,e,c),l(e,Qe,c),h(Fe,e,c),l(e,qe,c),l(e,xe,c),l(e,Le,c),h(Be,e,c),Se=!0},p(e,c){const Ve={};c&2&&(Ve.$$scope={dirty:c,ctx:e}),Ue.$set(Ve)},i(e){Se||(g(o.$$.fragment,e),g(_.$$.fragment,e),g(V.$$.fragment,e),g(Q.$$.fragment,e),g(P.$$.fragment,e),g(ie.$$.fragment,e),g(D.$$.fragment,e),g(le.$$.fragment,e),g(he.$$.fragment,e),g(ee.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(Ze.$$.fragment,e),g(Ue.$$.fragment,e),g(Ge.$$.fragment,e),g(Xe.$$.fragment,e),g(Fe.$$.fragment,e),g(Be.$$.fragment,e),Se=!0)},o(e){M(o.$$.fragment,e),M(_.$$.fragment,e),M(V.$$.fragment,e),M(Q.$$.fragment,e),M(P.$$.fragment,e),M(ie.$$.fragment,e),M(D.$$.fragment,e),M(le.$$.fragment,e),M(he.$$.fragment,e),M(ee.$$.fragment,e),M(ge.$$.fragment,e),M(Te.$$.fragment,e),M(Ze.$$.fragment,e),M(Ue.$$.fragment,e),M(Ge.$$.fragment,e),M(Xe.$$.fragment,e),M(Fe.$$.fragment,e),M(Be.$$.fragment,e),Se=!1},d(e){e&&(a(T),a(p),a(v),a(F),a(Y),a(q),a(G),a(x),a(C),a(I),a(R),a(y),a(pe),a(de),a(K),a(me),a(Me),a(N),a(O),a(re),a(ue),a(s),a(be),a(ze),a(ye),a(Ce),a(_e),a(je),a(m),a(Ie),a(Ye),a(Re),a(Ee),a(Ne),a(We),a(Ae),a(Qe),a(qe),a(xe),a(Le)),$(o,e),$(_,e),$(V),$(Q),$(P),$(ie,e),$(D,e),$(le,e),$(he,e),$(ee,e),$(ge,e),$(Te,e),$(Ze,e),$(Ue,e),$(Ge,e),$(Xe,e),$(Fe,e),$(Be,e)}}}function yt(te){let o,T;return o=new tt({props:{$$slots:{default:[bt]},$$scope:{ctx:te}}}),{c(){u(o.$$.fragment)},l(p){f(o.$$.fragment,p)},m(p,J){h(o,p,J),T=!0},p(p,J){const v={};J&2&&(v.$$scope={dirty:J,ctx:p}),o.$set(v)},i(p){T||(g(o.$$.fragment,p),T=!0)},o(p){M(o.$$.fragment,p),T=!1},d(p){$(o,p)}}}function Tt(te){let o,T,p,J,v,F,ne,Y,_,q="Ci sono benefici significativi nell’usare un modello pre-addestrato. Si riducono i costi computazionali, l’impronta di carbonio e ti consente di usare modelli stato dell’arte senza doverli addestrare da zero. 🤗 Transformers consente l’accesso a migliaia di modelli pre-addestrati per un’ampia gamma di compiti. Quando usi un modello pre-addestrato, lo alleni su un dataset specifico per il tuo compito. Questo è conosciuto come fine-tuning, una tecnica di addestramento incredibilmente potente. In questa esercitazione, potrai fare il fine-tuning di un modello pre-addestrato, con un framework di deep learning a tua scelta:",G,L,x="<li>Fine-tuning di un modello pre-addestrato con 🤗 Transformers <code>Trainer</code>.</li> <li>Fine-tuning di un modello pre-addestrato in TensorFlow con Keras.</li> <li>Fine-tuning di un modello pre-addestrato con PyTorch.</li>",C,k,ae,B,se,V,A,Z,E="Prima di poter fare il fine-tuning di un modello pre-addestrato, scarica un dataset e preparalo per l’addestramento. La precedente esercitazione ti ha mostrato come processare i dati per l’addestramento e adesso hai l’opportunità di metterti alla prova!",S,W,Q='Inizia caricando il dataset <a href="https://huggingface.co/datasets/yelp_review_full" rel="nofollow">Yelp Reviews</a>:',ce,U,X,H,oe='Come già sai, hai bisogno di un tokenizer per processare il testo e includere una strategia di padding e truncation per gestire sequenze di lunghezza variabile. Per processare il dataset in un unico passo, usa il metodo <a href="https://huggingface.co/docs/datasets/process.html#map" rel="nofollow"><code>map</code></a> di 🤗 Datasets che applica la funzione di preprocessing all’intero dataset:',P,I,R,n,y="Se vuoi, puoi creare un sottoinsieme più piccolo del dataset per il fine-tuning così da ridurre il tempo necessario:",ie,pe,D,de,K,fe,me,le,Me,N,we,O,he,re,ee,ue,s,d,be,ge,ze="Per altri esempi sul fine-tuning, fai riferimento a:",ye,ke,Ce='<li><p><a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers Examples</a> include scripts per addestrare compiti comuni di NLP in PyTorch e TensorFlow.</p></li> <li><p><a href="notebooks">🤗 Transformers Notebooks</a> contiene diversi notebooks su come mettere a punto un modello per compiti specifici in PyTorch e TensorFlow.</p></li>',Te,_e,je;return v=new $e({props:{title:"Fine-tuning di un modello pre-addestrato",local:"fine-tuning-di-un-modello-pre-addestrato",headingTag:"h1"}}),ne=new dt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/training.ipynb"}]}}),B=new $e({props:{title:"Preparare un dataset",local:"preparare-un-dataset",headingTag:"h2"}}),V=new Ke({props:{id:"_BZearw7f0w"}}),U=new z({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5ZWxwX3Jldmlld19mdWxsJTIyKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCU1QjEwMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;yelp_review_full&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">100</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My expectations for McDonalds are t rarely high. But for one to still fail so spectacularly...that takes something special!\\\\nThe cashier took my friends\\&#x27;s order, then promptly ignored me. I had to force myself in front of a cashier who opened his register to wait on the person BEHIND me. I waited over five minutes for a gigantic order that included precisely one kid\\&#x27;s meal. After watching two people who ordered after me be handed their food, I asked where mine was. The manager started yelling at the cashiers for \\\\&quot;serving off their orders\\\\&quot; when they didn\\&#x27;t have their food. But neither cashier was anywhere near those controls, and the manager was the one serving food to customers and clearing the boards.\\\\nThe manager was rude when giving me my order. She didn\\&#x27;t make sure that I had everything ON MY RECEIPT, and never even had the decency to apologize that I felt I was getting poor service.\\\\nI\\&#x27;ve eaten at various McDonalds restaurants for over 30 years. I\\&#x27;ve worked at more than one location. I expect bad days, bad moods, and the occasional mistake. But I have yet to have a decent experience at this store. It will remain a place I avoid unless someone in my party needs to avoid illness from low blood sugar. Perhaps I should go back to the racially biased service of Steak n Shake instead!&#x27;</span>}`,wrap:!1}}),I=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTBBZGVmJTIwdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydGV4dCUyMiU1RCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAodG9rZW5pemVfZnVuY3Rpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new z({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),fe=new $e({props:{title:"Addestramento",local:"addestramento",headingTag:"h2"}}),le=new nt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[$t],pytorch:[ht]},$$scope:{ctx:te}}}),O=new $e({props:{title:"Addestramento in PyTorch nativo",local:"addestramento-in-pytorch-nativo",headingTag:"h2"}}),re=new nt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[yt]},$$scope:{ctx:te}}}),d=new $e({props:{title:"Altre risorse",local:"altre-risorse",headingTag:"h2"}}),{c(){o=w("meta"),T=i(),p=w("p"),J=i(),u(v.$$.fragment),F=i(),u(ne.$$.fragment),Y=i(),_=w("p"),_.textContent=q,G=i(),L=w("ul"),L.innerHTML=x,C=i(),k=w("a"),ae=i(),u(B.$$.fragment),se=i(),u(V.$$.fragment),A=i(),Z=w("p"),Z.textContent=E,S=i(),W=w("p"),W.innerHTML=Q,ce=i(),u(U.$$.fragment),X=i(),H=w("p"),H.innerHTML=oe,P=i(),u(I.$$.fragment),R=i(),n=w("p"),n.textContent=y,ie=i(),u(pe.$$.fragment),D=i(),de=w("a"),K=i(),u(fe.$$.fragment),me=i(),u(le.$$.fragment),Me=i(),N=w("a"),we=i(),u(O.$$.fragment),he=i(),u(re.$$.fragment),ee=i(),ue=w("a"),s=i(),u(d.$$.fragment),be=i(),ge=w("p"),ge.textContent=ze,ye=i(),ke=w("ul"),ke.innerHTML=Ce,Te=i(),_e=w("p"),this.h()},l(t){const m=mt("svelte-u9bgzb",document.head);o=b(m,"META",{name:!0,content:!0}),m.forEach(a),T=r(t),p=b(t,"P",{}),ve(p).forEach(a),J=r(t),f(v.$$.fragment,t),F=r(t),f(ne.$$.fragment,t),Y=r(t),_=b(t,"P",{"data-svelte-h":!0}),j(_)!=="svelte-gx4agk"&&(_.textContent=q),G=r(t),L=b(t,"UL",{"data-svelte-h":!0}),j(L)!=="svelte-cwrdoc"&&(L.innerHTML=x),C=r(t),k=b(t,"A",{id:!0}),ve(k).forEach(a),ae=r(t),f(B.$$.fragment,t),se=r(t),f(V.$$.fragment,t),A=r(t),Z=b(t,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-n29iv5"&&(Z.textContent=E),S=r(t),W=b(t,"P",{"data-svelte-h":!0}),j(W)!=="svelte-128hpxg"&&(W.innerHTML=Q),ce=r(t),f(U.$$.fragment,t),X=r(t),H=b(t,"P",{"data-svelte-h":!0}),j(H)!=="svelte-199xk0z"&&(H.innerHTML=oe),P=r(t),f(I.$$.fragment,t),R=r(t),n=b(t,"P",{"data-svelte-h":!0}),j(n)!=="svelte-14sxrz7"&&(n.textContent=y),ie=r(t),f(pe.$$.fragment,t),D=r(t),de=b(t,"A",{id:!0}),ve(de).forEach(a),K=r(t),f(fe.$$.fragment,t),me=r(t),f(le.$$.fragment,t),Me=r(t),N=b(t,"A",{id:!0}),ve(N).forEach(a),we=r(t),f(O.$$.fragment,t),he=r(t),f(re.$$.fragment,t),ee=r(t),ue=b(t,"A",{id:!0}),ve(ue).forEach(a),s=r(t),f(d.$$.fragment,t),be=r(t),ge=b(t,"P",{"data-svelte-h":!0}),j(ge)!=="svelte-1ja6793"&&(ge.textContent=ze),ye=r(t),ke=b(t,"UL",{"data-svelte-h":!0}),j(ke)!=="svelte-1y57zg6"&&(ke.innerHTML=Ce),Te=r(t),_e=b(t,"P",{}),ve(_e).forEach(a),this.h()},h(){He(o,"name","hf:doc:metadata"),He(o,"content",jt),He(k,"id","data-processing"),He(de,"id","trainer"),He(N,"id","pytorch_native"),He(ue,"id","additional-resources")},m(t,m){Je(document.head,o),l(t,T,m),l(t,p,m),l(t,J,m),h(v,t,m),l(t,F,m),h(ne,t,m),l(t,Y,m),l(t,_,m),l(t,G,m),l(t,L,m),l(t,C,m),l(t,k,m),l(t,ae,m),h(B,t,m),l(t,se,m),h(V,t,m),l(t,A,m),l(t,Z,m),l(t,S,m),l(t,W,m),l(t,ce,m),h(U,t,m),l(t,X,m),l(t,H,m),l(t,P,m),h(I,t,m),l(t,R,m),l(t,n,m),l(t,ie,m),h(pe,t,m),l(t,D,m),l(t,de,m),l(t,K,m),h(fe,t,m),l(t,me,m),h(le,t,m),l(t,Me,m),l(t,N,m),l(t,we,m),h(O,t,m),l(t,he,m),h(re,t,m),l(t,ee,m),l(t,ue,m),l(t,s,m),h(d,t,m),l(t,be,m),l(t,ge,m),l(t,ye,m),l(t,ke,m),l(t,Te,m),l(t,_e,m),je=!0},p(t,[m]){const Ze={};m&2&&(Ze.$$scope={dirty:m,ctx:t}),le.$set(Ze);const Ie={};m&2&&(Ie.$$scope={dirty:m,ctx:t}),re.$set(Ie)},i(t){je||(g(v.$$.fragment,t),g(ne.$$.fragment,t),g(B.$$.fragment,t),g(V.$$.fragment,t),g(U.$$.fragment,t),g(I.$$.fragment,t),g(pe.$$.fragment,t),g(fe.$$.fragment,t),g(le.$$.fragment,t),g(O.$$.fragment,t),g(re.$$.fragment,t),g(d.$$.fragment,t),je=!0)},o(t){M(v.$$.fragment,t),M(ne.$$.fragment,t),M(B.$$.fragment,t),M(V.$$.fragment,t),M(U.$$.fragment,t),M(I.$$.fragment,t),M(pe.$$.fragment,t),M(fe.$$.fragment,t),M(le.$$.fragment,t),M(O.$$.fragment,t),M(re.$$.fragment,t),M(d.$$.fragment,t),je=!1},d(t){t&&(a(T),a(p),a(J),a(F),a(Y),a(_),a(G),a(L),a(C),a(k),a(ae),a(se),a(A),a(Z),a(S),a(W),a(ce),a(X),a(H),a(P),a(R),a(n),a(ie),a(D),a(de),a(K),a(me),a(Me),a(N),a(we),a(he),a(ee),a(ue),a(s),a(be),a(ge),a(ye),a(ke),a(Te),a(_e)),a(o),$(v,t),$(ne,t),$(B,t),$(V,t),$(U,t),$(I,t),$(pe,t),$(fe,t),$(le,t),$(O,t),$(re,t),$(d,t)}}}const jt='{"title":"Fine-tuning di un modello pre-addestrato","local":"fine-tuning-di-un-modello-pre-addestrato","sections":[{"title":"Preparare un dataset","local":"preparare-un-dataset","sections":[],"depth":2},{"title":"Addestramento","local":"addestramento","sections":[{"title":"Iperparametri per il training","local":"iperparametri-per-il-training","sections":[],"depth":3},{"title":"Metriche","local":"metriche","sections":[],"depth":3},{"title":"Trainer","local":"trainer","sections":[],"depth":3},{"title":"Convertire dataset nel formato per TensorFlow","local":"convertire-dataset-nel-formato-per-tensorflow","sections":[],"depth":3},{"title":"Compilazione e addestramento","local":"compilazione-e-addestramento","sections":[],"depth":3}],"depth":2},{"title":"Addestramento in PyTorch nativo","local":"addestramento-in-pytorch-nativo","sections":[{"title":"DataLoader","local":"dataloader","sections":[],"depth":3},{"title":"Ottimizzatore e learning rate scheduler","local":"ottimizzatore-e-learning-rate-scheduler","sections":[],"depth":3},{"title":"Training loop","local":"training-loop","sections":[],"depth":3},{"title":"Metriche","local":"metriche","sections":[],"depth":3}],"depth":2},{"title":"Altre risorse","local":"altre-risorse","sections":[],"depth":2}],"depth":1}';function Jt(te){return rt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ct}),[]}class Rt extends ot{constructor(o){super(),pt(this,o,Jt,Tt,it,{})}}export{Rt as component};
