import{s as Is,n as Bs,o as gs}from"../chunks/scheduler.36a0863c.js";import{S as Cs,i as _s,g as i,s as t,r,A as ks,h as p,f as l,c as n,j as hs,u as c,x as o,k as bs,y as Zs,a,v as M,d,t as u,w as m}from"../chunks/index.9c13489a.js";import{H as Se,g as zs}from"../chunks/Heading.88a24aaa.js";import{C as y}from"../chunks/CodeBlock.05d8ec32.js";function vs(Pe){let J,ne,ae,ie,T,pe,j,Le=`In questa guida, scopriremo come creare una pipeline personalizzata e condividerla sull’ <a href="hf.co/models">Hub</a> o aggiungerla nella libreria
Transformers.`,oe,w,De=`Innanzitutto, è necessario decidere gli input grezzi che la pipeline sarà in grado di accettare. Possono essere strings, raw bytes,
dictionaries o qualsiasi cosa sia l’input desiderato più probabile. Cerca di mantenere questi input il più possibile in Python
in quanto facilita la compatibilità (anche con altri linguaggi tramite JSON). Questi saranno gli <code>inputs</code> della
pipeline (<code>preprocess</code>).`,re,U,Ke=`Poi definire gli <code>outputs</code>. Stessa strategia degli <code>inputs</code>. Più è seplice e meglio è. Questi saranno gli output del metodo
<code>postprocess</code>.`,ce,f,Oe=`Si parte ereditando la classe base <code>Pipeline</code>. con i 4 metodi che bisogna implementare <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code> e <code>_sanitize_parameters</code>.`,Me,h,de,b,es=`La struttura di questa suddivisione consiste nel supportare in modo relativamente continuo CPU/GPU, supportando allo stesso tempo l’esecuzione di
pre/postelaborazione sulla CPU su thread diversi.`,ue,I,ss=`<code>preprocess</code> prenderà gli input originariamente definiti e li trasformerà in qualcosa di alimentabile dal modello. Potrebbe
contenere più informazioni e di solito è un <code>Dict</code>.`,me,B,ls=`<code>_forward</code> è il dettaglio dell’implementazione e non è destinato a essere chiamato direttamente. <code>forward</code> è il metodo preferito per assicurarsi che tutto funzioni correttamente perchè contiene delle slavaguardie. Se qualcosa è
è collegato a un modello reale, appartiene al metodo <code>_forward</code>, tutto il resto è nel preprocess/postprocess.`,ye,g,as="<code>postprocess</code> prende l’otput di <code>_forward</code> e lo trasforma nell’output finale che era stato deciso in precedenza.",Je,C,ts="<code>_sanitize_parameters</code> esiste per consentire agli utenti di passare i parametri ogni volta che desiderano sia a inizialization time <code>pipeline(...., maybe_arg=4)</code> che al call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.",Te,_,ns=`<code>_sanitize_parameters</code> ritorna 3 dicts di kwargs che vengono passati direttamente a <code>preprocess</code>,
<code>_forward</code> e <code>postprocess</code>. Non riempire nulla se il chiamante non ha chiamato con alcun parametro aggiuntivo. Questo
consente di mantenere gli argomenti predefiniti nella definizione della funzione, che è sempre più “naturale”.`,je,k,is="Un esempio classico potrebbe essere l’argomento <code>top_k</code> nel post processing dei classification tasks.",we,Z,Ue,z,ps=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,fe,v,he,G,os=`Cercare di mantenere gli input/output molto semplici e idealmente serializzabili in JSON, in quanto ciò rende l’uso della pipeline molto facile
senza richiedere agli utenti di comprendere nuovi tipi di oggetti. È anche relativamente comune supportare molti tipi di argomenti
per facilitarne l’uso (ad esempio file audio, possono essere nomi di file, URL o byte puri).`,be,q,Ie,A,rs="Per registrar il tuo <code>new-task</code> alla lista dei tasks supportati, devi aggiungerlo al <code>PIPELINE_REGISTRY</code>:",Be,H,ge,V,cs="Puoi specificare il modello di default che desideri, in questo caso dovrebbe essere accompagnato da una revisione specifica (che può essere il nome di un branch o l’hash di un commit, in questo caso abbiamo preso <code>&quot;abcdef&quot;</code>) e anche dal type:",Ce,X,_e,W,ke,R,Ms=`Per condividere la tua pipeline personalizzata sull’Hub, devi solo salvare il codice della tua sottoclasse <code>Pipeline</code> in un file
python. Per esempio, supponiamo di voler utilizzare una pipeline personalizzata per la classificazione delle coppie di frasi come la seguente:`,Ze,N,ze,E,ds="L’implementazione è agnostica al framework, e lavorerà sia con modelli PyTorch che con TensorFlow. Se l’abbiamo salvato in un file chiamato <code>pair_classification.py</code>, può essere successivamente importato e registrato in questo modo:",ve,$,Ge,x,us=`Una volta fatto, possiamo usarla con un modello pretrained. L’istanza <code>sgugger/finetuned-bert-mrpc</code> è stata
fine-tuned sul dataset MRPC, che classifica le coppie di frasi come parafrasi o no.`,qe,Y,Ae,Q,ms="Successivamente possiamo condividerlo sull’Hub usando il metodo <code>save_pretrained</code> in un <code>Repository</code>:",He,F,Ve,S,ys=`Questo codice copierà il file dove è stato definitp <code>PairClassificationPipeline</code> all’interno della cartella <code>&quot;test-dynamic-pipeline&quot;</code>,
insieme al salvataggio del modello e del tokenizer della pipeline, prima di pushare il tutto nel repository
<code>{your_username}/test-dynamic-pipeline</code>. Dopodiché chiunque potrà utilizzarlo, purché fornisca l’opzione
<code>trust_remote_code=True</code>:`,Xe,P,We,L,Re,D,Js=`Se vuoi contribuire con la tua pipeline a Transformers, dovrai aggiungere un modulo nel sottomodulo <code>pipelines</code>
con il codice della tua pipeline, quindi aggiungilo all’elenco dei tasks definiti in <code>pipelines/__init__.py</code>.`,Ne,K,Ts="Poi hai bisogno di aggiungere i test. Crea un nuovo file <code>tests/test_pipelines_MY_PIPELINE.py</code> con esempi ed altri test.",Ee,O,js=`La funzione <code>run_pipeline_test</code> sarà molto generica e su piccoli modelli casuali su ogni possibile
architettura, come definito da <code>model_mapping</code> e <code>tf_model_mapping</code>.`,$e,ee,ws=`Questo è molto importante per testare la compatibilità futura, nel senso che se qualcuno aggiunge un nuovo modello di
<code>XXXForQuestionAnswering</code> allora il test della pipeline tenterà di essere eseguito su di esso. Poiché i modelli sono casuali, è
è impossibile controllare i valori effettivi, per questo esiste un aiuto <code>ANY</code> che tenterà solamente di far corrispondere l’output della pipeline TYPE.`,xe,se,Us="Hai anche <em>bisogno</em> di implementare 2 (idealmente 4) test.",Ye,le,fs=`<li><code>test_small_model_pt</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi che non ci siano  derive nelle versioni future</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi
che non ci siano derive nelle versioni future</li>`,Qe,te,Fe;return T=new Se({props:{title:"Come creare una pipeline personalizzata?",local:"come-creare-una-pipeline-personalizzata",headingTag:"h1"}}),h=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),Z=new y({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),v=new y({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),q=new Se({props:{title:"Aggiungilo alla lista dei tasks supportati",local:"aggiungilo-alla-lista-dei-tasks-supportati",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),X=new y({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),W=new Se({props:{title:"Condividi la tua pipeline sull’Hub",local:"condividi-la-tua-pipeline-sullhub",headingTag:"h2"}}),N=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),F=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new Se({props:{title:"Aggiungere la pipeline a Transformers",local:"aggiungere-la-pipeline-a-transformers",headingTag:"h2"}}),{c(){J=i("meta"),ne=t(),ae=i("p"),ie=t(),r(T.$$.fragment),pe=t(),j=i("p"),j.innerHTML=Le,oe=t(),w=i("p"),w.innerHTML=De,re=t(),U=i("p"),U.innerHTML=Ke,ce=t(),f=i("p"),f.innerHTML=Oe,Me=t(),r(h.$$.fragment),de=t(),b=i("p"),b.textContent=es,ue=t(),I=i("p"),I.innerHTML=ss,me=t(),B=i("p"),B.innerHTML=ls,ye=t(),g=i("p"),g.innerHTML=as,Je=t(),C=i("p"),C.innerHTML=ts,Te=t(),_=i("p"),_.innerHTML=ns,je=t(),k=i("p"),k.innerHTML=is,we=t(),r(Z.$$.fragment),Ue=t(),z=i("p"),z.innerHTML=ps,fe=t(),r(v.$$.fragment),he=t(),G=i("p"),G.textContent=os,be=t(),r(q.$$.fragment),Ie=t(),A=i("p"),A.innerHTML=rs,Be=t(),r(H.$$.fragment),ge=t(),V=i("p"),V.innerHTML=cs,Ce=t(),r(X.$$.fragment),_e=t(),r(W.$$.fragment),ke=t(),R=i("p"),R.innerHTML=Ms,Ze=t(),r(N.$$.fragment),ze=t(),E=i("p"),E.innerHTML=ds,ve=t(),r($.$$.fragment),Ge=t(),x=i("p"),x.innerHTML=us,qe=t(),r(Y.$$.fragment),Ae=t(),Q=i("p"),Q.innerHTML=ms,He=t(),r(F.$$.fragment),Ve=t(),S=i("p"),S.innerHTML=ys,Xe=t(),r(P.$$.fragment),We=t(),r(L.$$.fragment),Re=t(),D=i("p"),D.innerHTML=Js,Ne=t(),K=i("p"),K.innerHTML=Ts,Ee=t(),O=i("p"),O.innerHTML=js,$e=t(),ee=i("p"),ee.innerHTML=ws,xe=t(),se=i("p"),se.innerHTML=Us,Ye=t(),le=i("ul"),le.innerHTML=fs,Qe=t(),te=i("p"),this.h()},l(e){const s=ks("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(l),ne=n(e),ae=p(e,"P",{}),hs(ae).forEach(l),ie=n(e),c(T.$$.fragment,e),pe=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-12w49xe"&&(j.innerHTML=Le),oe=n(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1iatkga"&&(w.innerHTML=De),re=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-i2xp1j"&&(U.innerHTML=Ke),ce=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-eef5a9"&&(f.innerHTML=Oe),Me=n(e),c(h.$$.fragment,e),de=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1lfi6tr"&&(b.textContent=es),ue=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-m2oyf8"&&(I.innerHTML=ss),me=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-xk0co8"&&(B.innerHTML=ls),ye=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-wbceks"&&(g.innerHTML=as),Je=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1w8676p"&&(C.innerHTML=ts),Te=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wn1l5e"&&(_.innerHTML=ns),je=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-hymnzr"&&(k.innerHTML=is),we=n(e),c(Z.$$.fragment,e),Ue=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-nsc0of"&&(z.innerHTML=ps),fe=n(e),c(v.$$.fragment,e),he=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1fkgamo"&&(G.textContent=os),be=n(e),c(q.$$.fragment,e),Ie=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-4zkgvo"&&(A.innerHTML=rs),Be=n(e),c(H.$$.fragment,e),ge=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-u38mjv"&&(V.innerHTML=cs),Ce=n(e),c(X.$$.fragment,e),_e=n(e),c(W.$$.fragment,e),ke=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-16cgcsm"&&(R.innerHTML=Ms),Ze=n(e),c(N.$$.fragment,e),ze=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-libyk9"&&(E.innerHTML=ds),ve=n(e),c($.$$.fragment,e),Ge=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-vhle5u"&&(x.innerHTML=us),qe=n(e),c(Y.$$.fragment,e),Ae=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-fwx120"&&(Q.innerHTML=ms),He=n(e),c(F.$$.fragment,e),Ve=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1jl4eog"&&(S.innerHTML=ys),Xe=n(e),c(P.$$.fragment,e),We=n(e),c(L.$$.fragment,e),Re=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-3oo5s6"&&(D.innerHTML=Js),Ne=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-17yxzlw"&&(K.innerHTML=Ts),Ee=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-agzokg"&&(O.innerHTML=js),$e=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-td3vn9"&&(ee.innerHTML=ws),xe=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-dschfg"&&(se.innerHTML=Us),Ye=n(e),le=p(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-1c56iwk"&&(le.innerHTML=fs),Qe=n(e),te=p(e,"P",{}),hs(te).forEach(l),this.h()},h(){bs(J,"name","hf:doc:metadata"),bs(J,"content",Gs)},m(e,s){Zs(document.head,J),a(e,ne,s),a(e,ae,s),a(e,ie,s),M(T,e,s),a(e,pe,s),a(e,j,s),a(e,oe,s),a(e,w,s),a(e,re,s),a(e,U,s),a(e,ce,s),a(e,f,s),a(e,Me,s),M(h,e,s),a(e,de,s),a(e,b,s),a(e,ue,s),a(e,I,s),a(e,me,s),a(e,B,s),a(e,ye,s),a(e,g,s),a(e,Je,s),a(e,C,s),a(e,Te,s),a(e,_,s),a(e,je,s),a(e,k,s),a(e,we,s),M(Z,e,s),a(e,Ue,s),a(e,z,s),a(e,fe,s),M(v,e,s),a(e,he,s),a(e,G,s),a(e,be,s),M(q,e,s),a(e,Ie,s),a(e,A,s),a(e,Be,s),M(H,e,s),a(e,ge,s),a(e,V,s),a(e,Ce,s),M(X,e,s),a(e,_e,s),M(W,e,s),a(e,ke,s),a(e,R,s),a(e,Ze,s),M(N,e,s),a(e,ze,s),a(e,E,s),a(e,ve,s),M($,e,s),a(e,Ge,s),a(e,x,s),a(e,qe,s),M(Y,e,s),a(e,Ae,s),a(e,Q,s),a(e,He,s),M(F,e,s),a(e,Ve,s),a(e,S,s),a(e,Xe,s),M(P,e,s),a(e,We,s),M(L,e,s),a(e,Re,s),a(e,D,s),a(e,Ne,s),a(e,K,s),a(e,Ee,s),a(e,O,s),a(e,$e,s),a(e,ee,s),a(e,xe,s),a(e,se,s),a(e,Ye,s),a(e,le,s),a(e,Qe,s),a(e,te,s),Fe=!0},p:Bs,i(e){Fe||(d(T.$$.fragment,e),d(h.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(q.$$.fragment,e),d(H.$$.fragment,e),d(X.$$.fragment,e),d(W.$$.fragment,e),d(N.$$.fragment,e),d($.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(P.$$.fragment,e),d(L.$$.fragment,e),Fe=!0)},o(e){u(T.$$.fragment,e),u(h.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(W.$$.fragment,e),u(N.$$.fragment,e),u($.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),Fe=!1},d(e){e&&(l(ne),l(ae),l(ie),l(pe),l(j),l(oe),l(w),l(re),l(U),l(ce),l(f),l(Me),l(de),l(b),l(ue),l(I),l(me),l(B),l(ye),l(g),l(Je),l(C),l(Te),l(_),l(je),l(k),l(we),l(Ue),l(z),l(fe),l(he),l(G),l(be),l(Ie),l(A),l(Be),l(ge),l(V),l(Ce),l(_e),l(ke),l(R),l(Ze),l(ze),l(E),l(ve),l(Ge),l(x),l(qe),l(Ae),l(Q),l(He),l(Ve),l(S),l(Xe),l(We),l(Re),l(D),l(Ne),l(K),l(Ee),l(O),l($e),l(ee),l(xe),l(se),l(Ye),l(le),l(Qe),l(te)),l(J),m(T,e),m(h,e),m(Z,e),m(v,e),m(q,e),m(H,e),m(X,e),m(W,e),m(N,e),m($,e),m(Y,e),m(F,e),m(P,e),m(L,e)}}}const Gs='{"title":"Come creare una pipeline personalizzata?","local":"come-creare-una-pipeline-personalizzata","sections":[{"title":"Aggiungilo alla lista dei tasks supportati","local":"aggiungilo-alla-lista-dei-tasks-supportati","sections":[],"depth":2},{"title":"Condividi la tua pipeline sull’Hub","local":"condividi-la-tua-pipeline-sullhub","sections":[],"depth":2},{"title":"Aggiungere la pipeline a Transformers","local":"aggiungere-la-pipeline-a-transformers","sections":[],"depth":2}],"depth":1}';function qs(Pe){return gs(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=zs}),[]}class Ws extends Cs{constructor(J){super(),_s(this,J,qs,vs,Is,{})}}export{Ws as component};
