import{s as np,f as ip,o as rp,n as sp}from"../chunks/scheduler.9bc65507.js";import{S as ap,i as Mp,g as r,s as n,r as p,A as pp,h as a,f as l,c as i,j as tp,u as m,x as M,k as C,y as mp,a as s,v as T,d as o,t as f,w}from"../chunks/index.707bf1b6.js";import{H as J,g as Tp}from"../chunks/Heading.18a460e4.js";import{T as lp}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";function op(Dl){let u,j='TensorFlowモデルを実装する興味がある場合は、<a href="add_tensorflow_model">🤗 TransformersモデルをTensorFlowに変換する方法</a>ガイドを参照してみてください！';return{c(){u=r("p"),u.innerHTML=j},l(d){u=a(d,"P",{"data-svelte-h":!0}),M(u)!=="svelte-ytr0ht"&&(u.innerHTML=j)},m(d,b){s(d,u,b)},p:sp,d(d){d&&l(u)}}}function fp(Dl){let u,j="Windowsを使用している場合、<code>RUN_SLOW=1</code>を<code>SET RUN_SLOW=1</code>に置き換えてください。";return{c(){u=r("p"),u.innerHTML=j},l(d){u=a(d,"P",{"data-svelte-h":!0}),M(u)!=="svelte-4xcol2"&&(u.innerHTML=j)},m(d,b){s(d,u,b)},p:sp,d(d){d&&l(u)}}}function wp(Dl){let u,j,d,b,x,Fl,g,cr=`🤗 Transformersライブラリは、コミュニティの貢献者のおかげで新しいモデルを提供できることがよくあります。
しかし、これは難しいプロジェクトであり、🤗 Transformersライブラリと実装するモデルについての深い知識が必要です。
Hugging Faceでは、コミュニティの多くの人々に積極的にモデルを追加する力を与えようと努力しており、
このガイドをまとめて、PyTorchモデルを追加するプロセスを説明します（<a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorchがインストールされていることを確認してください</a>）。`,Sl,c,ql,k,Ur="この過程で、以下のことを学びます：",Ol,A,_r="<li>オープンソースのベストプラクティスに関する洞察</li> <li>最も人気のある深層学習ライブラリの設計原則を理解する</li> <li>大規模なモデルを効率的にテストする方法を学ぶ</li> <li><code>black</code>、<code>ruff</code>、および<code>make fix-copies</code>などのPythonユーティリティを統合して、クリーンで読みやすいコードを確保する方法を学ぶ</li>",Kl,H,hr="Hugging Faceチームのメンバーがサポートを提供するので、一人ぼっちになることはありません。 🤗 ❤️",es,Z,vr=`さあ、始めましょう！🤗 Transformersで見たいモデルについての<a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=New+model&amp;template=new-model-addition.yml" rel="nofollow">New model addition</a>のイシューを開いてください。
特定のモデルを提供することに特にこだわりがない場合、<a href="https://github.com/huggingface/transformers/labels/New%20model" rel="nofollow">New model label</a>で未割り当てのモデルリクエストがあるかどうかを確認して、それに取り組むことができます。`,ts,B,$r="新しいモデルリクエストを開いたら、最初のステップは🤗 Transformersをよく理解することです！",ls,N,ss,W,Ir=`まず、🤗 Transformersの一般的な概要を把握する必要があります。🤗 Transformersは非常に意見が分かれるライブラリですので、
ライブラリの哲学や設計選択について同意できない可能性があります。ただし、私たちの経験から、ライブラリの基本的な設計選択と哲学は、
🤗 Transformersを効率的にスケーリングし、適切なレベルで保守コストを抑えるために不可欠です。`,ns,R,Lr=`ライブラリの理解を深めるための良い出発点は、<a href="philosophy">哲学のドキュメント</a>を読むことです。
私たちの作業方法の結果、すべてのモデルに適用しようとするいくつかの選択肢があります：`,is,G,xr="<li>一般的に、抽象化よりも構成が優先されます。</li> <li>コードの重複は、読みやすさやアクセス可能性を大幅に向上させる場合、必ずしも悪いわけではありません。</li> <li>モデルファイルはできるだけ自己完結的であるべきで、特定のモデルのコードを読む際には、理想的には該当する<code>modeling_....py</code>ファイルのみを見る必要があります。</li>",rs,P,gr="私たちの意見では、このライブラリのコードは単なる製品を提供する手段だけでなく、<em>例えば、推論のためにBERTを使用する能力</em>などの製品そのもの.",as,Q,Ms,E,kr=`モデルを正常に追加するためには、モデルとその設定、<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>、および<a href="/docs/transformers/v4.35.2/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>の相互作用を理解することが重要です。
例示的な目的で、🤗 Transformersに追加するモデルを「BrandNewBert」と呼びます。`,ps,V,Ar="以下をご覧ください：",ms,Xl,Hr,Ts,z,Zr=`ご覧のように、🤗 Transformersでは継承を使用していますが、抽象化のレベルを最小限に保っています。
ライブラリ内のどのモデルにも、抽象化のレベルが2つを超えることはありません。
<code>BrandNewBertModel</code> は <code>BrandNewBertPreTrainedModel</code> を継承し、さらに<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>を継承しています。
これだけです。
一般的なルールとして、新しいモデルは<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>にのみ依存するようにしたいと考えています。
すべての新しいモデルに自動的に提供される重要な機能は、<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>および
<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>です。
これらはシリアライゼーションとデシリアライゼーションに使用されます。
<code>BrandNewBertModel.forward</code>などの他の重要な機能は、新しい「modeling_brand_new_bert.py」スクリプトで完全に定義されるべきです。
次に、特定のヘッドレイヤーを持つモデル（たとえば <code>BrandNewBertForMaskedLM</code> ）が <code>BrandNewBertModel</code> を継承するのではなく、
抽象化のレベルを低く保つために、そのフォワードパスで <code>BrandNewBertModel</code> を呼び出すコンポーネントとして使用されるようにしたいと考えています。
新しいモデルには常に <code>BrandNewBertConfig</code> という設定クラスが必要です。この設定は常に<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>の属性として保存され、
したがって、<code>BrandNewBertPreTrainedModel</code>から継承するすべてのクラスで<code>config</code>属性を介してアクセスできます。`,os,D,fs,X,Br='モデルと同様に、設定は<a href="/docs/transformers/v4.35.2/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>から基本的なシリアル化および逆シリアル化の機能を継承しています。注意すべきは、設定とモデルは常に2つの異なる形式にシリアル化されることです - モデルは<em>pytorch_model.bin</em>ファイルに、設定は<em>config.json</em>ファイルにシリアル化されます。<a href="/docs/transformers/v4.35.2/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>を呼び出すと、自動的に<a href="/docs/transformers/v4.35.2/ja/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>も呼び出され、モデルと設定の両方が保存されます。',ws,Y,ys,F,Nr="新しいモデルをコーディングする際には、Transformersは意見があるライブラリであり、コードの書き方に関していくつかの独自の考え方があります :-)",us,S,Wr='<li>モデルのフォワードパスはモデリングファイルに完全に記述され、ライブラリ内の他のモデルとは完全に独立している必要があります。他のモデルからブロックを再利用したい場合、コードをコピーしてトップに<code># Copied from</code>コメントを付けて貼り付けます（良い例は<a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">こちら</a>、コピーに関する詳細なドキュメンテーションは<a href="pr_checks#check-copies">ここ</a>を参照してください）。</li> <li>コードは完全に理解可能でなければなりません。これは記述的な変数名を選択し、省略形を避けるべきであることを意味します。例えば、<code>act</code>ではなく<code>activation</code>が好まれます。1文字の変数名は、forループ内のインデックスでない限り、強く非推奨です。</li> <li>より一般的に、魔法のような短いコードよりも長くて明示的なコードを好みます。</li> <li>PyTorchでは<code>nn.Sequential</code>をサブクラス化せずに、<code>nn.Module</code>をサブクラス化し、フォワードパスを記述し、コードを使用する他の人が簡単にデバッグできるようにします。プリントステートメントやブレークポイントを追加してデバッグできるようにします。</li> <li>関数のシグネチャは型アノテーションを付けるべきです。その他の部分に関しては、型アノテーションよりも良い変数名が読みやすく理解しやすいことがあります。</li>',ds,q,Js,O,Rr="まだ完了していません :-( このセクションは近日中に追加されます！",js,K,Cs,ee,Gr="モデルを追加する方法は人それぞれ異なるため、他のコントリビューターが🤗 Transformersにモデルを追加する際の要約を確認することが非常に役立つ場合があります。以下は、他のコントリビューターが🤗 Transformersにモデルをポートする際のコミュニティブログ投稿のリストです。",bs,te,Pr='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">GPT2モデルのポーティング</a> by <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">WMT19 MTモデルのポーティング</a> by <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',cs,le,Qr="経験から言えることは、モデルを追加する際に最も重要なことは次のようになります：",Us,se,Er='<li>車輪の再発明をしないでください！新しい🤗 Transformersモデルのために追加するコードのほとんどはすでに🤗 Transformers内のどこかに存在しています。類似した既存のモデルやトークナイザを見つけるために、いくつかの時間をかけて探すことが重要です。<a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a>と<a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a>はあなたの友達です。モデルのトークナイザは1つのモデル実装に基づいているかもしれませんが、モデルのモデリングコードは別の実装に基づいていることがあることに注意してください。例えば、FSMTのモデリングコードはBARTに基づいており、FSMTのトークナイザコードはXLMに基づいています。</li> <li>これは科学的な課題よりもエンジニアリングの課題です。モデルの論文の理論的な側面をすべて理解しようとするよりも、効率的なデバッグ環境を作成するために時間を費やすべきです。</li> <li>行き詰まった場合は助けを求めてください！モデルは🤗 Transformersのコアコンポーネントであり、Hugging Faceではモデルを追加するための各ステップでお手伝いするのを喜んでいます。進行がないことに気付いた場合は、進展していないことを気にしないでください。</li>',_s,ne,Vr="以下では、🤗 Transformersにモデルをポートする際に最も役立つと考えられる一般的なレシピを提供しようとしています。",hs,ie,zr="次のリストは、モデルを追加するために行う必要があるすべてのことの要約であり、To-Doリストとして使用できます：",vs,re,Dr="<li>☐ （オプション）モデルの理論的な側面を理解しました</li> <li>☐ 🤗 Transformersの開発環境を準備しました</li> <li>☐ オリジナルのリポジトリのデバッグ環境をセットアップしました</li> <li>☐ <code>forward()</code> パスをオリジナルのリポジトリとチェックポイントで正常に実行するスクリプトを作成しました</li> <li>☐ モデルの骨格を🤗 Transformersに正常に追加しました</li> <li>☐ オリジナルのチェックポイントを🤗 Transformersのチェックポイントに正常に変換しました</li> <li>☐ 🤗 Transformersで実行される <code>forward()</code> パスを正常に実行し、オリジナルのチェックポイントと同一の出力を得ました</li> <li>☐ 🤗 Transformersでのモデルテストを完了しました</li> <li>☐ 🤗 Transformersにトークナイザを正常に追加しました</li> <li>☐ エンドツーエンドの統合テストを実行しました</li> <li>☐ ドキュメントを完成させました</li> <li>☐ モデルのウェイトをHubにアップロードしました</li> <li>☐ プルリクエストを提出しました</li> <li>☐ （オプション）デモノートブックを追加しました</li>",$s,ae,Xr=`まず、通常、<code>BrandNewBert</code>の理論的な理解を深めることをお勧めします。
ただし、もしモデルの理論的な側面を「実務中に理解する」方が好ましい場合、<code>BrandNewBert</code>のコードベースに直接アクセスするのも問題ありません。
このオプションは、エンジニアリングのスキルが理論的なスキルよりも優れている場合、
<code>BrandNewBert</code>の論文を理解するのに苦労している場合、または科学的な論文を読むよりもプログラミングを楽しんでいる場合に適しています。`,Is,Me,Ls,pe,Yr=`BrandNewBertの論文がある場合、その説明を読むための時間を取るべきです。論文の中には理解が難しい部分があるかもしれません。
その場合でも心配しないでください。目標は論文の深い理論的理解を得ることではなく、
🤗 Transformersでモデルを効果的に再実装するために必要な情報を抽出することです。
ただし、理論的な側面にあまり多くの時間をかける必要はありません。代わりに、実践的な側面に焦点を当てましょう。具体的には次の点です：`,xs,me,Fr=`<li><em>brand_new_bert</em>はどの種類のモデルですか？ BERTのようなエンコーダーのみのモデルですか？ GPT2のようなデコーダーのみのモデルですか？ BARTのようなエンコーダー-デコーダーモデルですか？
<a href="model_summary">model_summary</a>を参照して、これらの違いについて詳しく知りたい場合があります。</li> <li><em>brand_new_bert</em>の応用分野は何ですか？ テキスト分類ですか？ テキスト生成ですか？ Seq2Seqタスク、例えば要約ですか？</li> <li>モデルをBERT/GPT-2/BARTとは異なるものにする新しい機能は何ですか？</li> <li>既存の<a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformersモデル</a>の中で<em>brand_new_bert</em>に最も似ているモデルはどれですか？</li> <li>使用されているトークナイザの種類は何ですか？ SentencePieceトークナイザですか？ WordPieceトークナイザですか？ BERTやBARTで使用されているトークナイザと同じですか？</li>`,gs,Te,Sr=`モデルのアーキテクチャの良い概要を得たと感じたら、Hugging Faceチームに質問を送ることができます。
これにはモデルのアーキテクチャ、注意層などに関する質問が含まれるかもしれません。
私たちは喜んでお手伝いします。`,ks,oe,As,fe,qr=`<li><p>リポジトリのページで「Fork」ボタンをクリックして、<a href="https://github.com/huggingface/transformers" rel="nofollow">リポジトリ</a>をフォークします。
これにより、コードのコピーがGitHubユーザーアカウントの下に作成されます。</p></li> <li><p>ローカルディスクにある<code>transformers</code>フォークをクローンし、ベースリポジトリをリモートとして追加します：</p></li>`,Hs,we,Zs,ye,Bs,U,Or="<li>開発環境をセットアップするために、次のコマンドを実行してください：</li>",Ns,ue,Ws,de,Kr=`お使いのOSに応じて、およびTransformersのオプションの依存関係の数が増えているため、このコマンドでエラーが発生する可能性があります。
その場合は、作業しているDeep Learningフレームワーク（PyTorch、TensorFlow、および/またはFlax）をインストールし、次の手順を実行してください：`,Rs,Je,Gs,je,ea="これはほとんどのユースケースには十分であるはずです。その後、親ディレクトリに戻ることができます。",Ps,Ce,Qs,_,ta=`<li><p>Transformersに<em>brand_new_bert</em>のPyTorchバージョンを追加することをお勧めします。PyTorchをインストールするには、
<a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a> の指示に従ってください。</p> <p><strong>注意:</strong> CUDAをインストールする必要はありません。新しいモデルをCPUで動作させることで十分です。</p></li> <li><p><em>brand_new_bert</em>を移植するには、元のリポジトリへのアクセスも必要です。</p></li>`,Es,be,Vs,ce,la="<em>brand_new_bert</em>を🤗 Transformersにポートするための開発環境を設定しました。",zs,Ue,Ds,_e,sa="最初に、オリジナルの<em>brand_new_bert</em>リポジトリで作業します。通常、オリジナルの実装は非常に「研究的」であり、ドキュメンテーションが不足していたり、コードが理解しにくいことがあります。しかし、これが<em>brand_new_bert</em>を再実装する動機となるべきです。Hugging Faceでは、主要な目標の1つが、動作するモデルを取り、それをできるだけ<strong>アクセス可能でユーザーフレンドリーで美しい</strong>ものに書き直すことです。これは、🤗 Transformersにモデルを再実装する最も重要な動機です - 複雑な新しいNLP技術を<strong>誰にでも</strong>アクセス可能にしようとする試みです。",Xs,he,na="まず、オリジナルのリポジトリに入り込むことから始めるべきです。",Ys,ve,ia=`公式の事前学習済みモデルをオリジナルのリポジトリで正常に実行することは、通常、<strong>最も困難な</strong>ステップです。
私たちの経験から、オリジナルのコードベースに慣れるのに時間をかけることが非常に重要です。以下のことを理解する必要があります：`,Fs,$e,ra="<li>事前学習済みの重みをどこで見つけるか？</li> <li>対応するモデルに事前学習済みの重みをロードする方法は？</li> <li>モデルから独立してトークナイザを実行する方法は？</li> <li>1つのフォワードパスを追跡して、単純なフォワードパスに必要なクラスと関数がわかるようにします。通常、これらの関数だけを再実装する必要があります。</li> <li>モデルの重要なコンポーネントを特定できること：モデルのクラスはどこにありますか？モデルのサブクラス、<em>例</em> EncoderModel、DecoderModelがありますか？自己注意レイヤーはどこにありますか？複数の異なる注意レイヤー、<em>例</em> <em>自己注意</em>、<em>クロスアテンション</em>などが存在しますか？</li> <li>オリジナルのリポジトリの環境でモデルをデバッグする方法は？<em>print</em>ステートメントを追加する必要があるか、<em>ipdb</em>のような対話型デバッガを使用できるか、PyCharmのような効率的なIDEを使用してモデルをデバッグする必要がありますか？</li>",Ss,Ie,aa="重要なのは、ポーティングプロセスを開始する前に、オリジナルのリポジトリでコードを<strong>効率的に</strong>デバッグできることです！また、これはオープンソースライブラリで作業していることを覚えておいてください。オリジナルのリポジトリでコードを調べる誰かを歓迎するために、問題をオープンにしたり、プルリクエストを送信したりすることをためらわないでください。このリポジトリのメンテナーは、彼らのコードを調べてくれる人に対して非常に喜んでいる可能性が高いです！",qs,Le,Ma="この段階では、オリジナルのモデルのデバッグにどのような環境と戦略を使用するかは、あなた次第です。最初にオリジナルのリポジトリに関するコードをデバッグできることが非常に重要です。また、GPU環境をセットアップすることはお勧めしません。まず、CPU上で作業し、モデルがすでに🤗 Transformersに正常にポートされていることを確認します。最後に、モデルがGPU上でも期待通りに動作するかどうかを検証する必要があります。",Os,xe,pa="一般的に、オリジナルのモデルを実行するための2つのデバッグ環境があります：",Ks,ge,ma='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>ローカルなPythonスクリプト。</li>',en,ke,Ta="Jupyterノートブックは、セルごとに実行できるため、論理的なコンポーネントをより分割し、中間結果を保存できるため、デバッグサイクルが速くなるという利点があります。また、ノートブックは他の共同作業者と簡単に共有できることが多く、Hugging Faceチームに助けを求める場合に非常に役立つ場合があります。Jupyterノートブックに精通している場合、それ",tn,Ae,ln,He,oa="デバッグ戦略については、通常、いくつかの選択肢があります：",sn,Ze,fa="<li>元のモデルを多くの小さなテスト可能なコンポーネントに分解し、それぞれに対して前方パスを実行して検証します</li> <li>元のモデルを元のトークナイザと元のモデルにのみ分解し、それらに対して前方パスを実行し、検証のために中間のプリントステートメントまたはブレークポイントを使用します</li>",nn,Be,wa="再度、どの戦略を選択するかはあなた次第です。元のコードベースに依存することが多く、元のコードベースに応じて一方または他方が有利なことがあります。",rn,Ne,ya="元のコードベースがモデルを小さなサブコンポーネントに分解できる場合、<em>例えば</em>元のコードベースが簡単にイーガーモードで実行できる場合、それを行う価値が通常あります。最初からより難しい方法を選択することにはいくつかの重要な利点があります：",an,We,ua="<li>後で元のモデルを🤗 Transformersの実装と比較する際に、各コンポーネントが対応する🤗 Transformers実装のコンポーネントと一致することを自動的に検証できるため、視覚的な比較に依存せずに済みます</li> <li>大きな問題を小さな問題に分解する、つまり個々のコンポーネントのみをポーティングする問題に分割するのに役立ち、作業を構造化するのに役立ちます</li> <li>モデルを論理的な意味のあるコンポーネントに分割することで、モデルの設計をよりよく理解しやすくし、モデルをよりよく理解するのに役立ちます</li> <li>後で、コンポーネントごとのテストを行うことで、コードを変更し続ける際にリグレッションが発生しないことを確認するのに役立ちます</li>",Mn,Re,da='<a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandreの</a> ELECTRAの統合チェックは、これがどのように行われるかの良い例です。',pn,Ge,Ja=`ただし、元のコードベースが非常に複雑で、中間コンポーネントをコンパイルモードで実行することしか許可しない場合、モデルを小さなテスト可能なサブコンポーネントに分解することが時間がかかりすぎるか、不可能であることがあります。
良い例は<a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">T5のMeshTensorFlow</a>ライブラリであり、非常に複雑でモデルをサブコンポーネントに分解する簡単な方法を提供しないことがあります。このようなライブラリでは、通常、プリントステートメントを検証することに依存します。`,mn,Pe,ja="どの戦略を選択しても、推奨される手順は通常同じで、最初のレイヤーからデバッグを開始し、最後のレイヤーからデバッグを行うべきです。",Tn,Qe,Ca="通常、以下の順序で次のレイヤーからの出力を取得することをお勧めします：",on,Ee,ba="<li>モデルに渡された入力IDを取得する</li> <li>単語の埋め込みを取得する</li> <li>最初のTransformerレイヤーの入力を取得する</li> <li>最初のTransformerレイヤーの出力を取得する</li> <li>次のn - 1つのTransformerレイヤーの出力を取得する</li> <li>BrandNewBertモデル全体の出力を取得する</li>",fn,Ve,ca="入力IDは整数の配列である必要があり、<em>例：</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code> のようになります。",wn,ze,Ua="以下のレイヤーの出力は多次元の浮動小数点配列であることが多く、次のようになることがあります：",yn,De,un,Xe,_a=`🤗 Transformersに追加されるすべてのモデルは、統合テストを数回合格することが期待されており、元のモデルと🤗 Transformersで再実装されたバージョンが、0.001の精度までまったく同じ出力を提供する必要があります。
異なるライブラリフレームワークで同じモデルを書いた場合、わずかに異なる出力を返すことが正常であるため、誤差許容値として1e-3（0.001）を受け入れています。モデルがほぼ同じ出力を返すだけでは不十分で、ほぼ同一である必要があります。そのため、🤗 Transformersバージョンの中間出力を元の<em>brand_new_bert</em>の実装の中間出力と複数回にわたって比較することになるでしょう。その際、元のリポジトリの<strong>効率的な</strong>デバッグ環境が非常に重要です。以下は、デバッグ環境をできるだけ効率的にするためのアドバイスです。`,dn,Ye,ha='<li>中間結果をデバッグする最適な方法を見つける。元のリポジトリはPyTorchで書かれていますか？その場合、元のモデルをより小さなサブコンポーネントに分解して中間値を取得する長いスクリプトを書くことがおそらく適切です。元のリポジトリがTensorflow 1で書かれている場合、<a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a>などのTensorFlowのプリント操作を使用して中間値を出力する必要があるかもしれません。元のリポジトリがJaxで書かれている場合、フォワードパスの実行時にモデルが<strong>jittedされていない</strong>ことを確認してください。例：<a href="https://github.com/google/jax/issues/196" rel="nofollow">このリンク</a>をチェック。</li> <li>使用可能な最小の事前学習済みチェックポイントを使用します。チェックポイントが小さいほど、デバッグサイクルが速くなります。事前学習済みモデルがフォワードパスに10秒以上かかる場合、効率的ではありません。非常に大きなチェックポイントしか利用できない場合、新しい環境でランダムに初期化されたウェイトを持つダミーモデルを作成し、それらのウェイトを🤗 Transformersバージョンのモデルと比較する方が良いかもしれません。</li> <li>元のリポジトリでフォワードパスを呼び出す最も簡単な方法を使用していることを確認してください。理想的には、元のリポジトリで<strong>単一のフォワードパス</strong>を呼び出す関数を見つけたいです。これは通常「predict」、「evaluate」、「forward」、「<strong>call</strong>」と呼ばれます。複数回「forward」を呼び出す関数をデバッグしたくありません。例：テキストを生成するために「autoregressive_sample」、「generate」と呼ばれる関数。</li> <li>トークナイゼーションとモデルの「フォワード」パスを分離しようとしてください。元のリポジトリが入力文字列を入力する必要がある例を示す場合、フォワードコール内で文字列入力が入力IDに変更される場所を特定し、このポイントから開始します。これは、スクリプトを自分で書くか、入力文字列ではなく入力IDを直接入力できるように元のコードを変更する必要があるかもしれません。</li> <li>デバッグセットアップ内のモデルがトレーニングモードではないことを確認してください。トレーニングモードでは、モデル内の複数のドロップアウトレイヤーのためにランダムな出力が生成されることがあります。デバッグ環境のフォワードパスが<strong>決定論的</strong>であることを確認し、ドロップアウトレイヤーが使用されないようにします。または、新しい実装が同じフレームワーク内にある場合、<em>transformers.utils.set_seed</em>を使用してください。</li>',Jn,Fe,va="以下のセクションでは、<em>brand_new_bert</em>についてこれを具体的にどのように行うかについての詳細/ヒントを提供します。",jn,Se,Cn,qe,$a="次に、ついに新しいコードを🤗 Transformersに追加できます。🤗 Transformersのフォークのクローンに移動してください：",bn,Oe,cn,Ke,Ia=`特別なケースとして、既存のモデルと完全に一致するアーキテクチャのモデルを追加する場合、
<a href="#write-a-conversion-script">このセクション</a>で説明されているように、変換スクリプトを追加するだけで済みます。
この場合、既存のモデルの完全なモデルアーキテクチャを再利用できます。`,Un,et,La="それ以外の場合、新しいモデルの生成を開始します。ここで2つの選択肢があります：",_n,tt,xa="<li><code>transformers-cli add-new-model-like</code>を使用して既存のモデルのような新しいモデルを追加します</li> <li><code>transformers-cli add-new-model</code>を使用して、テンプレートから新しいモデルを追加します（モデルのタイプに応じてBERTまたはBartのように見えます）</li>",hn,lt,ga=`どちらの場合でも、モデルの基本情報を入力するための質問事項が表示されます。
2番目のコマンドを実行するには、<code>cookiecutter</code>をインストールする必要があります。
詳細については<a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model" rel="nofollow">こちら</a>をご覧ください。`,vn,st,ka="<strong>主要な huggingface/transformers リポジトリでプルリクエストを開く</strong>",$n,nt,Aa=`自動生成されたコードを適応し始める前に、🤗 Transformers に「作業中（WIP）」プルリクエストを開くタイミングです。
例：「[WIP] <em>brand_new_bert</em> を追加」などです。
これにより、ユーザーと Hugging Face チームが🤗 Transformers にモデルを統合する作業を並行して行うことができます。`,In,it,Ha="以下の手順を実行してください：",Ln,rt,Za="<li>メインブランチから分かりやすい名前のブランチを作成します。</li>",xn,at,gn,h,Ba="<li>自動生成されたコードをコミットしてください:</li>",kn,Mt,An,v,Na="<li>現在の main ブランチにフェッチしてリベース</li>",Hn,pt,Zn,$,Wa="<li>変更をあなたのアカウントにプッシュするには、次のコマンドを使用します：</li>",Bn,mt,Nn,I,Ra="<li><p>満足したら、GitHub上のフォークのウェブページに移動します。[プルリクエスト]をクリックします。将来の変更に備えて、Hugging Face チームのメンバーのGitHubハンドルをレビュアーとして追加してください。</p></li> <li><p>GitHubのプルリクエストウェブページの右側にある「ドラフトに変換」をクリックして、PRをドラフトに変更します。</p></li>",Wn,Tt,Ga="以下では、進捗があった場合は常に作業をコミットし、プッシュしてプルリクエストに表示されるようにしてください。さらに、定期的にメインからの最新の変更を取り込むために、次のように行うことを忘れないでください：",Rn,ot,Gn,ft,Pa=`一般的に、モデルや実装に関する質問はPull Request (PR) で行い、PR内で議論し、解決します。
これにより、Hugging Face チームは新しいコードをコミットする際や質問がある場合に常に通知を受けることができます。
質問や問題が解決された際に、問題や質問が理解されやすいように、Hugging Face チームにコードを指摘することが非常に役立ちます。`,Pn,wt,Qa=`このためには、「Files changed」タブに移動してすべての変更を表示し、質問したい行に移動して「+」シンボルをクリックしてコメントを追加します。
質問や問題が解決された場合は、作成されたコメントの「Resolve」ボタンをクリックできます。`,Qn,yt,Ea=`同様に、Hugging Face チームはコードをレビューする際にコメントを開きます。
PR上でのほとんどの質問はGitHub上で行うことをお勧めします。
一般的な質問に関しては、公にはあまり役立たない質問については、SlackやメールでHugging Face チームに連絡することもできます。`,En,ut,Va="<strong>5. 生成されたモデルコードを”brand_new_bert”に適応させる</strong>",Vn,dt,za=`最初に、モデル自体に焦点を当て、トークナイザには気にしないでください。
関連するコードは、生成されたファイル<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>および<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>で見つかるはずです。`,zn,Jt,Da=`さて、ついにコーディングを始めることができます :smile:。
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>にある生成されたコードは、エンコーダーのみのモデルであればBERTと同じアーキテクチャを持っているか、エンコーダー-デコーダーモデルであればBARTと同じアーキテクチャを持っているはずです。
この段階では、モデルの理論的な側面について学んだことを思い出すべきです。つまり、「このモデルはBERTまたはBARTとどのように異なるのか？」ということです。
これらの変更を実装しますが、これは通常、セルフアテンションレイヤー、正規化レイヤーの順序などを変更することを意味します。
再び、あなたのモデルがどのように実装されるべきかをより良く理解するために、Transformers内に既存のモデルの類似アーキテクチャを見ることが役立つことがあります。`,Dn,jt,Xa=`この時点では、コードが完全に正確またはクリーンである必要はありません。
むしろ、まずは必要なコードの最初の<em>クリーンでない</em>コピー＆ペーストバージョンを
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>に追加し、必要なコードがすべて追加されていると感じるまで改善/修正を反復的に行うことがお勧めです。
私たちの経験から、必要なコードの最初のバージョンを迅速に追加し、次のセクションで説明する変換スクリプトを使用してコードを繰り返し改善/修正する方が効率的であることが多いです。
この時点で動作する必要があるのは、🤗 Transformersの”brand_new_bert”の実装をインスタンス化できることだけです。つまり、以下のコマンドが機能する必要があります：`,Xn,Ct,Yn,bt,Ya=`上記のコマンドは、<code>BrandNewBertConfig()</code> で定義されたデフォルトパラメータに従ってモデルを作成し、
すべてのコンポーネントの <code>init()</code> メソッドが正常に動作することを確認します。`,Fn,ct,Fa=`すべてのランダムな初期化は、<code>BrandnewBertPreTrainedModel</code> クラスの <code>_init_weights</code> メソッドで行う必要があります。
このメソッドは、設定変数に依存するすべてのリーフモジュールを初期化する必要があります。以下は、BERT の <code>_init_weights</code> メソッドの例です：`,Sn,Ut,qn,_t,Sa=`特定のモジュールに特別な初期化が必要な場合、カスタムスキームをさらに持つことができます。たとえば、
<code>Wav2Vec2ForPreTraining</code>では、最後の2つの線形層には通常のPyTorchの<code>nn.Linear</code>の初期化が必要ですが、
他のすべての層は上記のような初期化を使用する必要があります。これは以下のようにコーディングされています：`,On,ht,Kn,vt,qa=`<code>_is_hf_initialized</code>フラグは、サブモジュールを一度だけ初期化することを確実にするために内部で使用されます。
<code>module.project_q</code>と<code>module.project_hid</code>のためにそれを<code>True</code>に設定することで、
カスタム初期化が後で上書きされないようにし、<code>_init_weights</code>関数がそれらに適用されないようにします。`,ei,$t,Oa="<strong>6. 変換スクリプトを書く</strong>",ti,It,Ka=`次に、<em>brand_new_bert</em> の元のリポジトリでデバッグに使用したチェックポイントを、新しく作成した 🤗 Transformers 実装の <em>brand_new_bert</em> と互換性のあるチェックポイントに変換できる変換スクリプトを書く必要があります。
変換スクリプトをゼロから書くことはお勧めされませんが、代わりに 🤗 Transformers で既に存在する類似のモデルを同じフレームワークで変換したスクリプトを調べることが良いでしょう。
通常、既存の変換スクリプトをコピーして、自分のユースケースにわずかに適応させることで十分です。
Hugging Face チームに既存のモデルに類似した変換スクリプトを教えてもらうことも躊躇しないでください。`,li,Lt,eM='<li>TensorFlowからPyTorchにモデルを移植している場合、良い出発点はBERTの変換スクリプトかもしれません <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">here</a></li> <li>PyTorchからPyTorchにモデルを移植している場合、良い出発点はBARTの変換スクリプトかもしれません <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">here</a></li>',si,xt,tM=`以下では、PyTorchモデルが層の重みをどのように保存し、層の名前を定義するかについて簡単に説明します。
PyTorchでは、層の名前は層に与えるクラス属性の名前によって定義されます。
PyTorchで <code>SimpleModel</code> というダミーモデルを定義しましょう：`,ni,gt,ii,kt,lM="これで、このモデル定義のインスタンスを作成し、<code>dense</code>、<code>intermediate</code>、<code>layer_norm</code>のすべての重みをランダムな重みで埋めたモデルを作成できます。モデルのアーキテクチャを確認するために、モデルを印刷してみましょう。",ri,At,ai,Ht,sM="これは以下を出力します：",Mi,Zt,pi,Bt,nM="層の名前はPyTorchのクラス属性の名前によって定義されています。特定の層の重み値を出力することができます：",mi,Nt,Ti,Wt,iM="ランダムに初期化された重みを確認するために",oi,Rt,fi,Gt,rM="スクリプト内の変換スクリプトでは、ランダムに初期化された重みを、対応するチェックポイント内の正確な重みで埋める必要があります。例えば、以下のように翻訳します：",wi,Pt,yi,Qt,aM=`PyTorchモデルの各ランダム初期化された重みと対応する事前学習済みチェックポイントの重みが
<strong>形状と名前の両方</strong>で正確に一致することを確認する必要があります。
これを行うために、形状に対するassertステートメントを追加し、チェックポイントの重みの名前を出力することが
<strong>必要不可欠</strong>です。例えば、次のようなステートメントを追加する必要があります：`,ui,Et,di,Vt,MM="また、両方の重みの名前を印刷して、一致していることを確認する必要があります。例えば、次のようにします：",Ji,zt,ji,Dt,pM="もし形状または名前のいずれかが一致しない場合、おそらく誤って🤗 Transformersの実装に初期化されたレイヤーに間違ったチェックポイントの重みを割り当ててしまった可能性があります。",Ci,Xt,mM=`誤った形状は、おそらく<code>BrandNewBertConfig()</code>での設定パラメーターが、変換したいチェックポイントで使用されたものと正確に一致しないためです。
ただし、PyTorchのレイヤーの実装によっては、重みを事前に転置する必要がある場合もあります。`,bi,Yt,TM=`最後に、<strong>すべて</strong>の必要な重みが初期化されていることを確認し、初期化に使用されなかったすべてのチェックポイントの重みを表示して、モデルが正しく変換されていることを確認してください。
変換トライアルが誤った形状ステートメントまたは誤った名前割り当てで失敗するのは完全に正常です。
これはおそらく、<code>BrandNewBertConfig()</code>で誤ったパラメーターを使用したか、🤗 Transformersの実装に誤ったアーキテクチャがあるか、🤗 Transformersの実装の1つのコンポーネントの<code>init()</code>関数にバグがあるか、チェックポイントの重みの1つを転置する必要があるためです。`,ci,Ft,oM=`このステップは、以前のステップと繰り返すべきです。すべてのチェックポイントの重みが正しく🤗 Transformersモデルに読み込まれるまで繰り返すべきです。
🤗 Transformers実装に正しくチェックポイントを読み込んだ後、選択したフォルダーにモデルを保存できます <code>/path/to/converted/checkpoint/folder</code>。このフォルダには<code>pytorch_model.bin</code>ファイルと<code>config.json</code>ファイルの両方が含まれるはずです。`,Ui,St,_i,qt,fM="<strong>7. 順伝播（forward pass）の実装</strong>",hi,Ot,wM='🤗 Transformers実装で事前学習済みの重みを正しく読み込んだ後、順伝播が正しく実装されていることを確認する必要があります。<a href="#34-run-a-pretrained-checkpoint-using-the-original-repository">元のリポジトリを理解する</a>で、元のリポジトリを使用してモデルの順伝播を実行するスクリプトをすでに作成しました。今度は、元のリポジトリの代わりに🤗 Transformers実装を使用して類似のスクリプトを作成する必要があります。以下のようになります：',vi,Kt,$i,el,yM=`🤗 Transformersの実装と元のモデルの実装が最初の実行で完全に同じ出力を提供しないか、
フォワードパスでエラーが発生する可能性が非常に高いです。失望しないでください - これは予想されていることです！
まず、フォワードパスがエラーをスローしないことを確認する必要があります。
間違った次元が使用され、<em>次元の不一致</em>エラーや、誤ったデータ型オブジェクトが使用されることがよくあります。
例えば、<code>torch.long</code>ではなく<code>torch.float32</code>が使用されます。特定のエラーを解決できない場合は、
Hugging Faceチームに助けを求めることを躊躇しないでください。`,Ii,tl,uM=`🤗 Transformers実装が正しく機能することを確認する最終的な部分は、出力が<code>1e-3</code>の精度で同等であることを確認することです。
まず、出力の形状が同一であること、つまりスクリプトの🤗 Transformers実装と元の実装の両方で<code>outputs.shape</code>が同じ値を生成する必要があります。
次に、出力値が同一であることを確認する必要があります。
これは新しいモデルを追加する際の最も難しい部分の1つです。
出力が同一でない理由の一般的な間違いは以下の通りです。`,Li,ll,dM=`<li>一部のレイヤーが追加されていない、つまり<em>活性化</em>レイヤーが追加されていないか、リザバル接続が忘れられている</li> <li>単語埋め込み行列が結ばれていない</li> <li>オリジナルの実装がオフセットを使用しているため、誤った位置埋め込みが使用されている</li> <li>フォワードパス中にドロップアウトが適用されています。これを修正するには、<em>model.trainingがFalse</em>であることを確認し、フォワードパス中に誤ってドロップアウトレイヤーがアクティブ化されないようにします。
<em>つまり</em> <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorchのfunctional dropout</a>に<em>model.training</em>を渡します。</li>`,xi,sl,JM=`問題を修正する最良の方法は、通常、元の実装と🤗 Transformers実装のフォワードパスを並べて表示し、違いがあるかどうかを確認することです。
理想的には、フォワードパスの両方の実装の中間出力をデバッグ/プリントアウトして、🤗 Transformers実装が元の実装と異なる出力を示すネットワーク内の正確な位置を見つけることができます。
最初に、両方のスクリプトのハードコーディングされた<code>input_ids</code>が同一であることを確認します。
次に、<code>input_ids</code>の最初の変換（通常、単語埋め込み）の出力が同一であることを確認します。
その後、ネットワークの最後のレイヤーまで作業を進めます。
いずれかの時点で、2つの実装間で違いがあることに気付くはずで、それにより🤗 Transformers実装のバグの場所が特定されます。
経験上、元の実装と🤗 Transformers実装のフォワードパスの同じ位置に多くのプリントステートメントを追加し、
中間プレゼンテーションで同じ値を示すプリントステートメントを段階的に削除するのがシンプルかつ効果的な方法です。`,gi,nl,jM=`両方の実装が同じ出力を生成することに自信を持っている場合、<code>torch.allclose(original_output, output, atol=1e-3)</code>を使用して出力を確認すると、最も難しい部分が完了します！
おめでとうございます - 完了する作業は簡単なものになるはずです 😊。`,ki,il,CM="<strong>8. 必要なすべてのモデルテストを追加</strong>",Ai,rl,bM=`この時点で、新しいモデルが正常に追加されました。
ただし、モデルがまだ必要な設計に完全に準拠していない可能性が非常に高いです。
🤗 Transformersと完全に互換性があることを確認するために、すべての一般的なテストがパスする必要があります。
Cookiecutterはおそらくモデル用のテストファイルを自動的に追加しているはずで、おそらく同じディレクトリに<code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code>として存在します。
このテストファイルを実行して、すべての一般的なテストがパスすることを確認してください：`,Hi,al,Zi,Ml,cM="すべての一般的なテストを修正したら、今度は実行したすべての素晴らしい作業が適切にテストされていることを確認することが非常に重要です。これにより、",Bi,pl,UM="<li>a) コミュニティは<em>brand_new_bert</em>の特定のテストを見ることで、あなたの作業を簡単に理解できます。</li> <li>b) モデルへの将来の変更がモデルの重要な機能を壊さないようにすることができます。</li>",Ni,ml,_M="まず、統合テストを追加する必要があります。これらの統合テストは、基本的にはデバッグスクリプトと同じことを行います。これらのモデルテストのテンプレートはCookiecutterによって既に追加されており、「BrandNewBertModelIntegrationTests」と呼ばれています。このテストを記入するだけです。これらのテストが合格していることを確認するには、次のコマンドを実行します。",Wi,Tl,Ri,L,Gi,ol,hM=`次に、<em>brand_new_bert</em>に特有のすべての特徴は、別個のテスト内で追加されるべきです。
<code>BrandNewBertModelTester</code>/<code>BrandNewBertModelTest</code>の下に。この部分はよく忘れられますが、2つの点で非常に役立ちます：`,Pi,fl,vM="<li>モデルの追加中に獲得した知識をコミュニティに伝え、<em>brand_new_bert</em>の特別な機能がどのように動作するかを示すことによって、知識の共有を支援します。</li> <li>将来の貢献者は、これらの特別なテストを実行することでモデルへの変更を迅速にテストできます。</li>",Qi,wl,$M="<strong>9. トークナイザの実装</strong>",Ei,yl,IM="次に、<em>brand_new_bert</em>のトークナイザを追加する必要があります。通常、トークナイザは🤗 Transformersの既存のトークナイザと同等か非常に似ています。",Vi,ul,LM=`トークナイザが正しく動作することを確認するためには、まず、元のリポジトリ内で文字列を入力し、<code>input_ids</code>を返すスクリプトを作成することをお勧めします。
このスクリプトは、次のように見えるかもしれません（疑似コードで示します）：`,zi,dl,Di,Jl,xM=`オリジナルのリポジトリを詳しく調査し、正しいトークナイザの関数を見つける必要があるかもしれません。
または、オリジナルのリポジトリのクローンを変更して、<code>input_ids</code>だけを出力するようにする必要があるかもしれません。
オリジナルのリポジトリを使用した機能的なトークナイゼーションスクリプトを作成した後、
🤗 Transformers向けの類似したスクリプトを作成する必要があります。
以下のように見えるべきです：`,Xi,jl,Yi,Cl,gM="<code>input_ids</code>が同じ値を生成した場合、最終ステップとしてトークナイザのテストファイルも追加するべきです。",Fi,bl,kM="<em>brand_new_bert</em>のモデルングテストファイルと同様に、<em>brand_new_bert</em>のトークナイズテストファイルには、いくつかのハードコードされた統合テストが含まれるべきです。",Si,cl,AM="<strong>10. エンドツーエンド統合テストの実行</strong>",qi,Ul,HM=`トークナイザを追加した後、<code>🤗 Transformers</code>内の<code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code>に
モデルとトークナイザの両方を使用するいくつかのエンドツーエンド統合テストも追加する必要があります。
このようなテストは、🤗 Transformersの実装が期待どおりに機能することを示すべきです。
意味のあるテキスト対テキストのサンプルが含まれます。有用なテキスト対テキストのサンプルには、ソースからターゲットへの翻訳ペア、記事から要約へのペア、質問から回答へのペアなどが含まれます。
ポートされたチェックポイントがダウンストリームタスクでファインチューニングされていない場合、モデルのテストに依存するだけで十分です。
モデルが完全に機能していることを確認するために、すべてのテストをGPU上で実行することもお勧めします。
モデルの内部テンソルに<code>.to(self.device)</code>ステートメントを追加するのを忘れる可能性があるため、そのようなテストではエラーが表示されることがあります。
GPUにアクセスできない場合、Hugging Faceチームが代わりにこれらのテストを実行できます。`,Oi,_l,ZM="<strong>11. ドキュメントの追加</strong>",Ki,hl,BM=`これで、<em>brand_new_bert</em>の必要なすべての機能が追加されました - ほぼ完了です！残りの追加すべきことは、良いドキュメントとドキュメントページです。
Cookiecutterが<code>docs/source/model_doc/brand_new_bert.md</code>というテンプレートファイルを追加しているはずで、これを記入する必要があります。
モデルのユーザーは通常、モデルを使用する前にまずこのページを見ます。したがって、ドキュメンテーションは理解しやすく簡潔である必要があります。
モデルの使用方法を示すためにいくつかの<em>Tips</em>を追加することはコミュニティにとって非常に役立ちます。ドキュメンテーションに関しては、Hugging Faceチームに問い合わせることをためらわないでください。`,er,vl,NM=`次に、<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>に追加されたドキュメンテーション文字列が正しいこと、およびすべての必要な入力および出力を含んでいることを確認してください。
ドキュメンテーションの書き方とドキュメンテーション文字列のフォーマットについて詳細なガイドが<a href="writing-documentation">こちら</a>にあります。
ドキュメンテーションは通常、コミュニティとモデルの最初の接触点であるため、コードと同じくらい注意深く扱うべきであることを常に念頭に置いてください。`,tr,$l,WM="<strong>コードのリファクタリング</strong>",lr,Il,RM=`素晴らしい、これで<em>brand_new_bert</em>に必要なすべてのコードが追加されました。
この時点で、次のようなポテンシャルなコードスタイルの誤りを訂正するために以下を実行する必要があります：`,sr,Ll,nr,xl,GM="あなたのコーディングスタイルが品質チェックをパスすることを確認してください:",ir,gl,rr,kl,PM=`🤗 Transformersの非常に厳格なデザインテストには、まだ合格していない可能性があるいくつかの他のテストが存在するかもしれません。
これは、ドキュメント文字列に情報が不足しているか、名前が間違っていることが原因であることが多いです。Hugging Faceチームは、ここで詰まっている場合には必ず助けてくれるでしょう。`,ar,Al,QM=`最後に、コードが正しく機能することを確認した後、コードをリファクタリングするのは常に良いアイデアです。
すべてのテストがパスした今、追加したコードを再度確認してリファクタリングを行うのは良いタイミングです。`,Mr,Hl,EM="これでコーディングの部分は完了しました、おめでとうございます！ 🎉 あなたは素晴らしいです！ 😎",pr,Zl,VM="<strong>12. モデルをモデルハブにアップロード</strong>",mr,Bl,zM=`最後のパートでは、すべてのチェックポイントをモデルハブに変換してアップロードし、各アップロードしたモデルチェックポイントにモデルカードを追加する必要があります。
モデルハブの機能について詳しくは、<a href="model_sharing">Model sharing and uploading Page</a>を読んで理解できます。
ここでは、<em>brand_new_bert</em>の著者組織の下にモデルをアップロードできるように必要なアクセス権を取得するために、Hugging Faceチームと協力する必要があります。
<code>transformers</code>のすべてのモデルに存在する<code>push_to_hub</code>メソッドは、チェックポイントをハブにプッシュする迅速かつ効率的な方法です。
以下に、少しのコードスニペットを示します：`,Tr,Nl,or,Wl,DM="各チェックポイントに適切なモデルカードを作成する価値があります。モデルカードは、この特定のチェックポイントの特性をハイライトするべきです。例えば、このチェックポイントはどのデータセットで事前学習/ファインチューニングされたか、どのような下流タスクでモデルを使用すべきかを示すべきです。また、モデルの正しい使用方法に関するコードも含めるべきです。",fr,Rl,XM="<strong>13.（オプション）ノートブックの追加</strong>",wr,Gl,YM="<em>brand_new_bert</em>を推論または下流タスクのファインチューニングにどのように詳細に使用できるかを示すノートブックを追加することは非常に役立ちます。これはあなたのPRをマージするために必須ではありませんが、コミュニティにとって非常に有用です。",yr,Pl,FM="<strong>14. 完成したPRの提出</strong>",ur,Ql,SM="プログラミングが完了したら、最後のステップに移動し、PRをメインブランチにマージしましょう。通常、Hugging Faceチームはこの時点で既にあなたをサポートしているはずですが、PRに良い説明を追加し、コードにコメントを追加して、レビュアーに特定の設計の選択肢を指摘したい場合はコメントを追加することも価値があります。",dr,El,Jr,Vl,qM="さあ、コミュニティからあなたの作業に対する評価を得る時が来ました！モデルの追加を完了することは、TransformersおよびNLPコミュニティにとって重要な貢献です。あなたのコードとポートされた事前学習済みモデルは、何百人、何千人という開発者や研究者によって確実に使用されるでしょう。あなたの仕事に誇りを持ち、コミュニティとあなたの成果を共有しましょう。",jr,zl,OM="<strong>あなたはコミュニティの誰でも簡単にアクセスできる別のモデルを作成しました！ 🤯</strong>",Cr,Yl,br;return x=new J({props:{title:"How to add a model to 🤗 Transformers?",local:"how-to-add-a-model-to--transformers",headingTag:"h1"}}),c=new lp({props:{$$slots:{default:[op]},$$scope:{ctx:Dl}}}),N=new J({props:{title:"General overview of 🤗 Transformers",local:"general-overview-of--transformers",headingTag:"h2"}}),Q=new J({props:{title:"Overview of models",local:"overview-of-models",headingTag:"h3"}}),D=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwbW9kZWwlMjBoYXMlMjBhY2Nlc3MlMjB0byUyMGl0cyUyMGNvbmZpZw==",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># model has access to its config</span>`,wrap:!1}}),Y=new J({props:{title:"Code style",local:"code-style",headingTag:"h3"}}),q=new J({props:{title:"Overview of tokenizers",local:"overview-of-tokenizers",headingTag:"h3"}}),K=new J({props:{title:"Step-by-step recipe to add a model to 🤗 Transformers",local:"step-by-step-recipe-to-add-a-model-to--transformers",headingTag:"h2"}}),Me=new J({props:{title:"1. (Optional) Theoretical aspects of BrandNewBert",local:"1-optional-theoretical-aspects-of-brandnewbert",headingTag:"h3"}}),oe=new J({props:{title:"2. Next prepare your environment",local:"2-next-prepare-your-environment",headingTag:"h3"}}),we=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),ye=new y({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),ue=new y({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),Je=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnF1YWxpdHklNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[quality]&quot;</span>',wrap:!1}}),Ce=new y({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),be=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),Ue=new J({props:{title:"3.-4. Run a pretrained checkpoint using the original repository",local:"3-4-run-a-pretrained-checkpoint-using-the-original-repository",headingTag:"h3"}}),Ae=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),De=new y({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),Se=new J({props:{title:"5.-14. Port BrandNewBert to 🤗 Transformers",local:"5-14-port-brandnewbert-to--transformers",headingTag:"h3"}}),Oe=new y({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),at=new y({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydA==",highlighted:"git checkout -b add_brand_new_bert",wrap:!1}}),Mt=new y({props:{code:"Z2l0JTIwYWRkJTIwLiUwQWdpdCUyMGNvbW1pdA==",highlighted:`git add .
git commit`,wrap:!1}}),pt=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbg==",highlighted:`git fetch upstream
git rebase upstream/main`,wrap:!1}}),mt=new y({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),ot=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),Ct=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),Ut=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxpbmVhciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUuYmlhcyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5iaWFzLmRhdGEuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkVtYmVkZGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUucGFkZGluZ19pZHglMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGElNUJtb2R1bGUucGFkZGluZ19pZHglNUQuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxheWVyTm9ybSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEuZmlsbF8oMS4wKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Embedding):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.padding_idx <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.weight.data[module.padding_idx].zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.LayerNorm):
        module.bias.data.zero_()
        module.weight.data.fill_(<span class="hljs-number">1.0</span>)`,wrap:!1}}),ht=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RuYWNlKG1vZHVsZSUyQyUyMFdhdjJWZWMyRm9yUHJlVHJhaW5pbmcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLnJlc2V0X3BhcmFtZXRlcnMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5wcm9qZWN0X3EucmVzZXRfcGFyYW1ldGVycygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUucHJvamVjdF9xLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjBlbGlmJTIwaXNpbnN0YW5jZShtb2R1bGUlMkMlMjBubi5MaW5lYXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLndlaWdodC5kYXRhLm5vcm1hbF8obWVhbiUzRDAuMCUyQyUyMHN0ZCUzRHNlbGYuY29uZmlnLmluaXRpYWxpemVyX3JhbmdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbW9kdWxlLmJpYXMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> isinstnace(module, Wav2Vec2ForPreTraining):
        module.project_hid.reset_parameters()
        module.project_q.reset_parameters()
        module.project_hid._is_hf_initialized = <span class="hljs-literal">True</span>
        module.project_q._is_hf_initialized = <span class="hljs-literal">True</span>
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()`,wrap:!1}}),gt=new y({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),At=new y({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),Zt=new y({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),Nt=new y({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),Rt=new y({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),Pt=new y({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Et=new y({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),zt=new y({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),St=new y({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),Kt=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),al=new y({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHk=",highlighted:"pytest tests/models/brand_new_bert/test_modeling_brand_new_bert.py",wrap:!1}}),Tl=new y({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHklM0ElM0FCcmFuZE5ld0JlcnRNb2RlbEludGVncmF0aW9uVGVzdHM=",highlighted:"RUN_SLOW=1 pytest -sv tests/models/brand_new_bert/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),L=new lp({props:{$$slots:{default:[fp]},$$scope:{ctx:Dl}}}),dl=new y({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),jl=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Ll=new y({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),gl=new y({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),Nl=new y({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyYnJhbmRfbmV3X2JlcnQlMjIpJTBBJTIzJTIwVW5jb21tZW50JTIwdGhlJTIwZm9sbG93aW5nJTIwbGluZSUyMHRvJTIwcHVzaCUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24uJTBBJTIzJTIwYnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyJTNDb3JnYW5pemF0aW9uJTNFJTJGYnJhbmRfbmV3X2JlcnQlMjIp",highlighted:`brand_new_bert.push_to_hub(<span class="hljs-string">&quot;brand_new_bert&quot;</span>)
<span class="hljs-comment"># Uncomment the following line to push to an organization.</span>
<span class="hljs-comment"># brand_new_bert.push_to_hub(&quot;&lt;organization&gt;/brand_new_bert&quot;)</span>`,wrap:!1}}),El=new J({props:{title:"Share your work!!",local:"share-your-work",headingTag:"h3"}}),{c(){u=r("meta"),j=n(),d=r("p"),b=n(),p(x.$$.fragment),Fl=n(),g=r("p"),g.innerHTML=cr,Sl=n(),p(c.$$.fragment),ql=n(),k=r("p"),k.textContent=Ur,Ol=n(),A=r("ul"),A.innerHTML=_r,Kl=n(),H=r("p"),H.textContent=hr,es=n(),Z=r("p"),Z.innerHTML=vr,ts=n(),B=r("p"),B.textContent=$r,ls=n(),p(N.$$.fragment),ss=n(),W=r("p"),W.textContent=Ir,ns=n(),R=r("p"),R.innerHTML=Lr,is=n(),G=r("ul"),G.innerHTML=xr,rs=n(),P=r("p"),P.innerHTML=gr,as=n(),p(Q.$$.fragment),Ms=n(),E=r("p"),E.innerHTML=kr,ps=n(),V=r("p"),V.textContent=Ar,ms=n(),Xl=r("img"),Ts=n(),z=r("p"),z.innerHTML=Zr,os=n(),p(D.$$.fragment),fs=n(),X=r("p"),X.innerHTML=Br,ws=n(),p(Y.$$.fragment),ys=n(),F=r("p"),F.textContent=Nr,us=n(),S=r("ol"),S.innerHTML=Wr,ds=n(),p(q.$$.fragment),Js=n(),O=r("p"),O.textContent=Rr,js=n(),p(K.$$.fragment),Cs=n(),ee=r("p"),ee.textContent=Gr,bs=n(),te=r("ol"),te.innerHTML=Pr,cs=n(),le=r("p"),le.textContent=Qr,Us=n(),se=r("ul"),se.innerHTML=Er,_s=n(),ne=r("p"),ne.textContent=Vr,hs=n(),ie=r("p"),ie.textContent=zr,vs=n(),re=r("ul"),re.innerHTML=Dr,$s=n(),ae=r("p"),ae.innerHTML=Xr,Is=n(),p(Me.$$.fragment),Ls=n(),pe=r("p"),pe.textContent=Yr,xs=n(),me=r("ul"),me.innerHTML=Fr,gs=n(),Te=r("p"),Te.textContent=Sr,ks=n(),p(oe.$$.fragment),As=n(),fe=r("ol"),fe.innerHTML=qr,Hs=n(),p(we.$$.fragment),Zs=n(),p(ye.$$.fragment),Bs=n(),U=r("ol"),U.innerHTML=Or,Ns=n(),p(ue.$$.fragment),Ws=n(),de=r("p"),de.textContent=Kr,Rs=n(),p(Je.$$.fragment),Gs=n(),je=r("p"),je.textContent=ea,Ps=n(),p(Ce.$$.fragment),Qs=n(),_=r("ol"),_.innerHTML=ta,Es=n(),p(be.$$.fragment),Vs=n(),ce=r("p"),ce.innerHTML=la,zs=n(),p(Ue.$$.fragment),Ds=n(),_e=r("p"),_e.innerHTML=sa,Xs=n(),he=r("p"),he.textContent=na,Ys=n(),ve=r("p"),ve.innerHTML=ia,Fs=n(),$e=r("ul"),$e.innerHTML=ra,Ss=n(),Ie=r("p"),Ie.innerHTML=aa,qs=n(),Le=r("p"),Le.textContent=Ma,Os=n(),xe=r("p"),xe.textContent=pa,Ks=n(),ge=r("ul"),ge.innerHTML=ma,en=n(),ke=r("p"),ke.textContent=Ta,tn=n(),p(Ae.$$.fragment),ln=n(),He=r("p"),He.textContent=oa,sn=n(),Ze=r("ul"),Ze.innerHTML=fa,nn=n(),Be=r("p"),Be.textContent=wa,rn=n(),Ne=r("p"),Ne.innerHTML=ya,an=n(),We=r("ul"),We.innerHTML=ua,Mn=n(),Re=r("p"),Re.innerHTML=da,pn=n(),Ge=r("p"),Ge.innerHTML=Ja,mn=n(),Pe=r("p"),Pe.textContent=ja,Tn=n(),Qe=r("p"),Qe.textContent=Ca,on=n(),Ee=r("ol"),Ee.innerHTML=ba,fn=n(),Ve=r("p"),Ve.innerHTML=ca,wn=n(),ze=r("p"),ze.textContent=Ua,yn=n(),p(De.$$.fragment),un=n(),Xe=r("p"),Xe.innerHTML=_a,dn=n(),Ye=r("ul"),Ye.innerHTML=ha,Jn=n(),Fe=r("p"),Fe.innerHTML=va,jn=n(),p(Se.$$.fragment),Cn=n(),qe=r("p"),qe.textContent=$a,bn=n(),p(Oe.$$.fragment),cn=n(),Ke=r("p"),Ke.innerHTML=Ia,Un=n(),et=r("p"),et.textContent=La,_n=n(),tt=r("ul"),tt.innerHTML=xa,hn=n(),lt=r("p"),lt.innerHTML=ga,vn=n(),st=r("p"),st.innerHTML=ka,$n=n(),nt=r("p"),nt.innerHTML=Aa,In=n(),it=r("p"),it.textContent=Ha,Ln=n(),rt=r("ol"),rt.innerHTML=Za,xn=n(),p(at.$$.fragment),gn=n(),h=r("ol"),h.innerHTML=Ba,kn=n(),p(Mt.$$.fragment),An=n(),v=r("ol"),v.innerHTML=Na,Hn=n(),p(pt.$$.fragment),Zn=n(),$=r("ol"),$.innerHTML=Wa,Bn=n(),p(mt.$$.fragment),Nn=n(),I=r("ol"),I.innerHTML=Ra,Wn=n(),Tt=r("p"),Tt.textContent=Ga,Rn=n(),p(ot.$$.fragment),Gn=n(),ft=r("p"),ft.textContent=Pa,Pn=n(),wt=r("p"),wt.textContent=Qa,Qn=n(),yt=r("p"),yt.textContent=Ea,En=n(),ut=r("p"),ut.innerHTML=Va,Vn=n(),dt=r("p"),dt.innerHTML=za,zn=n(),Jt=r("p"),Jt.innerHTML=Da,Dn=n(),jt=r("p"),jt.innerHTML=Xa,Xn=n(),p(Ct.$$.fragment),Yn=n(),bt=r("p"),bt.innerHTML=Ya,Fn=n(),ct=r("p"),ct.innerHTML=Fa,Sn=n(),p(Ut.$$.fragment),qn=n(),_t=r("p"),_t.innerHTML=Sa,On=n(),p(ht.$$.fragment),Kn=n(),vt=r("p"),vt.innerHTML=qa,ei=n(),$t=r("p"),$t.innerHTML=Oa,ti=n(),It=r("p"),It.innerHTML=Ka,li=n(),Lt=r("ul"),Lt.innerHTML=eM,si=n(),xt=r("p"),xt.innerHTML=tM,ni=n(),p(gt.$$.fragment),ii=n(),kt=r("p"),kt.innerHTML=lM,ri=n(),p(At.$$.fragment),ai=n(),Ht=r("p"),Ht.textContent=sM,Mi=n(),p(Zt.$$.fragment),pi=n(),Bt=r("p"),Bt.textContent=nM,mi=n(),p(Nt.$$.fragment),Ti=n(),Wt=r("p"),Wt.textContent=iM,oi=n(),p(Rt.$$.fragment),fi=n(),Gt=r("p"),Gt.textContent=rM,wi=n(),p(Pt.$$.fragment),yi=n(),Qt=r("p"),Qt.innerHTML=aM,ui=n(),p(Et.$$.fragment),di=n(),Vt=r("p"),Vt.textContent=MM,Ji=n(),p(zt.$$.fragment),ji=n(),Dt=r("p"),Dt.textContent=pM,Ci=n(),Xt=r("p"),Xt.innerHTML=mM,bi=n(),Yt=r("p"),Yt.innerHTML=TM,ci=n(),Ft=r("p"),Ft.innerHTML=oM,Ui=n(),p(St.$$.fragment),_i=n(),qt=r("p"),qt.innerHTML=fM,hi=n(),Ot=r("p"),Ot.innerHTML=wM,vi=n(),p(Kt.$$.fragment),$i=n(),el=r("p"),el.innerHTML=yM,Ii=n(),tl=r("p"),tl.innerHTML=uM,Li=n(),ll=r("ul"),ll.innerHTML=dM,xi=n(),sl=r("p"),sl.innerHTML=JM,gi=n(),nl=r("p"),nl.innerHTML=jM,ki=n(),il=r("p"),il.innerHTML=CM,Ai=n(),rl=r("p"),rl.innerHTML=bM,Hi=n(),p(al.$$.fragment),Zi=n(),Ml=r("p"),Ml.textContent=cM,Bi=n(),pl=r("ul"),pl.innerHTML=UM,Ni=n(),ml=r("p"),ml.textContent=_M,Wi=n(),p(Tl.$$.fragment),Ri=n(),p(L.$$.fragment),Gi=n(),ol=r("p"),ol.innerHTML=hM,Pi=n(),fl=r("ul"),fl.innerHTML=vM,Qi=n(),wl=r("p"),wl.innerHTML=$M,Ei=n(),yl=r("p"),yl.innerHTML=IM,Vi=n(),ul=r("p"),ul.innerHTML=LM,zi=n(),p(dl.$$.fragment),Di=n(),Jl=r("p"),Jl.innerHTML=xM,Xi=n(),p(jl.$$.fragment),Yi=n(),Cl=r("p"),Cl.innerHTML=gM,Fi=n(),bl=r("p"),bl.innerHTML=kM,Si=n(),cl=r("p"),cl.innerHTML=AM,qi=n(),Ul=r("p"),Ul.innerHTML=HM,Oi=n(),_l=r("p"),_l.innerHTML=ZM,Ki=n(),hl=r("p"),hl.innerHTML=BM,er=n(),vl=r("p"),vl.innerHTML=NM,tr=n(),$l=r("p"),$l.innerHTML=WM,lr=n(),Il=r("p"),Il.innerHTML=RM,sr=n(),p(Ll.$$.fragment),nr=n(),xl=r("p"),xl.textContent=GM,ir=n(),p(gl.$$.fragment),rr=n(),kl=r("p"),kl.textContent=PM,ar=n(),Al=r("p"),Al.textContent=QM,Mr=n(),Hl=r("p"),Hl.textContent=EM,pr=n(),Zl=r("p"),Zl.innerHTML=VM,mr=n(),Bl=r("p"),Bl.innerHTML=zM,Tr=n(),p(Nl.$$.fragment),or=n(),Wl=r("p"),Wl.textContent=DM,fr=n(),Rl=r("p"),Rl.innerHTML=XM,wr=n(),Gl=r("p"),Gl.innerHTML=YM,yr=n(),Pl=r("p"),Pl.innerHTML=FM,ur=n(),Ql=r("p"),Ql.textContent=SM,dr=n(),p(El.$$.fragment),Jr=n(),Vl=r("p"),Vl.textContent=qM,jr=n(),zl=r("p"),zl.innerHTML=OM,Cr=n(),Yl=r("p"),this.h()},l(e){const t=pp("svelte-u9bgzb",document.head);u=a(t,"META",{name:!0,content:!0}),t.forEach(l),j=i(e),d=a(e,"P",{}),tp(d).forEach(l),b=i(e),m(x.$$.fragment,e),Fl=i(e),g=a(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-18u0cj4"&&(g.innerHTML=cr),Sl=i(e),m(c.$$.fragment,e),ql=i(e),k=a(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1k433fh"&&(k.textContent=Ur),Ol=i(e),A=a(e,"UL",{"data-svelte-h":!0}),M(A)!=="svelte-vya7rd"&&(A.innerHTML=_r),Kl=i(e),H=a(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1qusnr2"&&(H.textContent=hr),es=i(e),Z=a(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-vq9gyk"&&(Z.innerHTML=vr),ts=i(e),B=a(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-hbllep"&&(B.textContent=$r),ls=i(e),m(N.$$.fragment,e),ss=i(e),W=a(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-hwdnqm"&&(W.textContent=Ir),ns=i(e),R=a(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-p3t7yw"&&(R.innerHTML=Lr),is=i(e),G=a(e,"UL",{"data-svelte-h":!0}),M(G)!=="svelte-9t3nui"&&(G.innerHTML=xr),rs=i(e),P=a(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-18nm5a"&&(P.innerHTML=gr),as=i(e),m(Q.$$.fragment,e),Ms=i(e),E=a(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1fxw6b1"&&(E.innerHTML=kr),ps=i(e),V=a(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1gbz23r"&&(V.textContent=Ar),ms=i(e),Xl=a(e,"IMG",{src:!0}),Ts=i(e),z=a(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1rpq7wi"&&(z.innerHTML=Zr),os=i(e),m(D.$$.fragment,e),fs=i(e),X=a(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-5xmh3t"&&(X.innerHTML=Br),ws=i(e),m(Y.$$.fragment,e),ys=i(e),F=a(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1i6feua"&&(F.textContent=Nr),us=i(e),S=a(e,"OL",{"data-svelte-h":!0}),M(S)!=="svelte-1ttw28h"&&(S.innerHTML=Wr),ds=i(e),m(q.$$.fragment,e),Js=i(e),O=a(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1blruvz"&&(O.textContent=Rr),js=i(e),m(K.$$.fragment,e),Cs=i(e),ee=a(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1s26ue3"&&(ee.textContent=Gr),bs=i(e),te=a(e,"OL",{"data-svelte-h":!0}),M(te)!=="svelte-1pfihai"&&(te.innerHTML=Pr),cs=i(e),le=a(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1sq61dt"&&(le.textContent=Qr),Us=i(e),se=a(e,"UL",{"data-svelte-h":!0}),M(se)!=="svelte-sv30f"&&(se.innerHTML=Er),_s=i(e),ne=a(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1ypz8pq"&&(ne.textContent=Vr),hs=i(e),ie=a(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1p66n8c"&&(ie.textContent=zr),vs=i(e),re=a(e,"UL",{"data-svelte-h":!0}),M(re)!=="svelte-1emp8vi"&&(re.innerHTML=Dr),$s=i(e),ae=a(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-7d1rj7"&&(ae.innerHTML=Xr),Is=i(e),m(Me.$$.fragment,e),Ls=i(e),pe=a(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1gjlk24"&&(pe.textContent=Yr),xs=i(e),me=a(e,"UL",{"data-svelte-h":!0}),M(me)!=="svelte-1kmfqav"&&(me.innerHTML=Fr),gs=i(e),Te=a(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-76k9xp"&&(Te.textContent=Sr),ks=i(e),m(oe.$$.fragment,e),As=i(e),fe=a(e,"OL",{"data-svelte-h":!0}),M(fe)!=="svelte-g4bq6e"&&(fe.innerHTML=qr),Hs=i(e),m(we.$$.fragment,e),Zs=i(e),m(ye.$$.fragment,e),Bs=i(e),U=a(e,"OL",{start:!0,"data-svelte-h":!0}),M(U)!=="svelte-yke5tt"&&(U.innerHTML=Or),Ns=i(e),m(ue.$$.fragment,e),Ws=i(e),de=a(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-aphjjd"&&(de.textContent=Kr),Rs=i(e),m(Je.$$.fragment,e),Gs=i(e),je=a(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-bsat2u"&&(je.textContent=ea),Ps=i(e),m(Ce.$$.fragment,e),Qs=i(e),_=a(e,"OL",{start:!0,"data-svelte-h":!0}),M(_)!=="svelte-1y9s84w"&&(_.innerHTML=ta),Es=i(e),m(be.$$.fragment,e),Vs=i(e),ce=a(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-es745w"&&(ce.innerHTML=la),zs=i(e),m(Ue.$$.fragment,e),Ds=i(e),_e=a(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-10t4mg7"&&(_e.innerHTML=sa),Xs=i(e),he=a(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-mye1f5"&&(he.textContent=na),Ys=i(e),ve=a(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-12yrw8c"&&(ve.innerHTML=ia),Fs=i(e),$e=a(e,"UL",{"data-svelte-h":!0}),M($e)!=="svelte-ptsdxf"&&($e.innerHTML=ra),Ss=i(e),Ie=a(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-1uw967"&&(Ie.innerHTML=aa),qs=i(e),Le=a(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-1hes8f4"&&(Le.textContent=Ma),Os=i(e),xe=a(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-yv8vzk"&&(xe.textContent=pa),Ks=i(e),ge=a(e,"UL",{"data-svelte-h":!0}),M(ge)!=="svelte-1nwgioq"&&(ge.innerHTML=ma),en=i(e),ke=a(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-d7dyt7"&&(ke.textContent=Ta),tn=i(e),m(Ae.$$.fragment,e),ln=i(e),He=a(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-geyqe2"&&(He.textContent=oa),sn=i(e),Ze=a(e,"UL",{"data-svelte-h":!0}),M(Ze)!=="svelte-1qeto49"&&(Ze.innerHTML=fa),nn=i(e),Be=a(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-jzzros"&&(Be.textContent=wa),rn=i(e),Ne=a(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-8zv3i3"&&(Ne.innerHTML=ya),an=i(e),We=a(e,"UL",{"data-svelte-h":!0}),M(We)!=="svelte-1l3920x"&&(We.innerHTML=ua),Mn=i(e),Re=a(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1siclj5"&&(Re.innerHTML=da),pn=i(e),Ge=a(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1vdgcpw"&&(Ge.innerHTML=Ja),mn=i(e),Pe=a(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-1ayz70j"&&(Pe.textContent=ja),Tn=i(e),Qe=a(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-kvlx3r"&&(Qe.textContent=Ca),on=i(e),Ee=a(e,"OL",{"data-svelte-h":!0}),M(Ee)!=="svelte-pueryw"&&(Ee.innerHTML=ba),fn=i(e),Ve=a(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-ts6c7j"&&(Ve.innerHTML=ca),wn=i(e),ze=a(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-92scbt"&&(ze.textContent=Ua),yn=i(e),m(De.$$.fragment,e),un=i(e),Xe=a(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-8ir8yh"&&(Xe.innerHTML=_a),dn=i(e),Ye=a(e,"UL",{"data-svelte-h":!0}),M(Ye)!=="svelte-1sk6aw"&&(Ye.innerHTML=ha),Jn=i(e),Fe=a(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-1xspdas"&&(Fe.innerHTML=va),jn=i(e),m(Se.$$.fragment,e),Cn=i(e),qe=a(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1rf22aq"&&(qe.textContent=$a),bn=i(e),m(Oe.$$.fragment,e),cn=i(e),Ke=a(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-7qqxut"&&(Ke.innerHTML=Ia),Un=i(e),et=a(e,"P",{"data-svelte-h":!0}),M(et)!=="svelte-13p5ehb"&&(et.textContent=La),_n=i(e),tt=a(e,"UL",{"data-svelte-h":!0}),M(tt)!=="svelte-13tlf6o"&&(tt.innerHTML=xa),hn=i(e),lt=a(e,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-wzmyoq"&&(lt.innerHTML=ga),vn=i(e),st=a(e,"P",{"data-svelte-h":!0}),M(st)!=="svelte-4zcs02"&&(st.innerHTML=ka),$n=i(e),nt=a(e,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1wljgm9"&&(nt.innerHTML=Aa),In=i(e),it=a(e,"P",{"data-svelte-h":!0}),M(it)!=="svelte-1mk9jzr"&&(it.textContent=Ha),Ln=i(e),rt=a(e,"OL",{"data-svelte-h":!0}),M(rt)!=="svelte-1lq0ebt"&&(rt.innerHTML=Za),xn=i(e),m(at.$$.fragment,e),gn=i(e),h=a(e,"OL",{start:!0,"data-svelte-h":!0}),M(h)!=="svelte-1udpty6"&&(h.innerHTML=Ba),kn=i(e),m(Mt.$$.fragment,e),An=i(e),v=a(e,"OL",{start:!0,"data-svelte-h":!0}),M(v)!=="svelte-u3dobd"&&(v.innerHTML=Na),Hn=i(e),m(pt.$$.fragment,e),Zn=i(e),$=a(e,"OL",{start:!0,"data-svelte-h":!0}),M($)!=="svelte-pji4t7"&&($.innerHTML=Wa),Bn=i(e),m(mt.$$.fragment,e),Nn=i(e),I=a(e,"OL",{start:!0,"data-svelte-h":!0}),M(I)!=="svelte-1fxrk8a"&&(I.innerHTML=Ra),Wn=i(e),Tt=a(e,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-3ejjip"&&(Tt.textContent=Ga),Rn=i(e),m(ot.$$.fragment,e),Gn=i(e),ft=a(e,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-qxff8z"&&(ft.textContent=Pa),Pn=i(e),wt=a(e,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-dsskjd"&&(wt.textContent=Qa),Qn=i(e),yt=a(e,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1b2xhzk"&&(yt.textContent=Ea),En=i(e),ut=a(e,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1qi5r7k"&&(ut.innerHTML=Va),Vn=i(e),dt=a(e,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-139kzpn"&&(dt.innerHTML=za),zn=i(e),Jt=a(e,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-1xgk4dc"&&(Jt.innerHTML=Da),Dn=i(e),jt=a(e,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-732b2h"&&(jt.innerHTML=Xa),Xn=i(e),m(Ct.$$.fragment,e),Yn=i(e),bt=a(e,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-52r0w0"&&(bt.innerHTML=Ya),Fn=i(e),ct=a(e,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-i44sg6"&&(ct.innerHTML=Fa),Sn=i(e),m(Ut.$$.fragment,e),qn=i(e),_t=a(e,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-1ro7m6"&&(_t.innerHTML=Sa),On=i(e),m(ht.$$.fragment,e),Kn=i(e),vt=a(e,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-1upzry2"&&(vt.innerHTML=qa),ei=i(e),$t=a(e,"P",{"data-svelte-h":!0}),M($t)!=="svelte-ioapel"&&($t.innerHTML=Oa),ti=i(e),It=a(e,"P",{"data-svelte-h":!0}),M(It)!=="svelte-qurl8h"&&(It.innerHTML=Ka),li=i(e),Lt=a(e,"UL",{"data-svelte-h":!0}),M(Lt)!=="svelte-lkvlpi"&&(Lt.innerHTML=eM),si=i(e),xt=a(e,"P",{"data-svelte-h":!0}),M(xt)!=="svelte-8kt0uv"&&(xt.innerHTML=tM),ni=i(e),m(gt.$$.fragment,e),ii=i(e),kt=a(e,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-gqojja"&&(kt.innerHTML=lM),ri=i(e),m(At.$$.fragment,e),ai=i(e),Ht=a(e,"P",{"data-svelte-h":!0}),M(Ht)!=="svelte-iko2vl"&&(Ht.textContent=sM),Mi=i(e),m(Zt.$$.fragment,e),pi=i(e),Bt=a(e,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-80i36v"&&(Bt.textContent=nM),mi=i(e),m(Nt.$$.fragment,e),Ti=i(e),Wt=a(e,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-m8de15"&&(Wt.textContent=iM),oi=i(e),m(Rt.$$.fragment,e),fi=i(e),Gt=a(e,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-17jn1my"&&(Gt.textContent=rM),wi=i(e),m(Pt.$$.fragment,e),yi=i(e),Qt=a(e,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-ruts9k"&&(Qt.innerHTML=aM),ui=i(e),m(Et.$$.fragment,e),di=i(e),Vt=a(e,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-a0v3m4"&&(Vt.textContent=MM),Ji=i(e),m(zt.$$.fragment,e),ji=i(e),Dt=a(e,"P",{"data-svelte-h":!0}),M(Dt)!=="svelte-r93wkp"&&(Dt.textContent=pM),Ci=i(e),Xt=a(e,"P",{"data-svelte-h":!0}),M(Xt)!=="svelte-c7lvxw"&&(Xt.innerHTML=mM),bi=i(e),Yt=a(e,"P",{"data-svelte-h":!0}),M(Yt)!=="svelte-jat6ur"&&(Yt.innerHTML=TM),ci=i(e),Ft=a(e,"P",{"data-svelte-h":!0}),M(Ft)!=="svelte-wvzniq"&&(Ft.innerHTML=oM),Ui=i(e),m(St.$$.fragment,e),_i=i(e),qt=a(e,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-tr5iwr"&&(qt.innerHTML=fM),hi=i(e),Ot=a(e,"P",{"data-svelte-h":!0}),M(Ot)!=="svelte-1pw4a9s"&&(Ot.innerHTML=wM),vi=i(e),m(Kt.$$.fragment,e),$i=i(e),el=a(e,"P",{"data-svelte-h":!0}),M(el)!=="svelte-3azh5i"&&(el.innerHTML=yM),Ii=i(e),tl=a(e,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-oynb20"&&(tl.innerHTML=uM),Li=i(e),ll=a(e,"UL",{"data-svelte-h":!0}),M(ll)!=="svelte-1pfk7cv"&&(ll.innerHTML=dM),xi=i(e),sl=a(e,"P",{"data-svelte-h":!0}),M(sl)!=="svelte-12gx77v"&&(sl.innerHTML=JM),gi=i(e),nl=a(e,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-1hfzg12"&&(nl.innerHTML=jM),ki=i(e),il=a(e,"P",{"data-svelte-h":!0}),M(il)!=="svelte-fv84w7"&&(il.innerHTML=CM),Ai=i(e),rl=a(e,"P",{"data-svelte-h":!0}),M(rl)!=="svelte-nvu9uf"&&(rl.innerHTML=bM),Hi=i(e),m(al.$$.fragment,e),Zi=i(e),Ml=a(e,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-1v64e8i"&&(Ml.textContent=cM),Bi=i(e),pl=a(e,"UL",{"data-svelte-h":!0}),M(pl)!=="svelte-mg5jfv"&&(pl.innerHTML=UM),Ni=i(e),ml=a(e,"P",{"data-svelte-h":!0}),M(ml)!=="svelte-1k3uhqw"&&(ml.textContent=_M),Wi=i(e),m(Tl.$$.fragment,e),Ri=i(e),m(L.$$.fragment,e),Gi=i(e),ol=a(e,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-1vg7tw5"&&(ol.innerHTML=hM),Pi=i(e),fl=a(e,"UL",{"data-svelte-h":!0}),M(fl)!=="svelte-tll8ox"&&(fl.innerHTML=vM),Qi=i(e),wl=a(e,"P",{"data-svelte-h":!0}),M(wl)!=="svelte-79li0d"&&(wl.innerHTML=$M),Ei=i(e),yl=a(e,"P",{"data-svelte-h":!0}),M(yl)!=="svelte-1trgdzo"&&(yl.innerHTML=IM),Vi=i(e),ul=a(e,"P",{"data-svelte-h":!0}),M(ul)!=="svelte-1ek8hk8"&&(ul.innerHTML=LM),zi=i(e),m(dl.$$.fragment,e),Di=i(e),Jl=a(e,"P",{"data-svelte-h":!0}),M(Jl)!=="svelte-1gvbjoy"&&(Jl.innerHTML=xM),Xi=i(e),m(jl.$$.fragment,e),Yi=i(e),Cl=a(e,"P",{"data-svelte-h":!0}),M(Cl)!=="svelte-912k7y"&&(Cl.innerHTML=gM),Fi=i(e),bl=a(e,"P",{"data-svelte-h":!0}),M(bl)!=="svelte-1bmorqf"&&(bl.innerHTML=kM),Si=i(e),cl=a(e,"P",{"data-svelte-h":!0}),M(cl)!=="svelte-18ui3q7"&&(cl.innerHTML=AM),qi=i(e),Ul=a(e,"P",{"data-svelte-h":!0}),M(Ul)!=="svelte-5wzk6u"&&(Ul.innerHTML=HM),Oi=i(e),_l=a(e,"P",{"data-svelte-h":!0}),M(_l)!=="svelte-1ywn99r"&&(_l.innerHTML=ZM),Ki=i(e),hl=a(e,"P",{"data-svelte-h":!0}),M(hl)!=="svelte-9m8fqg"&&(hl.innerHTML=BM),er=i(e),vl=a(e,"P",{"data-svelte-h":!0}),M(vl)!=="svelte-16kr22c"&&(vl.innerHTML=NM),tr=i(e),$l=a(e,"P",{"data-svelte-h":!0}),M($l)!=="svelte-1x01yxc"&&($l.innerHTML=WM),lr=i(e),Il=a(e,"P",{"data-svelte-h":!0}),M(Il)!=="svelte-u3u2vi"&&(Il.innerHTML=RM),sr=i(e),m(Ll.$$.fragment,e),nr=i(e),xl=a(e,"P",{"data-svelte-h":!0}),M(xl)!=="svelte-1cf1vsg"&&(xl.textContent=GM),ir=i(e),m(gl.$$.fragment,e),rr=i(e),kl=a(e,"P",{"data-svelte-h":!0}),M(kl)!=="svelte-1hqas8u"&&(kl.textContent=PM),ar=i(e),Al=a(e,"P",{"data-svelte-h":!0}),M(Al)!=="svelte-8yx3n3"&&(Al.textContent=QM),Mr=i(e),Hl=a(e,"P",{"data-svelte-h":!0}),M(Hl)!=="svelte-1bwdrg"&&(Hl.textContent=EM),pr=i(e),Zl=a(e,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-gq96oy"&&(Zl.innerHTML=VM),mr=i(e),Bl=a(e,"P",{"data-svelte-h":!0}),M(Bl)!=="svelte-4etmcg"&&(Bl.innerHTML=zM),Tr=i(e),m(Nl.$$.fragment,e),or=i(e),Wl=a(e,"P",{"data-svelte-h":!0}),M(Wl)!=="svelte-tyijoh"&&(Wl.textContent=DM),fr=i(e),Rl=a(e,"P",{"data-svelte-h":!0}),M(Rl)!=="svelte-1359y59"&&(Rl.innerHTML=XM),wr=i(e),Gl=a(e,"P",{"data-svelte-h":!0}),M(Gl)!=="svelte-1h0io99"&&(Gl.innerHTML=YM),yr=i(e),Pl=a(e,"P",{"data-svelte-h":!0}),M(Pl)!=="svelte-1dm7odc"&&(Pl.innerHTML=FM),ur=i(e),Ql=a(e,"P",{"data-svelte-h":!0}),M(Ql)!=="svelte-uaoxgu"&&(Ql.textContent=SM),dr=i(e),m(El.$$.fragment,e),Jr=i(e),Vl=a(e,"P",{"data-svelte-h":!0}),M(Vl)!=="svelte-1u2gh6x"&&(Vl.textContent=qM),jr=i(e),zl=a(e,"P",{"data-svelte-h":!0}),M(zl)!=="svelte-v7naz3"&&(zl.innerHTML=OM),Cr=i(e),Yl=a(e,"P",{}),tp(Yl).forEach(l),this.h()},h(){C(u,"name","hf:doc:metadata"),C(u,"content",yp),ip(Xl.src,Hr="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||C(Xl,"src",Hr),C(U,"start","3"),C(_,"start","4"),C(h,"start","2"),C(v,"start","3"),C($,"start","4"),C(I,"start","5")},m(e,t){mp(document.head,u),s(e,j,t),s(e,d,t),s(e,b,t),T(x,e,t),s(e,Fl,t),s(e,g,t),s(e,Sl,t),T(c,e,t),s(e,ql,t),s(e,k,t),s(e,Ol,t),s(e,A,t),s(e,Kl,t),s(e,H,t),s(e,es,t),s(e,Z,t),s(e,ts,t),s(e,B,t),s(e,ls,t),T(N,e,t),s(e,ss,t),s(e,W,t),s(e,ns,t),s(e,R,t),s(e,is,t),s(e,G,t),s(e,rs,t),s(e,P,t),s(e,as,t),T(Q,e,t),s(e,Ms,t),s(e,E,t),s(e,ps,t),s(e,V,t),s(e,ms,t),s(e,Xl,t),s(e,Ts,t),s(e,z,t),s(e,os,t),T(D,e,t),s(e,fs,t),s(e,X,t),s(e,ws,t),T(Y,e,t),s(e,ys,t),s(e,F,t),s(e,us,t),s(e,S,t),s(e,ds,t),T(q,e,t),s(e,Js,t),s(e,O,t),s(e,js,t),T(K,e,t),s(e,Cs,t),s(e,ee,t),s(e,bs,t),s(e,te,t),s(e,cs,t),s(e,le,t),s(e,Us,t),s(e,se,t),s(e,_s,t),s(e,ne,t),s(e,hs,t),s(e,ie,t),s(e,vs,t),s(e,re,t),s(e,$s,t),s(e,ae,t),s(e,Is,t),T(Me,e,t),s(e,Ls,t),s(e,pe,t),s(e,xs,t),s(e,me,t),s(e,gs,t),s(e,Te,t),s(e,ks,t),T(oe,e,t),s(e,As,t),s(e,fe,t),s(e,Hs,t),T(we,e,t),s(e,Zs,t),T(ye,e,t),s(e,Bs,t),s(e,U,t),s(e,Ns,t),T(ue,e,t),s(e,Ws,t),s(e,de,t),s(e,Rs,t),T(Je,e,t),s(e,Gs,t),s(e,je,t),s(e,Ps,t),T(Ce,e,t),s(e,Qs,t),s(e,_,t),s(e,Es,t),T(be,e,t),s(e,Vs,t),s(e,ce,t),s(e,zs,t),T(Ue,e,t),s(e,Ds,t),s(e,_e,t),s(e,Xs,t),s(e,he,t),s(e,Ys,t),s(e,ve,t),s(e,Fs,t),s(e,$e,t),s(e,Ss,t),s(e,Ie,t),s(e,qs,t),s(e,Le,t),s(e,Os,t),s(e,xe,t),s(e,Ks,t),s(e,ge,t),s(e,en,t),s(e,ke,t),s(e,tn,t),T(Ae,e,t),s(e,ln,t),s(e,He,t),s(e,sn,t),s(e,Ze,t),s(e,nn,t),s(e,Be,t),s(e,rn,t),s(e,Ne,t),s(e,an,t),s(e,We,t),s(e,Mn,t),s(e,Re,t),s(e,pn,t),s(e,Ge,t),s(e,mn,t),s(e,Pe,t),s(e,Tn,t),s(e,Qe,t),s(e,on,t),s(e,Ee,t),s(e,fn,t),s(e,Ve,t),s(e,wn,t),s(e,ze,t),s(e,yn,t),T(De,e,t),s(e,un,t),s(e,Xe,t),s(e,dn,t),s(e,Ye,t),s(e,Jn,t),s(e,Fe,t),s(e,jn,t),T(Se,e,t),s(e,Cn,t),s(e,qe,t),s(e,bn,t),T(Oe,e,t),s(e,cn,t),s(e,Ke,t),s(e,Un,t),s(e,et,t),s(e,_n,t),s(e,tt,t),s(e,hn,t),s(e,lt,t),s(e,vn,t),s(e,st,t),s(e,$n,t),s(e,nt,t),s(e,In,t),s(e,it,t),s(e,Ln,t),s(e,rt,t),s(e,xn,t),T(at,e,t),s(e,gn,t),s(e,h,t),s(e,kn,t),T(Mt,e,t),s(e,An,t),s(e,v,t),s(e,Hn,t),T(pt,e,t),s(e,Zn,t),s(e,$,t),s(e,Bn,t),T(mt,e,t),s(e,Nn,t),s(e,I,t),s(e,Wn,t),s(e,Tt,t),s(e,Rn,t),T(ot,e,t),s(e,Gn,t),s(e,ft,t),s(e,Pn,t),s(e,wt,t),s(e,Qn,t),s(e,yt,t),s(e,En,t),s(e,ut,t),s(e,Vn,t),s(e,dt,t),s(e,zn,t),s(e,Jt,t),s(e,Dn,t),s(e,jt,t),s(e,Xn,t),T(Ct,e,t),s(e,Yn,t),s(e,bt,t),s(e,Fn,t),s(e,ct,t),s(e,Sn,t),T(Ut,e,t),s(e,qn,t),s(e,_t,t),s(e,On,t),T(ht,e,t),s(e,Kn,t),s(e,vt,t),s(e,ei,t),s(e,$t,t),s(e,ti,t),s(e,It,t),s(e,li,t),s(e,Lt,t),s(e,si,t),s(e,xt,t),s(e,ni,t),T(gt,e,t),s(e,ii,t),s(e,kt,t),s(e,ri,t),T(At,e,t),s(e,ai,t),s(e,Ht,t),s(e,Mi,t),T(Zt,e,t),s(e,pi,t),s(e,Bt,t),s(e,mi,t),T(Nt,e,t),s(e,Ti,t),s(e,Wt,t),s(e,oi,t),T(Rt,e,t),s(e,fi,t),s(e,Gt,t),s(e,wi,t),T(Pt,e,t),s(e,yi,t),s(e,Qt,t),s(e,ui,t),T(Et,e,t),s(e,di,t),s(e,Vt,t),s(e,Ji,t),T(zt,e,t),s(e,ji,t),s(e,Dt,t),s(e,Ci,t),s(e,Xt,t),s(e,bi,t),s(e,Yt,t),s(e,ci,t),s(e,Ft,t),s(e,Ui,t),T(St,e,t),s(e,_i,t),s(e,qt,t),s(e,hi,t),s(e,Ot,t),s(e,vi,t),T(Kt,e,t),s(e,$i,t),s(e,el,t),s(e,Ii,t),s(e,tl,t),s(e,Li,t),s(e,ll,t),s(e,xi,t),s(e,sl,t),s(e,gi,t),s(e,nl,t),s(e,ki,t),s(e,il,t),s(e,Ai,t),s(e,rl,t),s(e,Hi,t),T(al,e,t),s(e,Zi,t),s(e,Ml,t),s(e,Bi,t),s(e,pl,t),s(e,Ni,t),s(e,ml,t),s(e,Wi,t),T(Tl,e,t),s(e,Ri,t),T(L,e,t),s(e,Gi,t),s(e,ol,t),s(e,Pi,t),s(e,fl,t),s(e,Qi,t),s(e,wl,t),s(e,Ei,t),s(e,yl,t),s(e,Vi,t),s(e,ul,t),s(e,zi,t),T(dl,e,t),s(e,Di,t),s(e,Jl,t),s(e,Xi,t),T(jl,e,t),s(e,Yi,t),s(e,Cl,t),s(e,Fi,t),s(e,bl,t),s(e,Si,t),s(e,cl,t),s(e,qi,t),s(e,Ul,t),s(e,Oi,t),s(e,_l,t),s(e,Ki,t),s(e,hl,t),s(e,er,t),s(e,vl,t),s(e,tr,t),s(e,$l,t),s(e,lr,t),s(e,Il,t),s(e,sr,t),T(Ll,e,t),s(e,nr,t),s(e,xl,t),s(e,ir,t),T(gl,e,t),s(e,rr,t),s(e,kl,t),s(e,ar,t),s(e,Al,t),s(e,Mr,t),s(e,Hl,t),s(e,pr,t),s(e,Zl,t),s(e,mr,t),s(e,Bl,t),s(e,Tr,t),T(Nl,e,t),s(e,or,t),s(e,Wl,t),s(e,fr,t),s(e,Rl,t),s(e,wr,t),s(e,Gl,t),s(e,yr,t),s(e,Pl,t),s(e,ur,t),s(e,Ql,t),s(e,dr,t),T(El,e,t),s(e,Jr,t),s(e,Vl,t),s(e,jr,t),s(e,zl,t),s(e,Cr,t),s(e,Yl,t),br=!0},p(e,[t]){const KM={};t&2&&(KM.$$scope={dirty:t,ctx:e}),c.$set(KM);const ep={};t&2&&(ep.$$scope={dirty:t,ctx:e}),L.$set(ep)},i(e){br||(o(x.$$.fragment,e),o(c.$$.fragment,e),o(N.$$.fragment,e),o(Q.$$.fragment,e),o(D.$$.fragment,e),o(Y.$$.fragment,e),o(q.$$.fragment,e),o(K.$$.fragment,e),o(Me.$$.fragment,e),o(oe.$$.fragment,e),o(we.$$.fragment,e),o(ye.$$.fragment,e),o(ue.$$.fragment,e),o(Je.$$.fragment,e),o(Ce.$$.fragment,e),o(be.$$.fragment,e),o(Ue.$$.fragment,e),o(Ae.$$.fragment,e),o(De.$$.fragment,e),o(Se.$$.fragment,e),o(Oe.$$.fragment,e),o(at.$$.fragment,e),o(Mt.$$.fragment,e),o(pt.$$.fragment,e),o(mt.$$.fragment,e),o(ot.$$.fragment,e),o(Ct.$$.fragment,e),o(Ut.$$.fragment,e),o(ht.$$.fragment,e),o(gt.$$.fragment,e),o(At.$$.fragment,e),o(Zt.$$.fragment,e),o(Nt.$$.fragment,e),o(Rt.$$.fragment,e),o(Pt.$$.fragment,e),o(Et.$$.fragment,e),o(zt.$$.fragment,e),o(St.$$.fragment,e),o(Kt.$$.fragment,e),o(al.$$.fragment,e),o(Tl.$$.fragment,e),o(L.$$.fragment,e),o(dl.$$.fragment,e),o(jl.$$.fragment,e),o(Ll.$$.fragment,e),o(gl.$$.fragment,e),o(Nl.$$.fragment,e),o(El.$$.fragment,e),br=!0)},o(e){f(x.$$.fragment,e),f(c.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(Y.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(Me.$$.fragment,e),f(oe.$$.fragment,e),f(we.$$.fragment,e),f(ye.$$.fragment,e),f(ue.$$.fragment,e),f(Je.$$.fragment,e),f(Ce.$$.fragment,e),f(be.$$.fragment,e),f(Ue.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(Se.$$.fragment,e),f(Oe.$$.fragment,e),f(at.$$.fragment,e),f(Mt.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ot.$$.fragment,e),f(Ct.$$.fragment,e),f(Ut.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(At.$$.fragment,e),f(Zt.$$.fragment,e),f(Nt.$$.fragment,e),f(Rt.$$.fragment,e),f(Pt.$$.fragment,e),f(Et.$$.fragment,e),f(zt.$$.fragment,e),f(St.$$.fragment,e),f(Kt.$$.fragment,e),f(al.$$.fragment,e),f(Tl.$$.fragment,e),f(L.$$.fragment,e),f(dl.$$.fragment,e),f(jl.$$.fragment,e),f(Ll.$$.fragment,e),f(gl.$$.fragment,e),f(Nl.$$.fragment,e),f(El.$$.fragment,e),br=!1},d(e){e&&(l(j),l(d),l(b),l(Fl),l(g),l(Sl),l(ql),l(k),l(Ol),l(A),l(Kl),l(H),l(es),l(Z),l(ts),l(B),l(ls),l(ss),l(W),l(ns),l(R),l(is),l(G),l(rs),l(P),l(as),l(Ms),l(E),l(ps),l(V),l(ms),l(Xl),l(Ts),l(z),l(os),l(fs),l(X),l(ws),l(ys),l(F),l(us),l(S),l(ds),l(Js),l(O),l(js),l(Cs),l(ee),l(bs),l(te),l(cs),l(le),l(Us),l(se),l(_s),l(ne),l(hs),l(ie),l(vs),l(re),l($s),l(ae),l(Is),l(Ls),l(pe),l(xs),l(me),l(gs),l(Te),l(ks),l(As),l(fe),l(Hs),l(Zs),l(Bs),l(U),l(Ns),l(Ws),l(de),l(Rs),l(Gs),l(je),l(Ps),l(Qs),l(_),l(Es),l(Vs),l(ce),l(zs),l(Ds),l(_e),l(Xs),l(he),l(Ys),l(ve),l(Fs),l($e),l(Ss),l(Ie),l(qs),l(Le),l(Os),l(xe),l(Ks),l(ge),l(en),l(ke),l(tn),l(ln),l(He),l(sn),l(Ze),l(nn),l(Be),l(rn),l(Ne),l(an),l(We),l(Mn),l(Re),l(pn),l(Ge),l(mn),l(Pe),l(Tn),l(Qe),l(on),l(Ee),l(fn),l(Ve),l(wn),l(ze),l(yn),l(un),l(Xe),l(dn),l(Ye),l(Jn),l(Fe),l(jn),l(Cn),l(qe),l(bn),l(cn),l(Ke),l(Un),l(et),l(_n),l(tt),l(hn),l(lt),l(vn),l(st),l($n),l(nt),l(In),l(it),l(Ln),l(rt),l(xn),l(gn),l(h),l(kn),l(An),l(v),l(Hn),l(Zn),l($),l(Bn),l(Nn),l(I),l(Wn),l(Tt),l(Rn),l(Gn),l(ft),l(Pn),l(wt),l(Qn),l(yt),l(En),l(ut),l(Vn),l(dt),l(zn),l(Jt),l(Dn),l(jt),l(Xn),l(Yn),l(bt),l(Fn),l(ct),l(Sn),l(qn),l(_t),l(On),l(Kn),l(vt),l(ei),l($t),l(ti),l(It),l(li),l(Lt),l(si),l(xt),l(ni),l(ii),l(kt),l(ri),l(ai),l(Ht),l(Mi),l(pi),l(Bt),l(mi),l(Ti),l(Wt),l(oi),l(fi),l(Gt),l(wi),l(yi),l(Qt),l(ui),l(di),l(Vt),l(Ji),l(ji),l(Dt),l(Ci),l(Xt),l(bi),l(Yt),l(ci),l(Ft),l(Ui),l(_i),l(qt),l(hi),l(Ot),l(vi),l($i),l(el),l(Ii),l(tl),l(Li),l(ll),l(xi),l(sl),l(gi),l(nl),l(ki),l(il),l(Ai),l(rl),l(Hi),l(Zi),l(Ml),l(Bi),l(pl),l(Ni),l(ml),l(Wi),l(Ri),l(Gi),l(ol),l(Pi),l(fl),l(Qi),l(wl),l(Ei),l(yl),l(Vi),l(ul),l(zi),l(Di),l(Jl),l(Xi),l(Yi),l(Cl),l(Fi),l(bl),l(Si),l(cl),l(qi),l(Ul),l(Oi),l(_l),l(Ki),l(hl),l(er),l(vl),l(tr),l($l),l(lr),l(Il),l(sr),l(nr),l(xl),l(ir),l(rr),l(kl),l(ar),l(Al),l(Mr),l(Hl),l(pr),l(Zl),l(mr),l(Bl),l(Tr),l(or),l(Wl),l(fr),l(Rl),l(wr),l(Gl),l(yr),l(Pl),l(ur),l(Ql),l(dr),l(Jr),l(Vl),l(jr),l(zl),l(Cr),l(Yl)),l(u),w(x,e),w(c,e),w(N,e),w(Q,e),w(D,e),w(Y,e),w(q,e),w(K,e),w(Me,e),w(oe,e),w(we,e),w(ye,e),w(ue,e),w(Je,e),w(Ce,e),w(be,e),w(Ue,e),w(Ae,e),w(De,e),w(Se,e),w(Oe,e),w(at,e),w(Mt,e),w(pt,e),w(mt,e),w(ot,e),w(Ct,e),w(Ut,e),w(ht,e),w(gt,e),w(At,e),w(Zt,e),w(Nt,e),w(Rt,e),w(Pt,e),w(Et,e),w(zt,e),w(St,e),w(Kt,e),w(al,e),w(Tl,e),w(L,e),w(dl,e),w(jl,e),w(Ll,e),w(gl,e),w(Nl,e),w(El,e)}}}const yp='{"title":"How to add a model to 🤗 Transformers?","local":"how-to-add-a-model-to--transformers","sections":[{"title":"General overview of 🤗 Transformers","local":"general-overview-of--transformers","sections":[{"title":"Overview of models","local":"overview-of-models","sections":[],"depth":3},{"title":"Code style","local":"code-style","sections":[],"depth":3},{"title":"Overview of tokenizers","local":"overview-of-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Step-by-step recipe to add a model to 🤗 Transformers","local":"step-by-step-recipe-to-add-a-model-to--transformers","sections":[{"title":"1. (Optional) Theoretical aspects of BrandNewBert","local":"1-optional-theoretical-aspects-of-brandnewbert","sections":[],"depth":3},{"title":"2. Next prepare your environment","local":"2-next-prepare-your-environment","sections":[],"depth":3},{"title":"3.-4. Run a pretrained checkpoint using the original repository","local":"3-4-run-a-pretrained-checkpoint-using-the-original-repository","sections":[],"depth":3},{"title":"5.-14. Port BrandNewBert to 🤗 Transformers","local":"5-14-port-brandnewbert-to--transformers","sections":[],"depth":3},{"title":"Share your work!!","local":"share-your-work","sections":[],"depth":3}],"depth":2}],"depth":1}';function up(Dl){return rp(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Tp}),[]}class cp extends ap{constructor(u){super(),Mp(this,u,up,wp,np,{})}}export{cp as component};
