import{s as St,o as At,n as Pt}from"../chunks/scheduler.56730f09.js";import{S as Kt,i as Dt,g as p,s as a,r as m,A as Ot,h as i,f as l,c as n,j as Yt,u as r,x as o,k as ht,y as el,a as s,v as c,d as g,t as u,w as M}from"../chunks/index.1f144517.js";import{H as y,g as tl}from"../chunks/Heading.8dc0cb83.js";import{T as ll}from"../chunks/Tip.41e845e5.js";import{C as T}from"../chunks/CodeBlock.738eeccb.js";import{D as sl}from"../chunks/DocNotebookDropdown.b2e82107.js";function al(fe){let d,J='기본 LLM 사용에 관심이 있다면, 우리의 <a href="pipeline_tutorial"><code>Pipeline</code></a> 인터페이스로 시작하는 것을 추천합니다. 그러나 LLM은 양자화나 토큰 선택 단계에서의 미세한 제어와 같은 고급 기능들을 종종 필요로 합니다. 이러한 작업은 <code>generate()</code>를 통해 가장 잘 수행될 수 있습니다. LLM을 이용한 자기회귀 생성은 자원을 많이 소모하므로, 적절한 처리량을 위해 GPU에서 실행되어야 합니다.';return{c(){d=p("p"),d.innerHTML=J},l(h){d=i(h,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1ygdj4"&&(d.innerHTML=J)},m(h,he){s(h,d,he)},p:Pt,d(h){h&&l(d)}}}function nl(fe){let d,J,h,he,w,be,U,je,Z,yt="LLM 또는 대규모 언어 모델은 텍스트 생성의 핵심 구성 요소입니다. 간단히 말하면, 주어진 입력 텍스트에 대한 다음 단어(정확하게는 토큰)를 예측하기 위해 훈련된 대규모 사전 훈련 변환기 모델로 구성됩니다. 토큰을 한 번에 하나씩 예측하기 때문에 새로운 문장을 생성하려면 모델을 호출하는 것 외에 더 복잡한 작업을 수행해야 합니다. 즉, 자기회귀 생성을 수행해야 합니다.",Te,$,ft="자기회귀 생성은 몇 개의 초기 입력값을 제공한 후, 그 출력을 다시 모델에 입력으로 사용하여 반복적으로 호출하는 추론 과정입니다. 🤗 Transformers에서는 <code>generate()</code> 메소드가 이 역할을 하며, 이는 생성 기능을 가진 모든 모델에서 사용 가능합니다.",Je,_,bt="이 튜토리얼에서는 다음 내용을 다루게 됩니다:",we,k,jt="<li>LLM으로 텍스트 생성</li> <li>일반적으로 발생하는 문제 해결</li> <li>LLM을 최대한 활용하기 위한 다음 단계</li>",Ue,v,Tt="시작하기 전에 필요한 모든 라이브러리가 설치되어 있는지 확인하세요:",Ze,G,$e,C,_e,I,Jt='<a href="tasks/language_modeling">인과적 언어 모델링(causal language modeling)</a>을 목적으로 학습된 언어 모델은 일련의 텍스트 토큰을 입력으로 사용하고, 그 결과로 다음 토큰이 나올 확률 분포를 제공합니다.',ke,f,wt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;LLM의 전방 패스&quot;</figcaption>',ve,W,Ut="LLM과 자기회귀 생성을 함께 사용할 때 핵심적인 부분은 이 확률 분포로부터 다음 토큰을 어떻게 고를 것인지입니다. 다음 반복 과정에 사용될 토큰을 결정하는 한, 어떠한 방법도 가능합니다. 확률 분포에서 가장 가능성이 높은 토큰을 선택하는 것처럼 간단할 수도 있고, 결과 분포에서 샘플링하기 전에 수십 가지 변환을 적용하는 것처럼 복잡할 수도 있습니다.",Ge,b,Zt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;자기회귀 생성은 확률 분포에서 다음 토큰을 반복적으로 선택하여 텍스트를 생성합니다.&quot;</figcaption>',Ce,V,$t="위에서 설명한 과정은 어떤 종료 조건이 충족될 때까지 반복적으로 수행됩니다. 모델이 시퀀스의 끝(EOS 토큰)을 출력할 때까지를 종료 조건으로 하는 것이 이상적입니다. 그렇지 않은 경우에는 미리 정의된 최대 길이에 도달했을 때 생성이 중단됩니다.",Ie,X,_t="모델이 예상대로 동작하기 위해선 토큰 선택 단계와 정지 조건을 올바르게 설정하는 것이 중요합니다. 이러한 이유로, 각 모델에는 기본 생성 설정이 잘 정의된 <code>GenerationConfig</code> 파일이 함께 제공됩니다.",We,R,kt="코드를 확인해봅시다!",Ve,j,Xe,x,vt="먼저, 모델을 불러오세요.",Re,L,xe,z,Gt="<code>from_pretrained</code> 함수를 호출할 때 2개의 플래그를 주목하세요:",Le,B,Ct='<li><code>device_map</code>은 모델이 GPU로 이동되도록 합니다.</li> <li><code>load_in_4bit</code>는 리소스 요구 사항을 크게 줄이기 위해 <a href="main_classes/quantization">4비트 동적 양자화</a>를 적용합니다.</li>',ze,H,It="이 외에도 모델을 초기화하는 다양한 방법이 있지만, LLM을 처음 시작할 때 이 설정을 추천합니다.",Be,F,Wt='이어서 텍스트 입력을 <a href="tokenizer_summary">토크나이저</a>으로 전처리하세요.',He,Q,Fe,q,Vt="<code>model_inputs</code> 변수에는 토큰화된 텍스트 입력과 함께 어텐션 마스크가 들어 있습니다. <code>generate()</code>는 어텐션 마스크가 제공되지 않았을 경우에도 이를 추론하려고 노력하지만, 최상의 성능을 위해서는 가능하면 어텐션 마스크를 전달하는 것을 권장합니다.",Qe,E,Xt="마지막으로 <code>generate()</code> 메소드를 호출해 생성된 토큰을 얻은 후, 이를 출력하기 전에 텍스트 형태로 변환하세요.",qe,N,Ee,Y,Rt="이게 전부입니다! 몇 줄의 코드만으로 LLM의 능력을 활용할 수 있게 되었습니다.",Ne,S,Ye,A,xt='<a href="generation_strategies">생성 전략</a>이 많고, 기본값이 항상 사용 사례에 적합하지 않을 수 있습니다. 출력이 예상과 다를 때 흔히 발생하는 문제와 이를 해결하는 방법에 대한 목록을 만들었습니다.',Se,P,Ae,K,Pe,D,Lt='<code>GenerationConfig</code> 파일에서 별도로 지정하지 않으면, <code>generate</code>는 기본적으로 최대 20개의 토큰을 반환합니다. <code>generate</code> 호출에서 <code>max_new_tokens</code>을 수동으로 설정하여 반환할 수 있는 새 토큰의 최대 수를 설정하는 것이 좋습니다. LLM(정확하게는 <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">디코더 전용 모델</a>)은 입력 프롬프트도 출력의 일부로 반환합니다.',Ke,O,De,ee,Oe,te,zt='기본적으로 <code>GenerationConfig</code> 파일에서 별도로 지정하지 않으면, <code>generate</code>는 각 반복에서 가장 확률이 높은 토큰을 선택합니다(그리디 디코딩). 하려는 작업에 따라 이 방법은 바람직하지 않을 수 있습니다. 예를 들어, 챗봇이나 에세이 작성과 같은 창의적인 작업은 샘플링이 적합할 수 있습니다. 반면, 오디오를 텍스트로 변환하거나 번역과 같은 입력 기반 작업은 그리디 디코딩이 더 적합할 수 있습니다. <code>do_sample=True</code>로 샘플링을 활성화할 수 있으며, 이 주제에 대한 자세한 내용은 이 <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">블로그 포스트</a>에서 볼 수 있습니다.',et,le,tt,se,lt,ae,Bt='LLM은 <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">디코더 전용</a> 구조를 가지고 있어, 입력 프롬프트에 대해 지속적으로 반복 처리를 합니다. 입력 데이터의 길이가 다르면 패딩 작업이 필요합니다. LLM은 패딩 토큰에서 작동을 이어가도록 설계되지 않았기 때문에, 입력 왼쪽에 패딩이 추가 되어야 합니다. 그리고 어텐션 마스크도 꼭 <code>generate</code> 함수에 전달되어야 합니다!',st,ne,at,pe,nt,ie,Ht="자기회귀 생성 프로세스는 상대적으로 단순한 편이지만, LLM을 최대한 활용하려면 여러 가지 요소를 고려해야 하므로 쉽지 않을 수 있습니다. LLM에 대한 더 깊은 이해와 활용을 위한 다음 단계는 아래와 같습니다:",pt,oe,it,me,Ft='<li><a href="generation_strategies">가이드</a>는 다양한 생성 방법을 제어하는 방법, 생성 설정 파일을 설정하는 방법, 출력을 스트리밍하는 방법에 대해 설명합니다.</li> <li><code>GenerationConfig</code>와 <code>generate()</code>, <a href="internal/generation_utils">generate-related classes</a>를 참조해보세요.</li>',ot,re,mt,ce,Qt='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>는 오픈 소스 모델의 품질에 중점을 둡니다.</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>는 LLM 처리량에 중점을 둡니다.</li>',rt,ge,ct,ue,qt='<li>메모리 요구 사항을 줄이려면, 동적 양자화에 대한 <a href="main_classes/quantization">가이드</a>를 참조하세요.</li>',gt,Me,ut,de,Et='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>는 LLM을 위한 실제 운영 환경에 적합한 서버입니다.</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>은 특정 하드웨어 장치에서 LLM을 최적화하기 위해 🤗 Transformers를 확장한 것입니다.</li>',Mt,ye,dt;return w=new y({props:{title:"대규모 언어 모델로 생성하기",local:"generation-with-llms",headingTag:"h1"}}),U=new sl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/llm_tutorial.ipynb"}]}}),G=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),C=new y({props:{title:"텍스트 생성",local:"generate-text",headingTag:"h2"}}),j=new ll({props:{$$slots:{default:[al]},$$scope:{ctx:fe}}}),L=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmxtLXJlc2VhcmNoJTJGb3Blbl9sbGFtYV83YiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),N=new T({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, black, white, and brown&#x27;</span>`,wrap:!1}}),S=new y({props:{title:"일반적으로 발생하는 문제",local:"common-pitfalls",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBMbGFtYSUyMGhhcyUyMG5vJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new y({props:{title:"생성된 출력이 너무 짧거나 길다",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),O=new T({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),ee=new y({props:{title:"잘못된 생성 모드",local:"incorrect-generation-mode",headingTag:"h3"}}),le=new T({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCgwKSUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJJTIwYW0lMjBhJTIwY2F0LiUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwTExNJTIwJTJCJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjAlM0QlMjByZXBldGl0aXZlJTJDJTIwYm9yaW5nJTIwb3V0cHV0JTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBiZWNvbWVzJTIwbW9yZSUyMGNyZWF0aXZlISUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.\\nI just need to be. I am always.\\nEvery time&#x27;</span>`,wrap:!1}}),se=new y({props:{title:"잘못된 패딩",local:"wrong-padding-side",headingTag:"h3"}}),ne=new T({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscy4lMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMGxlZnQtcGFkZGluZyUyQyUyMGl0JTIwd29ya3MlMjBhcyUyMGV4cGVjdGVkISUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTGxhbWElMjBoYXMlMjBubyUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUyMjElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMCUyMkElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMkMlMjBFJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),pe=new y({props:{title:"추가 자료",local:"further-resources",headingTag:"h2"}}),oe=new y({props:{title:"고급 생성 사용",local:"advanced-generate-usage",headingTag:"h3"}}),re=new y({props:{title:"LLM 리더보드",local:"llm-leaderboards",headingTag:"h3"}}),ge=new y({props:{title:"지연 시간 및 처리량",local:"latency-and-throughput",headingTag:"h3"}}),Me=new y({props:{title:"관련 라이브러리",local:"related-libraries",headingTag:"h3"}}),{c(){d=p("meta"),J=a(),h=p("p"),he=a(),m(w.$$.fragment),be=a(),m(U.$$.fragment),je=a(),Z=p("p"),Z.textContent=yt,Te=a(),$=p("p"),$.innerHTML=ft,Je=a(),_=p("p"),_.textContent=bt,we=a(),k=p("ul"),k.innerHTML=jt,Ue=a(),v=p("p"),v.textContent=Tt,Ze=a(),m(G.$$.fragment),$e=a(),m(C.$$.fragment),_e=a(),I=p("p"),I.innerHTML=Jt,ke=a(),f=p("figure"),f.innerHTML=wt,ve=a(),W=p("p"),W.textContent=Ut,Ge=a(),b=p("figure"),b.innerHTML=Zt,Ce=a(),V=p("p"),V.textContent=$t,Ie=a(),X=p("p"),X.innerHTML=_t,We=a(),R=p("p"),R.textContent=kt,Ve=a(),m(j.$$.fragment),Xe=a(),x=p("p"),x.textContent=vt,Re=a(),m(L.$$.fragment),xe=a(),z=p("p"),z.innerHTML=Gt,Le=a(),B=p("ul"),B.innerHTML=Ct,ze=a(),H=p("p"),H.textContent=It,Be=a(),F=p("p"),F.innerHTML=Wt,He=a(),m(Q.$$.fragment),Fe=a(),q=p("p"),q.innerHTML=Vt,Qe=a(),E=p("p"),E.innerHTML=Xt,qe=a(),m(N.$$.fragment),Ee=a(),Y=p("p"),Y.textContent=Rt,Ne=a(),m(S.$$.fragment),Ye=a(),A=p("p"),A.innerHTML=xt,Se=a(),m(P.$$.fragment),Ae=a(),m(K.$$.fragment),Pe=a(),D=p("p"),D.innerHTML=Lt,Ke=a(),m(O.$$.fragment),De=a(),m(ee.$$.fragment),Oe=a(),te=p("p"),te.innerHTML=zt,et=a(),m(le.$$.fragment),tt=a(),m(se.$$.fragment),lt=a(),ae=p("p"),ae.innerHTML=Bt,st=a(),m(ne.$$.fragment),at=a(),m(pe.$$.fragment),nt=a(),ie=p("p"),ie.textContent=Ht,pt=a(),m(oe.$$.fragment),it=a(),me=p("ol"),me.innerHTML=Ft,ot=a(),m(re.$$.fragment),mt=a(),ce=p("ol"),ce.innerHTML=Qt,rt=a(),m(ge.$$.fragment),ct=a(),ue=p("ol"),ue.innerHTML=qt,gt=a(),m(Me.$$.fragment),ut=a(),de=p("ol"),de.innerHTML=Et,Mt=a(),ye=p("p"),this.h()},l(e){const t=Ot("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),h=i(e,"P",{}),Yt(h).forEach(l),he=n(e),r(w.$$.fragment,e),be=n(e),r(U.$$.fragment,e),je=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1mqsb83"&&(Z.textContent=yt),Te=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-pz4xfn"&&($.innerHTML=ft),Je=n(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-bstddc"&&(_.textContent=bt),we=n(e),k=i(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-n39m57"&&(k.innerHTML=jt),Ue=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-18iigii"&&(v.textContent=Tt),Ze=n(e),r(G.$$.fragment,e),$e=n(e),r(C.$$.fragment,e),_e=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1knuq7u"&&(I.innerHTML=Jt),ke=n(e),f=i(e,"FIGURE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1e5pfoq"&&(f.innerHTML=wt),ve=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1paz2ao"&&(W.textContent=Ut),Ge=n(e),b=i(e,"FIGURE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-e8zgh"&&(b.innerHTML=Zt),Ce=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1jyajpb"&&(V.textContent=$t),Ie=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1mz5903"&&(X.innerHTML=_t),We=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-139gs6l"&&(R.textContent=kt),Ve=n(e),r(j.$$.fragment,e),Xe=n(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1jlhxga"&&(x.textContent=vt),Re=n(e),r(L.$$.fragment,e),xe=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-3pz7gp"&&(z.innerHTML=Gt),Le=n(e),B=i(e,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1b3d22e"&&(B.innerHTML=Ct),ze=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-r6qxit"&&(H.textContent=It),Be=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-y9vwcs"&&(F.innerHTML=Wt),He=n(e),r(Q.$$.fragment,e),Fe=n(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-128stuf"&&(q.innerHTML=Vt),Qe=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-t9jh1g"&&(E.innerHTML=Xt),qe=n(e),r(N.$$.fragment,e),Ee=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-uhj5p6"&&(Y.textContent=Rt),Ne=n(e),r(S.$$.fragment,e),Ye=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1efv58y"&&(A.innerHTML=xt),Se=n(e),r(P.$$.fragment,e),Ae=n(e),r(K.$$.fragment,e),Pe=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-sc73j"&&(D.innerHTML=Lt),Ke=n(e),r(O.$$.fragment,e),De=n(e),r(ee.$$.fragment,e),Oe=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-j4osa7"&&(te.innerHTML=zt),et=n(e),r(le.$$.fragment,e),tt=n(e),r(se.$$.fragment,e),lt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1xvggc8"&&(ae.innerHTML=Bt),st=n(e),r(ne.$$.fragment,e),at=n(e),r(pe.$$.fragment,e),nt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1gtwjq2"&&(ie.textContent=Ht),pt=n(e),r(oe.$$.fragment,e),it=n(e),me=i(e,"OL",{"data-svelte-h":!0}),o(me)!=="svelte-5tvhf0"&&(me.innerHTML=Ft),ot=n(e),r(re.$$.fragment,e),mt=n(e),ce=i(e,"OL",{"data-svelte-h":!0}),o(ce)!=="svelte-hea1r2"&&(ce.innerHTML=Qt),rt=n(e),r(ge.$$.fragment,e),ct=n(e),ue=i(e,"OL",{"data-svelte-h":!0}),o(ue)!=="svelte-9s5g32"&&(ue.innerHTML=qt),gt=n(e),r(Me.$$.fragment,e),ut=n(e),de=i(e,"OL",{"data-svelte-h":!0}),o(de)!=="svelte-st1yc"&&(de.innerHTML=Et),Mt=n(e),ye=i(e,"P",{}),Yt(ye).forEach(l),this.h()},h(){ht(d,"name","hf:doc:metadata"),ht(d,"content",pl),ht(f,"class","image table text-center m-0 w-full"),ht(b,"class","image table text-center m-0 w-full")},m(e,t){el(document.head,d),s(e,J,t),s(e,h,t),s(e,he,t),c(w,e,t),s(e,be,t),c(U,e,t),s(e,je,t),s(e,Z,t),s(e,Te,t),s(e,$,t),s(e,Je,t),s(e,_,t),s(e,we,t),s(e,k,t),s(e,Ue,t),s(e,v,t),s(e,Ze,t),c(G,e,t),s(e,$e,t),c(C,e,t),s(e,_e,t),s(e,I,t),s(e,ke,t),s(e,f,t),s(e,ve,t),s(e,W,t),s(e,Ge,t),s(e,b,t),s(e,Ce,t),s(e,V,t),s(e,Ie,t),s(e,X,t),s(e,We,t),s(e,R,t),s(e,Ve,t),c(j,e,t),s(e,Xe,t),s(e,x,t),s(e,Re,t),c(L,e,t),s(e,xe,t),s(e,z,t),s(e,Le,t),s(e,B,t),s(e,ze,t),s(e,H,t),s(e,Be,t),s(e,F,t),s(e,He,t),c(Q,e,t),s(e,Fe,t),s(e,q,t),s(e,Qe,t),s(e,E,t),s(e,qe,t),c(N,e,t),s(e,Ee,t),s(e,Y,t),s(e,Ne,t),c(S,e,t),s(e,Ye,t),s(e,A,t),s(e,Se,t),c(P,e,t),s(e,Ae,t),c(K,e,t),s(e,Pe,t),s(e,D,t),s(e,Ke,t),c(O,e,t),s(e,De,t),c(ee,e,t),s(e,Oe,t),s(e,te,t),s(e,et,t),c(le,e,t),s(e,tt,t),c(se,e,t),s(e,lt,t),s(e,ae,t),s(e,st,t),c(ne,e,t),s(e,at,t),c(pe,e,t),s(e,nt,t),s(e,ie,t),s(e,pt,t),c(oe,e,t),s(e,it,t),s(e,me,t),s(e,ot,t),c(re,e,t),s(e,mt,t),s(e,ce,t),s(e,rt,t),c(ge,e,t),s(e,ct,t),s(e,ue,t),s(e,gt,t),c(Me,e,t),s(e,ut,t),s(e,de,t),s(e,Mt,t),s(e,ye,t),dt=!0},p(e,[t]){const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),j.$set(Nt)},i(e){dt||(g(w.$$.fragment,e),g(U.$$.fragment,e),g(G.$$.fragment,e),g(C.$$.fragment,e),g(j.$$.fragment,e),g(L.$$.fragment,e),g(Q.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(P.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(se.$$.fragment,e),g(ne.$$.fragment,e),g(pe.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ge.$$.fragment,e),g(Me.$$.fragment,e),dt=!0)},o(e){u(w.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(C.$$.fragment,e),u(j.$$.fragment,e),u(L.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ge.$$.fragment,e),u(Me.$$.fragment,e),dt=!1},d(e){e&&(l(J),l(h),l(he),l(be),l(je),l(Z),l(Te),l($),l(Je),l(_),l(we),l(k),l(Ue),l(v),l(Ze),l($e),l(_e),l(I),l(ke),l(f),l(ve),l(W),l(Ge),l(b),l(Ce),l(V),l(Ie),l(X),l(We),l(R),l(Ve),l(Xe),l(x),l(Re),l(xe),l(z),l(Le),l(B),l(ze),l(H),l(Be),l(F),l(He),l(Fe),l(q),l(Qe),l(E),l(qe),l(Ee),l(Y),l(Ne),l(Ye),l(A),l(Se),l(Ae),l(Pe),l(D),l(Ke),l(De),l(Oe),l(te),l(et),l(tt),l(lt),l(ae),l(st),l(at),l(nt),l(ie),l(pt),l(it),l(me),l(ot),l(mt),l(ce),l(rt),l(ct),l(ue),l(gt),l(ut),l(de),l(Mt),l(ye)),l(d),M(w,e),M(U,e),M(G,e),M(C,e),M(j,e),M(L,e),M(Q,e),M(N,e),M(S,e),M(P,e),M(K,e),M(O,e),M(ee,e),M(le,e),M(se,e),M(ne,e),M(pe,e),M(oe,e),M(re,e),M(ge,e),M(Me,e)}}}const pl='{"title":"대규모 언어 모델로 생성하기","local":"generation-with-llms","sections":[{"title":"텍스트 생성","local":"generate-text","sections":[],"depth":2},{"title":"일반적으로 발생하는 문제","local":"common-pitfalls","sections":[{"title":"생성된 출력이 너무 짧거나 길다","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"잘못된 생성 모드","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"잘못된 패딩","local":"wrong-padding-side","sections":[],"depth":3}],"depth":2},{"title":"추가 자료","local":"further-resources","sections":[{"title":"고급 생성 사용","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM 리더보드","local":"llm-leaderboards","sections":[],"depth":3},{"title":"지연 시간 및 처리량","local":"latency-and-throughput","sections":[],"depth":3},{"title":"관련 라이브러리","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function il(fe){return At(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=tl}),[]}class Ml extends Kt{constructor(d){super(),Dt(this,d,il,nl,St,{})}}export{Ml as component};
