import{s as Ss,n as As,o as Ps}from"../chunks/scheduler.56730f09.js";import{S as Ds,i as Ls,g as p,s as a,r as c,A as Ks,h as o,f as l,c as n,j as Vs,u as r,x as i,k as $s,y as Os,a as e,v as m,d as g,t as h,w as u}from"../chunks/index.1f144517.js";import{H as Cs,g as st}from"../chunks/Heading.8dc0cb83.js";import{C as M}from"../chunks/CodeBlock.738eeccb.js";import{D as tt}from"../chunks/DocNotebookDropdown.b2e82107.js";function lt(vs){let j,A,V,P,y,D,d,L,x,Zs="제로샷(zero-shot) 이미지 분류는 특정 카테고리의 예시가 포함된 데이터를 학습되지 않은 모델을 사용해 이미지 분류를 수행하는 작업입니다.",K,w,ks=`일반적으로 이미지 분류를 위해서는 레이블이 달린 특정 이미지 데이터로 모델 학습이 필요하며, 이 모델은 특정 이미지의 특징을 레이블에 “매핑”하는 방법을 학습합니다.
새로운 레이블이 있는 분류 작업에 이러한 모델을 사용해야 하는 경우에는, 모델을 “재보정”하기 위해 미세 조정이 필요합니다.`,O,J,_s=`이와 대조적으로, 제로샷 또는 개방형 어휘(open vocabulary) 이미지 분류 모델은 일반적으로 대규모 이미지 데이터와 해당 설명에 대해 학습된 멀티모달(multimodal) 모델입니다.
이러한 모델은 제로샷 이미지 분류를 포함한 많은 다운스트림 작업에 사용할 수 있는 정렬된(aligned) 비전 언어 표현을 학습합니다.`,ss,T,Rs=`이는 이미지 분류에 대한 보다 유연한 접근 방식으로, 추가 학습 데이터 없이 새로운 레이블이나 학습하지 못한 카테고리에 대해 모델을 일반화할 수 있습니다.
또한, 사용자가 대상 개체에 대한 자유 형식의 텍스트 설명으로 이미지를 검색할 수 있습니다.`,ts,U,zs="이번 가이드에서 배울 내용은 다음과 같습니다:",ls,$,Gs="<li>제로샷 이미지 분류 파이프라인 만들기</li> <li>직접 제로샷 이미지 분류 모델 추론 실행하기</li>",es,C,Is="시작하기 전에 필요한 라이브러리가 모두 설치되어 있는지 확인하세요:",as,v,ns,Z,ps,k,Ws=`<code>pipeline()</code>을 활용하면 가장 간단하게 제로샷 이미지 분류를 지원하는 모델로 추론해볼 수 있습니다.
<a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">Hugging Face Hub에 업로드된 체크포인트</a>에서 파이프라인을 인스턴스화합니다.`,os,_,is,R,Es="다음으로, 분류하고 싶은 이미지를 선택하세요.",cs,z,rs,f,Bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/owl.jpg" alt="Photo of an owl"/>',ms,G,Hs=`이미지와 해당 이미지의 후보 레이블인 <code>candidate_labels</code>를 파이프라인으로 전달합니다.
여기서는 이미지를 직접 전달하지만, 컴퓨터에 저장된 이미지의 경로나 url로 전달할 수도 있습니다.
<code>candidate_labels</code>는 이 예시처럼 간단한 단어일 수도 있고 좀 더 설명적인 단어일 수도 있습니다.`,gs,I,hs,W,us,E,Ys="이제 제로샷 이미지 분류 파이프라인 사용 방법을 살펴보았으니, 실행하는 방법을 살펴보겠습니다.",js,B,Ns=`<a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">Hugging Face Hub에 업로드된 체크포인트</a>에서 모델과 프로세서를 가져오는 것으로 시작합니다.
여기서는 이전과 동일한 체크포인트를 사용하겠습니다:`,fs,H,bs,Y,qs="다른 이미지를 사용해 보겠습니다.",Ms,N,ys,b,Fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/car.jpg" alt="Photo of a car"/>',ds,q,Qs=`프로세서를 사용해 모델의 입력을 준비합니다.
프로세서는 모델의 입력으로 사용하기 위해 이미지 크기를 변환하고 정규화하는 이미지 프로세서와 텍스트 입력을 처리하는 토크나이저로 구성됩니다.`,xs,F,ws,Q,Xs="모델에 입력을 전달하고, 결과를 후처리합니다:",Js,X,Ts,S,Us;return y=new Cs({props:{title:"제로샷(zero-shot) 이미지 분류",local:"zeroshot-image-classification",headingTag:"h1"}}),d=new tt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/zero_shot_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/zero_shot_image_classification.ipynb"}]}}),v=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),Z=new Cs({props:{title:"제로샷(zero-shot) 이미지 분류 파이프라인",local:"zeroshot-image-classification-pipeline",headingTag:"h2"}}),_=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-image-classification&quot;</span>)`,wrap:!1}}),z=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRmc4b1M4LTgyRHhJJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4MGIzQnBZM3g4U25Cbk5rdHBaR3d0U0d0OGZIeDhmREo4ZkRFMk56Z3hNRFl3T0RjJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/g8oS8-82DxI/download?ixid=MnwxMjA3fDB8MXx0b3BpY3x8SnBnNktpZGwtSGt8fHx8fDJ8fDE2NzgxMDYwODc&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),I=new M({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBjbGFzc2lmaWVyKGltYWdlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRCU1QiUyMmZveCUyMiUyQyUyMCUyMmJlYXIlMjIlMkMlMjAlMjJzZWFndWxsJTIyJTJDJTIwJTIyb3dsJTIyJTVEKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = classifier(image, candidate_labels=[<span class="hljs-string">&quot;fox&quot;</span>, <span class="hljs-string">&quot;bear&quot;</span>, <span class="hljs-string">&quot;seagull&quot;</span>, <span class="hljs-string">&quot;owl&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996670484542847</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;owl&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.000199399160919711</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;seagull&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">7.392891711788252e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fox&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">5.96074532950297e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bear&#x27;</span>}]`,wrap:!1}}),W=new Cs({props:{title:"직접 제로샷(zero-shot) 이미지 분류하기",local:"zeroshot-image-classification-by-hand",headingTag:"h2"}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),N=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRnhCUlFmUjJicU5JJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4aGJHeDhmSHg4Zkh4OGZId3hOamM0TXpnNE9ERXglMjZmb3JjZSUzRHRydWUlMjZ3JTNENjQwJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/xBRQfR2bqNI/download?ixid=MnwxMjA3fDB8MXxhbGx8fHx8fHx8fHwxNjc4Mzg4ODEx&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),F=new M({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMnRyZWUlMjIlMkMlMjAlMjJjYXIlMjIlMkMlMjAlMjJiaWtlJTIyJTJDJTIwJTIyY2F0JTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRGNhbmRpZGF0ZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;tree&quot;</span>, <span class="hljs-string">&quot;car&quot;</span>, <span class="hljs-string">&quot;bike&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=candidate_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSU1QjAlNUQlMEFwcm9icyUyMCUzRCUyMGxvZ2l0cy5zb2Z0bWF4KGRpbSUzRC0xKS5udW1weSgpJTBBc2NvcmVzJTIwJTNEJTIwcHJvYnMudG9saXN0KCklMEElMEFyZXN1bHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMHNjb3JlJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBjYW5kaWRhdGVfbGFiZWwlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBzY29yZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbCUyMGluJTIwc29ydGVkKHppcChwcm9icyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMC14JTVCMCU1RCklMEElNUQlMEElMEFyZXN1bHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits_per_image[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits.softmax(dim=-<span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>scores = probs.tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span>result = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;label&quot;</span>: candidate_label}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, candidate_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(<span class="hljs-built_in">zip</span>(probs, candidate_labels), key=<span class="hljs-keyword">lambda</span> x: -x[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>result
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998572</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0010570387</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bike&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0003393686</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tree&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">3.1572064e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}]`,wrap:!1}}),{c(){j=p("meta"),A=a(),V=p("p"),P=a(),c(y.$$.fragment),D=a(),c(d.$$.fragment),L=a(),x=p("p"),x.textContent=Zs,K=a(),w=p("p"),w.textContent=ks,O=a(),J=p("p"),J.textContent=_s,ss=a(),T=p("p"),T.textContent=Rs,ts=a(),U=p("p"),U.textContent=zs,ls=a(),$=p("ul"),$.innerHTML=Gs,es=a(),C=p("p"),C.textContent=Is,as=a(),c(v.$$.fragment),ns=a(),c(Z.$$.fragment),ps=a(),k=p("p"),k.innerHTML=Ws,os=a(),c(_.$$.fragment),is=a(),R=p("p"),R.textContent=Es,cs=a(),c(z.$$.fragment),rs=a(),f=p("div"),f.innerHTML=Bs,ms=a(),G=p("p"),G.innerHTML=Hs,gs=a(),c(I.$$.fragment),hs=a(),c(W.$$.fragment),us=a(),E=p("p"),E.textContent=Ys,js=a(),B=p("p"),B.innerHTML=Ns,fs=a(),c(H.$$.fragment),bs=a(),Y=p("p"),Y.textContent=qs,Ms=a(),c(N.$$.fragment),ys=a(),b=p("div"),b.innerHTML=Fs,ds=a(),q=p("p"),q.textContent=Qs,xs=a(),c(F.$$.fragment),ws=a(),Q=p("p"),Q.textContent=Xs,Js=a(),c(X.$$.fragment),Ts=a(),S=p("p"),this.h()},l(s){const t=Ks("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),A=n(s),V=o(s,"P",{}),Vs(V).forEach(l),P=n(s),r(y.$$.fragment,s),D=n(s),r(d.$$.fragment,s),L=n(s),x=o(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1ohgv1c"&&(x.textContent=Zs),K=n(s),w=o(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-w8qz18"&&(w.textContent=ks),O=n(s),J=o(s,"P",{"data-svelte-h":!0}),i(J)!=="svelte-o87ayh"&&(J.textContent=_s),ss=n(s),T=o(s,"P",{"data-svelte-h":!0}),i(T)!=="svelte-ryenqj"&&(T.textContent=Rs),ts=n(s),U=o(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-pdyjx9"&&(U.textContent=zs),ls=n(s),$=o(s,"UL",{"data-svelte-h":!0}),i($)!=="svelte-1nsu74x"&&($.innerHTML=Gs),es=n(s),C=o(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1k0z9pm"&&(C.textContent=Is),as=n(s),r(v.$$.fragment,s),ns=n(s),r(Z.$$.fragment,s),ps=n(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-jljpqr"&&(k.innerHTML=Ws),os=n(s),r(_.$$.fragment,s),is=n(s),R=o(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-tza26b"&&(R.textContent=Es),cs=n(s),r(z.$$.fragment,s),rs=n(s),f=o(s,"DIV",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-10yxso1"&&(f.innerHTML=Bs),ms=n(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1vlt2d5"&&(G.innerHTML=Hs),gs=n(s),r(I.$$.fragment,s),hs=n(s),r(W.$$.fragment,s),us=n(s),E=o(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-chmorg"&&(E.textContent=Ys),js=n(s),B=o(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1to009q"&&(B.innerHTML=Ns),fs=n(s),r(H.$$.fragment,s),bs=n(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-qe32ys"&&(Y.textContent=qs),Ms=n(s),r(N.$$.fragment,s),ys=n(s),b=o(s,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-1kfxibh"&&(b.innerHTML=Fs),ds=n(s),q=o(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-sjszr1"&&(q.textContent=Qs),xs=n(s),r(F.$$.fragment,s),ws=n(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-11wh2d9"&&(Q.textContent=Xs),Js=n(s),r(X.$$.fragment,s),Ts=n(s),S=o(s,"P",{}),Vs(S).forEach(l),this.h()},h(){$s(j,"name","hf:doc:metadata"),$s(j,"content",et),$s(f,"class","flex justify-center"),$s(b,"class","flex justify-center")},m(s,t){Os(document.head,j),e(s,A,t),e(s,V,t),e(s,P,t),m(y,s,t),e(s,D,t),m(d,s,t),e(s,L,t),e(s,x,t),e(s,K,t),e(s,w,t),e(s,O,t),e(s,J,t),e(s,ss,t),e(s,T,t),e(s,ts,t),e(s,U,t),e(s,ls,t),e(s,$,t),e(s,es,t),e(s,C,t),e(s,as,t),m(v,s,t),e(s,ns,t),m(Z,s,t),e(s,ps,t),e(s,k,t),e(s,os,t),m(_,s,t),e(s,is,t),e(s,R,t),e(s,cs,t),m(z,s,t),e(s,rs,t),e(s,f,t),e(s,ms,t),e(s,G,t),e(s,gs,t),m(I,s,t),e(s,hs,t),m(W,s,t),e(s,us,t),e(s,E,t),e(s,js,t),e(s,B,t),e(s,fs,t),m(H,s,t),e(s,bs,t),e(s,Y,t),e(s,Ms,t),m(N,s,t),e(s,ys,t),e(s,b,t),e(s,ds,t),e(s,q,t),e(s,xs,t),m(F,s,t),e(s,ws,t),e(s,Q,t),e(s,Js,t),m(X,s,t),e(s,Ts,t),e(s,S,t),Us=!0},p:As,i(s){Us||(g(y.$$.fragment,s),g(d.$$.fragment,s),g(v.$$.fragment,s),g(Z.$$.fragment,s),g(_.$$.fragment,s),g(z.$$.fragment,s),g(I.$$.fragment,s),g(W.$$.fragment,s),g(H.$$.fragment,s),g(N.$$.fragment,s),g(F.$$.fragment,s),g(X.$$.fragment,s),Us=!0)},o(s){h(y.$$.fragment,s),h(d.$$.fragment,s),h(v.$$.fragment,s),h(Z.$$.fragment,s),h(_.$$.fragment,s),h(z.$$.fragment,s),h(I.$$.fragment,s),h(W.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(F.$$.fragment,s),h(X.$$.fragment,s),Us=!1},d(s){s&&(l(A),l(V),l(P),l(D),l(L),l(x),l(K),l(w),l(O),l(J),l(ss),l(T),l(ts),l(U),l(ls),l($),l(es),l(C),l(as),l(ns),l(ps),l(k),l(os),l(is),l(R),l(cs),l(rs),l(f),l(ms),l(G),l(gs),l(hs),l(us),l(E),l(js),l(B),l(fs),l(bs),l(Y),l(Ms),l(ys),l(b),l(ds),l(q),l(xs),l(ws),l(Q),l(Js),l(Ts),l(S)),l(j),u(y,s),u(d,s),u(v,s),u(Z,s),u(_,s),u(z,s),u(I,s),u(W,s),u(H,s),u(N,s),u(F,s),u(X,s)}}}const et='{"title":"제로샷(zero-shot) 이미지 분류","local":"zeroshot-image-classification","sections":[{"title":"제로샷(zero-shot) 이미지 분류 파이프라인","local":"zeroshot-image-classification-pipeline","sections":[],"depth":2},{"title":"직접 제로샷(zero-shot) 이미지 분류하기","local":"zeroshot-image-classification-by-hand","sections":[],"depth":2}],"depth":1}';function at(vs){return Ps(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=st}),[]}class rt extends Ds{constructor(j){super(),Ls(this,j,at,lt,Ss,{})}}export{rt as component};
