import{s as Te,n as Je,o as ce}from"../chunks/scheduler.56730f09.js";import{S as Me,i as ue,g as o,s as n,r as i,A as fe,h as r,f as t,c as a,j as ie,u as m,x as p,k as me,y as Ue,a as s,v as T,d as J,t as c,w as M}from"../chunks/index.1f144517.js";import{H as el,g as de}from"../chunks/Heading.8dc0cb83.js";import{C as f}from"../chunks/CodeBlock.738eeccb.js";import{D as we}from"../chunks/DocNotebookDropdown.b2e82107.js";function ye(vl){let u,tl,K,sl,U,nl,d,al,w,Al='XLA(Accelerated Linear Algebra)는 TensorFlow 모델의 실행 시간을 가속화하기 위한 컴파일러입니다. <a href="https://www.tensorflow.org/xla" rel="nofollow">공식 문서</a>에 따르면 다음과 같습니다:',ol,y,zl="XLA(Accelerated Linear Algebra)는 선형 대수를 위한 도메인 특화 컴파일러로, TensorFlow 모델을 소스 코드 변경 없이 가속화할 수 있습니다.",rl,b,Ll='TensorFlow에서 XLA를 사용하는 것은 간단합니다. XLA는 <code>tensorflow</code> 라이브러리 내에 패키지로 제공되며, <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>과 같은 그래프 생성 함수에서 <code>jit_compile</code> 인수를 사용하여 활성화할 수 있습니다. <code>fit()</code> 및 <code>predict()</code>와 같은 Keras 메소드를 사용하는 경우, <code>jit_compile</code> 인수를 <code>model.compile()</code>에 전달하여 XLA를 간단하게 활성화할 수 있습니다. 그러나 XLA는 이러한 메소드에 국한되지 않고 임의의 <code>tf.function</code>을 가속화하는 데에도 사용할 수 있습니다.',pl,h,Hl='🤗 Transformers에서는 <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>, <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>와 같은 모델의 텍스트 생성, 그리고 <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>와 같은 모델의 음성 처리를 포함하여 여러 TensorFlow 메소드가 XLA와 호환되도록 다시 작성되었습니다.',il,g,Dl="정확한 속도 향상은 모델에 따라 다르지만, 🤗 Transformers 내의 TensorFlow 텍스트 생성 모델의 경우 최대 100배의 속도 향상을 확인했습니다. 이 문서에서는 이러한 모델에 대해 XLA를 사용하여 최대 성능을 얻는 방법을 설명합니다. 또한 XLA 통합의 벤치마크 및 디자인 철학에 대한 추가 자료 링크도 제공할 것입니다.",ml,j,Tl,k,Nl="TensorFlow에서 다음과 같은 모델을 고려해 봅시다:",Jl,R,cl,_,Yl="위 모델은 차원이 <code>(10, )</code>인 입력을 받습니다. 다음과 같이 모델을 사용하여 순전파를 실행할 수 있습니다:",Ml,Z,ul,V,ql="XLA로 컴파일된 함수로 순전파를 실행하려면 다음과 같이 해야 합니다:",fl,I,Ul,C,Ol="<code>model</code>의 기본 <code>call()</code> 함수는 XLA 그래프를 컴파일하는 데 사용됩니다. 그러나 다른 모델 함수를 XLA로 컴파일하려면 다음과 같이 할 수도 있습니다:",dl,X,wl,Q,yl,G,Sl="🤗 Transformers에서 XLA로 가속화된 생성을 활성화하려면 최신 버전의 <code>transformers</code>가 설치되어 있어야 합니다. 다음과 같이 설치할 수 있습니다:",bl,$,hl,B,Pl="그리고 다음 코드를 실행할 수 있습니다:",gl,W,jl,E,Kl="알 수 있듯이, <code>generate()</code>에서 XLA를 활성화하는 것은 단 한 줄의 코드입니다. 코드의 나머지 부분은 변경되지 않습니다. 그러나 위 코드 스니펫에서는 XLA에 특정한 몇 가지 주의할 점이 있습니다. XLA가 가져다줄 속도 향상을 실현하기 위해서는 이를 알고 있어야 합니다. 다음 섹션에서 이에 대해 논의합니다.",kl,x,Rl,F,le='XLA 활성화 함수(<code>xla_generate()</code>와 같은)를 처음 실행할 때 내부적으로 계산 그래프를 추론하려고 하며, 이는 시간이 소요됩니다. 이 과정은 <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“추적(tracing)”</a>이라고 알려져 있습니다.',_l,v,ee="생성 시간이 빠르지 않다는 것을 알 수 있을 것입니다. <code>xla_generate()</code>(또는 다른 XLA 활성화 함수)의 연속 호출은 함수에 전달된 입력이 초기에 구축된 계산 그래프와 동일한 형태를 따른다면, 계산 그래프를 추론할 필요가 없습니다. 이는 입력 형태가 고정된 모달리티(예: 이미지)에는 문제가 되지 않지만, 가변 입력 형태 모달리티(예: 텍스트)를 사용할 때 주의해야 합니다.",Zl,A,te="<code>xla_generate()</code>가 항상 동일한 입력 형태로 동작하도록 하려면, 토크나이저를 호출할 때 <code>padding</code> 인수를 지정할 수 있습니다.",Vl,z,Il,L,se="이렇게 하면 <code>xla_generate()</code>에 대한 입력이 항상 추적된 형태로 전달되어 생성 시간이 가속화됩니다. 다음 코드로 이를 확인할 수 있습니다:",Cl,H,Xl,D,ne="Tesla T4 GPU에서는 다음과 같은 출력을 예상할 수 있습니다:",Ql,N,Gl,Y,ae="<code>xla_generate()</code>의 첫 번째 호출은 추적 때문에 시간이 오래 걸리지만, 연속 호출은 몇 배나 빠릅니다. 생성 옵션에 대한 어떤 변경이든 다시 추적을 유발하므로 생성 시간이 느려질 수 있음을 명심하세요.",$l,q,oe="이 문서에서는 🤗 Transformers에서 제공하는 모든 텍스트 생성 옵션을 다루지 않았습니다. 고급 사용 사례에 대해 문서를 참조하시기 바랍니다.",Bl,O,Wl,S,re="여기에 🤗 Transformers와 XLA에 대해 더 자세히 알고 싶은 경우 도움이 될 수 있는 몇 가지 추가 자료를 제공합니다.",El,P,pe='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">이 Colab 노트북</a>은 XLA와 호환되는 인코더-디코더(<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>와 같은) 및 디코더 전용(<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>와 같은) 텍스트 생성 모델을 실험해 볼 수 있는 대화형 데모를 제공합니다.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">이 블로그 글</a>은 TensorFlow에서 XLA에 대한 친절한 소개와 함께 XLA와 호환되는 모델의 비교 벤치마크에 대한 개요를 제공합니다.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">이 블로그 글</a>은 🤗 Transformers의 TensorFlow 모델에 XLA 지원을 추가하는 것에 대한 디자인 철학을 논의합니다.</li> <li>XLA와 TensorFlow 그래프에 대해 더 자세히 알고 싶은 경우 추천하는 글:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: 기계 학습을 위한 최적화 컴파일러</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">그래프 및 tf.function 소개</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">tf.function으로 성능 향상하기</a></li></ul></li>',xl,ll,Fl;return U=new el({props:{title:"TensorFlow 모델을 위한 XLA 통합",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),d=new we({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"}]}}),j=new el({props:{title:"XLA를 사용하여 TF 함수 실행하기",local:"running-tf-functions-with-xla",headingTag:"h2"}}),R=new f({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),Z=new f({props:{code:"JTIzJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTk3JTkwJTIwJUVCJThDJTgwJUVEJTk1JTlDJTIwJUVDJTlFJTg0JUVDJTlEJTk4JUVDJTlEJTk4JTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVDJTlEJTg0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQWlucHV0X3ZlY3Rvcl9kaW0lMjAlM0QlMjAxMCUwQXJhbmRvbV9pbnB1dHMlMjAlM0QlMjB0Zi5yYW5kb20ubm9ybWFsKChiYXRjaF9zaXplJTJDJTIwaW5wdXRfdmVjdG9yX2RpbSkpJTBBJTBBJTIzJTIwJUVDJTg4JTlDJUVDJUEwJTg0JUVEJThDJThDJUVCJUE1JUJDJTIwJUVDJThCJUE0JUVEJTk2JTg5JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQV8lMjAlM0QlMjBtb2RlbChyYW5kb21faW5wdXRzKQ==",highlighted:`<span class="hljs-comment"># 모델에 대한 임의의 입력을 생성합니다.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># 순전파를 실행합니다.</span>
_ = model(random_inputs)`,wrap:!1}}),I=new f({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),X=new f({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),Q=new el({props:{title:"🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기",local:"running-a-tf-text-generation-model-with-xla-from-transformers",headingTag:"h2"}}),$=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),W=new f({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjAlRUMlQjUlOUMlRUMlODYlOEMlMjAlRUIlQjIlODQlRUMlQTAlODQlRUMlOUQlOTglMjBUcmFuc2Zvcm1lcnMlRUElQjAlODAlMjAlRUMlODQlQTQlRUMlQjklOTglRUIlOTAlOTglRUMlOTYlQjQlMjAlRUMlOUUlODglRUMlQTclODAlMjAlRUMlOTUlOEElRUIlOEIlQTQlRUIlQTklQjQlMjAlRUMlOTglQTQlRUIlQTUlOTglRUElQjAlODAlMjAlRUIlQjAlOUMlRUMlODMlOUQlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGNoZWNrX21pbl92ZXJzaW9uJTBBJTBBY2hlY2tfbWluX3ZlcnNpb24oJTIyNC4yMS4wJTIyKSUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBJTIzJTIwWExBJTIwJUVDJTgzJTlEJUVDJTg0JUIxJTIwJUVEJTk1JUE4JUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVCJUE3JThDJUVCJTkzJUE0JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JTlDJTIwJUVEJTk1JTlDJTIwJUVDJUE0JTg0JTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># 최소 버전의 Transformers가 설치되어 있지 않다면 오류가 발생합니다.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># XLA 생성 함수를 만들기 위한 한 줄</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),x=new el({props:{title:"주의할 점",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),z=new f({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMCVFQyU5NyVBQyVFQSVCOCVCMCVFQyU4NCU5QyUyQyUyMHBhZGRpbmclMjAlRUMlOTglQjUlRUMlODUlOTglRUMlOUQlQjQlMjAlRUMlOUUlODglRUIlOEElOTQlMjAlRUQlODYlQTAlRUQlODElQUMlRUIlODIlOTglRUMlOUQlQjQlRUMlQTAlODAlRUIlQTUlQkMlMjAlRUQlOTglQjglRUMlQjYlOUMlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 여기서, padding 옵션이 있는 토크나이저를 호출합니다.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),H=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),N=new f({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),O=new el({props:{title:"추가 자료",local:"additional-resources",headingTag:"h2"}}),{c(){u=o("meta"),tl=n(),K=o("p"),sl=n(),i(U.$$.fragment),nl=n(),i(d.$$.fragment),al=n(),w=o("p"),w.innerHTML=Al,ol=n(),y=o("p"),y.textContent=zl,rl=n(),b=o("p"),b.innerHTML=Ll,pl=n(),h=o("p"),h.innerHTML=Hl,il=n(),g=o("p"),g.textContent=Dl,ml=n(),i(j.$$.fragment),Tl=n(),k=o("p"),k.textContent=Nl,Jl=n(),i(R.$$.fragment),cl=n(),_=o("p"),_.innerHTML=Yl,Ml=n(),i(Z.$$.fragment),ul=n(),V=o("p"),V.textContent=ql,fl=n(),i(I.$$.fragment),Ul=n(),C=o("p"),C.innerHTML=Ol,dl=n(),i(X.$$.fragment),wl=n(),i(Q.$$.fragment),yl=n(),G=o("p"),G.innerHTML=Sl,bl=n(),i($.$$.fragment),hl=n(),B=o("p"),B.textContent=Pl,gl=n(),i(W.$$.fragment),jl=n(),E=o("p"),E.innerHTML=Kl,kl=n(),i(x.$$.fragment),Rl=n(),F=o("p"),F.innerHTML=le,_l=n(),v=o("p"),v.innerHTML=ee,Zl=n(),A=o("p"),A.innerHTML=te,Vl=n(),i(z.$$.fragment),Il=n(),L=o("p"),L.innerHTML=se,Cl=n(),i(H.$$.fragment),Xl=n(),D=o("p"),D.textContent=ne,Ql=n(),i(N.$$.fragment),Gl=n(),Y=o("p"),Y.innerHTML=ae,$l=n(),q=o("p"),q.textContent=oe,Bl=n(),i(O.$$.fragment),Wl=n(),S=o("p"),S.textContent=re,El=n(),P=o("ul"),P.innerHTML=pe,xl=n(),ll=o("p"),this.h()},l(l){const e=fe("svelte-u9bgzb",document.head);u=r(e,"META",{name:!0,content:!0}),e.forEach(t),tl=a(l),K=r(l,"P",{}),ie(K).forEach(t),sl=a(l),m(U.$$.fragment,l),nl=a(l),m(d.$$.fragment,l),al=a(l),w=r(l,"P",{"data-svelte-h":!0}),p(w)!=="svelte-vhpug6"&&(w.innerHTML=Al),ol=a(l),y=r(l,"P",{"data-svelte-h":!0}),p(y)!=="svelte-mb1ukg"&&(y.textContent=zl),rl=a(l),b=r(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1f4n09x"&&(b.innerHTML=Ll),pl=a(l),h=r(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1v6brk3"&&(h.innerHTML=Hl),il=a(l),g=r(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-148xdun"&&(g.textContent=Dl),ml=a(l),m(j.$$.fragment,l),Tl=a(l),k=r(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1njozb7"&&(k.textContent=Nl),Jl=a(l),m(R.$$.fragment,l),cl=a(l),_=r(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-7f6oar"&&(_.innerHTML=Yl),Ml=a(l),m(Z.$$.fragment,l),ul=a(l),V=r(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1pc9n8q"&&(V.textContent=ql),fl=a(l),m(I.$$.fragment,l),Ul=a(l),C=r(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-epruek"&&(C.innerHTML=Ol),dl=a(l),m(X.$$.fragment,l),wl=a(l),m(Q.$$.fragment,l),yl=a(l),G=r(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1dwvoc4"&&(G.innerHTML=Sl),bl=a(l),m($.$$.fragment,l),hl=a(l),B=r(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-183puqa"&&(B.textContent=Pl),gl=a(l),m(W.$$.fragment,l),jl=a(l),E=r(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ssbrjd"&&(E.innerHTML=Kl),kl=a(l),m(x.$$.fragment,l),Rl=a(l),F=r(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1n4in8p"&&(F.innerHTML=le),_l=a(l),v=r(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-h9m36e"&&(v.innerHTML=ee),Zl=a(l),A=r(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1s012xi"&&(A.innerHTML=te),Vl=a(l),m(z.$$.fragment,l),Il=a(l),L=r(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-f28hgm"&&(L.innerHTML=se),Cl=a(l),m(H.$$.fragment,l),Xl=a(l),D=r(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1slt67r"&&(D.textContent=ne),Ql=a(l),m(N.$$.fragment,l),Gl=a(l),Y=r(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-15kvfy2"&&(Y.innerHTML=ae),$l=a(l),q=r(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-18p6eo2"&&(q.textContent=oe),Bl=a(l),m(O.$$.fragment,l),Wl=a(l),S=r(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-36wvdw"&&(S.textContent=re),El=a(l),P=r(l,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-wv6sfd"&&(P.innerHTML=pe),xl=a(l),ll=r(l,"P",{}),ie(ll).forEach(t),this.h()},h(){me(u,"name","hf:doc:metadata"),me(u,"content",be)},m(l,e){Ue(document.head,u),s(l,tl,e),s(l,K,e),s(l,sl,e),T(U,l,e),s(l,nl,e),T(d,l,e),s(l,al,e),s(l,w,e),s(l,ol,e),s(l,y,e),s(l,rl,e),s(l,b,e),s(l,pl,e),s(l,h,e),s(l,il,e),s(l,g,e),s(l,ml,e),T(j,l,e),s(l,Tl,e),s(l,k,e),s(l,Jl,e),T(R,l,e),s(l,cl,e),s(l,_,e),s(l,Ml,e),T(Z,l,e),s(l,ul,e),s(l,V,e),s(l,fl,e),T(I,l,e),s(l,Ul,e),s(l,C,e),s(l,dl,e),T(X,l,e),s(l,wl,e),T(Q,l,e),s(l,yl,e),s(l,G,e),s(l,bl,e),T($,l,e),s(l,hl,e),s(l,B,e),s(l,gl,e),T(W,l,e),s(l,jl,e),s(l,E,e),s(l,kl,e),T(x,l,e),s(l,Rl,e),s(l,F,e),s(l,_l,e),s(l,v,e),s(l,Zl,e),s(l,A,e),s(l,Vl,e),T(z,l,e),s(l,Il,e),s(l,L,e),s(l,Cl,e),T(H,l,e),s(l,Xl,e),s(l,D,e),s(l,Ql,e),T(N,l,e),s(l,Gl,e),s(l,Y,e),s(l,$l,e),s(l,q,e),s(l,Bl,e),T(O,l,e),s(l,Wl,e),s(l,S,e),s(l,El,e),s(l,P,e),s(l,xl,e),s(l,ll,e),Fl=!0},p:Je,i(l){Fl||(J(U.$$.fragment,l),J(d.$$.fragment,l),J(j.$$.fragment,l),J(R.$$.fragment,l),J(Z.$$.fragment,l),J(I.$$.fragment,l),J(X.$$.fragment,l),J(Q.$$.fragment,l),J($.$$.fragment,l),J(W.$$.fragment,l),J(x.$$.fragment,l),J(z.$$.fragment,l),J(H.$$.fragment,l),J(N.$$.fragment,l),J(O.$$.fragment,l),Fl=!0)},o(l){c(U.$$.fragment,l),c(d.$$.fragment,l),c(j.$$.fragment,l),c(R.$$.fragment,l),c(Z.$$.fragment,l),c(I.$$.fragment,l),c(X.$$.fragment,l),c(Q.$$.fragment,l),c($.$$.fragment,l),c(W.$$.fragment,l),c(x.$$.fragment,l),c(z.$$.fragment,l),c(H.$$.fragment,l),c(N.$$.fragment,l),c(O.$$.fragment,l),Fl=!1},d(l){l&&(t(tl),t(K),t(sl),t(nl),t(al),t(w),t(ol),t(y),t(rl),t(b),t(pl),t(h),t(il),t(g),t(ml),t(Tl),t(k),t(Jl),t(cl),t(_),t(Ml),t(ul),t(V),t(fl),t(Ul),t(C),t(dl),t(wl),t(yl),t(G),t(bl),t(hl),t(B),t(gl),t(jl),t(E),t(kl),t(Rl),t(F),t(_l),t(v),t(Zl),t(A),t(Vl),t(Il),t(L),t(Cl),t(Xl),t(D),t(Ql),t(Gl),t(Y),t($l),t(q),t(Bl),t(Wl),t(S),t(El),t(P),t(xl),t(ll)),t(u),M(U,l),M(d,l),M(j,l),M(R,l),M(Z,l),M(I,l),M(X,l),M(Q,l),M($,l),M(W,l),M(x,l),M(z,l),M(H,l),M(N,l),M(O,l)}}}const be='{"title":"TensorFlow 모델을 위한 XLA 통합","local":"xla-integration-for-tensorflow-models","sections":[{"title":"XLA를 사용하여 TF 함수 실행하기","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기","local":"running-a-tf-text-generation-model-with-xla-from-transformers","sections":[],"depth":2},{"title":"주의할 점","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"추가 자료","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function he(vl){return ce(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=de}),[]}class Ze extends Me{constructor(u){super(),ue(this,u,he,ye,Te,{})}}export{Ze as component};
