import{s as ke,n as Ye,o as _e}from"../chunks/scheduler.d586627e.js";import{S as Ne,i as xe,g as M,s,r as n,A as Ve,h as d,f as a,c as o,j as We,u as r,x as w,k as Xe,y as Re,a as l,v as i,d as c,t as p,w as m}from"../chunks/index.8589a59c.js";import{H as E,g as Qe}from"../chunks/Heading.9a893468.js";import{C as y}from"../chunks/CodeBlock.47c46d2c.js";function Ee(be){let u,H,F,z,J,P,j,Ue=`O paralelismo surgiu como uma estratégia para treinar modelos grandes em hardware limitado e aumentar a velocidade
de treinamento em várias órdens de magnitude. Na Hugging Face criamos a biblioteca <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a>
para ajudar os usuários a treinar modelos 🤗 Transformers com qualquer configuração distribuída, seja em uma máquina
com múltiplos GPUs ou em múltiplos GPUs distribuidos entre muitas máquinas. Neste tutorial, você irá aprender como
personalizar seu laço de treinamento de PyTorch para poder treinar em ambientes distribuídos.`,K,T,L,f,he="De início, instale o 🤗 Accelerate:",q,b,D,U,ge=`Logo, devemos importar e criar um objeto <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>.
O <code>Accelerator</code> detectará automáticamente a configuração distribuída disponível e inicializará todos os
componentes necessários para o treinamento. Não há necessidade portanto de especificar o dispositivo onde deve colocar seu modelo.`,O,h,ee,g,te,$,$e=`Passe todos os objetos relevantes ao treinamento para o método <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>.
Isto inclui os DataLoaders de treino e evaluação, um modelo e um otimizador:`,ae,I,le,C,se,B,Ie='Por último, substitua o <code>loss.backward()</code> padrão em seu laço de treinamento com o método <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.backward" rel="nofollow"><code>backward</code></a> do 🤗 Accelerate:',oe,Z,ne,A,Ce=`Como se poder ver no seguinte código, só precisará adicionar quatro linhas de código ao seu laço de treinamento
para habilitar o treinamento distribuído!`,re,v,ie,G,ce,W,Be="Quando tiver adicionado as linhas de código relevantes, inicie o treinamento por um script ou notebook como o Colab.",pe,X,me,k,Ze="Se estiver rodando seu treinamento em um Script, execute o seguinte comando para criar e guardar um arquivo de configuração:",Me,Y,de,_,Ae="Comece o treinamento com:",we,N,ue,x,ye,V,ve=`O 🤗 Accelerate pode rodar em um notebook, por exemplo, se estiver planejando usar as TPUs do Google Colab.
Encapsule o código responsável pelo treinamento de uma função e passe-o ao <code>notebook_launcher</code>:`,Je,R,je,Q,Ge='Para obter mais informações sobre o 🤗 Accelerate e suas numerosas funções, consulte a <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">documentación</a>.',Te,S,fe;return J=new E({props:{title:"Treinamento distribuído com o 🤗 Accelerate",local:"treinamento-distribuído-com-o--accelerate",headingTag:"h1"}}),T=new E({props:{title:"Configuração",local:"configuração",headingTag:"h2"}}),b=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),h=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`,wrap:!1}}),g=new E({props:{title:"Preparando a aceleração",local:"preparando-a-aceleração",headingTag:"h2"}}),I=new y({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new E({props:{title:"Backward",local:"backward",headingTag:"h2"}}),Z=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),v=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),G=new E({props:{title:"Treinamento",local:"treinamento",headingTag:"h2"}}),X=new E({props:{title:"Treinamento em um Script",local:"treinamento-em-um-script",headingTag:"h3"}}),Y=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),N=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py",wrap:!1}}),x=new E({props:{title:"Treinamento em um Notebook",local:"treinamento-em-um-notebook",headingTag:"h3"}}),R=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`,wrap:!1}}),{c(){u=M("meta"),H=s(),F=M("p"),z=s(),n(J.$$.fragment),P=s(),j=M("p"),j.innerHTML=Ue,K=s(),n(T.$$.fragment),L=s(),f=M("p"),f.textContent=he,q=s(),n(b.$$.fragment),D=s(),U=M("p"),U.innerHTML=ge,O=s(),n(h.$$.fragment),ee=s(),n(g.$$.fragment),te=s(),$=M("p"),$.innerHTML=$e,ae=s(),n(I.$$.fragment),le=s(),n(C.$$.fragment),se=s(),B=M("p"),B.innerHTML=Ie,oe=s(),n(Z.$$.fragment),ne=s(),A=M("p"),A.textContent=Ce,re=s(),n(v.$$.fragment),ie=s(),n(G.$$.fragment),ce=s(),W=M("p"),W.textContent=Be,pe=s(),n(X.$$.fragment),me=s(),k=M("p"),k.textContent=Ze,Me=s(),n(Y.$$.fragment),de=s(),_=M("p"),_.textContent=Ae,we=s(),n(N.$$.fragment),ue=s(),n(x.$$.fragment),ye=s(),V=M("p"),V.innerHTML=ve,Je=s(),n(R.$$.fragment),je=s(),Q=M("p"),Q.innerHTML=Ge,Te=s(),S=M("p"),this.h()},l(e){const t=Ve("svelte-u9bgzb",document.head);u=d(t,"META",{name:!0,content:!0}),t.forEach(a),H=o(e),F=d(e,"P",{}),We(F).forEach(a),z=o(e),r(J.$$.fragment,e),P=o(e),j=d(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-1wiu3fb"&&(j.innerHTML=Ue),K=o(e),r(T.$$.fragment,e),L=o(e),f=d(e,"P",{"data-svelte-h":!0}),w(f)!=="svelte-t6m1zf"&&(f.textContent=he),q=o(e),r(b.$$.fragment,e),D=o(e),U=d(e,"P",{"data-svelte-h":!0}),w(U)!=="svelte-1rphp5p"&&(U.innerHTML=ge),O=o(e),r(h.$$.fragment,e),ee=o(e),r(g.$$.fragment,e),te=o(e),$=d(e,"P",{"data-svelte-h":!0}),w($)!=="svelte-iagz26"&&($.innerHTML=$e),ae=o(e),r(I.$$.fragment,e),le=o(e),r(C.$$.fragment,e),se=o(e),B=d(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1a4hz8x"&&(B.innerHTML=Ie),oe=o(e),r(Z.$$.fragment,e),ne=o(e),A=d(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1eeg6uf"&&(A.textContent=Ce),re=o(e),r(v.$$.fragment,e),ie=o(e),r(G.$$.fragment,e),ce=o(e),W=d(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1ugx3dc"&&(W.textContent=Be),pe=o(e),r(X.$$.fragment,e),me=o(e),k=d(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-o59jjd"&&(k.textContent=Ze),Me=o(e),r(Y.$$.fragment,e),de=o(e),_=d(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-257ccc"&&(_.textContent=Ae),we=o(e),r(N.$$.fragment,e),ue=o(e),r(x.$$.fragment,e),ye=o(e),V=d(e,"P",{"data-svelte-h":!0}),w(V)!=="svelte-12l65dl"&&(V.innerHTML=ve),Je=o(e),r(R.$$.fragment,e),je=o(e),Q=d(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-8c3jdl"&&(Q.innerHTML=Ge),Te=o(e),S=d(e,"P",{}),We(S).forEach(a),this.h()},h(){Xe(u,"name","hf:doc:metadata"),Xe(u,"content",Fe)},m(e,t){Re(document.head,u),l(e,H,t),l(e,F,t),l(e,z,t),i(J,e,t),l(e,P,t),l(e,j,t),l(e,K,t),i(T,e,t),l(e,L,t),l(e,f,t),l(e,q,t),i(b,e,t),l(e,D,t),l(e,U,t),l(e,O,t),i(h,e,t),l(e,ee,t),i(g,e,t),l(e,te,t),l(e,$,t),l(e,ae,t),i(I,e,t),l(e,le,t),i(C,e,t),l(e,se,t),l(e,B,t),l(e,oe,t),i(Z,e,t),l(e,ne,t),l(e,A,t),l(e,re,t),i(v,e,t),l(e,ie,t),i(G,e,t),l(e,ce,t),l(e,W,t),l(e,pe,t),i(X,e,t),l(e,me,t),l(e,k,t),l(e,Me,t),i(Y,e,t),l(e,de,t),l(e,_,t),l(e,we,t),i(N,e,t),l(e,ue,t),i(x,e,t),l(e,ye,t),l(e,V,t),l(e,Je,t),i(R,e,t),l(e,je,t),l(e,Q,t),l(e,Te,t),l(e,S,t),fe=!0},p:Ye,i(e){fe||(c(J.$$.fragment,e),c(T.$$.fragment,e),c(b.$$.fragment,e),c(h.$$.fragment,e),c(g.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(N.$$.fragment,e),c(x.$$.fragment,e),c(R.$$.fragment,e),fe=!0)},o(e){p(J.$$.fragment,e),p(T.$$.fragment,e),p(b.$$.fragment,e),p(h.$$.fragment,e),p(g.$$.fragment,e),p(I.$$.fragment,e),p(C.$$.fragment,e),p(Z.$$.fragment,e),p(v.$$.fragment,e),p(G.$$.fragment,e),p(X.$$.fragment,e),p(Y.$$.fragment,e),p(N.$$.fragment,e),p(x.$$.fragment,e),p(R.$$.fragment,e),fe=!1},d(e){e&&(a(H),a(F),a(z),a(P),a(j),a(K),a(L),a(f),a(q),a(D),a(U),a(O),a(ee),a(te),a($),a(ae),a(le),a(se),a(B),a(oe),a(ne),a(A),a(re),a(ie),a(ce),a(W),a(pe),a(me),a(k),a(Me),a(de),a(_),a(we),a(ue),a(ye),a(V),a(Je),a(je),a(Q),a(Te),a(S)),a(u),m(J,e),m(T,e),m(b,e),m(h,e),m(g,e),m(I,e),m(C,e),m(Z,e),m(v,e),m(G,e),m(X,e),m(Y,e),m(N,e),m(x,e),m(R,e)}}}const Fe='{"title":"Treinamento distribuído com o 🤗 Accelerate","local":"treinamento-distribuído-com-o--accelerate","sections":[{"title":"Configuração","local":"configuração","sections":[],"depth":2},{"title":"Preparando a aceleração","local":"preparando-a-aceleração","sections":[],"depth":2},{"title":"Backward","local":"backward","sections":[],"depth":2},{"title":"Treinamento","local":"treinamento","sections":[{"title":"Treinamento em um Script","local":"treinamento-em-um-script","sections":[],"depth":3},{"title":"Treinamento em um Notebook","local":"treinamento-em-um-notebook","sections":[],"depth":3}],"depth":2}],"depth":1}';function Se(be){return _e(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Qe}),[]}class Le extends Ne{constructor(u){super(),xe(this,u,Se,Ee,ke,{})}}export{Le as component};
