import{s as re,n as pe,o as me}from"../chunks/scheduler.852ec091.js";import{S as fe,i as de,g as s,s as a,r as p,A as ce,h as o,f as n,c as l,j as oe,u as m,x as r,k as K,y as be,a as i,v as f,d,t as c,w as b}from"../chunks/index.28275fd3.js";import{C as O}from"../chunks/CodeBlock.c866bcf2.js";import{H as T,E as ye}from"../chunks/getInferenceSnippets.4c9a2b57.js";function ue(Qt){let y,nt,tt,it,w,at,U,Et="bitsandbytes is widely integrated with many of the libraries in the Hugging Face and wider PyTorch ecosystem. This guide provides a brief overview of the integrations and how to use bitsandbytes with them. For more details, you should refer to the linked documentation for each library.",lt,_,st,u,Ft='<p>Learn more in the bitsandbytes Transformers integration <a href="https://huggingface.co/docs/transformers/quantization#bitsandbytes" rel="nofollow">guide</a>.</p>',ot,C,At='With Transformers, it’s very easy to load any model in 4 or 8-bit and quantize them on the fly. To configure the quantization parameters, specify them in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class.',rt,$,Vt="For example, to load and quantize a model to 4-bits and use the bfloat16 data type for compute:",pt,g,qt='<p>bfloat16 is the ideal <code>compute_dtype</code> if your hardware supports it. While the default <code>compute_dtype</code>, float32, ensures backward compatibility (due to wide-ranging hardware support) and numerical stability, it is large and slows down computations. In contrast, float16 is smaller and faster but can lead to numerical instabilities. bfloat16 combines the best aspects of both; it offers the numerical stability of float32 and the reduced memory footprint and speed of a 16-bit data type. Check if your hardware supports bfloat16 and configure it using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a>!</p>',mt,J,ft,v,dt,Z,Yt='You can use any of the 8-bit or paged optimizers with Transformers by passing them to the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class on initialization. All bitsandbytes optimizers are supported by passing the correct string in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> <code>optim</code> parameter. For example, to load a <a href="/docs/bitsandbytes/main/en/reference/optim/adamw#bitsandbytes.optim.PagedAdamW32bit">PagedAdamW32bit</a> optimizer:',ct,B,bt,j,yt,h,It='<p>Learn more in the bitsandbytes PEFT integration <a href="https://huggingface.co/docs/peft/developer_guides/quantization#quantization" rel="nofollow">guide</a>.</p>',ut,X,Nt="PEFT builds on the bitsandbytes Transformers integration, and extends it for training with a few more steps. Let’s prepare the 4-bit model from the section above for training.",gt,k,Pt="Call the <code>~peft.prepare_model_for_kbit_training</code> method to prepare the model for training. This only works for Transformers models!",ht,L,Mt,G,St="Setup a <code>~peft.LoraConfig</code> to use QLoRA:",Tt,W,wt,z,Dt="Now call the <code>~peft.get_peft_model</code> function on your model and config to create a trainable <code>PeftModel</code>.",Ut,R,_t,H,Ct,M,Kt='<p>Learn more in the bitsandbytes Accelerate integration <a href="https://huggingface.co/docs/accelerate/usage_guides/quantization" rel="nofollow">guide</a>.</p>',$t,x,Ot='bitsandbytes is also easily usable from Accelerate and you can quantize any PyTorch model by passing a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig" rel="nofollow">BnbQuantizationConfig</a> with your desired settings, and then calling the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.load_and_quantize_model" rel="nofollow">load_and_quantize_model</a> function to quantize it.',Jt,Q,vt,E,Zt,F,te="bitsandbytes is available from:",Bt,A,ee='<li><a href="https://lightning.ai/docs/pytorch/stable/" rel="nofollow">PyTorch Lightning</a>, a deep learning framework for professional AI researchers and machine learning engineers who need maximal flexibility without sacrificing performance at scale.</li> <li><a href="https://lightning.ai/docs/fabric/stable/" rel="nofollow">Lightning Fabric</a>, a fast and lightweight way to scale PyTorch models without boilerplate.</li>',jt,V,ne='Learn more in the bitsandbytes PyTorch Lightning integration <a href="https://lightning.ai/docs/pytorch/stable/common/precision_intermediate.html#quantization-via-bitsandbytes" rel="nofollow">guide</a>.',Xt,q,kt,Y,ie='bitsandbytes is integrated with <a href="https://github.com/Lightning-AI/lit-gpt" rel="nofollow">Lit-GPT</a>, a hackable implementation of state-of-the-art open-source large language models. Lit-GPT is based on Lightning Fabric, and it can be used for quantization during training, finetuning, and inference.',Lt,I,ae='Learn more in the bitsandbytes Lit-GPT integration <a href="https://github.com/Lightning-AI/lit-gpt/blob/main/tutorials/quantize.md" rel="nofollow">guide</a>.',Gt,N,Wt,P,le="To learn in more detail about some of bitsandbytes integrations, take a look at the following blog posts:",zt,S,se='<li><a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a></li> <li><a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a></li>',Rt,D,Ht,et,xt;return w=new T({props:{title:"Integrations",local:"integrations",headingTag:"h1"}}),_=new T({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),J=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)
model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),v=new T({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h3"}}),B=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMnBhZ2VkX2FkYW13XzMyYml0JTIyJTJDJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTJDJTIwdHJhaW5pbmdfYXJncyUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

training_args = TrainingArguments(
    ...,
    optim=<span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>,
)
trainer = Trainer(model, training_args, ...)
trainer.train()`,wrap:!1}}),j=new T({props:{title:"PEFT",local:"peft",headingTag:"h2"}}),L=new O({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMHByZXBhcmVfbW9kZWxfZm9yX2tiaXRfdHJhaW5pbmcobW9kZWxfNGJpdCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model_4bit = prepare_model_for_kbit_training(model_4bit)`,wrap:!1}}),W=new O({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTIyYWxsLWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),R=new O({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWxfNGJpdCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model_4bit, config)`,wrap:!1}}),H=new T({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),Q=new O({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyUyQyUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsJTBBZnJvbSUyMG1pbmdwdC5tb2RlbCUyMGltcG9ydCUyMEdQVCUwQSUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMEdQVC5nZXRfZGVmYXVsdF9jb25maWcoKSUwQW1vZGVsX2NvbmZpZy5tb2RlbF90eXBlJTIwJTNEJTIwJ2dwdDIteGwnJTBBbW9kZWxfY29uZmlnLnZvY2FiX3NpemUlMjAlM0QlMjA1MDI1NyUwQW1vZGVsX2NvbmZpZy5ibG9ja19zaXplJTIwJTNEJTIwMTAyNCUwQSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMGVtcHR5X21vZGVsJTIwJTNEJTIwR1BUKG1vZGVsX2NvbmZpZyklMEElMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTIwJTIzJTIwb3B0aW9uYWwlMEElMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBKSUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKCUwQSUyMCUyMGVtcHR5X21vZGVsJTJDJTBBJTIwJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMEElMjAlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig, load_and_quantize_model
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)

bnb_quantization_config = BnbQuantizationConfig(
  load_in_4bit=<span class="hljs-literal">True</span>,
  bnb_4bit_compute_dtype=torch.bfloat16,  <span class="hljs-comment"># optional</span>
  bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,         <span class="hljs-comment"># optional</span>
  bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>               <span class="hljs-comment"># optional</span>
)

quantized_model = load_and_quantize_model(
  empty_model,
  weights_location=weights_location,
  bnb_quantization_config=bnb_quantization_config,
  device_map = <span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),E=new T({props:{title:"PyTorch Lightning and Lightning Fabric",local:"pytorch-lightning-and-lightning-fabric",headingTag:"h2"}}),q=new T({props:{title:"Lit-GPT",local:"lit-gpt",headingTag:"h2"}}),N=new T({props:{title:"Blog posts",local:"blog-posts",headingTag:"h2"}}),D=new ye({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/integrations.mdx"}}),{c(){y=s("meta"),nt=a(),tt=s("p"),it=a(),p(w.$$.fragment),at=a(),U=s("p"),U.textContent=Et,lt=a(),p(_.$$.fragment),st=a(),u=s("blockquote"),u.innerHTML=Ft,ot=a(),C=s("p"),C.innerHTML=At,rt=a(),$=s("p"),$.textContent=Vt,pt=a(),g=s("blockquote"),g.innerHTML=qt,mt=a(),p(J.$$.fragment),ft=a(),p(v.$$.fragment),dt=a(),Z=s("p"),Z.innerHTML=Yt,ct=a(),p(B.$$.fragment),bt=a(),p(j.$$.fragment),yt=a(),h=s("blockquote"),h.innerHTML=It,ut=a(),X=s("p"),X.textContent=Nt,gt=a(),k=s("p"),k.innerHTML=Pt,ht=a(),p(L.$$.fragment),Mt=a(),G=s("p"),G.innerHTML=St,Tt=a(),p(W.$$.fragment),wt=a(),z=s("p"),z.innerHTML=Dt,Ut=a(),p(R.$$.fragment),_t=a(),p(H.$$.fragment),Ct=a(),M=s("blockquote"),M.innerHTML=Kt,$t=a(),x=s("p"),x.innerHTML=Ot,Jt=a(),p(Q.$$.fragment),vt=a(),p(E.$$.fragment),Zt=a(),F=s("p"),F.textContent=te,Bt=a(),A=s("ul"),A.innerHTML=ee,jt=a(),V=s("p"),V.innerHTML=ne,Xt=a(),p(q.$$.fragment),kt=a(),Y=s("p"),Y.innerHTML=ie,Lt=a(),I=s("p"),I.innerHTML=ae,Gt=a(),p(N.$$.fragment),Wt=a(),P=s("p"),P.textContent=le,zt=a(),S=s("ul"),S.innerHTML=se,Rt=a(),p(D.$$.fragment),Ht=a(),et=s("p"),this.h()},l(t){const e=ce("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(n),nt=l(t),tt=o(t,"P",{}),oe(tt).forEach(n),it=l(t),m(w.$$.fragment,t),at=l(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-17oloa0"&&(U.textContent=Et),lt=l(t),m(_.$$.fragment,t),st=l(t),u=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-1a8u5ay"&&(u.innerHTML=Ft),ot=l(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-t09m1v"&&(C.innerHTML=At),rt=l(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-fugr8i"&&($.textContent=Vt),pt=l(t),g=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1o6oue3"&&(g.innerHTML=qt),mt=l(t),m(J.$$.fragment,t),ft=l(t),m(v.$$.fragment,t),dt=l(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rupil2"&&(Z.innerHTML=Yt),ct=l(t),m(B.$$.fragment,t),bt=l(t),m(j.$$.fragment,t),yt=l(t),h=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ts8pmq"&&(h.innerHTML=It),ut=l(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-945c4h"&&(X.textContent=Nt),gt=l(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-16xvigi"&&(k.innerHTML=Pt),ht=l(t),m(L.$$.fragment,t),Mt=l(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-xc51cl"&&(G.innerHTML=St),Tt=l(t),m(W.$$.fragment,t),wt=l(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-x8ok68"&&(z.innerHTML=Dt),Ut=l(t),m(R.$$.fragment,t),_t=l(t),m(H.$$.fragment,t),Ct=l(t),M=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-ebimhp"&&(M.innerHTML=Kt),$t=l(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-wlkf6t"&&(x.innerHTML=Ot),Jt=l(t),m(Q.$$.fragment,t),vt=l(t),m(E.$$.fragment,t),Zt=l(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zm0jix"&&(F.textContent=te),Bt=l(t),A=o(t,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-c4dddp"&&(A.innerHTML=ee),jt=l(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-xrv468"&&(V.innerHTML=ne),Xt=l(t),m(q.$$.fragment,t),kt=l(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-jne5kj"&&(Y.innerHTML=ie),Lt=l(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-144d081"&&(I.innerHTML=ae),Gt=l(t),m(N.$$.fragment,t),Wt=l(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-hhb45g"&&(P.textContent=le),zt=l(t),S=o(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1opwyey"&&(S.innerHTML=se),Rt=l(t),m(D.$$.fragment,t),Ht=l(t),et=o(t,"P",{}),oe(et).forEach(n),this.h()},h(){K(y,"name","hf:doc:metadata"),K(y,"content",ge),K(u,"class","tip"),K(g,"class","warning"),K(h,"class","tip"),K(M,"class","tip")},m(t,e){be(document.head,y),i(t,nt,e),i(t,tt,e),i(t,it,e),f(w,t,e),i(t,at,e),i(t,U,e),i(t,lt,e),f(_,t,e),i(t,st,e),i(t,u,e),i(t,ot,e),i(t,C,e),i(t,rt,e),i(t,$,e),i(t,pt,e),i(t,g,e),i(t,mt,e),f(J,t,e),i(t,ft,e),f(v,t,e),i(t,dt,e),i(t,Z,e),i(t,ct,e),f(B,t,e),i(t,bt,e),f(j,t,e),i(t,yt,e),i(t,h,e),i(t,ut,e),i(t,X,e),i(t,gt,e),i(t,k,e),i(t,ht,e),f(L,t,e),i(t,Mt,e),i(t,G,e),i(t,Tt,e),f(W,t,e),i(t,wt,e),i(t,z,e),i(t,Ut,e),f(R,t,e),i(t,_t,e),f(H,t,e),i(t,Ct,e),i(t,M,e),i(t,$t,e),i(t,x,e),i(t,Jt,e),f(Q,t,e),i(t,vt,e),f(E,t,e),i(t,Zt,e),i(t,F,e),i(t,Bt,e),i(t,A,e),i(t,jt,e),i(t,V,e),i(t,Xt,e),f(q,t,e),i(t,kt,e),i(t,Y,e),i(t,Lt,e),i(t,I,e),i(t,Gt,e),f(N,t,e),i(t,Wt,e),i(t,P,e),i(t,zt,e),i(t,S,e),i(t,Rt,e),f(D,t,e),i(t,Ht,e),i(t,et,e),xt=!0},p:pe,i(t){xt||(d(w.$$.fragment,t),d(_.$$.fragment,t),d(J.$$.fragment,t),d(v.$$.fragment,t),d(B.$$.fragment,t),d(j.$$.fragment,t),d(L.$$.fragment,t),d(W.$$.fragment,t),d(R.$$.fragment,t),d(H.$$.fragment,t),d(Q.$$.fragment,t),d(E.$$.fragment,t),d(q.$$.fragment,t),d(N.$$.fragment,t),d(D.$$.fragment,t),xt=!0)},o(t){c(w.$$.fragment,t),c(_.$$.fragment,t),c(J.$$.fragment,t),c(v.$$.fragment,t),c(B.$$.fragment,t),c(j.$$.fragment,t),c(L.$$.fragment,t),c(W.$$.fragment,t),c(R.$$.fragment,t),c(H.$$.fragment,t),c(Q.$$.fragment,t),c(E.$$.fragment,t),c(q.$$.fragment,t),c(N.$$.fragment,t),c(D.$$.fragment,t),xt=!1},d(t){t&&(n(nt),n(tt),n(it),n(at),n(U),n(lt),n(st),n(u),n(ot),n(C),n(rt),n($),n(pt),n(g),n(mt),n(ft),n(dt),n(Z),n(ct),n(bt),n(yt),n(h),n(ut),n(X),n(gt),n(k),n(ht),n(Mt),n(G),n(Tt),n(wt),n(z),n(Ut),n(_t),n(Ct),n(M),n($t),n(x),n(Jt),n(vt),n(Zt),n(F),n(Bt),n(A),n(jt),n(V),n(Xt),n(kt),n(Y),n(Lt),n(I),n(Gt),n(Wt),n(P),n(zt),n(S),n(Rt),n(Ht),n(et)),n(y),b(w,t),b(_,t),b(J,t),b(v,t),b(B,t),b(j,t),b(L,t),b(W,t),b(R,t),b(H,t),b(Q,t),b(E,t),b(q,t),b(N,t),b(D,t)}}}const ge='{"title":"Integrations","local":"integrations","sections":[{"title":"Transformers","local":"transformers","sections":[{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[],"depth":3}],"depth":2},{"title":"PEFT","local":"peft","sections":[],"depth":2},{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Lightning and Lightning Fabric","local":"pytorch-lightning-and-lightning-fabric","sections":[],"depth":2},{"title":"Lit-GPT","local":"lit-gpt","sections":[],"depth":2},{"title":"Blog posts","local":"blog-posts","sections":[],"depth":2}],"depth":1}';function he(Qt){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends fe{constructor(y){super(),de(this,y,he,ue,re,{})}}export{_e as component};
