import{s as Le,n as Ae,o as Be}from"../chunks/scheduler.852ec091.js";import{S as Ye,i as He,g as n,s as a,r,A as Ee,h as m,f as s,c as i,j as Ie,u as o,x as p,k as S,y as Qe,a as l,v as d,d as b,t as c,w as M}from"../chunks/index.28275fd3.js";import{C as E}from"../chunks/CodeBlock.c866bcf2.js";import{H as fe,E as Fe}from"../chunks/getInferenceSnippets.4c9a2b57.js";function Se(Te){let u,X,Q,R,f,V,T,Je="With 8-bit optimizers, large models can be finetuned with 75% less GPU memory without losing any accuracy compared to training with standard 32-bit optimizers. The reduced memory requirements means 8-bit optimizers are 4x faster than a standard optimizer, and no hyperparameter tuning is required.",N,J,je="This guide will show you how to use 8-bit optimizers.",P,y,ge="<p>8-bit optimizers reduce memory usage and accelerate optimization on a wide range of tasks. However, since 8-bit optimizers only reduce memory proportional to the number of parameters, models that use large amounts of activation memory, such as convolutional networks, don’t really benefit from 8-bit optimizers. 8-bit optimizers are most beneficial for training or finetuning models with many parameters on highly memory-constrained GPUs.</p>",K,j,Ue='8-bit optimizers are a drop-in replacement for regular optimizers which means they also accept the same arguments as a regular optimizer. For NLP models, it is recommended to use the <a href="/docs/bitsandbytes/main/en/reference/nn/embeddings#bitsandbytes.nn.StableEmbedding">StableEmbedding</a> class to improve stability and results.',O,g,q,U,$e="By default, all parameter tensors with less than 4096 elements are kept at 32-bits even if you initialize those parameters with 8-bit optimizers. This is done because small tensors do not save much memory and often contain highly variable parameters (biases) or parameters that require high precision (batch norm, layer norm).",D,$,Ge="You can change this value with the <code>min_8bit_size</code> parameter. For example, if you want to optimize parameters to 8-bits only if the minimum size is 16384 values (it is recommended to use multiples of 4096):",ee,G,te,v,ve='Other parameters you can configure include the learning rate (<code>lr</code>), the decay rates (<code>betas</code>), the number of bits of the optimizer state (<code>optim_bits</code>), and percentile clipping (<code>percentile_clipping</code>) which can increase stability. For example, to initialize a 32-bit <a href="/docs/bitsandbytes/main/en/reference/optim/adam#bitsandbytes.optim.Adam">Adam</a> optimizer with 5th percentile clipping:',se,Z,le,k,ae,_,Ze='To optimize some unstable parameters with 32-bit Adam and others with 8-bit Adam, use the <a href="/docs/bitsandbytes/main/en/reference/optim/optim_overview#bitsandbytes.optim.GlobalOptimManager">GlobalOptimManager</a> class to override the specific hyperparameters for a particular layer. You’ll need to:',ie,z,ke="<li>Register the parameters while they’re on the CPU.</li>",ne,x,me,h,_e="<li>Override the config with the new desired hyperparameters. For example, let’s override the <code>model.fc1.weight</code> layer to use 32-bit Adam.</li>",pe,w,ze="<p>Check the optimizer API documentation for more information about other hyperparameters you can override.</p>",re,W,oe,C,xe="You can also override multiple layers at once by passing them as a list and the new hyperparameters as a dictionary. For example, let’s override the <code>model.special.weight</code> and <code>model.also_special.weight</code> layers to use sparse optimization and a lower learning and decay rate.",de,I,be,L,We='For a specific layer, we recommend overriding locally in each module. Pass the module, the parameter, and its attribute name to the <a href="/docs/bitsandbytes/main/en/reference/optim/optim_overview#bitsandbytes.optim.GlobalOptimManager">GlobalOptimManager</a>:',ce,A,Me,B,ue,Y,Ce='For more conceptual details and explanation about 8-bit optimizers, take a look at the <a href="./explanations/optimizers">8-bit optimizers</a> guide.',ye,H,he,F,we;return f=new fe({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h1"}}),g=new E({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEEtJTIwYWRhbSUyMCUzRCUyMHRvcmNoLm9wdGltLkFkYW0oLi4uKSUwQSUyQiUyMGFkYW0lMjAlM0QlMjBibmIub3B0aW0uQWRhbThiaXQoLi4uKSUwQSUwQSUyMyUyMHJlY29tbWVuZGVkJTIwZm9yJTIwTkxQJTIwbW9kZWxzJTBBLSUyMGJlZm9yZSUzQSUyMHRvcmNoLm5uLkVtYmVkZGluZyguLi4pJTBBJTJCJTIwYm5iLm5uLlN0YWJsZUVtYmVkZGluZyguLi4p",highlighted:`import bitsandbytes as bnb

<span class="hljs-deletion">- adam = torch.optim.Adam(...)</span>
<span class="hljs-addition">+ adam = bnb.optim.Adam8bit(...)</span>

# recommended for NLP models
<span class="hljs-deletion">- before: torch.nn.Embedding(...)</span>
<span class="hljs-addition">+ bnb.nn.StableEmbedding(...)</span>`,wrap:!1}}),G=new E({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMG1pbl84Yml0X3NpemUlM0QxNjM4NCk=",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

adam = bnb.optim.Adam8bit(model.parameters(), min_8bit_size=<span class="hljs-number">16384</span>)`,wrap:!1}}),Z=new E({props:{code:"aW1wb3J0JTIwYml0c2FuZGJ5dGVzJTIwYXMlMjBibmIlMEElMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW0obW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QwLjAwMSUyQyUyMGJldGFzJTNEKDAuOSUyQyUyMDAuOTk1KSUyQyUyMG9wdGltX2JpdHMlM0QzMiUyQyUyMHBlcmNlbnRpbGVfY2xpcHBpbmclM0Q1KQ==",highlighted:`<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, betas=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.995</span>), optim_bits=<span class="hljs-number">32</span>, percentile_clipping=<span class="hljs-number">5</span>)`,wrap:!1}}),k=new fe({props:{title:"Optimize unstable parameters",local:"optimize-unstable-parameters",headingTag:"h2"}}),x=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBiaXRzYW5kYnl0ZXMlMjBhcyUyMGJuYiUwQSUwQW1uZyUyMCUzRCUyMGJuYi5vcHRpbS5HbG9iYWxPcHRpbU1hbmFnZXIuZ2V0X2luc3RhbmNlKCklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKSUwQW1uZy5yZWdpc3Rlcl9wYXJhbWV0ZXJzKG1vZGVsLnBhcmFtZXRlcnMoKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

mng = bnb.optim.GlobalOptimManager.get_instance()

model = MyModel()
mng.register_parameters(model.parameters())`,wrap:!1}}),W=new E({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC5jdWRhKCklMEElMjMlMjB1c2UlMjA4LWJpdCUyMG9wdGltaXplciUyMHN0YXRlcyUyMGZvciUyMGFsbCUyMHBhcmFtZXRlcnMlMEFhZGFtJTIwJTNEJTIwYm5iLm9wdGltLkFkYW0obW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QwLjAwMSUyQyUyMG9wdGltX2JpdHMlM0Q4KSUwQSUwQSUyMyUyMG92ZXJyaWRlJTIwdGhlJTIwcGFyYW1ldGVyJTIwbW9kZWwuZmMxLndlaWdodCUyMG5vdyUyMHVzZXMlMjAzMi1iaXQlMjBBZGFtJTBBbW5nLm92ZXJyaWRlX2NvbmZpZyhtb2RlbC5mYzEud2VpZ2h0JTJDJTIwJTIyb3B0aW1fYml0cyUyMiUyQyUyMDMyKQ==",highlighted:`model = model.cuda()
<span class="hljs-comment"># use 8-bit optimizer states for all parameters</span>
adam = bnb.optim.Adam(model.parameters(), lr=<span class="hljs-number">0.001</span>, optim_bits=<span class="hljs-number">8</span>)

<span class="hljs-comment"># override the parameter model.fc1.weight now uses 32-bit Adam</span>
mng.override_config(model.fc1.weight, <span class="hljs-string">&quot;optim_bits&quot;</span>, <span class="hljs-number">32</span>)`,wrap:!1}}),I=new E({props:{code:"bW5nLm92ZXJyaWRlX2NvbmZpZyglNUJtb2RlbC5zcGVjaWFsLndlaWdodCUyQyUyMG1vZGVsLmFsc29fc3BlY2lhbC53ZWlnaHQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXlfdmFsdWVfZGljdCUyMCUzRCU3Qidpc19zcGFyc2UnJTNBJTIwVHJ1ZSUyQyUyMCdsciclM0ElMjAxZS01JTJDJTIwJ2JldGFzJyUzRCgwLjklMkMlMjAwLjk4KSU3RCk=",highlighted:`mng.override_config([model.special.weight, model.also_special.weight],
                    key_value_dict ={<span class="hljs-string">&#x27;is_sparse&#x27;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&#x27;lr&#x27;</span>: <span class="hljs-number">1e-5</span>, <span class="hljs-string">&#x27;betas&#x27;</span>=(<span class="hljs-number">0.9</span>, <span class="hljs-number">0.98</span>)})`,wrap:!1}}),A=new E({props:{code:"Y2xhc3MlMjBNeU1vZHVsZSh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwZGVmJTIwX19pbml0X18oZF9pbiUyQyUyMGRfb3V0KSUzQSUwQSUyMCUyMCUyMCUyMHN1cGVyKE15TW9kdWxlJTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKGRfaW4lMkMlMjBkX291dCklMEElMjAlMjAlMjAlMjAlMjMlMjBvcHRpbWl6YXRpb24lMjB3aWxsJTIwaGFwcGVuJTIwaW4lMjAzMi1iaXQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjMlMjBsZWFybmluZyUyMHJhdGUlMjB3aWxsJTIwYmUlMjBzZXQlMjB0byUyMDAuMDAwMSUyMGluZGVwZW5kZW50JTIwb2YlMjB0aGUlMjBtYWluJTIwbGVhcm5pbmclMjByYXRlJTBBJTIwJTIwJTIwJTIwY29uZmlnJTIwJTNEJTIwJTdCJ29wdGltX2JpdHMnJTNBJTIwMzIlMkMlMjAnbHInJTIwJTNBJTIwMC4wMDAxJTdEJTBBJTIwJTIwJTIwJTIwR2xvYmFsT3B0aW1NYW5hZ2VyLmdldF9pbnN0YW5jZSgpLnJlZ2lzdGVyX21vZHVsZV9vdmVycmlkZShzZWxmJTJDJTIwJ3dlaWdodCclMkMlMjBjb25maWcpJTBB",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModule</span>(torch.nn.Module):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">d_in, d_out</span>):
    <span class="hljs-built_in">super</span>(MyModule, self).__init__()
    self.linear = torch.nn.Linear(d_in, d_out)
    <span class="hljs-comment"># optimization will happen in 32-bit and</span>
    <span class="hljs-comment"># learning rate will be set to 0.0001 independent of the main learning rate</span>
    config = {<span class="hljs-string">&#x27;optim_bits&#x27;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&#x27;lr&#x27;</span> : <span class="hljs-number">0.0001</span>}
    GlobalOptimManager.get_instance().register_module_override(self, <span class="hljs-string">&#x27;weight&#x27;</span>, config)
`,wrap:!1}}),B=new fe({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),H=new Fe({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/optimizers.mdx"}}),{c(){u=n("meta"),X=a(),Q=n("p"),R=a(),r(f.$$.fragment),V=a(),T=n("p"),T.textContent=Je,N=a(),J=n("p"),J.textContent=je,P=a(),y=n("blockquote"),y.innerHTML=ge,K=a(),j=n("p"),j.innerHTML=Ue,O=a(),r(g.$$.fragment),q=a(),U=n("p"),U.textContent=$e,D=a(),$=n("p"),$.innerHTML=Ge,ee=a(),r(G.$$.fragment),te=a(),v=n("p"),v.innerHTML=ve,se=a(),r(Z.$$.fragment),le=a(),r(k.$$.fragment),ae=a(),_=n("p"),_.innerHTML=Ze,ie=a(),z=n("ol"),z.innerHTML=ke,ne=a(),r(x.$$.fragment),me=a(),h=n("ol"),h.innerHTML=_e,pe=a(),w=n("blockquote"),w.innerHTML=ze,re=a(),r(W.$$.fragment),oe=a(),C=n("p"),C.innerHTML=xe,de=a(),r(I.$$.fragment),be=a(),L=n("p"),L.innerHTML=We,ce=a(),r(A.$$.fragment),Me=a(),r(B.$$.fragment),ue=a(),Y=n("p"),Y.innerHTML=Ce,ye=a(),r(H.$$.fragment),he=a(),F=n("p"),this.h()},l(e){const t=Ee("svelte-u9bgzb",document.head);u=m(t,"META",{name:!0,content:!0}),t.forEach(s),X=i(e),Q=m(e,"P",{}),Ie(Q).forEach(s),R=i(e),o(f.$$.fragment,e),V=i(e),T=m(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-7xifi0"&&(T.textContent=Je),N=i(e),J=m(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-anq6iu"&&(J.textContent=je),P=i(e),y=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-1n1g6xz"&&(y.innerHTML=ge),K=i(e),j=m(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-42uda"&&(j.innerHTML=Ue),O=i(e),o(g.$$.fragment,e),q=i(e),U=m(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1swxts3"&&(U.textContent=$e),D=i(e),$=m(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-swi3zx"&&($.innerHTML=Ge),ee=i(e),o(G.$$.fragment,e),te=i(e),v=m(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-198tc99"&&(v.innerHTML=ve),se=i(e),o(Z.$$.fragment,e),le=i(e),o(k.$$.fragment,e),ae=i(e),_=m(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-t6ql1m"&&(_.innerHTML=Ze),ie=i(e),z=m(e,"OL",{"data-svelte-h":!0}),p(z)!=="svelte-1revex8"&&(z.innerHTML=ke),ne=i(e),o(x.$$.fragment,e),me=i(e),h=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(h)!=="svelte-127zgse"&&(h.innerHTML=_e),pe=i(e),w=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-pqrln3"&&(w.innerHTML=ze),re=i(e),o(W.$$.fragment,e),oe=i(e),C=m(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-kxfpon"&&(C.innerHTML=xe),de=i(e),o(I.$$.fragment,e),be=i(e),L=m(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-sha7g0"&&(L.innerHTML=We),ce=i(e),o(A.$$.fragment,e),Me=i(e),o(B.$$.fragment,e),ue=i(e),Y=m(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1er8qov"&&(Y.innerHTML=Ce),ye=i(e),o(H.$$.fragment,e),he=i(e),F=m(e,"P",{}),Ie(F).forEach(s),this.h()},h(){S(u,"name","hf:doc:metadata"),S(u,"content",Xe),S(y,"class","warning"),S(h,"start","2"),S(w,"class","tip")},m(e,t){Qe(document.head,u),l(e,X,t),l(e,Q,t),l(e,R,t),d(f,e,t),l(e,V,t),l(e,T,t),l(e,N,t),l(e,J,t),l(e,P,t),l(e,y,t),l(e,K,t),l(e,j,t),l(e,O,t),d(g,e,t),l(e,q,t),l(e,U,t),l(e,D,t),l(e,$,t),l(e,ee,t),d(G,e,t),l(e,te,t),l(e,v,t),l(e,se,t),d(Z,e,t),l(e,le,t),d(k,e,t),l(e,ae,t),l(e,_,t),l(e,ie,t),l(e,z,t),l(e,ne,t),d(x,e,t),l(e,me,t),l(e,h,t),l(e,pe,t),l(e,w,t),l(e,re,t),d(W,e,t),l(e,oe,t),l(e,C,t),l(e,de,t),d(I,e,t),l(e,be,t),l(e,L,t),l(e,ce,t),d(A,e,t),l(e,Me,t),d(B,e,t),l(e,ue,t),l(e,Y,t),l(e,ye,t),d(H,e,t),l(e,he,t),l(e,F,t),we=!0},p:Ae,i(e){we||(b(f.$$.fragment,e),b(g.$$.fragment,e),b(G.$$.fragment,e),b(Z.$$.fragment,e),b(k.$$.fragment,e),b(x.$$.fragment,e),b(W.$$.fragment,e),b(I.$$.fragment,e),b(A.$$.fragment,e),b(B.$$.fragment,e),b(H.$$.fragment,e),we=!0)},o(e){c(f.$$.fragment,e),c(g.$$.fragment,e),c(G.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(x.$$.fragment,e),c(W.$$.fragment,e),c(I.$$.fragment,e),c(A.$$.fragment,e),c(B.$$.fragment,e),c(H.$$.fragment,e),we=!1},d(e){e&&(s(X),s(Q),s(R),s(V),s(T),s(N),s(J),s(P),s(y),s(K),s(j),s(O),s(q),s(U),s(D),s($),s(ee),s(te),s(v),s(se),s(le),s(ae),s(_),s(ie),s(z),s(ne),s(me),s(h),s(pe),s(w),s(re),s(oe),s(C),s(de),s(be),s(L),s(ce),s(Me),s(ue),s(Y),s(ye),s(he),s(F)),s(u),M(f,e),M(g,e),M(G,e),M(Z,e),M(k,e),M(x,e),M(W,e),M(I,e),M(A,e),M(B,e),M(H,e)}}}const Xe='{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[{"title":"Optimize unstable parameters","local":"optimize-unstable-parameters","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Re(Te){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ye{constructor(u){super(),He(this,u,Re,Se,Le,{})}}export{Oe as component};
