import{s as Xe,n as Ye,o as ze}from"../chunks/scheduler.852ec091.js";import{S as Ne,i as We,g as i,s as l,r as p,A as De,h as o,f as a,c as s,j as Pe,u as d,x as r,k as z,y as Ve,a as n,v as f,d as m,t as c,w as u}from"../chunks/index.28275fd3.js";import{C as P}from"../chunks/CodeBlock.c866bcf2.js";import{H as Ce,E as Oe}from"../chunks/getInferenceSnippets.4c9a2b57.js";function Ke($e){let b,N,X,W,g,D,w,Be='FSDP-QLoRA combines data parallelism (FSDP enables sharding model parameters, optimizer states, and gradients across GPUs), 4-bit quantization, and LoRA to train LLMs up to 70B parameters on a dual 24GB GPU system. This technique was released by <a href="https://www.answer.ai/posts/2024-03-06-fsdp-qlora" rel="nofollow">Answer.AI</a> in collaboration with bitsandbytes to make training LLMs more efficient and accessible for everyone.',V,T,je="This guide provides a brief guide on how bitsandbytes supports storing quantized weights to enable FSDP-QLoRA, and how to run training with the Hugging Face libraries.",O,h,ve='<p>Other changes required for bitsandbytes to support FSDP-QLoRA, such as reconstructing the weights from the quantization metadata and preventing quantizing already quantized weights when they’re moved from a CPU to GPU, are documented in this <a href="https://github.com/bitsandbytes-foundation/bitsandbytes/pull/970" rel="nofollow">Pull Request</a> and described in the <a href="https://www.answer.ai/posts/2024-03-14-fsdp-qlora-deep-dive" rel="nofollow">Enabling 70B Finetuning on Consumer GPUs</a> blog post. We highly recommend reading these resources for a better understanding of FSDP-QLoRA!</p>',K,J,ee,U,Le='FSDP only supports sharding float data types which can be problematic because quantized weights are typically stored as integer data types (uint8). bitsandbytes doesn’t have this problem because it uses <code>StoreChar</code> to read and write quantized weights regardless of the data type storage. This makes it simple to add a <code>quant_storage</code> parameter to the <a href="/docs/bitsandbytes/main/en/reference/nn/linear4bit#bitsandbytes.nn.Linear4bit">Linear4bit</a> and <a href="/docs/bitsandbytes/main/en/reference/nn/linear4bit#bitsandbytes.nn.Params4bit">Params4bit</a> classes and set it to <code>torch.uint8</code> to maintain backward compatibility with the codebase. With the <code>quant_storage</code> parameter, you can select any of the FSDP supported data types to shard <a href="/docs/bitsandbytes/main/en/reference/nn/linear4bit#bitsandbytes.nn.Linear4bit">Linear4bit</a> with such as bfloat16, float16 or float32.',te,_,Fe='You’ll typically access and configure this option from <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> by setting the <code>bnb_4bit_quant_storage</code> parameter. It is very <strong>important</strong> the <code>quant_storage</code> data type matches the data types used throughout the model because FSDP can only wrap layers and modules that have the <em>same floating data type</em>. Making sure the data types are aligned will ensure the model is correctly sharded.',ae,y,Ae="<p>The <code>compute_dtype</code> is the data type used for computation inside the CUDA kernel, where the 4-bit quantized weights are unpacked from the data type in <code>quant_storage</code> and dequantized to <code>compute_dtype</code>. We recommend using torch.bfloat16 (if available on your hardware) for better numerical stability.</p>",ne,C,le,$,Re='Check out this <a href="https://hf.co/docs/peft/main/en/accelerate/fsdp#use-peft-qlora-and-fsdp-for-finetuning-large-models-on-multiple-gpus" rel="nofollow">section</a> of the PEFT documentation for the config file and training code to run FSDP-QLoRA training.',se,B,ie,M,Ze='<p>FSDP is a distributed training framework that needs to be launched as a distributed training job with a library like <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> or <a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>. The launch command provided in this section uses Accelerate to launch the training script.</p>',oe,j,qe='bitsandbytes is deeply integrated with the Hugging Face ecosystem, making it easy to use with libraries like <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a>, <a href="https://hf.co/docs/peft" rel="nofollow">PEFT</a>, and <a href="https://hf.co/docs/trl" rel="nofollow">TRL</a>.',re,v,Qe='PEFT provides a configuration file (<a href="https://github.com/huggingface/peft/blob/main/examples/sft/configs/fsdp_config_qlora.yaml" rel="nofollow">fsdp_config_qlora.yaml</a>), launch command (<a href="https://github.com/huggingface/peft/blob/main/examples/sft/run_peft_qlora_fsdp.sh" rel="nofollow">run_peft_qlora_fsdp.sh</a>), and training script (<a href="https://github.com/huggingface/peft/blob/main/examples/sft/train.py" rel="nofollow">train.py</a>) for running FSDP-QLoRA. To learn more, check out the <a href="https://huggingface.co/docs/peft/main/en/accelerate/fsdp#use-peft-qlora-and-fsdp-for-finetuning-large-models-on-multiple-gpus" rel="nofollow">Use PEFT QLoRA and FSDP for finetuning large models on multiple GPUs</a> documentation. This section briefly covers the steps to run FSDP-QLoRA training.',pe,L,ke="Before you begin, make sure you have the latest libraries installed.",de,F,fe,A,Ee='The important change that enables FSDP-QLoRA training is the <code>bnb_4bit_quant_storage</code> parameter in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. This allows you to set the storage data type of the quantized weights to a float data type.',me,R,ce,Z,Ge='Pass the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> to a model to set it up for FSDP-QLoRA. You should set the <code>torch_dtype</code> parameter to match <code>bnb_4bit_quant_storage</code> so that the <a href="/docs/bitsandbytes/main/en/reference/nn/linear4bit#bitsandbytes.nn.Linear4bit">Linear4bit</a> layers are wrapped identically to the <code>Linear</code> layers. If the storage types do not match, then each <a href="/docs/bitsandbytes/main/en/reference/nn/linear4bit#bitsandbytes.nn.Linear4bit">Linear4bit</a> layer is wrapped individually.',ue,q,be,Q,He="Configure the <code>~peft.LoraConfig</code> class for QLoRA training by setting <code>target_modules=&quot;all-linear&quot;</code>.",he,k,ye,E,Ie='Now you can pass everything to the <a href="https://huggingface.co/docs/trl/main/en/sft_trainer#trl.SFTTrainer" rel="nofollow">SFTTrainer</a> for training.',Me,G,ge,H,we,I,Se="To learn more about FSDP and QLoRA, check out the following resources:",Te,S,xe='<li>The <a href="https://github.com/AnswerDotAI/fsdp_qlora" rel="nofollow">AnswerDotAI/fsdp_qlora</a> repository.</li> <li>The introductory <a href="https://www.answer.ai/posts/2024-03-06-fsdp-qlora.html" rel="nofollow">You can now train a 70b language model at home</a> blog post by Answer.AI.</li> <li>For an introduction to FSDP, read the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api" rel="nofollow">Introducing PyTorch Fully Sharded Data Parallel (FSDP) API</a> blog post.</li> <li>For more details about QLoRA, take a look at the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li>',Je,x,Ue,Y,_e;return g=new Ce({props:{title:"FSDP-QLoRA",local:"fsdp-qlora",headingTag:"h1"}}),J=new Ce({props:{title:"Quantized data storage",local:"quantized-data-storage",headingTag:"h2"}}),C=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3N0b3JhZ2UlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03MGIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig, AutoModelForCausalLM

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_quant_storage=torch.bfloat16,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-2-70b&quot;</span>,
    quantization_config=bnb_config,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),B=new Ce({props:{title:"Training",local:"training",headingTag:"h2"}}),F=new P({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVzJTIwYWNjZWxlcmF0ZSUyMHRyYW5zZm9ybWVycyUyMHBlZnQlMjB0cmw=",highlighted:"pip install -U bitsandbytes accelerate transformers peft trl",wrap:!1}}),R=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3N0b3JhZ2UlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_storage=torch.bfloat16,
)`,wrap:!1}}),q=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItNzBiJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-2-70b&quot;</span>,
    quantization_config=bnb_config,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),k=new P({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlMjJhbGwtbGluZWFyJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
)`,wrap:!1}}),G=new P({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmd1bWVudHMlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

trainer = SFTTrainer(
    model=model,
    train_dataset=dataset,
    peft_config=peft_config,
    processing_class=tokenizer,
    args=training_arguments,
)
trainer.train()`,wrap:!1}}),H=new Ce({props:{title:"Resources",local:"resources",headingTag:"h2"}}),x=new Oe({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/fsdp_qlora.md"}}),{c(){b=i("meta"),N=l(),X=i("p"),W=l(),p(g.$$.fragment),D=l(),w=i("p"),w.innerHTML=Be,V=l(),T=i("p"),T.textContent=je,O=l(),h=i("blockquote"),h.innerHTML=ve,K=l(),p(J.$$.fragment),ee=l(),U=i("p"),U.innerHTML=Le,te=l(),_=i("p"),_.innerHTML=Fe,ae=l(),y=i("blockquote"),y.innerHTML=Ae,ne=l(),p(C.$$.fragment),le=l(),$=i("p"),$.innerHTML=Re,se=l(),p(B.$$.fragment),ie=l(),M=i("blockquote"),M.innerHTML=Ze,oe=l(),j=i("p"),j.innerHTML=qe,re=l(),v=i("p"),v.innerHTML=Qe,pe=l(),L=i("p"),L.textContent=ke,de=l(),p(F.$$.fragment),fe=l(),A=i("p"),A.innerHTML=Ee,me=l(),p(R.$$.fragment),ce=l(),Z=i("p"),Z.innerHTML=Ge,ue=l(),p(q.$$.fragment),be=l(),Q=i("p"),Q.innerHTML=He,he=l(),p(k.$$.fragment),ye=l(),E=i("p"),E.innerHTML=Ie,Me=l(),p(G.$$.fragment),ge=l(),p(H.$$.fragment),we=l(),I=i("p"),I.textContent=Se,Te=l(),S=i("ul"),S.innerHTML=xe,Je=l(),p(x.$$.fragment),Ue=l(),Y=i("p"),this.h()},l(e){const t=De("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(a),N=s(e),X=o(e,"P",{}),Pe(X).forEach(a),W=s(e),d(g.$$.fragment,e),D=s(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-5l5q4j"&&(w.innerHTML=Be),V=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1naqdkg"&&(T.textContent=je),O=s(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1bablpl"&&(h.innerHTML=ve),K=s(e),d(J.$$.fragment,e),ee=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1m8vuap"&&(U.innerHTML=Le),te=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-2kgr0m"&&(_.innerHTML=Fe),ae=s(e),y=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-5h53j4"&&(y.innerHTML=Ae),ne=s(e),d(C.$$.fragment,e),le=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1mcsrsf"&&($.innerHTML=Re),se=s(e),d(B.$$.fragment,e),ie=s(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1nwuwp3"&&(M.innerHTML=Ze),oe=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-11niy1x"&&(j.innerHTML=qe),re=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-eapz72"&&(v.innerHTML=Qe),pe=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1x35k4g"&&(L.textContent=ke),de=s(e),d(F.$$.fragment,e),fe=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-2os12x"&&(A.innerHTML=Ee),me=s(e),d(R.$$.fragment,e),ce=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-yo0tm4"&&(Z.innerHTML=Ge),ue=s(e),d(q.$$.fragment,e),be=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1c6aae"&&(Q.innerHTML=He),he=s(e),d(k.$$.fragment,e),ye=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1yk5yum"&&(E.innerHTML=Ie),Me=s(e),d(G.$$.fragment,e),ge=s(e),d(H.$$.fragment,e),we=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ijbsql"&&(I.textContent=Se),Te=s(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-47gauf"&&(S.innerHTML=xe),Je=s(e),d(x.$$.fragment,e),Ue=s(e),Y=o(e,"P",{}),Pe(Y).forEach(a),this.h()},h(){z(b,"name","hf:doc:metadata"),z(b,"content",et),z(h,"class","tip"),z(y,"class","tip"),z(M,"class","tip")},m(e,t){Ve(document.head,b),n(e,N,t),n(e,X,t),n(e,W,t),f(g,e,t),n(e,D,t),n(e,w,t),n(e,V,t),n(e,T,t),n(e,O,t),n(e,h,t),n(e,K,t),f(J,e,t),n(e,ee,t),n(e,U,t),n(e,te,t),n(e,_,t),n(e,ae,t),n(e,y,t),n(e,ne,t),f(C,e,t),n(e,le,t),n(e,$,t),n(e,se,t),f(B,e,t),n(e,ie,t),n(e,M,t),n(e,oe,t),n(e,j,t),n(e,re,t),n(e,v,t),n(e,pe,t),n(e,L,t),n(e,de,t),f(F,e,t),n(e,fe,t),n(e,A,t),n(e,me,t),f(R,e,t),n(e,ce,t),n(e,Z,t),n(e,ue,t),f(q,e,t),n(e,be,t),n(e,Q,t),n(e,he,t),f(k,e,t),n(e,ye,t),n(e,E,t),n(e,Me,t),f(G,e,t),n(e,ge,t),f(H,e,t),n(e,we,t),n(e,I,t),n(e,Te,t),n(e,S,t),n(e,Je,t),f(x,e,t),n(e,Ue,t),n(e,Y,t),_e=!0},p:Ye,i(e){_e||(m(g.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(B.$$.fragment,e),m(F.$$.fragment,e),m(R.$$.fragment,e),m(q.$$.fragment,e),m(k.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(x.$$.fragment,e),_e=!0)},o(e){c(g.$$.fragment,e),c(J.$$.fragment,e),c(C.$$.fragment,e),c(B.$$.fragment,e),c(F.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(H.$$.fragment,e),c(x.$$.fragment,e),_e=!1},d(e){e&&(a(N),a(X),a(W),a(D),a(w),a(V),a(T),a(O),a(h),a(K),a(ee),a(U),a(te),a(_),a(ae),a(y),a(ne),a(le),a($),a(se),a(ie),a(M),a(oe),a(j),a(re),a(v),a(pe),a(L),a(de),a(fe),a(A),a(me),a(ce),a(Z),a(ue),a(be),a(Q),a(he),a(ye),a(E),a(Me),a(ge),a(we),a(I),a(Te),a(S),a(Je),a(Ue),a(Y)),a(b),u(g,e),u(J,e),u(C,e),u(B,e),u(F,e),u(R,e),u(q,e),u(k,e),u(G,e),u(H,e),u(x,e)}}}const et='{"title":"FSDP-QLoRA","local":"fsdp-qlora","sections":[{"title":"Quantized data storage","local":"quantized-data-storage","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function tt($e){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Ne{constructor(b){super(),We(this,b,tt,Ke,Xe,{})}}export{it as component};
