import{s as Ms,o as ns}from"../chunks/scheduler.b108d059.js";import{S as as,i as es,g as e,s as n,r as J,A as js,h as j,f as t,c as a,j as ss,u as y,x as i,k as ts,y as is,a as M,v as o,d as T,t as p,w as c,m as Js,n as ys}from"../chunks/index.008de539.js";import{T as os}from"../chunks/Tip.aeb15ab7.js";import{C as vl}from"../chunks/CodeBlock.7b00c886.js";import{H as u,E as Ts}from"../chunks/getInferenceSnippets.88a504ef.js";function ps(O){let U;return{c(){U=Js("Never expose sensitive operations directly through function calls. Always implement proper validation and authorization checks.")},l(w){U=ys(w,"Never expose sensitive operations directly through function calls. Always implement proper validation and authorization checks.")},m(w,r){M(w,U,r)},d(w){w&&t(U)}}}function cs(O){let U,w,r,ll,A,sl,C,Wl="Function calling is a powerful capability that enables Large Language Models (LLMs) to interact with your code and external systems in a structured way. Instead of just generating text responses, LLMs can understand when to call specific functions and provide the necessary parameters to execute real-world actions.",tl,m,Ml,h,kl="The process follows these steps:",nl,d,$l='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hugs/function-callin.png" alt="Function Calling"/>',al,g,Xl="This cycle can continue as needed, allowing for complex multi-step interactions between the application and the LLM.",el,q,jl,f,xl="Function calling is useful for many practical applications, such as:",il,b,Sl="<li>Data Retrieval: Converting natural language queries into API calls to fetch data (e.g., “Show me my recent orders” triggers a database query)</li> <li>Action Execution: Transforming user requests into specific function calls (e.g., “Schedule a meeting” becomes a calendar API call)</li> <li>Computation Tasks: Handling mathematical or logical operations through dedicated functions (e.g., calculating compound interest or statistical analysis)</li> <li>Data Processing Pipelines: Chaining multiple function calls together (e.g., fetching data → parsing → transformation → storage)</li> <li>UI/UX Integration: Triggering interface updates based on user interactions (e.g., updating map markers or displaying charts)</li>",Jl,B,yl,E,Rl="Tools are the primary way to define callable functions for your LLM. Each tool requires:",ol,N,_l="<li>A unique name</li> <li>A clear description</li> <li>A JSON schema defining the expected parameters</li>",Tl,Z,Vl="Here’s an example that defines weather-related functions:",pl,Q,cl,G,zl="The model will analyze the user’s request and generate a structured call to the appropriate function with the correct parameters.",Ul,v,wl,W,Fl="For better type safety and validation, you can use Pydantic models to define your function schemas. This approach provides:",ul,k,Yl="<li>Runtime type checking</li> <li>Automatic validation</li> <li>Better IDE support</li> <li>Clear documentation through Python types</li>",Il,$,Hl="Here’s how to use Pydantic models for function calling:",rl,X,Al,x,Ll="This will return a JSON object that matches your schema, making it easy to parse and use in your application.",Cl,S,ml,R,hl,_,Dl="LLMs can orchestrate multiple function calls to complete complex tasks:",dl,V,gl,z,ql,F,Pl="Always validate function calls before execution:",fl,Y,bl,H,Bl,L,Kl="<li><p><strong>Function Design</strong></p> <ul><li>Keep function names clear and specific</li> <li>Use detailed descriptions for functions and parameters</li> <li>Include parameter constraints (min/max values, enums, etc.)</li></ul></li> <li><p><strong>Error Handling</strong></p> <ul><li>Validate all function inputs</li> <li>Implement proper error handling for failed function calls</li> <li>Consider retry logic for transient failures</li></ul></li> <li><p><strong>Security</strong></p> <ul><li>Validate and sanitize all inputs before execution</li> <li>Implement rate limiting and access controls</li> <li>Consider function call permissions based on user context</li></ul></li>",El,I,Nl,D,Ol='For more information about basic inference capabilities, see our <a href="./inference">Inference Guide</a>.',Zl,P,Ql,K,Gl;return A=new u({props:{title:"Function Calling",local:"function-calling",headingTag:"h1"}}),m=new u({props:{title:"How Function Calling Works",local:"how-function-calling-works",headingTag:"h2"}}),q=new u({props:{title:"Example Use Cases",local:"example-use-cases",headingTag:"h2"}}),B=new u({props:{title:"Using Tools (Function Definitions)",local:"using-tools-function-definitions",headingTag:"h2"}}),Q=new vl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:8080&quot;</span>) <span class="hljs-comment"># Replace with your HUGS host</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about values. Ask for clarification if needed.&quot;</span>,
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
    },
]

tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use&quot;</span>,
                    },
                    <span class="hljs-string">&quot;num_days&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
            },
        },
    }
]

response = client.chat_completion(
    messages=messages,
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function)
<span class="hljs-comment"># ChatCompletionOutputFunctionDefinition(arguments={&#x27;format&#x27;: &#x27;celsius&#x27;, &#x27;location&#x27;: &#x27;San Francisco, CA&#x27;, &#x27;num_days&#x27;: 3}, name=&#x27;get_n_day_weather_forecast&#x27;, description=None)</span>`,wrap:!1}}),v=new u({props:{title:"Using Pydantic Models for structured outputs",local:"using-pydantic-models-for-structured-outputs",headingTag:"h2"}}),X=new vl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, Field
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ParkObservation</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span> = Field(..., description=<span class="hljs-string">&quot;Where the observation took place&quot;</span>)
    activity: <span class="hljs-built_in">str</span> = Field(..., description=<span class="hljs-string">&quot;What activity was being done&quot;</span>)
    animals_seen: <span class="hljs-built_in">int</span> = Field(..., description=<span class="hljs-string">&quot;Number of animals spotted&quot;</span>, ge=<span class="hljs-number">1</span>, le=<span class="hljs-number">5</span>)
    animals: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>] = Field(..., description=<span class="hljs-string">&quot;List of animals observed&quot;</span>)


client = InferenceClient(<span class="hljs-string">&quot;http://localhost:8080&quot;</span>)  <span class="hljs-comment"># Replace with your HUGS host</span>
response_format = {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: ParkObservation.model_json_schema()}


messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy, a cat and a raccoon during my bike ride in the park.&quot;</span>,
    },
]


response = client.chat_completion(
    messages=messages,
    response_format=response_format,
    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.content)
<span class="hljs-comment"># {   &quot;activity&quot;: &quot;bike ride&quot;,</span>
<span class="hljs-comment">#     &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],</span>
<span class="hljs-comment">#     &quot;animals_seen&quot;: 3,</span>
<span class="hljs-comment">#     &quot;location&quot;: &quot;the park&quot;</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),S=new u({props:{title:"Advanced Usage Patterns",local:"advanced-usage-patterns",headingTag:"h2"}}),R=new u({props:{title:"Chaining Function Calls",local:"chaining-function-calls",headingTag:"h3"}}),V=new vl({props:{code:"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",highlighted:`tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;search_products&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Search product catalog&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;query&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
                    <span class="hljs-string">&quot;category&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;electronics&quot;</span>, <span class="hljs-string">&quot;clothing&quot;</span>, <span class="hljs-string">&quot;books&quot;</span>]}
                }
            }
        }
    },
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;create_order&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Create a new order&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;product_id&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
                    <span class="hljs-string">&quot;quantity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>}
                }
            }
        }
    }
]`,wrap:!1}}),z=new u({props:{title:"Error Handling and Execution",local:"error-handling-and-execution",headingTag:"h3"}}),Y=new vl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_n_day_weather_forecast</span>(<span class="hljs-params">location, <span class="hljs-built_in">format</span>, num_days</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&#x27;{&quot;temperature&quot;: 70, &quot;condition&quot;: &quot;sunny&quot;}&#x27;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_tool_call</span>(<span class="hljs-params">tool_call</span>):
    <span class="hljs-keyword">try</span>:
        args = tool_call.function.arguments
        <span class="hljs-comment"># Validate required parameters</span>
        <span class="hljs-keyword">if</span> tool_call.function.name == <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>:
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">all</span>(k <span class="hljs-keyword">in</span> args <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>]):
                <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Missing required parameters&quot;</span>)
            <span class="hljs-comment"># Only pass arguments that match the function&#x27;s parameters</span>
            valid_args = {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> args.items() 
                         <span class="hljs-keyword">if</span> k <span class="hljs-keyword">in</span> get_n_day_weather_forecast.__code__.co_varnames}
            <span class="hljs-keyword">return</span> get_n_day_weather_forecast(**valid_args)
    <span class="hljs-keyword">except</span> json.JSONDecodeError:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;Invalid function arguments&quot;</span>}
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e)}

res = handle_tool_call(response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(res)
<span class="hljs-comment"># {&quot;temperature&quot;: 70, &quot;condition&quot;: &quot;sunny&quot;}</span>`,wrap:!1}}),H=new u({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),I=new os({props:{$$slots:{default:[ps]},$$scope:{ctx:O}}}),P=new Ts({props:{source:"https://github.com/huggingface/hugs-docs/blob/main/docs/source/guides/function-calling.mdx"}}),{c(){U=e("meta"),w=n(),r=e("p"),ll=n(),J(A.$$.fragment),sl=n(),C=e("p"),C.textContent=Wl,tl=n(),J(m.$$.fragment),Ml=n(),h=e("p"),h.textContent=kl,nl=n(),d=e("p"),d.innerHTML=$l,al=n(),g=e("p"),g.textContent=Xl,el=n(),J(q.$$.fragment),jl=n(),f=e("p"),f.textContent=xl,il=n(),b=e("ol"),b.innerHTML=Sl,Jl=n(),J(B.$$.fragment),yl=n(),E=e("p"),E.textContent=Rl,ol=n(),N=e("ul"),N.innerHTML=_l,Tl=n(),Z=e("p"),Z.textContent=Vl,pl=n(),J(Q.$$.fragment),cl=n(),G=e("p"),G.textContent=zl,Ul=n(),J(v.$$.fragment),wl=n(),W=e("p"),W.textContent=Fl,ul=n(),k=e("ul"),k.innerHTML=Yl,Il=n(),$=e("p"),$.textContent=Hl,rl=n(),J(X.$$.fragment),Al=n(),x=e("p"),x.textContent=Ll,Cl=n(),J(S.$$.fragment),ml=n(),J(R.$$.fragment),hl=n(),_=e("p"),_.textContent=Dl,dl=n(),J(V.$$.fragment),gl=n(),J(z.$$.fragment),ql=n(),F=e("p"),F.textContent=Pl,fl=n(),J(Y.$$.fragment),bl=n(),J(H.$$.fragment),Bl=n(),L=e("ol"),L.innerHTML=Kl,El=n(),J(I.$$.fragment),Nl=n(),D=e("p"),D.innerHTML=Ol,Zl=n(),J(P.$$.fragment),Ql=n(),K=e("p"),this.h()},l(l){const s=js("svelte-u9bgzb",document.head);U=j(s,"META",{name:!0,content:!0}),s.forEach(t),w=a(l),r=j(l,"P",{}),ss(r).forEach(t),ll=a(l),y(A.$$.fragment,l),sl=a(l),C=j(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-15huis7"&&(C.textContent=Wl),tl=a(l),y(m.$$.fragment,l),Ml=a(l),h=j(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1rrrtaa"&&(h.textContent=kl),nl=a(l),d=j(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-fne95t"&&(d.innerHTML=$l),al=a(l),g=j(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1tjbzpp"&&(g.textContent=Xl),el=a(l),y(q.$$.fragment,l),jl=a(l),f=j(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1hiz435"&&(f.textContent=xl),il=a(l),b=j(l,"OL",{"data-svelte-h":!0}),i(b)!=="svelte-1wathun"&&(b.innerHTML=Sl),Jl=a(l),y(B.$$.fragment,l),yl=a(l),E=j(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1w03otm"&&(E.textContent=Rl),ol=a(l),N=j(l,"UL",{"data-svelte-h":!0}),i(N)!=="svelte-2pa3zj"&&(N.innerHTML=_l),Tl=a(l),Z=j(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1aw33qr"&&(Z.textContent=Vl),pl=a(l),y(Q.$$.fragment,l),cl=a(l),G=j(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-5g0859"&&(G.textContent=zl),Ul=a(l),y(v.$$.fragment,l),wl=a(l),W=j(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-15x3fl0"&&(W.textContent=Fl),ul=a(l),k=j(l,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-omrx96"&&(k.innerHTML=Yl),Il=a(l),$=j(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1ue1wtf"&&($.textContent=Hl),rl=a(l),y(X.$$.fragment,l),Al=a(l),x=j(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-2q30t8"&&(x.textContent=Ll),Cl=a(l),y(S.$$.fragment,l),ml=a(l),y(R.$$.fragment,l),hl=a(l),_=j(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-13n96xh"&&(_.textContent=Dl),dl=a(l),y(V.$$.fragment,l),gl=a(l),y(z.$$.fragment,l),ql=a(l),F=j(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-iikcp9"&&(F.textContent=Pl),fl=a(l),y(Y.$$.fragment,l),bl=a(l),y(H.$$.fragment,l),Bl=a(l),L=j(l,"OL",{"data-svelte-h":!0}),i(L)!=="svelte-c0no2m"&&(L.innerHTML=Kl),El=a(l),y(I.$$.fragment,l),Nl=a(l),D=j(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-4qqawb"&&(D.innerHTML=Ol),Zl=a(l),y(P.$$.fragment,l),Ql=a(l),K=j(l,"P",{}),ss(K).forEach(t),this.h()},h(){ts(U,"name","hf:doc:metadata"),ts(U,"content",Us)},m(l,s){is(document.head,U),M(l,w,s),M(l,r,s),M(l,ll,s),o(A,l,s),M(l,sl,s),M(l,C,s),M(l,tl,s),o(m,l,s),M(l,Ml,s),M(l,h,s),M(l,nl,s),M(l,d,s),M(l,al,s),M(l,g,s),M(l,el,s),o(q,l,s),M(l,jl,s),M(l,f,s),M(l,il,s),M(l,b,s),M(l,Jl,s),o(B,l,s),M(l,yl,s),M(l,E,s),M(l,ol,s),M(l,N,s),M(l,Tl,s),M(l,Z,s),M(l,pl,s),o(Q,l,s),M(l,cl,s),M(l,G,s),M(l,Ul,s),o(v,l,s),M(l,wl,s),M(l,W,s),M(l,ul,s),M(l,k,s),M(l,Il,s),M(l,$,s),M(l,rl,s),o(X,l,s),M(l,Al,s),M(l,x,s),M(l,Cl,s),o(S,l,s),M(l,ml,s),o(R,l,s),M(l,hl,s),M(l,_,s),M(l,dl,s),o(V,l,s),M(l,gl,s),o(z,l,s),M(l,ql,s),M(l,F,s),M(l,fl,s),o(Y,l,s),M(l,bl,s),o(H,l,s),M(l,Bl,s),M(l,L,s),M(l,El,s),o(I,l,s),M(l,Nl,s),M(l,D,s),M(l,Zl,s),o(P,l,s),M(l,Ql,s),M(l,K,s),Gl=!0},p(l,[s]){const ls={};s&2&&(ls.$$scope={dirty:s,ctx:l}),I.$set(ls)},i(l){Gl||(T(A.$$.fragment,l),T(m.$$.fragment,l),T(q.$$.fragment,l),T(B.$$.fragment,l),T(Q.$$.fragment,l),T(v.$$.fragment,l),T(X.$$.fragment,l),T(S.$$.fragment,l),T(R.$$.fragment,l),T(V.$$.fragment,l),T(z.$$.fragment,l),T(Y.$$.fragment,l),T(H.$$.fragment,l),T(I.$$.fragment,l),T(P.$$.fragment,l),Gl=!0)},o(l){p(A.$$.fragment,l),p(m.$$.fragment,l),p(q.$$.fragment,l),p(B.$$.fragment,l),p(Q.$$.fragment,l),p(v.$$.fragment,l),p(X.$$.fragment,l),p(S.$$.fragment,l),p(R.$$.fragment,l),p(V.$$.fragment,l),p(z.$$.fragment,l),p(Y.$$.fragment,l),p(H.$$.fragment,l),p(I.$$.fragment,l),p(P.$$.fragment,l),Gl=!1},d(l){l&&(t(w),t(r),t(ll),t(sl),t(C),t(tl),t(Ml),t(h),t(nl),t(d),t(al),t(g),t(el),t(jl),t(f),t(il),t(b),t(Jl),t(yl),t(E),t(ol),t(N),t(Tl),t(Z),t(pl),t(cl),t(G),t(Ul),t(wl),t(W),t(ul),t(k),t(Il),t($),t(rl),t(Al),t(x),t(Cl),t(ml),t(hl),t(_),t(dl),t(gl),t(ql),t(F),t(fl),t(bl),t(Bl),t(L),t(El),t(Nl),t(D),t(Zl),t(Ql),t(K)),t(U),c(A,l),c(m,l),c(q,l),c(B,l),c(Q,l),c(v,l),c(X,l),c(S,l),c(R,l),c(V,l),c(z,l),c(Y,l),c(H,l),c(I,l),c(P,l)}}}const Us='{"title":"Function Calling","local":"function-calling","sections":[{"title":"How Function Calling Works","local":"how-function-calling-works","sections":[],"depth":2},{"title":"Example Use Cases","local":"example-use-cases","sections":[],"depth":2},{"title":"Using Tools (Function Definitions)","local":"using-tools-function-definitions","sections":[],"depth":2},{"title":"Using Pydantic Models for structured outputs","local":"using-pydantic-models-for-structured-outputs","sections":[],"depth":2},{"title":"Advanced Usage Patterns","local":"advanced-usage-patterns","sections":[{"title":"Chaining Function Calls","local":"chaining-function-calls","sections":[],"depth":3},{"title":"Error Handling and Execution","local":"error-handling-and-execution","sections":[],"depth":3}],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[],"depth":2}],"depth":1}';function ws(O){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends as{constructor(U){super(),es(this,U,ws,cs,Ms,{})}}export{ms as component};
