import{s as ss,f as ls,n as as,o as is}from"../chunks/scheduler.f6319a2a.js";import{S as os,i as ps,g as i,s,r as M,A as Ms,h as o,f as l,c as a,j as ns,u as r,x as p,k as T,y as rs,a as n,v as u,d as c,t as y,w as d}from"../chunks/index.85aa684c.js";import{C as w}from"../chunks/CodeBlock.3400fc53.js";import{D as us}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as J,E as cs}from"../chunks/getInferenceSnippets.0233181f.js";function ys(Dl){let m,ot,at,pt,C,Mt,f,rt,h,Pl='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',ut,x,ct,B,Kl='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',yt,v,Ol="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",dt,k,en="Code is just a better way to express actions on a computer. It has better:",Jt,Z,tn="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",wt,W,ln='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Tt,nt,nn,mt,G,sn="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",ht,$,bt,A,an="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",Ut,V,on="This is inherently risky, LLM-generated code could be harmful to your environment.",It,E,pn="Malicious code execution can occur in several ways:",jt,R,Mn=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,gt,N,rn='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',Ct,S,un="So you need to be very mindful of security.",ft,_,cn="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",xt,Q,yn="We advise you to keep in mind that no solution will be 100% safe.",Bt,st,dn,vt,H,kt,Y,Jn=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,Zt,q,wn="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",Wt,X,Tn="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",Gt,z,mn="You could try these safeguards as follows:",$t,L,At,F,hn=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,Vt,b,bn="<p>It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.</p> <p>For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.</p> <p>Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.</p>",Et,D,Un=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,Rt,P,Nt,K,In="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",St,O,jn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="Sandbox approaches comparison"/>',_t,ee,gn=`<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code>, <code>executor_type=&quot;modal&quot;</code>, or
<code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>`,Qt,te,Cn="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",Ht,le,Yt,ne,qt,se,fn='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Xt,ae,zt,ie,Lt,oe,xn="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",Ft,pe,Dt,U,Bn=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Pt,Me,vn=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,Kt,re,kn="This is illustrated in the figure below.",Ot,I,Zn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',el,ue,Wn=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,tl,ce,ll,ye,Gn="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",nl,de,$n="Here is how to do it:",sl,Je,al,we,il,Te,ol,me,An='<li>Create a Modal account at <a href="https://modal.com/signup" rel="nofollow">modal.com</a></li> <li>Install the required packages:</li>',pl,he,Ml,be,rl,Ue,Vn="We provide a simple way to use a Modal Sandbox: simply add <code>executor_type=&quot;modal&quot;</code> to the agent initialization, as follows:",ul,Ie,cl,j,En=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Modal sandbox is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,yl,je,Rn="The agent state and generated code from the <code>InferenceClientModel</code> are sent to a Modal sandbox, which can securely execute code inside them.",dl,ge,Jl,Ce,wl,fe,Nn='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',Tl,xe,ml,Be,hl,ve,Sn="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",bl,ke,Ul,g,_n=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Il,Ze,jl,We,Qn="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",gl,Ge,Hn="Here is how to setup the a Dockerfile:",Cl,$e,fl,Ae,Yn="Create a sandbox manager to run code:",xl,Ve,Bl,Ee,vl,Re,qn=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,kl,Ne,Xn='The <code>WasmExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',Zl,Se,Wl,_e,zn='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',Gl,Qe,$l,He,Ln="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",Al,Ye,Vl,qe,El,Xe,Fn="These key practices apply to both E2B and Docker sandboxes:",Rl,ze,Dn="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",Nl,Le,Pn="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Sl,Fe,_l,De,Kn="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",Ql,Pe,Hl,Ke,On="<li><strong>Pros</strong>: <ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>",Yl,Oe,ql,et,es="<li><strong>Pros</strong>:<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>",Xl,tt,ts="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",zl,lt,Ll,it,Fl;return C=new J({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),f=new us({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),x=new J({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),$=new J({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),H=new J({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),L=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),P=new J({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),le=new J({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),ne=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ae=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),ie=new J({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),pe=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZTJiJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),ce=new J({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),Je=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),we=new J({props:{title:"Modal setup",local:"modal-setup",headingTag:"h3"}}),Te=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),he=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbW9kYWwlNUQn",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[modal]&#x27;</span>',wrap:!1}}),be=new J({props:{title:"Running your agent in Modal: quick start",local:"running-your-agent-in-modal-quick-start",headingTag:"h4"}}),Ie=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIybW9kYWwlMjIpJTIwYXMlMjBhZ2VudCUzQSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjA0MnRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;modal&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;What is the 42th Fibonacci number?&quot;</span>)`,wrap:!1}}),ge=new J({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),Ce=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),xe=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Be=new J({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),ke=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZG9ja2VyJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Ze=new J({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),$e=new w({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Ve=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),Ee=new J({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),Se=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Qe=new J({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),Ye=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),qe=new J({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),Fe=new J({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),Pe=new J({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),Oe=new J({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),lt=new cs({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){m=i("meta"),ot=s(),at=i("p"),pt=s(),M(C.$$.fragment),Mt=s(),M(f.$$.fragment),rt=s(),h=i("blockquote"),h.innerHTML=Pl,ut=s(),M(x.$$.fragment),ct=s(),B=i("p"),B.innerHTML=Kl,yt=s(),v=i("p"),v.textContent=Ol,dt=s(),k=i("p"),k.textContent=en,Jt=s(),Z=i("ul"),Z.innerHTML=tn,wt=s(),W=i("p"),W.innerHTML=ln,Tt=s(),nt=i("img"),mt=s(),G=i("p"),G.textContent=sn,ht=s(),M($.$$.fragment),bt=s(),A=i("p"),A.innerHTML=an,Ut=s(),V=i("p"),V.textContent=on,It=s(),E=i("p"),E.textContent=pn,jt=s(),R=i("ul"),R.innerHTML=Mn,gt=s(),N=i("p"),N.innerHTML=rn,Ct=s(),S=i("p"),S.textContent=un,ft=s(),_=i("p"),_.textContent=cn,xt=s(),Q=i("p"),Q.textContent=yn,Bt=s(),st=i("img"),vt=s(),M(H.$$.fragment),kt=s(),Y=i("p"),Y.innerHTML=Jn,Zt=s(),q=i("p"),q.textContent=wn,Wt=s(),X=i("ul"),X.innerHTML=Tn,Gt=s(),z=i("p"),z.textContent=mn,$t=s(),M(L.$$.fragment),At=s(),F=i("p"),F.textContent=hn,Vt=s(),b=i("blockquote"),b.innerHTML=bn,Et=s(),D=i("p"),D.textContent=Un,Rt=s(),M(P.$$.fragment),Nt=s(),K=i("p"),K.textContent=In,St=s(),O=i("p"),O.innerHTML=jn,_t=s(),ee=i("ol"),ee.innerHTML=gn,Qt=s(),te=i("p"),te.textContent=Cn,Ht=s(),M(le.$$.fragment),Yt=s(),M(ne.$$.fragment),qt=s(),se=i("ol"),se.innerHTML=fn,Xt=s(),M(ae.$$.fragment),zt=s(),M(ie.$$.fragment),Lt=s(),oe=i("p"),oe.innerHTML=xn,Ft=s(),M(pe.$$.fragment),Dt=s(),U=i("blockquote"),U.innerHTML=Bn,Pt=s(),Me=i("p"),Me.innerHTML=vn,Kt=s(),re=i("p"),re.textContent=kn,Ot=s(),I=i("p"),I.innerHTML=Zn,el=s(),ue=i("p"),ue.innerHTML=Wn,tl=s(),M(ce.$$.fragment),ll=s(),ye=i("p"),ye.textContent=Gn,nl=s(),de=i("p"),de.textContent=$n,sl=s(),M(Je.$$.fragment),al=s(),M(we.$$.fragment),il=s(),M(Te.$$.fragment),ol=s(),me=i("ol"),me.innerHTML=An,pl=s(),M(he.$$.fragment),Ml=s(),M(be.$$.fragment),rl=s(),Ue=i("p"),Ue.innerHTML=Vn,ul=s(),M(Ie.$$.fragment),cl=s(),j=i("blockquote"),j.innerHTML=En,yl=s(),je=i("p"),je.innerHTML=Rn,dl=s(),M(ge.$$.fragment),Jl=s(),M(Ce.$$.fragment),wl=s(),fe=i("ol"),fe.innerHTML=Nn,Tl=s(),M(xe.$$.fragment),ml=s(),M(Be.$$.fragment),hl=s(),ve=i("p"),ve.innerHTML=Sn,bl=s(),M(ke.$$.fragment),Ul=s(),g=i("blockquote"),g.innerHTML=_n,Il=s(),M(Ze.$$.fragment),jl=s(),We=i("p"),We.textContent=Qn,gl=s(),Ge=i("p"),Ge.textContent=Hn,Cl=s(),M($e.$$.fragment),fl=s(),Ae=i("p"),Ae.textContent=Yn,xl=s(),M(Ve.$$.fragment),Bl=s(),M(Ee.$$.fragment),vl=s(),Re=i("p"),Re.textContent=qn,kl=s(),Ne=i("p"),Ne.innerHTML=Xn,Zl=s(),M(Se.$$.fragment),Wl=s(),_e=i("ol"),_e.innerHTML=zn,Gl=s(),M(Qe.$$.fragment),$l=s(),He=i("p"),He.innerHTML=Ln,Al=s(),M(Ye.$$.fragment),Vl=s(),M(qe.$$.fragment),El=s(),Xe=i("p"),Xe.textContent=Fn,Rl=s(),ze=i("ul"),ze.innerHTML=Dn,Nl=s(),Le=i("p"),Le.textContent=Pn,Sl=s(),M(Fe.$$.fragment),_l=s(),De=i("p"),De.textContent=Kn,Ql=s(),M(Pe.$$.fragment),Hl=s(),Ke=i("ul"),Ke.innerHTML=On,Yl=s(),M(Oe.$$.fragment),ql=s(),et=i("ul"),et.innerHTML=es,Xl=s(),tt=i("p"),tt.textContent=ts,zl=s(),M(lt.$$.fragment),Ll=s(),it=i("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(l),ot=a(e),at=o(e,"P",{}),ns(at).forEach(l),pt=a(e),r(C.$$.fragment,e),Mt=a(e),r(f.$$.fragment,e),rt=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-1eo9frz"&&(h.innerHTML=Pl),ut=a(e),r(x.$$.fragment,e),ct=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1nor5c0"&&(B.innerHTML=Kl),yt=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1b2f48c"&&(v.textContent=Ol),dt=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1jp5kiv"&&(k.textContent=en),Jt=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-a7ou7n"&&(Z.innerHTML=tn),wt=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1ugtxvn"&&(W.innerHTML=ln),Tt=a(e),nt=o(e,"IMG",{src:!0}),mt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1lbgv3o"&&(G.textContent=sn),ht=a(e),r($.$$.fragment,e),bt=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-19p3p3d"&&(A.innerHTML=an),Ut=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-y55i8i"&&(V.textContent=on),It=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-y4kupg"&&(E.textContent=pn),jt=a(e),R=o(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-1b6z7ic"&&(R.innerHTML=Mn),gt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-uopq3c"&&(N.innerHTML=rn),Ct=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-gfolx1"&&(S.textContent=un),ft=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1j1i1cv"&&(_.textContent=cn),xt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1ghwkh9"&&(Q.textContent=yn),Bt=a(e),st=o(e,"IMG",{src:!0}),vt=a(e),r(H.$$.fragment,e),kt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-845rka"&&(Y.innerHTML=Jn),Zt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-180snho"&&(q.textContent=wn),Wt=a(e),X=o(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-19qb8ke"&&(X.innerHTML=Tn),Gt=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1wz8jbt"&&(z.textContent=mn),$t=a(e),r(L.$$.fragment,e),At=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1gk7uki"&&(F.textContent=hn),Vt=a(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-620wn8"&&(b.innerHTML=bn),Et=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-whkli4"&&(D.textContent=Un),Rt=a(e),r(P.$$.fragment,e),Nt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-grnb59"&&(K.textContent=In),St=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1r04sc2"&&(O.innerHTML=jn),_t=a(e),ee=o(e,"OL",{"data-svelte-h":!0}),p(ee)!=="svelte-15n47tm"&&(ee.innerHTML=gn),Qt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1h3g1zs"&&(te.textContent=Cn),Ht=a(e),r(le.$$.fragment,e),Yt=a(e),r(ne.$$.fragment,e),qt=a(e),se=o(e,"OL",{"data-svelte-h":!0}),p(se)!=="svelte-uvtwg2"&&(se.innerHTML=fn),Xt=a(e),r(ae.$$.fragment,e),zt=a(e),r(ie.$$.fragment,e),Lt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-r3242t"&&(oe.innerHTML=xn),Ft=a(e),r(pe.$$.fragment,e),Dt=a(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1mfz8t0"&&(U.innerHTML=Bn),Pt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-jrgx8f"&&(Me.innerHTML=vn),Kt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-8sir7q"&&(re.textContent=kn),Ot=a(e),I=o(e,"P",{align:!0,"data-svelte-h":!0}),p(I)!=="svelte-11rtdvt"&&(I.innerHTML=Zn),el=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-ofpo9r"&&(ue.innerHTML=Wn),tl=a(e),r(ce.$$.fragment,e),ll=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-geglm0"&&(ye.textContent=Gn),nl=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1iycphr"&&(de.textContent=$n),sl=a(e),r(Je.$$.fragment,e),al=a(e),r(we.$$.fragment,e),il=a(e),r(Te.$$.fragment,e),ol=a(e),me=o(e,"OL",{"data-svelte-h":!0}),p(me)!=="svelte-18yk2df"&&(me.innerHTML=An),pl=a(e),r(he.$$.fragment,e),Ml=a(e),r(be.$$.fragment,e),rl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-fv88x1"&&(Ue.innerHTML=Vn),ul=a(e),r(Ie.$$.fragment,e),cl=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-tfrjt3"&&(j.innerHTML=En),yl=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1tt8eoy"&&(je.innerHTML=Rn),dl=a(e),r(ge.$$.fragment,e),Jl=a(e),r(Ce.$$.fragment,e),wl=a(e),fe=o(e,"OL",{"data-svelte-h":!0}),p(fe)!=="svelte-19h0avy"&&(fe.innerHTML=Nn),Tl=a(e),r(xe.$$.fragment,e),ml=a(e),r(Be.$$.fragment,e),hl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1j9zoi1"&&(ve.innerHTML=Sn),bl=a(e),r(ke.$$.fragment,e),Ul=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-1y2mdhk"&&(g.innerHTML=_n),Il=a(e),r(Ze.$$.fragment,e),jl=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-t1it0d"&&(We.textContent=Qn),gl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1lygj8"&&(Ge.textContent=Hn),Cl=a(e),r($e.$$.fragment,e),fl=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-8mtm8c"&&(Ae.textContent=Yn),xl=a(e),r(Ve.$$.fragment,e),Bl=a(e),r(Ee.$$.fragment,e),vl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-ozg6k5"&&(Re.textContent=qn),kl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1f0518g"&&(Ne.innerHTML=Xn),Zl=a(e),r(Se.$$.fragment,e),Wl=a(e),_e=o(e,"OL",{"data-svelte-h":!0}),p(_e)!=="svelte-18eum27"&&(_e.innerHTML=zn),Gl=a(e),r(Qe.$$.fragment,e),$l=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-zmyq9d"&&(He.innerHTML=Ln),Al=a(e),r(Ye.$$.fragment,e),Vl=a(e),r(qe.$$.fragment,e),El=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-5fyo5r"&&(Xe.textContent=Fn),Rl=a(e),ze=o(e,"UL",{"data-svelte-h":!0}),p(ze)!=="svelte-162p62u"&&(ze.innerHTML=Dn),Nl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1hbg2e4"&&(Le.textContent=Pn),Sl=a(e),r(Fe.$$.fragment,e),_l=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-i4top7"&&(De.textContent=Kn),Ql=a(e),r(Pe.$$.fragment,e),Hl=a(e),Ke=o(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-8oe7h4"&&(Ke.innerHTML=On),Yl=a(e),r(Oe.$$.fragment,e),ql=a(e),et=o(e,"UL",{"data-svelte-h":!0}),p(et)!=="svelte-1nt0hab"&&(et.innerHTML=es),Xl=a(e),tt=o(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-l1ns7z"&&(tt.textContent=ts),zl=a(e),r(lt.$$.fragment,e),Ll=a(e),it=o(e,"P",{}),ns(it).forEach(l),this.h()},h(){T(m,"name","hf:doc:metadata"),T(m,"content",ds),T(h,"class","tip"),ls(nt.src,nn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||T(nt,"src",nn),ls(st.src,dn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||T(st,"src",dn),T(b,"class","warning"),T(U,"class","tip"),T(I,"align","center"),T(j,"class","tip"),T(g,"class","tip")},m(e,t){rs(document.head,m),n(e,ot,t),n(e,at,t),n(e,pt,t),u(C,e,t),n(e,Mt,t),u(f,e,t),n(e,rt,t),n(e,h,t),n(e,ut,t),u(x,e,t),n(e,ct,t),n(e,B,t),n(e,yt,t),n(e,v,t),n(e,dt,t),n(e,k,t),n(e,Jt,t),n(e,Z,t),n(e,wt,t),n(e,W,t),n(e,Tt,t),n(e,nt,t),n(e,mt,t),n(e,G,t),n(e,ht,t),u($,e,t),n(e,bt,t),n(e,A,t),n(e,Ut,t),n(e,V,t),n(e,It,t),n(e,E,t),n(e,jt,t),n(e,R,t),n(e,gt,t),n(e,N,t),n(e,Ct,t),n(e,S,t),n(e,ft,t),n(e,_,t),n(e,xt,t),n(e,Q,t),n(e,Bt,t),n(e,st,t),n(e,vt,t),u(H,e,t),n(e,kt,t),n(e,Y,t),n(e,Zt,t),n(e,q,t),n(e,Wt,t),n(e,X,t),n(e,Gt,t),n(e,z,t),n(e,$t,t),u(L,e,t),n(e,At,t),n(e,F,t),n(e,Vt,t),n(e,b,t),n(e,Et,t),n(e,D,t),n(e,Rt,t),u(P,e,t),n(e,Nt,t),n(e,K,t),n(e,St,t),n(e,O,t),n(e,_t,t),n(e,ee,t),n(e,Qt,t),n(e,te,t),n(e,Ht,t),u(le,e,t),n(e,Yt,t),u(ne,e,t),n(e,qt,t),n(e,se,t),n(e,Xt,t),u(ae,e,t),n(e,zt,t),u(ie,e,t),n(e,Lt,t),n(e,oe,t),n(e,Ft,t),u(pe,e,t),n(e,Dt,t),n(e,U,t),n(e,Pt,t),n(e,Me,t),n(e,Kt,t),n(e,re,t),n(e,Ot,t),n(e,I,t),n(e,el,t),n(e,ue,t),n(e,tl,t),u(ce,e,t),n(e,ll,t),n(e,ye,t),n(e,nl,t),n(e,de,t),n(e,sl,t),u(Je,e,t),n(e,al,t),u(we,e,t),n(e,il,t),u(Te,e,t),n(e,ol,t),n(e,me,t),n(e,pl,t),u(he,e,t),n(e,Ml,t),u(be,e,t),n(e,rl,t),n(e,Ue,t),n(e,ul,t),u(Ie,e,t),n(e,cl,t),n(e,j,t),n(e,yl,t),n(e,je,t),n(e,dl,t),u(ge,e,t),n(e,Jl,t),u(Ce,e,t),n(e,wl,t),n(e,fe,t),n(e,Tl,t),u(xe,e,t),n(e,ml,t),u(Be,e,t),n(e,hl,t),n(e,ve,t),n(e,bl,t),u(ke,e,t),n(e,Ul,t),n(e,g,t),n(e,Il,t),u(Ze,e,t),n(e,jl,t),n(e,We,t),n(e,gl,t),n(e,Ge,t),n(e,Cl,t),u($e,e,t),n(e,fl,t),n(e,Ae,t),n(e,xl,t),u(Ve,e,t),n(e,Bl,t),u(Ee,e,t),n(e,vl,t),n(e,Re,t),n(e,kl,t),n(e,Ne,t),n(e,Zl,t),u(Se,e,t),n(e,Wl,t),n(e,_e,t),n(e,Gl,t),u(Qe,e,t),n(e,$l,t),n(e,He,t),n(e,Al,t),u(Ye,e,t),n(e,Vl,t),u(qe,e,t),n(e,El,t),n(e,Xe,t),n(e,Rl,t),n(e,ze,t),n(e,Nl,t),n(e,Le,t),n(e,Sl,t),u(Fe,e,t),n(e,_l,t),n(e,De,t),n(e,Ql,t),u(Pe,e,t),n(e,Hl,t),n(e,Ke,t),n(e,Yl,t),u(Oe,e,t),n(e,ql,t),n(e,et,t),n(e,Xl,t),n(e,tt,t),n(e,zl,t),u(lt,e,t),n(e,Ll,t),n(e,it,t),Fl=!0},p:as,i(e){Fl||(c(C.$$.fragment,e),c(f.$$.fragment,e),c(x.$$.fragment,e),c($.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(Ie.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(xe.$$.fragment,e),c(Be.$$.fragment,e),c(ke.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),c(Ve.$$.fragment,e),c(Ee.$$.fragment,e),c(Se.$$.fragment,e),c(Qe.$$.fragment,e),c(Ye.$$.fragment,e),c(qe.$$.fragment,e),c(Fe.$$.fragment,e),c(Pe.$$.fragment,e),c(Oe.$$.fragment,e),c(lt.$$.fragment,e),Fl=!0)},o(e){y(C.$$.fragment,e),y(f.$$.fragment,e),y(x.$$.fragment,e),y($.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(Je.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(he.$$.fragment,e),y(be.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y(Ce.$$.fragment,e),y(xe.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(Ze.$$.fragment,e),y($e.$$.fragment,e),y(Ve.$$.fragment,e),y(Ee.$$.fragment,e),y(Se.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(qe.$$.fragment,e),y(Fe.$$.fragment,e),y(Pe.$$.fragment,e),y(Oe.$$.fragment,e),y(lt.$$.fragment,e),Fl=!1},d(e){e&&(l(ot),l(at),l(pt),l(Mt),l(rt),l(h),l(ut),l(ct),l(B),l(yt),l(v),l(dt),l(k),l(Jt),l(Z),l(wt),l(W),l(Tt),l(nt),l(mt),l(G),l(ht),l(bt),l(A),l(Ut),l(V),l(It),l(E),l(jt),l(R),l(gt),l(N),l(Ct),l(S),l(ft),l(_),l(xt),l(Q),l(Bt),l(st),l(vt),l(kt),l(Y),l(Zt),l(q),l(Wt),l(X),l(Gt),l(z),l($t),l(At),l(F),l(Vt),l(b),l(Et),l(D),l(Rt),l(Nt),l(K),l(St),l(O),l(_t),l(ee),l(Qt),l(te),l(Ht),l(Yt),l(qt),l(se),l(Xt),l(zt),l(Lt),l(oe),l(Ft),l(Dt),l(U),l(Pt),l(Me),l(Kt),l(re),l(Ot),l(I),l(el),l(ue),l(tl),l(ll),l(ye),l(nl),l(de),l(sl),l(al),l(il),l(ol),l(me),l(pl),l(Ml),l(rl),l(Ue),l(ul),l(cl),l(j),l(yl),l(je),l(dl),l(Jl),l(wl),l(fe),l(Tl),l(ml),l(hl),l(ve),l(bl),l(Ul),l(g),l(Il),l(jl),l(We),l(gl),l(Ge),l(Cl),l(fl),l(Ae),l(xl),l(Bl),l(vl),l(Re),l(kl),l(Ne),l(Zl),l(Wl),l(_e),l(Gl),l($l),l(He),l(Al),l(Vl),l(El),l(Xe),l(Rl),l(ze),l(Nl),l(Le),l(Sl),l(_l),l(De),l(Ql),l(Hl),l(Ke),l(Yl),l(ql),l(et),l(Xl),l(tt),l(zl),l(Ll),l(it)),l(m),d(C,e),d(f,e),d(x,e),d($,e),d(H,e),d(L,e),d(P,e),d(le,e),d(ne,e),d(ae,e),d(ie,e),d(pe,e),d(ce,e),d(Je,e),d(we,e),d(Te,e),d(he,e),d(be,e),d(Ie,e),d(ge,e),d(Ce,e),d(xe,e),d(Be,e),d(ke,e),d(Ze,e),d($e,e),d(Ve,e),d(Ee,e),d(Se,e),d(Qe,e),d(Ye,e),d(qe,e),d(Fe,e),d(Pe,e),d(Oe,e),d(lt,e)}}}const ds='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Modal setup","local":"modal-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Modal: quick start","local":"running-your-agent-in-modal-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function Js(Dl){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends os{constructor(m){super(),ps(this,m,Js,ys,ss,{})}}export{Us as component};
