import{s as DT,n as vT,o as XT}from"../chunks/scheduler.f6319a2a.js";import{S as HT,i as zT,g as e,s as M,r as i,m as AT,A as ST,h as y,f as T,c as t,j as Ql,u as C,x as a,n as YT,k as $U,y as g,a as J,v as s,d as w,t as n,w as o}from"../chunks/index.85aa684c.js";import{C as N}from"../chunks/CodeBlock.3400fc53.js";import{D as fT}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as d,E as ET}from"../chunks/getInferenceSnippets.0233181f.js";function xT(qU){let p,rl,Ol,Zl,h,Wl,k,Al,j,LU=`एक ऐसा एजेंट बनाने में जो काम करता है और जो काम नहीं करता है, इसमें ज़मीन-आसमान का अंतर है।
हम कैसे ऐसे एजेंट्स बना सकते हैं जो बाद वाली श्रेणी में आते हैं?
इस गाइड में, हम एजेंट्स बनाने के लिए सर्वोत्तम प्रक्रियाएँ के बारे में बात करेंगे।`,Yl,V,PU='<p>यदि आप एजेंट्स बनाने में नए हैं, तो पहले <a href="../conceptual_guides/intro_agents">एजेंट्स का परिचय</a> और <a href="../guided_tour">smolagents की गाइडेड टूर</a> पढ़ना सुनिश्चित करें।</p>',Dl,F,vl,c,KU="अपने वर्कफ़्लो में एक LLM को कुछ एजेंसी देने से त्रुटियों का जोखिम होता है।",Xl,b,lT="अच्छी तरह से प्रोग्राम किए गए एजेंटिक सिस्टम में वैसे भी अच्छी एरर लॉगिंग और रीट्राई मैकेनिज्म होते हैं, जिससे LLM इंजन अपनी गलतियों को सुधारने का मौका मिलता है। लेकिन LLM त्रुटि के जोखिम को अधिकतम कम करने के लिए, आपको अपना वर्कफ़्लो सरल बनाना चाहिए!",Hl,u,UT=`आइए <a href="../conceptual_guides/intro_agents">एजेंट्स का परिचय</a> से उदाहरण पर फिर से विचार करें: एक सर्फ ट्रिप कंपनी के लिए उपयोगकर्ता प्रश्नों का उत्तर देने वाला बॉट।
एजेंट को हर बार जब एक नए सर्फ स्पॉट के बारे में पूछा जाता है तो “travel distance API” और “weather API” के लिए 2 अलग-अलग कॉल करने देने के बजाय, आप केवल एक एकीकृत टूल “return_spot_information” बना सकते हैं, एक फंक्शन जो दोनों APIs को एक साथ कॉल करता है और उनके संयोजित आउटपुट को उपयोगकर्ता को वापस करता है।`,zl,R,TT="यह लागत, देरी और त्रुटि जोखिम को कम करेगा!",Sl,B,JT="मुख्य दिशानिर्देश है: LLM कॉल्स की संख्या को जितना हो सके उतना कम करें।",fl,m,MT="इससे कुछ निष्कर्ष निकलते हैं:",El,O,tT="<li>जब भी संभव हो, दो APIs के हमारे उदाहरण की तरह 2 टूल्स को एक में समूहित करें।</li> <li>जब भी संभव हो, लॉजिक एजेंटिक निर्णयों के बजाय डिटरमिनिस्टिक फंक्शंस पर आधारित होनी चाहिए।</li>",xl,G,_l,Q,eT="याद रखें कि आपका LLM इंजन एक <em>बुद्धिमान</em> रोबोट की तरह है, जो एक कमरे में बंद है, और बाहरी दुनिया के साथ इसका एकमात्र संचार दरवाजे के नीचे से नोट्स पास करना है।",$l,r,yT="यह किसी भी ऐसी चीज के बारे में नहीं जानेगा जिसे आप स्पष्ट रूप से अपने प्रॉम्प्ट में नहीं डालते हैं।",ql,Z,aT=`इसलिए पहले अपने कार्य को बहुत स्पष्ट बनाने से शुरू करें!
चूंकि एक एजेंट LLM द्वारा संचालित होता है, आपके कार्य के निर्माण में छोटे बदलाव भी पूरी तरह से अलग परिणाम दे सकते हैं।`,Ll,W,iT="फिर, टूल के उपयोग में अपने एजेंट की ओर जानकारी के प्रवाह में सुधार करें।",Pl,A,CT="पालन करने के लिए विशेष दिशानिर्देश:",Kl,Y,sT="<li>प्रत्येक टूल को वह सब कुछ लॉग करना चाहिए (टूल की <code>forward</code> मेथड के अंदर केवल <code>print</code> स्टेटमेंट्स का उपयोग करके) जो LLM इंजन के लिए उपयोगी हो सकता है।<ul><li>विशेष रूप से, टूल एक्जीक्यूशन गलतियों पर विस्तृत लॉगिंग बहुत मदद करेगी!</li></ul></li>",lU,D,wT="उदाहरण के लिए, यहाँ एक टूल है जो लोकेशन और डेट-टाइम के आधार पर मौसम डेटा प्राप्त करता है:",UU,v,nT="पहले, यहाँ एक खराब रूप है:",TU,X,JU,H,MU,z,oT="<li><code>date_time</code> के लिए उपयोग किए जाने वाले फॉर्मेट की सटीकता का कोई उल्लेख नहीं है।</li> <li>यह स्पष्ट नहीं है कि स्थान (location) को किस प्रकार निर्दिष्ट किया जाना चाहिए।</li> <li>त्रुटियों को स्पष्ट रूप से इंगित करने के लिए कोई लॉगिंग मेकैनिज्म मौजूद नहीं है, जैसे कि स्थान गलत फॉर्मेट में होना या <code>date_time</code> का सही ढंग से फॉर्मेट न होना।</li> <li>आउटपुट फॉर्मेट समझने में कठिन है।</li>",tU,S,IT="यदि टूल कॉल विफल हो जाती है, तो मेमोरी में लॉग की गई एरर ट्रेस LLM को टूल की समस्याओं को ठीक करने के लिए रिवर्स इंजीनियरिंग में मदद कर सकती है। लेकिन इतना सारा काम LLM को ही क्यों करने देना?",eU,f,NT="इस टूल को बेहतर तरीके से बनाने का एक उदाहरण इस प्रकार हो सकता है:",yU,E,aU,x,dT="सामान्य तौर पर, अपने LLM का बोझ को कम करने के लिए, खुद से यह अच्छा सवाल पूछें: “यदि मैं नया और अनुभवहीन हूं और इस टूल का पहली बार उपयोग कर रहा हूं, तो इस टूल के साथ प्रोग्रामिंग करना और अपनी गलतियों को ठीक करना मेरे लिए कितना आसान होगा?”",iU,_,CU,$,pT="अपने एजेंट को कार्य का वर्णन करने वाले साधारण स्ट्रिंग से आगे बढ़कर कुछ अतिरिक्त ऑब्जेक्ट्स देने के लिए, आप <code>additional_args</code> का उपयोग कर सकते हैं। यह आपको किसी भी प्रकार का ऑब्जेक्ट पास करने की सुविधा देता है:",sU,q,wU,L,VT="उदाहरण के लिए, आप इस <code>additional_args</code> आर्ग्यूमेंट का उपयोग उन इमेजेज़ या स्ट्रिंग्स को पास करने के लिए कर सकते हैं जिन्हें आप चाहते हैं कि आपका एजेंट उपयोग करे।",nU,P,oU,K,IU,ll,gT=`एजेंटिक वर्कफ़्लो में, कुछ त्रुटियां वास्तविक होती हैं, जबकि कुछ अन्य त्रुटियां आपके LLM इंजन के सही तरीके से तर्क न कर पाने की वजह से होती हैं।<br/>
उदाहरण के लिए, इस ट्रेस को देखें, जहां मैंने एक <code>CodeAgent</code> से एक कार की तस्वीर बनाने के लिए कहा:`,NU,Ul,dU,Tl,hT=`उपयोगकर्ता को, एक इमेज लौटाए जाने के बजाय, उन्हें एक पाथ लौटाया जाता है।
यह सिस्टम से एक बग की तरह दिख सकता है, लेकिन वास्तव में एजेंटिक सिस्टम ने त्रुटि नहीं की: यह केवल इसलिए है कि LLM ब्रेन ने इमेज आउटपुट को एक वेरिएबल में सेव करने की गलती की।
इस प्रकार यह इमेज को फिर से एक्सेस नहीं कर सकता है सिवाय इमेज को सेव करते समय लॉग किए गए पाथ का उपयोग करके, इसलिए यह इमेज के बजाय पाथ लौटाता है।`,pU,Jl,kT="अपने एजेंट को डीबग करने का पहला कदम इस प्रकार है “एक अधिक शक्तिशाली LLM का उपयोग करें”। <code>Qwen2/5-72B-Instruct</code> जैसे विकल्प वह गलती नहीं करते।",VU,Ml,gU,tl,jT="आप कम शक्तिशाली मॉडल्स का भी उपयोग कर सकते हैं, बशर्ते आप उन्हें अधिक प्रभावी ढंग से मार्गदर्शन करें।",hU,el,FT="अपने आप को अपने मॉडल की जगह रखें: यदि आप कार्य को हल करने वाला मॉडल होते, तो क्या आप उपलब्ध जानकारी (सिस्टम प्रॉम्प्ट + कार्य निर्माण + टूल विवरण से) के साथ संघर्ष करते?",kU,yl,cT="क्या आपको कुछ अतिरिक्त स्पष्टीकरण की आवश्यकता होती?",jU,al,bT=`अतिरिक्त जानकारी प्रदान करने के लिए, हम तुरंत सिस्टम प्रॉम्प्ट को बदलने की सलाह नहीं देते हैं: डिफ़ॉल्ट सिस्टम प्रॉम्प्ट में कई समायोजन हैं जिन्हें आप तब तक नहीं बिगाड़ना चाहते जब तक आप प्रॉम्प्ट को बहुत अच्छी तरह से नहीं समझते।
अपने LLM इंजन को मार्गदर्शन करने के बेहतर तरीके हैं:`,FU,il,uT="<li>यदि यह कार्य को हल करने के बारे में है: इन सभी विवरणों को कार्य में जोड़ें। यह कार्य 100 पेज लंबा हो सकता है</li> <li>यदि यह टूल्स के उपयोग के बारे में है: आपके टूल्स की विवरण विशेषता।</li>",cU,Cl,bU,sl,RT="यदि उपरोक्त स्पष्टीकरण पर्याप्त नहीं हैं, तो आप सिस्टम प्रॉम्प्ट बदल सकते हैं।",uU,wl,BT='आइए देखें कि यह कैसे काम करता है। उदाहरण के लिए, आइए <a href="/docs/smolagents/main/hi/reference/agents#smolagents.CodeAgent">CodeAgent</a> के लिए डिफ़ॉल्ट सिस्टम प्रॉम्प्ट की जाँच करें (नीचे दिया गया वर्जन जीरो-शॉट उदाहरणों को छोड़कर छोटा किया गया है)।',RU,nl,BU,ol,mT="Here is what you get:",mU,Il,OU,Nl,OT="जैसा कि आप देख सकते हैं, <code>&quot;{{ tool.description }}&quot;</code> जैसे प्लेसहोल्डर्स हैं: इनका उपयोग एजेंट इनिशियलाइजेशन के समय टूल्स या मैनेज्ड एजेंट्स के कुछ स्वचालित रूप से जनरेट किए गए विवरणों को डालने के लिए किया जाएगा।",GU,dl,GT="इसलिए जबकि आप <code>system_prompt</code> पैरामीटर में अपने कस्टम प्रॉम्प्ट को आर्गुमेंट के रूप में पास करके इस सिस्टम प्रॉम्प्ट टेम्पलेट को ओवरराइट कर सकते हैं, आपके नए सिस्टम प्रॉम्प्ट में निम्नलिखित प्लेसहोल्डर्स होने चाहिए:",QU,I,ul,zU,pl,SU,Rl,fU,Vl,EU,Bl,QT="केवल <code>CodeAgent</code> के लिए: अधिकृत इम्पोर्ट्स की सूची डालने के लिए <code>&quot;{{authorized_imports}}&quot;</code>।",rU,gl,rT="फिर आप सिस्टम प्रॉम्प्ट को निम्नानुसार बदल सकते हैं:",ZU,hl,WU,kl,ZT='This also works with the <a href="/docs/smolagents/main/hi/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>.',AU,jl,YU,Fl,WT="हम पूरक योजना चरण के लिए एक मॉडल प्रदान करते हैं, जिसे एजेंट सामान्य क्रियाओं के चरणों के बीच नियमित रूप से चला सकता है। इस चरण में कोई टूल कॉल नहीं होती है, LLM से केवल उन तथ्यों की सूची को अपडेट करने के लिए कहा जाता है जो उसे ज्ञात हैं और इन तथ्यों के आधार पर उसे अगले कदमों के बारे में विचार करना होता है।",DU,cl,vU,bl,XU,Gl,HU;return h=new d({props:{title:"अच्छे Agents का निर्माण",local:"अचछ-agents-क-नरमण",headingTag:"h1"}}),k=new fT({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/hi/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/hi/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/hi/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/hi/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/hi/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/hi/tensorflow/building_good_agents.ipynb"}]}}),F=new d({props:{title:"सर्वश्रेष्ठ एजेंटिक सिस्टम सबसे सरल होते हैं: वर्कफ़्लो को जितना हो सके उतना सरल बनाएं",local:"सरवशरषठ-एजटक-ससटम-सबस-सरल-हत-ह-वरकफल-क-जतन-ह-सक-उतन-सरल-बनए",headingTag:"h3"}}),G=new d({props:{title:"LLM इंजन को जानकारी के प्रवाह में सुधार करें",local:"llm-इजन-क-जनकर-क-परवह-म-सधर-कर",headingTag:"h3"}}),X=new N({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRHVtbXklMjBmdW5jdGlvbiUyQyUyMHJldHVybnMlMjBhJTIwbGlzdCUyMG9mJTIwJTVCdGVtcGVyYXR1cmUlMjBpbiUyMCVDMiVCMEMlMkMlMjByaXNrJTIwb2YlMjByYWluJTIwb24lMjBhJTIwc2NhbGUlMjAwLTElMkMlMjB3YXZlJTIwaGVpZ2h0JTIwaW4lMjBtJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSZXR1cm5zJTIwZHVtbXklMjBjb29yZGluYXRlcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjMuMyUyQyUyMC00Mi4wJTVEJTBBJTBBJTQwdG9vbCUwQWRlZiUyMGdldF93ZWF0aGVyX2FwaShsb2NhdGlvbiUzQSUyMHN0ciUyQyUyMGRhdGVfdGltZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUyMHRoZSUyMHdlYXRoZXIlMjByZXBvcnQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvY2F0aW9uJTNBJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwcGxhY2UlMjB0aGF0JTIweW91JTIwd2FudCUyMHRoZSUyMHdlYXRoZXIlMjBmb3IuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTNBJTIwdGhlJTIwZGF0ZSUyMGFuZCUyMHRpbWUlMjBmb3IlMjB3aGljaCUyMHlvdSUyMHdhbnQlMjB0aGUlMjByZXBvcnQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbG9uJTJDJTIwbGF0JTIwJTNEJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklMEElMjAlMjAlMjAlMjBkYXRlX3RpbWUlMjAlM0QlMjBkYXRldGltZS5zdHJwdGltZShkYXRlX3RpbWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGdldF93ZWF0aGVyX3JlcG9ydF9hdF9jb29yZGluYXRlcygobG9uJTJDJTIwbGF0KSUyQyUyMGRhdGVfdGltZSkp",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># Dummy function, returns a list of [temperature in °C, risk of rain on a scale 0-1, wave height in m]</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_location_to_coordinates</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># Returns dummy coordinates</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),H=new d({props:{title:"यह खराब क्यों है?",local:"यह-खरब-कय-ह",headingTag:"h1"}}),E=new N({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),_=new d({props:{title:"एजेंट को अधिक तर्क (arguments) दें",local:"एजट-क-अधक-तरक-arguments-द",headingTag:"h3"}}),q=new N({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),P=new d({props:{title:"अपने एजेंट को डिबग कैसे करें",local:"अपन-एजट-क-डबग-कस-कर",headingTag:"h2"}}),K=new d({props:{title:"1. एक अधिक शक्तिशाली LLM का उपयोग करें",local:"1-एक-अधक-शकतशल-llm-क-उपयग-कर",headingTag:"h3"}}),Ul=new N({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),Ml=new d({props:{title:"2. अधिक मार्गदर्शन / अधिक जानकारी प्रदान करें",local:"2-अधक-मरगदरशन--अधक-जनकर-परदन-कर",headingTag:"h3"}}),Cl=new d({props:{title:"3. सिस्टम प्रॉम्प्ट बदलें (आमतौर पर यह सलाह नहीं दी जाती)",local:"3-ससटम-परमपट-बदल-आमतर-पर-यह-सलह-नह-द-जत",headingTag:"h3"}}),nl=new N({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),Il=new N({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you should write the code in simple Python. The code sequence must end with &#x27;&lt;end_code&gt;&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
Code:
\`\`\`py
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
\`\`\`&lt;end_code&gt;
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
Code:
\`\`\`py
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
Code:
\`\`\`py
result = 5 + 3 + 1294.678
final_answer(result)
\`\`\`&lt;end_code&gt;

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
Code:
\`\`\`py
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
\`\`\`&lt;end_code&gt;

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
Code:
\`\`\`py
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
\`\`\`&lt;end_code&gt;
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
Code:
\`\`\`py
final_answer(&quot;diminished&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.
Code:
\`\`\`py
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, search(f&quot;{city} population&quot;)
\`\`\`&lt;end_code&gt;
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
Code:
\`\`\`py
final_answer(&quot;Shanghai&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wiki\` to get the age of the pope, and confirm that with a web search.
Code:
\`\`\`py
pope_age_wiki = wiki(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
\`\`\`&lt;end_code&gt;
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
Code:
\`\`\`py
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
\`\`\`&lt;end_code&gt;

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools:
{%- for tool in tools.values() %}
- {{ tool.to_tool_calling_prompt() }}
{%- endfor %}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works similarly to calling a tool: provide the task description as the &#x27;task&#x27; argument. Since this team member is a real human, be as detailed and verbose as necessary in your task description.
You can also include any relevant variables or context using the &#x27;additional_args&#x27; argument.
Here is a list of the team members that you can call:
{%- for agent in managed_agents.values() %}
- {{ agent.name }}: {{ agent.description }}
{%- endfor %}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wiki({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wiki(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
6. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
7. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
8. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
9. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
10. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

Now Begin! If you solve the task correctly, you will receive a reward of $1,000,000.`,wrap:!1}}),pl=new N({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wudG9fdG9vbF9jYWxsaW5nX3Byb21wdCgpJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> tool <span class="hljs-keyword">in</span> tools.values() %}</span><span class="language-xml">
- </span><span class="hljs-template-variable">{{ tool.to_tool_calling_prompt() }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Vl=new N({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHNpbWlsYXJseSUyMHRvJTIwY2FsbGluZyUyMGElMjB0b29sJTNBJTIwcHJvdmlkZSUyMHRoZSUyMHRhc2slMjBkZXNjcmlwdGlvbiUyMGFzJTIwdGhlJTIwJ3Rhc2snJTIwYXJndW1lbnQuJTIwU2luY2UlMjB0aGlzJTIwdGVhbSUyMG1lbWJlciUyMGlzJTIwYSUyMHJlYWwlMjBodW1hbiUyQyUyMGJlJTIwYXMlMjBkZXRhaWxlZCUyMGFuZCUyMHZlcmJvc2UlMjBhcyUyMG5lY2Vzc2FyeSUyMGluJTIweW91ciUyMHRhc2slMjBkZXNjcmlwdGlvbi4lMEFZb3UlMjBjYW4lMjBhbHNvJTIwaW5jbHVkZSUyMGFueSUyMHJlbGV2YW50JTIwdmFyaWFibGVzJTIwb3IlMjBjb250ZXh0JTIwdXNpbmclMjB0aGUlMjAnYWRkaXRpb25hbF9hcmdzJyUyMGFyZ3VtZW50LiUwQUhlcmUlMjBpcyUyMGElMjBsaXN0JTIwb2YlMjB0aGUlMjB0ZWFtJTIwbWVtYmVycyUyMHRoYXQlMjB5b3UlMjBjYW4lMjBjYWxsJTNBJTBBJTdCJTI1LSUyMGZvciUyMGFnZW50JTIwaW4lMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCUyNSU3RCUwQS0lMjAlN0IlN0IlMjBhZ2VudC5uYW1lJTIwJTdEJTdEJTNBJTIwJTdCJTdCJTIwYWdlbnQuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works similarly <span class="hljs-keyword">to</span> calling <span class="hljs-keyword">a</span> tool: provide the task description <span class="hljs-keyword">as</span> the <span class="hljs-string">&#x27;task&#x27;</span> <span class="hljs-keyword">argument</span>. Since this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, <span class="hljs-keyword">be</span> <span class="hljs-keyword">as</span> detailed <span class="hljs-built_in">and</span> <span class="hljs-keyword">verbose</span> <span class="hljs-keyword">as</span> necessary in your task description.
You can also include any relevant variables <span class="hljs-built_in">or</span> context using the <span class="hljs-string">&#x27;additional_args&#x27;</span> <span class="hljs-keyword">argument</span>.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),hl=new N({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),jl=new d({props:{title:"4. अतिरिक्त योजना",local:"4-अतरकत-यजन",headingTag:"h3"}}),cl=new N({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwV2ViU2VhcmNoVG9vbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0QzJTIwJTIzJTIwVGhpcyUyMGlzJTIwd2hlcmUlMjB5b3UlMjBhY3RpdmF0ZSUyMHBsYW5uaW5nISUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),bl=new ET({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/hi/tutorials/building_good_agents.md"}}),{c(){p=e("meta"),rl=M(),Ol=e("p"),Zl=M(),i(h.$$.fragment),Wl=M(),i(k.$$.fragment),Al=M(),j=e("p"),j.textContent=LU,Yl=M(),V=e("blockquote"),V.innerHTML=PU,Dl=M(),i(F.$$.fragment),vl=M(),c=e("p"),c.textContent=KU,Xl=M(),b=e("p"),b.textContent=lT,Hl=M(),u=e("p"),u.innerHTML=UT,zl=M(),R=e("p"),R.textContent=TT,Sl=M(),B=e("p"),B.textContent=JT,fl=M(),m=e("p"),m.textContent=MT,El=M(),O=e("ul"),O.innerHTML=tT,xl=M(),i(G.$$.fragment),_l=M(),Q=e("p"),Q.innerHTML=eT,$l=M(),r=e("p"),r.textContent=yT,ql=M(),Z=e("p"),Z.textContent=aT,Ll=M(),W=e("p"),W.textContent=iT,Pl=M(),A=e("p"),A.textContent=CT,Kl=M(),Y=e("ul"),Y.innerHTML=sT,lU=M(),D=e("p"),D.textContent=wT,UU=M(),v=e("p"),v.textContent=nT,TU=M(),i(X.$$.fragment),JU=M(),i(H.$$.fragment),MU=M(),z=e("ul"),z.innerHTML=oT,tU=M(),S=e("p"),S.textContent=IT,eU=M(),f=e("p"),f.textContent=NT,yU=M(),i(E.$$.fragment),aU=M(),x=e("p"),x.textContent=dT,iU=M(),i(_.$$.fragment),CU=M(),$=e("p"),$.innerHTML=pT,sU=M(),i(q.$$.fragment),wU=M(),L=e("p"),L.innerHTML=VT,nU=M(),i(P.$$.fragment),oU=M(),i(K.$$.fragment),IU=M(),ll=e("p"),ll.innerHTML=gT,NU=M(),i(Ul.$$.fragment),dU=M(),Tl=e("p"),Tl.textContent=hT,pU=M(),Jl=e("p"),Jl.innerHTML=kT,VU=M(),i(Ml.$$.fragment),gU=M(),tl=e("p"),tl.textContent=jT,hU=M(),el=e("p"),el.textContent=FT,kU=M(),yl=e("p"),yl.textContent=cT,jU=M(),al=e("p"),al.textContent=bT,FU=M(),il=e("ul"),il.innerHTML=uT,cU=M(),i(Cl.$$.fragment),bU=M(),sl=e("p"),sl.textContent=RT,uU=M(),wl=e("p"),wl.innerHTML=BT,RU=M(),i(nl.$$.fragment),BU=M(),ol=e("p"),ol.textContent=mT,mU=M(),i(Il.$$.fragment),OU=M(),Nl=e("p"),Nl.innerHTML=OT,GU=M(),dl=e("p"),dl.innerHTML=GT,QU=M(),I=e("ul"),ul=e("li"),zU=AT(`टूल विवरण डालने के लिए।
	`),i(pl.$$.fragment),SU=M(),Rl=e("li"),fU=AT(`यदि कोई मैनेज्ड एजेंट्स हैं तो उनके लिए विवरण डालने के लिए।
	`),i(Vl.$$.fragment),EU=M(),Bl=e("li"),Bl.innerHTML=QT,rU=M(),gl=e("p"),gl.textContent=rT,ZU=M(),i(hl.$$.fragment),WU=M(),kl=e("p"),kl.innerHTML=ZT,AU=M(),i(jl.$$.fragment),YU=M(),Fl=e("p"),Fl.textContent=WT,DU=M(),i(cl.$$.fragment),vU=M(),i(bl.$$.fragment),XU=M(),Gl=e("p"),this.h()},l(l){const U=ST("svelte-u9bgzb",document.head);p=y(U,"META",{name:!0,content:!0}),U.forEach(T),rl=t(l),Ol=y(l,"P",{}),Ql(Ol).forEach(T),Zl=t(l),C(h.$$.fragment,l),Wl=t(l),C(k.$$.fragment,l),Al=t(l),j=y(l,"P",{"data-svelte-h":!0}),a(j)!=="svelte-1o8lw50"&&(j.textContent=LU),Yl=t(l),V=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),a(V)!=="svelte-1qkef8g"&&(V.innerHTML=PU),Dl=t(l),C(F.$$.fragment,l),vl=t(l),c=y(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-177orsq"&&(c.textContent=KU),Xl=t(l),b=y(l,"P",{"data-svelte-h":!0}),a(b)!=="svelte-kax6zy"&&(b.textContent=lT),Hl=t(l),u=y(l,"P",{"data-svelte-h":!0}),a(u)!=="svelte-t67zje"&&(u.innerHTML=UT),zl=t(l),R=y(l,"P",{"data-svelte-h":!0}),a(R)!=="svelte-2iut2j"&&(R.textContent=TT),Sl=t(l),B=y(l,"P",{"data-svelte-h":!0}),a(B)!=="svelte-1a48b8q"&&(B.textContent=JT),fl=t(l),m=y(l,"P",{"data-svelte-h":!0}),a(m)!=="svelte-11htjar"&&(m.textContent=MT),El=t(l),O=y(l,"UL",{"data-svelte-h":!0}),a(O)!=="svelte-jyuw55"&&(O.innerHTML=tT),xl=t(l),C(G.$$.fragment,l),_l=t(l),Q=y(l,"P",{"data-svelte-h":!0}),a(Q)!=="svelte-8o8rci"&&(Q.innerHTML=eT),$l=t(l),r=y(l,"P",{"data-svelte-h":!0}),a(r)!=="svelte-t07eax"&&(r.textContent=yT),ql=t(l),Z=y(l,"P",{"data-svelte-h":!0}),a(Z)!=="svelte-15m6rux"&&(Z.textContent=aT),Ll=t(l),W=y(l,"P",{"data-svelte-h":!0}),a(W)!=="svelte-1brjvda"&&(W.textContent=iT),Pl=t(l),A=y(l,"P",{"data-svelte-h":!0}),a(A)!=="svelte-2n3td0"&&(A.textContent=CT),Kl=t(l),Y=y(l,"UL",{"data-svelte-h":!0}),a(Y)!=="svelte-wwvhj4"&&(Y.innerHTML=sT),lU=t(l),D=y(l,"P",{"data-svelte-h":!0}),a(D)!=="svelte-19r5v40"&&(D.textContent=wT),UU=t(l),v=y(l,"P",{"data-svelte-h":!0}),a(v)!=="svelte-nd84y2"&&(v.textContent=nT),TU=t(l),C(X.$$.fragment,l),JU=t(l),C(H.$$.fragment,l),MU=t(l),z=y(l,"UL",{"data-svelte-h":!0}),a(z)!=="svelte-1a1bm2n"&&(z.innerHTML=oT),tU=t(l),S=y(l,"P",{"data-svelte-h":!0}),a(S)!=="svelte-qohr6v"&&(S.textContent=IT),eU=t(l),f=y(l,"P",{"data-svelte-h":!0}),a(f)!=="svelte-hqnuk9"&&(f.textContent=NT),yU=t(l),C(E.$$.fragment,l),aU=t(l),x=y(l,"P",{"data-svelte-h":!0}),a(x)!=="svelte-1wb2jbo"&&(x.textContent=dT),iU=t(l),C(_.$$.fragment,l),CU=t(l),$=y(l,"P",{"data-svelte-h":!0}),a($)!=="svelte-11a18w6"&&($.innerHTML=pT),sU=t(l),C(q.$$.fragment,l),wU=t(l),L=y(l,"P",{"data-svelte-h":!0}),a(L)!=="svelte-go2vfj"&&(L.innerHTML=VT),nU=t(l),C(P.$$.fragment,l),oU=t(l),C(K.$$.fragment,l),IU=t(l),ll=y(l,"P",{"data-svelte-h":!0}),a(ll)!=="svelte-jhbaty"&&(ll.innerHTML=gT),NU=t(l),C(Ul.$$.fragment,l),dU=t(l),Tl=y(l,"P",{"data-svelte-h":!0}),a(Tl)!=="svelte-hktzw4"&&(Tl.textContent=hT),pU=t(l),Jl=y(l,"P",{"data-svelte-h":!0}),a(Jl)!=="svelte-1esv8fe"&&(Jl.innerHTML=kT),VU=t(l),C(Ml.$$.fragment,l),gU=t(l),tl=y(l,"P",{"data-svelte-h":!0}),a(tl)!=="svelte-1g282fx"&&(tl.textContent=jT),hU=t(l),el=y(l,"P",{"data-svelte-h":!0}),a(el)!=="svelte-rqjg3t"&&(el.textContent=FT),kU=t(l),yl=y(l,"P",{"data-svelte-h":!0}),a(yl)!=="svelte-2oi4h1"&&(yl.textContent=cT),jU=t(l),al=y(l,"P",{"data-svelte-h":!0}),a(al)!=="svelte-168zzx0"&&(al.textContent=bT),FU=t(l),il=y(l,"UL",{"data-svelte-h":!0}),a(il)!=="svelte-12qphxy"&&(il.innerHTML=uT),cU=t(l),C(Cl.$$.fragment,l),bU=t(l),sl=y(l,"P",{"data-svelte-h":!0}),a(sl)!=="svelte-1cdrg1f"&&(sl.textContent=RT),uU=t(l),wl=y(l,"P",{"data-svelte-h":!0}),a(wl)!=="svelte-1kmih6t"&&(wl.innerHTML=BT),RU=t(l),C(nl.$$.fragment,l),BU=t(l),ol=y(l,"P",{"data-svelte-h":!0}),a(ol)!=="svelte-174l3zr"&&(ol.textContent=mT),mU=t(l),C(Il.$$.fragment,l),OU=t(l),Nl=y(l,"P",{"data-svelte-h":!0}),a(Nl)!=="svelte-zzikjs"&&(Nl.innerHTML=OT),GU=t(l),dl=y(l,"P",{"data-svelte-h":!0}),a(dl)!=="svelte-e52uwm"&&(dl.innerHTML=GT),QU=t(l),I=y(l,"UL",{});var ml=Ql(I);ul=y(ml,"LI",{});var xU=Ql(ul);zU=YT(xU,`टूल विवरण डालने के लिए।
	`),C(pl.$$.fragment,xU),xU.forEach(T),SU=t(ml),Rl=y(ml,"LI",{});var _U=Ql(Rl);fU=YT(_U,`यदि कोई मैनेज्ड एजेंट्स हैं तो उनके लिए विवरण डालने के लिए।
	`),C(Vl.$$.fragment,_U),_U.forEach(T),EU=t(ml),Bl=y(ml,"LI",{"data-svelte-h":!0}),a(Bl)!=="svelte-1ykdced"&&(Bl.innerHTML=QT),ml.forEach(T),rU=t(l),gl=y(l,"P",{"data-svelte-h":!0}),a(gl)!=="svelte-9jtmts"&&(gl.textContent=rT),ZU=t(l),C(hl.$$.fragment,l),WU=t(l),kl=y(l,"P",{"data-svelte-h":!0}),a(kl)!=="svelte-78xec0"&&(kl.innerHTML=ZT),AU=t(l),C(jl.$$.fragment,l),YU=t(l),Fl=y(l,"P",{"data-svelte-h":!0}),a(Fl)!=="svelte-1fs431j"&&(Fl.textContent=WT),DU=t(l),C(cl.$$.fragment,l),vU=t(l),C(bl.$$.fragment,l),XU=t(l),Gl=y(l,"P",{}),Ql(Gl).forEach(T),this.h()},h(){$U(p,"name","hf:doc:metadata"),$U(p,"content",_T),$U(V,"class","tip")},m(l,U){g(document.head,p),J(l,rl,U),J(l,Ol,U),J(l,Zl,U),s(h,l,U),J(l,Wl,U),s(k,l,U),J(l,Al,U),J(l,j,U),J(l,Yl,U),J(l,V,U),J(l,Dl,U),s(F,l,U),J(l,vl,U),J(l,c,U),J(l,Xl,U),J(l,b,U),J(l,Hl,U),J(l,u,U),J(l,zl,U),J(l,R,U),J(l,Sl,U),J(l,B,U),J(l,fl,U),J(l,m,U),J(l,El,U),J(l,O,U),J(l,xl,U),s(G,l,U),J(l,_l,U),J(l,Q,U),J(l,$l,U),J(l,r,U),J(l,ql,U),J(l,Z,U),J(l,Ll,U),J(l,W,U),J(l,Pl,U),J(l,A,U),J(l,Kl,U),J(l,Y,U),J(l,lU,U),J(l,D,U),J(l,UU,U),J(l,v,U),J(l,TU,U),s(X,l,U),J(l,JU,U),s(H,l,U),J(l,MU,U),J(l,z,U),J(l,tU,U),J(l,S,U),J(l,eU,U),J(l,f,U),J(l,yU,U),s(E,l,U),J(l,aU,U),J(l,x,U),J(l,iU,U),s(_,l,U),J(l,CU,U),J(l,$,U),J(l,sU,U),s(q,l,U),J(l,wU,U),J(l,L,U),J(l,nU,U),s(P,l,U),J(l,oU,U),s(K,l,U),J(l,IU,U),J(l,ll,U),J(l,NU,U),s(Ul,l,U),J(l,dU,U),J(l,Tl,U),J(l,pU,U),J(l,Jl,U),J(l,VU,U),s(Ml,l,U),J(l,gU,U),J(l,tl,U),J(l,hU,U),J(l,el,U),J(l,kU,U),J(l,yl,U),J(l,jU,U),J(l,al,U),J(l,FU,U),J(l,il,U),J(l,cU,U),s(Cl,l,U),J(l,bU,U),J(l,sl,U),J(l,uU,U),J(l,wl,U),J(l,RU,U),s(nl,l,U),J(l,BU,U),J(l,ol,U),J(l,mU,U),s(Il,l,U),J(l,OU,U),J(l,Nl,U),J(l,GU,U),J(l,dl,U),J(l,QU,U),J(l,I,U),g(I,ul),g(ul,zU),s(pl,ul,null),g(I,SU),g(I,Rl),g(Rl,fU),s(Vl,Rl,null),g(I,EU),g(I,Bl),J(l,rU,U),J(l,gl,U),J(l,ZU,U),s(hl,l,U),J(l,WU,U),J(l,kl,U),J(l,AU,U),s(jl,l,U),J(l,YU,U),J(l,Fl,U),J(l,DU,U),s(cl,l,U),J(l,vU,U),s(bl,l,U),J(l,XU,U),J(l,Gl,U),HU=!0},p:vT,i(l){HU||(w(h.$$.fragment,l),w(k.$$.fragment,l),w(F.$$.fragment,l),w(G.$$.fragment,l),w(X.$$.fragment,l),w(H.$$.fragment,l),w(E.$$.fragment,l),w(_.$$.fragment,l),w(q.$$.fragment,l),w(P.$$.fragment,l),w(K.$$.fragment,l),w(Ul.$$.fragment,l),w(Ml.$$.fragment,l),w(Cl.$$.fragment,l),w(nl.$$.fragment,l),w(Il.$$.fragment,l),w(pl.$$.fragment,l),w(Vl.$$.fragment,l),w(hl.$$.fragment,l),w(jl.$$.fragment,l),w(cl.$$.fragment,l),w(bl.$$.fragment,l),HU=!0)},o(l){n(h.$$.fragment,l),n(k.$$.fragment,l),n(F.$$.fragment,l),n(G.$$.fragment,l),n(X.$$.fragment,l),n(H.$$.fragment,l),n(E.$$.fragment,l),n(_.$$.fragment,l),n(q.$$.fragment,l),n(P.$$.fragment,l),n(K.$$.fragment,l),n(Ul.$$.fragment,l),n(Ml.$$.fragment,l),n(Cl.$$.fragment,l),n(nl.$$.fragment,l),n(Il.$$.fragment,l),n(pl.$$.fragment,l),n(Vl.$$.fragment,l),n(hl.$$.fragment,l),n(jl.$$.fragment,l),n(cl.$$.fragment,l),n(bl.$$.fragment,l),HU=!1},d(l){l&&(T(rl),T(Ol),T(Zl),T(Wl),T(Al),T(j),T(Yl),T(V),T(Dl),T(vl),T(c),T(Xl),T(b),T(Hl),T(u),T(zl),T(R),T(Sl),T(B),T(fl),T(m),T(El),T(O),T(xl),T(_l),T(Q),T($l),T(r),T(ql),T(Z),T(Ll),T(W),T(Pl),T(A),T(Kl),T(Y),T(lU),T(D),T(UU),T(v),T(TU),T(JU),T(MU),T(z),T(tU),T(S),T(eU),T(f),T(yU),T(aU),T(x),T(iU),T(CU),T($),T(sU),T(wU),T(L),T(nU),T(oU),T(IU),T(ll),T(NU),T(dU),T(Tl),T(pU),T(Jl),T(VU),T(gU),T(tl),T(hU),T(el),T(kU),T(yl),T(jU),T(al),T(FU),T(il),T(cU),T(bU),T(sl),T(uU),T(wl),T(RU),T(BU),T(ol),T(mU),T(OU),T(Nl),T(GU),T(dl),T(QU),T(I),T(rU),T(gl),T(ZU),T(WU),T(kl),T(AU),T(YU),T(Fl),T(DU),T(vU),T(XU),T(Gl)),T(p),o(h,l),o(k,l),o(F,l),o(G,l),o(X,l),o(H,l),o(E,l),o(_,l),o(q,l),o(P,l),o(K,l),o(Ul,l),o(Ml,l),o(Cl,l),o(nl,l),o(Il,l),o(pl),o(Vl),o(hl,l),o(jl,l),o(cl,l),o(bl,l)}}}const _T='{"title":"अच्छे Agents का निर्माण","local":"अचछ-agents-क-नरमण","sections":[{"title":"सर्वश्रेष्ठ एजेंटिक सिस्टम सबसे सरल होते हैं: वर्कफ़्लो को जितना हो सके उतना सरल बनाएं","local":"सरवशरषठ-एजटक-ससटम-सबस-सरल-हत-ह-वरकफल-क-जतन-ह-सक-उतन-सरल-बनए","sections":[],"depth":3},{"title":"LLM इंजन को जानकारी के प्रवाह में सुधार करें","local":"llm-इजन-क-जनकर-क-परवह-म-सधर-कर","sections":[],"depth":3}],"depth":1}';function $T(qU){return XT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class UJ extends HT{constructor(p){super(),zT(this,p,$T,xT,DT,{})}}export{UJ as component};
