import{s as fT,n as ST,o as zT}from"../chunks/scheduler.f00c12d3.js";import{S as ET,i as HT,g as e,s as M,r as a,m as XT,A as xT,h as y,f as T,c as t,j as rl,u as s,x as i,n as DT,k as LU,y as b,a as J,v as C,d as n,t as w,w as o}from"../chunks/index.bfa6505f.js";import{C as d}from"../chunks/CodeBlock.df38d6a7.js";import{D as _T}from"../chunks/DocNotebookDropdown.fe3efc66.js";import{H as p,E as $T}from"../chunks/getInferenceSnippets.afd9f400.js";function qT(PU){let N,Zl,Gl,Wl,g,Al,V,vl,h,KU=`성공하는 에이전트와 실패하는 에이전트 사이에는 큰 차이가 있습니다.
성공하는 에이전트는 어떻게 만들 수 있을까요?
이 가이드에서 에이전트 구축의 핵심 원칙들을 소개하겠습니다.`,Yl,c,lT='<p>에이전트 구축이 처음이라면 먼저 <a href="../conceptual_guides/intro_agents">에이전트 소개</a>와 <a href="../guided_tour">안내서</a>를 읽어보세요.</p>',Xl,k,Dl,R,UT="워크플로우에 LLM에게 어느 정도의 자율성을 부여하는 것은 오류가 발생할 위험이 있습니다.",fl,F,TT="잘 설계된 에이전트 시스템은 오류를 기록하고 다시 시도하는 기능을 통해 LLM이 자신의 실수를 교정할 수 있게 해줍니다. 그렇다고 해도 처음부터 LLM이 실수하지 않도록 워크플로우를 간단하게 만드는 것이 훨씬 효과적입니다.",Sl,j,JT=`<a href="../conceptual_guides/intro_agents">에이전트 소개</a>의 예시를 다시 살펴보겠습니다: 서핑 여행사 이용자들의 문의에 대응하는 봇입니다.
새로운 서핑 스팟에 대해 질문을 받을 때마다 에이전트가 “여행 거리 API”와 “날씨 API”에 각각 2번의 서로 다른 호출을 하도록 하는 대신, 두 API를 한 번에 호출하고 연결된 출력을 사용자에게 반환하는 함수인 “return_spot_information”이라는 하나의 통합된 도구를 만들 수 있습니다.`,zl,u,MT="이렇게 하면 비용, 지연 시간, 오류 위험을 줄일 수 있습니다!",El,m,tT="주요 지침은 다음과 같습니다: LLM 호출 횟수를 최대한 줄이세요.",Hl,B,eT="이것은 몇 가지 결론으로 이어집니다:",xl,Q,yT="<li>가능하면 언제든지 두 개의 API 예시처럼 2개의 도구를 하나로 그룹화하세요.</li> <li>가능하면 언제든지 로직은 에이전트의 결정보다는 결정론적 함수로 처리해야 합니다.</li>",_l,G,$l,O,iT="LLM은 쪽지를 통해서만 소통할 수 있는 밀폐된 방 안의 <em>똑똑한</em> 로봇이라고 생각하면 됩니다.",ql,r,aT="프롬프트에 명시하지 않으면 무슨 일이 일어났는지 전혀 알 수 없습니다.",Ll,Z,sT=`그러니까 일단 작업을 아주 명확하게 정의하는 것부터 시작하세요!
에이전트는 LLM으로 작동하기 때문에, 작업을 설명하는 방식이 조금만 달라져도 결과가 완전히 바뀔 수 있습니다.`,Pl,W,CT="그 다음엔 도구에서 에이전트로 정보가 잘 전달되도록 개선해야 합니다.",Kl,A,nT="구체적으로는 이렇게 하세요:",lU,v,wT="<li>각 도구는 LLM에게 도움이 될 만한 정보를 모두 기록해야 합니다.(도구의 <code>forward</code> 메서드 안에서 <code>print</code>문을 쓰기만 하면 됩니다.)<ul><li>특히 도구 실행 오류에 대한 자세한 정보를 기록하면 큰 도움이 됩니다!</li></ul></li>",UU,Y,oT="예를 들어 위치와 날짜-시간을 받아서 날씨 데이터를 가져오는 도구를 보겠습니다:",TU,X,dT="먼저 좋지 않은 버전입니다:",JU,D,MU,f,IT="문제점은 무엇일까요?",tU,S,NT="<li><code>date_time</code>에 사용해야 하는 형식에 대한 정확한 설명이 없습니다.</li> <li>위치를 어떻게 지정해야 하는지에 대한 세부 정보가 없습니다.</li> <li>위치가 적절한 형식이 아니거나 <code>date_time</code>이 제대로 형식화되지 않은 경우와 같은 실패 사례를 명시적으로 기록할 수 있는 로깅 메커니즘이 없습니다.</li> <li>출력 형식을 이해하기 어렵습니다.</li>",eU,z,pT="도구 호출이 실패하면 메모리에 로깅된 오류 추적이 LLM이 도구를 역설계하여 오류를 수정하는 데 도움이 될 수 있습니다. 하지만 왜 그렇게 많은 무거운 작업을 맡겨야 할까요?",yU,E,cT="이 도구를 구축하는 더 나은 방법은 다음과 같습니다:",iU,H,aU,x,bT="LLM의 부담을 덜어주려면 이런 질문을 해보세요: “만약 내가 아무것도 모르는 상태에서 이 도구를 처음 사용한다면, 실수했을 때 스스로 고치기가 얼마나 쉬울까?”",sU,_,CU,$,gT="작업을 설명하는 단순한 문자열 외에 에이전트에 추가 객체를 전달하려면 <code>additional_args</code> 매개변수를 사용하여 모든 유형의 객체를 전달할 수 있습니다:",nU,q,wU,L,VT="예를 들어, <code>additional_args</code> 매개변수를 통해 에이전트가 활용할 수 있도록 원하는 이미지나 문자열을 전달할 수 있습니다.",oU,P,dU,K,IU,ll,hT=`에이전트 워크플로우에서 발생하는 오류 중 일부는 실제 오류이고, 다른 일부는 LLM 엔진이 제대로 추론하지 못한 탓입니다.
예를 들어, 자동차 그림을 만들어 달라고 요청한 <code>CodeAgent</code>에 대한 다음 추적을 고려해보세요:`,NU,Ul,pU,Tl,kT=`사용자는 이미지가 반환되는 대신 경로가 반환되는 것을 보게 됩니다.
시스템의 버그처럼 보일 수 있지만, 실제로는 에이전트 시스템이 오류를 일으킨 것이 아닙니다: 단지 LLM이 이미지 출력을 변수에 저장하지 않는 실수를 했을 뿐입니다.
따라서 이미지를 저장하면서 로깅된 경로를 활용하는 것 외에는 이미지에 다시 접근할 수 없으므로 이미지 대신 경로를 반환합니다.`,cU,Jl,RT="따라서 에이전트를 디버깅하는 첫 번째 단계는 “더 강력한 LLM을 사용하는 것”입니다. <code>Qwen2/5-72B-Instruct</code>와 같은 대안은 그런 실수를 하지 않았을 것입니다.",bU,Ml,gU,tl,FT="더 자세하게 안내해준다면 성능이 낮은 모델도 충분히 사용할 수 있습니다.",VU,el,jT="모델의 관점에서 생각해보세요: 내가 모델이 되어서 이 작업을 해결해야 한다면, 지금 주어진 정보(시스템 프롬프트 + 작업 설명 + 도구 설명)만으로도 충분할까요?",hU,yl,uT="더 구체적인 안내가 필요할까요?",kU,il,mT="<li>지침이 항상 에이전트에게 주어져야 하는 경우(일반적으로 시스템 프롬프트가 작동한다고 이해하는 것처럼): 에이전트 초기화 시 <code>instructions</code> 매개변수 아래에 문자열로 전달할 수 있습니다.</li> <li>해결할 특정 작업에 관한 것이라면: 이 모든 세부 사항을 작업에 추가하세요. 작업은 수십 페이지처럼 매우 길 수 있습니다.</li> <li>특정 도구 사용 방법에 관한 것이라면: 해당 도구의 <code>description</code> 속성에 포함시키세요.</li>",RU,al,FU,sl,BT="위의 방법들로도 부족하다면 에이전트의 프롬프트 템플릿을 직접 수정할 수 있습니다.",jU,Cl,QT="작동 원리를 살펴보겠습니다. [CodeAgent]의 기본 프롬프트 템플릿을 예로 들어보겠습니다(제로샷 예제는 생략하고 간단히 정리했습니다).",uU,nl,mU,wl,GT="Here is what you get:",BU,ol,QU,dl,OT="보시다시피 <code>&quot;{{ tool.description }}&quot;</code>와 같은 플레이스홀더들이 있습니다. 이것들은 에이전트를 초기화할 때 도구나 관리 에이전트에 대한 설명을 자동으로 넣어주는 역할을 합니다.",GU,Il,rT="따라서 <code>system_prompt</code> 매개변수에 커스텀 프롬프트를 넣어서 기본 시스템 프롬프트 템플릿을 덮어쓸 수 있습니다. 새로운 시스템 프롬프트에는 이런 플레이스홀더들을 포함할 수 있습니다:",OU,I,ul,EU,Nl,HU,ml,xU,pl,_U,Bl,ZT="<code>CodeAgent</code>에만 해당하며, 승인된 import 목록을 삽입하려면: <code>&quot;{{authorized_imports}}&quot;</code>",rU,cl,WT="그런 다음 다음과 같이 시스템 프롬프트를 변경할 수 있습니다:",ZU,bl,WU,gl,AT="이는 <code>ToolCallingAgent</code>에서도 작동합니다.",AU,Vl,vT="하지만 일반적으로 다음과 같이 에이전트 초기화 시 <code>instructions</code> 매개변수를 전달하는 것이 더 간단합니다:",vU,hl,YU,kl,XU,Rl,YT="일반적인 작업 단계들 중간중간에 에이전트가 추가로 계획을 세우는 단계를 넣을 수 있습니다. 이때는 도구를 사용하지 않고, LLM이 현재까지 파악한 정보를 정리하고 그 정보를 토대로 앞으로의 계획을 다시 점검하게 됩니다.",DU,Fl,fU,jl,SU,Ol,zU;return g=new p({props:{title:"좋은 에이전트 구축하기",local:"building-good-agents",headingTag:"h1"}}),V=new _T({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/building_good_agents.ipynb"}]}}),k=new p({props:{title:"최고의 에이전트 시스템은 가장 단순합니다: 워크플로우를 최대한 단순하게 만드세요",local:"the-best-agentic-systems-are-the-simplest:-simplify-the-workflow-as-much-as-you-can",headingTag:"h3"}}),G=new p({props:{title:"LLM 엔진으로의 정보 흐름을 개선하세요",local:"improve-the-information-flow-to-the-llm-engine",headingTag:"h3"}}),D=new d({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUVCJThEJTk0JUVCJUFGJUI4JTIwJUVEJTk1JUE4JUVDJTg4JTk4JTJDJTIwJTVCJUVDJTg0JUFEJUVDJTk0JUE4JTIwJUVDJTk4JUE4JUVCJThGJTg0JTJDJTIwMC0xJTIwJUVDJUIyJTk5JUVCJThGJTg0JUVDJTlEJTk4JTIwJUVCJUI5JTg0JTIwJUVDJTk4JUFDJTIwJUVEJTk5JTk1JUVCJUE1JUEwJTJDJTIwJUVCJUFGJUI4JUVEJTg0JUIwJTIwJUVCJThCJUE4JUVDJTlDJTg0JTIwJUVEJThDJThDJUVCJThGJTg0JTIwJUVCJTg2JTkyJUVDJTlEJUI0JTVEJTIwJUVCJUE2JUFDJUVDJThBJUE0JUVEJThBJUI4JUVCJUE1JUJDJTIwJUVCJUIwJTk4JUVEJTk5JTk4JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRUIlOEQlOTQlRUIlQUYlQjglMjAlRUMlQTIlOEMlRUQlOTElOUMlRUIlQTUlQkMlMjAlRUIlQjAlOTglRUQlOTklOTglMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIzLjMlMkMlMjAtNDIuMCU1RCUwQSUwQSU0MHRvb2wlMEFkZWYlMjBnZXRfd2VhdGhlcl9hcGkobG9jYXRpb24lM0ElMjBzdHIlMkMlMjBkYXRlX3RpbWUlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFJldHVybnMlMjB0aGUlMjB3ZWF0aGVyJTIwcmVwb3J0LiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHBsYWNlJTIwdGhhdCUyMHlvdSUyMHdhbnQlMjB0aGUlMjB3ZWF0aGVyJTIwZm9yLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGVfdGltZSUzQSUyMHRoZSUyMGRhdGUlMjBhbmQlMjB0aW1lJTIwZm9yJTIwd2hpY2glMjB5b3UlMjB3YW50JTIwdGhlJTIwcmVwb3J0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGxvbiUyQyUyMGxhdCUyMCUzRCUyMGNvbnZlcnRfbG9jYXRpb25fdG9fY29vcmRpbmF0ZXMobG9jYXRpb24pJTBBJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTIwJTNEJTIwZGF0ZXRpbWUuc3RycHRpbWUoZGF0ZV90aW1lKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHN0cihnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoKGxvbiUyQyUyMGxhdCklMkMlMjBkYXRlX3RpbWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># 더미 함수, [섭씨 온도, 0-1 척도의 비 올 확률, 미터 단위 파도 높이] 리스트를 반환</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_location_to_coordinates</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># 더미 좌표를 반환</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),H=new d({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),_=new p({props:{title:"에이전트에 더 많은 매개변수 제공",local:"give-more-arguments-to-the-agent",headingTag:"h3"}}),q=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),P=new p({props:{title:"에이전트 디버깅 방법",local:"how-to-debug-your-agent",headingTag:"h2"}}),K=new p({props:{title:"1. 더 강력한 LLM 사용",local:"use-a-stronger-llm",headingTag:"h3"}}),Ul=new d({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),Ml=new p({props:{title:"2. 더 많은 정보나 구체적인 지침 제공",local:"provide-more-information-or-specific-instructions",headingTag:"h3"}}),al=new p({props:{title:"3. 프롬프트 템플릿 변경 (일반적으로 권장되지 않음)",local:"change-the-prompt-templates-(generally-not-advised)",headingTag:"h3"}}),nl=new d({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),ol=new d({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of Thought, Code, and Observation sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the Code sequence you should write the code in simple Python. The code sequence must be opened with &#x27;{{code_block_opening_tag}}&#x27;, and closed with &#x27;{{code_block_closing_tag}}&#x27;.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
{{code_block_opening_tag}}
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
{{code_block_closing_tag}}
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
{{code_block_opening_tag}}
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
{{code_block_closing_tag}}

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
{{code_block_opening_tag}}
result = 5 + 3 + 1294.678
final_answer(result)
{{code_block_closing_tag}}

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
{{code_block_opening_tag}}
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
{{code_block_closing_tag}}

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
{{code_block_opening_tag}}
pages = web_search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
{{code_block_closing_tag}}
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
{{code_block_opening_tag}}
pages = web_search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
{{code_block_closing_tag}}
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
{{code_block_opening_tag}}
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
{{code_block_closing_tag}}
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
{{code_block_opening_tag}}
final_answer(&quot;diminished&quot;)
{{code_block_closing_tag}}

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`web_search\` to get the population of both cities.
{{code_block_opening_tag}}
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, web_search(f&quot;{city} population&quot;)
{{code_block_closing_tag}}
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
{{code_block_opening_tag}}
final_answer(&quot;Shanghai&quot;)
{{code_block_closing_tag}}

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wikipedia_search\` to get the age of the pope, and confirm that with a web search.
{{code_block_opening_tag}}
pope_age_wiki = wikipedia_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
{{code_block_closing_tag}}
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
{{code_block_opening_tag}}
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
{{code_block_closing_tag}}

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools, behaving like regular python functions:
{{code_block_opening_tag}}
{%- for tool in tools.values() %}
{{ tool.to_code_prompt() }}
{% endfor %}
{{code_block_closing_tag}}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works similarly to calling a tool: provide the task description as the &#x27;task&#x27; argument. Since this team member is a real human, be as detailed and verbose as necessary in your task description.
You can also include any relevant variables or context using the &#x27;additional_args&#x27; argument.
Here is a list of the team members that you can call:
{{code_block_opening_tag}}
{%- for agent in managed_agents.values() %}
def {{ agent.name }}(task: str, additional_args: dict[str, Any]) -&gt; str:
    &quot;&quot;&quot;{{ agent.description }}

    Args:
        task: Long detailed description of the task.
        additional_args: Dictionary of extra inputs to pass to the managed agent, e.g. images, dataframes, or any other contextual data it may need.
    &quot;&quot;&quot;
{% endfor %}
{{code_block_closing_tag}}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;{{code_block_opening_tag}}&#x27; sequence ending with &#x27;{{code_block_closing_tag}}&#x27;, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wikipedia_search({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wikipedia_search(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. For tools WITHOUT JSON output schema: Take care to not chain too many sequential tool calls in the same code block, as their output format is unpredictable. For instance, a call to wikipedia_search without a JSON output schema has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. For tools WITH JSON output schema: You can confidently chain multiple tool calls and directly access structured output fields in the same code block! When a tool has a JSON output schema, you know exactly what fields and data types to expect, allowing you to write robust code that directly accesses the structured response (e.g., result[&#x27;field_name&#x27;]) without needing intermediate print() statements.
6. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
7. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
8. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
9. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
10. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
11. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

{%- if custom_instructions %}
{{custom_instructions}}
{%- endif %}

Now Begin!`,wrap:!1}}),Nl=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wudG9fdG9vbF9jYWxsaW5nX3Byb21wdCgpJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> tool <span class="hljs-keyword">in</span> tools.values() %}</span><span class="language-xml">
- </span><span class="hljs-template-variable">{{ tool.to_tool_calling_prompt() }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),pl=new d({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHNpbWlsYXJseSUyMHRvJTIwY2FsbGluZyUyMGElMjB0b29sJTNBJTIwcHJvdmlkZSUyMHRoZSUyMHRhc2slMjBkZXNjcmlwdGlvbiUyMGFzJTIwdGhlJTIwJ3Rhc2snJTIwYXJndW1lbnQuJTIwU2luY2UlMjB0aGlzJTIwdGVhbSUyMG1lbWJlciUyMGlzJTIwYSUyMHJlYWwlMjBodW1hbiUyQyUyMGJlJTIwYXMlMjBkZXRhaWxlZCUyMGFuZCUyMHZlcmJvc2UlMjBhcyUyMG5lY2Vzc2FyeSUyMGluJTIweW91ciUyMHRhc2slMjBkZXNjcmlwdGlvbi4lMEFZb3UlMjBjYW4lMjBhbHNvJTIwaW5jbHVkZSUyMGFueSUyMHJlbGV2YW50JTIwdmFyaWFibGVzJTIwb3IlMjBjb250ZXh0JTIwdXNpbmclMjB0aGUlMjAnYWRkaXRpb25hbF9hcmdzJyUyMGFyZ3VtZW50LiUwQUhlcmUlMjBpcyUyMGElMjBsaXN0JTIwb2YlMjB0aGUlMjB0ZWFtJTIwbWVtYmVycyUyMHRoYXQlMjB5b3UlMjBjYW4lMjBjYWxsJTNBJTBBJTdCJTI1LSUyMGZvciUyMGFnZW50JTIwaW4lMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCUyNSU3RCUwQS0lMjAlN0IlN0IlMjBhZ2VudC5uYW1lJTIwJTdEJTdEJTNBJTIwJTdCJTdCJTIwYWdlbnQuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works similarly <span class="hljs-keyword">to</span> calling <span class="hljs-keyword">a</span> tool: provide the task description <span class="hljs-keyword">as</span> the <span class="hljs-string">&#x27;task&#x27;</span> <span class="hljs-keyword">argument</span>. Since this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, <span class="hljs-keyword">be</span> <span class="hljs-keyword">as</span> detailed <span class="hljs-built_in">and</span> <span class="hljs-keyword">verbose</span> <span class="hljs-keyword">as</span> necessary in your task description.
You can also include any relevant variables <span class="hljs-built_in">or</span> context using the <span class="hljs-string">&#x27;additional_args&#x27;</span> <span class="hljs-keyword">argument</span>.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),bl=new d({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),hl=new d({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTJDJTIwaW5zdHJ1Y3Rpb25zJTNEJTIyQWx3YXlzJTIwdGFsayUyMGxpa2UlMjBhJTIwNSUyMHllYXIlMjBvbGQuJTIyKQ==",highlighted:'agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), instructions=<span class="hljs-string">&quot;Always talk like a 5 year old.&quot;</span>)',wrap:!1}}),kl=new p({props:{title:"4. 추가 계획",local:"extra-planning",headingTag:"h3"}}),Fl=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwV2ViU2VhcmNoVG9vbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCUyQyUyMGltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0QzJTIwJTIzJTIwVGhpcyUyMGlzJTIwd2hlcmUlMjB5b3UlMjBhY3RpdmF0ZSUyMHBsYW5uaW5nISUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool, image_generation_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),jl=new $T({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/ko/tutorials/building_good_agents.md"}}),{c(){N=e("meta"),Zl=M(),Gl=e("p"),Wl=M(),a(g.$$.fragment),Al=M(),a(V.$$.fragment),vl=M(),h=e("p"),h.textContent=KU,Yl=M(),c=e("blockquote"),c.innerHTML=lT,Xl=M(),a(k.$$.fragment),Dl=M(),R=e("p"),R.textContent=UT,fl=M(),F=e("p"),F.textContent=TT,Sl=M(),j=e("p"),j.innerHTML=JT,zl=M(),u=e("p"),u.textContent=MT,El=M(),m=e("p"),m.textContent=tT,Hl=M(),B=e("p"),B.textContent=eT,xl=M(),Q=e("ul"),Q.innerHTML=yT,_l=M(),a(G.$$.fragment),$l=M(),O=e("p"),O.innerHTML=iT,ql=M(),r=e("p"),r.textContent=aT,Ll=M(),Z=e("p"),Z.textContent=sT,Pl=M(),W=e("p"),W.textContent=CT,Kl=M(),A=e("p"),A.textContent=nT,lU=M(),v=e("ul"),v.innerHTML=wT,UU=M(),Y=e("p"),Y.textContent=oT,TU=M(),X=e("p"),X.textContent=dT,JU=M(),a(D.$$.fragment),MU=M(),f=e("p"),f.textContent=IT,tU=M(),S=e("ul"),S.innerHTML=NT,eU=M(),z=e("p"),z.textContent=pT,yU=M(),E=e("p"),E.textContent=cT,iU=M(),a(H.$$.fragment),aU=M(),x=e("p"),x.textContent=bT,sU=M(),a(_.$$.fragment),CU=M(),$=e("p"),$.innerHTML=gT,nU=M(),a(q.$$.fragment),wU=M(),L=e("p"),L.innerHTML=VT,oU=M(),a(P.$$.fragment),dU=M(),a(K.$$.fragment),IU=M(),ll=e("p"),ll.innerHTML=hT,NU=M(),a(Ul.$$.fragment),pU=M(),Tl=e("p"),Tl.textContent=kT,cU=M(),Jl=e("p"),Jl.innerHTML=RT,bU=M(),a(Ml.$$.fragment),gU=M(),tl=e("p"),tl.textContent=FT,VU=M(),el=e("p"),el.textContent=jT,hU=M(),yl=e("p"),yl.textContent=uT,kU=M(),il=e("ul"),il.innerHTML=mT,RU=M(),a(al.$$.fragment),FU=M(),sl=e("p"),sl.textContent=BT,jU=M(),Cl=e("p"),Cl.textContent=QT,uU=M(),a(nl.$$.fragment),mU=M(),wl=e("p"),wl.textContent=GT,BU=M(),a(ol.$$.fragment),QU=M(),dl=e("p"),dl.innerHTML=OT,GU=M(),Il=e("p"),Il.innerHTML=rT,OU=M(),I=e("ul"),ul=e("li"),EU=XT(`도구 설명을 삽입하려면:
	`),a(Nl.$$.fragment),HU=M(),ml=e("li"),xU=XT(`관리되는 에이전트가 있는 경우 해당 설명을 삽입하려면:
	`),a(pl.$$.fragment),_U=M(),Bl=e("li"),Bl.innerHTML=ZT,rU=M(),cl=e("p"),cl.textContent=WT,ZU=M(),a(bl.$$.fragment),WU=M(),gl=e("p"),gl.innerHTML=AT,AU=M(),Vl=e("p"),Vl.innerHTML=vT,vU=M(),a(hl.$$.fragment),YU=M(),a(kl.$$.fragment),XU=M(),Rl=e("p"),Rl.textContent=YT,DU=M(),a(Fl.$$.fragment),fU=M(),a(jl.$$.fragment),SU=M(),Ol=e("p"),this.h()},l(l){const U=xT("svelte-u9bgzb",document.head);N=y(U,"META",{name:!0,content:!0}),U.forEach(T),Zl=t(l),Gl=y(l,"P",{}),rl(Gl).forEach(T),Wl=t(l),s(g.$$.fragment,l),Al=t(l),s(V.$$.fragment,l),vl=t(l),h=y(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-15hjohz"&&(h.textContent=KU),Yl=t(l),c=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(c)!=="svelte-nbyvb0"&&(c.innerHTML=lT),Xl=t(l),s(k.$$.fragment,l),Dl=t(l),R=y(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-109u08a"&&(R.textContent=UT),fl=t(l),F=y(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1fryr2e"&&(F.textContent=TT),Sl=t(l),j=y(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-x0bugw"&&(j.innerHTML=JT),zl=t(l),u=y(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-4avckm"&&(u.textContent=MT),El=t(l),m=y(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1uilf4u"&&(m.textContent=tT),Hl=t(l),B=y(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-t6n5xj"&&(B.textContent=eT),xl=t(l),Q=y(l,"UL",{"data-svelte-h":!0}),i(Q)!=="svelte-40glt0"&&(Q.innerHTML=yT),_l=t(l),s(G.$$.fragment,l),$l=t(l),O=y(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-k1phh6"&&(O.innerHTML=iT),ql=t(l),r=y(l,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1oupjpg"&&(r.textContent=aT),Ll=t(l),Z=y(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1sk7dc3"&&(Z.textContent=sT),Pl=t(l),W=y(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-f7ao35"&&(W.textContent=CT),Kl=t(l),A=y(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1p0puh0"&&(A.textContent=nT),lU=t(l),v=y(l,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-o9fzjy"&&(v.innerHTML=wT),UU=t(l),Y=y(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-z7kkzl"&&(Y.textContent=oT),TU=t(l),X=y(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1414oxm"&&(X.textContent=dT),JU=t(l),s(D.$$.fragment,l),MU=t(l),f=y(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1oxdypg"&&(f.textContent=IT),tU=t(l),S=y(l,"UL",{"data-svelte-h":!0}),i(S)!=="svelte-h78796"&&(S.innerHTML=NT),eU=t(l),z=y(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-i6b4f"&&(z.textContent=pT),yU=t(l),E=y(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1owhurf"&&(E.textContent=cT),iU=t(l),s(H.$$.fragment,l),aU=t(l),x=y(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1mbzn9z"&&(x.textContent=bT),sU=t(l),s(_.$$.fragment,l),CU=t(l),$=y(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1o6f9c"&&($.innerHTML=gT),nU=t(l),s(q.$$.fragment,l),wU=t(l),L=y(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-zh66ny"&&(L.innerHTML=VT),oU=t(l),s(P.$$.fragment,l),dU=t(l),s(K.$$.fragment,l),IU=t(l),ll=y(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-16eywem"&&(ll.innerHTML=hT),NU=t(l),s(Ul.$$.fragment,l),pU=t(l),Tl=y(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-1qj7c3s"&&(Tl.textContent=kT),cU=t(l),Jl=y(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-njfepl"&&(Jl.innerHTML=RT),bU=t(l),s(Ml.$$.fragment,l),gU=t(l),tl=y(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1vb1r37"&&(tl.textContent=FT),VU=t(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-7cvb86"&&(el.textContent=jT),hU=t(l),yl=y(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-145agf6"&&(yl.textContent=uT),kU=t(l),il=y(l,"UL",{"data-svelte-h":!0}),i(il)!=="svelte-14ox1yu"&&(il.innerHTML=mT),RU=t(l),s(al.$$.fragment,l),FU=t(l),sl=y(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-2nsn4w"&&(sl.textContent=BT),jU=t(l),Cl=y(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-f1mu0l"&&(Cl.textContent=QT),uU=t(l),s(nl.$$.fragment,l),mU=t(l),wl=y(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-174l3zr"&&(wl.textContent=GT),BU=t(l),s(ol.$$.fragment,l),QU=t(l),dl=y(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-15eney5"&&(dl.innerHTML=OT),GU=t(l),Il=y(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1sjap49"&&(Il.innerHTML=rT),OU=t(l),I=y(l,"UL",{});var Ql=rl(I);ul=y(Ql,"LI",{});var $U=rl(ul);EU=DT($U,`도구 설명을 삽입하려면:
	`),s(Nl.$$.fragment,$U),$U.forEach(T),HU=t(Ql),ml=y(Ql,"LI",{});var qU=rl(ml);xU=DT(qU,`관리되는 에이전트가 있는 경우 해당 설명을 삽입하려면:
	`),s(pl.$$.fragment,qU),qU.forEach(T),_U=t(Ql),Bl=y(Ql,"LI",{"data-svelte-h":!0}),i(Bl)!=="svelte-gt7nt7"&&(Bl.innerHTML=ZT),Ql.forEach(T),rU=t(l),cl=y(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1ap4q4p"&&(cl.textContent=WT),ZU=t(l),s(bl.$$.fragment,l),WU=t(l),gl=y(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-15vz8hf"&&(gl.innerHTML=AT),AU=t(l),Vl=y(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-1nv2b58"&&(Vl.innerHTML=vT),vU=t(l),s(hl.$$.fragment,l),YU=t(l),s(kl.$$.fragment,l),XU=t(l),Rl=y(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-99er4s"&&(Rl.textContent=YT),DU=t(l),s(Fl.$$.fragment,l),fU=t(l),s(jl.$$.fragment,l),SU=t(l),Ol=y(l,"P",{}),rl(Ol).forEach(T),this.h()},h(){LU(N,"name","hf:doc:metadata"),LU(N,"content",LT),LU(c,"class","tip")},m(l,U){b(document.head,N),J(l,Zl,U),J(l,Gl,U),J(l,Wl,U),C(g,l,U),J(l,Al,U),C(V,l,U),J(l,vl,U),J(l,h,U),J(l,Yl,U),J(l,c,U),J(l,Xl,U),C(k,l,U),J(l,Dl,U),J(l,R,U),J(l,fl,U),J(l,F,U),J(l,Sl,U),J(l,j,U),J(l,zl,U),J(l,u,U),J(l,El,U),J(l,m,U),J(l,Hl,U),J(l,B,U),J(l,xl,U),J(l,Q,U),J(l,_l,U),C(G,l,U),J(l,$l,U),J(l,O,U),J(l,ql,U),J(l,r,U),J(l,Ll,U),J(l,Z,U),J(l,Pl,U),J(l,W,U),J(l,Kl,U),J(l,A,U),J(l,lU,U),J(l,v,U),J(l,UU,U),J(l,Y,U),J(l,TU,U),J(l,X,U),J(l,JU,U),C(D,l,U),J(l,MU,U),J(l,f,U),J(l,tU,U),J(l,S,U),J(l,eU,U),J(l,z,U),J(l,yU,U),J(l,E,U),J(l,iU,U),C(H,l,U),J(l,aU,U),J(l,x,U),J(l,sU,U),C(_,l,U),J(l,CU,U),J(l,$,U),J(l,nU,U),C(q,l,U),J(l,wU,U),J(l,L,U),J(l,oU,U),C(P,l,U),J(l,dU,U),C(K,l,U),J(l,IU,U),J(l,ll,U),J(l,NU,U),C(Ul,l,U),J(l,pU,U),J(l,Tl,U),J(l,cU,U),J(l,Jl,U),J(l,bU,U),C(Ml,l,U),J(l,gU,U),J(l,tl,U),J(l,VU,U),J(l,el,U),J(l,hU,U),J(l,yl,U),J(l,kU,U),J(l,il,U),J(l,RU,U),C(al,l,U),J(l,FU,U),J(l,sl,U),J(l,jU,U),J(l,Cl,U),J(l,uU,U),C(nl,l,U),J(l,mU,U),J(l,wl,U),J(l,BU,U),C(ol,l,U),J(l,QU,U),J(l,dl,U),J(l,GU,U),J(l,Il,U),J(l,OU,U),J(l,I,U),b(I,ul),b(ul,EU),C(Nl,ul,null),b(I,HU),b(I,ml),b(ml,xU),C(pl,ml,null),b(I,_U),b(I,Bl),J(l,rU,U),J(l,cl,U),J(l,ZU,U),C(bl,l,U),J(l,WU,U),J(l,gl,U),J(l,AU,U),J(l,Vl,U),J(l,vU,U),C(hl,l,U),J(l,YU,U),C(kl,l,U),J(l,XU,U),J(l,Rl,U),J(l,DU,U),C(Fl,l,U),J(l,fU,U),C(jl,l,U),J(l,SU,U),J(l,Ol,U),zU=!0},p:ST,i(l){zU||(n(g.$$.fragment,l),n(V.$$.fragment,l),n(k.$$.fragment,l),n(G.$$.fragment,l),n(D.$$.fragment,l),n(H.$$.fragment,l),n(_.$$.fragment,l),n(q.$$.fragment,l),n(P.$$.fragment,l),n(K.$$.fragment,l),n(Ul.$$.fragment,l),n(Ml.$$.fragment,l),n(al.$$.fragment,l),n(nl.$$.fragment,l),n(ol.$$.fragment,l),n(Nl.$$.fragment,l),n(pl.$$.fragment,l),n(bl.$$.fragment,l),n(hl.$$.fragment,l),n(kl.$$.fragment,l),n(Fl.$$.fragment,l),n(jl.$$.fragment,l),zU=!0)},o(l){w(g.$$.fragment,l),w(V.$$.fragment,l),w(k.$$.fragment,l),w(G.$$.fragment,l),w(D.$$.fragment,l),w(H.$$.fragment,l),w(_.$$.fragment,l),w(q.$$.fragment,l),w(P.$$.fragment,l),w(K.$$.fragment,l),w(Ul.$$.fragment,l),w(Ml.$$.fragment,l),w(al.$$.fragment,l),w(nl.$$.fragment,l),w(ol.$$.fragment,l),w(Nl.$$.fragment,l),w(pl.$$.fragment,l),w(bl.$$.fragment,l),w(hl.$$.fragment,l),w(kl.$$.fragment,l),w(Fl.$$.fragment,l),w(jl.$$.fragment,l),zU=!1},d(l){l&&(T(Zl),T(Gl),T(Wl),T(Al),T(vl),T(h),T(Yl),T(c),T(Xl),T(Dl),T(R),T(fl),T(F),T(Sl),T(j),T(zl),T(u),T(El),T(m),T(Hl),T(B),T(xl),T(Q),T(_l),T($l),T(O),T(ql),T(r),T(Ll),T(Z),T(Pl),T(W),T(Kl),T(A),T(lU),T(v),T(UU),T(Y),T(TU),T(X),T(JU),T(MU),T(f),T(tU),T(S),T(eU),T(z),T(yU),T(E),T(iU),T(aU),T(x),T(sU),T(CU),T($),T(nU),T(wU),T(L),T(oU),T(dU),T(IU),T(ll),T(NU),T(pU),T(Tl),T(cU),T(Jl),T(bU),T(gU),T(tl),T(VU),T(el),T(hU),T(yl),T(kU),T(il),T(RU),T(FU),T(sl),T(jU),T(Cl),T(uU),T(mU),T(wl),T(BU),T(QU),T(dl),T(GU),T(Il),T(OU),T(I),T(rU),T(cl),T(ZU),T(WU),T(gl),T(AU),T(Vl),T(vU),T(YU),T(XU),T(Rl),T(DU),T(fU),T(SU),T(Ol)),T(N),o(g,l),o(V,l),o(k,l),o(G,l),o(D,l),o(H,l),o(_,l),o(q,l),o(P,l),o(K,l),o(Ul,l),o(Ml,l),o(al,l),o(nl,l),o(ol,l),o(Nl),o(pl),o(bl,l),o(hl,l),o(kl,l),o(Fl,l),o(jl,l)}}}const LT='{"title":"좋은 에이전트 구축하기","local":"building-good-agents","sections":[{"title":"최고의 에이전트 시스템은 가장 단순합니다: 워크플로우를 최대한 단순하게 만드세요","local":"the-best-agentic-systems-are-the-simplest:-simplify-the-workflow-as-much-as-you-can","sections":[],"depth":3},{"title":"LLM 엔진으로의 정보 흐름을 개선하세요","local":"improve-the-information-flow-to-the-llm-engine","sections":[],"depth":3},{"title":"에이전트에 더 많은 매개변수 제공","local":"give-more-arguments-to-the-agent","sections":[],"depth":3},{"title":"에이전트 디버깅 방법","local":"how-to-debug-your-agent","sections":[{"title":"1. 더 강력한 LLM 사용","local":"use-a-stronger-llm","sections":[],"depth":3},{"title":"2. 더 많은 정보나 구체적인 지침 제공","local":"provide-more-information-or-specific-instructions","sections":[],"depth":3},{"title":"3. 프롬프트 템플릿 변경 (일반적으로 권장되지 않음)","local":"change-the-prompt-templates-(generally-not-advised)","sections":[],"depth":3},{"title":"4. 추가 계획","local":"extra-planning","sections":[],"depth":3}],"depth":2}],"depth":1}';function PT(PU){return zT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class MJ extends ET{constructor(N){super(),HT(this,N,PT,qT,fT,{})}}export{MJ as component};
