import{s as st,n as pt,o as mt}from"../chunks/scheduler.f6319a2a.js";import{S as ot,i as rt,g as s,s as i,r as o,A as Tt,h as p,f as l,c as a,j as it,u as r,x as m,k as at,y as Jt,a as n,v as T,d as J,t as u,w as c}from"../chunks/index.85aa684c.js";import{C as Le}from"../chunks/CodeBlock.3400fc53.js";import{H as f,E as ut}from"../chunks/getInferenceSnippets.74d2db76.js";function ct(We){let E,O,q,ee,h,te,N,Ze=`This page demonstrates advanced usage of the smolagents library, with a special focus on <strong>Human-in-the-Loop (HITL)</strong> approaches for interactive plan creation, user-driven plan modification, and memory preservation in agentic workflows.
The example is based on the code in <code>examples/plan_customization/plan_customization.py</code>.`,le,w,ne,C,Pe="This example teaches you how to implement Human-in-the-Loop strategies to:",ie,$,Qe="<li>Interrupt agent execution after a plan is created (using step callbacks)</li> <li>Allow users to review and modify the agent’s plan before execution (Human-in-the-Loop)</li> <li>Resume execution while preserving the agent’s memory</li> <li>Dynamically update plans based on user feedback, keeping the human in control</li>",ae,d,se,M,pe,U,Ve="The agent is configured to pause after creating a plan. This is achieved by registering a step callback for the <code>PlanningStep</code>:",me,g,oe,v,re,y,Ae="When the agent creates a plan, the callback displays it and prompts the human user to:",Te,R,Se="<li>Approve the plan</li> <li>Modify the plan</li> <li>Cancel execution</li>",Je,b,Ge="Example interaction:",ue,z,ce,x,Ye="This Human-in-the-Loop step enables a human to intervene and review or modify the plan before execution continues, and ensures that the agent’s actions align with human intent.",fe,I,Fe="If the user chooses to modify, they can edit the plan directly. The updated plan is then used for subsequent execution steps.",Ee,j,he,H,Xe="By running the agent with <code>reset=False</code>, all previous steps and memory are preserved. This allows you to resume execution after an interruption or plan modification:",Ne,B,we,_,Ce,k,De="You can inspect the agent’s memory to see all steps taken so far:",$e,L,de,W,Me,Z,qe="<li>Agent starts with a complex task</li> <li>Planning step is created and execution pauses for human review</li> <li>Human reviews and optionally modifies the plan (Human-in-the-Loop)</li> <li>Execution resumes with the approved/modified plan</li> <li>All steps are preserved for future runs, maintaining transparency and control</li>",Ue,P,ge,Q,Ke="The example includes error handling for:",ve,V,Oe="<li>User cancellation</li> <li>Plan modification errors</li> <li>Resume execution failures</li>",ye,A,Re,S,et="<li>smolagents library</li> <li>DuckDuckGoSearchTool (included with smolagents)</li> <li>InferenceClientModel (requires HuggingFace API token)</li>",be,G,ze,Y,tt="This example demonstrates:",xe,F,lt="<li>Step callback implementation for custom agent behavior</li> <li>Memory management in multi-step agents</li> <li>User interaction patterns in agentic systems</li> <li>Plan modification techniques for dynamic agent control</li> <li>Error handling in interactive agent systems</li>",Ie,je,He,X,nt='For the full code, see <a href="https://github.com/huggingface/smolagents/tree/main/examples/plan_customization" rel="nofollow"><code>examples/plan_customization</code></a>.',Be,D,_e,K,ke;return h=new f({props:{title:"Human-in-the-Loop: Customize Agent Plan Interactively",local:"human-in-the-loop-customize-agent-plan-interactively",headingTag:"h1"}}),w=new f({props:{title:"Overview",local:"overview",headingTag:"h2"}}),d=new f({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h2"}}),M=new f({props:{title:"Step Callbacks for Plan Interruption",local:"step-callbacks-for-plan-interruption",headingTag:"h3"}}),g=new Le({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0Q1JTJDJTIwJTIwJTIzJTIwUGxhbiUyMGV2ZXJ5JTIwNSUyMHN0ZXBzJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlN0JQbGFubmluZ1N0ZXAlM0ElMjBpbnRlcnJ1cHRfYWZ0ZXJfcGxhbiU3RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUwQSk=",highlighted:`agent = CodeAgent(
    model=InferenceClientModel(),
    tools=[DuckDuckGoSearchTool()],
    planning_interval=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Plan every 5 steps</span>
    step_callbacks={PlanningStep: interrupt_after_plan},
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">1</span>
)`,wrap:!1}}),v=new f({props:{title:"Human-in-the-Loop: Interactive Plan Review and Modification",local:"human-in-the-loop-interactive-plan-review-and-modification",headingTag:"h3"}}),z=new Le({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJUYwJTlGJUE0JTk2JTIwQUdFTlQlMjBQTEFOJTIwQ1JFQVRFRCUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQTEuJTIwU2VhcmNoJTIwZm9yJTIwcmVjZW50JTIwQUklMjBkZXZlbG9wbWVudHMlMEEyLiUyMEFuYWx5emUlMjB0aGUlMjB0b3AlMjByZXN1bHRzJTBBMy4lMjBTdW1tYXJpemUlMjB0aGUlMjAzJTIwbW9zdCUyMHNpZ25pZmljYW50JTIwYnJlYWt0aHJvdWdocyUwQTQuJTIwSW5jbHVkZSUyMHNvdXJjZXMlMjBmb3IlMjBlYWNoJTIwYnJlYWt0aHJvdWdoJTBBJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTBBQ2hvb3NlJTIwYW4lMjBvcHRpb24lM0ElMEExLiUyMEFwcHJvdmUlMjBwbGFuJTBBMi4lMjBNb2RpZnklMjBwbGFuJTBBMy4lMjBDYW5jZWwlMEFZb3VyJTIwY2hvaWNlJTIwKDEtMyklM0E=",highlighted:`============================================================
🤖 AGENT PLAN CREATED
============================================================
1. Search for recent AI developments
2. Analyze the top results
3. Summarize the 3 most significant breakthroughs
<span class="hljs-section">4. Include sources for each breakthrough
============================================================</span>

Choose an option:
1. Approve plan
2. Modify plan
3. Cancel
Your choice (1-3):`,wrap:!1}}),j=new f({props:{title:"Memory Preservation and Resuming Execution",local:"memory-preservation-and-resuming-execution",headingTag:"h3"}}),B=new Le({props:{code:"JTIzJTIwRmlyc3QlMjBydW4lMjAobWF5JTIwYmUlMjBpbnRlcnJ1cHRlZCklMEFhZ2VudC5ydW4odGFzayUyQyUyMHJlc2V0JTNEVHJ1ZSklMEElMEElMjMlMjBSZXN1bWUlMjB3aXRoJTIwcHJlc2VydmVkJTIwbWVtb3J5JTBBYWdlbnQucnVuKHRhc2slMkMlMjByZXNldCUzREZhbHNlKQ==",highlighted:`<span class="hljs-comment"># First run (may be interrupted)</span>
agent.run(task, reset=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Resume with preserved memory</span>
agent.run(task, reset=<span class="hljs-literal">False</span>)`,wrap:!1}}),_=new f({props:{title:"Inspecting Agent Memory",local:"inspecting-agent-memory",headingTag:"h3"}}),L=new Le({props:{code:"cHJpbnQoZiUyMkN1cnJlbnQlMjBtZW1vcnklMjBjb250YWlucyUyMCU3QmxlbihhZ2VudC5tZW1vcnkuc3RlcHMpJTdEJTIwc3RlcHMlM0ElMjIpJTBBZm9yJTIwaSUyQyUyMHN0ZXAlMjBpbiUyMGVudW1lcmF0ZShhZ2VudC5tZW1vcnkuc3RlcHMpJTNBJTBBJTIwJTIwJTIwJTIwc3RlcF90eXBlJTIwJTNEJTIwdHlwZShzdGVwKS5fX25hbWVfXyUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JpJTJCMSU3RC4lMjAlN0JzdGVwX3R5cGUlN0QlMjIp",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Current memory contains <span class="hljs-subst">{<span class="hljs-built_in">len</span>(agent.memory.steps)}</span> steps:&quot;</span>)
<span class="hljs-keyword">for</span> i, step <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(agent.memory.steps):
    step_type = <span class="hljs-built_in">type</span>(step).__name__
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{i+<span class="hljs-number">1</span>}</span>. <span class="hljs-subst">{step_type}</span>&quot;</span>)`,wrap:!1}}),W=new f({props:{title:"Example Human-in-the-Loop Workflow",local:"example-human-in-the-loop-workflow",headingTag:"h2"}}),P=new f({props:{title:"Error Handling",local:"error-handling",headingTag:"h2"}}),A=new f({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),G=new f({props:{title:"Educational Value",local:"educational-value",headingTag:"h2"}}),D=new ut({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/plan_customization.md"}}),{c(){E=s("meta"),O=i(),q=s("p"),ee=i(),o(h.$$.fragment),te=i(),N=s("p"),N.innerHTML=Ze,le=i(),o(w.$$.fragment),ne=i(),C=s("p"),C.textContent=Pe,ie=i(),$=s("ul"),$.innerHTML=Qe,ae=i(),o(d.$$.fragment),se=i(),o(M.$$.fragment),pe=i(),U=s("p"),U.innerHTML=Ve,me=i(),o(g.$$.fragment),oe=i(),o(v.$$.fragment),re=i(),y=s("p"),y.textContent=Ae,Te=i(),R=s("ol"),R.innerHTML=Se,Je=i(),b=s("p"),b.textContent=Ge,ue=i(),o(z.$$.fragment),ce=i(),x=s("p"),x.textContent=Ye,fe=i(),I=s("p"),I.textContent=Fe,Ee=i(),o(j.$$.fragment),he=i(),H=s("p"),H.innerHTML=Xe,Ne=i(),o(B.$$.fragment),we=i(),o(_.$$.fragment),Ce=i(),k=s("p"),k.textContent=De,$e=i(),o(L.$$.fragment),de=i(),o(W.$$.fragment),Me=i(),Z=s("ol"),Z.innerHTML=qe,Ue=i(),o(P.$$.fragment),ge=i(),Q=s("p"),Q.textContent=Ke,ve=i(),V=s("ul"),V.innerHTML=Oe,ye=i(),o(A.$$.fragment),Re=i(),S=s("ul"),S.innerHTML=et,be=i(),o(G.$$.fragment),ze=i(),Y=s("p"),Y.textContent=tt,xe=i(),F=s("ul"),F.innerHTML=lt,Ie=i(),je=s("hr"),He=i(),X=s("p"),X.innerHTML=nt,Be=i(),o(D.$$.fragment),_e=i(),K=s("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);E=p(t,"META",{name:!0,content:!0}),t.forEach(l),O=a(e),q=p(e,"P",{}),it(q).forEach(l),ee=a(e),r(h.$$.fragment,e),te=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1wti06c"&&(N.innerHTML=Ze),le=a(e),r(w.$$.fragment,e),ne=a(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-kmblxs"&&(C.textContent=Pe),ie=a(e),$=p(e,"UL",{"data-svelte-h":!0}),m($)!=="svelte-n2ijli"&&($.innerHTML=Qe),ae=a(e),r(d.$$.fragment,e),se=a(e),r(M.$$.fragment,e),pe=a(e),U=p(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-azc98v"&&(U.innerHTML=Ve),me=a(e),r(g.$$.fragment,e),oe=a(e),r(v.$$.fragment,e),re=a(e),y=p(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-jevtav"&&(y.textContent=Ae),Te=a(e),R=p(e,"OL",{"data-svelte-h":!0}),m(R)!=="svelte-1qdpmfw"&&(R.innerHTML=Se),Je=a(e),b=p(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-w8vt1w"&&(b.textContent=Ge),ue=a(e),r(z.$$.fragment,e),ce=a(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-eb1jys"&&(x.textContent=Ye),fe=a(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-bn3dhy"&&(I.textContent=Fe),Ee=a(e),r(j.$$.fragment,e),he=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-r52soi"&&(H.innerHTML=Xe),Ne=a(e),r(B.$$.fragment,e),we=a(e),r(_.$$.fragment,e),Ce=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-poryh8"&&(k.textContent=De),$e=a(e),r(L.$$.fragment,e),de=a(e),r(W.$$.fragment,e),Me=a(e),Z=p(e,"OL",{"data-svelte-h":!0}),m(Z)!=="svelte-zuge37"&&(Z.innerHTML=qe),Ue=a(e),r(P.$$.fragment,e),ge=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-majit4"&&(Q.textContent=Ke),ve=a(e),V=p(e,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-1753xp9"&&(V.innerHTML=Oe),ye=a(e),r(A.$$.fragment,e),Re=a(e),S=p(e,"UL",{"data-svelte-h":!0}),m(S)!=="svelte-1tasrgg"&&(S.innerHTML=et),be=a(e),r(G.$$.fragment,e),ze=a(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-eguazz"&&(Y.textContent=tt),xe=a(e),F=p(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-1hkp5ed"&&(F.innerHTML=lt),Ie=a(e),je=p(e,"HR",{}),He=a(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1ru3szn"&&(X.innerHTML=nt),Be=a(e),r(D.$$.fragment,e),_e=a(e),K=p(e,"P",{}),it(K).forEach(l),this.h()},h(){at(E,"name","hf:doc:metadata"),at(E,"content",ft)},m(e,t){Jt(document.head,E),n(e,O,t),n(e,q,t),n(e,ee,t),T(h,e,t),n(e,te,t),n(e,N,t),n(e,le,t),T(w,e,t),n(e,ne,t),n(e,C,t),n(e,ie,t),n(e,$,t),n(e,ae,t),T(d,e,t),n(e,se,t),T(M,e,t),n(e,pe,t),n(e,U,t),n(e,me,t),T(g,e,t),n(e,oe,t),T(v,e,t),n(e,re,t),n(e,y,t),n(e,Te,t),n(e,R,t),n(e,Je,t),n(e,b,t),n(e,ue,t),T(z,e,t),n(e,ce,t),n(e,x,t),n(e,fe,t),n(e,I,t),n(e,Ee,t),T(j,e,t),n(e,he,t),n(e,H,t),n(e,Ne,t),T(B,e,t),n(e,we,t),T(_,e,t),n(e,Ce,t),n(e,k,t),n(e,$e,t),T(L,e,t),n(e,de,t),T(W,e,t),n(e,Me,t),n(e,Z,t),n(e,Ue,t),T(P,e,t),n(e,ge,t),n(e,Q,t),n(e,ve,t),n(e,V,t),n(e,ye,t),T(A,e,t),n(e,Re,t),n(e,S,t),n(e,be,t),T(G,e,t),n(e,ze,t),n(e,Y,t),n(e,xe,t),n(e,F,t),n(e,Ie,t),n(e,je,t),n(e,He,t),n(e,X,t),n(e,Be,t),T(D,e,t),n(e,_e,t),n(e,K,t),ke=!0},p:pt,i(e){ke||(J(h.$$.fragment,e),J(w.$$.fragment,e),J(d.$$.fragment,e),J(M.$$.fragment,e),J(g.$$.fragment,e),J(v.$$.fragment,e),J(z.$$.fragment,e),J(j.$$.fragment,e),J(B.$$.fragment,e),J(_.$$.fragment,e),J(L.$$.fragment,e),J(W.$$.fragment,e),J(P.$$.fragment,e),J(A.$$.fragment,e),J(G.$$.fragment,e),J(D.$$.fragment,e),ke=!0)},o(e){u(h.$$.fragment,e),u(w.$$.fragment,e),u(d.$$.fragment,e),u(M.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(z.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(_.$$.fragment,e),u(L.$$.fragment,e),u(W.$$.fragment,e),u(P.$$.fragment,e),u(A.$$.fragment,e),u(G.$$.fragment,e),u(D.$$.fragment,e),ke=!1},d(e){e&&(l(O),l(q),l(ee),l(te),l(N),l(le),l(ne),l(C),l(ie),l($),l(ae),l(se),l(pe),l(U),l(me),l(oe),l(re),l(y),l(Te),l(R),l(Je),l(b),l(ue),l(ce),l(x),l(fe),l(I),l(Ee),l(he),l(H),l(Ne),l(we),l(Ce),l(k),l($e),l(de),l(Me),l(Z),l(Ue),l(ge),l(Q),l(ve),l(V),l(ye),l(Re),l(S),l(be),l(ze),l(Y),l(xe),l(F),l(Ie),l(je),l(He),l(X),l(Be),l(_e),l(K)),l(E),c(h,e),c(w,e),c(d,e),c(M,e),c(g,e),c(v,e),c(z,e),c(j,e),c(B,e),c(_,e),c(L,e),c(W,e),c(P,e),c(A,e),c(G,e),c(D,e)}}}const ft='{"title":"Human-in-the-Loop: Customize Agent Plan Interactively","local":"human-in-the-loop-customize-agent-plan-interactively","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Key Concepts","local":"key-concepts","sections":[{"title":"Step Callbacks for Plan Interruption","local":"step-callbacks-for-plan-interruption","sections":[],"depth":3},{"title":"Human-in-the-Loop: Interactive Plan Review and Modification","local":"human-in-the-loop-interactive-plan-review-and-modification","sections":[],"depth":3},{"title":"Memory Preservation and Resuming Execution","local":"memory-preservation-and-resuming-execution","sections":[],"depth":3},{"title":"Inspecting Agent Memory","local":"inspecting-agent-memory","sections":[],"depth":3}],"depth":2},{"title":"Example Human-in-the-Loop Workflow","local":"example-human-in-the-loop-workflow","sections":[],"depth":2},{"title":"Error Handling","local":"error-handling","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Educational Value","local":"educational-value","sections":[],"depth":2}],"depth":1}';function Et(We){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends ot{constructor(E){super(),rt(this,E,Et,ct,st,{})}}export{$t as component};
