import{s as uo,o as Jo}from"../chunks/scheduler.25b97de1.js";import{S as To,i as Uo,g as o,s as a,r as M,A as jo,h as i,f as s,c as n,j as ro,u as r,x as p,k as yo,y as wo,a as l,v as y,d as c,t as h,w as m,m as ho,n as mo}from"../chunks/index.d9030fc9.js";import{T as co}from"../chunks/Tip.baa67368.js";import{C as u}from"../chunks/CodeBlock.e6cd0d95.js";import{H as d,E as Io}from"../chunks/EditOnGithub.91d95064.js";function go(ts){let J;return{c(){J=ho(`Not all of the tool-calling features shown above are used by all models. Some use tool call IDs, others simply use the function name and
match tool calls to results using the ordering, and there are several models that use neither and only issue one tool 
call at a time to avoid confusion. If you want your code to be compatible across as many models as possible, we 
recommend structuring your tools calls like we've shown here, and returning tool results in the order that
they were issued by the model. The chat templates on each model should handle the rest.`)},l(T){J=mo(T,`Not all of the tool-calling features shown above are used by all models. Some use tool call IDs, others simply use the function name and
match tool calls to results using the ordering, and there are several models that use neither and only issue one tool 
call at a time to avoid confusion. If you want your code to be compatible across as many models as possible, we 
recommend structuring your tools calls like we've shown here, and returning tool results in the order that
they were issued by the model. The chat templates on each model should handle the rest.`)},m(T,U){l(T,J,U)},d(T){T&&s(J)}}}function fo(ts){let J;return{c(){J=ho(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(T){J=mo(T,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(T,U){l(T,J,U)},d(T){T&&s(J)}}}function bo(ts){let J,T,U,ss,I,ls,g,as,f,qa=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,ns,b,Va=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer. They specify how to convert conversations,
represented as lists of messages, into a single tokenizable string in the format that the model expects.`,os,C,Sa=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,is,G,ps,x,za=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>mistralai/Mistral-7B-Instruct-v0.1</code> model.`,Ms,B,rs,Z,Ra=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!). Mistral-instruct was trained with these tokens, but BlenderBot was not.`,ys,v,cs,k,Xa=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> method. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,hs,N,_a="Here’s an example of preparing input for <code>model.generate()</code>, using the <code>Zephyr</code> assistant model:",ms,$,us,Q,Ea="This will yield a string in the input format that Zephyr expects.",ds,W,Js,A,Ha="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",Ts,q,Us,V,Ya="This will yield:",js,S,ws,z,Fa="Arr, ‘twas easy after all!",Is,R,gs,X,La=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,fs,_,bs,E,Cs,H,Da=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,Gs,Y,xs,F,Pa=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Bs,L,Zs,D,Ka="Here’s what this will look like without a generation prompt, using the ChatML template we saw in the Zephyr example:",vs,P,ks,K,Oa="And here’s what it looks like <strong>with</strong> a generation prompt:",Ns,O,$s,tt,tn=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Qs,et,en=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Ws,st,As,lt,sn=`Yes! We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,qs,at,Vs,nt,ln="And we get:",Ss,ot,zs,it,an="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",Rs,pt,Xs,Mt,nn=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,_s,rt,on=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,Es,yt,Hs,ct,pn=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,Ys,ht,Fs,mt,Mn=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,Ls,ut,rn=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,Ds,dt,Ps,Jt,yn=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,Ks,Tt,cn="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",Os,Ut,tl,jt,hn=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,el,wt,mn="First, let’s load our model and tokenizer:",sl,It,ll,gt,un="Next, let’s define a list of tools:",al,ft,nl,bt,dn="Now, let’s set up a conversation for our bot:",ol,Ct,il,Gt,Jn="Now, let’s apply the chat template and generate a response:",pl,xt,Ml,Bt,Tn="And we get:",rl,Zt,yl,vt,Un=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,cl,kt,jn=`Let’s append the model’s tool call to the conversation. Note that we generate a random <code>tool_call_id</code> here. These IDs
are not used by all models, but they allow models to issue multiple tool calls at once and keep track of which response
corresponds to which call. You can generate them any way you like, but they should be unique within each chat.`,hl,Nt,ml,$t,wn=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly. Again, note the <code>tool_call_id</code> - this should match the ID used in the tool call above.`,ul,Qt,dl,Wt,In="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Jl,At,Tl,qt,gn="And we get:",Ul,Vt,jl,St,fn=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,wl,j,Il,zt,gl,Rt,bn=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,fl,Xt,Cn=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,bl,_t,Cl,Et,Gn="This will yield:",Gl,Ht,xl,Yt,xn=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,Bl,Ft,Bn="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",Zl,Lt,vl,Dt,kl,Pt,Zn=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,Nl,Kt,vn="Here’s an example of a RAG template in action:",$l,Ot,Ql,te,Wl,ee,kn=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Al,se,ql,le,Nn=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that the first
newline after each block as well as any preceding whitespace before a block are ignored by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. However, be cautious - although leading whitespace on each
line is stripped, spaces between blocks on the same line are not. We strongly recommend checking that your template
isn’t printing extra spaces where it shouldn’t be!`,Vl,ae,Sl,ne,$n=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,zl,oe,Rl,ie,Qn="Effectively, the template does three things:",Xl,pe,Wn="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",_l,Me,An=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,El,re,Hl,ye,qn=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,Yl,ce,Fl,he,Ll,me,Vn=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Dl,ue,Pl,de,Sn=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,Kl,Je,Ol,Te,zn=`The method <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,ta,w,ea,Ue,sa,je,Rn=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>TextGenerationPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,la,we,Xn=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat.`,aa,Ie,_n=`Now that actual chat templates have been adopted more widely, default templates have been deprecated and will be
removed in a future release. We strongly recommend setting the <code>chat_template</code> attribute for any tokenizers that
still depend on them!`,na,ge,oa,fe,En=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,ia,be,Hn=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,pa,Ce,Ma,Ge,Yn=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,ra,xe,ya,Be,Fn=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,ca,Ze,ha,ve,Ln=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,ma,ke,ua,Ne,Dn=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,da,$e,Pn=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Ja,Qe,Kn=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Ta,We,Ua,Ae,On=`If you’re unfamiliar with Jinja, we generally find that the easiest way to write a chat template is to first
write a short Python script that formats messages the way you want, and then convert that script into a template.`,ja,qe,to=`Remember that the template handler will receive the conversation history as a variable called <code>messages</code>. Each
message is a dictionary with two keys, <code>role</code> and <code>content</code>. You will be able to access <code>messages</code> in your template
just like you can in Python, which means you can loop over it with <code>{% for message in messages %}</code> or access
individual messages with, for example, <code>{{ messages[0] }}</code>.`,wa,Ve,eo="You can also use the following tips to convert your code to Jinja:",Ia,Se,ga,ze,so="For loops in Jinja look like this:",fa,Re,ba,Xe,lo=`Note that whatever’s inside the {{ expression block }} will be printed to the output. You can use operators like
<code>+</code> to combine strings inside expression blocks.`,Ca,_e,Ga,Ee,ao="If statements in Jinja look like this:",xa,He,Ba,Ye,no=`Note how where Python uses whitespace to mark the beginnings and ends of <code>for</code> and <code>if</code> blocks, Jinja requires you
to explicitly end them with <code>{% endfor %}</code> and <code>{% endif %}</code>.`,Za,Fe,va,Le,oo=`Inside your template, you will have access to the list of <code>messages</code>, but you can also access several other special
variables. These include special tokens like <code>bos_token</code> and <code>eos_token</code>, as well as the <code>add_generation_prompt</code>
variable that we discussed above. You can also use the <code>loop</code> variable to access information about the current loop
iteration, for example  using <code>{% if loop.last %}</code> to check if the current message is the last message in the
conversation. Here’s an example that puts these ideas together to add a generation prompt at the end of the
conversation if add_generation_prompt is <code>True</code>:`,ka,De,Na,Pe,$a,Ke,io=`As much as possible, we’ve tried to get Jinja to ignore whitespace outside of {{ expressions }}. However, be aware
that Jinja is a general-purpose templating engine, and it may treat whitespace between blocks on the same line
as significant and print it to the output. We <strong>strongly</strong> recommend checking that your template isn’t printing extra
spaces where it shouldn’t be before you upload it!`,Qa,Oe,Wa,es,Aa;return I=new d({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),g=new d({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),G=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),B=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),v=new d({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),$=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),W=new u({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),q=new u({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),S=new u({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),R=new d({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),E=new u({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),Y=new d({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),L=new u({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),P=new u({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),O=new u({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),st=new d({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),at=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),ot=new u({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),pt=new d({props:{title:"Advanced: Extra inputs to chat templates",local:"advanced-extra-inputs-to-chat-templates",headingTag:"h2"}}),yt=new d({props:{title:"Advanced: Tool use / function calling",local:"advanced-tool-use--function-calling",headingTag:"h2"}}),ht=new u({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),dt=new d({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),Ut=new d({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),It=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHJldmlzaW9uJTNEJTIycHIlMkYxMyUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint, revision=<span class="hljs-string">&quot;pr/13&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),ft=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),Ct=new u({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),xt=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBjaGF0X3RlbXBsYXRlJTNEJTIydG9vbF91c2UlMjIlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, chat_template=<span class="hljs-string">&quot;tool_use&quot;</span>, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),Zt=new u({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),Nt=new u({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIydkFIZGYzJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjBzaG91bGQlMjBiZSUyMHVuaXF1ZSUyMGZvciUyMGVhY2glMjB0b29sJTIwY2FsbCUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;vAHdf3&quot;</span>  <span class="hljs-comment"># Random ID, should be unique for each tool call</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),Qt=new u({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),At=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBjaGF0X3RlbXBsYXRlJTNEJTIydG9vbF91c2UlMjIlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, chat_template=<span class="hljs-string">&quot;tool_use&quot;</span>, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),Vt=new u({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),j=new co({props:{$$slots:{default:[go]},$$scope:{ctx:ts}}}),zt=new d({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),_t=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),Ht=new u({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Lt=new u({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),Dt=new d({props:{title:"Advanced: Retrieval-augmented generation",local:"advanced-retrieval-augmented-generation",headingTag:"h2"}}),Ot=new u({props:{code:"ZG9jdW1lbnQxJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjAlMjJUaGUlMjBNb29uJTNBJTIwT3VyJTIwQWdlLU9sZCUyMEZvZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbnRlbnRzJTIyJTNBJTIwJTIyTWFuJTIwaGFzJTIwYWx3YXlzJTIwZHJlYW1lZCUyMG9mJTIwZGVzdHJveWluZyUyMHRoZSUyMG1vb24uJTIwSW4lMjB0aGlzJTIwZXNzYXklMkMlMjBJJTIwc2hhbGwuLi4lMjIlMEElN0QlMEElMEFkb2N1bWVudDIlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMCUyMlRoZSUyMFN1biUzQSUyME91ciUyMEFnZS1PbGQlMjBGcmllbmQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJjb250ZW50cyUyMiUzQSUyMCUyMkFsdGhvdWdoJTIwb2Z0ZW4lMjB1bmRlcmFwcHJlY2lhdGVkJTJDJTIwdGhlJTIwc3VuJTIwcHJvdmlkZXMlMjBzZXZlcmFsJTIwbm90YWJsZSUyMGJlbmVmaXRzLi4uJTIyJTBBJTdEJTBBJTBBbW9kZWxfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUzRCU1QmRvY3VtZW50MSUyQyUyMGRvY3VtZW50MiU1RCUwQSk=",highlighted:`document1 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
}

document2 = {
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
    <span class="hljs-string">&quot;contents&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
}

model_input = tokenizer.apply_chat_template(
    messages,
    documents=[document1, document2]
)`,wrap:!1}}),te=new d({props:{title:"Advanced: How do chat templates work?",local:"advanced-how-do-chat-templates-work",headingTag:"h2"}}),se=new u({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),ae=new u({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),oe=new u({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),re=new u({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ce=new d({props:{title:"Advanced: Adding and editing chat templates",local:"advanced-adding-and-editing-chat-templates",headingTag:"h2"}}),he=new d({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h3"}}),ue=new u({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Je=new u({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),w=new co({props:{$$slots:{default:[fo]},$$scope:{ctx:ts}}}),Ue=new d({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h3"}}),ge=new d({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h3"}}),Ce=new u({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),xe=new u({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Ze=new u({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),ke=new d({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h3"}}),We=new d({props:{title:"Advanced: Template writing tips",local:"advanced-template-writing-tips",headingTag:"h2"}}),Se=new d({props:{title:"For loops",local:"for-loops",headingTag:"h3"}}),Re=new u({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),_e=new d({props:{title:"If statements",local:"if-statements",headingTag:"h3"}}),He=new u({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Fe=new d({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),De=new u({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),Pe=new d({props:{title:"Notes on whitespace",local:"notes-on-whitespace",headingTag:"h3"}}),Oe=new Io({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_templating.md"}}),{c(){J=o("meta"),T=a(),U=o("p"),ss=a(),M(I.$$.fragment),ls=a(),M(g.$$.fragment),as=a(),f=o("p"),f.innerHTML=qa,ns=a(),b=o("p"),b.innerHTML=Va,os=a(),C=o("p"),C.innerHTML=Sa,is=a(),M(G.$$.fragment),ps=a(),x=o("p"),x.innerHTML=za,Ms=a(),M(B.$$.fragment),rs=a(),Z=o("p"),Z.textContent=Ra,ys=a(),M(v.$$.fragment),cs=a(),k=o("p"),k.innerHTML=Xa,hs=a(),N=o("p"),N.innerHTML=_a,ms=a(),M($.$$.fragment),us=a(),Q=o("p"),Q.textContent=Ea,ds=a(),M(W.$$.fragment),Js=a(),A=o("p"),A.textContent=Ha,Ts=a(),M(q.$$.fragment),Us=a(),V=o("p"),V.textContent=Ya,js=a(),M(S.$$.fragment),ws=a(),z=o("p"),z.textContent=Fa,Is=a(),M(R.$$.fragment),gs=a(),X=o("p"),X.innerHTML=La,fs=a(),M(_.$$.fragment),bs=a(),M(E.$$.fragment),Cs=a(),H=o("p"),H.innerHTML=Da,Gs=a(),M(Y.$$.fragment),xs=a(),F=o("p"),F.innerHTML=Pa,Bs=a(),M(L.$$.fragment),Zs=a(),D=o("p"),D.textContent=Ka,vs=a(),M(P.$$.fragment),ks=a(),K=o("p"),K.innerHTML=Oa,Ns=a(),M(O.$$.fragment),$s=a(),tt=o("p"),tt.textContent=tn,Qs=a(),et=o("p"),et.innerHTML=en,Ws=a(),M(st.$$.fragment),As=a(),lt=o("p"),lt.innerHTML=sn,qs=a(),M(at.$$.fragment),Vs=a(),nt=o("p"),nt.textContent=ln,Ss=a(),M(ot.$$.fragment),zs=a(),it=o("p"),it.innerHTML=an,Rs=a(),M(pt.$$.fragment),Xs=a(),Mt=o("p"),Mt.innerHTML=nn,_s=a(),rt=o("p"),rt.textContent=on,Es=a(),M(yt.$$.fragment),Hs=a(),ct=o("p"),ct.innerHTML=pn,Ys=a(),M(ht.$$.fragment),Fs=a(),mt=o("p"),mt.textContent=Mn,Ls=a(),ut=o("ul"),ut.innerHTML=rn,Ds=a(),M(dt.$$.fragment),Ps=a(),Jt=o("p"),Jt.textContent=yn,Ks=a(),Tt=o("ol"),Tt.innerHTML=cn,Os=a(),M(Ut.$$.fragment),tl=a(),jt=o("p"),jt.innerHTML=hn,el=a(),wt=o("p"),wt.textContent=mn,sl=a(),M(It.$$.fragment),ll=a(),gt=o("p"),gt.textContent=un,al=a(),M(ft.$$.fragment),nl=a(),bt=o("p"),bt.textContent=dn,ol=a(),M(Ct.$$.fragment),il=a(),Gt=o("p"),Gt.textContent=Jn,pl=a(),M(xt.$$.fragment),Ml=a(),Bt=o("p"),Bt.textContent=Tn,rl=a(),M(Zt.$$.fragment),yl=a(),vt=o("p"),vt.textContent=Un,cl=a(),kt=o("p"),kt.innerHTML=jn,hl=a(),M(Nt.$$.fragment),ml=a(),$t=o("p"),$t.innerHTML=wn,ul=a(),M(Qt.$$.fragment),dl=a(),Wt=o("p"),Wt.textContent=In,Jl=a(),M(At.$$.fragment),Tl=a(),qt=o("p"),qt.textContent=gn,Ul=a(),M(Vt.$$.fragment),jl=a(),St=o("p"),St.textContent=fn,wl=a(),M(j.$$.fragment),Il=a(),M(zt.$$.fragment),gl=a(),Rt=o("p"),Rt.innerHTML=bn,fl=a(),Xt=o("p"),Xt.textContent=Cn,bl=a(),M(_t.$$.fragment),Cl=a(),Et=o("p"),Et.textContent=Gn,Gl=a(),M(Ht.$$.fragment),xl=a(),Yt=o("p"),Yt.innerHTML=xn,Bl=a(),Ft=o("p"),Ft.innerHTML=Bn,Zl=a(),M(Lt.$$.fragment),vl=a(),M(Dt.$$.fragment),kl=a(),Pt=o("p"),Pt.innerHTML=Zn,Nl=a(),Kt=o("p"),Kt.textContent=vn,$l=a(),M(Ot.$$.fragment),Ql=a(),M(te.$$.fragment),Wl=a(),ee=o("p"),ee.innerHTML=kn,Al=a(),M(se.$$.fragment),ql=a(),le=o("p"),le.innerHTML=Nn,Vl=a(),M(ae.$$.fragment),Sl=a(),ne=o("p"),ne.innerHTML=$n,zl=a(),M(oe.$$.fragment),Rl=a(),ie=o("p"),ie.textContent=Qn,Xl=a(),pe=o("ol"),pe.innerHTML=Wn,_l=a(),Me=o("p"),Me.textContent=An,El=a(),M(re.$$.fragment),Hl=a(),ye=o("p"),ye.textContent=qn,Yl=a(),M(ce.$$.fragment),Fl=a(),M(he.$$.fragment),Ll=a(),me=o("p"),me.innerHTML=Vn,Dl=a(),M(ue.$$.fragment),Pl=a(),de=o("p"),de.innerHTML=Sn,Kl=a(),M(Je.$$.fragment),Ol=a(),Te=o("p"),Te.innerHTML=zn,ta=a(),M(w.$$.fragment),ea=a(),M(Ue.$$.fragment),sa=a(),je=o("p"),je.innerHTML=Rn,la=a(),we=o("p"),we.innerHTML=Xn,aa=a(),Ie=o("p"),Ie.innerHTML=_n,na=a(),M(ge.$$.fragment),oa=a(),fe=o("p"),fe.textContent=En,ia=a(),be=o("p"),be.innerHTML=Hn,pa=a(),M(Ce.$$.fragment),Ma=a(),Ge=o("p"),Ge.innerHTML=Yn,ra=a(),M(xe.$$.fragment),ya=a(),Be=o("p"),Be.innerHTML=Fn,ca=a(),M(Ze.$$.fragment),ha=a(),ve=o("p"),ve.innerHTML=Ln,ma=a(),M(ke.$$.fragment),ua=a(),Ne=o("p"),Ne.innerHTML=Dn,da=a(),$e=o("p"),$e.innerHTML=Pn,Ja=a(),Qe=o("p"),Qe.textContent=Kn,Ta=a(),M(We.$$.fragment),Ua=a(),Ae=o("p"),Ae.textContent=On,ja=a(),qe=o("p"),qe.innerHTML=to,wa=a(),Ve=o("p"),Ve.textContent=eo,Ia=a(),M(Se.$$.fragment),ga=a(),ze=o("p"),ze.textContent=so,fa=a(),M(Re.$$.fragment),ba=a(),Xe=o("p"),Xe.innerHTML=lo,Ca=a(),M(_e.$$.fragment),Ga=a(),Ee=o("p"),Ee.textContent=ao,xa=a(),M(He.$$.fragment),Ba=a(),Ye=o("p"),Ye.innerHTML=no,Za=a(),M(Fe.$$.fragment),va=a(),Le=o("p"),Le.innerHTML=oo,ka=a(),M(De.$$.fragment),Na=a(),M(Pe.$$.fragment),$a=a(),Ke=o("p"),Ke.innerHTML=io,Qa=a(),M(Oe.$$.fragment),Wa=a(),es=o("p"),this.h()},l(t){const e=jo("svelte-u9bgzb",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(s),T=n(t),U=i(t,"P",{}),ro(U).forEach(s),ss=n(t),r(I.$$.fragment,t),ls=n(t),r(g.$$.fragment,t),as=n(t),f=i(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ydi30o"&&(f.innerHTML=qa),ns=n(t),b=i(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1p8dq8"&&(b.innerHTML=Va),os=n(t),C=i(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1n6wf0k"&&(C.innerHTML=Sa),is=n(t),r(G.$$.fragment,t),ps=n(t),x=i(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1e3bvfs"&&(x.innerHTML=za),Ms=n(t),r(B.$$.fragment,t),rs=n(t),Z=i(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-15k3bj3"&&(Z.textContent=Ra),ys=n(t),r(v.$$.fragment,t),cs=n(t),k=i(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1qjxrus"&&(k.innerHTML=Xa),hs=n(t),N=i(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-gmslqw"&&(N.innerHTML=_a),ms=n(t),r($.$$.fragment,t),us=n(t),Q=i(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1vy7akj"&&(Q.textContent=Ea),ds=n(t),r(W.$$.fragment,t),Js=n(t),A=i(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-hj60o5"&&(A.textContent=Ha),Ts=n(t),r(q.$$.fragment,t),Us=n(t),V=i(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1bfcqd3"&&(V.textContent=Ya),js=n(t),r(S.$$.fragment,t),ws=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-k9m2iy"&&(z.textContent=Fa),Is=n(t),r(R.$$.fragment,t),gs=n(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-znnkjx"&&(X.innerHTML=La),fs=n(t),r(_.$$.fragment,t),bs=n(t),r(E.$$.fragment,t),Cs=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-5umvde"&&(H.innerHTML=Da),Gs=n(t),r(Y.$$.fragment,t),xs=n(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-rhnu79"&&(F.innerHTML=Pa),Bs=n(t),r(L.$$.fragment,t),Zs=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1g5nifq"&&(D.textContent=Ka),vs=n(t),r(P.$$.fragment,t),ks=n(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-61bp3d"&&(K.innerHTML=Oa),Ns=n(t),r(O.$$.fragment,t),$s=n(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-inq88f"&&(tt.textContent=tn),Qs=n(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-76qw2e"&&(et.innerHTML=en),Ws=n(t),r(st.$$.fragment,t),As=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-i6ltb0"&&(lt.innerHTML=sn),qs=n(t),r(at.$$.fragment,t),Vs=n(t),nt=i(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-13505nn"&&(nt.textContent=ln),Ss=n(t),r(ot.$$.fragment,t),zs=n(t),it=i(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-ziuqkt"&&(it.innerHTML=an),Rs=n(t),r(pt.$$.fragment,t),Xs=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-dd615e"&&(Mt.innerHTML=nn),_s=n(t),rt=i(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-dcun4m"&&(rt.textContent=on),Es=n(t),r(yt.$$.fragment,t),Hs=n(t),ct=i(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-6sd0wq"&&(ct.innerHTML=pn),Ys=n(t),r(ht.$$.fragment,t),Fs=n(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-608o9m"&&(mt.textContent=Mn),Ls=n(t),ut=i(t,"UL",{"data-svelte-h":!0}),p(ut)!=="svelte-n1b3zm"&&(ut.innerHTML=rn),Ds=n(t),r(dt.$$.fragment,t),Ps=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-11962fa"&&(Jt.textContent=yn),Ks=n(t),Tt=i(t,"OL",{"data-svelte-h":!0}),p(Tt)!=="svelte-1vd84s7"&&(Tt.innerHTML=cn),Os=n(t),r(Ut.$$.fragment,t),tl=n(t),jt=i(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1oi0gsn"&&(jt.innerHTML=hn),el=n(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-o8n6v4"&&(wt.textContent=mn),sl=n(t),r(It.$$.fragment,t),ll=n(t),gt=i(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-1q7358y"&&(gt.textContent=un),al=n(t),r(ft.$$.fragment,t),nl=n(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-11hfyaa"&&(bt.textContent=dn),ol=n(t),r(Ct.$$.fragment,t),il=n(t),Gt=i(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-1usrd3e"&&(Gt.textContent=Jn),pl=n(t),r(xt.$$.fragment,t),Ml=n(t),Bt=i(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-13505nn"&&(Bt.textContent=Tn),rl=n(t),r(Zt.$$.fragment,t),yl=n(t),vt=i(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-nxltbo"&&(vt.textContent=Un),cl=n(t),kt=i(t,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-1fjq90r"&&(kt.innerHTML=jn),hl=n(t),r(Nt.$$.fragment,t),ml=n(t),$t=i(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-6h0phb"&&($t.innerHTML=wn),ul=n(t),r(Qt.$$.fragment,t),dl=n(t),Wt=i(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-1qjybqz"&&(Wt.textContent=In),Jl=n(t),r(At.$$.fragment,t),Tl=n(t),qt=i(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-13505nn"&&(qt.textContent=gn),Ul=n(t),r(Vt.$$.fragment,t),jl=n(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1evxmus"&&(St.textContent=fn),wl=n(t),r(j.$$.fragment,t),Il=n(t),r(zt.$$.fragment,t),gl=n(t),Rt=i(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-pl4mbs"&&(Rt.innerHTML=bn),fl=n(t),Xt=i(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-37xmdz"&&(Xt.textContent=Cn),bl=n(t),r(_t.$$.fragment,t),Cl=n(t),Et=i(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-1bfcqd3"&&(Et.textContent=Gn),Gl=n(t),r(Ht.$$.fragment,t),xl=n(t),Yt=i(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-19t6fs5"&&(Yt.innerHTML=xn),Bl=n(t),Ft=i(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-1nlyrys"&&(Ft.innerHTML=Bn),Zl=n(t),r(Lt.$$.fragment,t),vl=n(t),r(Dt.$$.fragment,t),kl=n(t),Pt=i(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1977j4z"&&(Pt.innerHTML=Zn),Nl=n(t),Kt=i(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1xmnzcc"&&(Kt.textContent=vn),$l=n(t),r(Ot.$$.fragment,t),Ql=n(t),r(te.$$.fragment,t),Wl=n(t),ee=i(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-9hx4bd"&&(ee.innerHTML=kn),Al=n(t),r(se.$$.fragment,t),ql=n(t),le=i(t,"P",{"data-svelte-h":!0}),p(le)!=="svelte-gucfz7"&&(le.innerHTML=Nn),Vl=n(t),r(ae.$$.fragment,t),Sl=n(t),ne=i(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-zet1qo"&&(ne.innerHTML=$n),zl=n(t),r(oe.$$.fragment,t),Rl=n(t),ie=i(t,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-9bdwn1"&&(ie.textContent=Qn),Xl=n(t),pe=i(t,"OL",{"data-svelte-h":!0}),p(pe)!=="svelte-yy2gop"&&(pe.innerHTML=Wn),_l=n(t),Me=i(t,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-jxu6rq"&&(Me.textContent=An),El=n(t),r(re.$$.fragment,t),Hl=n(t),ye=i(t,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-dqaxjt"&&(ye.textContent=qn),Yl=n(t),r(ce.$$.fragment,t),Fl=n(t),r(he.$$.fragment,t),Ll=n(t),me=i(t,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1ubxgh9"&&(me.innerHTML=Vn),Dl=n(t),r(ue.$$.fragment,t),Pl=n(t),de=i(t,"P",{"data-svelte-h":!0}),p(de)!=="svelte-t74z56"&&(de.innerHTML=Sn),Kl=n(t),r(Je.$$.fragment,t),Ol=n(t),Te=i(t,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-pl6d88"&&(Te.innerHTML=zn),ta=n(t),r(w.$$.fragment,t),ea=n(t),r(Ue.$$.fragment,t),sa=n(t),je=i(t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-wev7i6"&&(je.innerHTML=Rn),la=n(t),we=i(t,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1o0lzen"&&(we.innerHTML=Xn),aa=n(t),Ie=i(t,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1o7n9tk"&&(Ie.innerHTML=_n),na=n(t),r(ge.$$.fragment,t),oa=n(t),fe=i(t,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-5u6sqi"&&(fe.textContent=En),ia=n(t),be=i(t,"P",{"data-svelte-h":!0}),p(be)!=="svelte-ffreiw"&&(be.innerHTML=Hn),pa=n(t),r(Ce.$$.fragment,t),Ma=n(t),Ge=i(t,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1cj1ql7"&&(Ge.innerHTML=Yn),ra=n(t),r(xe.$$.fragment,t),ya=n(t),Be=i(t,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-soh9qu"&&(Be.innerHTML=Fn),ca=n(t),r(Ze.$$.fragment,t),ha=n(t),ve=i(t,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-14p3dvw"&&(ve.innerHTML=Ln),ma=n(t),r(ke.$$.fragment,t),ua=n(t),Ne=i(t,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-12av8vh"&&(Ne.innerHTML=Dn),da=n(t),$e=i(t,"P",{"data-svelte-h":!0}),p($e)!=="svelte-kn2i6o"&&($e.innerHTML=Pn),Ja=n(t),Qe=i(t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-197jyne"&&(Qe.textContent=Kn),Ta=n(t),r(We.$$.fragment,t),Ua=n(t),Ae=i(t,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-64od1c"&&(Ae.textContent=On),ja=n(t),qe=i(t,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-155y3gc"&&(qe.innerHTML=to),wa=n(t),Ve=i(t,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1hxm0m6"&&(Ve.textContent=eo),Ia=n(t),r(Se.$$.fragment,t),ga=n(t),ze=i(t,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1mepej5"&&(ze.textContent=so),fa=n(t),r(Re.$$.fragment,t),ba=n(t),Xe=i(t,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-rw0syz"&&(Xe.innerHTML=lo),Ca=n(t),r(_e.$$.fragment,t),Ga=n(t),Ee=i(t,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-audzqy"&&(Ee.textContent=ao),xa=n(t),r(He.$$.fragment,t),Ba=n(t),Ye=i(t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-gc7ich"&&(Ye.innerHTML=no),Za=n(t),r(Fe.$$.fragment,t),va=n(t),Le=i(t,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1ky9l6m"&&(Le.innerHTML=oo),ka=n(t),r(De.$$.fragment,t),Na=n(t),r(Pe.$$.fragment,t),$a=n(t),Ke=i(t,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-qra3hk"&&(Ke.innerHTML=io),Qa=n(t),r(Oe.$$.fragment,t),Wa=n(t),es=i(t,"P",{}),ro(es).forEach(s),this.h()},h(){yo(J,"name","hf:doc:metadata"),yo(J,"content",Co)},m(t,e){wo(document.head,J),l(t,T,e),l(t,U,e),l(t,ss,e),y(I,t,e),l(t,ls,e),y(g,t,e),l(t,as,e),l(t,f,e),l(t,ns,e),l(t,b,e),l(t,os,e),l(t,C,e),l(t,is,e),y(G,t,e),l(t,ps,e),l(t,x,e),l(t,Ms,e),y(B,t,e),l(t,rs,e),l(t,Z,e),l(t,ys,e),y(v,t,e),l(t,cs,e),l(t,k,e),l(t,hs,e),l(t,N,e),l(t,ms,e),y($,t,e),l(t,us,e),l(t,Q,e),l(t,ds,e),y(W,t,e),l(t,Js,e),l(t,A,e),l(t,Ts,e),y(q,t,e),l(t,Us,e),l(t,V,e),l(t,js,e),y(S,t,e),l(t,ws,e),l(t,z,e),l(t,Is,e),y(R,t,e),l(t,gs,e),l(t,X,e),l(t,fs,e),y(_,t,e),l(t,bs,e),y(E,t,e),l(t,Cs,e),l(t,H,e),l(t,Gs,e),y(Y,t,e),l(t,xs,e),l(t,F,e),l(t,Bs,e),y(L,t,e),l(t,Zs,e),l(t,D,e),l(t,vs,e),y(P,t,e),l(t,ks,e),l(t,K,e),l(t,Ns,e),y(O,t,e),l(t,$s,e),l(t,tt,e),l(t,Qs,e),l(t,et,e),l(t,Ws,e),y(st,t,e),l(t,As,e),l(t,lt,e),l(t,qs,e),y(at,t,e),l(t,Vs,e),l(t,nt,e),l(t,Ss,e),y(ot,t,e),l(t,zs,e),l(t,it,e),l(t,Rs,e),y(pt,t,e),l(t,Xs,e),l(t,Mt,e),l(t,_s,e),l(t,rt,e),l(t,Es,e),y(yt,t,e),l(t,Hs,e),l(t,ct,e),l(t,Ys,e),y(ht,t,e),l(t,Fs,e),l(t,mt,e),l(t,Ls,e),l(t,ut,e),l(t,Ds,e),y(dt,t,e),l(t,Ps,e),l(t,Jt,e),l(t,Ks,e),l(t,Tt,e),l(t,Os,e),y(Ut,t,e),l(t,tl,e),l(t,jt,e),l(t,el,e),l(t,wt,e),l(t,sl,e),y(It,t,e),l(t,ll,e),l(t,gt,e),l(t,al,e),y(ft,t,e),l(t,nl,e),l(t,bt,e),l(t,ol,e),y(Ct,t,e),l(t,il,e),l(t,Gt,e),l(t,pl,e),y(xt,t,e),l(t,Ml,e),l(t,Bt,e),l(t,rl,e),y(Zt,t,e),l(t,yl,e),l(t,vt,e),l(t,cl,e),l(t,kt,e),l(t,hl,e),y(Nt,t,e),l(t,ml,e),l(t,$t,e),l(t,ul,e),y(Qt,t,e),l(t,dl,e),l(t,Wt,e),l(t,Jl,e),y(At,t,e),l(t,Tl,e),l(t,qt,e),l(t,Ul,e),y(Vt,t,e),l(t,jl,e),l(t,St,e),l(t,wl,e),y(j,t,e),l(t,Il,e),y(zt,t,e),l(t,gl,e),l(t,Rt,e),l(t,fl,e),l(t,Xt,e),l(t,bl,e),y(_t,t,e),l(t,Cl,e),l(t,Et,e),l(t,Gl,e),y(Ht,t,e),l(t,xl,e),l(t,Yt,e),l(t,Bl,e),l(t,Ft,e),l(t,Zl,e),y(Lt,t,e),l(t,vl,e),y(Dt,t,e),l(t,kl,e),l(t,Pt,e),l(t,Nl,e),l(t,Kt,e),l(t,$l,e),y(Ot,t,e),l(t,Ql,e),y(te,t,e),l(t,Wl,e),l(t,ee,e),l(t,Al,e),y(se,t,e),l(t,ql,e),l(t,le,e),l(t,Vl,e),y(ae,t,e),l(t,Sl,e),l(t,ne,e),l(t,zl,e),y(oe,t,e),l(t,Rl,e),l(t,ie,e),l(t,Xl,e),l(t,pe,e),l(t,_l,e),l(t,Me,e),l(t,El,e),y(re,t,e),l(t,Hl,e),l(t,ye,e),l(t,Yl,e),y(ce,t,e),l(t,Fl,e),y(he,t,e),l(t,Ll,e),l(t,me,e),l(t,Dl,e),y(ue,t,e),l(t,Pl,e),l(t,de,e),l(t,Kl,e),y(Je,t,e),l(t,Ol,e),l(t,Te,e),l(t,ta,e),y(w,t,e),l(t,ea,e),y(Ue,t,e),l(t,sa,e),l(t,je,e),l(t,la,e),l(t,we,e),l(t,aa,e),l(t,Ie,e),l(t,na,e),y(ge,t,e),l(t,oa,e),l(t,fe,e),l(t,ia,e),l(t,be,e),l(t,pa,e),y(Ce,t,e),l(t,Ma,e),l(t,Ge,e),l(t,ra,e),y(xe,t,e),l(t,ya,e),l(t,Be,e),l(t,ca,e),y(Ze,t,e),l(t,ha,e),l(t,ve,e),l(t,ma,e),y(ke,t,e),l(t,ua,e),l(t,Ne,e),l(t,da,e),l(t,$e,e),l(t,Ja,e),l(t,Qe,e),l(t,Ta,e),y(We,t,e),l(t,Ua,e),l(t,Ae,e),l(t,ja,e),l(t,qe,e),l(t,wa,e),l(t,Ve,e),l(t,Ia,e),y(Se,t,e),l(t,ga,e),l(t,ze,e),l(t,fa,e),y(Re,t,e),l(t,ba,e),l(t,Xe,e),l(t,Ca,e),y(_e,t,e),l(t,Ga,e),l(t,Ee,e),l(t,xa,e),y(He,t,e),l(t,Ba,e),l(t,Ye,e),l(t,Za,e),y(Fe,t,e),l(t,va,e),l(t,Le,e),l(t,ka,e),y(De,t,e),l(t,Na,e),y(Pe,t,e),l(t,$a,e),l(t,Ke,e),l(t,Qa,e),y(Oe,t,e),l(t,Wa,e),l(t,es,e),Aa=!0},p(t,[e]){const po={};e&2&&(po.$$scope={dirty:e,ctx:t}),j.$set(po);const Mo={};e&2&&(Mo.$$scope={dirty:e,ctx:t}),w.$set(Mo)},i(t){Aa||(c(I.$$.fragment,t),c(g.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(v.$$.fragment,t),c($.$$.fragment,t),c(W.$$.fragment,t),c(q.$$.fragment,t),c(S.$$.fragment,t),c(R.$$.fragment,t),c(_.$$.fragment,t),c(E.$$.fragment,t),c(Y.$$.fragment,t),c(L.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(st.$$.fragment,t),c(at.$$.fragment,t),c(ot.$$.fragment,t),c(pt.$$.fragment,t),c(yt.$$.fragment,t),c(ht.$$.fragment,t),c(dt.$$.fragment,t),c(Ut.$$.fragment,t),c(It.$$.fragment,t),c(ft.$$.fragment,t),c(Ct.$$.fragment,t),c(xt.$$.fragment,t),c(Zt.$$.fragment,t),c(Nt.$$.fragment,t),c(Qt.$$.fragment,t),c(At.$$.fragment,t),c(Vt.$$.fragment,t),c(j.$$.fragment,t),c(zt.$$.fragment,t),c(_t.$$.fragment,t),c(Ht.$$.fragment,t),c(Lt.$$.fragment,t),c(Dt.$$.fragment,t),c(Ot.$$.fragment,t),c(te.$$.fragment,t),c(se.$$.fragment,t),c(ae.$$.fragment,t),c(oe.$$.fragment,t),c(re.$$.fragment,t),c(ce.$$.fragment,t),c(he.$$.fragment,t),c(ue.$$.fragment,t),c(Je.$$.fragment,t),c(w.$$.fragment,t),c(Ue.$$.fragment,t),c(ge.$$.fragment,t),c(Ce.$$.fragment,t),c(xe.$$.fragment,t),c(Ze.$$.fragment,t),c(ke.$$.fragment,t),c(We.$$.fragment,t),c(Se.$$.fragment,t),c(Re.$$.fragment,t),c(_e.$$.fragment,t),c(He.$$.fragment,t),c(Fe.$$.fragment,t),c(De.$$.fragment,t),c(Pe.$$.fragment,t),c(Oe.$$.fragment,t),Aa=!0)},o(t){h(I.$$.fragment,t),h(g.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(v.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(q.$$.fragment,t),h(S.$$.fragment,t),h(R.$$.fragment,t),h(_.$$.fragment,t),h(E.$$.fragment,t),h(Y.$$.fragment,t),h(L.$$.fragment,t),h(P.$$.fragment,t),h(O.$$.fragment,t),h(st.$$.fragment,t),h(at.$$.fragment,t),h(ot.$$.fragment,t),h(pt.$$.fragment,t),h(yt.$$.fragment,t),h(ht.$$.fragment,t),h(dt.$$.fragment,t),h(Ut.$$.fragment,t),h(It.$$.fragment,t),h(ft.$$.fragment,t),h(Ct.$$.fragment,t),h(xt.$$.fragment,t),h(Zt.$$.fragment,t),h(Nt.$$.fragment,t),h(Qt.$$.fragment,t),h(At.$$.fragment,t),h(Vt.$$.fragment,t),h(j.$$.fragment,t),h(zt.$$.fragment,t),h(_t.$$.fragment,t),h(Ht.$$.fragment,t),h(Lt.$$.fragment,t),h(Dt.$$.fragment,t),h(Ot.$$.fragment,t),h(te.$$.fragment,t),h(se.$$.fragment,t),h(ae.$$.fragment,t),h(oe.$$.fragment,t),h(re.$$.fragment,t),h(ce.$$.fragment,t),h(he.$$.fragment,t),h(ue.$$.fragment,t),h(Je.$$.fragment,t),h(w.$$.fragment,t),h(Ue.$$.fragment,t),h(ge.$$.fragment,t),h(Ce.$$.fragment,t),h(xe.$$.fragment,t),h(Ze.$$.fragment,t),h(ke.$$.fragment,t),h(We.$$.fragment,t),h(Se.$$.fragment,t),h(Re.$$.fragment,t),h(_e.$$.fragment,t),h(He.$$.fragment,t),h(Fe.$$.fragment,t),h(De.$$.fragment,t),h(Pe.$$.fragment,t),h(Oe.$$.fragment,t),Aa=!1},d(t){t&&(s(T),s(U),s(ss),s(ls),s(as),s(f),s(ns),s(b),s(os),s(C),s(is),s(ps),s(x),s(Ms),s(rs),s(Z),s(ys),s(cs),s(k),s(hs),s(N),s(ms),s(us),s(Q),s(ds),s(Js),s(A),s(Ts),s(Us),s(V),s(js),s(ws),s(z),s(Is),s(gs),s(X),s(fs),s(bs),s(Cs),s(H),s(Gs),s(xs),s(F),s(Bs),s(Zs),s(D),s(vs),s(ks),s(K),s(Ns),s($s),s(tt),s(Qs),s(et),s(Ws),s(As),s(lt),s(qs),s(Vs),s(nt),s(Ss),s(zs),s(it),s(Rs),s(Xs),s(Mt),s(_s),s(rt),s(Es),s(Hs),s(ct),s(Ys),s(Fs),s(mt),s(Ls),s(ut),s(Ds),s(Ps),s(Jt),s(Ks),s(Tt),s(Os),s(tl),s(jt),s(el),s(wt),s(sl),s(ll),s(gt),s(al),s(nl),s(bt),s(ol),s(il),s(Gt),s(pl),s(Ml),s(Bt),s(rl),s(yl),s(vt),s(cl),s(kt),s(hl),s(ml),s($t),s(ul),s(dl),s(Wt),s(Jl),s(Tl),s(qt),s(Ul),s(jl),s(St),s(wl),s(Il),s(gl),s(Rt),s(fl),s(Xt),s(bl),s(Cl),s(Et),s(Gl),s(xl),s(Yt),s(Bl),s(Ft),s(Zl),s(vl),s(kl),s(Pt),s(Nl),s(Kt),s($l),s(Ql),s(Wl),s(ee),s(Al),s(ql),s(le),s(Vl),s(Sl),s(ne),s(zl),s(Rl),s(ie),s(Xl),s(pe),s(_l),s(Me),s(El),s(Hl),s(ye),s(Yl),s(Fl),s(Ll),s(me),s(Dl),s(Pl),s(de),s(Kl),s(Ol),s(Te),s(ta),s(ea),s(sa),s(je),s(la),s(we),s(aa),s(Ie),s(na),s(oa),s(fe),s(ia),s(be),s(pa),s(Ma),s(Ge),s(ra),s(ya),s(Be),s(ca),s(ha),s(ve),s(ma),s(ua),s(Ne),s(da),s($e),s(Ja),s(Qe),s(Ta),s(Ua),s(Ae),s(ja),s(qe),s(wa),s(Ve),s(Ia),s(ga),s(ze),s(fa),s(ba),s(Xe),s(Ca),s(Ga),s(Ee),s(xa),s(Ba),s(Ye),s(Za),s(va),s(Le),s(ka),s(Na),s($a),s(Ke),s(Qa),s(Wa),s(es)),s(J),m(I,t),m(g,t),m(G,t),m(B,t),m(v,t),m($,t),m(W,t),m(q,t),m(S,t),m(R,t),m(_,t),m(E,t),m(Y,t),m(L,t),m(P,t),m(O,t),m(st,t),m(at,t),m(ot,t),m(pt,t),m(yt,t),m(ht,t),m(dt,t),m(Ut,t),m(It,t),m(ft,t),m(Ct,t),m(xt,t),m(Zt,t),m(Nt,t),m(Qt,t),m(At,t),m(Vt,t),m(j,t),m(zt,t),m(_t,t),m(Ht,t),m(Lt,t),m(Dt,t),m(Ot,t),m(te,t),m(se,t),m(ae,t),m(oe,t),m(re,t),m(ce,t),m(he,t),m(ue,t),m(Je,t),m(w,t),m(Ue,t),m(ge,t),m(Ce,t),m(xe,t),m(Ze,t),m(ke,t),m(We,t),m(Se,t),m(Re,t),m(_e,t),m(He,t),m(Fe,t),m(De,t),m(Pe,t),m(Oe,t)}}}const Co='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2},{"title":"Advanced: Extra inputs to chat templates","local":"advanced-extra-inputs-to-chat-templates","sections":[],"depth":2},{"title":"Advanced: Tool use / function calling","local":"advanced-tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Retrieval-augmented generation","local":"advanced-retrieval-augmented-generation","sections":[],"depth":2},{"title":"Advanced: How do chat templates work?","local":"advanced-how-do-chat-templates-work","sections":[],"depth":2},{"title":"Advanced: Adding and editing chat templates","local":"advanced-adding-and-editing-chat-templates","sections":[{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":3},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":3},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":3},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[],"depth":3}],"depth":2},{"title":"Advanced: Template writing tips","local":"advanced-template-writing-tips","sections":[{"title":"For loops","local":"for-loops","sections":[],"depth":3},{"title":"If statements","local":"if-statements","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Notes on whitespace","local":"notes-on-whitespace","sections":[],"depth":3}],"depth":2}],"depth":1}';function Go(ts){return Jo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class No extends To{constructor(J){super(),Uo(this,J,Go,bo,uo,{})}}export{No as component};
