import{s as Fe,n as Le,o as qe}from"../chunks/scheduler.25b97de1.js";import{S as Ae,i as De,g as i,s as l,r as p,A as Pe,h as o,f as s,c as n,j as Xe,u as m,x as f,k as Ye,y as Ke,a,v as r,d as c,t as u,w as d}from"../chunks/index.d9030fc9.js";import{C as h}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Oe}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as We,E as et}from"../chunks/EditOnGithub.91d95064.js";function tt(ve){let g,A,L,D,J,P,b,K,w,ke="Image feature extraction is the task of extracting semantically meaningful features given an image. This has many use cases, including image similarity and image retrieval. Moreover, most computer vision models can be used for image feature extraction, where one can remove the task-specific head (image classification, object detection etc) and get the features. These features are very useful on a higher level: edge detection, corner detection and so on. They may also contain information about the real world (e.g. what a cat looks like) depending on how deep the model is. Therefore, these outputs can be used to train new classifiers on a specific dataset.",O,y,Ce="In this guide, you will:",ee,T,_e="<li>Learn to build a simple image similarity system on top of the <code>image-feature-extraction</code> pipeline.</li> <li>Accomplish the same task with bare model inference.</li>",te,M,se,$,xe="We have two images of cats sitting on top of fish nets, one of them is generated.",ae,j,le,U,Ve='Let’s see the pipeline in action. First, initialize the pipeline. If you don’t pass any model to it, the pipeline will be automatically initialized with <a href="google/vit-base-patch16-224">google/vit-base-patch16-224</a>. If you’d like to calculate similarity, set <code>pool</code> to True.',ne,I,ie,Z,Be="To infer with <code>pipe</code> pass both images to it.",oe,W,pe,v,Ne="The output contains pooled embeddings of those two images.",me,k,re,C,Re="To get the similarity score, we need to pass them to a similarity function.",ce,_,ue,x,Ee="If you want to get the last hidden states before pooling, avoid passing any value for the <code>pool</code> parameter, as it is set to <code>False</code> by default. These hidden states are useful for training new classifiers or models based on the features from the model.",de,V,fe,B,Ge="Since the outputs are unpooled, we get the last hidden states where the first dimension is the batch size, and the last two are the embedding shape.",he,N,ge,R,Je,E,He="We can also use <code>AutoModel</code> class of transformers to get the features. <code>AutoModel</code> loads any transformers model with no task-specific head, and we can use this to get the features.",be,G,we,H,Se="Let’s write a simple function for inference. We will pass the inputs to the <code>processor</code> first and pass its outputs to the <code>model</code>.",ye,S,Te,Q,Qe="We can pass the images directly to this function and get the embeddings.",Me,z,$e,X,ze="We can get the similarity again over the embeddings.",je,Y,Ue,F,Ie,q,Ze;return J=new We({props:{title:"Image Feature Extraction",local:"image-feature-extraction",headingTag:"h1"}}),b=new Oe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"}]}}),M=new We({props:{title:"Image Similarity using image-feature-extraction Pipeline",local:"image-similarity-using-image-feature-extraction-pipeline",headingTag:"h2"}}),j=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCUyMCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGVnJTIyJTVEJTBBaW1hZ2VfcmVhbCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBaW1hZ2VfZ2VuJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybHMlNUIxJTVEJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls = [<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>, <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.jpeg&quot;</span>]
image_real = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image_gen = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),I=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFERVZJQ0UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtZmVhdHVyZS1leHRyYWN0aW9uJTIyJTJDJTIwbW9kZWxfbmFtZSUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMzg0JTIyJTJDJTIwZGV2aWNlJTNEREVWSUNFJTJDJTIwcG9vbCUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

DEVICE = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-384&quot;</span>, device=DEVICE, pool=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGUoJTVCaW1hZ2VfcmVhbCUyQyUyMGltYWdlX2dlbiU1RCk=",highlighted:"outputs = pipe([image_real, image_gen])",wrap:!1}}),k=new h({props:{code:"JTIzJTIwZ2V0JTIwdGhlJTIwbGVuZ3RoJTIwb2YlMjBhJTIwc2luZ2xlJTIwb3V0cHV0JTBBcHJpbnQobGVuKG91dHB1dHMlNUIwJTVEJTVCMCU1RCkpJTBBJTIzJTIwc2hvdyUyMG91dHB1dHMlMEFwcmludChvdXRwdXRzKSUwQSUwQSUyMyUyMDc2OCUwQSUyMyUyMCU1QiU1QiU1Qi0wLjAzOTA5MjM2OTM3NzYxMzA3JTJDJTIwMC40MzM4MTY3MDExNzM3ODIzNSUyQyUyMC0wLjA2OTEzMjU1OTAwMTQ0NTc3JTJD",highlighted:`<span class="hljs-comment"># get the length of a single output</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(outputs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))
<span class="hljs-comment"># show outputs</span>
<span class="hljs-built_in">print</span>(outputs)

<span class="hljs-comment"># 768</span>
<span class="hljs-comment"># [[[-0.03909236937761307, 0.43381670117378235, -0.06913255900144577,</span>`,wrap:!1}}),_=new h({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eSh0b3JjaC5UZW5zb3Iob3V0cHV0cyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guVGVuc29yKG91dHB1dHMlNUIxJTVEKSUyQyUyMGRpbSUzRDEpJTBBJTBBcHJpbnQoc2ltaWxhcml0eV9zY29yZSklMEElMEElMjMlMjB0ZW5zb3IoJTVCMC42MDQzJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(torch.Tensor(outputs[<span class="hljs-number">0</span>]),
                                     torch.Tensor(outputs[<span class="hljs-number">1</span>]), dim=<span class="hljs-number">1</span>)

<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6043])</span>`,wrap:!1}}),V=new h({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1mZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIlMkMlMjBkZXZpY2UlM0RERVZJQ0UpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShpbWFnZV9yZWFsKQ==",highlighted:`pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, device=DEVICE)
output = pipe(image_real)`,wrap:!1}}),N=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBcHJpbnQobnAuYXJyYXkob3V0cHV0cykuc2hhcGUpJTBBJTIzJTIwKDElMkMlMjAxOTclMkMlMjA3Njgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-built_in">print</span>(np.array(outputs).shape)
<span class="hljs-comment"># (1, 197, 768)</span>`,wrap:!1}}),R=new We({props:{title:"Getting Features and Similarities using AutoModel",local:"getting-features-and-similarities-using-automodel",headingTag:"h2"}}),G=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byhERVZJQ0Up",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(DEVICE)`,wrap:!1}}),S=new h({props:{code:"ZGVmJTIwaW5mZXIoaW1hZ2UpJTNBJTBBJTIwJTIwaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oREVWSUNFKSUwQSUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjByZXR1cm4lMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">infer</span>(<span class="hljs-params">image</span>):
  inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)
  outputs = model(**inputs)
  <span class="hljs-keyword">return</span> outputs.pooler_output`,wrap:!1}}),z=new h({props:{code:"ZW1iZWRfcmVhbCUyMCUzRCUyMGluZmVyKGltYWdlX3JlYWwpJTBBZW1iZWRfZ2VuJTIwJTNEJTIwaW5mZXIoaW1hZ2VfZ2VuKQ==",highlighted:`embed_real = infer(image_real)
embed_gen = infer(image_gen)`,wrap:!1}}),Y=new h({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eShlbWJlZF9yZWFsJTJDJTIwZW1iZWRfZ2VuJTJDJTIwZGltJTNEMSklMEFwcmludChzaW1pbGFyaXR5X3Njb3JlKSUwQSUwQSUyMyUyMHRlbnNvciglNUIwLjYwNjElNUQlMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnJTJDJTIwZ3JhZF9mbiUzRCUzQ1N1bUJhY2t3YXJkMSUzRSk=",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(embed_real, embed_gen, dim=<span class="hljs-number">1</span>)
<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6061], device=&#x27;cuda:0&#x27;, grad_fn=&lt;SumBackward1&gt;)</span>`,wrap:!1}}),F=new et({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_feature_extraction.md"}}),{c(){g=i("meta"),A=l(),L=i("p"),D=l(),p(J.$$.fragment),P=l(),p(b.$$.fragment),K=l(),w=i("p"),w.textContent=ke,O=l(),y=i("p"),y.textContent=Ce,ee=l(),T=i("ul"),T.innerHTML=_e,te=l(),p(M.$$.fragment),se=l(),$=i("p"),$.textContent=xe,ae=l(),p(j.$$.fragment),le=l(),U=i("p"),U.innerHTML=Ve,ne=l(),p(I.$$.fragment),ie=l(),Z=i("p"),Z.innerHTML=Be,oe=l(),p(W.$$.fragment),pe=l(),v=i("p"),v.textContent=Ne,me=l(),p(k.$$.fragment),re=l(),C=i("p"),C.textContent=Re,ce=l(),p(_.$$.fragment),ue=l(),x=i("p"),x.innerHTML=Ee,de=l(),p(V.$$.fragment),fe=l(),B=i("p"),B.textContent=Ge,he=l(),p(N.$$.fragment),ge=l(),p(R.$$.fragment),Je=l(),E=i("p"),E.innerHTML=He,be=l(),p(G.$$.fragment),we=l(),H=i("p"),H.innerHTML=Se,ye=l(),p(S.$$.fragment),Te=l(),Q=i("p"),Q.textContent=Qe,Me=l(),p(z.$$.fragment),$e=l(),X=i("p"),X.textContent=ze,je=l(),p(Y.$$.fragment),Ue=l(),p(F.$$.fragment),Ie=l(),q=i("p"),this.h()},l(e){const t=Pe("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),A=n(e),L=o(e,"P",{}),Xe(L).forEach(s),D=n(e),m(J.$$.fragment,e),P=n(e),m(b.$$.fragment,e),K=n(e),w=o(e,"P",{"data-svelte-h":!0}),f(w)!=="svelte-htpxsg"&&(w.textContent=ke),O=n(e),y=o(e,"P",{"data-svelte-h":!0}),f(y)!=="svelte-dkb44i"&&(y.textContent=Ce),ee=n(e),T=o(e,"UL",{"data-svelte-h":!0}),f(T)!=="svelte-o9mygf"&&(T.innerHTML=_e),te=n(e),m(M.$$.fragment,e),se=n(e),$=o(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-1y1lzmz"&&($.textContent=xe),ae=n(e),m(j.$$.fragment,e),le=n(e),U=o(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-ufkt7t"&&(U.innerHTML=Ve),ne=n(e),m(I.$$.fragment,e),ie=n(e),Z=o(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1wqrlcg"&&(Z.innerHTML=Be),oe=n(e),m(W.$$.fragment,e),pe=n(e),v=o(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-ejn9fo"&&(v.textContent=Ne),me=n(e),m(k.$$.fragment,e),re=n(e),C=o(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-7ov6zk"&&(C.textContent=Re),ce=n(e),m(_.$$.fragment,e),ue=n(e),x=o(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-1t8cfg9"&&(x.innerHTML=Ee),de=n(e),m(V.$$.fragment,e),fe=n(e),B=o(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-u3d9d7"&&(B.textContent=Ge),he=n(e),m(N.$$.fragment,e),ge=n(e),m(R.$$.fragment,e),Je=n(e),E=o(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-18d7a3m"&&(E.innerHTML=He),be=n(e),m(G.$$.fragment,e),we=n(e),H=o(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1mcm377"&&(H.innerHTML=Se),ye=n(e),m(S.$$.fragment,e),Te=n(e),Q=o(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1ej6c6d"&&(Q.textContent=Qe),Me=n(e),m(z.$$.fragment,e),$e=n(e),X=o(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1t2j36n"&&(X.textContent=ze),je=n(e),m(Y.$$.fragment,e),Ue=n(e),m(F.$$.fragment,e),Ie=n(e),q=o(e,"P",{}),Xe(q).forEach(s),this.h()},h(){Ye(g,"name","hf:doc:metadata"),Ye(g,"content",st)},m(e,t){Ke(document.head,g),a(e,A,t),a(e,L,t),a(e,D,t),r(J,e,t),a(e,P,t),r(b,e,t),a(e,K,t),a(e,w,t),a(e,O,t),a(e,y,t),a(e,ee,t),a(e,T,t),a(e,te,t),r(M,e,t),a(e,se,t),a(e,$,t),a(e,ae,t),r(j,e,t),a(e,le,t),a(e,U,t),a(e,ne,t),r(I,e,t),a(e,ie,t),a(e,Z,t),a(e,oe,t),r(W,e,t),a(e,pe,t),a(e,v,t),a(e,me,t),r(k,e,t),a(e,re,t),a(e,C,t),a(e,ce,t),r(_,e,t),a(e,ue,t),a(e,x,t),a(e,de,t),r(V,e,t),a(e,fe,t),a(e,B,t),a(e,he,t),r(N,e,t),a(e,ge,t),r(R,e,t),a(e,Je,t),a(e,E,t),a(e,be,t),r(G,e,t),a(e,we,t),a(e,H,t),a(e,ye,t),r(S,e,t),a(e,Te,t),a(e,Q,t),a(e,Me,t),r(z,e,t),a(e,$e,t),a(e,X,t),a(e,je,t),r(Y,e,t),a(e,Ue,t),r(F,e,t),a(e,Ie,t),a(e,q,t),Ze=!0},p:Le,i(e){Ze||(c(J.$$.fragment,e),c(b.$$.fragment,e),c(M.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(W.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(R.$$.fragment,e),c(G.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),Ze=!0)},o(e){u(J.$$.fragment,e),u(b.$$.fragment,e),u(M.$$.fragment,e),u(j.$$.fragment,e),u(I.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),Ze=!1},d(e){e&&(s(A),s(L),s(D),s(P),s(K),s(w),s(O),s(y),s(ee),s(T),s(te),s(se),s($),s(ae),s(le),s(U),s(ne),s(ie),s(Z),s(oe),s(pe),s(v),s(me),s(re),s(C),s(ce),s(ue),s(x),s(de),s(fe),s(B),s(he),s(ge),s(Je),s(E),s(be),s(we),s(H),s(ye),s(Te),s(Q),s(Me),s($e),s(X),s(je),s(Ue),s(Ie),s(q)),s(g),d(J,e),d(b,e),d(M,e),d(j,e),d(I,e),d(W,e),d(k,e),d(_,e),d(V,e),d(N,e),d(R,e),d(G,e),d(S,e),d(z,e),d(Y,e),d(F,e)}}}const st='{"title":"Image Feature Extraction","local":"image-feature-extraction","sections":[{"title":"Image Similarity using image-feature-extraction Pipeline","local":"image-similarity-using-image-feature-extraction-pipeline","sections":[],"depth":2},{"title":"Getting Features and Similarities using AutoModel","local":"getting-features-and-similarities-using-automodel","sections":[],"depth":2}],"depth":1}';function at(ve){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends Ae{constructor(g){super(),De(this,g,at,tt,Fe,{})}}export{mt as component};
