import{s as ie,n as ce,o as ye}from"../chunks/scheduler.65852ee5.js";import{S as Te,i as re,g as M,s as a,r as J,A as we,h as o,f as e,c as n,j as oe,u as i,x as p,k as pe,y as ue,a as t,v as c,d as y,t as T,w as r}from"../chunks/index.65a1b999.js";import{D as de,C as w}from"../chunks/DocNotebookDropdown.25e0a31d.js";import{H as Je,E as Ue}from"../chunks/EditOnGithub.885169e7.js";function je(gs){let u,ml,Ul,hl,d,Il,U,bl,j,Zs='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',gl,m,Bs='<p>This tutorial is advanced. You should have notions from <a href="advanced_rag">this other cookbook</a> first!</p>',Zl,h,Cs="<p>Reminder: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.</p>",Bl,I,fs="But vanilla RAG has limitations, most importantly these two:",Cl,b,Gs="<li>It <strong>performs only one retrieval step</strong>: if the results are bad, the generation in turn will be bad.</li> <li><strong>Semantic similarity is computed with the <em>user query</em> as a reference</strong>, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",fl,g,Ns="But we can alleviate these problems by making a <strong>RAG agent: very simply, an agent armed with a retriever tool!</strong>",Gl,Z,Vs="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",Nl,B,Ws="So it should naively recover some advanced RAG techniques!",Vl,C,vs='<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a></li> <li>The agent can the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a></li>',Wl,f,Rs="Let’s build this system. 🛠️",vl,G,Qs="Run the line below to install required dependencies:",Rl,N,Ql,V,Xs="Let’s login in order to call the HF Inference API:",Xl,W,kl,v,ks="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",El,R,ql,Q,Es="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",Yl,X,qs=`We use <a href="https://python.langchain.com/" rel="nofollow">LangChain</a> for its excellent vector database utilities.
For the embedding model, we use <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> since it performed well in our <code>RAG_evaluation</code> cookbook.`,_l,k,Hl,E,Ys=`Splitting documents...
`,Al,q,_s="Now the database is ready: let’s build our agentic RAG system!",Sl,Y,Hs="👉 We only need a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",xl,_,As='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',Fl,H,zl,A,Ss="Now it’s straightforward to create an agent that leverages this tool!",$l,S,xs="The agent will need these arguments upon initialization:",Ll,x,Fs="<li><em><code>tools</code></em>: a list of tools that the agent will be able to call.</li> <li><em><code>model</code></em>: the LLM that powers the agent.</li>",Dl,F,zs='Our <code>model</code> must be a callable that takes as input a list of <a href="https://huggingface.co/docs/transformers/main/chat_templating" rel="nofollow">messages</a> and returns text. It also needs to accept a <code>stop_sequences</code> argument that indicates when to stop its generation. For convenience, we directly use the <code>HfApiModel</code> class provided in the package to get a LLM engine that calls our <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Inference API</a>.',Pl,z,$s='And we use <a href="https://huggingface.co/meta-llama/Llama-3.1-70B-Instruct" rel="nofollow">meta-llama/Llama-3.1-70B-Instruct</a>, served for free on Hugging Face’s Inference API!',Kl,$,Ls='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',Ol,L,ls,D,Ds="Since we initialized the agent as a <code>ReactJsonAgent</code>, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as JSON blobs (you could replace this prompt template with your own as needed).",ss,P,Ps="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, parsing the tool call JSON blobs and executing these tool calls, all in a loop that ends only when the final answer is provided.",es,K,ts,O,Ks=`Final output:
To push a model to the Hub, you can use the push_to_hub() method after training. You can also use the PushToHubCallback to upload checkpoints regularly during a longer training run. Additionally, you can push the model up to the hub using the api.upload_folder() method.
`,as,ll,ns,sl,Os="Does the agent setup make a better RAG system? Well, let’s compare it to a standard RAG system using LLM Judge!",Ms,el,le='We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-70B-Instruct</a> for evaluation since it’s one of the strongest OS models we tested for LLM judge use cases.',os,tl,ps,al,se="Before running the test let’s make the agent less verbose.",Js,nl,is,Ml,cs,ol,ys,pl,ee='The evaluation prompt follows some of the best principles shown in <a href="llm_judge">our llm_judge cookbook</a>: it follows a small integer Likert scale, has clear criteria, and a description for each score.',Ts,Jl,rs,il,ws,cl,us,yl,ds,Tl,te=`Average score for agentic RAG: 86.9%
Average score for standard RAG: 73.1%
`,Us,rl,ae="<strong>Let us recap: the Agent setup improves scores by 14% compared to a standard RAG!</strong> (from 73.1% to 86.9%)",js,wl,ne="This is a great improvement, with a very simple setup 🚀",ms,ul,Me="(For a baseline, using Llama-3-70B without the knowledge base got 36%)",hs,dl,Is,jl,bs;return d=new de({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_rag.ipynb"}]}}),U=new Je({props:{title:"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀",local:"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-",headingTag:"h1"}}),N=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtY3B1JTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install pandas langchain langchain-community sentence-transformers faiss-cpu smolagents --upgrade -q",wrap:!1}}),W=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),R=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),k=new w({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLnZlY3RvcnN0b3JlcyUyMGltcG9ydCUyMEZBSVNTJTBBZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LnZlY3RvcnN0b3Jlcy51dGlscyUyMGltcG9ydCUyMERpc3RhbmNlU3RyYXRlZ3klMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBdGV4dF9zcGxpdHRlciUyMCUzRCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlci5mcm9tX2h1Z2dpbmdmYWNlX3Rva2VuaXplciglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0aGVubHBlciUyRmd0ZS1zbWFsbCUyMiklMkMlMEElMjAlMjAlMjAlMjBjaHVua19zaXplJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwY2h1bmtfb3ZlcmxhcCUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwYWRkX3N0YXJ0X2luZGV4JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmlwX3doaXRlc3BhY2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwc2VwYXJhdG9ycyUzRCU1QiUyMiU1Q24lNUNuJTIyJTJDJTIwJTIyJTVDbiUyMiUyQyUyMCUyMi4lMjIlMkMlMjAlMjIlMjAlMjIlMkMlMjAlMjIlMjIlNUQlMkMlMEEpJTBBJTBBJTIzJTIwU3BsaXQlMjBkb2NzJTIwYW5kJTIwa2VlcCUyMG9ubHklMjB1bmlxdWUlMjBvbmVzJTBBcHJpbnQoJTIyU3BsaXR0aW5nJTIwZG9jdW1lbnRzLi4uJTIyKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwJTVCJTVEJTBBdW5pcXVlX3RleHRzJTIwJTNEJTIwJTdCJTdEJTBBZm9yJTIwZG9jJTIwaW4lMjB0cWRtKHNvdXJjZV9kb2NzKSUzQSUwQSUyMCUyMCUyMCUyMG5ld19kb2NzJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoJTVCZG9jJTVEKSUwQSUyMCUyMCUyMCUyMGZvciUyMG5ld19kb2MlMjBpbiUyMG5ld19kb2NzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBuZXdfZG9jLnBhZ2VfY29udGVudCUyMG5vdCUyMGluJTIwdW5pcXVlX3RleHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdW5pcXVlX3RleHRzJTVCbmV3X2RvYy5wYWdlX2NvbnRlbnQlNUQlMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQuYXBwZW5kKG5ld19kb2MpJTBBJTBBcHJpbnQoJTIyRW1iZWRkaW5nJTIwZG9jdW1lbnRzLi4uJTIwVGhpcyUyMHNob3VsZCUyMHRha2UlMjBhJTIwZmV3JTIwbWludXRlcyUyMCg1JTIwbWludXRlcyUyMG9uJTIwTWFjQm9vayUyMHdpdGglMjBNMSUyMFBybyklMjIpJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJ0aGVubHBlciUyRmd0ZS1zbWFsbCUyMiklMEF2ZWN0b3JkYiUyMCUzRCUyMEZBSVNTLmZyb21fZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUzRGRvY3NfcHJvY2Vzc2VkJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTNEZW1iZWRkaW5nX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZGlzdGFuY2Vfc3RyYXRlZ3klM0REaXN0YW5jZVN0cmF0ZWd5LkNPU0lORSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

<span class="hljs-meta">&gt;&gt;&gt; </span>source_docs = [
<span class="hljs-meta">... </span>    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>    AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>),
<span class="hljs-meta">... </span>    chunk_size=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    chunk_overlap=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Split docs and keep only unique ones</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Splitting documents...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = []
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_texts = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(source_docs):
<span class="hljs-meta">... </span>    new_docs = text_splitter.split_documents([doc])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> new_doc <span class="hljs-keyword">in</span> new_docs:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> new_doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[new_doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed.append(new_doc)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Embedding documents... This should take a few minutes (5 minutes on MacBook with M1 Pro)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vectordb = FAISS.from_documents(
<span class="hljs-meta">... </span>    documents=docs_processed,
<span class="hljs-meta">... </span>    embedding=embedding_model,
<span class="hljs-meta">... </span>    distance_strategy=DistanceStrategy.COSINE,
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Using semantic similarity, retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.vectordb.similarity_search(
            query,
            k=<span class="hljs-number">7</span>,
        )

        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [<span class="hljs-string">f&quot;===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)]
        )`,wrap:!1}}),L=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbENhbGxpbmdBZ2VudCUwQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLTcwQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIpJTBBYWdlbnQlMjAlM0QlMjBUb29sQ2FsbGluZ0FnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, ToolCallingAgent

model = HfApiModel(<span class="hljs-string">&quot;meta-llama/Llama-3.1-70B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb)
agent = ToolCallingAgent(tools=[retriever_tool], model=model)`,wrap:!1}}),K=new w({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkhvdyUyMGNhbiUyMEklMjBwdXNoJTIwYSUyMG1vZGVsJTIwdG8lMjB0aGUlMjBIdWIlM0YlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;How can I push a model to the Hub?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),ll=new Je({props:{title:"Agentic RAG vs. standard RAG",local:"agentic-rag-vs-standard-rag",headingTag:"h2"}}),tl=new w({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),nl=new w({props:{code:"aW1wb3J0JTIwbG9nZ2luZyUwQSUwQWFnZW50LmxvZ2dlci5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcpJTIwJTIwJTIzJTIwTGV0J3MlMjByZWR1Y2UlMjB0aGUlMjBhZ2VudCdzJTIwdmVyYm9zaXR5JTIwbGV2ZWwlMEElMEFldmFsX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIybS1yaWMlMkZodWdnaW5nZmFjZV9kb2NfcWFfZXZhbCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> logging

agent.logger.setLevel(logging.WARNING)  <span class="hljs-comment"># Let&#x27;s reduce the agent&#x27;s verbosity level</span>

eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Ml=new w({props:{code:"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",highlighted:`outputs_agentic_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]

    enhanced_question = <span class="hljs-string">f&quot;&quot;&quot;Using the information contained in your knowledge base, which you can access with the &#x27;retriever&#x27; tool,
give a comprehensive answer to the question below.
Respond only to the question asked, response should be concise and relevant to the question.
If you cannot find information, do not give up and try calling your retriever again with different arguments!
Make sure to have covered the question completely by calling the retriever tool several times with semantically different queries.
Your queries should not be questions but affirmative form sentences: e.g. rather than &quot;How do I load a model from the Hub in bf16?&quot;, query should be &quot;load a model from the Hub bf16 weights&quot;.

Question:
<span class="hljs-subst">{question}</span>&quot;&quot;&quot;</span>
    answer = agent.run(enhanced_question)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_agentic_rag.append(results_agentic)`,wrap:!1}}),ol=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

reader_llm = InferenceClient(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

outputs_standard_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    context = retriever_tool(question)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Given the question and supporting documents below, give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If you cannot find information, do not give up and try calling your retriever again with different arguments!

Question:
<span class="hljs-subst">{question}</span>

<span class="hljs-subst">{context}</span>
&quot;&quot;&quot;</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    answer = reader_llm.chat_completion(messages).choices[<span class="hljs-number">0</span>].message.content

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_standard_rag.append(results_agentic)`,wrap:!1}}),Jl=new w({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;You are a fair evaluator language model.

You will be given an instruction, a response to evaluate, a reference answer that gets a score of 3, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 3. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 3}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.
5. Do not score conciseness: a correct answer that covers the question should receive max score, even if it contains additional useless information.

The instruction to evaluate:
{instruction}

Response to evaluate:
{response}

Reference Answer (Score 3):
{reference_answer}

Score Rubrics:
[Is the response complete, accurate, and factual based on the reference answer?]
Score 1: The response is completely incomplete, inaccurate, and/or not factual.
Score 2: The response is somewhat complete, accurate, and/or factual.
Score 3: The response is completely complete, accurate, and/or factual.

Feedback:&quot;&quot;&quot;</span>`,wrap:!1}}),il=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWV2YWx1YXRpb25fY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

evaluation_client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.1-70B-Instruct&quot;</span>)`,wrap:!1}}),cl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

results = {}
<span class="hljs-keyword">for</span> system_type, outputs <span class="hljs-keyword">in</span> [
    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
]:
    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(outputs):
        eval_prompt = EVALUATION_PROMPT.<span class="hljs-built_in">format</span>(
            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
        )
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: eval_prompt},
        ]

        eval_result = evaluation_client.text_generation(eval_prompt, max_new_tokens=<span class="hljs-number">1000</span>)
        <span class="hljs-keyword">try</span>:
            feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
            experiment[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>] = score
            experiment[<span class="hljs-string">&quot;eval_feedback_LLM_judge&quot;</span>] = feedback
        <span class="hljs-keyword">except</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Parsing failed - output was: <span class="hljs-subst">{eval_result}</span>&quot;</span>)

    results[system_type] = pd.DataFrame.from_dict(outputs)
    results[system_type] = results[system_type].loc[~results[system_type][<span class="hljs-string">&quot;generated_answer&quot;</span>].<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;Error&quot;</span>)]`,wrap:!1}}),yl=new w({props:{code:"REVGQVVMVF9TQ09SRSUyMCUzRCUyMDIlMjAlMjAlMjMlMjBHaXZlJTIwYXZlcmFnZSUyMHNjb3JlJTIwd2hlbmV2ZXIlMjBzY29yaW5nJTIwZmFpbHMlMEElMEElMEFkZWYlMjBmaWxsX3Njb3JlKHgpJTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW50KHgpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwREVGQVVMVF9TQ09SRSUwQSUwQSUwQWZvciUyMHN5c3RlbV90eXBlJTJDJTIwb3V0cHV0cyUyMGluJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMmFnZW50aWMlMjIlMkMlMjBvdXRwdXRzX2FnZW50aWNfcmFnKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJzdGFuZGFyZCUyMiUyQyUyMG91dHB1dHNfc3RhbmRhcmRfcmFnKSUyQyUwQSU1RCUzQSUwQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCU1QiUyMmV2YWxfc2NvcmVfTExNX2p1ZGdlX2ludCUyMiU1RCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzJTVCc3lzdGVtX3R5cGUlNUQlNUIlMjJldmFsX3Njb3JlX0xMTV9qdWRnZSUyMiU1RC5maWxsbmEoREVGQVVMVF9TQ09SRSkuYXBwbHkoZmlsbF9zY29yZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyU1QnN5c3RlbV90eXBlJTVEJTVCJTIyZXZhbF9zY29yZV9MTE1fanVkZ2VfaW50JTIyJTVEJTIwJTNEJTIwKHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCU1QiUyMmV2YWxfc2NvcmVfTExNX2p1ZGdlX2ludCUyMiU1RCUyMC0lMjAxKSUyMCUyRiUyMDIlMEElMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyQXZlcmFnZSUyMHNjb3JlJTIwZm9yJTIwJTdCc3lzdGVtX3R5cGUlN0QlMjBSQUclM0ElMjAlN0JyZXN1bHRzJTVCc3lzdGVtX3R5cGUlNUQlNUInZXZhbF9zY29yZV9MTE1fanVkZ2VfaW50JyU1RC5tZWFuKCkqMTAwJTNBLjFmJTdEJTI1JTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DEFAULT_SCORE = <span class="hljs-number">2</span>  <span class="hljs-comment"># Give average score whenever scoring fails</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">fill_score</span>(<span class="hljs-params">x</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">int</span>(x)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> DEFAULT_SCORE


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> system_type, outputs <span class="hljs-keyword">in</span> [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
<span class="hljs-meta">... </span>]:

<span class="hljs-meta">... </span>    results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (
<span class="hljs-meta">... </span>        results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>].fillna(DEFAULT_SCORE).apply(fill_score)
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">2</span>

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Average score for <span class="hljs-subst">{system_type}</span> RAG: <span class="hljs-subst">{results[system_type][<span class="hljs-string">&#x27;eval_score_LLM_judge_int&#x27;</span>].mean()*<span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%&quot;</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),dl=new Ue({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_rag.md"}}),{c(){u=M("meta"),ml=a(),Ul=M("p"),hl=a(),J(d.$$.fragment),Il=a(),J(U.$$.fragment),bl=a(),j=M("p"),j.innerHTML=Zs,gl=a(),m=M("blockquote"),m.innerHTML=Bs,Zl=a(),h=M("blockquote"),h.innerHTML=Cs,Bl=a(),I=M("p"),I.textContent=fs,Cl=a(),b=M("ul"),b.innerHTML=Gs,fl=a(),g=M("p"),g.innerHTML=Ns,Gl=a(),Z=M("p"),Z.textContent=Vs,Nl=a(),B=M("p"),B.textContent=Ws,Vl=a(),C=M("ul"),C.innerHTML=vs,Wl=a(),f=M("p"),f.textContent=Rs,vl=a(),G=M("p"),G.textContent=Qs,Rl=a(),J(N.$$.fragment),Ql=a(),V=M("p"),V.textContent=Xs,Xl=a(),J(W.$$.fragment),kl=a(),v=M("p"),v.innerHTML=ks,El=a(),J(R.$$.fragment),ql=a(),Q=M("p"),Q.textContent=Es,Yl=a(),X=M("p"),X.innerHTML=qs,_l=a(),J(k.$$.fragment),Hl=a(),E=M("pre"),E.textContent=Ys,Al=a(),q=M("p"),q.textContent=_s,Sl=a(),Y=M("p"),Y.innerHTML=Hs,xl=a(),_=M("p"),_.innerHTML=As,Fl=a(),J(H.$$.fragment),zl=a(),A=M("p"),A.textContent=Ss,$l=a(),S=M("p"),S.textContent=xs,Ll=a(),x=M("ul"),x.innerHTML=Fs,Dl=a(),F=M("p"),F.innerHTML=zs,Pl=a(),z=M("p"),z.innerHTML=$s,Kl=a(),$=M("p"),$.innerHTML=Ls,Ol=a(),J(L.$$.fragment),ls=a(),D=M("p"),D.innerHTML=Ds,ss=a(),P=M("p"),P.innerHTML=Ps,es=a(),J(K.$$.fragment),ts=a(),O=M("pre"),O.textContent=Ks,as=a(),J(ll.$$.fragment),ns=a(),sl=M("p"),sl.textContent=Os,Ms=a(),el=M("p"),el.innerHTML=le,os=a(),J(tl.$$.fragment),ps=a(),al=M("p"),al.textContent=se,Js=a(),J(nl.$$.fragment),is=a(),J(Ml.$$.fragment),cs=a(),J(ol.$$.fragment),ys=a(),pl=M("p"),pl.innerHTML=ee,Ts=a(),J(Jl.$$.fragment),rs=a(),J(il.$$.fragment),ws=a(),J(cl.$$.fragment),us=a(),J(yl.$$.fragment),ds=a(),Tl=M("pre"),Tl.textContent=te,Us=a(),rl=M("p"),rl.innerHTML=ae,js=a(),wl=M("p"),wl.textContent=ne,ms=a(),ul=M("p"),ul.textContent=Me,hs=a(),J(dl.$$.fragment),Is=a(),jl=M("p"),this.h()},l(l){const s=we("svelte-u9bgzb",document.head);u=o(s,"META",{name:!0,content:!0}),s.forEach(e),ml=n(l),Ul=o(l,"P",{}),oe(Ul).forEach(e),hl=n(l),i(d.$$.fragment,l),Il=n(l),i(U.$$.fragment,l),bl=n(l),j=o(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xlqnsv"&&(j.innerHTML=Zs),gl=n(l),m=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(m)!=="svelte-ut7thx"&&(m.innerHTML=Bs),Zl=n(l),h=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(h)!=="svelte-1uj6u2q"&&(h.innerHTML=Cs),Bl=n(l),I=o(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-le6dse"&&(I.textContent=fs),Cl=n(l),b=o(l,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-1tet28w"&&(b.innerHTML=Gs),fl=n(l),g=o(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-zgftoz"&&(g.innerHTML=Ns),Gl=n(l),Z=o(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1oxrjf8"&&(Z.textContent=Vs),Nl=n(l),B=o(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-i3m4dm"&&(B.textContent=Ws),Vl=n(l),C=o(l,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-16julm3"&&(C.innerHTML=vs),Wl=n(l),f=o(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-18mh92s"&&(f.textContent=Rs),vl=n(l),G=o(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-16cuoal"&&(G.textContent=Qs),Rl=n(l),i(N.$$.fragment,l),Ql=n(l),V=o(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-64fox6"&&(V.textContent=Xs),Xl=n(l),i(W.$$.fragment,l),kl=n(l),v=o(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-zy8yuo"&&(v.innerHTML=ks),El=n(l),i(R.$$.fragment,l),ql=n(l),Q=o(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-11htfoc"&&(Q.textContent=Es),Yl=n(l),X=o(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-pr8fqf"&&(X.innerHTML=qs),_l=n(l),i(k.$$.fragment,l),Hl=n(l),E=o(l,"PRE",{"data-svelte-h":!0}),p(E)!=="svelte-bkjqrc"&&(E.textContent=Ys),Al=n(l),q=o(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1tpog71"&&(q.textContent=_s),Sl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-675szm"&&(Y.innerHTML=Hs),xl=n(l),_=o(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-yb70ev"&&(_.innerHTML=As),Fl=n(l),i(H.$$.fragment,l),zl=n(l),A=o(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1ma3u1b"&&(A.textContent=Ss),$l=n(l),S=o(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-14g5yev"&&(S.textContent=xs),Ll=n(l),x=o(l,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1plagnt"&&(x.innerHTML=Fs),Dl=n(l),F=o(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1tg0it8"&&(F.innerHTML=zs),Pl=n(l),z=o(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1am6oti"&&(z.innerHTML=$s),Kl=n(l),$=o(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1faawbb"&&($.innerHTML=Ls),Ol=n(l),i(L.$$.fragment,l),ls=n(l),D=o(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1dmyh52"&&(D.innerHTML=Ds),ss=n(l),P=o(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-143bxk3"&&(P.innerHTML=Ps),es=n(l),i(K.$$.fragment,l),ts=n(l),O=o(l,"PRE",{"data-svelte-h":!0}),p(O)!=="svelte-wsg97n"&&(O.textContent=Ks),as=n(l),i(ll.$$.fragment,l),ns=n(l),sl=o(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-to6drr"&&(sl.textContent=Os),Ms=n(l),el=o(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-yr66ap"&&(el.innerHTML=le),os=n(l),i(tl.$$.fragment,l),ps=n(l),al=o(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-708yv1"&&(al.textContent=se),Js=n(l),i(nl.$$.fragment,l),is=n(l),i(Ml.$$.fragment,l),cs=n(l),i(ol.$$.fragment,l),ys=n(l),pl=o(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-lt6qr6"&&(pl.innerHTML=ee),Ts=n(l),i(Jl.$$.fragment,l),rs=n(l),i(il.$$.fragment,l),ws=n(l),i(cl.$$.fragment,l),us=n(l),i(yl.$$.fragment,l),ds=n(l),Tl=o(l,"PRE",{"data-svelte-h":!0}),p(Tl)!=="svelte-1it3mki"&&(Tl.textContent=te),Us=n(l),rl=o(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-en509u"&&(rl.innerHTML=ae),js=n(l),wl=o(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1fi7cw9"&&(wl.textContent=ne),ms=n(l),ul=o(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1y4e8t1"&&(ul.textContent=Me),hs=n(l),i(dl.$$.fragment,l),Is=n(l),jl=o(l,"P",{}),oe(jl).forEach(e),this.h()},h(){pe(u,"name","hf:doc:metadata"),pe(u,"content",me)},m(l,s){ue(document.head,u),t(l,ml,s),t(l,Ul,s),t(l,hl,s),c(d,l,s),t(l,Il,s),c(U,l,s),t(l,bl,s),t(l,j,s),t(l,gl,s),t(l,m,s),t(l,Zl,s),t(l,h,s),t(l,Bl,s),t(l,I,s),t(l,Cl,s),t(l,b,s),t(l,fl,s),t(l,g,s),t(l,Gl,s),t(l,Z,s),t(l,Nl,s),t(l,B,s),t(l,Vl,s),t(l,C,s),t(l,Wl,s),t(l,f,s),t(l,vl,s),t(l,G,s),t(l,Rl,s),c(N,l,s),t(l,Ql,s),t(l,V,s),t(l,Xl,s),c(W,l,s),t(l,kl,s),t(l,v,s),t(l,El,s),c(R,l,s),t(l,ql,s),t(l,Q,s),t(l,Yl,s),t(l,X,s),t(l,_l,s),c(k,l,s),t(l,Hl,s),t(l,E,s),t(l,Al,s),t(l,q,s),t(l,Sl,s),t(l,Y,s),t(l,xl,s),t(l,_,s),t(l,Fl,s),c(H,l,s),t(l,zl,s),t(l,A,s),t(l,$l,s),t(l,S,s),t(l,Ll,s),t(l,x,s),t(l,Dl,s),t(l,F,s),t(l,Pl,s),t(l,z,s),t(l,Kl,s),t(l,$,s),t(l,Ol,s),c(L,l,s),t(l,ls,s),t(l,D,s),t(l,ss,s),t(l,P,s),t(l,es,s),c(K,l,s),t(l,ts,s),t(l,O,s),t(l,as,s),c(ll,l,s),t(l,ns,s),t(l,sl,s),t(l,Ms,s),t(l,el,s),t(l,os,s),c(tl,l,s),t(l,ps,s),t(l,al,s),t(l,Js,s),c(nl,l,s),t(l,is,s),c(Ml,l,s),t(l,cs,s),c(ol,l,s),t(l,ys,s),t(l,pl,s),t(l,Ts,s),c(Jl,l,s),t(l,rs,s),c(il,l,s),t(l,ws,s),c(cl,l,s),t(l,us,s),c(yl,l,s),t(l,ds,s),t(l,Tl,s),t(l,Us,s),t(l,rl,s),t(l,js,s),t(l,wl,s),t(l,ms,s),t(l,ul,s),t(l,hs,s),c(dl,l,s),t(l,Is,s),t(l,jl,s),bs=!0},p:ce,i(l){bs||(y(d.$$.fragment,l),y(U.$$.fragment,l),y(N.$$.fragment,l),y(W.$$.fragment,l),y(R.$$.fragment,l),y(k.$$.fragment,l),y(H.$$.fragment,l),y(L.$$.fragment,l),y(K.$$.fragment,l),y(ll.$$.fragment,l),y(tl.$$.fragment,l),y(nl.$$.fragment,l),y(Ml.$$.fragment,l),y(ol.$$.fragment,l),y(Jl.$$.fragment,l),y(il.$$.fragment,l),y(cl.$$.fragment,l),y(yl.$$.fragment,l),y(dl.$$.fragment,l),bs=!0)},o(l){T(d.$$.fragment,l),T(U.$$.fragment,l),T(N.$$.fragment,l),T(W.$$.fragment,l),T(R.$$.fragment,l),T(k.$$.fragment,l),T(H.$$.fragment,l),T(L.$$.fragment,l),T(K.$$.fragment,l),T(ll.$$.fragment,l),T(tl.$$.fragment,l),T(nl.$$.fragment,l),T(Ml.$$.fragment,l),T(ol.$$.fragment,l),T(Jl.$$.fragment,l),T(il.$$.fragment,l),T(cl.$$.fragment,l),T(yl.$$.fragment,l),T(dl.$$.fragment,l),bs=!1},d(l){l&&(e(ml),e(Ul),e(hl),e(Il),e(bl),e(j),e(gl),e(m),e(Zl),e(h),e(Bl),e(I),e(Cl),e(b),e(fl),e(g),e(Gl),e(Z),e(Nl),e(B),e(Vl),e(C),e(Wl),e(f),e(vl),e(G),e(Rl),e(Ql),e(V),e(Xl),e(kl),e(v),e(El),e(ql),e(Q),e(Yl),e(X),e(_l),e(Hl),e(E),e(Al),e(q),e(Sl),e(Y),e(xl),e(_),e(Fl),e(zl),e(A),e($l),e(S),e(Ll),e(x),e(Dl),e(F),e(Pl),e(z),e(Kl),e($),e(Ol),e(ls),e(D),e(ss),e(P),e(es),e(ts),e(O),e(as),e(ns),e(sl),e(Ms),e(el),e(os),e(ps),e(al),e(Js),e(is),e(cs),e(ys),e(pl),e(Ts),e(rs),e(ws),e(us),e(ds),e(Tl),e(Us),e(rl),e(js),e(wl),e(ms),e(ul),e(hs),e(Is),e(jl)),e(u),r(d,l),r(U,l),r(N,l),r(W,l),r(R,l),r(k,l),r(H,l),r(L,l),r(K,l),r(ll,l),r(tl,l),r(nl,l),r(Ml,l),r(ol,l),r(Jl,l),r(il,l),r(cl,l),r(yl,l),r(dl,l)}}}const me='{"title":"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀","local":"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-","sections":[{"title":"Agentic RAG vs. standard RAG","local":"agentic-rag-vs-standard-rag","sections":[],"depth":2}],"depth":1}';function he(gs){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends Te{constructor(u){super(),re(this,u,he,je,ie,{})}}export{Be as component};
