import{s as pt,f as gt,o as ht,n as ze}from"../chunks/scheduler.9bc65507.js";import{S as ft,i as ut,g as l,s,r as g,A as _t,h as m,f as o,c as r,j as k,u as h,x as v,k as U,y as p,a as n,v as f,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as mt}from"../chunks/Tip.c2ecdbf4.js";import{D as ge}from"../chunks/Docstring.17db21ae.js";import{C as dt}from"../chunks/CodeBlock.54a9f38d.js";import{E as ct}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as he}from"../chunks/Heading.342b1fa6.js";function bt(x){let a,M="The model expects both the image and trimap (concatenated) as input. Use <code>ViTMatteImageProcessor</code> for this purpose.";return{c(){a=l("p"),a.innerHTML=M},l(c){a=m(c,"P",{"data-svelte-h":!0}),v(a)!=="svelte-8i6ct1"&&(a.innerHTML=M)},m(c,d){n(c,a,d)},p:ze,d(c){c&&o(a)}}}function vt(x){let a,M="Example:",c,d,y;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdE1hdHRlQ29uZmlnJTJDJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVmlUTWF0dGUlMjBodXN0dmwlMkZ2aXRtYXR0ZS1zbWFsbC1jb21wb3NpdGlvbi0xayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBWaXRNYXR0ZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBodXN0dmwlMkZ2aXRtYXR0ZS1zbWFsbC1jb21wb3NpdGlvbi0xayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmcoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitMatteConfig, VitMatteForImageMatting

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ViTMatte hustvl/vitmatte-small-composition-1k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VitMatteConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/vitmatte-small-composition-1k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitMatteForImageMatting(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=l("p"),a.textContent=M,c=s(),g(d.$$.fragment)},l(i){a=m(i,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=M),c=r(i),h(d.$$.fragment,i)},m(i,T){n(i,a,T),n(i,c,T),f(d,i,T),y=!0},p:ze,i(i){y||(u(d.$$.fragment,i),y=!0)},o(i){_(d.$$.fragment,i),y=!1},d(i){i&&(o(a),o(c)),b(d,i)}}}function yt(x){let a,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=M},l(c){a=m(c,"P",{"data-svelte-h":!0}),v(a)!=="svelte-fincs2"&&(a.innerHTML=M)},m(c,d){n(c,a,d)},p:ze,d(c){c&&o(a)}}}function Mt(x){let a,M="Examples:",c,d,y;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdE1hdHRlSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaXRNYXR0ZUZvckltYWdlTWF0dGluZyUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMFZpdE1hdHRlSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnZpdG1hdHRlLXNtYWxsLWNvbXBvc2l0aW9uLTFrJTIyKSUwQW1vZGVsJTIwJTNEJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnZpdG1hdHRlLXNtYWxsLWNvbXBvc2l0aW9uLTFrJTIyKSUwQSUwQWZpbGVwYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGaW1hZ2UtbWF0dGluZy1maXh0dXJlcyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oZmlsZXBhdGgpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWZpbGVwYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGaW1hZ2UtbWF0dGluZy1maXh0dXJlcyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJpbWFwLnBuZyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBdHJpbWFwJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlcGF0aCkuY29udmVydCglMjJMJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMCUyQiUyMHRyaW1hcCUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdHJpbWFwcyUzRHRyaW1hcCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGFscGhhcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5hbHBoYXMlMEFwcmludChhbHBoYXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitMatteImageProcessor, VitMatteForImageMatting
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VitMatteImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/vitmatte-small-composition-1k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitMatteForImageMatting.from_pretrained(<span class="hljs-string">&quot;hustvl/vitmatte-small-composition-1k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filepath = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/image-matting-fixtures&quot;</span>, filename=<span class="hljs-string">&quot;image.png&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(filepath).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>filepath = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/image-matting-fixtures&quot;</span>, filename=<span class="hljs-string">&quot;trimap.png&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trimap = Image.<span class="hljs-built_in">open</span>(filepath).convert(<span class="hljs-string">&quot;L&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image + trimap for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, trimaps=trimap, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    alphas = model(**inputs).alphas
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(alphas.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">640</span>, <span class="hljs-number">960</span>])`,wrap:!1}}),{c(){a=l("p"),a.textContent=M,c=s(),g(d.$$.fragment)},l(i){a=m(i,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=M),c=r(i),h(d.$$.fragment,i)},m(i,T){n(i,a,T),n(i,c,T),f(d,i,T),y=!0},p:ze,i(i){y||(u(d.$$.fragment,i),y=!0)},o(i){_(d.$$.fragment,i),y=!1},d(i){i&&(o(a),o(c)),b(d,i)}}}function Tt(x){let a,M,c,d,y,i,T,ue,G,De=`The ViTMatte model was proposed in <a href="https://arxiv.org/abs/2305.15272" rel="nofollow">Boosting Image Matting with Pretrained Plain Vision Transformers</a> by Jingfeng Yao, Xinggang Wang, Shusheng Yang, Baoyuan Wang.
ViTMatte leverages plain <a href="vit">Vision Transformers</a> for the task of image matting, which is the process of accurately estimating the foreground object in images and videos.`,_e,L,Ye="The abstract from the paper is the following:",be,H,Qe="<em>Recently, plain vision Transformers (ViTs) have shown impressive performance on various computer vision tasks, thanks to their strong modeling capacity and large-scale pretraining. However, they have not yet conquered the problem of image matting. We hypothesize that image matting could also be boosted by ViTs and present a new efficient and robust ViT-based matting system, named ViTMatte. Our method utilizes (i) a hybrid attention mechanism combined with a convolution neck to help ViTs achieve an excellent performance-computation trade-off in matting tasks. (ii) Additionally, we introduce the detail capture module, which just consists of simple lightweight convolutions to complement the detailed information required by matting. To the best of our knowledge, ViTMatte is the first work to unleash the potential of ViT on image matting with concise adaptation. It inherits many superior properties from ViT to matting, including various pretraining strategies, concise architecture design, and flexible inference strategies. We evaluate ViTMatte on Composition-1k and Distinctions-646, the most commonly used benchmark for image matting, our method achieves state-of-the-art performance and outperforms prior matting works by a large margin.</em>",ve,S,Ae=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/hustvl/ViTMatte" rel="nofollow">here</a>.`,ye,j,Oe,Me,E,Ke='ViTMatte high-level overview. Taken from the <a href="https://arxiv.org/abs/2305.15272">original paper.</a>',Te,B,we,X,et="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ViTMatte.",$e,q,tt='<li>A demo notebook regarding inference with <a href="/docs/transformers/v4.36.0/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>, including background replacement, can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ViTMatte" rel="nofollow">here</a>.</li>',Ie,F,Ve,D,Ce,w,Y,Pe,se,ot=`This is the configuration class to store the configuration of <a href="/docs/transformers/v4.36.0/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>. It is used to
instantiate a ViTMatte model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the ViTMatte
<a href="https://huggingface.co/hustvl/vitmatte-small-composition-1k" rel="nofollow">hustvl/vitmatte-small-composition-1k</a> architecture.`,Ze,re,at=`Configuration objects inherit from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Re,W,Ne,z,Q,ke,ie,nt=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,Ue,A,xe,V,O,Ge,le,st="Constructs a ViTMatte image processor.",Le,P,K,He,me,rt="Preprocess an image or batch of images.",Je,ee,je,C,te,Se,ce,it="ViTMatte framework leveraging any vision backbone e.g. for ADE20k, CityScapes.",Ee,I,oe,Be,de,lt='The <a href="/docs/transformers/v4.36.0/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a> forward method, overrides the <code>__call__</code> special method.',Xe,Z,qe,R,Fe,fe,We;return y=new he({props:{title:"ViTMatte",local:"vitmatte",headingTag:"h1"}}),T=new he({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new he({props:{title:"Resources",local:"resources",headingTag:"h2"}}),F=new mt({props:{$$slots:{default:[bt]},$$scope:{ctx:x}}}),D=new he({props:{title:"VitMatteConfig",local:"transformers.VitMatteConfig",headingTag:"h2"}}),Y=new ge({props:{name:"class transformers.VitMatteConfig",anchor:"transformers.VitMatteConfig",parameters:[{name:"backbone_config",val:": PretrainedConfig = None"},{name:"hidden_size",val:": int = 384"},{name:"batch_norm_eps",val:": float = 1e-05"},{name:"initializer_range",val:": float = 0.02"},{name:"convstream_hidden_sizes",val:": typing.List[int] = [48, 96, 192]"},{name:"fusion_hidden_sizes",val:": typing.List[int] = [256, 128, 64, 32]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>VitDetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.VitMatteConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the decoder.`,name:"hidden_size"},{anchor:"transformers.VitMatteConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the batch norm layers.`,name:"batch_norm_eps"},{anchor:"transformers.VitMatteConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VitMatteConfig.convstream_hidden_sizes",description:`<strong>convstream_hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[48, 96, 192]</code>) &#x2014;
The output channels of the ConvStream module.`,name:"convstream_hidden_sizes"},{anchor:"transformers.VitMatteConfig.fusion_hidden_sizes",description:`<strong>fusion_hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 128, 64, 32]</code>) &#x2014;
The output channels of the Fusion blocks.`,name:"fusion_hidden_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/vitmatte/configuration_vitmatte.py#L32"}}),W=new ct({props:{anchor:"transformers.VitMatteConfig.example",$$slots:{default:[vt]},$$scope:{ctx:x}}}),Q=new ge({props:{name:"to_dict",anchor:"transformers.VitMatteConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/vitmatte/configuration_vitmatte.py#L100"}}),A=new he({props:{title:"VitMatteImageProcessor",local:"transformers.VitMatteImageProcessor",headingTag:"h2"}}),O=new ge({props:{name:"class transformers.VitMatteImageProcessor",anchor:"transformers.VitMatteImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": bool = True"},{name:"size_divisibility",val:": int = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the width and height divisible by <code>size_divisibility</code>. Can be overridden
by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessor.size_divisibility",description:`<strong>size_divisibility</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The width and height of the image will be padded to be divisible by this number.`,name:"size_divisibility"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/vitmatte/image_processing_vitmatte.py#L41"}}),K=new ge({props:{name:"preprocess",anchor:"transformers.VitMatteImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"trimaps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"size_divisibility",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VitMatteImageProcessor.preprocess.trimaps",description:`<strong>trimaps</strong> (<code>ImageInput</code>) &#x2014;
Trimap to preprocess.`,name:"trimaps"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessor.preprocess.size_divisibility",description:`<strong>size_divisibility</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisibility</code>) &#x2014;
The size divisibility to pad the image to if <code>do_pad</code> is set to <code>True</code>.`,name:"size_divisibility"},{anchor:"transformers.VitMatteImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VitMatteImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VitMatteImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/vitmatte/image_processing_vitmatte.py#L131"}}),ee=new he({props:{title:"VitMatteForImageMatting",local:"transformers.VitMatteForImageMatting",headingTag:"h2"}}),te=new ge({props:{name:"class transformers.VitMatteForImageMatting",anchor:"transformers.VitMatteForImageMatting",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VitMatteForImageMatting.This",description:"<strong>This</strong> model is a PyTorch [torch.nn.Module](https &#x2014;//pytorch.org/docs/stable/nn.html#torch.nn.Module) sub-class. Use",name:"This"},{anchor:"transformers.VitMatteForImageMatting.it",description:`<strong>it</strong> as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and &#x2014;
behavior. &#x2014;
config (<a href="/docs/transformers/v4.36.0/en/model_doc/upernet#transformers.UperNetConfig">UperNetConfig</a>): Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.36.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"it"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/vitmatte/modeling_vitmatte.py#L257"}}),oe=new ge({props:{name:"forward",anchor:"transformers.VitMatteForImageMatting.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VitMatteForImageMatting.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.36.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor.__call__">VitMatteImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VitMatteForImageMatting.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers in case the backbone has them. See
<code>attentions</code> under returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VitMatteForImageMatting.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers of the backbone. See <code>hidden_states</code> under
returned tensors for more detail.`,name:"output_hidden_states"},{anchor:"transformers.VitMatteForImageMatting.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VitMatteForImageMatting.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth image matting for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/vitmatte/modeling_vitmatte.py#L268",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.vitmatte.modeling_vitmatte.ImageMattingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.36.0/en/model_doc/vitmatte#transformers.VitMatteConfig"
>VitMatteConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Loss.</p>
</li>
<li>
<p><strong>alphas</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Estimated alpha values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.vitmatte.modeling_vitmatte.ImageMattingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new mt({props:{$$slots:{default:[yt]},$$scope:{ctx:x}}}),R=new ct({props:{anchor:"transformers.VitMatteForImageMatting.forward.example",$$slots:{default:[Mt]},$$scope:{ctx:x}}}),{c(){a=l("meta"),M=s(),c=l("p"),d=s(),g(y.$$.fragment),i=s(),g(T.$$.fragment),ue=s(),G=l("p"),G.innerHTML=De,_e=s(),L=l("p"),L.textContent=Ye,be=s(),H=l("p"),H.innerHTML=Qe,ve=s(),S=l("p"),S.innerHTML=Ae,ye=s(),j=l("img"),Me=s(),E=l("small"),E.innerHTML=Ke,Te=s(),g(B.$$.fragment),we=s(),X=l("p"),X.textContent=et,$e=s(),q=l("ul"),q.innerHTML=tt,Ie=s(),g(F.$$.fragment),Ve=s(),g(D.$$.fragment),Ce=s(),w=l("div"),g(Y.$$.fragment),Pe=s(),se=l("p"),se.innerHTML=ot,Ze=s(),re=l("p"),re.innerHTML=at,Re=s(),g(W.$$.fragment),Ne=s(),z=l("div"),g(Q.$$.fragment),ke=s(),ie=l("p"),ie.innerHTML=nt,Ue=s(),g(A.$$.fragment),xe=s(),V=l("div"),g(O.$$.fragment),Ge=s(),le=l("p"),le.textContent=st,Le=s(),P=l("div"),g(K.$$.fragment),He=s(),me=l("p"),me.textContent=rt,Je=s(),g(ee.$$.fragment),je=s(),C=l("div"),g(te.$$.fragment),Se=s(),ce=l("p"),ce.textContent=it,Ee=s(),I=l("div"),g(oe.$$.fragment),Be=s(),de=l("p"),de.innerHTML=lt,Xe=s(),g(Z.$$.fragment),qe=s(),g(R.$$.fragment),Fe=s(),fe=l("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);a=m(t,"META",{name:!0,content:!0}),t.forEach(o),M=r(e),c=m(e,"P",{}),k(c).forEach(o),d=r(e),h(y.$$.fragment,e),i=r(e),h(T.$$.fragment,e),ue=r(e),G=m(e,"P",{"data-svelte-h":!0}),v(G)!=="svelte-1oupqpp"&&(G.innerHTML=De),_e=r(e),L=m(e,"P",{"data-svelte-h":!0}),v(L)!=="svelte-vfdo9a"&&(L.textContent=Ye),be=r(e),H=m(e,"P",{"data-svelte-h":!0}),v(H)!=="svelte-ejbjbx"&&(H.innerHTML=Qe),ve=r(e),S=m(e,"P",{"data-svelte-h":!0}),v(S)!=="svelte-cgl4x9"&&(S.innerHTML=Ae),ye=r(e),j=m(e,"IMG",{src:!0,alt:!0,width:!0}),Me=r(e),E=m(e,"SMALL",{"data-svelte-h":!0}),v(E)!=="svelte-htuduo"&&(E.innerHTML=Ke),Te=r(e),h(B.$$.fragment,e),we=r(e),X=m(e,"P",{"data-svelte-h":!0}),v(X)!=="svelte-1h6mpjr"&&(X.textContent=et),$e=r(e),q=m(e,"UL",{"data-svelte-h":!0}),v(q)!=="svelte-oqhrz"&&(q.innerHTML=tt),Ie=r(e),h(F.$$.fragment,e),Ve=r(e),h(D.$$.fragment,e),Ce=r(e),w=m(e,"DIV",{class:!0});var $=k(w);h(Y.$$.fragment,$),Pe=r($),se=m($,"P",{"data-svelte-h":!0}),v(se)!=="svelte-ip9ksw"&&(se.innerHTML=ot),Ze=r($),re=m($,"P",{"data-svelte-h":!0}),v(re)!=="svelte-1qljms5"&&(re.innerHTML=at),Re=r($),h(W.$$.fragment,$),Ne=r($),z=m($,"DIV",{class:!0});var ae=k(z);h(Q.$$.fragment,ae),ke=r(ae),ie=m(ae,"P",{"data-svelte-h":!0}),v(ie)!=="svelte-clb2hw"&&(ie.innerHTML=nt),ae.forEach(o),$.forEach(o),Ue=r(e),h(A.$$.fragment,e),xe=r(e),V=m(e,"DIV",{class:!0});var J=k(V);h(O.$$.fragment,J),Ge=r(J),le=m(J,"P",{"data-svelte-h":!0}),v(le)!=="svelte-ohhgeg"&&(le.textContent=st),Le=r(J),P=m(J,"DIV",{class:!0});var ne=k(P);h(K.$$.fragment,ne),He=r(ne),me=m(ne,"P",{"data-svelte-h":!0}),v(me)!=="svelte-1x3yxsa"&&(me.textContent=rt),ne.forEach(o),J.forEach(o),Je=r(e),h(ee.$$.fragment,e),je=r(e),C=m(e,"DIV",{class:!0});var pe=k(C);h(te.$$.fragment,pe),Se=r(pe),ce=m(pe,"P",{"data-svelte-h":!0}),v(ce)!=="svelte-hfzn9x"&&(ce.textContent=it),Ee=r(pe),I=m(pe,"DIV",{class:!0});var N=k(I);h(oe.$$.fragment,N),Be=r(N),de=m(N,"P",{"data-svelte-h":!0}),v(de)!=="svelte-y2yyvj"&&(de.innerHTML=lt),Xe=r(N),h(Z.$$.fragment,N),qe=r(N),h(R.$$.fragment,N),N.forEach(o),pe.forEach(o),Fe=r(e),fe=m(e,"P",{}),k(fe).forEach(o),this.h()},h(){U(a,"name","hf:doc:metadata"),U(a,"content",wt),gt(j.src,Oe="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vitmatte_architecture.png")||U(j,"src",Oe),U(j,"alt","drawing"),U(j,"width","600"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,a),n(e,M,t),n(e,c,t),n(e,d,t),f(y,e,t),n(e,i,t),f(T,e,t),n(e,ue,t),n(e,G,t),n(e,_e,t),n(e,L,t),n(e,be,t),n(e,H,t),n(e,ve,t),n(e,S,t),n(e,ye,t),n(e,j,t),n(e,Me,t),n(e,E,t),n(e,Te,t),f(B,e,t),n(e,we,t),n(e,X,t),n(e,$e,t),n(e,q,t),n(e,Ie,t),f(F,e,t),n(e,Ve,t),f(D,e,t),n(e,Ce,t),n(e,w,t),f(Y,w,null),p(w,Pe),p(w,se),p(w,Ze),p(w,re),p(w,Re),f(W,w,null),p(w,Ne),p(w,z),f(Q,z,null),p(z,ke),p(z,ie),n(e,Ue,t),f(A,e,t),n(e,xe,t),n(e,V,t),f(O,V,null),p(V,Ge),p(V,le),p(V,Le),p(V,P),f(K,P,null),p(P,He),p(P,me),n(e,Je,t),f(ee,e,t),n(e,je,t),n(e,C,t),f(te,C,null),p(C,Se),p(C,ce),p(C,Ee),p(C,I),f(oe,I,null),p(I,Be),p(I,de),p(I,Xe),f(Z,I,null),p(I,qe),f(R,I,null),n(e,Fe,t),n(e,fe,t),We=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),F.$set($);const ae={};t&2&&(ae.$$scope={dirty:t,ctx:e}),W.$set(ae);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),Z.$set(J);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:e}),R.$set(ne)},i(e){We||(u(y.$$.fragment,e),u(T.$$.fragment,e),u(B.$$.fragment,e),u(F.$$.fragment,e),u(D.$$.fragment,e),u(Y.$$.fragment,e),u(W.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),We=!0)},o(e){_(y.$$.fragment,e),_(T.$$.fragment,e),_(B.$$.fragment,e),_(F.$$.fragment,e),_(D.$$.fragment,e),_(Y.$$.fragment,e),_(W.$$.fragment,e),_(Q.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(Z.$$.fragment,e),_(R.$$.fragment,e),We=!1},d(e){e&&(o(M),o(c),o(d),o(i),o(ue),o(G),o(_e),o(L),o(be),o(H),o(ve),o(S),o(ye),o(j),o(Me),o(E),o(Te),o(we),o(X),o($e),o(q),o(Ie),o(Ve),o(Ce),o(w),o(Ue),o(xe),o(V),o(Je),o(je),o(C),o(Fe),o(fe)),o(a),b(y,e),b(T,e),b(B,e),b(F,e),b(D,e),b(Y),b(W),b(Q),b(A,e),b(O),b(K),b(ee,e),b(te),b(oe),b(Z),b(R)}}}const wt='{"title":"ViTMatte","local":"vitmatte","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"VitMatteConfig","local":"transformers.VitMatteConfig","sections":[],"depth":2},{"title":"VitMatteImageProcessor","local":"transformers.VitMatteImageProcessor","sections":[],"depth":2},{"title":"VitMatteForImageMatting","local":"transformers.VitMatteForImageMatting","sections":[],"depth":2}],"depth":1}';function $t(x){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends ft{constructor(a){super(),ut(this,a,$t,Tt,pt,{})}}export{Ft as component};
