import{s as Ll,n as Fl,o as Dl}from"../chunks/scheduler.1f027d5a.js";import{S as Pl,i as Ol,e as i,s as n,c as p,h as Kl,a as o,d as l,b as a,f as Yl,g as J,j as M,k as al,q as es,l as ts,m as s,n as d,t as c,o as r,p as T}from"../chunks/index.5cb6ce42.js";import{D as ls,C as u}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as w,E as ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function ns(il){let y,Ee,_e,$e,h,Ve,I,Qe,U,ol='<em>Authored by: <a href="https://qdrant.tech/" rel="nofollow">Qdrant Team</a></em>',qe,b,Ml="In this notebook, we demonstrate how you can use vector embeddings to navigate a codebase, and find relevant code snippets. We’ll search codebases using natural semantic queries, and search for code based on a similar logic.",ze,f,pl='You can check out the <a href="https://code-search.qdrant.tech/" rel="nofollow">live deployment</a> of this approach which exposes the Qdrant codebase for search with a web interface.',Xe,C,He,g,Jl="We need two models to accomplish our goal.",Se,x,dl='<li><p>General usage neural encoder for Natural Language Processing (NLP), in our case <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a>. We’ll call this NLP model.</p></li> <li><p>Specialized embeddings for code-to-code similarity search. We’ll use the <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-code" rel="nofollow">jinaai/jina-embeddings-v2-base-code</a> model for the task. It supports English and 30 widely used programming languages with a 8192 sequence length. Let’s call this code model.</p></li>',Ye,B,cl="To prepare our code for the NLP model, we need to preprocess the code to a format that closely resembles natural language. The code model supports a variety of standard programming languages, so there is no need to preprocess the snippets. We can use the code as is.",Le,Z,Fe,v,rl="Let’s install the packages we’ll work with.",De,A,Tl='<li><a href="https://pypi.org/project/inflection/" rel="nofollow">inflection</a> - A string transformation library. It singularizes and pluralizes English words, and transforms CamelCase to underscored string.</li> <li><a href="https://pypi.org/project/fastembed/" rel="nofollow">fastembed</a> - A CPU-first, lightweight library for generating vector embeddings. <a href="https://github.com/qdrant/fastembed#%EF%B8%8F-fastembed-on-a-gpu" rel="nofollow">GPU support is available</a>.</li> <li><a href="https://pypi.org/project/qdrant-client/" rel="nofollow">qdrant-client</a> - Official Python library to interface with the Qdrant server.</li>',Pe,G,Oe,N,Ke,W,ul="Chunking the application sources into smaller parts is a non-trivial task. In general, functions, class methods, structs, enums, and all the other language-specific constructs are good candidates for chunks. They are big enough to contain some meaningful information, but small enough to be processed by embedding models with a limited context window. You can also use docstrings, comments, and other metadata can be used to enrich the chunks with additional information.",et,m,wl='<img src="https://huggingface.co/datasets/Anush008/cookbook-images/resolve/main/data-chunking.png"/>',tt,k,yl="Text-based search is based on function signatures, but code search may return smaller pieces, such as loops. So, if we receive a particular function signature from the NLP model and part of its implementation from the code model, we merge the results.",lt,_,st,R,ml=`We’ll use the <a href="https://github.com/qdrant/qdrant" rel="nofollow">Qdrant codebase</a> for this demo.
While this codebase uses Rust, you can use this approach with any other language. You can use an <a href="https://microsoft.github.io/language-server-protocol/" rel="nofollow">Language Server Protocol (LSP)</a> tool to build a graph of the codebase, and then extract chunks. We did our work with the <a href="https://rust-analyzer.github.io/" rel="nofollow">rust-analyzer</a>. We exported the parsed codebase into the <a href="https://microsoft.github.io/language-server-protocol/specifications/lsif/0.4.0/specification/" rel="nofollow">LSIF</a> format, a standard for code intelligence data. Next, we used the LSIF data to navigate the codebase and extract the chunks.`,nt,E,jl='You can use the same approach for other languages. There are <a href="https://microsoft.github.io/language-server-protocol/implementors/servers/" rel="nofollow">plenty of implementations</a> available.',at,$,hl="We will then export the chunks into JSON documents with not only the code itself, but also context with the location of the code in the project.",it,V,Il='You can examine the Qdrant structures, parsed in JSON, in the <a href="https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl" rel="nofollow">structures.jsonl file</a> in our Google Cloud Storage bucket. Download it and use it as a source of data for our code search.',ot,Q,Mt,q,Ul="Next, load the file and parse the lines into a list of dictionaries:",pt,z,Jt,X,bl="Let’s see how one entry looks like.",dt,H,ct,S,rt,Y,Tt,L,fl="Each programming language has its own syntax which is not a part of the natural language. Thus, a general-purpose model probably does not understand the code as is. We can, however, normalize the data by removing code specifics and including additional context, such as module, class, function, and file name. We take the following steps:",ut,F,Cl="<li>Extract the signature of the function, method, or other code construct.</li> <li>Divide camel case and snake case names into separate words.</li> <li>Take the docstring, comments, and other important metadata.</li> <li>Build a sentence from the extracted data using a predefined template.</li> <li>Remove the special characters and replace them with spaces.</li>",wt,D,gl="We can now define the <code>textify</code> function that uses the <code>inflection</code> library to carry out our conversions:",yt,P,mt,O,xl="Now we can use <code>textify</code> to convert all chunks into text representations:",jt,K,ht,ee,Bl="Let’s see how one of our representations looks like:",It,te,Ut,le,bt,se,ft,ne,Ct,ae,gt,ie,xt,oe,Bt,Me,Zl='Qdrant supports multiple modes of deployment. Including in-memory for prototyping, Docker and Qdrant Cloud. You can refer to the <a href="https://qdrant.tech/documentation/guides/installation/" rel="nofollow">installation instructions</a> for more information.',Zt,pe,vl="We’ll continue the tutorial using an in-memory instance.",vt,j,Al="<p>In-memory can only be used for quick-prototyping and tests. It is a Python implementation of the Qdrant server methods.</p>",At,Je,Gl="Let’s create a collection to store our vectors.",Gt,de,Nt,ce,Nl="Our newly created collection is ready to accept the data. Let’s upload the embeddings:",Wt,re,kt,Te,Wl="The uploaded points are immediately available for search. Next, query the collection to find relevant code snippets.",_t,ue,Rt,we,kl='We use one of the models to search the collection via Qdrant’s new <a href="https://qdrant.tech/blog/qdrant-1.10.x/" rel="nofollow">Query API</a>. Start with text embeddings. Run the following query “How do I count points in a collection?”. Review the results.',Et,ye,$t,me,_l=`Now, review the results. The following table lists the module, the file name
and score. Each line includes a link to the signature.`,Vt,je,Rl='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>operations</td> <td>types.rs</td> <td>0.5493385</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/collection/src/operations/types.rs#L794" rel="nofollow"><code>pub struct CountRequestInternal</code></a></td></tr> <tr><td>map_index</td> <td>types.rs</td> <td>0.49973965</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mod.rs#L89" rel="nofollow"><code>fn get_points_with_value_count</code></a></td></tr> <tr><td>map_index</td> <td>mutable_map_index.rs</td> <td>0.49941066</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mutable_map_index.rs#L143" rel="nofollow"><code>pub fn get_points_with_value_count</code></a></td></tr></tbody>',Qt,he,El="It seems we were able to find some relevant code structures. Let’s try the same with the code embeddings:",qt,Ie,zt,Ue,$l="Output:",Xt,be,Vl='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>field_index</td> <td>geo_index.rs</td> <td>0.7217579</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/geo_index/mod.rs#L319" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>numeric_index</td> <td>mod.rs</td> <td>0.7113214</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/numeric_index/mod.rs#L317" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>full_text_index</td> <td>text_index.rs</td> <td>0.6993165</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/full_text_index/text_index.rs#L179" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr></tbody>',Ht,fe,Ql=`While the scores retrieved by different models are not comparable, but we can
see that the results are different. Code and text embeddings can capture
different aspects of the codebase. We can use both models to query the collection
and then combine the results to get the most relevant code snippets.`,St,Ce,Yt,ge,Lt,xe,ql='|  operations  |  lib/collection/src/operations/types.rs  |  0.5  | ` # [doc = " Count Request"] # [doc = " Counts the number of points which satisfy the given filter."] # [doc = " If filter is not provided, the count of all points in the collection will be returned."] # [derive (Debug , Deserialize , Serialize , JsonSchema , Validate)] # [serde (rename_all = "snake_case")] pub struct CountRequestInternal &#123; # [doc = " Look only for points which satisfies this conditions"] # [validate] pub filter : Option < Filter > , # [doc = " If true, count exact number of points. If false, count approximate number of points faster."] # [doc = " Approximate count might be unreliable during the indexing process. Default: true"] # [serde (default = "default_exact_count")] pub exact : bool , } ` |\n|  field_index  |  lib/segment/src/index/field_index/geo_index.rs  |  0.5  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.33333334  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  numeric_index  |  lib/segment/src/index/field_index/numeric_index/mod.rs  |  0.33333334  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  lib/segment/src/fixtures/payload_context_fixture.rs  |  0.25  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mutable_map_index.rs  |  0.25  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  id_tracker  |  lib/segment/src/id_tracker/simple_id_tracker.rs  |  0.2  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.2  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.16666667  | ` fn count_indexed_points (& self) -> usize ` |\n|  field_index  |  lib/segment/src/index/field_index/stat_tools.rs  |  0.16666667  | ` fn number_of_selected_points (points : usize , values : usize) -> usize ` |\n',Ft,Be,zl=`This is one example of how you can fuse the results from different models.
In a real-world scenario, you might run some reranking and deduplication, as well as additional processing of the results.`,Dt,Ze,Pt,ve,Xl=`You can improve the search results, by grouping them by payload properties.
In our case, we can group the results by the module. If we use code embeddings,
we can see multiple results from the <code>map_index</code> module. Let’s group the
results and assume a single result per module:`,Ot,Ae,Kt,Ge,el,Ne,Hl="|  field_index  |  geo_index.rs  |  0.7217579  | ` fn count_indexed_points (& self) -> usize ` |\n|  numeric_index  |  mod.rs  |  0.7113214  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  payload_context_fixture.rs  |  0.6993165  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  mod.rs  |  0.68385994  | ` fn count_indexed_points (& self) -> usize ` |\n|  full_text_index  |  text_index.rs  |  0.6660142  | ` fn count_indexed_points (& self) -> usize ` |\n",tl,We,Sl='That concludes our tutorial. Thanks for taking the time to get here. We’ve just begun exploring what’s possible with vector embeddings and how to improve it. Feel free to experiment your way; you could build something very cool! Do share it with us 🙏 We are <a href="https://qdrant.tech/contact-us/" rel="nofollow">here</a>.',ll,ke,sl,Re,nl;return h=new ls({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/code_search.ipynb"}]}}),I=new w({props:{title:"Code Search with Vector Embeddings and Qdrant",local:"code-search-with-vector-embeddings-and-qdrant",headingTag:"h2"}}),C=new w({props:{title:"The approach",local:"the-approach",headingTag:"h3"}}),Z=new w({props:{title:"Installing Dependencies",local:"installing-dependencies",headingTag:"h2"}}),G=new u({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGluZmxlY3Rpb24lMjBxZHJhbnQtY2xpZW50JTIwZmFzdGVtYmVk",highlighted:"%pip install inflection qdrant-client fastembed",wrap:!1}}),N=new w({props:{title:"Data preparation",local:"data-preparation",headingTag:"h3"}}),_=new w({props:{title:"Parsing the Codebaase",local:"parsing-the-codebaase",headingTag:"h3"}}),Q=new u({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZ0dXRvcmlhbC1hdHRhY2htZW50cyUyRmNvZGUtc2VhcmNoJTJGc3RydWN0dXJlcy5qc29ubA==",highlighted:"!wget https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl",wrap:!1}}),z=new u({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXN0cnVjdHVyZXMlMjAlM0QlMjAlNUIlNUQlMEF3aXRoJTIwb3BlbiglMjJzdHJ1Y3R1cmVzLmpzb25sJTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGZwJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMHJvdyUyMGluJTIwZW51bWVyYXRlKGZwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5JTIwJTNEJTIwanNvbi5sb2Fkcyhyb3cpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RydWN0dXJlcy5hcHBlbmQoZW50cnkp",highlighted:`<span class="hljs-keyword">import</span> json

structures = []
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;structures.jsonl&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> fp:
    <span class="hljs-keyword">for</span> i, row <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(fp):
        entry = json.loads(row)
        structures.append(entry)`,wrap:!1}}),H=new u({props:{code:"c3RydWN0dXJlcyU1QjAlNUQ=",highlighted:'structures[<span class="hljs-number">0</span>]',wrap:!1}}),S=new u({props:{code:"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",highlighted:`{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;InvertedIndexRam&#x27;</span>,
 <span class="hljs-string">&#x27;signature&#x27;</span>: <span class="hljs-string">&#x27;# [doc = &quot; Inverted flatten index from dimension id to posting list&quot;] # [derive (Debug , Clone , PartialEq)] pub struct InvertedIndexRam { # [doc = &quot; Posting lists for each dimension flattened (dimension id -&gt; posting list)&quot;] # [doc = &quot; Gaps are filled with empty posting lists&quot;] pub postings : Vec &lt; PostingList &gt; , # [doc = &quot; Number of unique indexed vectors&quot;] # [doc = &quot; pre-computed on build and upsert to avoid having to traverse the posting lists.&quot;] pub vector_count : usize , }&#x27;</span>,
 <span class="hljs-string">&#x27;code_type&#x27;</span>: <span class="hljs-string">&#x27;Struct&#x27;</span>,
 <span class="hljs-string">&#x27;docstring&#x27;</span>: <span class="hljs-string">&#x27;= &quot; Inverted flatten index from dimension id to posting list&quot;&#x27;</span>,
 <span class="hljs-string">&#x27;line&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;line_from&#x27;</span>: <span class="hljs-number">13</span>,
 <span class="hljs-string">&#x27;line_to&#x27;</span>: <span class="hljs-number">22</span>,
 <span class="hljs-string">&#x27;context&#x27;</span>: {<span class="hljs-string">&#x27;module&#x27;</span>: <span class="hljs-string">&#x27;inverted_index&#x27;</span>,
  <span class="hljs-string">&#x27;file_path&#x27;</span>: <span class="hljs-string">&#x27;lib/sparse/src/index/inverted_index/inverted_index_ram.rs&#x27;</span>,
  <span class="hljs-string">&#x27;file_name&#x27;</span>: <span class="hljs-string">&#x27;inverted_index_ram.rs&#x27;</span>,
  <span class="hljs-string">&#x27;struct_name&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;snippet&#x27;</span>: <span class="hljs-string">&#x27;/// Inverted flatten index from dimension id to posting list\\n#[derive(Debug, Clone, PartialEq)]\\npub struct InvertedIndexRam {\\n    /// Posting lists for each dimension flattened (dimension id -&gt; posting list)\\n    /// Gaps are filled with empty posting lists\\n    pub postings: Vec&lt;PostingList&gt;,\\n    /// Number of unique indexed vectors\\n    /// pre-computed on build and upsert to avoid having to traverse the posting lists.\\n    pub vector_count: usize,\\n}\\n&#x27;</span>}}`,wrap:!1}}),Y=new w({props:{title:"Code to natural language conversion",local:"code-to-natural-language-conversion",headingTag:"h3"}}),P=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inflection
<span class="hljs-keyword">import</span> re

<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">textify</span>(<span class="hljs-params">chunk: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
&lt;CopyLLMTxtMenu containerStyle=<span class="hljs-string">&quot;float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;&quot;</span>&gt;&lt;/CopyLLMTxtMenu&gt;

    <span class="hljs-comment"># Get rid of all the camel case / snake case</span>
    <span class="hljs-comment"># - inflection.underscore changes the camel case to snake case</span>
    <span class="hljs-comment"># - inflection.humanize converts the snake case to human readable form</span>
    name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;name&quot;</span>]))
    signature = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;signature&quot;</span>]))

    <span class="hljs-comment"># Check if docstring is provided</span>
    docstring = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;docstring&quot;</span>]:
        docstring = <span class="hljs-string">f&quot;that does <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;docstring&#x27;</span>]}</span> &quot;</span>

    <span class="hljs-comment"># Extract the location of that snippet of code</span>
    context = (
        <span class="hljs-string">f&quot;module <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;module&#x27;</span>]}</span> &quot;</span> <span class="hljs-string">f&quot;file <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;file_name&#x27;</span>]}</span>&quot;</span>
    )
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]:
        struct_name = inflection.humanize(
            inflection.underscore(chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>])
        )
        context = <span class="hljs-string">f&quot;defined in struct <span class="hljs-subst">{struct_name}</span> <span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Combine all the bits and pieces together</span>
    text_representation = (
        <span class="hljs-string">f&quot;<span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;code_type&#x27;</span>]}</span> <span class="hljs-subst">{name}</span> &quot;</span>
        <span class="hljs-string">f&quot;<span class="hljs-subst">{docstring}</span>&quot;</span>
        <span class="hljs-string">f&quot;defined as <span class="hljs-subst">{signature}</span> &quot;</span>
        <span class="hljs-string">f&quot;<span class="hljs-subst">{context}</span>&quot;</span>
    )

    <span class="hljs-comment"># Remove any special characters and concatenate the tokens</span>
    tokens = re.split(<span class="hljs-string">r&quot;\\W&quot;</span>, text_representation)
    tokens = <span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x, tokens)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot; &quot;</span>.join(tokens)`,wrap:!1}}),K=new u({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlMjAlM0QlMjBsaXN0KG1hcCh0ZXh0aWZ5JTJDJTIwc3RydWN0dXJlcykp",highlighted:'text_representations = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">map</span>(textify, structures))',wrap:!1}}),te=new u({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlNUIxMDAwJTVE",highlighted:'text_representations[<span class="hljs-number">1000</span>]',wrap:!1}}),le=new u({props:{code:"J0Z1bmN0aW9uJTIwSG5zdyUyMGRpc2NvdmVyJTIwcHJlY2lzaW9uJTIwdGhhdCUyMGRvZXMlMjBDaGVja3MlMjBkaXNjb3ZlcnklMjBzZWFyY2glMjBwcmVjaXNpb24lMjB3aGVuJTIwdXNpbmclMjBobnN3JTIwaW5kZXglMjB0aGlzJTIwaXMlMjBkaWZmZXJlbnQlMjBmcm9tJTIwdGhlJTIwdGVzdHMlMjBpbiUyMGRlZmluZWQlMjBhcyUyMEZuJTIwaG5zdyUyMGRpc2NvdmVyJTIwcHJlY2lzaW9uJTIwbW9kdWxlJTIwaW50ZWdyYXRpb24lMjBmaWxlJTIwaG5zd19kaXNjb3Zlcl90ZXN0JTIwcnMn",highlighted:'<span class="hljs-string">&#x27;Function Hnsw discover precision that does Checks discovery search precision when using hnsw index this is different from the tests in defined as Fn hnsw discover precision module integration file hnsw_discover_test rs&#x27;</span>',wrap:!1}}),se=new w({props:{title:"Natural language embeddings",local:"natural-language-embeddings",headingTag:"h3"}}),ne=new u({props:{code:"ZnJvbSUyMGZhc3RlbWJlZCUyMGltcG9ydCUyMFRleHRFbWJlZGRpbmclMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwNSUwQSUwQW5scF9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiUyQyUyMHRocmVhZHMlM0QwKSUwQW5scF9lbWJlZGRpbmdzJTIwJTNEJTIwbmxwX21vZGVsLmVtYmVkKHRleHRfcmVwcmVzZW50YXRpb25zJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUp",highlighted:`<span class="hljs-keyword">from</span> fastembed <span class="hljs-keyword">import</span> TextEmbedding

batch_size = <span class="hljs-number">5</span>

nlp_model = TextEmbedding(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>, threads=<span class="hljs-number">0</span>)
nlp_embeddings = nlp_model.embed(text_representations, batch_size=batch_size)`,wrap:!1}}),ae=new w({props:{title:"Code Embeddings",local:"code-embeddings",headingTag:"h3"}}),ie=new u({props:{code:"Y29kZV9zbmlwcGV0cyUyMCUzRCUyMCU1QnN0cnVjdHVyZSU1QiUyMmNvbnRleHQlMjIlNUQlNUIlMjJzbmlwcGV0JTIyJTVEJTIwZm9yJTIwc3RydWN0dXJlJTIwaW4lMjBzdHJ1Y3R1cmVzJTVEJTBBJTBBY29kZV9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyamluYWFpJTJGamluYS1lbWJlZGRpbmdzLXYyLWJhc2UtY29kZSUyMiklMEElMEFjb2RlX2VtYmVkZGluZ3MlMjAlM0QlMjBjb2RlX21vZGVsLmVtYmVkKGNvZGVfc25pcHBldHMlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSk=",highlighted:`code_snippets = [structure[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;snippet&quot;</span>] <span class="hljs-keyword">for</span> structure <span class="hljs-keyword">in</span> structures]

code_model = TextEmbedding(<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-code&quot;</span>)

code_embeddings = code_model.embed(code_snippets, batch_size=batch_size)`,wrap:!1}}),oe=new w({props:{title:"Building Qdrant collection",local:"building-qdrant-collection",headingTag:"h3"}}),de=new u({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBRZHJhbnRDbGllbnQlMkMlMjBtb2RlbHMlMEElMEFDT0xMRUNUSU9OX05BTUUlMjAlM0QlMjAlMjJxZHJhbnQtc291cmNlcyUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjIlM0FtZW1vcnklM0ElMjIpJTIwJTIwJTIzJTIwVXNlJTIwaW4tbWVtb3J5JTIwc3RvcmFnZSUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWhvc3QlM0E2MzMzJTIyKSUyMCUyMCUyMyUyMEZvciUyMFFkcmFudCUyMHNlcnZlciUwQSUwQWNsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjB2ZWN0b3JzX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjBtb2RlbHMuVmVjdG9yUGFyYW1zKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNpemUlM0QzODQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXN0YW5jZSUzRG1vZGVscy5EaXN0YW5jZS5DT1NJTkUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMG1vZGVscy5WZWN0b3JQYXJhbXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RhbmNlJTNEbW9kZWxzLkRpc3RhbmNlLkNPU0lORSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> QdrantClient, models

COLLECTION_NAME = <span class="hljs-string">&quot;qdrant-sources&quot;</span>

client = QdrantClient(<span class="hljs-string">&quot;:memory:&quot;</span>)  <span class="hljs-comment"># Use in-memory storage</span>
<span class="hljs-comment"># client = QdrantClient(&quot;http://locahost:6333&quot;)  # For Qdrant server</span>

client.create_collection(
    COLLECTION_NAME,
    vectors_config={
        <span class="hljs-string">&quot;text&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">384</span>,
            distance=models.Distance.COSINE,
        ),
        <span class="hljs-string">&quot;code&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">768</span>,
            distance=models.Distance.COSINE,
        ),
    },
)`,wrap:!1}}),re=new u({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcG9pbnRzJTIwJTNEJTIwJTVCJTVEJTBBdG90YWwlMjAlM0QlMjBsZW4oc3RydWN0dXJlcyklMEFwcmludCglMjJOdW1iZXIlMjBvZiUyMHBvaW50cyUyMHRvJTIwdXBsb2FkJTNBJTIwJTIyJTJDJTIwdG90YWwpJTBBJTBBZm9yJTIwaWQlMkMlMjAodGV4dF9lbWJlZGRpbmclMkMlMjBjb2RlX2VtYmVkZGluZyUyQyUyMHN0cnVjdHVyZSklMjBpbiUyMHRxZG0oZW51bWVyYXRlKHppcChubHBfZW1iZWRkaW5ncyUyQyUyMGNvZGVfZW1iZWRkaW5ncyUyQyUyMHN0cnVjdHVyZXMpKSUyQyUyMHRvdGFsJTNEdG90YWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmFzdEVtYmVkJTIwcmV0dXJucyUyMGdlbmVyYXRvcnMuJTIwRW1iZWRkaW5ncyUyMGFyZSUyMGNvbXB1dGVkJTIwYXMlMjBjb25zdW1lZC4lMEElMjAlMjAlMjAlMjBwb2ludHMuYXBwZW5kKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5Qb2ludFN0cnVjdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRGlkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVjdG9yJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMHRleHRfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMGNvZGVfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF5bG9hZCUzRHN0cnVjdHVyZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBsb2FkJTIwcG9pbnRzJTIwaW4lMjBiYXRjaGVzJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG9pbnRzKSUyMCUzRSUzRCUyMGJhdGNoX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGllbnQudXBsb2FkX3BvaW50cyhDT0xMRUNUSU9OX05BTUUlMkMlMjBwb2ludHMlM0Rwb2ludHMlMkMlMjB3YWl0JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb2ludHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjMlMjBFbnN1cmUlMjBhbnklMjByZW1haW5pbmclMjBwb2ludHMlMjBhcmUlMjB1cGxvYWRlZCUwQWlmJTIwcG9pbnRzJTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnVwbG9hZF9wb2ludHMoQ09MTEVDVElPTl9OQU1FJTJDJTIwcG9pbnRzJTNEcG9pbnRzKSUwQSUwQXByaW50KGYlMjJUb3RhbCUyMHBvaW50cyUyMGluJTIwY29sbGVjdGlvbiUzQSUyMCU3QmNsaWVudC5jb3VudChDT0xMRUNUSU9OX05BTUUpLmNvdW50JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

points = []
total = <span class="hljs-built_in">len</span>(structures)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of points to upload: &quot;</span>, total)

<span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, (text_embedding, code_embedding, structure) <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(nlp_embeddings, code_embeddings, structures)), total=total):
    <span class="hljs-comment"># FastEmbed returns generators. Embeddings are computed as consumed.</span>
    points.append(
        models.PointStruct(
            <span class="hljs-built_in">id</span>=<span class="hljs-built_in">id</span>,
            vector={
                <span class="hljs-string">&quot;text&quot;</span>: text_embedding,
                <span class="hljs-string">&quot;code&quot;</span>: code_embedding,
            },
            payload=structure,
        )
    )

    <span class="hljs-comment"># Upload points in batches</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(points) &gt;= batch_size:
        client.upload_points(COLLECTION_NAME, points=points, wait=<span class="hljs-literal">True</span>)
        points = []

<span class="hljs-comment"># Ensure any remaining points are uploaded</span>
<span class="hljs-keyword">if</span> points:
    client.upload_points(COLLECTION_NAME, points=points)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total points in collection: <span class="hljs-subst">{client.count(COLLECTION_NAME).count}</span>&quot;</span>)`,wrap:!1}}),ue=new w({props:{title:"Querying the codebase",local:"querying-the-codebase",headingTag:"h3"}}),ye=new u({props:{code:"cXVlcnklMjAlM0QlMjAlMjJIb3clMjBkbyUyMEklMjBjb3VudCUyMHBvaW50cyUyMGluJTIwYSUyMGNvbGxlY3Rpb24lM0YlMjIlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBsaW1pdCUzRDMlMkMlMEEpLnBvaW50cw==",highlighted:`query = <span class="hljs-string">&quot;How do I count points in a collection?&quot;</span>

hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;text&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),Ie=new u({props:{code:"aGl0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHMoJTBBJTIwJTIwJTIwJTIwQ09MTEVDVElPTl9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0RuZXh0KGNvZGVfbW9kZWwucXVlcnlfZW1iZWQocXVlcnkpKS50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMHVzaW5nJTNEJTIyY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpbWl0JTNEMyUyQyUwQSkucG9pbnRz",highlighted:`hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),Ce=new u({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBtb2RlbHMlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0RDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBwcmVmZXRjaCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5QcmVmZXRjaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxzLlByZWZldGNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0Rtb2RlbHMuRnVzaW9uUXVlcnkoZnVzaW9uJTNEbW9kZWxzLkZ1c2lvbi5SUkYpJTBBKS5wb2ludHM=",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> models

hits = client.query_points(
    collection_name=COLLECTION_NAME,
    prefetch=[
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;text&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;code&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
    ],
    query=models.FusionQuery(fusion=models.Fusion.RRF)
).points`,wrap:!1}}),ge=new u({props:{code:"Zm9yJTIwaGl0JTIwaW4lMjBoaXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9wYXRoJTIyJTVEJTJDJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMjAlMjIlNjAlMjAlN0MlMjIlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> hits:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>], <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_path&quot;</span>], <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.score, <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;signature&quot;</span>], <span class="hljs-string">&quot;\` |&quot;</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Ze=new w({props:{title:"Grouping the results",local:"grouping-the-results",headingTag:"h3"}}),Ae=new u({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHNfZ3JvdXBzKCUwQSUyMCUyMCUyMCUyMENPTExFQ1RJT05fTkFNRSUyQyUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBncm91cF9ieSUzRCUyMmNvbnRleHQubW9kdWxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGltaXQlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfc2l6ZSUzRDElMkMlMEEp",highlighted:`results = client.query_points_groups(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    group_by=<span class="hljs-string">&quot;context.module&quot;</span>,
    limit=<span class="hljs-number">5</span>,
    group_size=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ge=new u({props:{code:"Zm9yJTIwZ3JvdXAlMjBpbiUyMHJlc3VsdHMuZ3JvdXBzJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaGl0JTIwaW4lMjBncm91cC5oaXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9uYW1lJTIyJTVEJTJDJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMjAlMjIlNjAlMjAlN0MlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> group <span class="hljs-keyword">in</span> results.groups:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> group.hits:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>], <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_name&quot;</span>], <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.score, <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;signature&quot;</span>], <span class="hljs-string">&quot;\` |&quot;</span>
<span class="hljs-meta">... </span>        )`,wrap:!1}}),ke=new ss({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/code_search.md"}}),{c(){y=i("meta"),Ee=n(),_e=i("p"),$e=n(),p(h.$$.fragment),Ve=n(),p(I.$$.fragment),Qe=n(),U=i("p"),U.innerHTML=ol,qe=n(),b=i("p"),b.textContent=Ml,ze=n(),f=i("p"),f.innerHTML=pl,Xe=n(),p(C.$$.fragment),He=n(),g=i("p"),g.textContent=Jl,Se=n(),x=i("ul"),x.innerHTML=dl,Ye=n(),B=i("p"),B.textContent=cl,Le=n(),p(Z.$$.fragment),Fe=n(),v=i("p"),v.textContent=rl,De=n(),A=i("ul"),A.innerHTML=Tl,Pe=n(),p(G.$$.fragment),Oe=n(),p(N.$$.fragment),Ke=n(),W=i("p"),W.textContent=ul,et=n(),m=i("div"),m.innerHTML=wl,tt=n(),k=i("p"),k.textContent=yl,lt=n(),p(_.$$.fragment),st=n(),R=i("p"),R.innerHTML=ml,nt=n(),E=i("p"),E.innerHTML=jl,at=n(),$=i("p"),$.textContent=hl,it=n(),V=i("p"),V.innerHTML=Il,ot=n(),p(Q.$$.fragment),Mt=n(),q=i("p"),q.textContent=Ul,pt=n(),p(z.$$.fragment),Jt=n(),X=i("p"),X.textContent=bl,dt=n(),p(H.$$.fragment),ct=n(),p(S.$$.fragment),rt=n(),p(Y.$$.fragment),Tt=n(),L=i("p"),L.textContent=fl,ut=n(),F=i("ol"),F.innerHTML=Cl,wt=n(),D=i("p"),D.innerHTML=gl,yt=n(),p(P.$$.fragment),mt=n(),O=i("p"),O.innerHTML=xl,jt=n(),p(K.$$.fragment),ht=n(),ee=i("p"),ee.textContent=Bl,It=n(),p(te.$$.fragment),Ut=n(),p(le.$$.fragment),bt=n(),p(se.$$.fragment),ft=n(),p(ne.$$.fragment),Ct=n(),p(ae.$$.fragment),gt=n(),p(ie.$$.fragment),xt=n(),p(oe.$$.fragment),Bt=n(),Me=i("p"),Me.innerHTML=Zl,Zt=n(),pe=i("p"),pe.textContent=vl,vt=n(),j=i("blockquote"),j.innerHTML=Al,At=n(),Je=i("p"),Je.textContent=Gl,Gt=n(),p(de.$$.fragment),Nt=n(),ce=i("p"),ce.textContent=Nl,Wt=n(),p(re.$$.fragment),kt=n(),Te=i("p"),Te.textContent=Wl,_t=n(),p(ue.$$.fragment),Rt=n(),we=i("p"),we.innerHTML=kl,Et=n(),p(ye.$$.fragment),$t=n(),me=i("p"),me.textContent=_l,Vt=n(),je=i("table"),je.innerHTML=Rl,Qt=n(),he=i("p"),he.textContent=El,qt=n(),p(Ie.$$.fragment),zt=n(),Ue=i("p"),Ue.textContent=$l,Xt=n(),be=i("table"),be.innerHTML=Vl,Ht=n(),fe=i("p"),fe.textContent=Ql,St=n(),p(Ce.$$.fragment),Yt=n(),p(ge.$$.fragment),Lt=n(),xe=i("pre"),xe.textContent=ql,Ft=n(),Be=i("p"),Be.textContent=zl,Dt=n(),p(Ze.$$.fragment),Pt=n(),ve=i("p"),ve.innerHTML=Xl,Ot=n(),p(Ae.$$.fragment),Kt=n(),p(Ge.$$.fragment),el=n(),Ne=i("pre"),Ne.textContent=Hl,tl=n(),We=i("p"),We.innerHTML=Sl,ll=n(),p(ke.$$.fragment),sl=n(),Re=i("p"),this.h()},l(e){const t=Kl("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ee=a(e),_e=o(e,"P",{}),Yl(_e).forEach(l),$e=a(e),J(h.$$.fragment,e),Ve=a(e),J(I.$$.fragment,e),Qe=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-17bl742"&&(U.innerHTML=ol),qe=a(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-ae7bkg"&&(b.textContent=Ml),ze=a(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-kszg01"&&(f.innerHTML=pl),Xe=a(e),J(C.$$.fragment,e),He=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1dvof7"&&(g.textContent=Jl),Se=a(e),x=o(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-19x5x7t"&&(x.innerHTML=dl),Ye=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-d94nr5"&&(B.textContent=cl),Le=a(e),J(Z.$$.fragment,e),Fe=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-ut59o"&&(v.textContent=rl),De=a(e),A=o(e,"UL",{"data-svelte-h":!0}),M(A)!=="svelte-n6syf2"&&(A.innerHTML=Tl),Pe=a(e),J(G.$$.fragment,e),Oe=a(e),J(N.$$.fragment,e),Ke=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1g3hp9b"&&(W.textContent=ul),et=a(e),m=o(e,"DIV",{style:!0,"data-svelte-h":!0}),M(m)!=="svelte-aiydin"&&(m.innerHTML=wl),tt=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-k9nbvr"&&(k.textContent=yl),lt=a(e),J(_.$$.fragment,e),st=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-i8w8vo"&&(R.innerHTML=ml),nt=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1mfzfdl"&&(E.innerHTML=jl),at=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-15jgfrp"&&($.textContent=hl),it=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-14cl4i2"&&(V.innerHTML=Il),ot=a(e),J(Q.$$.fragment,e),Mt=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-6aidpg"&&(q.textContent=Ul),pt=a(e),J(z.$$.fragment,e),Jt=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-y6ssjb"&&(X.textContent=bl),dt=a(e),J(H.$$.fragment,e),ct=a(e),J(S.$$.fragment,e),rt=a(e),J(Y.$$.fragment,e),Tt=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1oie9o1"&&(L.textContent=fl),ut=a(e),F=o(e,"OL",{"data-svelte-h":!0}),M(F)!=="svelte-xx6zbg"&&(F.innerHTML=Cl),wt=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1k8bmra"&&(D.innerHTML=gl),yt=a(e),J(P.$$.fragment,e),mt=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1fo0w5p"&&(O.innerHTML=xl),jt=a(e),J(K.$$.fragment,e),ht=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-3wwgsm"&&(ee.textContent=Bl),It=a(e),J(te.$$.fragment,e),Ut=a(e),J(le.$$.fragment,e),bt=a(e),J(se.$$.fragment,e),ft=a(e),J(ne.$$.fragment,e),Ct=a(e),J(ae.$$.fragment,e),gt=a(e),J(ie.$$.fragment,e),xt=a(e),J(oe.$$.fragment,e),Bt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-8h1xvl"&&(Me.innerHTML=Zl),Zt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-5jc3sw"&&(pe.textContent=vl),vt=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-1r7pu79"&&(j.innerHTML=Al),At=a(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1fvhhbg"&&(Je.textContent=Gl),Gt=a(e),J(de.$$.fragment,e),Nt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-dpehrl"&&(ce.textContent=Nl),Wt=a(e),J(re.$$.fragment,e),kt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-3ws99c"&&(Te.textContent=Wl),_t=a(e),J(ue.$$.fragment,e),Rt=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-h95ly4"&&(we.innerHTML=kl),Et=a(e),J(ye.$$.fragment,e),$t=a(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1yoto9z"&&(me.textContent=_l),Vt=a(e),je=o(e,"TABLE",{"data-svelte-h":!0}),M(je)!=="svelte-129t8ym"&&(je.innerHTML=Rl),Qt=a(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-19cp8rk"&&(he.textContent=El),qt=a(e),J(Ie.$$.fragment,e),zt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1wuxk0l"&&(Ue.textContent=$l),Xt=a(e),be=o(e,"TABLE",{"data-svelte-h":!0}),M(be)!=="svelte-1d7gdtl"&&(be.innerHTML=Vl),Ht=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-6u9tc7"&&(fe.textContent=Ql),St=a(e),J(Ce.$$.fragment,e),Yt=a(e),J(ge.$$.fragment,e),Lt=a(e),xe=o(e,"PRE",{"data-svelte-h":!0}),M(xe)!=="svelte-k4pkfe"&&(xe.textContent=ql),Ft=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-rfg7y4"&&(Be.textContent=zl),Dt=a(e),J(Ze.$$.fragment,e),Pt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-t87f2d"&&(ve.innerHTML=Xl),Ot=a(e),J(Ae.$$.fragment,e),Kt=a(e),J(Ge.$$.fragment,e),el=a(e),Ne=o(e,"PRE",{"data-svelte-h":!0}),M(Ne)!=="svelte-jxqdo"&&(Ne.textContent=Hl),tl=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1rvelqz"&&(We.innerHTML=Sl),ll=a(e),J(ke.$$.fragment,e),sl=a(e),Re=o(e,"P",{}),Yl(Re).forEach(l),this.h()},h(){al(y,"name","hf:doc:metadata"),al(y,"content",as),es(m,"text-align","center"),al(j,"class","tip")},m(e,t){ts(document.head,y),s(e,Ee,t),s(e,_e,t),s(e,$e,t),d(h,e,t),s(e,Ve,t),d(I,e,t),s(e,Qe,t),s(e,U,t),s(e,qe,t),s(e,b,t),s(e,ze,t),s(e,f,t),s(e,Xe,t),d(C,e,t),s(e,He,t),s(e,g,t),s(e,Se,t),s(e,x,t),s(e,Ye,t),s(e,B,t),s(e,Le,t),d(Z,e,t),s(e,Fe,t),s(e,v,t),s(e,De,t),s(e,A,t),s(e,Pe,t),d(G,e,t),s(e,Oe,t),d(N,e,t),s(e,Ke,t),s(e,W,t),s(e,et,t),s(e,m,t),s(e,tt,t),s(e,k,t),s(e,lt,t),d(_,e,t),s(e,st,t),s(e,R,t),s(e,nt,t),s(e,E,t),s(e,at,t),s(e,$,t),s(e,it,t),s(e,V,t),s(e,ot,t),d(Q,e,t),s(e,Mt,t),s(e,q,t),s(e,pt,t),d(z,e,t),s(e,Jt,t),s(e,X,t),s(e,dt,t),d(H,e,t),s(e,ct,t),d(S,e,t),s(e,rt,t),d(Y,e,t),s(e,Tt,t),s(e,L,t),s(e,ut,t),s(e,F,t),s(e,wt,t),s(e,D,t),s(e,yt,t),d(P,e,t),s(e,mt,t),s(e,O,t),s(e,jt,t),d(K,e,t),s(e,ht,t),s(e,ee,t),s(e,It,t),d(te,e,t),s(e,Ut,t),d(le,e,t),s(e,bt,t),d(se,e,t),s(e,ft,t),d(ne,e,t),s(e,Ct,t),d(ae,e,t),s(e,gt,t),d(ie,e,t),s(e,xt,t),d(oe,e,t),s(e,Bt,t),s(e,Me,t),s(e,Zt,t),s(e,pe,t),s(e,vt,t),s(e,j,t),s(e,At,t),s(e,Je,t),s(e,Gt,t),d(de,e,t),s(e,Nt,t),s(e,ce,t),s(e,Wt,t),d(re,e,t),s(e,kt,t),s(e,Te,t),s(e,_t,t),d(ue,e,t),s(e,Rt,t),s(e,we,t),s(e,Et,t),d(ye,e,t),s(e,$t,t),s(e,me,t),s(e,Vt,t),s(e,je,t),s(e,Qt,t),s(e,he,t),s(e,qt,t),d(Ie,e,t),s(e,zt,t),s(e,Ue,t),s(e,Xt,t),s(e,be,t),s(e,Ht,t),s(e,fe,t),s(e,St,t),d(Ce,e,t),s(e,Yt,t),d(ge,e,t),s(e,Lt,t),s(e,xe,t),s(e,Ft,t),s(e,Be,t),s(e,Dt,t),d(Ze,e,t),s(e,Pt,t),s(e,ve,t),s(e,Ot,t),d(Ae,e,t),s(e,Kt,t),d(Ge,e,t),s(e,el,t),s(e,Ne,t),s(e,tl,t),s(e,We,t),s(e,ll,t),d(ke,e,t),s(e,sl,t),s(e,Re,t),nl=!0},p:Fl,i(e){nl||(c(h.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(N.$$.fragment,e),c(_.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(ge.$$.fragment,e),c(Ze.$$.fragment,e),c(Ae.$$.fragment,e),c(Ge.$$.fragment,e),c(ke.$$.fragment,e),nl=!0)},o(e){r(h.$$.fragment,e),r(I.$$.fragment,e),r(C.$$.fragment,e),r(Z.$$.fragment,e),r(G.$$.fragment,e),r(N.$$.fragment,e),r(_.$$.fragment,e),r(Q.$$.fragment,e),r(z.$$.fragment,e),r(H.$$.fragment,e),r(S.$$.fragment,e),r(Y.$$.fragment,e),r(P.$$.fragment,e),r(K.$$.fragment,e),r(te.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(oe.$$.fragment,e),r(de.$$.fragment,e),r(re.$$.fragment,e),r(ue.$$.fragment,e),r(ye.$$.fragment,e),r(Ie.$$.fragment,e),r(Ce.$$.fragment,e),r(ge.$$.fragment,e),r(Ze.$$.fragment,e),r(Ae.$$.fragment,e),r(Ge.$$.fragment,e),r(ke.$$.fragment,e),nl=!1},d(e){e&&(l(Ee),l(_e),l($e),l(Ve),l(Qe),l(U),l(qe),l(b),l(ze),l(f),l(Xe),l(He),l(g),l(Se),l(x),l(Ye),l(B),l(Le),l(Fe),l(v),l(De),l(A),l(Pe),l(Oe),l(Ke),l(W),l(et),l(m),l(tt),l(k),l(lt),l(st),l(R),l(nt),l(E),l(at),l($),l(it),l(V),l(ot),l(Mt),l(q),l(pt),l(Jt),l(X),l(dt),l(ct),l(rt),l(Tt),l(L),l(ut),l(F),l(wt),l(D),l(yt),l(mt),l(O),l(jt),l(ht),l(ee),l(It),l(Ut),l(bt),l(ft),l(Ct),l(gt),l(xt),l(Bt),l(Me),l(Zt),l(pe),l(vt),l(j),l(At),l(Je),l(Gt),l(Nt),l(ce),l(Wt),l(kt),l(Te),l(_t),l(Rt),l(we),l(Et),l($t),l(me),l(Vt),l(je),l(Qt),l(he),l(qt),l(zt),l(Ue),l(Xt),l(be),l(Ht),l(fe),l(St),l(Yt),l(Lt),l(xe),l(Ft),l(Be),l(Dt),l(Pt),l(ve),l(Ot),l(Kt),l(el),l(Ne),l(tl),l(We),l(ll),l(sl),l(Re)),l(y),T(h,e),T(I,e),T(C,e),T(Z,e),T(G,e),T(N,e),T(_,e),T(Q,e),T(z,e),T(H,e),T(S,e),T(Y,e),T(P,e),T(K,e),T(te,e),T(le,e),T(se,e),T(ne,e),T(ae,e),T(ie,e),T(oe,e),T(de,e),T(re,e),T(ue,e),T(ye,e),T(Ie,e),T(Ce,e),T(ge,e),T(Ze,e),T(Ae,e),T(Ge,e),T(ke,e)}}}const as='{"title":"Code Search with Vector Embeddings and Qdrant","local":"code-search-with-vector-embeddings-and-qdrant","sections":[{"title":"The approach","local":"the-approach","sections":[],"depth":3}],"depth":2}';function is(il){return Dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends Pl{constructor(y){super(),Ol(this,y,is,ns,Ll,{})}}export{ds as component};
