import{s as Ee,n as Ne,o as Ve}from"../chunks/scheduler.1f027d5a.js";import{S as He,i as Ye,e as M,s as a,c as r,h as Qe,a as o,d as e,b as n,f as Xe,g as p,j as i,k as Pt,l as _e,m as s,n as c,t as y,o as j,p as d}from"../chunks/index.5cb6ce42.js";import{C as Fe}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as xe,C as w}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as J,E as ze}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Se(Kt){let T,vl,Rl,Xl,u,El,m,Nl,U,Vl,I,Ot='<em>Authored by: <a href="https://huggingface.co/MoritzLaurer" rel="nofollow">Moritz Laurer</a></em>',Hl,b,le="This notebook illustrates the workflow for systematically evaluating LLM outputs and creating LLM training data. You can start by using this notebook to evaluate the zero-shot performance of your favorite LLM on your task without any fine-tuning. If you want to improve performance, you can then easily reuse this workflow to create training data.",Yl,g,te="<strong>Example use case: code generation.</strong> In this tutorial, we demonstrate how to create high-quality test and train data for code generation tasks. The same workflow can, however, be adapted to any other task relevant to your specific use case.",Ql,f,ee="<strong>In this notebook, we:</strong>",_l,C,se="<li>Download data for the example task.</li> <li>Prompt two LLMs to respond to these tasks. This results in “synthetic data” to speed up manual data creation.</li> <li>Create an Argilla annotation interface on HF Spaces to compare and evaluate the outputs from the two LLMs.</li> <li>Upload the example data and the zero-shot LLM responses into the Argilla annotation interface.</li> <li>Download the annotated data.</li>",Fl,A,ae="You can adapt this notebook to your needs, e.g., using a different LLM and API provider for step (2) or adapting the annotation task in step (3).",xl,G,zl,B,Sl,Z,$l,k,ql,R,ne='First, we download an example dataset containing LLMs’ code generation tasks. We want to evaluate how well two different LLMs perform on these code-generation tasks. We use instructions from the <a href="https://huggingface.co/datasets/bigcode/self-oss-instruct-sc2-exec-filter-50k" rel="nofollow">bigcode/self-oss-instruct-sc2-exec-filter-50k</a> dataset that was used to train the <a href="https://huggingface.co/bigcode/starcoder2-15b-instruct-v0.1" rel="nofollow">StarCoder2-Instruct</a> model.',Ll,W,Dl,v,Me="Dataset structure:\n Dataset(&#123;\n    features: ['fingerprint', 'sha1', 'seed', 'response', 'concepts', 'prompt', 'instruction', 'id'],\n    num_rows: 3\n}) \n\nExample instructions:\n ['Write a Python function named `get_value` that takes a matrix (represented by a list of lists) and a tuple of indices, and returns the value at that index in the matrix. The function should handle index out of range errors by returning None.', 'Write a Python function `check_collision` that takes a list of `rectangles` as input and checks if there are any collisions between any two rectangles. A rectangle is represented as a tuple (x, y, w, h) where (x, y) is the top-left corner of the rectangle, `w` is the width, and `h` is the height.\\n\\nThe function should return True if any pair of rectangles collide, and False otherwise. Use an iterative approach and check for collisions based on the bounding box collision detection algorithm. If a collision is found, return True immediately without checking for more collisions.']\n",Pl,X,Kl,E,Ol,N,oe='Before sending the instructions to an LLM API, we need to format the instructions with the correct <code>chat_template</code> for each of the models we want to evaluate. This essentially entails wrapping some special tokens around the instructions. See the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">docs</a> on chat templates for details.',lt,V,tt,H,ie=`First prompt formatted for mistralai/Mixtral-8x7B-Instruct-v0.1:

 <s>[INST] Write a Python function named \`get_value\` that takes a matrix (represented by a list of lists) and a tuple of indices, and returns the value at that index in the matrix. The function should handle index out of range errors by returning None. [/INST] 


First prompt formatted for meta-llama/Meta-Llama-3-70B-Instruct:

 &lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;

Write a Python function named \`get_value\` that takes a matrix (represented by a list of lists) and a tuple of indices, and returns the value at that index in the matrix. The function should handle index out of range errors by returning None.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
</s>`,et,Y,st,Q,re='Now, we can send the instructions to the APIs for both LLMs to get outputs we can evaluate. We first define some parameters for generating the responses correctly. Hugging Face’s LLM APIs are powered by <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference (TGI)</a> containers. See the TGI OpenAPI specifications <a href="https://huggingface.github.io/text-generation-inference/#/Text%20Generation%20Inference/generate" rel="nofollow">here</a> and the explanations of different parameters in the Transformers Generation Parameters <a href="https://huggingface.co/docs/transformers/v4.30.0/main_classes/text_generation#transformers.GenerationConfig" rel="nofollow">docs</a>.',at,_,nt,F,pe='Now, we can make a standard API request to the Serverless Inference API (<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">docs</a>). Note that the Serverless Inference API is mostly for testing and is rate-limited. For testing without rate limits, you can create your own API via the HF Dedicated Endpoints (<a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">docs</a>). See also our corresponding tutorials in the <a href="https://huggingface.co/learn/cookbook/index" rel="nofollow">Open Source AI Cookbook</a>.',Mt,h,ce="<p>The code below will be updated once the Inference API recipe is finished.</p>",ot,x,it,z,ye=`---First generation of mistralai/Mixtral-8x7B-Instruct-v0.1:
Here's a Python function that meets your requirements:

\`\`\`python
def get_value(matrix, indices):
    try:
        return matrix[indices[0]][indices[1]]
    except IndexError:
        return None
\`\`\`

This function takes a matrix (represented by a list of lists) and a tuple of indices as input. It first tries to access the value at the given indices in the matrix. If the indices are out of range, it catches the \`IndexError\` exception and returns \`None\`.


---First generation of meta-llama/Meta-Llama-3-70B-Instruct:
Here is a Python function that does what you described:
\`\`\`
def get_value(matrix, indices):
    try:
        row, col = indices
        return matrix[row][col]
    except IndexError:
        return None
\`\`\`
Here's an explanation of how the function works:

1. The function takes two arguments: \`matrix\` (a list of lists) and \`indices\` (a tuple of two integers, representing the row and column indices).
2. The function tries to access the value at the specified indices using \`matrix[row][col]\`.
3. If the indices are out of range (i.e., \`row\` or \`col\` is greater than the length of the corresponding dimension of the matrix), an \`IndexError\` exception is raised.
4. The \`except\` block catches the \`IndexError\` exception and returns \`None\` instead of raising an error.

Here's an example usage of the function:
\`\`\`
matrix = [[1, 2, 3], [4, 5, 6], [7, 8, 9]]

print(get_value(matrix, (0, 0)))  # prints 1
print(get_value(matrix, (1, 1)))  # prints 5
print(get_value(matrix, (3, 0)))  # prints None (out of range)
print(get_value(matrix, (0, 3)))  # prints None (out of range)
\`\`\`
I hope this helps! Let me know if you have any questions.
`,rt,S,pt,$,je="We can now store the LLM outputs in a dataset together with the original instructions.",ct,q,yt,L,jt,D,de='We use <a href="https://argilla.io/" rel="nofollow">Argilla</a>, a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects.',dt,P,Je='We run Argilla via a HF Space, which you can set up with just a few clicks without any local setup. You can create the HF Argilla Space by following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">these instructions</a>. For further configuration on HF Argilla Spaces, see also the detailed <a href="https://docs.argilla.io/latest/getting_started/how-to-configure-argilla-on-huggingface/" rel="nofollow">documentation</a>. If you want, you can also run Argilla locally via Argilla’s docker containers (see <a href="https://docs.argilla.io/latest/getting_started/how-to-deploy-argilla-with-docker/" rel="nofollow">Argilla docs</a>).',Jt,K,we='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/argilla-login-screen.png" alt="Argilla login screen"/>',wt,O,Tt,ll,Te="Before we can tailor the dataset to our specific task and upload the data that will be shown in the UI, we need to first set up a few things.",ht,tl,he="<strong>Connecting this notebook to Argilla:</strong> We can now connect this notebook to Argilla to programmatically configure your dataset and upload/download data.",ut,el,mt,sl,Ut,al,It,nl,ue="Writing good guidelines for your human annotators is just as important (and difficult) as writing good training code. Good instructions should fulfill the following criteria:",bt,Ml,me="<li><strong>Simple and clear</strong>: The guidelines should be simple and clear to understand for people who do not know anything about your task yet. Always ask at least one colleague to reread the guidelines to make sure that there are no ambiguities.</li> <li><strong>Reproducible and explicit</strong>: All information for doing the annotation task should be contained in the guidelines. A common mistake is to create informal interpretations of the guidelines during conversations with selected annotators. Future annotators will not have this information and might do the task differently than intended if it is not made explicit in the guidelines.</li> <li><strong>Short and comprehensive</strong>: The guidelines should as short as possible, while containing all necessary information. Annotators tend not to read long guidelines properly, so try to keep them as short as possible, while remaining comprehensive.</li>",gt,ol,Ue='Note that creating annotator guidelines is an iterative process. It is good practice to do a few dozen annotations yourself and refine the guidelines based on your learnings from the data before assigning the task to others. Versioning the guidelines can also help as the task evolves over time. See further tips in this <a href="https://argilla.io/blog/annotation-guidelines-practices/" rel="nofollow">blog post</a>.',ft,il,Ct,rl,Ie="<strong>Cumulative ratings vs. Likert scales:</strong> Note that the guidelines above ask the annotators to do cumulative ratings by adding points for explicit criteria. An alternative approach are “Likert scales”, where annotators are asked to rate responses on a continuous scale e.g. from 1 (very bad) to 3 (mediocre) to 5 (very good). We generally recommend cumulative ratings, because they force you and the annotators to make quality criteria explicit, while just rating a response as “4” (good) is ambiguous and will be interpreted differently by different annotators.",At,pl,Gt,cl,be='We can now create our own <code>code-llm</code> task with the fields, questions, and metadata required for annotation. For more information on configuring the Argilla dataset, see the <a href="https://docs.argilla.io/latest/how_to_guides/dataset/#create-a-dataset" rel="nofollow">Argilla docs</a>.',Bt,yl,Zt,jl,ge="After running the code above, you will see the new custom <code>code-llm</code> dataset in Argilla (and any other dataset you might have created before).",kt,dl,Rt,Jl,fe="At this point, the dataset is still empty. Let’s load some data with the code below.",Wt,wl,vt,Tl,Ce="<strong>The Argilla UI for annotation</strong> will look similar to this:",Xt,hl,Ae='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/argilla-code-llm.png" alt="Argilla UI"/>',Et,ul,Nt,ml,Ge='That’s it, we’ve created our Argilla dataset and we can now start annotating in the UI! By default, the records will be completed when they have 1 annotation. Check these guides, to know how to <a href="https://docs.argilla.io/latest/how_to_guides/distribution/" rel="nofollow">automatically distribute the annotation task</a> and <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">annotate in Argilla</a>.',Vt,Ul,Be="<strong>Important</strong>: If you use Argilla in a HF Space, you’d to activate persistent storage so that your data is safely stored and not automatically deleted after a while. For production settings, make sure that persistent storage is activated <strong>before</strong> making any annotations to avoid data loss.",Ht,Il,Yt,bl,Ze='After annotating, you can pull the data from Argilla and simply store and process them locally in any tabular format (see <a href="https://docs.argilla.io/latest/how_to_guides/import_export/" rel="nofollow">docs here</a>). You can also download the filtered version of the dataset (<a href="https://docs.argilla.io/latest/how_to_guides/query/" rel="nofollow">docs</a>).',Qt,gl,_t,fl,Ft,Cl,xt,Al,ke="That’s it! You’ve created synthetic LLM data with the HF inference API, created a dataset in Argilla, uploaded the LLM data into Argilla, evaluated/corrected the data, and after annotation you have downloaded the data in a simple tabular format for downstream use.",zt,Gl,Re="We have specifically designed the pipeline and the interface for <strong>two main use-cases</strong>:",St,Bl,We='<li>Evaluation: You can now simply use the numeric scores in the <code>score_response_1</code> and <code>score_response_2</code> columns to calculate which model was better overall. You can also inspect responses with very low or high ratings for a detailed error analysis. As you test or train different models, you can reuse this pipeline and track improvements of different models over time.</li> <li>Training: After annotating enough data, you can create a train-test split from the data and fine-tune your own model. You can either use highly rated response texts for supervised fine-tuning with the the <a href="https://huggingface.co/docs/trl/en/sft_trainer" rel="nofollow">TRL SFTTrainer</a>, or you can directly use the ratings for preference-tuning techniques like DPO with the <a href="https://huggingface.co/docs/trl/en/dpo_trainer" rel="nofollow">TRL DPOTrainer</a>. See the <a href="https://huggingface.co/docs/trl/en/index" rel="nofollow">TRL docs</a> for the pros and cons of different LLM fine-tuning techniques.</li>',$t,Zl,ve='<strong>Adapt and improve:</strong> Many things can be improved to tailor this pipeline to your specific use-cases. For example, you can prompt an LLM to evaluate the outputs of the two LLMs with instructions very similar to the guidelines for human annotators (“LLM-as-a-judge” approach). This can help further speed up your evaluation pipeline. See our <a href="https://huggingface.co/learn/cookbook/llm_judge" rel="nofollow">LLM-as-a-judge recipe</a> for an example implementation of LLM-as-a-judge and our overall <a href="https://huggingface.co/learn/cookbook/index" rel="nofollow">Open-Source AI Cookbook</a> for many other ideas.',qt,kl,Lt,Wl,Dt;return u=new xe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_argilla.ipynb"}]}}),m=new Fe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new J({props:{title:"Data Annotation with Argilla Spaces",local:"data-annotation-with-argilla-spaces",headingTag:"h1"}}),G=new J({props:{title:"Install required packages and connect to HF Hub",local:"install-required-packages-and-connect-to-hf-hub",headingTag:"h2"}}),B=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBhcmdpbGxhfiUzRDIuMC4wJTBBIXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnN+JTNENC40MC4wJTBBIXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0c34lM0QyLjE5LjAlMEEhcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yn4lM0QwLjIzLjI=",highlighted:`!pip install argilla~=<span class="hljs-number">2.0</span><span class="hljs-number">.0</span>
!pip install transformers~=<span class="hljs-number">4.40</span><span class="hljs-number">.0</span>
!pip install datasets~=<span class="hljs-number">2.19</span><span class="hljs-number">.0</span>
!pip install huggingface_hub~=<span class="hljs-number">0.23</span><span class="hljs-number">.2</span>`,wrap:!1}}),Z=new w({props:{code:"JTIzJTIwTG9naW4lMjB0byUyMHRoZSUyMEhGJTIwSHViLiUyMFdlJTIwcmVjb21tZW5kJTIwdXNpbmclMjB0aGlzJTIwbG9naW4lMjBtZXRob2QlMjAlMEElMjMlMjB0byUyMGF2b2lkJTIwdGhlJTIwbmVlZCUyMHRvJTIwZXhwbGljaXRseSUyMHN0b3JlJTIweW91ciUyMEhGJTIwdG9rZW4lMjBpbiUyMHZhcmlhYmxlcyUyMCUwQWltcG9ydCUyMGh1Z2dpbmdmYWNlX2h1YiUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmUlMEFodWdnaW5nZmFjZV9odWIubG9naW4oYWRkX3RvX2dpdF9jcmVkZW50aWFsJTNEVHJ1ZSk=",highlighted:`<span class="hljs-comment"># Login to the HF Hub. We recommend using this login method </span>
<span class="hljs-comment"># to avoid the need to explicitly store your HF token in variables </span>
<span class="hljs-keyword">import</span> huggingface_hub
!git config --<span class="hljs-keyword">global</span> credential.helper store
huggingface_hub.login(add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),k=new J({props:{title:"Download example task data",local:"download-example-task-data",headingTag:"h2"}}),W=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwU21hbGwlMjBzYW1wbGUlMjBmb3IlMjBmYXN0ZXIlMjB0ZXN0aW5nJTBBZGF0YXNldF9jb2RldGFzayUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiaWdjb2RlJTJGc2VsZi1vc3MtaW5zdHJ1Y3Qtc2MyLWV4ZWMtZmlsdGVyLTUwayUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0EzJTVEJTIyKSUwQXByaW50KCUyMkRhdGFzZXQlMjBzdHJ1Y3R1cmUlM0ElNUNuJTIyJTJDJTIwZGF0YXNldF9jb2RldGFzayUyQyUyMCUyMiU1Q24lMjIpJTBBJTBBJTIzJTIwV2UlMjBhcmUlMjBvbmx5JTIwaW50ZXJlc3RlZCUyMGluJTIwdGhlJTIwaW5zdHJ1Y3Rpb25zJTJGcHJvbXB0cyUyMHByb3ZpZGVkJTIwaW4lMjB0aGUlMjBkYXRhc2V0JTBBaW5zdHJ1Y3Rpb25zX2xzdCUyMCUzRCUyMGRhdGFzZXRfY29kZXRhc2slNUIlMjJpbnN0cnVjdGlvbiUyMiU1RCUwQXByaW50KCUyMkV4YW1wbGUlMjBpbnN0cnVjdGlvbnMlM0ElNUNuJTIyJTJDJTIwaW5zdHJ1Y3Rpb25zX2xzdCU1QiUzQTIlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Small sample for faster testing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_codetask = load_dataset(<span class="hljs-string">&quot;bigcode/self-oss-instruct-sc2-exec-filter-50k&quot;</span>, split=<span class="hljs-string">&quot;train[:3]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Dataset structure:\\n&quot;</span>, dataset_codetask, <span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We are only interested in the instructions/prompts provided in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>instructions_lst = dataset_codetask[<span class="hljs-string">&quot;instruction&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Example instructions:\\n&quot;</span>, instructions_lst[:<span class="hljs-number">2</span>])`,wrap:!1}}),X=new J({props:{title:"Prompt two LLMs on the example task",local:"prompt-two-llms-on-the-example-task",headingTag:"h2"}}),E=new J({props:{title:"Formatting the instructions with a chat_template",local:"formatting-the-instructions-with-a-chattemplate",headingTag:"h4"}}),V=new w({props:{code:"JTIzJTIwQXBwbHklMjBjb3JyZWN0JTIwY2hhdCUyMGZvcm1hdHRpbmclMjB0byUyMGluc3RydWN0aW9ucyUyMGZyb20lMjB0aGUlMjBkYXRhc2V0JTIwJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbHNfdG9fY29tcGFyZSUyMCUzRCUyMCU1QiUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIlNUQlMEElMEFkZWYlMjBmb3JtYXRfcHJvbXB0KHByb21wdCUyQyUyMHRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHByb21wdCU3RCU1RCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzX3Rva2VuaXplZCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1lc3NhZ2VzX3Rva2VuaXplZCUwQSUwQSUwQXByb21wdHNfZm9ybWF0dGVkX2RpYyUyMCUzRCUyMCU3QiU3RCUwQWZvciUyMG1vZGVsJTIwaW4lMjBtb2RlbHNfdG9fY29tcGFyZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsKSUwQSUwQSUyMCUyMCUyMCUyMHByb21wdF9mb3JtYXR0ZWQlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpbnN0cnVjdGlvbiUyMGluJTIwaW5zdHJ1Y3Rpb25zX2xzdCUzQSUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9mb3JtYXR0ZWQuYXBwZW5kKGZvcm1hdF9wcm9tcHQoaW5zdHJ1Y3Rpb24lMkMlMjB0b2tlbml6ZXIpKSUwQSUyMCUyMCUyMCUyMHByb21wdHNfZm9ybWF0dGVkX2RpYy51cGRhdGUoJTdCbW9kZWwlM0ElMjBwcm9tcHRfZm9ybWF0dGVkJTdEKSUwQSUwQSUwQXByaW50KGYlMjIlNUNuRmlyc3QlMjBwcm9tcHQlMjBmb3JtYXR0ZWQlMjBmb3IlMjAlN0Jtb2RlbHNfdG9fY29tcGFyZSU1QjAlNUQlN0QlM0ElNUNuJTVDbiUyMiUyQyUyMHByb21wdHNfZm9ybWF0dGVkX2RpYyU1Qm1vZGVsc190b19jb21wYXJlJTVCMCU1RCU1RCU1QjAlNUQlMkMlMjAlMjIlNUNuJTVDbiUyMiklMEFwcmludChmJTIyRmlyc3QlMjBwcm9tcHQlMjBmb3JtYXR0ZWQlMjBmb3IlMjAlN0Jtb2RlbHNfdG9fY29tcGFyZSU1QjElNUQlN0QlM0ElNUNuJTVDbiUyMiUyQyUyMHByb21wdHNfZm9ybWF0dGVkX2RpYyU1Qm1vZGVsc190b19jb21wYXJlJTVCMSU1RCU1RCU1QjAlNUQlMkMlMjAlMjIlNUNuJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply correct chat formatting to instructions from the dataset </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>models_to_compare = [<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">format_prompt</span>(<span class="hljs-params">prompt, tokenizer</span>):
<span class="hljs-meta">... </span>    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
<span class="hljs-meta">... </span>    messages_tokenized = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> messages_tokenized


<span class="hljs-meta">&gt;&gt;&gt; </span>prompts_formatted_dic = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> model <span class="hljs-keyword">in</span> models_to_compare:
<span class="hljs-meta">... </span>    tokenizer = AutoTokenizer.from_pretrained(model)

<span class="hljs-meta">... </span>    prompt_formatted = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> instruction <span class="hljs-keyword">in</span> instructions_lst: 
<span class="hljs-meta">... </span>        prompt_formatted.append(format_prompt(instruction, tokenizer))
        
<span class="hljs-meta">... </span>    prompts_formatted_dic.update({model: prompt_formatted})


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nFirst prompt formatted for <span class="hljs-subst">{models_to_compare[<span class="hljs-number">0</span>]}</span>:\\n\\n&quot;</span>, prompts_formatted_dic[models_to_compare[<span class="hljs-number">0</span>]][<span class="hljs-number">0</span>], <span class="hljs-string">&quot;\\n\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;First prompt formatted for <span class="hljs-subst">{models_to_compare[<span class="hljs-number">1</span>]}</span>:\\n\\n&quot;</span>, prompts_formatted_dic[models_to_compare[<span class="hljs-number">1</span>]][<span class="hljs-number">0</span>], <span class="hljs-string">&quot;\\n\\n&quot;</span>)`,wrap:!1}}),Y=new J({props:{title:"Sending the instructions to the HF Inference API",local:"sending-the-instructions-to-the-hf-inference-api",headingTag:"h4"}}),_=new w({props:{code:"Z2VuZXJhdGlvbl9wYXJhbXMlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMCUyMyUyMHdlJTIwdXNlJTIwbG93JTIwdGVtcGVyYXR1cmUlMjBhbmQlMjB0b3BfcCUyMHRvJTIwcmVkdWNlJTIwY3JlYXRpdml0eSUyMGFuZCUyMGluY3JlYXNlJTIwbGlrZWxpaG9vZCUyMG9mJTIwaGlnaGx5JTIwcHJvYmFibGUlMjB0b2tlbnMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMHRvcF9wJTNEMC42MCUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMioyJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2Z1bGxfdGV4dCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwc2VlZCUzRDQyJTJDJTBBJTIwJTIwJTIwJTIwJTIzZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjNzdG9wJTNEJTVCJTIyJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjNncmFtbWFyJTNEJTdCJTIydHlwZSUyMiUzQSUyMCUyMmpzb24lMjIlN0QlMEElMjAlMjAlMjAlMjBtYXhfdGltZSUzRE5vbmUlMkMlMjAlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwd2FpdF9mb3JfbW9kZWwlM0RGYWxzZSUyQyUwQSk=",highlighted:`generation_params = <span class="hljs-built_in">dict</span>(
    <span class="hljs-comment"># we use low temperature and top_p to reduce creativity and increase likelihood of highly probable tokens</span>
    temperature=<span class="hljs-number">0.2</span>,
    top_p=<span class="hljs-number">0.60</span>,
    top_k=<span class="hljs-literal">None</span>,
    repetition_penalty=<span class="hljs-number">1.0</span>,
    do_sample=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">512</span>*<span class="hljs-number">2</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    seed=<span class="hljs-number">42</span>,
    <span class="hljs-comment">#details=True,</span>
    <span class="hljs-comment">#stop=[&quot;&lt;|END_OF_TURN_TOKEN|&gt;&quot;],</span>
    <span class="hljs-comment">#grammar={&quot;type&quot;: &quot;json&quot;}</span>
    max_time=<span class="hljs-literal">None</span>, 
    stream=<span class="hljs-literal">False</span>,
    use_cache=<span class="hljs-literal">False</span>,
    wait_for_model=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),x=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Hint: use asynchronous API calls (and dedicated endpoints) to increase speed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">payload=<span class="hljs-literal">None</span>, api_url=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    response = requests.post(api_url, headers=headers, json=payload)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> response.json()

<span class="hljs-meta">&gt;&gt;&gt; </span>headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{huggingface_hub.get_token()}</span>&quot;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>output_dic = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> model <span class="hljs-keyword">in</span> models_to_compare:
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Create API urls for each model</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># When using dedicated endpoints, you can reuse the same code and simply replace this URL</span>
<span class="hljs-meta">... </span>    api_url = <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/&quot;</span> + model
    
<span class="hljs-meta">... </span>    <span class="hljs-comment"># send requests to API </span>
<span class="hljs-meta">... </span>    output_lst = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> tqdm(prompt_formatted):
<span class="hljs-meta">... </span>        output = query(
<span class="hljs-meta">... </span>            payload={
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;inputs&quot;</span>: prompt,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;parameters&quot;</span>: {**generation_params}
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            api_url=api_url 
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        output_lst.append(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])
    
<span class="hljs-meta">... </span>    output_dic.update({model: output_lst})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;---First generation of <span class="hljs-subst">{models_to_compare[<span class="hljs-number">0</span>]}</span>:\\n<span class="hljs-subst">{output_dic[models_to_compare[<span class="hljs-number">0</span>]][<span class="hljs-number">0</span>]}</span>\\n\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;---First generation of <span class="hljs-subst">{models_to_compare[<span class="hljs-number">1</span>]}</span>:\\n<span class="hljs-subst">{output_dic[models_to_compare[<span class="hljs-number">1</span>]][<span class="hljs-number">0</span>]}</span>&quot;</span>)`,wrap:!1}}),S=new J({props:{title:"Store the LLM outputs in a dataset",local:"store-the-llm-outputs-in-a-dataset",headingTag:"h4"}}),q=new w({props:{code:"JTIzJTIwY3JlYXRlJTIwYSUyMEhGJTIwZGF0YXNldCUyMHdpdGglMjB0aGUlMjBpbnN0cnVjdGlvbnMlMjBhbmQlMjBtb2RlbCUyMG91dHB1dHMlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMmluc3RydWN0aW9ucyUyMiUzQSUyMGluc3RydWN0aW9uc19sc3QlMkMlMEElMjAlMjAlMjAlMjAlMjJyZXNwb25zZV9tb2RlbF8xJTIyJTNBJTIwb3V0cHV0X2RpYyU1Qm1vZGVsc190b19jb21wYXJlJTVCMCU1RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc3BvbnNlX21vZGVsXzIlMjIlM0ElMjBvdXRwdXRfZGljJTVCbW9kZWxzX3RvX2NvbXBhcmUlNUIxJTVEJTVEJTBBJTdEKSUwQSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-comment"># create a HF dataset with the instructions and model outputs</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;instructions&quot;</span>: instructions_lst,
    <span class="hljs-string">&quot;response_model_1&quot;</span>: output_dic[models_to_compare[<span class="hljs-number">0</span>]],
    <span class="hljs-string">&quot;response_model_2&quot;</span>: output_dic[models_to_compare[<span class="hljs-number">1</span>]]
})

dataset`,wrap:!1}}),L=new J({props:{title:"Create and configure your Argilla dataset",local:"create-and-configure-your-argilla-dataset",headingTag:"h2"}}),O=new J({props:{title:"Programmatically interact with Argilla",local:"programmatically-interact-with-argilla",headingTag:"h4"}}),el=new w({props:{code:"JTIzJTIwQWZ0ZXIlMjBzdGFydGluZyUyMHRoZSUyMEFyZ2lsbGElMjBTcGFjZSUyMChvciUyMGxvY2FsJTIwZG9ja2VyJTIwY29udGFpbmVyKSUyMHlvdSUyMGNhbiUyMGNvbm5lY3QlMjB0byUyMHRoZSUyMFNwYWNlJTIwd2l0aCUyMHRoZSUyMGNvZGUlMjBiZWxvdy4lMEFpbXBvcnQlMjBhcmdpbGxhJTIwYXMlMjByZyUwQSUwQWNsaWVudCUyMCUzRCUyMHJnLkFyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGdXNlcm5hbWUtc3BhY2VuYW1lLmhmLnNwYWNlJTIyJTJDJTIwJTIwJTIzJTIwTG9jYWxseSUzQSUyMCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E2OTAwJTIyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMnlvdXItYXBpa2V5JTIyJTJDJTIwJTIwJTIzJTIwWW91J2xsJTIwZmluZCUyMGl0JTIwaW4lMjB0aGUlMjBVSSUyMCUyMk15JTIwU2V0dGluZ3MlMjAlM0UlMjBBUEklMjBrZXklMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBUbyUyMHVzZSUyMGElMjBwcml2YXRlJTIwSEYlMjBBcmdpbGxhJTIwU3BhY2UlMkMlMjBhbHNvJTIwcGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRCU3QiUyMkF1dGhvcml6YXRpb24lMjIlM0ElMjBmJTIyQmVhcmVyJTIwJTdCaHVnZ2luZ2ZhY2VfaHViLmdldF90b2tlbigpJTdEJTIyJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># After starting the Argilla Space (or local docker container) you can connect to the Space with the code below.</span>
<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

client = rg.Argilla(
    api_url=<span class="hljs-string">&quot;https://username-spacename.hf.space&quot;</span>,  <span class="hljs-comment"># Locally: &quot;http://localhost:6900&quot;</span>
    api_key=<span class="hljs-string">&quot;your-apikey&quot;</span>,  <span class="hljs-comment"># You&#x27;ll find it in the UI &quot;My Settings &gt; API key&quot;</span>
    <span class="hljs-comment"># To use a private HF Argilla Space, also pass your HF token</span>
    headers={<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{huggingface_hub.get_token()}</span>&quot;</span>},
)`,wrap:!1}}),sl=new w({props:{code:"dXNlciUyMCUzRCUyMGNsaWVudC5tZSUwQXVzZXI=",highlighted:`user = client.me
user`,wrap:!1}}),al=new J({props:{title:"Write good annotator guidelines",local:"write-good-annotator-guidelines",headingTag:"h4"}}),il=new w({props:{code:"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",highlighted:`annotator_guidelines = <span class="hljs-string">&quot;&quot;&quot;\\
Your task is to evaluate the responses of two LLMs to code generation tasks. 

First, you need to score each response on a scale from 0 to 7. You add points to your final score based on the following criteria:
- Add up to +2 points, if the code is properly commented, with inline comments and doc strings for functions.
- Add up to +2 points, if the code contains a good example for testing. 
- Add up to +3 points, if the code runs and works correctly. Copy the code into an IDE and test it with at least two different inputs. Attribute one point if the code is overall correct, but has some issues. Attribute three points if the code is fully correct and robust against different scenarios. 
Your resulting final score can be any value between 0 to 7. 

If both responses have a final score of &lt;= 4, select one response and correct it manually in the text field. 
The corrected response must fulfill all criteria from above. 
&quot;&quot;&quot;</span>

rating_tooltip = <span class="hljs-string">&quot;&quot;&quot;\\
- Add up to +2 points, if the code is properly commented, with inline comments and doc strings for functions.
- Add up to +2 points, if the code contains a good example for testing. 
- Add up to +3 points, if the code runs and works correctly. Copy the code into an IDE and test it with at least two different inputs. Attribute one point if the code works mostly correctly, but has some issues. Attribute three points if the code is fully correct and robust against different scenarios. 
&quot;&quot;&quot;</span>`,wrap:!1}}),pl=new J({props:{title:"Tailor your Argilla dataset to your specific task",local:"tailor-your-argilla-dataset-to-your-specific-task",headingTag:"h4"}}),yl=new w({props:{code:"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",highlighted:`dataset_argilla_name = <span class="hljs-string">&quot;code-llm&quot;</span>
workspace_name = <span class="hljs-string">&quot;argilla&quot;</span>
reuse_existing_dataset = <span class="hljs-literal">False</span>  <span class="hljs-comment"># for easier iterative testing</span>

<span class="hljs-comment"># Configure your dataset settings</span>
settings = rg.Settings(
    <span class="hljs-comment"># The overall annotation guidelines, which human annotators can refer back to inside of the interface</span>
    guidelines=<span class="hljs-string">&quot;my guidelines&quot;</span>,
    fields=[
        rg.TextField(
            name=<span class="hljs-string">&quot;instruction&quot;</span>, title=<span class="hljs-string">&quot;Instruction:&quot;</span>, use_markdown=<span class="hljs-literal">True</span>, required=<span class="hljs-literal">True</span>
        ),
        rg.TextField(
            name=<span class="hljs-string">&quot;generation_1&quot;</span>,
            title=<span class="hljs-string">&quot;Response model 1:&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">True</span>,
        ),
        rg.TextField(
            name=<span class="hljs-string">&quot;generation_2&quot;</span>,
            title=<span class="hljs-string">&quot;Response model 2:&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">True</span>,
        ),
    ],
    <span class="hljs-comment"># These are the questions we ask annotators about the fields in the dataset</span>
    questions=[
        rg.RatingQuestion(
            name=<span class="hljs-string">&quot;score_response_1&quot;</span>,
            title=<span class="hljs-string">&quot;Your score for the response of model 1:&quot;</span>,
            description=<span class="hljs-string">&quot;0=very bad, 7=very good&quot;</span>,
            values=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>],
            required=<span class="hljs-literal">True</span>,
        ),
        rg.RatingQuestion(
            name=<span class="hljs-string">&quot;score_response_2&quot;</span>,
            title=<span class="hljs-string">&quot;Your score for the response of model 2:&quot;</span>,
            description=<span class="hljs-string">&quot;0=very bad, 7=very good&quot;</span>,
            values=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>],
            required=<span class="hljs-literal">True</span>,
        ),
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;which_response_corrected&quot;</span>,
            title=<span class="hljs-string">&quot;If both responses score below 4, select a response to correct:&quot;</span>,
            description=<span class="hljs-string">&quot;Select the response you will correct in the text field below.&quot;</span>,
            labels=[<span class="hljs-string">&quot;Response 1&quot;</span>, <span class="hljs-string">&quot;Response 2&quot;</span>, <span class="hljs-string">&quot;Combination of both&quot;</span>, <span class="hljs-string">&quot;Neither&quot;</span>],
            required=<span class="hljs-literal">False</span>,
        ),
        rg.TextQuestion(
            name=<span class="hljs-string">&quot;correction&quot;</span>,
            title=<span class="hljs-string">&quot;Paste the selected response below and correct it manually:&quot;</span>,
            description=<span class="hljs-string">&quot;Your corrected response must fulfill all criteria from the annotation guidelines.&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">False</span>,
        ),
        rg.TextQuestion(
            name=<span class="hljs-string">&quot;comments&quot;</span>,
            title=<span class="hljs-string">&quot;Annotator Comments&quot;</span>,
            description=<span class="hljs-string">&quot;Add any additional comments here. E.g.: edge cases, issues with the interface etc.&quot;</span>,
            use_markdown=<span class="hljs-literal">True</span>,
            required=<span class="hljs-literal">False</span>,
        ),
    ],
    metadata=[
        rg.TermsMetadataProperty(
            name=<span class="hljs-string">&quot;source-dataset&quot;</span>,
            title=<span class="hljs-string">&quot;Original dataset source&quot;</span>,
        ),
    ],
    allow_extra_metadata=<span class="hljs-literal">False</span>,
)

<span class="hljs-keyword">if</span> reuse_existing_dataset:
    dataset_argilla = client.datasets(dataset_argilla_name, workspace=workspace_name)
<span class="hljs-keyword">else</span>:
    dataset_argilla = rg.Dataset(
        name=dataset_argilla_name,
        settings=settings,
        workspace=workspace_name,
    )
    <span class="hljs-keyword">if</span> client.datasets(dataset_argilla_name, workspace=workspace_name) <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        client.datasets(dataset_argilla_name, workspace=workspace_name).delete()
    dataset_argilla = dataset_argilla.create()

dataset_argilla`,wrap:!1}}),dl=new J({props:{title:"Load the data to Argilla",local:"load-the-data-to-argilla",headingTag:"h4"}}),wl=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Iterate over the samples in the dataset</span>
records = [
    rg.Record(
        fields={
            <span class="hljs-string">&quot;instruction&quot;</span>: example[<span class="hljs-string">&quot;instructions&quot;</span>],
            <span class="hljs-string">&quot;generation_1&quot;</span>: example[<span class="hljs-string">&quot;response_model_1&quot;</span>],
            <span class="hljs-string">&quot;generation_2&quot;</span>: example[<span class="hljs-string">&quot;response_model_2&quot;</span>],
        },
        metadata={
            <span class="hljs-string">&quot;source-dataset&quot;</span>: <span class="hljs-string">&quot;bigcode/self-oss-instruct-sc2-exec-filter-50k&quot;</span>,
        },
        <span class="hljs-comment"># Optional: add suggestions from an LLM-as-a-judge system</span>
        <span class="hljs-comment"># They will be indicated with a sparkle icon and shown as pre-filled responses</span>
        <span class="hljs-comment"># It will speed up manual annotation</span>
        <span class="hljs-comment"># suggestions=[</span>
        <span class="hljs-comment">#     rg.Suggestion(</span>
        <span class="hljs-comment">#         question_name=&quot;score_response_1&quot;,</span>
        <span class="hljs-comment">#         value=example[&quot;llm_judge_rating&quot;],</span>
        <span class="hljs-comment">#         agent=&quot;llama-3-70b-instruct&quot;,</span>
        <span class="hljs-comment">#     ),</span>
        <span class="hljs-comment"># ],</span>
    )
    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> dataset
]

<span class="hljs-keyword">try</span>:
    dataset_argilla.records.log(records)
<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Exception:&quot;</span>, e)`,wrap:!1}}),ul=new J({props:{title:"Annotate",local:"annotate",headingTag:"h2"}}),Il=new J({props:{title:"Download annotated data",local:"download-annotated-data",headingTag:"h2"}}),gl=new w({props:{code:"YW5ub3RhdGVkX2RhdGFzZXQlMjAlM0QlMjBjbGllbnQuZGF0YXNldHMoZGF0YXNldF9hcmdpbGxhX25hbWUlMkMlMjB3b3Jrc3BhY2UlM0R3b3Jrc3BhY2VfbmFtZSklMEElMEFoZl9kYXRhc2V0JTIwJTNEJTIwYW5ub3RhdGVkX2RhdGFzZXQucmVjb3Jkcy50b19kYXRhc2V0cygpJTBBJTBBJTIzJTIwVGhpcyUyMEhGJTIwZGF0YXNldCUyMGNhbiUyMHRoZW4lMjBiZSUyMGZvcm1hdHRlZCUyQyUyMHN0b3JlZCUyMGFuZCUyMHByb2Nlc3NlZCUyMGludG8lMjBhbnklMjB0YWJ1bGFyJTIwZGF0YSUyMGZvcm1hdCUwQWhmX2RhdGFzZXQudG9fcGFuZGFzKCk=",highlighted:`annotated_dataset = client.datasets(dataset_argilla_name, workspace=workspace_name)

hf_dataset = annotated_dataset.records.to_datasets()

<span class="hljs-comment"># This HF dataset can then be formatted, stored and processed into any tabular data format</span>
hf_dataset.to_pandas()`,wrap:!1}}),fl=new w({props:{code:"JTIzJTIwU3RvcmUlMjB0aGUlMjBkYXRhc2V0JTIwbG9jYWxseSUwQWhmX2RhdGFzZXQudG9fY3N2KCUyMmFyZ2lsbGEtZGF0YXNldC1sb2NhbC5jc3YlMjIpJTIwJTIwJTIzJTIwU2F2ZSUyMGFzJTIwQ1NWJTBBJTIzaGZfZGF0YXNldC50b19qc29uKCUyMmFyZ2lsbGEtZGF0YXNldC1sb2NhbC5qc29uJTIyKSUyMCUyMCUyMyUyMFNhdmUlMjBhcyUyMEpTT04lMEElMjNoZl9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJhcmdpbGxhLWRhdGFzZXQtbG9jYWwlMjIpJTIwJTIwJTIzJTIwU2F2ZSUyMGFzJTIwYSUyMCU2MGRhdGFzZXRzLkRhdGFzZXQlNjAlMjBpbiUyMHRoZSUyMGxvY2FsJTIwZmlsZXN5c3RlbSUwQSUyM2hmX2RhdGFzZXQudG9fcGFycXVldCgpJTIwJTIwJTIzJTIwU2F2ZSUyMGFzJTIwUGFycXVldA==",highlighted:`<span class="hljs-comment"># Store the dataset locally</span>
hf_dataset.to_csv(<span class="hljs-string">&quot;argilla-dataset-local.csv&quot;</span>)  <span class="hljs-comment"># Save as CSV</span>
<span class="hljs-comment">#hf_dataset.to_json(&quot;argilla-dataset-local.json&quot;)  # Save as JSON</span>
<span class="hljs-comment">#hf_dataset.save_to_disk(&quot;argilla-dataset-local&quot;)  # Save as a \`datasets.Dataset\` in the local filesystem</span>
<span class="hljs-comment">#hf_dataset.to_parquet()  # Save as Parquet</span>`,wrap:!1}}),Cl=new J({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),kl=new ze({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_argilla.md"}}),{c(){T=M("meta"),vl=a(),Rl=M("p"),Xl=a(),r(u.$$.fragment),El=a(),r(m.$$.fragment),Nl=a(),r(U.$$.fragment),Vl=a(),I=M("p"),I.innerHTML=Ot,Hl=a(),b=M("p"),b.textContent=le,Yl=a(),g=M("p"),g.innerHTML=te,Ql=a(),f=M("p"),f.innerHTML=ee,_l=a(),C=M("ol"),C.innerHTML=se,Fl=a(),A=M("p"),A.textContent=ae,xl=a(),r(G.$$.fragment),zl=a(),r(B.$$.fragment),Sl=a(),r(Z.$$.fragment),$l=a(),r(k.$$.fragment),ql=a(),R=M("p"),R.innerHTML=ne,Ll=a(),r(W.$$.fragment),Dl=a(),v=M("pre"),v.textContent=Me,Pl=a(),r(X.$$.fragment),Kl=a(),r(E.$$.fragment),Ol=a(),N=M("p"),N.innerHTML=oe,lt=a(),r(V.$$.fragment),tt=a(),H=M("pre"),H.innerHTML=ie,et=a(),r(Y.$$.fragment),st=a(),Q=M("p"),Q.innerHTML=re,at=a(),r(_.$$.fragment),nt=a(),F=M("p"),F.innerHTML=pe,Mt=a(),h=M("blockquote"),h.innerHTML=ce,ot=a(),r(x.$$.fragment),it=a(),z=M("pre"),z.textContent=ye,rt=a(),r(S.$$.fragment),pt=a(),$=M("p"),$.textContent=je,ct=a(),r(q.$$.fragment),yt=a(),r(L.$$.fragment),jt=a(),D=M("p"),D.innerHTML=de,dt=a(),P=M("p"),P.innerHTML=Je,Jt=a(),K=M("p"),K.innerHTML=we,wt=a(),r(O.$$.fragment),Tt=a(),ll=M("p"),ll.textContent=Te,ht=a(),tl=M("p"),tl.innerHTML=he,ut=a(),r(el.$$.fragment),mt=a(),r(sl.$$.fragment),Ut=a(),r(al.$$.fragment),It=a(),nl=M("p"),nl.textContent=ue,bt=a(),Ml=M("ul"),Ml.innerHTML=me,gt=a(),ol=M("p"),ol.innerHTML=Ue,ft=a(),r(il.$$.fragment),Ct=a(),rl=M("p"),rl.innerHTML=Ie,At=a(),r(pl.$$.fragment),Gt=a(),cl=M("p"),cl.innerHTML=be,Bt=a(),r(yl.$$.fragment),Zt=a(),jl=M("p"),jl.innerHTML=ge,kt=a(),r(dl.$$.fragment),Rt=a(),Jl=M("p"),Jl.textContent=fe,Wt=a(),r(wl.$$.fragment),vt=a(),Tl=M("p"),Tl.innerHTML=Ce,Xt=a(),hl=M("p"),hl.innerHTML=Ae,Et=a(),r(ul.$$.fragment),Nt=a(),ml=M("p"),ml.innerHTML=Ge,Vt=a(),Ul=M("p"),Ul.innerHTML=Be,Ht=a(),r(Il.$$.fragment),Yt=a(),bl=M("p"),bl.innerHTML=Ze,Qt=a(),r(gl.$$.fragment),_t=a(),r(fl.$$.fragment),Ft=a(),r(Cl.$$.fragment),xt=a(),Al=M("p"),Al.textContent=ke,zt=a(),Gl=M("p"),Gl.innerHTML=Re,St=a(),Bl=M("ol"),Bl.innerHTML=We,$t=a(),Zl=M("p"),Zl.innerHTML=ve,qt=a(),r(kl.$$.fragment),Lt=a(),Wl=M("p"),this.h()},l(l){const t=Qe("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(e),vl=n(l),Rl=o(l,"P",{}),Xe(Rl).forEach(e),Xl=n(l),p(u.$$.fragment,l),El=n(l),p(m.$$.fragment,l),Nl=n(l),p(U.$$.fragment,l),Vl=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-phy2er"&&(I.innerHTML=Ot),Hl=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1l9ba3b"&&(b.textContent=le),Yl=n(l),g=o(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-l6uth4"&&(g.innerHTML=te),Ql=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1j66clp"&&(f.innerHTML=ee),_l=n(l),C=o(l,"OL",{"data-svelte-h":!0}),i(C)!=="svelte-99p1uo"&&(C.innerHTML=se),Fl=n(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-t4uezl"&&(A.textContent=ae),xl=n(l),p(G.$$.fragment,l),zl=n(l),p(B.$$.fragment,l),Sl=n(l),p(Z.$$.fragment,l),$l=n(l),p(k.$$.fragment,l),ql=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-lyfwpf"&&(R.innerHTML=ne),Ll=n(l),p(W.$$.fragment,l),Dl=n(l),v=o(l,"PRE",{"data-svelte-h":!0}),i(v)!=="svelte-ky4em7"&&(v.textContent=Me),Pl=n(l),p(X.$$.fragment,l),Kl=n(l),p(E.$$.fragment,l),Ol=n(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1i1rnp2"&&(N.innerHTML=oe),lt=n(l),p(V.$$.fragment,l),tt=n(l),H=o(l,"PRE",{"data-svelte-h":!0}),i(H)!=="svelte-dhulxx"&&(H.innerHTML=ie),et=n(l),p(Y.$$.fragment,l),st=n(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1x769ch"&&(Q.innerHTML=re),at=n(l),p(_.$$.fragment,l),nt=n(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-dksij3"&&(F.innerHTML=pe),Mt=n(l),h=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-qs056z"&&(h.innerHTML=ce),ot=n(l),p(x.$$.fragment,l),it=n(l),z=o(l,"PRE",{"data-svelte-h":!0}),i(z)!=="svelte-13ofkmd"&&(z.textContent=ye),rt=n(l),p(S.$$.fragment,l),pt=n(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1rfbvc"&&($.textContent=je),ct=n(l),p(q.$$.fragment,l),yt=n(l),p(L.$$.fragment,l),jt=n(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-o96d5a"&&(D.innerHTML=de),dt=n(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1t6w574"&&(P.innerHTML=Je),Jt=n(l),K=o(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1t9619c"&&(K.innerHTML=we),wt=n(l),p(O.$$.fragment,l),Tt=n(l),ll=o(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1083lvv"&&(ll.textContent=Te),ht=n(l),tl=o(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-11y3hwk"&&(tl.innerHTML=he),ut=n(l),p(el.$$.fragment,l),mt=n(l),p(sl.$$.fragment,l),Ut=n(l),p(al.$$.fragment,l),It=n(l),nl=o(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-ezpv3g"&&(nl.textContent=ue),bt=n(l),Ml=o(l,"UL",{"data-svelte-h":!0}),i(Ml)!=="svelte-1na5fga"&&(Ml.innerHTML=me),gt=n(l),ol=o(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1qpaxi2"&&(ol.innerHTML=Ue),ft=n(l),p(il.$$.fragment,l),Ct=n(l),rl=o(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1h73c1v"&&(rl.innerHTML=Ie),At=n(l),p(pl.$$.fragment,l),Gt=n(l),cl=o(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-15ob2rx"&&(cl.innerHTML=be),Bt=n(l),p(yl.$$.fragment,l),Zt=n(l),jl=o(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-4sijlc"&&(jl.innerHTML=ge),kt=n(l),p(dl.$$.fragment,l),Rt=n(l),Jl=o(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-19sqfel"&&(Jl.textContent=fe),Wt=n(l),p(wl.$$.fragment,l),vt=n(l),Tl=o(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-no5ez3"&&(Tl.innerHTML=Ce),Xt=n(l),hl=o(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-1tsxy4g"&&(hl.innerHTML=Ae),Et=n(l),p(ul.$$.fragment,l),Nt=n(l),ml=o(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1fthso6"&&(ml.innerHTML=Ge),Vt=n(l),Ul=o(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-lspd45"&&(Ul.innerHTML=Be),Ht=n(l),p(Il.$$.fragment,l),Yt=n(l),bl=o(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-mh9wpg"&&(bl.innerHTML=Ze),Qt=n(l),p(gl.$$.fragment,l),_t=n(l),p(fl.$$.fragment,l),Ft=n(l),p(Cl.$$.fragment,l),xt=n(l),Al=o(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-6tbqup"&&(Al.textContent=ke),zt=n(l),Gl=o(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-1nz4tc1"&&(Gl.innerHTML=Re),St=n(l),Bl=o(l,"OL",{"data-svelte-h":!0}),i(Bl)!=="svelte-1nta8f4"&&(Bl.innerHTML=We),$t=n(l),Zl=o(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-afghff"&&(Zl.innerHTML=ve),qt=n(l),p(kl.$$.fragment,l),Lt=n(l),Wl=o(l,"P",{}),Xe(Wl).forEach(e),this.h()},h(){Pt(T,"name","hf:doc:metadata"),Pt(T,"content",$e),Pt(h,"class","tip")},m(l,t){_e(document.head,T),s(l,vl,t),s(l,Rl,t),s(l,Xl,t),c(u,l,t),s(l,El,t),c(m,l,t),s(l,Nl,t),c(U,l,t),s(l,Vl,t),s(l,I,t),s(l,Hl,t),s(l,b,t),s(l,Yl,t),s(l,g,t),s(l,Ql,t),s(l,f,t),s(l,_l,t),s(l,C,t),s(l,Fl,t),s(l,A,t),s(l,xl,t),c(G,l,t),s(l,zl,t),c(B,l,t),s(l,Sl,t),c(Z,l,t),s(l,$l,t),c(k,l,t),s(l,ql,t),s(l,R,t),s(l,Ll,t),c(W,l,t),s(l,Dl,t),s(l,v,t),s(l,Pl,t),c(X,l,t),s(l,Kl,t),c(E,l,t),s(l,Ol,t),s(l,N,t),s(l,lt,t),c(V,l,t),s(l,tt,t),s(l,H,t),s(l,et,t),c(Y,l,t),s(l,st,t),s(l,Q,t),s(l,at,t),c(_,l,t),s(l,nt,t),s(l,F,t),s(l,Mt,t),s(l,h,t),s(l,ot,t),c(x,l,t),s(l,it,t),s(l,z,t),s(l,rt,t),c(S,l,t),s(l,pt,t),s(l,$,t),s(l,ct,t),c(q,l,t),s(l,yt,t),c(L,l,t),s(l,jt,t),s(l,D,t),s(l,dt,t),s(l,P,t),s(l,Jt,t),s(l,K,t),s(l,wt,t),c(O,l,t),s(l,Tt,t),s(l,ll,t),s(l,ht,t),s(l,tl,t),s(l,ut,t),c(el,l,t),s(l,mt,t),c(sl,l,t),s(l,Ut,t),c(al,l,t),s(l,It,t),s(l,nl,t),s(l,bt,t),s(l,Ml,t),s(l,gt,t),s(l,ol,t),s(l,ft,t),c(il,l,t),s(l,Ct,t),s(l,rl,t),s(l,At,t),c(pl,l,t),s(l,Gt,t),s(l,cl,t),s(l,Bt,t),c(yl,l,t),s(l,Zt,t),s(l,jl,t),s(l,kt,t),c(dl,l,t),s(l,Rt,t),s(l,Jl,t),s(l,Wt,t),c(wl,l,t),s(l,vt,t),s(l,Tl,t),s(l,Xt,t),s(l,hl,t),s(l,Et,t),c(ul,l,t),s(l,Nt,t),s(l,ml,t),s(l,Vt,t),s(l,Ul,t),s(l,Ht,t),c(Il,l,t),s(l,Yt,t),s(l,bl,t),s(l,Qt,t),c(gl,l,t),s(l,_t,t),c(fl,l,t),s(l,Ft,t),c(Cl,l,t),s(l,xt,t),s(l,Al,t),s(l,zt,t),s(l,Gl,t),s(l,St,t),s(l,Bl,t),s(l,$t,t),s(l,Zl,t),s(l,qt,t),c(kl,l,t),s(l,Lt,t),s(l,Wl,t),Dt=!0},p:Ne,i(l){Dt||(y(u.$$.fragment,l),y(m.$$.fragment,l),y(U.$$.fragment,l),y(G.$$.fragment,l),y(B.$$.fragment,l),y(Z.$$.fragment,l),y(k.$$.fragment,l),y(W.$$.fragment,l),y(X.$$.fragment,l),y(E.$$.fragment,l),y(V.$$.fragment,l),y(Y.$$.fragment,l),y(_.$$.fragment,l),y(x.$$.fragment,l),y(S.$$.fragment,l),y(q.$$.fragment,l),y(L.$$.fragment,l),y(O.$$.fragment,l),y(el.$$.fragment,l),y(sl.$$.fragment,l),y(al.$$.fragment,l),y(il.$$.fragment,l),y(pl.$$.fragment,l),y(yl.$$.fragment,l),y(dl.$$.fragment,l),y(wl.$$.fragment,l),y(ul.$$.fragment,l),y(Il.$$.fragment,l),y(gl.$$.fragment,l),y(fl.$$.fragment,l),y(Cl.$$.fragment,l),y(kl.$$.fragment,l),Dt=!0)},o(l){j(u.$$.fragment,l),j(m.$$.fragment,l),j(U.$$.fragment,l),j(G.$$.fragment,l),j(B.$$.fragment,l),j(Z.$$.fragment,l),j(k.$$.fragment,l),j(W.$$.fragment,l),j(X.$$.fragment,l),j(E.$$.fragment,l),j(V.$$.fragment,l),j(Y.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(S.$$.fragment,l),j(q.$$.fragment,l),j(L.$$.fragment,l),j(O.$$.fragment,l),j(el.$$.fragment,l),j(sl.$$.fragment,l),j(al.$$.fragment,l),j(il.$$.fragment,l),j(pl.$$.fragment,l),j(yl.$$.fragment,l),j(dl.$$.fragment,l),j(wl.$$.fragment,l),j(ul.$$.fragment,l),j(Il.$$.fragment,l),j(gl.$$.fragment,l),j(fl.$$.fragment,l),j(Cl.$$.fragment,l),j(kl.$$.fragment,l),Dt=!1},d(l){l&&(e(vl),e(Rl),e(Xl),e(El),e(Nl),e(Vl),e(I),e(Hl),e(b),e(Yl),e(g),e(Ql),e(f),e(_l),e(C),e(Fl),e(A),e(xl),e(zl),e(Sl),e($l),e(ql),e(R),e(Ll),e(Dl),e(v),e(Pl),e(Kl),e(Ol),e(N),e(lt),e(tt),e(H),e(et),e(st),e(Q),e(at),e(nt),e(F),e(Mt),e(h),e(ot),e(it),e(z),e(rt),e(pt),e($),e(ct),e(yt),e(jt),e(D),e(dt),e(P),e(Jt),e(K),e(wt),e(Tt),e(ll),e(ht),e(tl),e(ut),e(mt),e(Ut),e(It),e(nl),e(bt),e(Ml),e(gt),e(ol),e(ft),e(Ct),e(rl),e(At),e(Gt),e(cl),e(Bt),e(Zt),e(jl),e(kt),e(Rt),e(Jl),e(Wt),e(vt),e(Tl),e(Xt),e(hl),e(Et),e(Nt),e(ml),e(Vt),e(Ul),e(Ht),e(Yt),e(bl),e(Qt),e(_t),e(Ft),e(xt),e(Al),e(zt),e(Gl),e(St),e(Bl),e($t),e(Zl),e(qt),e(Lt),e(Wl)),e(T),d(u,l),d(m,l),d(U,l),d(G,l),d(B,l),d(Z,l),d(k,l),d(W,l),d(X,l),d(E,l),d(V,l),d(Y,l),d(_,l),d(x,l),d(S,l),d(q,l),d(L,l),d(O,l),d(el,l),d(sl,l),d(al,l),d(il,l),d(pl,l),d(yl,l),d(dl,l),d(wl,l),d(ul,l),d(Il,l),d(gl,l),d(fl,l),d(Cl,l),d(kl,l)}}}const $e='{"title":"Data Annotation with Argilla Spaces","local":"data-annotation-with-argilla-spaces","sections":[{"title":"Install required packages and connect to HF Hub","local":"install-required-packages-and-connect-to-hf-hub","sections":[],"depth":2},{"title":"Download example task data","local":"download-example-task-data","sections":[],"depth":2},{"title":"Prompt two LLMs on the example task","local":"prompt-two-llms-on-the-example-task","sections":[{"title":"Formatting the instructions with a chat_template","local":"formatting-the-instructions-with-a-chattemplate","sections":[],"depth":4},{"title":"Sending the instructions to the HF Inference API","local":"sending-the-instructions-to-the-hf-inference-api","sections":[],"depth":4},{"title":"Store the LLM outputs in a dataset","local":"store-the-llm-outputs-in-a-dataset","sections":[],"depth":4}],"depth":2},{"title":"Create and configure your Argilla dataset","local":"create-and-configure-your-argilla-dataset","sections":[{"title":"Programmatically interact with Argilla","local":"programmatically-interact-with-argilla","sections":[],"depth":4},{"title":"Write good annotator guidelines","local":"write-good-annotator-guidelines","sections":[],"depth":4},{"title":"Tailor your Argilla dataset to your specific task","local":"tailor-your-argilla-dataset-to-your-specific-task","sections":[],"depth":4},{"title":"Load the data to Argilla","local":"load-the-data-to-argilla","sections":[],"depth":4}],"depth":2},{"title":"Annotate","local":"annotate","sections":[],"depth":2},{"title":"Download annotated data","local":"download-annotated-data","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function qe(Kt){return Ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends He{constructor(T){super(),Ye(this,T,qe,Se,Ee,{})}}export{ls as component};
