import{s as wa,a as ma,n as Ja,o as Ta}from"../chunks/scheduler.1f027d5a.js";import{S as fa,i as ba,e as s,s as i,c as p,h as Ua,a as o,d as l,b as a,f as xt,g as u,j as r,k as w,l as I,m as n,n as c,t as d,o as y,p as M}from"../chunks/index.5cb6ce42.js";import{C as ga}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as Ia,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as m,E as ja}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Ga(An){let J,$t,Zt,Ht,j,kt,G,Xt,v,Vt,B,qn='<em>Authored by: <a href="https://huggingface.co/dmaniloff" rel="nofollow">Diego Maniloff</a></em>',Rt,C,Yt,Z,En='In this notebook we will demonstrate how to bring any machine learning model to life using <a href="https://www.gradio.app/" rel="nofollow">Gradio</a>, a library that allows you to create a web demo from any Python function and share it with the world 🌎!',St,W,Pn="📚 This notebook covers:",_t,x,Dn="<li>Building a <code>Hello, World!</code> demo: The basics of Gradio</li> <li>Moving your demo to Hugging Face Spaces</li> <li>Making it interesting: a real-world example that leverages the 🤗 Hub</li> <li>Some of the cool “batteries included” features that come with Gradio</li>",Qt,$,Kn="⏭️ At the end of this notebook you will find a <code>Further Reading</code> list with links to keep going on your own.",zt,H,Ft,k,On="To get started install the <code>gradio</code> library along with <code>transformers</code>.",Lt,X,Nt,V,At,R,qt,Y,ei="At its core, Gradio turns any Python function into a web interface.",Et,S,ti="Say we have a simple function that takes <code>name</code> and <code>intensity</code> as parameters, and returns a string like so:",Pt,_,Dt,Q,li="If you run this function for the name ‘Diego’ you will get an output string that looks like this:",Kt,z,Ot,F,ni=`Hello, Diego!!!
`,el,L,ii="With Gradio, we can build an interface for this function via the <code>gr.Interface</code> class. All we need to do is pass in the <code>greet</code> function we created above, and the kinds of inputs and outputs that our function expects:",tl,N,ll,A,ai='Notice how we passed in <code>[&quot;text&quot;, &quot;slider&quot;]</code> as inputs and <code>[&quot;text&quot;]</code> as outputs — these are called <a href="https://www.gradio.app/docs/gradio/introduction" rel="nofollow">Components</a> in Gradio.',nl,q,si="That’s all we need for our first demo. Go ahead and try it out 👇🏼! Type your name into the <code>name</code> textbox, slide the intensity that you want, and click <code>Submit</code>.",il,E,al,P,sl,D,oi=`At this point you understand how to take a basic Python function and turn it into
a web-ready demo. However, we only did this for a function that is very simple, a bit boring even!`,ol,K,ri="Let’s consider a more interesting example that highlights the very thing that Gradio was built for: demoing cutting-edge machine learning models. A good friend of mine recently asked me for help with an audio recording of an interview she had done. She needed to convert the audio file into a well-organized text summary. How did I help her? I built a Gradio app!",rl,O,pi="Let’s walk through the steps to build the meeting transcription tool. We can think of the process as two parts:",pl,ee,ui="<li>Transcribe the audio file into text</li> <li>Organize the text into sections, paragraphs, lists, etc. We could include summarization here too.</li>",ul,te,cl,le,ci="In this part we will build a demo that handles the first step of the meeting transcription tool: converting audio into text.",dl,ne,di="As we learned, the key ingredient to building a Gradio demo is to have a Python function that executes the logic we are trying to showcase. For the audio-to-text conversion, we will build our function using the awesome <code>transformers</code> library and its <code>pipeline</code> utility to use a popular audio-to-text model called <code>distil-whisper/distil-large-v3</code>.",yl,ie,yi="The result is the following <code>transcribe</code> function, which takes as input the audio that we want to convert:",Ml,ae,hl,se,Mi='Now that we have our Python function, we can demo that by passing it into <code>gr.Interface</code>. Notice how in this case the input that the function expects is the audio that we want to convert. Gradio includes a ton useful components, one of which is <a href="https://www.gradio.app/docs/gradio/audio" rel="nofollow">Audio</a>, exactly what we need for our demo 🎶 😎.',ml,oe,wl,re,hi="Go ahead and try it out 👆! You can upload an <code>.mp3</code> file or hit the 🎤 button to record your own voice.",Jl,pe,mi='For a sample file with an actual meeting recording, you can check out the <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio" rel="nofollow">MeetingBank_Audio dataset</a> which is a dataset of meetings from city councils of 6 major U.S. cities. For my own testing, I tried out a couple of the <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio/blob/main/Denver/mp3/Denver-21.zip" rel="nofollow">Denver meetings</a>.',Tl,T,wi='<p>Also check out <code>Interface</code>’s <a href="https://www.gradio.app/docs/gradio/interface#interface-from_pipeline" rel="nofollow">from_pipeline</a> constructor which will directly build the <code>Interface</code> from a <code>pipeline</code>.</p>',fl,ue,bl,ce,Ji="For part 2 of the meeting transcription tool, we need to organize the transcribed text from the previous step.",Ul,de,Ti='Once again, to build a Gradio demo we need the Python function with the logic that we care about. For text organization and summarization, we will use an “instruction-tuned” model that is trained to follow a broad range of tasks. There are many options to pick from such as <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-8B-Instruct</a> or <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3" rel="nofollow">mistralai/Mistral-7B-Instruct-v0.3</a>. For our example we are going to use <a href="https://huggingface.co/microsoft/Phi-3-mini-4k-instruct" rel="nofollow">microsoft/Phi-3-mini-4k-instruct</a>.',gl,ye,fi='Just like for part 1, we could leverage the <code>pipeline</code> utility within <code>transformers</code> to do this, but instead we will take this opportunity to showcase the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>, which is an API within the Hugging Face Hub that allows us to use thousands of publicly accessible (or your own privately permissioned) machine learning models <strong><em>for free</em></strong>! Check out the cookbook section of the Serverless Inferfence API <a href="https://huggingface.co/learn/cookbook/en/enterprise_hub_serverless_inference_api" rel="nofollow">here</a>.',Il,Me,bi='Using the Serverless Inferfence API means that instead of calling a model via a pipeline (like we did for the audio conversion part), we will call it from the <code>InferenceClient</code>, which is part of the <code>huggingface_hub</code> library (<a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a>). And in turn, to use the <code>InferenceClient</code>, we need to log into the 🤗 Hub using <code>notebook_login()</code>, which will produce a dialog box asking for your User Access Token to authenticate with the Hub.',jl,he,Ui='You can manage your tokens from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">personal settings page</a>, and please remember to use <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">fine-grained</a> tokens as much as possible for enhanced security.',Gl,me,vl,we,gi="Now that we are logged into the Hub, we can write our text processing function using the Serverless Inference API via <code>InferenceClient</code>.",Bl,Je,Ii="The code for this part will be structured into two functions:",Cl,Te,ji="<li><code>build_messages</code>, to format the message prompt into the LLM;</li> <li><code>organize_text</code>, to actually pass the raw meeting text into the LLM for organization (and summarization, depending on the prompt we provide).</li>",Zl,fe,Wl,be,xl,Ue,Gi="And now that we have our text organization function <code>organize_text</code>, we can build a demo for it as well:",$l,ge,Hl,Ie,vi="Go ahead and try it out 👆! If you hit “Submit” in the demo above, you will see that the output text is a much clearer and organized version of the transcript, with a title and sections for the different parts of the meeting.",kl,je,Bi="See if you can get a summary by playing around with the <code>user_input</code> variable that controls the LLM prompt.",Xl,Ge,Vl,ve,Ci="At this point we have a function for each of the two steps we want out meeting transcription tool to do:",Rl,Be,Zi="<li>convert the audio into a text file, and</li> <li>organize that text file into a nicely-formatted meeting document.</li>",Yl,Ce,Wi="All we have to do next is stitch these two functions together and build a demo for the combined steps. In other words, our complete meeting transcription tool is just a new function (which we’ll creatively call <code>meeting_transcript_tool</code> 😀) that takes the output of <code>transcribe</code> and passes it into <code>organize_text</code>:",Sl,Ze,_l,We,xi="Go ahead and try it out 👆! This is now the full demo of our transcript tool. If you give it an audio file, the output will be the already-organized (and potentially summarized) version of the meeting. Super cool 😎.",Ql,xe,zl,$e,$i="If you made it this far, now you know the basics of how to create a demo of your machine learning model using Gradio 👏!",Fl,He,Hi="Up next we are going to show you how to take your brand new demo to Hugging Face Spaces. On top of the ease of use and powerful features of Gradio, moving your demo to 🤗 Spaces gives you the benefit of permanent hosting, ease of deployment each time you update your app, and the ability to share your work with anyone! Do keep in mind that your Space will go to sleep after a while unless you are using it or making changes to it.",Ll,ke,ki='The first step is to head over to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>, select “Gradio” from the templates, and leave the rest of the options as default for now (you can change these later):',Nl,f,Xi,Al,Xe,Vi='This will result in a newly created Space that you can populate with your demo code. As an example for you to follow, I created the 🤗 Space <code>dmaniloff/meeting-transcript-tool</code>, which you can access <a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool" rel="nofollow">here</a>.',ql,Ve,Ri="There are two files we need to edit:",El,b,Re,Bt,Yi="<code>app.py</code> — This is where the demo code lives. It should look something like this:",Fn,Ye,Ln,Se,Ct,Si="<code>requirements.txt</code> — This is where we tell our Space about the libraries it will need. It should look something like this:",Nn,_e,Pl,Qe,Dl,ze,_i="Gradio comes with lots of cool functionality right out of the box. We won’t be able to cover all of it in this notebook, but here’s 3 that we will check out:",Kl,Fe,Qi="<li>Access as an API</li> <li>Sharing via public URL</li> <li>Flagging</li>",Ol,Le,en,Ne,zi="One of the benefits of building your web demos with Gradio is that you automatically get an API 🙌! This means that you can access the functionality of your Python function using a standard HTTP client like <code>curl</code> or the Python <code>requests</code> library.",tn,Ae,Fi='If you look closely at the demos we created above, you will see at the bottom there is a link that says “Use via API”. If you click on it in the Space I created (<a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool/blob/main/app.py" rel="nofollow">dmaniloff/meeting-transcript-tool</a>), you will see the following:',ln,U,Li,nn,qe,Ni="Let’s go ahead and copy-paste that code below to use our Space as an API:",an,Ee,sn,Pe,on,De,Ai=`Loaded as API: https://dmaniloff-meeting-transcript-tool.hf.space ✔
Certainly! Below is an organized version of a hypothetical meeting transcript. Since the original transcript you've provided is quite minimal, I'll create a more detailed and structured example featuring a meeting summary.

---

# Meeting Transcript: Project Alpha Kickoff

**Date:** April 7, 2023

**Location:** Conference Room B, TechCorp Headquarters


**Attendees:**

- John Smith (Project Manager)

- Emily Johnson (Lead Developer)

- Michael Brown (Marketing Lead)

- Lisa Green (Design Lead)


**Meeting Duration:** 1 hour 30 minutes


## Opening Remarks

**John Smith:**

Good morning everyone, and thank you for joining this kickoff meeting for Project Alpha. Today, we'll discuss our project vision, milestones, and roles. Let's get started.


## Vision and Goals

**Emily Johnson:**

The main goal of Project Alpha is to
`,rn,Ke,qi="Wow! What happened there? Let’s break it down:",pn,Oe,Ei="<li>We installed the <code>gradio_client</code>, which is a package that is specifically designed to interact with APIs built with Gradio.</li> <li>We instantiated the client by providing the name of the 🤗 Space that we want to query.</li> <li>We called the <code>predict</code> method of the client and passed in a sample audio file to it.</li>",un,et,Pi="The Gradio client takes care of making the HTTP POST for us, and it also provides functionality like reading the input audio file that our meeting transcript tool will process (via the function <code>handle_file</code>).",cn,tt,Di="Again, using this client is a choice, and you can just as well run a <code>curl -X POST https://dmaniloff-meeting-transcript-tool.hf.space/call/predict [...]</code> and pass in all the parameters needed in the request.",dn,g,Ki="<p>The output that we get from the call above is a made-up meeting that was generated by the LLM that we are using for text organization. This is because the sample input file isn’t an actual meeting recording. You can tweak the LLM’s prompt to handle this case.</p>",yn,lt,Mn,nt,Oi="Another cool feature built into Gradio is that even if you build your demo on your local computer (before you move it into a 🤗 Space) you can still share this with anyone in the world by passing in <code>share=True</code> into <code>launch</code> like so:",hn,it,mn,at,ea="You might have noticed that in this Google Colab environment that behaviour is enabled by default, and so the previous demos that we created already had a public URL that you can share 🌎. Go back ⬆ and look at the logs for <code>Running on public URL:</code> to find it 🔎!",wn,st,Jn,ot,ta='<a href="https://www.gradio.app/guides/using-flagging" rel="nofollow">Flagging</a> is a feature built into Gradio that allows the users of your demo to provide feedback. You might have noticed that the first demo we created had a <code>Flag</code> button at the bottom.',Tn,rt,la="Under the default options, if a user clicks that button then the input and output samples are saved into a CSV log file that you can review later. If the demo involves audio (like in our case), these are saved separately in a parallel directory and the paths to these files are saved in the CSV file.",fn,pt,na="Go back and play with our first demo once more, and then click the <code>Flag</code> button. You will see that a new log file is created in the <code>flagged</code> directory:",bn,ut,Un,ct,ia=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
`,gn,dt,aa="In this case I set inputs to <code>name=diego</code> and <code>intensity=29</code>, which I then flagged. You can see that the log file includes the inputs to the function, the output <code>&quot;Hello, diego!!!!!!!!!!!!!!!!!!!!!!!!!!!!!&quot;</code>, and also a timestamp.",In,yt,sa="While a list of inputs and outputs that your users found problematic is better than nothing, Gradio’s flagging feature allows you to do much more. For example, you can provide a <code>flagging_options</code> parameter that lets you customize the kind of feedback or errors that you can receive, such as <code>[&quot;Incorrect&quot;, &quot;Ambiguous&quot;]</code>. Note that this requires that <code>allow_flagging</code> is set to <code>&quot;manual&quot;</code>:",jn,Mt,Gn,ht,oa="Go ahead and try it out 👆! You can see that the flagging buttons now are <code>Flag as Incorrect</code> and <code>Flag as Ambiguous</code>, and the new log file will reflect those options:",vn,mt,Bn,wt,ra=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
Diego,5,"Hello, Diego!!!!!",Ambiguous,,2024-06-29 22:08:04.281030
`,Cn,Jt,Zn,Tt,pa="In this notebook we learned how to demo any machine learning model using Gradio.",Wn,ft,ua="First, we learned the basics of setting up an interface for a simple Python function; and second, we covered Gradio’s true strength: building demos for machine learning models.",xn,bt,ca="For this, we learned how easy it is to leverage models in the 🤗 Hub via the <code>transformers</code> library and its <code>pipeline</code> function, and how to use multimedia inputs like <code>gr.Audio</code>.",$n,Ut,da="Third, we covered how to host your Gradio demo on 🤗 Spaces, which lets you keep your demo running in the cloud and gives you flexibility in terms of the compute requirements for your demo.",Hn,gt,ya="Finally, we showcased a few of the super cool batteries included that come with Gradio such as API access, public URLs, and Flagging.",kn,It,Ma="For next steps, check out the <code>Further Reading</code> links at the end of each section.",Xn,jt,Vn,Gt,ha='<li><a href="https://www.gradio.app/guides/quickstart#building-your-first-demo" rel="nofollow">Your first demo with gradio</a></li> <li><a href="https://www.gradio.app/docs/gradio/introduction" rel="nofollow">Gradio Components</a></li> <li><a href="https://huggingface.co/docs/transformers/en/index" rel="nofollow">The transformers library</a></li> <li><a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">The pipeline function</a></li> <li><a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a></li> <li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a></li> <li><a href="https://huggingface.co/spaces" rel="nofollow">🤗 Spaces</a></li> <li><a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Spaces documentation</a></li>',Rn,vt,Yn,Wt,Sn;return j=new Ia({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_gradio.ipynb"}]}}),G=new ga({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new m({props:{title:"Creating Demos with Spaces and Gradio",local:"creating-demos-with-spaces-and-gradio",headingTag:"h1"}}),C=new m({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),H=new m({props:{title:"Setup",local:"setup",headingTag:"h2"}}),X=new h({props:{code:"IXBpcCUyMC1xJTIwaW5zdGFsbCUyMGdyYWRpbyUzRCUzRDQuMzYuMSUwQSFwaXAlMjAtcSUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlM0QlM0Q0LjQxLjI=",highlighted:`!pip -q install gradio==<span class="hljs-number">4.36</span><span class="hljs-number">.1</span>
!pip -q install transformers==<span class="hljs-number">4.41</span><span class="hljs-number">.2</span>`,wrap:!1}}),V=new h({props:{code:"JTIzJTIwdGhlJTIwdXN1YWwlMjBzaG9ydGhhbmQlMjBpcyUyMHRvJTIwaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3I=",highlighted:`<span class="hljs-comment"># the usual shorthand is to import gradio as gr</span>
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr`,wrap:!1}}),R=new m({props:{title:"Your first demo: the basics of Gradio",local:"your-first-demo-the-basics-of-gradio",headingTag:"h2"}}),_=new h({props:{code:"ZGVmJTIwZ3JlZXQobmFtZSUzQSUyMHN0ciUyQyUyMGludGVuc2l0eSUzQSUyMGludCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySGVsbG8lMkMlMjAlMjIlMjAlMkIlMjBuYW1lJTIwJTJCJTIwJTIyISUyMiUyMColMjBpbnQoaW50ZW5zaXR5KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greet</span>(<span class="hljs-params">name: <span class="hljs-built_in">str</span>, intensity: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Hello, &quot;</span> + name + <span class="hljs-string">&quot;!&quot;</span> * <span class="hljs-built_in">int</span>(intensity)`,wrap:!1}}),z=new h({props:{code:"cHJpbnQoZ3JlZXQoJTIyRGllZ28lMjIlMkMlMjAzKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(greet(<span class="hljs-string">&quot;Diego&quot;</span>, <span class="hljs-number">3</span>))',wrap:!1}}),N=new h({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSk=",highlighted:`demo = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>], <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],          <span class="hljs-comment"># the output is a text box</span>
)`,wrap:!1}}),E=new h({props:{code:"JTIzJTIwdGhlJTIwbGF1bmNoJTIwbWV0aG9kJTIwd2lsbCUyMGZpcmUlMjB1cCUyMHRoZSUyMGludGVyZmFjZSUyMHdlJTIwanVzdCUyMGNyZWF0ZWQlMEFkZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-comment"># the launch method will fire up the interface we just created</span>
demo.launch()`,wrap:!1}}),P=new m({props:{title:"Let’s make it interesting: a meeting transcription tool",local:"lets-make-it-interesting-a-meeting-transcription-tool",headingTag:"h2"}}),te=new m({props:{title:"Audio-to-text",local:"audio-to-text",headingTag:"h3"}}),ae=new h({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0ZW1wZmlsZSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMDAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBJTBBQVVESU9fTU9ERUxfTkFNRSUyMCUzRCUyMCUyMmRpc3RpbC13aGlzcGVyJTJGZGlzdGlsLWxhcmdlLXYzJTIyJTIwJTIzJTIwZmFzdGVyJTIwYW5kJTIwdmVyeSUyMGNsb3NlJTIwaW4lMjBwZXJmb3JtYW5jZSUyMHRvJTIwdGhlJTIwZnVsbC1zaXplJTIwJTIyb3BlbmFpJTJGd2hpc3Blci1sYXJnZS12MyUyMiUwQUJBVENIX1NJWkUlMjAlM0QlMjA4JTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RBVURJT19NT0RFTF9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwY2h1bmtfbGVuZ3RoX3MlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRGRldmljZSUyQyUwQSklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlKGF1ZGlvX2lucHV0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkZ1bmN0aW9uJTIwdG8lMjBjb252ZXJ0JTIwYXVkaW8lMjB0byUyMHRleHQuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBhdWRpb19pbnB1dCUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwZ3IuRXJyb3IoJTIyTm8lMjBhdWRpbyUyMGZpbGUlMjBzdWJtaXR0ZWQhJTIyKSUwQSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9faW5wdXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEQkFUQ0hfU0laRSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuX3RpbWVzdGFtcHMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-number">0</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

AUDIO_MODEL_NAME = <span class="hljs-string">&quot;distil-whisper/distil-large-v3&quot;</span> <span class="hljs-comment"># faster and very close in performance to the full-size &quot;openai/whisper-large-v3&quot;</span>
BATCH_SIZE = <span class="hljs-number">8</span>


pipe = pipeline(
    task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=AUDIO_MODEL_NAME,
    chunk_length_s=<span class="hljs-number">30</span>,
    device=device,
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">audio_input</span>):
    <span class="hljs-string">&quot;&quot;&quot;Function to convert audio to text.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_input <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> gr.Error(<span class="hljs-string">&quot;No audio file submitted!&quot;</span>)

    output = pipe(
        audio_input,
        batch_size=BATCH_SIZE,
        generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
        return_timestamps=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),oe=new h({props:{code:"cGFydF8xX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0R0cmFuc2NyaWJlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8odHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUyMCUyMyUyMCUyMmZpbGVwYXRoJTIyJTIwcGFzc2VzJTIwYSUyMHN0ciUyMHBhdGglMjB0byUyMGElMjB0ZW1wb3JhcnklMjBmaWxlJTIwY29udGFpbmluZyUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTIwJTIzJTIwZ2l2ZSUyMHVzZXJzJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjBjb3B5JTIwdGhlJTIwcmVzdWx0cyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyVHJhbnNjcmliZSUyMEF1ZGlvJTIwdG8lMjBUZXh0JTIyJTJDJTIwJTIzJTIwZ2l2ZSUyMG91ciUyMGRlbW8lMjBhJTIwdGl0bGUlMjAlM0EpJTBBKSUwQSUwQXBhcnRfMV9kZW1vLmxhdW5jaCgp",highlighted:`part_1_demo = gr.Interface(
    fn=transcribe,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>), <span class="hljs-comment"># &quot;filepath&quot; passes a str path to a temporary file containing the audio</span>
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>), <span class="hljs-comment"># give users the option to copy the results</span>
    title=<span class="hljs-string">&quot;Transcribe Audio to Text&quot;</span>, <span class="hljs-comment"># give our demo a title :)</span>
)

part_1_demo.launch()`,wrap:!1}}),ue=new m({props:{title:"Organize & summarize text",local:"organize--summarize-text",headingTag:"h3"}}),me=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIwcnVubmluZyUyMHRoaXMlMjB3aWxsJTIwcHJvbXB0JTIweW91JTIwdG8lMjBlbnRlciUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMGNyZWRlbnRpYWxzJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, InferenceClient

<span class="hljs-comment"># running this will prompt you to enter your Hugging Face credentials</span>
notebook_login()`,wrap:!1}}),fe=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># sample meeting transcript from huuuyeah/MeetingBank_Audio</span>
<span class="hljs-comment"># this is just a copy-paste from the output of part 1 using one of the Denver meetings</span>
sample_transcript = <span class="hljs-string">&quot;&quot;&quot;
 Good evening. Welcome to the Denver City Council meeting of Monday, May 8, 2017. My name is Kelly Velez. I&#x27;m your Council Secretary. According to our rules of procedure, when our Council President, Albus Brooks, and Council President Pro Tem, JoLynn Clark, are both absent, the Council Secretary calls the meeting to order. Please rise and join Councilman Herndon in the Pledge of Allegiance. Madam Secretary, roll call. Roll call. Here. Mark. Espinosa. Here. Platt. Delmar. Here. Here. Here. Here. We have five members present. There is not a quorum this evening. Many of the council members are participating in an urban exploration trip in Portland, Oregon, pursuant to Section 3.3.4 of the city charter. Because there is not a quorum of seven council members present, all of tonight&#x27;s business will move to next week, to Monday, May 15th. Seeing no other business before this body except to wish Councilwoman Keniche a very happy birthday this meeting is adjourned Thank you. A standard model and an energy efficient model likely will be returned to you in energy savings many times during its lifespan. Now, what size do you need? Air conditioners are not a one-size-or-type fits all. Before you buy an air conditioner, you need to consider the size of your home and the cost to operate the unit per hour. Do you want a room air conditioner, which costs less but cools a smaller area, or do you want a central air conditioner, which cools your entire house but costs more? Do your homework. Now, let&#x27;s discuss evaporative coolers. In low humidity areas, evaporating water into the air provides a natural and energy efficient means of cooling. Evaporative coolers, also called swamp coolers, cool outdoor air by passing it over water saturated pads, causing the water to evaporate into it. Evaporative coolers cost about one half as much to install as central air conditioners and use about one-quarter as much energy. However, they require more frequent maintenance than refrigerated air conditioners, and they&#x27;re suitable only for areas with low humidity. Watch the maintenance tips at the end of this segment to learn more. And finally, fans. When air moves around in your home, it creates a wind chill effect. A mere two-mile-an-hour breeze will make your home feel four degrees cooler and therefore you can set your thermostat a bit higher. Ceiling fans and portable oscillating fans are cheap to run and they make your house feel cooler. You can also install a whole house fan to draw the hot air out of your home. A whole house fan draws cool outdoor air inside through open windows and exhausts hot room air through the attic to the outside. The result is excellent ventilation, lower indoor temperatures, and improved evaporative cooling. But remember, there are many low-cost, no-cost ways that you can keep your home cool. You should focus on these long before you turn on your AC or even before you purchase an AC. But if you are going to purchase a new cooling system, remember to get one that&#x27;s energy efficient and the correct size for your home. Wait, wait, don&#x27;t go away, there&#x27;s more. After this segment of the presentation is over, you&#x27;re going to be given the option to view maintenance tips about air conditioners and evaporative coolers. Now all of these tips are brought to you by the people at Xcel Energy. Thanks for watching.
&quot;&quot;&quot;</span>`,wrap:!1}}),be=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQVRFWFRfTU9ERUxfTkFNRSUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQobWVldGluZ190cmFuc2NyaXB0KSUzQSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUyMG1vZGVsJTNEVEVYVF9NT0RFTF9OQU1FJTJDJTIwbWF4X3Rva2VucyUzRDI1MCUyQyUyMHNlZWQlM0Q0MzAlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTBBJTBBZGVmJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUyMC0lM0UlMjBsaXN0JTNBJTBBJTIwJTIwJTIwJTIwc3lzdGVtX2lucHV0JTIwJTNEJTIwJTIyWW91JTIwYXJlJTIwYW4lMjBhc3NpdGFudCUyMHRoYXQlMjBvcmdhbml6ZXMlMjBtZWV0aW5nJTIwbWludXRlcy4lMjIlMEElMjAlMjAlMjAlMjB1c2VyX2lucHV0JTIwJTNEJTIwJTIyJTIyJTIyVGFrZSUyMHRoaXMlMjByYXclMjBtZWV0aW5nJTIwdHJhbnNjcmlwdCUyMGFuZCUyMHJldHVybiUyMGFuJTIwb3JnYW5pemVkJTIwdmVyc2lvbi4lMEElMjAlMjAlMjAlMjBIZXJlJTIwaXMlMjB0aGUlMjB0cmFuc2NyaXB0JTNBJTBBJTIwJTIwJTIwJTIwJTdCbWVldGluZ190cmFuc2NyaXB0JTdEJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyLmZvcm1hdChtZWV0aW5nX3RyYW5zY3JpcHQlM0RtZWV0aW5nX3RyYW5zY3JpcHQpJTBBJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9pbnB1dCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHVzZXJfaW5wdXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXNzYWdlcw==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

TEXT_MODEL_NAME = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

client = InferenceClient()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">meeting_transcript</span>):
    messages = build_messages(meeting_transcript)
    response = client.chat_completion(
        messages, model=TEXT_MODEL_NAME, max_tokens=<span class="hljs-number">250</span>, seed=<span class="hljs-number">430</span>
    )
    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


<span class="hljs-keyword">def</span> <span class="hljs-title function_">build_messages</span>(<span class="hljs-params">meeting_transcript</span>) -&gt; <span class="hljs-built_in">list</span>:
    system_input = <span class="hljs-string">&quot;You are an assitant that organizes meeting minutes.&quot;</span>
    user_input = <span class="hljs-string">&quot;&quot;&quot;Take this raw meeting transcript and return an organized version.
    Here is the transcript:
    {meeting_transcript}
    &quot;&quot;&quot;</span>.<span class="hljs-built_in">format</span>(meeting_transcript=meeting_transcript)

    messages = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_input},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_input},
    ]
    <span class="hljs-keyword">return</span> messages`,wrap:!1}}),ge=new h({props:{code:"cGFydF8yX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0Rvcmdhbml6ZV90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuVGV4dGJveCh2YWx1ZSUzRHNhbXBsZV90cmFuc2NyaXB0KSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5UZXh0Ym94KHNob3dfY29weV9idXR0b24lM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQ2xlYW4lMjBVcCUyMFRyYW5zY3JpcHQlMjBUZXh0JTIyJTJDJTBBKSUwQXBhcnRfMl9kZW1vLmxhdW5jaCgp",highlighted:`part_2_demo = gr.Interface(
    fn=organize_text,
    inputs=gr.Textbox(value=sample_transcript),
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
    title=<span class="hljs-string">&quot;Clean Up Transcript Text&quot;</span>,
)
part_2_demo.launch()`,wrap:!1}}),Ge=new m({props:{title:"Putting it all together",local:"putting-it-all-together",headingTag:"h3"}}),Ze=new h({props:{code:"ZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woYXVkaW9faW5wdXQpJTNBJTBBJTIwJTIwJTIwJTIwbWVldGluZ190ZXh0JTIwJTNEJTIwdHJhbnNjcmliZShhdWRpb19pbnB1dCklMEElMjAlMjAlMjAlMjBvcmdhbml6ZWRfdGV4dCUyMCUzRCUyMG9yZ2FuaXplX3RleHQobWVldGluZ190ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZ2FuaXplZF90ZXh0JTBBJTBBJTBBZnVsbF9kZW1vJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEbWVldGluZ190cmFuc2NyaXB0X3Rvb2wlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJUaGUlMjBDb21wbGV0ZSUyME1lZXRpbmclMjBUcmFuc2NyaXB0aW9uJTIwVG9vbCUyMiUyQyUwQSklMEFmdWxsX2RlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">audio_input</span>):
    meeting_text = transcribe(audio_input)
    organized_text = organize_text(meeting_text)
    <span class="hljs-keyword">return</span> organized_text


full_demo = gr.Interface(
    fn=meeting_transcript_tool,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
    title=<span class="hljs-string">&quot;The Complete Meeting Transcription Tool&quot;</span>,
)
full_demo.launch()`,wrap:!1}}),xe=new m({props:{title:"Move your demo into 🤗 Spaces",local:"move-your-demo-into--spaces",headingTag:"h2"}}),Ye=new h({props:{code:"JTIzJTIwb3V0bGluZSUyMG9mJTIwYXBwLnB5JTNBJTBBJTBBZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMHRyYW5zY3JpYmUoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQQ==",highlighted:`<span class="hljs-comment"># outline of app.py:</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">...</span>):
   ...
`,wrap:!1}}),_e=new h({props:{code:"JTIzJTIwY29udGVudHMlMjBvZiUyMHJlcXVpcmVtZW50cy50eHQlM0ElMEF0b3JjaCUwQXRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># contents of requirements.txt:</span>
<span class="hljs-attribute">torch</span>
transformers`,wrap:!1}}),Qe=new m({props:{title:"Gradio comes with batteries included 🔋",local:"gradio-comes-with-batteries-included-",headingTag:"h2"}}),Le=new m({props:{title:"Access as an API",local:"access-as-an-api",headingTag:"h3"}}),Ee=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBncmFkaW9fY2xpZW50",highlighted:"!pip install gradio_client",wrap:!1}}),Pe=new h({props:{code:"ZnJvbSUyMGdyYWRpb19jbGllbnQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBoYW5kbGVfZmlsZSUwQSUwQWNsaWVudCUyMCUzRCUyMENsaWVudCglMjJkbWFuaWxvZmYlMkZtZWV0aW5nLXRyYW5zY3JpcHQtdG9vbCUyMiklMEFyZXN1bHQlMjAlM0QlMjBjbGllbnQucHJlZGljdCglMEElMDklMDlhdWRpb19pbnB1dCUzRGhhbmRsZV9maWxlKCdodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZncmFkaW8tYXBwJTJGZ3JhZGlvJTJGcmF3JTJGbWFpbiUyRnRlc3QlMkZ0ZXN0X2ZpbGVzJTJGYXVkaW9fc2FtcGxlLndhdicpJTJDJTBBJTA5JTA5YXBpX25hbWUlM0QlMjIlMkZwcmVkaWN0JTIyJTBBKSUwQXByaW50KHJlc3VsdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> gradio_client <span class="hljs-keyword">import</span> Client, handle_file

<span class="hljs-meta">&gt;&gt;&gt; </span>client = Client(<span class="hljs-string">&quot;dmaniloff/meeting-transcript-tool&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = client.predict(
<span class="hljs-meta">&gt;&gt;&gt; </span>		audio_input=handle_file(<span class="hljs-string">&#x27;https://github.com/gradio-app/gradio/raw/main/test/test_files/audio_sample.wav&#x27;</span>),
<span class="hljs-meta">&gt;&gt;&gt; </span>		api_name=<span class="hljs-string">&quot;/predict&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)`,wrap:!1}}),lt=new m({props:{title:"Share via public URL",local:"share-via-public-url",headingTag:"h3"}}),it=new h({props:{code:"JTIwZGVtby5sYXVuY2goc2hhcmUlM0RUcnVlKQ==",highlighted:' demo.launch(share=<span class="hljs-literal">True</span>)',wrap:!1}}),st=new m({props:{title:"Flagging",local:"flagging",headingTag:"h3"}}),ut=new h({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),Mt=new h({props:{code:"ZGVtb193aXRoX2N1c3RvbV9mbGFnZ2luZyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSUyMCUyMCUyMCUyMGFsbG93X2ZsYWdnaW5nJTNEJTIybWFudWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ2dpbmdfb3B0aW9ucyUzRCU1QiUyMkluY29ycmVjdCUyMiUyQyUyMCUyMkFtYmlndW91cyUyMiU1RCUyQyUwQSklMEFkZW1vX3dpdGhfY3VzdG9tX2ZsYWdnaW5nLmxhdW5jaCgp",highlighted:`demo_with_custom_flagging = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>], <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],          <span class="hljs-comment"># the output is a text box</span>
    allow_flagging=<span class="hljs-string">&quot;manual&quot;</span>,
    flagging_options=[<span class="hljs-string">&quot;Incorrect&quot;</span>, <span class="hljs-string">&quot;Ambiguous&quot;</span>],
)
demo_with_custom_flagging.launch()`,wrap:!1}}),mt=new h({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),Jt=new m({props:{title:"Wrap up & Next Steps",local:"wrap-up--next-steps",headingTag:"h2"}}),jt=new m({props:{title:"⏭️ Further reading",local:"-further-reading",headingTag:"h2"}}),vt=new ja({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_gradio.md"}}),{c(){J=s("meta"),$t=i(),Zt=s("p"),Ht=i(),p(j.$$.fragment),kt=i(),p(G.$$.fragment),Xt=i(),p(v.$$.fragment),Vt=i(),B=s("p"),B.innerHTML=qn,Rt=i(),p(C.$$.fragment),Yt=i(),Z=s("p"),Z.innerHTML=En,St=i(),W=s("p"),W.textContent=Pn,_t=i(),x=s("ul"),x.innerHTML=Dn,Qt=i(),$=s("p"),$.innerHTML=Kn,zt=i(),p(H.$$.fragment),Ft=i(),k=s("p"),k.innerHTML=On,Lt=i(),p(X.$$.fragment),Nt=i(),p(V.$$.fragment),At=i(),p(R.$$.fragment),qt=i(),Y=s("p"),Y.textContent=ei,Et=i(),S=s("p"),S.innerHTML=ti,Pt=i(),p(_.$$.fragment),Dt=i(),Q=s("p"),Q.textContent=li,Kt=i(),p(z.$$.fragment),Ot=i(),F=s("pre"),F.textContent=ni,el=i(),L=s("p"),L.innerHTML=ii,tl=i(),p(N.$$.fragment),ll=i(),A=s("p"),A.innerHTML=ai,nl=i(),q=s("p"),q.innerHTML=si,il=i(),p(E.$$.fragment),al=i(),p(P.$$.fragment),sl=i(),D=s("p"),D.textContent=oi,ol=i(),K=s("p"),K.textContent=ri,rl=i(),O=s("p"),O.textContent=pi,pl=i(),ee=s("ol"),ee.innerHTML=ui,ul=i(),p(te.$$.fragment),cl=i(),le=s("p"),le.textContent=ci,dl=i(),ne=s("p"),ne.innerHTML=di,yl=i(),ie=s("p"),ie.innerHTML=yi,Ml=i(),p(ae.$$.fragment),hl=i(),se=s("p"),se.innerHTML=Mi,ml=i(),p(oe.$$.fragment),wl=i(),re=s("p"),re.innerHTML=hi,Jl=i(),pe=s("p"),pe.innerHTML=mi,Tl=i(),T=s("blockquote"),T.innerHTML=wi,fl=i(),p(ue.$$.fragment),bl=i(),ce=s("p"),ce.textContent=Ji,Ul=i(),de=s("p"),de.innerHTML=Ti,gl=i(),ye=s("p"),ye.innerHTML=fi,Il=i(),Me=s("p"),Me.innerHTML=bi,jl=i(),he=s("p"),he.innerHTML=Ui,Gl=i(),p(me.$$.fragment),vl=i(),we=s("p"),we.innerHTML=gi,Bl=i(),Je=s("p"),Je.textContent=Ii,Cl=i(),Te=s("ul"),Te.innerHTML=ji,Zl=i(),p(fe.$$.fragment),Wl=i(),p(be.$$.fragment),xl=i(),Ue=s("p"),Ue.innerHTML=Gi,$l=i(),p(ge.$$.fragment),Hl=i(),Ie=s("p"),Ie.textContent=vi,kl=i(),je=s("p"),je.innerHTML=Bi,Xl=i(),p(Ge.$$.fragment),Vl=i(),ve=s("p"),ve.textContent=Ci,Rl=i(),Be=s("ol"),Be.innerHTML=Zi,Yl=i(),Ce=s("p"),Ce.innerHTML=Wi,Sl=i(),p(Ze.$$.fragment),_l=i(),We=s("p"),We.textContent=xi,Ql=i(),p(xe.$$.fragment),zl=i(),$e=s("p"),$e.textContent=$i,Fl=i(),He=s("p"),He.textContent=Hi,Ll=i(),ke=s("p"),ke.innerHTML=ki,Nl=i(),f=s("img"),Al=i(),Xe=s("p"),Xe.innerHTML=Vi,ql=i(),Ve=s("p"),Ve.textContent=Ri,El=i(),b=s("ul"),Re=s("li"),Bt=s("p"),Bt.innerHTML=Yi,Fn=i(),p(Ye.$$.fragment),Ln=i(),Se=s("li"),Ct=s("p"),Ct.innerHTML=Si,Nn=i(),p(_e.$$.fragment),Pl=i(),p(Qe.$$.fragment),Dl=i(),ze=s("p"),ze.textContent=_i,Kl=i(),Fe=s("ul"),Fe.innerHTML=Qi,Ol=i(),p(Le.$$.fragment),en=i(),Ne=s("p"),Ne.innerHTML=zi,tn=i(),Ae=s("p"),Ae.innerHTML=Fi,ln=i(),U=s("img"),nn=i(),qe=s("p"),qe.textContent=Ni,an=i(),p(Ee.$$.fragment),sn=i(),p(Pe.$$.fragment),on=i(),De=s("pre"),De.textContent=Ai,rn=i(),Ke=s("p"),Ke.textContent=qi,pn=i(),Oe=s("ul"),Oe.innerHTML=Ei,un=i(),et=s("p"),et.innerHTML=Pi,cn=i(),tt=s("p"),tt.innerHTML=Di,dn=i(),g=s("blockquote"),g.innerHTML=Ki,yn=i(),p(lt.$$.fragment),Mn=i(),nt=s("p"),nt.innerHTML=Oi,hn=i(),p(it.$$.fragment),mn=i(),at=s("p"),at.innerHTML=ea,wn=i(),p(st.$$.fragment),Jn=i(),ot=s("p"),ot.innerHTML=ta,Tn=i(),rt=s("p"),rt.textContent=la,fn=i(),pt=s("p"),pt.innerHTML=na,bn=i(),p(ut.$$.fragment),Un=i(),ct=s("pre"),ct.textContent=ia,gn=i(),dt=s("p"),dt.innerHTML=aa,In=i(),yt=s("p"),yt.innerHTML=sa,jn=i(),p(Mt.$$.fragment),Gn=i(),ht=s("p"),ht.innerHTML=oa,vn=i(),p(mt.$$.fragment),Bn=i(),wt=s("pre"),wt.textContent=ra,Cn=i(),p(Jt.$$.fragment),Zn=i(),Tt=s("p"),Tt.textContent=pa,Wn=i(),ft=s("p"),ft.textContent=ua,xn=i(),bt=s("p"),bt.innerHTML=ca,$n=i(),Ut=s("p"),Ut.textContent=da,Hn=i(),gt=s("p"),gt.textContent=ya,kn=i(),It=s("p"),It.innerHTML=Ma,Xn=i(),p(jt.$$.fragment),Vn=i(),Gt=s("ul"),Gt.innerHTML=ha,Rn=i(),p(vt.$$.fragment),Yn=i(),Wt=s("p"),this.h()},l(e){const t=Ua("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(l),$t=a(e),Zt=o(e,"P",{}),xt(Zt).forEach(l),Ht=a(e),u(j.$$.fragment,e),kt=a(e),u(G.$$.fragment,e),Xt=a(e),u(v.$$.fragment,e),Vt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jo227l"&&(B.innerHTML=qn),Rt=a(e),u(C.$$.fragment,e),Yt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-tfh72r"&&(Z.innerHTML=En),St=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-18fq2ds"&&(W.textContent=Pn),_t=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-yc80xa"&&(x.innerHTML=Dn),Qt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-dsdcpw"&&($.innerHTML=Kn),zt=a(e),u(H.$$.fragment,e),Ft=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ndetzi"&&(k.innerHTML=On),Lt=a(e),u(X.$$.fragment,e),Nt=a(e),u(V.$$.fragment,e),At=a(e),u(R.$$.fragment,e),qt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-imykz0"&&(Y.textContent=ei),Et=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ck34qj"&&(S.innerHTML=ti),Pt=a(e),u(_.$$.fragment,e),Dt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-i6af0b"&&(Q.textContent=li),Kt=a(e),u(z.$$.fragment,e),Ot=a(e),F=o(e,"PRE",{"data-svelte-h":!0}),r(F)!=="svelte-1d8bxpj"&&(F.textContent=ni),el=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ao31px"&&(L.innerHTML=ii),tl=a(e),u(N.$$.fragment,e),ll=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1srjwy5"&&(A.innerHTML=ai),nl=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-idgyqj"&&(q.innerHTML=si),il=a(e),u(E.$$.fragment,e),al=a(e),u(P.$$.fragment,e),sl=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-17laqx2"&&(D.textContent=oi),ol=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1yo8y7n"&&(K.textContent=ri),rl=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-ekm3wd"&&(O.textContent=pi),pl=a(e),ee=o(e,"OL",{"data-svelte-h":!0}),r(ee)!=="svelte-86ps6"&&(ee.innerHTML=ui),ul=a(e),u(te.$$.fragment,e),cl=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-16t2jma"&&(le.textContent=ci),dl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-oonzuh"&&(ne.innerHTML=di),yl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-mzfgq9"&&(ie.innerHTML=yi),Ml=a(e),u(ae.$$.fragment,e),hl=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-2mbqop"&&(se.innerHTML=Mi),ml=a(e),u(oe.$$.fragment,e),wl=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-qv5xew"&&(re.innerHTML=hi),Jl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1yvhatv"&&(pe.innerHTML=mi),Tl=a(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-smh4uu"&&(T.innerHTML=wi),fl=a(e),u(ue.$$.fragment,e),bl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1pk54pa"&&(ce.textContent=Ji),Ul=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-121gwix"&&(de.innerHTML=Ti),gl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-rn2c0"&&(ye.innerHTML=fi),Il=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1ytrw7h"&&(Me.innerHTML=bi),jl=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-eig0yh"&&(he.innerHTML=Ui),Gl=a(e),u(me.$$.fragment,e),vl=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1nuljlf"&&(we.innerHTML=gi),Bl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1t4rfuz"&&(Je.textContent=Ii),Cl=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-590jvf"&&(Te.innerHTML=ji),Zl=a(e),u(fe.$$.fragment,e),Wl=a(e),u(be.$$.fragment,e),xl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1y7r0u"&&(Ue.innerHTML=Gi),$l=a(e),u(ge.$$.fragment,e),Hl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1qiucww"&&(Ie.textContent=vi),kl=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-l930ml"&&(je.innerHTML=Bi),Xl=a(e),u(Ge.$$.fragment,e),Vl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-su8pwm"&&(ve.textContent=Ci),Rl=a(e),Be=o(e,"OL",{"data-svelte-h":!0}),r(Be)!=="svelte-jraobi"&&(Be.innerHTML=Zi),Yl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-97jp0s"&&(Ce.innerHTML=Wi),Sl=a(e),u(Ze.$$.fragment,e),_l=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ug6zdj"&&(We.textContent=xi),Ql=a(e),u(xe.$$.fragment,e),zl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1f1og5o"&&($e.textContent=$i),Fl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-18it3mz"&&(He.textContent=Hi),Ll=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-7nl279"&&(ke.innerHTML=ki),Nl=a(e),f=o(e,"IMG",{src:!0,width:!0,alt:!0}),Al=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-112s0s1"&&(Xe.innerHTML=Vi),ql=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-t0rmiw"&&(Ve.textContent=Ri),El=a(e),b=o(e,"UL",{});var _n=xt(b);Re=o(_n,"LI",{});var Qn=xt(Re);Bt=o(Qn,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1rhlgw4"&&(Bt.innerHTML=Yi),Fn=a(Qn),u(Ye.$$.fragment,Qn),Qn.forEach(l),Ln=a(_n),Se=o(_n,"LI",{});var zn=xt(Se);Ct=o(zn,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-qc8pgv"&&(Ct.innerHTML=Si),Nn=a(zn),u(_e.$$.fragment,zn),zn.forEach(l),_n.forEach(l),Pl=a(e),u(Qe.$$.fragment,e),Dl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-8s6vsh"&&(ze.textContent=_i),Kl=a(e),Fe=o(e,"UL",{"data-svelte-h":!0}),r(Fe)!=="svelte-1vr4ngb"&&(Fe.innerHTML=Qi),Ol=a(e),u(Le.$$.fragment,e),en=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-7qbjz7"&&(Ne.innerHTML=zi),tn=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1ydqs3k"&&(Ae.innerHTML=Fi),ln=a(e),U=o(e,"IMG",{src:!0,width:!0,alt:!0}),nn=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-853jwi"&&(qe.textContent=Ni),an=a(e),u(Ee.$$.fragment,e),sn=a(e),u(Pe.$$.fragment,e),on=a(e),De=o(e,"PRE",{"data-svelte-h":!0}),r(De)!=="svelte-1f419gx"&&(De.textContent=Ai),rn=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-7n3hrv"&&(Ke.textContent=qi),pn=a(e),Oe=o(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-8wzody"&&(Oe.innerHTML=Ei),un=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-edepwe"&&(et.innerHTML=Pi),cn=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-czm7yu"&&(tt.innerHTML=Di),dn=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1iacfrq"&&(g.innerHTML=Ki),yn=a(e),u(lt.$$.fragment,e),Mn=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-bmr5of"&&(nt.innerHTML=Oi),hn=a(e),u(it.$$.fragment,e),mn=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-6zs2wg"&&(at.innerHTML=ea),wn=a(e),u(st.$$.fragment,e),Jn=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-j019a0"&&(ot.innerHTML=ta),Tn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-byl69c"&&(rt.textContent=la),fn=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-qd0749"&&(pt.innerHTML=na),bn=a(e),u(ut.$$.fragment,e),Un=a(e),ct=o(e,"PRE",{"data-svelte-h":!0}),r(ct)!=="svelte-t58374"&&(ct.textContent=ia),gn=a(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1f1ercz"&&(dt.innerHTML=aa),In=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1kvyfsz"&&(yt.innerHTML=sa),jn=a(e),u(Mt.$$.fragment,e),Gn=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-n67zfm"&&(ht.innerHTML=oa),vn=a(e),u(mt.$$.fragment,e),Bn=a(e),wt=o(e,"PRE",{"data-svelte-h":!0}),r(wt)!=="svelte-p76wiz"&&(wt.textContent=ra),Cn=a(e),u(Jt.$$.fragment,e),Zn=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-s3ahdf"&&(Tt.textContent=pa),Wn=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1c8mrg"&&(ft.textContent=ua),xn=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1ef1i7i"&&(bt.innerHTML=ca),$n=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-v4dtnd"&&(Ut.textContent=da),Hn=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-thjo29"&&(gt.textContent=ya),kn=a(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-3wup7e"&&(It.innerHTML=Ma),Xn=a(e),u(jt.$$.fragment,e),Vn=a(e),Gt=o(e,"UL",{"data-svelte-h":!0}),r(Gt)!=="svelte-pif45z"&&(Gt.innerHTML=ha),Rn=a(e),u(vt.$$.fragment,e),Yn=a(e),Wt=o(e,"P",{}),xt(Wt).forEach(l),this.h()},h(){w(J,"name","hf:doc:metadata"),w(J,"content",va),w(T,"class","tip"),ma(f.src,Xi="https://github.com/dmaniloff/public-screenshots/blob/main/create-new-space.png?raw=true")||w(f,"src",Xi),w(f,"width","350"),w(f,"alt","image description"),ma(U.src,Li="https://github.com/dmaniloff/public-screenshots/blob/main/gradio-as-api.png?raw=true")||w(U,"src",Li),w(U,"width","750"),w(U,"alt","image description"),w(g,"class","tip")},m(e,t){I(document.head,J),n(e,$t,t),n(e,Zt,t),n(e,Ht,t),c(j,e,t),n(e,kt,t),c(G,e,t),n(e,Xt,t),c(v,e,t),n(e,Vt,t),n(e,B,t),n(e,Rt,t),c(C,e,t),n(e,Yt,t),n(e,Z,t),n(e,St,t),n(e,W,t),n(e,_t,t),n(e,x,t),n(e,Qt,t),n(e,$,t),n(e,zt,t),c(H,e,t),n(e,Ft,t),n(e,k,t),n(e,Lt,t),c(X,e,t),n(e,Nt,t),c(V,e,t),n(e,At,t),c(R,e,t),n(e,qt,t),n(e,Y,t),n(e,Et,t),n(e,S,t),n(e,Pt,t),c(_,e,t),n(e,Dt,t),n(e,Q,t),n(e,Kt,t),c(z,e,t),n(e,Ot,t),n(e,F,t),n(e,el,t),n(e,L,t),n(e,tl,t),c(N,e,t),n(e,ll,t),n(e,A,t),n(e,nl,t),n(e,q,t),n(e,il,t),c(E,e,t),n(e,al,t),c(P,e,t),n(e,sl,t),n(e,D,t),n(e,ol,t),n(e,K,t),n(e,rl,t),n(e,O,t),n(e,pl,t),n(e,ee,t),n(e,ul,t),c(te,e,t),n(e,cl,t),n(e,le,t),n(e,dl,t),n(e,ne,t),n(e,yl,t),n(e,ie,t),n(e,Ml,t),c(ae,e,t),n(e,hl,t),n(e,se,t),n(e,ml,t),c(oe,e,t),n(e,wl,t),n(e,re,t),n(e,Jl,t),n(e,pe,t),n(e,Tl,t),n(e,T,t),n(e,fl,t),c(ue,e,t),n(e,bl,t),n(e,ce,t),n(e,Ul,t),n(e,de,t),n(e,gl,t),n(e,ye,t),n(e,Il,t),n(e,Me,t),n(e,jl,t),n(e,he,t),n(e,Gl,t),c(me,e,t),n(e,vl,t),n(e,we,t),n(e,Bl,t),n(e,Je,t),n(e,Cl,t),n(e,Te,t),n(e,Zl,t),c(fe,e,t),n(e,Wl,t),c(be,e,t),n(e,xl,t),n(e,Ue,t),n(e,$l,t),c(ge,e,t),n(e,Hl,t),n(e,Ie,t),n(e,kl,t),n(e,je,t),n(e,Xl,t),c(Ge,e,t),n(e,Vl,t),n(e,ve,t),n(e,Rl,t),n(e,Be,t),n(e,Yl,t),n(e,Ce,t),n(e,Sl,t),c(Ze,e,t),n(e,_l,t),n(e,We,t),n(e,Ql,t),c(xe,e,t),n(e,zl,t),n(e,$e,t),n(e,Fl,t),n(e,He,t),n(e,Ll,t),n(e,ke,t),n(e,Nl,t),n(e,f,t),n(e,Al,t),n(e,Xe,t),n(e,ql,t),n(e,Ve,t),n(e,El,t),n(e,b,t),I(b,Re),I(Re,Bt),I(Re,Fn),c(Ye,Re,null),I(b,Ln),I(b,Se),I(Se,Ct),I(Se,Nn),c(_e,Se,null),n(e,Pl,t),c(Qe,e,t),n(e,Dl,t),n(e,ze,t),n(e,Kl,t),n(e,Fe,t),n(e,Ol,t),c(Le,e,t),n(e,en,t),n(e,Ne,t),n(e,tn,t),n(e,Ae,t),n(e,ln,t),n(e,U,t),n(e,nn,t),n(e,qe,t),n(e,an,t),c(Ee,e,t),n(e,sn,t),c(Pe,e,t),n(e,on,t),n(e,De,t),n(e,rn,t),n(e,Ke,t),n(e,pn,t),n(e,Oe,t),n(e,un,t),n(e,et,t),n(e,cn,t),n(e,tt,t),n(e,dn,t),n(e,g,t),n(e,yn,t),c(lt,e,t),n(e,Mn,t),n(e,nt,t),n(e,hn,t),c(it,e,t),n(e,mn,t),n(e,at,t),n(e,wn,t),c(st,e,t),n(e,Jn,t),n(e,ot,t),n(e,Tn,t),n(e,rt,t),n(e,fn,t),n(e,pt,t),n(e,bn,t),c(ut,e,t),n(e,Un,t),n(e,ct,t),n(e,gn,t),n(e,dt,t),n(e,In,t),n(e,yt,t),n(e,jn,t),c(Mt,e,t),n(e,Gn,t),n(e,ht,t),n(e,vn,t),c(mt,e,t),n(e,Bn,t),n(e,wt,t),n(e,Cn,t),c(Jt,e,t),n(e,Zn,t),n(e,Tt,t),n(e,Wn,t),n(e,ft,t),n(e,xn,t),n(e,bt,t),n(e,$n,t),n(e,Ut,t),n(e,Hn,t),n(e,gt,t),n(e,kn,t),n(e,It,t),n(e,Xn,t),c(jt,e,t),n(e,Vn,t),n(e,Gt,t),n(e,Rn,t),c(vt,e,t),n(e,Yn,t),n(e,Wt,t),Sn=!0},p:Ja,i(e){Sn||(d(j.$$.fragment,e),d(G.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(H.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(fe.$$.fragment,e),d(be.$$.fragment,e),d(ge.$$.fragment,e),d(Ge.$$.fragment,e),d(Ze.$$.fragment,e),d(xe.$$.fragment,e),d(Ye.$$.fragment,e),d(_e.$$.fragment,e),d(Qe.$$.fragment,e),d(Le.$$.fragment,e),d(Ee.$$.fragment,e),d(Pe.$$.fragment,e),d(lt.$$.fragment,e),d(it.$$.fragment,e),d(st.$$.fragment,e),d(ut.$$.fragment,e),d(Mt.$$.fragment,e),d(mt.$$.fragment,e),d(Jt.$$.fragment,e),d(jt.$$.fragment,e),d(vt.$$.fragment,e),Sn=!0)},o(e){y(j.$$.fragment,e),y(G.$$.fragment,e),y(v.$$.fragment,e),y(C.$$.fragment,e),y(H.$$.fragment,e),y(X.$$.fragment,e),y(V.$$.fragment,e),y(R.$$.fragment,e),y(_.$$.fragment,e),y(z.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(ue.$$.fragment,e),y(me.$$.fragment,e),y(fe.$$.fragment,e),y(be.$$.fragment,e),y(ge.$$.fragment,e),y(Ge.$$.fragment,e),y(Ze.$$.fragment,e),y(xe.$$.fragment,e),y(Ye.$$.fragment,e),y(_e.$$.fragment,e),y(Qe.$$.fragment,e),y(Le.$$.fragment,e),y(Ee.$$.fragment,e),y(Pe.$$.fragment,e),y(lt.$$.fragment,e),y(it.$$.fragment,e),y(st.$$.fragment,e),y(ut.$$.fragment,e),y(Mt.$$.fragment,e),y(mt.$$.fragment,e),y(Jt.$$.fragment,e),y(jt.$$.fragment,e),y(vt.$$.fragment,e),Sn=!1},d(e){e&&(l($t),l(Zt),l(Ht),l(kt),l(Xt),l(Vt),l(B),l(Rt),l(Yt),l(Z),l(St),l(W),l(_t),l(x),l(Qt),l($),l(zt),l(Ft),l(k),l(Lt),l(Nt),l(At),l(qt),l(Y),l(Et),l(S),l(Pt),l(Dt),l(Q),l(Kt),l(Ot),l(F),l(el),l(L),l(tl),l(ll),l(A),l(nl),l(q),l(il),l(al),l(sl),l(D),l(ol),l(K),l(rl),l(O),l(pl),l(ee),l(ul),l(cl),l(le),l(dl),l(ne),l(yl),l(ie),l(Ml),l(hl),l(se),l(ml),l(wl),l(re),l(Jl),l(pe),l(Tl),l(T),l(fl),l(bl),l(ce),l(Ul),l(de),l(gl),l(ye),l(Il),l(Me),l(jl),l(he),l(Gl),l(vl),l(we),l(Bl),l(Je),l(Cl),l(Te),l(Zl),l(Wl),l(xl),l(Ue),l($l),l(Hl),l(Ie),l(kl),l(je),l(Xl),l(Vl),l(ve),l(Rl),l(Be),l(Yl),l(Ce),l(Sl),l(_l),l(We),l(Ql),l(zl),l($e),l(Fl),l(He),l(Ll),l(ke),l(Nl),l(f),l(Al),l(Xe),l(ql),l(Ve),l(El),l(b),l(Pl),l(Dl),l(ze),l(Kl),l(Fe),l(Ol),l(en),l(Ne),l(tn),l(Ae),l(ln),l(U),l(nn),l(qe),l(an),l(sn),l(on),l(De),l(rn),l(Ke),l(pn),l(Oe),l(un),l(et),l(cn),l(tt),l(dn),l(g),l(yn),l(Mn),l(nt),l(hn),l(mn),l(at),l(wn),l(Jn),l(ot),l(Tn),l(rt),l(fn),l(pt),l(bn),l(Un),l(ct),l(gn),l(dt),l(In),l(yt),l(jn),l(Gn),l(ht),l(vn),l(Bn),l(wt),l(Cn),l(Zn),l(Tt),l(Wn),l(ft),l(xn),l(bt),l($n),l(Ut),l(Hn),l(gt),l(kn),l(It),l(Xn),l(Vn),l(Gt),l(Rn),l(Yn),l(Wt)),l(J),M(j,e),M(G,e),M(v,e),M(C,e),M(H,e),M(X,e),M(V,e),M(R,e),M(_,e),M(z,e),M(N,e),M(E,e),M(P,e),M(te,e),M(ae,e),M(oe,e),M(ue,e),M(me,e),M(fe,e),M(be,e),M(ge,e),M(Ge,e),M(Ze,e),M(xe,e),M(Ye),M(_e),M(Qe,e),M(Le,e),M(Ee,e),M(Pe,e),M(lt,e),M(it,e),M(st,e),M(ut,e),M(Mt,e),M(mt,e),M(Jt,e),M(jt,e),M(vt,e)}}}const va='{"title":"Creating Demos with Spaces and Gradio","local":"creating-demos-with-spaces-and-gradio","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Your first demo: the basics of Gradio","local":"your-first-demo-the-basics-of-gradio","sections":[],"depth":2},{"title":"Let’s make it interesting: a meeting transcription tool","local":"lets-make-it-interesting-a-meeting-transcription-tool","sections":[{"title":"Audio-to-text","local":"audio-to-text","sections":[],"depth":3},{"title":"Organize & summarize text","local":"organize--summarize-text","sections":[],"depth":3},{"title":"Putting it all together","local":"putting-it-all-together","sections":[],"depth":3}],"depth":2},{"title":"Move your demo into 🤗 Spaces","local":"move-your-demo-into--spaces","sections":[],"depth":2},{"title":"Gradio comes with batteries included 🔋","local":"gradio-comes-with-batteries-included-","sections":[{"title":"Access as an API","local":"access-as-an-api","sections":[],"depth":3},{"title":"Share via public URL","local":"share-via-public-url","sections":[],"depth":3},{"title":"Flagging","local":"flagging","sections":[],"depth":3}],"depth":2},{"title":"Wrap up & Next Steps","local":"wrap-up--next-steps","sections":[],"depth":2},{"title":"⏭️ Further reading","local":"-further-reading","sections":[],"depth":2}],"depth":1}';function Ba(An){return Ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends fa{constructor(J){super(),ba(this,J,Ba,Ga,wa,{})}}export{Ha as component};
