import{s as tt,n as nt,o as at}from"../chunks/scheduler.1f027d5a.js";import{S as pt,i as it,e as p,s as n,c as M,h as ot,a as i,d as l,b as a,f as et,g as c,j as o,k as yl,q as lt,l as Mt,m as t,n as y,t as r,o as m,p as d}from"../chunks/index.5cb6ce42.js";import{C as ct}from"../chunks/CopyLLMTxtMenu.c64d5249.js";import{D as yt,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as j,E as rt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function mt(rl){let u,Xs,_s,Ss,U,Ys,g,Ns,I,zs,b,ml='<em>Authored by: <a href="https://huggingface.co/MoritzLaurer" rel="nofollow">Moritz Laurer</a></em>',Fs,f,dl='Have you ever wanted to create your own machine learning API? That’s what we will do in this recipe with the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">HF Dedicated Inference Endpoints</a>. Inference Endpoints enable you to pick any of the hundreds of thousands of models on the HF Hub, create your own API on a deployment platform you control, and on hardware you choose.',xs,C,hl='<a href="link-to-recipe">Serverless Inference APIs</a> are great for initial testing, but they are limited to a pre-configured selection of popular models and they are rate limited, because the serverless API’s hardware is used by many users at the same time. With a Dedicated Inference Endpoint, you can customize the deployment of your model and the hardware is exclusively dedicated to you.',$s,Z,jl="In this recipe, we will:",Ls,B,ul="<li>Create an Inference Endpoint via a simple UI and send standard HTTP requests to the Endpoint</li> <li>Create and manage different Inference Endpoints programmatically with the <code>huggingface_hub</code> library</li> <li>Cover three use-cases: text generation with an LLM, image generation with Stable Diffusion, and reasoning over images with Idefics2.</li>",Ps,G,Ds,W,Jl='In case you don’t have a HF Account, you can create your account <a href="https://huggingface.co/join" rel="nofollow">here</a>. If you work in a larger team, you can also create a <a href="https://huggingface.co/organizations" rel="nofollow">HF Organization</a> and manage all your models, datasets and Endpoints via this organization. Dedicated Inference Endpoints are a paid service and you will therefore need to add a credit card to the <a href="https://huggingface.co/settings/billing" rel="nofollow">billing settings</a> of your personal HF account, or of your HF organization.',Ks,A,wl='You can then create a user access token <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">here</a>. A token with <code>read</code> or <code>write</code> permissions will work for this guide, but we encourage the use of fine-grained tokens for increased security. For this notebook, you’ll need a fine-grained token with <code>User Permissions &gt; Inference &gt; Make calls to Inference Endpoints &amp; Manage Inference Endpoints</code> and <code>Repository permissions &gt; google/gemma-1.1-2b-it &amp; HuggingFaceM4/idefics2-8b-chatty</code>.',Os,E,se,k,ee,V,le,v,Tl='With this initial setup out of the way, we can now create our first Endpoint. Navigate to <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">https://ui.endpoints.huggingface.co/</a> and click on <code>+ New</code> next to <code>Dedicated Endpoints</code>. You will then see the interface for creating a new Endpoint with the following options (see image below):',te,R,Ul='<li><strong>Model Repository</strong>: Here you can insert the identifier of any model on the HF Hub. For this initial demonstration, we use <a href="https://huggingface.co/google/gemma-1.1-2b-it" rel="nofollow">google/gemma-1.1-2b-it</a>, a small generative LLM (2.5B parameters).</li> <li><strong>Endpoint Name</strong>: The Endpoint Name is automatically generated based on the model identifier, but you are free to change the name. Valid Endpoint names must only contain lower-case characters, numbers or hyphens (”-”) and are between 4 to 32 characters long.</li> <li><strong>Instance Configuration</strong>: Here you can choose from a wide range of CPUs or GPUs from all major cloud platforms. You can also adjust the region, for example if you need to host your Endpoint in the EU.</li> <li><strong>Automatic Scale-to-Zero</strong>: You can configure your Endpoint to scale to zero GPUs/CPUs after a certain amount of time. Scaled-to-zero Endpoints are not billed anymore. Note that restarting the Endpoint requires the model to be re-loaded into memory (and potentially re-downloaded), which can take several minutes for large models.</li> <li><strong>Endpoint Security Level</strong>: The standard security level is <code>Protected</code>, which requires an authorized HF token for accessing the Endpoint. <code>Public</code> Endpoints are accessible by anyone without token authentification. <code>Private</code> Endpoints are only available through an intra-region secured AWS or Azure PrivateLink connection.</li> <li><strong>Advanced configuration</strong>: Here you can select some advanced options like the Docker container type. As Gemma is compatible with <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference (TGI)</a> containers, the system automatically selects TGI as the container type and other good default values.</li>',ne,H,gl="For this guide, select the options in the image below and click on <code>Create Endpoint</code>.",ae,J,Il='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/enterprise-endpoints-creation.png"/>',pe,Q,bl="After roughly one minute, your Endpoint will be created and you will see a page similar to the image below.",ie,_,fl="On the Endpoint’s <code>Overview</code> page, will find the URL for querying the Endpoint, a Playground for testing the model and additional tabs on <code>Analytics</code>, <code>Usage &amp; Cost</code>, <code>Logs</code>and <code>Settings</code>.",oe,w,Cl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/enterprise-endpoint-overviewpage.png"/>',Me,q,ce,X,Zl='When moving into production, you don’t always want to manually start, stop and modify your Endpoints. The <code>huggingface_hub</code> library provides good functionality for managing your Endpoints programmatically. See the docs <a href="https://huggingface.co/docs/huggingface_hub/guides/inference_endpoints" rel="nofollow">here</a> and details on all functions <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_endpoints" rel="nofollow">here</a>. Here are some key functions:',ye,S,re,Y,Bl="You can also create an inference Endpoint programmatically. Let’s recreate the same <code>gemma</code> LLM Endpoint as the one created with the UI.",me,N,de,z,he,F,je,x,Gl='Now let’s query this Endpoint like any other LLM API. First copy the Endpoint URL from the interface (or use <code>endpoint.url</code>) and assign it to <code>API_URL</code> below. We then use the standardised messages format for the text inputs, i.e. a dictionary of user and assistant messages, which you might know from other LLM API services. We then need to apply the chat template to the messages, which LLMs like Gemma, Llama-3 etc. have been trained to expect (see details on in the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">docs</a>). For most recent generative LLMs, it is essential to apply this chat template, otherwise the model’s performance will degrade without throwing an error.',ue,$,Je,L,Wl=`Your text input looks like this, after the chat template has been applied:

<bos><start_of_turn>user
Please write a short poem about open source for me.<end_of_turn>
</end_of_turn></start_of_turn></bos>`,we,P,Te,D,Al=`The output from your API/Endpoint call:

[&#123;'generated_text': "Free to use, free to share,\\nA collaborative code, a community's care.\\n\\nCode transparent, bugs readily found,\\nContributions welcome, stories unbound.\\nOpen source, a gift to all,\\nBuilding the future, one line at a call.\\n\\nSo join the movement, embrace the light,\\nOpen source, shining ever so bright."}]
`,Ue,K,El="That’s it, you’ve made the first request to your Endpoint - your very own API!",ge,O,kl='If you want the Endpoint to handle the chat template automatically and if your LLM runs on a TGI container, you can also use the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">messages API</a> by appending the <code>/v1/chat/completions</code> path to the URL. With the <code>/v1/chat/completions</code> path, the <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">TGI</a> container running on the Endpoint applies the chat template automatically and is fully compatible with OpenAI’s API structure for easier interoperability. See the <a href="https://huggingface.github.io/text-generation-inference/#/Text%20Generation%20Inference/chat_completions" rel="nofollow">TGI Swagger UI</a> for all available parameters. Note that the parameters accepted by the default <code>/</code> path and by the <code>/v1/chat/completions</code> path are slightly different. Here is the slightly modified code for using the messages API:',Ie,ss,be,es,Vl=`The output from your API/Endpoint call with the OpenAI-compatible messages API route:

&#123;'id': '', 'object': 'text_completion', 'created': 1718283608, 'model': '/repository', 'system_fingerprint': '2.0.5-dev0-sha-90184df', 'choices': [&#123;'index': 0, 'message': &#123;'role': 'assistant', 'content': '**Open Source**\\n\\nA license for the mind,\\nTo share, distribute, and bind,\\nIdeas freely given birth,\\nFor the good of all to sort.\\n\\nCode transparent, eyes open wide,\\nA permission for the wise,\\nTo learn, to build, to use at will,\\nA future bright, we help fill.\\n\\nFrom servers vast to candles low,\\nOpen source, a guiding key,\\nFor progress made, knowledge shared,\\nA future brimming with'}, 'logprobs': None, 'finish_reason': 'length'}], 'usage': &#123;'prompt_tokens': 20, 'completion_tokens': 100, 'total_tokens': 120}}
`,fe,ls,Ce,ts,vl='You can also use the <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_client#huggingface_hub.InferenceClient" rel="nofollow"><code>InferenceClient</code></a> to easily send requests to your Endpoint. The client is a convenient utility available in the <code>huggingface_hub</code> Python library that allows you to easily make calls to both <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Dedicated Inference Endpoints</a> and the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>. See the <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_client#inference" rel="nofollow">docs</a> for details.',Ze,ns,Rl="This is the most succinct way of sending requests to your Endpoint:",Be,as,Ge,ps,We,is,Ae,os,Hl="Following the same process, you can create Endpoints for any of the models on the HF Hub. Let’s illustrate some other use-cases.",Ee,Ms,ke,cs,Ql="We can create an image generation Endpoint with almost the exact same code as for the LLM. The only difference is that we do not use the TGI container in this case, as TGI is only designed for LLMs (and vision LMs).",Ve,ys,ve,rs,_l=`Collecting Pillow
  Downloading pillow-10.3.0-cp39-cp39-manylinux_2_28_x86_64.whl (4.5 MB)
\x1B[K     |████████████████████████████████| 4.5 MB 24.7 MB/s eta 0:00:01
\x1B[?25hInstalling collected packages: Pillow
Successfully installed Pillow-10.3.0
`,Re,ms,He,ds,ql=`Does the endpoint already exist? True
Waiting for endpoint to start
Endpoint ready
`,Qe,hs,_e,js,Xl=`PROMPT:  A whimsical illustration of a fashionably dressed llama proudly holding a worn, vintage cookbook, with a warm cup of tea and a few freshly baked treats scattered around, set against a cozy background of rustic wood and blooming flowers.
`,qe,us,Sl="We pause the Endpoint again to stop billing.",Xe,Js,Se,ws,Ye,Ts,Yl='Now let’s create an Endpoint for a vision language model (VLM). VLMs are very similar to LLMs, only that they can take both text and images as input simultaneously. Their output is autoregressively generated text, just like for a standard LLM. VLMs can tackle many tasks from visual question answering to document understanding. For this example, we use <a href="https://huggingface.co/blog/idefics2" rel="nofollow">Idefics2</a>, a powerful 8B parameter VLM.',Ne,Us,Nl="We first need to convert our PIL image generated with Stable Diffusion to a <code>base64</code> encoded string so that we can send it to the model over the network.",ze,gs,Fe,Is,zl='Because VLMs and LLMs are so similar, we can use almost the same messages format and chat template again, only with some additional code for including the image in the prompt. See the <a href="https://huggingface.co/HuggingFaceM4/idefics2-8b" rel="nofollow">Idefics2 model card</a> for specific details on prompt formatting.',xe,bs,$e,T,Fl='<p>For VLMs, an image represents a certain amount of tokens. For Idefics2, for example, one image represents 64 tokens at low resolution and 5*64=320 tokens in high resolution. High resolution is the default in TGI (see <code>do_image_splitting</code> in the <a href="https://huggingface.co/HuggingFaceM4/idefics2-8b-chatty" rel="nofollow">model card</a> for details). This means that one image consumed 320 tokens.</p>',Le,fs,xl='Several VLMs like Idefics2 are also supported by TGI (see <a href="https://huggingface.co/docs/text-generation-inference/supported_models" rel="nofollow">list of supported models</a>), so we use the TGI container again when creating the Endpoint.',Pe,Cs,De,Zs,$l=`Does the endpoint already exist? False
Waiting for endpoint to be created
Endpoint ready
`,Ke,Bs,Oe,Gs,Ll=`In a quaint little café, there lived a llama,
With glasses on his face, he was quite a charm.
He'd sit at the table,
With a book and a mable,
And sip from a cup of warm tea.
`,sl,Ws,el,As,ll,Es,Pl="<li>When creating several Endpoints, you will probably get an error message that your GPU quota has been reached. Don’t hesitate to send a message to the email address in the error message and we will most likely increase your GPU quota.</li> <li>What is the difference between <code>paused</code> and <code>scaled-to-zero</code> Endpoints? <code>scaled-to-zero</code> Endpoints can be flexibly woken up and scaled up by user requests, while <code>paused</code> Endpoints need to be unpaused by the creator of the Endpoint. Moreover, <code>scaled-to-zero</code> Endpoints count towards your GPU quota (with the maximum possible replica it could be scaled up to), while <code>paused</code> Endpoints do not. A simple way of freeing up your GPU quota is therefore to pause some Endpoints.</li>",tl,ks,nl,Vs,Dl="That’s it, you’ve created three different Endpoints (your own APIs!) for text-to-text, text-to-image, and image-to-text generation and the same is possible for many other models and tasks.",al,vs,Kl='We encourage you to read the Dedicated Inference Endpoint <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">docs</a> to learn more. If you are using generative LLMs and VLMs, we also recommend reading the TGI <a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">docs</a>, as the most popular LLMs/VLMs are also supported by TGI, which makes your Endpoints significantly more efficient.',pl,Rs,Ol='You can, for example, use <strong>JSON-mode or function calling</strong> with open-source models via <a href="https://huggingface.co/docs/text-generation-inference/basic_tutorials/using_guidance" rel="nofollow">TGI Guidance</a> (see also this <a href="https://huggingface.co/learn/cookbook/structured_generation" rel="nofollow">recipe</a> for an example for RAG with structured generation).',il,Hs,st="When moving your Endpoints into production, you will want to make several additional improvements to make your setup more efficient. When using TGI, you should send batches of requests to the Endpoint with asynchronous function calls to fully utilize the Endpoint’s hardware and you can adapt several container parameters to optimize latency and throughput for your use-case. We will cover these optimizations in another recipe.",ol,Qs,Ml,qs,cl;return U=new yt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/enterprise_dedicated_endpoints.ipynb"}]}}),g=new ct({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new j({props:{title:"Inference Endpoints (dedicated)",local:"inference-endpoints-dedicated",headingTag:"h1"}}),G=new j({props:{title:"Install and login",local:"install-and-login",headingTag:"h2"}}),E=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWJ+JTNEMC4yMy4zJTBBIXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnN+JTNENC40MS4y",highlighted:`!pip install huggingface_hub~=<span class="hljs-number">0.23</span><span class="hljs-number">.3</span>
!pip install transformers~=<span class="hljs-number">4.41</span><span class="hljs-number">.2</span>`,wrap:!1}}),k=new h({props:{code:"JTIzJTIwTG9naW4lMjB0byUyMHRoZSUyMEhGJTIwSHViLiUyMFdlJTIwcmVjb21tZW5kJTIwdXNpbmclMjB0aGlzJTIwbG9naW4lMjBtZXRob2QlMjAlMEElMjMlMjB0byUyMGF2b2lkJTIwdGhlJTIwbmVlZCUyMGZvciUyMGV4cGxpY2l0bHklMjBzdG9yaW5nJTIweW91ciUyMEhGJTIwdG9rZW4lMjBpbiUyMHZhcmlhYmxlcyUyMCUwQWltcG9ydCUyMGh1Z2dpbmdmYWNlX2h1YiUwQWh1Z2dpbmdmYWNlX2h1Yi5pbnRlcnByZXRlcl9sb2dpbigp",highlighted:`<span class="hljs-comment"># Login to the HF Hub. We recommend using this login method </span>
<span class="hljs-comment"># to avoid the need for explicitly storing your HF token in variables </span>
<span class="hljs-keyword">import</span> huggingface_hub
huggingface_hub.interpreter_login()`,wrap:!1}}),V=new j({props:{title:"Creating your first Endpoint",local:"creating-your-first-endpoint",headingTag:"h2"}}),q=new j({props:{title:"Creating and managing Endpoints programmatically",local:"creating-and-managing-endpoints-programmatically",headingTag:"h3"}}),S=new h({props:{code:"JTIzJTIwbGlzdCUyMGFsbCUyMHlvdXIlMjBpbmZlcmVuY2UlMjBlbmRwb2ludHMlMEFodWdnaW5nZmFjZV9odWIubGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKCklMEElMEElMjMlMjBnZXQlMjBhbiUyMGV4aXN0aW5nJTIwZW5kcG9pbnQlMjBhbmQlMjBjaGVjayUyMGl0J3MlMjBzdGF0dXMlMEFlbmRwb2ludCUyMCUzRCUyMGh1Z2dpbmdmYWNlX2h1Yi5nZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJnZW1tYS0xLTEtMmItaXQteWNpJTIyJTJDJTIwJTIwJTIzJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwZW5kcG9pbnQlMjAlMEElMjAlMjAlMjAlMjBuYW1lc3BhY2UlM0QlMjJNb3JpdHpMYXVyZXIlMjIlMjAlMjAlMjMlMjB5b3VyJTIwdXNlciUyMG5hbWUlMjBvciUyMG9yZ2FuaXphdGlvbiUyMG5hbWUlMEEpJTBBcHJpbnQoZW5kcG9pbnQpJTBBJTBBJTIzJTIwUGF1c2UlMjBlbmRwb2ludCUyMHRvJTIwc3RvcCUyMGJpbGxpbmclMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBJTIzJTIwUmVzdW1lJTIwYW5kJTIwd2FpdCUyMHVudGlsJTIwdGhlJTIwZW5kcG9pbnQlMjBpcyUyMHJlYWR5JTBBJTIzZW5kcG9pbnQucmVzdW1lKCklMEElMjNlbmRwb2ludC53YWl0KCklMEElMEElMjMlMjBVcGRhdGUlMjB0aGUlMjBlbmRwb2ludCUyMHRvJTIwYSUyMGRpZmZlcmVudCUyMEdQVSUwQSUyMyUyMFlvdSUyMGNhbiUyMGZpbmQlMjB0aGUlMjBjb3JyZWN0JTIwYXJndW1lbnRzJTIwZm9yJTIwZGlmZmVyZW50JTIwaGFyZHdhcmUlMjB0eXBlcyUyMGluJTIwdGhpcyUyMHRhYmxlJTNBJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZpbmZlcmVuY2UtZW5kcG9pbnRzJTJGcHJpY2luZyUyM2dwdS1pbnN0YW5jZXMlMEElMjNlbmRwb2ludC51cGRhdGUoJTBBJTIzJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMngxJTIyJTJDJTBBJTIzJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm52aWRpYS1hMTAwJTIyJTJDJTIwJTIwJTIzJTIwbnZpZGlhLWExMGclMEElMjMp",highlighted:`<span class="hljs-comment"># list all your inference endpoints</span>
huggingface_hub.list_inference_endpoints()

<span class="hljs-comment"># get an existing endpoint and check it&#x27;s status</span>
endpoint = huggingface_hub.get_inference_endpoint(
    name=<span class="hljs-string">&quot;gemma-1-1-2b-it-yci&quot;</span>,  <span class="hljs-comment"># the name of the endpoint </span>
    namespace=<span class="hljs-string">&quot;MoritzLaurer&quot;</span>  <span class="hljs-comment"># your user name or organization name</span>
)
<span class="hljs-built_in">print</span>(endpoint)

<span class="hljs-comment"># Pause endpoint to stop billing</span>
endpoint.pause()

<span class="hljs-comment"># Resume and wait until the endpoint is ready</span>
<span class="hljs-comment">#endpoint.resume()</span>
<span class="hljs-comment">#endpoint.wait()</span>

<span class="hljs-comment"># Update the endpoint to a different GPU</span>
<span class="hljs-comment"># You can find the correct arguments for different hardware types in this table: https://huggingface.co/docs/inference-endpoints/pricing#gpu-instances</span>
<span class="hljs-comment">#endpoint.update(</span>
<span class="hljs-comment">#    instance_size=&quot;x1&quot;,</span>
<span class="hljs-comment">#    instance_type=&quot;nvidia-a100&quot;,  # nvidia-a10g</span>
<span class="hljs-comment">#)</span>`,wrap:!1}}),N=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint


model_id = <span class="hljs-string">&quot;google/gemma-1.1-2b-it&quot;</span>
endpoint_name = <span class="hljs-string">&quot;gemma-1-1-2b-it-001&quot;</span>  <span class="hljs-comment"># Valid Endpoint names must only contain lower-case characters, numbers or hyphens (&quot;-&quot;) and are between 4 to 32 characters long.</span>
namespace = <span class="hljs-string">&quot;MoritzLaurer&quot;</span>  <span class="hljs-comment"># your user or organization name</span>


<span class="hljs-comment"># check if endpoint with this name already exists from previous tests</span>
available_endpoints_names = [endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> huggingface_hub.list_inference_endpoints()]
<span class="hljs-keyword">if</span> endpoint_name <span class="hljs-keyword">in</span> available_endpoints_names:
    endpoint_exists = <span class="hljs-literal">True</span>
<span class="hljs-keyword">else</span>: 
    endpoint_exists = <span class="hljs-literal">False</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Does the endpoint already exist?&quot;</span>, endpoint_exists)
    

<span class="hljs-comment"># create new endpoint</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint_exists:
    endpoint = create_inference_endpoint(
        endpoint_name,
        repository=model_id,
        namespace=namespace,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        task=<span class="hljs-string">&quot;text-generation&quot;</span>,
        <span class="hljs-comment"># see the available hardware options here: https://huggingface.co/docs/inference-endpoints/pricing#pricing</span>
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        vendor=<span class="hljs-string">&quot;aws&quot;</span>,
        region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
        instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
        instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
        min_replica=<span class="hljs-number">0</span>,
        max_replica=<span class="hljs-number">1</span>,
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
        <span class="hljs-comment"># since the LLM is compatible with TGI, we specify that we want to use the latest TGI image</span>
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:latest&quot;</span>,
        },
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to be created&quot;</span>)
    endpoint.wait()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)

<span class="hljs-comment"># if endpoint with this name already exists, get and resume existing endpoint</span>
<span class="hljs-keyword">else</span>:
    endpoint = huggingface_hub.get_inference_endpoint(name=endpoint_name, namespace=namespace)
    <span class="hljs-keyword">if</span> endpoint.status <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;paused&quot;</span>, <span class="hljs-string">&quot;scaledToZero&quot;</span>]:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Resuming endpoint&quot;</span>)
        endpoint.resume()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to start&quot;</span>)
    endpoint.wait()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)`,wrap:!1}}),z=new h({props:{code:"JTIzJTIwYWNjZXNzJTIwdGhlJTIwZW5kcG9pbnQlMjB1cmwlMjBmb3IlMjBBUEklMjBjYWxscyUwQXByaW50KGVuZHBvaW50LnVybCk=",highlighted:`<span class="hljs-comment"># access the endpoint url for API calls</span>
<span class="hljs-built_in">print</span>(endpoint.url)`,wrap:!1}}),F=new j({props:{title:"Querying your Endpoint",local:"querying-your-endpoint",headingTag:"h2"}}),$=new h({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMHBhc3RlJTIweW91ciUyMGVuZHBvaW50JTIwVVJMJTIwaGVyZSUyMG9yJTIwcmV1c2UlMjBlbmRwb2ludC51cmwlMjBpZiUyMHlvdSUyMGNyZWF0ZWQlMjB0aGUlMjBlbmRwb2ludCUyMHByb2dyYW1tYXRpY2FsbHklMEFBUElfVVJMJTIwJTNEJTIwZW5kcG9pbnQudXJsJTIwJTIwJTIzJTIwb3IlMjBwYXN0ZSUyMGxpbmslMjBsaWtlJTIwJTIyaHR0cHMlM0ElMkYlMkZkejA3ODg0YTUzcWpxYjk4LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyJTIwJTBBSEVBREVSUyUyMCUzRCUyMCU3QiUyMkF1dGhvcml6YXRpb24lMjIlM0ElMjBmJTIyQmVhcmVyJTIwJTdCaHVnZ2luZ2ZhY2VfaHViLmdldF90b2tlbigpJTdEJTIyJTdEJTBBJTBBJTIzJTIwZnVuY3Rpb24lMjBmb3IlMjBzdGFuZGFyZCUyMGh0dHAlMjByZXF1ZXN0cyUwQWRlZiUyMHF1ZXJ5KHBheWxvYWQlM0ROb25lJTJDJTIwYXBpX3VybCUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5wb3N0KGFwaV91cmwlMkMlMjBoZWFkZXJzJTNESEVBREVSUyUyQyUyMGpzb24lM0RwYXlsb2FkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmpzb24oKSUwQSUwQSUwQSUyMyUyMGRlZmluZSUyMGNvbnZlcnNhdGlvbiUyMGlucHV0JTIwaW4lMjBtZXNzYWdlcyUyMGZvcm1hdCUwQSUyMyUyMHlvdSUyMGNhbiUyMGFsc28lMjBwcm92aWRlJTIwbXVsdGlwbGUlMjB0dXJucyUyMGJldHdlZW4lMjB1c2VyJTIwYW5kJTIwYXNzaXN0YW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJQbGVhc2UlMjB3cml0ZSUyMGElMjBzaG9ydCUyMHBvZW0lMjBhYm91dCUyMG9wZW4lMjBzb3VyY2UlMjBmb3IlMjBtZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjMlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkklMjBhbSUyMG5vdCUyMGluJTIwdGhlJTIwbW9vZC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjMlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjBwbGVhc2UlMjBkbyUyMHRoaXMlMjBmb3IlMjBtZSUzRiUyMiU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTIwZm9yJTIwdGhlJTIwcmVzcGVjdGl2ZSUyMG1vZGVsJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZnZW1tYS0xLjEtMmItaXQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMjAlMEFtZXNzYWdlc193aXRoX3RlbXBsYXRlJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUwQXByaW50KCUyMllvdXIlMjB0ZXh0JTIwaW5wdXQlMjBsb29rcyUyMGxpa2UlMjB0aGlzJTJDJTIwYWZ0ZXIlMjB0aGUlMjBjaGF0JTIwdGVtcGxhdGUlMjBoYXMlMjBiZWVuJTIwYXBwbGllZCUzQSU1Q24lMjIpJTBBcHJpbnQobWVzc2FnZXNfd2l0aF90ZW1wbGF0ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># paste your endpoint URL here or reuse endpoint.url if you created the endpoint programmatically</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>API_URL = endpoint.url  <span class="hljs-comment"># or paste link like &quot;https://dz07884a53qjqb98.us-east-1.aws.endpoints.huggingface.cloud&quot; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HEADERS = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{huggingface_hub.get_token()}</span>&quot;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># function for standard http requests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">payload=<span class="hljs-literal">None</span>, api_url=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    response = requests.post(api_url, headers=HEADERS, json=payload)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> response.json()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define conversation input in messages format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can also provide multiple turns between user and assistant</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Please write a short poem about open source for me.&quot;</span>},
<span class="hljs-meta">... </span>    <span class="hljs-comment">#{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;I am not in the mood.&quot;},</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment">#{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Can you please do this for me?&quot;},</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the chat template for the respective model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/gemma-1.1-2b-it&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id) 
<span class="hljs-meta">&gt;&gt;&gt; </span>messages_with_template = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Your text input looks like this, after the chat template has been applied:\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(messages_with_template)`,wrap:!1}}),P=new h({props:{code:"JTIzJTIwc2VuZCUyMHN0YW5kYXJkJTIwaHR0cCUyMHJlcXVlc3QlMjB0byUyMGVuZHBvaW50JTBBb3V0cHV0JTIwJTNEJTIwcXVlcnkoJTBBJTIwJTIwJTIwJTIwcGF5bG9hZCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMG1lc3NhZ2VzX3dpdGhfdGVtcGxhdGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjIlMkMlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwMCUyQyUyMCUyMnNlZWQlMjIlM0ElMjA0MiUyQyUyMCUyMnJldHVybl9mdWxsX3RleHQlMjIlM0ElMjBGYWxzZSU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBBUElfVVJMJTBBKSUwQSUwQXByaW50KCUyMlRoZSUyMG91dHB1dCUyMGZyb20lMjB5b3VyJTIwQVBJJTJGRW5kcG9pbnQlMjBjYWxsJTNBJTVDbiUyMiklMEFwcmludChvdXRwdXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># send standard http request to endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = query(
<span class="hljs-meta">... </span>    payload = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;inputs&quot;</span>: messages_with_template,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.2</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">100</span>, <span class="hljs-string">&quot;seed&quot;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&quot;return_full_text&quot;</span>: <span class="hljs-literal">False</span>},
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    api_url = API_URL
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The output from your API/Endpoint call:\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ss=new h({props:{code:"QVBJX1VSTF9DSEFUJTIwJTNEJTIwQVBJX1VSTCUyMCUyQiUyMCUyMiUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIyJTBBJTBBb3V0cHV0JTIwJTNEJTIwcXVlcnkoJTBBJTIwJTIwJTIwJTIwcGF5bG9hZCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbCUyMiUzQSUyMCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuMiUyQyUyMCUyMm1heF90b2tlbnMlMjIlM0ElMjAxMDAlMkMlMjAlMjJzZWVkJTIyJTNBJTIwNDIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBhcGlfdXJsJTIwJTNEJTIwQVBJX1VSTF9DSEFUJTBBKSUwQSUwQXByaW50KCUyMlRoZSUyMG91dHB1dCUyMGZyb20lMjB5b3VyJTIwQVBJJTJGRW5kcG9pbnQlMjBjYWxsJTIwd2l0aCUyMHRoZSUyME9wZW5BSS1jb21wYXRpYmxlJTIwbWVzc2FnZXMlMjBBUEklMjByb3V0ZSUzQSU1Q24lMjIpJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>API_URL_CHAT = API_URL + <span class="hljs-string">&quot;/v1/chat/completions&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = query(
<span class="hljs-meta">... </span>    payload = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;messages&quot;</span>: messages,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.2</span>, <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">100</span>, <span class="hljs-string">&quot;seed&quot;</span>: <span class="hljs-number">42</span>},
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    api_url = API_URL_CHAT
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The output from your API/Endpoint call with the OpenAI-compatible messages API route:\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ls=new j({props:{title:"Simplified Endpoint usage with the InferenceClient",local:"simplified-endpoint-usage-with-the-inferenceclient",headingTag:"h3"}}),as=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUyMCUyMCUyMyUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMGlzJTIwYXBwbGllZCUyMGF1dG9tYXRpY2FsbHklMkMlMjBpZiUyMHlvdXIlMjBlbmRwb2ludCUyMHVzZXMlMjBhJTIwVEdJJTIwY29udGFpbmVyJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RBUElfVVJMJTJDJTIwJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMjBtYXhfdG9rZW5zJTNEMTAwJTJDJTIwc2VlZCUzRDQyJTJDJTBBKSUwQSUwQXByaW50KCUyMlRoZSUyMG91dHB1dCUyMGZyb20lMjB5b3VyJTIwQVBJJTJGRW5kcG9pbnQlMjBjYWxsJTIwd2l0aCUyMHRoZSUyMEluZmVyZW5jZUNsaWVudCUzQSU1Q24lMjIpJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient()

output = client.chat_completion(
    messages,  <span class="hljs-comment"># the chat template is applied automatically, if your endpoint uses a TGI container</span>
    model=API_URL, 
    temperature=<span class="hljs-number">0.2</span>, max_tokens=<span class="hljs-number">100</span>, seed=<span class="hljs-number">42</span>,
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The output from your API/Endpoint call with the InferenceClient:\\n&quot;</span>)
<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ps=new h({props:{code:"JTIzJTIwcGF1c2UlMjB0aGUlMjBlbmRwb2ludCUyMHRvJTIwc3RvcCUyMGJpbGxpbmclMEElMjNlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-comment"># pause the endpoint to stop billing</span>
<span class="hljs-comment">#endpoint.pause()</span>`,wrap:!1}}),is=new j({props:{title:"Creating Endpoints for a wide variety of models",local:"creating-endpoints-for-a-wide-variety-of-models",headingTag:"h2"}}),Ms=new j({props:{title:"Image generation with Stable Diffusion",local:"image-generation-with-stable-diffusion",headingTag:"h3"}}),ys=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBQaWxsb3clMjAlMjAlMjMlMjBmb3IlMjBpbWFnZSUyMHByb2Nlc3Npbmc=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!pip install Pillow  <span class="hljs-comment"># for image processing</span>',wrap:!1}}),ms=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_name = <span class="hljs-string">&quot;stable-diffusion-xl-base-1-0-001&quot;</span>  <span class="hljs-comment"># Valid Endpoint names must only contain lower-case characters, numbers or hyphens (&quot;-&quot;) and are between 4 to 32 characters long.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = <span class="hljs-string">&quot;MoritzLaurer&quot;</span>  <span class="hljs-comment"># your user or organization name</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task = <span class="hljs-string">&quot;text-to-image&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># check if endpoint with this name already exists from previous tests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>available_endpoints_names = [endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> huggingface_hub.list_inference_endpoints()]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> endpoint_name <span class="hljs-keyword">in</span> available_endpoints_names:
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>: 
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Does the endpoint already exist?&quot;</span>, endpoint_exists)
    

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create new endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint_exists:
<span class="hljs-meta">... </span>    endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>        endpoint_name,
<span class="hljs-meta">... </span>        repository=model_id,
<span class="hljs-meta">... </span>        namespace=namespace,
<span class="hljs-meta">... </span>        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>        task=task,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># see the available hardware options here: https://huggingface.co/docs/inference-endpoints/pricing#pricing</span>
<span class="hljs-meta">... </span>        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>        vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>        region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>        instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>        instance_type=<span class="hljs-string">&quot;nvidia-a100&quot;</span>,
<span class="hljs-meta">... </span>        min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>        max_replica=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to be created&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># if endpoint with this name already exists, get existing endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    endpoint = huggingface_hub.get_inference_endpoint(name=endpoint_name, namespace=namespace)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> endpoint.status <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;paused&quot;</span>, <span class="hljs-string">&quot;scaledToZero&quot;</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Resuming endpoint&quot;</span>)
<span class="hljs-meta">... </span>        endpoint.resume()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to start&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)`,wrap:!1}}),hs=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdoaW1zaWNhbCUyMGlsbHVzdHJhdGlvbiUyMG9mJTIwYSUyMGZhc2hpb25hYmx5JTIwZHJlc3NlZCUyMGxsYW1hJTIwcHJvdWRseSUyMGhvbGRpbmclMjBhJTIwd29ybiUyQyUyMHZpbnRhZ2UlMjBjb29rYm9vayUyQyUyMHdpdGglMjBhJTIwd2FybSUyMGN1cCUyMG9mJTIwdGVhJTIwYW5kJTIwYSUyMGZldyUyMGZyZXNobHklMjBiYWtlZCUyMHRyZWF0cyUyMHNjYXR0ZXJlZCUyMGFyb3VuZCUyQyUyMHNldCUyMGFnYWluc3QlMjBhJTIwY296eSUyMGJhY2tncm91bmQlMjBvZiUyMHJ1c3RpYyUyMHdvb2QlMjBhbmQlMjBibG9vbWluZyUyMGZsb3dlcnMuJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRGVuZHBvaW50LnVybCUyQyUyMCUyMCUyMyUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUwQSklMEElMEFwcmludCglMjJQUk9NUFQlM0ElMjAlMjIlMkMlMjBwcm9tcHQpJTBBZGlzcGxheShpbWFnZS5yZXNpemUoKGltYWdlLndpZHRoJTIwJTJGJTJGJTIwMiUyQyUyMGltYWdlLmhlaWdodCUyMCUyRiUyRiUyMDIpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A whimsical illustration of a fashionably dressed llama proudly holding a worn, vintage cookbook, with a warm cup of tea and a few freshly baked treats scattered around, set against a cozy background of rustic wood and blooming flowers.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    model=endpoint.url,  <span class="hljs-comment">#&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;,</span>
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;PROMPT: &quot;</span>, prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>display(image.resize((image.width // <span class="hljs-number">2</span>, image.height // <span class="hljs-number">2</span>)))`,wrap:!1}}),Js=new h({props:{code:"ZW5kcG9pbnQucGF1c2UoKQ==",highlighted:"endpoint.pause()",wrap:!1}}),ws=new j({props:{title:"Vision Language Models: Reasoning over text and images",local:"vision-language-models-reasoning-over-text-and-images",headingTag:"h3"}}),gs=new h({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQSUwQSUwQWRlZiUyMHBpbF9pbWFnZV90b19iYXNlNjQoaW1hZ2UpJTNBJTBBJTIwJTIwJTIwJTIwYnVmZmVyZWQlMjAlM0QlMjBCeXRlc0lPKCklMEElMjAlMjAlMjAlMjBpbWFnZS5zYXZlKGJ1ZmZlcmVkJTJDJTIwZm9ybWF0JTNEJTIySlBFRyUyMiklMEElMjAlMjAlMjAlMjBpbWdfc3RyJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZShidWZmZXJlZC5nZXR2YWx1ZSgpKS5kZWNvZGUoJTIydXRmLTglMjIpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1nX3N0ciUwQSUwQSUwQWltYWdlX2I2NCUyMCUzRCUyMHBpbF9pbWFnZV90b19iYXNlNjQoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO


<span class="hljs-keyword">def</span> <span class="hljs-title function_">pil_image_to_base64</span>(<span class="hljs-params">image</span>):
    buffered = BytesIO()
    image.save(buffered, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;JPEG&quot;</span>)
    img_str = base64.b64encode(buffered.getvalue()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    <span class="hljs-keyword">return</span> img_str


image_b64 = pil_image_to_base64(image)`,wrap:!1}}),bs=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-comment"># load the processor</span>
model_id_vlm = <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b-chatty&quot;</span>
processor = AutoProcessor.from_pretrained(model_id_vlm)

<span class="hljs-comment"># define the user messages</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},  <span class="hljs-comment"># the image is placed here in the prompt. You can add multiple images throughout the conversation.</span>
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Write a short limerick about this image.&quot;</span>},
        ],
    },
]

<span class="hljs-comment"># apply the chat template to the messages</span>
prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># the chat template places a special &quot;&lt;image&gt;&quot; token at the position where the image should go</span>
<span class="hljs-comment"># here we replace the &quot;&lt;image&gt;&quot; token with the base64 encoded image string in the prompt</span>
<span class="hljs-comment"># to be able to send the image via an API request</span>
image_input = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{image_b64}</span>&quot;</span>
image_input = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image_input}</span>)&quot;</span>
prompt = prompt.replace(<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, image_input)`,wrap:!1}}),Cs=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_name = <span class="hljs-string">&quot;idefics2-8b-chatty-001&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = <span class="hljs-string">&quot;MoritzLaurer&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task = <span class="hljs-string">&quot;text-generation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># check if endpoint with this name already exists from previous tests</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>available_endpoints_names = [endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> huggingface_hub.list_inference_endpoints()]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> endpoint_name <span class="hljs-keyword">in</span> available_endpoints_names:
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>: 
<span class="hljs-meta">... </span>    endpoint_exists = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Does the endpoint already exist?&quot;</span>, endpoint_exists)
    

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> endpoint_exists:
<span class="hljs-meta">... </span>    endpoint = huggingface_hub.get_inference_endpoint(name=endpoint_name, namespace=namespace)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> endpoint.status <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;paused&quot;</span>, <span class="hljs-string">&quot;scaledToZero&quot;</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Resuming endpoint&quot;</span>)
<span class="hljs-meta">... </span>        endpoint.resume()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to start&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>        endpoint_name,
<span class="hljs-meta">... </span>        repository=model_id_vlm,
<span class="hljs-meta">... </span>        namespace=namespace,
<span class="hljs-meta">... </span>        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>        task=task,
<span class="hljs-meta">... </span>        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>        vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>        region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>        instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>        instance_type=<span class="hljs-string">&quot;nvidia-a100&quot;</span>,
<span class="hljs-meta">... </span>        min_replica=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>        max_replica=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        custom_image={
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1536&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:latest&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for endpoint to be created&quot;</span>)
<span class="hljs-meta">... </span>    endpoint.wait()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint ready&quot;</span>)`,wrap:!1}}),Bs=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBtb2RlbCUzRG1vZGVsX2lkX3ZsbSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTIwc2VlZCUzRDQyJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.text_generation(
<span class="hljs-meta">... </span>    prompt, model=model_id_vlm, max_new_tokens=<span class="hljs-number">200</span>, seed=<span class="hljs-number">42</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output)`,wrap:!1}}),Ws=new h({props:{code:"ZW5kcG9pbnQucGF1c2UoKQ==",highlighted:"endpoint.pause()",wrap:!1}}),As=new j({props:{title:"Additional information",local:"additional-information",headingTag:"h2"}}),ks=new j({props:{title:"Conclusion and next steps",local:"conclusion-and-next-steps",headingTag:"h2"}}),Qs=new rt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_dedicated_endpoints.md"}}),{c(){u=p("meta"),Xs=n(),_s=p("p"),Ss=n(),M(U.$$.fragment),Ys=n(),M(g.$$.fragment),Ns=n(),M(I.$$.fragment),zs=n(),b=p("p"),b.innerHTML=ml,Fs=n(),f=p("p"),f.innerHTML=dl,xs=n(),C=p("p"),C.innerHTML=hl,$s=n(),Z=p("p"),Z.textContent=jl,Ls=n(),B=p("ul"),B.innerHTML=ul,Ps=n(),M(G.$$.fragment),Ds=n(),W=p("p"),W.innerHTML=Jl,Ks=n(),A=p("p"),A.innerHTML=wl,Os=n(),M(E.$$.fragment),se=n(),M(k.$$.fragment),ee=n(),M(V.$$.fragment),le=n(),v=p("p"),v.innerHTML=Tl,te=n(),R=p("ul"),R.innerHTML=Ul,ne=n(),H=p("p"),H.innerHTML=gl,ae=n(),J=p("div"),J.innerHTML=Il,pe=n(),Q=p("p"),Q.textContent=bl,ie=n(),_=p("p"),_.innerHTML=fl,oe=n(),w=p("div"),w.innerHTML=Cl,Me=n(),M(q.$$.fragment),ce=n(),X=p("p"),X.innerHTML=Zl,ye=n(),M(S.$$.fragment),re=n(),Y=p("p"),Y.innerHTML=Bl,me=n(),M(N.$$.fragment),de=n(),M(z.$$.fragment),he=n(),M(F.$$.fragment),je=n(),x=p("p"),x.innerHTML=Gl,ue=n(),M($.$$.fragment),Je=n(),L=p("pre"),L.innerHTML=Wl,we=n(),M(P.$$.fragment),Te=n(),D=p("pre"),D.textContent=Al,Ue=n(),K=p("p"),K.textContent=El,ge=n(),O=p("p"),O.innerHTML=kl,Ie=n(),M(ss.$$.fragment),be=n(),es=p("pre"),es.textContent=Vl,fe=n(),M(ls.$$.fragment),Ce=n(),ts=p("p"),ts.innerHTML=vl,Ze=n(),ns=p("p"),ns.textContent=Rl,Be=n(),M(as.$$.fragment),Ge=n(),M(ps.$$.fragment),We=n(),M(is.$$.fragment),Ae=n(),os=p("p"),os.textContent=Hl,Ee=n(),M(Ms.$$.fragment),ke=n(),cs=p("p"),cs.textContent=Ql,Ve=n(),M(ys.$$.fragment),ve=n(),rs=p("pre"),rs.textContent=_l,Re=n(),M(ms.$$.fragment),He=n(),ds=p("pre"),ds.textContent=ql,Qe=n(),M(hs.$$.fragment),_e=n(),js=p("pre"),js.textContent=Xl,qe=n(),us=p("p"),us.textContent=Sl,Xe=n(),M(Js.$$.fragment),Se=n(),M(ws.$$.fragment),Ye=n(),Ts=p("p"),Ts.innerHTML=Yl,Ne=n(),Us=p("p"),Us.innerHTML=Nl,ze=n(),M(gs.$$.fragment),Fe=n(),Is=p("p"),Is.innerHTML=zl,xe=n(),M(bs.$$.fragment),$e=n(),T=p("blockquote"),T.innerHTML=Fl,Le=n(),fs=p("p"),fs.innerHTML=xl,Pe=n(),M(Cs.$$.fragment),De=n(),Zs=p("pre"),Zs.textContent=$l,Ke=n(),M(Bs.$$.fragment),Oe=n(),Gs=p("pre"),Gs.textContent=Ll,sl=n(),M(Ws.$$.fragment),el=n(),M(As.$$.fragment),ll=n(),Es=p("ul"),Es.innerHTML=Pl,tl=n(),M(ks.$$.fragment),nl=n(),Vs=p("p"),Vs.textContent=Dl,al=n(),vs=p("p"),vs.innerHTML=Kl,pl=n(),Rs=p("p"),Rs.innerHTML=Ol,il=n(),Hs=p("p"),Hs.textContent=st,ol=n(),M(Qs.$$.fragment),Ml=n(),qs=p("p"),this.h()},l(s){const e=ot("svelte-u9bgzb",document.head);u=i(e,"META",{name:!0,content:!0}),e.forEach(l),Xs=a(s),_s=i(s,"P",{}),et(_s).forEach(l),Ss=a(s),c(U.$$.fragment,s),Ys=a(s),c(g.$$.fragment,s),Ns=a(s),c(I.$$.fragment,s),zs=a(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-phy2er"&&(b.innerHTML=ml),Fs=a(s),f=i(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-31gxb1"&&(f.innerHTML=dl),xs=a(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-ea64o2"&&(C.innerHTML=hl),$s=a(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-cjypfx"&&(Z.textContent=jl),Ls=a(s),B=i(s,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1y2rksz"&&(B.innerHTML=ul),Ps=a(s),c(G.$$.fragment,s),Ds=a(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-mgw3ja"&&(W.innerHTML=Jl),Ks=a(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-qnpmsm"&&(A.innerHTML=wl),Os=a(s),c(E.$$.fragment,s),se=a(s),c(k.$$.fragment,s),ee=a(s),c(V.$$.fragment,s),le=a(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1jdmkft"&&(v.innerHTML=Tl),te=a(s),R=i(s,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1fztman"&&(R.innerHTML=Ul),ne=a(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-14vawf4"&&(H.innerHTML=gl),ae=a(s),J=i(s,"DIV",{style:!0,"data-svelte-h":!0}),o(J)!=="svelte-y2vyyr"&&(J.innerHTML=Il),pe=a(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-16u6bcx"&&(Q.textContent=bl),ie=a(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1b0vo31"&&(_.innerHTML=fl),oe=a(s),w=i(s,"DIV",{style:!0,"data-svelte-h":!0}),o(w)!=="svelte-a4voxj"&&(w.innerHTML=Cl),Me=a(s),c(q.$$.fragment,s),ce=a(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-d6pll0"&&(X.innerHTML=Zl),ye=a(s),c(S.$$.fragment,s),re=a(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1oik75g"&&(Y.innerHTML=Bl),me=a(s),c(N.$$.fragment,s),de=a(s),c(z.$$.fragment,s),he=a(s),c(F.$$.fragment,s),je=a(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-h8bvlt"&&(x.innerHTML=Gl),ue=a(s),c($.$$.fragment,s),Je=a(s),L=i(s,"PRE",{"data-svelte-h":!0}),o(L)!=="svelte-1ge2cq1"&&(L.innerHTML=Wl),we=a(s),c(P.$$.fragment,s),Te=a(s),D=i(s,"PRE",{"data-svelte-h":!0}),o(D)!=="svelte-eapgg6"&&(D.textContent=Al),Ue=a(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-n71ylo"&&(K.textContent=El),ge=a(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1nmi541"&&(O.innerHTML=kl),Ie=a(s),c(ss.$$.fragment,s),be=a(s),es=i(s,"PRE",{"data-svelte-h":!0}),o(es)!=="svelte-ylq8xh"&&(es.textContent=Vl),fe=a(s),c(ls.$$.fragment,s),Ce=a(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-1tmrz4s"&&(ts.innerHTML=vl),Ze=a(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-z4qkh9"&&(ns.textContent=Rl),Be=a(s),c(as.$$.fragment,s),Ge=a(s),c(ps.$$.fragment,s),We=a(s),c(is.$$.fragment,s),Ae=a(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-qoiq95"&&(os.textContent=Hl),Ee=a(s),c(Ms.$$.fragment,s),ke=a(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-mbrgfm"&&(cs.textContent=Ql),Ve=a(s),c(ys.$$.fragment,s),ve=a(s),rs=i(s,"PRE",{"data-svelte-h":!0}),o(rs)!=="svelte-155ymre"&&(rs.textContent=_l),Re=a(s),c(ms.$$.fragment,s),He=a(s),ds=i(s,"PRE",{"data-svelte-h":!0}),o(ds)!=="svelte-1y8n5ov"&&(ds.textContent=ql),Qe=a(s),c(hs.$$.fragment,s),_e=a(s),js=i(s,"PRE",{"data-svelte-h":!0}),o(js)!=="svelte-1cx6d48"&&(js.textContent=Xl),qe=a(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1bjtv3s"&&(us.textContent=Sl),Xe=a(s),c(Js.$$.fragment,s),Se=a(s),c(ws.$$.fragment,s),Ye=a(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-io8nac"&&(Ts.innerHTML=Yl),Ne=a(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-81wpai"&&(Us.innerHTML=Nl),ze=a(s),c(gs.$$.fragment,s),Fe=a(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-18m2y9y"&&(Is.innerHTML=zl),xe=a(s),c(bs.$$.fragment,s),$e=a(s),T=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1ipmhb8"&&(T.innerHTML=Fl),Le=a(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-197qp1q"&&(fs.innerHTML=xl),Pe=a(s),c(Cs.$$.fragment,s),De=a(s),Zs=i(s,"PRE",{"data-svelte-h":!0}),o(Zs)!=="svelte-rvo07b"&&(Zs.textContent=$l),Ke=a(s),c(Bs.$$.fragment,s),Oe=a(s),Gs=i(s,"PRE",{"data-svelte-h":!0}),o(Gs)!=="svelte-vodlno"&&(Gs.textContent=Ll),sl=a(s),c(Ws.$$.fragment,s),el=a(s),c(As.$$.fragment,s),ll=a(s),Es=i(s,"UL",{"data-svelte-h":!0}),o(Es)!=="svelte-17e5lbs"&&(Es.innerHTML=Pl),tl=a(s),c(ks.$$.fragment,s),nl=a(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-1qat679"&&(Vs.textContent=Dl),al=a(s),vs=i(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-nwy2z9"&&(vs.innerHTML=Kl),pl=a(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-e8d7iw"&&(Rs.innerHTML=Ol),il=a(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1yipim9"&&(Hs.textContent=st),ol=a(s),c(Qs.$$.fragment,s),Ml=a(s),qs=i(s,"P",{}),et(qs).forEach(l),this.h()},h(){yl(u,"name","hf:doc:metadata"),yl(u,"content",dt),lt(J,"display","flex"),lt(J,"justify-content","center",1),yl(w,"style","flex justify-center"),yl(T,"class","tip")},m(s,e){Mt(document.head,u),t(s,Xs,e),t(s,_s,e),t(s,Ss,e),y(U,s,e),t(s,Ys,e),y(g,s,e),t(s,Ns,e),y(I,s,e),t(s,zs,e),t(s,b,e),t(s,Fs,e),t(s,f,e),t(s,xs,e),t(s,C,e),t(s,$s,e),t(s,Z,e),t(s,Ls,e),t(s,B,e),t(s,Ps,e),y(G,s,e),t(s,Ds,e),t(s,W,e),t(s,Ks,e),t(s,A,e),t(s,Os,e),y(E,s,e),t(s,se,e),y(k,s,e),t(s,ee,e),y(V,s,e),t(s,le,e),t(s,v,e),t(s,te,e),t(s,R,e),t(s,ne,e),t(s,H,e),t(s,ae,e),t(s,J,e),t(s,pe,e),t(s,Q,e),t(s,ie,e),t(s,_,e),t(s,oe,e),t(s,w,e),t(s,Me,e),y(q,s,e),t(s,ce,e),t(s,X,e),t(s,ye,e),y(S,s,e),t(s,re,e),t(s,Y,e),t(s,me,e),y(N,s,e),t(s,de,e),y(z,s,e),t(s,he,e),y(F,s,e),t(s,je,e),t(s,x,e),t(s,ue,e),y($,s,e),t(s,Je,e),t(s,L,e),t(s,we,e),y(P,s,e),t(s,Te,e),t(s,D,e),t(s,Ue,e),t(s,K,e),t(s,ge,e),t(s,O,e),t(s,Ie,e),y(ss,s,e),t(s,be,e),t(s,es,e),t(s,fe,e),y(ls,s,e),t(s,Ce,e),t(s,ts,e),t(s,Ze,e),t(s,ns,e),t(s,Be,e),y(as,s,e),t(s,Ge,e),y(ps,s,e),t(s,We,e),y(is,s,e),t(s,Ae,e),t(s,os,e),t(s,Ee,e),y(Ms,s,e),t(s,ke,e),t(s,cs,e),t(s,Ve,e),y(ys,s,e),t(s,ve,e),t(s,rs,e),t(s,Re,e),y(ms,s,e),t(s,He,e),t(s,ds,e),t(s,Qe,e),y(hs,s,e),t(s,_e,e),t(s,js,e),t(s,qe,e),t(s,us,e),t(s,Xe,e),y(Js,s,e),t(s,Se,e),y(ws,s,e),t(s,Ye,e),t(s,Ts,e),t(s,Ne,e),t(s,Us,e),t(s,ze,e),y(gs,s,e),t(s,Fe,e),t(s,Is,e),t(s,xe,e),y(bs,s,e),t(s,$e,e),t(s,T,e),t(s,Le,e),t(s,fs,e),t(s,Pe,e),y(Cs,s,e),t(s,De,e),t(s,Zs,e),t(s,Ke,e),y(Bs,s,e),t(s,Oe,e),t(s,Gs,e),t(s,sl,e),y(Ws,s,e),t(s,el,e),y(As,s,e),t(s,ll,e),t(s,Es,e),t(s,tl,e),y(ks,s,e),t(s,nl,e),t(s,Vs,e),t(s,al,e),t(s,vs,e),t(s,pl,e),t(s,Rs,e),t(s,il,e),t(s,Hs,e),t(s,ol,e),y(Qs,s,e),t(s,Ml,e),t(s,qs,e),cl=!0},p:nt,i(s){cl||(r(U.$$.fragment,s),r(g.$$.fragment,s),r(I.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(k.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(S.$$.fragment,s),r(N.$$.fragment,s),r(z.$$.fragment,s),r(F.$$.fragment,s),r($.$$.fragment,s),r(P.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(ys.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(Js.$$.fragment,s),r(ws.$$.fragment,s),r(gs.$$.fragment,s),r(bs.$$.fragment,s),r(Cs.$$.fragment,s),r(Bs.$$.fragment,s),r(Ws.$$.fragment,s),r(As.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),cl=!0)},o(s){m(U.$$.fragment,s),m(g.$$.fragment,s),m(I.$$.fragment,s),m(G.$$.fragment,s),m(E.$$.fragment,s),m(k.$$.fragment,s),m(V.$$.fragment,s),m(q.$$.fragment,s),m(S.$$.fragment,s),m(N.$$.fragment,s),m(z.$$.fragment,s),m(F.$$.fragment,s),m($.$$.fragment,s),m(P.$$.fragment,s),m(ss.$$.fragment,s),m(ls.$$.fragment,s),m(as.$$.fragment,s),m(ps.$$.fragment,s),m(is.$$.fragment,s),m(Ms.$$.fragment,s),m(ys.$$.fragment,s),m(ms.$$.fragment,s),m(hs.$$.fragment,s),m(Js.$$.fragment,s),m(ws.$$.fragment,s),m(gs.$$.fragment,s),m(bs.$$.fragment,s),m(Cs.$$.fragment,s),m(Bs.$$.fragment,s),m(Ws.$$.fragment,s),m(As.$$.fragment,s),m(ks.$$.fragment,s),m(Qs.$$.fragment,s),cl=!1},d(s){s&&(l(Xs),l(_s),l(Ss),l(Ys),l(Ns),l(zs),l(b),l(Fs),l(f),l(xs),l(C),l($s),l(Z),l(Ls),l(B),l(Ps),l(Ds),l(W),l(Ks),l(A),l(Os),l(se),l(ee),l(le),l(v),l(te),l(R),l(ne),l(H),l(ae),l(J),l(pe),l(Q),l(ie),l(_),l(oe),l(w),l(Me),l(ce),l(X),l(ye),l(re),l(Y),l(me),l(de),l(he),l(je),l(x),l(ue),l(Je),l(L),l(we),l(Te),l(D),l(Ue),l(K),l(ge),l(O),l(Ie),l(be),l(es),l(fe),l(Ce),l(ts),l(Ze),l(ns),l(Be),l(Ge),l(We),l(Ae),l(os),l(Ee),l(ke),l(cs),l(Ve),l(ve),l(rs),l(Re),l(He),l(ds),l(Qe),l(_e),l(js),l(qe),l(us),l(Xe),l(Se),l(Ye),l(Ts),l(Ne),l(Us),l(ze),l(Fe),l(Is),l(xe),l($e),l(T),l(Le),l(fs),l(Pe),l(De),l(Zs),l(Ke),l(Oe),l(Gs),l(sl),l(el),l(ll),l(Es),l(tl),l(nl),l(Vs),l(al),l(vs),l(pl),l(Rs),l(il),l(Hs),l(ol),l(Ml),l(qs)),l(u),d(U,s),d(g,s),d(I,s),d(G,s),d(E,s),d(k,s),d(V,s),d(q,s),d(S,s),d(N,s),d(z,s),d(F,s),d($,s),d(P,s),d(ss,s),d(ls,s),d(as,s),d(ps,s),d(is,s),d(Ms,s),d(ys,s),d(ms,s),d(hs,s),d(Js,s),d(ws,s),d(gs,s),d(bs,s),d(Cs,s),d(Bs,s),d(Ws,s),d(As,s),d(ks,s),d(Qs,s)}}}const dt='{"title":"Inference Endpoints (dedicated)","local":"inference-endpoints-dedicated","sections":[{"title":"Install and login","local":"install-and-login","sections":[],"depth":2},{"title":"Creating your first Endpoint","local":"creating-your-first-endpoint","sections":[{"title":"Creating and managing Endpoints programmatically","local":"creating-and-managing-endpoints-programmatically","sections":[],"depth":3}],"depth":2},{"title":"Querying your Endpoint","local":"querying-your-endpoint","sections":[{"title":"Simplified Endpoint usage with the InferenceClient","local":"simplified-endpoint-usage-with-the-inferenceclient","sections":[],"depth":3}],"depth":2},{"title":"Creating Endpoints for a wide variety of models","local":"creating-endpoints-for-a-wide-variety-of-models","sections":[{"title":"Image generation with Stable Diffusion","local":"image-generation-with-stable-diffusion","sections":[],"depth":3},{"title":"Vision Language Models: Reasoning over text and images","local":"vision-language-models-reasoning-over-text-and-images","sections":[],"depth":3}],"depth":2},{"title":"Additional information","local":"additional-information","sections":[],"depth":2},{"title":"Conclusion and next steps","local":"conclusion-and-next-steps","sections":[],"depth":2}],"depth":1}';function ht(rl){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ut extends pt{constructor(u){super(),it(this,u,ht,mt,tt,{})}}export{Ut as component};
